/*
 * Decompiled with CFR 0.152.
 */
package java2d.demos.Mix;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import java2d.ControlsSurface;
import java2d.CustomControls;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class Stars3D
extends ControlsSurface {
    private static Color[] colors = new Color[]{Color.RED, Color.GREEN, Color.WHITE};
    private static AffineTransform at = AffineTransform.getTranslateInstance(-5.0, -5.0);
    private Shape shape;
    private Shape tshape;
    private Shape ribbon;
    protected int fontSize = 72;
    protected String text = "OpenJDK";
    protected int numStars = 300;

    public Stars3D() {
        this.setBackground(Color.BLACK);
        this.setControls(new Component[]{new DemoControls(this)});
    }

    @Override
    public void render(int w, int h, Graphics2D g2) {
        Rectangle2D.Double rect = new Rectangle2D.Double();
        for (int i = 0; i < this.numStars; ++i) {
            g2.setColor(colors[i % 3]);
            g2.setComposite(AlphaComposite.getInstance(3, (float)Math.random()));
            ((Rectangle2D)rect).setRect((double)w * Math.random(), (double)h * Math.random(), 2.0, 2.0);
            g2.fill(rect);
        }
        FontRenderContext frc = g2.getFontRenderContext();
        Font font = new Font("Serif", 3, this.fontSize);
        this.shape = font.createGlyphVector(frc, this.text).getOutline();
        this.tshape = at.createTransformedShape(this.shape);
        PathIterator pi = this.shape.getPathIterator(null);
        float[] seg = new float[6];
        float[] tseg = new float[6];
        GeneralPath working = new GeneralPath(1);
        float x = 0.0f;
        float y = 0.0f;
        float tx = 0.0f;
        float ty = 0.0f;
        float cx = 0.0f;
        float cy = 0.0f;
        float tcx = 0.0f;
        float tcy = 0.0f;
        while (!pi.isDone()) {
            int segType = pi.currentSegment(seg);
            switch (segType) {
                case 0: {
                    at.transform(seg, 0, tseg, 0, 1);
                    x = seg[0];
                    y = seg[1];
                    tx = tseg[0];
                    ty = tseg[1];
                    cx = x;
                    cy = y;
                    tcx = tx;
                    tcy = ty;
                    break;
                }
                case 1: {
                    at.transform(seg, 0, tseg, 0, 1);
                    if (Line2D.relativeCCW(x, y, tx, ty, seg[0], seg[1]) < 0) {
                        working.moveTo(x, y);
                        working.lineTo(seg[0], seg[1]);
                        working.lineTo(tseg[0], tseg[1]);
                        working.lineTo(tx, ty);
                        working.lineTo(x, y);
                    } else {
                        working.moveTo(x, y);
                        working.lineTo(tx, ty);
                        working.lineTo(tseg[0], tseg[1]);
                        working.lineTo(seg[0], seg[1]);
                        working.lineTo(x, y);
                    }
                    x = seg[0];
                    y = seg[1];
                    tx = tseg[0];
                    ty = tseg[1];
                    break;
                }
                case 2: {
                    at.transform(seg, 0, tseg, 0, 2);
                    if (Line2D.relativeCCW(x, y, tx, ty, seg[2], seg[3]) < 0) {
                        working.moveTo(x, y);
                        working.quadTo(seg[0], seg[1], seg[2], seg[3]);
                        working.lineTo(tseg[2], tseg[3]);
                        working.quadTo(tseg[0], tseg[1], tx, ty);
                        working.lineTo(x, y);
                    } else {
                        working.moveTo(x, y);
                        working.lineTo(tx, ty);
                        working.quadTo(tseg[0], tseg[1], tseg[2], tseg[3]);
                        working.lineTo(seg[2], seg[3]);
                        working.quadTo(seg[0], seg[1], x, y);
                    }
                    x = seg[2];
                    y = seg[3];
                    tx = tseg[2];
                    ty = tseg[3];
                    break;
                }
                case 3: {
                    at.transform(seg, 0, tseg, 0, 3);
                    if (Line2D.relativeCCW(x, y, tx, ty, seg[4], seg[5]) < 0) {
                        working.moveTo(x, y);
                        working.curveTo(seg[0], seg[1], seg[2], seg[3], seg[4], seg[5]);
                        working.lineTo(tseg[4], tseg[5]);
                        working.curveTo(tseg[2], tseg[3], tseg[0], tseg[1], tx, ty);
                        working.lineTo(x, y);
                    } else {
                        working.moveTo(x, y);
                        working.lineTo(tx, ty);
                        working.curveTo(tseg[0], tseg[1], tseg[2], tseg[3], tseg[4], tseg[5]);
                        working.lineTo(seg[4], seg[5]);
                        working.curveTo(seg[2], seg[3], seg[0], seg[1], x, y);
                    }
                    x = seg[4];
                    y = seg[5];
                    tx = tseg[4];
                    ty = tseg[5];
                    break;
                }
                case 4: {
                    if (Line2D.relativeCCW(x, y, tx, ty, cx, cy) < 0) {
                        working.moveTo(x, y);
                        working.lineTo(cx, cy);
                        working.lineTo(tcx, tcy);
                        working.lineTo(tx, ty);
                        working.lineTo(x, y);
                    } else {
                        working.moveTo(x, y);
                        working.lineTo(tx, ty);
                        working.lineTo(tcx, tcy);
                        working.lineTo(cx, cy);
                        working.lineTo(x, y);
                    }
                    x = cx;
                    y = cy;
                    tx = tcx;
                    ty = tcy;
                }
            }
            pi.next();
        }
        this.ribbon = working;
        if (this.composite != null) {
            g2.setComposite(this.composite);
        } else {
            g2.setComposite(AlphaComposite.SrcOver);
        }
        Rectangle r = this.shape.getBounds();
        g2.translate((double)w * 0.5 - (double)r.width * 0.5, (double)h * 0.5 + (double)r.height * 0.5);
        g2.setColor(Color.BLUE);
        g2.fill(this.tshape);
        g2.setColor(new Color(255, 255, 255, 200));
        g2.fill(this.ribbon);
        g2.setColor(Color.WHITE);
        g2.fill(this.shape);
        g2.setColor(Color.BLUE);
        g2.draw(this.shape);
    }

    public static void main(String[] argv) {
        Stars3D.createDemoFrame(new Stars3D());
    }

    static class DemoControls
    extends CustomControls
    implements ActionListener {
        Stars3D demo;
        JTextField tf1;
        JTextField tf2;

        public DemoControls(Stars3D demo) {
            super(demo.name);
            this.demo = demo;
            JLabel l = new JLabel("  Text:");
            l.setForeground(Color.BLACK);
            this.add(l);
            this.tf1 = new JTextField(demo.text);
            this.add(this.tf1);
            this.tf1.setPreferredSize(new Dimension(60, 20));
            this.tf1.addActionListener(this);
            l = new JLabel("  Size:");
            l.setForeground(Color.BLACK);
            this.add(l);
            this.tf2 = new JTextField(String.valueOf(demo.fontSize));
            this.add(this.tf2);
            this.tf2.setPreferredSize(new Dimension(30, 20));
            this.tf2.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                if (e.getSource().equals(this.tf1)) {
                    this.demo.text = this.tf1.getText().trim();
                } else if (e.getSource().equals(this.tf2)) {
                    this.demo.fontSize = Integer.parseInt(this.tf2.getText().trim());
                    if (this.demo.fontSize < 10) {
                        this.demo.fontSize = 10;
                    }
                }
                this.demo.repaint();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(200, 37);
        }

        @Override
        public void run() {
            Thread me = Thread.currentThread();
            try {
                Thread.sleep(999L);
            }
            catch (Exception e) {
                return;
            }
            int length = this.getSize().width / 4;
            int[] size = new int[]{length, length};
            String[] str = new String[]{"OpenJDK", "J2D"};
            while (this.thread == me) {
                for (int i = 0; i < str.length; ++i) {
                    this.demo.fontSize = size[i];
                    this.tf2.setText(String.valueOf(this.demo.fontSize));
                    this.demo.text = str[i];
                    this.tf1.setText(this.demo.text);
                    this.demo.repaint();
                    try {
                        Thread.sleep(5555L);
                        continue;
                    }
                    catch (InterruptedException e) {
                        return;
                    }
                }
            }
            this.thread = null;
        }
    }
}

