/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.scriptext;

import java.util.Hashtable;
import java.util.Map;
import javajs.api.JSONEncodable;
import javajs.util.AU;
import javajs.util.BArray;
import javajs.util.BS;
import javajs.util.Base64;
import javajs.util.Lst;
import javajs.util.M3;
import javajs.util.M4;
import javajs.util.Measure;
import javajs.util.P3;
import javajs.util.P4;
import javajs.util.PT;
import javajs.util.Quat;
import javajs.util.SB;
import javajs.util.T3;
import javajs.util.V3;
import org.jmol.api.Interface;
import org.jmol.api.SymmetryInterface;
import org.jmol.atomdata.RadiusData;
import org.jmol.c.STER;
import org.jmol.c.VDW;
import org.jmol.i18n.GT;
import org.jmol.minimize.Minimizer;
import org.jmol.modelkit.ModelKit;
import org.jmol.modelset.Atom;
import org.jmol.modelset.AtomCollection;
import org.jmol.modelset.Bond;
import org.jmol.modelset.BondSet;
import org.jmol.modelset.LabelToken;
import org.jmol.modelset.Measurement;
import org.jmol.modelset.ModelSet;
import org.jmol.modelset.StateScript;
import org.jmol.modelset.Text;
import org.jmol.modelset.TickInfo;
import org.jmol.script.SV;
import org.jmol.script.ScriptCompiler;
import org.jmol.script.ScriptContext;
import org.jmol.script.ScriptError;
import org.jmol.script.ScriptEval;
import org.jmol.script.ScriptException;
import org.jmol.script.ScriptInterruption;
import org.jmol.script.ScriptMathProcessor;
import org.jmol.script.ScriptParam;
import org.jmol.script.T;
import org.jmol.scriptext.ScriptExt;
import org.jmol.shape.Measures;
import org.jmol.util.BSUtil;
import org.jmol.util.BZone;
import org.jmol.util.BoxInfo;
import org.jmol.util.C;
import org.jmol.util.Edge;
import org.jmol.util.Elements;
import org.jmol.util.Escape;
import org.jmol.util.Font;
import org.jmol.util.Logger;
import org.jmol.util.Node;
import org.jmol.util.Parser;
import org.jmol.util.Point3fi;
import org.jmol.util.SimpleUnitCell;
import org.jmol.viewer.FileManager;
import org.jmol.viewer.JC;
import org.jmol.viewer.ShapeManager;
import org.jmol.viewer.StateManager;
import org.jmol.viewer.Viewer;

public class CmdExt
extends ScriptExt {
    static final int ERROR_invalidArgument = 22;
    private static LabelToken labeler;

    @Override
    public String dispatch(int iTok, boolean flag, T[] st) throws ScriptException {
        this.chk = this.e.chk;
        this.slen = this.e.slen;
        this.st = st;
        switch (iTok) {
            case 4108: {
                this.audio();
                break;
            }
            case 1073741866: {
                st[0].value = this.prepareBinaryOutput((SV)st[0]);
                return null;
            }
            case 4098: {
                this.assign(false);
                break;
            }
            case 134221829: {
                this.cache();
                break;
            }
            case 4102: {
                this.calculate();
                break;
            }
            case 4103: {
                this.capture();
                break;
            }
            case 4105: {
                this.centerAt();
                break;
            }
            case 134221831: {
                this.compare();
                break;
            }
            case 528395: {
                this.console();
                break;
            }
            case 4106: {
                this.connect(1);
                break;
            }
            case 1094717448: {
                this.configuration();
                break;
            }
            case 134221834: {
                this.data();
                break;
            }
            case 1613238294: {
                this.connect(0);
                break;
            }
            case 4120: {
                this.image();
                break;
            }
            case 4122: {
                this.invertSelected();
                break;
            }
            case 4124: {
                this.macro();
                break;
            }
            case 4125: {
                this.mapProperty();
                break;
            }
            case 4126: {
                this.minimize(false);
                break;
            }
            case 603983903: {
                this.modelkit();
                break;
            }
            case 1275072532: {
                this.modulation();
                break;
            }
            case 4130: {
                this.mutate();
                break;
            }
            case 4131: {
                this.navigate();
                break;
            }
            case 4133: 
            case 4138: 
            case 134221850: {
                this.plot(st);
                break;
            }
            case 134222350: {
                this.show();
                break;
            }
            case 528443: {
                this.stereo();
                break;
            }
            case 1814695966: {
                this.unitcell(flag ? 2 : 1, false);
                break;
            }
            case 134221856: {
                return this.write((T[])(flag ? st : null));
            }
            case 6: {
                this.measure();
                break;
            }
            case 21: {
                this.polyhedra();
                break;
            }
            case 20: {
                this.ellipsoid();
                break;
            }
            case 4: {
                this.struts();
            }
        }
        return null;
    }

    private void audio() throws ScriptException {
        Hashtable<String, Object> htParams = new Hashtable<String, Object>();
        String id = null;
        String filter = null;
        String filename = null;
        int i = this.e.iToken + 1;
        if (this.tokAt(i) == 1073742334) {
            this.checkLength(i + 1);
            if (!this.chk) {
                this.vwr.sm.stopAudio(null);
            }
            return;
        }
        while (i < this.slen) {
            switch (this.tokAt(i)) {
                case 1073741974: {
                    if (id != null) {
                        this.invArg();
                    }
                    id = this.paramAsStr(++i);
                    break;
                }
                case 4: {
                    filename = this.stringParameter(i);
                    htParams.put("audioFile", filename);
                    break;
                }
                case 0x40000074: {
                    filter = this.stringParameter(++i);
                    id = this.addFilterAttribute(htParams, filter, "id");
                    this.addFilterAttribute(htParams, filter, "loop");
                    this.addFilterAttribute(htParams, filter, "start");
                    this.addFilterAttribute(htParams, filter, "pause");
                    this.addFilterAttribute(htParams, filter, "play");
                    this.addFilterAttribute(htParams, filter, "ended");
                    this.addFilterAttribute(htParams, filter, "action");
                    break;
                }
                default: {
                    this.checkLength(i + 1);
                    if (htParams.containsKey("action")) {
                        this.invArg();
                    }
                    String action = this.paramAsStr(i);
                    htParams.put("autoclose", Boolean.FALSE);
                    htParams.put("action", action);
                }
            }
            ++i;
        }
        if (!this.chk && !htParams.isEmpty()) {
            if (id == null) {
                id = "audio1";
            }
            htParams.put("id", id);
            this.vwr.sm.playAudio(htParams);
        }
    }

    private String addFilterAttribute(Map<String, Object> htParams, String filter, String key) {
        String val = PT.getQuotedOrUnquotedAttribute(filter, key);
        if (val != null && val.length() > 0) {
            htParams.put(key, val);
        }
        return val;
    }

    private void macro() throws ScriptException {
        if (this.chk) {
            return;
        }
        String key = this.e.optParameterAsString(1);
        if (key.length() == 0) {
            this.showString(this.vwr.getMacro(null));
            return;
        }
        String macro = this.vwr.getMacro(key);
        if (macro == null) {
            this.showString("macro " + key + " could not be found. Current macros include:\n" + this.vwr.getMacro(null));
            return;
        }
        this.showString("running " + macro);
        this.e.cmdScript(4124, macro, null, null);
    }

    public boolean evalParallel(ScriptContext context, ShapeManager shapeManager) {
        this.chk = this.e.chk;
        this.slen = this.e.slen;
        ScriptEval se = new ScriptEval().setViewer(this.vwr);
        se.historyDisabled = true;
        se.compiler = new ScriptCompiler(this.vwr);
        se.sm = shapeManager;
        try {
            se.restoreScriptContext(context, true, false, false);
            se.setAllowJSThreads(false);
            se.dispatchCommands(false, false, false);
        }
        catch (Exception ex) {
            this.e.vwr.setStringProperty("_errormessage", "" + ex);
            if (se.thisContext == null) {
                Logger.error("Error evaluating context " + ex);
                ex.printStackTrace();
            }
            return false;
        }
        return true;
    }

    public Object getBitsetIdent(BS bs, String label, Object tokenValue, boolean useAtomMap, int index, boolean isExplicitlyAll) {
        return this.getBitsetIdentFull(bs, label, useAtomMap, index, isExplicitlyAll, null);
    }

    public Object getBitsetIdentFull(BS bs, String label, boolean useAtomMap, int index, boolean isExplicitlyAll, String[] sout) {
        int j;
        boolean haveSout;
        Map<String, Object> htValues;
        boolean haveIndex;
        boolean isAtoms;
        boolean bl = isAtoms = !(bs instanceof BondSet);
        if (isAtoms) {
            if (label == null) {
                label = this.vwr.getStandardLabelFormat(0);
            } else if (label.length() == 0) {
                label = "%[label]";
            }
        } else if (label != null && label.length() == 0) {
            label = "[%a1 #%i1] %4.3LENGTH [%a2 #%i2] #%#";
        } else if ("%U".equals(label)) {
            label = "";
        }
        int pt = label == null ? -1 : label.indexOf("%");
        boolean bl2 = haveIndex = index != Integer.MAX_VALUE;
        if (bs == null || this.chk || isAtoms && pt < 0) {
            String[] stringArray;
            if (label == null) {
                label = "";
            }
            if (isExplicitlyAll) {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = label;
            } else {
                stringArray = label;
            }
            return stringArray;
        }
        ModelSet modelSet = this.vwr.ms;
        int n = 0;
        if (labeler == null) {
            labeler = modelSet.getLabeler();
        }
        int[] indices = isAtoms || !useAtomMap ? null : ((BondSet)bs).getAssociatedAtoms(modelSet);
        boolean asIdentity = label == null || label.length() == 0;
        Map<String, Object> map = htValues = isAtoms || asIdentity ? null : labeler.getBondLabelValues();
        LabelToken[] tokens = asIdentity ? null : (isAtoms ? LabelToken.compile(this.vwr, (String)label, '\u0000', null) : LabelToken.compile(this.vwr, (String)label, '\u0001', htValues));
        int nmax = haveIndex ? 1 : bs.cardinality();
        boolean bl3 = haveSout = sout != null;
        if (!haveSout) {
            sout = new String[nmax];
        }
        P3 ptTemp = new P3();
        int n2 = j = haveIndex ? index : bs.nextSetBit(0);
        while (j >= 0) {
            block21: {
                String str;
                block20: {
                    block19: {
                        if (!isAtoms) break block19;
                        str = asIdentity ? modelSet.at[j].getInfo() : LabelToken.formatLabelAtomArray(this.vwr, modelSet.at[j], tokens, '\u0000', indices, ptTemp);
                        break block20;
                    }
                    Bond bond = modelSet.bo[j];
                    if (bond == null) break block21;
                    str = asIdentity ? bond.getIdentity() : LabelToken.formatLabelBond(this.vwr, bond, tokens, htValues, indices, ptTemp);
                }
                str = PT.formatStringI(str, "#", n + 1);
                sout[haveSout ? j : n] = str;
                ++n;
                if (haveIndex) break;
            }
            j = bs.nextSetBit(j + 1);
        }
        return nmax == 1 && !isExplicitlyAll ? sout[0] : sout;
    }

    public int getLoadSymmetryParams(int i, SB sOptions, Map<String, Object> htParams) throws ScriptException {
        ScriptEval eval = this.e;
        this.chk = eval.chk;
        this.slen = eval.slen;
        boolean isEmptyLoad = false;
        T3 lattice = null;
        int tok = this.tokAt(i);
        if (tok == 1073742332 || tok == 8) {
            lattice = eval.getFractionalPoint(i);
            i = eval.iToken + 1;
            tok = this.tokAt(i);
        }
        switch (tok) {
            case 134217764: {
                isEmptyLoad = htParams.get("isEmptyLoad") == Boolean.TRUE;
            }
            case 1073741938: 
            case 0x40000100: 
            case 1073742114: 
            case 1073742163: 
            case 1094713350: 
            case 1814695966: {
                if (lattice == null) {
                    lattice = P3.new3(555.0f, 555.0f, -1.0f);
                }
                eval.iToken = i - 1;
            }
        }
        T3 offset = null;
        if (lattice != null) {
            SymmetryInterface sg;
            htParams.put("lattice", lattice);
            i = eval.iToken + 1;
            sOptions.append(" " + SimpleUnitCell.escapeMultiplier(lattice));
            i = this.checkPacked(i, 0, htParams, sOptions);
            if (this.tokAt(i) == 1094713350) {
                htParams.put("centroid", Boolean.TRUE);
                sOptions.append(" CENTROID");
                int ptok = 0;
                if (this.isFloatParameter(i + 1)) {
                    --i;
                    ptok = 0x40000100;
                }
                ++i;
                i = this.checkPacked(i, ptok, htParams, sOptions);
            }
            if (this.tokAt(i) == 1073742163) {
                Object supercell;
                sOptions.append(" SUPERCELL ");
                if (eval.isPoint3f(++i)) {
                    P3 pt = this.getPoint3f(i, false);
                    if (pt.x != (float)((int)pt.x) || pt.y != (float)((int)pt.y) || pt.z != (float)((int)pt.z) || pt.x < 1.0f || pt.y < 1.0f || pt.z < 1.0f) {
                        eval.iToken = i;
                        this.invArg();
                    }
                    supercell = pt;
                    i = eval.iToken;
                } else {
                    supercell = this.stringParameter(i);
                }
                sOptions.append(Escape.e(supercell));
                htParams.put("supercell", supercell);
                ++i;
                i = this.checkPacked(i, 0, htParams, sOptions);
            }
            float distance = 0.0f;
            if (this.tokAt(i) == 1073742114) {
                int n = ++i;
                ++i;
                distance = this.floatParameter(n);
                sOptions.append(" range " + distance);
            }
            htParams.put("symmetryRange", Float.valueOf(distance));
            String spacegroup = null;
            int iGroup = Integer.MIN_VALUE;
            if (this.tokAt(i) == 134217764) {
                int n = ++i;
                ++i;
                spacegroup = PT.rep(this.paramAsStr(n), "''", "\"");
                sOptions.append(" spacegroup " + PT.esc(spacegroup));
                if (spacegroup.equalsIgnoreCase("ignoreOperators")) {
                    iGroup = -999;
                } else {
                    if (spacegroup.length() == 0) {
                        sg = this.vwr.getCurrentUnitCell();
                        if (sg != null) {
                            spacegroup = sg.getSpaceGroupName();
                        }
                    } else if (spacegroup.indexOf(",") >= 0 && lattice.x < 9.0f && lattice.y < 9.0f && lattice.z == 0.0f) {
                        spacegroup = spacegroup + "#doNormalize=0";
                    }
                    htParams.put("spaceGroupName", spacegroup);
                    iGroup = -2;
                }
            }
            float[] fparams = null;
            if (this.tokAt(i) == 1814695966) {
                String s;
                if ((s = eval.optParameterAsString(++i)).length() == 0) {
                    sg = this.vwr.getCurrentUnitCell();
                    if (sg != null) {
                        fparams = sg.getUnitCellAsArray(true);
                        offset = sg.getCartesianOffset();
                    }
                } else if (this.tokAt(i) == 4) {
                    fparams = new float[6];
                    SimpleUnitCell.setAbc(s, fparams, null);
                } else {
                    fparams = eval.floatParameterSet(i, 6, 9);
                }
                if (fparams == null || fparams.length != 6 && fparams.length != 9) {
                    this.invArg();
                }
                sOptions.append(" unitcell [");
                for (int j = 0; j < fparams.length; ++j) {
                    sOptions.append((j == 0 ? "" : " ") + fparams[j]);
                }
                sOptions.append("]");
                htParams.put("unitcell", fparams);
                if (iGroup == Integer.MIN_VALUE) {
                    iGroup = -1;
                }
                i = eval.iToken + 1;
            }
            if (iGroup != Integer.MIN_VALUE) {
                htParams.put("spaceGroupIndex", iGroup);
            }
            if (!isEmptyLoad || fparams != null || spacegroup == null || (iGroup = PT.parseInt(spacegroup)) != Integer.MIN_VALUE) {
                // empty if block
            }
        }
        boolean areFractional = false;
        if (offset == null && this.tokAt(i) == 1073742066) {
            offset = this.getPoint3f(++i, true);
            areFractional = eval.coordinatesAreFractional;
        }
        if (offset != null) {
            if (areFractional) {
                offset.setT(eval.fractionalPoint);
                htParams.put("unitCellOffsetFractional", areFractional ? Boolean.TRUE : Boolean.FALSE);
                sOptions.append(" offset {" + ((P3)offset).x + " " + ((P3)offset).y + " " + ((P3)offset).z + "/1}");
            } else {
                sOptions.append(" offset " + Escape.eP(offset));
            }
            htParams.put("unitCellOffset", offset);
            i = eval.iToken + 1;
        }
        return i;
    }

    /*
     * Unable to fully structure code
     */
    private int checkPacked(int i, int tok, Map<String, Object> htParams, SB sOptions) throws ScriptException {
        if (tok == 0) {
            tok = this.tokAt(i);
        }
        switch (tok) {
            case 1073741938: {
                htParams.put("packed", Boolean.TRUE);
                oabc = null;
                tok = this.tokAt(++i);
                switch (tok) {
                    case 4: 
                    case 1812599299: 
                    case 1814695966: {
                        break;
                    }
                    default: {
                        if (this.e.isArrayParameter(i)) {
                            oabc = this.e.getPointArray(i, -1, false);
                            i = this.e.iToken;
                            break;
                        }
                        if (this.isFloatParameter(i)) {
                            d = this.floatParameter(i);
                            oabc = new P3[]{new P3(), P3.new3(d, d, d)};
                            break;
                        }
                        oabc = new P3[]{};
                        --i;
                    }
                }
                ++i;
                if (this.e.chk) {
                    return i;
                }
                switch (tok) {
                    ** case 4:
lbl28:
                    // 2 sources

                    case 1814695966: {
                        v0 = --i;
                        ++i;
                        type = this.e.optParameterAsString(v0).toLowerCase();
                        if (PT.isOneOf(type, ";conventional;primitive;rhombohedral;trigonal;") || type.indexOf(",") >= 0 && type.indexOf("a") >= 0 && type.indexOf("b") >= 0 && type.indexOf("c") >= 0) {
                            htParams.put("fillRange", type);
                            sOptions.append(" FILL UNITCELL \"" + type + "\"");
                            return i;
                        }
                        unitCell = this.vwr.getCurrentUnitCell();
                        if (unitCell != null) {
                            oabc = BoxInfo.toOABC(unitCell.getUnitCellVerticesNoOffset(), unitCell.getCartesianOffset());
                            break;
                        }
                    }
                    case 1812599299: {
                        oabc = BoxInfo.toOABC(this.vwr.ms.getBBoxVertices(), null);
                    }
                }
                switch (oabc.length) {
                    case 2: {
                        a = oabc[1];
                        oabc = new T3[]{oabc[0], P3.newP(oabc[0]), new P3(), new P3()};
                        oabc[1].x = a.x;
                        oabc[2].y = a.y;
                        oabc[3].z = a.z;
                        break;
                    }
                    case 3: {
                        oabc = new T3[]{new P3(), oabc[0], oabc[1], oabc[2]};
                        break;
                    }
                    case 4: {
                        break;
                    }
                    default: {
                        oabc = new T3[]{new P3(), P3.new3(10.0f, 0.0f, 0.0f), P3.new3(0.0f, 10.0f, 0.0f), P3.new3(0.0f, 0.0f, 10.0f)};
                    }
                }
                htParams.put("fillRange", oabc);
                sOptions.append(" FILL [" + oabc[0] + oabc[1] + oabc[2] + oabc[3] + "]");
                break;
            }
            case 0x40000100: {
                f = NaNf;
                if (this.isFloatParameter(++i)) {
                    f = this.floatParameter(i++);
                }
                if (this.e.chk) break;
                htParams.put("packed", Boolean.TRUE);
                sOptions.append(" PACKED");
                if (Float.isNaN(f)) break;
                htParams.put("packingRange", Float.valueOf(f));
                sOptions.append(" " + f);
            }
        }
        return i;
    }

    private void cache() throws ScriptException {
        int tok = this.tokAt(1);
        String fileName = null;
        int n = 2;
        switch (tok) {
            case 1073742119: 
            case 1275069441: {
                fileName = this.e.optParameterAsString(n++);
            }
            case 1073741882: {
                int nBytes;
                this.checkLength(n);
                if (this.chk) break;
                if ("all".equals(fileName)) {
                    fileName = null;
                }
                this.showString((nBytes = this.vwr.cacheFileByName(fileName, tok == 1275069441)) < 0 ? "cache cleared" : nBytes + " bytes " + (tok == 1275069441 ? " cached" : " removed"));
                break;
            }
            default: {
                this.invArg();
            }
        }
    }

    private void calculate() throws ScriptException {
        boolean isSurface = false;
        boolean asDSSP = false;
        BS bs1 = null;
        BS bs2 = null;
        ScriptEval e = this.e;
        int n = Integer.MIN_VALUE;
        int version = -1;
        e.iToken = e.slen;
        if (e.iToken >= 2) {
            e.clearDefinedVariableAtomSets();
            switch (this.getToken((int)1).tok) {
                case 2: {
                    if (this.intParameter(1) != 3 || !this.paramAsStr(2).equalsIgnoreCase("D")) break;
                    if (this.vwr.am.cmi < 0) {
                        e.errorStr(30, "calculate 3D");
                    }
                    String cmd = "load append $ filter '2D';select visible;center selected";
                    if (e.optParameterAsString(3).equalsIgnoreCase("ZAP")) {
                        cmd = cmd + ";zap modelIndex=" + Math.max(this.vwr.am.cmi, 0);
                    }
                    if (!this.chk) {
                        e.runScript(cmd);
                    }
                    return;
                }
                case 0x40000000: {
                    this.checkLength(2);
                    break;
                }
                case 134217764: {
                    e.iToken = 1;
                    bs1 = this.slen == 2 ? null : this.atomExpressionAt(2);
                    e.checkLast(e.iToken);
                    if (!this.chk) {
                        e.showString("" + this.vwr.findSpaceGroup(null, bs1, null, null, null, null, 1));
                    }
                    return;
                }
                case 1086324752: {
                    e.iToken = 1;
                    bs1 = this.slen == 2 ? null : this.atomExpressionAt(2);
                    e.checkLast(e.iToken);
                    if (!this.chk) {
                        e.showString(this.vwr.calculateChirality(bs1));
                    }
                    return;
                }
                case 1631586315: {
                    this.checkLength(2);
                    if (this.chk) {
                        return;
                    }
                    n = this.vwr.calculateFormalCharges(null);
                    this.showString(GT.i(GT.$("{0} charges modified"), n));
                    return;
                }
                case 1075838996: {
                    this.checkLength(2);
                    if (!this.chk) {
                        this.vwr.ms.assignAromaticBondsBs(true, null);
                    }
                    return;
                }
                case 1613238294: {
                    if (e.slen != 2) {
                        asDSSP = this.tokAt(++e.iToken) == 1639976963;
                        bs1 = asDSSP ? this.vwr.bsA() : this.atomExpressionAt(e.iToken);
                        if (!asDSSP && !(asDSSP = this.tokAt(++e.iToken) == 1639976963)) {
                            bs2 = this.atomExpressionAt(e.iToken);
                        }
                    }
                    if (this.chk) {
                        return;
                    }
                    n = this.vwr.autoHbond(bs1, bs2, false);
                    if (n != Integer.MIN_VALUE) {
                        e.report(GT.i(GT.$("{0} hydrogen bonds"), Math.abs(n)), false);
                    }
                    return;
                }
                case 1612709900: {
                    boolean andBond;
                    int itok = this.tokAt(2);
                    boolean bl = andBond = itok == 1073742335;
                    if (andBond) {
                        ++e.iToken;
                    } else if (itok == 528443) {
                        ++e.iToken;
                    }
                    BS bS = bs1 = this.slen == e.iToken + 1 ? null : this.atomExpressionAt(e.iToken + 1);
                    if (bs1 == null && itok == 528443) {
                        bs1 = this.vwr.getAtomBitSet("_C & connected(3) & !connected(double)");
                    }
                    e.checkLast(e.iToken);
                    if (!this.chk) {
                        this.vwr.addHydrogens(bs1, 0);
                        if (andBond) {
                            if (bs1 == null) {
                                bs1 = this.vwr.bsA();
                            }
                            this.vwr.makeConnections(0.1f, 1.0E8f, 515, 1073742025, bs1, bs1, null, false, false, 0.0f);
                            this.vwr.ms.assignAromaticBondsBs(true, null);
                        }
                    }
                    return;
                }
                case 1111492619: {
                    e.iToken = 1;
                    bs1 = this.slen == 2 ? null : this.atomExpressionAt(2);
                    e.checkLast(e.iToken);
                    if (!this.chk) {
                        e.getPartialCharges(bs1);
                    }
                    return;
                }
                case 1088421903: 
                case 1275068447: {
                    if (!this.chk) {
                        if (this.tokAt(2) == 1275203608) {
                            String id = this.tokAt(3) == 4 ? this.stringParameter(3) : null;
                            bs1 = id != null || this.slen == 3 ? null : this.atomExpressionAt(3);
                            Object[] data = new Object[]{id, null, bs1};
                            this.showString(e.getShapePropertyData(21, "symmetry", data) ? (String)data[1] : "");
                        } else {
                            bs1 = this.slen == 2 ? this.vwr.bsA() : this.atomExpressionAt(2);
                            this.showString(this.vwr.ms.calculatePointGroup(bs1));
                        }
                    }
                    return;
                }
                case 1111490574: {
                    this.checkLength(2);
                    if (!this.chk) {
                        this.vwr.calculateStraightness();
                        this.vwr.addStateScript("set quaternionFrame '" + this.vwr.getQuaternionFrame() + "'; calculate straightness", false, true);
                    }
                    return;
                }
                case 1639976963: {
                    bs1 = this.slen < 4 || this.isFloatParameter(3) ? null : this.atomExpressionAt(2);
                    switch (this.tokAt(++e.iToken)) {
                        case 4138: {
                            break;
                        }
                        case 1111490587: {
                            if (this.chk) {
                                return;
                            }
                            e.showString(this.vwr.getAnnotationParser(true).calculateDSSRStructure(this.vwr, bs1));
                            return;
                        }
                        case 1073741915: {
                            asDSSP = true;
                            version = this.slen == e.iToken + 1 ? -1 : (int)this.floatParameter(++e.iToken);
                            break;
                        }
                        case 0: {
                            asDSSP = this.vwr.getBoolean(603979826);
                            break;
                        }
                        default: {
                            this.invArg();
                        }
                    }
                    if (!this.chk) {
                        this.showString(this.vwr.calculateStructures(bs1, asDSSP, true, version));
                    }
                    return;
                }
                case 659482: {
                    bs1 = e.iToken + 1 < this.slen ? this.atomExpressionAt(++e.iToken) : null;
                    bs2 = e.iToken + 1 < this.slen ? this.atomExpressionAt(++e.iToken) : null;
                    this.checkLength(++e.iToken);
                    if (!this.chk) {
                        n = this.vwr.calculateStruts(bs1, bs2);
                        if (n > 0) {
                            this.setShapeProperty(1, "type", 32768);
                            e.setShapePropertyBs(1, "color", 0xFFFFFF, null);
                            e.setShapeTranslucency(1, "", "translucent", 0.5f, null);
                            this.setShapeProperty(1, "type", 1023);
                        }
                        this.showString(GT.i(GT.$("{0} struts added"), n));
                    }
                    return;
                }
                case 2097180: {
                    isSurface = true;
                }
                case 1111490575: {
                    boolean isFrom = false;
                    switch (this.tokAt(2)) {
                        case 134217759: {
                            ++e.iToken;
                            break;
                        }
                        case 0: {
                            isFrom = !isSurface;
                            break;
                        }
                        case 0x40000080: {
                            isFrom = true;
                            ++e.iToken;
                            break;
                        }
                        default: {
                            isFrom = true;
                        }
                    }
                    bs1 = e.iToken + 1 < this.slen ? this.atomExpressionAt(++e.iToken) : this.vwr.bsA();
                    this.checkLength(++e.iToken);
                    if (!this.chk) {
                        this.vwr.calculateSurface(bs1, isFrom ? Float.MAX_VALUE : -1.0f);
                    }
                    return;
                }
            }
        }
        e.errorStr2(53, "CALCULATE", "3D? aromatic? hbonds? hydrogen? formalCharge? partialCharge? pointgroup? straightness? structure? struts? surfaceDistance FROM? surfaceDistance WITHIN?");
    }

    private void capture() throws ScriptException {
        boolean isTransparent;
        if (!this.chk && !this.vwr.allowCapture()) {
            this.showString("Cannot capture on this platform");
            return;
        }
        Map<String, Object> params = this.vwr.captureParams;
        String type = params == null ? "GIF" : (String)params.get("type");
        float endTime = 0.0f;
        int mode = 0;
        int slen = this.e.slen;
        String fileName = "";
        boolean looping = this.vwr.am.animationReplayMode != 1073742070;
        int i = 1;
        int tok = this.tokAt(i);
        boolean bl = isTransparent = tok == 1111490588;
        if (isTransparent) {
            tok = this.tokAt(++i);
        }
        String s = null;
        switch (tok == 0 ? (tok = 102409) : tok) {
            case 4: {
                int pt;
                fileName = this.e.optParameterAsString(i++);
                if (fileName.length() == 0) {
                    mode = 102409;
                    break;
                }
                String lc = fileName.toLowerCase();
                if (lc.endsWith(".gift") || lc.endsWith(".pngt")) {
                    isTransparent = true;
                    fileName = fileName.substring(0, fileName.length() - 1);
                    lc = fileName.toLowerCase();
                } else if (!lc.endsWith(".gif") && !lc.contains(".png")) {
                    fileName = fileName + ".gif";
                }
                if (lc.endsWith(".png")) {
                    if (!lc.endsWith("0.png")) {
                        fileName = fileName.substring(0, fileName.length() - 4) + "0000.png";
                    }
                    type = "PNG";
                } else {
                    type = "GIF";
                }
                if (isTransparent) {
                    type = type + "T";
                }
                boolean streaming = (pt = fileName.indexOf("0000.")) < 0 || pt != fileName.lastIndexOf(".") - 4;
                boolean isRock = false;
                if (this.tokAt(i) == 528411) {
                    looping = true;
                    tok = this.tokAt(++i);
                }
                switch (this.tokAt(i)) {
                    case 134222850: {
                        s = this.stringParameter(++i);
                        break;
                    }
                    case 1073742129: {
                        isRock = true;
                    }
                    case 1611141175: {
                        String axis = "y";
                        looping = true;
                        ++i;
                        if (isRock) {
                            int n;
                            if (i < slen && this.tokAt(i) != 2) {
                                axis = this.e.optParameterAsString(i++).toLowerCase();
                            }
                            s = "rotate Y 10 10;rotate Y -10 -10;rotate Y -10 -10;rotate Y 10 10";
                            int n2 = n = i < slen ? this.intParameter(i++) : 5;
                            s = n < 0 ? PT.rep(s, "10;", "" + -n + ";") : PT.rep(s, "10", "" + n);
                        } else {
                            if (i < slen) {
                                axis = this.e.optParameterAsString(i++).toLowerCase();
                            }
                            s = "rotate Y 360 30;";
                        }
                        if (this.chk) {
                            return;
                        }
                        this.vwr.setNavigationMode(false);
                        if (axis == "" || "xyz".indexOf(axis) < 0) {
                            axis = "y";
                        }
                        s = PT.rep(s, "Y", axis);
                        break;
                    }
                    case 2: 
                    case 3: {
                        endTime = this.floatParameter(i++);
                    }
                }
                if (this.chk) {
                    return;
                }
                if (s != null) {
                    boolean wf = this.vwr.g.waitForMoveTo;
                    s = "set waitformoveto true;" + s + ";set waitformoveto " + wf;
                    s = "capture " + (isTransparent ? "transparent " : "") + PT.esc(fileName) + (looping ? " LOOP;" : ";") + s + ";capture end;";
                    this.e.cmdScript(0, null, s, null);
                    return;
                }
                mode = 1073742031;
                params = new Hashtable<String, Object>();
                int fps = this.vwr.getInt(553648132);
                if (streaming) {
                    params.put("streaming", Boolean.TRUE);
                    if (!looping) {
                        this.showString(GT.o(GT.$("Note: Enable looping using the LOOP keyword just after the file name or {0}"), new Object[]{"ANIMATION MODE LOOP"}));
                    }
                    this.showString(GT.o(GT.$("Animation delay based on: {0}"), new Object[]{"ANIMATION FPS " + fps}));
                }
                params.put("captureFps", fps);
                break;
            }
            case 102409: 
            case 1073741874: {
                if (params != null) {
                    params.put("captureSilent", Boolean.TRUE);
                }
            }
            case 1073742334: 
            case 1073742335: {
                this.checkLength(-2);
                mode = tok;
                break;
            }
            default: {
                this.invArg();
            }
        }
        if (this.chk || params == null) {
            return;
        }
        params.put("type", type);
        Integer c = this.vwr.getBackgroundArgb();
        params.put("backgroundColor", c);
        params.put("fileName", fileName);
        params.put("quality", -1);
        params.put("endTime", endTime <= 0.0f ? -1L : System.currentTimeMillis() + (long)(endTime * 1000.0f));
        params.put("captureMode", T.nameOf(mode).toLowerCase());
        params.put("captureLooping", looping ? Boolean.TRUE : Boolean.FALSE);
        String msg = this.vwr.processWriteOrCapture(params);
        if (msg == null) {
            msg = "canceled";
        }
        Logger.info(msg);
    }

    private void centerAt() throws ScriptException {
        int tok = this.getToken((int)1).tok;
        switch (tok) {
            case 96: 
            case 0x40000002: 
            case 1812599299: {
                break;
            }
            default: {
                this.invArg();
            }
        }
        P3 pt = P3.new3(0.0f, 0.0f, 0.0f);
        if (this.slen == 5) {
            pt.x = this.floatParameter(2);
            pt.y = this.floatParameter(3);
            pt.z = this.floatParameter(4);
        } else if (this.e.isCenterParameter(2)) {
            pt = this.centerParameter(2);
            this.e.checkLast(this.e.iToken);
        } else {
            this.checkLength(2);
        }
        if (!this.chk && !this.vwr.isJmolDataFrame()) {
            this.vwr.tm.setCenterAt(tok, pt);
        }
    }

    private void compare() throws ScriptException {
        int iModel;
        BS[] bsFrames;
        boolean isToSubsetOfFrom;
        ScriptEval eval = this.e;
        boolean isQuaternion = false;
        boolean doRotate = false;
        boolean doTranslate = false;
        boolean doAnimate = false;
        boolean isFlexFit = false;
        boolean doMorph = false;
        Quat[] data1 = null;
        Quat[] data2 = null;
        BS bsAtoms1 = null;
        BS bsAtoms2 = null;
        Lst<Object[]> vAtomSets = null;
        Lst<Object[]> vQuatSets = null;
        eval.iToken = 0;
        float nSeconds = this.isFloatParameter(1) ? this.floatParameter(++eval.iToken) : Float.NaN;
        P3[] coordTo = null;
        BS bsFrom = null;
        BS bsTo = null;
        int tok = 0;
        if (this.tokAt(1) == 4115) {
            bsFrom = this.vwr.bsA();
        } else {
            bsFrom = this.atomExpressionAt(1);
            if (eval.isArrayParameter(++eval.iToken)) {
                coordTo = eval.getPointArray(eval.iToken, -1, false);
            } else {
                tok = this.tokAt(eval.iToken);
                if (tok != 1153433601 && tok != 4115) {
                    bsTo = this.atomExpressionAt(eval.iToken);
                }
            }
        }
        BS bsSubset = null;
        boolean isSmiles = false;
        boolean isPolyhedral = false;
        String strSmiles = null;
        BS bs = BSUtil.copy(bsFrom);
        if (bsTo != null) {
            bs.or(bsTo);
        }
        boolean isFrames = isToSubsetOfFrom = coordTo == null && bsTo != null && bs.equals(bsFrom);
        boolean isAtoms = tok == 1153433601;
        boolean isCoords = false;
        block23: for (int i = eval.iToken + 1; i < this.slen; ++i) {
            switch (this.getToken((int)i).tok) {
                case 4115: {
                    isFrames = true;
                    if (bsTo != null) continue block23;
                    bsTo = BSUtil.copy(bsFrom);
                    continue block23;
                }
                case 134218757: {
                    isSmiles = true;
                    tok = this.tokAt(i + 1);
                    if (tok != 4 && tok != 1275203608) {
                        strSmiles = "*";
                        continue block23;
                    }
                }
                case 0x8000404: {
                    isPolyhedral = this.tokAt(++i) == 1275203608;
                    String string = strSmiles = isPolyhedral ? "polyhedra" : this.stringParameter(i);
                    if (!strSmiles.equalsIgnoreCase("polyhedra") && !strSmiles.equalsIgnoreCase("polyhedron")) continue block23;
                    isPolyhedral = true;
                    continue block23;
                }
                case 1677721602: {
                    isFlexFit = true;
                    doRotate = true;
                    strSmiles = this.paramAsStr(++i);
                    if (!strSmiles.equalsIgnoreCase("SMILES")) continue block23;
                    isSmiles = true;
                    if (this.e.tokAt(i + 1) == 1612709900) {
                        strSmiles = "H";
                        ++i;
                        continue block23;
                    }
                    strSmiles = "*";
                    continue block23;
                }
                case 2: 
                case 3: {
                    nSeconds = Math.abs(this.floatParameter(i));
                    if (!(nSeconds > 0.0f)) continue block23;
                    doAnimate = true;
                    continue block23;
                }
                case 0x10000600: {
                    continue block23;
                }
                case 2109448: {
                    bsSubset = this.atomExpressionAt(++i);
                    i = eval.iToken;
                    continue block23;
                }
                case 10: 
                case 1073742325: {
                    if (vQuatSets != null) {
                        this.invArg();
                    }
                    bsAtoms1 = this.atomExpressionAt(eval.iToken);
                    int n = tok = isToSubsetOfFrom ? 0 : this.tokAt(eval.iToken + 1);
                    BS bS = coordTo == null && eval.isArrayParameter(eval.iToken + 1) ? null : (bsAtoms2 = tok == 10 || tok == 1073742325 ? this.atomExpressionAt(++eval.iToken) : BSUtil.copy(bsAtoms1));
                    if (bsSubset != null) {
                        bsAtoms1.and(bsSubset);
                        if (bsAtoms2 != null) {
                            bsAtoms2.and(bsSubset);
                        }
                    }
                    if (bsAtoms2 == null) {
                        int ipt = eval.iToken;
                        coordTo = eval.getPointArray(eval.iToken + 1, -1, false);
                        if (coordTo == null) {
                            eval.iToken = ipt;
                        } else {
                            isCoords = true;
                        }
                    } else if (bsTo != null) {
                        bsAtoms2.and(bsTo);
                    }
                    if (vAtomSets == null) {
                        vAtomSets = new Lst<Object[]>();
                    }
                    vAtomSets.addLast(new Object[]{bsAtoms1, bsAtoms2 == null ? coordTo : bsAtoms2});
                    if (isAtoms) {
                        coordTo = null;
                    }
                    i = eval.iToken;
                    continue block23;
                }
                case 1275203608: {
                    isPolyhedral = true;
                    isSmiles = true;
                    continue block23;
                }
                case 4125: {
                    continue block23;
                }
                case 7: {
                    if (vAtomSets != null) {
                        this.invArg();
                    }
                    isQuaternion = true;
                    data1 = eval.getQuaternionArray(((SV)eval.theToken).getList(), 1073742001);
                    this.getToken(++i);
                    data2 = eval.getQuaternionArray(((SV)eval.theToken).getList(), 1073742001);
                    if (vQuatSets == null) {
                        vQuatSets = new Lst<Object[]>();
                    }
                    vQuatSets.addLast(new Object[]{data1, data2});
                    continue block23;
                }
                case 1073742077: {
                    isQuaternion = true;
                    continue block23;
                }
                case 1153433601: {
                    isAtoms = true;
                    isQuaternion = false;
                    continue block23;
                }
                case 134217751: {
                    isQuaternion = false;
                    continue block23;
                }
                case 1073742029: {
                    doMorph = true;
                    continue block23;
                }
                case 528432: {
                    doRotate = true;
                    continue block23;
                }
                case 4160: {
                    doTranslate = true;
                    continue block23;
                }
                default: {
                    this.invArg();
                }
            }
        }
        if (this.chk) {
            return;
        }
        if (isFrames) {
            nSeconds = 0.0f;
        }
        if (Float.isNaN(nSeconds) || nSeconds < 0.0f) {
            nSeconds = 1.0f;
        } else if (!(doMorph || doRotate || doTranslate)) {
            doTranslate = true;
            doRotate = true;
        }
        doAnimate = nSeconds != 0.0f;
        boolean bl = isAtoms = !isQuaternion && strSmiles == null && !isPolyhedral || coordTo != null;
        if (isAtoms) {
            Interface.getInterface("javajs.util.Eigen", this.vwr, "script");
        }
        if (vAtomSets == null && vQuatSets == null) {
            if (isPolyhedral && bsSubset == null) {
                bsSubset = this.vwr.getAtomBitSet("polyhedra");
            }
            if (bsSubset == null) {
                BS bS = bsAtoms1 = isAtoms ? this.vwr.getAtomBitSet("spine") : new BS();
                if (bsAtoms1.nextSetBit(0) < 0) {
                    bsAtoms1 = bsFrom;
                    bsAtoms2 = bsTo;
                } else {
                    bsAtoms2 = BSUtil.copy(bsAtoms1);
                    bsAtoms1.and(bsFrom);
                    bsAtoms2.and(bsTo);
                }
            } else {
                bsAtoms1 = BSUtil.copy(bsFrom);
                bsAtoms2 = BSUtil.copy(bsTo);
                bsAtoms1.and(bsSubset);
                bsAtoms1.and(bsFrom);
                if (bsAtoms2 != null) {
                    bsAtoms2.and(bsSubset);
                    bsAtoms2.and(bsTo);
                }
            }
            vAtomSets = new Lst();
            vAtomSets.addLast(new BS[]{bsAtoms1, bsAtoms2});
        }
        BS bsModels = null;
        if (isFrames) {
            bsModels = this.vwr.ms.getModelBS(bsFrom, false);
            bsFrames = new BS[bsModels.cardinality()];
            int i = 0;
            iModel = bsModels.nextSetBit(0);
            while (iModel >= 0) {
                bsFrames[i] = this.vwr.getModelUndeletedAtomsBitSet(iModel);
                iModel = bsModels.nextSetBit(iModel + 1);
                ++i;
            }
        } else {
            bsModels = BSUtil.newAndSetBit(0);
            bsFrames = new BS[]{bsFrom};
        }
        iModel = bsModels.nextSetBit(0);
        for (int iFrame = 0; iFrame < bsFrames.length; ++iFrame) {
            block103: {
                float endDegrees;
                P3 pt1;
                V3 translation;
                P3 center;
                P3[][] centerAndPoints;
                Quat q;
                block105: {
                    block106: {
                        block104: {
                            Lst<Object[]> vAtomSets2;
                            float[] retStddev;
                            block102: {
                                bsFrom = bsFrames[iFrame];
                                retStddev = new float[2];
                                if (!isFrames || !isPolyhedral || iFrame != 0) break block102;
                                bsTo = bsFrom;
                                break block103;
                            }
                            q = null;
                            Lst<Quat> vQ = new Lst<Quat>();
                            centerAndPoints = null;
                            Lst<Object[]> lst = vAtomSets2 = isFrames ? new Lst<Object[]>() : vAtomSets;
                            if (!isCoords) {
                                for (int i = 0; i < vAtomSets.size(); ++i) {
                                    Object[] bss = (Object[])vAtomSets.get(i);
                                    if (isFrames) {
                                        bss = new BS[]{BSUtil.copy((BS)bss[0]), (BS)bss[1]};
                                        vAtomSets2.addLast(bss);
                                    }
                                    ((BS)bss[0]).and(bsFrom);
                                }
                            }
                            center = null;
                            translation = null;
                            if (isAtoms) {
                                if (coordTo != null) {
                                    vAtomSets2.clear();
                                    vAtomSets2.addLast(new Object[]{bsAtoms1, coordTo});
                                }
                                try {
                                    centerAndPoints = this.vwr.getCenterAndPoints(vAtomSets2, !doMorph);
                                }
                                catch (Exception ex) {
                                    this.invArg();
                                }
                                if (!doMorph) {
                                    int n = centerAndPoints[0].length - 1;
                                    for (int i = 1; i <= n; ++i) {
                                        P3 aij = centerAndPoints[0][i];
                                        P3 bij = centerAndPoints[1][i];
                                        if (!(aij instanceof Atom) || !(bij instanceof Atom)) break;
                                        if (isFrames) continue;
                                        Logger.info(" atom 1 " + ((Atom)aij).getInfo() + "\tatom 2 " + ((Atom)bij).getInfo());
                                    }
                                    q = Measure.calculateQuaternionRotation(centerAndPoints, retStddev);
                                    float r0 = Float.isNaN(retStddev[1]) ? Float.NaN : (float)Math.round(retStddev[0] * 100.0f) / 100.0f;
                                    float r1 = Float.isNaN(retStddev[1]) ? Float.NaN : (float)Math.round(retStddev[1] * 100.0f) / 100.0f;
                                    this.showString("RMSD " + r0 + " --> " + r1 + " Angstroms");
                                }
                            } else if (isQuaternion) {
                                if (vQuatSets == null) {
                                    for (int i = 0; i < vAtomSets2.size(); ++i) {
                                        BS[] bss = (BS[])vAtomSets2.get(i);
                                        data1 = this.vwr.getAtomGroupQuaternions(bss[0], Integer.MAX_VALUE);
                                        data2 = this.vwr.getAtomGroupQuaternions(bss[1], Integer.MAX_VALUE);
                                        for (int j = 0; j < data1.length && j < data2.length; ++j) {
                                            vQ.addLast(data2[j].div(data1[j]));
                                        }
                                    }
                                } else {
                                    for (int j = 0; j < data1.length && j < data2.length; ++j) {
                                        vQ.addLast(data2[j].div(data1[j]));
                                    }
                                }
                                retStddev[0] = 0.0f;
                                data1 = vQ.toArray(new Quat[vQ.size()]);
                                q = Quat.sphereMean(data1, retStddev, 1.0E-4f);
                                this.showString("RMSD = " + retStddev[0] + " degrees");
                            } else {
                                T3[] oabc;
                                float stddev;
                                M4 m4 = new M4();
                                center = new P3();
                                if (bsFrom != null && strSmiles != null && ("H".equals(strSmiles) || "*".equals(strSmiles) || "".equals(strSmiles))) {
                                    try {
                                        strSmiles = this.vwr.getSmilesOpt(bsAtoms1 == null ? bsFrom : bsAtoms1, -1, -1, 0x8000 | ("H".equals(strSmiles) ? 4096 : 0), null);
                                    }
                                    catch (Exception ex) {
                                        eval.evalError(ex.getMessage(), null);
                                    }
                                }
                                if (isFlexFit) {
                                    float[] list;
                                    if (bsFrom == null || bsTo == null || (list = eval.getSmilesExt().getFlexFitList(bsFrom, bsTo, strSmiles, !isSmiles)) == null) {
                                        return;
                                    }
                                    this.vwr.setDihedrals(list, null, 1.0f);
                                }
                                if (isPolyhedral) {
                                    BS bs1 = BS.copy(bsAtoms1);
                                    bs1.and(bsFrom);
                                    BS bs2 = BS.copy(bsAtoms2);
                                    bs2.and(bsTo);
                                    stddev = eval.getSmilesExt().mapPolyhedra(bs1.nextSetBit(0), bs2.nextSetBit(0), isSmiles, m4);
                                } else {
                                    this.showString("COMPARE using " + (isSmiles ? "SMILES " : "SMARTS ") + strSmiles);
                                    Lst<P3> ptsA = new Lst<P3>();
                                    Lst<P3> ptsB = new Lst<P3>();
                                    stddev = eval.getSmilesExt().getSmilesCorrelation(bsAtoms1 == null ? bsFrom : bsAtoms1, bsAtoms2 == null ? bsTo : bsAtoms2, strSmiles, ptsA, ptsB, m4, null, false, null, center, false, 0x20 | (isSmiles ? 1 : 2));
                                }
                                if (Float.isNaN(stddev)) {
                                    this.showString("structures do not match from " + bsFrom + " to " + bsTo);
                                    return;
                                }
                                if (doTranslate) {
                                    translation = new V3();
                                    m4.getTranslation(translation);
                                }
                                if (doRotate) {
                                    M3 m3 = new M3();
                                    m4.getRotationScale(m3);
                                    q = Quat.newM(m3);
                                }
                                this.showString("RMSD = " + stddev + " Angstroms");
                                if (isFrames && (oabc = this.vwr.getV0abc(iModel, new Object[]{m4})) != null) {
                                    this.vwr.ms.setModelCagePts(iModel, oabc, null);
                                }
                            }
                            if (centerAndPoints != null) {
                                center = centerAndPoints[0][0];
                            }
                            if (center == null) {
                                centerAndPoints = this.vwr.getCenterAndPoints(vAtomSets2, true);
                                center = centerAndPoints[0][0];
                            }
                            pt1 = new P3();
                            endDegrees = Float.NaN;
                            if (!doMorph) break block104;
                            endDegrees = 1.0E10f;
                            break block105;
                        }
                        if (doTranslate) {
                            if (translation == null) {
                                translation = V3.newVsub(centerAndPoints[1][0], center);
                            }
                            endDegrees = 1.0E10f;
                        }
                        if (!doRotate) break block105;
                        if (q == null) {
                            eval.evalError("option not implemented", null);
                        }
                        pt1.add2(center, q.getNormal());
                        endDegrees = q.getTheta();
                        if (endDegrees != 0.0f || !doTranslate) break block105;
                        if (!(translation.length() > 0.01f)) break block106;
                        endDegrees = 1.0E10f;
                        break block105;
                    }
                    if (isFrames) break block103;
                    doAnimate = false;
                    doTranslate = false;
                    doRotate = false;
                }
                if (!Float.isNaN(endDegrees) && !Float.isNaN(pt1.x)) {
                    Lst<P3> ptsB = null;
                    if (doMorph) {
                        ptsB = new Lst<P3>();
                        int n = centerAndPoints[0].length;
                        for (int i = 0; i < n; ++i) {
                            ptsB.addLast(centerAndPoints[1][i]);
                        }
                    } else if (doRotate && doTranslate && nSeconds != 0.0f) {
                        Lst<P3> ptsA = this.vwr.ms.getAtomPointVector(bsFrom);
                        M4 m4 = ScriptMathProcessor.getMatrix4f(q.getMatrix(), translation);
                        ptsB = ScriptParam.transformPoints(ptsA, m4, center);
                    }
                    if (!eval.useThreads(true)) {
                        doAnimate = false;
                    }
                    if (this.vwr.rotateAboutPointsInternal(eval, center, pt1, endDegrees / nSeconds, endDegrees, doAnimate, bsFrom, translation, ptsB, null, null, false, centerAndPoints) && doAnimate && eval.isJS) {
                        throw new ScriptInterruption(eval, "compare", 1);
                    }
                }
            }
            iModel = bsModels.nextSetBit(iModel + 1);
        }
    }

    private void configuration() throws ScriptException {
        BS bsSelected;
        BS bsAtoms = null;
        BS bS = bsSelected = this.chk ? null : this.vwr.bsA();
        if (this.slen == 1) {
            if (this.chk) {
                return;
            }
            bsAtoms = this.vwr.ms.setConformation(bsSelected);
            this.vwr.ms.addStateScript("select", null, bsSelected, null, ";configuration", true, false);
        } else {
            int n = Integer.MIN_VALUE;
            BS bs = null;
            if (this.tokAt(1) == 4) {
                n = -1000 - (this.stringParameter(this.e.checkLast(1)) + " ").codePointAt(0);
            } else if (this.tokAt(1) == 2) {
                n = this.intParameter(this.e.checkLast(1));
            } else {
                bs = bsAtoms = this.atomExpressionAt(1);
                n = this.tokAt(this.e.iToken) == 4 ? -1000 - (this.stringParameter(this.e.checkLast(this.e.iToken + 1)) + " ").codePointAt(0) : this.intParameter(this.e.checkLast(this.e.iToken + 1));
            }
            if (this.chk) {
                return;
            }
            this.vwr.addStateScript("configuration " + (bs == null ? "" : Escape.eBS(bsAtoms) + " ") + n + ";", true, false);
            bsAtoms = this.vwr.ms.getConformation(this.vwr.am.cmi, n, true, bs);
        }
        this.setShapeProperty(1, "type", 30720);
        this.e.setShapeSizeBs(1, 0, bsAtoms);
        this.vwr.autoHbond(bsAtoms, bsAtoms, true);
        this.vwr.selectStatus(bsAtoms, false, 0, !this.e.doReport(), false);
    }

    private void measure() throws ScriptException {
        ScriptEval eval = this.e;
        String id = null;
        int pt = 1;
        short colix = 0;
        float[] offset = null;
        if (this.slen == 2) {
            switch (this.tokAt(1)) {
                case 1073742334: {
                    this.setShapeProperty(6, "hideAll", Boolean.TRUE);
                    return;
                }
                case 12291: {
                    if (!this.chk) {
                        this.vwr.clearAllMeasurements();
                    }
                    return;
                }
                case 1113589787: {
                    if (!this.chk) {
                        this.showMeasureCount(true);
                    }
                    return;
                }
            }
        }
        this.vwr.shm.loadShape(6);
        switch (this.tokAt(1)) {
            case 0x8000404: {
                String smarts = this.stringParameter(this.slen == 3 ? 2 : 4);
                if (this.chk) {
                    return;
                }
                Node[] atoms = this.vwr.ms.at;
                int ac = this.vwr.ms.ac;
                int[][] maps = null;
                try {
                    maps = this.vwr.getSmilesMatcher().getCorrelationMaps(smarts, atoms, ac, this.vwr.bsA(), 2);
                }
                catch (Exception ex) {
                    eval.evalError(ex.getMessage(), null);
                }
                if (maps == null) {
                    return;
                }
                this.setShapeProperty(6, "maps", maps);
                return;
            }
        }
        switch (this.slen) {
            case 2: {
                switch (this.getToken((int)pt).tok) {
                    case 0: 
                    case 1073742335: {
                        this.vwr.shm.loadShape(6);
                        this.setShapeProperty(6, "hideAll", Boolean.FALSE);
                        return;
                    }
                    case 1073742001: {
                        if (!this.chk) {
                            eval.showStringPrint(this.vwr.getMeasurementInfoAsString(), false);
                        }
                        return;
                    }
                    case 4: {
                        this.setShapeProperty(6, "setFormats", this.stringParameter(1));
                        return;
                    }
                }
                eval.errorStr(24, "ON, OFF, DELETE");
                break;
            }
            case 3: {
                switch (this.getToken((int)1).tok) {
                    case 12291: {
                        if (this.getToken((int)2).tok == 1073742327) {
                            if (!this.chk) {
                                this.vwr.clearAllMeasurements();
                            }
                        } else {
                            int i = this.intParameter(2) - 1;
                            if (!this.chk) {
                                this.vwr.deleteMeasurement(i);
                            }
                        }
                        return;
                    }
                }
            }
        }
        int nAtoms = 0;
        int expressionCount = 0;
        int modelIndex = -1;
        int atomIndex = -1;
        int ptFloat = -1;
        int[] countPlusIndexes = new int[5];
        float[] rangeMinMax = new float[]{Float.MAX_VALUE, Float.MAX_VALUE};
        boolean isAll = false;
        boolean isAllConnected = false;
        boolean isNotConnected = false;
        boolean isRange = true;
        boolean isRefreshID = false;
        RadiusData rd = null;
        Boolean intramolecular = null;
        int tokAction = 268438018;
        String strFormat = null;
        String property = null;
        String units = null;
        Font font = null;
        Lst<Object> points = new Lst<Object>();
        BS bs = new BS();
        BS bsSelected = null;
        JSONEncodable target = null;
        TickInfo tickInfo = null;
        int nBitSets = 0;
        int mad = 0;
        float value = Float.NaN;
        String alignment = null;
        block55: for (int i = 1; i < this.slen; ++i) {
            switch (this.getToken((int)i).tok) {
                default: {
                    this.error(15);
                    continue block55;
                }
                case 1073741974: {
                    if (i != 1) {
                        this.invArg();
                    }
                    id = eval.optParameterAsString(++i);
                    continue block55;
                }
                case 0x40000000: {
                    eval.errorStr(24, "ALL, ALLCONNECTED, DELETE");
                    continue block55;
                }
                case 1275082241: {
                    tokAction = 1275082241;
                    if (this.tokAt(i + 1) != 1073742327 || this.slen != i + 2) continue block55;
                    if (!this.chk) {
                        this.vwr.setShapeProperty(6, "selectall", null);
                        this.showMeasureCount(true);
                    }
                    return;
                }
                case 1113589787: {
                    if (points.size() > 0 || nBitSets > 0 || id != null) {
                        this.invArg();
                    }
                    tokAction = 1275082241;
                    if (this.chk) {
                        bsSelected = new BS();
                    } else {
                        bsSelected = (BS)this.vwr.getShapeProperty(6, "selected");
                        if (bsSelected.cardinality() == 0) {
                            return;
                        }
                    }
                    isAll = true;
                    continue block55;
                }
                case 0x10000E00: {
                    if (this.tokAt(i + 1) != 0x8000008) {
                        this.invArg();
                    }
                    ++i;
                    isNotConnected = true;
                    continue block55;
                }
                case 0x40000008: {
                    alignment = this.paramAsStr(++i).toLowerCase();
                    continue block55;
                }
                case 0x8000008: 
                case 0x4000000A: 
                case 1073742327: {
                    isAllConnected = eval.theTok == 0x4000000A;
                    atomIndex = -1;
                    isAll = true;
                    if (!isAllConnected || !isNotConnected) continue block55;
                    this.invArg();
                    continue block55;
                }
                case 1765808134: {
                    colix = C.getColix(eval.getArgbParam(++i));
                    i = eval.iToken;
                    continue block55;
                }
                case 1073742066: {
                    if (eval.isPoint3f(++i)) {
                        P3 p = this.getPoint3f(i, false);
                        offset = new float[]{1.0f, p.x, p.y, p.z, 0.0f, 0.0f, 0.0f};
                    } else {
                        offset = eval.floatParameterSet(i, 7, 7);
                    }
                    i = eval.iToken;
                    continue block55;
                }
                case 1073741917: 
                case 1665140738: {
                    mad = (int)((float)(eval.theTok == 1665140738 ? 2000 : 1000) * this.floatParameter(++i));
                    if (id == null || mad > 0) continue block55;
                    mad = -1;
                    continue block55;
                }
                case 3: {
                    if (rd != null) {
                        this.invArg();
                    }
                    isAll = true;
                    isRange = true;
                    ptFloat = (ptFloat + 1) % 2;
                    rangeMinMax[ptFloat] = this.floatParameter(i);
                    continue block55;
                }
                case 12291: {
                    if (tokAction != 268438018 && tokAction != 1275082241) {
                        this.invArg();
                    }
                    tokAction = 12291;
                    continue block55;
                }
                case 4114: {
                    float fontsize = this.floatParameter(++i);
                    String fontface = this.paramAsStr(++i);
                    String fontstyle = this.paramAsStr(++i);
                    if (this.chk) continue block55;
                    font = this.vwr.getFont3D(fontface, fontstyle, fontsize);
                    continue block55;
                }
                case 2: {
                    int iParam = this.intParameter(i);
                    if (isAll) {
                        isRange = true;
                        ptFloat = (ptFloat + 1) % 2;
                        rangeMinMax[ptFloat] = iParam;
                        continue block55;
                    }
                    atomIndex = this.vwr.ms.getFirstAtomIndexFromAtomNumber(iParam, this.vwr.getVisibleFramesBitSet());
                    if (!this.chk && atomIndex < 0) {
                        return;
                    }
                    if (target != null) {
                        this.invArg();
                    }
                    if ((countPlusIndexes[0] = ++nAtoms) > 4) {
                        eval.bad();
                    }
                    countPlusIndexes[nAtoms] = atomIndex;
                    continue block55;
                }
                case 1094713359: {
                    modelIndex = this.intParameter(++i);
                    continue block55;
                }
                case 1073742334: {
                    if (tokAction != 268438018) {
                        this.invArg();
                    }
                    tokAction = 1073742334;
                    continue block55;
                }
                case 1073742335: {
                    if (tokAction != 268438018) {
                        this.invArg();
                    }
                    tokAction = 1073742335;
                    continue block55;
                }
                case 1073742114: {
                    isAll = true;
                    isRange = true;
                    atomIndex = -1;
                    continue block55;
                }
                case 1073741989: 
                case 1073741990: {
                    intramolecular = eval.theTok == 1073741989;
                    isAll = true;
                    isNotConnected = eval.theTok == 1073741990;
                    continue block55;
                }
                case 1648363544: {
                    if (ptFloat >= 0) {
                        this.invArg();
                    }
                    if ((rd = eval.encodeRadiusParameter(i, false, true)) == null) {
                        return;
                    }
                    rd.values = rangeMinMax;
                    i = eval.iToken;
                    isNotConnected = true;
                    isAll = true;
                    intramolecular = false;
                    if (nBitSets != 1) continue block55;
                    ++nBitSets;
                    ++nAtoms;
                    BS bs2 = BSUtil.copy(bs);
                    BSUtil.invertInPlace(bs2, this.vwr.ms.ac);
                    bs2.and(this.vwr.ms.getAtomsWithinRadius(5.0f, bs, false, null, null));
                    points.addLast(bs2);
                    continue block55;
                }
                case 10: 
                case 12290: 
                case 1073742325: {
                    ++nBitSets;
                }
                case 8: 
                case 1073742330: 
                case 1073742332: {
                    if (atomIndex >= 0 || bsSelected != null) {
                        this.invArg();
                    }
                    Object[] ret = new Object[1];
                    target = eval.centerParameter(i, ret);
                    if (ret[0] instanceof BS) {
                        bs = (BS)ret[0];
                        target = bs;
                        if (!this.chk && bs.length() == 0) {
                            return;
                        }
                    }
                    if (target instanceof P3) {
                        Point3fi v = new Point3fi();
                        v.setT((T3)target);
                        v.mi = (short)modelIndex;
                        target = v;
                    }
                    if ((nAtoms = ++expressionCount) > 4) {
                        eval.bad();
                    }
                    i = eval.iToken;
                    points.addLast(target);
                    continue block55;
                }
                case 1715472409: {
                    property = this.paramAsStr(i);
                    continue block55;
                }
                case 1073742188: {
                    value = this.floatParameter(++i);
                    continue block55;
                }
                case 4: {
                    String s = this.stringParameter(i);
                    if (Measurement.isUnits(s) || s.equals("default")) {
                        units = s;
                        continue block55;
                    }
                    strFormat = s;
                    continue block55;
                }
                case 1073742164: {
                    tickInfo = eval.tickParamAsStr(i, false, true, true);
                    i = eval.iToken;
                    tokAction = 12290;
                }
            }
        }
        if (rd != null && (ptFloat >= 0 || nAtoms != 2) || tokAction != 1275082241 && bsSelected == null && nAtoms < 2 && id == null && (tickInfo == null || nAtoms == 1)) {
            eval.bad();
        }
        if (strFormat != null && strFormat.indexOf(nAtoms + ":") != 0) {
            strFormat = nAtoms + ":" + strFormat;
        }
        if (isRange && rangeMinMax[1] < rangeMinMax[0]) {
            rangeMinMax[1] = rangeMinMax[0];
            float f = rangeMinMax[0] = rangeMinMax[1] == Float.MAX_VALUE ? Float.MAX_VALUE : -200.0f;
        }
        if (this.chk) {
            return;
        }
        boolean bl = isRefreshID = id != null && target == null && tokAction == 268438018;
        if (target != null || bsSelected != null || tickInfo != null || isRefreshID) {
            if (rd == null) {
                rd = new RadiusData(rangeMinMax, 0.0f, null, null);
            }
            if (tickInfo != null) {
                tickInfo.id = "default";
            }
            if (isRefreshID) {
                tokAction = 266284;
            } else if (target != null && (property != null || strFormat != null) && tokAction == 268438018) {
                tokAction = 12290;
            }
            Text text = null;
            if (font != null || alignment != null || colix != 0 || strFormat != null && (isRefreshID || strFormat.indexOf(10) >= 0)) {
                text = Text.newMeasure(this.vwr, font, colix);
            }
            if (text != null) {
                text.pymolOffset = offset;
                text.setAlignmentLCR(alignment);
            }
            this.setShapeProperty(6, "measure", this.vwr.newMeasurementData(id, points).set(tokAction, null, rd, property, strFormat, units, tickInfo, isAllConnected, isNotConnected, intramolecular, isAll, mad, colix, text, value, bsSelected));
            if (tokAction == 1275082241) {
                this.showMeasureCount(false);
            }
            return;
        }
        Object propertyValue = id == null ? countPlusIndexes : (Object)id;
        switch (tokAction) {
            case 12291: {
                this.setShapeProperty(6, "delete", propertyValue);
                break;
            }
            case 1073742335: {
                this.setShapeProperty(6, "show", propertyValue);
                break;
            }
            case 1073742334: {
                this.setShapeProperty(6, "hide", propertyValue);
                break;
            }
            default: {
                this.setShapeProperty(6, strFormat == null && units == null ? "toggle" : "toggleOn", propertyValue);
                if (strFormat == null) break;
                this.setShapeProperty(6, "setFormats", strFormat);
            }
        }
    }

    private void showMeasureCount(boolean isFull) {
        BS bs = (BS)this.vwr.getShapeProperty(6, "selected");
        int n = bs.cardinality();
        if (isFull) {
            int i = bs.nextSetBit(0);
            while (i >= 0) {
                this.showString(((Measures)this.vwr.shm.getShape(6)).getInfoAsString(i));
                i = bs.nextSetBit(i + 1);
            }
        }
        this.showString(n + (n == 1 ? " measure" : " measures") + " selected");
    }

    private void connect(int index) throws ScriptException {
        ScriptEval eval = this.e;
        float[] distances = new float[2];
        BS[] atomSets = new BS[2];
        atomSets[0] = atomSets[1] = this.vwr.bsA();
        float radius = Float.NaN;
        int[] colorArgb = new int[]{Integer.MIN_VALUE};
        int distanceCount = 0;
        int bondOrder = 131071;
        int operation = 1073742026;
        boolean isDelete = false;
        boolean haveType = false;
        boolean haveOperation = false;
        float translucentLevel = Float.MAX_VALUE;
        boolean isColorOrRadius = false;
        int nAtomSets = 0;
        int nDistances = 0;
        BS bsBonds = new BS();
        boolean isBonds = false;
        int expression2 = 0;
        int ptColor = 0;
        float energy = 0.0f;
        boolean addGroup = false;
        if (this.slen == 1) {
            if (!this.chk) {
                this.vwr.rebondState(eval.isStateScript);
            }
            return;
        }
        if (this.tokAt(1) == 1073877011) {
            if (!this.chk) {
                this.vwr.connectNBO(this.e.optParameterAsString(2));
            }
            return;
        }
        for (int i = index; i < this.slen; ++i) {
            switch (this.getToken((int)i).tok) {
                case 1073742334: 
                case 1073742335: {
                    this.checkLength(2);
                    if (!this.chk) {
                        this.vwr.rebondState(eval.isStateScript);
                    }
                    return;
                }
                case 2: 
                case 3: {
                    int bo;
                    if (nAtomSets > 0) {
                        if (haveType || isColorOrRadius) {
                            eval.error(23);
                        }
                        if ((bo = Edge.getBondOrderFromFloat(this.floatParameter(i))) == 131071) {
                            this.invArg();
                        }
                        bondOrder = bo;
                        haveType = true;
                        break;
                    }
                    if (++nDistances > 2) {
                        eval.bad();
                    }
                    float dist = this.floatParameter(i);
                    if (this.tokAt(i + 1) == 268441090) {
                        dist = -dist / 100.0f;
                        ++i;
                    }
                    distances[distanceCount++] = dist;
                    break;
                }
                case 10: 
                case 12290: 
                case 1073742325: {
                    if (nAtomSets > 2 || isBonds && nAtomSets > 0) {
                        eval.bad();
                    }
                    if (haveType || isColorOrRadius) {
                        this.invArg();
                    }
                    atomSets[nAtomSets++] = this.atomExpressionAt(i);
                    isBonds = eval.isBondSet;
                    if (nAtomSets == 2) {
                        int pt = eval.iToken;
                        for (int j = i; j < pt; ++j) {
                            if (this.tokAt(j) != 0x40000000 || !this.paramAsStr(j).equals("_1")) continue;
                            expression2 = i;
                            break;
                        }
                        eval.iToken = pt;
                    }
                    i = eval.iToken;
                    break;
                }
                case 1086324742: {
                    addGroup = true;
                    break;
                }
                case 1073742074: 
                case 1111490588: 
                case 1765808134: {
                    isColorOrRadius = true;
                    translucentLevel = this.getColorTrans(eval, i, false, colorArgb);
                    i = eval.iToken;
                    break;
                }
                case 1073742086: {
                    boolean isAuto = this.tokAt(2) == 1073741852;
                    this.checkLength(isAuto ? 3 : 2);
                    if (this.chk) {
                        return;
                    }
                    this.vwr.clearModelDependentObjects();
                    this.vwr.ms.deleteAllBonds();
                    BS bsExclude = new BS();
                    this.vwr.ms.setPdbConectBonding(0, 0, bsExclude);
                    if (isAuto) {
                        boolean isLegacy = eval.isStateScript && this.vwr.getBoolean(603979872);
                        this.vwr.ms.autoBondBs4(null, null, bsExclude, null, this.vwr.getMadBond(), isLegacy, null);
                        this.vwr.addStateScript(isLegacy ? "set legacyAutoBonding TRUE;connect PDB AUTO;set legacyAutoBonding FALSE;" : "connect PDB auto;", false, true);
                        return;
                    }
                    this.vwr.addStateScript("connect PDB;", false, true);
                    return;
                }
                case 1073741852: 
                case 0x40000050: 
                case 1073742025: 
                case 1073742026: {
                    haveOperation = true;
                    if (++i != this.slen) {
                        this.invArg();
                    }
                    if ((operation = eval.theTok) != 1073741852 || bondOrder == 131071 || bondOrder == 2048 || bondOrder == 515) break;
                    this.invArg();
                    break;
                }
                case 659482: {
                    if (!isColorOrRadius) {
                        colorArgb[0] = 0xFFFFFF;
                        translucentLevel = 0.5f;
                        radius = this.vwr.getFloat(570425406);
                        isColorOrRadius = true;
                    }
                    if (!haveOperation) {
                        operation = 1073742026;
                        haveOperation = true;
                    }
                }
                case 0x40000000: {
                    if (eval.isColorParam(i)) {
                        ptColor = -i;
                        break;
                    }
                }
                case 1075838996: 
                case 1613238294: {
                    String cmd = this.paramAsStr(i);
                    int bo = Edge.getBondOrderFromString(cmd);
                    if (bo == 131071) {
                        this.invArg();
                    }
                    if (haveType) {
                        eval.error(18);
                    }
                    haveType = true;
                    switch (bo) {
                        case 33: {
                            switch (this.tokAt(i + 1)) {
                                case 3: {
                                    bo = Edge.getPartialBondOrderFromFloatEncodedInt(this.st[++i].intValue);
                                    break;
                                }
                                case 2: {
                                    bo = (short)this.intParameter(++i);
                                }
                            }
                            break;
                        }
                        case 2048: {
                            if (this.tokAt(i + 1) != 2) break;
                            bo = (short)(this.intParameter(++i) << 11);
                            energy = this.floatParameter(++i);
                            break;
                        }
                        case 65537: {
                            if (haveOperation) break;
                            operation = 1073742025;
                            haveOperation = true;
                        }
                    }
                    bondOrder = bo;
                    break;
                }
                case 1665140738: {
                    radius = this.floatParameter(++i);
                    isColorOrRadius = true;
                    break;
                }
                case 1073742333: {
                    if (++i != this.slen) {
                        this.invArg();
                    }
                }
                case 12291: {
                    operation = 12291;
                    isDelete = true;
                    isColorOrRadius = false;
                    break;
                }
                default: {
                    ptColor = i;
                }
            }
            if (i <= 0) continue;
            if (ptColor == -i || ptColor == i && eval.isColorParam(i)) {
                isColorOrRadius = true;
                colorArgb[0] = eval.getArgbParam(i);
                i = eval.iToken;
                continue;
            }
            if (ptColor != i) continue;
            this.invArg();
        }
        if (this.chk) {
            return;
        }
        if (distanceCount < 2) {
            if (distanceCount == 0) {
                distances[0] = 1.0E8f;
            }
            distances[1] = distances[0];
            distances[0] = 0.1f;
        }
        if (isColorOrRadius) {
            if (!haveType) {
                bondOrder = 65535;
            }
            if (!haveOperation) {
                operation = 1073742025;
            }
        }
        int nNew = 0;
        int nModified = 0;
        if (expression2 > 0) {
            BS bs = new BS();
            this.vwr.definedAtomSets.put("_1", bs);
            BS bs0 = atomSets[0];
            int atom1 = bs0.nextSetBit(0);
            while (atom1 >= 0) {
                bs.set(atom1);
                int[] result = this.vwr.makeConnections(distances[0], distances[1], bondOrder, operation, bs, this.atomExpressionAt(expression2), bsBonds, isBonds, false, 0.0f);
                nNew += Math.abs(result[0]);
                nModified += result[1];
                bs.clear(atom1);
                atom1 = bs0.nextSetBit(atom1 + 1);
            }
        } else {
            int[] result = this.vwr.makeConnections(distances[0], distances[1], bondOrder, operation, atomSets[0], atomSets[1], bsBonds, isBonds, addGroup, energy);
            nNew += Math.abs(result[0]);
            nModified += result[1];
        }
        boolean report = eval.doReport();
        if (isDelete) {
            if (report) {
                eval.report(GT.i(GT.$("{0} connections deleted"), nModified), false);
            }
            return;
        }
        if (isColorOrRadius) {
            this.vwr.selectBonds(bsBonds);
            if (!Float.isNaN(radius)) {
                eval.setShapeSizeBs(1, Math.round(radius * 2000.0f), null);
            }
            this.finalizeObject(1, colorArgb[0], translucentLevel, 0, false, null, 0, bsBonds);
            this.vwr.selectBonds(null);
        }
        if (report) {
            eval.report(GT.o(GT.$("{0} new bonds; {1} modified"), new Object[]{nNew, nModified}), false);
        }
    }

    private void console() throws ScriptException {
        switch (this.getToken((int)1).tok) {
            case 1073742334: {
                if (this.chk) break;
                this.vwr.showConsole(false);
                break;
            }
            case 1073742335: {
                if (this.chk) break;
                this.vwr.showConsole(true);
                break;
            }
            case 1073741882: {
                if (this.chk) break;
                this.vwr.sm.clearConsole();
                break;
            }
            case 134221856: {
                this.showString(this.stringParameter(2));
                break;
            }
            default: {
                this.invArg();
            }
        }
    }

    private void data() throws ScriptException {
        int userType;
        boolean isDefault;
        ScriptEval eval = this.e;
        String dataString = null;
        String dataLabel = null;
        boolean isOneValue = false;
        eval.iToken = this.slen;
        switch (eval.iToken) {
            case 5: {
                dataString = this.paramAsStr(2);
            }
            case 2: 
            case 4: {
                dataLabel = this.paramAsStr(1);
                if (dataLabel.equalsIgnoreCase("clear")) {
                    if (!this.chk) {
                        this.vwr.setData(null, null, 0, 0, 0, 0, 0);
                    }
                    return;
                }
                int i = dataLabel.indexOf("@");
                if (i >= 0) {
                    dataString = "" + eval.getParameter(dataLabel.substring(i + 1), 4, true);
                    dataLabel = dataLabel.substring(0, i).trim();
                    break;
                }
                if (dataString != null || (i = dataLabel.indexOf(" ")) < 0) break;
                dataString = dataLabel.substring(i + 1).trim();
                dataLabel = dataLabel.substring(0, i).trim();
                isOneValue = true;
                break;
            }
            default: {
                eval.bad();
            }
        }
        String dataType = dataLabel.substring(0, (dataLabel + " ").indexOf(" ")).toLowerCase();
        if (dataType.equals("model") || dataType.equals("append")) {
            eval.cmdLoad();
            return;
        }
        if (this.chk) {
            return;
        }
        boolean bl = isDefault = dataLabel.toLowerCase().indexOf("(default)") >= 0;
        if (dataType.equals("connect_atoms")) {
            this.vwr.ms.connect((float[][])this.parseDataArray(dataString, false));
            return;
        }
        if (dataType.indexOf("ligand_") == 0) {
            this.vwr.setLigandModel(dataLabel.substring(7).toUpperCase() + "_data", dataString.trim());
            return;
        }
        if (dataType.indexOf("file_") == 0) {
            this.vwr.setLigandModel(dataLabel.substring(5) + "_file", dataString.trim());
            return;
        }
        Object[] d = new Object[4];
        if (dataType.equals("element_vdw")) {
            d[0] = dataType;
            d[1] = dataString.replace(';', '\n');
            int n = Elements.elementNumberMax;
            int[] eArray = new int[n + 1];
            for (int ie = 1; ie <= n; ++ie) {
                eArray[ie] = ie;
            }
            d[2] = eArray;
            d[3] = 0;
            this.vwr.setData("element_vdw", d, n, 0, 0, 0, 0);
            return;
        }
        if (dataType.indexOf("data2d_") == 0) {
            d[0] = dataLabel;
            d[1] = this.parseDataArray(dataString, false);
            d[3] = 2;
            this.vwr.setData(dataLabel, d, 0, 0, 0, 0, 0);
            return;
        }
        if (dataType.indexOf("data3d_") == 0) {
            d[0] = dataLabel;
            d[1] = this.parseDataArray(dataString, true);
            d[3] = 3;
            this.vwr.setData(dataLabel, d, 0, 0, 0, 0, 0);
            return;
        }
        String[] tokens = PT.getTokens(dataLabel);
        if (!(dataType.indexOf("property_") != 0 || tokens.length == 2 && tokens[1].equals("set"))) {
            int propertyFieldColumnCount;
            BS bs = this.vwr.bsA();
            d[0] = dataType;
            int atomNumberField = isOneValue ? 0 : (Integer)this.vwr.getP("propertyAtomNumberField");
            int atomNumberFieldColumnCount = isOneValue ? 0 : (Integer)this.vwr.getP("propertyAtomNumberColumnCount");
            int propertyField = isOneValue ? Integer.MIN_VALUE : (Integer)this.vwr.getP("propertyDataField");
            int n = propertyFieldColumnCount = isOneValue ? 0 : (Integer)this.vwr.getP("propertyDataColumnCount");
            if (!isOneValue && dataLabel.indexOf(" ") >= 0) {
                if (tokens.length == 3) {
                    dataLabel = tokens[0];
                    atomNumberField = PT.parseInt(tokens[1]);
                    propertyField = PT.parseInt(tokens[2]);
                }
                if (tokens.length == 5) {
                    dataLabel = tokens[0];
                    atomNumberField = PT.parseInt(tokens[1]);
                    atomNumberFieldColumnCount = PT.parseInt(tokens[2]);
                    propertyField = PT.parseInt(tokens[3]);
                    propertyFieldColumnCount = PT.parseInt(tokens[4]);
                }
            }
            if (atomNumberField < 0) {
                atomNumberField = 0;
            }
            if (propertyField < 0) {
                propertyField = 0;
            }
            int ac = this.vwr.ms.ac;
            int[] atomMap = null;
            BS bsTemp = BS.newN(ac);
            if (atomNumberField > 0) {
                int j;
                atomMap = new int[ac + 2];
                for (j = 0; j <= ac; ++j) {
                    atomMap[j] = -1;
                }
                j = bs.nextSetBit(0);
                while (j >= 0) {
                    int atomNo = this.vwr.ms.at[j].getAtomNumber();
                    if (atomNo <= ac + 1 && atomNo >= 0 && !bsTemp.get(atomNo)) {
                        bsTemp.set(atomNo);
                        atomMap[atomNo] = j;
                    }
                    j = bs.nextSetBit(j + 1);
                }
                d[2] = atomMap;
            } else {
                d[2] = BSUtil.copy(bs);
            }
            d[1] = dataString;
            d[3] = 0;
            this.vwr.setData(dataType, d, ac, atomNumberField, atomNumberFieldColumnCount, propertyField, propertyFieldColumnCount);
            return;
        }
        if ("occupany".equals(dataType)) {
            dataType = "occupancy";
        }
        if ((userType = AtomCollection.getUserSettableType(dataType)) > -1) {
            this.vwr.setAtomData(userType, dataType, dataString, isDefault);
            return;
        }
        d[0] = dataLabel;
        d[1] = dataString;
        d[3] = 0;
        this.vwr.setData(dataType, d, 0, 0, 0, 0, 0);
    }

    private void ellipsoid() throws ScriptException {
        ScriptEval eval = this.e;
        int mad = 0;
        int i = 1;
        float translucentLevel = Float.MAX_VALUE;
        boolean checkMore = false;
        boolean isSet = false;
        this.setShapeProperty(20, "thisID", null);
        switch (this.getToken((int)1).tok) {
            case 1073742335: {
                mad = Integer.MAX_VALUE;
                break;
            }
            case 1073742334: {
                break;
            }
            case 2: {
                mad = this.intParameter(1);
                break;
            }
            case 36867: {
                this.e.sm.loadShape(20);
                this.setShapeProperty(20, "select", this.paramAsStr(2));
                i = eval.iToken;
                checkMore = true;
                isSet = true;
                break;
            }
            case 0x10001601: 
            case 0x40000000: 
            case 1073741974: {
                this.e.sm.loadShape(20);
                if (eval.theTok == 1073741974) {
                    ++i;
                }
                this.setShapeId(20, i, false);
                i = eval.iToken;
                checkMore = true;
                break;
            }
            default: {
                this.invArg();
            }
        }
        if (!checkMore) {
            eval.setShapeSizeBs(20, mad, null);
            return;
        }
        int[] colorArgb = new int[]{Integer.MIN_VALUE};
        block40: while (++i < this.slen) {
            String key = this.paramAsStr(i);
            Object[] value = null;
            this.getToken(i);
            if (!isSet) {
                switch (eval.theTok) {
                    case 1073742330: {
                        key = "points";
                        Object[] data = new Object[3];
                        data[0] = eval.objectNameParameter(++i);
                        if (this.chk) continue block40;
                        eval.getShapePropertyData(24, "getVertices", data);
                        value = data;
                        break;
                    }
                    case 1825200146: {
                        value = this.e.optParameterAsString(++i);
                        if (((String)value).length() != 0) break;
                        continue block40;
                    }
                    case 1611272194: {
                        V3[] axes = new V3[3];
                        Lst<Object> l = null;
                        block15 : switch (this.getToken((int)(i + 1)).tok) {
                            case 11: {
                                ++i;
                                M3 m = (M3)eval.theToken.value;
                                int im = 3;
                                while (--im >= 0) {
                                    axes[im] = new V3();
                                    m.getColumnV(im, axes[im]);
                                }
                                break;
                            }
                            case 1073742195: {
                                i += 2;
                            }
                            case 0x10000800: {
                                l = new Lst();
                                int i1 = 3;
                                while (--i1 >= 0) {
                                    switch (this.tokAt(++i)) {
                                        case 0x10000800: {
                                            break;
                                        }
                                        default: {
                                            if (eval.isCenterParameter(i)) {
                                                l.addLast(SV.newV(8, this.centerParameter(i)));
                                                break;
                                            }
                                            if (this.tokAt(i) == 0x10000800) break;
                                            l.addLast((SV)this.getToken(i));
                                        }
                                    }
                                    i = eval.iToken;
                                }
                                if (this.getToken((int)(++i)).tok == 0x10000801) break;
                                this.invArg();
                                break;
                            }
                            case 7: {
                                l = ((SV)eval.theToken).getList();
                                switch (l.size()) {
                                    case 1: {
                                        Lst<SV> l1 = new Lst<SV>();
                                        int il = 3;
                                        while (--il >= 0) {
                                            l1.addLast((SV)this.getToken(++i));
                                        }
                                        l = l1;
                                        break block15;
                                    }
                                    case 3: {
                                        break block15;
                                    }
                                }
                                this.invArg();
                                break;
                            }
                            default: {
                                for (int j = 0; j < 3; ++j) {
                                    axes[j] = new V3();
                                    axes[j].setT(this.centerParameter(++i));
                                    i = eval.iToken;
                                }
                            }
                        }
                        if (l != null) {
                            int k = 3;
                            while (--k >= 0) {
                                SV v = (SV)l.get(k);
                                switch (v.tok) {
                                    case 7: {
                                        axes[k] = V3.new3(SV.fValue((T)v.getList().get(0)), SV.fValue((T)v.getList().get(1)), SV.fValue((T)v.getList().get(2)));
                                        break;
                                    }
                                    case 8: {
                                        axes[k] = V3.newV((T3)v.value);
                                    }
                                }
                            }
                        }
                        i = eval.iToken;
                        value = axes;
                        break;
                    }
                    case 12289: {
                        value = this.centerParameter(++i);
                        i = eval.iToken;
                        break;
                    }
                    case 1094713359: {
                        value = this.intParameter(++i);
                        break;
                    }
                    case 12291: {
                        value = Boolean.TRUE;
                        this.checkLength(i + 1);
                    }
                }
            }
            if (value == null) {
                switch (eval.theTok) {
                    case 1073742335: {
                        key = "on";
                        value = Boolean.TRUE;
                        break;
                    }
                    case 1073742334: {
                        key = "on";
                        value = Boolean.FALSE;
                        break;
                    }
                    case 536875059: {
                        if (this.isFloatParameter(i + 1)) {
                            value = Float.valueOf(this.floatParameter(++i));
                        } else if (eval.isCenterParameter(i)) {
                            P3 p = this.centerParameter(i);
                            value = new float[]{p.x, p.y, p.z};
                        } else {
                            value = eval.floatParameterSet(++i, 3, 3);
                        }
                        i = eval.iToken;
                        break;
                    }
                    case 10: 
                    case 12290: 
                    case 1073742325: {
                        key = "atoms";
                        value = this.atomExpressionAt(i);
                        i = eval.iToken;
                        break;
                    }
                    case 1073742074: 
                    case 1111490588: 
                    case 1765808134: {
                        translucentLevel = this.getColorTrans(eval, i, true, colorArgb);
                        i = eval.iToken;
                        continue block40;
                    }
                    case 1073742075: {
                        value = this.paramAsStr(++i);
                    }
                }
            }
            if (value == null) {
                this.invArg();
            }
            this.setShapeProperty(20, key.toLowerCase(), value);
        }
        this.finalizeObject(20, colorArgb[0], translucentLevel, 0, false, null, 0, null);
        this.setShapeProperty(20, "thisID", null);
    }

    private void image() throws ScriptException {
        if (!this.chk) {
            this.vwr.getConsole();
        }
        int pt = 1;
        String id = null;
        if (this.tokAt(1) == 1073741974) {
            id = this.e.optParameterAsString(++pt);
            ++pt;
        }
        String fileName = this.e.optParameterAsString(pt);
        boolean isClose = this.e.optParameterAsString(this.slen - 1).equalsIgnoreCase("close");
        if (!(isClose || this.slen != pt && this.slen != pt + 2)) {
            int width = this.slen == pt + 2 ? this.intParameter(pt++) : -1;
            int height = width < 0 ? -1 : this.intParameter(pt);
            Hashtable<String, Object> params = new Hashtable<String, Object>();
            params.put("fileName", "\u0001\u0001" + id);
            params.put("backgroundColor", this.vwr.getBackgroundArgb());
            params.put("type", "png");
            params.put("quality", -1);
            params.put("width", width);
            params.put("height", height);
            if (!this.chk) {
                this.vwr.processWriteOrCapture(params);
            }
            return;
        }
        ++pt;
        if (isClose) {
            switch (this.slen) {
                case 2: {
                    fileName = "closeall";
                    break;
                }
                case 3: 
                case 4: {
                    break;
                }
                default: {
                    this.checkLength(0);
                }
            }
        }
        if (!this.chk) {
            this.vwr.fm.loadImage(isClose ? "\u0001close" : fileName, "\u0001" + fileName + "\u0001" + ("".equals(id) || id == null ? null : id), false);
        }
    }

    private void invertSelected() throws ScriptException {
        ScriptEval e = this.e;
        P3 pt = null;
        P4 plane = null;
        BS bs = null;
        int iAtom = Integer.MIN_VALUE;
        int ipt = 1;
        switch (this.tokAt(1)) {
            case 0: {
                if (this.chk) {
                    return;
                }
                bs = this.vwr.bsA();
                pt = this.vwr.ms.getAtomSetCenter(bs);
                this.vwr.invertAtomCoord(pt, null, bs, -1, false);
                return;
            }
            case 528443: 
            case 1153433601: {
                ++ipt;
            }
            case 10: 
            case 12290: 
            case 1073742325: {
                bs = this.atomExpressionAt(ipt);
                if (!e.isAtomExpression(e.iToken + 1)) {
                    e.checkLengthErrorPt(e.iToken + 1, e.iToken + 1);
                    if (!this.chk) {
                        int i = bs.nextSetBit(0);
                        while (i >= 0) {
                            this.vwr.invertAtomCoord(null, null, bs, i, false);
                            i = bs.nextSetBit(i + 1);
                        }
                    }
                    return;
                }
                iAtom = bs.nextSetBit(0);
                bs = this.atomExpressionAt(e.iToken + 1);
                break;
            }
            case 134217751: {
                pt = e.centerParameter(2, null);
                break;
            }
            case 134217750: {
                plane = e.planeParameter(1, false);
                break;
            }
            case 0x8000801: {
                plane = e.hklParameter(2, null, true);
            }
        }
        e.checkLengthErrorPt(e.iToken + 1, 1);
        if (plane == null && pt == null && iAtom == Integer.MIN_VALUE) {
            this.invArg();
        }
        if (this.chk) {
            return;
        }
        if (iAtom == -1) {
            return;
        }
        this.vwr.invertSelected(pt, plane, iAtom, bs);
    }

    private void mapProperty() throws ScriptException {
        block21: {
            String mapKey;
            String property1;
            String property2;
            BS bsTo;
            BS bsFrom;
            ScriptEval e;
            int tokKey;
            int tokProp2;
            int tokProp1;
            block20: {
                block19: {
                    tokProp1 = 0;
                    tokProp2 = 0;
                    tokKey = 0;
                    e = this.e;
                    if (this.tokAt(1) != 1113589787) break block19;
                    bsFrom = this.vwr.bsA();
                    bsTo = this.atomExpressionAt(2);
                    property2 = "selected";
                    property1 = "selected";
                    break block20;
                }
                bsFrom = this.atomExpressionAt(1);
                if (this.tokAt(++e.iToken) != 0x40000200 || !T.tokAttr(tokProp1 = this.tokAt(++e.iToken), 0x40400000)) break block21;
                property1 = this.paramAsStr(e.iToken);
                bsTo = this.atomExpressionAt(++e.iToken);
                if (this.tokAt(++e.iToken) != 0x40000200 || !T.tokAttr(tokProp2 = this.tokAt(++e.iToken), 2048)) break block21;
                property2 = this.paramAsStr(e.iToken);
            }
            tokKey = this.tokAt(e.iToken + 1);
            if (T.tokAttr(tokKey, 0x40400000)) {
                mapKey = this.paramAsStr(++e.iToken);
            } else {
                tokKey = 1094715393;
                mapKey = T.nameOf(1094715393);
            }
            e.checkLast(e.iToken);
            if (this.chk) {
                return;
            }
            BS bsOut = null;
            this.showString("mapping " + property1.toUpperCase() + " for " + bsFrom.cardinality() + " atoms to " + property2.toUpperCase() + " for " + bsTo.cardinality() + " atoms using " + mapKey.toUpperCase());
            if (T.tokAttrOr(tokProp1, 0x41400000, 0x42400000) && T.tokAttrOr(tokProp2, 0x41400000, 0x42400000) && T.tokAttrOr(tokKey, 0x41400000, 0x42400000)) {
                float[] data1 = this.getBitsetPropertyFloat(bsFrom, tokProp1 | 0xE0, null, Float.NaN, Float.NaN);
                float[] data2 = this.getBitsetPropertyFloat(bsFrom, tokKey | 0xE0, null, Float.NaN, Float.NaN);
                float[] data3 = this.getBitsetPropertyFloat(bsTo, tokKey | 0xE0, null, Float.NaN, Float.NaN);
                boolean isProperty = tokProp2 == 1715472409;
                float[] dataOut = new float[isProperty ? this.vwr.ms.ac : data3.length];
                bsOut = new BS();
                if (data1.length == data2.length) {
                    Hashtable<Float, Float> ht = new Hashtable<Float, Float>();
                    for (int i = 0; i < data1.length; ++i) {
                        ht.put(Float.valueOf(data2[i]), Float.valueOf(data1[i]));
                    }
                    int pt = -1;
                    int nOut = 0;
                    for (int i = 0; i < data3.length; ++i) {
                        pt = bsTo.nextSetBit(pt + 1);
                        Float F = (Float)ht.get(Float.valueOf(data3[i]));
                        if (F == null) continue;
                        bsOut.set(pt);
                        dataOut[isProperty ? pt : nOut] = F.floatValue();
                        ++nOut;
                    }
                    if (isProperty) {
                        this.vwr.setData(property2, new Object[]{property2, dataOut, bsOut, 1, Boolean.TRUE}, this.vwr.ms.ac, 0, 0, Integer.MAX_VALUE, 0);
                    } else if (!T.tokAttr(tokProp2, 2048)) {
                        this.error(56);
                    } else {
                        this.vwr.setAtomProperty(bsOut, tokProp2, 0, 0.0f, null, dataOut, null);
                    }
                }
            }
            if (bsOut == null) {
                String format = "{" + mapKey + "=%[" + mapKey + "]}." + property2 + " = %[" + property1 + "]";
                String[] data = (String[])this.getBitsetIdent(bsFrom, format, null, false, Integer.MAX_VALUE, false);
                SB sb = new SB();
                for (int i = 0; i < data.length; ++i) {
                    if (data[i].indexOf("null") >= 0) continue;
                    sb.append(data[i]).appendC('\n');
                }
                if (Logger.debugging) {
                    Logger.debug(sb.toString());
                }
                BS bsSubset = BSUtil.copy(this.vwr.slm.bsSubset);
                this.vwr.slm.setSelectionSubset(bsTo);
                try {
                    e.runScript(sb.toString());
                }
                catch (Exception ex) {
                    this.vwr.slm.setSelectionSubset(bsSubset);
                    e.errorStr(-1, "Error: " + ex.getMessage());
                }
                catch (Error er) {
                    this.vwr.slm.setSelectionSubset(bsSubset);
                    e.errorStr(-1, "Error: " + er.toString());
                }
                this.vwr.slm.setSelectionSubset(bsSubset);
            }
            this.showString("DONE");
            return;
        }
        this.invArg();
    }

    private void minimize(boolean isModelkit) throws ScriptException {
        int i;
        BS bsSelected = null;
        int steps = Integer.MAX_VALUE;
        float crit = 0.0f;
        boolean addHydrogen = false;
        boolean isSilent = false;
        BS bsFixed = null;
        boolean selectedOnly = false;
        boolean groupOnly = false;
        Minimizer minimizer = this.vwr.getMinimizer(false);
        float range = 0.0f;
        int n = i = isModelkit ? 2 : 1;
        while (i < this.slen) {
            switch (this.getToken((int)i).tok) {
                case 1073741905: {
                    crit = this.floatParameter(++i);
                    break;
                }
                case 1073742114: {
                    range = this.floatParameter(++i);
                    break;
                }
                case 1073741935: {
                    steps = 0;
                    break;
                }
                case 1073741874: 
                case 1073742162: {
                    this.checkLength(2);
                    if (this.chk || minimizer == null) {
                        return;
                    }
                    minimizer.setProperty(this.paramAsStr(i), null);
                    return;
                }
                case 1073741882: {
                    this.checkLength(2);
                    if (this.chk || minimizer == null) {
                        return;
                    }
                    minimizer.setProperty("clear", null);
                    return;
                }
                case 0x40000046: {
                    if (i != 1) {
                        this.invArg();
                    }
                    int n2 = 0;
                    float targetValue = 0.0f;
                    int[] aList = new int[5];
                    if (this.tokAt(++i) == 1073741882) {
                        this.checkLength(3);
                    } else {
                        while (n2 < 4 && !this.isFloatParameter(i)) {
                            aList[++n2] = this.atomExpressionAt(i).nextSetBit(0);
                            i = this.e.iToken + 1;
                        }
                        aList[0] = n2;
                        if (n2 == 1) {
                            this.invArg();
                        }
                        targetValue = this.floatParameter(this.e.checkLast(i));
                    }
                    if (!this.chk) {
                        this.vwr.getMinimizer(true).setProperty("constraint", new Object[]{aList, Float.valueOf(targetValue)});
                    }
                    return;
                }
                case 12293: {
                    if (i != 1) {
                        this.invArg();
                    }
                    if (this.slen == ++i) {
                        if (!this.chk) {
                            BS bs = (BS)this.vwr.getMinimizer(true).getProperty("fixed", 0);
                            if (bs == null) {
                                this.e.showString("no atoms are fixed for minimization");
                            } else {
                                int n3 = bs.cardinality();
                                this.e.showString(n3 + (n3 == 1 ? " atom is" : " atoms are") + " fixed for minimization: " + bs + "\nunfix them with MINIMIZE FIX NONE");
                            }
                        }
                        return;
                    }
                    bsFixed = this.atomExpressionAt(i);
                    if (bsFixed.nextSetBit(0) < 0) {
                        bsFixed = null;
                    }
                    i = this.e.iToken;
                    if (!this.chk) {
                        this.vwr.getMinimizer(true).setProperty("fixed", bsFixed);
                    }
                    if (i + 1 != this.slen) break;
                    return;
                }
                case 0x40000004: {
                    addHydrogen = true;
                    break;
                }
                case 1073742072: 
                case 1113589787: {
                    selectedOnly = true;
                    break;
                }
                case 1086324742: {
                    groupOnly = true;
                    break;
                }
                case 0x40000144: {
                    isSilent = true;
                    break;
                }
                case 266298: {
                    steps = this.intParameter(++i);
                    break;
                }
                case 10: 
                case 1073742325: {
                    selectedOnly = true;
                }
                case 1275082241: {
                    if (this.e.theTok == 1275082241) {
                        ++i;
                    }
                    bsSelected = this.atomExpressionAt(i);
                    i = this.e.iToken;
                    if (this.tokAt(i + 1) != 1073742072) break;
                    ++i;
                    selectedOnly = true;
                    break;
                }
                default: {
                    this.invArg();
                }
            }
            ++i;
        }
        if (isModelkit && (addHydrogen || selectedOnly || groupOnly)) {
            this.invArg();
        }
        if (!this.chk) {
            try {
                this.vwr.minimize(this.e, steps, crit, bsSelected, bsFixed, null, range, (addHydrogen ? 16 : 0) | (isModelkit ? 256 : 0) | (selectedOnly ? 32 : 0) | (groupOnly ? 64 : 0) | (isSilent ? 1 : 0));
            }
            catch (Exception e1) {
                throw new ScriptInterruption(this.e, "minimize", 1);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private void modulation() throws ScriptException {
        qtOffset = null;
        eval = this.e;
        mod = true;
        isQ = false;
        bs = null;
        i = 1;
        switch (this.getToken((int)i).tok) {
            case 1073742334: {
                mod = false;
            }
            case 0: 
            case 1073742335: {
                break;
            }
            case 10: 
            case 12290: 
            case 1073742325: {
                bs = this.atomExpressionAt(1);
                switch (this.tokAt(eval.iToken + 1)) {
                    case 0: {
                        break;
                    }
                    case 1073742334: {
                        mod = false;
                    }
                    case 1073742335: {
                        ++eval.iToken;
                    }
                }
                eval.checkLast(eval.iToken);
                break;
            }
            case 8: 
            case 1073742332: {
                qtOffset = eval.getPoint3f(1, false, true);
                isQ = this.tokAt(eval.iToken + 1) == 1073742335;
                break;
            }
            default: {
                s = eval.theToken.value.toString();
                ++i;
                if (!s.equalsIgnoreCase("t")) ** GOTO lbl34
                eval.theTok = 3;
                ** GOTO lbl38
lbl34:
                // 1 sources

                if (s.equalsIgnoreCase("m") || s.equalsIgnoreCase("q")) {
                    eval.theTok = 2;
                } else {
                    this.invArg();
                }
            }
lbl38:
            // 4 sources

            case 2: 
            case 3: {
                switch (eval.theTok) {
                    case 3: {
                        if (this.isFloatParameter(i)) {
                            t1 = this.floatParameter(i);
                            qtOffset = P3.new3(t1, t1, t1);
                            break;
                        }
                        qtOffset = eval.getPoint3f(i, false, true);
                        break;
                    }
                    case 2: {
                        if (this.tokAt(i) == 2) {
                            t = this.intParameter(i);
                            qtOffset = P3.new3(t, t, t);
                        } else {
                            qtOffset = eval.getPoint3f(i, false, true);
                        }
                        isQ = true;
                    }
                }
                break;
            }
            case 536875059: {
                scale = this.floatParameter(2);
                if (!this.chk) {
                    this.vwr.setFloatProperty("modulationScale", scale);
                }
                return;
            }
        }
        if (!this.chk) {
            this.vwr.tm.setVibrationPeriod(0.0f);
            this.vwr.setModulation(bs, mod, qtOffset, isQ);
        }
    }

    private void mutate() throws ScriptException {
        String[] list;
        boolean isFile;
        BS bs;
        int i = this.e.iToken;
        String alphaType = null;
        String sequence = null;
        float[] phipsi = null;
        boolean isCreate = false;
        block0 : switch (this.tokAt(++i)) {
            case 0x40000050: {
                alphaType = "alpha";
                isCreate = true;
                bs = null;
                switch (this.tokAt(++i)) {
                    case 0: {
                        this.invArg();
                        break block0;
                    }
                }
                sequence = this.e.paramAsStr(i);
                i = this.e.iToken;
                switch (this.tokAt(i + 1)) {
                    case 0: {
                        break block0;
                    }
                    case 7: 
                    case 0x10000800: 
                    case 1073742195: {
                        alphaType = null;
                        phipsi = this.e.floatParameterSet(++i, 2, Integer.MAX_VALUE);
                        if (phipsi.length % 2 == 1) {
                            this.invArg();
                        }
                        i = this.e.iToken;
                        break block0;
                    }
                }
                alphaType = this.e.paramAsStr(++i);
                i = this.e.iToken;
                break;
            }
            case 2: {
                this.st[1] = T.o(4, "" + this.st[1].value);
            }
            default: {
                bs = this.atomExpressionAt(i);
                i = ++this.e.iToken;
                break;
            }
            case 0x10001601: {
                bs = this.vwr.getFrameAtoms();
                i = ++this.e.iToken;
            }
        }
        if (!this.chk && bs != null) {
            short imodel;
            bs.and(this.vwr.getFrameAtoms());
            int iatom = bs.nextSetBit(0);
            if (iatom < 0) {
                this.invArg();
            }
            if (this.vwr.ms.isTrajectory(imodel = this.vwr.ms.at[iatom].mi) || !this.vwr.ms.am[imodel].isBioModel) {
                return;
            }
        }
        if (sequence == null) {
            sequence = this.e.optParameterAsString(i);
        }
        this.e.checkLast(i);
        if (this.chk) {
            return;
        }
        boolean isOneLetter = sequence.startsWith("~");
        boolean bl = isFile = !isOneLetter && !isCreate && (sequence.indexOf(".") >= 0 || sequence.indexOf("-") < 0 && sequence.length() > 3 && sequence.startsWith("=="));
        if (isFile) {
            list = new String[]{sequence};
            sequence = null;
        } else {
            sequence = PT.replaceAllCharacters(sequence, ",; \t\n", " ").trim().toUpperCase();
            if (!isOneLetter && sequence.indexOf("-") >= 0) {
                list = PT.split(sequence, "-");
            } else {
                if (isOneLetter || sequence.length() != 3 || !this.vwr.getJBR().isKnownPDBGroup(sequence, 20)) {
                    sequence = this.vwr.getJBR().toStdAmino3(isOneLetter ? sequence.substring(1) : sequence);
                }
                list = PT.getTokens(sequence);
            }
        }
        this.e.iToken = this.e.slen;
        if (list.length > 0 && !this.vwr.getJBR().getBioModelSet(this.vwr.ms).mutate(bs, sequence, list, alphaType, phipsi)) {
            this.invArg();
        }
    }

    private void navigate() throws ScriptException {
        ScriptEval eval = this.e;
        if (this.slen == 1) {
            eval.setBooleanProperty("navigationMode", true);
            return;
        }
        V3 rotAxis = V3.new3(0.0f, 1.0f, 0.0f);
        Lst<Object[]> list = new Lst<Object[]>();
        if (this.slen == 2) {
            switch (this.getToken((int)1).tok) {
                case 1073742334: 
                case 1073742335: {
                    if (this.chk) {
                        return;
                    }
                    eval.setObjectMad10(34, "axes", 10);
                    this.setShapeProperty(34, "position", P3.new3(50.0f, 50.0f, Float.MAX_VALUE));
                    eval.setBooleanProperty("navigationMode", true);
                    this.vwr.tm.setNavOn(eval.theTok == 1073742335);
                    return;
                }
                case 1073742162: {
                    if (!this.chk) {
                        this.vwr.tm.setNavXYZ(0.0f, 0.0f, 0.0f);
                    }
                    return;
                }
                case 8: 
                case 1112152078: {
                    break;
                }
                default: {
                    this.invArg();
                }
            }
        }
        if (!this.chk && !this.vwr.getBoolean(603979889)) {
            eval.setBooleanProperty("navigationMode", true);
        }
        block26: for (int i = 1; i < this.slen; ++i) {
            float timeSec;
            float f = timeSec = this.isFloatParameter(i) ? this.floatParameter(i++) : 2.0f;
            if (timeSec < 0.0f) {
                this.invArg();
            }
            if (!this.chk && timeSec > 0.0f) {
                eval.refresh(false);
            }
            switch (this.getToken((int)i).tok) {
                case 8: 
                case 1073742332: {
                    P3 pt = this.getPoint3f(i, true);
                    ++eval.iToken;
                    if (eval.iToken != this.slen) {
                        this.invArg();
                    }
                    if (!this.chk) {
                        this.vwr.tm.setNavXYZ(pt.x, pt.y, pt.z);
                    }
                    return;
                }
                case 554176526: {
                    float depth = this.floatParameter(++i);
                    if (this.chk) continue block26;
                    list.addLast(new Object[]{554176526, Float.valueOf(timeSec), Float.valueOf(depth)});
                    continue block26;
                }
                case 12289: {
                    P3 pt = this.centerParameter(++i);
                    i = eval.iToken;
                    if (this.chk) continue block26;
                    list.addLast(new Object[]{134217751, Float.valueOf(timeSec), pt});
                    continue block26;
                }
                case 528432: {
                    switch (this.getToken((int)(++i)).tok) {
                        case 1111492629: {
                            rotAxis.set(1.0f, 0.0f, 0.0f);
                            ++i;
                            break;
                        }
                        case 1111492630: {
                            rotAxis.set(0.0f, 1.0f, 0.0f);
                            ++i;
                            break;
                        }
                        case 1111492631: {
                            rotAxis.set(0.0f, 0.0f, 1.0f);
                            ++i;
                            break;
                        }
                        case 8: 
                        case 1073742332: {
                            rotAxis.setT(this.getPoint3f(i, true));
                            i = eval.iToken + 1;
                            break;
                        }
                        case 0x40000000: {
                            this.invArg();
                        }
                    }
                    float degrees = this.floatParameter(i);
                    if (this.chk) continue block26;
                    list.addLast(new Object[]{528432, Float.valueOf(timeSec), rotAxis, Float.valueOf(degrees)});
                    continue block26;
                }
                case 4160: {
                    P3 pt;
                    float x = Float.NaN;
                    float y = Float.NaN;
                    if (this.isFloatParameter(++i)) {
                        x = this.floatParameter(i);
                        y = this.floatParameter(++i);
                    } else {
                        switch (this.tokAt(i)) {
                            case 1111492629: {
                                x = this.floatParameter(++i);
                                break;
                            }
                            case 1111492630: {
                                y = this.floatParameter(++i);
                                break;
                            }
                            default: {
                                pt = this.centerParameter(i);
                                i = eval.iToken;
                                if (this.chk) continue block26;
                                list.addLast(new Object[]{4160, Float.valueOf(timeSec), pt});
                                continue block26;
                            }
                        }
                    }
                    if (this.chk) continue block26;
                    list.addLast(new Object[]{268441090, Float.valueOf(timeSec), Float.valueOf(x), Float.valueOf(y)});
                    continue block26;
                }
                case 0x10001600: {
                    continue block26;
                }
                case 1112152078: {
                    BS bs;
                    Lst<P3[]> vp = new Lst<P3[]>();
                    if (eval.isAtomExpression(i + 1)) {
                        bs = this.atomExpressionAt(++i);
                        i = eval.iToken;
                    } else {
                        bs = this.vwr.bsA();
                    }
                    if (this.chk) {
                        return;
                    }
                    this.vwr.getPolymerPointsAndVectors(bs, vp);
                    int n = vp.size();
                    if (n <= 0) continue block26;
                    P3[][] pathGuide = new P3[n][];
                    for (int j = 0; j < n; ++j) {
                        pathGuide[j] = (P3[])vp.get(j);
                    }
                    list.addLast(new Object[]{1112152078, Float.valueOf(timeSec), pathGuide});
                    continue block26;
                }
                case 0x40000104: {
                    Object theta = null;
                    if (this.getToken((int)(i + 1)).tok == 1073742330) {
                        ++i;
                        String pathID = eval.objectNameParameter(++i);
                        if (this.chk) {
                            return;
                        }
                        this.setShapeProperty(22, "thisID", pathID);
                        P3[] path = (P3[])this.getShapeProperty(22, "vertices");
                        eval.refresh(false);
                        if (path == null) {
                            this.invArg();
                        }
                        int indexStart = (int)(this.isFloatParameter(i + 1) ? this.floatParameter(++i) : 0.0f);
                        int indexEnd = (int)(this.isFloatParameter(i + 1) ? this.floatParameter(++i) : 2.1474836E9f);
                        list.addLast(new Object[]{0x40000104, Float.valueOf(timeSec), path, theta, new int[]{indexStart, indexEnd}});
                        continue block26;
                    }
                    Lst<P3> v = new Lst<P3>();
                    while (eval.isCenterParameter(i + 1)) {
                        v.addLast(this.centerParameter(++i));
                        i = eval.iToken;
                    }
                    if (v.size() > 0) {
                        P3[] path = v.toArray(new P3[v.size()]);
                        if (this.chk) continue block26;
                        list.addLast(new Object[]{0x40000104, Float.valueOf(timeSec), path, theta, new int[]{0, Integer.MAX_VALUE}});
                        continue block26;
                    }
                }
                default: {
                    this.invArg();
                }
            }
        }
        if (!(this.chk || this.vwr.isJmolDataFrame() || this.vwr.is2D())) {
            this.vwr.tm.navigateList(eval, list);
        }
    }

    private String plot(T[] args) throws ScriptException {
        String script;
        String data;
        int ptDataFrame;
        ScriptEval e = this.e;
        int modelIndex = this.vwr.am.cmi;
        if (modelIndex < 0) {
            e.errorStr(30, "plot");
        }
        modelIndex = this.vwr.ms.getJmolDataSourceFrame(modelIndex);
        int pt = args.length - 1;
        boolean isReturnOnly = args != this.st;
        boolean pdbFormat = true;
        T[] statementSave = this.st;
        if (isReturnOnly) {
            this.st = args;
            e.st = args;
        }
        int tokCmd = isReturnOnly ? 134222350 : args[0].tok;
        int pt0 = isReturnOnly || tokCmd == 134221850 || tokCmd == 4138 ? 0 : 1;
        String filename = null;
        boolean makeNewFrame = true;
        boolean isDraw = false;
        switch (tokCmd) {
            case 4133: 
            case 4138: 
            case 134221850: {
                break;
            }
            case 135176: {
                makeNewFrame = false;
                isDraw = true;
                break;
            }
            case 134222350: {
                makeNewFrame = false;
                pdbFormat = false;
                break;
            }
            case 134221856: {
                makeNewFrame = false;
                if (CmdExt.tokAtArray(pt, args) == 4) {
                    filename = this.stringParameter(pt--);
                } else if (CmdExt.tokAtArray(pt - 1, args) == 0x40000200) {
                    filename = this.paramAsStr(pt - 2) + "." + this.paramAsStr(pt);
                    pt -= 3;
                } else {
                    this.st = statementSave;
                    e.st = statementSave;
                    e.iToken = this.st.length;
                    this.error(13);
                }
                e.slen = this.slen = pt + 1;
            }
        }
        String qFrame = "";
        Object[] parameters = null;
        String stateScript = "";
        boolean isQuaternion = false;
        boolean isDerivative = false;
        boolean isSecondDerivative = false;
        boolean isRamachandranRelative = false;
        String[] props = new String[3];
        int[] propToks = new int[3];
        BS bs = BSUtil.copy(this.vwr.bsA());
        String preSelected = "; select " + Escape.eBS(bs) + ";\n ";
        String type = e.optParameterAsString(pt).toLowerCase();
        P3 minXYZ = null;
        P3 maxXYZ = null;
        String format = null;
        int tok = CmdExt.tokAtArray(pt0, args);
        if (tok == 4) {
            tok = T.getTokFromName((String)args[pt0].value);
        }
        switch (tok) {
            default: {
                e.iToken = 1;
                this.invArg();
                break;
            }
            case 134221834: {
                e.iToken = 1;
                type = "data";
                preSelected = "";
                break;
            }
            case 1715472409: {
                e.iToken = pt0 + 1;
                block22: for (int i = 0; i < 3; ++i) {
                    switch (this.tokAt(e.iToken)) {
                        case 4: {
                            propToks[i] = T.getTokFromName((String)e.getToken((int)e.iToken).value);
                            break;
                        }
                        default: {
                            propToks[i] = this.tokAt(e.iToken);
                            break;
                        }
                        case 0: {
                            if (i == 0) {
                                this.invArg();
                            }
                        }
                        case 32: 
                        case 64: 
                        case 1287653388: {
                            i = 2;
                            continue block22;
                        }
                    }
                    if (propToks[i] != 1715472409 && !T.tokAttr(propToks[i], 0x40400000)) {
                        this.invArg();
                    }
                    props[i] = this.getToken((int)e.iToken).value.toString();
                    ++e.iToken;
                }
                if (this.tokAt(e.iToken) == 1287653388) {
                    format = this.stringParameter(++e.iToken);
                    pdbFormat = false;
                    ++e.iToken;
                }
                if (this.tokAt(e.iToken) == 32) {
                    minXYZ = this.getPoint3f(++e.iToken, false);
                    ++e.iToken;
                }
                if (this.tokAt(e.iToken) == 64) {
                    maxXYZ = this.getPoint3f(++e.iToken, false);
                    ++e.iToken;
                }
                type = "property " + props[0] + (props[1] == null ? "" : " " + props[1]) + (props[2] == null ? "" : " " + props[2]);
                if (bs.nextSetBit(0) < 0) {
                    bs = this.vwr.getModelUndeletedAtomsBitSet(modelIndex);
                }
                stateScript = "select " + Escape.eBS(bs) + ";\n ";
                break;
            }
            case 4138: {
                if (type.equalsIgnoreCase("draw")) {
                    isDraw = true;
                    type = e.optParameterAsString(--pt).toLowerCase();
                }
                isRamachandranRelative = pt > pt0 && type.startsWith("r");
                type = "ramachandran" + (isRamachandranRelative ? " r" : "") + (tokCmd == 135176 ? " draw" : "");
                break;
            }
            case 134221850: 
            case 136314895: {
                qFrame = " \"" + this.vwr.getQuaternionFrame() + "\"";
                stateScript = "set quaternionFrame" + qFrame + ";\n  ";
                isQuaternion = true;
                if (type.equalsIgnoreCase("draw")) {
                    isDraw = true;
                    type = e.optParameterAsString(--pt).toLowerCase();
                }
                isDerivative = type.startsWith("deriv") || type.startsWith("diff");
                boolean bl = isSecondDerivative = isDerivative && type.indexOf("2") > 0;
                if (isDerivative) {
                    --pt;
                }
                if (type.equalsIgnoreCase("helix") || type.equalsIgnoreCase("axis")) {
                    isDraw = true;
                    isDerivative = true;
                    pt = -1;
                }
                if ((type = ((pt <= pt0 ? "" : e.optParameterAsString(pt)) + "w").substring(0, 1)).equals("a") || type.equals("r")) {
                    isDerivative = true;
                }
                if (!PT.isOneOf(type, ";w;x;y;z;r;a;")) {
                    e.evalError("QUATERNION [w,x,y,z,a,r] [difference][2]", null);
                }
                type = "quaternion " + type + (isDerivative ? " difference" : "") + (isSecondDerivative ? "2" : "") + (isDraw ? " draw" : "");
            }
        }
        this.st = statementSave;
        if (this.chk) {
            return "";
        }
        if (makeNewFrame && (ptDataFrame = this.vwr.ms.getJmolDataFrameIndex(modelIndex, stateScript = stateScript + "plot " + type)) > 0 && tokCmd != 134221856 && tokCmd != 134222350) {
            this.vwr.setCurrentModelIndexClear(ptDataFrame, true);
            return "";
        }
        float[] dataX = null;
        float[] dataY = null;
        float[] dataZ = null;
        String[] propData = new String[3];
        if (tok == 1715472409) {
            dataX = this.getBitsetPropertyFloat(bs, propToks[0] | 0xE0, propToks[0] == 1715472409 ? props[0] : null, minXYZ == null ? Float.NaN : minXYZ.x, maxXYZ == null ? Float.NaN : maxXYZ.x);
            propData[0] = props[0] + " " + Escape.eAF(dataX);
            if (props[1] != null) {
                dataY = this.getBitsetPropertyFloat(bs, propToks[1] | 0xE0, propToks[1] == 1715472409 ? props[1] : null, minXYZ == null ? Float.NaN : minXYZ.y, maxXYZ == null ? Float.NaN : maxXYZ.y);
                propData[1] = props[1] + " " + Escape.eAF(dataY);
            }
            if (props[2] != null) {
                dataZ = this.getBitsetPropertyFloat(bs, propToks[2] | 0xE0, propToks[2] == 1715472409 ? props[2] : null, minXYZ == null ? Float.NaN : minXYZ.z, maxXYZ == null ? Float.NaN : maxXYZ.z);
                propData[2] = props[2] + " " + Escape.eAF(dataZ);
            }
            if (minXYZ == null) {
                minXYZ = P3.new3(this.getPlotMinMax(dataX, false, propToks[0]), this.getPlotMinMax(dataY, false, propToks[1]), this.getPlotMinMax(dataZ, false, propToks[2]));
            }
            if (maxXYZ == null) {
                maxXYZ = P3.new3(this.getPlotMinMax(dataX, true, propToks[0]), this.getPlotMinMax(dataY, true, propToks[1]), this.getPlotMinMax(dataZ, true, propToks[2]));
            }
            Logger.info("plot min/max: " + minXYZ + " " + maxXYZ);
            P3 center = null;
            P3 factors = null;
            if (pdbFormat) {
                int i;
                factors = P3.new3(1.0f, 1.0f, 1.0f);
                center = new P3();
                center.ave(maxXYZ, minXYZ);
                factors.sub2(maxXYZ, minXYZ);
                factors.set(factors.x / 200.0f, factors.y / 200.0f, factors.z / 200.0f);
                if (T.tokAttr(propToks[0], 0x41400000)) {
                    factors.x = 1.0f;
                    center.x = 0.0f;
                } else if ((double)factors.x > 0.1 && factors.x <= 10.0f) {
                    factors.x = 1.0f;
                }
                if (T.tokAttr(propToks[1], 0x41400000)) {
                    factors.y = 1.0f;
                    center.y = 0.0f;
                } else if ((double)factors.y > 0.1 && factors.y <= 10.0f) {
                    factors.y = 1.0f;
                }
                if (T.tokAttr(propToks[2], 0x41400000)) {
                    factors.z = 1.0f;
                    center.z = 0.0f;
                } else if ((double)factors.z > 0.1 && factors.z <= 10.0f) {
                    factors.z = 1.0f;
                }
                if (props[2] == null || props[1] == null) {
                    factors.z = 0.0f;
                    maxXYZ.z = 0.0f;
                    minXYZ.z = 0.0f;
                    center.z = 0.0f;
                }
                for (i = 0; i < dataX.length; ++i) {
                    dataX[i] = (dataX[i] - center.x) / factors.x;
                }
                if (props[1] != null) {
                    for (i = 0; i < dataY.length; ++i) {
                        dataY[i] = (dataY[i] - center.y) / factors.y;
                    }
                }
                if (props[2] != null) {
                    for (i = 0; i < dataZ.length; ++i) {
                        dataZ[i] = (dataZ[i] - center.z) / factors.z;
                    }
                }
            }
            parameters = new Object[]{bs, dataX, dataY, dataZ, minXYZ, maxXYZ, factors, center, format, propData};
        }
        if (tokCmd == 134221856) {
            return this.vwr.writeFileData(filename, "PLOT_" + type, modelIndex, parameters);
        }
        String string = data = type.equals("data") ? "1 0 H 0 0 0 # Jmol PDB-encoded data" : this.vwr.getPdbData(modelIndex, type, null, parameters, null, true);
        if (tokCmd == 134222350) {
            return data;
        }
        if (Logger.debugging) {
            Logger.debug(data);
        }
        if (tokCmd == 135176) {
            e.runScript(data);
            return "";
        }
        String[] savedFileInfo = this.vwr.fm.getFileInfo();
        boolean oldAppendNew = this.vwr.getBoolean(603979792);
        this.vwr.g.appendNew = true;
        boolean isOK = data != null && this.vwr.openStringInlineParamsAppend(data, null, true) == null;
        this.vwr.g.appendNew = oldAppendNew;
        this.vwr.fm.setFileInfo(savedFileInfo);
        if (!isOK) {
            return "";
        }
        int modelCount = this.vwr.ms.mc;
        this.vwr.ms.setJmolDataFrame(stateScript, modelIndex, modelCount - 1);
        if (tok != 1715472409) {
            stateScript = stateScript + ";\n" + preSelected;
        }
        StateScript ss = this.vwr.addStateScript(stateScript, true, false);
        float radius = 150.0f;
        switch (tok) {
            default: {
                script = "frame 0.0; frame last; reset;select visible;wireframe only;";
                radius = 10.0f;
                break;
            }
            case 1715472409: {
                this.vwr.setFrameTitle(modelCount - 1, type + " plot for model " + this.vwr.getModelNumberDotted(modelIndex));
                script = "frame 0.0; frame last; reset;select visible; spacefill 3.0; wireframe 0;draw plotAxisX" + modelCount + " {100 -100 -100} {-100 -100 -100} \"" + props[0] + "\";draw plotAxisY" + modelCount + " {-100 100 -100} {-100 -100 -100} \"" + props[1] + "\";";
                if (props[2] == null) break;
                script = script + "draw plotAxisZ" + modelCount + " {-100 -100 100} {-100 -100 -100} \"" + props[2] + "\";";
                break;
            }
            case 4138: {
                this.vwr.setFrameTitle(modelCount - 1, "ramachandran plot for model " + this.vwr.getModelNumberDotted(modelIndex));
                script = "frame 0.0; frame last; reset;select visible; color structure; spacefill 3.0; wireframe 0;draw ramaAxisX" + modelCount + " {100 0 0} {-100 0 0} \"phi\";draw ramaAxisY" + modelCount + " {0 100 0} {0 -100 0} \"psi\";";
                break;
            }
            case 134221850: 
            case 136314895: {
                this.vwr.setFrameTitle(modelCount - 1, type.replace('w', ' ') + qFrame + " for model " + this.vwr.getModelNumberDotted(modelIndex));
                String color = C.getHexCode(this.vwr.cm.colixBackgroundContrast);
                script = "frame 0.0; frame last; reset;select visible; wireframe 0; spacefill 3.0; isosurface quatSphere" + modelCount + " color " + color + " sphere 100.0 mesh nofill frontonly translucent 0.8;draw quatAxis" + modelCount + "X {100 0 0} {-100 0 0} color red \"x\";draw quatAxis" + modelCount + "Y {0 100 0} {0 -100 0} color green \"y\";draw quatAxis" + modelCount + "Z {0 0 100} {0 0 -100} color blue \"z\";color structure;draw quatCenter" + modelCount + "{0 0 0} scale 0.02;";
            }
        }
        e.runScript(script + preSelected);
        ss.setModelIndex(this.vwr.am.cmi);
        this.vwr.setRotationRadius(radius, true);
        e.sm.loadShape(31);
        this.showString("frame " + this.vwr.getModelNumberDotted(modelCount - 1) + (type.length() > 0 ? " created: " + type + (isQuaternion ? qFrame : "") : ""));
        return "";
    }

    private void polyhedra() throws ScriptException {
        ScriptEval eval = this.e;
        boolean haveBonds = this.slen == 1;
        boolean haveCenter = false;
        boolean needsGenerating = haveBonds;
        boolean onOffDelete = false;
        boolean typeSeen = false;
        boolean edgeParameterSeen = false;
        float scale = Float.NaN;
        int nAtomSets = 0;
        eval.sm.loadShape(21);
        this.setShapeProperty(21, "init", Boolean.TRUE);
        float translucentLevel = Float.MAX_VALUE;
        float radius = -1.0f;
        int[] colorArgb = new int[]{Integer.MIN_VALUE};
        int noToParam = -1;
        int atomPt = -1;
        P3 offset = null;
        float foffset = 0.0f;
        String id = null;
        boolean ok = false;
        boolean modifyOnly = false;
        int[][] faces = null;
        P3[] points = null;
        if (this.slen == 2 && this.tokAt(1) == 1073742001) {
            if (!this.chk) {
                eval.showStringPrint((String)this.getShapeProperty(21, "list"), false);
            }
            return;
        }
        block35: for (int i = 1; i < this.slen; ++i) {
            String propertyName = null;
            Object propertyValue = null;
            switch (this.getToken((int)i).tok) {
                case 1073742197: {
                    scale = Float.NaN;
                }
                case 0x40000030: {
                    int index;
                    int n = this.e.theTok == 1073742197 ? -1 : (index = this.tokAt(i + 1) == 2 ? this.intParameter(++i) : 1);
                    if (!this.chk) {
                        ((BZone)Interface.getInterface("org.jmol.util.BZone", this.vwr, "script")).createBZ(this.vwr, index, null, false, id, scale, foffset, offset);
                    }
                    return;
                }
                case 6: {
                    propertyName = "info";
                    propertyValue = ((SV)this.e.theToken).getMap();
                    needsGenerating = true;
                    break;
                }
                case 134217751: {
                    propertyName = "points";
                    propertyValue = Float.valueOf(this.tokAt(++i) == 1073742334 ? 0.0f : this.e.floatParameter(i));
                    ok = true;
                    break;
                }
                case 536875059: {
                    scale = this.floatParameter(++i);
                    ok = true;
                    continue block35;
                }
                case 1814695966: {
                    if (id != null) {
                        this.invArg();
                    }
                    propertyName = "unitCell";
                    propertyValue = Boolean.TRUE;
                    needsGenerating = true;
                    break;
                }
                case 1073742072: {
                    this.e.restrictSelected(false, false);
                    eval.theTok = 1073742335;
                }
                case 12291: 
                case 1073742334: 
                case 1073742335: {
                    if (i + 1 != this.slen || needsGenerating || nAtomSets > 1) {
                        this.error(18);
                    }
                    propertyName = eval.theTok == 1073742334 ? "off" : (eval.theTok == 1073742335 ? "on" : "delete");
                    onOffDelete = true;
                    break;
                }
                case 7: {
                    if (id == null || needsGenerating) {
                        this.invArg();
                    }
                    needsGenerating = true;
                    faces = this.getIntArray2(i);
                    points = this.getAllPoints(eval.iToken + 1, 3);
                    i = eval.iToken;
                    if (points[0] instanceof Atom) {
                        this.setShapeProperty(21, "model", ((Atom)points[0]).getModelIndex());
                    }
                    propertyName = "definedFaces";
                    propertyValue = new Object[]{faces, points};
                    break;
                }
                case 1073741961: {
                    propertyName = "full";
                    break;
                }
                case 2: {
                    if (id != null) {
                        this.invArg();
                    }
                    propertyName = "nVertices";
                    propertyValue = this.intParameter(i);
                    needsGenerating = true;
                    if (this.tokAt(i + 1) != 0x10000600) break;
                    ++i;
                    break;
                }
                case 1677721602: {
                    if (id != null) {
                        this.invArg();
                    }
                    if (nAtomSets > 0) {
                        this.invPO();
                    }
                    needsGenerating = true;
                    propertyName = "bonds";
                    haveBonds = true;
                    break;
                }
                case 1073741852: {
                    if (radius != -1.0f) {
                        this.invArg();
                    }
                    radius = 0.0f;
                    --i;
                }
                case 1665140738: {
                    ++i;
                }
                case 3: {
                    if (id != null) {
                        this.invArg();
                    }
                    if (nAtomSets > 0) {
                        this.invPO();
                    }
                    propertyName = radius <= 0.0f ? "radius" : "radius1";
                    radius = radius == 0.0f ? 0.0f : this.floatParameter(i);
                    propertyValue = Float.valueOf(radius);
                    needsGenerating = true;
                    break;
                }
                case 1073742066: {
                    if (this.isFloatParameter(i + 1)) {
                        foffset = this.floatParameter(++i);
                    } else {
                        offset = this.e.centerParameter(++i, null);
                        i = eval.iToken;
                    }
                    ok = true;
                    continue block35;
                }
                case 1073741937: {
                    this.setShapeProperty(21, "collapsed", null);
                }
                case 0x40000064: 
                case 1073742099: {
                    propertyName = T.nameOf(eval.theTok);
                    switch (this.tokAt(i + 1)) {
                        case 0x10000600: 
                        case 268440324: {
                            ++i;
                        }
                    }
                    propertyValue = Float.valueOf(this.floatParameter(++i));
                    break;
                }
                case 1094717454: {
                    if (id == null) {
                        this.invArg();
                    }
                    propertyName = "model";
                    propertyValue = this.intParameter(++i);
                    break;
                }
                case 1073742170: {
                    if (nAtomSets > 1 || id != null && !haveCenter || noToParam == i) {
                        this.invPO();
                    }
                    nAtomSets = 3;
                    if (eval.isAtomExpression(++i)) {
                        propertyName = needsGenerating || haveCenter ? "to" : "toBitSet";
                        propertyValue = this.atomExpressionAt(i);
                    } else if (eval.isArrayParameter(i)) {
                        propertyName = "toVertices";
                        propertyValue = eval.getPointArray(i, -1, false);
                    } else {
                        this.error(19);
                    }
                    i = eval.iToken;
                    needsGenerating = true;
                    break;
                }
                case 10: 
                case 12290: 
                case 1073742325: {
                    if (typeSeen) {
                        this.invPO();
                    }
                    switch (++nAtomSets) {
                        case 1: {
                            if (id != null) {
                                this.invArg();
                            }
                            propertyName = "centers";
                            break;
                        }
                        case 2: {
                            propertyName = "to";
                            needsGenerating = true;
                            break;
                        }
                        default: {
                            eval.bad();
                        }
                    }
                    propertyValue = this.atomExpressionAt(i);
                    atomPt = i = eval.iToken;
                    needsGenerating |= i + 1 == this.slen;
                    break;
                }
                case 1073741886: 
                case 1073741948: {
                    needsGenerating = true;
                    boolean bl = modifyOnly = i == 1;
                    if (typeSeen) {
                        this.error(18);
                    }
                    typeSeen = true;
                    String string = propertyName = this.e.theTok == 1073741886 ? "collapsed" : null;
                    if (!this.isFloatParameter(i + 1)) break;
                    this.setShapeProperty(21, "faceCenterOffset", Float.valueOf(this.floatParameter(++i)));
                    break;
                }
                case 1073742074: 
                case 1111490588: 
                case 1765808134: {
                    if (atomPt == i - 1) {
                        needsGenerating = true;
                    }
                    translucentLevel = this.getColorTrans(eval, i, true, colorArgb);
                    ok = true;
                    i = eval.iToken;
                    continue block35;
                }
                case 1073741933: 
                case 1073741934: 
                case 0x40000084: 
                case 1073742044: {
                    if (atomPt == i - 1) {
                        needsGenerating = true;
                    }
                    if (edgeParameterSeen) {
                        this.error(18);
                    }
                    edgeParameterSeen = true;
                    ok = true;
                    propertyName = T.nameOf(eval.theTok);
                    break;
                }
                case 1073741861: 
                case 1073741958: 
                case 1073741964: 
                case 1073742060: 
                case 1073742182: {
                    continue block35;
                }
                case 4: 
                case 0x10001601: 
                case 0x40000000: 
                case 1073741974: {
                    if (!eval.isColorParam(i)) {
                        if (i != 1) {
                            this.invPO();
                        }
                        String string = id = eval.theTok == 1073741974 ? this.stringParameter(++i) : eval.optParameterAsString(i);
                        if (this.tokAt(i + 1) == 0x10001601) {
                            id = id + this.paramAsStr(++i);
                        }
                        this.setShapeProperty(21, "thisID", id);
                        this.setShapeProperty(21, "model", this.vwr.am.cmi);
                        if (!eval.isCenterParameter(i + 1)) continue block35;
                        propertyName = "center";
                        propertyValue = this.centerParameter(++i);
                        i = eval.iToken;
                        haveCenter = true;
                        break;
                    }
                }
                default: {
                    if (eval.isColorParam(i)) {
                        if (atomPt == i - 1) {
                            needsGenerating = true;
                        }
                        colorArgb[0] = eval.getArgbParam(i);
                        if (eval.isCenterParameter(i)) {
                            noToParam = eval.iToken + 1;
                        }
                        i = eval.iToken;
                        continue block35;
                    }
                    this.invArg();
                }
            }
            if (propertyName != null) {
                this.setShapeProperty(21, propertyName, propertyValue);
            }
            if (!onOffDelete) continue;
            return;
        }
        if (needsGenerating) {
            if (!typeSeen && haveBonds) {
                this.setShapeProperty(21, "bonds", null);
            }
            this.setShapeProperty(21, "generate", modifyOnly);
        } else if (!ok) {
            this.error(19);
        }
        if (offset != null) {
            this.setShapeProperty(21, "offset", offset);
        }
        if (!Float.isNaN(scale)) {
            this.setShapeProperty(21, "scale", Float.valueOf(scale));
        }
        if (colorArgb[0] != Integer.MIN_VALUE) {
            this.setShapeProperty(21, "colorThis", colorArgb[0]);
        }
        if (translucentLevel != Float.MAX_VALUE) {
            eval.setShapeTranslucency(21, "", "translucentThis", translucentLevel, null);
        }
        this.setShapeProperty(21, "init", Boolean.FALSE);
    }

    private String write(T[] args) throws ScriptException {
        Hashtable<String, Object> params;
        boolean isImage;
        T t0;
        if (args == null && this.vwr.haveAccessInternal(null)) {
            this.invArg();
        }
        ScriptEval eval = this.e;
        int pt = 1;
        int pt0 = 1;
        String[] scripts = null;
        String msg = null;
        String localPath = null;
        String remotePath = null;
        String type = "SPT";
        boolean isCommand = true;
        boolean showOnly = false;
        boolean isContact = false;
        if (args == null) {
            args = this.st;
            showOnly = this.vwr.isApplet && !this.vwr.isSignedApplet || !this.vwr.haveAccess(Viewer.ACCESS.ALL) || this.vwr.fm.getPathForAllFiles().length() > 0;
        } else {
            pt0 = 0;
            pt = 0;
            isCommand = false;
            showOnly = !isCommand;
        }
        int tok = CmdExt.tokAtArray(pt, args);
        if (tok == 4 && !isCommand && (t0 = T.getTokenFromName(SV.sValue(args[0]).toLowerCase())) != null) {
            tok = t0.tok;
        }
        switch (tok) {
            case 0: {
                break;
            }
            case 4138: 
            case 134221850: 
            case 1715472409: {
                msg = this.plot(args);
                return showOnly ? msg : this.writeMsg(msg);
            }
            case 134222850: {
                if (!eval.isArrayParameter(pt + 1)) break;
                scripts = eval.stringParameterSet(++pt);
                localPath = ".";
                remotePath = ".";
                pt0 = pt = eval.iToken + 1;
                tok = this.tokAt(pt);
                break;
            }
            default: {
                type = SV.sValue(this.tokenAt(pt, args)).toUpperCase();
            }
        }
        String driverList = this.vwr.getExportDriverList();
        String data = null;
        int argCount = isCommand ? this.slen : args.length;
        String type2 = "";
        String val = null;
        boolean is2D = false;
        SV tVar = null;
        int nVibes = 0;
        String sceneType = null;
        boolean isCoord = false;
        BS bsFrames = null;
        int width = -1;
        int height = -1;
        boolean isExport = false;
        String fileName = null;
        int quality = Integer.MIN_VALUE;
        if (tok != 0 && isCommand && this.slen > 1 && this.tokAt(this.slen - 2) == 1073741848) {
            type = this.paramAsStr(this.slen - 1).toUpperCase();
            pt0 = argCount;
            argCount -= 2;
            tok = 0;
        }
        switch (tok) {
            case 0: {
                break;
            }
            case 6: 
            case 15: {
                type = "VAR";
                tVar = (SV)this.tokenAt(pt++, args);
                break;
            }
            case 0x400000A0: {
                type = "INLINE";
                data = SV.sValue(this.tokenAt(++pt, args));
                ++pt;
                break;
            }
            case 1275068447: {
                type = "PGRP";
                type2 = SV.sValue(this.tokenAt(++pt, args)).toLowerCase();
                if (!type2.equals("draw")) break;
                ++pt;
                break;
            }
            case 1073742329: {
                ++pt;
                isCoord = true;
                break;
            }
            case 134222850: 
            case 1073742158: {
                val = SV.sValue(this.tokenAt(++pt, args)).toLowerCase();
                while (val.equals("localpath") || val.equals("remotepath")) {
                    if (val.equals("localpath")) {
                        localPath = SV.sValue(this.tokenAt(++pt, args));
                    } else {
                        remotePath = SV.sValue(this.tokenAt(++pt, args));
                    }
                    val = SV.sValue(this.tokenAt(++pt, args)).toLowerCase();
                }
                type = "SPT";
                break;
            }
            case 135180: 
            case 135188: 
            case 134320141: 
            case 1073742015: 
            case 1073742018: 
            case 1073877010: 
            case 1073877011: 
            case 1228935687: 
            case 1610616855: {
                ++pt;
                break;
            }
            case 1073741991: {
                type = "ZIPALL";
                ++pt;
                break;
            }
            case 36868: {
                type = "VAR";
                pt += 2;
                break;
            }
            case 4: 
            case 4115: 
            case 4120: 
            case 4166: 
            case 0x40000000: 
            case 1073741929: 
            case 0x400000EE: 
            case 1073742139: {
                switch (tok) {
                    case 4115: {
                        BS bsAtoms;
                        if (pt + 1 < argCount && args[++pt].tok == 1073742325 || args[pt].tok == 10) {
                            bsAtoms = eval.atomExpression(args, pt, 0, true, false, null, true);
                            pt = eval.iToken + 1;
                        } else {
                            bsAtoms = this.vwr.getAllAtoms();
                        }
                        if (this.chk) break;
                        bsFrames = this.vwr.ms.getModelBS(bsAtoms, true);
                        break;
                    }
                    case 1073741929: {
                        tok = 4120;
                        is2D = true;
                    }
                    case 4120: {
                        type = "IMAGE";
                        ++pt;
                        break;
                    }
                    case 1073742139: {
                        val = SV.sValue(this.tokenAt(++pt, args)).toUpperCase();
                        if (PT.isOneOf(val, ";PNG;PNGJ;")) {
                            sceneType = val;
                            ++pt;
                            break;
                        }
                        sceneType = "PNG";
                        break;
                    }
                    case 4166: {
                        nVibes = eval.intParameterRange(++pt, 1, 10);
                        if (nVibes == Integer.MAX_VALUE) {
                            return "";
                        }
                        if (!this.chk) {
                            this.vwr.tm.setVibrationPeriod(0.0f);
                            if (!eval.isJS) {
                                eval.delayScript(100);
                            }
                        }
                        ++pt;
                        break;
                    }
                    default: {
                        tok = 4120;
                    }
                }
                if (tok == 4120 && pt < args.length) {
                    T t = T.getTokenFromName(SV.sValue(args[pt]).toLowerCase());
                    if (t != null) {
                        type = SV.sValue(t).toUpperCase();
                    }
                    if (PT.isOneOf(type, driverList.toUpperCase())) {
                        ++pt;
                        type = type.substring(0, 1).toUpperCase() + type.substring(1).toLowerCase();
                        isExport = true;
                        if (!isCommand) break;
                        fileName = "Jmol." + type.toLowerCase();
                        break;
                    }
                    if (PT.isOneOf(type, ";ZIP;ZIPALL;SPT;STATE;")) {
                        ++pt;
                        break;
                    }
                    type = "IMAGE";
                }
                if (CmdExt.tokAtArray(pt, args) != 2) break;
                if ((width = SV.iValue(this.tokenAt(pt++, args))) <= 0) {
                    this.invArg();
                }
                if ((height = SV.iValue(this.tokenAt(pt++, args))) > 0) break;
                this.invArg();
            }
        }
        if (pt0 < argCount) {
            val = SV.sValue(this.tokenAt(pt, args));
            if (val.equalsIgnoreCase("clipboard")) {
                if (this.chk) {
                    return "";
                }
            } else if (PT.isOneOf(val.toLowerCase(), ";jpg;jpeg;jpg64;jpeg64;gif;gift;pdf;ppm;png;pngj;pngt;")) {
                if (CmdExt.tokAtArray(pt + 1, args) == 2 && CmdExt.tokAtArray(pt + 2, args) == 2) {
                    if ((width = SV.iValue(this.tokenAt(++pt, args))) <= 0) {
                        this.invArg();
                    }
                    if ((height = SV.iValue(this.tokenAt(++pt, args))) <= 0) {
                        this.invArg();
                    }
                }
                if (CmdExt.tokAtArray(pt + 1, args) == 2) {
                    quality = SV.iValue(this.tokenAt(++pt, args));
                }
            } else if (PT.isOneOf(val.toLowerCase(), ";xyz;xyzrn;xyzvib;mol;mol67;sdf;v2000;v3000;json;pdb;pqr;cml;cif;cifp1;pwmat;pwslab;qcjson;xsf;")) {
                type = val.toUpperCase();
                if (pt + 1 == argCount) {
                    ++pt;
                }
            }
            if (type.equals("IMAGE") && PT.isOneOf(val.toLowerCase(), ";jpg;jpeg;jpg64;jpeg64;gif;gift;pdf;ppm;png;pngj;pngt;scene;")) {
                type = val.toUpperCase();
                quality = Integer.MIN_VALUE;
                ++pt;
            }
        }
        if (pt + 2 == argCount) {
            SV.sValue(this.tokenAt(++pt, args));
        }
        switch (CmdExt.tokAtArray(pt, args)) {
            case 0: {
                showOnly = true;
                break;
            }
            case 1073741884: {
                break;
            }
            case 805307393: {
                fileName = type.equals("IMAGE") ? "?jmol.png" : "?jmol." + type.toLowerCase();
                break;
            }
            case 4: 
            case 0x40000000: {
                fileName = SV.sValue(this.tokenAt(pt, args));
                if (!fileName.equalsIgnoreCase("clipboard") && this.vwr.haveAccess(Viewer.ACCESS.ALL)) break;
                fileName = null;
                break;
            }
            default: {
                this.invArg();
            }
        }
        if (type.equals("IMAGE") || type.equals("FRAME") || type.equals("VIBRATION")) {
            String string = type = fileName != null && fileName.indexOf(".") >= 0 ? fileName.substring(fileName.lastIndexOf(".") + 1).toUpperCase() : "JPG";
        }
        if (type.equals("ISOSURFACE") || type.equals("CONTACT")) {
            isContact = type.equals("CONTACT");
            String string = type = fileName != null && fileName.indexOf(".") >= 0 ? fileName.substring(fileName.lastIndexOf(".") + 1).toUpperCase() : "JVXL";
            if (type.equals("PMESH")) {
                type = "ISOMESH";
            } else if (type.equals("PMB")) {
                type = "ISOMESHBIN";
            }
        }
        if (!(isImage = PT.isOneOf(type.toLowerCase(), ";jpg;jpeg;jpg64;jpeg64;gif;gift;pdf;ppm;png;pngj;pngt;scene;"))) {
            if (type.equals("MNU")) {
                type = "MENU";
            } else if (type.equals("WRL") || type.equals("VRML")) {
                type = "Vrml";
                isExport = true;
            } else if (type.equals("X3D")) {
                type = "X3d";
                isExport = true;
            } else if (type.equals("STL")) {
                type = "Stl";
                isExport = true;
            } else if (type.equals("IDTF")) {
                type = "Idtf";
                isExport = true;
            } else if (type.equals("MA")) {
                type = "Maya";
                isExport = true;
            } else if (type.equals("JS")) {
                type = "Js";
                isExport = true;
            } else if (type.equals("OBJ")) {
                type = "Obj";
                isExport = true;
            } else if (type.equals("JVXL")) {
                type = "ISOSURFACE";
            } else if (type.equals("XJVXL")) {
                type = "ISOSURFACE";
            } else if (type.equals("JMOL")) {
                type = "ZIPALL";
            } else if (type.equals("HIS")) {
                type = "HISTORY";
            }
            if (type.equals("COORD") || type.equals("COORDS")) {
                String string = type = fileName != null && fileName.indexOf(".") >= 0 ? fileName.substring(fileName.lastIndexOf(".") + 1).toUpperCase() : "XYZ";
            }
        }
        if (scripts != null) {
            if (!FileManager.isJmolType(type)) {
                this.invArg();
            }
            if (type.equals("PNG")) {
                type = "PNGJ";
            }
        }
        if (!(isImage || isExport || PT.isOneOf(type, ";SCENE;JMOL;ZIP;ZIPALL;SPT;HISTORY;MO;NBO;ISOSURFACE;MESH;PMESH;PMB;ISOMESHBIN;ISOMESH;VAR;FILE;FUNCTION;CFI;CIF;CIFP1;CML;JSON;XYZ;XYZRN;XYZVIB;MENU;MOL;MOL67;PDB;PGRP;PQR;PWMAT;PWSLAB;QUAT;RAMA;SDF;V2000;V3000;QCJSON;XSF;INLINE;"))) {
            eval.errorStr2(54, "COORDS|FILE|FUNCTIONS|HISTORY|IMAGE|INLINE|ISOSURFACE|JMOL|MENU|MO|NBO|POINTGROUP|QUATERNION [w,x,y,z] [derivative]|RAMACHANDRAN|SPT|STATE|VAR x|ZIP|ZIPALL|CLIPBOARD", "CIF|CIFP1|CML|CFI|GIF|GIFT|JPG|JPG64|JMOL|JVXL|MESH|MOL|PDB|PMESH|PNG|PNGJ|PNGT|PPM|PQR|PWMAT|PWSLAB|SDF|CD|JSON|QCJSON|V2000|V3000|SPT|XJVXL|XSF|XYZ|XYZRN|XYZVIB|ZIP" + driverList.toUpperCase().replace(';', '|'));
        }
        if (this.chk) {
            return "";
        }
        String[] fullPath = new String[1];
        boolean timeMsg = this.vwr.getBoolean(603979934);
        if (isExport) {
            if (timeMsg) {
                Logger.startTimer("export");
            }
            Hashtable<String, Object> eparams = new Hashtable<String, Object>();
            eparams.put("type", type);
            if (fileName != null) {
                eparams.put("fileName", fileName);
            }
            if (isCommand || fileName != null) {
                eparams.put("fullPath", fullPath);
            }
            eparams.put("width", width);
            eparams.put("height", height);
            try {
                data = this.vwr.generateOutputForExport(eparams);
            }
            catch (Exception e) {
                data = e.toString();
                return data;
            }
            if (data == null || data.length() == 0) {
                return "";
            }
            if (showOnly) {
                return data;
            }
            if (!type.equals("Povray") && !type.equals("Idtf") || fullPath[0] == null) {
                return this.writeMsg(data);
            }
            String ext = type.equals("Idtf") ? ".tex" : ".ini";
            fileName = fullPath[0] + ext;
            Hashtable<String, Object> params2 = new Hashtable<String, Object>();
            params2.put("fileName", fileName);
            params2.put("type", ext);
            params2.put("text", data);
            params2.put("fullPath", fullPath);
            msg = this.vwr.processWriteOrCapture(params2);
            if (type.equals("Idtf")) {
                data = data.substring(0, data.indexOf("\\begin{comment}"));
            }
            data = "Created " + fullPath[0] + ":\n\n" + data;
            if (timeMsg) {
                this.showString(Logger.getTimerMsg("export", 0));
            }
            if (msg != null) {
                boolean isError;
                boolean bl = isError = !msg.startsWith("OK");
                if (isError) {
                    eval.evalError(msg, null);
                }
                eval.report(data, isError);
            }
            return "";
        }
        Object bytes = null;
        boolean writeFileData = false;
        if (data == null) {
            int len = 0;
            data = type.intern();
            if (data == "MENU") {
                data = this.vwr.getMenu("");
            } else if (data == "PGRP") {
                data = this.vwr.ms.getPointGroupAsString(this.vwr.bsA(), null, 0, 1.0f, null, null, type2.equals("draw") ? "" : null);
            } else if (data == "PDB" || data == "PQR") {
                if (showOnly) {
                    data = this.vwr.getPdbAtomData(null, null, data == "PQR", isCoord);
                } else {
                    writeFileData = true;
                    type = "PDB_" + data + "-coord " + isCoord;
                }
            } else if (data == "FILE") {
                if ("?".equals(fileName)) {
                    fileName = "?Jmol." + this.vwr.getP("_fileType");
                }
                if (showOnly) {
                    data = this.e.getCurrentModelFileAsString(null);
                } else {
                    writeFileData = true;
                }
            } else if (PT.isOneOf(data, ";CIF;CIFP1;SDF;MOL;MOL67;V2000;V3000;CD;JSON;XYZ;XYZRN;XYZVIB;CML;QCJSON;PWMAT;PWSLAB;XSF;")) {
                BS bsModel;
                BS selected = this.vwr.bsA();
                this.vwr.setErrorMessage(null, " (" + selected.cardinality() + " atoms)");
                data = this.vwr.getModelExtract(selected, isCoord, false, data);
                msg = this.vwr.getErrorMessageUn();
                this.vwr.setErrorMessage(null, null);
                if (this.vwr.am.cmi >= 0 && !selected.equals(bsModel = this.vwr.getModelUndeletedAtomsBitSet(this.vwr.am.cmi))) {
                    msg = msg + "\nNote! Selected atom set " + selected + " is not the same as the current model " + bsModel;
                }
                if (data.startsWith("ERROR:")) {
                    bytes = data;
                }
            } else if (data == "CFI") {
                data = this.vwr.getModelFileData("selected", "cfi", false);
            } else if (data == "FUNCTION") {
                data = this.vwr.getFunctionCalls(null);
                type = "TXT";
            } else if (data == "VAR") {
                if (tVar == null) {
                    tVar = (SV)eval.getParameter(SV.sValue(this.tokenAt(isCommand ? 2 : 1, args)), 1073742190, true);
                }
                Lst<byte[]> v = null;
                if (tVar.tok == 15) {
                    v = new Lst<byte[]>();
                    v.addLast(((BArray)tVar.value).data);
                } else if (tVar.tok == 6) {
                    Lst<Object> lst = v = fileName == null ? new Lst() : this.prepareBinaryOutput(tVar);
                }
                if (v == null) {
                    data = tVar.asString();
                    type = "TXT";
                } else if (fileName != null) {
                    params = new Hashtable();
                    params.put("data", v);
                    data = (String)this.vwr.createZip(fileName, v.size() == 1 || fileName.endsWith(".png") || fileName.endsWith(".pngj") ? "BINARY" : "ZIPDATA", params);
                    bytes = data;
                    if (data == null) {
                        eval.evalError("#CANCELED#", null);
                    }
                }
            } else if (data == "SPT") {
                if (isCoord) {
                    BS tainted = this.vwr.ms.getTaintedAtoms(2);
                    this.vwr.setAtomCoordsRelative(P3.new3(0.0f, 0.0f, 0.0f), null);
                    data = this.vwr.getStateInfo();
                    this.vwr.ms.setTaintedAtoms(tainted, 2);
                } else {
                    data = this.vwr.getStateInfo();
                    if (localPath != null || remotePath != null) {
                        data = FileManager.setScriptFileReferences(data, localPath, remotePath, null);
                    }
                }
            } else if (data == "ZIP" || data == "ZIPALL") {
                if (fileName != null) {
                    params = new Hashtable();
                    if (scripts != null) {
                        params.put("data", scripts);
                    }
                    data = (String)this.vwr.createZip(fileName, type, params);
                    bytes = data;
                    if (data == null) {
                        eval.evalError("#CANCELED#", null);
                    }
                }
            } else if (data == "HISTORY") {
                data = this.vwr.getSetHistory(Integer.MAX_VALUE);
                type = "SPT";
            } else if (data == "MO" || data == "NBO") {
                data = this.getMoJvxl(Integer.MAX_VALUE, data == "NBO");
                type = "XJVXL";
            } else if (data == "PMESH" || data == "PMB") {
                if ((data = (String)this.getIsosurfaceJvxl(29, data)) == null) {
                    this.error(31);
                }
                type = "XJVXL";
            } else if (data == "ISOMESH") {
                if ((data = (String)this.getIsosurfaceJvxl(24, data)) == null) {
                    this.error(31);
                }
                type = "PMESH";
            } else if (data == "ISOMESHBIN") {
                bytes = this.getIsosurfaceJvxl(24, "ISOMESHBIN");
                if (bytes == null) {
                    this.error(31);
                }
                type = "PMB";
            } else if (data == "ISOSURFACE" || data == "MESH") {
                data = (String)this.getIsosurfaceJvxl(isContact ? 25 : 24, data);
                if (data == null) {
                    this.error(31);
                }
                String string = type = data.indexOf("<?xml") >= 0 ? "XJVXL" : "JVXL";
                if (!showOnly) {
                    this.showString((String)this.getShapeProperty(isContact ? 25 : 24, "jvxlFileInfo"));
                }
            } else {
                if (isCommand && showOnly && fileName == null) {
                    showOnly = false;
                    fileName = "\u0001";
                }
                len = -1;
                if (sceneType == null && quality < 0) {
                    quality = -1;
                }
            }
            if (data == null) {
                data = "";
            }
            if (len == 0) {
                int n = bytes == null ? data.length() : (len = bytes instanceof String ? ((String)bytes).length() : ((byte[])bytes).length);
            }
        }
        if (!isCommand) {
            return data;
        }
        if (showOnly) {
            eval.showStringPrint(data, true);
            return "";
        }
        if (bytes != null && bytes instanceof String) {
            return this.writeMsg((String)bytes);
        }
        if (writeFileData) {
            return this.writeMsg(this.vwr.writeFileData(fileName, type, 0, null));
        }
        if (type.equals("SCENE")) {
            bytes = sceneType;
        } else if (!(bytes != null || isImage && fileName == null)) {
            bytes = data;
        }
        if (timeMsg) {
            Logger.startTimer("write");
        }
        if (isImage) {
            eval.refresh(false);
            if (width < 0) {
                int n = width = is2D ? 250 : this.vwr.getScreenWidth();
            }
            if (height < 0) {
                height = is2D ? 250 : this.vwr.getScreenHeight();
            }
        }
        params = new Hashtable<String, Object>();
        if (fileName != null) {
            params.put("fileName", fileName);
        }
        params.put("backgroundColor", this.vwr.getBackgroundArgb());
        params.put("type", type);
        if (is2D) {
            params.put("is2D", Boolean.TRUE);
            Object ret = "smiles could not be generated";
            try {
                String smiles = this.vwr.getOpenSmiles(null);
                if (smiles.length() > 0) {
                    String fname = (String)this.vwr.setLoadFormat(true, "_" + smiles, '2', false);
                    fname = fname + "?width=" + width + "&height=" + height + "&format=" + type.toLowerCase();
                    this.showString(fname);
                    ret = this.vwr.fm.getFileAsBytes(fname, null);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (ret instanceof String) {
                this.showString((String)ret);
                return null;
            }
            bytes = ret;
        }
        if (bytes instanceof String && quality == Integer.MIN_VALUE) {
            params.put("text", bytes);
        } else if (bytes instanceof byte[]) {
            params.put("bytes", bytes);
        }
        if (scripts != null) {
            params.put("scripts", scripts);
        }
        if (bsFrames != null) {
            params.put("bsFrames", bsFrames);
        }
        params.put("fullPath", fullPath);
        params.put("quality", quality);
        params.put("width", width);
        params.put("height", height);
        params.put("nVibes", nVibes);
        String ret = this.vwr.processWriteOrCapture(params);
        if (ret == null) {
            ret = "canceled";
        }
        if (isImage && ret.startsWith("OK")) {
            ret = ret + "; width=" + width + "; height=" + height;
        }
        if (timeMsg) {
            this.showString(Logger.getTimerMsg("write", 0));
        }
        return this.writeMsg(ret + (msg == null ? "" : msg));
    }

    public Lst<Object> prepareBinaryOutput(SV tvar) {
        Map<String, SV> m = tvar.getMap();
        if (m == null || !m.containsKey("$_BINARY_$")) {
            return null;
        }
        Lst<Object> v = new Lst<Object>();
        for (Map.Entry<String, SV> e : m.entrySet()) {
            byte[] bytes;
            String key = e.getKey();
            if (key.equals("$_BINARY_$")) continue;
            SV o = e.getValue();
            byte[] byArray = bytes = o.tok == 15 ? ((BArray)o.value).data : null;
            if (bytes == null) {
                String s = o.asString();
                byte[] byArray2 = bytes = s.startsWith(";base64,") ? Base64.decodeBase64(s) : s.getBytes();
            }
            if (key.equals("_DATA_")) {
                v = new Lst();
                v.addLast(bytes);
                return v;
            }
            if (key.equals("_IMAGE_")) {
                v.add(0, key);
                v.add(1, (Object)null);
                v.add(2, bytes);
                continue;
            }
            v.addLast(key);
            v.addLast((Object)null);
            v.addLast(bytes);
        }
        return v;
    }

    private String writeMsg(String msg) throws ScriptException {
        boolean isError;
        if (this.chk || msg == null) {
            return "";
        }
        boolean bl = isError = !msg.startsWith("OK");
        if (isError) {
            this.e.evalError(msg, null);
        }
        this.e.report(msg, isError);
        return msg;
    }

    private void show() throws ScriptException {
        int tok;
        ScriptEval eval = this.e;
        String value = null;
        String str = this.paramAsStr(1);
        String filter = null;
        int filterLen = 0;
        if (this.slen > 3 && this.tokAt(this.slen - 3) == 0x10001600 && this.tokAt(this.slen - 2) == 0x10000E00) {
            filter = "!/" + this.paramAsStr(this.slen - 1);
            this.slen -= 3;
            filterLen = 3;
        } else if (this.slen > 2 && this.tokAt(this.slen - 2) == 0x10001600) {
            filter = "/" + this.paramAsStr(this.slen - 1);
            this.slen -= 2;
            filterLen = 2;
        } else {
            filter = this.paramAsStr(this.slen - 1);
            if (filter.lastIndexOf("/") == 0) {
                --this.slen;
                filterLen = 1;
            } else {
                filter = null;
            }
        }
        String msg = null;
        String name = null;
        int len = 2;
        T token = this.getToken(1);
        int n = tok = token instanceof SV && token.tok != 0x40000000 ? 0 : token.tok;
        if (tok == 4 && (token = T.getTokenFromName(str.toLowerCase())) != null) {
            tok = token.tok;
        }
        if (tok != 1296041985 && tok != 1073742158 && tok != 1715472409 && tok != 1228935687) {
            this.checkLength(-3);
        }
        if (this.slen == 2 && str.indexOf("?") >= 0) {
            msg = this.vwr.getAllSettings(str.substring(0, str.indexOf("?")));
            tok = -1;
        }
        block1 : switch (tok) {
            case -1: {
                break;
            }
            case 0: {
                if (this.chk) break;
                msg = ((SV)eval.theToken).escape();
                break;
            }
            case 603984065: {
                if (this.chk) break;
                msg = this.vwr.stm.getUndoInfo();
                break;
            }
            case 1073741925: {
                eval.checkLength23();
                len = this.st.length;
                if (this.chk) break;
                Object d = this.vwr.getModelInfo("domains");
                if (d instanceof SV) {
                    msg = this.vwr.getAnnotationInfo((SV)d, eval.optParameterAsString(2), 1073741925);
                    break;
                }
                msg = "domain information has not been loaded";
                break;
            }
            case 1715472409: {
                msg = this.plot(this.st);
                len = this.st.length;
                break;
            }
            case 1073742189: {
                eval.checkLength23();
                len = this.st.length;
                if (this.chk) break;
                Object d = this.vwr.getModelInfo("validation");
                if (d instanceof SV) {
                    msg = this.vwr.getAnnotationInfo((SV)d, eval.optParameterAsString(2), 1073742189);
                    break;
                }
                msg = "validation information has not been loaded";
                break;
            }
            case 134221829: {
                if (this.chk) break;
                msg = Escape.e(this.vwr.fm.cacheList());
                break;
            }
            case 1111490587: {
                eval.checkLength23();
                len = this.st.length;
                if (this.chk) break;
                Object d = this.vwr.getModelInfo("dssr");
                msg = d == null ? "no DSSR information has been read" : (len > 2 ? SV.getVariable(this.vwr.extractProperty(d, this.stringParameter(2), -1)).asString() : "" + SV.getVariable(d).asString());
                break;
            }
            case 1073741915: {
                int version = 2;
                if (this.slen == 3) {
                    len = 3;
                    version = (int)this.floatParameter(3 - 1);
                } else {
                    this.checkLength(2 + filterLen);
                }
                if (this.chk) break;
                msg = this.vwr.calculateStructures(null, true, false, version);
                break;
            }
            case 545259572: {
                this.checkLength(2 + filterLen);
                if (this.chk) break;
                msg = this.vwr.fm.getPathForAllFiles();
                break;
            }
            case 1275203608: {
                if (this.chk) break;
                Object[] info = new Object[2];
                this.vwr.shm.getShapePropertyData(21, "allInfo", info);
                msg = SV.getVariable(info[1]).asString();
                break;
            }
            case 1073742038: {
                if (!this.chk) {
                    this.vwr.getNMRPredict(eval.optParameterAsString(2));
                }
                return;
            }
            case 603983903: {
                if (this.chk || this.slen != 3) break;
                msg = "" + this.vwr.getModelkitPropertySafely(eval.stringParameter(2));
                len = 3;
                break;
            }
            case 134218757: 
            case 1073741879: 
            case 1073741929: 
            case 1073741978: 
            case 1275068433: {
                this.checkLength((tok == 1073741879 || tok == 134218757 && this.tokAt(2) == 1073742335 ? (len = 3) : 2) + filterLen);
                if (this.chk) {
                    return;
                }
                String param2 = eval.optParameterAsString(2);
                if (tok == 1073741879) {
                    if ("mf".equals(param2)) {
                        param2 = "formula";
                    }
                    if ("formula".equals(param2) && (msg = (String)this.vwr.getModelInfo("formula")) != null) {
                        msg = PT.rep(msg, " ", "");
                    }
                }
                if (msg != null) break;
                try {
                    switch (tok) {
                        case 1275068433: {
                            msg = this.vwr.getInchi(this.vwr.bsA(), null, null);
                            if (msg != null) break;
                            msg = "?";
                            break;
                        }
                        case 1073741978: {
                            msg = this.vwr.getInchi(this.vwr.bsA(), null, "key");
                            break;
                        }
                        case 134218757: {
                            if (param2.equalsIgnoreCase("true")) {
                                msg = this.vwr.getBioSmiles(null);
                                filter = null;
                                break;
                            }
                            if (filter == null) break;
                            msg = this.vwr.getSmilesOpt(null, -1, -1, 1, filter + "///");
                            filter = null;
                            break;
                        }
                        default: {
                            msg = this.vwr.ms.getModelDataBaseName(this.vwr.bsA());
                            msg = msg != null && (msg.startsWith("$") || msg.startsWith(":")) ? msg.substring(1) : null;
                        }
                    }
                    if (msg == null) {
                        int level = Logger.getLogLevel();
                        Logger.setLogLevel(4);
                        msg = tok == 134218757 ? this.vwr.getSmiles(null) : this.vwr.getOpenSmiles(null);
                        Logger.setLogLevel(level);
                    }
                }
                catch (Exception ex) {
                    msg = ex.getMessage();
                    if (msg == null) {
                        msg = "";
                    }
                    ex.printStackTrace();
                }
                switch (tok) {
                    case 134218757: {
                        break;
                    }
                    case 1073741929: {
                        if (msg.length() > 0) {
                            this.vwr.fm.loadImage(this.vwr.setLoadFormat(false, "_" + msg, '2', false), "\u0001" + msg, false);
                            return;
                        }
                        msg = "Could not show drawing -- Either insufficient atoms are selected or the model is a PDB file.";
                        break;
                    }
                    case 1073741879: {
                        len = 3;
                        if (msg.length() > 0) {
                            if ((msg = this.vwr.getChemicalInfo(msg, param2, this.vwr.bsA())).indexOf("FileNotFound") < 0) break;
                            msg = "?";
                            break;
                        }
                        msg = "Could not show name -- Either insufficient atoms are selected or the model is a PDB file.";
                    }
                }
                break;
            }
            case 1086324754: 
            case 1086324755: {
                if (this.chk) break;
                msg = ("" + this.vwr.evaluateExpression("symop('wyckoff" + (tok == 1086324755 ? "m" : "") + "')")).trim();
                break;
            }
            case 134217764: 
            case 1296041985: {
                SymmetryInterface sym = this.vwr.getOperativeSymmetry();
                switch (tok) {
                    case 134217764: {
                        Map<String, Object> info;
                        String sdiag = eval.optParameterAsString(2);
                        boolean isNames = sdiag.toLowerCase().equals("names");
                        boolean isSubgroup = sdiag.toLowerCase().startsWith("subgroups");
                        boolean isDiagram = sdiag.toLowerCase().startsWith("diagram");
                        boolean isDiagramITA = sdiag.startsWith("diagramITA");
                        boolean isTable = sdiag.toLowerCase().startsWith("table");
                        len = this.slen;
                        int ita = -1;
                        if (isNames) {
                            if (this.chk) {
                                break;
                            }
                        } else if (isSubgroup || isDiagram || isTable || isDiagramITA) {
                            if (this.chk) break;
                            if ((sdiag = PT.trim(sdiag.substring(isDiagramITA ? 10 : (isSubgroup ? 9 : (isDiagram ? 7 : 5))).trim(), "\"")).length() == 0) {
                                if (sym == null) {
                                    msg = "Include a space group name or number to view its diagram, table, or subgroups";
                                    break;
                                }
                                if (sym.getSpaceGroupClegId().charAt(1) == '/') {
                                    msg = "special group information is not implemented yet";
                                    break;
                                }
                                sdiag = sym.getIntTableNumber();
                                if (sdiag == null || sdiag.equals("0")) {
                                    msg = "Can't display a table; don't have an ITA number.";
                                    break;
                                }
                            }
                            if (msg != null) break;
                            ita = PT.parseInt(sdiag);
                            if (ita == Integer.MIN_VALUE) {
                                if (sym == null) {
                                    sym = this.vwr.getSymStatic();
                                }
                                if ((info = sym.getSpaceGroupInfo(this.vwr.ms, PT.rep(sdiag, "''", "\""), -1, true, null)) == null) {
                                    msg = "Could not find space group " + sdiag;
                                    break;
                                }
                                ita = (Integer)((Map)info.get("spaceGroupInfo")).get("ita");
                            }
                        }
                        if (isNames || ita > 0) {
                            String href;
                            msg = href = isNames ? "https://www.cryst.ehu.es/cgi-bin/cryst/programs/nph-getgen" : JC.resolveDataBase(isDiagramITA ? "itadiagramita" : (isDiagram ? "itadiagram" : "itatable"), PT.formatS("" + ita, 3, 0, false, true), null);
                            this.vwr.showUrl(href);
                            break;
                        }
                    }
                    case 1296041985: {
                        msg = "";
                        Map<String, Object> info = null;
                        len = this.slen;
                        if (len == 2) {
                            if (this.chk) break;
                            if (sym == null) {
                                sym = this.vwr.getSymTemp();
                            }
                            info = sym.getSpaceGroupInfo(this.vwr.ms, null, -1, false, null);
                        } else if (tok == 134217764) {
                            String sg = this.paramAsStr(2);
                            len = 3;
                            if (this.chk) break;
                            if (sg.startsWith("list/")) {
                                filter = sg.substring(4);
                                sg = "list";
                            }
                            info = this.vwr.getSymTemp().getSpaceGroupInfo(this.vwr.ms, PT.rep(sg, "''", "\""), -1, false, null);
                        }
                        if (info != null) {
                            msg = (tok == 134217764 ? "" + info.get("spaceGroupInfo") + info.get("spaceGroupNote") : "") + (info.containsKey("symmetryInfo") ? info.get("symmetryInfo") : "");
                            break;
                        }
                        int iop = this.tokAt(2) == 2 ? this.intParameter(2) : 0;
                        String xyz = this.tokAt(2) == 4 || this.tokAt(2) == 12 ? this.paramAsStr(2) : null;
                        P3 pt1 = null;
                        P3 pt2 = null;
                        int nth = -1;
                        if (this.slen > 3 && this.tokAt(3) != 4) {
                            Object[] ret = new Object[]{null, this.vwr.getFrameAtoms()};
                            pt1 = eval.centerParameter(2 + (iop == 0 ? 0 : 1), ret);
                            if (ret[0] != null && ((BS)ret[0]).isEmpty()) {
                                len = this.slen;
                                break;
                            }
                            ret[0] = null;
                            pt2 = eval.centerParameter(++eval.iToken, ret);
                            if (ret[0] != null && ((BS)ret[0]).isEmpty()) {
                                len = this.slen;
                                break;
                            }
                            if (iop == 0 && this.tokAt(eval.iToken + 1) == 2) {
                                nth = eval.getToken((int)(++eval.iToken)).intValue;
                            }
                        }
                        String type = eval.iToken > 1 && this.tokAt(eval.iToken + 1) == 4 ? this.stringParameter(++eval.iToken) : null;
                        len = ++eval.iToken;
                        this.checkLength(eval.iToken + filterLen);
                        if (!this.chk) {
                            Object o = this.vwr.getSymmetryInfo(this.vwr.getAllAtoms().nextSetBit(0), xyz, iop, null, pt1, pt2, 0, type, 0.0f, nth, 0, null);
                            msg = o == null ? "" : (o instanceof Map ? SV.getVariable(o).asString() : o.toString());
                        } else {
                            break;
                        }
                    }
                }
                break;
            }
            case 1648363544: {
                VDW vdwType = null;
                if (this.slen > 2) {
                    len = this.slen;
                    vdwType = VDW.getVdwType(this.paramAsStr(2));
                    if (vdwType == null) {
                        this.invArg();
                    }
                }
                if (this.chk) break;
                msg = this.vwr.getDefaultVdwNameOrData(0, vdwType, null);
                break;
            }
            case 134320141: {
                int pt;
                eval.checkLength23();
                len = this.slen;
                String s = eval.optParameterAsString(2);
                if (filter == null && (pt = s.indexOf(47)) >= 0) {
                    filter = s.substring(pt + 1);
                    s = s.substring(0, pt);
                }
                if (this.chk) break;
                msg = this.vwr.getFunctionCalls(s);
                break;
            }
            case 36867: {
                this.checkLength(2 + filterLen);
                if (this.chk) break;
                msg = this.vwr.getAllSettings(null);
                break;
            }
            case 1073742166: {
                msg = this.vwr.getFrameTitle();
                break;
            }
            case 1073742184: {
                len = this.slen;
                if (len == 2) {
                    if (!this.chk) {
                        this.vwr.showUrl(eval.getFullPathName(false));
                    }
                } else {
                    name = this.paramAsStr(2);
                    if (!this.chk) {
                        this.vwr.showUrl(name);
                    }
                }
                return;
            }
            case 1765808134: {
                str = "defaultColorScheme";
                break;
            }
            case 0x60000004: {
                str = "scaleAngstromsPerInch";
                break;
            }
            case 4138: 
            case 134221850: {
                if (this.chk) {
                    return;
                }
                int modelIndex = this.vwr.am.cmi;
                if (modelIndex < 0) {
                    eval.errorStr(30, "show " + eval.theToken.value);
                }
                msg = this.plot(this.st);
                len = this.slen;
                break;
            }
            case 14: 
            case 1112152078: {
                if (this.chk) break;
                msg = this.getContext(false);
                break;
            }
            case 0x40000040: {
                name = eval.optParameterAsString(2);
                if (name.length() > 0) {
                    len = 3;
                }
                if (this.chk) break;
                value = this.vwr.cm.getColorSchemeList(name);
                break;
            }
            case 1073742192: {
                if (this.chk) break;
                msg = this.vwr.getAtomDefs(this.vwr.definedAtomSets) + this.vwr.g.getVariableList() + this.getContext(true);
                break;
            }
            case 0x2000000E: {
                if (this.chk) break;
                msg = this.vwr.getTrajectoryState();
                break;
            }
            case 0x21000010: {
                value = "" + ScriptEval.commandHistoryLevelMax;
                break;
            }
            case 553648148: {
                value = "" + Logger.getLogLevel();
                break;
            }
            case 603979825: {
                value = "" + this.vwr.getBoolean(603979825);
                break;
            }
            case 553648178: {
                msg = "set strandCountForStrands " + this.vwr.getStrandCount(12) + "; set strandCountForMeshRibbon " + this.vwr.getStrandCount(13);
                break;
            }
            case 536875070: {
                len = this.slen;
                msg = this.vwr.showTimeout(len == 2 ? null : this.paramAsStr(2));
                break;
            }
            case 0x20000006: {
                value = Escape.eP(this.vwr.getDefaultLattice());
                break;
            }
            case 4126: {
                if (this.chk) break;
                msg = this.vwr.getMinimizationInfo();
                break;
            }
            case 1611272194: {
                switch (this.vwr.g.axesMode) {
                    case 0x24000020: {
                        msg = "set axesUnitcell";
                        break block1;
                    }
                    case 603979804: {
                        msg = "set axesMolecular";
                        break block1;
                    }
                }
                msg = "set axesWindow";
                break;
            }
            case 0x60000001: {
                msg = "set bondMode " + (this.vwr.getBoolean(0x24000024) ? "OR" : "AND");
                break;
            }
            case 1649022989: {
                if (this.chk) break;
                msg = "set strandCountForStrands " + this.vwr.getStrandCount(12) + "; set strandCountForMeshRibbon " + this.vwr.getStrandCount(13);
                break;
            }
            case 1613238294: {
                msg = "set hbondsBackbone " + this.vwr.getBoolean(603979852) + ";set hbondsSolid " + this.vwr.getBoolean(603979854);
                break;
            }
            case 1611141175: {
                if (this.chk) break;
                msg = this.vwr.getSpinState();
                break;
            }
            case 1611141176: {
                msg = "set ssbondsBackbone " + this.vwr.getBoolean(603979952);
                break;
            }
            case 1610625028: 
            case 1611141172: {
                msg = "selectionHalos " + (this.vwr.getSelectionHalosEnabled() ? "ON" : "OFF");
                break;
            }
            case 0x60200006: {
                msg = "set selectHetero " + this.vwr.getBoolean(0x60200006);
                break;
            }
            case 0x40000004: {
                msg = Escape.eAP(this.vwr.getAdditionalHydrogens(null, null, 768));
                break;
            }
            case 1612709900: {
                msg = "set selectHydrogens " + this.vwr.getBoolean(1612709900);
                break;
            }
            case 0x2000000C: 
            case 0x21000002: 
            case 553648138: 
            case 553648172: 
            case 553648176: 
            case 1073741995: {
                if (this.chk) break;
                msg = this.vwr.getLightingState();
                break;
            }
            case 4146: 
            case 1073742136: {
                if (this.chk) break;
                msg = this.vwr.stm.listSavedStates();
                break;
            }
            case 1814695966: {
                if (this.chk) break;
                len = this.slen;
                if (len == 3) {
                    msg = this.vwr.stm.getSavedUnitCell(this.paramAsStr(2));
                    break;
                }
                msg = this.vwr.getUnitCellInfoText();
                break;
            }
            case 1073742329: {
                len = this.slen;
                if (len == 2) {
                    if (this.chk) break;
                    msg = this.vwr.getCoordinateState(this.vwr.bsA());
                    break;
                }
                String nameC = this.paramAsStr(2);
                if (this.chk) break;
                msg = this.vwr.stm.getSavedCoordinates(nameC);
                break;
            }
            case 1073742158: {
                if (!this.chk && eval.outputBuffer == null && filter == null) {
                    this.vwr.sm.clearConsole();
                }
                if ((len = this.slen) == 2) {
                    if (this.chk) break;
                    msg = this.vwr.getStateInfo();
                    break;
                }
                if (filter != null && this.slen == 3) {
                    if (this.chk) break;
                    msg = this.vwr.getStateInfo();
                    break;
                }
                if (this.tokAt(2) == 1228935687 && (len = this.slen) == 4) {
                    if (this.chk) break;
                    msg = this.vwr.fm.getEmbeddedFileState(this.paramAsStr(3), true, "state.spt");
                    break;
                }
                len = 3;
                name = this.paramAsStr(2);
                if (this.chk) break;
                msg = this.vwr.stm.getSavedState(name);
                break;
            }
            case 1639976963: {
                len = this.slen;
                if (len == 2) {
                    if (this.chk) break;
                    msg = this.vwr.ms.getProteinStructureState(this.vwr.bsA(), 134222350);
                    break;
                }
                String shape = this.paramAsStr(2);
                if (this.chk) break;
                msg = this.vwr.stm.getSavedStructure(shape);
                break;
            }
            case 134221834: {
                boolean isAll;
                String dtype;
                len = this.slen;
                String string = dtype = len == 3 ? this.paramAsStr(2) : null;
                if (this.chk) break;
                String[] data = this.vwr.getDataObj(dtype, null, -2);
                boolean isType = dtype != null && "types".equals(dtype.toLowerCase());
                boolean bl = isAll = isType || "*".equals(dtype);
                if (data == null) {
                    msg = "no data";
                } else if (data instanceof Lst) {
                    Lst list = (Lst)data;
                    data = list.toArray(new String[list.size()]);
                } else if (!isAll) {
                    Object[] odata = data;
                    msg = Escape.encapsulateData((String)odata[0], odata[1], (Integer)odata[3]);
                }
                if (msg != null) break;
                String[] sdata = data;
                if (isType) {
                    sdata[1] = sdata[1].replace('\n', ',');
                }
                msg = Escape.e(sdata);
                break;
            }
            case 1073742330: {
                len = 3;
                msg = eval.setObjectProperty();
                break;
            }
            case 1812599299: {
                if (this.chk) break;
                msg = this.vwr.ms.getBoundBoxCommand(true);
                break;
            }
            case 12289: {
                if (this.chk) break;
                msg = "center " + Escape.eP(this.vwr.tm.fixedRotationCenter);
                break;
            }
            case 135176: {
                if (this.chk) break;
                msg = (String)this.getShapeProperty(22, "command");
                break;
            }
            case 1228935687: {
                if (this.slen == 2) {
                    if (!this.chk) {
                        if (filter == null) {
                            this.vwr.sm.clearConsole();
                        }
                        msg = this.e.getCurrentModelFileAsString(null);
                    }
                    if (msg != null) break;
                    msg = "<unavailable>";
                    break;
                }
                len = 3;
                value = this.paramAsStr(2);
                if (this.chk) break;
                if (filter == null) {
                    this.vwr.sm.clearConsole();
                }
                msg = this.vwr.getFileAsString3(value, true, null);
                break;
            }
            case 4115: {
                if (this.tokAt(2) == 1073742327) {
                    len = 3;
                    if (3 > 0) {
                        msg = this.vwr.getModelFileInfoAll();
                        break;
                    }
                }
                msg = this.vwr.getModelFileInfo();
                break;
            }
            case 1610616855: {
                int n2;
                len = this.slen;
                int n3 = n2 = len == 2 ? Integer.MAX_VALUE : this.intParameter(2);
                if (n2 < 1) {
                    this.invArg();
                }
                if (this.chk) break;
                this.vwr.sm.clearConsole();
                if (eval.scriptLevel == 0) {
                    this.vwr.removeCommand();
                }
                msg = this.vwr.getSetHistory(n2);
                break;
            }
            case 135180: {
                if (this.chk) break;
                msg = (String)this.getShapeProperty(24, "jvxlDataXml");
                break;
            }
            case 1073877010: 
            case 1073877011: {
                int ptMO;
                if (eval.optParameterAsString(2).equalsIgnoreCase("list")) {
                    this.e.sm.loadShape(27);
                    msg = this.chk ? "" : (String)this.getShapeProperty(27, "list -1");
                    len = 3;
                    break;
                }
                len = this.slen;
                int n4 = ptMO = len == 2 ? Integer.MIN_VALUE : this.intParameter(2);
                if (this.chk) break;
                msg = this.getMoJvxl(ptMO, tok == 1073877011);
                break;
            }
            case 1094717454: {
                if (this.chk) break;
                msg = this.vwr.ms.getModelInfoAsString();
                break;
            }
            case 0x20021010: {
                if (this.chk) break;
                msg = this.vwr.getMeasurementInfoAsString();
                break;
            }
            case 1073741864: {
                len = 3;
                if (this.chk || this.slen != len) break;
                msg = this.paramAsStr(2);
                msg = this.vwr.getOrientation(T.getTokFromName(msg.equals("box") ? "volume" : (msg.equals("rotation") ? "best" : msg)), "best", null, null).toString();
                break;
            }
            case 1073742132: {
                tok = this.tokAt(2);
                if (tok == 0) {
                    tok = 1073742132;
                } else {
                    len = 3;
                }
            }
            case 4129: 
            case 1073742178: {
                if (this.chk) break;
                msg = this.vwr.getOrientation(tok, null, null, null).toString();
                break;
            }
            case 1073742077: {
                len = 2;
                if (this.slen > 3) break;
                tok = this.tokAt(2);
                switch (tok) {
                    case 0: 
                    case 4129: 
                    case 1073742132: 
                    case 1073742178: {
                        if (this.chk) break;
                        msg = this.vwr.getOrientation(tok, null, null, null).toString();
                        break;
                    }
                    default: {
                        name = eval.optParameterAsString(2);
                        msg = this.vwr.getOrientation(1073742034, name, null, null).toString();
                    }
                }
                len = this.slen;
                break;
            }
            case 1073742088: {
                if (this.chk) break;
                msg = this.vwr.ms.getPDBHeader(this.vwr.am.cmi);
                break;
            }
            case 1275068447: {
                String typ = eval.optParameterAsString(2);
                if (typ.length() == 0) {
                    typ = null;
                }
                len = this.slen;
                if (this.chk) break;
                msg = this.vwr.ms.getPointGroupAsString(this.vwr.bsA(), "show:" + typ, 0, 0.0f, null, null, null);
                break;
            }
            case 1088421903: {
                if (this.chk) break;
                msg = this.vwr.ms.getSymmetryInfoAsString();
                break;
            }
            case 1073742176: {
                if (this.chk) break;
                msg = "transform:\n" + this.vwr.tm.matrixRotate.toString();
                break;
            }
            case 4168: {
                msg = "zoom " + (this.vwr.tm.zoomEnabled ? "" + this.vwr.tm.getZoomSetting() : "off");
                break;
            }
            case 1611272202: {
                msg = this.vwr.getShowFrank() ? "frank ON" : "frank OFF";
                break;
            }
            case 1665140738: {
                str = "solventProbeRadius";
                break;
            }
            case 1086324744: {
                len = this.slen;
                if (len == 3 && this.tokAt(2) == 1073742334) {
                    tok = 1086324743;
                }
            }
            case 1073741863: 
            case 1073741982: 
            case 1073742120: 
            case 1086324742: 
            case 1086326788: 
            case 1113589787: 
            case 1153433601: {
                if (this.chk) break;
                msg = this.vwr.getChimeInfo(tok);
                break;
            }
            case 20482: 
            case 537022465: 
            case 0x60000002: 
            case 1612709912: {
                value = "?";
                break;
            }
            case 1073742030: {
                String qualifiers;
                len = this.slen;
                String string = qualifiers = len == 2 ? null : this.paramAsStr(2);
                if (this.chk) break;
                msg = this.vwr.getBindingInfo(qualifiers);
                break;
            }
            case 1073742015: {
                if (this.chk) break;
                value = this.vwr.getMenu("");
                break;
            }
            case 0x40000000: {
                if (!str.equalsIgnoreCase("fileHeader") || this.chk) break;
                msg = this.vwr.ms.getPDBHeader(this.vwr.am.cmi);
                break;
            }
            case 36868: 
            case 1073741992: {
                str = this.paramAsStr(len++);
                SV v = (SV)eval.getParameter(str, 1073742190, true);
                if (this.chk) break;
                msg = tok == 1073741992 ? v.toJSON() : v.escape();
            }
        }
        this.checkLength(len + filterLen);
        if (this.chk) {
            return;
        }
        if (msg != null) {
            this.showString(this.filterShow(msg, filter));
        } else if (value != null) {
            this.showString(str + " = " + value);
        } else if (str != null) {
            if (str.indexOf(" ") >= 0) {
                this.showString(str);
            } else {
                this.showString(str + " = " + ((SV)eval.getParameter(str, 1073742190, true)).escape());
            }
        }
    }

    private String filterShow(String msg, String name) {
        if (name == null) {
            return msg;
        }
        boolean isNot = name.startsWith("!/");
        name = name.substring(isNot ? 2 : 1).toLowerCase();
        String[] info = PT.split(msg, "\n");
        SB sb = new SB();
        for (int i = 0; i < info.length; ++i) {
            if (info[i].toLowerCase().indexOf(name) < 0 != isNot) continue;
            sb.append(info[i]).appendC('\n');
        }
        return sb.toString();
    }

    private void stereo() throws ScriptException {
        STER stereoMode = STER.DOUBLE;
        float degrees = -5.0f;
        boolean degreesSeen = false;
        int[] colors = null;
        int colorpt = 0;
        block6: for (int i = 1; i < this.slen; ++i) {
            if (this.e.isColorParam(i)) {
                if (colorpt > 1) {
                    this.e.bad();
                }
                if (colorpt == 0) {
                    colors = new int[2];
                }
                if (!degreesSeen) {
                    degrees = 3.0f;
                }
                colors[colorpt] = this.e.getArgbParam(i);
                if (colorpt++ == 0) {
                    colors[1] = ~colors[0];
                }
                i = this.e.iToken;
                continue;
            }
            switch (this.getToken((int)i).tok) {
                case 1073742335: {
                    this.e.iToken = 1;
                    this.e.checkLast(1);
                    this.e.iToken = 1;
                    continue block6;
                }
                case 1073742334: {
                    this.e.iToken = 1;
                    this.e.checkLast(1);
                    stereoMode = STER.NONE;
                    continue block6;
                }
                case 2: 
                case 3: {
                    degrees = this.floatParameter(i);
                    degreesSeen = true;
                    continue block6;
                }
                case 0x40000000: {
                    if (!degreesSeen) {
                        degrees = 3.0f;
                    }
                    if ((stereoMode = STER.getStereoMode(this.paramAsStr(i))) != null) continue block6;
                }
                default: {
                    this.invArg();
                }
            }
        }
        if (this.chk) {
            return;
        }
        this.vwr.setStereoMode(colors, stereoMode, degrees);
    }

    private boolean struts() throws ScriptException {
        ScriptEval eval = this.e;
        boolean defOn = this.tokAt(1) == 1073742072 || this.tokAt(1) == 1073742335 || this.slen == 1;
        int mad = eval.getMadParameter();
        if (mad == Integer.MAX_VALUE) {
            return false;
        }
        if (defOn) {
            mad = Math.round(this.vwr.getFloat(570425406) * 2000.0f);
        }
        this.setShapeProperty(1, "type", 32768);
        eval.setShapeSizeBs(1, mad, null);
        this.setShapeProperty(1, "type", 1023);
        return true;
    }

    private void unitcell(int i, boolean isModelkit) throws ScriptException {
        ScriptEval eval = this.e;
        int icell = Integer.MAX_VALUE;
        int mad10 = Integer.MAX_VALUE;
        T3 pt = null;
        TickInfo tickInfo = eval.tickParamAsStr(i, true, false, false);
        i = eval.iToken;
        String id = null;
        T3[] oabc = null;
        Object newUC = null;
        String ucname = null;
        boolean isOffset = false;
        boolean isReset = false;
        boolean isPacked = false;
        SymmetryInterface sym = this.chk ? null : this.vwr.getCurrentUnitCell();
        int tok = this.tokAt(++i);
        switch (tok) {
            case 1073742333: {
                if (!this.chk) {
                    this.vwr.ms.clearUnitCell(this.vwr.am.cmi);
                }
                return;
            }
            case 4141: 
            case 4142: {
                isReset = true;
                pt = P4.new4(0.0f, 0.0f, 0.0f, -1.0f);
                ++eval.iToken;
                break;
            }
            case 2097180: {
                boolean refTop;
                P4 plane = eval.hklParameter(i + 1, null, false);
                T3 hkl = eval.getPointOrPlane(i + 1, 7);
                i = eval.iToken;
                float zscale = Float.NaN;
                if (this.isFloatParameter(i + 1)) {
                    zscale = this.floatParameter(++i);
                    if (this.tokAt(i + 1) == 268441090) {
                        zscale = -zscale / 100.0f;
                        ++i;
                    }
                }
                float zoffset = Float.NaN;
                boolean zoffPercent = false;
                if (this.isFloatParameter(i + 1)) {
                    zoffset = this.floatParameter(++i);
                    if (this.tokAt(i + 1) == 268441090) {
                        zoffPercent = true;
                        ++i;
                    }
                }
                boolean bl = refTop = this.tokAt(i + 1) == 1073742172;
                if (refTop) {
                    ++i;
                }
                eval.iToken = i;
                if (this.chk) break;
                if (hkl instanceof P3) {
                    hkl = P4.new4(hkl.x, hkl.y, hkl.z, 0.0f);
                } else if (Float.isNaN(zoffset)) {
                    zoffset = ((P4)hkl).w;
                }
                oabc = this.getUVBoxFromHKL(sym, (P4)hkl, plane);
                P3 p = new P3();
                V3 vt = new V3();
                Measure.getPlaneProjection(new P3(), plane, p, vt);
                if (zscale > 0.0f) {
                    oabc[3].normalize();
                    oabc[3].scale(zscale);
                } else if (zscale < 0.0f) {
                    oabc[3].scale(-zscale);
                }
                if (!Float.isNaN(zoffset) && zoffset != 0.0f) {
                    if (zoffPercent) {
                        zoffset = zoffset / 100.0f * oabc[3].length();
                    }
                    oabc[0].scaleAdd2(zoffset, vt, oabc[0]);
                }
                if (refTop) {
                    oabc[0].scaleAdd2(-oabc[3].length(), vt, oabc[0]);
                }
                ucname = "surface" + (int)hkl.x + (int)hkl.y + (int)hkl.z;
                break;
            }
            case 536875059: 
            case 1073742163: {
                pt = tok == 536875059 ? eval.getPointOrPlane(++i, 19) : eval.checkHKL(eval.getFractionalPoint(++i));
                i = eval.iToken;
                if (this.chk) break;
                oabc = sym.getUnitCellVectors();
                oabc[1].scale(Math.abs(pt.x));
                oabc[2].scale(Math.abs(pt.y));
                oabc[3].scale(Math.abs(pt.z));
                pt = null;
                ucname = "supercell";
                break;
            }
            case 1073741938: {
                pt = eval.getFractionalPoint(++i);
                i = eval.iToken;
                if (this.chk) break;
                pt = SimpleUnitCell.ptToIJK(eval.checkHKL(pt), 1);
                break;
            }
            case 135180: 
            case 1073742330: {
                id = eval.objectNameParameter(++i);
                break;
            }
            case 1812599299: {
                eval.iToken = i;
                if (this.chk) break;
                P3 o = P3.newP(this.vwr.getBoundBoxCenter());
                pt = this.vwr.getBoundBoxCornerVector();
                o.sub(pt);
                oabc = new P3[]{o, P3.new3(pt.x * 2.0f, 0.0f, 0.0f), P3.new3(0.0f, pt.y * 2.0f, 0.0f), P3.new3(0.0f, 0.0f, pt.z * 2.0f)};
                pt = null;
                break;
            }
            case 1073742176: {
                if (this.tokAt(++i) != 12) {
                    this.invArg();
                }
                if (this.chk) break;
                newUC = new Object[]{this.getToken((int)i).value};
                break;
            }
            case 11: 
            case 12: {
                newUC = this.getToken((int)i).value;
                break;
            }
            case 12289: {
                switch (this.tokAt(++i)) {
                    case 10: 
                    case 12290: 
                    case 1073742325: {
                        pt = this.vwr.ms.getAtomSetCenter(this.atomExpressionAt(i));
                        i = eval.iToken;
                        if (this.chk) break;
                        this.vwr.toFractional(pt, true);
                        break;
                    }
                    default: {
                        if (eval.isCenterParameter(i)) {
                            pt = this.centerParameter(i);
                            i = eval.iToken;
                            break;
                        }
                        this.invArg();
                    }
                }
                pt.x -= 0.5f;
                pt.y -= 0.5f;
                pt.z -= 0.5f;
                break;
            }
            case 10: 
            case 12290: 
            case 1073742325: {
                int iAtom = this.atomExpressionAt(i).nextSetBit(0);
                i = eval.iToken;
                if (!this.chk) {
                    this.vwr.setUnitCellAtomIndex(iAtom);
                }
                if (iAtom >= 0) break;
                return;
            }
            case 1073742066: {
                isOffset = true;
                if (eval.isAtomExpression(i + 1)) {
                    pt = eval.centerParameter(++i, null);
                    i = eval.iToken;
                    if (this.chk) break;
                    this.vwr.toFractional(pt, false);
                    break;
                }
            }
            case 1073742114: {
                pt = eval.getFractionalPoint(++i);
                if (pt instanceof P4) {
                    if (!isOffset) break;
                    this.invArg();
                    break;
                }
                i = eval.iToken;
                if (this.chk) break;
                if (!isOffset && pt.x < 555.0f) {
                    pt = SimpleUnitCell.ptToIJK(eval.checkHKL(pt), 1);
                    break;
                }
                pt = P4.new4(pt.x, pt.y, pt.z, isOffset ? 1 : 0);
                break;
            }
            case 2: 
            case 3: {
                float f = this.floatParameter(i);
                if (f < 111.0f) {
                    --i;
                    break;
                }
                icell = this.intParameter(i);
                break;
            }
            case 4: 
            case 0x40000000: {
                boolean modelIsPrimitive;
                String s = this.paramAsStr(i).toLowerCase();
                if (s.equals("rhombohedral") || s.equals("r")) {
                    if (sym != null && sym.getUnitCellInfoType(8) == 0.0f) {
                        return;
                    }
                    s = "2/3a+1/3b+1/3c,-1/3a+1/3b+1/3c,-1/3a-2/3b+1/3c";
                } else if (s.equals("trigonal") || s.equals("hexagonal")) {
                    if (sym != null && sym.getUnitCellInfoType(9) == 0.0f) {
                        return;
                    }
                    s = "a-b,b-c,a+b+c";
                }
                ucname = s;
                if (s.indexOf(",") >= 0 || this.chk) {
                    newUC = s;
                    break;
                }
                String stype = null;
                this.vwr.ms.setModelCagePts(-1, null, null);
                newUC = this.vwr.getModelInfo("unitcell_conventional");
                boolean bl = modelIsPrimitive = this.vwr.getModelInfo("isprimitive") != null;
                if (PT.isOneOf(ucname, ";parent;standard;primitive;")) {
                    if (newUC == null && modelIsPrimitive) {
                        this.showString("Cannot convert unit cell when file data is primitive and have no lattice information");
                        return;
                    }
                    if (ucname.equals("primitive") && this.tokAt(i + 1) == 4) {
                        stype = this.paramAsStr(++i).toUpperCase();
                    }
                }
                if (newUC instanceof T3[]) {
                    oabc = (T3[])newUC;
                }
                if (stype == null) {
                    stype = (String)this.vwr.getModelInfo("latticeType");
                }
                if (newUC != null) {
                    this.vwr.ms.setModelCagePts(-1, this.vwr.getV0abc(-1, newUC), "" + newUC);
                    newUC = null;
                }
                if (ucname.equals("conventional")) break;
                this.setShapeProperty(34, "labels", null);
                s = (String)this.vwr.getModelInfo("unitcell_" + ucname);
                if (s == null) {
                    T3[] t3Array;
                    boolean isPrimitive = ucname.equals("primitive");
                    if (!isPrimitive && !ucname.equals("reciprocal")) break;
                    float scale = (float)(this.slen == i + 1 ? 1.0 : (this.tokAt(i + 1) == 2 ? (double)this.intParameter(++i) * Math.PI : (double)this.floatParameter(++i)));
                    ucname = (sym == null ? "" : sym.getSpaceGroupName() + " ") + ucname;
                    if (sym == null) {
                        P3[] p3Array = new P3[4];
                        p3Array[0] = P3.new3(0.0f, 0.0f, 0.0f);
                        p3Array[1] = P3.new3(1.0f, 0.0f, 0.0f);
                        p3Array[2] = P3.new3(0.0f, 1.0f, 0.0f);
                        t3Array = p3Array;
                        p3Array[3] = P3.new3(0.0f, 0.0f, 1.0f);
                    } else {
                        t3Array = oabc = sym.getUnitCellVectors();
                    }
                    if (stype == null) {
                        stype = (String)this.vwr.getSymmetryInfo(this.vwr.getFrameAtoms().nextSetBit(0), null, 0, null, null, null, 0x400000AA, null, 0.0f, -1, 0, null);
                    }
                    if (sym == null) {
                        sym = this.vwr.getSymTemp();
                    }
                    if (!modelIsPrimitive) {
                        sym.toFromPrimitive(true, stype.length() == 0 ? (char)'P' : (char)stype.charAt(0), oabc, (M3)this.vwr.getCurrentModelAuxInfo().get("primitiveToCrystal"));
                    }
                    if (isPrimitive) break;
                    SimpleUnitCell.getReciprocal(oabc, oabc, scale);
                    break;
                }
                ucname = s;
                if (s.indexOf(",") < 0) break;
                newUC = s;
                break;
            }
            default: {
                Object[] ret = new Object[1];
                if (this.getUnitCellParameter(i, ret)) {
                    oabc = (T3[])ret[0];
                } else {
                    newUC = ret[0];
                }
                if (newUC == null && oabc == null) {
                    if (this.slen > i + 1) {
                        pt = eval.getFractionalPoint(i);
                        i = eval.iToken;
                        break;
                    }
                    --i;
                    break;
                }
                if (newUC != null) {
                    if (!this.chk && isModelkit) {
                        if (sym == null) {
                            this.assignSpaceGroup(null, "P1", newUC, false, false, "unitcell");
                        } else if (sym.fixUnitCell((float[])newUC)) {
                            eval.invArgStr("Unit cell is incompatible with current space group");
                        }
                    }
                    i = eval.iToken;
                    break;
                }
                if (oabc == null) break;
                i = eval.iToken;
            }
        }
        if (isModelkit && this.tokAt(i + 1) == 0x40000100) {
            isPacked = true;
            i = ++eval.iToken;
        }
        mad10 = eval.getSetAxesTypeMad10(++i);
        eval.checkLast(eval.iToken);
        if (this.chk || mad10 == Integer.MAX_VALUE) {
            return;
        }
        if (mad10 == Integer.MAX_VALUE) {
            this.vwr.am.setUnitCellAtomIndex(-1);
        }
        if (oabc == null && newUC != null) {
            oabc = this.vwr.getV0abc(-1, newUC);
        }
        if (icell != Integer.MAX_VALUE) {
            if (sym != null) {
                sym.setOffset(icell);
            }
        } else if (id != null) {
            this.vwr.setCurrentCage(id);
        } else if (isReset || oabc != null) {
            boolean bl = isReset = isModelkit || sym == null ? this.vwr.getModelkit(false).transformAtomsToUnitCell(sym, oabc, ucname) : true;
            if (isReset) {
                if (isModelkit && sym != null) {
                    this.vwr.ms.setSpaceGroup(this.vwr.am.cmi, sym.getUnitCell(oabc, false, null), null);
                    return;
                }
                this.vwr.ms.setModelCagePts(-1, oabc, ucname);
                if (sym == null) {
                    this.vwr.setNewRotationCenter(this.vwr.getUnitCellCenter());
                }
            }
        }
        eval.setObjectMad10(33, "unitCell", mad10);
        if (pt != null && (sym = this.vwr.ms.getUnitCell(Integer.MIN_VALUE)) != null) {
            sym.setOffsetPt(pt);
        }
        if (isModelkit && sym.getFractionalOffset(true) == null) {
            sym = this.vwr.ms.getUnitCell(-1 - this.vwr.am.cmi);
            this.assignSpaceGroup(this.vwr.getModelUndeletedAtomsBitSet(this.vwr.am.cmi), sym.getSpaceGroupClegId(), null, isPacked, false, this.e.fullCommand);
        }
        if (tickInfo != null) {
            this.setShapeProperty(33, "tickInfo", tickInfo);
        }
        if (ucname != null) {
            this.showString(ucname + (oabc == null ? "" : " " + Escape.e(oabc)));
        }
    }

    private P3[] getUVBoxFromHKL(SymmetryInterface uc, P4 hkl, P4 plane) throws ScriptException {
        int h = (int)hkl.x;
        int k = (int)hkl.y;
        int l = (int)hkl.z;
        if (h == 0 && k == 0 && l == 0 || (float)h != hkl.x || (float)k != hkl.y || (float)l != hkl.z) {
            this.invArg();
        }
        while (h % 2 == 0 && k % 2 == 0 && l % 2 == 0) {
            h /= 2;
            k /= 2;
            l /= 2;
        }
        P3[] oabc = uc.getUnitCellVectors();
        float dist0 = plane.w;
        P4 p0 = P4.new4(plane.x, plane.y, plane.z, 0.0f);
        int max = Math.max(Math.max(h, k), l);
        Lst<P3> cpts = Measure.getLatticePoints(uc.getLatticeCentering(), max, max, max);
        int j = cpts.size();
        while (--j >= 0) {
            uc.toCartesian((T3)cpts.get(j), true);
        }
        cpts = Measure.getPointsOnPlane(cpts.toArray(new P3[cpts.size()]), p0);
        P3 zero = new P3();
        float amin = -179.0f;
        float dmin = Float.MAX_VALUE;
        float dmin2 = Float.MAX_VALUE;
        P3 v = null;
        P3 v1 = null;
        float da = amin;
        float damin = Float.MAX_VALUE;
        int i = cpts.size();
        while (--i >= 0) {
            boolean okAng;
            P3 pt = (P3)cpts.get(i);
            float d = pt.length();
            boolean isLinear = false;
            boolean isNew = false;
            if (d < 0.01f) continue;
            if (v != null) {
                float f;
                da = Math.abs(Measure.computeTorsion(v, zero, plane, pt, true));
                if (f > -amin) continue;
            }
            boolean bl = isLinear = da < 1.0f;
            if (v == null) {
                v = pt;
                dmin = d;
                continue;
            }
            if (d < dmin - 0.01f) {
                isNew = true;
                damin = Float.MAX_VALUE;
                da = Float.MAX_VALUE;
            } else if (d < dmin2 - 0.01f) {
                damin = Float.MAX_VALUE;
            } else if (!(d >= dmin2 + 0.01f)) continue;
            if (isNew || (okAng = da > 89.0f) && d < dmin + 0.1f && pt.x >= -0.01f && pt.y <= 0.01f && (damin == Float.MAX_VALUE || damin < 89.0f)) {
                if (isLinear) {
                    v1 = null;
                    dmin2 = Float.MAX_VALUE;
                } else {
                    v1 = v;
                    dmin2 = dmin;
                }
                v = pt;
                dmin = d;
                if (isNew || !(da < damin)) continue;
                damin = da;
                continue;
            }
            if (!okAng || !(d < dmin2 + 0.1f)) continue;
            v1 = pt;
            dmin2 = d;
            if (!(da < damin)) continue;
            damin = da;
        }
        if (v == null) {
            this.invArg();
        }
        P3 u = null;
        if (v1 == null) {
            int i2 = cpts.size();
            while (--i2 >= 0) {
                P3 pt = (P3)cpts.get(i2);
                da = Measure.computeTorsion(v, zero, plane, pt, true);
                if (!((double)da < -89.9) || !(da > amin + 0.01f)) continue;
                amin = da;
                u = pt;
            }
        } else {
            da = Measure.computeTorsion(v, zero, plane, v1, true);
            if (da > 1.0f) {
                u = v;
                v = v1;
            } else {
                u = v1;
            }
        }
        if (u == null) {
            this.invArg();
        }
        oabc[1] = u;
        oabc[2] = v;
        boolean doReverse = ((h < 0 ? 1 : 0) + (k < 0 ? 1 : 0) + (l < 0 ? 1 : 0)) % 2 == 1;
        P3 w = oabc[3];
        P3 a = P3.newP(u);
        P3 b = P3.newP(v);
        if (h == 0 && k == 0) {
            b.scale(-1.0f);
            a.scale(-1.0f);
            oabc[1] = a;
            oabc[2] = b;
        } else if ((h != 0 || l != 0) && k == 0 && l == 0) {
            a.scale(-1.0f);
            b.scale(-1.0f);
            oabc[1] = b;
            oabc[2] = a;
        }
        if (doReverse) {
            a = oabc[1];
            oabc[1] = oabc[2];
            oabc[2] = a;
        }
        w.cross(v, u);
        w.normalize();
        w.scale(dist0);
        return oabc;
    }

    private void modelkit() throws ScriptException {
        int i = 0;
        int tok = this.tokAt(1);
        switch (tok) {
            case 4139: 
            case 603984065: {
                if (this.chk) {
                    this.e.cmdUndoRedo(tok == 603984065 ? 4165 : 4140);
                }
                return;
            }
            case 1073742334: {
                if (this.e.isStateScript) {
                    this.vwr.getModelkit(false).setProperty("updatekeysfromstate", null);
                }
                if (this.slen == 2 && this.vwr.getModelkitPropertySafely("exists") == null) {
                    return;
                }
            }
            case 0: 
            case 1073742335: {
                if (!this.chk) {
                    this.vwr.setBooleanProperty("modelkitmode", tok != 1073742334);
                }
                if (this.tokAt(i + 1) == 0) {
                    return;
                }
                i = ++this.e.iToken;
                break;
            }
            case 4126: {
                if (this.vwr.am.cmi < 0) {
                    this.e.errorStr(30, "MODELKIT MINIMIZE");
                }
                this.minimize(true);
                return;
            }
            case 4145: 
            case 528432: {
                this.e.cmdRotate(false, true);
                return;
            }
            case 4098: {
                ++this.e.iToken;
            }
            case 4106: 
            case 4129: 
            case 12291: 
            case 12297: 
            case 135176: 
            case 134217764: 
            case 0x40000100: 
            case 1275069441: {
                this.assign(true);
                return;
            }
            case 4130: {
                ++this.e.iToken;
                this.mutate();
                return;
            }
        }
        ModelKit kit = this.vwr.getModelkit(false);
        block38: while ((tok = this.tokAt(++i)) != 0) {
            String key = this.paramAsStr(i).toLowerCase();
            Object[] value = null;
            block10 : switch (tok) {
                case 1073742334: 
                case 1073742335: {
                    if (this.chk) continue block38;
                    this.vwr.setBooleanProperty("modelkitmode", tok == 1073742335);
                    if (tok != 1073742334) continue block38;
                    this.vwr.setStringProperty("picking", "identify");
                    continue block38;
                }
                case 12294: 
                case 1610625028: {
                    key = "hidden";
                    value = tok != 1610625028;
                    break;
                }
                case 12293: {
                    key = "constraint";
                    value = "";
                    int type = this.tokAt(++i);
                    P3 v1 = null;
                    P3 v2 = null;
                    P4 plane = null;
                    switch (type) {
                        case 1073742333: 
                        case 1073742334: {
                            if (this.chk) break;
                            this.vwr.setBooleanProperty("dragPicking", false);
                            break;
                        }
                        case 135198: {
                            v1 = this.e.getPoint3f(++i, true, true);
                            i = this.e.iToken;
                            v2 = this.e.getPoint3f(++i, true, true);
                            value = null;
                            break;
                        }
                        case 0x8000801: {
                            plane = this.e.hklParameter(++i, null, true);
                            value = null;
                            break;
                        }
                        case 134217750: {
                            plane = this.e.planeParameter(++i, false);
                            value = null;
                            break;
                        }
                        default: {
                            this.invArg();
                        }
                    }
                    if (value == null) {
                        if ((v1 == null || v2 == null) == (plane == null)) {
                            this.invArg();
                        }
                        value = new Object[]{v1, v2, plane};
                    } else {
                        value = null;
                    }
                    i = this.e.iToken;
                    break;
                }
                case 36867: {
                    key = this.paramAsStr(++i);
                    value = this.tokAt(++i) == 0 ? "true" : this.paramAsStr(i);
                    break;
                }
                case 4166: {
                    key = "vibration";
                    switch (this.tokAt(++i)) {
                        case 1073742334: {
                            value = "off";
                            break block10;
                        }
                        case 1086324754: {
                            value = "wyckoff";
                            break block10;
                        }
                    }
                    this.invArg();
                    break;
                }
                case 1296041985: {
                    switch (this.tokAt(++i)) {
                        case 4: 
                        case 1073742333: {
                            value = this.paramAsStr(i);
                            break block10;
                        }
                        case 12: {
                            value = this.getToken((int)i).value;
                            break block10;
                        }
                        case 2: {
                            value = this.getToken((int)i).intValue;
                            break block10;
                        }
                    }
                    if (this.e.isCenterParameter(i)) {
                        key = "center";
                        value = this.e.centerParameter(i, null);
                        i = this.e.iToken;
                        break;
                    }
                    this.invArg();
                    break;
                }
                case 1073742066: {
                    value = this.paramAsStr(i + 1);
                    if (value.equals("none")) {
                        ++i;
                        break;
                    }
                }
                case 12289: 
                case 134217751: {
                    value = this.e.atomCenterOrCoordinateParameter(++i, null);
                    i = this.e.iToken;
                    break;
                }
                case 1073742024: {
                    value = this.paramAsStr(++i).toLowerCase();
                    if (this.vwr.isModelKitOption('M', (String)value)) break;
                    this.invArg();
                    break;
                }
                case 1814695966: {
                    if (this.e.isArrayParameter(i + 1)) {
                        this.unitcell(2, true);
                        return;
                    }
                    Object[] objectArray = value = this.tokAt(i + 1) == 4 ? this.paramAsStr(++i).toLowerCase() : null;
                    if (value != null && this.vwr.isModelKitOption('U', (String)value)) break;
                    this.unitcell(2, true);
                    return;
                }
                case 1088421903: {
                    value = this.paramAsStr(++i).toLowerCase();
                    if (this.vwr.isModelKitOption('S', (String)value)) break;
                    this.invArg();
                    break;
                }
                default: {
                    if (this.vwr.isModelKitOption('B', key)) {
                        value = (tok = this.tokAt(++i)) == 0 || tok == 1073742335;
                        break;
                    }
                    if (this.vwr.isModelKitOption('M', key)) {
                        value = key;
                        key = "mode";
                        break;
                    }
                    if (this.vwr.isModelKitOption('U', key)) {
                        value = key;
                        key = "unitcell";
                        break;
                    }
                    this.invArg();
                }
            }
            if (this.chk || value == null || (value = kit.setProperty(key, value)) == null || key == "hidden" || kit.isHidden()) continue;
            this.vwr.showString("modelkit SET " + key + " " + value.toString(), false);
        }
    }

    private void assign(boolean isModelkit) throws ScriptException {
        boolean isPacked;
        if (this.vwr.am.cmi < 0) {
            this.invArg();
        }
        BS bsModelAtoms = this.vwr.getThisModelAtoms();
        int i = ++this.e.iToken;
        boolean doDraw = false;
        boolean isZap = false;
        int mode = this.tokAt(i);
        if (mode == 135176) {
            if (this.tokAt(2) != 134217764) {
                this.invArg();
            }
            doDraw = true;
            mode = 12297;
        }
        if (mode == 12297) {
            if (!isModelkit) {
                this.invArg();
            }
            isZap = true;
            if ((mode = this.tokAt(++i)) == 0) {
                return;
            }
        }
        boolean isAtom = mode == 1153433601;
        boolean isBond = mode == 1677721602;
        boolean isAdd = mode == 1275069441;
        boolean isConnect = mode == 4106;
        boolean isDelete = mode == 12291;
        boolean isMove = mode == 4129;
        boolean isSpacegroup = mode == 134217764;
        boolean bl = isPacked = mode == 0x40000100;
        if ((isPacked || isSpacegroup) && !isModelkit) {
            this.invArg();
        }
        if (isAtom || isBond || isConnect || isSpacegroup || isDelete || isMove || isAdd || isPacked) {
            ++i;
        } else {
            isAtom = true;
            mode = 1153433601;
        }
        int index = -1;
        int index2 = -1;
        BS bs = null;
        if (isBond) {
            if (this.tokAt(i) == 2) {
                index = this.e.intParameter(i);
            } else if (this.getToken((int)i).value instanceof BondSet) {
                index = ((BS)this.getToken((int)i).value).nextSetBit(0);
            } else {
                bs = this.expFor(i, bsModelAtoms);
                index = bs.nextSetBit(0);
                switch (bs.cardinality()) {
                    case 1: {
                        i = ++this.e.iToken;
                        bs = this.expFor(this.e.iToken, bsModelAtoms);
                        index2 = bs.nextSetBit(0);
                        if (index2 < 0) {
                            this.invArg();
                        }
                        bs.set(index);
                    }
                    case 2: {
                        bs = this.vwr.ms.getBondsForSelectedAtoms(bs, false);
                        if (!bs.isEmpty()) {
                            index = bs.nextSetBit(0);
                            break;
                        }
                        isConnect = true;
                        mode = 4106;
                        break;
                    }
                    default: {
                        this.invArg();
                    }
                }
            }
            i = ++this.e.iToken;
        } else if (isPacked) {
            bs = bsModelAtoms;
        } else if (!(isAtom && this.tokAt(i) == 4 || mode == 1275069441 || isSpacegroup && !this.e.isAtomExpression(i))) {
            bs = this.expFor(i, bsModelAtoms);
            index = bs.nextSetBit(0);
            if (index < 0) {
                return;
            }
            i = ++this.e.iToken;
        }
        SymmetryInterface sym = this.vwr.getOperativeSymmetry();
        String type = null;
        P3 pt = null;
        String wyckoff = null;
        Object paramsOrUC = null;
        P3[] pts = null;
        if (isAdd) {
            if (this.e.isAtomExpression(i)) {
                bs = this.expFor(++this.e.iToken, bsModelAtoms);
                i = this.e.iToken;
                type = this.e.optParameterAsString(i + 1);
                i = this.e.iToken;
                if (type.toLowerCase().equals("packed")) {
                    isPacked = true;
                    type = "";
                }
            } else if (this.e.tokAt(i) == 1086324754) {
                this.e.iToken = i - 1;
                type = "O";
            } else {
                type = this.e.optParameterAsString(i);
            }
            if (this.e.isPoint3f(this.e.iToken + 1)) {
                pt = this.getPoint3f(++this.e.iToken, true);
            } else if (this.e.isArrayParameter(this.e.iToken + 1)) {
                pts = this.e.getPointArray(this.e.iToken + 1, -1, false);
            }
            if (type.length() == 0) {
                type = null;
            }
            switch (this.tokAt(this.e.iToken + 1)) {
                case 0x40000100: {
                    isPacked = true;
                    ++this.e.iToken;
                    break;
                }
                case 1086324754: {
                    char w;
                    ++this.e.iToken;
                    wyckoff = this.paramAsStr(++this.e.iToken);
                    char c = wyckoff.equalsIgnoreCase("all") ? (char)'L' : (wyckoff.equalsIgnoreCase("general") ? (char)'G' : (w = wyckoff.length() > 1 || wyckoff.length() == 0 ? (char)'\u0000' : (char)wyckoff.charAt(0)));
                    if (w < 'a' && w != 'A' && w != 'G' && w != 'L' || w > 'z') {
                        this.invArg();
                    }
                    wyckoff = "" + w;
                    if (!"packed".equals(this.e.optParameterAsString(this.e.iToken + 1))) break;
                    isPacked = true;
                    ++this.e.iToken;
                }
            }
        } else if (isMove) {
            if (this.e.isArrayParameter(i)) {
                pts = this.e.getPointArray(i, -1, false);
            } else {
                pt = this.getPoint3f(i, true);
            }
            i = this.e.iToken;
        } else if (isSpacegroup) {
            type = this.e.optParameterAsString(i);
            if (type.length() == 0) {
                type = ".";
            }
            sym = this.vwr.getOperativeSymmetry();
            if (type.equals(".")) {
                if (sym == null) {
                    type = "P1";
                } else {
                    String string = type = i == this.slen ? null : sym.getSpaceGroupClegId();
                }
            }
            if ("packed".equalsIgnoreCase(type)) {
                isPacked = true;
                type = sym.getSpaceGroupClegId();
            }
            if (this.tokAt(this.e.iToken + 1) == 1814695966) {
                Object[] ret = new Object[1];
                this.getUnitCellParameter(this.e.iToken + 2, ret);
                paramsOrUC = ret[0];
                if (paramsOrUC == null) {
                    this.invArg();
                }
            }
            if (!isPacked && this.tokAt(this.e.iToken + 1) == 0x40000100) {
                isPacked = true;
                ++this.e.iToken;
            }
        } else if (isConnect) {
            if (index2 < 0) {
                bs = this.expFor(i, bsModelAtoms);
                index2 = bs.nextSetBit(0);
                type = this.e.optParameterAsString(++this.e.iToken);
            }
        } else {
            type = this.e.optParameterAsString(i);
            if (isAtom) {
                P3 p3 = pt = ++this.e.iToken < this.slen ? this.centerParameter(this.e.iToken) : null;
            }
        }
        if (this.chk) {
            return;
        }
        this.vwr.pushState();
        switch (mode) {
            case 1153433601: {
                this.e.clearDefinedVariableAtomSets();
                this.vwr.getModelkit(false).cmdAssignAtom(bs, pt, type, this.e.fullCommand);
                break;
            }
            case 1677721602: {
                this.vwr.getModelkit(false).cmdAssignBond(index, (type + "-").charAt(0), this.e.fullCommand);
                break;
            }
            case 4106: {
                this.vwr.getModelkit(false).cmdAssignConnect(index, index2, (type + "1").charAt(0), this.e.fullCommand);
                break;
            }
            case 0x40000100: {
                type = null;
            }
            case 1086324754: 
            case 1275069441: {
                if (pts == null) {
                    if (pt != null) {
                        pts = new P3[]{pt};
                    } else if (bs == null && wyckoff == null) {
                        if (type == null) {
                            this.invArg();
                        } else {
                            wyckoff = "G";
                        }
                    }
                }
                int na = this.vwr.getModelkit(false).cmdAssignAddAtoms(type + (wyckoff != null ? ":" + wyckoff : ""), pts, bs, isPacked ? "packed" : "", this.e.fullCommand);
                if (!this.e.doReport()) break;
                this.e.report(GT.i(GT.$("{0} atoms added"), na), false);
                break;
            }
            case 12291: {
                int nd = this.vwr.getModelkit(false).cmdAssignDeleteAtoms(bs);
                if (!this.e.doReport()) break;
                this.e.report(GT.i(GT.$("{0} atoms deleted"), nd), false);
                break;
            }
            case 4129: {
                int nm = this.vwr.getModelkit(false).cmdAssignMoveAtoms(bs, index, P3.newP(pt), pts, true, false);
                if (nm > 0) {
                    this.vwr.checkCoordinatesChanged(bs);
                }
                if (!this.e.doReport()) break;
                this.e.report(GT.i(GT.$("{0} atoms moved"), nm), false);
                break;
            }
            case 134217764: {
                String s;
                boolean isError;
                if (isZap) {
                    this.vwr.zap(false, false, false);
                    sym = null;
                }
                if (isPacked && type.equalsIgnoreCase("packed")) {
                    type = null;
                    if (sym == null) {
                        this.invArg();
                    }
                } else {
                    if (!isPacked) {
                        int ptend;
                        for (int j = ptend = i + 1; j < this.slen; ++j) {
                            if (this.tokAt(j) != 0x40000100) continue;
                            isPacked = true;
                            ptend = j;
                            break;
                        }
                        if (ptend < this.slen) {
                            type = null;
                        }
                    }
                    if (type == null) {
                        type = this.concatString(i, isPacked ? "packed" : "unitcell");
                    }
                    if (type.length() > 0 && type.indexOf(":") < 0 && type.indexOf(">") < 0 && (type.indexOf(",") > 0 || "rh".indexOf(type) >= 0)) {
                        if (sym == null) {
                            this.invArg();
                        }
                        String cleg = sym.getSpaceGroupClegId();
                        type = cleg.substring(0, cleg.indexOf(":") + 1) + type;
                    }
                }
                if (isError = (s = this.assignSpaceGroup(bs, type, paramsOrUC, isPacked, doDraw, this.e.fullCommand)).endsWith("!")) {
                    this.e.invArgStr(s);
                }
                if (!this.e.doReport()) break;
                this.e.showString(s);
            }
        }
    }

    private String assignSpaceGroup(BS bs, String cleg, Object paramsOrUC, boolean isPacked, boolean doDraw, String cmd) {
        SB sb = new SB();
        String ret = this.vwr.getSymStatic().staticTransformSpaceGroup(bs, cleg, paramsOrUC, sb);
        boolean isError = ret.endsWith("!");
        if (isError) {
            return ret;
        }
        if (isPacked || doDraw) {
            this.vwr.getModelkit(false).cmdAssignSpaceGroup(ret, sb, cmd, isPacked, doDraw);
        }
        return sb.toString();
    }

    private String concatString(int i, String butNot) throws ScriptException {
        String s = "";
        while (i < this.slen) {
            String t = SV.sValue(this.e.getToken(i));
            if (t.equals(butNot)) {
                --this.e.iToken;
                break;
            }
            s = s + t;
            ++i;
        }
        return s;
    }

    private boolean getUnitCellParameter(int i, Object[] ret) throws ScriptException {
        ret[0] = null;
        if (this.tokAt(i) == 8) {
            return false;
        }
        int ei = this.e.iToken;
        if (this.tokAt(i) == 4) {
            String tr = this.paramAsStr(i);
            SymmetryInterface uc = this.vwr.getCurrentUnitCell();
            if (uc == null) {
                this.invArg();
            }
            if (!this.chk) {
                ret[0] = uc.getV0abc(tr, null);
            }
            return true;
        }
        if (this.e.isArrayParameter(i)) {
            this.e.ignoreError = true;
            if (this.tokAt(i + 2) != 1073742332) {
                try {
                    ret[0] = this.e.floatParameterSet(i, 6, 6);
                    this.e.ignoreError = false;
                    return false;
                }
                catch (Exception tr) {
                    // empty catch block
                }
            }
            try {
                ret[0] = this.e.getPointArray(i, 4, false);
            }
            catch (Exception ee) {
                this.e.iToken = ei;
            }
            this.e.ignoreError = false;
        }
        return true;
    }

    private BS expFor(int i, BS bsAtoms) throws ScriptException {
        BS bs = BS.copy(this.atomExpressionAt(i));
        bs.and(bsAtoms);
        return bs;
    }

    private String getContext(boolean withVariables) {
        SB sb = new SB();
        ScriptContext context = this.e.thisContext;
        while (context != null) {
            if (withVariables) {
                if (context.vars != null) {
                    sb.append(this.getScriptID(context));
                    sb.append(StateManager.getVariableList(context.vars, 80, true, false));
                }
            } else {
                sb.append(ScriptError.getErrorLineMessage(context.functionName, context.scriptFileName, this.e.getLinenumber(context), context.pc, ScriptEval.statementAsString(this.vwr, context.statement, -9999, this.e.debugHigh)));
            }
            context = context.parentContext;
        }
        if (withVariables) {
            if (this.e.contextVariables != null) {
                sb.append(this.getScriptID(null));
                sb.append(StateManager.getVariableList(this.e.contextVariables, 80, true, false));
            }
        } else {
            sb.append(this.e.getErrorLineMessage2());
        }
        return sb.toString();
    }

    private Object getIsosurfaceJvxl(int iShape, String type) {
        type = type == "PMESH" || type == "MESH" ? "jvxlMeshX" : (type == "ISOMESH" ? "pmesh" : (type == "ISOMESHBIN" || type == "PMB" ? "pmeshbin" : "jvxlDataXml"));
        return this.chk ? "" : this.getShapeProperty(iShape, type);
    }

    private String getMoJvxl(int ptMO, boolean isNBO) throws ScriptException {
        Integer n;
        Map moData;
        int iShape = isNBO ? 28 : 27;
        this.e.sm.loadShape(iShape);
        int modelIndex = this.vwr.am.cmi;
        if (modelIndex < 0) {
            this.e.errorStr(30, "show/write MO/NBO");
        }
        if ((moData = (Map)this.vwr.ms.getInfo(modelIndex, "moData")) == null) {
            this.error(27);
        }
        if ((n = (Integer)this.getShapeProperty(iShape, "moNumber")) == null || n == 0) {
            this.setShapeProperty(iShape, "init", modelIndex);
        }
        this.setShapeProperty(iShape, "moData", moData);
        return (String)this.e.sm.getShapePropertyIndex(iShape, "showMO", ptMO);
    }

    private String getScriptID(ScriptContext context) {
        String fuName = context == null ? this.e.functionName : "function " + context.functionName;
        String fiName = context == null ? this.e.scriptFileName : context.scriptFileName;
        return "\n# " + fuName + " (file " + fiName + (context == null ? "" : " context " + context.id) + ")\n";
    }

    private T tokenAt(int i, T[] args) {
        return i < args.length ? args[i] : null;
    }

    private static int tokAtArray(int i, T[] args) {
        return i < args.length && args[i] != null ? args[i].tok : 0;
    }

    private float getPlotMinMax(float[] data, boolean isMax, int tok) {
        if (data == null) {
            return 0.0f;
        }
        switch (tok) {
            case 1111490568: 
            case 1111490569: 
            case 1111490570: {
                return isMax ? 180 : -180;
            }
            case 1111490565: 
            case 1111490576: {
                return isMax ? 360 : 0;
            }
            case 1111490574: {
                return isMax ? 1 : -1;
            }
        }
        float fmax = isMax ? -1.0E10f : 1.0E10f;
        int i = data.length;
        while (--i >= 0) {
            float f = data[i];
            if (Float.isNaN(f) || isMax != f > fmax) continue;
            fmax = f;
        }
        return fmax;
    }

    private Object parseDataArray(String str, boolean is3D) {
        str = Parser.fixDataString(str);
        int[] lines = Parser.markLines(str, '\n');
        int nLines = lines.length;
        if (!is3D) {
            float[][] data = AU.newFloat2(nLines);
            int iLine = 0;
            int pt = 0;
            while (iLine < nLines) {
                String[] tokens = PT.getTokens(str.substring(pt, lines[iLine]));
                data[iLine] = new float[tokens.length];
                PT.parseFloatArrayData(tokens, data[iLine]);
                pt = lines[iLine++];
            }
            return data;
        }
        String[] tokens = PT.getTokens(str.substring(0, lines[0]));
        if (tokens.length != 3) {
            return new float[0][0][0];
        }
        int nX = PT.parseInt(tokens[0]);
        int nY = PT.parseInt(tokens[1]);
        int nZ = PT.parseInt(tokens[2]);
        if (nX < 1 || nY < 1 || nZ < 1) {
            return new float[1][1][1];
        }
        float[][][] data = AU.newFloat3(nX, nY);
        int iX = 0;
        int iY = 0;
        int iLine = 1;
        int pt = lines[0];
        while (iLine < nLines && iX < nX) {
            tokens = PT.getTokens(str.substring(pt, lines[iLine]));
            if (tokens.length >= nZ) {
                float[] fArray = new float[tokens.length];
                data[iX][iY] = fArray;
                PT.parseFloatArrayData(tokens, fArray);
                if (++iY == nY) {
                    ++iX;
                    iY = 0;
                }
            }
            pt = lines[iLine++];
        }
        if (iX != nX) {
            System.out.println("Error reading 3D data -- nX = " + nX + ", but only " + iX + " blocks read");
            return new float[1][1][1];
        }
        return data;
    }

    public float[] getBitsetPropertyFloat(BS bs, int tok, String property, float min, float max) throws ScriptException {
        int i;
        Object odata;
        Object object = odata = property == null || tok == 1086325010 || tok == 1111490843 ? this.e.getBitsetProperty(bs, (Lst)null, tok, (P3)null, (P4)null, (Object)property, (Object)null, false, Integer.MAX_VALUE, false) : this.vwr.getDataObj(property, bs, 1);
        if (odata == null || !AU.isAF(odata)) {
            return bs == null ? null : new float[bs.cardinality()];
        }
        float[] data = (float[])odata;
        if (!Float.isNaN(min)) {
            for (i = 0; i < data.length; ++i) {
                if (!(data[i] < min)) continue;
                data[i] = Float.NaN;
            }
        }
        if (!Float.isNaN(max)) {
            for (i = 0; i < data.length; ++i) {
                if (!(data[i] > max)) continue;
                data[i] = Float.NaN;
            }
        }
        return data;
    }
}

