/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.xtal;

import java.util.Hashtable;
import java.util.Map;
import javajs.util.Lst;
import javajs.util.M3;
import javajs.util.P3;
import javajs.util.PT;
import javajs.util.V3;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollectionReader;
import org.jmol.adapter.smarter.Bond;
import org.jmol.util.Logger;

public class CgdReader
extends AtomSetCollectionReader {
    private boolean noBondSym;
    private String[] tokens;
    private Map<Atom, V3[]> htEdges;
    private String lastName;
    private Lst<String> edgeData;
    private static final String SG_ALIASES = ";P2=P121;P21=P1211;C2=C121;A2=A121;I2=I121;Pm=P1m1;Pc=P1c1;Pn=P1n1;Pa=P1a1;Cm=C1m1;Am=A1m1;Im=I1m1;Cc=C1c1;An=A1n1;Ia=I1a1;Aa=A1a1;Cn=C1n1;Ic=I1c1;P2/m=P12/m1;P21/m=P121/m1;C2/m=C12/m1;A2/m=A12/m1;I2/m=I12/m1;P2/c=P12/c1;P2/n=P12/n1;P2/a=P12/a1;P21/c=P121/c1;P21/n=P121/n1;P21/a=P121/a1;C2/c=C12/c1;A2/n=A12/n1;I2/a=I12/a1;A2/a=A12/a1;C2/n=C12/n1;I2/c=I12/c1;Pm3=Pm-3;Pn3=Pn-3;Fm3=Fm-3;Fd3=Fd-3;Im3=Im-3;Pa3=Pa-3;Ia3=Ia-3;Pm3m=Pm-3m;Pn3n=Pn-3n;Pm3n=Pm-3n;Pn3m=Pn-3m;Fm3m=Fm-3m;Fm3c=Fm-3c;Fd3m=Fd-3m;Fd3c=Fd-3c;Im3m=Im-3m;Ia3d=Ia-3d;";
    private static final V3[] vecs = new V3[]{V3.new3(0.0f, 0.0f, -1.0f), V3.new3(1.0f, 0.0f, -1.0f), null, V3.new3(0.0f, 1.0f, -1.0f), V3.new3(0.0f, -1.0f, 0.0f), V3.new3(1.0f, -1.0f, 0.0f), V3.new3(-1.0f, 0.0f, 0.0f), null, V3.new3(1.0f, 0.0f, 0.0f), V3.new3(-1.0f, 1.0f, 0.0f), V3.new3(0.0f, 1.0f, 0.0f), V3.new3(0.0f, -1.0f, 1.0f), null, V3.new3(-1.0f, 0.0f, 1.0f), V3.new3(0.0f, 0.0f, 1.0f)};

    @Override
    public void initializeReader() {
        this.setFractionalCoordinates(true);
        this.asc.setNoAutoBond();
        this.asc.vibScale = 1;
        this.forceSymmetry(!this.noPack);
        this.noBondSym = this.checkFilterKey("NOBONDSYM");
    }

    @Override
    protected boolean checkLine() throws Exception {
        this.line = this.line.trim();
        if (this.line.length() == 0 || this.line.startsWith("#")) {
            return true;
        }
        if (!Character.isLetter(this.line.charAt(0))) {
            this.line = this.lastName + " " + this.line;
        }
        this.tokens = this.getTokens();
        if (this.tokens.length > 0) {
            this.lastName = this.tokens[0].toUpperCase();
            int pt = "NAME |CELL |GROUP|ATOM |EDGE |".indexOf(this.lastName);
            if (this.tokens.length > 1 && (pt == 0 || this.doProcessLines)) {
                switch (pt) {
                    case 0: {
                        if (!this.doGetModel(++this.modelNumber, null)) {
                            return this.checkLastModel();
                        }
                        this.applySymmetryAndSetTrajectory();
                        this.setFractionalCoordinates(true);
                        this.asc.newAtomSet();
                        this.asc.setAtomSetName(this.line.substring(6).trim());
                        this.htEdges = null;
                        this.edgeData = null;
                        break;
                    }
                    case 6: {
                        for (int i = 0; i < 6; ++i) {
                            this.setUnitCellItem(i, (float)(i < 3 ? 10 : 1) * this.parseFloatStr(this.tokens[i + 1]));
                        }
                        break;
                    }
                    case 12: {
                        this.setSpaceGroupName("bilbao:" + this.group(this.tokens[1]));
                        break;
                    }
                    case 18: {
                        this.atom();
                        break;
                    }
                    case 24: {
                        if (!this.doApplySymmetry) break;
                        if (this.edgeData == null) {
                            this.edgeData = new Lst();
                        }
                        this.edgeData.addLast(this.line);
                    }
                }
            }
        }
        return true;
    }

    private String group(String name) {
        int pt;
        String name0 = null;
        if (name.charAt(0) == '\"') {
            name = name.substring(1, name.length() - 1);
        }
        if ((pt = SG_ALIASES.indexOf(";" + name + "=")) >= 0) {
            name0 = name;
            name = SG_ALIASES.substring(SG_ALIASES.indexOf("=", pt) + 1, SG_ALIASES.indexOf(";", pt + 1));
        }
        Logger.info("CgdReader using GROUP " + name + (name0 == null ? "" : " alias of " + name0));
        return name;
    }

    private void atom() {
        String name = this.getName(this.tokens[1]);
        int edgeCount = this.parseIntStr(this.tokens[2]);
        for (int i = 3; i < 6; ++i) {
            if (this.tokens[i].indexOf("/") < 0) continue;
            this.tokens[i] = "" + PT.parseFloatFraction(this.tokens[i]);
        }
        Atom a = this.addAtomXYZSymName(this.tokens, 3, null, name);
        if (!this.doApplySymmetry) {
            return;
        }
        this.asc.atomSymbolicMap.put(name, a);
        this.asc.addVibrationVector(a.index, 1.0f, 3.0f, 7.0f);
        if (this.htEdges == null) {
            this.htEdges = new Hashtable<Atom, V3[]>();
        }
        this.htEdges.put(a, new V3[edgeCount]);
    }

    private String getName(String name) {
        return name.charAt(0) == '\"' ? name.substring(1, name.length() - 1) : (Character.isDigit(name.charAt(0)) ? "C" + name : name);
    }

    @Override
    public void finalizeSubclassReader() throws Exception {
        this.finalizeReaderASCR();
        if (this.doApplySymmetry) {
            this.finalizeNet();
        }
    }

    private void finalizeEdges() {
        block5: for (int j = 0; j < this.edgeData.size(); ++j) {
            P3 p;
            V3[] atomEdges;
            this.line = (String)this.edgeData.get(j);
            this.tokens = PT.getTokens(this.line);
            switch (this.tokens.length) {
                case 3: {
                    String name = this.getName(this.tokens[1]);
                    Atom a = this.asc.getAtomFromName(name);
                    atomEdges = this.htEdges.get(a);
                    p = this.asc.getAtomFromName(this.getName(this.tokens[2]));
                    break;
                }
                case 5: {
                    String name = this.getName(this.tokens[1]);
                    Atom a = this.asc.getAtomFromName(name);
                    atomEdges = this.htEdges.get(a);
                    p = this.getCoord(2);
                    break;
                }
                case 7: {
                    atomEdges = this.htEdges.get(this.findAtom(this.getCoord(1)));
                    p = this.getCoord(4);
                    break;
                }
                default: {
                    Logger.error("EDGE record skipped: " + this.line);
                    continue block5;
                }
            }
            int n = atomEdges.length;
            for (int i = 0; i < n; ++i) {
                if (atomEdges[i] != null) continue;
                atomEdges[i] = V3.newV(p);
                continue block5;
            }
        }
    }

    private P3 getCoord(int i) {
        return P3.new3(PT.parseFloatFraction(this.tokens[i++]), PT.parseFloatFraction(this.tokens[i++]), PT.parseFloatFraction(this.tokens[i++]));
    }

    private void finalizeNet() {
        this.finalizeEdges();
        M3 m = new M3();
        P3 pt = new P3();
        int n = this.asc.ac;
        for (int i = 0; i < n; ++i) {
            V3[] edges;
            Atom a = this.asc.atoms[i];
            Atom a0 = this.asc.atoms[a.atomSite];
            if (this.noBondSym && a != a0 || (edges = this.htEdges.get(a0)) == null) continue;
            int ix = (int)a.vib.x + 7;
            int iy = (int)a.vib.y + 7;
            int iz = (int)a.vib.z + 7;
            m.setRowV(0, vecs[ix]);
            m.setRowV(1, vecs[iy]);
            m.setRowV(2, vecs[iz]);
            int n1 = edges.length;
            for (int j = 0; j < n1; ++j) {
                pt.sub2(edges[j], a0);
                m.rotate(pt);
                pt.add(a);
                Atom b = this.findAtom(pt);
                if (b != null) {
                    this.asc.addBond(new Bond(a.index, b.index, 1));
                    continue;
                }
                if (!(pt.x >= 0.0f) || !(pt.x <= 1.0f) || !(pt.y >= 0.0f) || !(pt.y <= 1.0f) || !(pt.z >= 0.0f) || !(pt.z <= 1.0f)) continue;
                Logger.error(" not found: i=" + i + "  pt=" + pt + " for a=" + a + "\n a0=" + a0 + " edge[" + j + "]=" + edges[j] + "\n a.vib=" + a.vib + "\n m=" + m);
            }
            a.vib = null;
        }
    }

    private Atom findAtom(P3 pt) {
        int i = this.asc.ac;
        while (--i >= 0) {
            if (!(this.asc.atoms[i].distanceSquared(pt) < 1.0E-5f)) continue;
            return this.asc.atoms[i];
        }
        return null;
    }
}

