/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import org.jmol.modelset.Bond;
import org.jmol.modelset.ModelSet;
import org.jmol.viewer.Connection;
import org.jmol.viewer.Viewer;

class Connections {
    protected String saveName;
    protected int bondCount;
    protected Connection[] connections;
    private Viewer vwr;

    protected Connections(Viewer vwr) {
        ModelSet modelSet = vwr.ms;
        if (modelSet == null) {
            return;
        }
        this.vwr = vwr;
        this.bondCount = modelSet.bondCount;
        this.connections = new Connection[this.bondCount + 1];
        Bond[] bonds = modelSet.bo;
        int i = this.bondCount;
        while (--i >= 0) {
            Bond b = bonds[i];
            if (b == null) continue;
            this.connections[i] = new Connection(b.atom1.i, b.atom2.i, b.mad, b.colix, b.order, b.getEnergy(), b.shapeVisibilityFlags);
        }
    }

    protected boolean restore() {
        ModelSet modelSet = this.vwr.ms;
        if (modelSet == null) {
            return false;
        }
        modelSet.deleteAllBonds();
        int i = this.bondCount;
        while (--i >= 0) {
            Connection c = this.connections[i];
            int ac = modelSet.ac;
            if (c.atomIndex1 >= ac || c.atomIndex2 >= ac) continue;
            Bond b = modelSet.bondAtoms(modelSet.at[c.atomIndex1], modelSet.at[c.atomIndex2], c.order, c.mad, null, c.energy, false, true);
            b.colix = c.colix;
            b.shapeVisibilityFlags = c.shapeVisibilityFlags;
        }
        Bond[] bonds = modelSet.bo;
        int i2 = modelSet.bondCount;
        while (--i2 >= 0) {
            if (bonds[i2] == null) continue;
            bonds[i2].index = i2;
        }
        this.vwr.setShapeProperty(1, "reportAll", null);
        return true;
    }
}

