/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.layer;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumnModel;
import org.openstreetmap.josm.data.SystemOfMeasurement;
import org.openstreetmap.josm.gui.ConditionalOptionPaneUtil;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.layer.GpxLayer;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class MergeGpxLayerDialog
extends ExtendedDialog {
    private final GpxLayersTableModel model;
    private final JTable t;
    private final JCheckBox c;
    private final JButton btnUp;
    private final JButton btnDown;

    public MergeGpxLayerDialog(Component parent, List<GpxLayer> layers) {
        super(parent, I18n.tr("Merge GPX layers", new Object[0]), I18n.tr("Merge", new Object[0]), I18n.tr("Cancel", new Object[0]));
        this.setButtonIcons("dialogs/mergedown", "cancel");
        JPanel p = new JPanel(new GridBagLayout());
        p.add((Component)new JLabel("<html>" + I18n.tr("Please select the order of the selected layers:<br>Tracks will be cut, when timestamps of higher layers are overlapping.", new Object[0]) + "</html>"), GBC.std(0, 0).fill(2).span(2));
        this.c = new JCheckBox(I18n.tr("Connect overlapping tracks on cuts", new Object[0]));
        this.c.setSelected(Config.getPref().getBoolean("mergelayer.gpx.connect", true));
        p.add((Component)this.c, GBC.std(0, 1).fill(2).span(2));
        this.model = new GpxLayersTableModel(layers);
        this.t = new JTable(this.model);
        this.t.setSelectionMode(0);
        this.t.setRowSelectionInterval(0, 0);
        JScrollPane sp = new JScrollPane(this.t);
        p.add((Component)sp, GBC.std(0, 2).fill().span(2));
        this.t.getSelectionModel().addListSelectionListener(new RowSelectionChangedListener());
        TableColumnModel cmodel = this.t.getColumnModel();
        cmodel.getColumn(0).setPreferredWidth((int)(sp.getPreferredSize().getWidth() - 150.0));
        cmodel.getColumn(1).setPreferredWidth(75);
        cmodel.getColumn(2).setPreferredWidth(75);
        this.btnUp = new JButton(I18n.tr("Move layer up", new Object[0]));
        this.btnUp.setIcon(ImageProvider.get("dialogs", "up", ImageProvider.ImageSizes.SMALLICON));
        this.btnUp.setEnabled(false);
        this.btnDown = new JButton(I18n.tr("Move layer down", new Object[0]));
        this.btnDown.setIcon(ImageProvider.get("dialogs", "down", ImageProvider.ImageSizes.SMALLICON));
        p.add((Component)this.btnUp, GBC.std(0, 3).fill(2));
        p.add((Component)this.btnDown, GBC.std(1, 3).fill(2));
        this.btnUp.addActionListener(new MoveLayersActionListener(true));
        this.btnDown.addActionListener(new MoveLayersActionListener(false));
        this.setContent(p);
    }

    @Override
    public MergeGpxLayerDialog showDialog() {
        super.showDialog();
        if (this.getValue() == 1) {
            Config.getPref().putBoolean("mergelayer.gpx.connect", this.c.isSelected());
        }
        return this;
    }

    public boolean connectCuts() {
        return this.c.isSelected();
    }

    public List<GpxLayer> getSortedLayers() {
        return this.model.getSortedLayers();
    }

    private static class GpxLayersTableModel
    extends AbstractTableModel {
        private final String[] cols = new String[]{I18n.tr("GPX layer", new Object[0]), I18n.tr("Length", new Object[0]), I18n.tr("Segments", new Object[0])};
        private final List<GpxLayer> layers;

        GpxLayersTableModel(List<GpxLayer> l) {
            this.layers = l;
        }

        @Override
        public String getColumnName(int column) {
            return this.cols[column];
        }

        @Override
        public int getColumnCount() {
            return this.cols.length;
        }

        @Override
        public int getRowCount() {
            return this.layers.size();
        }

        void moveRow(int row, int newRow) {
            Collections.swap(this.layers, row, newRow);
        }

        List<GpxLayer> getSortedLayers() {
            return this.layers;
        }

        @Override
        public Object getValueAt(int row, int col) {
            switch (col) {
                case 0: {
                    String n = this.layers.get(row).getName();
                    if (row == 0) {
                        return I18n.tr("{0} (target layer)", n);
                    }
                    return n;
                }
                case 1: {
                    return SystemOfMeasurement.getSystemOfMeasurement().getDistText(this.layers.get((int)row).data.length());
                }
                case 2: {
                    return this.layers.get((int)row).data.getTrackSegsCount();
                }
            }
            throw new IndexOutOfBoundsException(Integer.toString(col));
        }
    }

    private final class RowSelectionChangedListener
    implements ListSelectionListener {
        private RowSelectionChangedListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            MergeGpxLayerDialog.this.btnUp.setEnabled(MergeGpxLayerDialog.this.t.getSelectedRow() > 0);
            MergeGpxLayerDialog.this.btnDown.setEnabled(MergeGpxLayerDialog.this.t.getSelectedRow() < MergeGpxLayerDialog.this.model.getRowCount() - 1);
        }
    }

    private class MoveLayersActionListener
    implements ActionListener {
        private final boolean moveUp;

        MoveLayersActionListener(boolean up) {
            this.moveUp = up;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int row = MergeGpxLayerDialog.this.t.getSelectedRow();
            int newRow = row + (this.moveUp ? -1 : 1);
            if (!(row != 0 && newRow != 0 || ConditionalOptionPaneUtil.showConfirmationDialog("gpx_target_change", MergeGpxLayerDialog.this.getParent(), new JLabel("<html>" + I18n.tr("This will change the target layer to \"{0}\".<br>Would you like to continue?", MergeGpxLayerDialog.this.model.getValueAt(1, 0).toString()) + "</html>"), I18n.tr("Information", new Object[0]), 2, 1, 0))) {
                return;
            }
            MergeGpxLayerDialog.this.model.moveRow(row, newRow);
            MergeGpxLayerDialog.this.t.getSelectionModel().setSelectionInterval(newRow, newRow);
            MergeGpxLayerDialog.this.t.repaint();
        }
    }
}

