/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.util;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JPopupMenu;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.openstreetmap.josm.actions.OpenBrowserAction;
import org.openstreetmap.josm.tools.Tag2Link;

public abstract class AbstractTag2LinkPopupListener
implements PopupMenuListener {
    private final Map<String, OpenBrowserAction> browserActions = new HashMap<String, OpenBrowserAction>();
    private final Collection<Component> itemList = new ArrayList<Component>();

    protected AbstractTag2LinkPopupListener() {
    }

    @Override
    public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
        JPopupMenu popup = (JPopupMenu)e.getSource();
        this.browserActions.clear();
        this.itemList.forEach(popup::remove);
        this.itemList.clear();
    }

    @Override
    public void popupMenuCanceled(PopupMenuEvent e) {
    }

    protected void addLinks(JPopupMenu popup, String key, String value) {
        Tag2Link.getLinksForTag(key, value, (name, url, icon) -> {
            if (this.itemList.isEmpty()) {
                this.itemList.add(popup.add(new JPopupMenu.Separator()));
            }
            if (this.browserActions.containsKey(name)) {
                this.browserActions.get(name).addUrl(url);
            } else {
                OpenBrowserAction action = new OpenBrowserAction(name, url, icon);
                this.browserActions.put(name, action);
                this.itemList.add(popup.add(action));
            }
        });
    }
}

