/*
 * Decompiled with CFR 0.152.
 */
package com.headius.options;

import com.headius.options.BooleanOption;
import com.headius.options.EnumerationOption;
import com.headius.options.IntegerOption;
import com.headius.options.StringOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;

public abstract class Option<T> {
    private static Comparator<Option> OptionComparator = new Comparator<Option>(){

        @Override
        public int compare(Option o1, Option o2) {
            int catComp = o1.category.compareTo(o2.category);
            if (catComp != 0) {
                return catComp;
            }
            return o1.displayName.compareTo(o2.displayName);
        }
    };
    private final Enum category;
    private final String prefix;
    private final String shortName;
    private final String longName;
    private final String displayName;
    protected final Class<T> type;
    private final T[] options;
    protected final T defval;
    private final String description;
    private String forced;
    private boolean specified;
    private volatile T value;
    private volatile boolean loaded;

    public Option(String prefix, String shortName, Class<T> type2, Enum category, T[] options2, T defval, String description) {
        this.category = category;
        this.prefix = prefix;
        this.shortName = shortName;
        this.longName = prefix + "." + shortName;
        this.displayName = shortName;
        this.type = type2;
        this.options = options2;
        this.defval = defval;
        this.description = description;
        this.specified = false;
    }

    public Option(String longName, Class<T> type2, Enum category, T[] options2, T defval, String description) {
        this.category = category;
        this.prefix = null;
        this.shortName = null;
        this.longName = longName;
        this.displayName = longName;
        this.type = type2;
        this.options = options2;
        this.defval = defval;
        this.description = description;
        this.specified = false;
    }

    public static Option<String> string(String prefix, String name2, Enum category, String description) {
        return new StringOption(prefix, name2, category, null, null, description);
    }

    public static Option<String> string(String longName, Enum category, String description) {
        return new StringOption(longName, category, null, null, description);
    }

    public static Option<String> string(String prefix, String name2, Enum category, String defval, String description) {
        return new StringOption(prefix, name2, category, null, defval, description);
    }

    public static Option<String> string(String longName, Enum category, String defval, String description) {
        return new StringOption(longName, category, null, defval, description);
    }

    public static Option<String> string(String prefix, String name2, Enum category, String[] options2, String description) {
        return new StringOption(prefix, name2, category, options2, null, description);
    }

    public static Option<String> string(String longName, Enum category, String[] options2, String description) {
        return new StringOption(longName, category, options2, null, description);
    }

    public static Option<String> string(String prefix, String name2, Enum category, String[] options2, String defval, String description) {
        return new StringOption(prefix, name2, category, options2, defval, description);
    }

    public static Option<String> string(String longName, Enum category, String[] options2, String defval, String description) {
        return new StringOption(longName, category, options2, defval, description);
    }

    public static Option<Boolean> bool(String prefix, String name2, Enum category, String description) {
        return new BooleanOption(prefix, name2, category, null, description);
    }

    public static Option<Boolean> bool(String longName, Enum category, String description) {
        return new BooleanOption(longName, category, null, description);
    }

    public static Option<Boolean> bool(String prefix, String name2, Enum category, Boolean defval, String description) {
        return new BooleanOption(prefix, name2, category, defval, description);
    }

    public static Option<Boolean> bool(String longName, Enum category, Boolean defval, String description) {
        return new BooleanOption(longName, category, defval, description);
    }

    public static Option<Integer> integer(String prefix, String name2, Enum category, String description) {
        return new IntegerOption(prefix, name2, category, null, description);
    }

    public static Option<Integer> integer(String prefix, String name2, Enum category, Integer[] options2, String description) {
        return new IntegerOption(prefix, name2, category, options2, null, description);
    }

    public static Option<Integer> integer(String longName, Enum category, String description) {
        return new IntegerOption(longName, category, null, description);
    }

    public static Option<Integer> integer(String longName, Enum category, Integer[] options2, String description) {
        return new IntegerOption(longName, category, options2, null, description);
    }

    public static Option<Integer> integer(String prefix, String name2, Enum category, Integer defval, String description) {
        return new IntegerOption(prefix, name2, category, defval, description);
    }

    public static Option<Integer> integer(String longName, Enum category, Integer defval, String description) {
        return new IntegerOption(longName, category, defval, description);
    }

    public static Option<Integer> integer(String prefix, String name2, Enum category, Integer[] options2, Integer defval, String description) {
        return new IntegerOption(prefix, name2, category, options2, defval, description);
    }

    public static Option<Integer> integer(String longName, Enum category, Integer[] options2, Integer defval, String description) {
        return new IntegerOption(longName, category, options2, defval, description);
    }

    public static <T extends Enum<T>> Option<T> enumeration(String prefix, String name2, Enum category, Class<T> enumClass, String description) {
        return new EnumerationOption<Object>(prefix, name2, category, enumClass, null, description);
    }

    public static <T extends Enum<T>> Option<T> enumeration(String longName, Enum category, Class<T> enumClass, String description) {
        return new EnumerationOption<Object>(longName, category, enumClass, null, description);
    }

    public static <T extends Enum<T>> Option<T> enumeration(String prefix, String name2, Enum category, T defval, String description) {
        return new EnumerationOption(prefix, name2, category, defval.getClass(), defval, description);
    }

    public static <T extends Enum<T>> Option<T> enumeration(String longName, Enum category, T defval, String description) {
        return new EnumerationOption(longName, category, defval.getClass(), defval, description);
    }

    public static String formatValues(Option ... options2) {
        return Option.formatValues(Arrays.asList(options2));
    }

    public static String formatValues(Collection<Option> options2) {
        StringBuilder sb = new StringBuilder();
        ArrayList<Option> sorted = new ArrayList<Option>(options2);
        Collections.sort(sorted, OptionComparator);
        Enum category = null;
        for (Option option : sorted) {
            if (category != option.category) {
                category = option.category;
                sb.append('\n').append(category).append('\n');
            }
            sb.append(option.displayName).append('=');
            option.load();
            if (option.isSpecified() || option.defval != null) {
                sb.append(Option.encodeWhitespace(option.load()));
            } else {
                sb.append("<unspecified>");
            }
            sb.append('\n');
        }
        return sb.toString();
    }

    public static String formatOptions(Option ... options2) {
        return Option.formatOptions(Arrays.asList(options2));
    }

    public static String formatOptions(Collection<Option> options2) {
        StringBuilder sb = new StringBuilder();
        ArrayList<Option> sorted = new ArrayList<Option>(options2);
        Collections.sort(sorted, OptionComparator);
        Enum category = null;
        for (Option option : sorted) {
            if (category != option.category) {
                category = option.category;
                sb.append("\n################################################################################");
                sb.append("\n# ").append(category);
                sb.append("\n################################################################################\n\n");
            }
            sb.append("# ").append(option.description).append('\n');
            if (option.options != null) {
                sb.append("# Options: ").append(Arrays.toString(option.options));
                if (option.defval != null) {
                    sb.append(", Default: ").append(Option.encodeWhitespace(option.defval));
                }
                sb.append(".\n");
            } else if (option.defval != null) {
                sb.append("# Default: ").append(Option.encodeWhitespace(option.defval));
                sb.append(".\n");
            }
            sb.append("\n#");
            if (option.defval != null) {
                sb.append(option.displayName).append('=').append(Option.encodeWhitespace(option.defval.toString()));
            } else {
                sb.append(option.displayName).append('=');
            }
            sb.append("\n\n");
        }
        return sb.toString();
    }

    private static String encodeWhitespace(Object obj) {
        if (obj == null) {
            return "null";
        }
        String str = obj.toString();
        StringBuilder sb = new StringBuilder(str.length() * 2);
        boolean hasWhitespace = false;
        for (char c : str.toCharArray()) {
            if (Character.isWhitespace(c)) {
                hasWhitespace = true;
                switch (c) {
                    case '\t': {
                        sb.append("\\t");
                        break;
                    }
                    case '\n': {
                        sb.append("\\n");
                        break;
                    }
                    default: {
                        sb.append(c);
                        break;
                    }
                }
                continue;
            }
            sb.append(c);
        }
        if (hasWhitespace) {
            return "\"" + sb.toString() + "\"";
        }
        return str;
    }

    public String toString() {
        return this.longName;
    }

    public synchronized String loadProperty() {
        String value2 = this.forced;
        if (value2 != null) {
            return value2;
        }
        try {
            value2 = System.getProperty(this.longName);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        if (value2 != null) {
            this.specified = true;
        }
        return value2;
    }

    public boolean isSpecified() {
        return this.specified;
    }

    public final T load() {
        if (this.loaded) {
            return this.value;
        }
        return this.reload();
    }

    public final synchronized T reload() {
        if (this.loaded) {
            return this.value;
        }
        this.value = this.reloadValue();
        this.loaded = true;
        return this.value;
    }

    public synchronized void force(String value2) {
        this.forced = value2;
        this.loaded = false;
        this.reload();
    }

    public synchronized void unforce() {
        this.forced = null;
        this.loaded = false;
        this.value = null;
    }

    protected abstract T reloadValue();

    public String shortName() {
        return this.shortName;
    }

    public String propertyName() {
        return this.longName;
    }

    public String prefix() {
        return this.prefix;
    }

    public String displayName() {
        return this.displayName;
    }

    public Class<T> type() {
        return this.type;
    }

    public T[] options() {
        return this.options == null ? null : (Object[])this.options.clone();
    }

    public T defaultValue() {
        return this.defval;
    }

    public String description() {
        return this.description;
    }
}

