/*
 * Decompiled with CFR 0.152.
 */
package jnr.constants.platform.linux;

import java.util.EnumMap;
import java.util.Map;
import jnr.constants.Constant;

public enum WaitFlags implements Constant
{
    WNOHANG(1L),
    WUNTRACED(2L),
    WSTOPPED(2L),
    WEXITED(4L),
    WCONTINUED(8L),
    WNOWAIT(0x1000000L);

    private final long value;
    public static final long MIN_VALUE = 1L;
    public static final long MAX_VALUE = 0x1000000L;

    private WaitFlags(long value2) {
        this.value = value2;
    }

    public final String toString() {
        return StringTable.descriptions.get(this);
    }

    public final int value() {
        return (int)this.value;
    }

    @Override
    public final int intValue() {
        return (int)this.value;
    }

    @Override
    public final long longValue() {
        return this.value;
    }

    @Override
    public final boolean defined() {
        return true;
    }

    static final class StringTable {
        public static final Map<WaitFlags, String> descriptions = StringTable.generateTable();

        StringTable() {
        }

        public static final Map<WaitFlags, String> generateTable() {
            EnumMap<WaitFlags, String> map2 = new EnumMap<WaitFlags, String>(WaitFlags.class);
            map2.put(WNOHANG, "WNOHANG");
            map2.put(WUNTRACED, "WUNTRACED");
            map2.put(WSTOPPED, "WSTOPPED");
            map2.put(WEXITED, "WEXITED");
            map2.put(WCONTINUED, "WCONTINUED");
            map2.put(WNOWAIT, "WNOWAIT");
            return map2;
        }
    }
}

