/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.project.structure.impl;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.local.CoreLocalFileSystem;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.projectStructure.KaModule;
import org.jetbrains.kotlin.analysis.api.projectStructure.KaSourceModule;
import org.jetbrains.kotlin.analysis.api.standalone.base.projectStructure.KotlinStaticProjectStructureProvider;
import org.jetbrains.kotlin.analysis.project.structure.builder.KtLibraryModuleBuilder;
import org.jetbrains.kotlin.analysis.project.structure.builder.KtModuleBuilder;
import org.jetbrains.kotlin.analysis.project.structure.builder.KtModuleProviderBuilder;
import org.jetbrains.kotlin.analysis.project.structure.builder.KtScriptModuleBuilder;
import org.jetbrains.kotlin.analysis.project.structure.builder.KtSdkModuleBuilder;
import org.jetbrains.kotlin.analysis.project.structure.builder.KtSourceModuleBuilder;
import org.jetbrains.kotlin.cli.jvm.compiler.KotlinCoreProjectEnvironment;
import org.jetbrains.kotlin.cli.jvm.config.JvmContentRootsKt;
import org.jetbrains.kotlin.config.CommonConfigurationKeys;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.config.JVMConfigurationKeys;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.parsing.KotlinParserDefinition;
import org.jetbrains.kotlin.platform.TargetPlatform;
import org.jetbrains.kotlin.platform.jvm.JvmPlatforms;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000>\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a \u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u0000\u001a\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00020\b2\u0006\u0010\t\u001a\u00020\u0002H\u0000\u001a\f\u0010\n\u001a\u00020\u0006*\u00020\u0002H\u0000\u001a1\u0010\u000b\u001a\b\u0012\u0004\u0012\u0002H\f0\b\"\n\b\u0000\u0010\f\u0018\u0001*\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00020\u0011H\u0080\b\u001a&\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0003\u001a\u00020\u00042\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\bH\u0000\u00a8\u0006\u0016"}, d2={"getSourceFilePaths", "", "Ljava/nio/file/Path;", "compilerConfig", "Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "includeDirectoryRoot", "", "collectSourceFilePaths", "", "root", "hasSuitableExtensionToAnalyse", "getPsiFilesFromPaths", "T", "Lcom/intellij/psi/PsiFileSystemItem;", "kotlinCoreProjectEnvironment", "Lorg/jetbrains/kotlin/cli/jvm/compiler/KotlinCoreProjectEnvironment;", "paths", "", "buildKtModuleProviderByCompilerConfiguration", "Lorg/jetbrains/kotlin/analysis/api/standalone/base/projectStructure/KotlinStaticProjectStructureProvider;", "ktFiles", "Lorg/jetbrains/kotlin/psi/KtFile;", "analysis-api-standalone"})
@SourceDebugExtension(value={"SMAP\nKaModuleUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KaModuleUtils.kt\norg/jetbrains/kotlin/analysis/project/structure/impl/KaModuleUtilsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 KaModuleProviderBuilder.kt\norg/jetbrains/kotlin/analysis/project/structure/builder/KaModuleProviderBuilderKt\n+ 5 KaScriptModuleBuilder.kt\norg/jetbrains/kotlin/analysis/project/structure/builder/KaScriptModuleBuilderKt\n+ 6 KaSourceModuleBuilder.kt\norg/jetbrains/kotlin/analysis/project/structure/builder/KaSourceModuleBuilderKt\n+ 7 KaLibraryModuleBuilder.kt\norg/jetbrains/kotlin/analysis/project/structure/builder/KaLibraryModuleBuilderKt\n+ 8 KaSdkModuleBuilder.kt\norg/jetbrains/kotlin/analysis/project/structure/builder/KaSdkModuleBuilderKt\n*L\n1#1,181:1\n1863#2,2:182\n3193#2,10:186\n1557#2:198\n1628#2,3:199\n1557#2:203\n1628#2,3:204\n1#3:184\n46#4:185\n50#5:196\n95#6:197\n49#7:202\n33#8:207\n*S KotlinDebug\n*F\n+ 1 KaModuleUtils.kt\norg/jetbrains/kotlin/analysis/project/structure/impl/KaModuleUtilsKt\n*L\n41#1:182,2\n133#1:186,10\n175#1:198\n175#1:199,3\n141#1:203\n141#1:204,3\n132#1:185\n159#1:196\n168#1:197\n139#1:202\n147#1:207\n*E\n"})
public final class KaModuleUtilsKt {
    @NotNull
    public static final Set<Path> getSourceFilePaths(@NotNull CompilerConfiguration compilerConfig, boolean includeDirectoryRoot) {
        Set set;
        Intrinsics.checkNotNullParameter((Object)compilerConfig, (String)"compilerConfig");
        Set $this$getSourceFilePaths_u24lambda_u241 = set = SetsKt.createSetBuilder();
        boolean bl = false;
        Iterable $this$forEach$iv = JvmContentRootsKt.getJavaSourceRoots((CompilerConfiguration)compilerConfig);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String srcRoot = (String)element$iv;
            boolean bl2 = false;
            Path path = Paths.get(srcRoot, new String[0]);
            if (Files.isDirectory(path, new LinkOption[0])) {
                Intrinsics.checkNotNull((Object)path);
                $this$getSourceFilePaths_u24lambda_u241.addAll((Collection)KaModuleUtilsKt.collectSourceFilePaths(path));
                if (!includeDirectoryRoot) continue;
                $this$getSourceFilePaths_u24lambda_u241.add(path);
                continue;
            }
            Intrinsics.checkNotNull((Object)path);
            $this$getSourceFilePaths_u24lambda_u241.add(path);
        }
        return SetsKt.build((Set)set);
    }

    public static /* synthetic */ Set getSourceFilePaths$default(CompilerConfiguration compilerConfiguration, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return KaModuleUtilsKt.getSourceFilePaths(compilerConfiguration, bl);
    }

    @NotNull
    public static final List<Path> collectSourceFilePaths(@NotNull Path root) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        List result = new ArrayList();
        Files.walkFileTree(root, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>((List<Path>)result){
            final /* synthetic */ List<Path> $result;
            {
                this.$result = $result;
            }

            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
                Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
                Intrinsics.checkNotNullParameter((Object)attrs, (String)"attrs");
                return Files.isReadable(dir) ? FileVisitResult.CONTINUE : FileVisitResult.SKIP_SUBTREE;
            }

            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                Intrinsics.checkNotNullParameter((Object)attrs, (String)"attrs");
                if (!Files.isRegularFile(file, new LinkOption[0]) || !Files.isReadable(file)) {
                    return FileVisitResult.CONTINUE;
                }
                if (KaModuleUtilsKt.hasSuitableExtensionToAnalyse(file)) {
                    this.$result.add(file);
                }
                return FileVisitResult.CONTINUE;
            }

            public FileVisitResult visitFileFailed(Path file, IOException exc) {
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                return FileVisitResult.CONTINUE;
            }
        });
        return result;
    }

    public static final boolean hasSuitableExtensionToAnalyse(@NotNull Path $this$hasSuitableExtensionToAnalyse) {
        Intrinsics.checkNotNullParameter((Object)$this$hasSuitableExtensionToAnalyse, (String)"<this>");
        String extension = PathsKt.getExtension((Path)$this$hasSuitableExtensionToAnalyse);
        return Intrinsics.areEqual((Object)extension, (Object)"kt") || Intrinsics.areEqual((Object)extension, (Object)KotlinParserDefinition.STD_SCRIPT_SUFFIX) || Intrinsics.areEqual((Object)extension, (Object)"java");
    }

    public static final /* synthetic */ <T extends PsiFileSystemItem> List<T> getPsiFilesFromPaths(KotlinCoreProjectEnvironment kotlinCoreProjectEnvironment, Collection<? extends Path> paths) {
        List list;
        Intrinsics.checkNotNullParameter((Object)kotlinCoreProjectEnvironment, (String)"kotlinCoreProjectEnvironment");
        Intrinsics.checkNotNullParameter(paths, (String)"paths");
        boolean $i$f$getPsiFilesFromPaths = false;
        CoreLocalFileSystem coreLocalFileSystem = kotlinCoreProjectEnvironment.getEnvironment().getLocalFileSystem();
        Intrinsics.checkNotNullExpressionValue((Object)coreLocalFileSystem, (String)"getLocalFileSystem(...)");
        CoreLocalFileSystem fs = coreLocalFileSystem;
        PsiManager psiManager = PsiManager.getInstance((Project)((Project)kotlinCoreProjectEnvironment.getProject()));
        Intrinsics.checkNotNullExpressionValue((Object)psiManager, (String)"getInstance(...)");
        PsiManager psiManager2 = psiManager;
        List $this$getPsiFilesFromPaths_u24lambda_u243 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        for (Path path : paths) {
            PsiFileSystemItem it;
            PsiFileSystemItem psiFileSystemItem;
            PsiFileSystemItem psiFileSystemItem2;
            VirtualFile vFile;
            if (fs.findFileByNioFile(path.toAbsolutePath()) == null) continue;
            if (vFile.isDirectory()) {
                PsiDirectory psiDirectory = psiManager2.findDirectory(vFile);
                Intrinsics.reifiedOperationMarker((int)2, (String)"T");
                psiFileSystemItem2 = (PsiFileSystemItem)psiDirectory;
            } else {
                PsiFile psiFile = psiManager2.findFile(vFile);
                Intrinsics.reifiedOperationMarker((int)2, (String)"T");
                psiFileSystemItem2 = psiFileSystemItem = (PsiFileSystemItem)psiFile;
            }
            if (psiFileSystemItem == null) continue;
            boolean bl2 = false;
            Boolean.valueOf($this$getPsiFilesFromPaths_u24lambda_u243.add(it));
        }
        return CollectionsKt.build((List)list);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final KotlinStaticProjectStructureProvider buildKtModuleProviderByCompilerConfiguration(@NotNull KotlinCoreProjectEnvironment kotlinCoreProjectEnvironment, @NotNull CompilerConfiguration compilerConfig, @NotNull List<? extends KtFile> ktFiles) {
        KaSourceModule kaSourceModule;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Object it;
        Object $this$buildKtScriptModule$iv;
        KtModuleProviderBuilder ktModuleProviderBuilder;
        Intrinsics.checkNotNullParameter((Object)kotlinCoreProjectEnvironment, (String)"kotlinCoreProjectEnvironment");
        Intrinsics.checkNotNullParameter((Object)compilerConfig, (String)"compilerConfig");
        Intrinsics.checkNotNullParameter(ktFiles, (String)"ktFiles");
        boolean $i$f$buildProjectStructureProvider = false;
        KtModuleProviderBuilder $this$buildKtModuleProviderByCompilerConfiguration_u24lambda_u2415 = ktModuleProviderBuilder = new KtModuleProviderBuilder(kotlinCoreProjectEnvironment);
        boolean bl = false;
        Iterable $this$partition$iv = ktFiles;
        boolean $i$f$partition = false;
        ArrayList first$iv = new ArrayList();
        ArrayList second$iv = new ArrayList();
        for (Object element$iv : $this$partition$iv) {
            KtFile it2 = (KtFile)element$iv;
            boolean bl2 = false;
            if (it2.isScript()) {
                first$iv.add(element$iv);
                continue;
            }
            second$iv.add(element$iv);
        }
        List scriptFiles = (List)new Pair(first$iv, second$iv).component1();
        TargetPlatform platform = JvmPlatforms.INSTANCE.getDefaultJvmPlatform();
        LanguageVersionSettings configLanguageVersionSettings = (LanguageVersionSettings)compilerConfig.get(CommonConfigurationKeys.LANGUAGE_VERSION_SETTINGS);
        for (KtFile scriptFile : scriptFiles) {
            KtScriptModuleBuilder bl2;
            $this$buildKtScriptModule$iv = $this$buildKtModuleProviderByCompilerConfiguration_u24lambda_u2415;
            boolean $i$f$buildKtScriptModule = false;
            KtScriptModuleBuilder $this$buildKtModuleProviderByCompilerConfiguration_u24lambda_u2415_u24lambda_u2410 = bl2 = new KtScriptModuleBuilder(((KtModuleProviderBuilder)$this$buildKtScriptModule$iv).getKotlinCoreProjectEnvironment());
            boolean bl3 = false;
            if (configLanguageVersionSettings != null) {
                boolean bl4 = false;
                $this$buildKtModuleProviderByCompilerConfiguration_u24lambda_u2415_u24lambda_u2410.setLanguageVersionSettings((LanguageVersionSettings)it);
            }
            $this$buildKtModuleProviderByCompilerConfiguration_u24lambda_u2415_u24lambda_u2410.setPlatform(platform);
            $this$buildKtModuleProviderByCompilerConfiguration_u24lambda_u2415_u24lambda_u2410.setFile(scriptFile);
            KaModuleUtilsKt.buildKtModuleProviderByCompilerConfiguration$lambda$15$addModuleDependencies($this$buildKtModuleProviderByCompilerConfiguration_u24lambda_u2415_u24lambda_u2410, compilerConfig, $this$buildKtModuleProviderByCompilerConfiguration_u24lambda_u2415, platform, "Script " + scriptFile.getName());
            Object p0 = $this$buildKtScriptModule$iv = bl2.build();
            boolean bl5 = false;
            $this$buildKtModuleProviderByCompilerConfiguration_u24lambda_u2415.addModule((KaModule)p0);
        }
        KtModuleProviderBuilder $this$buildKtSourceModule$iv = $this$buildKtModuleProviderByCompilerConfiguration_u24lambda_u2415;
        boolean $i$f$buildKtSourceModule = false;
        Object $this$buildKtModuleProviderByCompilerConfiguration_u24lambda_u2415_u24lambda_u2413 = $this$buildKtScriptModule$iv = new KtSourceModuleBuilder($this$buildKtSourceModule$iv.getKotlinCoreProjectEnvironment());
        boolean bl6 = false;
        LanguageVersionSettings languageVersionSettings = configLanguageVersionSettings;
        if (languageVersionSettings != null) {
            LanguageVersionSettings it3 = languageVersionSettings;
            boolean bl7 = false;
            ((KtSourceModuleBuilder)$this$buildKtModuleProviderByCompilerConfiguration_u24lambda_u2415_u24lambda_u2413).setLanguageVersionSettings(it3);
        }
        ((KtModuleBuilder)$this$buildKtModuleProviderByCompilerConfiguration_u24lambda_u2415_u24lambda_u2413).setPlatform(platform);
        String string = (String)compilerConfig.get(CommonConfigurationKeys.MODULE_NAME);
        if (string == null) {
            string = "<no module name provided>";
        }
        ((KtSourceModuleBuilder)$this$buildKtModuleProviderByCompilerConfiguration_u24lambda_u2415_u24lambda_u2413).setModuleName(string);
        KaModuleUtilsKt.buildKtModuleProviderByCompilerConfiguration$lambda$15$addModuleDependencies((KtModuleBuilder)$this$buildKtModuleProviderByCompilerConfiguration_u24lambda_u2415_u24lambda_u2413, compilerConfig, $this$buildKtModuleProviderByCompilerConfiguration_u24lambda_u2415, platform, ((KtSourceModuleBuilder)$this$buildKtModuleProviderByCompilerConfiguration_u24lambda_u2415_u24lambda_u2413).getModuleName());
        it = JvmContentRootsKt.getJavaSourceRoots((CompilerConfiguration)compilerConfig);
        Object object = $this$buildKtModuleProviderByCompilerConfiguration_u24lambda_u2415_u24lambda_u2413;
        boolean $i$f$map = false;
        void bl7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it4;
            String string2 = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl8 = false;
            collection.add(Paths.get((String)it4, new String[0]));
        }
        ((KtSourceModuleBuilder)object).addSourceRoots((List)destination$iv$iv);
        KaSourceModule p0 = kaSourceModule = ((KtSourceModuleBuilder)$this$buildKtScriptModule$iv).build();
        boolean bl9 = false;
        $this$buildKtModuleProviderByCompilerConfiguration_u24lambda_u2415.addModule((KaModule)p0);
        $this$buildKtModuleProviderByCompilerConfiguration_u24lambda_u2415.setPlatform(platform);
        return ktModuleProviderBuilder.build();
    }

    /*
     * WARNING - void declaration
     */
    private static final void buildKtModuleProviderByCompilerConfiguration$lambda$15$addModuleDependencies(KtModuleBuilder $this$buildKtModuleProviderByCompilerConfiguration_u24lambda_u2415_u24addModuleDependencies, CompilerConfiguration $compilerConfig, KtModuleProviderBuilder $this_buildProjectStructureProvider, TargetPlatform platform, String moduleName) {
        block1: {
            void $this$buildKtModuleProviderByCompilerConfiguration_u24lambda_u2415_u24addModuleDependencies_u24lambda_u248_u24lambda_u247;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            void $this$buildKtModuleProviderByCompilerConfiguration_u24lambda_u2415_u24addModuleDependencies_u24lambda_u246;
            KtLibraryModuleBuilder ktLibraryModuleBuilder;
            List libraryRoots = CollectionsKt.plus((Collection)JvmContentRootsKt.getJvmModularRoots((CompilerConfiguration)$compilerConfig), (Iterable)JvmContentRootsKt.getJvmClasspathRoots((CompilerConfiguration)$compilerConfig));
            KtModuleProviderBuilder $this$buildKtLibraryModule$iv = $this_buildProjectStructureProvider;
            boolean $i$f$buildKtLibraryModule = false;
            KtLibraryModuleBuilder ktLibraryModuleBuilder2 = ktLibraryModuleBuilder = new KtLibraryModuleBuilder($this$buildKtLibraryModule$iv.getKotlinCoreProjectEnvironment());
            KtModuleBuilder ktModuleBuilder = $this$buildKtModuleProviderByCompilerConfiguration_u24lambda_u2415_u24addModuleDependencies;
            boolean bl = false;
            $this$buildKtModuleProviderByCompilerConfiguration_u24lambda_u2415_u24addModuleDependencies_u24lambda_u246.setPlatform(platform);
            Iterable iterable = libraryRoots;
            KtSdkModuleBuilder ktSdkModuleBuilder = $this$buildKtModuleProviderByCompilerConfiguration_u24lambda_u2415_u24addModuleDependencies_u24lambda_u246;
            boolean $i$f$map22 = false;
            KtModuleBuilder ktModuleBuilder2 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                File file = (File)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(it.toPath());
            }
            ktSdkModuleBuilder.addBinaryRoots((List)destination$iv$iv);
            $this$buildKtModuleProviderByCompilerConfiguration_u24lambda_u2415_u24addModuleDependencies_u24lambda_u246.setLibraryName("Library for " + moduleName);
            ktModuleBuilder.addRegularDependency(ktLibraryModuleBuilder.build());
            File file = (File)$compilerConfig.get(JVMConfigurationKeys.JDK_HOME);
            if (file == null) break block1;
            File jdkHome = file;
            boolean bl3 = false;
            KtModuleProviderBuilder $this$buildKtSdkModule$iv = $this_buildProjectStructureProvider;
            boolean $i$f$buildKtSdkModule = false;
            KtSdkModuleBuilder $i$f$map22 = ktSdkModuleBuilder = new KtSdkModuleBuilder($this$buildKtSdkModule$iv.getKotlinCoreProjectEnvironment());
            ktModuleBuilder2 = $this$buildKtModuleProviderByCompilerConfiguration_u24lambda_u2415_u24addModuleDependencies;
            boolean bl4 = false;
            $this$buildKtModuleProviderByCompilerConfiguration_u24lambda_u2415_u24addModuleDependencies_u24lambda_u248_u24lambda_u247.setPlatform(platform);
            Path path = jdkHome.toPath();
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toPath(...)");
            $this$buildKtModuleProviderByCompilerConfiguration_u24lambda_u2415_u24addModuleDependencies_u24lambda_u248_u24lambda_u247.addBinaryRootsFromJdkHome(path, false);
            $this$buildKtModuleProviderByCompilerConfiguration_u24lambda_u2415_u24addModuleDependencies_u24lambda_u248_u24lambda_u247.setLibraryName("JDK for " + moduleName);
            ktModuleBuilder2.addRegularDependency(ktSdkModuleBuilder.build());
        }
    }
}

