/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.daemon.report;

import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.build.report.ICReporter;
import org.jetbrains.kotlin.build.report.ICReporterBase;
import org.jetbrains.kotlin.build.report.RemoteICReporter;
import org.jetbrains.kotlin.cli.common.ExitCode;
import org.jetbrains.kotlin.daemon.common.CompilationResultCategory;
import org.jetbrains.kotlin.daemon.common.CompilationResults;

@VisibleForTesting
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002B#\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u001e\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\r0\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J&\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\b2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00060\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u001e\u0010\u001d\u001a\u00020\u00122\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00060\u001f2\u0006\u0010 \u001a\u00020\rH\u0016J\b\u0010!\u001a\u00020\u0012H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000b\u001a\u0012\u0012\u0004\u0012\u00020\r0\fj\b\u0012\u0004\u0012\u00020\r`\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\r0\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lorg/jetbrains/kotlin/daemon/report/BuildReportICReporter;", "Lorg/jetbrains/kotlin/build/report/ICReporterBase;", "Lorg/jetbrains/kotlin/build/report/RemoteICReporter;", "compilationResults", "Lorg/jetbrains/kotlin/daemon/common/CompilationResults;", "rootDir", "Ljava/io/File;", "isVerbose", "", "<init>", "(Lorg/jetbrains/kotlin/daemon/common/CompilationResults;Ljava/io/File;Z)V", "icLogLines", "Ljava/util/ArrayList;", "", "Lkotlin/collections/ArrayList;", "recompilationReason", "Ljava/util/HashMap;", "report", "", "message", "Lkotlin/Function0;", "severity", "Lorg/jetbrains/kotlin/build/report/ICReporter$ReportSeverity;", "reportCompileIteration", "incremental", "sourceFiles", "", "exitCode", "Lorg/jetbrains/kotlin/cli/common/ExitCode;", "reportMarkDirty", "affectedFiles", "", "reason", "flush", "kotlin-daemon"})
@SourceDebugExtension(value={"SMAP\nBuildReportICReporter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BuildReportICReporter.kt\norg/jetbrains/kotlin/daemon/report/BuildReportICReporter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,52:1\n1#2:53\n1863#3,2:54\n*S KotlinDebug\n*F\n+ 1 BuildReportICReporter.kt\norg/jetbrains/kotlin/daemon/report/BuildReportICReporter\n*L\n46#1:54,2\n*E\n"})
public final class BuildReportICReporter
extends ICReporterBase
implements RemoteICReporter {
    @NotNull
    private final CompilationResults compilationResults;
    private final boolean isVerbose;
    @NotNull
    private final ArrayList<String> icLogLines;
    @NotNull
    private final HashMap<File, String> recompilationReason;

    public BuildReportICReporter(@NotNull CompilationResults compilationResults, @Nullable File rootDir, boolean isVerbose) {
        Intrinsics.checkNotNullParameter((Object)compilationResults, (String)"compilationResults");
        super(rootDir);
        this.compilationResults = compilationResults;
        this.isVerbose = isVerbose;
        this.icLogLines = new ArrayList();
        this.recompilationReason = new HashMap();
    }

    public /* synthetic */ BuildReportICReporter(CompilationResults compilationResults, File file, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            bl = false;
        }
        this(compilationResults, file, bl);
    }

    public void report(@NotNull Function0<String> message, @NotNull ICReporter.ReportSeverity severity) {
        Intrinsics.checkNotNullParameter(message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)severity, (String)"severity");
        if (severity == ICReporter.ReportSeverity.DEBUG && !this.isVerbose) {
            return;
        }
        this.icLogLines.add((String)message.invoke());
    }

    public void reportCompileIteration(boolean incremental, @NotNull Collection<? extends File> sourceFiles, @NotNull ExitCode exitCode) {
        Intrinsics.checkNotNullParameter(sourceFiles, (String)"sourceFiles");
        Intrinsics.checkNotNullParameter((Object)exitCode, (String)"exitCode");
        if (!incremental) {
            return;
        }
        this.icLogLines.add("Compile iteration:");
        for (File file : sourceFiles) {
            String string;
            block6: {
                block5: {
                    string = this.recompilationReason.get(file);
                    if (string == null) break block5;
                    String it = string;
                    boolean bl = false;
                    String string2 = " <- " + it;
                    string = string2;
                    if (string2 != null) break block6;
                }
                string = "";
            }
            String reason = string;
            this.icLogLines.add("  " + this.relativeOrAbsolute(file) + reason);
        }
        this.recompilationReason.clear();
    }

    public void reportMarkDirty(@NotNull Iterable<? extends File> affectedFiles, @NotNull String reason) {
        Intrinsics.checkNotNullParameter(affectedFiles, (String)"affectedFiles");
        Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
        Iterable<? extends File> $this$forEach$iv = affectedFiles;
        boolean $i$f$forEach = false;
        Iterator<? extends File> iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            File element$iv;
            File it = element$iv = iterator.next();
            boolean bl = false;
            ((Map)this.recompilationReason).put(it, reason);
        }
    }

    public void flush() {
        this.compilationResults.add(CompilationResultCategory.BUILD_REPORT_LINES.getCode(), this.icLogLines);
    }
}

