/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common;

import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.BackendContext;
import org.jetbrains.kotlin.backend.common.DefaultInlineClassesUtils;
import org.jetbrains.kotlin.backend.common.ErrorReportingContext;
import org.jetbrains.kotlin.backend.common.InlineClassesUtils;
import org.jetbrains.kotlin.backend.common.LoggingContext;
import org.jetbrains.kotlin.backend.common.Mapping;
import org.jetbrains.kotlin.backend.common.ir.Ir;
import org.jetbrains.kotlin.backend.common.lower.InnerClassesSupport;
import org.jetbrains.kotlin.backend.common.phaser.BackendContextHolder;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.config.CommonConfigurationKeysKt;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.ir.builders.ExpressionHelpersKt;
import org.jetbrains.kotlin.ir.builders.IrBuilderWithScope;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrStatementOrigin;
import org.jetbrains.kotlin.ir.linkage.partial.PartialLinkageSupportForLowerings;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrFileSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00b0\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\bf\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u0004J\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016JD\u0010\"\u001a\u00020#2\u0012\u0010$\u001a\u000e\u0012\u0004\u0012\u00020&\u0012\u0004\u0012\u00020&0%2\u0012\u0010'\u001a\u000e\u0012\u0004\u0012\u00020(\u0012\u0004\u0012\u00020(0%2\u0012\u0010)\u001a\u000e\u0012\u0004\u0012\u00020*\u0012\u0004\u0012\u00020*0%H\u0016J\u0010\u0010+\u001a\u00020\u00112\u0006\u0010,\u001a\u00020-H\u0016J.\u0010<\u001a\u00020#2\u0006\u0010=\u001a\u00020>2\u0006\u0010?\u001a\u00020>2\u0014\u0010@\u001a\u0010\u0012\u0004\u0012\u00020B\u0012\u0004\u0012\u00020B\u0018\u00010AH\u0016R\u0018\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00000\u0006X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\u00008VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0012\u0010\f\u001a\u00020\rX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0012\u0010\u0010\u001a\u00020\u0011X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0012\u0010\u001e\u001a\u00020\u001fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010!R\u0014\u0010.\u001a\u00020\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b/\u0010\u0013R\u0016\u00100\u001a\u0004\u0018\u0001018VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b2\u00103R\u0014\u00104\u001a\u0002058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b6\u00107R\u0014\u00108\u001a\u00020\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b9\u0010\u0013R\u0014\u0010:\u001a\u00020\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b;\u0010\u0013R\u0014\u0010C\u001a\u00020D8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bE\u0010FR\u0014\u0010G\u001a\u00020H8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bI\u0010JR\u0012\u0010K\u001a\u00020LX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\bM\u0010N\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006O\u00c0\u0006\u0001"}, d2={"Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;", "Lorg/jetbrains/kotlin/backend/common/BackendContext;", "Lorg/jetbrains/kotlin/backend/common/LoggingContext;", "Lorg/jetbrains/kotlin/backend/common/ErrorReportingContext;", "Lorg/jetbrains/kotlin/backend/common/phaser/BackendContextHolder;", "ir", "Lorg/jetbrains/kotlin/backend/common/ir/Ir;", "getIr", "()Lorg/jetbrains/kotlin/backend/common/ir/Ir;", "heldBackendContext", "getHeldBackendContext", "()Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;", "configuration", "Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "getConfiguration", "()Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "scriptMode", "", "getScriptMode", "()Z", "messageCollector", "Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;", "getMessageCollector", "()Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;", "throwUninitializedPropertyAccessException", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "builder", "Lorg/jetbrains/kotlin/ir/builders/IrBuilderWithScope;", "name", "", "mapping", "Lorg/jetbrains/kotlin/backend/common/Mapping;", "getMapping", "()Lorg/jetbrains/kotlin/backend/common/Mapping;", "handleDeepCopy", "", "fileSymbolMap", "", "Lorg/jetbrains/kotlin/ir/symbols/IrFileSymbol;", "classSymbolMap", "Lorg/jetbrains/kotlin/ir/symbols/IrClassSymbol;", "functionSymbolMap", "Lorg/jetbrains/kotlin/ir/symbols/IrSimpleFunctionSymbol;", "isSideEffectFree", "call", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "preferJavaLikeCounterLoop", "getPreferJavaLikeCounterLoop", "doWhileCounterLoopOrigin", "Lorg/jetbrains/kotlin/ir/expressions/IrStatementOrigin;", "getDoWhileCounterLoopOrigin", "()Lorg/jetbrains/kotlin/ir/expressions/IrStatementOrigin;", "inductionVariableOrigin", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationOrigin;", "getInductionVariableOrigin", "()Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationOrigin;", "optimizeLoopsOverUnsignedArrays", "getOptimizeLoopsOverUnsignedArrays", "optimizeNullChecksUsingKotlinNullability", "getOptimizeNullChecksUsingKotlinNullability", "remapMultiFieldValueClassStructure", "oldFunction", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "newFunction", "parametersMappingOrNull", "", "Lorg/jetbrains/kotlin/ir/declarations/IrValueParameter;", "inlineClassesUtils", "Lorg/jetbrains/kotlin/backend/common/InlineClassesUtils;", "getInlineClassesUtils", "()Lorg/jetbrains/kotlin/backend/common/InlineClassesUtils;", "partialLinkageSupport", "Lorg/jetbrains/kotlin/ir/linkage/partial/PartialLinkageSupportForLowerings;", "getPartialLinkageSupport", "()Lorg/jetbrains/kotlin/ir/linkage/partial/PartialLinkageSupportForLowerings;", "innerClassesSupport", "Lorg/jetbrains/kotlin/backend/common/lower/InnerClassesSupport;", "getInnerClassesSupport", "()Lorg/jetbrains/kotlin/backend/common/lower/InnerClassesSupport;", "ir.backend.common"})
public interface CommonBackendContext
extends BackendContext,
ErrorReportingContext,
LoggingContext,
BackendContextHolder {
    @Override
    @NotNull
    public Ir<CommonBackendContext> getIr();

    @Override
    @NotNull
    default public CommonBackendContext getHeldBackendContext() {
        return this;
    }

    @NotNull
    public CompilerConfiguration getConfiguration();

    public boolean getScriptMode();

    @Override
    @NotNull
    default public MessageCollector getMessageCollector() {
        return CommonConfigurationKeysKt.getMessageCollector(this.getConfiguration());
    }

    @NotNull
    default public IrExpression throwUninitializedPropertyAccessException(@NotNull IrBuilderWithScope builder, @NotNull String name2) {
        IrFunctionAccessExpression irFunctionAccessExpression;
        Intrinsics.checkNotNullParameter(builder, "builder");
        Intrinsics.checkNotNullParameter(name2, "name");
        IrSimpleFunction throwErrorFunction = (IrSimpleFunction)this.getIr().getSymbols().getThrowUninitializedPropertyAccessException().getOwner();
        IrFunctionAccessExpression $this$throwUninitializedPropertyAccessException_u24lambda_u240 = irFunctionAccessExpression = ExpressionHelpersKt.irCall(builder, throwErrorFunction);
        boolean bl = false;
        $this$throwUninitializedPropertyAccessException_u24lambda_u240.putValueArgument(0, ExpressionHelpersKt.irString(builder, name2));
        return irFunctionAccessExpression;
    }

    @NotNull
    public Mapping getMapping();

    default public void handleDeepCopy(@NotNull Map<IrFileSymbol, IrFileSymbol> fileSymbolMap, @NotNull Map<IrClassSymbol, IrClassSymbol> classSymbolMap, @NotNull Map<IrSimpleFunctionSymbol, IrSimpleFunctionSymbol> functionSymbolMap) {
        Intrinsics.checkNotNullParameter(fileSymbolMap, "fileSymbolMap");
        Intrinsics.checkNotNullParameter(classSymbolMap, "classSymbolMap");
        Intrinsics.checkNotNullParameter(functionSymbolMap, "functionSymbolMap");
    }

    default public boolean isSideEffectFree(@NotNull IrCall call2) {
        Intrinsics.checkNotNullParameter(call2, "call");
        return false;
    }

    default public boolean getPreferJavaLikeCounterLoop() {
        return false;
    }

    @Nullable
    default public IrStatementOrigin getDoWhileCounterLoopOrigin() {
        return null;
    }

    @NotNull
    default public IrDeclarationOrigin getInductionVariableOrigin() {
        return IrDeclarationOrigin.Companion.getIR_TEMPORARY_VARIABLE();
    }

    default public boolean getOptimizeLoopsOverUnsignedArrays() {
        return false;
    }

    default public boolean getOptimizeNullChecksUsingKotlinNullability() {
        return true;
    }

    default public void remapMultiFieldValueClassStructure(@NotNull IrFunction oldFunction, @NotNull IrFunction newFunction, @Nullable Map<IrValueParameter, ? extends IrValueParameter> parametersMappingOrNull) {
        Intrinsics.checkNotNullParameter(oldFunction, "oldFunction");
        Intrinsics.checkNotNullParameter(newFunction, "newFunction");
    }

    @NotNull
    default public InlineClassesUtils getInlineClassesUtils() {
        return DefaultInlineClassesUtils.INSTANCE;
    }

    @NotNull
    default public PartialLinkageSupportForLowerings getPartialLinkageSupport() {
        return PartialLinkageSupportForLowerings.Companion.getDISABLED();
    }

    @NotNull
    public InnerClassesSupport getInnerClassesSupport();
}

