/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.resolve.sam.SamConversionResolverImplKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u0007R\u0011\u0010\u000e\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/backend/common/SamType;", "", "type", "Lorg/jetbrains/kotlin/types/KotlinType;", "<init>", "(Lorg/jetbrains/kotlin/types/KotlinType;)V", "getType", "()Lorg/jetbrains/kotlin/types/KotlinType;", "classDescriptor", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "getClassDescriptor", "()Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "kotlinFunctionType", "getKotlinFunctionType", "originalAbstractMethod", "Lorg/jetbrains/kotlin/descriptors/SimpleFunctionDescriptor;", "getOriginalAbstractMethod", "()Lorg/jetbrains/kotlin/descriptors/SimpleFunctionDescriptor;", "equals", "", "other", "hashCode", "", "toString", "", "backend-common"})
public final class SamType {
    @NotNull
    private final KotlinType type;

    public SamType(@NotNull KotlinType type2) {
        Intrinsics.checkNotNullParameter(type2, "type");
        this.type = type2;
    }

    @NotNull
    public final KotlinType getType() {
        return this.type;
    }

    @NotNull
    public final ClassDescriptor getClassDescriptor() {
        ClassifierDescriptor classifierDescriptor = this.type.getConstructor().getDeclarationDescriptor();
        ClassDescriptor classDescriptor = classifierDescriptor instanceof ClassDescriptor ? (ClassDescriptor)classifierDescriptor : null;
        if (classDescriptor == null) {
            throw new IllegalStateException(("Sam/Fun interface not a class descriptor: " + this.type).toString());
        }
        return classDescriptor;
    }

    @NotNull
    public final KotlinType getKotlinFunctionType() {
        SimpleType simpleType = this.getClassDescriptor().getDefaultFunctionTypeForSamInterface();
        Intrinsics.checkNotNull(simpleType);
        return simpleType;
    }

    @NotNull
    public final SimpleFunctionDescriptor getOriginalAbstractMethod() {
        CallableMemberDescriptor callableMemberDescriptor = SamConversionResolverImplKt.getAbstractMembers(this.getClassDescriptor()).get(0);
        Intrinsics.checkNotNull(callableMemberDescriptor, "null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor");
        return (SimpleFunctionDescriptor)callableMemberDescriptor;
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof SamType && Intrinsics.areEqual(this.type, ((SamType)other).type);
    }

    public int hashCode() {
        return this.type.hashCode();
    }

    @NotNull
    public String toString() {
        return "SamType(" + this.type + ')';
    }
}

