/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.range.forLoop;

import java.util.Collection;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.codegen.ExpressionCodegen;
import org.jetbrains.kotlin.codegen.StackValue;
import org.jetbrains.kotlin.codegen.range.comparison.ComparisonGenerator;
import org.jetbrains.kotlin.codegen.range.comparison.ComparisonGeneratorKt;
import org.jetbrains.kotlin.codegen.range.comparison.SignedIntegerComparisonGenerator;
import org.jetbrains.kotlin.codegen.range.forLoop.AbstractForInProgressionOrRangeLoopGenerator;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtForExpression;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.RangeUtilKt;
import org.jetbrains.org.objectweb.asm.Label;
import org.jetbrains.org.objectweb.asm.Type;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u001b\u001a\u00020\u001cH\u0016J\b\u0010\u001d\u001a\u00020\u001cH$J\u0010\u0010\u001e\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020 H\u0016J\b\u0010!\u001a\u00020\u001cH\u0014J\u0010\u0010\"\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020 H\u0014R\u001a\u0010\b\u001a\u00020\tX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000fX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\u00020\u000fX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0011R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lorg/jetbrains/kotlin/codegen/range/forLoop/AbstractForInProgressionLoopGenerator;", "Lorg/jetbrains/kotlin/codegen/range/forLoop/AbstractForInProgressionOrRangeLoopGenerator;", "codegen", "Lorg/jetbrains/kotlin/codegen/ExpressionCodegen;", "forExpression", "Lorg/jetbrains/kotlin/psi/KtForExpression;", "<init>", "(Lorg/jetbrains/kotlin/codegen/ExpressionCodegen;Lorg/jetbrains/kotlin/psi/KtForExpression;)V", "incrementVar", "", "getIncrementVar", "()I", "setIncrementVar", "(I)V", "asmLoopRangeType", "Lorg/jetbrains/org/objectweb/asm/Type;", "getAsmLoopRangeType", "()Lorg/jetbrains/org/objectweb/asm/Type;", "rangeElementKotlinType", "Lorg/jetbrains/kotlin/types/KotlinType;", "incrementKotlinType", "incrementType", "getIncrementType", "incrementComparisonGenerator", "Lorg/jetbrains/kotlin/codegen/range/comparison/SignedIntegerComparisonGenerator;", "elementComparisonGenerator", "Lorg/jetbrains/kotlin/codegen/range/comparison/ComparisonGenerator;", "beforeLoop", "", "storeProgressionParametersToLocalVars", "checkEmptyLoop", "loopExit", "Lorg/jetbrains/org/objectweb/asm/Label;", "assignToLoopParameter", "checkPostConditionAndIncrement", "backend"})
@SourceDebugExtension(value={"SMAP\nAbstractForInProgressionLoopGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractForInProgressionLoopGenerator.kt\norg/jetbrains/kotlin/codegen/range/forLoop/AbstractForInProgressionLoopGenerator\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,98:1\n1#2:99\n*E\n"})
public abstract class AbstractForInProgressionLoopGenerator
extends AbstractForInProgressionOrRangeLoopGenerator {
    private int incrementVar;
    @NotNull
    private final Type asmLoopRangeType;
    @NotNull
    private final KotlinType rangeElementKotlinType;
    @NotNull
    private final KotlinType incrementKotlinType;
    @NotNull
    private final Type incrementType;
    @NotNull
    private final SignedIntegerComparisonGenerator incrementComparisonGenerator;
    @NotNull
    private final ComparisonGenerator elementComparisonGenerator;

    public AbstractForInProgressionLoopGenerator(@NotNull ExpressionCodegen codegen2, @NotNull KtForExpression forExpression) {
        boolean bl;
        Intrinsics.checkNotNullParameter(codegen2, "codegen");
        Intrinsics.checkNotNullParameter(forExpression, "forExpression");
        super(codegen2, forExpression);
        this.incrementVar = -1;
        Type type2 = codegen2.asmType(this.getRangeKotlinType());
        Intrinsics.checkNotNullExpressionValue(type2, "asmType(...)");
        this.asmLoopRangeType = type2;
        KotlinType kotlinType = RangeUtilKt.getRangeOrProgressionElementType$default(this.getRangeKotlinType(), null, 2, null);
        if (kotlinType == null) {
            throw new AssertionError((Object)("Unexpected loop range type: " + this.getRangeKotlinType()));
        }
        this.rangeElementKotlinType = kotlinType;
        MemberScope memberScope2 = this.getRangeKotlinType().getMemberScope();
        Name name2 = Name.identifier("step");
        Intrinsics.checkNotNullExpressionValue(name2, "identifier(...)");
        Collection<? extends PropertyDescriptor> incrementProp = memberScope2.getContributedVariables(name2, NoLookupLocation.FROM_BACKEND);
        boolean bl2 = bl = incrementProp.size() == 1;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string2 = "" + this.getRangeKotlinType() + ' ' + incrementProp.size();
            throw new AssertionError((Object)string2);
        }
        this.incrementKotlinType = ((PropertyDescriptor)CollectionsKt.single((Iterable)incrementProp)).getType();
        this.incrementType = codegen2.asmType(this.incrementKotlinType);
        ComparisonGenerator comparisonGenerator = ComparisonGeneratorKt.getComparisonGeneratorForKotlinType(this.incrementKotlinType);
        SignedIntegerComparisonGenerator signedIntegerComparisonGenerator = comparisonGenerator instanceof SignedIntegerComparisonGenerator ? (SignedIntegerComparisonGenerator)comparisonGenerator : null;
        if (signedIntegerComparisonGenerator == null) {
            throw new AssertionError((Object)("Unexpected increment type: " + this.incrementKotlinType));
        }
        this.incrementComparisonGenerator = signedIntegerComparisonGenerator;
        this.elementComparisonGenerator = ComparisonGeneratorKt.getComparisonGeneratorForKotlinType(this.rangeElementKotlinType);
    }

    protected final int getIncrementVar() {
        return this.incrementVar;
    }

    protected final void setIncrementVar(int n) {
        this.incrementVar = n;
    }

    @NotNull
    protected final Type getAsmLoopRangeType() {
        return this.asmLoopRangeType;
    }

    @NotNull
    protected final Type getIncrementType() {
        return this.incrementType;
    }

    @Override
    public void beforeLoop() {
        super.beforeLoop();
        this.incrementVar = this.createLoopTempVariable(this.getAsmElementType());
        this.storeProgressionParametersToLocalVars();
    }

    protected abstract void storeProgressionParametersToLocalVars();

    @Override
    public void checkEmptyLoop(@NotNull Label loopExit) {
        Intrinsics.checkNotNullParameter(loopExit, "loopExit");
        this.loopParameter().put(this.getAsmElementType(), this.getElementType(), this.getV());
        this.getV().load(this.getEndVar(), this.getAsmElementType());
        this.getV().load(this.incrementVar, this.incrementType);
        Label negativeIncrement = new Label();
        Label afterIf = new Label();
        this.incrementComparisonGenerator.jumpIfLessThanZero(this.getV(), negativeIncrement);
        this.elementComparisonGenerator.jumpIfGreater(this.getV(), loopExit);
        this.getV().goTo(afterIf);
        this.getV().mark(negativeIncrement);
        this.elementComparisonGenerator.jumpIfLess(this.getV(), loopExit);
        this.getV().mark(afterIf);
    }

    @Override
    protected void assignToLoopParameter() {
    }

    @Override
    protected void checkPostConditionAndIncrement(@NotNull Label loopExit) {
        Intrinsics.checkNotNullParameter(loopExit, "loopExit");
        this.checkPostCondition(loopExit);
        StackValue loopParameter = this.loopParameter();
        loopParameter.put(this.getAsmElementType(), this.getElementType(), this.getV());
        this.getV().load(this.incrementVar, this.getAsmElementType());
        this.getV().add(this.getAsmElementType());
        if (this.getAsmElementType() == Type.BYTE_TYPE || this.getAsmElementType() == Type.SHORT_TYPE || this.getAsmElementType() == Type.CHAR_TYPE) {
            StackValue.coerce(Type.INT_TYPE, this.getAsmElementType(), this.getV());
        }
        loopParameter.store(StackValue.onStack(this.getAsmElementType(), this.getElementType()), this.getV());
    }
}

