/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.ic;

import java.io.File;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\u000eB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\t\u001a\u00020\nJ\u0006\u0010\u000b\u001a\u00020\fJ\u0006\u0010\r\u001a\u00020\fR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/ic/IncrementalCacheGuard;", "", "cacheDir", "", "<init>", "(Ljava/lang/String;)V", "cacheRoot", "Ljava/io/File;", "guardFile", "acquire", "Lorg/jetbrains/kotlin/ir/backend/js/ic/IncrementalCacheGuard$AcquireStatus;", "tryAcquire", "", "release", "AcquireStatus", "backend.js"})
public final class IncrementalCacheGuard {
    @NotNull
    private final File cacheRoot;
    @NotNull
    private final File guardFile;

    public IncrementalCacheGuard(@NotNull String cacheDir) {
        Intrinsics.checkNotNullParameter(cacheDir, "cacheDir");
        this.cacheRoot = new File(cacheDir);
        this.guardFile = FilesKt.resolve(this.cacheRoot, "cache.guard");
    }

    @NotNull
    public final AcquireStatus acquire() {
        boolean cacheCleared = this.guardFile.exists();
        if (cacheCleared) {
            FilesKt.deleteRecursively(this.cacheRoot);
        }
        this.tryAcquire();
        return cacheCleared ? AcquireStatus.CACHE_CLEARED : AcquireStatus.OK;
    }

    public final void tryAcquire() {
        this.cacheRoot.mkdirs();
        this.guardFile.createNewFile();
    }

    public final void release() {
        this.guardFile.delete();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/ic/IncrementalCacheGuard$AcquireStatus;", "", "<init>", "(Ljava/lang/String;I)V", "OK", "CACHE_CLEARED", "backend.js"})
    public static final class AcquireStatus
    extends Enum<AcquireStatus> {
        public static final /* enum */ AcquireStatus OK = new AcquireStatus();
        public static final /* enum */ AcquireStatus CACHE_CLEARED = new AcquireStatus();
        private static final /* synthetic */ AcquireStatus[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static AcquireStatus[] values() {
            return (AcquireStatus[])$VALUES.clone();
        }

        public static AcquireStatus valueOf(String value2) {
            return Enum.valueOf(AcquireStatus.class, value2);
        }

        @NotNull
        public static EnumEntries<AcquireStatus> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = acquireStatusArray = new AcquireStatus[]{AcquireStatus.OK, AcquireStatus.CACHE_CLEARED};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

