/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.library.abi.impl;

import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.library.abi.AbiFunction;
import org.jetbrains.kotlin.library.abi.AbiModality;
import org.jetbrains.kotlin.library.abi.AbiQualifiedName;
import org.jetbrains.kotlin.library.abi.AbiSignatures;
import org.jetbrains.kotlin.library.abi.AbiTypeParameter;
import org.jetbrains.kotlin.library.abi.AbiValueParameter;
import org.jetbrains.kotlin.library.abi.ExperimentalLibraryAbiReader;
import org.jetbrains.kotlin.library.abi.impl.FlagFieldEx;
import org.jetbrains.kotlin.metadata.deserialization.Flags;

@ExperimentalLibraryAbiReader
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0001\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0001\u0018\u0000 ,2\u00020\u0001:\u0001,BC\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0010\u0010*\u001a\u00020\t2\u0006\u0010+\u001a\u00020\u0003H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u000e\u0010\u0017\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0018\u001a\u00020\u00198VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u0014\u0010\u001c\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u001dR\u0014\u0010\u001e\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001dR\u0014\u0010\u001f\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010\u001dR\u0014\u0010\n\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"R\u0016\u0010#\u001a\u0004\u0018\u00010$8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b%\u0010&R\u001a\u0010'\u001a\b\u0012\u0004\u0012\u00020(0\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b)\u0010\u0016\u00a8\u0006-"}, d2={"Lorg/jetbrains/kotlin/library/abi/impl/AbiConstructorImpl;", "Lorg/jetbrains/kotlin/library/abi/AbiFunction;", "qualifiedName", "Lorg/jetbrains/kotlin/library/abi/AbiQualifiedName;", "signatures", "Lorg/jetbrains/kotlin/library/abi/AbiSignatures;", "annotations", "", "isInline", "", "contextReceiverParametersCount", "", "valueParameters", "", "Lorg/jetbrains/kotlin/library/abi/AbiValueParameter;", "<init>", "(Lorg/jetbrains/kotlin/library/abi/AbiQualifiedName;Lorg/jetbrains/kotlin/library/abi/AbiSignatures;Ljava/util/Set;ZILjava/util/List;)V", "getQualifiedName", "()Lorg/jetbrains/kotlin/library/abi/AbiQualifiedName;", "getSignatures", "()Lorg/jetbrains/kotlin/library/abi/AbiSignatures;", "getValueParameters", "()Ljava/util/List;", "flags", "modality", "Lorg/jetbrains/kotlin/library/abi/AbiModality;", "getModality", "()Lorg/jetbrains/kotlin/library/abi/AbiModality;", "isConstructor", "()Z", "isSuspend", "hasExtensionReceiverParameter", "getHasExtensionReceiverParameter", "getContextReceiverParametersCount", "()I", "returnType", "", "getReturnType", "()Ljava/lang/Void;", "typeParameters", "Lorg/jetbrains/kotlin/library/abi/AbiTypeParameter;", "getTypeParameters", "hasAnnotation", "annotationClassName", "Companion", "kotlin-util-klib-abi"})
public final class AbiConstructorImpl
implements AbiFunction {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AbiQualifiedName qualifiedName;
    @NotNull
    private final AbiSignatures signatures;
    @NotNull
    private final Set<AbiQualifiedName> annotations;
    @NotNull
    private final List<AbiValueParameter> valueParameters;
    private final int flags;
    private static final Flags.BooleanFlagField IS_INLINE;
    @NotNull
    private static final FlagFieldEx<Integer> CONTEXT_RECEIVERS_COUNT;

    public AbiConstructorImpl(@NotNull AbiQualifiedName qualifiedName, @NotNull AbiSignatures signatures2, @NotNull Set<AbiQualifiedName> annotations2, boolean isInline, int contextReceiverParametersCount, @NotNull List<? extends AbiValueParameter> valueParameters) {
        Intrinsics.checkNotNullParameter(qualifiedName, "qualifiedName");
        Intrinsics.checkNotNullParameter(signatures2, "signatures");
        Intrinsics.checkNotNullParameter(annotations2, "annotations");
        Intrinsics.checkNotNullParameter(valueParameters, "valueParameters");
        this.qualifiedName = qualifiedName;
        this.signatures = signatures2;
        this.annotations = annotations2;
        this.valueParameters = valueParameters;
        this.flags = IS_INLINE.toFlags(isInline) | CONTEXT_RECEIVERS_COUNT.toFlags(contextReceiverParametersCount);
    }

    @Override
    @NotNull
    public AbiQualifiedName getQualifiedName() {
        return this.qualifiedName;
    }

    @Override
    @NotNull
    public AbiSignatures getSignatures() {
        return this.signatures;
    }

    @Override
    @NotNull
    public List<AbiValueParameter> getValueParameters() {
        return this.valueParameters;
    }

    @Override
    @NotNull
    public AbiModality getModality() {
        return AbiModality.FINAL;
    }

    @Override
    public boolean isConstructor() {
        return true;
    }

    @Override
    public boolean isInline() {
        Boolean bl = IS_INLINE.get(this.flags);
        Intrinsics.checkNotNullExpressionValue(bl, "get(...)");
        return bl;
    }

    @Override
    public boolean isSuspend() {
        return false;
    }

    @Override
    public boolean getHasExtensionReceiverParameter() {
        return false;
    }

    @Override
    public int getContextReceiverParametersCount() {
        return ((Number)CONTEXT_RECEIVERS_COUNT.get(this.flags)).intValue();
    }

    @Nullable
    public Void getReturnType() {
        return null;
    }

    @Override
    @NotNull
    public List<AbiTypeParameter> getTypeParameters() {
        return CollectionsKt.emptyList();
    }

    @Override
    public boolean hasAnnotation(@NotNull AbiQualifiedName annotationClassName) {
        Intrinsics.checkNotNullParameter(annotationClassName, "annotationClassName");
        return this.annotations.contains(annotationClassName);
    }

    static {
        Flags.BooleanFlagField booleanFlagField = IS_INLINE = Flags.FlagField.booleanFirst();
        Intrinsics.checkNotNullExpressionValue(booleanFlagField, "IS_INLINE");
        CONTEXT_RECEIVERS_COUNT = FlagFieldEx.Companion.intAfter(booleanFlagField, 8);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0018\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/library/abi/impl/AbiConstructorImpl$Companion;", "", "<init>", "()V", "IS_INLINE", "Lorg/jetbrains/kotlin/metadata/deserialization/Flags$BooleanFlagField;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/kotlin/metadata/deserialization/Flags$BooleanFlagField;", "CONTEXT_RECEIVERS_COUNT", "Lorg/jetbrains/kotlin/library/abi/impl/FlagFieldEx;", "", "kotlin-util-klib-abi"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

