/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.model.schema.syntaxCheckers;

import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.model.schema.SyntaxChecker;
import org.apache.directory.api.util.Strings;

public final class PrintableStringSyntaxChecker
extends SyntaxChecker {
    public static final PrintableStringSyntaxChecker INSTANCE = new PrintableStringSyntaxChecker("1.3.6.1.4.1.1466.115.121.1.44");

    private PrintableStringSyntaxChecker(String oid) {
        super(oid);
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public boolean isValidSyntax(Object value) {
        if (value == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(I18n.err(I18n.ERR_13210_SYNTAX_INVALID, "null"));
            }
            return false;
        }
        String strValue = value instanceof String ? (String)value : (value instanceof byte[] ? Strings.utf8ToString((byte[])value) : value.toString());
        if (strValue.length() == 0) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(I18n.err(I18n.ERR_13210_SYNTAX_INVALID, value));
            }
            return false;
        }
        if (strValue.length() == 0) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(I18n.err(I18n.ERR_13210_SYNTAX_INVALID, value));
            }
            return false;
        }
        boolean result = Strings.isPrintableString(strValue);
        if (LOG.isDebugEnabled()) {
            if (result) {
                LOG.debug(I18n.msg(I18n.MSG_13701_SYNTAX_VALID, value));
            } else {
                LOG.debug(I18n.err(I18n.ERR_13210_SYNTAX_INVALID, value));
            }
        }
        return result;
    }

    public static final class Builder
    extends SyntaxChecker.SCBuilder<PrintableStringSyntaxChecker> {
        private Builder() {
            super("1.3.6.1.4.1.1466.115.121.1.44");
        }

        @Override
        public PrintableStringSyntaxChecker build() {
            return new PrintableStringSyntaxChecker(this.oid);
        }
    }
}

