/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.assembler.metadata;

import com.strobel.assembler.metadata.BuiltinTypes;
import com.strobel.assembler.metadata.ICapturedType;
import com.strobel.assembler.metadata.MetadataHelper;
import com.strobel.assembler.metadata.TypeMetadataVisitor;
import com.strobel.assembler.metadata.TypeReference;
import com.strobel.assembler.metadata.WildcardType;
import com.strobel.core.VerifyArgument;

public final class CapturedType
extends TypeReference
implements ICapturedType {
    private final TypeReference _superBound;
    private final TypeReference _extendsBound;
    private final WildcardType _wildcard;

    CapturedType(TypeReference superBound, TypeReference extendsBound, WildcardType wildcard) {
        this._superBound = superBound != null ? superBound : BuiltinTypes.Bottom;
        this._extendsBound = extendsBound != null ? extendsBound : BuiltinTypes.Object;
        this._wildcard = VerifyArgument.notNull(wildcard, "wildcard");
    }

    @Override
    public final WildcardType getWildcard() {
        return this._wildcard;
    }

    @Override
    public final TypeReference getExtendsBound() {
        return this._extendsBound;
    }

    @Override
    public final TypeReference getSuperBound() {
        return this._superBound;
    }

    @Override
    public final boolean hasExtendsBound() {
        return this._extendsBound != null && !MetadataHelper.isSameType(this._extendsBound, BuiltinTypes.Object);
    }

    @Override
    public final boolean hasSuperBound() {
        return this._superBound != BuiltinTypes.Bottom;
    }

    @Override
    public final boolean isBoundedType() {
        return true;
    }

    @Override
    public String getSimpleName() {
        return "capture of " + this._wildcard.getSimpleName();
    }

    @Override
    public final <R, P> R accept(TypeMetadataVisitor<P, R> visitor, P parameter) {
        return visitor.visitCapturedType(this, parameter);
    }

    @Override
    protected final StringBuilder appendName(StringBuilder sb, boolean fullName, boolean dottedName) {
        return this._wildcard.appendName(sb.append("capture of "), fullName, dottedName);
    }
}

