/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.decompiler;

import com.strobel.annotations.NotNull;
import com.strobel.assembler.Collection;
import com.strobel.assembler.metadata.CompilerTarget;
import com.strobel.assembler.metadata.IMemberDefinition;
import com.strobel.assembler.metadata.LanguageFeature;
import com.strobel.assembler.metadata.MethodDefinition;
import com.strobel.assembler.metadata.TypeDefinition;
import com.strobel.componentmodel.UserDataStoreBase;
import com.strobel.core.BooleanBox;
import com.strobel.decompiler.DecompilerSettings;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public final class DecompilerContext
extends UserDataStoreBase {
    private final List<String> _reservedVariableNames = new Collection<String>();
    private final Set<IMemberDefinition> _forcedVisibleMembers = new LinkedHashSet<IMemberDefinition>();
    private DecompilerSettings _settings = new DecompilerSettings();
    private BooleanBox _isCanceled;
    private TypeDefinition _currentType;
    private MethodDefinition _currentMethod;

    public DecompilerContext() {
    }

    public DecompilerContext(DecompilerSettings settings) {
        this._settings = settings;
    }

    public DecompilerSettings getSettings() {
        return this._settings;
    }

    public void setSettings(DecompilerSettings settings) {
        this._settings = settings;
    }

    public BooleanBox getCanceled() {
        return this._isCanceled;
    }

    public void setCanceled(BooleanBox canceled) {
        this._isCanceled = canceled;
    }

    public TypeDefinition getCurrentType() {
        return this._currentType;
    }

    public void setCurrentType(TypeDefinition currentType) {
        this._currentType = currentType;
        this.isSupported(LanguageFeature.TEXT_BLOCKS);
    }

    public MethodDefinition getCurrentMethod() {
        return this._currentMethod;
    }

    public void setCurrentMethod(MethodDefinition currentMethod) {
        this._currentMethod = currentMethod;
    }

    public List<String> getReservedVariableNames() {
        return this._reservedVariableNames;
    }

    public Set<IMemberDefinition> getForcedVisibleMembers() {
        return this._forcedVisibleMembers;
    }

    public boolean isSupported(@NotNull LanguageFeature feature) {
        return this.isSupported(this._currentType, feature);
    }

    public boolean isSupported(TypeDefinition versionSource, @NotNull LanguageFeature feature) {
        boolean allowPreview = this._settings.arePreviewFeaturesEnabled();
        CompilerTarget target = this._settings.getForcedCompilerTarget();
        if (target == null && versionSource != null) {
            target = versionSource.getCompilerTarget();
        }
        if (target == null) {
            target = CompilerTarget.DEFAULT;
        }
        return feature.isAvailable(target, allowPreview);
    }

    public CompilerTarget target() {
        return this.target(this._currentType);
    }

    public CompilerTarget target(TypeDefinition versionSource) {
        CompilerTarget target = this._settings.getForcedCompilerTarget();
        if (target == null && versionSource != null) {
            target = versionSource.getCompilerTarget();
        }
        if (target == null) {
            target = CompilerTarget.DEFAULT;
        }
        return target;
    }
}

