/***************************************************************************
    qgsgeometrywidgetwrapper.h
     -----------------------
    Date                 : February 2023
    Copyright            : (C) 2023 Nyall Dawson
    Email                : nyall dot dawson at gmail dot com
 ***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef QGSGEOMETRYWIDGETWRAPPER_H
#define QGSGEOMETRYWIDGETWRAPPER_H

#include "qgseditorwidgetwrapper.h"
#include "qgis_gui.h"

class QLabel;
class QToolButton;
class QgsGeometryWidget;

SIP_NO_FILE

/**
 * \ingroup gui
 * \class QgsGeometryWidgetWrapper
 * \brief Widget wrapper for geometry fields.
 * \note not available in Python bindings
 * \since QGIS 3.30
 */
class GUI_EXPORT QgsGeometryWidgetWrapper : public QgsEditorWidgetWrapper
{
    Q_OBJECT
  public:

    /**
     * Constructor for QgsGeometryWidgetWrapper.
     *
     * The \a layer and \a fieldIdx arguments specify the vector layer field associated with the wrapper.
     *
     * The \a editor argument indicates the editor widget to use with the wrapper. This can be NULLPTR if a
     * new widget should be autogenerated.
     *
     * A \a parent widget for this widget wrapper and the created widget can also be specified.
     * \a messageBar is unused and will be removed
     */
    explicit QgsGeometryWidgetWrapper( QgsVectorLayer *layer, int fieldIdx, QWidget *editor = nullptr, QWidget *parent = nullptr, QgsMessageBar *messageBar = nullptr );

    // QgsEditorWidgetWrapper interface
  public:
    QVariant value() const override;
    void setEnabled( bool enabled ) override;

  protected:
    QWidget *createWidget( QWidget *parent ) override;
    void initWidget( QWidget *editor ) override;
    bool valid() const override;

  private:
    void updateValues( const QVariant &value, const QVariantList & = QVariantList() ) override;

    QgsGeometryWidget *mWidget = nullptr;
};

#endif // QGSGEOMETRYWIDGETWRAPPER_H
