// Automatically generated file. DO NOT EDIT.
// Generated by gen-device-svd.go from nrf5340_network.svd, see https://github.com/NordicSemiconductor/nrfx/tree/master/mdk

//go:build nrf && nrf5340_network

// nRF53 reference description for system-on-chip with dual ARM 32-bit Cortex-M33 microcontrollers
//
//	Copyright (c) 2010 - 2020, Nordic Semiconductor ASA All rights reserved. Redistribution and use in source and binary forms, with or without modification, are permitted provided that the following conditions are met: 1. Redistributions of source code must retain the above copyright notice, this list of conditions and the following disclaimer. 2. Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following disclaimer in the documentation and/or other materials provided with the distribution. 3. Neither the name of Nordic Semiconductor ASA nor the names of its contributors may be used to endorse or promote products derived from this software without specific prior written permission. THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY, AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL NORDIC SEMICONDUCTOR ASA OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
package nrf

import (
	"runtime/volatile"
	"unsafe"
)

// Some information about this device.
const (
	Device       = "nrf5340_network"
	CPU          = "CM33"
	FPUPresent   = false
	NVICPrioBits = 3
)

// Interrupt numbers.
const (
	// Clock management // Power control
	IRQ_CLOCK_POWER = 5

	// Clock management
	IRQ_CLOCK_NS = 5

	// Power control
	IRQ_POWER_NS = 5

	// 2.4 GHz radio
	IRQ_RADIO = 8

	// 2.4 GHz radio
	IRQ_RADIO_NS = 8

	// Random Number Generator
	IRQ_RNG = 9

	// Random Number Generator
	IRQ_RNG_NS = 9

	// GPIO Tasks and Events
	IRQ_GPIOTE = 10

	// GPIO Tasks and Events
	IRQ_GPIOTE_NS = 10

	// Watchdog Timer
	IRQ_WDT = 11

	// Watchdog Timer
	IRQ_WDT_NS = 11

	// Timer/Counter 0
	IRQ_TIMER0 = 12

	// Timer/Counter 0
	IRQ_TIMER0_NS = 12

	// AES ECB Mode Encryption
	IRQ_ECB = 13

	// AES ECB Mode Encryption
	IRQ_ECB_NS = 13

	// Accelerated Address Resolver // AES CCM mode encryption
	IRQ_AAR_CCM = 14

	// Accelerated Address Resolver
	IRQ_AAR_NS = 14

	// AES CCM mode encryption
	IRQ_CCM_NS = 14

	// Temperature Sensor
	IRQ_TEMP = 16

	// Temperature Sensor
	IRQ_TEMP_NS = 16

	// Real-time counter 0
	IRQ_RTC0 = 17

	// Real-time counter 0
	IRQ_RTC0_NS = 17

	// Interprocessor communication
	IRQ_IPC = 18

	// Interprocessor communication
	IRQ_IPC_NS = 18

	// Serial Peripheral Interface Master with EasyDMA // SPI Slave // I2C compatible Two-Wire Master Interface with EasyDMA // I2C compatible Two-Wire Slave Interface with EasyDMA // UART with EasyDMA
	IRQ_SPIM0_SPIS0_TWIM0_TWIS0_UARTE0 = 19

	// Serial Peripheral Interface Master with EasyDMA
	IRQ_SPIM0_NS = 19

	// SPI Slave
	IRQ_SPIS0_NS = 19

	// I2C compatible Two-Wire Master Interface with EasyDMA
	IRQ_TWIM0_NS = 19

	// I2C compatible Two-Wire Slave Interface with EasyDMA
	IRQ_TWIS0_NS = 19

	// UART with EasyDMA
	IRQ_UARTE0_NS = 19

	// Event generator unit
	IRQ_EGU0 = 20

	// Event generator unit
	IRQ_EGU0_NS = 20

	// Real-time counter 1
	IRQ_RTC1 = 22

	// Real-time counter 1
	IRQ_RTC1_NS = 22

	// Timer/Counter 1
	IRQ_TIMER1 = 24

	// Timer/Counter 1
	IRQ_TIMER1_NS = 24

	// Timer/Counter 2
	IRQ_TIMER2 = 25

	// Timer/Counter 2
	IRQ_TIMER2_NS = 25

	// Software interrupt 0
	IRQ_SWI0 = 26

	// Software interrupt 0
	IRQ_SWI0_NS = 26

	// Software interrupt 1
	IRQ_SWI1 = 27

	// Software interrupt 1
	IRQ_SWI1_NS = 27

	// Software interrupt 2
	IRQ_SWI2 = 28

	// Software interrupt 2
	IRQ_SWI2_NS = 28

	// Software interrupt 3
	IRQ_SWI3 = 29

	// Software interrupt 3
	IRQ_SWI3_NS = 29

	// Highest interrupt number on this device.
	IRQ_max = 29
)

// Pseudo function call that is replaced by the compiler with the actual
// functions registered through interrupt.New.
//
//go:linkname callHandlers runtime/interrupt.callHandlers
func callHandlers(num int)

//export CLOCK_POWER_IRQHandler
func interruptCLOCK_POWER() {
	callHandlers(IRQ_CLOCK_POWER)
}

//export RADIO_IRQHandler
func interruptRADIO() {
	callHandlers(IRQ_RADIO)
}

//export RNG_IRQHandler
func interruptRNG() {
	callHandlers(IRQ_RNG)
}

//export GPIOTE_IRQHandler
func interruptGPIOTE() {
	callHandlers(IRQ_GPIOTE)
}

//export WDT_IRQHandler
func interruptWDT() {
	callHandlers(IRQ_WDT)
}

//export TIMER0_IRQHandler
func interruptTIMER0() {
	callHandlers(IRQ_TIMER0)
}

//export ECB_IRQHandler
func interruptECB() {
	callHandlers(IRQ_ECB)
}

//export AAR_CCM_IRQHandler
func interruptAAR_CCM() {
	callHandlers(IRQ_AAR_CCM)
}

//export TEMP_IRQHandler
func interruptTEMP() {
	callHandlers(IRQ_TEMP)
}

//export RTC0_IRQHandler
func interruptRTC0() {
	callHandlers(IRQ_RTC0)
}

//export IPC_IRQHandler
func interruptIPC() {
	callHandlers(IRQ_IPC)
}

//export SPIM0_SPIS0_TWIM0_TWIS0_UARTE0_IRQHandler
func interruptSPIM0_SPIS0_TWIM0_TWIS0_UARTE0() {
	callHandlers(IRQ_SPIM0_SPIS0_TWIM0_TWIS0_UARTE0)
}

//export EGU0_IRQHandler
func interruptEGU0() {
	callHandlers(IRQ_EGU0)
}

//export RTC1_IRQHandler
func interruptRTC1() {
	callHandlers(IRQ_RTC1)
}

//export TIMER1_IRQHandler
func interruptTIMER1() {
	callHandlers(IRQ_TIMER1)
}

//export TIMER2_IRQHandler
func interruptTIMER2() {
	callHandlers(IRQ_TIMER2)
}

//export SWI0_IRQHandler
func interruptSWI0() {
	callHandlers(IRQ_SWI0)
}

//export SWI1_IRQHandler
func interruptSWI1() {
	callHandlers(IRQ_SWI1)
}

//export SWI2_IRQHandler
func interruptSWI2() {
	callHandlers(IRQ_SWI2)
}

//export SWI3_IRQHandler
func interruptSWI3() {
	callHandlers(IRQ_SWI3)
}

// Peripherals.
var (
	// Factory Information Configuration Registers
	FICR_NS = (*FICR_Type)(unsafe.Pointer(uintptr(0x1ff0000)))

	// User Information Configuration Registers
	UICR_NS = (*UICR_Type)(unsafe.Pointer(uintptr(0x1ff8000)))

	// Cross-Trigger Interface control. NOTE: this is not a separate peripheral, but describes CM33 functionality.
	CTI_NS = (*CTI_Type)(unsafe.Pointer(uintptr(0xe0042000)))

	// Domain configuration management
	DCNF_NS = (*DCNF_Type)(unsafe.Pointer(uintptr(0x41000000)))

	// Voltage request control
	VREQCTRL_NS = (*VREQCTRL_Type)(unsafe.Pointer(uintptr(0x41004000)))

	// Clock management
	CLOCK_NS = (*CLOCK_Type)(unsafe.Pointer(uintptr(0x41005000)))

	// Power control
	POWER_NS = (*POWER_Type)(unsafe.Pointer(uintptr(0x41005000)))

	// Reset control
	RESET_NS = (*RESET_Type)(unsafe.Pointer(uintptr(0x41005000)))

	// Control access port
	CTRLAP_NS = (*CTRLAPPERI_Type)(unsafe.Pointer(uintptr(0x41006000)))

	// 2.4 GHz radio
	RADIO_NS = (*RADIO_Type)(unsafe.Pointer(uintptr(0x41008000)))

	// Random Number Generator
	RNG_NS = (*RNG_Type)(unsafe.Pointer(uintptr(0x41009000)))

	// GPIO Tasks and Events
	GPIOTE_NS = (*GPIOTE_Type)(unsafe.Pointer(uintptr(0x4100a000)))

	// Watchdog Timer
	WDT_NS = (*WDT_Type)(unsafe.Pointer(uintptr(0x4100b000)))

	// Timer/Counter 0
	TIMER0_NS = (*TIMER_Type)(unsafe.Pointer(uintptr(0x4100c000)))

	// AES ECB Mode Encryption
	ECB_NS = (*ECB_Type)(unsafe.Pointer(uintptr(0x4100d000)))

	// Accelerated Address Resolver
	AAR_NS = (*AAR_Type)(unsafe.Pointer(uintptr(0x4100e000)))

	// AES CCM mode encryption
	CCM_NS = (*CCM_Type)(unsafe.Pointer(uintptr(0x4100e000)))

	// Distributed programmable peripheral interconnect controller
	DPPIC_NS = (*DPPIC_Type)(unsafe.Pointer(uintptr(0x4100f000)))

	// Temperature Sensor
	TEMP_NS = (*TEMP_Type)(unsafe.Pointer(uintptr(0x41010000)))

	// Real-time counter 0
	RTC0_NS = (*RTC_Type)(unsafe.Pointer(uintptr(0x41011000)))

	// Interprocessor communication
	IPC_NS = (*IPC_Type)(unsafe.Pointer(uintptr(0x41012000)))

	// Serial Peripheral Interface Master with EasyDMA
	SPIM0_NS = (*SPIM_Type)(unsafe.Pointer(uintptr(0x41013000)))

	// SPI Slave
	SPIS0_NS = (*SPIS_Type)(unsafe.Pointer(uintptr(0x41013000)))

	// I2C compatible Two-Wire Master Interface with EasyDMA
	TWIM0_NS = (*TWIM_Type)(unsafe.Pointer(uintptr(0x41013000)))

	// I2C compatible Two-Wire Slave Interface with EasyDMA
	TWIS0_NS = (*TWIS_Type)(unsafe.Pointer(uintptr(0x41013000)))

	// UART with EasyDMA
	UARTE0_NS = (*UARTE_Type)(unsafe.Pointer(uintptr(0x41013000)))

	// Event generator unit
	EGU0_NS = (*EGU_Type)(unsafe.Pointer(uintptr(0x41014000)))

	// Software interrupt 0
	SWI0_NS = (*SWI_Type)(unsafe.Pointer(uintptr(0x4101a000)))

	// MUTEX 0
	APPMUTEX_NS = (*MUTEX_Type)(unsafe.Pointer(uintptr(0x40030000)))

	// Access control lists
	ACL_NS = (*ACL_Type)(unsafe.Pointer(uintptr(0x41080000)))

	// Non-volatile memory controller
	NVMC_NS = (*NVMC_Type)(unsafe.Pointer(uintptr(0x41080000)))

	// Volatile Memory controller
	VMC_NS = (*VMC_Type)(unsafe.Pointer(uintptr(0x41081000)))

	// GPIO Port 0
	P0_NS = (*GPIO_Type)(unsafe.Pointer(uintptr(0x418c0500)))

	// Real-time counter 1
	RTC1_NS = (*RTC_Type)(unsafe.Pointer(uintptr(0x41016000)))

	// Timer/Counter 1
	TIMER1_NS = (*TIMER_Type)(unsafe.Pointer(uintptr(0x41018000)))

	// Timer/Counter 2
	TIMER2_NS = (*TIMER_Type)(unsafe.Pointer(uintptr(0x41019000)))

	// Software interrupt 1
	SWI1_NS = (*SWI_Type)(unsafe.Pointer(uintptr(0x4101b000)))

	// Software interrupt 2
	SWI2_NS = (*SWI_Type)(unsafe.Pointer(uintptr(0x4101c000)))

	// Software interrupt 3
	SWI3_NS = (*SWI_Type)(unsafe.Pointer(uintptr(0x4101d000)))

	// MUTEX 1
	APPMUTEX_S = (*MUTEX_Type)(unsafe.Pointer(uintptr(0x50030000)))

	// GPIO Port 1
	P1_NS = (*GPIO_Type)(unsafe.Pointer(uintptr(0x418c0800)))
)

// Factory Information Configuration Registers
type FICR_Type struct {
	_              [512]byte
	INFO           FICR_INFO_Type // 0x200
	_              [84]byte
	ER             [4]volatile.Register32 // 0x280
	IR             [4]volatile.Register32 // 0x290
	DEVICEADDRTYPE volatile.Register32    // 0x2A0
	DEVICEADDR     [2]volatile.Register32 // 0x2A4
	_              [84]byte
	TRIMCNF        [32]FICR_TRIMCNF_Type // 0x300
}

// FICR.ER: Description collection: Encryption Root, word n
func (o *FICR_Type) SetER(idx int, value uint32) {
	volatile.StoreUint32(&o.ER[idx].Reg, value)
}
func (o *FICR_Type) GetER(idx int) uint32 {
	return volatile.LoadUint32(&o.ER[idx].Reg)
}

// FICR.IR: Description collection: Identity Root, word n
func (o *FICR_Type) SetIR(idx int, value uint32) {
	volatile.StoreUint32(&o.IR[idx].Reg, value)
}
func (o *FICR_Type) GetIR(idx int) uint32 {
	return volatile.LoadUint32(&o.IR[idx].Reg)
}

// FICR.DEVICEADDRTYPE: Device address type
func (o *FICR_Type) SetDEVICEADDRTYPE(value uint32) {
	volatile.StoreUint32(&o.DEVICEADDRTYPE.Reg, volatile.LoadUint32(&o.DEVICEADDRTYPE.Reg)&^(0x1)|value)
}
func (o *FICR_Type) GetDEVICEADDRTYPE() uint32 {
	return volatile.LoadUint32(&o.DEVICEADDRTYPE.Reg) & 0x1
}

// FICR.DEVICEADDR: Description collection: Device address n
func (o *FICR_Type) SetDEVICEADDR(idx int, value uint32) {
	volatile.StoreUint32(&o.DEVICEADDR[idx].Reg, value)
}
func (o *FICR_Type) GetDEVICEADDR(idx int) uint32 {
	return volatile.LoadUint32(&o.DEVICEADDR[idx].Reg)
}

// Device info
type FICR_INFO_Type struct {
	CONFIGID     volatile.Register32    // 0x200
	DEVICEID     [2]volatile.Register32 // 0x204
	PART         volatile.Register32    // 0x20C
	VARIANT      volatile.Register32    // 0x210
	PACKAGE      volatile.Register32    // 0x214
	RAM          volatile.Register32    // 0x218
	FLASH        volatile.Register32    // 0x21C
	CODEPAGESIZE volatile.Register32    // 0x220
	CODESIZE     volatile.Register32    // 0x224
	DEVICETYPE   volatile.Register32    // 0x228
}

// FICR_INFO.CONFIGID: Configuration identifier
func (o *FICR_INFO_Type) SetCONFIGID_HWID(value uint32) {
	volatile.StoreUint32(&o.CONFIGID.Reg, volatile.LoadUint32(&o.CONFIGID.Reg)&^(0xffff)|value)
}
func (o *FICR_INFO_Type) GetCONFIGID_HWID() uint32 {
	return volatile.LoadUint32(&o.CONFIGID.Reg) & 0xffff
}

// FICR_INFO.PART: Part code
func (o *FICR_INFO_Type) SetPART(value uint32) {
	volatile.StoreUint32(&o.PART.Reg, value)
}
func (o *FICR_INFO_Type) GetPART() uint32 {
	return volatile.LoadUint32(&o.PART.Reg)
}

// FICR_INFO.VARIANT: Part Variant, Hardware version and Production configuration
func (o *FICR_INFO_Type) SetVARIANT(value uint32) {
	volatile.StoreUint32(&o.VARIANT.Reg, value)
}
func (o *FICR_INFO_Type) GetVARIANT() uint32 {
	return volatile.LoadUint32(&o.VARIANT.Reg)
}

// FICR_INFO.PACKAGE: Package option
func (o *FICR_INFO_Type) SetPACKAGE(value uint32) {
	volatile.StoreUint32(&o.PACKAGE.Reg, value)
}
func (o *FICR_INFO_Type) GetPACKAGE() uint32 {
	return volatile.LoadUint32(&o.PACKAGE.Reg)
}

// FICR_INFO.RAM: RAM variant
func (o *FICR_INFO_Type) SetRAM(value uint32) {
	volatile.StoreUint32(&o.RAM.Reg, value)
}
func (o *FICR_INFO_Type) GetRAM() uint32 {
	return volatile.LoadUint32(&o.RAM.Reg)
}

// FICR_INFO.FLASH: Flash variant
func (o *FICR_INFO_Type) SetFLASH(value uint32) {
	volatile.StoreUint32(&o.FLASH.Reg, value)
}
func (o *FICR_INFO_Type) GetFLASH() uint32 {
	return volatile.LoadUint32(&o.FLASH.Reg)
}

// FICR_INFO.CODEPAGESIZE: Code memory page size in bytes
func (o *FICR_INFO_Type) SetCODEPAGESIZE(value uint32) {
	volatile.StoreUint32(&o.CODEPAGESIZE.Reg, value)
}
func (o *FICR_INFO_Type) GetCODEPAGESIZE() uint32 {
	return volatile.LoadUint32(&o.CODEPAGESIZE.Reg)
}

// FICR_INFO.CODESIZE: Code memory size
func (o *FICR_INFO_Type) SetCODESIZE(value uint32) {
	volatile.StoreUint32(&o.CODESIZE.Reg, value)
}
func (o *FICR_INFO_Type) GetCODESIZE() uint32 {
	return volatile.LoadUint32(&o.CODESIZE.Reg)
}

// FICR_INFO.DEVICETYPE: Device type
func (o *FICR_INFO_Type) SetDEVICETYPE(value uint32) {
	volatile.StoreUint32(&o.DEVICETYPE.Reg, value)
}
func (o *FICR_INFO_Type) GetDEVICETYPE() uint32 {
	return volatile.LoadUint32(&o.DEVICETYPE.Reg)
}

// Unspecified
type FICR_TRIMCNF_Type struct {
	ADDR volatile.Register32 // 0x300
	DATA volatile.Register32 // 0x304
}

// FICR_TRIMCNF.ADDR: Description cluster: Address
func (o *FICR_TRIMCNF_Type) SetADDR(value uint32) {
	volatile.StoreUint32(&o.ADDR.Reg, value)
}
func (o *FICR_TRIMCNF_Type) GetADDR() uint32 {
	return volatile.LoadUint32(&o.ADDR.Reg)
}

// FICR_TRIMCNF.DATA: Description cluster: Data
func (o *FICR_TRIMCNF_Type) SetDATA(value uint32) {
	volatile.StoreUint32(&o.DATA.Reg, value)
}
func (o *FICR_TRIMCNF_Type) GetDATA() uint32 {
	return volatile.LoadUint32(&o.DATA.Reg)
}

// User Information Configuration Registers
type UICR_Type struct {
	APPROTECT    volatile.Register32 // 0x0
	ERASEPROTECT volatile.Register32 // 0x4
	_            [504]byte
	NRFFW        [32]volatile.Register32 // 0x200
	_            [128]byte
	CUSTOMER     [32]volatile.Register32 // 0x300
}

// UICR.APPROTECT: Access port protection
func (o *UICR_Type) SetAPPROTECT(value uint32) {
	volatile.StoreUint32(&o.APPROTECT.Reg, value)
}
func (o *UICR_Type) GetAPPROTECT() uint32 {
	return volatile.LoadUint32(&o.APPROTECT.Reg)
}

// UICR.ERASEPROTECT: Erase protection
func (o *UICR_Type) SetERASEPROTECT(value uint32) {
	volatile.StoreUint32(&o.ERASEPROTECT.Reg, value)
}
func (o *UICR_Type) GetERASEPROTECT() uint32 {
	return volatile.LoadUint32(&o.ERASEPROTECT.Reg)
}

// UICR.NRFFW: Description collection: Reserved for Nordic firmware design
func (o *UICR_Type) SetNRFFW(idx int, value uint32) {
	volatile.StoreUint32(&o.NRFFW[idx].Reg, value)
}
func (o *UICR_Type) GetNRFFW(idx int) uint32 {
	return volatile.LoadUint32(&o.NRFFW[idx].Reg)
}

// UICR.CUSTOMER: Description collection: Reserved for customer
func (o *UICR_Type) SetCUSTOMER(idx int, value uint32) {
	volatile.StoreUint32(&o.CUSTOMER[idx].Reg, value)
}
func (o *UICR_Type) GetCUSTOMER(idx int) uint32 {
	return volatile.LoadUint32(&o.CUSTOMER[idx].Reg)
}

// Cross-Trigger Interface control. NOTE: this is not a separate peripheral, but describes CM33 functionality.
type CTI_Type struct {
	CTICONTROL       volatile.Register32 // 0x0
	_                [12]byte
	CTIINTACK        volatile.Register32    // 0x10
	CTIAPPSET        volatile.Register32    // 0x14
	CTIAPPCLEAR      volatile.Register32    // 0x18
	CTIAPPPULSE      volatile.Register32    // 0x1C
	CTIINEN          [8]volatile.Register32 // 0x20
	_                [96]byte
	CTIOUTEN         [8]volatile.Register32 // 0xA0
	_                [112]byte
	CTITRIGINSTATUS  volatile.Register32 // 0x130
	CTITRIGOUTSTATUS volatile.Register32 // 0x134
	CTICHINSTATUS    volatile.Register32 // 0x138
	_                [4]byte
	CTIGATE          volatile.Register32 // 0x140
	_                [3704]byte
	DEVARCH          volatile.Register32 // 0xFBC
	_                [8]byte
	DEVID            volatile.Register32 // 0xFC8
	DEVTYPE          volatile.Register32 // 0xFCC
	PIDR4            volatile.Register32 // 0xFD0
	PIDR5            volatile.Register32 // 0xFD4
	PIDR6            volatile.Register32 // 0xFD8
	PIDR7            volatile.Register32 // 0xFDC
	PIDR0            volatile.Register32 // 0xFE0
	PIDR1            volatile.Register32 // 0xFE4
	PIDR2            volatile.Register32 // 0xFE8
	PIDR3            volatile.Register32 // 0xFEC
	CIDR0            volatile.Register32 // 0xFF0
	CIDR1            volatile.Register32 // 0xFF4
	CIDR2            volatile.Register32 // 0xFF8
	CIDR3            volatile.Register32 // 0xFFC
}

// CTI.CTICONTROL: CTI Control register
func (o *CTI_Type) SetCTICONTROL_GLBEN(value uint32) {
	volatile.StoreUint32(&o.CTICONTROL.Reg, volatile.LoadUint32(&o.CTICONTROL.Reg)&^(0x1)|value)
}
func (o *CTI_Type) GetCTICONTROL_GLBEN() uint32 {
	return volatile.LoadUint32(&o.CTICONTROL.Reg) & 0x1
}

// CTI.CTIINTACK: CTI Interrupt Acknowledge register
func (o *CTI_Type) SetCTIINTACK_DEBUGREQ(value uint32) {
	volatile.StoreUint32(&o.CTIINTACK.Reg, volatile.LoadUint32(&o.CTIINTACK.Reg)&^(0x1)|value)
}
func (o *CTI_Type) GetCTIINTACK_DEBUGREQ() uint32 {
	return volatile.LoadUint32(&o.CTIINTACK.Reg) & 0x1
}
func (o *CTI_Type) SetCTIINTACK_CPURESTART(value uint32) {
	volatile.StoreUint32(&o.CTIINTACK.Reg, volatile.LoadUint32(&o.CTIINTACK.Reg)&^(0x2)|value<<1)
}
func (o *CTI_Type) GetCTIINTACK_CPURESTART() uint32 {
	return (volatile.LoadUint32(&o.CTIINTACK.Reg) & 0x2) >> 1
}
func (o *CTI_Type) SetCTIINTACK_UNUSED0(value uint32) {
	volatile.StoreUint32(&o.CTIINTACK.Reg, volatile.LoadUint32(&o.CTIINTACK.Reg)&^(0x4)|value<<2)
}
func (o *CTI_Type) GetCTIINTACK_UNUSED0() uint32 {
	return (volatile.LoadUint32(&o.CTIINTACK.Reg) & 0x4) >> 2
}
func (o *CTI_Type) SetCTIINTACK_UNUSED1(value uint32) {
	volatile.StoreUint32(&o.CTIINTACK.Reg, volatile.LoadUint32(&o.CTIINTACK.Reg)&^(0x8)|value<<3)
}
func (o *CTI_Type) GetCTIINTACK_UNUSED1() uint32 {
	return (volatile.LoadUint32(&o.CTIINTACK.Reg) & 0x8) >> 3
}
func (o *CTI_Type) SetCTIINTACK_UNUSED2(value uint32) {
	volatile.StoreUint32(&o.CTIINTACK.Reg, volatile.LoadUint32(&o.CTIINTACK.Reg)&^(0x10)|value<<4)
}
func (o *CTI_Type) GetCTIINTACK_UNUSED2() uint32 {
	return (volatile.LoadUint32(&o.CTIINTACK.Reg) & 0x10) >> 4
}
func (o *CTI_Type) SetCTIINTACK_UNUSED3(value uint32) {
	volatile.StoreUint32(&o.CTIINTACK.Reg, volatile.LoadUint32(&o.CTIINTACK.Reg)&^(0x20)|value<<5)
}
func (o *CTI_Type) GetCTIINTACK_UNUSED3() uint32 {
	return (volatile.LoadUint32(&o.CTIINTACK.Reg) & 0x20) >> 5
}
func (o *CTI_Type) SetCTIINTACK_UNUSED4(value uint32) {
	volatile.StoreUint32(&o.CTIINTACK.Reg, volatile.LoadUint32(&o.CTIINTACK.Reg)&^(0x40)|value<<6)
}
func (o *CTI_Type) GetCTIINTACK_UNUSED4() uint32 {
	return (volatile.LoadUint32(&o.CTIINTACK.Reg) & 0x40) >> 6
}
func (o *CTI_Type) SetCTIINTACK_UNUSED5(value uint32) {
	volatile.StoreUint32(&o.CTIINTACK.Reg, volatile.LoadUint32(&o.CTIINTACK.Reg)&^(0x80)|value<<7)
}
func (o *CTI_Type) GetCTIINTACK_UNUSED5() uint32 {
	return (volatile.LoadUint32(&o.CTIINTACK.Reg) & 0x80) >> 7
}

// CTI.CTIAPPSET: CTI Application Trigger Set register
func (o *CTI_Type) SetCTIAPPSET_APPSET_0(value uint32) {
	volatile.StoreUint32(&o.CTIAPPSET.Reg, volatile.LoadUint32(&o.CTIAPPSET.Reg)&^(0x1)|value)
}
func (o *CTI_Type) GetCTIAPPSET_APPSET_0() uint32 {
	return volatile.LoadUint32(&o.CTIAPPSET.Reg) & 0x1
}
func (o *CTI_Type) SetCTIAPPSET_APPSET_1(value uint32) {
	volatile.StoreUint32(&o.CTIAPPSET.Reg, volatile.LoadUint32(&o.CTIAPPSET.Reg)&^(0x2)|value<<1)
}
func (o *CTI_Type) GetCTIAPPSET_APPSET_1() uint32 {
	return (volatile.LoadUint32(&o.CTIAPPSET.Reg) & 0x2) >> 1
}
func (o *CTI_Type) SetCTIAPPSET_APPSET_2(value uint32) {
	volatile.StoreUint32(&o.CTIAPPSET.Reg, volatile.LoadUint32(&o.CTIAPPSET.Reg)&^(0x4)|value<<2)
}
func (o *CTI_Type) GetCTIAPPSET_APPSET_2() uint32 {
	return (volatile.LoadUint32(&o.CTIAPPSET.Reg) & 0x4) >> 2
}
func (o *CTI_Type) SetCTIAPPSET_APPSET_3(value uint32) {
	volatile.StoreUint32(&o.CTIAPPSET.Reg, volatile.LoadUint32(&o.CTIAPPSET.Reg)&^(0x8)|value<<3)
}
func (o *CTI_Type) GetCTIAPPSET_APPSET_3() uint32 {
	return (volatile.LoadUint32(&o.CTIAPPSET.Reg) & 0x8) >> 3
}

// CTI.CTIAPPCLEAR: CTI Application Trigger Clear register
func (o *CTI_Type) SetCTIAPPCLEAR_APPCLEAR_0(value uint32) {
	volatile.StoreUint32(&o.CTIAPPCLEAR.Reg, volatile.LoadUint32(&o.CTIAPPCLEAR.Reg)&^(0x1)|value)
}
func (o *CTI_Type) GetCTIAPPCLEAR_APPCLEAR_0() uint32 {
	return volatile.LoadUint32(&o.CTIAPPCLEAR.Reg) & 0x1
}
func (o *CTI_Type) SetCTIAPPCLEAR_APPCLEAR_1(value uint32) {
	volatile.StoreUint32(&o.CTIAPPCLEAR.Reg, volatile.LoadUint32(&o.CTIAPPCLEAR.Reg)&^(0x2)|value<<1)
}
func (o *CTI_Type) GetCTIAPPCLEAR_APPCLEAR_1() uint32 {
	return (volatile.LoadUint32(&o.CTIAPPCLEAR.Reg) & 0x2) >> 1
}
func (o *CTI_Type) SetCTIAPPCLEAR_APPCLEAR_2(value uint32) {
	volatile.StoreUint32(&o.CTIAPPCLEAR.Reg, volatile.LoadUint32(&o.CTIAPPCLEAR.Reg)&^(0x4)|value<<2)
}
func (o *CTI_Type) GetCTIAPPCLEAR_APPCLEAR_2() uint32 {
	return (volatile.LoadUint32(&o.CTIAPPCLEAR.Reg) & 0x4) >> 2
}
func (o *CTI_Type) SetCTIAPPCLEAR_APPCLEAR_3(value uint32) {
	volatile.StoreUint32(&o.CTIAPPCLEAR.Reg, volatile.LoadUint32(&o.CTIAPPCLEAR.Reg)&^(0x8)|value<<3)
}
func (o *CTI_Type) GetCTIAPPCLEAR_APPCLEAR_3() uint32 {
	return (volatile.LoadUint32(&o.CTIAPPCLEAR.Reg) & 0x8) >> 3
}

// CTI.CTIAPPPULSE: CTI Application Pulse register
func (o *CTI_Type) SetCTIAPPPULSE_APPULSE_0(value uint32) {
	volatile.StoreUint32(&o.CTIAPPPULSE.Reg, volatile.LoadUint32(&o.CTIAPPPULSE.Reg)&^(0x1)|value)
}
func (o *CTI_Type) GetCTIAPPPULSE_APPULSE_0() uint32 {
	return volatile.LoadUint32(&o.CTIAPPPULSE.Reg) & 0x1
}
func (o *CTI_Type) SetCTIAPPPULSE_APPULSE_1(value uint32) {
	volatile.StoreUint32(&o.CTIAPPPULSE.Reg, volatile.LoadUint32(&o.CTIAPPPULSE.Reg)&^(0x2)|value<<1)
}
func (o *CTI_Type) GetCTIAPPPULSE_APPULSE_1() uint32 {
	return (volatile.LoadUint32(&o.CTIAPPPULSE.Reg) & 0x2) >> 1
}
func (o *CTI_Type) SetCTIAPPPULSE_APPULSE_2(value uint32) {
	volatile.StoreUint32(&o.CTIAPPPULSE.Reg, volatile.LoadUint32(&o.CTIAPPPULSE.Reg)&^(0x4)|value<<2)
}
func (o *CTI_Type) GetCTIAPPPULSE_APPULSE_2() uint32 {
	return (volatile.LoadUint32(&o.CTIAPPPULSE.Reg) & 0x4) >> 2
}
func (o *CTI_Type) SetCTIAPPPULSE_APPULSE_3(value uint32) {
	volatile.StoreUint32(&o.CTIAPPPULSE.Reg, volatile.LoadUint32(&o.CTIAPPPULSE.Reg)&^(0x8)|value<<3)
}
func (o *CTI_Type) GetCTIAPPPULSE_APPULSE_3() uint32 {
	return (volatile.LoadUint32(&o.CTIAPPPULSE.Reg) & 0x8) >> 3
}

// CTI.CTIINEN: Description collection: CTI Trigger input
func (o *CTI_Type) SetCTIINEN_TRIGINEN_0(idx int, value uint32) {
	volatile.StoreUint32(&o.CTIINEN[idx].Reg, volatile.LoadUint32(&o.CTIINEN[idx].Reg)&^(0x1)|value)
}
func (o *CTI_Type) GetCTIINEN_TRIGINEN_0(idx int) uint32 {
	return volatile.LoadUint32(&o.CTIINEN[idx].Reg) & 0x1
}
func (o *CTI_Type) SetCTIINEN_TRIGINEN_1(idx int, value uint32) {
	volatile.StoreUint32(&o.CTIINEN[idx].Reg, volatile.LoadUint32(&o.CTIINEN[idx].Reg)&^(0x2)|value<<1)
}
func (o *CTI_Type) GetCTIINEN_TRIGINEN_1(idx int) uint32 {
	return (volatile.LoadUint32(&o.CTIINEN[idx].Reg) & 0x2) >> 1
}
func (o *CTI_Type) SetCTIINEN_TRIGINEN_2(idx int, value uint32) {
	volatile.StoreUint32(&o.CTIINEN[idx].Reg, volatile.LoadUint32(&o.CTIINEN[idx].Reg)&^(0x4)|value<<2)
}
func (o *CTI_Type) GetCTIINEN_TRIGINEN_2(idx int) uint32 {
	return (volatile.LoadUint32(&o.CTIINEN[idx].Reg) & 0x4) >> 2
}
func (o *CTI_Type) SetCTIINEN_TRIGINEN_3(idx int, value uint32) {
	volatile.StoreUint32(&o.CTIINEN[idx].Reg, volatile.LoadUint32(&o.CTIINEN[idx].Reg)&^(0x8)|value<<3)
}
func (o *CTI_Type) GetCTIINEN_TRIGINEN_3(idx int) uint32 {
	return (volatile.LoadUint32(&o.CTIINEN[idx].Reg) & 0x8) >> 3
}

// CTI.CTIOUTEN: Description collection: CTI Trigger output
func (o *CTI_Type) SetCTIOUTEN_TRIGOUTEN_0(idx int, value uint32) {
	volatile.StoreUint32(&o.CTIOUTEN[idx].Reg, volatile.LoadUint32(&o.CTIOUTEN[idx].Reg)&^(0x1)|value)
}
func (o *CTI_Type) GetCTIOUTEN_TRIGOUTEN_0(idx int) uint32 {
	return volatile.LoadUint32(&o.CTIOUTEN[idx].Reg) & 0x1
}
func (o *CTI_Type) SetCTIOUTEN_TRIGOUTEN_1(idx int, value uint32) {
	volatile.StoreUint32(&o.CTIOUTEN[idx].Reg, volatile.LoadUint32(&o.CTIOUTEN[idx].Reg)&^(0x2)|value<<1)
}
func (o *CTI_Type) GetCTIOUTEN_TRIGOUTEN_1(idx int) uint32 {
	return (volatile.LoadUint32(&o.CTIOUTEN[idx].Reg) & 0x2) >> 1
}
func (o *CTI_Type) SetCTIOUTEN_TRIGOUTEN_2(idx int, value uint32) {
	volatile.StoreUint32(&o.CTIOUTEN[idx].Reg, volatile.LoadUint32(&o.CTIOUTEN[idx].Reg)&^(0x4)|value<<2)
}
func (o *CTI_Type) GetCTIOUTEN_TRIGOUTEN_2(idx int) uint32 {
	return (volatile.LoadUint32(&o.CTIOUTEN[idx].Reg) & 0x4) >> 2
}
func (o *CTI_Type) SetCTIOUTEN_TRIGOUTEN_3(idx int, value uint32) {
	volatile.StoreUint32(&o.CTIOUTEN[idx].Reg, volatile.LoadUint32(&o.CTIOUTEN[idx].Reg)&^(0x8)|value<<3)
}
func (o *CTI_Type) GetCTIOUTEN_TRIGOUTEN_3(idx int) uint32 {
	return (volatile.LoadUint32(&o.CTIOUTEN[idx].Reg) & 0x8) >> 3
}

// CTI.CTITRIGINSTATUS: CTI Trigger In Status register
func (o *CTI_Type) SetCTITRIGINSTATUS_CPUHALTED(value uint32) {
	volatile.StoreUint32(&o.CTITRIGINSTATUS.Reg, volatile.LoadUint32(&o.CTITRIGINSTATUS.Reg)&^(0x1)|value)
}
func (o *CTI_Type) GetCTITRIGINSTATUS_CPUHALTED() uint32 {
	return volatile.LoadUint32(&o.CTITRIGINSTATUS.Reg) & 0x1
}
func (o *CTI_Type) SetCTITRIGINSTATUS_DWTCOMPOUT0(value uint32) {
	volatile.StoreUint32(&o.CTITRIGINSTATUS.Reg, volatile.LoadUint32(&o.CTITRIGINSTATUS.Reg)&^(0x2)|value<<1)
}
func (o *CTI_Type) GetCTITRIGINSTATUS_DWTCOMPOUT0() uint32 {
	return (volatile.LoadUint32(&o.CTITRIGINSTATUS.Reg) & 0x2) >> 1
}
func (o *CTI_Type) SetCTITRIGINSTATUS_DWTCOMPOUT1(value uint32) {
	volatile.StoreUint32(&o.CTITRIGINSTATUS.Reg, volatile.LoadUint32(&o.CTITRIGINSTATUS.Reg)&^(0x4)|value<<2)
}
func (o *CTI_Type) GetCTITRIGINSTATUS_DWTCOMPOUT1() uint32 {
	return (volatile.LoadUint32(&o.CTITRIGINSTATUS.Reg) & 0x4) >> 2
}
func (o *CTI_Type) SetCTITRIGINSTATUS_DWTCOMPOUT2(value uint32) {
	volatile.StoreUint32(&o.CTITRIGINSTATUS.Reg, volatile.LoadUint32(&o.CTITRIGINSTATUS.Reg)&^(0x8)|value<<3)
}
func (o *CTI_Type) GetCTITRIGINSTATUS_DWTCOMPOUT2() uint32 {
	return (volatile.LoadUint32(&o.CTITRIGINSTATUS.Reg) & 0x8) >> 3
}
func (o *CTI_Type) SetCTITRIGINSTATUS_UNUSED0(value uint32) {
	volatile.StoreUint32(&o.CTITRIGINSTATUS.Reg, volatile.LoadUint32(&o.CTITRIGINSTATUS.Reg)&^(0x10)|value<<4)
}
func (o *CTI_Type) GetCTITRIGINSTATUS_UNUSED0() uint32 {
	return (volatile.LoadUint32(&o.CTITRIGINSTATUS.Reg) & 0x10) >> 4
}
func (o *CTI_Type) SetCTITRIGINSTATUS_UNUSED1(value uint32) {
	volatile.StoreUint32(&o.CTITRIGINSTATUS.Reg, volatile.LoadUint32(&o.CTITRIGINSTATUS.Reg)&^(0x20)|value<<5)
}
func (o *CTI_Type) GetCTITRIGINSTATUS_UNUSED1() uint32 {
	return (volatile.LoadUint32(&o.CTITRIGINSTATUS.Reg) & 0x20) >> 5
}
func (o *CTI_Type) SetCTITRIGINSTATUS_UNUSED2(value uint32) {
	volatile.StoreUint32(&o.CTITRIGINSTATUS.Reg, volatile.LoadUint32(&o.CTITRIGINSTATUS.Reg)&^(0x40)|value<<6)
}
func (o *CTI_Type) GetCTITRIGINSTATUS_UNUSED2() uint32 {
	return (volatile.LoadUint32(&o.CTITRIGINSTATUS.Reg) & 0x40) >> 6
}
func (o *CTI_Type) SetCTITRIGINSTATUS_UNUSED3(value uint32) {
	volatile.StoreUint32(&o.CTITRIGINSTATUS.Reg, volatile.LoadUint32(&o.CTITRIGINSTATUS.Reg)&^(0x80)|value<<7)
}
func (o *CTI_Type) GetCTITRIGINSTATUS_UNUSED3() uint32 {
	return (volatile.LoadUint32(&o.CTITRIGINSTATUS.Reg) & 0x80) >> 7
}

// CTI.CTITRIGOUTSTATUS: CTI Trigger Out Status register
func (o *CTI_Type) SetCTITRIGOUTSTATUS_DEBUGREQ(value uint32) {
	volatile.StoreUint32(&o.CTITRIGOUTSTATUS.Reg, volatile.LoadUint32(&o.CTITRIGOUTSTATUS.Reg)&^(0x1)|value)
}
func (o *CTI_Type) GetCTITRIGOUTSTATUS_DEBUGREQ() uint32 {
	return volatile.LoadUint32(&o.CTITRIGOUTSTATUS.Reg) & 0x1
}
func (o *CTI_Type) SetCTITRIGOUTSTATUS_CPURESTART(value uint32) {
	volatile.StoreUint32(&o.CTITRIGOUTSTATUS.Reg, volatile.LoadUint32(&o.CTITRIGOUTSTATUS.Reg)&^(0x2)|value<<1)
}
func (o *CTI_Type) GetCTITRIGOUTSTATUS_CPURESTART() uint32 {
	return (volatile.LoadUint32(&o.CTITRIGOUTSTATUS.Reg) & 0x2) >> 1
}
func (o *CTI_Type) SetCTITRIGOUTSTATUS_UNUSED0(value uint32) {
	volatile.StoreUint32(&o.CTITRIGOUTSTATUS.Reg, volatile.LoadUint32(&o.CTITRIGOUTSTATUS.Reg)&^(0x4)|value<<2)
}
func (o *CTI_Type) GetCTITRIGOUTSTATUS_UNUSED0() uint32 {
	return (volatile.LoadUint32(&o.CTITRIGOUTSTATUS.Reg) & 0x4) >> 2
}
func (o *CTI_Type) SetCTITRIGOUTSTATUS_UNUSED1(value uint32) {
	volatile.StoreUint32(&o.CTITRIGOUTSTATUS.Reg, volatile.LoadUint32(&o.CTITRIGOUTSTATUS.Reg)&^(0x8)|value<<3)
}
func (o *CTI_Type) GetCTITRIGOUTSTATUS_UNUSED1() uint32 {
	return (volatile.LoadUint32(&o.CTITRIGOUTSTATUS.Reg) & 0x8) >> 3
}
func (o *CTI_Type) SetCTITRIGOUTSTATUS_UNUSED2(value uint32) {
	volatile.StoreUint32(&o.CTITRIGOUTSTATUS.Reg, volatile.LoadUint32(&o.CTITRIGOUTSTATUS.Reg)&^(0x10)|value<<4)
}
func (o *CTI_Type) GetCTITRIGOUTSTATUS_UNUSED2() uint32 {
	return (volatile.LoadUint32(&o.CTITRIGOUTSTATUS.Reg) & 0x10) >> 4
}
func (o *CTI_Type) SetCTITRIGOUTSTATUS_UNUSED3(value uint32) {
	volatile.StoreUint32(&o.CTITRIGOUTSTATUS.Reg, volatile.LoadUint32(&o.CTITRIGOUTSTATUS.Reg)&^(0x20)|value<<5)
}
func (o *CTI_Type) GetCTITRIGOUTSTATUS_UNUSED3() uint32 {
	return (volatile.LoadUint32(&o.CTITRIGOUTSTATUS.Reg) & 0x20) >> 5
}
func (o *CTI_Type) SetCTITRIGOUTSTATUS_UNUSED4(value uint32) {
	volatile.StoreUint32(&o.CTITRIGOUTSTATUS.Reg, volatile.LoadUint32(&o.CTITRIGOUTSTATUS.Reg)&^(0x40)|value<<6)
}
func (o *CTI_Type) GetCTITRIGOUTSTATUS_UNUSED4() uint32 {
	return (volatile.LoadUint32(&o.CTITRIGOUTSTATUS.Reg) & 0x40) >> 6
}
func (o *CTI_Type) SetCTITRIGOUTSTATUS_UNUSED5(value uint32) {
	volatile.StoreUint32(&o.CTITRIGOUTSTATUS.Reg, volatile.LoadUint32(&o.CTITRIGOUTSTATUS.Reg)&^(0x80)|value<<7)
}
func (o *CTI_Type) GetCTITRIGOUTSTATUS_UNUSED5() uint32 {
	return (volatile.LoadUint32(&o.CTITRIGOUTSTATUS.Reg) & 0x80) >> 7
}

// CTI.CTICHINSTATUS: CTI Channel In Status register
func (o *CTI_Type) SetCTICHINSTATUS_CTICHINSTATUS_0(value uint32) {
	volatile.StoreUint32(&o.CTICHINSTATUS.Reg, volatile.LoadUint32(&o.CTICHINSTATUS.Reg)&^(0x1)|value)
}
func (o *CTI_Type) GetCTICHINSTATUS_CTICHINSTATUS_0() uint32 {
	return volatile.LoadUint32(&o.CTICHINSTATUS.Reg) & 0x1
}
func (o *CTI_Type) SetCTICHINSTATUS_CTICHINSTATUS_1(value uint32) {
	volatile.StoreUint32(&o.CTICHINSTATUS.Reg, volatile.LoadUint32(&o.CTICHINSTATUS.Reg)&^(0x2)|value<<1)
}
func (o *CTI_Type) GetCTICHINSTATUS_CTICHINSTATUS_1() uint32 {
	return (volatile.LoadUint32(&o.CTICHINSTATUS.Reg) & 0x2) >> 1
}
func (o *CTI_Type) SetCTICHINSTATUS_CTICHINSTATUS_2(value uint32) {
	volatile.StoreUint32(&o.CTICHINSTATUS.Reg, volatile.LoadUint32(&o.CTICHINSTATUS.Reg)&^(0x4)|value<<2)
}
func (o *CTI_Type) GetCTICHINSTATUS_CTICHINSTATUS_2() uint32 {
	return (volatile.LoadUint32(&o.CTICHINSTATUS.Reg) & 0x4) >> 2
}
func (o *CTI_Type) SetCTICHINSTATUS_CTICHINSTATUS_3(value uint32) {
	volatile.StoreUint32(&o.CTICHINSTATUS.Reg, volatile.LoadUint32(&o.CTICHINSTATUS.Reg)&^(0x8)|value<<3)
}
func (o *CTI_Type) GetCTICHINSTATUS_CTICHINSTATUS_3() uint32 {
	return (volatile.LoadUint32(&o.CTICHINSTATUS.Reg) & 0x8) >> 3
}

// CTI.CTIGATE: Enable CTI Channel Gate register
func (o *CTI_Type) SetCTIGATE_CTIGATEEN_0(value uint32) {
	volatile.StoreUint32(&o.CTIGATE.Reg, volatile.LoadUint32(&o.CTIGATE.Reg)&^(0x1)|value)
}
func (o *CTI_Type) GetCTIGATE_CTIGATEEN_0() uint32 {
	return volatile.LoadUint32(&o.CTIGATE.Reg) & 0x1
}
func (o *CTI_Type) SetCTIGATE_CTIGATEEN_1(value uint32) {
	volatile.StoreUint32(&o.CTIGATE.Reg, volatile.LoadUint32(&o.CTIGATE.Reg)&^(0x2)|value<<1)
}
func (o *CTI_Type) GetCTIGATE_CTIGATEEN_1() uint32 {
	return (volatile.LoadUint32(&o.CTIGATE.Reg) & 0x2) >> 1
}
func (o *CTI_Type) SetCTIGATE_CTIGATEEN_2(value uint32) {
	volatile.StoreUint32(&o.CTIGATE.Reg, volatile.LoadUint32(&o.CTIGATE.Reg)&^(0x4)|value<<2)
}
func (o *CTI_Type) GetCTIGATE_CTIGATEEN_2() uint32 {
	return (volatile.LoadUint32(&o.CTIGATE.Reg) & 0x4) >> 2
}
func (o *CTI_Type) SetCTIGATE_CTIGATEEN_3(value uint32) {
	volatile.StoreUint32(&o.CTIGATE.Reg, volatile.LoadUint32(&o.CTIGATE.Reg)&^(0x8)|value<<3)
}
func (o *CTI_Type) GetCTIGATE_CTIGATEEN_3() uint32 {
	return (volatile.LoadUint32(&o.CTIGATE.Reg) & 0x8) >> 3
}

// CTI.DEVARCH: Device Architecture register
func (o *CTI_Type) SetDEVARCH_Architecture(value uint32) {
	volatile.StoreUint32(&o.DEVARCH.Reg, volatile.LoadUint32(&o.DEVARCH.Reg)&^(0x1)|value)
}
func (o *CTI_Type) GetDEVARCH_Architecture() uint32 {
	return volatile.LoadUint32(&o.DEVARCH.Reg) & 0x1
}

// CTI.DEVID: Device Configuration register
func (o *CTI_Type) SetDEVID_EXTMUXNUM(value uint32) {
	volatile.StoreUint32(&o.DEVID.Reg, volatile.LoadUint32(&o.DEVID.Reg)&^(0x1f)|value)
}
func (o *CTI_Type) GetDEVID_EXTMUXNUM() uint32 {
	return volatile.LoadUint32(&o.DEVID.Reg) & 0x1f
}
func (o *CTI_Type) SetDEVID_NUMTRIG(value uint32) {
	volatile.StoreUint32(&o.DEVID.Reg, volatile.LoadUint32(&o.DEVID.Reg)&^(0xff00)|value<<8)
}
func (o *CTI_Type) GetDEVID_NUMTRIG() uint32 {
	return (volatile.LoadUint32(&o.DEVID.Reg) & 0xff00) >> 8
}
func (o *CTI_Type) SetDEVID_NUMCH(value uint32) {
	volatile.StoreUint32(&o.DEVID.Reg, volatile.LoadUint32(&o.DEVID.Reg)&^(0xf0000)|value<<16)
}
func (o *CTI_Type) GetDEVID_NUMCH() uint32 {
	return (volatile.LoadUint32(&o.DEVID.Reg) & 0xf0000) >> 16
}

// CTI.DEVTYPE: Device Type Identifier register
func (o *CTI_Type) SetDEVTYPE_MAJOR(value uint32) {
	volatile.StoreUint32(&o.DEVTYPE.Reg, volatile.LoadUint32(&o.DEVTYPE.Reg)&^(0xf)|value)
}
func (o *CTI_Type) GetDEVTYPE_MAJOR() uint32 {
	return volatile.LoadUint32(&o.DEVTYPE.Reg) & 0xf
}
func (o *CTI_Type) SetDEVTYPE_SUB(value uint32) {
	volatile.StoreUint32(&o.DEVTYPE.Reg, volatile.LoadUint32(&o.DEVTYPE.Reg)&^(0xf0)|value<<4)
}
func (o *CTI_Type) GetDEVTYPE_SUB() uint32 {
	return (volatile.LoadUint32(&o.DEVTYPE.Reg) & 0xf0) >> 4
}

// CTI.PIDR4: Peripheral ID4 Register
func (o *CTI_Type) SetPIDR4_DES_2(value uint32) {
	volatile.StoreUint32(&o.PIDR4.Reg, volatile.LoadUint32(&o.PIDR4.Reg)&^(0xf)|value)
}
func (o *CTI_Type) GetPIDR4_DES_2() uint32 {
	return volatile.LoadUint32(&o.PIDR4.Reg) & 0xf
}
func (o *CTI_Type) SetPIDR4_SIZE(value uint32) {
	volatile.StoreUint32(&o.PIDR4.Reg, volatile.LoadUint32(&o.PIDR4.Reg)&^(0xf0)|value<<4)
}
func (o *CTI_Type) GetPIDR4_SIZE() uint32 {
	return (volatile.LoadUint32(&o.PIDR4.Reg) & 0xf0) >> 4
}

// CTI.PIDR0: Peripheral ID0 Register
func (o *CTI_Type) SetPIDR0_PART_0(value uint32) {
	volatile.StoreUint32(&o.PIDR0.Reg, volatile.LoadUint32(&o.PIDR0.Reg)&^(0xff)|value)
}
func (o *CTI_Type) GetPIDR0_PART_0() uint32 {
	return volatile.LoadUint32(&o.PIDR0.Reg) & 0xff
}

// CTI.PIDR1: Peripheral ID1 Register
func (o *CTI_Type) SetPIDR1_PART_1(value uint32) {
	volatile.StoreUint32(&o.PIDR1.Reg, volatile.LoadUint32(&o.PIDR1.Reg)&^(0xf)|value)
}
func (o *CTI_Type) GetPIDR1_PART_1() uint32 {
	return volatile.LoadUint32(&o.PIDR1.Reg) & 0xf
}
func (o *CTI_Type) SetPIDR1_DES_0(value uint32) {
	volatile.StoreUint32(&o.PIDR1.Reg, volatile.LoadUint32(&o.PIDR1.Reg)&^(0xf0)|value<<4)
}
func (o *CTI_Type) GetPIDR1_DES_0() uint32 {
	return (volatile.LoadUint32(&o.PIDR1.Reg) & 0xf0) >> 4
}

// CTI.PIDR2: Peripheral ID2 Register
func (o *CTI_Type) SetPIDR2_DES_1(value uint32) {
	volatile.StoreUint32(&o.PIDR2.Reg, volatile.LoadUint32(&o.PIDR2.Reg)&^(0x7)|value)
}
func (o *CTI_Type) GetPIDR2_DES_1() uint32 {
	return volatile.LoadUint32(&o.PIDR2.Reg) & 0x7
}
func (o *CTI_Type) SetPIDR2_JEDEC(value uint32) {
	volatile.StoreUint32(&o.PIDR2.Reg, volatile.LoadUint32(&o.PIDR2.Reg)&^(0x8)|value<<3)
}
func (o *CTI_Type) GetPIDR2_JEDEC() uint32 {
	return (volatile.LoadUint32(&o.PIDR2.Reg) & 0x8) >> 3
}
func (o *CTI_Type) SetPIDR2_REVISION(value uint32) {
	volatile.StoreUint32(&o.PIDR2.Reg, volatile.LoadUint32(&o.PIDR2.Reg)&^(0xf0)|value<<4)
}
func (o *CTI_Type) GetPIDR2_REVISION() uint32 {
	return (volatile.LoadUint32(&o.PIDR2.Reg) & 0xf0) >> 4
}

// CTI.PIDR3: Peripheral ID3 Register
func (o *CTI_Type) SetPIDR3_CMOD(value uint32) {
	volatile.StoreUint32(&o.PIDR3.Reg, volatile.LoadUint32(&o.PIDR3.Reg)&^(0xf)|value)
}
func (o *CTI_Type) GetPIDR3_CMOD() uint32 {
	return volatile.LoadUint32(&o.PIDR3.Reg) & 0xf
}
func (o *CTI_Type) SetPIDR3_REVAND(value uint32) {
	volatile.StoreUint32(&o.PIDR3.Reg, volatile.LoadUint32(&o.PIDR3.Reg)&^(0xf0)|value<<4)
}
func (o *CTI_Type) GetPIDR3_REVAND() uint32 {
	return (volatile.LoadUint32(&o.PIDR3.Reg) & 0xf0) >> 4
}

// CTI.CIDR0: Component ID0 Register
func (o *CTI_Type) SetCIDR0_PRMBL_0(value uint32) {
	volatile.StoreUint32(&o.CIDR0.Reg, volatile.LoadUint32(&o.CIDR0.Reg)&^(0xff)|value)
}
func (o *CTI_Type) GetCIDR0_PRMBL_0() uint32 {
	return volatile.LoadUint32(&o.CIDR0.Reg) & 0xff
}

// CTI.CIDR1: Component ID1 Register
func (o *CTI_Type) SetCIDR1_PRMBL_1(value uint32) {
	volatile.StoreUint32(&o.CIDR1.Reg, volatile.LoadUint32(&o.CIDR1.Reg)&^(0xf)|value)
}
func (o *CTI_Type) GetCIDR1_PRMBL_1() uint32 {
	return volatile.LoadUint32(&o.CIDR1.Reg) & 0xf
}
func (o *CTI_Type) SetCIDR1_CLASS(value uint32) {
	volatile.StoreUint32(&o.CIDR1.Reg, volatile.LoadUint32(&o.CIDR1.Reg)&^(0xf0)|value<<4)
}
func (o *CTI_Type) GetCIDR1_CLASS() uint32 {
	return (volatile.LoadUint32(&o.CIDR1.Reg) & 0xf0) >> 4
}

// CTI.CIDR2: Component ID2 Register
func (o *CTI_Type) SetCIDR2_PRMBL_2(value uint32) {
	volatile.StoreUint32(&o.CIDR2.Reg, volatile.LoadUint32(&o.CIDR2.Reg)&^(0xff)|value)
}
func (o *CTI_Type) GetCIDR2_PRMBL_2() uint32 {
	return volatile.LoadUint32(&o.CIDR2.Reg) & 0xff
}

// CTI.CIDR3: Component ID3 Register
func (o *CTI_Type) SetCIDR3_PRMBL_3(value uint32) {
	volatile.StoreUint32(&o.CIDR3.Reg, volatile.LoadUint32(&o.CIDR3.Reg)&^(0xff)|value)
}
func (o *CTI_Type) GetCIDR3_PRMBL_3() uint32 {
	return volatile.LoadUint32(&o.CIDR3.Reg) & 0xff
}

// Domain configuration management
type DCNF_Type struct {
	_     [1056]byte
	CPUID volatile.Register32 // 0x420
}

// DCNF.CPUID: CPU ID of this subsystem
func (o *DCNF_Type) SetCPUID(value uint32) {
	volatile.StoreUint32(&o.CPUID.Reg, volatile.LoadUint32(&o.CPUID.Reg)&^(0xff)|value)
}
func (o *DCNF_Type) GetCPUID() uint32 {
	return volatile.LoadUint32(&o.CPUID.Reg) & 0xff
}

// Voltage request control
type VREQCTRL_Type struct {
	_         [1280]byte
	VREGRADIO VREQCTRL_VREGRADIO_Type // 0x500
}

// Unspecified
type VREQCTRL_VREGRADIO_Type struct {
	VREQH      volatile.Register32 // 0x500
	_          [4]byte
	VREQHREADY volatile.Register32 // 0x508
}

// VREQCTRL_VREGRADIO.VREQH: Request high voltage on RADIO After requesting high voltage, the user must wait until VREQHREADY is set to Ready
func (o *VREQCTRL_VREGRADIO_Type) SetVREQH(value uint32) {
	volatile.StoreUint32(&o.VREQH.Reg, volatile.LoadUint32(&o.VREQH.Reg)&^(0x1)|value)
}
func (o *VREQCTRL_VREGRADIO_Type) GetVREQH() uint32 {
	return volatile.LoadUint32(&o.VREQH.Reg) & 0x1
}

// VREQCTRL_VREGRADIO.VREQHREADY: High voltage on RADIO is ready
func (o *VREQCTRL_VREGRADIO_Type) SetVREQHREADY_READY(value uint32) {
	volatile.StoreUint32(&o.VREQHREADY.Reg, volatile.LoadUint32(&o.VREQHREADY.Reg)&^(0x1)|value)
}
func (o *VREQCTRL_VREGRADIO_Type) GetVREQHREADY_READY() uint32 {
	return volatile.LoadUint32(&o.VREQHREADY.Reg) & 0x1
}

// Clock management
type CLOCK_Type struct {
	TASKS_HFCLKSTART     volatile.Register32 // 0x0
	TASKS_HFCLKSTOP      volatile.Register32 // 0x4
	TASKS_LFCLKSTART     volatile.Register32 // 0x8
	TASKS_LFCLKSTOP      volatile.Register32 // 0xC
	TASKS_CAL            volatile.Register32 // 0x10
	_                    [108]byte
	SUBSCRIBE_HFCLKSTART volatile.Register32 // 0x80
	SUBSCRIBE_HFCLKSTOP  volatile.Register32 // 0x84
	SUBSCRIBE_LFCLKSTART volatile.Register32 // 0x88
	SUBSCRIBE_LFCLKSTOP  volatile.Register32 // 0x8C
	SUBSCRIBE_CAL        volatile.Register32 // 0x90
	_                    [108]byte
	EVENTS_HFCLKSTARTED  volatile.Register32 // 0x100
	EVENTS_LFCLKSTARTED  volatile.Register32 // 0x104
	_                    [20]byte
	EVENTS_DONE          volatile.Register32 // 0x11C
	_                    [96]byte
	PUBLISH_HFCLKSTARTED volatile.Register32 // 0x180
	PUBLISH_LFCLKSTARTED volatile.Register32 // 0x184
	_                    [20]byte
	PUBLISH_DONE         volatile.Register32 // 0x19C
	_                    [352]byte
	INTEN                volatile.Register32 // 0x300
	INTENSET             volatile.Register32 // 0x304
	INTENCLR             volatile.Register32 // 0x308
	INTPEND              volatile.Register32 // 0x30C
	_                    [248]byte
	HFCLKRUN             volatile.Register32 // 0x408
	HFCLKSTAT            volatile.Register32 // 0x40C
	_                    [4]byte
	LFCLKRUN             volatile.Register32 // 0x414
	LFCLKSTAT            volatile.Register32 // 0x418
	LFCLKSRCCOPY         volatile.Register32 // 0x41C
	_                    [244]byte
	HFCLKSRC             volatile.Register32 // 0x514
	LFCLKSRC             volatile.Register32 // 0x518
	_                    [60]byte
	HFCLKCTRL            volatile.Register32 // 0x558
	_                    [20]byte
	HFCLKALWAYSRUN       volatile.Register32 // 0x570
	LFCLKALWAYSRUN       volatile.Register32 // 0x574
}

// CLOCK.TASKS_HFCLKSTART: Start HFCLK128M/HFCLK64M source as selected in HFCLKSRC
func (o *CLOCK_Type) SetTASKS_HFCLKSTART(value uint32) {
	volatile.StoreUint32(&o.TASKS_HFCLKSTART.Reg, volatile.LoadUint32(&o.TASKS_HFCLKSTART.Reg)&^(0x1)|value)
}
func (o *CLOCK_Type) GetTASKS_HFCLKSTART() uint32 {
	return volatile.LoadUint32(&o.TASKS_HFCLKSTART.Reg) & 0x1
}

// CLOCK.TASKS_HFCLKSTOP: Stop HFCLK128M/HFCLK64M source
func (o *CLOCK_Type) SetTASKS_HFCLKSTOP(value uint32) {
	volatile.StoreUint32(&o.TASKS_HFCLKSTOP.Reg, volatile.LoadUint32(&o.TASKS_HFCLKSTOP.Reg)&^(0x1)|value)
}
func (o *CLOCK_Type) GetTASKS_HFCLKSTOP() uint32 {
	return volatile.LoadUint32(&o.TASKS_HFCLKSTOP.Reg) & 0x1
}

// CLOCK.TASKS_LFCLKSTART: Start LFCLK source as selected in LFCLKSRC
func (o *CLOCK_Type) SetTASKS_LFCLKSTART(value uint32) {
	volatile.StoreUint32(&o.TASKS_LFCLKSTART.Reg, volatile.LoadUint32(&o.TASKS_LFCLKSTART.Reg)&^(0x1)|value)
}
func (o *CLOCK_Type) GetTASKS_LFCLKSTART() uint32 {
	return volatile.LoadUint32(&o.TASKS_LFCLKSTART.Reg) & 0x1
}

// CLOCK.TASKS_LFCLKSTOP: Stop LFCLK source
func (o *CLOCK_Type) SetTASKS_LFCLKSTOP(value uint32) {
	volatile.StoreUint32(&o.TASKS_LFCLKSTOP.Reg, volatile.LoadUint32(&o.TASKS_LFCLKSTOP.Reg)&^(0x1)|value)
}
func (o *CLOCK_Type) GetTASKS_LFCLKSTOP() uint32 {
	return volatile.LoadUint32(&o.TASKS_LFCLKSTOP.Reg) & 0x1
}

// CLOCK.TASKS_CAL: Start calibration of LFRC oscillator
func (o *CLOCK_Type) SetTASKS_CAL(value uint32) {
	volatile.StoreUint32(&o.TASKS_CAL.Reg, volatile.LoadUint32(&o.TASKS_CAL.Reg)&^(0x1)|value)
}
func (o *CLOCK_Type) GetTASKS_CAL() uint32 {
	return volatile.LoadUint32(&o.TASKS_CAL.Reg) & 0x1
}

// CLOCK.SUBSCRIBE_HFCLKSTART: Subscribe configuration for task HFCLKSTART
func (o *CLOCK_Type) SetSUBSCRIBE_HFCLKSTART_CHIDX(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_HFCLKSTART.Reg, volatile.LoadUint32(&o.SUBSCRIBE_HFCLKSTART.Reg)&^(0xff)|value)
}
func (o *CLOCK_Type) GetSUBSCRIBE_HFCLKSTART_CHIDX() uint32 {
	return volatile.LoadUint32(&o.SUBSCRIBE_HFCLKSTART.Reg) & 0xff
}
func (o *CLOCK_Type) SetSUBSCRIBE_HFCLKSTART_EN(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_HFCLKSTART.Reg, volatile.LoadUint32(&o.SUBSCRIBE_HFCLKSTART.Reg)&^(0x80000000)|value<<31)
}
func (o *CLOCK_Type) GetSUBSCRIBE_HFCLKSTART_EN() uint32 {
	return (volatile.LoadUint32(&o.SUBSCRIBE_HFCLKSTART.Reg) & 0x80000000) >> 31
}

// CLOCK.SUBSCRIBE_HFCLKSTOP: Subscribe configuration for task HFCLKSTOP
func (o *CLOCK_Type) SetSUBSCRIBE_HFCLKSTOP_CHIDX(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_HFCLKSTOP.Reg, volatile.LoadUint32(&o.SUBSCRIBE_HFCLKSTOP.Reg)&^(0xff)|value)
}
func (o *CLOCK_Type) GetSUBSCRIBE_HFCLKSTOP_CHIDX() uint32 {
	return volatile.LoadUint32(&o.SUBSCRIBE_HFCLKSTOP.Reg) & 0xff
}
func (o *CLOCK_Type) SetSUBSCRIBE_HFCLKSTOP_EN(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_HFCLKSTOP.Reg, volatile.LoadUint32(&o.SUBSCRIBE_HFCLKSTOP.Reg)&^(0x80000000)|value<<31)
}
func (o *CLOCK_Type) GetSUBSCRIBE_HFCLKSTOP_EN() uint32 {
	return (volatile.LoadUint32(&o.SUBSCRIBE_HFCLKSTOP.Reg) & 0x80000000) >> 31
}

// CLOCK.SUBSCRIBE_LFCLKSTART: Subscribe configuration for task LFCLKSTART
func (o *CLOCK_Type) SetSUBSCRIBE_LFCLKSTART_CHIDX(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_LFCLKSTART.Reg, volatile.LoadUint32(&o.SUBSCRIBE_LFCLKSTART.Reg)&^(0xff)|value)
}
func (o *CLOCK_Type) GetSUBSCRIBE_LFCLKSTART_CHIDX() uint32 {
	return volatile.LoadUint32(&o.SUBSCRIBE_LFCLKSTART.Reg) & 0xff
}
func (o *CLOCK_Type) SetSUBSCRIBE_LFCLKSTART_EN(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_LFCLKSTART.Reg, volatile.LoadUint32(&o.SUBSCRIBE_LFCLKSTART.Reg)&^(0x80000000)|value<<31)
}
func (o *CLOCK_Type) GetSUBSCRIBE_LFCLKSTART_EN() uint32 {
	return (volatile.LoadUint32(&o.SUBSCRIBE_LFCLKSTART.Reg) & 0x80000000) >> 31
}

// CLOCK.SUBSCRIBE_LFCLKSTOP: Subscribe configuration for task LFCLKSTOP
func (o *CLOCK_Type) SetSUBSCRIBE_LFCLKSTOP_CHIDX(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_LFCLKSTOP.Reg, volatile.LoadUint32(&o.SUBSCRIBE_LFCLKSTOP.Reg)&^(0xff)|value)
}
func (o *CLOCK_Type) GetSUBSCRIBE_LFCLKSTOP_CHIDX() uint32 {
	return volatile.LoadUint32(&o.SUBSCRIBE_LFCLKSTOP.Reg) & 0xff
}
func (o *CLOCK_Type) SetSUBSCRIBE_LFCLKSTOP_EN(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_LFCLKSTOP.Reg, volatile.LoadUint32(&o.SUBSCRIBE_LFCLKSTOP.Reg)&^(0x80000000)|value<<31)
}
func (o *CLOCK_Type) GetSUBSCRIBE_LFCLKSTOP_EN() uint32 {
	return (volatile.LoadUint32(&o.SUBSCRIBE_LFCLKSTOP.Reg) & 0x80000000) >> 31
}

// CLOCK.SUBSCRIBE_CAL: Subscribe configuration for task CAL
func (o *CLOCK_Type) SetSUBSCRIBE_CAL_CHIDX(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_CAL.Reg, volatile.LoadUint32(&o.SUBSCRIBE_CAL.Reg)&^(0xff)|value)
}
func (o *CLOCK_Type) GetSUBSCRIBE_CAL_CHIDX() uint32 {
	return volatile.LoadUint32(&o.SUBSCRIBE_CAL.Reg) & 0xff
}
func (o *CLOCK_Type) SetSUBSCRIBE_CAL_EN(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_CAL.Reg, volatile.LoadUint32(&o.SUBSCRIBE_CAL.Reg)&^(0x80000000)|value<<31)
}
func (o *CLOCK_Type) GetSUBSCRIBE_CAL_EN() uint32 {
	return (volatile.LoadUint32(&o.SUBSCRIBE_CAL.Reg) & 0x80000000) >> 31
}

// CLOCK.EVENTS_HFCLKSTARTED: HFCLK128M/HFCLK64M source started
func (o *CLOCK_Type) SetEVENTS_HFCLKSTARTED(value uint32) {
	volatile.StoreUint32(&o.EVENTS_HFCLKSTARTED.Reg, volatile.LoadUint32(&o.EVENTS_HFCLKSTARTED.Reg)&^(0x1)|value)
}
func (o *CLOCK_Type) GetEVENTS_HFCLKSTARTED() uint32 {
	return volatile.LoadUint32(&o.EVENTS_HFCLKSTARTED.Reg) & 0x1
}

// CLOCK.EVENTS_LFCLKSTARTED: LFCLK source started
func (o *CLOCK_Type) SetEVENTS_LFCLKSTARTED(value uint32) {
	volatile.StoreUint32(&o.EVENTS_LFCLKSTARTED.Reg, volatile.LoadUint32(&o.EVENTS_LFCLKSTARTED.Reg)&^(0x1)|value)
}
func (o *CLOCK_Type) GetEVENTS_LFCLKSTARTED() uint32 {
	return volatile.LoadUint32(&o.EVENTS_LFCLKSTARTED.Reg) & 0x1
}

// CLOCK.EVENTS_DONE: Calibration of LFRC oscillator complete event
func (o *CLOCK_Type) SetEVENTS_DONE(value uint32) {
	volatile.StoreUint32(&o.EVENTS_DONE.Reg, volatile.LoadUint32(&o.EVENTS_DONE.Reg)&^(0x1)|value)
}
func (o *CLOCK_Type) GetEVENTS_DONE() uint32 {
	return volatile.LoadUint32(&o.EVENTS_DONE.Reg) & 0x1
}

// CLOCK.PUBLISH_HFCLKSTARTED: Publish configuration for event HFCLKSTARTED
func (o *CLOCK_Type) SetPUBLISH_HFCLKSTARTED_CHIDX(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_HFCLKSTARTED.Reg, volatile.LoadUint32(&o.PUBLISH_HFCLKSTARTED.Reg)&^(0xff)|value)
}
func (o *CLOCK_Type) GetPUBLISH_HFCLKSTARTED_CHIDX() uint32 {
	return volatile.LoadUint32(&o.PUBLISH_HFCLKSTARTED.Reg) & 0xff
}
func (o *CLOCK_Type) SetPUBLISH_HFCLKSTARTED_EN(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_HFCLKSTARTED.Reg, volatile.LoadUint32(&o.PUBLISH_HFCLKSTARTED.Reg)&^(0x80000000)|value<<31)
}
func (o *CLOCK_Type) GetPUBLISH_HFCLKSTARTED_EN() uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_HFCLKSTARTED.Reg) & 0x80000000) >> 31
}

// CLOCK.PUBLISH_LFCLKSTARTED: Publish configuration for event LFCLKSTARTED
func (o *CLOCK_Type) SetPUBLISH_LFCLKSTARTED_CHIDX(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_LFCLKSTARTED.Reg, volatile.LoadUint32(&o.PUBLISH_LFCLKSTARTED.Reg)&^(0xff)|value)
}
func (o *CLOCK_Type) GetPUBLISH_LFCLKSTARTED_CHIDX() uint32 {
	return volatile.LoadUint32(&o.PUBLISH_LFCLKSTARTED.Reg) & 0xff
}
func (o *CLOCK_Type) SetPUBLISH_LFCLKSTARTED_EN(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_LFCLKSTARTED.Reg, volatile.LoadUint32(&o.PUBLISH_LFCLKSTARTED.Reg)&^(0x80000000)|value<<31)
}
func (o *CLOCK_Type) GetPUBLISH_LFCLKSTARTED_EN() uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_LFCLKSTARTED.Reg) & 0x80000000) >> 31
}

// CLOCK.PUBLISH_DONE: Publish configuration for event DONE
func (o *CLOCK_Type) SetPUBLISH_DONE_CHIDX(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_DONE.Reg, volatile.LoadUint32(&o.PUBLISH_DONE.Reg)&^(0xff)|value)
}
func (o *CLOCK_Type) GetPUBLISH_DONE_CHIDX() uint32 {
	return volatile.LoadUint32(&o.PUBLISH_DONE.Reg) & 0xff
}
func (o *CLOCK_Type) SetPUBLISH_DONE_EN(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_DONE.Reg, volatile.LoadUint32(&o.PUBLISH_DONE.Reg)&^(0x80000000)|value<<31)
}
func (o *CLOCK_Type) GetPUBLISH_DONE_EN() uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_DONE.Reg) & 0x80000000) >> 31
}

// CLOCK.INTEN: Enable or disable interrupt
func (o *CLOCK_Type) SetINTEN_HFCLKSTARTED(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x1)|value)
}
func (o *CLOCK_Type) GetINTEN_HFCLKSTARTED() uint32 {
	return volatile.LoadUint32(&o.INTEN.Reg) & 0x1
}
func (o *CLOCK_Type) SetINTEN_LFCLKSTARTED(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x2)|value<<1)
}
func (o *CLOCK_Type) GetINTEN_LFCLKSTARTED() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x2) >> 1
}
func (o *CLOCK_Type) SetINTEN_DONE(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x80)|value<<7)
}
func (o *CLOCK_Type) GetINTEN_DONE() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x80) >> 7
}

// CLOCK.INTENSET: Enable interrupt
func (o *CLOCK_Type) SetINTENSET_HFCLKSTARTED(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x1)|value)
}
func (o *CLOCK_Type) GetINTENSET_HFCLKSTARTED() uint32 {
	return volatile.LoadUint32(&o.INTENSET.Reg) & 0x1
}
func (o *CLOCK_Type) SetINTENSET_LFCLKSTARTED(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x2)|value<<1)
}
func (o *CLOCK_Type) GetINTENSET_LFCLKSTARTED() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x2) >> 1
}
func (o *CLOCK_Type) SetINTENSET_DONE(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x80)|value<<7)
}
func (o *CLOCK_Type) GetINTENSET_DONE() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x80) >> 7
}

// CLOCK.INTENCLR: Disable interrupt
func (o *CLOCK_Type) SetINTENCLR_HFCLKSTARTED(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x1)|value)
}
func (o *CLOCK_Type) GetINTENCLR_HFCLKSTARTED() uint32 {
	return volatile.LoadUint32(&o.INTENCLR.Reg) & 0x1
}
func (o *CLOCK_Type) SetINTENCLR_LFCLKSTARTED(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x2)|value<<1)
}
func (o *CLOCK_Type) GetINTENCLR_LFCLKSTARTED() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x2) >> 1
}
func (o *CLOCK_Type) SetINTENCLR_DONE(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x80)|value<<7)
}
func (o *CLOCK_Type) GetINTENCLR_DONE() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x80) >> 7
}

// CLOCK.INTPEND: Pending interrupts
func (o *CLOCK_Type) SetINTPEND_HFCLKSTARTED(value uint32) {
	volatile.StoreUint32(&o.INTPEND.Reg, volatile.LoadUint32(&o.INTPEND.Reg)&^(0x1)|value)
}
func (o *CLOCK_Type) GetINTPEND_HFCLKSTARTED() uint32 {
	return volatile.LoadUint32(&o.INTPEND.Reg) & 0x1
}
func (o *CLOCK_Type) SetINTPEND_LFCLKSTARTED(value uint32) {
	volatile.StoreUint32(&o.INTPEND.Reg, volatile.LoadUint32(&o.INTPEND.Reg)&^(0x2)|value<<1)
}
func (o *CLOCK_Type) GetINTPEND_LFCLKSTARTED() uint32 {
	return (volatile.LoadUint32(&o.INTPEND.Reg) & 0x2) >> 1
}
func (o *CLOCK_Type) SetINTPEND_DONE(value uint32) {
	volatile.StoreUint32(&o.INTPEND.Reg, volatile.LoadUint32(&o.INTPEND.Reg)&^(0x80)|value<<7)
}
func (o *CLOCK_Type) GetINTPEND_DONE() uint32 {
	return (volatile.LoadUint32(&o.INTPEND.Reg) & 0x80) >> 7
}

// CLOCK.HFCLKRUN: Status indicating that HFCLKSTART task has been triggered
func (o *CLOCK_Type) SetHFCLKRUN_STATUS(value uint32) {
	volatile.StoreUint32(&o.HFCLKRUN.Reg, volatile.LoadUint32(&o.HFCLKRUN.Reg)&^(0x1)|value)
}
func (o *CLOCK_Type) GetHFCLKRUN_STATUS() uint32 {
	return volatile.LoadUint32(&o.HFCLKRUN.Reg) & 0x1
}

// CLOCK.HFCLKSTAT: Status indicating which HFCLK128M/HFCLK64M source is running This register value in any CLOCK instance reflects status only due to configurations/actions in that CLOCK instance.
func (o *CLOCK_Type) SetHFCLKSTAT_SRC(value uint32) {
	volatile.StoreUint32(&o.HFCLKSTAT.Reg, volatile.LoadUint32(&o.HFCLKSTAT.Reg)&^(0x1)|value)
}
func (o *CLOCK_Type) GetHFCLKSTAT_SRC() uint32 {
	return volatile.LoadUint32(&o.HFCLKSTAT.Reg) & 0x1
}
func (o *CLOCK_Type) SetHFCLKSTAT_ALWAYSRUNNING(value uint32) {
	volatile.StoreUint32(&o.HFCLKSTAT.Reg, volatile.LoadUint32(&o.HFCLKSTAT.Reg)&^(0x10)|value<<4)
}
func (o *CLOCK_Type) GetHFCLKSTAT_ALWAYSRUNNING() uint32 {
	return (volatile.LoadUint32(&o.HFCLKSTAT.Reg) & 0x10) >> 4
}
func (o *CLOCK_Type) SetHFCLKSTAT_STATE(value uint32) {
	volatile.StoreUint32(&o.HFCLKSTAT.Reg, volatile.LoadUint32(&o.HFCLKSTAT.Reg)&^(0x10000)|value<<16)
}
func (o *CLOCK_Type) GetHFCLKSTAT_STATE() uint32 {
	return (volatile.LoadUint32(&o.HFCLKSTAT.Reg) & 0x10000) >> 16
}

// CLOCK.LFCLKRUN: Status indicating that LFCLKSTART task has been triggered
func (o *CLOCK_Type) SetLFCLKRUN_STATUS(value uint32) {
	volatile.StoreUint32(&o.LFCLKRUN.Reg, volatile.LoadUint32(&o.LFCLKRUN.Reg)&^(0x1)|value)
}
func (o *CLOCK_Type) GetLFCLKRUN_STATUS() uint32 {
	return volatile.LoadUint32(&o.LFCLKRUN.Reg) & 0x1
}

// CLOCK.LFCLKSTAT: Status indicating which LFCLK source is running This register value in any CLOCK instance reflects status only due to configurations/actions in that CLOCK instance.
func (o *CLOCK_Type) SetLFCLKSTAT_SRC(value uint32) {
	volatile.StoreUint32(&o.LFCLKSTAT.Reg, volatile.LoadUint32(&o.LFCLKSTAT.Reg)&^(0x3)|value)
}
func (o *CLOCK_Type) GetLFCLKSTAT_SRC() uint32 {
	return volatile.LoadUint32(&o.LFCLKSTAT.Reg) & 0x3
}
func (o *CLOCK_Type) SetLFCLKSTAT_ALWAYSRUNNING(value uint32) {
	volatile.StoreUint32(&o.LFCLKSTAT.Reg, volatile.LoadUint32(&o.LFCLKSTAT.Reg)&^(0x10)|value<<4)
}
func (o *CLOCK_Type) GetLFCLKSTAT_ALWAYSRUNNING() uint32 {
	return (volatile.LoadUint32(&o.LFCLKSTAT.Reg) & 0x10) >> 4
}
func (o *CLOCK_Type) SetLFCLKSTAT_STATE(value uint32) {
	volatile.StoreUint32(&o.LFCLKSTAT.Reg, volatile.LoadUint32(&o.LFCLKSTAT.Reg)&^(0x10000)|value<<16)
}
func (o *CLOCK_Type) GetLFCLKSTAT_STATE() uint32 {
	return (volatile.LoadUint32(&o.LFCLKSTAT.Reg) & 0x10000) >> 16
}

// CLOCK.LFCLKSRCCOPY: Copy of LFCLKSRC register, set when LFCLKSTART task was triggered
func (o *CLOCK_Type) SetLFCLKSRCCOPY_SRC(value uint32) {
	volatile.StoreUint32(&o.LFCLKSRCCOPY.Reg, volatile.LoadUint32(&o.LFCLKSRCCOPY.Reg)&^(0x3)|value)
}
func (o *CLOCK_Type) GetLFCLKSRCCOPY_SRC() uint32 {
	return volatile.LoadUint32(&o.LFCLKSRCCOPY.Reg) & 0x3
}

// CLOCK.HFCLKSRC: Clock source for HFCLK128M/HFCLK64M
func (o *CLOCK_Type) SetHFCLKSRC_SRC(value uint32) {
	volatile.StoreUint32(&o.HFCLKSRC.Reg, volatile.LoadUint32(&o.HFCLKSRC.Reg)&^(0x1)|value)
}
func (o *CLOCK_Type) GetHFCLKSRC_SRC() uint32 {
	return volatile.LoadUint32(&o.HFCLKSRC.Reg) & 0x1
}

// CLOCK.LFCLKSRC: Clock source for LFCLK
func (o *CLOCK_Type) SetLFCLKSRC_SRC(value uint32) {
	volatile.StoreUint32(&o.LFCLKSRC.Reg, volatile.LoadUint32(&o.LFCLKSRC.Reg)&^(0x3)|value)
}
func (o *CLOCK_Type) GetLFCLKSRC_SRC() uint32 {
	return volatile.LoadUint32(&o.LFCLKSRC.Reg) & 0x3
}

// CLOCK.HFCLKCTRL: HFCLK128M frequency configuration
func (o *CLOCK_Type) SetHFCLKCTRL_HCLK(value uint32) {
	volatile.StoreUint32(&o.HFCLKCTRL.Reg, volatile.LoadUint32(&o.HFCLKCTRL.Reg)&^(0x3)|value)
}
func (o *CLOCK_Type) GetHFCLKCTRL_HCLK() uint32 {
	return volatile.LoadUint32(&o.HFCLKCTRL.Reg) & 0x3
}

// CLOCK.HFCLKALWAYSRUN: Automatic or manual control of HFCLK128M/HFCLK64M
func (o *CLOCK_Type) SetHFCLKALWAYSRUN_ALWAYSRUN(value uint32) {
	volatile.StoreUint32(&o.HFCLKALWAYSRUN.Reg, volatile.LoadUint32(&o.HFCLKALWAYSRUN.Reg)&^(0x1)|value)
}
func (o *CLOCK_Type) GetHFCLKALWAYSRUN_ALWAYSRUN() uint32 {
	return volatile.LoadUint32(&o.HFCLKALWAYSRUN.Reg) & 0x1
}

// CLOCK.LFCLKALWAYSRUN: Automatic or manual control of LFCLK
func (o *CLOCK_Type) SetLFCLKALWAYSRUN_ALWAYSRUN(value uint32) {
	volatile.StoreUint32(&o.LFCLKALWAYSRUN.Reg, volatile.LoadUint32(&o.LFCLKALWAYSRUN.Reg)&^(0x1)|value)
}
func (o *CLOCK_Type) GetLFCLKALWAYSRUN_ALWAYSRUN() uint32 {
	return volatile.LoadUint32(&o.LFCLKALWAYSRUN.Reg) & 0x1
}

// Power control
type POWER_Type struct {
	_                  [120]byte
	TASKS_CONSTLAT     volatile.Register32 // 0x78
	TASKS_LOWPWR       volatile.Register32 // 0x7C
	_                  [120]byte
	SUBSCRIBE_CONSTLAT volatile.Register32 // 0xF8
	SUBSCRIBE_LOWPWR   volatile.Register32 // 0xFC
	_                  [8]byte
	EVENTS_POFWARN     volatile.Register32 // 0x108
	_                  [8]byte
	EVENTS_SLEEPENTER  volatile.Register32 // 0x114
	EVENTS_SLEEPEXIT   volatile.Register32 // 0x118
	_                  [108]byte
	PUBLISH_POFWARN    volatile.Register32 // 0x188
	_                  [8]byte
	PUBLISH_SLEEPENTER volatile.Register32 // 0x194
	PUBLISH_SLEEPEXIT  volatile.Register32 // 0x198
	_                  [356]byte
	INTEN              volatile.Register32 // 0x300
	INTENSET           volatile.Register32 // 0x304
	INTENCLR           volatile.Register32 // 0x308
	_                  [528]byte
	GPREGRET           [2]volatile.Register32 // 0x51C
}

// POWER.TASKS_CONSTLAT: Enable Constant Latency mode
func (o *POWER_Type) SetTASKS_CONSTLAT(value uint32) {
	volatile.StoreUint32(&o.TASKS_CONSTLAT.Reg, volatile.LoadUint32(&o.TASKS_CONSTLAT.Reg)&^(0x1)|value)
}
func (o *POWER_Type) GetTASKS_CONSTLAT() uint32 {
	return volatile.LoadUint32(&o.TASKS_CONSTLAT.Reg) & 0x1
}

// POWER.TASKS_LOWPWR: Enable Low-Power mode (variable latency)
func (o *POWER_Type) SetTASKS_LOWPWR(value uint32) {
	volatile.StoreUint32(&o.TASKS_LOWPWR.Reg, volatile.LoadUint32(&o.TASKS_LOWPWR.Reg)&^(0x1)|value)
}
func (o *POWER_Type) GetTASKS_LOWPWR() uint32 {
	return volatile.LoadUint32(&o.TASKS_LOWPWR.Reg) & 0x1
}

// POWER.SUBSCRIBE_CONSTLAT: Subscribe configuration for task CONSTLAT
func (o *POWER_Type) SetSUBSCRIBE_CONSTLAT_CHIDX(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_CONSTLAT.Reg, volatile.LoadUint32(&o.SUBSCRIBE_CONSTLAT.Reg)&^(0xff)|value)
}
func (o *POWER_Type) GetSUBSCRIBE_CONSTLAT_CHIDX() uint32 {
	return volatile.LoadUint32(&o.SUBSCRIBE_CONSTLAT.Reg) & 0xff
}
func (o *POWER_Type) SetSUBSCRIBE_CONSTLAT_EN(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_CONSTLAT.Reg, volatile.LoadUint32(&o.SUBSCRIBE_CONSTLAT.Reg)&^(0x80000000)|value<<31)
}
func (o *POWER_Type) GetSUBSCRIBE_CONSTLAT_EN() uint32 {
	return (volatile.LoadUint32(&o.SUBSCRIBE_CONSTLAT.Reg) & 0x80000000) >> 31
}

// POWER.SUBSCRIBE_LOWPWR: Subscribe configuration for task LOWPWR
func (o *POWER_Type) SetSUBSCRIBE_LOWPWR_CHIDX(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_LOWPWR.Reg, volatile.LoadUint32(&o.SUBSCRIBE_LOWPWR.Reg)&^(0xff)|value)
}
func (o *POWER_Type) GetSUBSCRIBE_LOWPWR_CHIDX() uint32 {
	return volatile.LoadUint32(&o.SUBSCRIBE_LOWPWR.Reg) & 0xff
}
func (o *POWER_Type) SetSUBSCRIBE_LOWPWR_EN(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_LOWPWR.Reg, volatile.LoadUint32(&o.SUBSCRIBE_LOWPWR.Reg)&^(0x80000000)|value<<31)
}
func (o *POWER_Type) GetSUBSCRIBE_LOWPWR_EN() uint32 {
	return (volatile.LoadUint32(&o.SUBSCRIBE_LOWPWR.Reg) & 0x80000000) >> 31
}

// POWER.EVENTS_POFWARN: Power failure warning
func (o *POWER_Type) SetEVENTS_POFWARN(value uint32) {
	volatile.StoreUint32(&o.EVENTS_POFWARN.Reg, volatile.LoadUint32(&o.EVENTS_POFWARN.Reg)&^(0x1)|value)
}
func (o *POWER_Type) GetEVENTS_POFWARN() uint32 {
	return volatile.LoadUint32(&o.EVENTS_POFWARN.Reg) & 0x1
}

// POWER.EVENTS_SLEEPENTER: CPU entered WFI/WFE sleep
func (o *POWER_Type) SetEVENTS_SLEEPENTER(value uint32) {
	volatile.StoreUint32(&o.EVENTS_SLEEPENTER.Reg, volatile.LoadUint32(&o.EVENTS_SLEEPENTER.Reg)&^(0x1)|value)
}
func (o *POWER_Type) GetEVENTS_SLEEPENTER() uint32 {
	return volatile.LoadUint32(&o.EVENTS_SLEEPENTER.Reg) & 0x1
}

// POWER.EVENTS_SLEEPEXIT: CPU exited WFI/WFE sleep
func (o *POWER_Type) SetEVENTS_SLEEPEXIT(value uint32) {
	volatile.StoreUint32(&o.EVENTS_SLEEPEXIT.Reg, volatile.LoadUint32(&o.EVENTS_SLEEPEXIT.Reg)&^(0x1)|value)
}
func (o *POWER_Type) GetEVENTS_SLEEPEXIT() uint32 {
	return volatile.LoadUint32(&o.EVENTS_SLEEPEXIT.Reg) & 0x1
}

// POWER.PUBLISH_POFWARN: Publish configuration for event POFWARN
func (o *POWER_Type) SetPUBLISH_POFWARN_CHIDX(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_POFWARN.Reg, volatile.LoadUint32(&o.PUBLISH_POFWARN.Reg)&^(0xff)|value)
}
func (o *POWER_Type) GetPUBLISH_POFWARN_CHIDX() uint32 {
	return volatile.LoadUint32(&o.PUBLISH_POFWARN.Reg) & 0xff
}
func (o *POWER_Type) SetPUBLISH_POFWARN_EN(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_POFWARN.Reg, volatile.LoadUint32(&o.PUBLISH_POFWARN.Reg)&^(0x80000000)|value<<31)
}
func (o *POWER_Type) GetPUBLISH_POFWARN_EN() uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_POFWARN.Reg) & 0x80000000) >> 31
}

// POWER.PUBLISH_SLEEPENTER: Publish configuration for event SLEEPENTER
func (o *POWER_Type) SetPUBLISH_SLEEPENTER_CHIDX(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_SLEEPENTER.Reg, volatile.LoadUint32(&o.PUBLISH_SLEEPENTER.Reg)&^(0xff)|value)
}
func (o *POWER_Type) GetPUBLISH_SLEEPENTER_CHIDX() uint32 {
	return volatile.LoadUint32(&o.PUBLISH_SLEEPENTER.Reg) & 0xff
}
func (o *POWER_Type) SetPUBLISH_SLEEPENTER_EN(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_SLEEPENTER.Reg, volatile.LoadUint32(&o.PUBLISH_SLEEPENTER.Reg)&^(0x80000000)|value<<31)
}
func (o *POWER_Type) GetPUBLISH_SLEEPENTER_EN() uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_SLEEPENTER.Reg) & 0x80000000) >> 31
}

// POWER.PUBLISH_SLEEPEXIT: Publish configuration for event SLEEPEXIT
func (o *POWER_Type) SetPUBLISH_SLEEPEXIT_CHIDX(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_SLEEPEXIT.Reg, volatile.LoadUint32(&o.PUBLISH_SLEEPEXIT.Reg)&^(0xff)|value)
}
func (o *POWER_Type) GetPUBLISH_SLEEPEXIT_CHIDX() uint32 {
	return volatile.LoadUint32(&o.PUBLISH_SLEEPEXIT.Reg) & 0xff
}
func (o *POWER_Type) SetPUBLISH_SLEEPEXIT_EN(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_SLEEPEXIT.Reg, volatile.LoadUint32(&o.PUBLISH_SLEEPEXIT.Reg)&^(0x80000000)|value<<31)
}
func (o *POWER_Type) GetPUBLISH_SLEEPEXIT_EN() uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_SLEEPEXIT.Reg) & 0x80000000) >> 31
}

// POWER.INTEN: Enable or disable interrupt
func (o *POWER_Type) SetINTEN_POFWARN(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x4)|value<<2)
}
func (o *POWER_Type) GetINTEN_POFWARN() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x4) >> 2
}
func (o *POWER_Type) SetINTEN_SLEEPENTER(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x20)|value<<5)
}
func (o *POWER_Type) GetINTEN_SLEEPENTER() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x20) >> 5
}
func (o *POWER_Type) SetINTEN_SLEEPEXIT(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x40)|value<<6)
}
func (o *POWER_Type) GetINTEN_SLEEPEXIT() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x40) >> 6
}

// POWER.INTENSET: Enable interrupt
func (o *POWER_Type) SetINTENSET_POFWARN(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x4)|value<<2)
}
func (o *POWER_Type) GetINTENSET_POFWARN() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x4) >> 2
}
func (o *POWER_Type) SetINTENSET_SLEEPENTER(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x20)|value<<5)
}
func (o *POWER_Type) GetINTENSET_SLEEPENTER() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x20) >> 5
}
func (o *POWER_Type) SetINTENSET_SLEEPEXIT(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x40)|value<<6)
}
func (o *POWER_Type) GetINTENSET_SLEEPEXIT() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x40) >> 6
}

// POWER.INTENCLR: Disable interrupt
func (o *POWER_Type) SetINTENCLR_POFWARN(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x4)|value<<2)
}
func (o *POWER_Type) GetINTENCLR_POFWARN() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x4) >> 2
}
func (o *POWER_Type) SetINTENCLR_SLEEPENTER(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x20)|value<<5)
}
func (o *POWER_Type) GetINTENCLR_SLEEPENTER() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x20) >> 5
}
func (o *POWER_Type) SetINTENCLR_SLEEPEXIT(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x40)|value<<6)
}
func (o *POWER_Type) GetINTENCLR_SLEEPEXIT() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x40) >> 6
}

// POWER.GPREGRET: Description collection: General purpose retention register
func (o *POWER_Type) SetGPREGRET(idx int, value uint32) {
	volatile.StoreUint32(&o.GPREGRET[idx].Reg, volatile.LoadUint32(&o.GPREGRET[idx].Reg)&^(0xff)|value)
}
func (o *POWER_Type) GetGPREGRET(idx int) uint32 {
	return volatile.LoadUint32(&o.GPREGRET[idx].Reg) & 0xff
}

// Reset control
type RESET_Type struct {
	_         [1024]byte
	RESETREAS volatile.Register32 // 0x400
}

// RESET.RESETREAS: Reset reason
func (o *RESET_Type) SetRESETREAS_RESETPIN(value uint32) {
	volatile.StoreUint32(&o.RESETREAS.Reg, volatile.LoadUint32(&o.RESETREAS.Reg)&^(0x1)|value)
}
func (o *RESET_Type) GetRESETREAS_RESETPIN() uint32 {
	return volatile.LoadUint32(&o.RESETREAS.Reg) & 0x1
}
func (o *RESET_Type) SetRESETREAS_DOG0(value uint32) {
	volatile.StoreUint32(&o.RESETREAS.Reg, volatile.LoadUint32(&o.RESETREAS.Reg)&^(0x2)|value<<1)
}
func (o *RESET_Type) GetRESETREAS_DOG0() uint32 {
	return (volatile.LoadUint32(&o.RESETREAS.Reg) & 0x2) >> 1
}
func (o *RESET_Type) SetRESETREAS_CTRLAP(value uint32) {
	volatile.StoreUint32(&o.RESETREAS.Reg, volatile.LoadUint32(&o.RESETREAS.Reg)&^(0x4)|value<<2)
}
func (o *RESET_Type) GetRESETREAS_CTRLAP() uint32 {
	return (volatile.LoadUint32(&o.RESETREAS.Reg) & 0x4) >> 2
}
func (o *RESET_Type) SetRESETREAS_SREQ(value uint32) {
	volatile.StoreUint32(&o.RESETREAS.Reg, volatile.LoadUint32(&o.RESETREAS.Reg)&^(0x8)|value<<3)
}
func (o *RESET_Type) GetRESETREAS_SREQ() uint32 {
	return (volatile.LoadUint32(&o.RESETREAS.Reg) & 0x8) >> 3
}
func (o *RESET_Type) SetRESETREAS_LOCKUP(value uint32) {
	volatile.StoreUint32(&o.RESETREAS.Reg, volatile.LoadUint32(&o.RESETREAS.Reg)&^(0x10)|value<<4)
}
func (o *RESET_Type) GetRESETREAS_LOCKUP() uint32 {
	return (volatile.LoadUint32(&o.RESETREAS.Reg) & 0x10) >> 4
}
func (o *RESET_Type) SetRESETREAS_OFF(value uint32) {
	volatile.StoreUint32(&o.RESETREAS.Reg, volatile.LoadUint32(&o.RESETREAS.Reg)&^(0x20)|value<<5)
}
func (o *RESET_Type) GetRESETREAS_OFF() uint32 {
	return (volatile.LoadUint32(&o.RESETREAS.Reg) & 0x20) >> 5
}
func (o *RESET_Type) SetRESETREAS_LPCOMP(value uint32) {
	volatile.StoreUint32(&o.RESETREAS.Reg, volatile.LoadUint32(&o.RESETREAS.Reg)&^(0x40)|value<<6)
}
func (o *RESET_Type) GetRESETREAS_LPCOMP() uint32 {
	return (volatile.LoadUint32(&o.RESETREAS.Reg) & 0x40) >> 6
}
func (o *RESET_Type) SetRESETREAS_DIF(value uint32) {
	volatile.StoreUint32(&o.RESETREAS.Reg, volatile.LoadUint32(&o.RESETREAS.Reg)&^(0x80)|value<<7)
}
func (o *RESET_Type) GetRESETREAS_DIF() uint32 {
	return (volatile.LoadUint32(&o.RESETREAS.Reg) & 0x80) >> 7
}
func (o *RESET_Type) SetRESETREAS_LSREQ(value uint32) {
	volatile.StoreUint32(&o.RESETREAS.Reg, volatile.LoadUint32(&o.RESETREAS.Reg)&^(0x10000)|value<<16)
}
func (o *RESET_Type) GetRESETREAS_LSREQ() uint32 {
	return (volatile.LoadUint32(&o.RESETREAS.Reg) & 0x10000) >> 16
}
func (o *RESET_Type) SetRESETREAS_LLOCKUP(value uint32) {
	volatile.StoreUint32(&o.RESETREAS.Reg, volatile.LoadUint32(&o.RESETREAS.Reg)&^(0x20000)|value<<17)
}
func (o *RESET_Type) GetRESETREAS_LLOCKUP() uint32 {
	return (volatile.LoadUint32(&o.RESETREAS.Reg) & 0x20000) >> 17
}
func (o *RESET_Type) SetRESETREAS_LDOG(value uint32) {
	volatile.StoreUint32(&o.RESETREAS.Reg, volatile.LoadUint32(&o.RESETREAS.Reg)&^(0x40000)|value<<18)
}
func (o *RESET_Type) GetRESETREAS_LDOG() uint32 {
	return (volatile.LoadUint32(&o.RESETREAS.Reg) & 0x40000) >> 18
}
func (o *RESET_Type) SetRESETREAS_MFORCEOFF(value uint32) {
	volatile.StoreUint32(&o.RESETREAS.Reg, volatile.LoadUint32(&o.RESETREAS.Reg)&^(0x800000)|value<<23)
}
func (o *RESET_Type) GetRESETREAS_MFORCEOFF() uint32 {
	return (volatile.LoadUint32(&o.RESETREAS.Reg) & 0x800000) >> 23
}
func (o *RESET_Type) SetRESETREAS_NFC(value uint32) {
	volatile.StoreUint32(&o.RESETREAS.Reg, volatile.LoadUint32(&o.RESETREAS.Reg)&^(0x1000000)|value<<24)
}
func (o *RESET_Type) GetRESETREAS_NFC() uint32 {
	return (volatile.LoadUint32(&o.RESETREAS.Reg) & 0x1000000) >> 24
}
func (o *RESET_Type) SetRESETREAS_DOG1(value uint32) {
	volatile.StoreUint32(&o.RESETREAS.Reg, volatile.LoadUint32(&o.RESETREAS.Reg)&^(0x2000000)|value<<25)
}
func (o *RESET_Type) GetRESETREAS_DOG1() uint32 {
	return (volatile.LoadUint32(&o.RESETREAS.Reg) & 0x2000000) >> 25
}
func (o *RESET_Type) SetRESETREAS_VBUS(value uint32) {
	volatile.StoreUint32(&o.RESETREAS.Reg, volatile.LoadUint32(&o.RESETREAS.Reg)&^(0x4000000)|value<<26)
}
func (o *RESET_Type) GetRESETREAS_VBUS() uint32 {
	return (volatile.LoadUint32(&o.RESETREAS.Reg) & 0x4000000) >> 26
}
func (o *RESET_Type) SetRESETREAS_LCTRLAP(value uint32) {
	volatile.StoreUint32(&o.RESETREAS.Reg, volatile.LoadUint32(&o.RESETREAS.Reg)&^(0x8000000)|value<<27)
}
func (o *RESET_Type) GetRESETREAS_LCTRLAP() uint32 {
	return (volatile.LoadUint32(&o.RESETREAS.Reg) & 0x8000000) >> 27
}

// Control access port
type CTRLAPPERI_Type struct {
	_            [1024]byte
	MAILBOX      CTRLAPPERI_MAILBOX_Type // 0x400
	_            [120]byte
	ERASEPROTECT CTRLAPPERI_ERASEPROTECT_Type // 0x500
	_            [56]byte
	APPROTECT    CTRLAPPERI_APPROTECT_Type // 0x540
	_            [184]byte
	STATUS       volatile.Register32 // 0x600
}

// CTRLAPPERI.STATUS: Status bits for CTRL-AP peripheral
func (o *CTRLAPPERI_Type) SetSTATUS_APPROTECT(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x1)|value)
}
func (o *CTRLAPPERI_Type) GetSTATUS_APPROTECT() uint32 {
	return volatile.LoadUint32(&o.STATUS.Reg) & 0x1
}
func (o *CTRLAPPERI_Type) SetSTATUS_DBGIFACEMODE(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x4)|value<<2)
}
func (o *CTRLAPPERI_Type) GetSTATUS_DBGIFACEMODE() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0x4) >> 2
}

// Unspecified
type CTRLAPPERI_MAILBOX_Type struct {
	RXDATA   volatile.Register32 // 0x400
	RXSTATUS volatile.Register32 // 0x404
	_        [120]byte
	TXDATA   volatile.Register32 // 0x480
	TXSTATUS volatile.Register32 // 0x484
}

// CTRLAPPERI_MAILBOX.RXDATA: Data sent from the debugger to the CPU.
func (o *CTRLAPPERI_MAILBOX_Type) SetRXDATA(value uint32) {
	volatile.StoreUint32(&o.RXDATA.Reg, value)
}
func (o *CTRLAPPERI_MAILBOX_Type) GetRXDATA() uint32 {
	return volatile.LoadUint32(&o.RXDATA.Reg)
}

// CTRLAPPERI_MAILBOX.RXSTATUS: This register shows a status that indicates if data sent from the debugger to the CPU has been read.
func (o *CTRLAPPERI_MAILBOX_Type) SetRXSTATUS(value uint32) {
	volatile.StoreUint32(&o.RXSTATUS.Reg, volatile.LoadUint32(&o.RXSTATUS.Reg)&^(0x1)|value)
}
func (o *CTRLAPPERI_MAILBOX_Type) GetRXSTATUS() uint32 {
	return volatile.LoadUint32(&o.RXSTATUS.Reg) & 0x1
}

// CTRLAPPERI_MAILBOX.TXDATA: Data sent from the CPU to the debugger.
func (o *CTRLAPPERI_MAILBOX_Type) SetTXDATA(value uint32) {
	volatile.StoreUint32(&o.TXDATA.Reg, value)
}
func (o *CTRLAPPERI_MAILBOX_Type) GetTXDATA() uint32 {
	return volatile.LoadUint32(&o.TXDATA.Reg)
}

// CTRLAPPERI_MAILBOX.TXSTATUS: This register shows a status that indicates if the data sent from the CPU to the debugger has been read.
func (o *CTRLAPPERI_MAILBOX_Type) SetTXSTATUS(value uint32) {
	volatile.StoreUint32(&o.TXSTATUS.Reg, volatile.LoadUint32(&o.TXSTATUS.Reg)&^(0x1)|value)
}
func (o *CTRLAPPERI_MAILBOX_Type) GetTXSTATUS() uint32 {
	return volatile.LoadUint32(&o.TXSTATUS.Reg) & 0x1
}

// Unspecified
type CTRLAPPERI_ERASEPROTECT_Type struct {
	LOCK    volatile.Register32 // 0x500
	DISABLE volatile.Register32 // 0x504
}

// CTRLAPPERI_ERASEPROTECT.LOCK: This register locks the ERASEPROTECT.DISABLE register from being written until next reset.
func (o *CTRLAPPERI_ERASEPROTECT_Type) SetLOCK(value uint32) {
	volatile.StoreUint32(&o.LOCK.Reg, volatile.LoadUint32(&o.LOCK.Reg)&^(0x1)|value)
}
func (o *CTRLAPPERI_ERASEPROTECT_Type) GetLOCK() uint32 {
	return volatile.LoadUint32(&o.LOCK.Reg) & 0x1
}

// CTRLAPPERI_ERASEPROTECT.DISABLE: This register disables the ERASEPROTECT register and performs an ERASEALL operation.
func (o *CTRLAPPERI_ERASEPROTECT_Type) SetDISABLE(value uint32) {
	volatile.StoreUint32(&o.DISABLE.Reg, value)
}
func (o *CTRLAPPERI_ERASEPROTECT_Type) GetDISABLE() uint32 {
	return volatile.LoadUint32(&o.DISABLE.Reg)
}

// Unspecified
type CTRLAPPERI_APPROTECT_Type struct {
	LOCK    volatile.Register32 // 0x540
	DISABLE volatile.Register32 // 0x544
}

// CTRLAPPERI_APPROTECT.LOCK: This register locks the APPROTECT.DISABLE register from being written to until next reset.
func (o *CTRLAPPERI_APPROTECT_Type) SetLOCK(value uint32) {
	volatile.StoreUint32(&o.LOCK.Reg, volatile.LoadUint32(&o.LOCK.Reg)&^(0x1)|value)
}
func (o *CTRLAPPERI_APPROTECT_Type) GetLOCK() uint32 {
	return volatile.LoadUint32(&o.LOCK.Reg) & 0x1
}

// CTRLAPPERI_APPROTECT.DISABLE: This register disables the APPROTECT register and enables debug access to non-secure mode.
func (o *CTRLAPPERI_APPROTECT_Type) SetDISABLE(value uint32) {
	volatile.StoreUint32(&o.DISABLE.Reg, value)
}
func (o *CTRLAPPERI_APPROTECT_Type) GetDISABLE() uint32 {
	return volatile.LoadUint32(&o.DISABLE.Reg)
}

// 2.4 GHz radio
type RADIO_Type struct {
	TASKS_TXEN          volatile.Register32 // 0x0
	TASKS_RXEN          volatile.Register32 // 0x4
	TASKS_START         volatile.Register32 // 0x8
	TASKS_STOP          volatile.Register32 // 0xC
	TASKS_DISABLE       volatile.Register32 // 0x10
	TASKS_RSSISTART     volatile.Register32 // 0x14
	TASKS_RSSISTOP      volatile.Register32 // 0x18
	TASKS_BCSTART       volatile.Register32 // 0x1C
	TASKS_BCSTOP        volatile.Register32 // 0x20
	TASKS_EDSTART       volatile.Register32 // 0x24
	TASKS_EDSTOP        volatile.Register32 // 0x28
	TASKS_CCASTART      volatile.Register32 // 0x2C
	TASKS_CCASTOP       volatile.Register32 // 0x30
	_                   [76]byte
	SUBSCRIBE_TXEN      volatile.Register32 // 0x80
	SUBSCRIBE_RXEN      volatile.Register32 // 0x84
	SUBSCRIBE_START     volatile.Register32 // 0x88
	SUBSCRIBE_STOP      volatile.Register32 // 0x8C
	SUBSCRIBE_DISABLE   volatile.Register32 // 0x90
	SUBSCRIBE_RSSISTART volatile.Register32 // 0x94
	SUBSCRIBE_RSSISTOP  volatile.Register32 // 0x98
	SUBSCRIBE_BCSTART   volatile.Register32 // 0x9C
	SUBSCRIBE_BCSTOP    volatile.Register32 // 0xA0
	SUBSCRIBE_EDSTART   volatile.Register32 // 0xA4
	SUBSCRIBE_EDSTOP    volatile.Register32 // 0xA8
	SUBSCRIBE_CCASTART  volatile.Register32 // 0xAC
	SUBSCRIBE_CCASTOP   volatile.Register32 // 0xB0
	_                   [76]byte
	EVENTS_READY        volatile.Register32 // 0x100
	EVENTS_ADDRESS      volatile.Register32 // 0x104
	EVENTS_PAYLOAD      volatile.Register32 // 0x108
	EVENTS_END          volatile.Register32 // 0x10C
	EVENTS_DISABLED     volatile.Register32 // 0x110
	EVENTS_DEVMATCH     volatile.Register32 // 0x114
	EVENTS_DEVMISS      volatile.Register32 // 0x118
	EVENTS_RSSIEND      volatile.Register32 // 0x11C
	_                   [8]byte
	EVENTS_BCMATCH      volatile.Register32 // 0x128
	_                   [4]byte
	EVENTS_CRCOK        volatile.Register32 // 0x130
	EVENTS_CRCERROR     volatile.Register32 // 0x134
	EVENTS_FRAMESTART   volatile.Register32 // 0x138
	EVENTS_EDEND        volatile.Register32 // 0x13C
	EVENTS_EDSTOPPED    volatile.Register32 // 0x140
	EVENTS_CCAIDLE      volatile.Register32 // 0x144
	EVENTS_CCABUSY      volatile.Register32 // 0x148
	EVENTS_CCASTOPPED   volatile.Register32 // 0x14C
	EVENTS_RATEBOOST    volatile.Register32 // 0x150
	EVENTS_TXREADY      volatile.Register32 // 0x154
	EVENTS_RXREADY      volatile.Register32 // 0x158
	EVENTS_MHRMATCH     volatile.Register32 // 0x15C
	_                   [8]byte
	EVENTS_SYNC         volatile.Register32 // 0x168
	EVENTS_PHYEND       volatile.Register32 // 0x16C
	EVENTS_CTEPRESENT   volatile.Register32 // 0x170
	_                   [12]byte
	PUBLISH_READY       volatile.Register32 // 0x180
	PUBLISH_ADDRESS     volatile.Register32 // 0x184
	PUBLISH_PAYLOAD     volatile.Register32 // 0x188
	PUBLISH_END         volatile.Register32 // 0x18C
	PUBLISH_DISABLED    volatile.Register32 // 0x190
	PUBLISH_DEVMATCH    volatile.Register32 // 0x194
	PUBLISH_DEVMISS     volatile.Register32 // 0x198
	PUBLISH_RSSIEND     volatile.Register32 // 0x19C
	_                   [8]byte
	PUBLISH_BCMATCH     volatile.Register32 // 0x1A8
	_                   [4]byte
	PUBLISH_CRCOK       volatile.Register32 // 0x1B0
	PUBLISH_CRCERROR    volatile.Register32 // 0x1B4
	PUBLISH_FRAMESTART  volatile.Register32 // 0x1B8
	PUBLISH_EDEND       volatile.Register32 // 0x1BC
	PUBLISH_EDSTOPPED   volatile.Register32 // 0x1C0
	PUBLISH_CCAIDLE     volatile.Register32 // 0x1C4
	PUBLISH_CCABUSY     volatile.Register32 // 0x1C8
	PUBLISH_CCASTOPPED  volatile.Register32 // 0x1CC
	PUBLISH_RATEBOOST   volatile.Register32 // 0x1D0
	PUBLISH_TXREADY     volatile.Register32 // 0x1D4
	PUBLISH_RXREADY     volatile.Register32 // 0x1D8
	PUBLISH_MHRMATCH    volatile.Register32 // 0x1DC
	_                   [8]byte
	PUBLISH_SYNC        volatile.Register32 // 0x1E8
	PUBLISH_PHYEND      volatile.Register32 // 0x1EC
	PUBLISH_CTEPRESENT  volatile.Register32 // 0x1F0
	_                   [12]byte
	SHORTS              volatile.Register32 // 0x200
	_                   [256]byte
	INTENSET            volatile.Register32 // 0x304
	INTENCLR            volatile.Register32 // 0x308
	_                   [244]byte
	CRCSTATUS           volatile.Register32 // 0x400
	_                   [4]byte
	RXMATCH             volatile.Register32 // 0x408
	RXCRC               volatile.Register32 // 0x40C
	DAI                 volatile.Register32 // 0x410
	PDUSTAT             volatile.Register32 // 0x414
	_                   [52]byte
	CTESTATUS           volatile.Register32 // 0x44C
	_                   [8]byte
	DFESTATUS           volatile.Register32 // 0x458
	_                   [168]byte
	PACKETPTR           volatile.Register32 // 0x504
	FREQUENCY           volatile.Register32 // 0x508
	TXPOWER             volatile.Register32 // 0x50C
	MODE                volatile.Register32 // 0x510
	PCNF0               volatile.Register32 // 0x514
	PCNF1               volatile.Register32 // 0x518
	BASE0               volatile.Register32 // 0x51C
	BASE1               volatile.Register32 // 0x520
	PREFIX0             volatile.Register32 // 0x524
	PREFIX1             volatile.Register32 // 0x528
	TXADDRESS           volatile.Register32 // 0x52C
	RXADDRESSES         volatile.Register32 // 0x530
	CRCCNF              volatile.Register32 // 0x534
	CRCPOLY             volatile.Register32 // 0x538
	CRCINIT             volatile.Register32 // 0x53C
	_                   [4]byte
	TIFS                volatile.Register32 // 0x544
	RSSISAMPLE          volatile.Register32 // 0x548
	_                   [4]byte
	STATE               volatile.Register32 // 0x550
	DATAWHITEIV         volatile.Register32 // 0x554
	_                   [8]byte
	BCC                 volatile.Register32 // 0x560
	_                   [156]byte
	DAB                 [8]volatile.Register32 // 0x600
	DAP                 [8]volatile.Register32 // 0x620
	DACNF               volatile.Register32    // 0x640
	MHRMATCHCONF        volatile.Register32    // 0x644
	MHRMATCHMAS         volatile.Register32    // 0x648
	_                   [4]byte
	MODECNF0            volatile.Register32 // 0x650
	_                   [12]byte
	SFD                 volatile.Register32 // 0x660
	EDCNT               volatile.Register32 // 0x664
	EDSAMPLE            volatile.Register32 // 0x668
	CCACTRL             volatile.Register32 // 0x66C
	_                   [656]byte
	DFEMODE             volatile.Register32 // 0x900
	CTEINLINECONF       volatile.Register32 // 0x904
	_                   [8]byte
	DFECTRL1            volatile.Register32 // 0x910
	DFECTRL2            volatile.Register32 // 0x914
	_                   [16]byte
	SWITCHPATTERN       volatile.Register32  // 0x928
	CLEARPATTERN        volatile.Register32  // 0x92C
	PSEL                RADIO_PSEL_Type      // 0x930
	DFEPACKET           RADIO_DFEPACKET_Type // 0x950
	_                   [1696]byte
	POWER               volatile.Register32 // 0xFFC
}

// RADIO.TASKS_TXEN: Enable RADIO in TX mode
func (o *RADIO_Type) SetTASKS_TXEN(value uint32) {
	volatile.StoreUint32(&o.TASKS_TXEN.Reg, volatile.LoadUint32(&o.TASKS_TXEN.Reg)&^(0x1)|value)
}
func (o *RADIO_Type) GetTASKS_TXEN() uint32 {
	return volatile.LoadUint32(&o.TASKS_TXEN.Reg) & 0x1
}

// RADIO.TASKS_RXEN: Enable RADIO in RX mode
func (o *RADIO_Type) SetTASKS_RXEN(value uint32) {
	volatile.StoreUint32(&o.TASKS_RXEN.Reg, volatile.LoadUint32(&o.TASKS_RXEN.Reg)&^(0x1)|value)
}
func (o *RADIO_Type) GetTASKS_RXEN() uint32 {
	return volatile.LoadUint32(&o.TASKS_RXEN.Reg) & 0x1
}

// RADIO.TASKS_START: Start RADIO
func (o *RADIO_Type) SetTASKS_START(value uint32) {
	volatile.StoreUint32(&o.TASKS_START.Reg, volatile.LoadUint32(&o.TASKS_START.Reg)&^(0x1)|value)
}
func (o *RADIO_Type) GetTASKS_START() uint32 {
	return volatile.LoadUint32(&o.TASKS_START.Reg) & 0x1
}

// RADIO.TASKS_STOP: Stop RADIO
func (o *RADIO_Type) SetTASKS_STOP(value uint32) {
	volatile.StoreUint32(&o.TASKS_STOP.Reg, volatile.LoadUint32(&o.TASKS_STOP.Reg)&^(0x1)|value)
}
func (o *RADIO_Type) GetTASKS_STOP() uint32 {
	return volatile.LoadUint32(&o.TASKS_STOP.Reg) & 0x1
}

// RADIO.TASKS_DISABLE: Disable RADIO
func (o *RADIO_Type) SetTASKS_DISABLE(value uint32) {
	volatile.StoreUint32(&o.TASKS_DISABLE.Reg, volatile.LoadUint32(&o.TASKS_DISABLE.Reg)&^(0x1)|value)
}
func (o *RADIO_Type) GetTASKS_DISABLE() uint32 {
	return volatile.LoadUint32(&o.TASKS_DISABLE.Reg) & 0x1
}

// RADIO.TASKS_RSSISTART: Start the RSSI and take one single sample of the receive signal strength
func (o *RADIO_Type) SetTASKS_RSSISTART(value uint32) {
	volatile.StoreUint32(&o.TASKS_RSSISTART.Reg, volatile.LoadUint32(&o.TASKS_RSSISTART.Reg)&^(0x1)|value)
}
func (o *RADIO_Type) GetTASKS_RSSISTART() uint32 {
	return volatile.LoadUint32(&o.TASKS_RSSISTART.Reg) & 0x1
}

// RADIO.TASKS_RSSISTOP: Stop the RSSI measurement
func (o *RADIO_Type) SetTASKS_RSSISTOP(value uint32) {
	volatile.StoreUint32(&o.TASKS_RSSISTOP.Reg, volatile.LoadUint32(&o.TASKS_RSSISTOP.Reg)&^(0x1)|value)
}
func (o *RADIO_Type) GetTASKS_RSSISTOP() uint32 {
	return volatile.LoadUint32(&o.TASKS_RSSISTOP.Reg) & 0x1
}

// RADIO.TASKS_BCSTART: Start the bit counter
func (o *RADIO_Type) SetTASKS_BCSTART(value uint32) {
	volatile.StoreUint32(&o.TASKS_BCSTART.Reg, volatile.LoadUint32(&o.TASKS_BCSTART.Reg)&^(0x1)|value)
}
func (o *RADIO_Type) GetTASKS_BCSTART() uint32 {
	return volatile.LoadUint32(&o.TASKS_BCSTART.Reg) & 0x1
}

// RADIO.TASKS_BCSTOP: Stop the bit counter
func (o *RADIO_Type) SetTASKS_BCSTOP(value uint32) {
	volatile.StoreUint32(&o.TASKS_BCSTOP.Reg, volatile.LoadUint32(&o.TASKS_BCSTOP.Reg)&^(0x1)|value)
}
func (o *RADIO_Type) GetTASKS_BCSTOP() uint32 {
	return volatile.LoadUint32(&o.TASKS_BCSTOP.Reg) & 0x1
}

// RADIO.TASKS_EDSTART: Start the energy detect measurement used in IEEE 802.15.4 mode
func (o *RADIO_Type) SetTASKS_EDSTART(value uint32) {
	volatile.StoreUint32(&o.TASKS_EDSTART.Reg, volatile.LoadUint32(&o.TASKS_EDSTART.Reg)&^(0x1)|value)
}
func (o *RADIO_Type) GetTASKS_EDSTART() uint32 {
	return volatile.LoadUint32(&o.TASKS_EDSTART.Reg) & 0x1
}

// RADIO.TASKS_EDSTOP: Stop the energy detect measurement
func (o *RADIO_Type) SetTASKS_EDSTOP(value uint32) {
	volatile.StoreUint32(&o.TASKS_EDSTOP.Reg, volatile.LoadUint32(&o.TASKS_EDSTOP.Reg)&^(0x1)|value)
}
func (o *RADIO_Type) GetTASKS_EDSTOP() uint32 {
	return volatile.LoadUint32(&o.TASKS_EDSTOP.Reg) & 0x1
}

// RADIO.TASKS_CCASTART: Start the clear channel assessment used in IEEE 802.15.4 mode
func (o *RADIO_Type) SetTASKS_CCASTART(value uint32) {
	volatile.StoreUint32(&o.TASKS_CCASTART.Reg, volatile.LoadUint32(&o.TASKS_CCASTART.Reg)&^(0x1)|value)
}
func (o *RADIO_Type) GetTASKS_CCASTART() uint32 {
	return volatile.LoadUint32(&o.TASKS_CCASTART.Reg) & 0x1
}

// RADIO.TASKS_CCASTOP: Stop the clear channel assessment
func (o *RADIO_Type) SetTASKS_CCASTOP(value uint32) {
	volatile.StoreUint32(&o.TASKS_CCASTOP.Reg, volatile.LoadUint32(&o.TASKS_CCASTOP.Reg)&^(0x1)|value)
}
func (o *RADIO_Type) GetTASKS_CCASTOP() uint32 {
	return volatile.LoadUint32(&o.TASKS_CCASTOP.Reg) & 0x1
}

// RADIO.SUBSCRIBE_TXEN: Subscribe configuration for task TXEN
func (o *RADIO_Type) SetSUBSCRIBE_TXEN_CHIDX(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_TXEN.Reg, volatile.LoadUint32(&o.SUBSCRIBE_TXEN.Reg)&^(0xff)|value)
}
func (o *RADIO_Type) GetSUBSCRIBE_TXEN_CHIDX() uint32 {
	return volatile.LoadUint32(&o.SUBSCRIBE_TXEN.Reg) & 0xff
}
func (o *RADIO_Type) SetSUBSCRIBE_TXEN_EN(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_TXEN.Reg, volatile.LoadUint32(&o.SUBSCRIBE_TXEN.Reg)&^(0x80000000)|value<<31)
}
func (o *RADIO_Type) GetSUBSCRIBE_TXEN_EN() uint32 {
	return (volatile.LoadUint32(&o.SUBSCRIBE_TXEN.Reg) & 0x80000000) >> 31
}

// RADIO.SUBSCRIBE_RXEN: Subscribe configuration for task RXEN
func (o *RADIO_Type) SetSUBSCRIBE_RXEN_CHIDX(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_RXEN.Reg, volatile.LoadUint32(&o.SUBSCRIBE_RXEN.Reg)&^(0xff)|value)
}
func (o *RADIO_Type) GetSUBSCRIBE_RXEN_CHIDX() uint32 {
	return volatile.LoadUint32(&o.SUBSCRIBE_RXEN.Reg) & 0xff
}
func (o *RADIO_Type) SetSUBSCRIBE_RXEN_EN(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_RXEN.Reg, volatile.LoadUint32(&o.SUBSCRIBE_RXEN.Reg)&^(0x80000000)|value<<31)
}
func (o *RADIO_Type) GetSUBSCRIBE_RXEN_EN() uint32 {
	return (volatile.LoadUint32(&o.SUBSCRIBE_RXEN.Reg) & 0x80000000) >> 31
}

// RADIO.SUBSCRIBE_START: Subscribe configuration for task START
func (o *RADIO_Type) SetSUBSCRIBE_START_CHIDX(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_START.Reg, volatile.LoadUint32(&o.SUBSCRIBE_START.Reg)&^(0xff)|value)
}
func (o *RADIO_Type) GetSUBSCRIBE_START_CHIDX() uint32 {
	return volatile.LoadUint32(&o.SUBSCRIBE_START.Reg) & 0xff
}
func (o *RADIO_Type) SetSUBSCRIBE_START_EN(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_START.Reg, volatile.LoadUint32(&o.SUBSCRIBE_START.Reg)&^(0x80000000)|value<<31)
}
func (o *RADIO_Type) GetSUBSCRIBE_START_EN() uint32 {
	return (volatile.LoadUint32(&o.SUBSCRIBE_START.Reg) & 0x80000000) >> 31
}

// RADIO.SUBSCRIBE_STOP: Subscribe configuration for task STOP
func (o *RADIO_Type) SetSUBSCRIBE_STOP_CHIDX(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_STOP.Reg, volatile.LoadUint32(&o.SUBSCRIBE_STOP.Reg)&^(0xff)|value)
}
func (o *RADIO_Type) GetSUBSCRIBE_STOP_CHIDX() uint32 {
	return volatile.LoadUint32(&o.SUBSCRIBE_STOP.Reg) & 0xff
}
func (o *RADIO_Type) SetSUBSCRIBE_STOP_EN(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_STOP.Reg, volatile.LoadUint32(&o.SUBSCRIBE_STOP.Reg)&^(0x80000000)|value<<31)
}
func (o *RADIO_Type) GetSUBSCRIBE_STOP_EN() uint32 {
	return (volatile.LoadUint32(&o.SUBSCRIBE_STOP.Reg) & 0x80000000) >> 31
}

// RADIO.SUBSCRIBE_DISABLE: Subscribe configuration for task DISABLE
func (o *RADIO_Type) SetSUBSCRIBE_DISABLE_CHIDX(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_DISABLE.Reg, volatile.LoadUint32(&o.SUBSCRIBE_DISABLE.Reg)&^(0xff)|value)
}
func (o *RADIO_Type) GetSUBSCRIBE_DISABLE_CHIDX() uint32 {
	return volatile.LoadUint32(&o.SUBSCRIBE_DISABLE.Reg) & 0xff
}
func (o *RADIO_Type) SetSUBSCRIBE_DISABLE_EN(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_DISABLE.Reg, volatile.LoadUint32(&o.SUBSCRIBE_DISABLE.Reg)&^(0x80000000)|value<<31)
}
func (o *RADIO_Type) GetSUBSCRIBE_DISABLE_EN() uint32 {
	return (volatile.LoadUint32(&o.SUBSCRIBE_DISABLE.Reg) & 0x80000000) >> 31
}

// RADIO.SUBSCRIBE_RSSISTART: Subscribe configuration for task RSSISTART
func (o *RADIO_Type) SetSUBSCRIBE_RSSISTART_CHIDX(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_RSSISTART.Reg, volatile.LoadUint32(&o.SUBSCRIBE_RSSISTART.Reg)&^(0xff)|value)
}
func (o *RADIO_Type) GetSUBSCRIBE_RSSISTART_CHIDX() uint32 {
	return volatile.LoadUint32(&o.SUBSCRIBE_RSSISTART.Reg) & 0xff
}
func (o *RADIO_Type) SetSUBSCRIBE_RSSISTART_EN(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_RSSISTART.Reg, volatile.LoadUint32(&o.SUBSCRIBE_RSSISTART.Reg)&^(0x80000000)|value<<31)
}
func (o *RADIO_Type) GetSUBSCRIBE_RSSISTART_EN() uint32 {
	return (volatile.LoadUint32(&o.SUBSCRIBE_RSSISTART.Reg) & 0x80000000) >> 31
}

// RADIO.SUBSCRIBE_RSSISTOP: Subscribe configuration for task RSSISTOP
func (o *RADIO_Type) SetSUBSCRIBE_RSSISTOP_CHIDX(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_RSSISTOP.Reg, volatile.LoadUint32(&o.SUBSCRIBE_RSSISTOP.Reg)&^(0xff)|value)
}
func (o *RADIO_Type) GetSUBSCRIBE_RSSISTOP_CHIDX() uint32 {
	return volatile.LoadUint32(&o.SUBSCRIBE_RSSISTOP.Reg) & 0xff
}
func (o *RADIO_Type) SetSUBSCRIBE_RSSISTOP_EN(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_RSSISTOP.Reg, volatile.LoadUint32(&o.SUBSCRIBE_RSSISTOP.Reg)&^(0x80000000)|value<<31)
}
func (o *RADIO_Type) GetSUBSCRIBE_RSSISTOP_EN() uint32 {
	return (volatile.LoadUint32(&o.SUBSCRIBE_RSSISTOP.Reg) & 0x80000000) >> 31
}

// RADIO.SUBSCRIBE_BCSTART: Subscribe configuration for task BCSTART
func (o *RADIO_Type) SetSUBSCRIBE_BCSTART_CHIDX(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_BCSTART.Reg, volatile.LoadUint32(&o.SUBSCRIBE_BCSTART.Reg)&^(0xff)|value)
}
func (o *RADIO_Type) GetSUBSCRIBE_BCSTART_CHIDX() uint32 {
	return volatile.LoadUint32(&o.SUBSCRIBE_BCSTART.Reg) & 0xff
}
func (o *RADIO_Type) SetSUBSCRIBE_BCSTART_EN(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_BCSTART.Reg, volatile.LoadUint32(&o.SUBSCRIBE_BCSTART.Reg)&^(0x80000000)|value<<31)
}
func (o *RADIO_Type) GetSUBSCRIBE_BCSTART_EN() uint32 {
	return (volatile.LoadUint32(&o.SUBSCRIBE_BCSTART.Reg) & 0x80000000) >> 31
}

// RADIO.SUBSCRIBE_BCSTOP: Subscribe configuration for task BCSTOP
func (o *RADIO_Type) SetSUBSCRIBE_BCSTOP_CHIDX(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_BCSTOP.Reg, volatile.LoadUint32(&o.SUBSCRIBE_BCSTOP.Reg)&^(0xff)|value)
}
func (o *RADIO_Type) GetSUBSCRIBE_BCSTOP_CHIDX() uint32 {
	return volatile.LoadUint32(&o.SUBSCRIBE_BCSTOP.Reg) & 0xff
}
func (o *RADIO_Type) SetSUBSCRIBE_BCSTOP_EN(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_BCSTOP.Reg, volatile.LoadUint32(&o.SUBSCRIBE_BCSTOP.Reg)&^(0x80000000)|value<<31)
}
func (o *RADIO_Type) GetSUBSCRIBE_BCSTOP_EN() uint32 {
	return (volatile.LoadUint32(&o.SUBSCRIBE_BCSTOP.Reg) & 0x80000000) >> 31
}

// RADIO.SUBSCRIBE_EDSTART: Subscribe configuration for task EDSTART
func (o *RADIO_Type) SetSUBSCRIBE_EDSTART_CHIDX(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_EDSTART.Reg, volatile.LoadUint32(&o.SUBSCRIBE_EDSTART.Reg)&^(0xff)|value)
}
func (o *RADIO_Type) GetSUBSCRIBE_EDSTART_CHIDX() uint32 {
	return volatile.LoadUint32(&o.SUBSCRIBE_EDSTART.Reg) & 0xff
}
func (o *RADIO_Type) SetSUBSCRIBE_EDSTART_EN(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_EDSTART.Reg, volatile.LoadUint32(&o.SUBSCRIBE_EDSTART.Reg)&^(0x80000000)|value<<31)
}
func (o *RADIO_Type) GetSUBSCRIBE_EDSTART_EN() uint32 {
	return (volatile.LoadUint32(&o.SUBSCRIBE_EDSTART.Reg) & 0x80000000) >> 31
}

// RADIO.SUBSCRIBE_EDSTOP: Subscribe configuration for task EDSTOP
func (o *RADIO_Type) SetSUBSCRIBE_EDSTOP_CHIDX(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_EDSTOP.Reg, volatile.LoadUint32(&o.SUBSCRIBE_EDSTOP.Reg)&^(0xff)|value)
}
func (o *RADIO_Type) GetSUBSCRIBE_EDSTOP_CHIDX() uint32 {
	return volatile.LoadUint32(&o.SUBSCRIBE_EDSTOP.Reg) & 0xff
}
func (o *RADIO_Type) SetSUBSCRIBE_EDSTOP_EN(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_EDSTOP.Reg, volatile.LoadUint32(&o.SUBSCRIBE_EDSTOP.Reg)&^(0x80000000)|value<<31)
}
func (o *RADIO_Type) GetSUBSCRIBE_EDSTOP_EN() uint32 {
	return (volatile.LoadUint32(&o.SUBSCRIBE_EDSTOP.Reg) & 0x80000000) >> 31
}

// RADIO.SUBSCRIBE_CCASTART: Subscribe configuration for task CCASTART
func (o *RADIO_Type) SetSUBSCRIBE_CCASTART_CHIDX(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_CCASTART.Reg, volatile.LoadUint32(&o.SUBSCRIBE_CCASTART.Reg)&^(0xff)|value)
}
func (o *RADIO_Type) GetSUBSCRIBE_CCASTART_CHIDX() uint32 {
	return volatile.LoadUint32(&o.SUBSCRIBE_CCASTART.Reg) & 0xff
}
func (o *RADIO_Type) SetSUBSCRIBE_CCASTART_EN(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_CCASTART.Reg, volatile.LoadUint32(&o.SUBSCRIBE_CCASTART.Reg)&^(0x80000000)|value<<31)
}
func (o *RADIO_Type) GetSUBSCRIBE_CCASTART_EN() uint32 {
	return (volatile.LoadUint32(&o.SUBSCRIBE_CCASTART.Reg) & 0x80000000) >> 31
}

// RADIO.SUBSCRIBE_CCASTOP: Subscribe configuration for task CCASTOP
func (o *RADIO_Type) SetSUBSCRIBE_CCASTOP_CHIDX(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_CCASTOP.Reg, volatile.LoadUint32(&o.SUBSCRIBE_CCASTOP.Reg)&^(0xff)|value)
}
func (o *RADIO_Type) GetSUBSCRIBE_CCASTOP_CHIDX() uint32 {
	return volatile.LoadUint32(&o.SUBSCRIBE_CCASTOP.Reg) & 0xff
}
func (o *RADIO_Type) SetSUBSCRIBE_CCASTOP_EN(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_CCASTOP.Reg, volatile.LoadUint32(&o.SUBSCRIBE_CCASTOP.Reg)&^(0x80000000)|value<<31)
}
func (o *RADIO_Type) GetSUBSCRIBE_CCASTOP_EN() uint32 {
	return (volatile.LoadUint32(&o.SUBSCRIBE_CCASTOP.Reg) & 0x80000000) >> 31
}

// RADIO.EVENTS_READY: RADIO has ramped up and is ready to be started
func (o *RADIO_Type) SetEVENTS_READY(value uint32) {
	volatile.StoreUint32(&o.EVENTS_READY.Reg, volatile.LoadUint32(&o.EVENTS_READY.Reg)&^(0x1)|value)
}
func (o *RADIO_Type) GetEVENTS_READY() uint32 {
	return volatile.LoadUint32(&o.EVENTS_READY.Reg) & 0x1
}

// RADIO.EVENTS_ADDRESS: Address sent or received
func (o *RADIO_Type) SetEVENTS_ADDRESS(value uint32) {
	volatile.StoreUint32(&o.EVENTS_ADDRESS.Reg, volatile.LoadUint32(&o.EVENTS_ADDRESS.Reg)&^(0x1)|value)
}
func (o *RADIO_Type) GetEVENTS_ADDRESS() uint32 {
	return volatile.LoadUint32(&o.EVENTS_ADDRESS.Reg) & 0x1
}

// RADIO.EVENTS_PAYLOAD: Packet payload sent or received
func (o *RADIO_Type) SetEVENTS_PAYLOAD(value uint32) {
	volatile.StoreUint32(&o.EVENTS_PAYLOAD.Reg, volatile.LoadUint32(&o.EVENTS_PAYLOAD.Reg)&^(0x1)|value)
}
func (o *RADIO_Type) GetEVENTS_PAYLOAD() uint32 {
	return volatile.LoadUint32(&o.EVENTS_PAYLOAD.Reg) & 0x1
}

// RADIO.EVENTS_END: Packet sent or received
func (o *RADIO_Type) SetEVENTS_END(value uint32) {
	volatile.StoreUint32(&o.EVENTS_END.Reg, volatile.LoadUint32(&o.EVENTS_END.Reg)&^(0x1)|value)
}
func (o *RADIO_Type) GetEVENTS_END() uint32 {
	return volatile.LoadUint32(&o.EVENTS_END.Reg) & 0x1
}

// RADIO.EVENTS_DISABLED: RADIO has been disabled
func (o *RADIO_Type) SetEVENTS_DISABLED(value uint32) {
	volatile.StoreUint32(&o.EVENTS_DISABLED.Reg, volatile.LoadUint32(&o.EVENTS_DISABLED.Reg)&^(0x1)|value)
}
func (o *RADIO_Type) GetEVENTS_DISABLED() uint32 {
	return volatile.LoadUint32(&o.EVENTS_DISABLED.Reg) & 0x1
}

// RADIO.EVENTS_DEVMATCH: A device address match occurred on the last received packet
func (o *RADIO_Type) SetEVENTS_DEVMATCH(value uint32) {
	volatile.StoreUint32(&o.EVENTS_DEVMATCH.Reg, volatile.LoadUint32(&o.EVENTS_DEVMATCH.Reg)&^(0x1)|value)
}
func (o *RADIO_Type) GetEVENTS_DEVMATCH() uint32 {
	return volatile.LoadUint32(&o.EVENTS_DEVMATCH.Reg) & 0x1
}

// RADIO.EVENTS_DEVMISS: No device address match occurred on the last received packet
func (o *RADIO_Type) SetEVENTS_DEVMISS(value uint32) {
	volatile.StoreUint32(&o.EVENTS_DEVMISS.Reg, volatile.LoadUint32(&o.EVENTS_DEVMISS.Reg)&^(0x1)|value)
}
func (o *RADIO_Type) GetEVENTS_DEVMISS() uint32 {
	return volatile.LoadUint32(&o.EVENTS_DEVMISS.Reg) & 0x1
}

// RADIO.EVENTS_RSSIEND: Sampling of receive signal strength complete
func (o *RADIO_Type) SetEVENTS_RSSIEND(value uint32) {
	volatile.StoreUint32(&o.EVENTS_RSSIEND.Reg, volatile.LoadUint32(&o.EVENTS_RSSIEND.Reg)&^(0x1)|value)
}
func (o *RADIO_Type) GetEVENTS_RSSIEND() uint32 {
	return volatile.LoadUint32(&o.EVENTS_RSSIEND.Reg) & 0x1
}

// RADIO.EVENTS_BCMATCH: Bit counter reached bit count value
func (o *RADIO_Type) SetEVENTS_BCMATCH(value uint32) {
	volatile.StoreUint32(&o.EVENTS_BCMATCH.Reg, volatile.LoadUint32(&o.EVENTS_BCMATCH.Reg)&^(0x1)|value)
}
func (o *RADIO_Type) GetEVENTS_BCMATCH() uint32 {
	return volatile.LoadUint32(&o.EVENTS_BCMATCH.Reg) & 0x1
}

// RADIO.EVENTS_CRCOK: Packet received with CRC ok
func (o *RADIO_Type) SetEVENTS_CRCOK(value uint32) {
	volatile.StoreUint32(&o.EVENTS_CRCOK.Reg, volatile.LoadUint32(&o.EVENTS_CRCOK.Reg)&^(0x1)|value)
}
func (o *RADIO_Type) GetEVENTS_CRCOK() uint32 {
	return volatile.LoadUint32(&o.EVENTS_CRCOK.Reg) & 0x1
}

// RADIO.EVENTS_CRCERROR: Packet received with CRC error
func (o *RADIO_Type) SetEVENTS_CRCERROR(value uint32) {
	volatile.StoreUint32(&o.EVENTS_CRCERROR.Reg, volatile.LoadUint32(&o.EVENTS_CRCERROR.Reg)&^(0x1)|value)
}
func (o *RADIO_Type) GetEVENTS_CRCERROR() uint32 {
	return volatile.LoadUint32(&o.EVENTS_CRCERROR.Reg) & 0x1
}

// RADIO.EVENTS_FRAMESTART: IEEE 802.15.4 length field received
func (o *RADIO_Type) SetEVENTS_FRAMESTART(value uint32) {
	volatile.StoreUint32(&o.EVENTS_FRAMESTART.Reg, volatile.LoadUint32(&o.EVENTS_FRAMESTART.Reg)&^(0x1)|value)
}
func (o *RADIO_Type) GetEVENTS_FRAMESTART() uint32 {
	return volatile.LoadUint32(&o.EVENTS_FRAMESTART.Reg) & 0x1
}

// RADIO.EVENTS_EDEND: Sampling of energy detection complete. A new ED sample is ready for readout from the RADIO.EDSAMPLE register
func (o *RADIO_Type) SetEVENTS_EDEND(value uint32) {
	volatile.StoreUint32(&o.EVENTS_EDEND.Reg, volatile.LoadUint32(&o.EVENTS_EDEND.Reg)&^(0x1)|value)
}
func (o *RADIO_Type) GetEVENTS_EDEND() uint32 {
	return volatile.LoadUint32(&o.EVENTS_EDEND.Reg) & 0x1
}

// RADIO.EVENTS_EDSTOPPED: The sampling of energy detection has stopped
func (o *RADIO_Type) SetEVENTS_EDSTOPPED(value uint32) {
	volatile.StoreUint32(&o.EVENTS_EDSTOPPED.Reg, volatile.LoadUint32(&o.EVENTS_EDSTOPPED.Reg)&^(0x1)|value)
}
func (o *RADIO_Type) GetEVENTS_EDSTOPPED() uint32 {
	return volatile.LoadUint32(&o.EVENTS_EDSTOPPED.Reg) & 0x1
}

// RADIO.EVENTS_CCAIDLE: Wireless medium in idle - clear to send
func (o *RADIO_Type) SetEVENTS_CCAIDLE(value uint32) {
	volatile.StoreUint32(&o.EVENTS_CCAIDLE.Reg, volatile.LoadUint32(&o.EVENTS_CCAIDLE.Reg)&^(0x1)|value)
}
func (o *RADIO_Type) GetEVENTS_CCAIDLE() uint32 {
	return volatile.LoadUint32(&o.EVENTS_CCAIDLE.Reg) & 0x1
}

// RADIO.EVENTS_CCABUSY: Wireless medium busy - do not send
func (o *RADIO_Type) SetEVENTS_CCABUSY(value uint32) {
	volatile.StoreUint32(&o.EVENTS_CCABUSY.Reg, volatile.LoadUint32(&o.EVENTS_CCABUSY.Reg)&^(0x1)|value)
}
func (o *RADIO_Type) GetEVENTS_CCABUSY() uint32 {
	return volatile.LoadUint32(&o.EVENTS_CCABUSY.Reg) & 0x1
}

// RADIO.EVENTS_CCASTOPPED: The CCA has stopped
func (o *RADIO_Type) SetEVENTS_CCASTOPPED(value uint32) {
	volatile.StoreUint32(&o.EVENTS_CCASTOPPED.Reg, volatile.LoadUint32(&o.EVENTS_CCASTOPPED.Reg)&^(0x1)|value)
}
func (o *RADIO_Type) GetEVENTS_CCASTOPPED() uint32 {
	return volatile.LoadUint32(&o.EVENTS_CCASTOPPED.Reg) & 0x1
}

// RADIO.EVENTS_RATEBOOST: Ble_LR CI field received, receive mode is changed from Ble_LR125Kbit to Ble_LR500Kbit.
func (o *RADIO_Type) SetEVENTS_RATEBOOST(value uint32) {
	volatile.StoreUint32(&o.EVENTS_RATEBOOST.Reg, volatile.LoadUint32(&o.EVENTS_RATEBOOST.Reg)&^(0x1)|value)
}
func (o *RADIO_Type) GetEVENTS_RATEBOOST() uint32 {
	return volatile.LoadUint32(&o.EVENTS_RATEBOOST.Reg) & 0x1
}

// RADIO.EVENTS_TXREADY: RADIO has ramped up and is ready to be started TX path
func (o *RADIO_Type) SetEVENTS_TXREADY(value uint32) {
	volatile.StoreUint32(&o.EVENTS_TXREADY.Reg, volatile.LoadUint32(&o.EVENTS_TXREADY.Reg)&^(0x1)|value)
}
func (o *RADIO_Type) GetEVENTS_TXREADY() uint32 {
	return volatile.LoadUint32(&o.EVENTS_TXREADY.Reg) & 0x1
}

// RADIO.EVENTS_RXREADY: RADIO has ramped up and is ready to be started RX path
func (o *RADIO_Type) SetEVENTS_RXREADY(value uint32) {
	volatile.StoreUint32(&o.EVENTS_RXREADY.Reg, volatile.LoadUint32(&o.EVENTS_RXREADY.Reg)&^(0x1)|value)
}
func (o *RADIO_Type) GetEVENTS_RXREADY() uint32 {
	return volatile.LoadUint32(&o.EVENTS_RXREADY.Reg) & 0x1
}

// RADIO.EVENTS_MHRMATCH: MAC header match found
func (o *RADIO_Type) SetEVENTS_MHRMATCH(value uint32) {
	volatile.StoreUint32(&o.EVENTS_MHRMATCH.Reg, volatile.LoadUint32(&o.EVENTS_MHRMATCH.Reg)&^(0x1)|value)
}
func (o *RADIO_Type) GetEVENTS_MHRMATCH() uint32 {
	return volatile.LoadUint32(&o.EVENTS_MHRMATCH.Reg) & 0x1
}

// RADIO.EVENTS_SYNC: Preamble indicator
func (o *RADIO_Type) SetEVENTS_SYNC(value uint32) {
	volatile.StoreUint32(&o.EVENTS_SYNC.Reg, volatile.LoadUint32(&o.EVENTS_SYNC.Reg)&^(0x1)|value)
}
func (o *RADIO_Type) GetEVENTS_SYNC() uint32 {
	return volatile.LoadUint32(&o.EVENTS_SYNC.Reg) & 0x1
}

// RADIO.EVENTS_PHYEND: Generated when last bit is sent on air, or received from air
func (o *RADIO_Type) SetEVENTS_PHYEND(value uint32) {
	volatile.StoreUint32(&o.EVENTS_PHYEND.Reg, volatile.LoadUint32(&o.EVENTS_PHYEND.Reg)&^(0x1)|value)
}
func (o *RADIO_Type) GetEVENTS_PHYEND() uint32 {
	return volatile.LoadUint32(&o.EVENTS_PHYEND.Reg) & 0x1
}

// RADIO.EVENTS_CTEPRESENT: CTE is present (early warning right after receiving CTEInfo byte)
func (o *RADIO_Type) SetEVENTS_CTEPRESENT(value uint32) {
	volatile.StoreUint32(&o.EVENTS_CTEPRESENT.Reg, volatile.LoadUint32(&o.EVENTS_CTEPRESENT.Reg)&^(0x1)|value)
}
func (o *RADIO_Type) GetEVENTS_CTEPRESENT() uint32 {
	return volatile.LoadUint32(&o.EVENTS_CTEPRESENT.Reg) & 0x1
}

// RADIO.PUBLISH_READY: Publish configuration for event READY
func (o *RADIO_Type) SetPUBLISH_READY_CHIDX(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_READY.Reg, volatile.LoadUint32(&o.PUBLISH_READY.Reg)&^(0xff)|value)
}
func (o *RADIO_Type) GetPUBLISH_READY_CHIDX() uint32 {
	return volatile.LoadUint32(&o.PUBLISH_READY.Reg) & 0xff
}
func (o *RADIO_Type) SetPUBLISH_READY_EN(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_READY.Reg, volatile.LoadUint32(&o.PUBLISH_READY.Reg)&^(0x80000000)|value<<31)
}
func (o *RADIO_Type) GetPUBLISH_READY_EN() uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_READY.Reg) & 0x80000000) >> 31
}

// RADIO.PUBLISH_ADDRESS: Publish configuration for event ADDRESS
func (o *RADIO_Type) SetPUBLISH_ADDRESS_CHIDX(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_ADDRESS.Reg, volatile.LoadUint32(&o.PUBLISH_ADDRESS.Reg)&^(0xff)|value)
}
func (o *RADIO_Type) GetPUBLISH_ADDRESS_CHIDX() uint32 {
	return volatile.LoadUint32(&o.PUBLISH_ADDRESS.Reg) & 0xff
}
func (o *RADIO_Type) SetPUBLISH_ADDRESS_EN(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_ADDRESS.Reg, volatile.LoadUint32(&o.PUBLISH_ADDRESS.Reg)&^(0x80000000)|value<<31)
}
func (o *RADIO_Type) GetPUBLISH_ADDRESS_EN() uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_ADDRESS.Reg) & 0x80000000) >> 31
}

// RADIO.PUBLISH_PAYLOAD: Publish configuration for event PAYLOAD
func (o *RADIO_Type) SetPUBLISH_PAYLOAD_CHIDX(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_PAYLOAD.Reg, volatile.LoadUint32(&o.PUBLISH_PAYLOAD.Reg)&^(0xff)|value)
}
func (o *RADIO_Type) GetPUBLISH_PAYLOAD_CHIDX() uint32 {
	return volatile.LoadUint32(&o.PUBLISH_PAYLOAD.Reg) & 0xff
}
func (o *RADIO_Type) SetPUBLISH_PAYLOAD_EN(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_PAYLOAD.Reg, volatile.LoadUint32(&o.PUBLISH_PAYLOAD.Reg)&^(0x80000000)|value<<31)
}
func (o *RADIO_Type) GetPUBLISH_PAYLOAD_EN() uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_PAYLOAD.Reg) & 0x80000000) >> 31
}

// RADIO.PUBLISH_END: Publish configuration for event END
func (o *RADIO_Type) SetPUBLISH_END_CHIDX(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_END.Reg, volatile.LoadUint32(&o.PUBLISH_END.Reg)&^(0xff)|value)
}
func (o *RADIO_Type) GetPUBLISH_END_CHIDX() uint32 {
	return volatile.LoadUint32(&o.PUBLISH_END.Reg) & 0xff
}
func (o *RADIO_Type) SetPUBLISH_END_EN(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_END.Reg, volatile.LoadUint32(&o.PUBLISH_END.Reg)&^(0x80000000)|value<<31)
}
func (o *RADIO_Type) GetPUBLISH_END_EN() uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_END.Reg) & 0x80000000) >> 31
}

// RADIO.PUBLISH_DISABLED: Publish configuration for event DISABLED
func (o *RADIO_Type) SetPUBLISH_DISABLED_CHIDX(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_DISABLED.Reg, volatile.LoadUint32(&o.PUBLISH_DISABLED.Reg)&^(0xff)|value)
}
func (o *RADIO_Type) GetPUBLISH_DISABLED_CHIDX() uint32 {
	return volatile.LoadUint32(&o.PUBLISH_DISABLED.Reg) & 0xff
}
func (o *RADIO_Type) SetPUBLISH_DISABLED_EN(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_DISABLED.Reg, volatile.LoadUint32(&o.PUBLISH_DISABLED.Reg)&^(0x80000000)|value<<31)
}
func (o *RADIO_Type) GetPUBLISH_DISABLED_EN() uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_DISABLED.Reg) & 0x80000000) >> 31
}

// RADIO.PUBLISH_DEVMATCH: Publish configuration for event DEVMATCH
func (o *RADIO_Type) SetPUBLISH_DEVMATCH_CHIDX(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_DEVMATCH.Reg, volatile.LoadUint32(&o.PUBLISH_DEVMATCH.Reg)&^(0xff)|value)
}
func (o *RADIO_Type) GetPUBLISH_DEVMATCH_CHIDX() uint32 {
	return volatile.LoadUint32(&o.PUBLISH_DEVMATCH.Reg) & 0xff
}
func (o *RADIO_Type) SetPUBLISH_DEVMATCH_EN(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_DEVMATCH.Reg, volatile.LoadUint32(&o.PUBLISH_DEVMATCH.Reg)&^(0x80000000)|value<<31)
}
func (o *RADIO_Type) GetPUBLISH_DEVMATCH_EN() uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_DEVMATCH.Reg) & 0x80000000) >> 31
}

// RADIO.PUBLISH_DEVMISS: Publish configuration for event DEVMISS
func (o *RADIO_Type) SetPUBLISH_DEVMISS_CHIDX(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_DEVMISS.Reg, volatile.LoadUint32(&o.PUBLISH_DEVMISS.Reg)&^(0xff)|value)
}
func (o *RADIO_Type) GetPUBLISH_DEVMISS_CHIDX() uint32 {
	return volatile.LoadUint32(&o.PUBLISH_DEVMISS.Reg) & 0xff
}
func (o *RADIO_Type) SetPUBLISH_DEVMISS_EN(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_DEVMISS.Reg, volatile.LoadUint32(&o.PUBLISH_DEVMISS.Reg)&^(0x80000000)|value<<31)
}
func (o *RADIO_Type) GetPUBLISH_DEVMISS_EN() uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_DEVMISS.Reg) & 0x80000000) >> 31
}

// RADIO.PUBLISH_RSSIEND: Publish configuration for event RSSIEND
func (o *RADIO_Type) SetPUBLISH_RSSIEND_CHIDX(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_RSSIEND.Reg, volatile.LoadUint32(&o.PUBLISH_RSSIEND.Reg)&^(0xff)|value)
}
func (o *RADIO_Type) GetPUBLISH_RSSIEND_CHIDX() uint32 {
	return volatile.LoadUint32(&o.PUBLISH_RSSIEND.Reg) & 0xff
}
func (o *RADIO_Type) SetPUBLISH_RSSIEND_EN(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_RSSIEND.Reg, volatile.LoadUint32(&o.PUBLISH_RSSIEND.Reg)&^(0x80000000)|value<<31)
}
func (o *RADIO_Type) GetPUBLISH_RSSIEND_EN() uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_RSSIEND.Reg) & 0x80000000) >> 31
}

// RADIO.PUBLISH_BCMATCH: Publish configuration for event BCMATCH
func (o *RADIO_Type) SetPUBLISH_BCMATCH_CHIDX(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_BCMATCH.Reg, volatile.LoadUint32(&o.PUBLISH_BCMATCH.Reg)&^(0xff)|value)
}
func (o *RADIO_Type) GetPUBLISH_BCMATCH_CHIDX() uint32 {
	return volatile.LoadUint32(&o.PUBLISH_BCMATCH.Reg) & 0xff
}
func (o *RADIO_Type) SetPUBLISH_BCMATCH_EN(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_BCMATCH.Reg, volatile.LoadUint32(&o.PUBLISH_BCMATCH.Reg)&^(0x80000000)|value<<31)
}
func (o *RADIO_Type) GetPUBLISH_BCMATCH_EN() uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_BCMATCH.Reg) & 0x80000000) >> 31
}

// RADIO.PUBLISH_CRCOK: Publish configuration for event CRCOK
func (o *RADIO_Type) SetPUBLISH_CRCOK_CHIDX(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_CRCOK.Reg, volatile.LoadUint32(&o.PUBLISH_CRCOK.Reg)&^(0xff)|value)
}
func (o *RADIO_Type) GetPUBLISH_CRCOK_CHIDX() uint32 {
	return volatile.LoadUint32(&o.PUBLISH_CRCOK.Reg) & 0xff
}
func (o *RADIO_Type) SetPUBLISH_CRCOK_EN(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_CRCOK.Reg, volatile.LoadUint32(&o.PUBLISH_CRCOK.Reg)&^(0x80000000)|value<<31)
}
func (o *RADIO_Type) GetPUBLISH_CRCOK_EN() uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_CRCOK.Reg) & 0x80000000) >> 31
}

// RADIO.PUBLISH_CRCERROR: Publish configuration for event CRCERROR
func (o *RADIO_Type) SetPUBLISH_CRCERROR_CHIDX(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_CRCERROR.Reg, volatile.LoadUint32(&o.PUBLISH_CRCERROR.Reg)&^(0xff)|value)
}
func (o *RADIO_Type) GetPUBLISH_CRCERROR_CHIDX() uint32 {
	return volatile.LoadUint32(&o.PUBLISH_CRCERROR.Reg) & 0xff
}
func (o *RADIO_Type) SetPUBLISH_CRCERROR_EN(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_CRCERROR.Reg, volatile.LoadUint32(&o.PUBLISH_CRCERROR.Reg)&^(0x80000000)|value<<31)
}
func (o *RADIO_Type) GetPUBLISH_CRCERROR_EN() uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_CRCERROR.Reg) & 0x80000000) >> 31
}

// RADIO.PUBLISH_FRAMESTART: Publish configuration for event FRAMESTART
func (o *RADIO_Type) SetPUBLISH_FRAMESTART_CHIDX(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_FRAMESTART.Reg, volatile.LoadUint32(&o.PUBLISH_FRAMESTART.Reg)&^(0xff)|value)
}
func (o *RADIO_Type) GetPUBLISH_FRAMESTART_CHIDX() uint32 {
	return volatile.LoadUint32(&o.PUBLISH_FRAMESTART.Reg) & 0xff
}
func (o *RADIO_Type) SetPUBLISH_FRAMESTART_EN(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_FRAMESTART.Reg, volatile.LoadUint32(&o.PUBLISH_FRAMESTART.Reg)&^(0x80000000)|value<<31)
}
func (o *RADIO_Type) GetPUBLISH_FRAMESTART_EN() uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_FRAMESTART.Reg) & 0x80000000) >> 31
}

// RADIO.PUBLISH_EDEND: Publish configuration for event EDEND
func (o *RADIO_Type) SetPUBLISH_EDEND_CHIDX(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_EDEND.Reg, volatile.LoadUint32(&o.PUBLISH_EDEND.Reg)&^(0xff)|value)
}
func (o *RADIO_Type) GetPUBLISH_EDEND_CHIDX() uint32 {
	return volatile.LoadUint32(&o.PUBLISH_EDEND.Reg) & 0xff
}
func (o *RADIO_Type) SetPUBLISH_EDEND_EN(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_EDEND.Reg, volatile.LoadUint32(&o.PUBLISH_EDEND.Reg)&^(0x80000000)|value<<31)
}
func (o *RADIO_Type) GetPUBLISH_EDEND_EN() uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_EDEND.Reg) & 0x80000000) >> 31
}

// RADIO.PUBLISH_EDSTOPPED: Publish configuration for event EDSTOPPED
func (o *RADIO_Type) SetPUBLISH_EDSTOPPED_CHIDX(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_EDSTOPPED.Reg, volatile.LoadUint32(&o.PUBLISH_EDSTOPPED.Reg)&^(0xff)|value)
}
func (o *RADIO_Type) GetPUBLISH_EDSTOPPED_CHIDX() uint32 {
	return volatile.LoadUint32(&o.PUBLISH_EDSTOPPED.Reg) & 0xff
}
func (o *RADIO_Type) SetPUBLISH_EDSTOPPED_EN(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_EDSTOPPED.Reg, volatile.LoadUint32(&o.PUBLISH_EDSTOPPED.Reg)&^(0x80000000)|value<<31)
}
func (o *RADIO_Type) GetPUBLISH_EDSTOPPED_EN() uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_EDSTOPPED.Reg) & 0x80000000) >> 31
}

// RADIO.PUBLISH_CCAIDLE: Publish configuration for event CCAIDLE
func (o *RADIO_Type) SetPUBLISH_CCAIDLE_CHIDX(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_CCAIDLE.Reg, volatile.LoadUint32(&o.PUBLISH_CCAIDLE.Reg)&^(0xff)|value)
}
func (o *RADIO_Type) GetPUBLISH_CCAIDLE_CHIDX() uint32 {
	return volatile.LoadUint32(&o.PUBLISH_CCAIDLE.Reg) & 0xff
}
func (o *RADIO_Type) SetPUBLISH_CCAIDLE_EN(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_CCAIDLE.Reg, volatile.LoadUint32(&o.PUBLISH_CCAIDLE.Reg)&^(0x80000000)|value<<31)
}
func (o *RADIO_Type) GetPUBLISH_CCAIDLE_EN() uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_CCAIDLE.Reg) & 0x80000000) >> 31
}

// RADIO.PUBLISH_CCABUSY: Publish configuration for event CCABUSY
func (o *RADIO_Type) SetPUBLISH_CCABUSY_CHIDX(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_CCABUSY.Reg, volatile.LoadUint32(&o.PUBLISH_CCABUSY.Reg)&^(0xff)|value)
}
func (o *RADIO_Type) GetPUBLISH_CCABUSY_CHIDX() uint32 {
	return volatile.LoadUint32(&o.PUBLISH_CCABUSY.Reg) & 0xff
}
func (o *RADIO_Type) SetPUBLISH_CCABUSY_EN(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_CCABUSY.Reg, volatile.LoadUint32(&o.PUBLISH_CCABUSY.Reg)&^(0x80000000)|value<<31)
}
func (o *RADIO_Type) GetPUBLISH_CCABUSY_EN() uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_CCABUSY.Reg) & 0x80000000) >> 31
}

// RADIO.PUBLISH_CCASTOPPED: Publish configuration for event CCASTOPPED
func (o *RADIO_Type) SetPUBLISH_CCASTOPPED_CHIDX(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_CCASTOPPED.Reg, volatile.LoadUint32(&o.PUBLISH_CCASTOPPED.Reg)&^(0xff)|value)
}
func (o *RADIO_Type) GetPUBLISH_CCASTOPPED_CHIDX() uint32 {
	return volatile.LoadUint32(&o.PUBLISH_CCASTOPPED.Reg) & 0xff
}
func (o *RADIO_Type) SetPUBLISH_CCASTOPPED_EN(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_CCASTOPPED.Reg, volatile.LoadUint32(&o.PUBLISH_CCASTOPPED.Reg)&^(0x80000000)|value<<31)
}
func (o *RADIO_Type) GetPUBLISH_CCASTOPPED_EN() uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_CCASTOPPED.Reg) & 0x80000000) >> 31
}

// RADIO.PUBLISH_RATEBOOST: Publish configuration for event RATEBOOST
func (o *RADIO_Type) SetPUBLISH_RATEBOOST_CHIDX(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_RATEBOOST.Reg, volatile.LoadUint32(&o.PUBLISH_RATEBOOST.Reg)&^(0xff)|value)
}
func (o *RADIO_Type) GetPUBLISH_RATEBOOST_CHIDX() uint32 {
	return volatile.LoadUint32(&o.PUBLISH_RATEBOOST.Reg) & 0xff
}
func (o *RADIO_Type) SetPUBLISH_RATEBOOST_EN(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_RATEBOOST.Reg, volatile.LoadUint32(&o.PUBLISH_RATEBOOST.Reg)&^(0x80000000)|value<<31)
}
func (o *RADIO_Type) GetPUBLISH_RATEBOOST_EN() uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_RATEBOOST.Reg) & 0x80000000) >> 31
}

// RADIO.PUBLISH_TXREADY: Publish configuration for event TXREADY
func (o *RADIO_Type) SetPUBLISH_TXREADY_CHIDX(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_TXREADY.Reg, volatile.LoadUint32(&o.PUBLISH_TXREADY.Reg)&^(0xff)|value)
}
func (o *RADIO_Type) GetPUBLISH_TXREADY_CHIDX() uint32 {
	return volatile.LoadUint32(&o.PUBLISH_TXREADY.Reg) & 0xff
}
func (o *RADIO_Type) SetPUBLISH_TXREADY_EN(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_TXREADY.Reg, volatile.LoadUint32(&o.PUBLISH_TXREADY.Reg)&^(0x80000000)|value<<31)
}
func (o *RADIO_Type) GetPUBLISH_TXREADY_EN() uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_TXREADY.Reg) & 0x80000000) >> 31
}

// RADIO.PUBLISH_RXREADY: Publish configuration for event RXREADY
func (o *RADIO_Type) SetPUBLISH_RXREADY_CHIDX(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_RXREADY.Reg, volatile.LoadUint32(&o.PUBLISH_RXREADY.Reg)&^(0xff)|value)
}
func (o *RADIO_Type) GetPUBLISH_RXREADY_CHIDX() uint32 {
	return volatile.LoadUint32(&o.PUBLISH_RXREADY.Reg) & 0xff
}
func (o *RADIO_Type) SetPUBLISH_RXREADY_EN(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_RXREADY.Reg, volatile.LoadUint32(&o.PUBLISH_RXREADY.Reg)&^(0x80000000)|value<<31)
}
func (o *RADIO_Type) GetPUBLISH_RXREADY_EN() uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_RXREADY.Reg) & 0x80000000) >> 31
}

// RADIO.PUBLISH_MHRMATCH: Publish configuration for event MHRMATCH
func (o *RADIO_Type) SetPUBLISH_MHRMATCH_CHIDX(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_MHRMATCH.Reg, volatile.LoadUint32(&o.PUBLISH_MHRMATCH.Reg)&^(0xff)|value)
}
func (o *RADIO_Type) GetPUBLISH_MHRMATCH_CHIDX() uint32 {
	return volatile.LoadUint32(&o.PUBLISH_MHRMATCH.Reg) & 0xff
}
func (o *RADIO_Type) SetPUBLISH_MHRMATCH_EN(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_MHRMATCH.Reg, volatile.LoadUint32(&o.PUBLISH_MHRMATCH.Reg)&^(0x80000000)|value<<31)
}
func (o *RADIO_Type) GetPUBLISH_MHRMATCH_EN() uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_MHRMATCH.Reg) & 0x80000000) >> 31
}

// RADIO.PUBLISH_SYNC: Publish configuration for event SYNC
func (o *RADIO_Type) SetPUBLISH_SYNC_CHIDX(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_SYNC.Reg, volatile.LoadUint32(&o.PUBLISH_SYNC.Reg)&^(0xff)|value)
}
func (o *RADIO_Type) GetPUBLISH_SYNC_CHIDX() uint32 {
	return volatile.LoadUint32(&o.PUBLISH_SYNC.Reg) & 0xff
}
func (o *RADIO_Type) SetPUBLISH_SYNC_EN(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_SYNC.Reg, volatile.LoadUint32(&o.PUBLISH_SYNC.Reg)&^(0x80000000)|value<<31)
}
func (o *RADIO_Type) GetPUBLISH_SYNC_EN() uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_SYNC.Reg) & 0x80000000) >> 31
}

// RADIO.PUBLISH_PHYEND: Publish configuration for event PHYEND
func (o *RADIO_Type) SetPUBLISH_PHYEND_CHIDX(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_PHYEND.Reg, volatile.LoadUint32(&o.PUBLISH_PHYEND.Reg)&^(0xff)|value)
}
func (o *RADIO_Type) GetPUBLISH_PHYEND_CHIDX() uint32 {
	return volatile.LoadUint32(&o.PUBLISH_PHYEND.Reg) & 0xff
}
func (o *RADIO_Type) SetPUBLISH_PHYEND_EN(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_PHYEND.Reg, volatile.LoadUint32(&o.PUBLISH_PHYEND.Reg)&^(0x80000000)|value<<31)
}
func (o *RADIO_Type) GetPUBLISH_PHYEND_EN() uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_PHYEND.Reg) & 0x80000000) >> 31
}

// RADIO.PUBLISH_CTEPRESENT: Publish configuration for event CTEPRESENT
func (o *RADIO_Type) SetPUBLISH_CTEPRESENT_CHIDX(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_CTEPRESENT.Reg, volatile.LoadUint32(&o.PUBLISH_CTEPRESENT.Reg)&^(0xff)|value)
}
func (o *RADIO_Type) GetPUBLISH_CTEPRESENT_CHIDX() uint32 {
	return volatile.LoadUint32(&o.PUBLISH_CTEPRESENT.Reg) & 0xff
}
func (o *RADIO_Type) SetPUBLISH_CTEPRESENT_EN(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_CTEPRESENT.Reg, volatile.LoadUint32(&o.PUBLISH_CTEPRESENT.Reg)&^(0x80000000)|value<<31)
}
func (o *RADIO_Type) GetPUBLISH_CTEPRESENT_EN() uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_CTEPRESENT.Reg) & 0x80000000) >> 31
}

// RADIO.SHORTS: Shortcuts between local events and tasks
func (o *RADIO_Type) SetSHORTS_READY_START(value uint32) {
	volatile.StoreUint32(&o.SHORTS.Reg, volatile.LoadUint32(&o.SHORTS.Reg)&^(0x1)|value)
}
func (o *RADIO_Type) GetSHORTS_READY_START() uint32 {
	return volatile.LoadUint32(&o.SHORTS.Reg) & 0x1
}
func (o *RADIO_Type) SetSHORTS_END_DISABLE(value uint32) {
	volatile.StoreUint32(&o.SHORTS.Reg, volatile.LoadUint32(&o.SHORTS.Reg)&^(0x2)|value<<1)
}
func (o *RADIO_Type) GetSHORTS_END_DISABLE() uint32 {
	return (volatile.LoadUint32(&o.SHORTS.Reg) & 0x2) >> 1
}
func (o *RADIO_Type) SetSHORTS_DISABLED_TXEN(value uint32) {
	volatile.StoreUint32(&o.SHORTS.Reg, volatile.LoadUint32(&o.SHORTS.Reg)&^(0x4)|value<<2)
}
func (o *RADIO_Type) GetSHORTS_DISABLED_TXEN() uint32 {
	return (volatile.LoadUint32(&o.SHORTS.Reg) & 0x4) >> 2
}
func (o *RADIO_Type) SetSHORTS_DISABLED_RXEN(value uint32) {
	volatile.StoreUint32(&o.SHORTS.Reg, volatile.LoadUint32(&o.SHORTS.Reg)&^(0x8)|value<<3)
}
func (o *RADIO_Type) GetSHORTS_DISABLED_RXEN() uint32 {
	return (volatile.LoadUint32(&o.SHORTS.Reg) & 0x8) >> 3
}
func (o *RADIO_Type) SetSHORTS_ADDRESS_RSSISTART(value uint32) {
	volatile.StoreUint32(&o.SHORTS.Reg, volatile.LoadUint32(&o.SHORTS.Reg)&^(0x10)|value<<4)
}
func (o *RADIO_Type) GetSHORTS_ADDRESS_RSSISTART() uint32 {
	return (volatile.LoadUint32(&o.SHORTS.Reg) & 0x10) >> 4
}
func (o *RADIO_Type) SetSHORTS_END_START(value uint32) {
	volatile.StoreUint32(&o.SHORTS.Reg, volatile.LoadUint32(&o.SHORTS.Reg)&^(0x20)|value<<5)
}
func (o *RADIO_Type) GetSHORTS_END_START() uint32 {
	return (volatile.LoadUint32(&o.SHORTS.Reg) & 0x20) >> 5
}
func (o *RADIO_Type) SetSHORTS_ADDRESS_BCSTART(value uint32) {
	volatile.StoreUint32(&o.SHORTS.Reg, volatile.LoadUint32(&o.SHORTS.Reg)&^(0x40)|value<<6)
}
func (o *RADIO_Type) GetSHORTS_ADDRESS_BCSTART() uint32 {
	return (volatile.LoadUint32(&o.SHORTS.Reg) & 0x40) >> 6
}
func (o *RADIO_Type) SetSHORTS_DISABLED_RSSISTOP(value uint32) {
	volatile.StoreUint32(&o.SHORTS.Reg, volatile.LoadUint32(&o.SHORTS.Reg)&^(0x100)|value<<8)
}
func (o *RADIO_Type) GetSHORTS_DISABLED_RSSISTOP() uint32 {
	return (volatile.LoadUint32(&o.SHORTS.Reg) & 0x100) >> 8
}
func (o *RADIO_Type) SetSHORTS_RXREADY_CCASTART(value uint32) {
	volatile.StoreUint32(&o.SHORTS.Reg, volatile.LoadUint32(&o.SHORTS.Reg)&^(0x800)|value<<11)
}
func (o *RADIO_Type) GetSHORTS_RXREADY_CCASTART() uint32 {
	return (volatile.LoadUint32(&o.SHORTS.Reg) & 0x800) >> 11
}
func (o *RADIO_Type) SetSHORTS_CCAIDLE_TXEN(value uint32) {
	volatile.StoreUint32(&o.SHORTS.Reg, volatile.LoadUint32(&o.SHORTS.Reg)&^(0x1000)|value<<12)
}
func (o *RADIO_Type) GetSHORTS_CCAIDLE_TXEN() uint32 {
	return (volatile.LoadUint32(&o.SHORTS.Reg) & 0x1000) >> 12
}
func (o *RADIO_Type) SetSHORTS_CCABUSY_DISABLE(value uint32) {
	volatile.StoreUint32(&o.SHORTS.Reg, volatile.LoadUint32(&o.SHORTS.Reg)&^(0x2000)|value<<13)
}
func (o *RADIO_Type) GetSHORTS_CCABUSY_DISABLE() uint32 {
	return (volatile.LoadUint32(&o.SHORTS.Reg) & 0x2000) >> 13
}
func (o *RADIO_Type) SetSHORTS_FRAMESTART_BCSTART(value uint32) {
	volatile.StoreUint32(&o.SHORTS.Reg, volatile.LoadUint32(&o.SHORTS.Reg)&^(0x4000)|value<<14)
}
func (o *RADIO_Type) GetSHORTS_FRAMESTART_BCSTART() uint32 {
	return (volatile.LoadUint32(&o.SHORTS.Reg) & 0x4000) >> 14
}
func (o *RADIO_Type) SetSHORTS_READY_EDSTART(value uint32) {
	volatile.StoreUint32(&o.SHORTS.Reg, volatile.LoadUint32(&o.SHORTS.Reg)&^(0x8000)|value<<15)
}
func (o *RADIO_Type) GetSHORTS_READY_EDSTART() uint32 {
	return (volatile.LoadUint32(&o.SHORTS.Reg) & 0x8000) >> 15
}
func (o *RADIO_Type) SetSHORTS_EDEND_DISABLE(value uint32) {
	volatile.StoreUint32(&o.SHORTS.Reg, volatile.LoadUint32(&o.SHORTS.Reg)&^(0x10000)|value<<16)
}
func (o *RADIO_Type) GetSHORTS_EDEND_DISABLE() uint32 {
	return (volatile.LoadUint32(&o.SHORTS.Reg) & 0x10000) >> 16
}
func (o *RADIO_Type) SetSHORTS_CCAIDLE_STOP(value uint32) {
	volatile.StoreUint32(&o.SHORTS.Reg, volatile.LoadUint32(&o.SHORTS.Reg)&^(0x20000)|value<<17)
}
func (o *RADIO_Type) GetSHORTS_CCAIDLE_STOP() uint32 {
	return (volatile.LoadUint32(&o.SHORTS.Reg) & 0x20000) >> 17
}
func (o *RADIO_Type) SetSHORTS_TXREADY_START(value uint32) {
	volatile.StoreUint32(&o.SHORTS.Reg, volatile.LoadUint32(&o.SHORTS.Reg)&^(0x40000)|value<<18)
}
func (o *RADIO_Type) GetSHORTS_TXREADY_START() uint32 {
	return (volatile.LoadUint32(&o.SHORTS.Reg) & 0x40000) >> 18
}
func (o *RADIO_Type) SetSHORTS_RXREADY_START(value uint32) {
	volatile.StoreUint32(&o.SHORTS.Reg, volatile.LoadUint32(&o.SHORTS.Reg)&^(0x80000)|value<<19)
}
func (o *RADIO_Type) GetSHORTS_RXREADY_START() uint32 {
	return (volatile.LoadUint32(&o.SHORTS.Reg) & 0x80000) >> 19
}
func (o *RADIO_Type) SetSHORTS_PHYEND_DISABLE(value uint32) {
	volatile.StoreUint32(&o.SHORTS.Reg, volatile.LoadUint32(&o.SHORTS.Reg)&^(0x100000)|value<<20)
}
func (o *RADIO_Type) GetSHORTS_PHYEND_DISABLE() uint32 {
	return (volatile.LoadUint32(&o.SHORTS.Reg) & 0x100000) >> 20
}
func (o *RADIO_Type) SetSHORTS_PHYEND_START(value uint32) {
	volatile.StoreUint32(&o.SHORTS.Reg, volatile.LoadUint32(&o.SHORTS.Reg)&^(0x200000)|value<<21)
}
func (o *RADIO_Type) GetSHORTS_PHYEND_START() uint32 {
	return (volatile.LoadUint32(&o.SHORTS.Reg) & 0x200000) >> 21
}

// RADIO.INTENSET: Enable interrupt
func (o *RADIO_Type) SetINTENSET_READY(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x1)|value)
}
func (o *RADIO_Type) GetINTENSET_READY() uint32 {
	return volatile.LoadUint32(&o.INTENSET.Reg) & 0x1
}
func (o *RADIO_Type) SetINTENSET_ADDRESS(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x2)|value<<1)
}
func (o *RADIO_Type) GetINTENSET_ADDRESS() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x2) >> 1
}
func (o *RADIO_Type) SetINTENSET_PAYLOAD(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x4)|value<<2)
}
func (o *RADIO_Type) GetINTENSET_PAYLOAD() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x4) >> 2
}
func (o *RADIO_Type) SetINTENSET_END(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x8)|value<<3)
}
func (o *RADIO_Type) GetINTENSET_END() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x8) >> 3
}
func (o *RADIO_Type) SetINTENSET_DISABLED(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x10)|value<<4)
}
func (o *RADIO_Type) GetINTENSET_DISABLED() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x10) >> 4
}
func (o *RADIO_Type) SetINTENSET_DEVMATCH(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x20)|value<<5)
}
func (o *RADIO_Type) GetINTENSET_DEVMATCH() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x20) >> 5
}
func (o *RADIO_Type) SetINTENSET_DEVMISS(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x40)|value<<6)
}
func (o *RADIO_Type) GetINTENSET_DEVMISS() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x40) >> 6
}
func (o *RADIO_Type) SetINTENSET_RSSIEND(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x80)|value<<7)
}
func (o *RADIO_Type) GetINTENSET_RSSIEND() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x80) >> 7
}
func (o *RADIO_Type) SetINTENSET_BCMATCH(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x400)|value<<10)
}
func (o *RADIO_Type) GetINTENSET_BCMATCH() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x400) >> 10
}
func (o *RADIO_Type) SetINTENSET_CRCOK(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x1000)|value<<12)
}
func (o *RADIO_Type) GetINTENSET_CRCOK() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x1000) >> 12
}
func (o *RADIO_Type) SetINTENSET_CRCERROR(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x2000)|value<<13)
}
func (o *RADIO_Type) GetINTENSET_CRCERROR() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x2000) >> 13
}
func (o *RADIO_Type) SetINTENSET_FRAMESTART(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x4000)|value<<14)
}
func (o *RADIO_Type) GetINTENSET_FRAMESTART() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x4000) >> 14
}
func (o *RADIO_Type) SetINTENSET_EDEND(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x8000)|value<<15)
}
func (o *RADIO_Type) GetINTENSET_EDEND() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x8000) >> 15
}
func (o *RADIO_Type) SetINTENSET_EDSTOPPED(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x10000)|value<<16)
}
func (o *RADIO_Type) GetINTENSET_EDSTOPPED() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x10000) >> 16
}
func (o *RADIO_Type) SetINTENSET_CCAIDLE(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x20000)|value<<17)
}
func (o *RADIO_Type) GetINTENSET_CCAIDLE() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x20000) >> 17
}
func (o *RADIO_Type) SetINTENSET_CCABUSY(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x40000)|value<<18)
}
func (o *RADIO_Type) GetINTENSET_CCABUSY() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x40000) >> 18
}
func (o *RADIO_Type) SetINTENSET_CCASTOPPED(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x80000)|value<<19)
}
func (o *RADIO_Type) GetINTENSET_CCASTOPPED() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x80000) >> 19
}
func (o *RADIO_Type) SetINTENSET_RATEBOOST(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x100000)|value<<20)
}
func (o *RADIO_Type) GetINTENSET_RATEBOOST() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x100000) >> 20
}
func (o *RADIO_Type) SetINTENSET_TXREADY(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x200000)|value<<21)
}
func (o *RADIO_Type) GetINTENSET_TXREADY() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x200000) >> 21
}
func (o *RADIO_Type) SetINTENSET_RXREADY(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x400000)|value<<22)
}
func (o *RADIO_Type) GetINTENSET_RXREADY() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x400000) >> 22
}
func (o *RADIO_Type) SetINTENSET_MHRMATCH(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x800000)|value<<23)
}
func (o *RADIO_Type) GetINTENSET_MHRMATCH() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x800000) >> 23
}
func (o *RADIO_Type) SetINTENSET_SYNC(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x4000000)|value<<26)
}
func (o *RADIO_Type) GetINTENSET_SYNC() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x4000000) >> 26
}
func (o *RADIO_Type) SetINTENSET_PHYEND(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x8000000)|value<<27)
}
func (o *RADIO_Type) GetINTENSET_PHYEND() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x8000000) >> 27
}
func (o *RADIO_Type) SetINTENSET_CTEPRESENT(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x10000000)|value<<28)
}
func (o *RADIO_Type) GetINTENSET_CTEPRESENT() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x10000000) >> 28
}

// RADIO.INTENCLR: Disable interrupt
func (o *RADIO_Type) SetINTENCLR_READY(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x1)|value)
}
func (o *RADIO_Type) GetINTENCLR_READY() uint32 {
	return volatile.LoadUint32(&o.INTENCLR.Reg) & 0x1
}
func (o *RADIO_Type) SetINTENCLR_ADDRESS(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x2)|value<<1)
}
func (o *RADIO_Type) GetINTENCLR_ADDRESS() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x2) >> 1
}
func (o *RADIO_Type) SetINTENCLR_PAYLOAD(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x4)|value<<2)
}
func (o *RADIO_Type) GetINTENCLR_PAYLOAD() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x4) >> 2
}
func (o *RADIO_Type) SetINTENCLR_END(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x8)|value<<3)
}
func (o *RADIO_Type) GetINTENCLR_END() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x8) >> 3
}
func (o *RADIO_Type) SetINTENCLR_DISABLED(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x10)|value<<4)
}
func (o *RADIO_Type) GetINTENCLR_DISABLED() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x10) >> 4
}
func (o *RADIO_Type) SetINTENCLR_DEVMATCH(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x20)|value<<5)
}
func (o *RADIO_Type) GetINTENCLR_DEVMATCH() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x20) >> 5
}
func (o *RADIO_Type) SetINTENCLR_DEVMISS(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x40)|value<<6)
}
func (o *RADIO_Type) GetINTENCLR_DEVMISS() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x40) >> 6
}
func (o *RADIO_Type) SetINTENCLR_RSSIEND(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x80)|value<<7)
}
func (o *RADIO_Type) GetINTENCLR_RSSIEND() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x80) >> 7
}
func (o *RADIO_Type) SetINTENCLR_BCMATCH(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x400)|value<<10)
}
func (o *RADIO_Type) GetINTENCLR_BCMATCH() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x400) >> 10
}
func (o *RADIO_Type) SetINTENCLR_CRCOK(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x1000)|value<<12)
}
func (o *RADIO_Type) GetINTENCLR_CRCOK() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x1000) >> 12
}
func (o *RADIO_Type) SetINTENCLR_CRCERROR(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x2000)|value<<13)
}
func (o *RADIO_Type) GetINTENCLR_CRCERROR() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x2000) >> 13
}
func (o *RADIO_Type) SetINTENCLR_FRAMESTART(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x4000)|value<<14)
}
func (o *RADIO_Type) GetINTENCLR_FRAMESTART() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x4000) >> 14
}
func (o *RADIO_Type) SetINTENCLR_EDEND(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x8000)|value<<15)
}
func (o *RADIO_Type) GetINTENCLR_EDEND() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x8000) >> 15
}
func (o *RADIO_Type) SetINTENCLR_EDSTOPPED(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x10000)|value<<16)
}
func (o *RADIO_Type) GetINTENCLR_EDSTOPPED() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x10000) >> 16
}
func (o *RADIO_Type) SetINTENCLR_CCAIDLE(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x20000)|value<<17)
}
func (o *RADIO_Type) GetINTENCLR_CCAIDLE() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x20000) >> 17
}
func (o *RADIO_Type) SetINTENCLR_CCABUSY(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x40000)|value<<18)
}
func (o *RADIO_Type) GetINTENCLR_CCABUSY() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x40000) >> 18
}
func (o *RADIO_Type) SetINTENCLR_CCASTOPPED(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x80000)|value<<19)
}
func (o *RADIO_Type) GetINTENCLR_CCASTOPPED() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x80000) >> 19
}
func (o *RADIO_Type) SetINTENCLR_RATEBOOST(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x100000)|value<<20)
}
func (o *RADIO_Type) GetINTENCLR_RATEBOOST() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x100000) >> 20
}
func (o *RADIO_Type) SetINTENCLR_TXREADY(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x200000)|value<<21)
}
func (o *RADIO_Type) GetINTENCLR_TXREADY() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x200000) >> 21
}
func (o *RADIO_Type) SetINTENCLR_RXREADY(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x400000)|value<<22)
}
func (o *RADIO_Type) GetINTENCLR_RXREADY() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x400000) >> 22
}
func (o *RADIO_Type) SetINTENCLR_MHRMATCH(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x800000)|value<<23)
}
func (o *RADIO_Type) GetINTENCLR_MHRMATCH() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x800000) >> 23
}
func (o *RADIO_Type) SetINTENCLR_SYNC(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x4000000)|value<<26)
}
func (o *RADIO_Type) GetINTENCLR_SYNC() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x4000000) >> 26
}
func (o *RADIO_Type) SetINTENCLR_PHYEND(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x8000000)|value<<27)
}
func (o *RADIO_Type) GetINTENCLR_PHYEND() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x8000000) >> 27
}
func (o *RADIO_Type) SetINTENCLR_CTEPRESENT(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x10000000)|value<<28)
}
func (o *RADIO_Type) GetINTENCLR_CTEPRESENT() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x10000000) >> 28
}

// RADIO.CRCSTATUS: CRC status
func (o *RADIO_Type) SetCRCSTATUS(value uint32) {
	volatile.StoreUint32(&o.CRCSTATUS.Reg, volatile.LoadUint32(&o.CRCSTATUS.Reg)&^(0x1)|value)
}
func (o *RADIO_Type) GetCRCSTATUS() uint32 {
	return volatile.LoadUint32(&o.CRCSTATUS.Reg) & 0x1
}

// RADIO.RXMATCH: Received address
func (o *RADIO_Type) SetRXMATCH(value uint32) {
	volatile.StoreUint32(&o.RXMATCH.Reg, volatile.LoadUint32(&o.RXMATCH.Reg)&^(0x7)|value)
}
func (o *RADIO_Type) GetRXMATCH() uint32 {
	return volatile.LoadUint32(&o.RXMATCH.Reg) & 0x7
}

// RADIO.RXCRC: CRC field of previously received packet
func (o *RADIO_Type) SetRXCRC(value uint32) {
	volatile.StoreUint32(&o.RXCRC.Reg, volatile.LoadUint32(&o.RXCRC.Reg)&^(0xffffff)|value)
}
func (o *RADIO_Type) GetRXCRC() uint32 {
	return volatile.LoadUint32(&o.RXCRC.Reg) & 0xffffff
}

// RADIO.DAI: Device address match index
func (o *RADIO_Type) SetDAI(value uint32) {
	volatile.StoreUint32(&o.DAI.Reg, volatile.LoadUint32(&o.DAI.Reg)&^(0x7)|value)
}
func (o *RADIO_Type) GetDAI() uint32 {
	return volatile.LoadUint32(&o.DAI.Reg) & 0x7
}

// RADIO.PDUSTAT: Payload status
func (o *RADIO_Type) SetPDUSTAT(value uint32) {
	volatile.StoreUint32(&o.PDUSTAT.Reg, volatile.LoadUint32(&o.PDUSTAT.Reg)&^(0x1)|value)
}
func (o *RADIO_Type) GetPDUSTAT() uint32 {
	return volatile.LoadUint32(&o.PDUSTAT.Reg) & 0x1
}
func (o *RADIO_Type) SetPDUSTAT_CISTAT(value uint32) {
	volatile.StoreUint32(&o.PDUSTAT.Reg, volatile.LoadUint32(&o.PDUSTAT.Reg)&^(0x6)|value<<1)
}
func (o *RADIO_Type) GetPDUSTAT_CISTAT() uint32 {
	return (volatile.LoadUint32(&o.PDUSTAT.Reg) & 0x6) >> 1
}

// RADIO.CTESTATUS: CTEInfo parsed from received packet
func (o *RADIO_Type) SetCTESTATUS_CTETIME(value uint32) {
	volatile.StoreUint32(&o.CTESTATUS.Reg, volatile.LoadUint32(&o.CTESTATUS.Reg)&^(0x1f)|value)
}
func (o *RADIO_Type) GetCTESTATUS_CTETIME() uint32 {
	return volatile.LoadUint32(&o.CTESTATUS.Reg) & 0x1f
}
func (o *RADIO_Type) SetCTESTATUS_RFU(value uint32) {
	volatile.StoreUint32(&o.CTESTATUS.Reg, volatile.LoadUint32(&o.CTESTATUS.Reg)&^(0x20)|value<<5)
}
func (o *RADIO_Type) GetCTESTATUS_RFU() uint32 {
	return (volatile.LoadUint32(&o.CTESTATUS.Reg) & 0x20) >> 5
}
func (o *RADIO_Type) SetCTESTATUS_CTETYPE(value uint32) {
	volatile.StoreUint32(&o.CTESTATUS.Reg, volatile.LoadUint32(&o.CTESTATUS.Reg)&^(0xc0)|value<<6)
}
func (o *RADIO_Type) GetCTESTATUS_CTETYPE() uint32 {
	return (volatile.LoadUint32(&o.CTESTATUS.Reg) & 0xc0) >> 6
}

// RADIO.DFESTATUS: DFE status information
func (o *RADIO_Type) SetDFESTATUS_SWITCHINGSTATE(value uint32) {
	volatile.StoreUint32(&o.DFESTATUS.Reg, volatile.LoadUint32(&o.DFESTATUS.Reg)&^(0x7)|value)
}
func (o *RADIO_Type) GetDFESTATUS_SWITCHINGSTATE() uint32 {
	return volatile.LoadUint32(&o.DFESTATUS.Reg) & 0x7
}
func (o *RADIO_Type) SetDFESTATUS_SAMPLINGSTATE(value uint32) {
	volatile.StoreUint32(&o.DFESTATUS.Reg, volatile.LoadUint32(&o.DFESTATUS.Reg)&^(0x10)|value<<4)
}
func (o *RADIO_Type) GetDFESTATUS_SAMPLINGSTATE() uint32 {
	return (volatile.LoadUint32(&o.DFESTATUS.Reg) & 0x10) >> 4
}

// RADIO.PACKETPTR: Packet pointer
func (o *RADIO_Type) SetPACKETPTR(value uint32) {
	volatile.StoreUint32(&o.PACKETPTR.Reg, value)
}
func (o *RADIO_Type) GetPACKETPTR() uint32 {
	return volatile.LoadUint32(&o.PACKETPTR.Reg)
}

// RADIO.FREQUENCY: Frequency
func (o *RADIO_Type) SetFREQUENCY(value uint32) {
	volatile.StoreUint32(&o.FREQUENCY.Reg, volatile.LoadUint32(&o.FREQUENCY.Reg)&^(0x7f)|value)
}
func (o *RADIO_Type) GetFREQUENCY() uint32 {
	return volatile.LoadUint32(&o.FREQUENCY.Reg) & 0x7f
}
func (o *RADIO_Type) SetFREQUENCY_MAP(value uint32) {
	volatile.StoreUint32(&o.FREQUENCY.Reg, volatile.LoadUint32(&o.FREQUENCY.Reg)&^(0x100)|value<<8)
}
func (o *RADIO_Type) GetFREQUENCY_MAP() uint32 {
	return (volatile.LoadUint32(&o.FREQUENCY.Reg) & 0x100) >> 8
}

// RADIO.TXPOWER: Output power
func (o *RADIO_Type) SetTXPOWER(value uint32) {
	volatile.StoreUint32(&o.TXPOWER.Reg, volatile.LoadUint32(&o.TXPOWER.Reg)&^(0xff)|value)
}
func (o *RADIO_Type) GetTXPOWER() uint32 {
	return volatile.LoadUint32(&o.TXPOWER.Reg) & 0xff
}

// RADIO.MODE: Data rate and modulation
func (o *RADIO_Type) SetMODE(value uint32) {
	volatile.StoreUint32(&o.MODE.Reg, volatile.LoadUint32(&o.MODE.Reg)&^(0xf)|value)
}
func (o *RADIO_Type) GetMODE() uint32 {
	return volatile.LoadUint32(&o.MODE.Reg) & 0xf
}

// RADIO.PCNF0: Packet configuration register 0
func (o *RADIO_Type) SetPCNF0_LFLEN(value uint32) {
	volatile.StoreUint32(&o.PCNF0.Reg, volatile.LoadUint32(&o.PCNF0.Reg)&^(0xf)|value)
}
func (o *RADIO_Type) GetPCNF0_LFLEN() uint32 {
	return volatile.LoadUint32(&o.PCNF0.Reg) & 0xf
}
func (o *RADIO_Type) SetPCNF0_S0LEN(value uint32) {
	volatile.StoreUint32(&o.PCNF0.Reg, volatile.LoadUint32(&o.PCNF0.Reg)&^(0x100)|value<<8)
}
func (o *RADIO_Type) GetPCNF0_S0LEN() uint32 {
	return (volatile.LoadUint32(&o.PCNF0.Reg) & 0x100) >> 8
}
func (o *RADIO_Type) SetPCNF0_S1LEN(value uint32) {
	volatile.StoreUint32(&o.PCNF0.Reg, volatile.LoadUint32(&o.PCNF0.Reg)&^(0xf0000)|value<<16)
}
func (o *RADIO_Type) GetPCNF0_S1LEN() uint32 {
	return (volatile.LoadUint32(&o.PCNF0.Reg) & 0xf0000) >> 16
}
func (o *RADIO_Type) SetPCNF0_S1INCL(value uint32) {
	volatile.StoreUint32(&o.PCNF0.Reg, volatile.LoadUint32(&o.PCNF0.Reg)&^(0x100000)|value<<20)
}
func (o *RADIO_Type) GetPCNF0_S1INCL() uint32 {
	return (volatile.LoadUint32(&o.PCNF0.Reg) & 0x100000) >> 20
}
func (o *RADIO_Type) SetPCNF0_CILEN(value uint32) {
	volatile.StoreUint32(&o.PCNF0.Reg, volatile.LoadUint32(&o.PCNF0.Reg)&^(0xc00000)|value<<22)
}
func (o *RADIO_Type) GetPCNF0_CILEN() uint32 {
	return (volatile.LoadUint32(&o.PCNF0.Reg) & 0xc00000) >> 22
}
func (o *RADIO_Type) SetPCNF0_PLEN(value uint32) {
	volatile.StoreUint32(&o.PCNF0.Reg, volatile.LoadUint32(&o.PCNF0.Reg)&^(0x3000000)|value<<24)
}
func (o *RADIO_Type) GetPCNF0_PLEN() uint32 {
	return (volatile.LoadUint32(&o.PCNF0.Reg) & 0x3000000) >> 24
}
func (o *RADIO_Type) SetPCNF0_CRCINC(value uint32) {
	volatile.StoreUint32(&o.PCNF0.Reg, volatile.LoadUint32(&o.PCNF0.Reg)&^(0x4000000)|value<<26)
}
func (o *RADIO_Type) GetPCNF0_CRCINC() uint32 {
	return (volatile.LoadUint32(&o.PCNF0.Reg) & 0x4000000) >> 26
}
func (o *RADIO_Type) SetPCNF0_TERMLEN(value uint32) {
	volatile.StoreUint32(&o.PCNF0.Reg, volatile.LoadUint32(&o.PCNF0.Reg)&^(0x60000000)|value<<29)
}
func (o *RADIO_Type) GetPCNF0_TERMLEN() uint32 {
	return (volatile.LoadUint32(&o.PCNF0.Reg) & 0x60000000) >> 29
}

// RADIO.PCNF1: Packet configuration register 1
func (o *RADIO_Type) SetPCNF1_MAXLEN(value uint32) {
	volatile.StoreUint32(&o.PCNF1.Reg, volatile.LoadUint32(&o.PCNF1.Reg)&^(0xff)|value)
}
func (o *RADIO_Type) GetPCNF1_MAXLEN() uint32 {
	return volatile.LoadUint32(&o.PCNF1.Reg) & 0xff
}
func (o *RADIO_Type) SetPCNF1_STATLEN(value uint32) {
	volatile.StoreUint32(&o.PCNF1.Reg, volatile.LoadUint32(&o.PCNF1.Reg)&^(0xff00)|value<<8)
}
func (o *RADIO_Type) GetPCNF1_STATLEN() uint32 {
	return (volatile.LoadUint32(&o.PCNF1.Reg) & 0xff00) >> 8
}
func (o *RADIO_Type) SetPCNF1_BALEN(value uint32) {
	volatile.StoreUint32(&o.PCNF1.Reg, volatile.LoadUint32(&o.PCNF1.Reg)&^(0x70000)|value<<16)
}
func (o *RADIO_Type) GetPCNF1_BALEN() uint32 {
	return (volatile.LoadUint32(&o.PCNF1.Reg) & 0x70000) >> 16
}
func (o *RADIO_Type) SetPCNF1_ENDIAN(value uint32) {
	volatile.StoreUint32(&o.PCNF1.Reg, volatile.LoadUint32(&o.PCNF1.Reg)&^(0x1000000)|value<<24)
}
func (o *RADIO_Type) GetPCNF1_ENDIAN() uint32 {
	return (volatile.LoadUint32(&o.PCNF1.Reg) & 0x1000000) >> 24
}
func (o *RADIO_Type) SetPCNF1_WHITEEN(value uint32) {
	volatile.StoreUint32(&o.PCNF1.Reg, volatile.LoadUint32(&o.PCNF1.Reg)&^(0x2000000)|value<<25)
}
func (o *RADIO_Type) GetPCNF1_WHITEEN() uint32 {
	return (volatile.LoadUint32(&o.PCNF1.Reg) & 0x2000000) >> 25
}

// RADIO.BASE0: Base address 0
func (o *RADIO_Type) SetBASE0(value uint32) {
	volatile.StoreUint32(&o.BASE0.Reg, value)
}
func (o *RADIO_Type) GetBASE0() uint32 {
	return volatile.LoadUint32(&o.BASE0.Reg)
}

// RADIO.BASE1: Base address 1
func (o *RADIO_Type) SetBASE1(value uint32) {
	volatile.StoreUint32(&o.BASE1.Reg, value)
}
func (o *RADIO_Type) GetBASE1() uint32 {
	return volatile.LoadUint32(&o.BASE1.Reg)
}

// RADIO.PREFIX0: Prefixes bytes for logical addresses 0-3
func (o *RADIO_Type) SetPREFIX0_AP0(value uint32) {
	volatile.StoreUint32(&o.PREFIX0.Reg, volatile.LoadUint32(&o.PREFIX0.Reg)&^(0xff)|value)
}
func (o *RADIO_Type) GetPREFIX0_AP0() uint32 {
	return volatile.LoadUint32(&o.PREFIX0.Reg) & 0xff
}
func (o *RADIO_Type) SetPREFIX0_AP1(value uint32) {
	volatile.StoreUint32(&o.PREFIX0.Reg, volatile.LoadUint32(&o.PREFIX0.Reg)&^(0xff00)|value<<8)
}
func (o *RADIO_Type) GetPREFIX0_AP1() uint32 {
	return (volatile.LoadUint32(&o.PREFIX0.Reg) & 0xff00) >> 8
}
func (o *RADIO_Type) SetPREFIX0_AP2(value uint32) {
	volatile.StoreUint32(&o.PREFIX0.Reg, volatile.LoadUint32(&o.PREFIX0.Reg)&^(0xff0000)|value<<16)
}
func (o *RADIO_Type) GetPREFIX0_AP2() uint32 {
	return (volatile.LoadUint32(&o.PREFIX0.Reg) & 0xff0000) >> 16
}
func (o *RADIO_Type) SetPREFIX0_AP3(value uint32) {
	volatile.StoreUint32(&o.PREFIX0.Reg, volatile.LoadUint32(&o.PREFIX0.Reg)&^(0xff000000)|value<<24)
}
func (o *RADIO_Type) GetPREFIX0_AP3() uint32 {
	return (volatile.LoadUint32(&o.PREFIX0.Reg) & 0xff000000) >> 24
}

// RADIO.PREFIX1: Prefixes bytes for logical addresses 4-7
func (o *RADIO_Type) SetPREFIX1_AP4(value uint32) {
	volatile.StoreUint32(&o.PREFIX1.Reg, volatile.LoadUint32(&o.PREFIX1.Reg)&^(0xff)|value)
}
func (o *RADIO_Type) GetPREFIX1_AP4() uint32 {
	return volatile.LoadUint32(&o.PREFIX1.Reg) & 0xff
}
func (o *RADIO_Type) SetPREFIX1_AP5(value uint32) {
	volatile.StoreUint32(&o.PREFIX1.Reg, volatile.LoadUint32(&o.PREFIX1.Reg)&^(0xff00)|value<<8)
}
func (o *RADIO_Type) GetPREFIX1_AP5() uint32 {
	return (volatile.LoadUint32(&o.PREFIX1.Reg) & 0xff00) >> 8
}
func (o *RADIO_Type) SetPREFIX1_AP6(value uint32) {
	volatile.StoreUint32(&o.PREFIX1.Reg, volatile.LoadUint32(&o.PREFIX1.Reg)&^(0xff0000)|value<<16)
}
func (o *RADIO_Type) GetPREFIX1_AP6() uint32 {
	return (volatile.LoadUint32(&o.PREFIX1.Reg) & 0xff0000) >> 16
}
func (o *RADIO_Type) SetPREFIX1_AP7(value uint32) {
	volatile.StoreUint32(&o.PREFIX1.Reg, volatile.LoadUint32(&o.PREFIX1.Reg)&^(0xff000000)|value<<24)
}
func (o *RADIO_Type) GetPREFIX1_AP7() uint32 {
	return (volatile.LoadUint32(&o.PREFIX1.Reg) & 0xff000000) >> 24
}

// RADIO.TXADDRESS: Transmit address select
func (o *RADIO_Type) SetTXADDRESS(value uint32) {
	volatile.StoreUint32(&o.TXADDRESS.Reg, volatile.LoadUint32(&o.TXADDRESS.Reg)&^(0x7)|value)
}
func (o *RADIO_Type) GetTXADDRESS() uint32 {
	return volatile.LoadUint32(&o.TXADDRESS.Reg) & 0x7
}

// RADIO.RXADDRESSES: Receive address select
func (o *RADIO_Type) SetRXADDRESSES_ADDR0(value uint32) {
	volatile.StoreUint32(&o.RXADDRESSES.Reg, volatile.LoadUint32(&o.RXADDRESSES.Reg)&^(0x1)|value)
}
func (o *RADIO_Type) GetRXADDRESSES_ADDR0() uint32 {
	return volatile.LoadUint32(&o.RXADDRESSES.Reg) & 0x1
}
func (o *RADIO_Type) SetRXADDRESSES_ADDR1(value uint32) {
	volatile.StoreUint32(&o.RXADDRESSES.Reg, volatile.LoadUint32(&o.RXADDRESSES.Reg)&^(0x2)|value<<1)
}
func (o *RADIO_Type) GetRXADDRESSES_ADDR1() uint32 {
	return (volatile.LoadUint32(&o.RXADDRESSES.Reg) & 0x2) >> 1
}
func (o *RADIO_Type) SetRXADDRESSES_ADDR2(value uint32) {
	volatile.StoreUint32(&o.RXADDRESSES.Reg, volatile.LoadUint32(&o.RXADDRESSES.Reg)&^(0x4)|value<<2)
}
func (o *RADIO_Type) GetRXADDRESSES_ADDR2() uint32 {
	return (volatile.LoadUint32(&o.RXADDRESSES.Reg) & 0x4) >> 2
}
func (o *RADIO_Type) SetRXADDRESSES_ADDR3(value uint32) {
	volatile.StoreUint32(&o.RXADDRESSES.Reg, volatile.LoadUint32(&o.RXADDRESSES.Reg)&^(0x8)|value<<3)
}
func (o *RADIO_Type) GetRXADDRESSES_ADDR3() uint32 {
	return (volatile.LoadUint32(&o.RXADDRESSES.Reg) & 0x8) >> 3
}
func (o *RADIO_Type) SetRXADDRESSES_ADDR4(value uint32) {
	volatile.StoreUint32(&o.RXADDRESSES.Reg, volatile.LoadUint32(&o.RXADDRESSES.Reg)&^(0x10)|value<<4)
}
func (o *RADIO_Type) GetRXADDRESSES_ADDR4() uint32 {
	return (volatile.LoadUint32(&o.RXADDRESSES.Reg) & 0x10) >> 4
}
func (o *RADIO_Type) SetRXADDRESSES_ADDR5(value uint32) {
	volatile.StoreUint32(&o.RXADDRESSES.Reg, volatile.LoadUint32(&o.RXADDRESSES.Reg)&^(0x20)|value<<5)
}
func (o *RADIO_Type) GetRXADDRESSES_ADDR5() uint32 {
	return (volatile.LoadUint32(&o.RXADDRESSES.Reg) & 0x20) >> 5
}
func (o *RADIO_Type) SetRXADDRESSES_ADDR6(value uint32) {
	volatile.StoreUint32(&o.RXADDRESSES.Reg, volatile.LoadUint32(&o.RXADDRESSES.Reg)&^(0x40)|value<<6)
}
func (o *RADIO_Type) GetRXADDRESSES_ADDR6() uint32 {
	return (volatile.LoadUint32(&o.RXADDRESSES.Reg) & 0x40) >> 6
}
func (o *RADIO_Type) SetRXADDRESSES_ADDR7(value uint32) {
	volatile.StoreUint32(&o.RXADDRESSES.Reg, volatile.LoadUint32(&o.RXADDRESSES.Reg)&^(0x80)|value<<7)
}
func (o *RADIO_Type) GetRXADDRESSES_ADDR7() uint32 {
	return (volatile.LoadUint32(&o.RXADDRESSES.Reg) & 0x80) >> 7
}

// RADIO.CRCCNF: CRC configuration
func (o *RADIO_Type) SetCRCCNF_LEN(value uint32) {
	volatile.StoreUint32(&o.CRCCNF.Reg, volatile.LoadUint32(&o.CRCCNF.Reg)&^(0x3)|value)
}
func (o *RADIO_Type) GetCRCCNF_LEN() uint32 {
	return volatile.LoadUint32(&o.CRCCNF.Reg) & 0x3
}
func (o *RADIO_Type) SetCRCCNF_SKIPADDR(value uint32) {
	volatile.StoreUint32(&o.CRCCNF.Reg, volatile.LoadUint32(&o.CRCCNF.Reg)&^(0x300)|value<<8)
}
func (o *RADIO_Type) GetCRCCNF_SKIPADDR() uint32 {
	return (volatile.LoadUint32(&o.CRCCNF.Reg) & 0x300) >> 8
}

// RADIO.CRCPOLY: CRC polynomial
func (o *RADIO_Type) SetCRCPOLY(value uint32) {
	volatile.StoreUint32(&o.CRCPOLY.Reg, volatile.LoadUint32(&o.CRCPOLY.Reg)&^(0xffffff)|value)
}
func (o *RADIO_Type) GetCRCPOLY() uint32 {
	return volatile.LoadUint32(&o.CRCPOLY.Reg) & 0xffffff
}

// RADIO.CRCINIT: CRC initial value
func (o *RADIO_Type) SetCRCINIT(value uint32) {
	volatile.StoreUint32(&o.CRCINIT.Reg, volatile.LoadUint32(&o.CRCINIT.Reg)&^(0xffffff)|value)
}
func (o *RADIO_Type) GetCRCINIT() uint32 {
	return volatile.LoadUint32(&o.CRCINIT.Reg) & 0xffffff
}

// RADIO.TIFS: Interframe spacing in us
func (o *RADIO_Type) SetTIFS(value uint32) {
	volatile.StoreUint32(&o.TIFS.Reg, volatile.LoadUint32(&o.TIFS.Reg)&^(0x3ff)|value)
}
func (o *RADIO_Type) GetTIFS() uint32 {
	return volatile.LoadUint32(&o.TIFS.Reg) & 0x3ff
}

// RADIO.RSSISAMPLE: RSSI sample
func (o *RADIO_Type) SetRSSISAMPLE(value uint32) {
	volatile.StoreUint32(&o.RSSISAMPLE.Reg, volatile.LoadUint32(&o.RSSISAMPLE.Reg)&^(0x7f)|value)
}
func (o *RADIO_Type) GetRSSISAMPLE() uint32 {
	return volatile.LoadUint32(&o.RSSISAMPLE.Reg) & 0x7f
}

// RADIO.STATE: Current radio state
func (o *RADIO_Type) SetSTATE(value uint32) {
	volatile.StoreUint32(&o.STATE.Reg, volatile.LoadUint32(&o.STATE.Reg)&^(0xf)|value)
}
func (o *RADIO_Type) GetSTATE() uint32 {
	return volatile.LoadUint32(&o.STATE.Reg) & 0xf
}

// RADIO.DATAWHITEIV: Data whitening initial value
func (o *RADIO_Type) SetDATAWHITEIV(value uint32) {
	volatile.StoreUint32(&o.DATAWHITEIV.Reg, volatile.LoadUint32(&o.DATAWHITEIV.Reg)&^(0x7f)|value)
}
func (o *RADIO_Type) GetDATAWHITEIV() uint32 {
	return volatile.LoadUint32(&o.DATAWHITEIV.Reg) & 0x7f
}

// RADIO.BCC: Bit counter compare
func (o *RADIO_Type) SetBCC(value uint32) {
	volatile.StoreUint32(&o.BCC.Reg, value)
}
func (o *RADIO_Type) GetBCC() uint32 {
	return volatile.LoadUint32(&o.BCC.Reg)
}

// RADIO.DAB: Description collection: Device address base segment n
func (o *RADIO_Type) SetDAB(idx int, value uint32) {
	volatile.StoreUint32(&o.DAB[idx].Reg, value)
}
func (o *RADIO_Type) GetDAB(idx int) uint32 {
	return volatile.LoadUint32(&o.DAB[idx].Reg)
}

// RADIO.DAP: Description collection: Device address prefix n
func (o *RADIO_Type) SetDAP(idx int, value uint32) {
	volatile.StoreUint32(&o.DAP[idx].Reg, volatile.LoadUint32(&o.DAP[idx].Reg)&^(0xffff)|value)
}
func (o *RADIO_Type) GetDAP(idx int) uint32 {
	return volatile.LoadUint32(&o.DAP[idx].Reg) & 0xffff
}

// RADIO.DACNF: Device address match configuration
func (o *RADIO_Type) SetDACNF_ENA0(value uint32) {
	volatile.StoreUint32(&o.DACNF.Reg, volatile.LoadUint32(&o.DACNF.Reg)&^(0x1)|value)
}
func (o *RADIO_Type) GetDACNF_ENA0() uint32 {
	return volatile.LoadUint32(&o.DACNF.Reg) & 0x1
}
func (o *RADIO_Type) SetDACNF_ENA1(value uint32) {
	volatile.StoreUint32(&o.DACNF.Reg, volatile.LoadUint32(&o.DACNF.Reg)&^(0x2)|value<<1)
}
func (o *RADIO_Type) GetDACNF_ENA1() uint32 {
	return (volatile.LoadUint32(&o.DACNF.Reg) & 0x2) >> 1
}
func (o *RADIO_Type) SetDACNF_ENA2(value uint32) {
	volatile.StoreUint32(&o.DACNF.Reg, volatile.LoadUint32(&o.DACNF.Reg)&^(0x4)|value<<2)
}
func (o *RADIO_Type) GetDACNF_ENA2() uint32 {
	return (volatile.LoadUint32(&o.DACNF.Reg) & 0x4) >> 2
}
func (o *RADIO_Type) SetDACNF_ENA3(value uint32) {
	volatile.StoreUint32(&o.DACNF.Reg, volatile.LoadUint32(&o.DACNF.Reg)&^(0x8)|value<<3)
}
func (o *RADIO_Type) GetDACNF_ENA3() uint32 {
	return (volatile.LoadUint32(&o.DACNF.Reg) & 0x8) >> 3
}
func (o *RADIO_Type) SetDACNF_ENA4(value uint32) {
	volatile.StoreUint32(&o.DACNF.Reg, volatile.LoadUint32(&o.DACNF.Reg)&^(0x10)|value<<4)
}
func (o *RADIO_Type) GetDACNF_ENA4() uint32 {
	return (volatile.LoadUint32(&o.DACNF.Reg) & 0x10) >> 4
}
func (o *RADIO_Type) SetDACNF_ENA5(value uint32) {
	volatile.StoreUint32(&o.DACNF.Reg, volatile.LoadUint32(&o.DACNF.Reg)&^(0x20)|value<<5)
}
func (o *RADIO_Type) GetDACNF_ENA5() uint32 {
	return (volatile.LoadUint32(&o.DACNF.Reg) & 0x20) >> 5
}
func (o *RADIO_Type) SetDACNF_ENA6(value uint32) {
	volatile.StoreUint32(&o.DACNF.Reg, volatile.LoadUint32(&o.DACNF.Reg)&^(0x40)|value<<6)
}
func (o *RADIO_Type) GetDACNF_ENA6() uint32 {
	return (volatile.LoadUint32(&o.DACNF.Reg) & 0x40) >> 6
}
func (o *RADIO_Type) SetDACNF_ENA7(value uint32) {
	volatile.StoreUint32(&o.DACNF.Reg, volatile.LoadUint32(&o.DACNF.Reg)&^(0x80)|value<<7)
}
func (o *RADIO_Type) GetDACNF_ENA7() uint32 {
	return (volatile.LoadUint32(&o.DACNF.Reg) & 0x80) >> 7
}
func (o *RADIO_Type) SetDACNF_TXADD0(value uint32) {
	volatile.StoreUint32(&o.DACNF.Reg, volatile.LoadUint32(&o.DACNF.Reg)&^(0x100)|value<<8)
}
func (o *RADIO_Type) GetDACNF_TXADD0() uint32 {
	return (volatile.LoadUint32(&o.DACNF.Reg) & 0x100) >> 8
}
func (o *RADIO_Type) SetDACNF_TXADD1(value uint32) {
	volatile.StoreUint32(&o.DACNF.Reg, volatile.LoadUint32(&o.DACNF.Reg)&^(0x200)|value<<9)
}
func (o *RADIO_Type) GetDACNF_TXADD1() uint32 {
	return (volatile.LoadUint32(&o.DACNF.Reg) & 0x200) >> 9
}
func (o *RADIO_Type) SetDACNF_TXADD2(value uint32) {
	volatile.StoreUint32(&o.DACNF.Reg, volatile.LoadUint32(&o.DACNF.Reg)&^(0x400)|value<<10)
}
func (o *RADIO_Type) GetDACNF_TXADD2() uint32 {
	return (volatile.LoadUint32(&o.DACNF.Reg) & 0x400) >> 10
}
func (o *RADIO_Type) SetDACNF_TXADD3(value uint32) {
	volatile.StoreUint32(&o.DACNF.Reg, volatile.LoadUint32(&o.DACNF.Reg)&^(0x800)|value<<11)
}
func (o *RADIO_Type) GetDACNF_TXADD3() uint32 {
	return (volatile.LoadUint32(&o.DACNF.Reg) & 0x800) >> 11
}
func (o *RADIO_Type) SetDACNF_TXADD4(value uint32) {
	volatile.StoreUint32(&o.DACNF.Reg, volatile.LoadUint32(&o.DACNF.Reg)&^(0x1000)|value<<12)
}
func (o *RADIO_Type) GetDACNF_TXADD4() uint32 {
	return (volatile.LoadUint32(&o.DACNF.Reg) & 0x1000) >> 12
}
func (o *RADIO_Type) SetDACNF_TXADD5(value uint32) {
	volatile.StoreUint32(&o.DACNF.Reg, volatile.LoadUint32(&o.DACNF.Reg)&^(0x2000)|value<<13)
}
func (o *RADIO_Type) GetDACNF_TXADD5() uint32 {
	return (volatile.LoadUint32(&o.DACNF.Reg) & 0x2000) >> 13
}
func (o *RADIO_Type) SetDACNF_TXADD6(value uint32) {
	volatile.StoreUint32(&o.DACNF.Reg, volatile.LoadUint32(&o.DACNF.Reg)&^(0x4000)|value<<14)
}
func (o *RADIO_Type) GetDACNF_TXADD6() uint32 {
	return (volatile.LoadUint32(&o.DACNF.Reg) & 0x4000) >> 14
}
func (o *RADIO_Type) SetDACNF_TXADD7(value uint32) {
	volatile.StoreUint32(&o.DACNF.Reg, volatile.LoadUint32(&o.DACNF.Reg)&^(0x8000)|value<<15)
}
func (o *RADIO_Type) GetDACNF_TXADD7() uint32 {
	return (volatile.LoadUint32(&o.DACNF.Reg) & 0x8000) >> 15
}

// RADIO.MHRMATCHCONF: Search pattern configuration
func (o *RADIO_Type) SetMHRMATCHCONF(value uint32) {
	volatile.StoreUint32(&o.MHRMATCHCONF.Reg, value)
}
func (o *RADIO_Type) GetMHRMATCHCONF() uint32 {
	return volatile.LoadUint32(&o.MHRMATCHCONF.Reg)
}

// RADIO.MHRMATCHMAS: Pattern mask
func (o *RADIO_Type) SetMHRMATCHMAS(value uint32) {
	volatile.StoreUint32(&o.MHRMATCHMAS.Reg, value)
}
func (o *RADIO_Type) GetMHRMATCHMAS() uint32 {
	return volatile.LoadUint32(&o.MHRMATCHMAS.Reg)
}

// RADIO.MODECNF0: Radio mode configuration register 0
func (o *RADIO_Type) SetMODECNF0_RU(value uint32) {
	volatile.StoreUint32(&o.MODECNF0.Reg, volatile.LoadUint32(&o.MODECNF0.Reg)&^(0x1)|value)
}
func (o *RADIO_Type) GetMODECNF0_RU() uint32 {
	return volatile.LoadUint32(&o.MODECNF0.Reg) & 0x1
}
func (o *RADIO_Type) SetMODECNF0_DTX(value uint32) {
	volatile.StoreUint32(&o.MODECNF0.Reg, volatile.LoadUint32(&o.MODECNF0.Reg)&^(0x300)|value<<8)
}
func (o *RADIO_Type) GetMODECNF0_DTX() uint32 {
	return (volatile.LoadUint32(&o.MODECNF0.Reg) & 0x300) >> 8
}

// RADIO.SFD: IEEE 802.15.4 start of frame delimiter
func (o *RADIO_Type) SetSFD(value uint32) {
	volatile.StoreUint32(&o.SFD.Reg, volatile.LoadUint32(&o.SFD.Reg)&^(0xff)|value)
}
func (o *RADIO_Type) GetSFD() uint32 {
	return volatile.LoadUint32(&o.SFD.Reg) & 0xff
}

// RADIO.EDCNT: IEEE 802.15.4 energy detect loop count
func (o *RADIO_Type) SetEDCNT(value uint32) {
	volatile.StoreUint32(&o.EDCNT.Reg, volatile.LoadUint32(&o.EDCNT.Reg)&^(0x1fffff)|value)
}
func (o *RADIO_Type) GetEDCNT() uint32 {
	return volatile.LoadUint32(&o.EDCNT.Reg) & 0x1fffff
}

// RADIO.EDSAMPLE: IEEE 802.15.4 energy detect level
func (o *RADIO_Type) SetEDSAMPLE_EDLVL(value uint32) {
	volatile.StoreUint32(&o.EDSAMPLE.Reg, volatile.LoadUint32(&o.EDSAMPLE.Reg)&^(0xff)|value)
}
func (o *RADIO_Type) GetEDSAMPLE_EDLVL() uint32 {
	return volatile.LoadUint32(&o.EDSAMPLE.Reg) & 0xff
}

// RADIO.CCACTRL: IEEE 802.15.4 clear channel assessment control
func (o *RADIO_Type) SetCCACTRL_CCAMODE(value uint32) {
	volatile.StoreUint32(&o.CCACTRL.Reg, volatile.LoadUint32(&o.CCACTRL.Reg)&^(0x7)|value)
}
func (o *RADIO_Type) GetCCACTRL_CCAMODE() uint32 {
	return volatile.LoadUint32(&o.CCACTRL.Reg) & 0x7
}
func (o *RADIO_Type) SetCCACTRL_CCAEDTHRES(value uint32) {
	volatile.StoreUint32(&o.CCACTRL.Reg, volatile.LoadUint32(&o.CCACTRL.Reg)&^(0xff00)|value<<8)
}
func (o *RADIO_Type) GetCCACTRL_CCAEDTHRES() uint32 {
	return (volatile.LoadUint32(&o.CCACTRL.Reg) & 0xff00) >> 8
}
func (o *RADIO_Type) SetCCACTRL_CCACORRTHRES(value uint32) {
	volatile.StoreUint32(&o.CCACTRL.Reg, volatile.LoadUint32(&o.CCACTRL.Reg)&^(0xff0000)|value<<16)
}
func (o *RADIO_Type) GetCCACTRL_CCACORRTHRES() uint32 {
	return (volatile.LoadUint32(&o.CCACTRL.Reg) & 0xff0000) >> 16
}
func (o *RADIO_Type) SetCCACTRL_CCACORRCNT(value uint32) {
	volatile.StoreUint32(&o.CCACTRL.Reg, volatile.LoadUint32(&o.CCACTRL.Reg)&^(0xff000000)|value<<24)
}
func (o *RADIO_Type) GetCCACTRL_CCACORRCNT() uint32 {
	return (volatile.LoadUint32(&o.CCACTRL.Reg) & 0xff000000) >> 24
}

// RADIO.DFEMODE: Whether to use Angle-of-Arrival (AOA) or Angle-of-Departure (AOD)
func (o *RADIO_Type) SetDFEMODE_DFEOPMODE(value uint32) {
	volatile.StoreUint32(&o.DFEMODE.Reg, volatile.LoadUint32(&o.DFEMODE.Reg)&^(0x3)|value)
}
func (o *RADIO_Type) GetDFEMODE_DFEOPMODE() uint32 {
	return volatile.LoadUint32(&o.DFEMODE.Reg) & 0x3
}

// RADIO.CTEINLINECONF: Configuration for CTE inline mode
func (o *RADIO_Type) SetCTEINLINECONF_CTEINLINECTRLEN(value uint32) {
	volatile.StoreUint32(&o.CTEINLINECONF.Reg, volatile.LoadUint32(&o.CTEINLINECONF.Reg)&^(0x1)|value)
}
func (o *RADIO_Type) GetCTEINLINECONF_CTEINLINECTRLEN() uint32 {
	return volatile.LoadUint32(&o.CTEINLINECONF.Reg) & 0x1
}
func (o *RADIO_Type) SetCTEINLINECONF_CTEINFOINS1(value uint32) {
	volatile.StoreUint32(&o.CTEINLINECONF.Reg, volatile.LoadUint32(&o.CTEINLINECONF.Reg)&^(0x8)|value<<3)
}
func (o *RADIO_Type) GetCTEINLINECONF_CTEINFOINS1() uint32 {
	return (volatile.LoadUint32(&o.CTEINLINECONF.Reg) & 0x8) >> 3
}
func (o *RADIO_Type) SetCTEINLINECONF_CTEERRORHANDLING(value uint32) {
	volatile.StoreUint32(&o.CTEINLINECONF.Reg, volatile.LoadUint32(&o.CTEINLINECONF.Reg)&^(0x10)|value<<4)
}
func (o *RADIO_Type) GetCTEINLINECONF_CTEERRORHANDLING() uint32 {
	return (volatile.LoadUint32(&o.CTEINLINECONF.Reg) & 0x10) >> 4
}
func (o *RADIO_Type) SetCTEINLINECONF_CTETIMEVALIDRANGE(value uint32) {
	volatile.StoreUint32(&o.CTEINLINECONF.Reg, volatile.LoadUint32(&o.CTEINLINECONF.Reg)&^(0xc0)|value<<6)
}
func (o *RADIO_Type) GetCTEINLINECONF_CTETIMEVALIDRANGE() uint32 {
	return (volatile.LoadUint32(&o.CTEINLINECONF.Reg) & 0xc0) >> 6
}
func (o *RADIO_Type) SetCTEINLINECONF_CTEINLINERXMODE1US(value uint32) {
	volatile.StoreUint32(&o.CTEINLINECONF.Reg, volatile.LoadUint32(&o.CTEINLINECONF.Reg)&^(0x1c00)|value<<10)
}
func (o *RADIO_Type) GetCTEINLINECONF_CTEINLINERXMODE1US() uint32 {
	return (volatile.LoadUint32(&o.CTEINLINECONF.Reg) & 0x1c00) >> 10
}
func (o *RADIO_Type) SetCTEINLINECONF_CTEINLINERXMODE2US(value uint32) {
	volatile.StoreUint32(&o.CTEINLINECONF.Reg, volatile.LoadUint32(&o.CTEINLINECONF.Reg)&^(0xe000)|value<<13)
}
func (o *RADIO_Type) GetCTEINLINECONF_CTEINLINERXMODE2US() uint32 {
	return (volatile.LoadUint32(&o.CTEINLINECONF.Reg) & 0xe000) >> 13
}
func (o *RADIO_Type) SetCTEINLINECONF_S0CONF(value uint32) {
	volatile.StoreUint32(&o.CTEINLINECONF.Reg, volatile.LoadUint32(&o.CTEINLINECONF.Reg)&^(0xff0000)|value<<16)
}
func (o *RADIO_Type) GetCTEINLINECONF_S0CONF() uint32 {
	return (volatile.LoadUint32(&o.CTEINLINECONF.Reg) & 0xff0000) >> 16
}
func (o *RADIO_Type) SetCTEINLINECONF_S0MASK(value uint32) {
	volatile.StoreUint32(&o.CTEINLINECONF.Reg, volatile.LoadUint32(&o.CTEINLINECONF.Reg)&^(0xff000000)|value<<24)
}
func (o *RADIO_Type) GetCTEINLINECONF_S0MASK() uint32 {
	return (volatile.LoadUint32(&o.CTEINLINECONF.Reg) & 0xff000000) >> 24
}

// RADIO.DFECTRL1: Various configuration for Direction finding
func (o *RADIO_Type) SetDFECTRL1_NUMBEROF8US(value uint32) {
	volatile.StoreUint32(&o.DFECTRL1.Reg, volatile.LoadUint32(&o.DFECTRL1.Reg)&^(0x3f)|value)
}
func (o *RADIO_Type) GetDFECTRL1_NUMBEROF8US() uint32 {
	return volatile.LoadUint32(&o.DFECTRL1.Reg) & 0x3f
}
func (o *RADIO_Type) SetDFECTRL1_DFEINEXTENSION(value uint32) {
	volatile.StoreUint32(&o.DFECTRL1.Reg, volatile.LoadUint32(&o.DFECTRL1.Reg)&^(0x80)|value<<7)
}
func (o *RADIO_Type) GetDFECTRL1_DFEINEXTENSION() uint32 {
	return (volatile.LoadUint32(&o.DFECTRL1.Reg) & 0x80) >> 7
}
func (o *RADIO_Type) SetDFECTRL1_TSWITCHSPACING(value uint32) {
	volatile.StoreUint32(&o.DFECTRL1.Reg, volatile.LoadUint32(&o.DFECTRL1.Reg)&^(0x700)|value<<8)
}
func (o *RADIO_Type) GetDFECTRL1_TSWITCHSPACING() uint32 {
	return (volatile.LoadUint32(&o.DFECTRL1.Reg) & 0x700) >> 8
}
func (o *RADIO_Type) SetDFECTRL1_TSAMPLESPACINGREF(value uint32) {
	volatile.StoreUint32(&o.DFECTRL1.Reg, volatile.LoadUint32(&o.DFECTRL1.Reg)&^(0x7000)|value<<12)
}
func (o *RADIO_Type) GetDFECTRL1_TSAMPLESPACINGREF() uint32 {
	return (volatile.LoadUint32(&o.DFECTRL1.Reg) & 0x7000) >> 12
}
func (o *RADIO_Type) SetDFECTRL1_SAMPLETYPE(value uint32) {
	volatile.StoreUint32(&o.DFECTRL1.Reg, volatile.LoadUint32(&o.DFECTRL1.Reg)&^(0x8000)|value<<15)
}
func (o *RADIO_Type) GetDFECTRL1_SAMPLETYPE() uint32 {
	return (volatile.LoadUint32(&o.DFECTRL1.Reg) & 0x8000) >> 15
}
func (o *RADIO_Type) SetDFECTRL1_TSAMPLESPACING(value uint32) {
	volatile.StoreUint32(&o.DFECTRL1.Reg, volatile.LoadUint32(&o.DFECTRL1.Reg)&^(0x70000)|value<<16)
}
func (o *RADIO_Type) GetDFECTRL1_TSAMPLESPACING() uint32 {
	return (volatile.LoadUint32(&o.DFECTRL1.Reg) & 0x70000) >> 16
}
func (o *RADIO_Type) SetDFECTRL1_REPEATPATTERN(value uint32) {
	volatile.StoreUint32(&o.DFECTRL1.Reg, volatile.LoadUint32(&o.DFECTRL1.Reg)&^(0xf00000)|value<<20)
}
func (o *RADIO_Type) GetDFECTRL1_REPEATPATTERN() uint32 {
	return (volatile.LoadUint32(&o.DFECTRL1.Reg) & 0xf00000) >> 20
}
func (o *RADIO_Type) SetDFECTRL1_AGCBACKOFFGAIN(value uint32) {
	volatile.StoreUint32(&o.DFECTRL1.Reg, volatile.LoadUint32(&o.DFECTRL1.Reg)&^(0xf000000)|value<<24)
}
func (o *RADIO_Type) GetDFECTRL1_AGCBACKOFFGAIN() uint32 {
	return (volatile.LoadUint32(&o.DFECTRL1.Reg) & 0xf000000) >> 24
}

// RADIO.DFECTRL2: Start offset for Direction finding
func (o *RADIO_Type) SetDFECTRL2_TSWITCHOFFSET(value uint32) {
	volatile.StoreUint32(&o.DFECTRL2.Reg, volatile.LoadUint32(&o.DFECTRL2.Reg)&^(0x1fff)|value)
}
func (o *RADIO_Type) GetDFECTRL2_TSWITCHOFFSET() uint32 {
	return volatile.LoadUint32(&o.DFECTRL2.Reg) & 0x1fff
}
func (o *RADIO_Type) SetDFECTRL2_TSAMPLEOFFSET(value uint32) {
	volatile.StoreUint32(&o.DFECTRL2.Reg, volatile.LoadUint32(&o.DFECTRL2.Reg)&^(0xfff0000)|value<<16)
}
func (o *RADIO_Type) GetDFECTRL2_TSAMPLEOFFSET() uint32 {
	return (volatile.LoadUint32(&o.DFECTRL2.Reg) & 0xfff0000) >> 16
}

// RADIO.SWITCHPATTERN: GPIO patterns to be used for each antenna
func (o *RADIO_Type) SetSWITCHPATTERN(value uint32) {
	volatile.StoreUint32(&o.SWITCHPATTERN.Reg, volatile.LoadUint32(&o.SWITCHPATTERN.Reg)&^(0xff)|value)
}
func (o *RADIO_Type) GetSWITCHPATTERN() uint32 {
	return volatile.LoadUint32(&o.SWITCHPATTERN.Reg) & 0xff
}

// RADIO.CLEARPATTERN: Clear the GPIO pattern array for antenna control
func (o *RADIO_Type) SetCLEARPATTERN(value uint32) {
	volatile.StoreUint32(&o.CLEARPATTERN.Reg, volatile.LoadUint32(&o.CLEARPATTERN.Reg)&^(0x1)|value)
}
func (o *RADIO_Type) GetCLEARPATTERN() uint32 {
	return volatile.LoadUint32(&o.CLEARPATTERN.Reg) & 0x1
}

// RADIO.POWER: Peripheral power control
func (o *RADIO_Type) SetPOWER(value uint32) {
	volatile.StoreUint32(&o.POWER.Reg, volatile.LoadUint32(&o.POWER.Reg)&^(0x1)|value)
}
func (o *RADIO_Type) GetPOWER() uint32 {
	return volatile.LoadUint32(&o.POWER.Reg) & 0x1
}

// Unspecified
type RADIO_PSEL_Type struct {
	DFEGPIO [8]volatile.Register32 // 0x930
}

// DFE packet EasyDMA channel
type RADIO_DFEPACKET_Type struct {
	PTR    volatile.Register32 // 0x950
	MAXCNT volatile.Register32 // 0x954
	AMOUNT volatile.Register32 // 0x958
}

// RADIO_DFEPACKET.PTR: Data pointer
func (o *RADIO_DFEPACKET_Type) SetPTR(value uint32) {
	volatile.StoreUint32(&o.PTR.Reg, value)
}
func (o *RADIO_DFEPACKET_Type) GetPTR() uint32 {
	return volatile.LoadUint32(&o.PTR.Reg)
}

// RADIO_DFEPACKET.MAXCNT: Maximum number of buffer words to transfer
func (o *RADIO_DFEPACKET_Type) SetMAXCNT(value uint32) {
	volatile.StoreUint32(&o.MAXCNT.Reg, volatile.LoadUint32(&o.MAXCNT.Reg)&^(0x3fff)|value)
}
func (o *RADIO_DFEPACKET_Type) GetMAXCNT() uint32 {
	return volatile.LoadUint32(&o.MAXCNT.Reg) & 0x3fff
}

// RADIO_DFEPACKET.AMOUNT: Number of samples transferred in the last transaction
func (o *RADIO_DFEPACKET_Type) SetAMOUNT(value uint32) {
	volatile.StoreUint32(&o.AMOUNT.Reg, volatile.LoadUint32(&o.AMOUNT.Reg)&^(0xffff)|value)
}
func (o *RADIO_DFEPACKET_Type) GetAMOUNT() uint32 {
	return volatile.LoadUint32(&o.AMOUNT.Reg) & 0xffff
}

// Random Number Generator
type RNG_Type struct {
	TASKS_START     volatile.Register32 // 0x0
	TASKS_STOP      volatile.Register32 // 0x4
	_               [120]byte
	SUBSCRIBE_START volatile.Register32 // 0x80
	SUBSCRIBE_STOP  volatile.Register32 // 0x84
	_               [120]byte
	EVENTS_VALRDY   volatile.Register32 // 0x100
	_               [124]byte
	PUBLISH_VALRDY  volatile.Register32 // 0x180
	_               [124]byte
	SHORTS          volatile.Register32 // 0x200
	_               [256]byte
	INTENSET        volatile.Register32 // 0x304
	INTENCLR        volatile.Register32 // 0x308
	_               [504]byte
	CONFIG          volatile.Register32 // 0x504
	VALUE           volatile.Register32 // 0x508
}

// RNG.TASKS_START: Task starting the random number generator
func (o *RNG_Type) SetTASKS_START(value uint32) {
	volatile.StoreUint32(&o.TASKS_START.Reg, volatile.LoadUint32(&o.TASKS_START.Reg)&^(0x1)|value)
}
func (o *RNG_Type) GetTASKS_START() uint32 {
	return volatile.LoadUint32(&o.TASKS_START.Reg) & 0x1
}

// RNG.TASKS_STOP: Task stopping the random number generator
func (o *RNG_Type) SetTASKS_STOP(value uint32) {
	volatile.StoreUint32(&o.TASKS_STOP.Reg, volatile.LoadUint32(&o.TASKS_STOP.Reg)&^(0x1)|value)
}
func (o *RNG_Type) GetTASKS_STOP() uint32 {
	return volatile.LoadUint32(&o.TASKS_STOP.Reg) & 0x1
}

// RNG.SUBSCRIBE_START: Subscribe configuration for task START
func (o *RNG_Type) SetSUBSCRIBE_START_CHIDX(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_START.Reg, volatile.LoadUint32(&o.SUBSCRIBE_START.Reg)&^(0xff)|value)
}
func (o *RNG_Type) GetSUBSCRIBE_START_CHIDX() uint32 {
	return volatile.LoadUint32(&o.SUBSCRIBE_START.Reg) & 0xff
}
func (o *RNG_Type) SetSUBSCRIBE_START_EN(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_START.Reg, volatile.LoadUint32(&o.SUBSCRIBE_START.Reg)&^(0x80000000)|value<<31)
}
func (o *RNG_Type) GetSUBSCRIBE_START_EN() uint32 {
	return (volatile.LoadUint32(&o.SUBSCRIBE_START.Reg) & 0x80000000) >> 31
}

// RNG.SUBSCRIBE_STOP: Subscribe configuration for task STOP
func (o *RNG_Type) SetSUBSCRIBE_STOP_CHIDX(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_STOP.Reg, volatile.LoadUint32(&o.SUBSCRIBE_STOP.Reg)&^(0xff)|value)
}
func (o *RNG_Type) GetSUBSCRIBE_STOP_CHIDX() uint32 {
	return volatile.LoadUint32(&o.SUBSCRIBE_STOP.Reg) & 0xff
}
func (o *RNG_Type) SetSUBSCRIBE_STOP_EN(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_STOP.Reg, volatile.LoadUint32(&o.SUBSCRIBE_STOP.Reg)&^(0x80000000)|value<<31)
}
func (o *RNG_Type) GetSUBSCRIBE_STOP_EN() uint32 {
	return (volatile.LoadUint32(&o.SUBSCRIBE_STOP.Reg) & 0x80000000) >> 31
}

// RNG.EVENTS_VALRDY: Event being generated for every new random number written to the VALUE register
func (o *RNG_Type) SetEVENTS_VALRDY(value uint32) {
	volatile.StoreUint32(&o.EVENTS_VALRDY.Reg, volatile.LoadUint32(&o.EVENTS_VALRDY.Reg)&^(0x1)|value)
}
func (o *RNG_Type) GetEVENTS_VALRDY() uint32 {
	return volatile.LoadUint32(&o.EVENTS_VALRDY.Reg) & 0x1
}

// RNG.PUBLISH_VALRDY: Publish configuration for event VALRDY
func (o *RNG_Type) SetPUBLISH_VALRDY_CHIDX(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_VALRDY.Reg, volatile.LoadUint32(&o.PUBLISH_VALRDY.Reg)&^(0xff)|value)
}
func (o *RNG_Type) GetPUBLISH_VALRDY_CHIDX() uint32 {
	return volatile.LoadUint32(&o.PUBLISH_VALRDY.Reg) & 0xff
}
func (o *RNG_Type) SetPUBLISH_VALRDY_EN(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_VALRDY.Reg, volatile.LoadUint32(&o.PUBLISH_VALRDY.Reg)&^(0x80000000)|value<<31)
}
func (o *RNG_Type) GetPUBLISH_VALRDY_EN() uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_VALRDY.Reg) & 0x80000000) >> 31
}

// RNG.SHORTS: Shortcuts between local events and tasks
func (o *RNG_Type) SetSHORTS_VALRDY_STOP(value uint32) {
	volatile.StoreUint32(&o.SHORTS.Reg, volatile.LoadUint32(&o.SHORTS.Reg)&^(0x1)|value)
}
func (o *RNG_Type) GetSHORTS_VALRDY_STOP() uint32 {
	return volatile.LoadUint32(&o.SHORTS.Reg) & 0x1
}

// RNG.INTENSET: Enable interrupt
func (o *RNG_Type) SetINTENSET_VALRDY(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x1)|value)
}
func (o *RNG_Type) GetINTENSET_VALRDY() uint32 {
	return volatile.LoadUint32(&o.INTENSET.Reg) & 0x1
}

// RNG.INTENCLR: Disable interrupt
func (o *RNG_Type) SetINTENCLR_VALRDY(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x1)|value)
}
func (o *RNG_Type) GetINTENCLR_VALRDY() uint32 {
	return volatile.LoadUint32(&o.INTENCLR.Reg) & 0x1
}

// RNG.CONFIG: Configuration register
func (o *RNG_Type) SetCONFIG_DERCEN(value uint32) {
	volatile.StoreUint32(&o.CONFIG.Reg, volatile.LoadUint32(&o.CONFIG.Reg)&^(0x1)|value)
}
func (o *RNG_Type) GetCONFIG_DERCEN() uint32 {
	return volatile.LoadUint32(&o.CONFIG.Reg) & 0x1
}

// RNG.VALUE: Output random number
func (o *RNG_Type) SetVALUE(value uint32) {
	volatile.StoreUint32(&o.VALUE.Reg, volatile.LoadUint32(&o.VALUE.Reg)&^(0xff)|value)
}
func (o *RNG_Type) GetVALUE() uint32 {
	return volatile.LoadUint32(&o.VALUE.Reg) & 0xff
}

// GPIO Tasks and Events
type GPIOTE_Type struct {
	TASKS_OUT     [8]volatile.Register32 // 0x0
	_             [16]byte
	TASKS_SET     [8]volatile.Register32 // 0x30
	_             [16]byte
	TASKS_CLR     [8]volatile.Register32 // 0x60
	SUBSCRIBE_OUT [8]volatile.Register32 // 0x80
	_             [16]byte
	SUBSCRIBE_SET [8]volatile.Register32 // 0xB0
	_             [16]byte
	SUBSCRIBE_CLR [8]volatile.Register32 // 0xE0
	EVENTS_IN     [8]volatile.Register32 // 0x100
	_             [92]byte
	EVENTS_PORT   volatile.Register32    // 0x17C
	PUBLISH_IN    [8]volatile.Register32 // 0x180
	_             [92]byte
	PUBLISH_PORT  volatile.Register32 // 0x1FC
	_             [260]byte
	INTENSET      volatile.Register32 // 0x304
	INTENCLR      volatile.Register32 // 0x308
	_             [504]byte
	LATENCY       volatile.Register32 // 0x504
	_             [8]byte
	CONFIG        [8]volatile.Register32 // 0x510
}

// GPIOTE.TASKS_OUT: Description collection: Task for writing to pin specified in CONFIG[n].PSEL. Action on pin is configured in CONFIG[n].POLARITY.
func (o *GPIOTE_Type) SetTASKS_OUT(idx int, value uint32) {
	volatile.StoreUint32(&o.TASKS_OUT[idx].Reg, volatile.LoadUint32(&o.TASKS_OUT[idx].Reg)&^(0x1)|value)
}
func (o *GPIOTE_Type) GetTASKS_OUT(idx int) uint32 {
	return volatile.LoadUint32(&o.TASKS_OUT[idx].Reg) & 0x1
}

// GPIOTE.TASKS_SET: Description collection: Task for writing to pin specified in CONFIG[n].PSEL. Action on pin is to set it high.
func (o *GPIOTE_Type) SetTASKS_SET(idx int, value uint32) {
	volatile.StoreUint32(&o.TASKS_SET[idx].Reg, volatile.LoadUint32(&o.TASKS_SET[idx].Reg)&^(0x1)|value)
}
func (o *GPIOTE_Type) GetTASKS_SET(idx int) uint32 {
	return volatile.LoadUint32(&o.TASKS_SET[idx].Reg) & 0x1
}

// GPIOTE.TASKS_CLR: Description collection: Task for writing to pin specified in CONFIG[n].PSEL. Action on pin is to set it low.
func (o *GPIOTE_Type) SetTASKS_CLR(idx int, value uint32) {
	volatile.StoreUint32(&o.TASKS_CLR[idx].Reg, volatile.LoadUint32(&o.TASKS_CLR[idx].Reg)&^(0x1)|value)
}
func (o *GPIOTE_Type) GetTASKS_CLR(idx int) uint32 {
	return volatile.LoadUint32(&o.TASKS_CLR[idx].Reg) & 0x1
}

// GPIOTE.SUBSCRIBE_OUT: Description collection: Subscribe configuration for task OUT[n]
func (o *GPIOTE_Type) SetSUBSCRIBE_OUT_CHIDX(idx int, value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_OUT[idx].Reg, volatile.LoadUint32(&o.SUBSCRIBE_OUT[idx].Reg)&^(0xff)|value)
}
func (o *GPIOTE_Type) GetSUBSCRIBE_OUT_CHIDX(idx int) uint32 {
	return volatile.LoadUint32(&o.SUBSCRIBE_OUT[idx].Reg) & 0xff
}
func (o *GPIOTE_Type) SetSUBSCRIBE_OUT_EN(idx int, value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_OUT[idx].Reg, volatile.LoadUint32(&o.SUBSCRIBE_OUT[idx].Reg)&^(0x80000000)|value<<31)
}
func (o *GPIOTE_Type) GetSUBSCRIBE_OUT_EN(idx int) uint32 {
	return (volatile.LoadUint32(&o.SUBSCRIBE_OUT[idx].Reg) & 0x80000000) >> 31
}

// GPIOTE.SUBSCRIBE_SET: Description collection: Subscribe configuration for task SET[n]
func (o *GPIOTE_Type) SetSUBSCRIBE_SET_CHIDX(idx int, value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_SET[idx].Reg, volatile.LoadUint32(&o.SUBSCRIBE_SET[idx].Reg)&^(0xff)|value)
}
func (o *GPIOTE_Type) GetSUBSCRIBE_SET_CHIDX(idx int) uint32 {
	return volatile.LoadUint32(&o.SUBSCRIBE_SET[idx].Reg) & 0xff
}
func (o *GPIOTE_Type) SetSUBSCRIBE_SET_EN(idx int, value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_SET[idx].Reg, volatile.LoadUint32(&o.SUBSCRIBE_SET[idx].Reg)&^(0x80000000)|value<<31)
}
func (o *GPIOTE_Type) GetSUBSCRIBE_SET_EN(idx int) uint32 {
	return (volatile.LoadUint32(&o.SUBSCRIBE_SET[idx].Reg) & 0x80000000) >> 31
}

// GPIOTE.SUBSCRIBE_CLR: Description collection: Subscribe configuration for task CLR[n]
func (o *GPIOTE_Type) SetSUBSCRIBE_CLR_CHIDX(idx int, value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_CLR[idx].Reg, volatile.LoadUint32(&o.SUBSCRIBE_CLR[idx].Reg)&^(0xff)|value)
}
func (o *GPIOTE_Type) GetSUBSCRIBE_CLR_CHIDX(idx int) uint32 {
	return volatile.LoadUint32(&o.SUBSCRIBE_CLR[idx].Reg) & 0xff
}
func (o *GPIOTE_Type) SetSUBSCRIBE_CLR_EN(idx int, value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_CLR[idx].Reg, volatile.LoadUint32(&o.SUBSCRIBE_CLR[idx].Reg)&^(0x80000000)|value<<31)
}
func (o *GPIOTE_Type) GetSUBSCRIBE_CLR_EN(idx int) uint32 {
	return (volatile.LoadUint32(&o.SUBSCRIBE_CLR[idx].Reg) & 0x80000000) >> 31
}

// GPIOTE.EVENTS_IN: Description collection: Event generated from pin specified in CONFIG[n].PSEL
func (o *GPIOTE_Type) SetEVENTS_IN(idx int, value uint32) {
	volatile.StoreUint32(&o.EVENTS_IN[idx].Reg, volatile.LoadUint32(&o.EVENTS_IN[idx].Reg)&^(0x1)|value)
}
func (o *GPIOTE_Type) GetEVENTS_IN(idx int) uint32 {
	return volatile.LoadUint32(&o.EVENTS_IN[idx].Reg) & 0x1
}

// GPIOTE.EVENTS_PORT: Event generated from multiple input GPIO pins with SENSE mechanism enabled
func (o *GPIOTE_Type) SetEVENTS_PORT(value uint32) {
	volatile.StoreUint32(&o.EVENTS_PORT.Reg, volatile.LoadUint32(&o.EVENTS_PORT.Reg)&^(0x1)|value)
}
func (o *GPIOTE_Type) GetEVENTS_PORT() uint32 {
	return volatile.LoadUint32(&o.EVENTS_PORT.Reg) & 0x1
}

// GPIOTE.PUBLISH_IN: Description collection: Publish configuration for event IN[n]
func (o *GPIOTE_Type) SetPUBLISH_IN_CHIDX(idx int, value uint32) {
	volatile.StoreUint32(&o.PUBLISH_IN[idx].Reg, volatile.LoadUint32(&o.PUBLISH_IN[idx].Reg)&^(0xff)|value)
}
func (o *GPIOTE_Type) GetPUBLISH_IN_CHIDX(idx int) uint32 {
	return volatile.LoadUint32(&o.PUBLISH_IN[idx].Reg) & 0xff
}
func (o *GPIOTE_Type) SetPUBLISH_IN_EN(idx int, value uint32) {
	volatile.StoreUint32(&o.PUBLISH_IN[idx].Reg, volatile.LoadUint32(&o.PUBLISH_IN[idx].Reg)&^(0x80000000)|value<<31)
}
func (o *GPIOTE_Type) GetPUBLISH_IN_EN(idx int) uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_IN[idx].Reg) & 0x80000000) >> 31
}

// GPIOTE.PUBLISH_PORT: Publish configuration for event PORT
func (o *GPIOTE_Type) SetPUBLISH_PORT_CHIDX(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_PORT.Reg, volatile.LoadUint32(&o.PUBLISH_PORT.Reg)&^(0xff)|value)
}
func (o *GPIOTE_Type) GetPUBLISH_PORT_CHIDX() uint32 {
	return volatile.LoadUint32(&o.PUBLISH_PORT.Reg) & 0xff
}
func (o *GPIOTE_Type) SetPUBLISH_PORT_EN(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_PORT.Reg, volatile.LoadUint32(&o.PUBLISH_PORT.Reg)&^(0x80000000)|value<<31)
}
func (o *GPIOTE_Type) GetPUBLISH_PORT_EN() uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_PORT.Reg) & 0x80000000) >> 31
}

// GPIOTE.INTENSET: Enable interrupt
func (o *GPIOTE_Type) SetINTENSET_IN0(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x1)|value)
}
func (o *GPIOTE_Type) GetINTENSET_IN0() uint32 {
	return volatile.LoadUint32(&o.INTENSET.Reg) & 0x1
}
func (o *GPIOTE_Type) SetINTENSET_IN1(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x2)|value<<1)
}
func (o *GPIOTE_Type) GetINTENSET_IN1() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x2) >> 1
}
func (o *GPIOTE_Type) SetINTENSET_IN2(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x4)|value<<2)
}
func (o *GPIOTE_Type) GetINTENSET_IN2() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x4) >> 2
}
func (o *GPIOTE_Type) SetINTENSET_IN3(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x8)|value<<3)
}
func (o *GPIOTE_Type) GetINTENSET_IN3() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x8) >> 3
}
func (o *GPIOTE_Type) SetINTENSET_IN4(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x10)|value<<4)
}
func (o *GPIOTE_Type) GetINTENSET_IN4() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x10) >> 4
}
func (o *GPIOTE_Type) SetINTENSET_IN5(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x20)|value<<5)
}
func (o *GPIOTE_Type) GetINTENSET_IN5() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x20) >> 5
}
func (o *GPIOTE_Type) SetINTENSET_IN6(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x40)|value<<6)
}
func (o *GPIOTE_Type) GetINTENSET_IN6() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x40) >> 6
}
func (o *GPIOTE_Type) SetINTENSET_IN7(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x80)|value<<7)
}
func (o *GPIOTE_Type) GetINTENSET_IN7() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x80) >> 7
}
func (o *GPIOTE_Type) SetINTENSET_PORT(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x80000000)|value<<31)
}
func (o *GPIOTE_Type) GetINTENSET_PORT() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x80000000) >> 31
}

// GPIOTE.INTENCLR: Disable interrupt
func (o *GPIOTE_Type) SetINTENCLR_IN0(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x1)|value)
}
func (o *GPIOTE_Type) GetINTENCLR_IN0() uint32 {
	return volatile.LoadUint32(&o.INTENCLR.Reg) & 0x1
}
func (o *GPIOTE_Type) SetINTENCLR_IN1(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x2)|value<<1)
}
func (o *GPIOTE_Type) GetINTENCLR_IN1() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x2) >> 1
}
func (o *GPIOTE_Type) SetINTENCLR_IN2(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x4)|value<<2)
}
func (o *GPIOTE_Type) GetINTENCLR_IN2() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x4) >> 2
}
func (o *GPIOTE_Type) SetINTENCLR_IN3(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x8)|value<<3)
}
func (o *GPIOTE_Type) GetINTENCLR_IN3() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x8) >> 3
}
func (o *GPIOTE_Type) SetINTENCLR_IN4(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x10)|value<<4)
}
func (o *GPIOTE_Type) GetINTENCLR_IN4() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x10) >> 4
}
func (o *GPIOTE_Type) SetINTENCLR_IN5(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x20)|value<<5)
}
func (o *GPIOTE_Type) GetINTENCLR_IN5() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x20) >> 5
}
func (o *GPIOTE_Type) SetINTENCLR_IN6(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x40)|value<<6)
}
func (o *GPIOTE_Type) GetINTENCLR_IN6() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x40) >> 6
}
func (o *GPIOTE_Type) SetINTENCLR_IN7(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x80)|value<<7)
}
func (o *GPIOTE_Type) GetINTENCLR_IN7() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x80) >> 7
}
func (o *GPIOTE_Type) SetINTENCLR_PORT(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x80000000)|value<<31)
}
func (o *GPIOTE_Type) GetINTENCLR_PORT() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x80000000) >> 31
}

// GPIOTE.LATENCY: Latency selection for Event mode (MODE=Event) with rising or falling edge detection on the pin.
func (o *GPIOTE_Type) SetLATENCY(value uint32) {
	volatile.StoreUint32(&o.LATENCY.Reg, volatile.LoadUint32(&o.LATENCY.Reg)&^(0x1)|value)
}
func (o *GPIOTE_Type) GetLATENCY() uint32 {
	return volatile.LoadUint32(&o.LATENCY.Reg) & 0x1
}

// GPIOTE.CONFIG: Description collection: Configuration for OUT[n], SET[n], and CLR[n] tasks and IN[n] event
func (o *GPIOTE_Type) SetCONFIG_MODE(idx int, value uint32) {
	volatile.StoreUint32(&o.CONFIG[idx].Reg, volatile.LoadUint32(&o.CONFIG[idx].Reg)&^(0x3)|value)
}
func (o *GPIOTE_Type) GetCONFIG_MODE(idx int) uint32 {
	return volatile.LoadUint32(&o.CONFIG[idx].Reg) & 0x3
}
func (o *GPIOTE_Type) SetCONFIG_PSEL(idx int, value uint32) {
	volatile.StoreUint32(&o.CONFIG[idx].Reg, volatile.LoadUint32(&o.CONFIG[idx].Reg)&^(0x1f00)|value<<8)
}
func (o *GPIOTE_Type) GetCONFIG_PSEL(idx int) uint32 {
	return (volatile.LoadUint32(&o.CONFIG[idx].Reg) & 0x1f00) >> 8
}
func (o *GPIOTE_Type) SetCONFIG_PORT(idx int, value uint32) {
	volatile.StoreUint32(&o.CONFIG[idx].Reg, volatile.LoadUint32(&o.CONFIG[idx].Reg)&^(0x2000)|value<<13)
}
func (o *GPIOTE_Type) GetCONFIG_PORT(idx int) uint32 {
	return (volatile.LoadUint32(&o.CONFIG[idx].Reg) & 0x2000) >> 13
}
func (o *GPIOTE_Type) SetCONFIG_POLARITY(idx int, value uint32) {
	volatile.StoreUint32(&o.CONFIG[idx].Reg, volatile.LoadUint32(&o.CONFIG[idx].Reg)&^(0x30000)|value<<16)
}
func (o *GPIOTE_Type) GetCONFIG_POLARITY(idx int) uint32 {
	return (volatile.LoadUint32(&o.CONFIG[idx].Reg) & 0x30000) >> 16
}
func (o *GPIOTE_Type) SetCONFIG_OUTINIT(idx int, value uint32) {
	volatile.StoreUint32(&o.CONFIG[idx].Reg, volatile.LoadUint32(&o.CONFIG[idx].Reg)&^(0x100000)|value<<20)
}
func (o *GPIOTE_Type) GetCONFIG_OUTINIT(idx int) uint32 {
	return (volatile.LoadUint32(&o.CONFIG[idx].Reg) & 0x100000) >> 20
}

// Watchdog Timer
type WDT_Type struct {
	TASKS_START     volatile.Register32 // 0x0
	TASKS_STOP      volatile.Register32 // 0x4
	_               [120]byte
	SUBSCRIBE_START volatile.Register32 // 0x80
	SUBSCRIBE_STOP  volatile.Register32 // 0x84
	_               [120]byte
	EVENTS_TIMEOUT  volatile.Register32 // 0x100
	EVENTS_STOPPED  volatile.Register32 // 0x104
	_               [120]byte
	PUBLISH_TIMEOUT volatile.Register32 // 0x180
	PUBLISH_STOPPED volatile.Register32 // 0x184
	_               [380]byte
	INTENSET        volatile.Register32 // 0x304
	INTENCLR        volatile.Register32 // 0x308
	_               [24]byte
	NMIENSET        volatile.Register32 // 0x324
	NMIENCLR        volatile.Register32 // 0x328
	_               [212]byte
	RUNSTATUS       volatile.Register32 // 0x400
	REQSTATUS       volatile.Register32 // 0x404
	_               [252]byte
	CRV             volatile.Register32 // 0x504
	RREN            volatile.Register32 // 0x508
	CONFIG          volatile.Register32 // 0x50C
	_               [16]byte
	TSEN            volatile.Register32 // 0x520
	_               [220]byte
	RR              [8]volatile.Register32 // 0x600
}

// WDT.TASKS_START: Start the watchdog
func (o *WDT_Type) SetTASKS_START(value uint32) {
	volatile.StoreUint32(&o.TASKS_START.Reg, volatile.LoadUint32(&o.TASKS_START.Reg)&^(0x1)|value)
}
func (o *WDT_Type) GetTASKS_START() uint32 {
	return volatile.LoadUint32(&o.TASKS_START.Reg) & 0x1
}

// WDT.TASKS_STOP: Stop the watchdog timer.
func (o *WDT_Type) SetTASKS_STOP(value uint32) {
	volatile.StoreUint32(&o.TASKS_STOP.Reg, volatile.LoadUint32(&o.TASKS_STOP.Reg)&^(0x1)|value)
}
func (o *WDT_Type) GetTASKS_STOP() uint32 {
	return volatile.LoadUint32(&o.TASKS_STOP.Reg) & 0x1
}

// WDT.SUBSCRIBE_START: Subscribe configuration for task START
func (o *WDT_Type) SetSUBSCRIBE_START_CHIDX(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_START.Reg, volatile.LoadUint32(&o.SUBSCRIBE_START.Reg)&^(0xff)|value)
}
func (o *WDT_Type) GetSUBSCRIBE_START_CHIDX() uint32 {
	return volatile.LoadUint32(&o.SUBSCRIBE_START.Reg) & 0xff
}
func (o *WDT_Type) SetSUBSCRIBE_START_EN(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_START.Reg, volatile.LoadUint32(&o.SUBSCRIBE_START.Reg)&^(0x80000000)|value<<31)
}
func (o *WDT_Type) GetSUBSCRIBE_START_EN() uint32 {
	return (volatile.LoadUint32(&o.SUBSCRIBE_START.Reg) & 0x80000000) >> 31
}

// WDT.SUBSCRIBE_STOP: Subscribe configuration for task STOP
func (o *WDT_Type) SetSUBSCRIBE_STOP_CHIDX(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_STOP.Reg, volatile.LoadUint32(&o.SUBSCRIBE_STOP.Reg)&^(0xff)|value)
}
func (o *WDT_Type) GetSUBSCRIBE_STOP_CHIDX() uint32 {
	return volatile.LoadUint32(&o.SUBSCRIBE_STOP.Reg) & 0xff
}
func (o *WDT_Type) SetSUBSCRIBE_STOP_EN(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_STOP.Reg, volatile.LoadUint32(&o.SUBSCRIBE_STOP.Reg)&^(0x80000000)|value<<31)
}
func (o *WDT_Type) GetSUBSCRIBE_STOP_EN() uint32 {
	return (volatile.LoadUint32(&o.SUBSCRIBE_STOP.Reg) & 0x80000000) >> 31
}

// WDT.EVENTS_TIMEOUT: Watchdog timeout
func (o *WDT_Type) SetEVENTS_TIMEOUT(value uint32) {
	volatile.StoreUint32(&o.EVENTS_TIMEOUT.Reg, volatile.LoadUint32(&o.EVENTS_TIMEOUT.Reg)&^(0x1)|value)
}
func (o *WDT_Type) GetEVENTS_TIMEOUT() uint32 {
	return volatile.LoadUint32(&o.EVENTS_TIMEOUT.Reg) & 0x1
}

// WDT.EVENTS_STOPPED: Watchdog stopped
func (o *WDT_Type) SetEVENTS_STOPPED(value uint32) {
	volatile.StoreUint32(&o.EVENTS_STOPPED.Reg, volatile.LoadUint32(&o.EVENTS_STOPPED.Reg)&^(0x1)|value)
}
func (o *WDT_Type) GetEVENTS_STOPPED() uint32 {
	return volatile.LoadUint32(&o.EVENTS_STOPPED.Reg) & 0x1
}

// WDT.PUBLISH_TIMEOUT: Publish configuration for event TIMEOUT
func (o *WDT_Type) SetPUBLISH_TIMEOUT_CHIDX(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_TIMEOUT.Reg, volatile.LoadUint32(&o.PUBLISH_TIMEOUT.Reg)&^(0xff)|value)
}
func (o *WDT_Type) GetPUBLISH_TIMEOUT_CHIDX() uint32 {
	return volatile.LoadUint32(&o.PUBLISH_TIMEOUT.Reg) & 0xff
}
func (o *WDT_Type) SetPUBLISH_TIMEOUT_EN(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_TIMEOUT.Reg, volatile.LoadUint32(&o.PUBLISH_TIMEOUT.Reg)&^(0x80000000)|value<<31)
}
func (o *WDT_Type) GetPUBLISH_TIMEOUT_EN() uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_TIMEOUT.Reg) & 0x80000000) >> 31
}

// WDT.PUBLISH_STOPPED: Publish configuration for event STOPPED
func (o *WDT_Type) SetPUBLISH_STOPPED_CHIDX(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_STOPPED.Reg, volatile.LoadUint32(&o.PUBLISH_STOPPED.Reg)&^(0xff)|value)
}
func (o *WDT_Type) GetPUBLISH_STOPPED_CHIDX() uint32 {
	return volatile.LoadUint32(&o.PUBLISH_STOPPED.Reg) & 0xff
}
func (o *WDT_Type) SetPUBLISH_STOPPED_EN(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_STOPPED.Reg, volatile.LoadUint32(&o.PUBLISH_STOPPED.Reg)&^(0x80000000)|value<<31)
}
func (o *WDT_Type) GetPUBLISH_STOPPED_EN() uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_STOPPED.Reg) & 0x80000000) >> 31
}

// WDT.INTENSET: Enable interrupt
func (o *WDT_Type) SetINTENSET_TIMEOUT(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x1)|value)
}
func (o *WDT_Type) GetINTENSET_TIMEOUT() uint32 {
	return volatile.LoadUint32(&o.INTENSET.Reg) & 0x1
}
func (o *WDT_Type) SetINTENSET_STOPPED(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x2)|value<<1)
}
func (o *WDT_Type) GetINTENSET_STOPPED() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x2) >> 1
}

// WDT.INTENCLR: Disable interrupt
func (o *WDT_Type) SetINTENCLR_TIMEOUT(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x1)|value)
}
func (o *WDT_Type) GetINTENCLR_TIMEOUT() uint32 {
	return volatile.LoadUint32(&o.INTENCLR.Reg) & 0x1
}
func (o *WDT_Type) SetINTENCLR_STOPPED(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x2)|value<<1)
}
func (o *WDT_Type) GetINTENCLR_STOPPED() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x2) >> 1
}

// WDT.NMIENSET: Enable interrupt
func (o *WDT_Type) SetNMIENSET_TIMEOUT(value uint32) {
	volatile.StoreUint32(&o.NMIENSET.Reg, volatile.LoadUint32(&o.NMIENSET.Reg)&^(0x1)|value)
}
func (o *WDT_Type) GetNMIENSET_TIMEOUT() uint32 {
	return volatile.LoadUint32(&o.NMIENSET.Reg) & 0x1
}
func (o *WDT_Type) SetNMIENSET_STOPPED(value uint32) {
	volatile.StoreUint32(&o.NMIENSET.Reg, volatile.LoadUint32(&o.NMIENSET.Reg)&^(0x2)|value<<1)
}
func (o *WDT_Type) GetNMIENSET_STOPPED() uint32 {
	return (volatile.LoadUint32(&o.NMIENSET.Reg) & 0x2) >> 1
}

// WDT.NMIENCLR: Disable interrupt
func (o *WDT_Type) SetNMIENCLR_TIMEOUT(value uint32) {
	volatile.StoreUint32(&o.NMIENCLR.Reg, volatile.LoadUint32(&o.NMIENCLR.Reg)&^(0x1)|value)
}
func (o *WDT_Type) GetNMIENCLR_TIMEOUT() uint32 {
	return volatile.LoadUint32(&o.NMIENCLR.Reg) & 0x1
}
func (o *WDT_Type) SetNMIENCLR_STOPPED(value uint32) {
	volatile.StoreUint32(&o.NMIENCLR.Reg, volatile.LoadUint32(&o.NMIENCLR.Reg)&^(0x2)|value<<1)
}
func (o *WDT_Type) GetNMIENCLR_STOPPED() uint32 {
	return (volatile.LoadUint32(&o.NMIENCLR.Reg) & 0x2) >> 1
}

// WDT.RUNSTATUS: Run status
func (o *WDT_Type) SetRUNSTATUS_RUNSTATUSWDT(value uint32) {
	volatile.StoreUint32(&o.RUNSTATUS.Reg, volatile.LoadUint32(&o.RUNSTATUS.Reg)&^(0x1)|value)
}
func (o *WDT_Type) GetRUNSTATUS_RUNSTATUSWDT() uint32 {
	return volatile.LoadUint32(&o.RUNSTATUS.Reg) & 0x1
}

// WDT.REQSTATUS: Request status
func (o *WDT_Type) SetREQSTATUS_RR0(value uint32) {
	volatile.StoreUint32(&o.REQSTATUS.Reg, volatile.LoadUint32(&o.REQSTATUS.Reg)&^(0x1)|value)
}
func (o *WDT_Type) GetREQSTATUS_RR0() uint32 {
	return volatile.LoadUint32(&o.REQSTATUS.Reg) & 0x1
}
func (o *WDT_Type) SetREQSTATUS_RR1(value uint32) {
	volatile.StoreUint32(&o.REQSTATUS.Reg, volatile.LoadUint32(&o.REQSTATUS.Reg)&^(0x2)|value<<1)
}
func (o *WDT_Type) GetREQSTATUS_RR1() uint32 {
	return (volatile.LoadUint32(&o.REQSTATUS.Reg) & 0x2) >> 1
}
func (o *WDT_Type) SetREQSTATUS_RR2(value uint32) {
	volatile.StoreUint32(&o.REQSTATUS.Reg, volatile.LoadUint32(&o.REQSTATUS.Reg)&^(0x4)|value<<2)
}
func (o *WDT_Type) GetREQSTATUS_RR2() uint32 {
	return (volatile.LoadUint32(&o.REQSTATUS.Reg) & 0x4) >> 2
}
func (o *WDT_Type) SetREQSTATUS_RR3(value uint32) {
	volatile.StoreUint32(&o.REQSTATUS.Reg, volatile.LoadUint32(&o.REQSTATUS.Reg)&^(0x8)|value<<3)
}
func (o *WDT_Type) GetREQSTATUS_RR3() uint32 {
	return (volatile.LoadUint32(&o.REQSTATUS.Reg) & 0x8) >> 3
}
func (o *WDT_Type) SetREQSTATUS_RR4(value uint32) {
	volatile.StoreUint32(&o.REQSTATUS.Reg, volatile.LoadUint32(&o.REQSTATUS.Reg)&^(0x10)|value<<4)
}
func (o *WDT_Type) GetREQSTATUS_RR4() uint32 {
	return (volatile.LoadUint32(&o.REQSTATUS.Reg) & 0x10) >> 4
}
func (o *WDT_Type) SetREQSTATUS_RR5(value uint32) {
	volatile.StoreUint32(&o.REQSTATUS.Reg, volatile.LoadUint32(&o.REQSTATUS.Reg)&^(0x20)|value<<5)
}
func (o *WDT_Type) GetREQSTATUS_RR5() uint32 {
	return (volatile.LoadUint32(&o.REQSTATUS.Reg) & 0x20) >> 5
}
func (o *WDT_Type) SetREQSTATUS_RR6(value uint32) {
	volatile.StoreUint32(&o.REQSTATUS.Reg, volatile.LoadUint32(&o.REQSTATUS.Reg)&^(0x40)|value<<6)
}
func (o *WDT_Type) GetREQSTATUS_RR6() uint32 {
	return (volatile.LoadUint32(&o.REQSTATUS.Reg) & 0x40) >> 6
}
func (o *WDT_Type) SetREQSTATUS_RR7(value uint32) {
	volatile.StoreUint32(&o.REQSTATUS.Reg, volatile.LoadUint32(&o.REQSTATUS.Reg)&^(0x80)|value<<7)
}
func (o *WDT_Type) GetREQSTATUS_RR7() uint32 {
	return (volatile.LoadUint32(&o.REQSTATUS.Reg) & 0x80) >> 7
}

// WDT.CRV: Counter reload value
func (o *WDT_Type) SetCRV(value uint32) {
	volatile.StoreUint32(&o.CRV.Reg, value)
}
func (o *WDT_Type) GetCRV() uint32 {
	return volatile.LoadUint32(&o.CRV.Reg)
}

// WDT.RREN: Enable register for reload request registers
func (o *WDT_Type) SetRREN_RR0(value uint32) {
	volatile.StoreUint32(&o.RREN.Reg, volatile.LoadUint32(&o.RREN.Reg)&^(0x1)|value)
}
func (o *WDT_Type) GetRREN_RR0() uint32 {
	return volatile.LoadUint32(&o.RREN.Reg) & 0x1
}
func (o *WDT_Type) SetRREN_RR1(value uint32) {
	volatile.StoreUint32(&o.RREN.Reg, volatile.LoadUint32(&o.RREN.Reg)&^(0x2)|value<<1)
}
func (o *WDT_Type) GetRREN_RR1() uint32 {
	return (volatile.LoadUint32(&o.RREN.Reg) & 0x2) >> 1
}
func (o *WDT_Type) SetRREN_RR2(value uint32) {
	volatile.StoreUint32(&o.RREN.Reg, volatile.LoadUint32(&o.RREN.Reg)&^(0x4)|value<<2)
}
func (o *WDT_Type) GetRREN_RR2() uint32 {
	return (volatile.LoadUint32(&o.RREN.Reg) & 0x4) >> 2
}
func (o *WDT_Type) SetRREN_RR3(value uint32) {
	volatile.StoreUint32(&o.RREN.Reg, volatile.LoadUint32(&o.RREN.Reg)&^(0x8)|value<<3)
}
func (o *WDT_Type) GetRREN_RR3() uint32 {
	return (volatile.LoadUint32(&o.RREN.Reg) & 0x8) >> 3
}
func (o *WDT_Type) SetRREN_RR4(value uint32) {
	volatile.StoreUint32(&o.RREN.Reg, volatile.LoadUint32(&o.RREN.Reg)&^(0x10)|value<<4)
}
func (o *WDT_Type) GetRREN_RR4() uint32 {
	return (volatile.LoadUint32(&o.RREN.Reg) & 0x10) >> 4
}
func (o *WDT_Type) SetRREN_RR5(value uint32) {
	volatile.StoreUint32(&o.RREN.Reg, volatile.LoadUint32(&o.RREN.Reg)&^(0x20)|value<<5)
}
func (o *WDT_Type) GetRREN_RR5() uint32 {
	return (volatile.LoadUint32(&o.RREN.Reg) & 0x20) >> 5
}
func (o *WDT_Type) SetRREN_RR6(value uint32) {
	volatile.StoreUint32(&o.RREN.Reg, volatile.LoadUint32(&o.RREN.Reg)&^(0x40)|value<<6)
}
func (o *WDT_Type) GetRREN_RR6() uint32 {
	return (volatile.LoadUint32(&o.RREN.Reg) & 0x40) >> 6
}
func (o *WDT_Type) SetRREN_RR7(value uint32) {
	volatile.StoreUint32(&o.RREN.Reg, volatile.LoadUint32(&o.RREN.Reg)&^(0x80)|value<<7)
}
func (o *WDT_Type) GetRREN_RR7() uint32 {
	return (volatile.LoadUint32(&o.RREN.Reg) & 0x80) >> 7
}

// WDT.CONFIG: Configuration register
func (o *WDT_Type) SetCONFIG_SLEEP(value uint32) {
	volatile.StoreUint32(&o.CONFIG.Reg, volatile.LoadUint32(&o.CONFIG.Reg)&^(0x1)|value)
}
func (o *WDT_Type) GetCONFIG_SLEEP() uint32 {
	return volatile.LoadUint32(&o.CONFIG.Reg) & 0x1
}
func (o *WDT_Type) SetCONFIG_HALT(value uint32) {
	volatile.StoreUint32(&o.CONFIG.Reg, volatile.LoadUint32(&o.CONFIG.Reg)&^(0x8)|value<<3)
}
func (o *WDT_Type) GetCONFIG_HALT() uint32 {
	return (volatile.LoadUint32(&o.CONFIG.Reg) & 0x8) >> 3
}
func (o *WDT_Type) SetCONFIG_STOPEN(value uint32) {
	volatile.StoreUint32(&o.CONFIG.Reg, volatile.LoadUint32(&o.CONFIG.Reg)&^(0x40)|value<<6)
}
func (o *WDT_Type) GetCONFIG_STOPEN() uint32 {
	return (volatile.LoadUint32(&o.CONFIG.Reg) & 0x40) >> 6
}

// WDT.TSEN: Task Stop Enable
func (o *WDT_Type) SetTSEN(value uint32) {
	volatile.StoreUint32(&o.TSEN.Reg, value)
}
func (o *WDT_Type) GetTSEN() uint32 {
	return volatile.LoadUint32(&o.TSEN.Reg)
}

// WDT.RR: Description collection: Reload request n
func (o *WDT_Type) SetRR(idx int, value uint32) {
	volatile.StoreUint32(&o.RR[idx].Reg, value)
}
func (o *WDT_Type) GetRR(idx int) uint32 {
	return volatile.LoadUint32(&o.RR[idx].Reg)
}

// Timer/Counter 0
type TIMER_Type struct {
	TASKS_START        volatile.Register32 // 0x0
	TASKS_STOP         volatile.Register32 // 0x4
	TASKS_COUNT        volatile.Register32 // 0x8
	TASKS_CLEAR        volatile.Register32 // 0xC
	TASKS_SHUTDOWN     volatile.Register32 // 0x10
	_                  [44]byte
	TASKS_CAPTURE      [8]volatile.Register32 // 0x40
	_                  [32]byte
	SUBSCRIBE_START    volatile.Register32 // 0x80
	SUBSCRIBE_STOP     volatile.Register32 // 0x84
	SUBSCRIBE_COUNT    volatile.Register32 // 0x88
	SUBSCRIBE_CLEAR    volatile.Register32 // 0x8C
	SUBSCRIBE_SHUTDOWN volatile.Register32 // 0x90
	_                  [44]byte
	SUBSCRIBE_CAPTURE  [8]volatile.Register32 // 0xC0
	_                  [96]byte
	EVENTS_COMPARE     [8]volatile.Register32 // 0x140
	_                  [96]byte
	PUBLISH_COMPARE    [8]volatile.Register32 // 0x1C0
	_                  [32]byte
	SHORTS             volatile.Register32 // 0x200
	_                  [252]byte
	INTEN              volatile.Register32 // 0x300
	INTENSET           volatile.Register32 // 0x304
	INTENCLR           volatile.Register32 // 0x308
	_                  [504]byte
	MODE               volatile.Register32 // 0x504
	BITMODE            volatile.Register32 // 0x508
	_                  [4]byte
	PRESCALER          volatile.Register32 // 0x510
	_                  [44]byte
	CC                 [8]volatile.Register32 // 0x540
	_                  [32]byte
	ONESHOTEN          [8]volatile.Register32 // 0x580
}

// TIMER.TASKS_START: Start Timer
func (o *TIMER_Type) SetTASKS_START(value uint32) {
	volatile.StoreUint32(&o.TASKS_START.Reg, volatile.LoadUint32(&o.TASKS_START.Reg)&^(0x1)|value)
}
func (o *TIMER_Type) GetTASKS_START() uint32 {
	return volatile.LoadUint32(&o.TASKS_START.Reg) & 0x1
}

// TIMER.TASKS_STOP: Stop Timer
func (o *TIMER_Type) SetTASKS_STOP(value uint32) {
	volatile.StoreUint32(&o.TASKS_STOP.Reg, volatile.LoadUint32(&o.TASKS_STOP.Reg)&^(0x1)|value)
}
func (o *TIMER_Type) GetTASKS_STOP() uint32 {
	return volatile.LoadUint32(&o.TASKS_STOP.Reg) & 0x1
}

// TIMER.TASKS_COUNT: Increment Timer (Counter mode only)
func (o *TIMER_Type) SetTASKS_COUNT(value uint32) {
	volatile.StoreUint32(&o.TASKS_COUNT.Reg, volatile.LoadUint32(&o.TASKS_COUNT.Reg)&^(0x1)|value)
}
func (o *TIMER_Type) GetTASKS_COUNT() uint32 {
	return volatile.LoadUint32(&o.TASKS_COUNT.Reg) & 0x1
}

// TIMER.TASKS_CLEAR: Clear time
func (o *TIMER_Type) SetTASKS_CLEAR(value uint32) {
	volatile.StoreUint32(&o.TASKS_CLEAR.Reg, volatile.LoadUint32(&o.TASKS_CLEAR.Reg)&^(0x1)|value)
}
func (o *TIMER_Type) GetTASKS_CLEAR() uint32 {
	return volatile.LoadUint32(&o.TASKS_CLEAR.Reg) & 0x1
}

// TIMER.TASKS_SHUTDOWN: Deprecated register - Shut down timer
func (o *TIMER_Type) SetTASKS_SHUTDOWN(value uint32) {
	volatile.StoreUint32(&o.TASKS_SHUTDOWN.Reg, volatile.LoadUint32(&o.TASKS_SHUTDOWN.Reg)&^(0x1)|value)
}
func (o *TIMER_Type) GetTASKS_SHUTDOWN() uint32 {
	return volatile.LoadUint32(&o.TASKS_SHUTDOWN.Reg) & 0x1
}

// TIMER.TASKS_CAPTURE: Description collection: Capture Timer value to CC[n] register
func (o *TIMER_Type) SetTASKS_CAPTURE(idx int, value uint32) {
	volatile.StoreUint32(&o.TASKS_CAPTURE[idx].Reg, volatile.LoadUint32(&o.TASKS_CAPTURE[idx].Reg)&^(0x1)|value)
}
func (o *TIMER_Type) GetTASKS_CAPTURE(idx int) uint32 {
	return volatile.LoadUint32(&o.TASKS_CAPTURE[idx].Reg) & 0x1
}

// TIMER.SUBSCRIBE_START: Subscribe configuration for task START
func (o *TIMER_Type) SetSUBSCRIBE_START_CHIDX(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_START.Reg, volatile.LoadUint32(&o.SUBSCRIBE_START.Reg)&^(0xff)|value)
}
func (o *TIMER_Type) GetSUBSCRIBE_START_CHIDX() uint32 {
	return volatile.LoadUint32(&o.SUBSCRIBE_START.Reg) & 0xff
}
func (o *TIMER_Type) SetSUBSCRIBE_START_EN(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_START.Reg, volatile.LoadUint32(&o.SUBSCRIBE_START.Reg)&^(0x80000000)|value<<31)
}
func (o *TIMER_Type) GetSUBSCRIBE_START_EN() uint32 {
	return (volatile.LoadUint32(&o.SUBSCRIBE_START.Reg) & 0x80000000) >> 31
}

// TIMER.SUBSCRIBE_STOP: Subscribe configuration for task STOP
func (o *TIMER_Type) SetSUBSCRIBE_STOP_CHIDX(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_STOP.Reg, volatile.LoadUint32(&o.SUBSCRIBE_STOP.Reg)&^(0xff)|value)
}
func (o *TIMER_Type) GetSUBSCRIBE_STOP_CHIDX() uint32 {
	return volatile.LoadUint32(&o.SUBSCRIBE_STOP.Reg) & 0xff
}
func (o *TIMER_Type) SetSUBSCRIBE_STOP_EN(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_STOP.Reg, volatile.LoadUint32(&o.SUBSCRIBE_STOP.Reg)&^(0x80000000)|value<<31)
}
func (o *TIMER_Type) GetSUBSCRIBE_STOP_EN() uint32 {
	return (volatile.LoadUint32(&o.SUBSCRIBE_STOP.Reg) & 0x80000000) >> 31
}

// TIMER.SUBSCRIBE_COUNT: Subscribe configuration for task COUNT
func (o *TIMER_Type) SetSUBSCRIBE_COUNT_CHIDX(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_COUNT.Reg, volatile.LoadUint32(&o.SUBSCRIBE_COUNT.Reg)&^(0xff)|value)
}
func (o *TIMER_Type) GetSUBSCRIBE_COUNT_CHIDX() uint32 {
	return volatile.LoadUint32(&o.SUBSCRIBE_COUNT.Reg) & 0xff
}
func (o *TIMER_Type) SetSUBSCRIBE_COUNT_EN(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_COUNT.Reg, volatile.LoadUint32(&o.SUBSCRIBE_COUNT.Reg)&^(0x80000000)|value<<31)
}
func (o *TIMER_Type) GetSUBSCRIBE_COUNT_EN() uint32 {
	return (volatile.LoadUint32(&o.SUBSCRIBE_COUNT.Reg) & 0x80000000) >> 31
}

// TIMER.SUBSCRIBE_CLEAR: Subscribe configuration for task CLEAR
func (o *TIMER_Type) SetSUBSCRIBE_CLEAR_CHIDX(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_CLEAR.Reg, volatile.LoadUint32(&o.SUBSCRIBE_CLEAR.Reg)&^(0xff)|value)
}
func (o *TIMER_Type) GetSUBSCRIBE_CLEAR_CHIDX() uint32 {
	return volatile.LoadUint32(&o.SUBSCRIBE_CLEAR.Reg) & 0xff
}
func (o *TIMER_Type) SetSUBSCRIBE_CLEAR_EN(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_CLEAR.Reg, volatile.LoadUint32(&o.SUBSCRIBE_CLEAR.Reg)&^(0x80000000)|value<<31)
}
func (o *TIMER_Type) GetSUBSCRIBE_CLEAR_EN() uint32 {
	return (volatile.LoadUint32(&o.SUBSCRIBE_CLEAR.Reg) & 0x80000000) >> 31
}

// TIMER.SUBSCRIBE_SHUTDOWN: Deprecated register - Subscribe configuration for task SHUTDOWN
func (o *TIMER_Type) SetSUBSCRIBE_SHUTDOWN_CHIDX(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_SHUTDOWN.Reg, volatile.LoadUint32(&o.SUBSCRIBE_SHUTDOWN.Reg)&^(0xff)|value)
}
func (o *TIMER_Type) GetSUBSCRIBE_SHUTDOWN_CHIDX() uint32 {
	return volatile.LoadUint32(&o.SUBSCRIBE_SHUTDOWN.Reg) & 0xff
}
func (o *TIMER_Type) SetSUBSCRIBE_SHUTDOWN_EN(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_SHUTDOWN.Reg, volatile.LoadUint32(&o.SUBSCRIBE_SHUTDOWN.Reg)&^(0x80000000)|value<<31)
}
func (o *TIMER_Type) GetSUBSCRIBE_SHUTDOWN_EN() uint32 {
	return (volatile.LoadUint32(&o.SUBSCRIBE_SHUTDOWN.Reg) & 0x80000000) >> 31
}

// TIMER.SUBSCRIBE_CAPTURE: Description collection: Subscribe configuration for task CAPTURE[n]
func (o *TIMER_Type) SetSUBSCRIBE_CAPTURE_CHIDX(idx int, value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_CAPTURE[idx].Reg, volatile.LoadUint32(&o.SUBSCRIBE_CAPTURE[idx].Reg)&^(0xff)|value)
}
func (o *TIMER_Type) GetSUBSCRIBE_CAPTURE_CHIDX(idx int) uint32 {
	return volatile.LoadUint32(&o.SUBSCRIBE_CAPTURE[idx].Reg) & 0xff
}
func (o *TIMER_Type) SetSUBSCRIBE_CAPTURE_EN(idx int, value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_CAPTURE[idx].Reg, volatile.LoadUint32(&o.SUBSCRIBE_CAPTURE[idx].Reg)&^(0x80000000)|value<<31)
}
func (o *TIMER_Type) GetSUBSCRIBE_CAPTURE_EN(idx int) uint32 {
	return (volatile.LoadUint32(&o.SUBSCRIBE_CAPTURE[idx].Reg) & 0x80000000) >> 31
}

// TIMER.EVENTS_COMPARE: Description collection: Compare event on CC[n] match
func (o *TIMER_Type) SetEVENTS_COMPARE(idx int, value uint32) {
	volatile.StoreUint32(&o.EVENTS_COMPARE[idx].Reg, volatile.LoadUint32(&o.EVENTS_COMPARE[idx].Reg)&^(0x1)|value)
}
func (o *TIMER_Type) GetEVENTS_COMPARE(idx int) uint32 {
	return volatile.LoadUint32(&o.EVENTS_COMPARE[idx].Reg) & 0x1
}

// TIMER.PUBLISH_COMPARE: Description collection: Publish configuration for event COMPARE[n]
func (o *TIMER_Type) SetPUBLISH_COMPARE_CHIDX(idx int, value uint32) {
	volatile.StoreUint32(&o.PUBLISH_COMPARE[idx].Reg, volatile.LoadUint32(&o.PUBLISH_COMPARE[idx].Reg)&^(0xff)|value)
}
func (o *TIMER_Type) GetPUBLISH_COMPARE_CHIDX(idx int) uint32 {
	return volatile.LoadUint32(&o.PUBLISH_COMPARE[idx].Reg) & 0xff
}
func (o *TIMER_Type) SetPUBLISH_COMPARE_EN(idx int, value uint32) {
	volatile.StoreUint32(&o.PUBLISH_COMPARE[idx].Reg, volatile.LoadUint32(&o.PUBLISH_COMPARE[idx].Reg)&^(0x80000000)|value<<31)
}
func (o *TIMER_Type) GetPUBLISH_COMPARE_EN(idx int) uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_COMPARE[idx].Reg) & 0x80000000) >> 31
}

// TIMER.SHORTS: Shortcuts between local events and tasks
func (o *TIMER_Type) SetSHORTS_COMPARE0_CLEAR(value uint32) {
	volatile.StoreUint32(&o.SHORTS.Reg, volatile.LoadUint32(&o.SHORTS.Reg)&^(0x1)|value)
}
func (o *TIMER_Type) GetSHORTS_COMPARE0_CLEAR() uint32 {
	return volatile.LoadUint32(&o.SHORTS.Reg) & 0x1
}
func (o *TIMER_Type) SetSHORTS_COMPARE1_CLEAR(value uint32) {
	volatile.StoreUint32(&o.SHORTS.Reg, volatile.LoadUint32(&o.SHORTS.Reg)&^(0x2)|value<<1)
}
func (o *TIMER_Type) GetSHORTS_COMPARE1_CLEAR() uint32 {
	return (volatile.LoadUint32(&o.SHORTS.Reg) & 0x2) >> 1
}
func (o *TIMER_Type) SetSHORTS_COMPARE2_CLEAR(value uint32) {
	volatile.StoreUint32(&o.SHORTS.Reg, volatile.LoadUint32(&o.SHORTS.Reg)&^(0x4)|value<<2)
}
func (o *TIMER_Type) GetSHORTS_COMPARE2_CLEAR() uint32 {
	return (volatile.LoadUint32(&o.SHORTS.Reg) & 0x4) >> 2
}
func (o *TIMER_Type) SetSHORTS_COMPARE3_CLEAR(value uint32) {
	volatile.StoreUint32(&o.SHORTS.Reg, volatile.LoadUint32(&o.SHORTS.Reg)&^(0x8)|value<<3)
}
func (o *TIMER_Type) GetSHORTS_COMPARE3_CLEAR() uint32 {
	return (volatile.LoadUint32(&o.SHORTS.Reg) & 0x8) >> 3
}
func (o *TIMER_Type) SetSHORTS_COMPARE4_CLEAR(value uint32) {
	volatile.StoreUint32(&o.SHORTS.Reg, volatile.LoadUint32(&o.SHORTS.Reg)&^(0x10)|value<<4)
}
func (o *TIMER_Type) GetSHORTS_COMPARE4_CLEAR() uint32 {
	return (volatile.LoadUint32(&o.SHORTS.Reg) & 0x10) >> 4
}
func (o *TIMER_Type) SetSHORTS_COMPARE5_CLEAR(value uint32) {
	volatile.StoreUint32(&o.SHORTS.Reg, volatile.LoadUint32(&o.SHORTS.Reg)&^(0x20)|value<<5)
}
func (o *TIMER_Type) GetSHORTS_COMPARE5_CLEAR() uint32 {
	return (volatile.LoadUint32(&o.SHORTS.Reg) & 0x20) >> 5
}
func (o *TIMER_Type) SetSHORTS_COMPARE6_CLEAR(value uint32) {
	volatile.StoreUint32(&o.SHORTS.Reg, volatile.LoadUint32(&o.SHORTS.Reg)&^(0x40)|value<<6)
}
func (o *TIMER_Type) GetSHORTS_COMPARE6_CLEAR() uint32 {
	return (volatile.LoadUint32(&o.SHORTS.Reg) & 0x40) >> 6
}
func (o *TIMER_Type) SetSHORTS_COMPARE7_CLEAR(value uint32) {
	volatile.StoreUint32(&o.SHORTS.Reg, volatile.LoadUint32(&o.SHORTS.Reg)&^(0x80)|value<<7)
}
func (o *TIMER_Type) GetSHORTS_COMPARE7_CLEAR() uint32 {
	return (volatile.LoadUint32(&o.SHORTS.Reg) & 0x80) >> 7
}
func (o *TIMER_Type) SetSHORTS_COMPARE0_STOP(value uint32) {
	volatile.StoreUint32(&o.SHORTS.Reg, volatile.LoadUint32(&o.SHORTS.Reg)&^(0x10000)|value<<16)
}
func (o *TIMER_Type) GetSHORTS_COMPARE0_STOP() uint32 {
	return (volatile.LoadUint32(&o.SHORTS.Reg) & 0x10000) >> 16
}
func (o *TIMER_Type) SetSHORTS_COMPARE1_STOP(value uint32) {
	volatile.StoreUint32(&o.SHORTS.Reg, volatile.LoadUint32(&o.SHORTS.Reg)&^(0x20000)|value<<17)
}
func (o *TIMER_Type) GetSHORTS_COMPARE1_STOP() uint32 {
	return (volatile.LoadUint32(&o.SHORTS.Reg) & 0x20000) >> 17
}
func (o *TIMER_Type) SetSHORTS_COMPARE2_STOP(value uint32) {
	volatile.StoreUint32(&o.SHORTS.Reg, volatile.LoadUint32(&o.SHORTS.Reg)&^(0x40000)|value<<18)
}
func (o *TIMER_Type) GetSHORTS_COMPARE2_STOP() uint32 {
	return (volatile.LoadUint32(&o.SHORTS.Reg) & 0x40000) >> 18
}
func (o *TIMER_Type) SetSHORTS_COMPARE3_STOP(value uint32) {
	volatile.StoreUint32(&o.SHORTS.Reg, volatile.LoadUint32(&o.SHORTS.Reg)&^(0x80000)|value<<19)
}
func (o *TIMER_Type) GetSHORTS_COMPARE3_STOP() uint32 {
	return (volatile.LoadUint32(&o.SHORTS.Reg) & 0x80000) >> 19
}
func (o *TIMER_Type) SetSHORTS_COMPARE4_STOP(value uint32) {
	volatile.StoreUint32(&o.SHORTS.Reg, volatile.LoadUint32(&o.SHORTS.Reg)&^(0x100000)|value<<20)
}
func (o *TIMER_Type) GetSHORTS_COMPARE4_STOP() uint32 {
	return (volatile.LoadUint32(&o.SHORTS.Reg) & 0x100000) >> 20
}
func (o *TIMER_Type) SetSHORTS_COMPARE5_STOP(value uint32) {
	volatile.StoreUint32(&o.SHORTS.Reg, volatile.LoadUint32(&o.SHORTS.Reg)&^(0x200000)|value<<21)
}
func (o *TIMER_Type) GetSHORTS_COMPARE5_STOP() uint32 {
	return (volatile.LoadUint32(&o.SHORTS.Reg) & 0x200000) >> 21
}
func (o *TIMER_Type) SetSHORTS_COMPARE6_STOP(value uint32) {
	volatile.StoreUint32(&o.SHORTS.Reg, volatile.LoadUint32(&o.SHORTS.Reg)&^(0x400000)|value<<22)
}
func (o *TIMER_Type) GetSHORTS_COMPARE6_STOP() uint32 {
	return (volatile.LoadUint32(&o.SHORTS.Reg) & 0x400000) >> 22
}
func (o *TIMER_Type) SetSHORTS_COMPARE7_STOP(value uint32) {
	volatile.StoreUint32(&o.SHORTS.Reg, volatile.LoadUint32(&o.SHORTS.Reg)&^(0x800000)|value<<23)
}
func (o *TIMER_Type) GetSHORTS_COMPARE7_STOP() uint32 {
	return (volatile.LoadUint32(&o.SHORTS.Reg) & 0x800000) >> 23
}

// TIMER.INTEN: Enable or disable interrupt
func (o *TIMER_Type) SetINTEN_COMPARE0(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x10000)|value<<16)
}
func (o *TIMER_Type) GetINTEN_COMPARE0() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x10000) >> 16
}
func (o *TIMER_Type) SetINTEN_COMPARE1(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x20000)|value<<17)
}
func (o *TIMER_Type) GetINTEN_COMPARE1() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x20000) >> 17
}
func (o *TIMER_Type) SetINTEN_COMPARE2(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x40000)|value<<18)
}
func (o *TIMER_Type) GetINTEN_COMPARE2() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x40000) >> 18
}
func (o *TIMER_Type) SetINTEN_COMPARE3(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x80000)|value<<19)
}
func (o *TIMER_Type) GetINTEN_COMPARE3() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x80000) >> 19
}
func (o *TIMER_Type) SetINTEN_COMPARE4(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x100000)|value<<20)
}
func (o *TIMER_Type) GetINTEN_COMPARE4() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x100000) >> 20
}
func (o *TIMER_Type) SetINTEN_COMPARE5(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x200000)|value<<21)
}
func (o *TIMER_Type) GetINTEN_COMPARE5() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x200000) >> 21
}
func (o *TIMER_Type) SetINTEN_COMPARE6(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x400000)|value<<22)
}
func (o *TIMER_Type) GetINTEN_COMPARE6() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x400000) >> 22
}
func (o *TIMER_Type) SetINTEN_COMPARE7(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x800000)|value<<23)
}
func (o *TIMER_Type) GetINTEN_COMPARE7() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x800000) >> 23
}

// TIMER.INTENSET: Enable interrupt
func (o *TIMER_Type) SetINTENSET_COMPARE0(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x10000)|value<<16)
}
func (o *TIMER_Type) GetINTENSET_COMPARE0() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x10000) >> 16
}
func (o *TIMER_Type) SetINTENSET_COMPARE1(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x20000)|value<<17)
}
func (o *TIMER_Type) GetINTENSET_COMPARE1() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x20000) >> 17
}
func (o *TIMER_Type) SetINTENSET_COMPARE2(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x40000)|value<<18)
}
func (o *TIMER_Type) GetINTENSET_COMPARE2() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x40000) >> 18
}
func (o *TIMER_Type) SetINTENSET_COMPARE3(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x80000)|value<<19)
}
func (o *TIMER_Type) GetINTENSET_COMPARE3() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x80000) >> 19
}
func (o *TIMER_Type) SetINTENSET_COMPARE4(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x100000)|value<<20)
}
func (o *TIMER_Type) GetINTENSET_COMPARE4() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x100000) >> 20
}
func (o *TIMER_Type) SetINTENSET_COMPARE5(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x200000)|value<<21)
}
func (o *TIMER_Type) GetINTENSET_COMPARE5() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x200000) >> 21
}
func (o *TIMER_Type) SetINTENSET_COMPARE6(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x400000)|value<<22)
}
func (o *TIMER_Type) GetINTENSET_COMPARE6() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x400000) >> 22
}
func (o *TIMER_Type) SetINTENSET_COMPARE7(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x800000)|value<<23)
}
func (o *TIMER_Type) GetINTENSET_COMPARE7() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x800000) >> 23
}

// TIMER.INTENCLR: Disable interrupt
func (o *TIMER_Type) SetINTENCLR_COMPARE0(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x10000)|value<<16)
}
func (o *TIMER_Type) GetINTENCLR_COMPARE0() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x10000) >> 16
}
func (o *TIMER_Type) SetINTENCLR_COMPARE1(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x20000)|value<<17)
}
func (o *TIMER_Type) GetINTENCLR_COMPARE1() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x20000) >> 17
}
func (o *TIMER_Type) SetINTENCLR_COMPARE2(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x40000)|value<<18)
}
func (o *TIMER_Type) GetINTENCLR_COMPARE2() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x40000) >> 18
}
func (o *TIMER_Type) SetINTENCLR_COMPARE3(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x80000)|value<<19)
}
func (o *TIMER_Type) GetINTENCLR_COMPARE3() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x80000) >> 19
}
func (o *TIMER_Type) SetINTENCLR_COMPARE4(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x100000)|value<<20)
}
func (o *TIMER_Type) GetINTENCLR_COMPARE4() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x100000) >> 20
}
func (o *TIMER_Type) SetINTENCLR_COMPARE5(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x200000)|value<<21)
}
func (o *TIMER_Type) GetINTENCLR_COMPARE5() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x200000) >> 21
}
func (o *TIMER_Type) SetINTENCLR_COMPARE6(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x400000)|value<<22)
}
func (o *TIMER_Type) GetINTENCLR_COMPARE6() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x400000) >> 22
}
func (o *TIMER_Type) SetINTENCLR_COMPARE7(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x800000)|value<<23)
}
func (o *TIMER_Type) GetINTENCLR_COMPARE7() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x800000) >> 23
}

// TIMER.MODE: Timer mode selection
func (o *TIMER_Type) SetMODE(value uint32) {
	volatile.StoreUint32(&o.MODE.Reg, volatile.LoadUint32(&o.MODE.Reg)&^(0x3)|value)
}
func (o *TIMER_Type) GetMODE() uint32 {
	return volatile.LoadUint32(&o.MODE.Reg) & 0x3
}

// TIMER.BITMODE: Configure the number of bits used by the TIMER
func (o *TIMER_Type) SetBITMODE(value uint32) {
	volatile.StoreUint32(&o.BITMODE.Reg, volatile.LoadUint32(&o.BITMODE.Reg)&^(0x3)|value)
}
func (o *TIMER_Type) GetBITMODE() uint32 {
	return volatile.LoadUint32(&o.BITMODE.Reg) & 0x3
}

// TIMER.PRESCALER: Timer prescaler register
func (o *TIMER_Type) SetPRESCALER(value uint32) {
	volatile.StoreUint32(&o.PRESCALER.Reg, volatile.LoadUint32(&o.PRESCALER.Reg)&^(0xf)|value)
}
func (o *TIMER_Type) GetPRESCALER() uint32 {
	return volatile.LoadUint32(&o.PRESCALER.Reg) & 0xf
}

// TIMER.CC: Description collection: Capture/Compare register n
func (o *TIMER_Type) SetCC(idx int, value uint32) {
	volatile.StoreUint32(&o.CC[idx].Reg, value)
}
func (o *TIMER_Type) GetCC(idx int) uint32 {
	return volatile.LoadUint32(&o.CC[idx].Reg)
}

// TIMER.ONESHOTEN: Description collection: Enable one-shot operation for Capture/Compare channel n
func (o *TIMER_Type) SetONESHOTEN(idx int, value uint32) {
	volatile.StoreUint32(&o.ONESHOTEN[idx].Reg, volatile.LoadUint32(&o.ONESHOTEN[idx].Reg)&^(0x1)|value)
}
func (o *TIMER_Type) GetONESHOTEN(idx int) uint32 {
	return volatile.LoadUint32(&o.ONESHOTEN[idx].Reg) & 0x1
}

// AES ECB Mode Encryption
type ECB_Type struct {
	TASKS_STARTECB     volatile.Register32 // 0x0
	TASKS_STOPECB      volatile.Register32 // 0x4
	_                  [120]byte
	SUBSCRIBE_STARTECB volatile.Register32 // 0x80
	SUBSCRIBE_STOPECB  volatile.Register32 // 0x84
	_                  [120]byte
	EVENTS_ENDECB      volatile.Register32 // 0x100
	EVENTS_ERRORECB    volatile.Register32 // 0x104
	_                  [120]byte
	PUBLISH_ENDECB     volatile.Register32 // 0x180
	PUBLISH_ERRORECB   volatile.Register32 // 0x184
	_                  [380]byte
	INTENSET           volatile.Register32 // 0x304
	INTENCLR           volatile.Register32 // 0x308
	_                  [504]byte
	ECBDATAPTR         volatile.Register32 // 0x504
}

// ECB.TASKS_STARTECB: Start ECB block encrypt
func (o *ECB_Type) SetTASKS_STARTECB(value uint32) {
	volatile.StoreUint32(&o.TASKS_STARTECB.Reg, volatile.LoadUint32(&o.TASKS_STARTECB.Reg)&^(0x1)|value)
}
func (o *ECB_Type) GetTASKS_STARTECB() uint32 {
	return volatile.LoadUint32(&o.TASKS_STARTECB.Reg) & 0x1
}

// ECB.TASKS_STOPECB: Abort a possible executing ECB operation
func (o *ECB_Type) SetTASKS_STOPECB(value uint32) {
	volatile.StoreUint32(&o.TASKS_STOPECB.Reg, volatile.LoadUint32(&o.TASKS_STOPECB.Reg)&^(0x1)|value)
}
func (o *ECB_Type) GetTASKS_STOPECB() uint32 {
	return volatile.LoadUint32(&o.TASKS_STOPECB.Reg) & 0x1
}

// ECB.SUBSCRIBE_STARTECB: Subscribe configuration for task STARTECB
func (o *ECB_Type) SetSUBSCRIBE_STARTECB_CHIDX(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_STARTECB.Reg, volatile.LoadUint32(&o.SUBSCRIBE_STARTECB.Reg)&^(0xff)|value)
}
func (o *ECB_Type) GetSUBSCRIBE_STARTECB_CHIDX() uint32 {
	return volatile.LoadUint32(&o.SUBSCRIBE_STARTECB.Reg) & 0xff
}
func (o *ECB_Type) SetSUBSCRIBE_STARTECB_EN(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_STARTECB.Reg, volatile.LoadUint32(&o.SUBSCRIBE_STARTECB.Reg)&^(0x80000000)|value<<31)
}
func (o *ECB_Type) GetSUBSCRIBE_STARTECB_EN() uint32 {
	return (volatile.LoadUint32(&o.SUBSCRIBE_STARTECB.Reg) & 0x80000000) >> 31
}

// ECB.SUBSCRIBE_STOPECB: Subscribe configuration for task STOPECB
func (o *ECB_Type) SetSUBSCRIBE_STOPECB_CHIDX(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_STOPECB.Reg, volatile.LoadUint32(&o.SUBSCRIBE_STOPECB.Reg)&^(0xff)|value)
}
func (o *ECB_Type) GetSUBSCRIBE_STOPECB_CHIDX() uint32 {
	return volatile.LoadUint32(&o.SUBSCRIBE_STOPECB.Reg) & 0xff
}
func (o *ECB_Type) SetSUBSCRIBE_STOPECB_EN(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_STOPECB.Reg, volatile.LoadUint32(&o.SUBSCRIBE_STOPECB.Reg)&^(0x80000000)|value<<31)
}
func (o *ECB_Type) GetSUBSCRIBE_STOPECB_EN() uint32 {
	return (volatile.LoadUint32(&o.SUBSCRIBE_STOPECB.Reg) & 0x80000000) >> 31
}

// ECB.EVENTS_ENDECB: ECB block encrypt complete
func (o *ECB_Type) SetEVENTS_ENDECB(value uint32) {
	volatile.StoreUint32(&o.EVENTS_ENDECB.Reg, volatile.LoadUint32(&o.EVENTS_ENDECB.Reg)&^(0x1)|value)
}
func (o *ECB_Type) GetEVENTS_ENDECB() uint32 {
	return volatile.LoadUint32(&o.EVENTS_ENDECB.Reg) & 0x1
}

// ECB.EVENTS_ERRORECB: ECB block encrypt aborted because of a STOPECB task or due to an error
func (o *ECB_Type) SetEVENTS_ERRORECB(value uint32) {
	volatile.StoreUint32(&o.EVENTS_ERRORECB.Reg, volatile.LoadUint32(&o.EVENTS_ERRORECB.Reg)&^(0x1)|value)
}
func (o *ECB_Type) GetEVENTS_ERRORECB() uint32 {
	return volatile.LoadUint32(&o.EVENTS_ERRORECB.Reg) & 0x1
}

// ECB.PUBLISH_ENDECB: Publish configuration for event ENDECB
func (o *ECB_Type) SetPUBLISH_ENDECB_CHIDX(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_ENDECB.Reg, volatile.LoadUint32(&o.PUBLISH_ENDECB.Reg)&^(0xff)|value)
}
func (o *ECB_Type) GetPUBLISH_ENDECB_CHIDX() uint32 {
	return volatile.LoadUint32(&o.PUBLISH_ENDECB.Reg) & 0xff
}
func (o *ECB_Type) SetPUBLISH_ENDECB_EN(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_ENDECB.Reg, volatile.LoadUint32(&o.PUBLISH_ENDECB.Reg)&^(0x80000000)|value<<31)
}
func (o *ECB_Type) GetPUBLISH_ENDECB_EN() uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_ENDECB.Reg) & 0x80000000) >> 31
}

// ECB.PUBLISH_ERRORECB: Publish configuration for event ERRORECB
func (o *ECB_Type) SetPUBLISH_ERRORECB_CHIDX(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_ERRORECB.Reg, volatile.LoadUint32(&o.PUBLISH_ERRORECB.Reg)&^(0xff)|value)
}
func (o *ECB_Type) GetPUBLISH_ERRORECB_CHIDX() uint32 {
	return volatile.LoadUint32(&o.PUBLISH_ERRORECB.Reg) & 0xff
}
func (o *ECB_Type) SetPUBLISH_ERRORECB_EN(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_ERRORECB.Reg, volatile.LoadUint32(&o.PUBLISH_ERRORECB.Reg)&^(0x80000000)|value<<31)
}
func (o *ECB_Type) GetPUBLISH_ERRORECB_EN() uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_ERRORECB.Reg) & 0x80000000) >> 31
}

// ECB.INTENSET: Enable interrupt
func (o *ECB_Type) SetINTENSET_ENDECB(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x1)|value)
}
func (o *ECB_Type) GetINTENSET_ENDECB() uint32 {
	return volatile.LoadUint32(&o.INTENSET.Reg) & 0x1
}
func (o *ECB_Type) SetINTENSET_ERRORECB(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x2)|value<<1)
}
func (o *ECB_Type) GetINTENSET_ERRORECB() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x2) >> 1
}

// ECB.INTENCLR: Disable interrupt
func (o *ECB_Type) SetINTENCLR_ENDECB(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x1)|value)
}
func (o *ECB_Type) GetINTENCLR_ENDECB() uint32 {
	return volatile.LoadUint32(&o.INTENCLR.Reg) & 0x1
}
func (o *ECB_Type) SetINTENCLR_ERRORECB(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x2)|value<<1)
}
func (o *ECB_Type) GetINTENCLR_ERRORECB() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x2) >> 1
}

// ECB.ECBDATAPTR: ECB block encrypt memory pointers
func (o *ECB_Type) SetECBDATAPTR(value uint32) {
	volatile.StoreUint32(&o.ECBDATAPTR.Reg, value)
}
func (o *ECB_Type) GetECBDATAPTR() uint32 {
	return volatile.LoadUint32(&o.ECBDATAPTR.Reg)
}

// Accelerated Address Resolver
type AAR_Type struct {
	TASKS_START         volatile.Register32 // 0x0
	_                   [4]byte
	TASKS_STOP          volatile.Register32 // 0x8
	_                   [116]byte
	SUBSCRIBE_START     volatile.Register32 // 0x80
	_                   [4]byte
	SUBSCRIBE_STOP      volatile.Register32 // 0x88
	_                   [116]byte
	EVENTS_END          volatile.Register32 // 0x100
	EVENTS_RESOLVED     volatile.Register32 // 0x104
	EVENTS_NOTRESOLVED  volatile.Register32 // 0x108
	_                   [116]byte
	PUBLISH_END         volatile.Register32 // 0x180
	PUBLISH_RESOLVED    volatile.Register32 // 0x184
	PUBLISH_NOTRESOLVED volatile.Register32 // 0x188
	_                   [376]byte
	INTENSET            volatile.Register32 // 0x304
	INTENCLR            volatile.Register32 // 0x308
	_                   [244]byte
	STATUS              volatile.Register32 // 0x400
	_                   [252]byte
	ENABLE              volatile.Register32 // 0x500
	NIRK                volatile.Register32 // 0x504
	IRKPTR              volatile.Register32 // 0x508
	_                   [4]byte
	ADDRPTR             volatile.Register32 // 0x510
	SCRATCHPTR          volatile.Register32 // 0x514
}

// AAR.TASKS_START: Start resolving addresses based on IRKs specified in the IRK data structure
func (o *AAR_Type) SetTASKS_START(value uint32) {
	volatile.StoreUint32(&o.TASKS_START.Reg, volatile.LoadUint32(&o.TASKS_START.Reg)&^(0x1)|value)
}
func (o *AAR_Type) GetTASKS_START() uint32 {
	return volatile.LoadUint32(&o.TASKS_START.Reg) & 0x1
}

// AAR.TASKS_STOP: Stop resolving addresses
func (o *AAR_Type) SetTASKS_STOP(value uint32) {
	volatile.StoreUint32(&o.TASKS_STOP.Reg, volatile.LoadUint32(&o.TASKS_STOP.Reg)&^(0x1)|value)
}
func (o *AAR_Type) GetTASKS_STOP() uint32 {
	return volatile.LoadUint32(&o.TASKS_STOP.Reg) & 0x1
}

// AAR.SUBSCRIBE_START: Subscribe configuration for task START
func (o *AAR_Type) SetSUBSCRIBE_START_CHIDX(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_START.Reg, volatile.LoadUint32(&o.SUBSCRIBE_START.Reg)&^(0xff)|value)
}
func (o *AAR_Type) GetSUBSCRIBE_START_CHIDX() uint32 {
	return volatile.LoadUint32(&o.SUBSCRIBE_START.Reg) & 0xff
}
func (o *AAR_Type) SetSUBSCRIBE_START_EN(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_START.Reg, volatile.LoadUint32(&o.SUBSCRIBE_START.Reg)&^(0x80000000)|value<<31)
}
func (o *AAR_Type) GetSUBSCRIBE_START_EN() uint32 {
	return (volatile.LoadUint32(&o.SUBSCRIBE_START.Reg) & 0x80000000) >> 31
}

// AAR.SUBSCRIBE_STOP: Subscribe configuration for task STOP
func (o *AAR_Type) SetSUBSCRIBE_STOP_CHIDX(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_STOP.Reg, volatile.LoadUint32(&o.SUBSCRIBE_STOP.Reg)&^(0xff)|value)
}
func (o *AAR_Type) GetSUBSCRIBE_STOP_CHIDX() uint32 {
	return volatile.LoadUint32(&o.SUBSCRIBE_STOP.Reg) & 0xff
}
func (o *AAR_Type) SetSUBSCRIBE_STOP_EN(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_STOP.Reg, volatile.LoadUint32(&o.SUBSCRIBE_STOP.Reg)&^(0x80000000)|value<<31)
}
func (o *AAR_Type) GetSUBSCRIBE_STOP_EN() uint32 {
	return (volatile.LoadUint32(&o.SUBSCRIBE_STOP.Reg) & 0x80000000) >> 31
}

// AAR.EVENTS_END: Address resolution procedure complete
func (o *AAR_Type) SetEVENTS_END(value uint32) {
	volatile.StoreUint32(&o.EVENTS_END.Reg, volatile.LoadUint32(&o.EVENTS_END.Reg)&^(0x1)|value)
}
func (o *AAR_Type) GetEVENTS_END() uint32 {
	return volatile.LoadUint32(&o.EVENTS_END.Reg) & 0x1
}

// AAR.EVENTS_RESOLVED: Address resolved
func (o *AAR_Type) SetEVENTS_RESOLVED(value uint32) {
	volatile.StoreUint32(&o.EVENTS_RESOLVED.Reg, volatile.LoadUint32(&o.EVENTS_RESOLVED.Reg)&^(0x1)|value)
}
func (o *AAR_Type) GetEVENTS_RESOLVED() uint32 {
	return volatile.LoadUint32(&o.EVENTS_RESOLVED.Reg) & 0x1
}

// AAR.EVENTS_NOTRESOLVED: Address not resolved
func (o *AAR_Type) SetEVENTS_NOTRESOLVED(value uint32) {
	volatile.StoreUint32(&o.EVENTS_NOTRESOLVED.Reg, volatile.LoadUint32(&o.EVENTS_NOTRESOLVED.Reg)&^(0x1)|value)
}
func (o *AAR_Type) GetEVENTS_NOTRESOLVED() uint32 {
	return volatile.LoadUint32(&o.EVENTS_NOTRESOLVED.Reg) & 0x1
}

// AAR.PUBLISH_END: Publish configuration for event END
func (o *AAR_Type) SetPUBLISH_END_CHIDX(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_END.Reg, volatile.LoadUint32(&o.PUBLISH_END.Reg)&^(0xff)|value)
}
func (o *AAR_Type) GetPUBLISH_END_CHIDX() uint32 {
	return volatile.LoadUint32(&o.PUBLISH_END.Reg) & 0xff
}
func (o *AAR_Type) SetPUBLISH_END_EN(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_END.Reg, volatile.LoadUint32(&o.PUBLISH_END.Reg)&^(0x80000000)|value<<31)
}
func (o *AAR_Type) GetPUBLISH_END_EN() uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_END.Reg) & 0x80000000) >> 31
}

// AAR.PUBLISH_RESOLVED: Publish configuration for event RESOLVED
func (o *AAR_Type) SetPUBLISH_RESOLVED_CHIDX(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_RESOLVED.Reg, volatile.LoadUint32(&o.PUBLISH_RESOLVED.Reg)&^(0xff)|value)
}
func (o *AAR_Type) GetPUBLISH_RESOLVED_CHIDX() uint32 {
	return volatile.LoadUint32(&o.PUBLISH_RESOLVED.Reg) & 0xff
}
func (o *AAR_Type) SetPUBLISH_RESOLVED_EN(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_RESOLVED.Reg, volatile.LoadUint32(&o.PUBLISH_RESOLVED.Reg)&^(0x80000000)|value<<31)
}
func (o *AAR_Type) GetPUBLISH_RESOLVED_EN() uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_RESOLVED.Reg) & 0x80000000) >> 31
}

// AAR.PUBLISH_NOTRESOLVED: Publish configuration for event NOTRESOLVED
func (o *AAR_Type) SetPUBLISH_NOTRESOLVED_CHIDX(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_NOTRESOLVED.Reg, volatile.LoadUint32(&o.PUBLISH_NOTRESOLVED.Reg)&^(0xff)|value)
}
func (o *AAR_Type) GetPUBLISH_NOTRESOLVED_CHIDX() uint32 {
	return volatile.LoadUint32(&o.PUBLISH_NOTRESOLVED.Reg) & 0xff
}
func (o *AAR_Type) SetPUBLISH_NOTRESOLVED_EN(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_NOTRESOLVED.Reg, volatile.LoadUint32(&o.PUBLISH_NOTRESOLVED.Reg)&^(0x80000000)|value<<31)
}
func (o *AAR_Type) GetPUBLISH_NOTRESOLVED_EN() uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_NOTRESOLVED.Reg) & 0x80000000) >> 31
}

// AAR.INTENSET: Enable interrupt
func (o *AAR_Type) SetINTENSET_END(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x1)|value)
}
func (o *AAR_Type) GetINTENSET_END() uint32 {
	return volatile.LoadUint32(&o.INTENSET.Reg) & 0x1
}
func (o *AAR_Type) SetINTENSET_RESOLVED(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x2)|value<<1)
}
func (o *AAR_Type) GetINTENSET_RESOLVED() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x2) >> 1
}
func (o *AAR_Type) SetINTENSET_NOTRESOLVED(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x4)|value<<2)
}
func (o *AAR_Type) GetINTENSET_NOTRESOLVED() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x4) >> 2
}

// AAR.INTENCLR: Disable interrupt
func (o *AAR_Type) SetINTENCLR_END(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x1)|value)
}
func (o *AAR_Type) GetINTENCLR_END() uint32 {
	return volatile.LoadUint32(&o.INTENCLR.Reg) & 0x1
}
func (o *AAR_Type) SetINTENCLR_RESOLVED(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x2)|value<<1)
}
func (o *AAR_Type) GetINTENCLR_RESOLVED() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x2) >> 1
}
func (o *AAR_Type) SetINTENCLR_NOTRESOLVED(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x4)|value<<2)
}
func (o *AAR_Type) GetINTENCLR_NOTRESOLVED() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x4) >> 2
}

// AAR.STATUS: Resolution status
func (o *AAR_Type) SetSTATUS(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0xf)|value)
}
func (o *AAR_Type) GetSTATUS() uint32 {
	return volatile.LoadUint32(&o.STATUS.Reg) & 0xf
}

// AAR.ENABLE: Enable AAR
func (o *AAR_Type) SetENABLE(value uint32) {
	volatile.StoreUint32(&o.ENABLE.Reg, volatile.LoadUint32(&o.ENABLE.Reg)&^(0x3)|value)
}
func (o *AAR_Type) GetENABLE() uint32 {
	return volatile.LoadUint32(&o.ENABLE.Reg) & 0x3
}

// AAR.NIRK: Number of IRKs
func (o *AAR_Type) SetNIRK(value uint32) {
	volatile.StoreUint32(&o.NIRK.Reg, volatile.LoadUint32(&o.NIRK.Reg)&^(0x1f)|value)
}
func (o *AAR_Type) GetNIRK() uint32 {
	return volatile.LoadUint32(&o.NIRK.Reg) & 0x1f
}

// AAR.IRKPTR: Pointer to IRK data structure
func (o *AAR_Type) SetIRKPTR(value uint32) {
	volatile.StoreUint32(&o.IRKPTR.Reg, value)
}
func (o *AAR_Type) GetIRKPTR() uint32 {
	return volatile.LoadUint32(&o.IRKPTR.Reg)
}

// AAR.ADDRPTR: Pointer to the resolvable address
func (o *AAR_Type) SetADDRPTR(value uint32) {
	volatile.StoreUint32(&o.ADDRPTR.Reg, value)
}
func (o *AAR_Type) GetADDRPTR() uint32 {
	return volatile.LoadUint32(&o.ADDRPTR.Reg)
}

// AAR.SCRATCHPTR: Pointer to data area used for temporary storage
func (o *AAR_Type) SetSCRATCHPTR(value uint32) {
	volatile.StoreUint32(&o.SCRATCHPTR.Reg, value)
}
func (o *AAR_Type) GetSCRATCHPTR() uint32 {
	return volatile.LoadUint32(&o.SCRATCHPTR.Reg)
}

// AES CCM mode encryption
type CCM_Type struct {
	TASKS_KSGEN            volatile.Register32 // 0x0
	TASKS_CRYPT            volatile.Register32 // 0x4
	TASKS_STOP             volatile.Register32 // 0x8
	TASKS_RATEOVERRIDE     volatile.Register32 // 0xC
	_                      [112]byte
	SUBSCRIBE_KSGEN        volatile.Register32 // 0x80
	SUBSCRIBE_CRYPT        volatile.Register32 // 0x84
	SUBSCRIBE_STOP         volatile.Register32 // 0x88
	SUBSCRIBE_RATEOVERRIDE volatile.Register32 // 0x8C
	_                      [112]byte
	EVENTS_ENDKSGEN        volatile.Register32 // 0x100
	EVENTS_ENDCRYPT        volatile.Register32 // 0x104
	EVENTS_ERROR           volatile.Register32 // 0x108
	_                      [116]byte
	PUBLISH_ENDKSGEN       volatile.Register32 // 0x180
	PUBLISH_ENDCRYPT       volatile.Register32 // 0x184
	PUBLISH_ERROR          volatile.Register32 // 0x188
	_                      [116]byte
	SHORTS                 volatile.Register32 // 0x200
	_                      [256]byte
	INTENSET               volatile.Register32 // 0x304
	INTENCLR               volatile.Register32 // 0x308
	_                      [244]byte
	MICSTATUS              volatile.Register32 // 0x400
	_                      [252]byte
	ENABLE                 volatile.Register32 // 0x500
	MODE                   volatile.Register32 // 0x504
	CNFPTR                 volatile.Register32 // 0x508
	INPTR                  volatile.Register32 // 0x50C
	OUTPTR                 volatile.Register32 // 0x510
	SCRATCHPTR             volatile.Register32 // 0x514
	MAXPACKETSIZE          volatile.Register32 // 0x518
	RATEOVERRIDE           volatile.Register32 // 0x51C
	HEADERMASK             volatile.Register32 // 0x520
}

// CCM.TASKS_KSGEN: Start generation of keystream. This operation will stop by itself when completed.
func (o *CCM_Type) SetTASKS_KSGEN(value uint32) {
	volatile.StoreUint32(&o.TASKS_KSGEN.Reg, volatile.LoadUint32(&o.TASKS_KSGEN.Reg)&^(0x1)|value)
}
func (o *CCM_Type) GetTASKS_KSGEN() uint32 {
	return volatile.LoadUint32(&o.TASKS_KSGEN.Reg) & 0x1
}

// CCM.TASKS_CRYPT: Start encryption/decryption. This operation will stop by itself when completed.
func (o *CCM_Type) SetTASKS_CRYPT(value uint32) {
	volatile.StoreUint32(&o.TASKS_CRYPT.Reg, volatile.LoadUint32(&o.TASKS_CRYPT.Reg)&^(0x1)|value)
}
func (o *CCM_Type) GetTASKS_CRYPT() uint32 {
	return volatile.LoadUint32(&o.TASKS_CRYPT.Reg) & 0x1
}

// CCM.TASKS_STOP: Stop encryption/decryption
func (o *CCM_Type) SetTASKS_STOP(value uint32) {
	volatile.StoreUint32(&o.TASKS_STOP.Reg, volatile.LoadUint32(&o.TASKS_STOP.Reg)&^(0x1)|value)
}
func (o *CCM_Type) GetTASKS_STOP() uint32 {
	return volatile.LoadUint32(&o.TASKS_STOP.Reg) & 0x1
}

// CCM.TASKS_RATEOVERRIDE: Override DATARATE setting in MODE register with the contents of the RATEOVERRIDE register for any ongoing encryption/decryption
func (o *CCM_Type) SetTASKS_RATEOVERRIDE(value uint32) {
	volatile.StoreUint32(&o.TASKS_RATEOVERRIDE.Reg, volatile.LoadUint32(&o.TASKS_RATEOVERRIDE.Reg)&^(0x1)|value)
}
func (o *CCM_Type) GetTASKS_RATEOVERRIDE() uint32 {
	return volatile.LoadUint32(&o.TASKS_RATEOVERRIDE.Reg) & 0x1
}

// CCM.SUBSCRIBE_KSGEN: Subscribe configuration for task KSGEN
func (o *CCM_Type) SetSUBSCRIBE_KSGEN_CHIDX(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_KSGEN.Reg, volatile.LoadUint32(&o.SUBSCRIBE_KSGEN.Reg)&^(0xff)|value)
}
func (o *CCM_Type) GetSUBSCRIBE_KSGEN_CHIDX() uint32 {
	return volatile.LoadUint32(&o.SUBSCRIBE_KSGEN.Reg) & 0xff
}
func (o *CCM_Type) SetSUBSCRIBE_KSGEN_EN(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_KSGEN.Reg, volatile.LoadUint32(&o.SUBSCRIBE_KSGEN.Reg)&^(0x80000000)|value<<31)
}
func (o *CCM_Type) GetSUBSCRIBE_KSGEN_EN() uint32 {
	return (volatile.LoadUint32(&o.SUBSCRIBE_KSGEN.Reg) & 0x80000000) >> 31
}

// CCM.SUBSCRIBE_CRYPT: Subscribe configuration for task CRYPT
func (o *CCM_Type) SetSUBSCRIBE_CRYPT_CHIDX(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_CRYPT.Reg, volatile.LoadUint32(&o.SUBSCRIBE_CRYPT.Reg)&^(0xff)|value)
}
func (o *CCM_Type) GetSUBSCRIBE_CRYPT_CHIDX() uint32 {
	return volatile.LoadUint32(&o.SUBSCRIBE_CRYPT.Reg) & 0xff
}
func (o *CCM_Type) SetSUBSCRIBE_CRYPT_EN(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_CRYPT.Reg, volatile.LoadUint32(&o.SUBSCRIBE_CRYPT.Reg)&^(0x80000000)|value<<31)
}
func (o *CCM_Type) GetSUBSCRIBE_CRYPT_EN() uint32 {
	return (volatile.LoadUint32(&o.SUBSCRIBE_CRYPT.Reg) & 0x80000000) >> 31
}

// CCM.SUBSCRIBE_STOP: Subscribe configuration for task STOP
func (o *CCM_Type) SetSUBSCRIBE_STOP_CHIDX(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_STOP.Reg, volatile.LoadUint32(&o.SUBSCRIBE_STOP.Reg)&^(0xff)|value)
}
func (o *CCM_Type) GetSUBSCRIBE_STOP_CHIDX() uint32 {
	return volatile.LoadUint32(&o.SUBSCRIBE_STOP.Reg) & 0xff
}
func (o *CCM_Type) SetSUBSCRIBE_STOP_EN(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_STOP.Reg, volatile.LoadUint32(&o.SUBSCRIBE_STOP.Reg)&^(0x80000000)|value<<31)
}
func (o *CCM_Type) GetSUBSCRIBE_STOP_EN() uint32 {
	return (volatile.LoadUint32(&o.SUBSCRIBE_STOP.Reg) & 0x80000000) >> 31
}

// CCM.SUBSCRIBE_RATEOVERRIDE: Subscribe configuration for task RATEOVERRIDE
func (o *CCM_Type) SetSUBSCRIBE_RATEOVERRIDE_CHIDX(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_RATEOVERRIDE.Reg, volatile.LoadUint32(&o.SUBSCRIBE_RATEOVERRIDE.Reg)&^(0xff)|value)
}
func (o *CCM_Type) GetSUBSCRIBE_RATEOVERRIDE_CHIDX() uint32 {
	return volatile.LoadUint32(&o.SUBSCRIBE_RATEOVERRIDE.Reg) & 0xff
}
func (o *CCM_Type) SetSUBSCRIBE_RATEOVERRIDE_EN(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_RATEOVERRIDE.Reg, volatile.LoadUint32(&o.SUBSCRIBE_RATEOVERRIDE.Reg)&^(0x80000000)|value<<31)
}
func (o *CCM_Type) GetSUBSCRIBE_RATEOVERRIDE_EN() uint32 {
	return (volatile.LoadUint32(&o.SUBSCRIBE_RATEOVERRIDE.Reg) & 0x80000000) >> 31
}

// CCM.EVENTS_ENDKSGEN: Keystream generation complete
func (o *CCM_Type) SetEVENTS_ENDKSGEN(value uint32) {
	volatile.StoreUint32(&o.EVENTS_ENDKSGEN.Reg, volatile.LoadUint32(&o.EVENTS_ENDKSGEN.Reg)&^(0x1)|value)
}
func (o *CCM_Type) GetEVENTS_ENDKSGEN() uint32 {
	return volatile.LoadUint32(&o.EVENTS_ENDKSGEN.Reg) & 0x1
}

// CCM.EVENTS_ENDCRYPT: Encrypt/decrypt complete
func (o *CCM_Type) SetEVENTS_ENDCRYPT(value uint32) {
	volatile.StoreUint32(&o.EVENTS_ENDCRYPT.Reg, volatile.LoadUint32(&o.EVENTS_ENDCRYPT.Reg)&^(0x1)|value)
}
func (o *CCM_Type) GetEVENTS_ENDCRYPT() uint32 {
	return volatile.LoadUint32(&o.EVENTS_ENDCRYPT.Reg) & 0x1
}

// CCM.EVENTS_ERROR: Deprecated register - CCM error event
func (o *CCM_Type) SetEVENTS_ERROR(value uint32) {
	volatile.StoreUint32(&o.EVENTS_ERROR.Reg, volatile.LoadUint32(&o.EVENTS_ERROR.Reg)&^(0x1)|value)
}
func (o *CCM_Type) GetEVENTS_ERROR() uint32 {
	return volatile.LoadUint32(&o.EVENTS_ERROR.Reg) & 0x1
}

// CCM.PUBLISH_ENDKSGEN: Publish configuration for event ENDKSGEN
func (o *CCM_Type) SetPUBLISH_ENDKSGEN_CHIDX(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_ENDKSGEN.Reg, volatile.LoadUint32(&o.PUBLISH_ENDKSGEN.Reg)&^(0xff)|value)
}
func (o *CCM_Type) GetPUBLISH_ENDKSGEN_CHIDX() uint32 {
	return volatile.LoadUint32(&o.PUBLISH_ENDKSGEN.Reg) & 0xff
}
func (o *CCM_Type) SetPUBLISH_ENDKSGEN_EN(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_ENDKSGEN.Reg, volatile.LoadUint32(&o.PUBLISH_ENDKSGEN.Reg)&^(0x80000000)|value<<31)
}
func (o *CCM_Type) GetPUBLISH_ENDKSGEN_EN() uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_ENDKSGEN.Reg) & 0x80000000) >> 31
}

// CCM.PUBLISH_ENDCRYPT: Publish configuration for event ENDCRYPT
func (o *CCM_Type) SetPUBLISH_ENDCRYPT_CHIDX(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_ENDCRYPT.Reg, volatile.LoadUint32(&o.PUBLISH_ENDCRYPT.Reg)&^(0xff)|value)
}
func (o *CCM_Type) GetPUBLISH_ENDCRYPT_CHIDX() uint32 {
	return volatile.LoadUint32(&o.PUBLISH_ENDCRYPT.Reg) & 0xff
}
func (o *CCM_Type) SetPUBLISH_ENDCRYPT_EN(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_ENDCRYPT.Reg, volatile.LoadUint32(&o.PUBLISH_ENDCRYPT.Reg)&^(0x80000000)|value<<31)
}
func (o *CCM_Type) GetPUBLISH_ENDCRYPT_EN() uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_ENDCRYPT.Reg) & 0x80000000) >> 31
}

// CCM.PUBLISH_ERROR: Deprecated register - Publish configuration for event ERROR
func (o *CCM_Type) SetPUBLISH_ERROR_CHIDX(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_ERROR.Reg, volatile.LoadUint32(&o.PUBLISH_ERROR.Reg)&^(0xff)|value)
}
func (o *CCM_Type) GetPUBLISH_ERROR_CHIDX() uint32 {
	return volatile.LoadUint32(&o.PUBLISH_ERROR.Reg) & 0xff
}
func (o *CCM_Type) SetPUBLISH_ERROR_EN(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_ERROR.Reg, volatile.LoadUint32(&o.PUBLISH_ERROR.Reg)&^(0x80000000)|value<<31)
}
func (o *CCM_Type) GetPUBLISH_ERROR_EN() uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_ERROR.Reg) & 0x80000000) >> 31
}

// CCM.SHORTS: Shortcuts between local events and tasks
func (o *CCM_Type) SetSHORTS_ENDKSGEN_CRYPT(value uint32) {
	volatile.StoreUint32(&o.SHORTS.Reg, volatile.LoadUint32(&o.SHORTS.Reg)&^(0x1)|value)
}
func (o *CCM_Type) GetSHORTS_ENDKSGEN_CRYPT() uint32 {
	return volatile.LoadUint32(&o.SHORTS.Reg) & 0x1
}

// CCM.INTENSET: Enable interrupt
func (o *CCM_Type) SetINTENSET_ENDKSGEN(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x1)|value)
}
func (o *CCM_Type) GetINTENSET_ENDKSGEN() uint32 {
	return volatile.LoadUint32(&o.INTENSET.Reg) & 0x1
}
func (o *CCM_Type) SetINTENSET_ENDCRYPT(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x2)|value<<1)
}
func (o *CCM_Type) GetINTENSET_ENDCRYPT() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x2) >> 1
}
func (o *CCM_Type) SetINTENSET_ERROR(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x4)|value<<2)
}
func (o *CCM_Type) GetINTENSET_ERROR() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x4) >> 2
}

// CCM.INTENCLR: Disable interrupt
func (o *CCM_Type) SetINTENCLR_ENDKSGEN(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x1)|value)
}
func (o *CCM_Type) GetINTENCLR_ENDKSGEN() uint32 {
	return volatile.LoadUint32(&o.INTENCLR.Reg) & 0x1
}
func (o *CCM_Type) SetINTENCLR_ENDCRYPT(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x2)|value<<1)
}
func (o *CCM_Type) GetINTENCLR_ENDCRYPT() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x2) >> 1
}
func (o *CCM_Type) SetINTENCLR_ERROR(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x4)|value<<2)
}
func (o *CCM_Type) GetINTENCLR_ERROR() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x4) >> 2
}

// CCM.MICSTATUS: MIC check result
func (o *CCM_Type) SetMICSTATUS(value uint32) {
	volatile.StoreUint32(&o.MICSTATUS.Reg, volatile.LoadUint32(&o.MICSTATUS.Reg)&^(0x1)|value)
}
func (o *CCM_Type) GetMICSTATUS() uint32 {
	return volatile.LoadUint32(&o.MICSTATUS.Reg) & 0x1
}

// CCM.ENABLE: Enable
func (o *CCM_Type) SetENABLE(value uint32) {
	volatile.StoreUint32(&o.ENABLE.Reg, volatile.LoadUint32(&o.ENABLE.Reg)&^(0x3)|value)
}
func (o *CCM_Type) GetENABLE() uint32 {
	return volatile.LoadUint32(&o.ENABLE.Reg) & 0x3
}

// CCM.MODE: Operation mode
func (o *CCM_Type) SetMODE(value uint32) {
	volatile.StoreUint32(&o.MODE.Reg, volatile.LoadUint32(&o.MODE.Reg)&^(0x1)|value)
}
func (o *CCM_Type) GetMODE() uint32 {
	return volatile.LoadUint32(&o.MODE.Reg) & 0x1
}
func (o *CCM_Type) SetMODE_DATARATE(value uint32) {
	volatile.StoreUint32(&o.MODE.Reg, volatile.LoadUint32(&o.MODE.Reg)&^(0x30000)|value<<16)
}
func (o *CCM_Type) GetMODE_DATARATE() uint32 {
	return (volatile.LoadUint32(&o.MODE.Reg) & 0x30000) >> 16
}
func (o *CCM_Type) SetMODE_LENGTH(value uint32) {
	volatile.StoreUint32(&o.MODE.Reg, volatile.LoadUint32(&o.MODE.Reg)&^(0x1000000)|value<<24)
}
func (o *CCM_Type) GetMODE_LENGTH() uint32 {
	return (volatile.LoadUint32(&o.MODE.Reg) & 0x1000000) >> 24
}

// CCM.CNFPTR: Pointer to data structure holding the AES key and the NONCE vector
func (o *CCM_Type) SetCNFPTR(value uint32) {
	volatile.StoreUint32(&o.CNFPTR.Reg, value)
}
func (o *CCM_Type) GetCNFPTR() uint32 {
	return volatile.LoadUint32(&o.CNFPTR.Reg)
}

// CCM.INPTR: Input pointer
func (o *CCM_Type) SetINPTR(value uint32) {
	volatile.StoreUint32(&o.INPTR.Reg, value)
}
func (o *CCM_Type) GetINPTR() uint32 {
	return volatile.LoadUint32(&o.INPTR.Reg)
}

// CCM.OUTPTR: Output pointer
func (o *CCM_Type) SetOUTPTR(value uint32) {
	volatile.StoreUint32(&o.OUTPTR.Reg, value)
}
func (o *CCM_Type) GetOUTPTR() uint32 {
	return volatile.LoadUint32(&o.OUTPTR.Reg)
}

// CCM.SCRATCHPTR: Pointer to data area used for temporary storage
func (o *CCM_Type) SetSCRATCHPTR(value uint32) {
	volatile.StoreUint32(&o.SCRATCHPTR.Reg, value)
}
func (o *CCM_Type) GetSCRATCHPTR() uint32 {
	return volatile.LoadUint32(&o.SCRATCHPTR.Reg)
}

// CCM.MAXPACKETSIZE: Length of keystream generated when MODE.LENGTH = Extended
func (o *CCM_Type) SetMAXPACKETSIZE(value uint32) {
	volatile.StoreUint32(&o.MAXPACKETSIZE.Reg, volatile.LoadUint32(&o.MAXPACKETSIZE.Reg)&^(0xff)|value)
}
func (o *CCM_Type) GetMAXPACKETSIZE() uint32 {
	return volatile.LoadUint32(&o.MAXPACKETSIZE.Reg) & 0xff
}

// CCM.RATEOVERRIDE: Data rate override setting.
func (o *CCM_Type) SetRATEOVERRIDE(value uint32) {
	volatile.StoreUint32(&o.RATEOVERRIDE.Reg, volatile.LoadUint32(&o.RATEOVERRIDE.Reg)&^(0x3)|value)
}
func (o *CCM_Type) GetRATEOVERRIDE() uint32 {
	return volatile.LoadUint32(&o.RATEOVERRIDE.Reg) & 0x3
}

// CCM.HEADERMASK: Header (S0) mask.
func (o *CCM_Type) SetHEADERMASK(value uint32) {
	volatile.StoreUint32(&o.HEADERMASK.Reg, volatile.LoadUint32(&o.HEADERMASK.Reg)&^(0xff)|value)
}
func (o *CCM_Type) GetHEADERMASK() uint32 {
	return volatile.LoadUint32(&o.HEADERMASK.Reg) & 0xff
}

// Distributed programmable peripheral interconnect controller
type DPPIC_Type struct {
	TASKS_CHG     [6]DPPIC_TASKS_CHG_Type // 0x0
	_             [80]byte
	SUBSCRIBE_CHG [6]DPPIC_SUBSCRIBE_CHG_Type // 0x80
	_             [1104]byte
	CHEN          volatile.Register32 // 0x500
	CHENSET       volatile.Register32 // 0x504
	CHENCLR       volatile.Register32 // 0x508
	_             [756]byte
	CHG           [6]volatile.Register32 // 0x800
}

// DPPIC.CHEN: Channel enable register
func (o *DPPIC_Type) SetCHEN_CH0(value uint32) {
	volatile.StoreUint32(&o.CHEN.Reg, volatile.LoadUint32(&o.CHEN.Reg)&^(0x1)|value)
}
func (o *DPPIC_Type) GetCHEN_CH0() uint32 {
	return volatile.LoadUint32(&o.CHEN.Reg) & 0x1
}
func (o *DPPIC_Type) SetCHEN_CH1(value uint32) {
	volatile.StoreUint32(&o.CHEN.Reg, volatile.LoadUint32(&o.CHEN.Reg)&^(0x2)|value<<1)
}
func (o *DPPIC_Type) GetCHEN_CH1() uint32 {
	return (volatile.LoadUint32(&o.CHEN.Reg) & 0x2) >> 1
}
func (o *DPPIC_Type) SetCHEN_CH2(value uint32) {
	volatile.StoreUint32(&o.CHEN.Reg, volatile.LoadUint32(&o.CHEN.Reg)&^(0x4)|value<<2)
}
func (o *DPPIC_Type) GetCHEN_CH2() uint32 {
	return (volatile.LoadUint32(&o.CHEN.Reg) & 0x4) >> 2
}
func (o *DPPIC_Type) SetCHEN_CH3(value uint32) {
	volatile.StoreUint32(&o.CHEN.Reg, volatile.LoadUint32(&o.CHEN.Reg)&^(0x8)|value<<3)
}
func (o *DPPIC_Type) GetCHEN_CH3() uint32 {
	return (volatile.LoadUint32(&o.CHEN.Reg) & 0x8) >> 3
}
func (o *DPPIC_Type) SetCHEN_CH4(value uint32) {
	volatile.StoreUint32(&o.CHEN.Reg, volatile.LoadUint32(&o.CHEN.Reg)&^(0x10)|value<<4)
}
func (o *DPPIC_Type) GetCHEN_CH4() uint32 {
	return (volatile.LoadUint32(&o.CHEN.Reg) & 0x10) >> 4
}
func (o *DPPIC_Type) SetCHEN_CH5(value uint32) {
	volatile.StoreUint32(&o.CHEN.Reg, volatile.LoadUint32(&o.CHEN.Reg)&^(0x20)|value<<5)
}
func (o *DPPIC_Type) GetCHEN_CH5() uint32 {
	return (volatile.LoadUint32(&o.CHEN.Reg) & 0x20) >> 5
}
func (o *DPPIC_Type) SetCHEN_CH6(value uint32) {
	volatile.StoreUint32(&o.CHEN.Reg, volatile.LoadUint32(&o.CHEN.Reg)&^(0x40)|value<<6)
}
func (o *DPPIC_Type) GetCHEN_CH6() uint32 {
	return (volatile.LoadUint32(&o.CHEN.Reg) & 0x40) >> 6
}
func (o *DPPIC_Type) SetCHEN_CH7(value uint32) {
	volatile.StoreUint32(&o.CHEN.Reg, volatile.LoadUint32(&o.CHEN.Reg)&^(0x80)|value<<7)
}
func (o *DPPIC_Type) GetCHEN_CH7() uint32 {
	return (volatile.LoadUint32(&o.CHEN.Reg) & 0x80) >> 7
}
func (o *DPPIC_Type) SetCHEN_CH8(value uint32) {
	volatile.StoreUint32(&o.CHEN.Reg, volatile.LoadUint32(&o.CHEN.Reg)&^(0x100)|value<<8)
}
func (o *DPPIC_Type) GetCHEN_CH8() uint32 {
	return (volatile.LoadUint32(&o.CHEN.Reg) & 0x100) >> 8
}
func (o *DPPIC_Type) SetCHEN_CH9(value uint32) {
	volatile.StoreUint32(&o.CHEN.Reg, volatile.LoadUint32(&o.CHEN.Reg)&^(0x200)|value<<9)
}
func (o *DPPIC_Type) GetCHEN_CH9() uint32 {
	return (volatile.LoadUint32(&o.CHEN.Reg) & 0x200) >> 9
}
func (o *DPPIC_Type) SetCHEN_CH10(value uint32) {
	volatile.StoreUint32(&o.CHEN.Reg, volatile.LoadUint32(&o.CHEN.Reg)&^(0x400)|value<<10)
}
func (o *DPPIC_Type) GetCHEN_CH10() uint32 {
	return (volatile.LoadUint32(&o.CHEN.Reg) & 0x400) >> 10
}
func (o *DPPIC_Type) SetCHEN_CH11(value uint32) {
	volatile.StoreUint32(&o.CHEN.Reg, volatile.LoadUint32(&o.CHEN.Reg)&^(0x800)|value<<11)
}
func (o *DPPIC_Type) GetCHEN_CH11() uint32 {
	return (volatile.LoadUint32(&o.CHEN.Reg) & 0x800) >> 11
}
func (o *DPPIC_Type) SetCHEN_CH12(value uint32) {
	volatile.StoreUint32(&o.CHEN.Reg, volatile.LoadUint32(&o.CHEN.Reg)&^(0x1000)|value<<12)
}
func (o *DPPIC_Type) GetCHEN_CH12() uint32 {
	return (volatile.LoadUint32(&o.CHEN.Reg) & 0x1000) >> 12
}
func (o *DPPIC_Type) SetCHEN_CH13(value uint32) {
	volatile.StoreUint32(&o.CHEN.Reg, volatile.LoadUint32(&o.CHEN.Reg)&^(0x2000)|value<<13)
}
func (o *DPPIC_Type) GetCHEN_CH13() uint32 {
	return (volatile.LoadUint32(&o.CHEN.Reg) & 0x2000) >> 13
}
func (o *DPPIC_Type) SetCHEN_CH14(value uint32) {
	volatile.StoreUint32(&o.CHEN.Reg, volatile.LoadUint32(&o.CHEN.Reg)&^(0x4000)|value<<14)
}
func (o *DPPIC_Type) GetCHEN_CH14() uint32 {
	return (volatile.LoadUint32(&o.CHEN.Reg) & 0x4000) >> 14
}
func (o *DPPIC_Type) SetCHEN_CH15(value uint32) {
	volatile.StoreUint32(&o.CHEN.Reg, volatile.LoadUint32(&o.CHEN.Reg)&^(0x8000)|value<<15)
}
func (o *DPPIC_Type) GetCHEN_CH15() uint32 {
	return (volatile.LoadUint32(&o.CHEN.Reg) & 0x8000) >> 15
}

// DPPIC.CHENSET: Channel enable set register
func (o *DPPIC_Type) SetCHENSET_CH0(value uint32) {
	volatile.StoreUint32(&o.CHENSET.Reg, volatile.LoadUint32(&o.CHENSET.Reg)&^(0x1)|value)
}
func (o *DPPIC_Type) GetCHENSET_CH0() uint32 {
	return volatile.LoadUint32(&o.CHENSET.Reg) & 0x1
}
func (o *DPPIC_Type) SetCHENSET_CH1(value uint32) {
	volatile.StoreUint32(&o.CHENSET.Reg, volatile.LoadUint32(&o.CHENSET.Reg)&^(0x2)|value<<1)
}
func (o *DPPIC_Type) GetCHENSET_CH1() uint32 {
	return (volatile.LoadUint32(&o.CHENSET.Reg) & 0x2) >> 1
}
func (o *DPPIC_Type) SetCHENSET_CH2(value uint32) {
	volatile.StoreUint32(&o.CHENSET.Reg, volatile.LoadUint32(&o.CHENSET.Reg)&^(0x4)|value<<2)
}
func (o *DPPIC_Type) GetCHENSET_CH2() uint32 {
	return (volatile.LoadUint32(&o.CHENSET.Reg) & 0x4) >> 2
}
func (o *DPPIC_Type) SetCHENSET_CH3(value uint32) {
	volatile.StoreUint32(&o.CHENSET.Reg, volatile.LoadUint32(&o.CHENSET.Reg)&^(0x8)|value<<3)
}
func (o *DPPIC_Type) GetCHENSET_CH3() uint32 {
	return (volatile.LoadUint32(&o.CHENSET.Reg) & 0x8) >> 3
}
func (o *DPPIC_Type) SetCHENSET_CH4(value uint32) {
	volatile.StoreUint32(&o.CHENSET.Reg, volatile.LoadUint32(&o.CHENSET.Reg)&^(0x10)|value<<4)
}
func (o *DPPIC_Type) GetCHENSET_CH4() uint32 {
	return (volatile.LoadUint32(&o.CHENSET.Reg) & 0x10) >> 4
}
func (o *DPPIC_Type) SetCHENSET_CH5(value uint32) {
	volatile.StoreUint32(&o.CHENSET.Reg, volatile.LoadUint32(&o.CHENSET.Reg)&^(0x20)|value<<5)
}
func (o *DPPIC_Type) GetCHENSET_CH5() uint32 {
	return (volatile.LoadUint32(&o.CHENSET.Reg) & 0x20) >> 5
}
func (o *DPPIC_Type) SetCHENSET_CH6(value uint32) {
	volatile.StoreUint32(&o.CHENSET.Reg, volatile.LoadUint32(&o.CHENSET.Reg)&^(0x40)|value<<6)
}
func (o *DPPIC_Type) GetCHENSET_CH6() uint32 {
	return (volatile.LoadUint32(&o.CHENSET.Reg) & 0x40) >> 6
}
func (o *DPPIC_Type) SetCHENSET_CH7(value uint32) {
	volatile.StoreUint32(&o.CHENSET.Reg, volatile.LoadUint32(&o.CHENSET.Reg)&^(0x80)|value<<7)
}
func (o *DPPIC_Type) GetCHENSET_CH7() uint32 {
	return (volatile.LoadUint32(&o.CHENSET.Reg) & 0x80) >> 7
}
func (o *DPPIC_Type) SetCHENSET_CH8(value uint32) {
	volatile.StoreUint32(&o.CHENSET.Reg, volatile.LoadUint32(&o.CHENSET.Reg)&^(0x100)|value<<8)
}
func (o *DPPIC_Type) GetCHENSET_CH8() uint32 {
	return (volatile.LoadUint32(&o.CHENSET.Reg) & 0x100) >> 8
}
func (o *DPPIC_Type) SetCHENSET_CH9(value uint32) {
	volatile.StoreUint32(&o.CHENSET.Reg, volatile.LoadUint32(&o.CHENSET.Reg)&^(0x200)|value<<9)
}
func (o *DPPIC_Type) GetCHENSET_CH9() uint32 {
	return (volatile.LoadUint32(&o.CHENSET.Reg) & 0x200) >> 9
}
func (o *DPPIC_Type) SetCHENSET_CH10(value uint32) {
	volatile.StoreUint32(&o.CHENSET.Reg, volatile.LoadUint32(&o.CHENSET.Reg)&^(0x400)|value<<10)
}
func (o *DPPIC_Type) GetCHENSET_CH10() uint32 {
	return (volatile.LoadUint32(&o.CHENSET.Reg) & 0x400) >> 10
}
func (o *DPPIC_Type) SetCHENSET_CH11(value uint32) {
	volatile.StoreUint32(&o.CHENSET.Reg, volatile.LoadUint32(&o.CHENSET.Reg)&^(0x800)|value<<11)
}
func (o *DPPIC_Type) GetCHENSET_CH11() uint32 {
	return (volatile.LoadUint32(&o.CHENSET.Reg) & 0x800) >> 11
}
func (o *DPPIC_Type) SetCHENSET_CH12(value uint32) {
	volatile.StoreUint32(&o.CHENSET.Reg, volatile.LoadUint32(&o.CHENSET.Reg)&^(0x1000)|value<<12)
}
func (o *DPPIC_Type) GetCHENSET_CH12() uint32 {
	return (volatile.LoadUint32(&o.CHENSET.Reg) & 0x1000) >> 12
}
func (o *DPPIC_Type) SetCHENSET_CH13(value uint32) {
	volatile.StoreUint32(&o.CHENSET.Reg, volatile.LoadUint32(&o.CHENSET.Reg)&^(0x2000)|value<<13)
}
func (o *DPPIC_Type) GetCHENSET_CH13() uint32 {
	return (volatile.LoadUint32(&o.CHENSET.Reg) & 0x2000) >> 13
}
func (o *DPPIC_Type) SetCHENSET_CH14(value uint32) {
	volatile.StoreUint32(&o.CHENSET.Reg, volatile.LoadUint32(&o.CHENSET.Reg)&^(0x4000)|value<<14)
}
func (o *DPPIC_Type) GetCHENSET_CH14() uint32 {
	return (volatile.LoadUint32(&o.CHENSET.Reg) & 0x4000) >> 14
}
func (o *DPPIC_Type) SetCHENSET_CH15(value uint32) {
	volatile.StoreUint32(&o.CHENSET.Reg, volatile.LoadUint32(&o.CHENSET.Reg)&^(0x8000)|value<<15)
}
func (o *DPPIC_Type) GetCHENSET_CH15() uint32 {
	return (volatile.LoadUint32(&o.CHENSET.Reg) & 0x8000) >> 15
}

// DPPIC.CHENCLR: Channel enable clear register
func (o *DPPIC_Type) SetCHENCLR_CH0(value uint32) {
	volatile.StoreUint32(&o.CHENCLR.Reg, volatile.LoadUint32(&o.CHENCLR.Reg)&^(0x1)|value)
}
func (o *DPPIC_Type) GetCHENCLR_CH0() uint32 {
	return volatile.LoadUint32(&o.CHENCLR.Reg) & 0x1
}
func (o *DPPIC_Type) SetCHENCLR_CH1(value uint32) {
	volatile.StoreUint32(&o.CHENCLR.Reg, volatile.LoadUint32(&o.CHENCLR.Reg)&^(0x2)|value<<1)
}
func (o *DPPIC_Type) GetCHENCLR_CH1() uint32 {
	return (volatile.LoadUint32(&o.CHENCLR.Reg) & 0x2) >> 1
}
func (o *DPPIC_Type) SetCHENCLR_CH2(value uint32) {
	volatile.StoreUint32(&o.CHENCLR.Reg, volatile.LoadUint32(&o.CHENCLR.Reg)&^(0x4)|value<<2)
}
func (o *DPPIC_Type) GetCHENCLR_CH2() uint32 {
	return (volatile.LoadUint32(&o.CHENCLR.Reg) & 0x4) >> 2
}
func (o *DPPIC_Type) SetCHENCLR_CH3(value uint32) {
	volatile.StoreUint32(&o.CHENCLR.Reg, volatile.LoadUint32(&o.CHENCLR.Reg)&^(0x8)|value<<3)
}
func (o *DPPIC_Type) GetCHENCLR_CH3() uint32 {
	return (volatile.LoadUint32(&o.CHENCLR.Reg) & 0x8) >> 3
}
func (o *DPPIC_Type) SetCHENCLR_CH4(value uint32) {
	volatile.StoreUint32(&o.CHENCLR.Reg, volatile.LoadUint32(&o.CHENCLR.Reg)&^(0x10)|value<<4)
}
func (o *DPPIC_Type) GetCHENCLR_CH4() uint32 {
	return (volatile.LoadUint32(&o.CHENCLR.Reg) & 0x10) >> 4
}
func (o *DPPIC_Type) SetCHENCLR_CH5(value uint32) {
	volatile.StoreUint32(&o.CHENCLR.Reg, volatile.LoadUint32(&o.CHENCLR.Reg)&^(0x20)|value<<5)
}
func (o *DPPIC_Type) GetCHENCLR_CH5() uint32 {
	return (volatile.LoadUint32(&o.CHENCLR.Reg) & 0x20) >> 5
}
func (o *DPPIC_Type) SetCHENCLR_CH6(value uint32) {
	volatile.StoreUint32(&o.CHENCLR.Reg, volatile.LoadUint32(&o.CHENCLR.Reg)&^(0x40)|value<<6)
}
func (o *DPPIC_Type) GetCHENCLR_CH6() uint32 {
	return (volatile.LoadUint32(&o.CHENCLR.Reg) & 0x40) >> 6
}
func (o *DPPIC_Type) SetCHENCLR_CH7(value uint32) {
	volatile.StoreUint32(&o.CHENCLR.Reg, volatile.LoadUint32(&o.CHENCLR.Reg)&^(0x80)|value<<7)
}
func (o *DPPIC_Type) GetCHENCLR_CH7() uint32 {
	return (volatile.LoadUint32(&o.CHENCLR.Reg) & 0x80) >> 7
}
func (o *DPPIC_Type) SetCHENCLR_CH8(value uint32) {
	volatile.StoreUint32(&o.CHENCLR.Reg, volatile.LoadUint32(&o.CHENCLR.Reg)&^(0x100)|value<<8)
}
func (o *DPPIC_Type) GetCHENCLR_CH8() uint32 {
	return (volatile.LoadUint32(&o.CHENCLR.Reg) & 0x100) >> 8
}
func (o *DPPIC_Type) SetCHENCLR_CH9(value uint32) {
	volatile.StoreUint32(&o.CHENCLR.Reg, volatile.LoadUint32(&o.CHENCLR.Reg)&^(0x200)|value<<9)
}
func (o *DPPIC_Type) GetCHENCLR_CH9() uint32 {
	return (volatile.LoadUint32(&o.CHENCLR.Reg) & 0x200) >> 9
}
func (o *DPPIC_Type) SetCHENCLR_CH10(value uint32) {
	volatile.StoreUint32(&o.CHENCLR.Reg, volatile.LoadUint32(&o.CHENCLR.Reg)&^(0x400)|value<<10)
}
func (o *DPPIC_Type) GetCHENCLR_CH10() uint32 {
	return (volatile.LoadUint32(&o.CHENCLR.Reg) & 0x400) >> 10
}
func (o *DPPIC_Type) SetCHENCLR_CH11(value uint32) {
	volatile.StoreUint32(&o.CHENCLR.Reg, volatile.LoadUint32(&o.CHENCLR.Reg)&^(0x800)|value<<11)
}
func (o *DPPIC_Type) GetCHENCLR_CH11() uint32 {
	return (volatile.LoadUint32(&o.CHENCLR.Reg) & 0x800) >> 11
}
func (o *DPPIC_Type) SetCHENCLR_CH12(value uint32) {
	volatile.StoreUint32(&o.CHENCLR.Reg, volatile.LoadUint32(&o.CHENCLR.Reg)&^(0x1000)|value<<12)
}
func (o *DPPIC_Type) GetCHENCLR_CH12() uint32 {
	return (volatile.LoadUint32(&o.CHENCLR.Reg) & 0x1000) >> 12
}
func (o *DPPIC_Type) SetCHENCLR_CH13(value uint32) {
	volatile.StoreUint32(&o.CHENCLR.Reg, volatile.LoadUint32(&o.CHENCLR.Reg)&^(0x2000)|value<<13)
}
func (o *DPPIC_Type) GetCHENCLR_CH13() uint32 {
	return (volatile.LoadUint32(&o.CHENCLR.Reg) & 0x2000) >> 13
}
func (o *DPPIC_Type) SetCHENCLR_CH14(value uint32) {
	volatile.StoreUint32(&o.CHENCLR.Reg, volatile.LoadUint32(&o.CHENCLR.Reg)&^(0x4000)|value<<14)
}
func (o *DPPIC_Type) GetCHENCLR_CH14() uint32 {
	return (volatile.LoadUint32(&o.CHENCLR.Reg) & 0x4000) >> 14
}
func (o *DPPIC_Type) SetCHENCLR_CH15(value uint32) {
	volatile.StoreUint32(&o.CHENCLR.Reg, volatile.LoadUint32(&o.CHENCLR.Reg)&^(0x8000)|value<<15)
}
func (o *DPPIC_Type) GetCHENCLR_CH15() uint32 {
	return (volatile.LoadUint32(&o.CHENCLR.Reg) & 0x8000) >> 15
}

// DPPIC.CHG: Description collection: Channel group n Note: Writes to this register are ignored if either SUBSCRIBE_CHG[n].EN or SUBSCRIBE_CHG[n].DIS is enabled
func (o *DPPIC_Type) SetCHG_CH0(idx int, value uint32) {
	volatile.StoreUint32(&o.CHG[idx].Reg, volatile.LoadUint32(&o.CHG[idx].Reg)&^(0x1)|value)
}
func (o *DPPIC_Type) GetCHG_CH0(idx int) uint32 {
	return volatile.LoadUint32(&o.CHG[idx].Reg) & 0x1
}
func (o *DPPIC_Type) SetCHG_CH1(idx int, value uint32) {
	volatile.StoreUint32(&o.CHG[idx].Reg, volatile.LoadUint32(&o.CHG[idx].Reg)&^(0x2)|value<<1)
}
func (o *DPPIC_Type) GetCHG_CH1(idx int) uint32 {
	return (volatile.LoadUint32(&o.CHG[idx].Reg) & 0x2) >> 1
}
func (o *DPPIC_Type) SetCHG_CH2(idx int, value uint32) {
	volatile.StoreUint32(&o.CHG[idx].Reg, volatile.LoadUint32(&o.CHG[idx].Reg)&^(0x4)|value<<2)
}
func (o *DPPIC_Type) GetCHG_CH2(idx int) uint32 {
	return (volatile.LoadUint32(&o.CHG[idx].Reg) & 0x4) >> 2
}
func (o *DPPIC_Type) SetCHG_CH3(idx int, value uint32) {
	volatile.StoreUint32(&o.CHG[idx].Reg, volatile.LoadUint32(&o.CHG[idx].Reg)&^(0x8)|value<<3)
}
func (o *DPPIC_Type) GetCHG_CH3(idx int) uint32 {
	return (volatile.LoadUint32(&o.CHG[idx].Reg) & 0x8) >> 3
}
func (o *DPPIC_Type) SetCHG_CH4(idx int, value uint32) {
	volatile.StoreUint32(&o.CHG[idx].Reg, volatile.LoadUint32(&o.CHG[idx].Reg)&^(0x10)|value<<4)
}
func (o *DPPIC_Type) GetCHG_CH4(idx int) uint32 {
	return (volatile.LoadUint32(&o.CHG[idx].Reg) & 0x10) >> 4
}
func (o *DPPIC_Type) SetCHG_CH5(idx int, value uint32) {
	volatile.StoreUint32(&o.CHG[idx].Reg, volatile.LoadUint32(&o.CHG[idx].Reg)&^(0x20)|value<<5)
}
func (o *DPPIC_Type) GetCHG_CH5(idx int) uint32 {
	return (volatile.LoadUint32(&o.CHG[idx].Reg) & 0x20) >> 5
}
func (o *DPPIC_Type) SetCHG_CH6(idx int, value uint32) {
	volatile.StoreUint32(&o.CHG[idx].Reg, volatile.LoadUint32(&o.CHG[idx].Reg)&^(0x40)|value<<6)
}
func (o *DPPIC_Type) GetCHG_CH6(idx int) uint32 {
	return (volatile.LoadUint32(&o.CHG[idx].Reg) & 0x40) >> 6
}
func (o *DPPIC_Type) SetCHG_CH7(idx int, value uint32) {
	volatile.StoreUint32(&o.CHG[idx].Reg, volatile.LoadUint32(&o.CHG[idx].Reg)&^(0x80)|value<<7)
}
func (o *DPPIC_Type) GetCHG_CH7(idx int) uint32 {
	return (volatile.LoadUint32(&o.CHG[idx].Reg) & 0x80) >> 7
}
func (o *DPPIC_Type) SetCHG_CH8(idx int, value uint32) {
	volatile.StoreUint32(&o.CHG[idx].Reg, volatile.LoadUint32(&o.CHG[idx].Reg)&^(0x100)|value<<8)
}
func (o *DPPIC_Type) GetCHG_CH8(idx int) uint32 {
	return (volatile.LoadUint32(&o.CHG[idx].Reg) & 0x100) >> 8
}
func (o *DPPIC_Type) SetCHG_CH9(idx int, value uint32) {
	volatile.StoreUint32(&o.CHG[idx].Reg, volatile.LoadUint32(&o.CHG[idx].Reg)&^(0x200)|value<<9)
}
func (o *DPPIC_Type) GetCHG_CH9(idx int) uint32 {
	return (volatile.LoadUint32(&o.CHG[idx].Reg) & 0x200) >> 9
}
func (o *DPPIC_Type) SetCHG_CH10(idx int, value uint32) {
	volatile.StoreUint32(&o.CHG[idx].Reg, volatile.LoadUint32(&o.CHG[idx].Reg)&^(0x400)|value<<10)
}
func (o *DPPIC_Type) GetCHG_CH10(idx int) uint32 {
	return (volatile.LoadUint32(&o.CHG[idx].Reg) & 0x400) >> 10
}
func (o *DPPIC_Type) SetCHG_CH11(idx int, value uint32) {
	volatile.StoreUint32(&o.CHG[idx].Reg, volatile.LoadUint32(&o.CHG[idx].Reg)&^(0x800)|value<<11)
}
func (o *DPPIC_Type) GetCHG_CH11(idx int) uint32 {
	return (volatile.LoadUint32(&o.CHG[idx].Reg) & 0x800) >> 11
}
func (o *DPPIC_Type) SetCHG_CH12(idx int, value uint32) {
	volatile.StoreUint32(&o.CHG[idx].Reg, volatile.LoadUint32(&o.CHG[idx].Reg)&^(0x1000)|value<<12)
}
func (o *DPPIC_Type) GetCHG_CH12(idx int) uint32 {
	return (volatile.LoadUint32(&o.CHG[idx].Reg) & 0x1000) >> 12
}
func (o *DPPIC_Type) SetCHG_CH13(idx int, value uint32) {
	volatile.StoreUint32(&o.CHG[idx].Reg, volatile.LoadUint32(&o.CHG[idx].Reg)&^(0x2000)|value<<13)
}
func (o *DPPIC_Type) GetCHG_CH13(idx int) uint32 {
	return (volatile.LoadUint32(&o.CHG[idx].Reg) & 0x2000) >> 13
}
func (o *DPPIC_Type) SetCHG_CH14(idx int, value uint32) {
	volatile.StoreUint32(&o.CHG[idx].Reg, volatile.LoadUint32(&o.CHG[idx].Reg)&^(0x4000)|value<<14)
}
func (o *DPPIC_Type) GetCHG_CH14(idx int) uint32 {
	return (volatile.LoadUint32(&o.CHG[idx].Reg) & 0x4000) >> 14
}
func (o *DPPIC_Type) SetCHG_CH15(idx int, value uint32) {
	volatile.StoreUint32(&o.CHG[idx].Reg, volatile.LoadUint32(&o.CHG[idx].Reg)&^(0x8000)|value<<15)
}
func (o *DPPIC_Type) GetCHG_CH15(idx int) uint32 {
	return (volatile.LoadUint32(&o.CHG[idx].Reg) & 0x8000) >> 15
}

// Channel group tasks
type DPPIC_TASKS_CHG_Type struct {
	EN  volatile.Register32 // 0x0
	DIS volatile.Register32 // 0x4
}

// DPPIC_TASKS_CHG.EN: Description cluster: Enable channel group n
func (o *DPPIC_TASKS_CHG_Type) SetEN(value uint32) {
	volatile.StoreUint32(&o.EN.Reg, volatile.LoadUint32(&o.EN.Reg)&^(0x1)|value)
}
func (o *DPPIC_TASKS_CHG_Type) GetEN() uint32 {
	return volatile.LoadUint32(&o.EN.Reg) & 0x1
}

// DPPIC_TASKS_CHG.DIS: Description cluster: Disable channel group n
func (o *DPPIC_TASKS_CHG_Type) SetDIS(value uint32) {
	volatile.StoreUint32(&o.DIS.Reg, volatile.LoadUint32(&o.DIS.Reg)&^(0x1)|value)
}
func (o *DPPIC_TASKS_CHG_Type) GetDIS() uint32 {
	return volatile.LoadUint32(&o.DIS.Reg) & 0x1
}

// Subscribe configuration for tasks
type DPPIC_SUBSCRIBE_CHG_Type struct {
	EN  volatile.Register32 // 0x80
	DIS volatile.Register32 // 0x84
}

// DPPIC_SUBSCRIBE_CHG.EN: Description cluster: Subscribe configuration for task CHG[n].EN
func (o *DPPIC_SUBSCRIBE_CHG_Type) SetEN_CHIDX(value uint32) {
	volatile.StoreUint32(&o.EN.Reg, volatile.LoadUint32(&o.EN.Reg)&^(0xff)|value)
}
func (o *DPPIC_SUBSCRIBE_CHG_Type) GetEN_CHIDX() uint32 {
	return volatile.LoadUint32(&o.EN.Reg) & 0xff
}
func (o *DPPIC_SUBSCRIBE_CHG_Type) SetEN(value uint32) {
	volatile.StoreUint32(&o.EN.Reg, volatile.LoadUint32(&o.EN.Reg)&^(0x80000000)|value<<31)
}
func (o *DPPIC_SUBSCRIBE_CHG_Type) GetEN() uint32 {
	return (volatile.LoadUint32(&o.EN.Reg) & 0x80000000) >> 31
}

// DPPIC_SUBSCRIBE_CHG.DIS: Description cluster: Subscribe configuration for task CHG[n].DIS
func (o *DPPIC_SUBSCRIBE_CHG_Type) SetDIS_CHIDX(value uint32) {
	volatile.StoreUint32(&o.DIS.Reg, volatile.LoadUint32(&o.DIS.Reg)&^(0xff)|value)
}
func (o *DPPIC_SUBSCRIBE_CHG_Type) GetDIS_CHIDX() uint32 {
	return volatile.LoadUint32(&o.DIS.Reg) & 0xff
}
func (o *DPPIC_SUBSCRIBE_CHG_Type) SetDIS_EN(value uint32) {
	volatile.StoreUint32(&o.DIS.Reg, volatile.LoadUint32(&o.DIS.Reg)&^(0x80000000)|value<<31)
}
func (o *DPPIC_SUBSCRIBE_CHG_Type) GetDIS_EN() uint32 {
	return (volatile.LoadUint32(&o.DIS.Reg) & 0x80000000) >> 31
}

// Temperature Sensor
type TEMP_Type struct {
	TASKS_START     volatile.Register32 // 0x0
	TASKS_STOP      volatile.Register32 // 0x4
	_               [120]byte
	SUBSCRIBE_START volatile.Register32 // 0x80
	SUBSCRIBE_STOP  volatile.Register32 // 0x84
	_               [120]byte
	EVENTS_DATARDY  volatile.Register32 // 0x100
	_               [124]byte
	PUBLISH_DATARDY volatile.Register32 // 0x180
	_               [384]byte
	INTENSET        volatile.Register32 // 0x304
	INTENCLR        volatile.Register32 // 0x308
	_               [508]byte
	TEMP            volatile.Register32 // 0x508
	_               [20]byte
	A0              volatile.Register32 // 0x520
	A1              volatile.Register32 // 0x524
	A2              volatile.Register32 // 0x528
	A3              volatile.Register32 // 0x52C
	A4              volatile.Register32 // 0x530
	A5              volatile.Register32 // 0x534
	_               [8]byte
	B0              volatile.Register32 // 0x540
	B1              volatile.Register32 // 0x544
	B2              volatile.Register32 // 0x548
	B3              volatile.Register32 // 0x54C
	B4              volatile.Register32 // 0x550
	B5              volatile.Register32 // 0x554
	_               [8]byte
	T0              volatile.Register32 // 0x560
	T1              volatile.Register32 // 0x564
	T2              volatile.Register32 // 0x568
	T3              volatile.Register32 // 0x56C
	T4              volatile.Register32 // 0x570
}

// TEMP.TASKS_START: Start temperature measurement
func (o *TEMP_Type) SetTASKS_START(value uint32) {
	volatile.StoreUint32(&o.TASKS_START.Reg, volatile.LoadUint32(&o.TASKS_START.Reg)&^(0x1)|value)
}
func (o *TEMP_Type) GetTASKS_START() uint32 {
	return volatile.LoadUint32(&o.TASKS_START.Reg) & 0x1
}

// TEMP.TASKS_STOP: Stop temperature measurement
func (o *TEMP_Type) SetTASKS_STOP(value uint32) {
	volatile.StoreUint32(&o.TASKS_STOP.Reg, volatile.LoadUint32(&o.TASKS_STOP.Reg)&^(0x1)|value)
}
func (o *TEMP_Type) GetTASKS_STOP() uint32 {
	return volatile.LoadUint32(&o.TASKS_STOP.Reg) & 0x1
}

// TEMP.SUBSCRIBE_START: Subscribe configuration for task START
func (o *TEMP_Type) SetSUBSCRIBE_START_CHIDX(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_START.Reg, volatile.LoadUint32(&o.SUBSCRIBE_START.Reg)&^(0xff)|value)
}
func (o *TEMP_Type) GetSUBSCRIBE_START_CHIDX() uint32 {
	return volatile.LoadUint32(&o.SUBSCRIBE_START.Reg) & 0xff
}
func (o *TEMP_Type) SetSUBSCRIBE_START_EN(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_START.Reg, volatile.LoadUint32(&o.SUBSCRIBE_START.Reg)&^(0x80000000)|value<<31)
}
func (o *TEMP_Type) GetSUBSCRIBE_START_EN() uint32 {
	return (volatile.LoadUint32(&o.SUBSCRIBE_START.Reg) & 0x80000000) >> 31
}

// TEMP.SUBSCRIBE_STOP: Subscribe configuration for task STOP
func (o *TEMP_Type) SetSUBSCRIBE_STOP_CHIDX(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_STOP.Reg, volatile.LoadUint32(&o.SUBSCRIBE_STOP.Reg)&^(0xff)|value)
}
func (o *TEMP_Type) GetSUBSCRIBE_STOP_CHIDX() uint32 {
	return volatile.LoadUint32(&o.SUBSCRIBE_STOP.Reg) & 0xff
}
func (o *TEMP_Type) SetSUBSCRIBE_STOP_EN(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_STOP.Reg, volatile.LoadUint32(&o.SUBSCRIBE_STOP.Reg)&^(0x80000000)|value<<31)
}
func (o *TEMP_Type) GetSUBSCRIBE_STOP_EN() uint32 {
	return (volatile.LoadUint32(&o.SUBSCRIBE_STOP.Reg) & 0x80000000) >> 31
}

// TEMP.EVENTS_DATARDY: Temperature measurement complete, data ready
func (o *TEMP_Type) SetEVENTS_DATARDY(value uint32) {
	volatile.StoreUint32(&o.EVENTS_DATARDY.Reg, volatile.LoadUint32(&o.EVENTS_DATARDY.Reg)&^(0x1)|value)
}
func (o *TEMP_Type) GetEVENTS_DATARDY() uint32 {
	return volatile.LoadUint32(&o.EVENTS_DATARDY.Reg) & 0x1
}

// TEMP.PUBLISH_DATARDY: Publish configuration for event DATARDY
func (o *TEMP_Type) SetPUBLISH_DATARDY_CHIDX(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_DATARDY.Reg, volatile.LoadUint32(&o.PUBLISH_DATARDY.Reg)&^(0xff)|value)
}
func (o *TEMP_Type) GetPUBLISH_DATARDY_CHIDX() uint32 {
	return volatile.LoadUint32(&o.PUBLISH_DATARDY.Reg) & 0xff
}
func (o *TEMP_Type) SetPUBLISH_DATARDY_EN(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_DATARDY.Reg, volatile.LoadUint32(&o.PUBLISH_DATARDY.Reg)&^(0x80000000)|value<<31)
}
func (o *TEMP_Type) GetPUBLISH_DATARDY_EN() uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_DATARDY.Reg) & 0x80000000) >> 31
}

// TEMP.INTENSET: Enable interrupt
func (o *TEMP_Type) SetINTENSET_DATARDY(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x1)|value)
}
func (o *TEMP_Type) GetINTENSET_DATARDY() uint32 {
	return volatile.LoadUint32(&o.INTENSET.Reg) & 0x1
}

// TEMP.INTENCLR: Disable interrupt
func (o *TEMP_Type) SetINTENCLR_DATARDY(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x1)|value)
}
func (o *TEMP_Type) GetINTENCLR_DATARDY() uint32 {
	return volatile.LoadUint32(&o.INTENCLR.Reg) & 0x1
}

// TEMP.TEMP: Temperature in degC (0.25deg steps)
func (o *TEMP_Type) SetTEMP(value uint32) {
	volatile.StoreUint32(&o.TEMP.Reg, value)
}
func (o *TEMP_Type) GetTEMP() uint32 {
	return volatile.LoadUint32(&o.TEMP.Reg)
}

// TEMP.A0: Slope of 1st piece wise linear function
func (o *TEMP_Type) SetA0(value uint32) {
	volatile.StoreUint32(&o.A0.Reg, volatile.LoadUint32(&o.A0.Reg)&^(0xfff)|value)
}
func (o *TEMP_Type) GetA0() uint32 {
	return volatile.LoadUint32(&o.A0.Reg) & 0xfff
}

// TEMP.A1: Slope of 2nd piece wise linear function
func (o *TEMP_Type) SetA1(value uint32) {
	volatile.StoreUint32(&o.A1.Reg, volatile.LoadUint32(&o.A1.Reg)&^(0xfff)|value)
}
func (o *TEMP_Type) GetA1() uint32 {
	return volatile.LoadUint32(&o.A1.Reg) & 0xfff
}

// TEMP.A2: Slope of 3rd piece wise linear function
func (o *TEMP_Type) SetA2(value uint32) {
	volatile.StoreUint32(&o.A2.Reg, volatile.LoadUint32(&o.A2.Reg)&^(0xfff)|value)
}
func (o *TEMP_Type) GetA2() uint32 {
	return volatile.LoadUint32(&o.A2.Reg) & 0xfff
}

// TEMP.A3: Slope of 4th piece wise linear function
func (o *TEMP_Type) SetA3(value uint32) {
	volatile.StoreUint32(&o.A3.Reg, volatile.LoadUint32(&o.A3.Reg)&^(0xfff)|value)
}
func (o *TEMP_Type) GetA3() uint32 {
	return volatile.LoadUint32(&o.A3.Reg) & 0xfff
}

// TEMP.A4: Slope of 5th piece wise linear function
func (o *TEMP_Type) SetA4(value uint32) {
	volatile.StoreUint32(&o.A4.Reg, volatile.LoadUint32(&o.A4.Reg)&^(0xfff)|value)
}
func (o *TEMP_Type) GetA4() uint32 {
	return volatile.LoadUint32(&o.A4.Reg) & 0xfff
}

// TEMP.A5: Slope of 6th piece wise linear function
func (o *TEMP_Type) SetA5(value uint32) {
	volatile.StoreUint32(&o.A5.Reg, volatile.LoadUint32(&o.A5.Reg)&^(0xfff)|value)
}
func (o *TEMP_Type) GetA5() uint32 {
	return volatile.LoadUint32(&o.A5.Reg) & 0xfff
}

// TEMP.B0: y-intercept of 1st piece wise linear function
func (o *TEMP_Type) SetB0(value uint32) {
	volatile.StoreUint32(&o.B0.Reg, volatile.LoadUint32(&o.B0.Reg)&^(0xfff)|value)
}
func (o *TEMP_Type) GetB0() uint32 {
	return volatile.LoadUint32(&o.B0.Reg) & 0xfff
}

// TEMP.B1: y-intercept of 2nd piece wise linear function
func (o *TEMP_Type) SetB1(value uint32) {
	volatile.StoreUint32(&o.B1.Reg, volatile.LoadUint32(&o.B1.Reg)&^(0xfff)|value)
}
func (o *TEMP_Type) GetB1() uint32 {
	return volatile.LoadUint32(&o.B1.Reg) & 0xfff
}

// TEMP.B2: y-intercept of 3rd piece wise linear function
func (o *TEMP_Type) SetB2(value uint32) {
	volatile.StoreUint32(&o.B2.Reg, volatile.LoadUint32(&o.B2.Reg)&^(0xfff)|value)
}
func (o *TEMP_Type) GetB2() uint32 {
	return volatile.LoadUint32(&o.B2.Reg) & 0xfff
}

// TEMP.B3: y-intercept of 4th piece wise linear function
func (o *TEMP_Type) SetB3(value uint32) {
	volatile.StoreUint32(&o.B3.Reg, volatile.LoadUint32(&o.B3.Reg)&^(0xfff)|value)
}
func (o *TEMP_Type) GetB3() uint32 {
	return volatile.LoadUint32(&o.B3.Reg) & 0xfff
}

// TEMP.B4: y-intercept of 5th piece wise linear function
func (o *TEMP_Type) SetB4(value uint32) {
	volatile.StoreUint32(&o.B4.Reg, volatile.LoadUint32(&o.B4.Reg)&^(0xfff)|value)
}
func (o *TEMP_Type) GetB4() uint32 {
	return volatile.LoadUint32(&o.B4.Reg) & 0xfff
}

// TEMP.B5: y-intercept of 6th piece wise linear function
func (o *TEMP_Type) SetB5(value uint32) {
	volatile.StoreUint32(&o.B5.Reg, volatile.LoadUint32(&o.B5.Reg)&^(0xfff)|value)
}
func (o *TEMP_Type) GetB5() uint32 {
	return volatile.LoadUint32(&o.B5.Reg) & 0xfff
}

// TEMP.T0: End point of 1st piece wise linear function
func (o *TEMP_Type) SetT0(value uint32) {
	volatile.StoreUint32(&o.T0.Reg, volatile.LoadUint32(&o.T0.Reg)&^(0xff)|value)
}
func (o *TEMP_Type) GetT0() uint32 {
	return volatile.LoadUint32(&o.T0.Reg) & 0xff
}

// TEMP.T1: End point of 2nd piece wise linear function
func (o *TEMP_Type) SetT1(value uint32) {
	volatile.StoreUint32(&o.T1.Reg, volatile.LoadUint32(&o.T1.Reg)&^(0xff)|value)
}
func (o *TEMP_Type) GetT1() uint32 {
	return volatile.LoadUint32(&o.T1.Reg) & 0xff
}

// TEMP.T2: End point of 3rd piece wise linear function
func (o *TEMP_Type) SetT2(value uint32) {
	volatile.StoreUint32(&o.T2.Reg, volatile.LoadUint32(&o.T2.Reg)&^(0xff)|value)
}
func (o *TEMP_Type) GetT2() uint32 {
	return volatile.LoadUint32(&o.T2.Reg) & 0xff
}

// TEMP.T3: End point of 4th piece wise linear function
func (o *TEMP_Type) SetT3(value uint32) {
	volatile.StoreUint32(&o.T3.Reg, volatile.LoadUint32(&o.T3.Reg)&^(0xff)|value)
}
func (o *TEMP_Type) GetT3() uint32 {
	return volatile.LoadUint32(&o.T3.Reg) & 0xff
}

// TEMP.T4: End point of 5th piece wise linear function
func (o *TEMP_Type) SetT4(value uint32) {
	volatile.StoreUint32(&o.T4.Reg, volatile.LoadUint32(&o.T4.Reg)&^(0xff)|value)
}
func (o *TEMP_Type) GetT4() uint32 {
	return volatile.LoadUint32(&o.T4.Reg) & 0xff
}

// Real-time counter 0
type RTC_Type struct {
	TASKS_START          volatile.Register32 // 0x0
	TASKS_STOP           volatile.Register32 // 0x4
	TASKS_CLEAR          volatile.Register32 // 0x8
	TASKS_TRIGOVRFLW     volatile.Register32 // 0xC
	_                    [48]byte
	TASKS_CAPTURE        [4]volatile.Register32 // 0x40
	_                    [48]byte
	SUBSCRIBE_START      volatile.Register32 // 0x80
	SUBSCRIBE_STOP       volatile.Register32 // 0x84
	SUBSCRIBE_CLEAR      volatile.Register32 // 0x88
	SUBSCRIBE_TRIGOVRFLW volatile.Register32 // 0x8C
	_                    [48]byte
	SUBSCRIBE_CAPTURE    [4]volatile.Register32 // 0xC0
	_                    [48]byte
	EVENTS_TICK          volatile.Register32 // 0x100
	EVENTS_OVRFLW        volatile.Register32 // 0x104
	_                    [56]byte
	EVENTS_COMPARE       [4]volatile.Register32 // 0x140
	_                    [48]byte
	PUBLISH_TICK         volatile.Register32 // 0x180
	PUBLISH_OVRFLW       volatile.Register32 // 0x184
	_                    [56]byte
	PUBLISH_COMPARE      [4]volatile.Register32 // 0x1C0
	_                    [48]byte
	SHORTS               volatile.Register32 // 0x200
	_                    [256]byte
	INTENSET             volatile.Register32 // 0x304
	INTENCLR             volatile.Register32 // 0x308
	_                    [52]byte
	EVTEN                volatile.Register32 // 0x340
	EVTENSET             volatile.Register32 // 0x344
	EVTENCLR             volatile.Register32 // 0x348
	_                    [440]byte
	COUNTER              volatile.Register32 // 0x504
	PRESCALER            volatile.Register32 // 0x508
	_                    [52]byte
	CC                   [4]volatile.Register32 // 0x540
}

// RTC.TASKS_START: Start RTC counter
func (o *RTC_Type) SetTASKS_START(value uint32) {
	volatile.StoreUint32(&o.TASKS_START.Reg, volatile.LoadUint32(&o.TASKS_START.Reg)&^(0x1)|value)
}
func (o *RTC_Type) GetTASKS_START() uint32 {
	return volatile.LoadUint32(&o.TASKS_START.Reg) & 0x1
}

// RTC.TASKS_STOP: Stop RTC counter
func (o *RTC_Type) SetTASKS_STOP(value uint32) {
	volatile.StoreUint32(&o.TASKS_STOP.Reg, volatile.LoadUint32(&o.TASKS_STOP.Reg)&^(0x1)|value)
}
func (o *RTC_Type) GetTASKS_STOP() uint32 {
	return volatile.LoadUint32(&o.TASKS_STOP.Reg) & 0x1
}

// RTC.TASKS_CLEAR: Clear RTC counter
func (o *RTC_Type) SetTASKS_CLEAR(value uint32) {
	volatile.StoreUint32(&o.TASKS_CLEAR.Reg, volatile.LoadUint32(&o.TASKS_CLEAR.Reg)&^(0x1)|value)
}
func (o *RTC_Type) GetTASKS_CLEAR() uint32 {
	return volatile.LoadUint32(&o.TASKS_CLEAR.Reg) & 0x1
}

// RTC.TASKS_TRIGOVRFLW: Set counter to 0xFFFFF0
func (o *RTC_Type) SetTASKS_TRIGOVRFLW(value uint32) {
	volatile.StoreUint32(&o.TASKS_TRIGOVRFLW.Reg, volatile.LoadUint32(&o.TASKS_TRIGOVRFLW.Reg)&^(0x1)|value)
}
func (o *RTC_Type) GetTASKS_TRIGOVRFLW() uint32 {
	return volatile.LoadUint32(&o.TASKS_TRIGOVRFLW.Reg) & 0x1
}

// RTC.TASKS_CAPTURE: Description collection: Capture RTC counter to CC[n] register
func (o *RTC_Type) SetTASKS_CAPTURE(idx int, value uint32) {
	volatile.StoreUint32(&o.TASKS_CAPTURE[idx].Reg, volatile.LoadUint32(&o.TASKS_CAPTURE[idx].Reg)&^(0x1)|value)
}
func (o *RTC_Type) GetTASKS_CAPTURE(idx int) uint32 {
	return volatile.LoadUint32(&o.TASKS_CAPTURE[idx].Reg) & 0x1
}

// RTC.SUBSCRIBE_START: Subscribe configuration for task START
func (o *RTC_Type) SetSUBSCRIBE_START_CHIDX(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_START.Reg, volatile.LoadUint32(&o.SUBSCRIBE_START.Reg)&^(0xff)|value)
}
func (o *RTC_Type) GetSUBSCRIBE_START_CHIDX() uint32 {
	return volatile.LoadUint32(&o.SUBSCRIBE_START.Reg) & 0xff
}
func (o *RTC_Type) SetSUBSCRIBE_START_EN(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_START.Reg, volatile.LoadUint32(&o.SUBSCRIBE_START.Reg)&^(0x80000000)|value<<31)
}
func (o *RTC_Type) GetSUBSCRIBE_START_EN() uint32 {
	return (volatile.LoadUint32(&o.SUBSCRIBE_START.Reg) & 0x80000000) >> 31
}

// RTC.SUBSCRIBE_STOP: Subscribe configuration for task STOP
func (o *RTC_Type) SetSUBSCRIBE_STOP_CHIDX(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_STOP.Reg, volatile.LoadUint32(&o.SUBSCRIBE_STOP.Reg)&^(0xff)|value)
}
func (o *RTC_Type) GetSUBSCRIBE_STOP_CHIDX() uint32 {
	return volatile.LoadUint32(&o.SUBSCRIBE_STOP.Reg) & 0xff
}
func (o *RTC_Type) SetSUBSCRIBE_STOP_EN(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_STOP.Reg, volatile.LoadUint32(&o.SUBSCRIBE_STOP.Reg)&^(0x80000000)|value<<31)
}
func (o *RTC_Type) GetSUBSCRIBE_STOP_EN() uint32 {
	return (volatile.LoadUint32(&o.SUBSCRIBE_STOP.Reg) & 0x80000000) >> 31
}

// RTC.SUBSCRIBE_CLEAR: Subscribe configuration for task CLEAR
func (o *RTC_Type) SetSUBSCRIBE_CLEAR_CHIDX(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_CLEAR.Reg, volatile.LoadUint32(&o.SUBSCRIBE_CLEAR.Reg)&^(0xff)|value)
}
func (o *RTC_Type) GetSUBSCRIBE_CLEAR_CHIDX() uint32 {
	return volatile.LoadUint32(&o.SUBSCRIBE_CLEAR.Reg) & 0xff
}
func (o *RTC_Type) SetSUBSCRIBE_CLEAR_EN(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_CLEAR.Reg, volatile.LoadUint32(&o.SUBSCRIBE_CLEAR.Reg)&^(0x80000000)|value<<31)
}
func (o *RTC_Type) GetSUBSCRIBE_CLEAR_EN() uint32 {
	return (volatile.LoadUint32(&o.SUBSCRIBE_CLEAR.Reg) & 0x80000000) >> 31
}

// RTC.SUBSCRIBE_TRIGOVRFLW: Subscribe configuration for task TRIGOVRFLW
func (o *RTC_Type) SetSUBSCRIBE_TRIGOVRFLW_CHIDX(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_TRIGOVRFLW.Reg, volatile.LoadUint32(&o.SUBSCRIBE_TRIGOVRFLW.Reg)&^(0xff)|value)
}
func (o *RTC_Type) GetSUBSCRIBE_TRIGOVRFLW_CHIDX() uint32 {
	return volatile.LoadUint32(&o.SUBSCRIBE_TRIGOVRFLW.Reg) & 0xff
}
func (o *RTC_Type) SetSUBSCRIBE_TRIGOVRFLW_EN(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_TRIGOVRFLW.Reg, volatile.LoadUint32(&o.SUBSCRIBE_TRIGOVRFLW.Reg)&^(0x80000000)|value<<31)
}
func (o *RTC_Type) GetSUBSCRIBE_TRIGOVRFLW_EN() uint32 {
	return (volatile.LoadUint32(&o.SUBSCRIBE_TRIGOVRFLW.Reg) & 0x80000000) >> 31
}

// RTC.SUBSCRIBE_CAPTURE: Description collection: Subscribe configuration for task CAPTURE[n]
func (o *RTC_Type) SetSUBSCRIBE_CAPTURE_CHIDX(idx int, value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_CAPTURE[idx].Reg, volatile.LoadUint32(&o.SUBSCRIBE_CAPTURE[idx].Reg)&^(0xff)|value)
}
func (o *RTC_Type) GetSUBSCRIBE_CAPTURE_CHIDX(idx int) uint32 {
	return volatile.LoadUint32(&o.SUBSCRIBE_CAPTURE[idx].Reg) & 0xff
}
func (o *RTC_Type) SetSUBSCRIBE_CAPTURE_EN(idx int, value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_CAPTURE[idx].Reg, volatile.LoadUint32(&o.SUBSCRIBE_CAPTURE[idx].Reg)&^(0x80000000)|value<<31)
}
func (o *RTC_Type) GetSUBSCRIBE_CAPTURE_EN(idx int) uint32 {
	return (volatile.LoadUint32(&o.SUBSCRIBE_CAPTURE[idx].Reg) & 0x80000000) >> 31
}

// RTC.EVENTS_TICK: Event on counter increment
func (o *RTC_Type) SetEVENTS_TICK(value uint32) {
	volatile.StoreUint32(&o.EVENTS_TICK.Reg, volatile.LoadUint32(&o.EVENTS_TICK.Reg)&^(0x1)|value)
}
func (o *RTC_Type) GetEVENTS_TICK() uint32 {
	return volatile.LoadUint32(&o.EVENTS_TICK.Reg) & 0x1
}

// RTC.EVENTS_OVRFLW: Event on counter overflow
func (o *RTC_Type) SetEVENTS_OVRFLW(value uint32) {
	volatile.StoreUint32(&o.EVENTS_OVRFLW.Reg, volatile.LoadUint32(&o.EVENTS_OVRFLW.Reg)&^(0x1)|value)
}
func (o *RTC_Type) GetEVENTS_OVRFLW() uint32 {
	return volatile.LoadUint32(&o.EVENTS_OVRFLW.Reg) & 0x1
}

// RTC.EVENTS_COMPARE: Description collection: Compare event on CC[n] match
func (o *RTC_Type) SetEVENTS_COMPARE(idx int, value uint32) {
	volatile.StoreUint32(&o.EVENTS_COMPARE[idx].Reg, volatile.LoadUint32(&o.EVENTS_COMPARE[idx].Reg)&^(0x1)|value)
}
func (o *RTC_Type) GetEVENTS_COMPARE(idx int) uint32 {
	return volatile.LoadUint32(&o.EVENTS_COMPARE[idx].Reg) & 0x1
}

// RTC.PUBLISH_TICK: Publish configuration for event TICK
func (o *RTC_Type) SetPUBLISH_TICK_CHIDX(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_TICK.Reg, volatile.LoadUint32(&o.PUBLISH_TICK.Reg)&^(0xff)|value)
}
func (o *RTC_Type) GetPUBLISH_TICK_CHIDX() uint32 {
	return volatile.LoadUint32(&o.PUBLISH_TICK.Reg) & 0xff
}
func (o *RTC_Type) SetPUBLISH_TICK_EN(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_TICK.Reg, volatile.LoadUint32(&o.PUBLISH_TICK.Reg)&^(0x80000000)|value<<31)
}
func (o *RTC_Type) GetPUBLISH_TICK_EN() uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_TICK.Reg) & 0x80000000) >> 31
}

// RTC.PUBLISH_OVRFLW: Publish configuration for event OVRFLW
func (o *RTC_Type) SetPUBLISH_OVRFLW_CHIDX(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_OVRFLW.Reg, volatile.LoadUint32(&o.PUBLISH_OVRFLW.Reg)&^(0xff)|value)
}
func (o *RTC_Type) GetPUBLISH_OVRFLW_CHIDX() uint32 {
	return volatile.LoadUint32(&o.PUBLISH_OVRFLW.Reg) & 0xff
}
func (o *RTC_Type) SetPUBLISH_OVRFLW_EN(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_OVRFLW.Reg, volatile.LoadUint32(&o.PUBLISH_OVRFLW.Reg)&^(0x80000000)|value<<31)
}
func (o *RTC_Type) GetPUBLISH_OVRFLW_EN() uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_OVRFLW.Reg) & 0x80000000) >> 31
}

// RTC.PUBLISH_COMPARE: Description collection: Publish configuration for event COMPARE[n]
func (o *RTC_Type) SetPUBLISH_COMPARE_CHIDX(idx int, value uint32) {
	volatile.StoreUint32(&o.PUBLISH_COMPARE[idx].Reg, volatile.LoadUint32(&o.PUBLISH_COMPARE[idx].Reg)&^(0xff)|value)
}
func (o *RTC_Type) GetPUBLISH_COMPARE_CHIDX(idx int) uint32 {
	return volatile.LoadUint32(&o.PUBLISH_COMPARE[idx].Reg) & 0xff
}
func (o *RTC_Type) SetPUBLISH_COMPARE_EN(idx int, value uint32) {
	volatile.StoreUint32(&o.PUBLISH_COMPARE[idx].Reg, volatile.LoadUint32(&o.PUBLISH_COMPARE[idx].Reg)&^(0x80000000)|value<<31)
}
func (o *RTC_Type) GetPUBLISH_COMPARE_EN(idx int) uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_COMPARE[idx].Reg) & 0x80000000) >> 31
}

// RTC.SHORTS: Shortcuts between local events and tasks
func (o *RTC_Type) SetSHORTS_COMPARE0_CLEAR(value uint32) {
	volatile.StoreUint32(&o.SHORTS.Reg, volatile.LoadUint32(&o.SHORTS.Reg)&^(0x1)|value)
}
func (o *RTC_Type) GetSHORTS_COMPARE0_CLEAR() uint32 {
	return volatile.LoadUint32(&o.SHORTS.Reg) & 0x1
}
func (o *RTC_Type) SetSHORTS_COMPARE1_CLEAR(value uint32) {
	volatile.StoreUint32(&o.SHORTS.Reg, volatile.LoadUint32(&o.SHORTS.Reg)&^(0x2)|value<<1)
}
func (o *RTC_Type) GetSHORTS_COMPARE1_CLEAR() uint32 {
	return (volatile.LoadUint32(&o.SHORTS.Reg) & 0x2) >> 1
}
func (o *RTC_Type) SetSHORTS_COMPARE2_CLEAR(value uint32) {
	volatile.StoreUint32(&o.SHORTS.Reg, volatile.LoadUint32(&o.SHORTS.Reg)&^(0x4)|value<<2)
}
func (o *RTC_Type) GetSHORTS_COMPARE2_CLEAR() uint32 {
	return (volatile.LoadUint32(&o.SHORTS.Reg) & 0x4) >> 2
}
func (o *RTC_Type) SetSHORTS_COMPARE3_CLEAR(value uint32) {
	volatile.StoreUint32(&o.SHORTS.Reg, volatile.LoadUint32(&o.SHORTS.Reg)&^(0x8)|value<<3)
}
func (o *RTC_Type) GetSHORTS_COMPARE3_CLEAR() uint32 {
	return (volatile.LoadUint32(&o.SHORTS.Reg) & 0x8) >> 3
}

// RTC.INTENSET: Enable interrupt
func (o *RTC_Type) SetINTENSET_TICK(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x1)|value)
}
func (o *RTC_Type) GetINTENSET_TICK() uint32 {
	return volatile.LoadUint32(&o.INTENSET.Reg) & 0x1
}
func (o *RTC_Type) SetINTENSET_OVRFLW(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x2)|value<<1)
}
func (o *RTC_Type) GetINTENSET_OVRFLW() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x2) >> 1
}
func (o *RTC_Type) SetINTENSET_COMPARE0(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x10000)|value<<16)
}
func (o *RTC_Type) GetINTENSET_COMPARE0() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x10000) >> 16
}
func (o *RTC_Type) SetINTENSET_COMPARE1(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x20000)|value<<17)
}
func (o *RTC_Type) GetINTENSET_COMPARE1() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x20000) >> 17
}
func (o *RTC_Type) SetINTENSET_COMPARE2(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x40000)|value<<18)
}
func (o *RTC_Type) GetINTENSET_COMPARE2() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x40000) >> 18
}
func (o *RTC_Type) SetINTENSET_COMPARE3(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x80000)|value<<19)
}
func (o *RTC_Type) GetINTENSET_COMPARE3() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x80000) >> 19
}

// RTC.INTENCLR: Disable interrupt
func (o *RTC_Type) SetINTENCLR_TICK(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x1)|value)
}
func (o *RTC_Type) GetINTENCLR_TICK() uint32 {
	return volatile.LoadUint32(&o.INTENCLR.Reg) & 0x1
}
func (o *RTC_Type) SetINTENCLR_OVRFLW(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x2)|value<<1)
}
func (o *RTC_Type) GetINTENCLR_OVRFLW() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x2) >> 1
}
func (o *RTC_Type) SetINTENCLR_COMPARE0(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x10000)|value<<16)
}
func (o *RTC_Type) GetINTENCLR_COMPARE0() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x10000) >> 16
}
func (o *RTC_Type) SetINTENCLR_COMPARE1(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x20000)|value<<17)
}
func (o *RTC_Type) GetINTENCLR_COMPARE1() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x20000) >> 17
}
func (o *RTC_Type) SetINTENCLR_COMPARE2(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x40000)|value<<18)
}
func (o *RTC_Type) GetINTENCLR_COMPARE2() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x40000) >> 18
}
func (o *RTC_Type) SetINTENCLR_COMPARE3(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x80000)|value<<19)
}
func (o *RTC_Type) GetINTENCLR_COMPARE3() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x80000) >> 19
}

// RTC.EVTEN: Enable or disable event routing
func (o *RTC_Type) SetEVTEN_TICK(value uint32) {
	volatile.StoreUint32(&o.EVTEN.Reg, volatile.LoadUint32(&o.EVTEN.Reg)&^(0x1)|value)
}
func (o *RTC_Type) GetEVTEN_TICK() uint32 {
	return volatile.LoadUint32(&o.EVTEN.Reg) & 0x1
}
func (o *RTC_Type) SetEVTEN_OVRFLW(value uint32) {
	volatile.StoreUint32(&o.EVTEN.Reg, volatile.LoadUint32(&o.EVTEN.Reg)&^(0x2)|value<<1)
}
func (o *RTC_Type) GetEVTEN_OVRFLW() uint32 {
	return (volatile.LoadUint32(&o.EVTEN.Reg) & 0x2) >> 1
}
func (o *RTC_Type) SetEVTEN_COMPARE0(value uint32) {
	volatile.StoreUint32(&o.EVTEN.Reg, volatile.LoadUint32(&o.EVTEN.Reg)&^(0x10000)|value<<16)
}
func (o *RTC_Type) GetEVTEN_COMPARE0() uint32 {
	return (volatile.LoadUint32(&o.EVTEN.Reg) & 0x10000) >> 16
}
func (o *RTC_Type) SetEVTEN_COMPARE1(value uint32) {
	volatile.StoreUint32(&o.EVTEN.Reg, volatile.LoadUint32(&o.EVTEN.Reg)&^(0x20000)|value<<17)
}
func (o *RTC_Type) GetEVTEN_COMPARE1() uint32 {
	return (volatile.LoadUint32(&o.EVTEN.Reg) & 0x20000) >> 17
}
func (o *RTC_Type) SetEVTEN_COMPARE2(value uint32) {
	volatile.StoreUint32(&o.EVTEN.Reg, volatile.LoadUint32(&o.EVTEN.Reg)&^(0x40000)|value<<18)
}
func (o *RTC_Type) GetEVTEN_COMPARE2() uint32 {
	return (volatile.LoadUint32(&o.EVTEN.Reg) & 0x40000) >> 18
}
func (o *RTC_Type) SetEVTEN_COMPARE3(value uint32) {
	volatile.StoreUint32(&o.EVTEN.Reg, volatile.LoadUint32(&o.EVTEN.Reg)&^(0x80000)|value<<19)
}
func (o *RTC_Type) GetEVTEN_COMPARE3() uint32 {
	return (volatile.LoadUint32(&o.EVTEN.Reg) & 0x80000) >> 19
}

// RTC.EVTENSET: Enable event routing
func (o *RTC_Type) SetEVTENSET_TICK(value uint32) {
	volatile.StoreUint32(&o.EVTENSET.Reg, volatile.LoadUint32(&o.EVTENSET.Reg)&^(0x1)|value)
}
func (o *RTC_Type) GetEVTENSET_TICK() uint32 {
	return volatile.LoadUint32(&o.EVTENSET.Reg) & 0x1
}
func (o *RTC_Type) SetEVTENSET_OVRFLW(value uint32) {
	volatile.StoreUint32(&o.EVTENSET.Reg, volatile.LoadUint32(&o.EVTENSET.Reg)&^(0x2)|value<<1)
}
func (o *RTC_Type) GetEVTENSET_OVRFLW() uint32 {
	return (volatile.LoadUint32(&o.EVTENSET.Reg) & 0x2) >> 1
}
func (o *RTC_Type) SetEVTENSET_COMPARE0(value uint32) {
	volatile.StoreUint32(&o.EVTENSET.Reg, volatile.LoadUint32(&o.EVTENSET.Reg)&^(0x10000)|value<<16)
}
func (o *RTC_Type) GetEVTENSET_COMPARE0() uint32 {
	return (volatile.LoadUint32(&o.EVTENSET.Reg) & 0x10000) >> 16
}
func (o *RTC_Type) SetEVTENSET_COMPARE1(value uint32) {
	volatile.StoreUint32(&o.EVTENSET.Reg, volatile.LoadUint32(&o.EVTENSET.Reg)&^(0x20000)|value<<17)
}
func (o *RTC_Type) GetEVTENSET_COMPARE1() uint32 {
	return (volatile.LoadUint32(&o.EVTENSET.Reg) & 0x20000) >> 17
}
func (o *RTC_Type) SetEVTENSET_COMPARE2(value uint32) {
	volatile.StoreUint32(&o.EVTENSET.Reg, volatile.LoadUint32(&o.EVTENSET.Reg)&^(0x40000)|value<<18)
}
func (o *RTC_Type) GetEVTENSET_COMPARE2() uint32 {
	return (volatile.LoadUint32(&o.EVTENSET.Reg) & 0x40000) >> 18
}
func (o *RTC_Type) SetEVTENSET_COMPARE3(value uint32) {
	volatile.StoreUint32(&o.EVTENSET.Reg, volatile.LoadUint32(&o.EVTENSET.Reg)&^(0x80000)|value<<19)
}
func (o *RTC_Type) GetEVTENSET_COMPARE3() uint32 {
	return (volatile.LoadUint32(&o.EVTENSET.Reg) & 0x80000) >> 19
}

// RTC.EVTENCLR: Disable event routing
func (o *RTC_Type) SetEVTENCLR_TICK(value uint32) {
	volatile.StoreUint32(&o.EVTENCLR.Reg, volatile.LoadUint32(&o.EVTENCLR.Reg)&^(0x1)|value)
}
func (o *RTC_Type) GetEVTENCLR_TICK() uint32 {
	return volatile.LoadUint32(&o.EVTENCLR.Reg) & 0x1
}
func (o *RTC_Type) SetEVTENCLR_OVRFLW(value uint32) {
	volatile.StoreUint32(&o.EVTENCLR.Reg, volatile.LoadUint32(&o.EVTENCLR.Reg)&^(0x2)|value<<1)
}
func (o *RTC_Type) GetEVTENCLR_OVRFLW() uint32 {
	return (volatile.LoadUint32(&o.EVTENCLR.Reg) & 0x2) >> 1
}
func (o *RTC_Type) SetEVTENCLR_COMPARE0(value uint32) {
	volatile.StoreUint32(&o.EVTENCLR.Reg, volatile.LoadUint32(&o.EVTENCLR.Reg)&^(0x10000)|value<<16)
}
func (o *RTC_Type) GetEVTENCLR_COMPARE0() uint32 {
	return (volatile.LoadUint32(&o.EVTENCLR.Reg) & 0x10000) >> 16
}
func (o *RTC_Type) SetEVTENCLR_COMPARE1(value uint32) {
	volatile.StoreUint32(&o.EVTENCLR.Reg, volatile.LoadUint32(&o.EVTENCLR.Reg)&^(0x20000)|value<<17)
}
func (o *RTC_Type) GetEVTENCLR_COMPARE1() uint32 {
	return (volatile.LoadUint32(&o.EVTENCLR.Reg) & 0x20000) >> 17
}
func (o *RTC_Type) SetEVTENCLR_COMPARE2(value uint32) {
	volatile.StoreUint32(&o.EVTENCLR.Reg, volatile.LoadUint32(&o.EVTENCLR.Reg)&^(0x40000)|value<<18)
}
func (o *RTC_Type) GetEVTENCLR_COMPARE2() uint32 {
	return (volatile.LoadUint32(&o.EVTENCLR.Reg) & 0x40000) >> 18
}
func (o *RTC_Type) SetEVTENCLR_COMPARE3(value uint32) {
	volatile.StoreUint32(&o.EVTENCLR.Reg, volatile.LoadUint32(&o.EVTENCLR.Reg)&^(0x80000)|value<<19)
}
func (o *RTC_Type) GetEVTENCLR_COMPARE3() uint32 {
	return (volatile.LoadUint32(&o.EVTENCLR.Reg) & 0x80000) >> 19
}

// RTC.COUNTER: Current counter value
func (o *RTC_Type) SetCOUNTER(value uint32) {
	volatile.StoreUint32(&o.COUNTER.Reg, volatile.LoadUint32(&o.COUNTER.Reg)&^(0xffffff)|value)
}
func (o *RTC_Type) GetCOUNTER() uint32 {
	return volatile.LoadUint32(&o.COUNTER.Reg) & 0xffffff
}

// RTC.PRESCALER: 12-bit prescaler for counter frequency (32768/(PRESCALER+1)). Must be written when RTC is stopped.
func (o *RTC_Type) SetPRESCALER(value uint32) {
	volatile.StoreUint32(&o.PRESCALER.Reg, volatile.LoadUint32(&o.PRESCALER.Reg)&^(0xfff)|value)
}
func (o *RTC_Type) GetPRESCALER() uint32 {
	return volatile.LoadUint32(&o.PRESCALER.Reg) & 0xfff
}

// RTC.CC: Description collection: Compare register n
func (o *RTC_Type) SetCC_COMPARE(idx int, value uint32) {
	volatile.StoreUint32(&o.CC[idx].Reg, volatile.LoadUint32(&o.CC[idx].Reg)&^(0xffffff)|value)
}
func (o *RTC_Type) GetCC_COMPARE(idx int) uint32 {
	return volatile.LoadUint32(&o.CC[idx].Reg) & 0xffffff
}

// Interprocessor communication
type IPC_Type struct {
	TASKS_SEND      [16]volatile.Register32 // 0x0
	_               [64]byte
	SUBSCRIBE_SEND  [16]volatile.Register32 // 0x80
	_               [64]byte
	EVENTS_RECEIVE  [16]volatile.Register32 // 0x100
	_               [64]byte
	PUBLISH_RECEIVE [16]volatile.Register32 // 0x180
	_               [320]byte
	INTEN           volatile.Register32 // 0x300
	INTENSET        volatile.Register32 // 0x304
	INTENCLR        volatile.Register32 // 0x308
	INTPEND         volatile.Register32 // 0x30C
	_               [512]byte
	SEND_CNF        [16]volatile.Register32 // 0x510
	_               [64]byte
	RECEIVE_CNF     [16]volatile.Register32 // 0x590
	_               [64]byte
	GPMEM           [2]volatile.Register32 // 0x610
}

// IPC.TASKS_SEND: Description collection: Trigger events on IPC channel enabled in SEND_CNF[n]
func (o *IPC_Type) SetTASKS_SEND(idx int, value uint32) {
	volatile.StoreUint32(&o.TASKS_SEND[idx].Reg, volatile.LoadUint32(&o.TASKS_SEND[idx].Reg)&^(0x1)|value)
}
func (o *IPC_Type) GetTASKS_SEND(idx int) uint32 {
	return volatile.LoadUint32(&o.TASKS_SEND[idx].Reg) & 0x1
}

// IPC.SUBSCRIBE_SEND: Description collection: Subscribe configuration for task SEND[n]
func (o *IPC_Type) SetSUBSCRIBE_SEND_CHIDX(idx int, value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_SEND[idx].Reg, volatile.LoadUint32(&o.SUBSCRIBE_SEND[idx].Reg)&^(0xff)|value)
}
func (o *IPC_Type) GetSUBSCRIBE_SEND_CHIDX(idx int) uint32 {
	return volatile.LoadUint32(&o.SUBSCRIBE_SEND[idx].Reg) & 0xff
}
func (o *IPC_Type) SetSUBSCRIBE_SEND_EN(idx int, value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_SEND[idx].Reg, volatile.LoadUint32(&o.SUBSCRIBE_SEND[idx].Reg)&^(0x80000000)|value<<31)
}
func (o *IPC_Type) GetSUBSCRIBE_SEND_EN(idx int) uint32 {
	return (volatile.LoadUint32(&o.SUBSCRIBE_SEND[idx].Reg) & 0x80000000) >> 31
}

// IPC.EVENTS_RECEIVE: Description collection: Event received on one or more of the enabled IPC channels in RECEIVE_CNF[n]
func (o *IPC_Type) SetEVENTS_RECEIVE(idx int, value uint32) {
	volatile.StoreUint32(&o.EVENTS_RECEIVE[idx].Reg, volatile.LoadUint32(&o.EVENTS_RECEIVE[idx].Reg)&^(0x1)|value)
}
func (o *IPC_Type) GetEVENTS_RECEIVE(idx int) uint32 {
	return volatile.LoadUint32(&o.EVENTS_RECEIVE[idx].Reg) & 0x1
}

// IPC.PUBLISH_RECEIVE: Description collection: Publish configuration for event RECEIVE[n]
func (o *IPC_Type) SetPUBLISH_RECEIVE_CHIDX(idx int, value uint32) {
	volatile.StoreUint32(&o.PUBLISH_RECEIVE[idx].Reg, volatile.LoadUint32(&o.PUBLISH_RECEIVE[idx].Reg)&^(0xff)|value)
}
func (o *IPC_Type) GetPUBLISH_RECEIVE_CHIDX(idx int) uint32 {
	return volatile.LoadUint32(&o.PUBLISH_RECEIVE[idx].Reg) & 0xff
}
func (o *IPC_Type) SetPUBLISH_RECEIVE_EN(idx int, value uint32) {
	volatile.StoreUint32(&o.PUBLISH_RECEIVE[idx].Reg, volatile.LoadUint32(&o.PUBLISH_RECEIVE[idx].Reg)&^(0x80000000)|value<<31)
}
func (o *IPC_Type) GetPUBLISH_RECEIVE_EN(idx int) uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_RECEIVE[idx].Reg) & 0x80000000) >> 31
}

// IPC.INTEN: Enable or disable interrupt
func (o *IPC_Type) SetINTEN_RECEIVE0(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x1)|value)
}
func (o *IPC_Type) GetINTEN_RECEIVE0() uint32 {
	return volatile.LoadUint32(&o.INTEN.Reg) & 0x1
}
func (o *IPC_Type) SetINTEN_RECEIVE1(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x2)|value<<1)
}
func (o *IPC_Type) GetINTEN_RECEIVE1() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x2) >> 1
}
func (o *IPC_Type) SetINTEN_RECEIVE2(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x4)|value<<2)
}
func (o *IPC_Type) GetINTEN_RECEIVE2() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x4) >> 2
}
func (o *IPC_Type) SetINTEN_RECEIVE3(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x8)|value<<3)
}
func (o *IPC_Type) GetINTEN_RECEIVE3() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x8) >> 3
}
func (o *IPC_Type) SetINTEN_RECEIVE4(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x10)|value<<4)
}
func (o *IPC_Type) GetINTEN_RECEIVE4() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x10) >> 4
}
func (o *IPC_Type) SetINTEN_RECEIVE5(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x20)|value<<5)
}
func (o *IPC_Type) GetINTEN_RECEIVE5() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x20) >> 5
}
func (o *IPC_Type) SetINTEN_RECEIVE6(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x40)|value<<6)
}
func (o *IPC_Type) GetINTEN_RECEIVE6() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x40) >> 6
}
func (o *IPC_Type) SetINTEN_RECEIVE7(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x80)|value<<7)
}
func (o *IPC_Type) GetINTEN_RECEIVE7() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x80) >> 7
}
func (o *IPC_Type) SetINTEN_RECEIVE8(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x100)|value<<8)
}
func (o *IPC_Type) GetINTEN_RECEIVE8() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x100) >> 8
}
func (o *IPC_Type) SetINTEN_RECEIVE9(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x200)|value<<9)
}
func (o *IPC_Type) GetINTEN_RECEIVE9() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x200) >> 9
}
func (o *IPC_Type) SetINTEN_RECEIVE10(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x400)|value<<10)
}
func (o *IPC_Type) GetINTEN_RECEIVE10() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x400) >> 10
}
func (o *IPC_Type) SetINTEN_RECEIVE11(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x800)|value<<11)
}
func (o *IPC_Type) GetINTEN_RECEIVE11() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x800) >> 11
}
func (o *IPC_Type) SetINTEN_RECEIVE12(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x1000)|value<<12)
}
func (o *IPC_Type) GetINTEN_RECEIVE12() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x1000) >> 12
}
func (o *IPC_Type) SetINTEN_RECEIVE13(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x2000)|value<<13)
}
func (o *IPC_Type) GetINTEN_RECEIVE13() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x2000) >> 13
}
func (o *IPC_Type) SetINTEN_RECEIVE14(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x4000)|value<<14)
}
func (o *IPC_Type) GetINTEN_RECEIVE14() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x4000) >> 14
}
func (o *IPC_Type) SetINTEN_RECEIVE15(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x8000)|value<<15)
}
func (o *IPC_Type) GetINTEN_RECEIVE15() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x8000) >> 15
}

// IPC.INTENSET: Enable interrupt
func (o *IPC_Type) SetINTENSET_RECEIVE0(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x1)|value)
}
func (o *IPC_Type) GetINTENSET_RECEIVE0() uint32 {
	return volatile.LoadUint32(&o.INTENSET.Reg) & 0x1
}
func (o *IPC_Type) SetINTENSET_RECEIVE1(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x2)|value<<1)
}
func (o *IPC_Type) GetINTENSET_RECEIVE1() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x2) >> 1
}
func (o *IPC_Type) SetINTENSET_RECEIVE2(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x4)|value<<2)
}
func (o *IPC_Type) GetINTENSET_RECEIVE2() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x4) >> 2
}
func (o *IPC_Type) SetINTENSET_RECEIVE3(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x8)|value<<3)
}
func (o *IPC_Type) GetINTENSET_RECEIVE3() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x8) >> 3
}
func (o *IPC_Type) SetINTENSET_RECEIVE4(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x10)|value<<4)
}
func (o *IPC_Type) GetINTENSET_RECEIVE4() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x10) >> 4
}
func (o *IPC_Type) SetINTENSET_RECEIVE5(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x20)|value<<5)
}
func (o *IPC_Type) GetINTENSET_RECEIVE5() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x20) >> 5
}
func (o *IPC_Type) SetINTENSET_RECEIVE6(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x40)|value<<6)
}
func (o *IPC_Type) GetINTENSET_RECEIVE6() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x40) >> 6
}
func (o *IPC_Type) SetINTENSET_RECEIVE7(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x80)|value<<7)
}
func (o *IPC_Type) GetINTENSET_RECEIVE7() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x80) >> 7
}
func (o *IPC_Type) SetINTENSET_RECEIVE8(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x100)|value<<8)
}
func (o *IPC_Type) GetINTENSET_RECEIVE8() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x100) >> 8
}
func (o *IPC_Type) SetINTENSET_RECEIVE9(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x200)|value<<9)
}
func (o *IPC_Type) GetINTENSET_RECEIVE9() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x200) >> 9
}
func (o *IPC_Type) SetINTENSET_RECEIVE10(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x400)|value<<10)
}
func (o *IPC_Type) GetINTENSET_RECEIVE10() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x400) >> 10
}
func (o *IPC_Type) SetINTENSET_RECEIVE11(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x800)|value<<11)
}
func (o *IPC_Type) GetINTENSET_RECEIVE11() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x800) >> 11
}
func (o *IPC_Type) SetINTENSET_RECEIVE12(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x1000)|value<<12)
}
func (o *IPC_Type) GetINTENSET_RECEIVE12() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x1000) >> 12
}
func (o *IPC_Type) SetINTENSET_RECEIVE13(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x2000)|value<<13)
}
func (o *IPC_Type) GetINTENSET_RECEIVE13() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x2000) >> 13
}
func (o *IPC_Type) SetINTENSET_RECEIVE14(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x4000)|value<<14)
}
func (o *IPC_Type) GetINTENSET_RECEIVE14() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x4000) >> 14
}
func (o *IPC_Type) SetINTENSET_RECEIVE15(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x8000)|value<<15)
}
func (o *IPC_Type) GetINTENSET_RECEIVE15() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x8000) >> 15
}

// IPC.INTENCLR: Disable interrupt
func (o *IPC_Type) SetINTENCLR_RECEIVE0(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x1)|value)
}
func (o *IPC_Type) GetINTENCLR_RECEIVE0() uint32 {
	return volatile.LoadUint32(&o.INTENCLR.Reg) & 0x1
}
func (o *IPC_Type) SetINTENCLR_RECEIVE1(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x2)|value<<1)
}
func (o *IPC_Type) GetINTENCLR_RECEIVE1() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x2) >> 1
}
func (o *IPC_Type) SetINTENCLR_RECEIVE2(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x4)|value<<2)
}
func (o *IPC_Type) GetINTENCLR_RECEIVE2() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x4) >> 2
}
func (o *IPC_Type) SetINTENCLR_RECEIVE3(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x8)|value<<3)
}
func (o *IPC_Type) GetINTENCLR_RECEIVE3() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x8) >> 3
}
func (o *IPC_Type) SetINTENCLR_RECEIVE4(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x10)|value<<4)
}
func (o *IPC_Type) GetINTENCLR_RECEIVE4() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x10) >> 4
}
func (o *IPC_Type) SetINTENCLR_RECEIVE5(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x20)|value<<5)
}
func (o *IPC_Type) GetINTENCLR_RECEIVE5() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x20) >> 5
}
func (o *IPC_Type) SetINTENCLR_RECEIVE6(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x40)|value<<6)
}
func (o *IPC_Type) GetINTENCLR_RECEIVE6() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x40) >> 6
}
func (o *IPC_Type) SetINTENCLR_RECEIVE7(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x80)|value<<7)
}
func (o *IPC_Type) GetINTENCLR_RECEIVE7() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x80) >> 7
}
func (o *IPC_Type) SetINTENCLR_RECEIVE8(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x100)|value<<8)
}
func (o *IPC_Type) GetINTENCLR_RECEIVE8() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x100) >> 8
}
func (o *IPC_Type) SetINTENCLR_RECEIVE9(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x200)|value<<9)
}
func (o *IPC_Type) GetINTENCLR_RECEIVE9() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x200) >> 9
}
func (o *IPC_Type) SetINTENCLR_RECEIVE10(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x400)|value<<10)
}
func (o *IPC_Type) GetINTENCLR_RECEIVE10() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x400) >> 10
}
func (o *IPC_Type) SetINTENCLR_RECEIVE11(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x800)|value<<11)
}
func (o *IPC_Type) GetINTENCLR_RECEIVE11() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x800) >> 11
}
func (o *IPC_Type) SetINTENCLR_RECEIVE12(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x1000)|value<<12)
}
func (o *IPC_Type) GetINTENCLR_RECEIVE12() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x1000) >> 12
}
func (o *IPC_Type) SetINTENCLR_RECEIVE13(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x2000)|value<<13)
}
func (o *IPC_Type) GetINTENCLR_RECEIVE13() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x2000) >> 13
}
func (o *IPC_Type) SetINTENCLR_RECEIVE14(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x4000)|value<<14)
}
func (o *IPC_Type) GetINTENCLR_RECEIVE14() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x4000) >> 14
}
func (o *IPC_Type) SetINTENCLR_RECEIVE15(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x8000)|value<<15)
}
func (o *IPC_Type) GetINTENCLR_RECEIVE15() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x8000) >> 15
}

// IPC.INTPEND: Pending interrupts
func (o *IPC_Type) SetINTPEND_RECEIVE0(value uint32) {
	volatile.StoreUint32(&o.INTPEND.Reg, volatile.LoadUint32(&o.INTPEND.Reg)&^(0x1)|value)
}
func (o *IPC_Type) GetINTPEND_RECEIVE0() uint32 {
	return volatile.LoadUint32(&o.INTPEND.Reg) & 0x1
}
func (o *IPC_Type) SetINTPEND_RECEIVE1(value uint32) {
	volatile.StoreUint32(&o.INTPEND.Reg, volatile.LoadUint32(&o.INTPEND.Reg)&^(0x2)|value<<1)
}
func (o *IPC_Type) GetINTPEND_RECEIVE1() uint32 {
	return (volatile.LoadUint32(&o.INTPEND.Reg) & 0x2) >> 1
}
func (o *IPC_Type) SetINTPEND_RECEIVE2(value uint32) {
	volatile.StoreUint32(&o.INTPEND.Reg, volatile.LoadUint32(&o.INTPEND.Reg)&^(0x4)|value<<2)
}
func (o *IPC_Type) GetINTPEND_RECEIVE2() uint32 {
	return (volatile.LoadUint32(&o.INTPEND.Reg) & 0x4) >> 2
}
func (o *IPC_Type) SetINTPEND_RECEIVE3(value uint32) {
	volatile.StoreUint32(&o.INTPEND.Reg, volatile.LoadUint32(&o.INTPEND.Reg)&^(0x8)|value<<3)
}
func (o *IPC_Type) GetINTPEND_RECEIVE3() uint32 {
	return (volatile.LoadUint32(&o.INTPEND.Reg) & 0x8) >> 3
}
func (o *IPC_Type) SetINTPEND_RECEIVE4(value uint32) {
	volatile.StoreUint32(&o.INTPEND.Reg, volatile.LoadUint32(&o.INTPEND.Reg)&^(0x10)|value<<4)
}
func (o *IPC_Type) GetINTPEND_RECEIVE4() uint32 {
	return (volatile.LoadUint32(&o.INTPEND.Reg) & 0x10) >> 4
}
func (o *IPC_Type) SetINTPEND_RECEIVE5(value uint32) {
	volatile.StoreUint32(&o.INTPEND.Reg, volatile.LoadUint32(&o.INTPEND.Reg)&^(0x20)|value<<5)
}
func (o *IPC_Type) GetINTPEND_RECEIVE5() uint32 {
	return (volatile.LoadUint32(&o.INTPEND.Reg) & 0x20) >> 5
}
func (o *IPC_Type) SetINTPEND_RECEIVE6(value uint32) {
	volatile.StoreUint32(&o.INTPEND.Reg, volatile.LoadUint32(&o.INTPEND.Reg)&^(0x40)|value<<6)
}
func (o *IPC_Type) GetINTPEND_RECEIVE6() uint32 {
	return (volatile.LoadUint32(&o.INTPEND.Reg) & 0x40) >> 6
}
func (o *IPC_Type) SetINTPEND_RECEIVE7(value uint32) {
	volatile.StoreUint32(&o.INTPEND.Reg, volatile.LoadUint32(&o.INTPEND.Reg)&^(0x80)|value<<7)
}
func (o *IPC_Type) GetINTPEND_RECEIVE7() uint32 {
	return (volatile.LoadUint32(&o.INTPEND.Reg) & 0x80) >> 7
}
func (o *IPC_Type) SetINTPEND_RECEIVE8(value uint32) {
	volatile.StoreUint32(&o.INTPEND.Reg, volatile.LoadUint32(&o.INTPEND.Reg)&^(0x100)|value<<8)
}
func (o *IPC_Type) GetINTPEND_RECEIVE8() uint32 {
	return (volatile.LoadUint32(&o.INTPEND.Reg) & 0x100) >> 8
}
func (o *IPC_Type) SetINTPEND_RECEIVE9(value uint32) {
	volatile.StoreUint32(&o.INTPEND.Reg, volatile.LoadUint32(&o.INTPEND.Reg)&^(0x200)|value<<9)
}
func (o *IPC_Type) GetINTPEND_RECEIVE9() uint32 {
	return (volatile.LoadUint32(&o.INTPEND.Reg) & 0x200) >> 9
}
func (o *IPC_Type) SetINTPEND_RECEIVE10(value uint32) {
	volatile.StoreUint32(&o.INTPEND.Reg, volatile.LoadUint32(&o.INTPEND.Reg)&^(0x400)|value<<10)
}
func (o *IPC_Type) GetINTPEND_RECEIVE10() uint32 {
	return (volatile.LoadUint32(&o.INTPEND.Reg) & 0x400) >> 10
}
func (o *IPC_Type) SetINTPEND_RECEIVE11(value uint32) {
	volatile.StoreUint32(&o.INTPEND.Reg, volatile.LoadUint32(&o.INTPEND.Reg)&^(0x800)|value<<11)
}
func (o *IPC_Type) GetINTPEND_RECEIVE11() uint32 {
	return (volatile.LoadUint32(&o.INTPEND.Reg) & 0x800) >> 11
}
func (o *IPC_Type) SetINTPEND_RECEIVE12(value uint32) {
	volatile.StoreUint32(&o.INTPEND.Reg, volatile.LoadUint32(&o.INTPEND.Reg)&^(0x1000)|value<<12)
}
func (o *IPC_Type) GetINTPEND_RECEIVE12() uint32 {
	return (volatile.LoadUint32(&o.INTPEND.Reg) & 0x1000) >> 12
}
func (o *IPC_Type) SetINTPEND_RECEIVE13(value uint32) {
	volatile.StoreUint32(&o.INTPEND.Reg, volatile.LoadUint32(&o.INTPEND.Reg)&^(0x2000)|value<<13)
}
func (o *IPC_Type) GetINTPEND_RECEIVE13() uint32 {
	return (volatile.LoadUint32(&o.INTPEND.Reg) & 0x2000) >> 13
}
func (o *IPC_Type) SetINTPEND_RECEIVE14(value uint32) {
	volatile.StoreUint32(&o.INTPEND.Reg, volatile.LoadUint32(&o.INTPEND.Reg)&^(0x4000)|value<<14)
}
func (o *IPC_Type) GetINTPEND_RECEIVE14() uint32 {
	return (volatile.LoadUint32(&o.INTPEND.Reg) & 0x4000) >> 14
}
func (o *IPC_Type) SetINTPEND_RECEIVE15(value uint32) {
	volatile.StoreUint32(&o.INTPEND.Reg, volatile.LoadUint32(&o.INTPEND.Reg)&^(0x8000)|value<<15)
}
func (o *IPC_Type) GetINTPEND_RECEIVE15() uint32 {
	return (volatile.LoadUint32(&o.INTPEND.Reg) & 0x8000) >> 15
}

// IPC.SEND_CNF: Description collection: Send event configuration for TASKS_SEND[n]
func (o *IPC_Type) SetSEND_CNF_CHEN0(idx int, value uint32) {
	volatile.StoreUint32(&o.SEND_CNF[idx].Reg, volatile.LoadUint32(&o.SEND_CNF[idx].Reg)&^(0x1)|value)
}
func (o *IPC_Type) GetSEND_CNF_CHEN0(idx int) uint32 {
	return volatile.LoadUint32(&o.SEND_CNF[idx].Reg) & 0x1
}
func (o *IPC_Type) SetSEND_CNF_CHEN1(idx int, value uint32) {
	volatile.StoreUint32(&o.SEND_CNF[idx].Reg, volatile.LoadUint32(&o.SEND_CNF[idx].Reg)&^(0x2)|value<<1)
}
func (o *IPC_Type) GetSEND_CNF_CHEN1(idx int) uint32 {
	return (volatile.LoadUint32(&o.SEND_CNF[idx].Reg) & 0x2) >> 1
}
func (o *IPC_Type) SetSEND_CNF_CHEN2(idx int, value uint32) {
	volatile.StoreUint32(&o.SEND_CNF[idx].Reg, volatile.LoadUint32(&o.SEND_CNF[idx].Reg)&^(0x4)|value<<2)
}
func (o *IPC_Type) GetSEND_CNF_CHEN2(idx int) uint32 {
	return (volatile.LoadUint32(&o.SEND_CNF[idx].Reg) & 0x4) >> 2
}
func (o *IPC_Type) SetSEND_CNF_CHEN3(idx int, value uint32) {
	volatile.StoreUint32(&o.SEND_CNF[idx].Reg, volatile.LoadUint32(&o.SEND_CNF[idx].Reg)&^(0x8)|value<<3)
}
func (o *IPC_Type) GetSEND_CNF_CHEN3(idx int) uint32 {
	return (volatile.LoadUint32(&o.SEND_CNF[idx].Reg) & 0x8) >> 3
}
func (o *IPC_Type) SetSEND_CNF_CHEN4(idx int, value uint32) {
	volatile.StoreUint32(&o.SEND_CNF[idx].Reg, volatile.LoadUint32(&o.SEND_CNF[idx].Reg)&^(0x10)|value<<4)
}
func (o *IPC_Type) GetSEND_CNF_CHEN4(idx int) uint32 {
	return (volatile.LoadUint32(&o.SEND_CNF[idx].Reg) & 0x10) >> 4
}
func (o *IPC_Type) SetSEND_CNF_CHEN5(idx int, value uint32) {
	volatile.StoreUint32(&o.SEND_CNF[idx].Reg, volatile.LoadUint32(&o.SEND_CNF[idx].Reg)&^(0x20)|value<<5)
}
func (o *IPC_Type) GetSEND_CNF_CHEN5(idx int) uint32 {
	return (volatile.LoadUint32(&o.SEND_CNF[idx].Reg) & 0x20) >> 5
}
func (o *IPC_Type) SetSEND_CNF_CHEN6(idx int, value uint32) {
	volatile.StoreUint32(&o.SEND_CNF[idx].Reg, volatile.LoadUint32(&o.SEND_CNF[idx].Reg)&^(0x40)|value<<6)
}
func (o *IPC_Type) GetSEND_CNF_CHEN6(idx int) uint32 {
	return (volatile.LoadUint32(&o.SEND_CNF[idx].Reg) & 0x40) >> 6
}
func (o *IPC_Type) SetSEND_CNF_CHEN7(idx int, value uint32) {
	volatile.StoreUint32(&o.SEND_CNF[idx].Reg, volatile.LoadUint32(&o.SEND_CNF[idx].Reg)&^(0x80)|value<<7)
}
func (o *IPC_Type) GetSEND_CNF_CHEN7(idx int) uint32 {
	return (volatile.LoadUint32(&o.SEND_CNF[idx].Reg) & 0x80) >> 7
}
func (o *IPC_Type) SetSEND_CNF_CHEN8(idx int, value uint32) {
	volatile.StoreUint32(&o.SEND_CNF[idx].Reg, volatile.LoadUint32(&o.SEND_CNF[idx].Reg)&^(0x100)|value<<8)
}
func (o *IPC_Type) GetSEND_CNF_CHEN8(idx int) uint32 {
	return (volatile.LoadUint32(&o.SEND_CNF[idx].Reg) & 0x100) >> 8
}
func (o *IPC_Type) SetSEND_CNF_CHEN9(idx int, value uint32) {
	volatile.StoreUint32(&o.SEND_CNF[idx].Reg, volatile.LoadUint32(&o.SEND_CNF[idx].Reg)&^(0x200)|value<<9)
}
func (o *IPC_Type) GetSEND_CNF_CHEN9(idx int) uint32 {
	return (volatile.LoadUint32(&o.SEND_CNF[idx].Reg) & 0x200) >> 9
}
func (o *IPC_Type) SetSEND_CNF_CHEN10(idx int, value uint32) {
	volatile.StoreUint32(&o.SEND_CNF[idx].Reg, volatile.LoadUint32(&o.SEND_CNF[idx].Reg)&^(0x400)|value<<10)
}
func (o *IPC_Type) GetSEND_CNF_CHEN10(idx int) uint32 {
	return (volatile.LoadUint32(&o.SEND_CNF[idx].Reg) & 0x400) >> 10
}
func (o *IPC_Type) SetSEND_CNF_CHEN11(idx int, value uint32) {
	volatile.StoreUint32(&o.SEND_CNF[idx].Reg, volatile.LoadUint32(&o.SEND_CNF[idx].Reg)&^(0x800)|value<<11)
}
func (o *IPC_Type) GetSEND_CNF_CHEN11(idx int) uint32 {
	return (volatile.LoadUint32(&o.SEND_CNF[idx].Reg) & 0x800) >> 11
}
func (o *IPC_Type) SetSEND_CNF_CHEN12(idx int, value uint32) {
	volatile.StoreUint32(&o.SEND_CNF[idx].Reg, volatile.LoadUint32(&o.SEND_CNF[idx].Reg)&^(0x1000)|value<<12)
}
func (o *IPC_Type) GetSEND_CNF_CHEN12(idx int) uint32 {
	return (volatile.LoadUint32(&o.SEND_CNF[idx].Reg) & 0x1000) >> 12
}
func (o *IPC_Type) SetSEND_CNF_CHEN13(idx int, value uint32) {
	volatile.StoreUint32(&o.SEND_CNF[idx].Reg, volatile.LoadUint32(&o.SEND_CNF[idx].Reg)&^(0x2000)|value<<13)
}
func (o *IPC_Type) GetSEND_CNF_CHEN13(idx int) uint32 {
	return (volatile.LoadUint32(&o.SEND_CNF[idx].Reg) & 0x2000) >> 13
}
func (o *IPC_Type) SetSEND_CNF_CHEN14(idx int, value uint32) {
	volatile.StoreUint32(&o.SEND_CNF[idx].Reg, volatile.LoadUint32(&o.SEND_CNF[idx].Reg)&^(0x4000)|value<<14)
}
func (o *IPC_Type) GetSEND_CNF_CHEN14(idx int) uint32 {
	return (volatile.LoadUint32(&o.SEND_CNF[idx].Reg) & 0x4000) >> 14
}
func (o *IPC_Type) SetSEND_CNF_CHEN15(idx int, value uint32) {
	volatile.StoreUint32(&o.SEND_CNF[idx].Reg, volatile.LoadUint32(&o.SEND_CNF[idx].Reg)&^(0x8000)|value<<15)
}
func (o *IPC_Type) GetSEND_CNF_CHEN15(idx int) uint32 {
	return (volatile.LoadUint32(&o.SEND_CNF[idx].Reg) & 0x8000) >> 15
}

// IPC.RECEIVE_CNF: Description collection: Receive event configuration for EVENTS_RECEIVE[n]
func (o *IPC_Type) SetRECEIVE_CNF_CHEN0(idx int, value uint32) {
	volatile.StoreUint32(&o.RECEIVE_CNF[idx].Reg, volatile.LoadUint32(&o.RECEIVE_CNF[idx].Reg)&^(0x1)|value)
}
func (o *IPC_Type) GetRECEIVE_CNF_CHEN0(idx int) uint32 {
	return volatile.LoadUint32(&o.RECEIVE_CNF[idx].Reg) & 0x1
}
func (o *IPC_Type) SetRECEIVE_CNF_CHEN1(idx int, value uint32) {
	volatile.StoreUint32(&o.RECEIVE_CNF[idx].Reg, volatile.LoadUint32(&o.RECEIVE_CNF[idx].Reg)&^(0x2)|value<<1)
}
func (o *IPC_Type) GetRECEIVE_CNF_CHEN1(idx int) uint32 {
	return (volatile.LoadUint32(&o.RECEIVE_CNF[idx].Reg) & 0x2) >> 1
}
func (o *IPC_Type) SetRECEIVE_CNF_CHEN2(idx int, value uint32) {
	volatile.StoreUint32(&o.RECEIVE_CNF[idx].Reg, volatile.LoadUint32(&o.RECEIVE_CNF[idx].Reg)&^(0x4)|value<<2)
}
func (o *IPC_Type) GetRECEIVE_CNF_CHEN2(idx int) uint32 {
	return (volatile.LoadUint32(&o.RECEIVE_CNF[idx].Reg) & 0x4) >> 2
}
func (o *IPC_Type) SetRECEIVE_CNF_CHEN3(idx int, value uint32) {
	volatile.StoreUint32(&o.RECEIVE_CNF[idx].Reg, volatile.LoadUint32(&o.RECEIVE_CNF[idx].Reg)&^(0x8)|value<<3)
}
func (o *IPC_Type) GetRECEIVE_CNF_CHEN3(idx int) uint32 {
	return (volatile.LoadUint32(&o.RECEIVE_CNF[idx].Reg) & 0x8) >> 3
}
func (o *IPC_Type) SetRECEIVE_CNF_CHEN4(idx int, value uint32) {
	volatile.StoreUint32(&o.RECEIVE_CNF[idx].Reg, volatile.LoadUint32(&o.RECEIVE_CNF[idx].Reg)&^(0x10)|value<<4)
}
func (o *IPC_Type) GetRECEIVE_CNF_CHEN4(idx int) uint32 {
	return (volatile.LoadUint32(&o.RECEIVE_CNF[idx].Reg) & 0x10) >> 4
}
func (o *IPC_Type) SetRECEIVE_CNF_CHEN5(idx int, value uint32) {
	volatile.StoreUint32(&o.RECEIVE_CNF[idx].Reg, volatile.LoadUint32(&o.RECEIVE_CNF[idx].Reg)&^(0x20)|value<<5)
}
func (o *IPC_Type) GetRECEIVE_CNF_CHEN5(idx int) uint32 {
	return (volatile.LoadUint32(&o.RECEIVE_CNF[idx].Reg) & 0x20) >> 5
}
func (o *IPC_Type) SetRECEIVE_CNF_CHEN6(idx int, value uint32) {
	volatile.StoreUint32(&o.RECEIVE_CNF[idx].Reg, volatile.LoadUint32(&o.RECEIVE_CNF[idx].Reg)&^(0x40)|value<<6)
}
func (o *IPC_Type) GetRECEIVE_CNF_CHEN6(idx int) uint32 {
	return (volatile.LoadUint32(&o.RECEIVE_CNF[idx].Reg) & 0x40) >> 6
}
func (o *IPC_Type) SetRECEIVE_CNF_CHEN7(idx int, value uint32) {
	volatile.StoreUint32(&o.RECEIVE_CNF[idx].Reg, volatile.LoadUint32(&o.RECEIVE_CNF[idx].Reg)&^(0x80)|value<<7)
}
func (o *IPC_Type) GetRECEIVE_CNF_CHEN7(idx int) uint32 {
	return (volatile.LoadUint32(&o.RECEIVE_CNF[idx].Reg) & 0x80) >> 7
}
func (o *IPC_Type) SetRECEIVE_CNF_CHEN8(idx int, value uint32) {
	volatile.StoreUint32(&o.RECEIVE_CNF[idx].Reg, volatile.LoadUint32(&o.RECEIVE_CNF[idx].Reg)&^(0x100)|value<<8)
}
func (o *IPC_Type) GetRECEIVE_CNF_CHEN8(idx int) uint32 {
	return (volatile.LoadUint32(&o.RECEIVE_CNF[idx].Reg) & 0x100) >> 8
}
func (o *IPC_Type) SetRECEIVE_CNF_CHEN9(idx int, value uint32) {
	volatile.StoreUint32(&o.RECEIVE_CNF[idx].Reg, volatile.LoadUint32(&o.RECEIVE_CNF[idx].Reg)&^(0x200)|value<<9)
}
func (o *IPC_Type) GetRECEIVE_CNF_CHEN9(idx int) uint32 {
	return (volatile.LoadUint32(&o.RECEIVE_CNF[idx].Reg) & 0x200) >> 9
}
func (o *IPC_Type) SetRECEIVE_CNF_CHEN10(idx int, value uint32) {
	volatile.StoreUint32(&o.RECEIVE_CNF[idx].Reg, volatile.LoadUint32(&o.RECEIVE_CNF[idx].Reg)&^(0x400)|value<<10)
}
func (o *IPC_Type) GetRECEIVE_CNF_CHEN10(idx int) uint32 {
	return (volatile.LoadUint32(&o.RECEIVE_CNF[idx].Reg) & 0x400) >> 10
}
func (o *IPC_Type) SetRECEIVE_CNF_CHEN11(idx int, value uint32) {
	volatile.StoreUint32(&o.RECEIVE_CNF[idx].Reg, volatile.LoadUint32(&o.RECEIVE_CNF[idx].Reg)&^(0x800)|value<<11)
}
func (o *IPC_Type) GetRECEIVE_CNF_CHEN11(idx int) uint32 {
	return (volatile.LoadUint32(&o.RECEIVE_CNF[idx].Reg) & 0x800) >> 11
}
func (o *IPC_Type) SetRECEIVE_CNF_CHEN12(idx int, value uint32) {
	volatile.StoreUint32(&o.RECEIVE_CNF[idx].Reg, volatile.LoadUint32(&o.RECEIVE_CNF[idx].Reg)&^(0x1000)|value<<12)
}
func (o *IPC_Type) GetRECEIVE_CNF_CHEN12(idx int) uint32 {
	return (volatile.LoadUint32(&o.RECEIVE_CNF[idx].Reg) & 0x1000) >> 12
}
func (o *IPC_Type) SetRECEIVE_CNF_CHEN13(idx int, value uint32) {
	volatile.StoreUint32(&o.RECEIVE_CNF[idx].Reg, volatile.LoadUint32(&o.RECEIVE_CNF[idx].Reg)&^(0x2000)|value<<13)
}
func (o *IPC_Type) GetRECEIVE_CNF_CHEN13(idx int) uint32 {
	return (volatile.LoadUint32(&o.RECEIVE_CNF[idx].Reg) & 0x2000) >> 13
}
func (o *IPC_Type) SetRECEIVE_CNF_CHEN14(idx int, value uint32) {
	volatile.StoreUint32(&o.RECEIVE_CNF[idx].Reg, volatile.LoadUint32(&o.RECEIVE_CNF[idx].Reg)&^(0x4000)|value<<14)
}
func (o *IPC_Type) GetRECEIVE_CNF_CHEN14(idx int) uint32 {
	return (volatile.LoadUint32(&o.RECEIVE_CNF[idx].Reg) & 0x4000) >> 14
}
func (o *IPC_Type) SetRECEIVE_CNF_CHEN15(idx int, value uint32) {
	volatile.StoreUint32(&o.RECEIVE_CNF[idx].Reg, volatile.LoadUint32(&o.RECEIVE_CNF[idx].Reg)&^(0x8000)|value<<15)
}
func (o *IPC_Type) GetRECEIVE_CNF_CHEN15(idx int) uint32 {
	return (volatile.LoadUint32(&o.RECEIVE_CNF[idx].Reg) & 0x8000) >> 15
}

// IPC.GPMEM: Description collection: General purpose memory
func (o *IPC_Type) SetGPMEM(idx int, value uint32) {
	volatile.StoreUint32(&o.GPMEM[idx].Reg, value)
}
func (o *IPC_Type) GetGPMEM(idx int) uint32 {
	return volatile.LoadUint32(&o.GPMEM[idx].Reg)
}

// Serial Peripheral Interface Master with EasyDMA
type SPIM_Type struct {
	_                 [16]byte
	TASKS_START       volatile.Register32 // 0x10
	TASKS_STOP        volatile.Register32 // 0x14
	_                 [4]byte
	TASKS_SUSPEND     volatile.Register32 // 0x1C
	TASKS_RESUME      volatile.Register32 // 0x20
	_                 [108]byte
	SUBSCRIBE_START   volatile.Register32 // 0x90
	SUBSCRIBE_STOP    volatile.Register32 // 0x94
	_                 [4]byte
	SUBSCRIBE_SUSPEND volatile.Register32 // 0x9C
	SUBSCRIBE_RESUME  volatile.Register32 // 0xA0
	_                 [96]byte
	EVENTS_STOPPED    volatile.Register32 // 0x104
	_                 [8]byte
	EVENTS_ENDRX      volatile.Register32 // 0x110
	_                 [4]byte
	EVENTS_END        volatile.Register32 // 0x118
	_                 [4]byte
	EVENTS_ENDTX      volatile.Register32 // 0x120
	_                 [40]byte
	EVENTS_STARTED    volatile.Register32 // 0x14C
	_                 [52]byte
	PUBLISH_STOPPED   volatile.Register32 // 0x184
	_                 [8]byte
	PUBLISH_ENDRX     volatile.Register32 // 0x190
	_                 [4]byte
	PUBLISH_END       volatile.Register32 // 0x198
	_                 [4]byte
	PUBLISH_ENDTX     volatile.Register32 // 0x1A0
	_                 [40]byte
	PUBLISH_STARTED   volatile.Register32 // 0x1CC
	_                 [48]byte
	SHORTS            volatile.Register32 // 0x200
	_                 [256]byte
	INTENSET          volatile.Register32 // 0x304
	INTENCLR          volatile.Register32 // 0x308
	_                 [244]byte
	STALLSTAT         volatile.Register32 // 0x400
	_                 [252]byte
	ENABLE            volatile.Register32 // 0x500
	_                 [4]byte
	PSEL              SPIM_PSEL_Type // 0x508
	_                 [12]byte
	FREQUENCY         volatile.Register32 // 0x524
	_                 [12]byte
	RXD               SPIM_RXD_Type       // 0x534
	TXD               SPIM_TXD_Type       // 0x544
	CONFIG            volatile.Register32 // 0x554
	_                 [8]byte
	IFTIMING          SPIM_IFTIMING_Type  // 0x560
	CSNPOL            volatile.Register32 // 0x568
	PSELDCX           volatile.Register32 // 0x56C
	DCXCNT            volatile.Register32 // 0x570
	_                 [76]byte
	ORC               volatile.Register32 // 0x5C0
}

// SPIM.TASKS_START: Start SPI transaction
func (o *SPIM_Type) SetTASKS_START(value uint32) {
	volatile.StoreUint32(&o.TASKS_START.Reg, volatile.LoadUint32(&o.TASKS_START.Reg)&^(0x1)|value)
}
func (o *SPIM_Type) GetTASKS_START() uint32 {
	return volatile.LoadUint32(&o.TASKS_START.Reg) & 0x1
}

// SPIM.TASKS_STOP: Stop SPI transaction
func (o *SPIM_Type) SetTASKS_STOP(value uint32) {
	volatile.StoreUint32(&o.TASKS_STOP.Reg, volatile.LoadUint32(&o.TASKS_STOP.Reg)&^(0x1)|value)
}
func (o *SPIM_Type) GetTASKS_STOP() uint32 {
	return volatile.LoadUint32(&o.TASKS_STOP.Reg) & 0x1
}

// SPIM.TASKS_SUSPEND: Suspend SPI transaction
func (o *SPIM_Type) SetTASKS_SUSPEND(value uint32) {
	volatile.StoreUint32(&o.TASKS_SUSPEND.Reg, volatile.LoadUint32(&o.TASKS_SUSPEND.Reg)&^(0x1)|value)
}
func (o *SPIM_Type) GetTASKS_SUSPEND() uint32 {
	return volatile.LoadUint32(&o.TASKS_SUSPEND.Reg) & 0x1
}

// SPIM.TASKS_RESUME: Resume SPI transaction
func (o *SPIM_Type) SetTASKS_RESUME(value uint32) {
	volatile.StoreUint32(&o.TASKS_RESUME.Reg, volatile.LoadUint32(&o.TASKS_RESUME.Reg)&^(0x1)|value)
}
func (o *SPIM_Type) GetTASKS_RESUME() uint32 {
	return volatile.LoadUint32(&o.TASKS_RESUME.Reg) & 0x1
}

// SPIM.SUBSCRIBE_START: Subscribe configuration for task START
func (o *SPIM_Type) SetSUBSCRIBE_START_CHIDX(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_START.Reg, volatile.LoadUint32(&o.SUBSCRIBE_START.Reg)&^(0xff)|value)
}
func (o *SPIM_Type) GetSUBSCRIBE_START_CHIDX() uint32 {
	return volatile.LoadUint32(&o.SUBSCRIBE_START.Reg) & 0xff
}
func (o *SPIM_Type) SetSUBSCRIBE_START_EN(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_START.Reg, volatile.LoadUint32(&o.SUBSCRIBE_START.Reg)&^(0x80000000)|value<<31)
}
func (o *SPIM_Type) GetSUBSCRIBE_START_EN() uint32 {
	return (volatile.LoadUint32(&o.SUBSCRIBE_START.Reg) & 0x80000000) >> 31
}

// SPIM.SUBSCRIBE_STOP: Subscribe configuration for task STOP
func (o *SPIM_Type) SetSUBSCRIBE_STOP_CHIDX(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_STOP.Reg, volatile.LoadUint32(&o.SUBSCRIBE_STOP.Reg)&^(0xff)|value)
}
func (o *SPIM_Type) GetSUBSCRIBE_STOP_CHIDX() uint32 {
	return volatile.LoadUint32(&o.SUBSCRIBE_STOP.Reg) & 0xff
}
func (o *SPIM_Type) SetSUBSCRIBE_STOP_EN(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_STOP.Reg, volatile.LoadUint32(&o.SUBSCRIBE_STOP.Reg)&^(0x80000000)|value<<31)
}
func (o *SPIM_Type) GetSUBSCRIBE_STOP_EN() uint32 {
	return (volatile.LoadUint32(&o.SUBSCRIBE_STOP.Reg) & 0x80000000) >> 31
}

// SPIM.SUBSCRIBE_SUSPEND: Subscribe configuration for task SUSPEND
func (o *SPIM_Type) SetSUBSCRIBE_SUSPEND_CHIDX(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_SUSPEND.Reg, volatile.LoadUint32(&o.SUBSCRIBE_SUSPEND.Reg)&^(0xff)|value)
}
func (o *SPIM_Type) GetSUBSCRIBE_SUSPEND_CHIDX() uint32 {
	return volatile.LoadUint32(&o.SUBSCRIBE_SUSPEND.Reg) & 0xff
}
func (o *SPIM_Type) SetSUBSCRIBE_SUSPEND_EN(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_SUSPEND.Reg, volatile.LoadUint32(&o.SUBSCRIBE_SUSPEND.Reg)&^(0x80000000)|value<<31)
}
func (o *SPIM_Type) GetSUBSCRIBE_SUSPEND_EN() uint32 {
	return (volatile.LoadUint32(&o.SUBSCRIBE_SUSPEND.Reg) & 0x80000000) >> 31
}

// SPIM.SUBSCRIBE_RESUME: Subscribe configuration for task RESUME
func (o *SPIM_Type) SetSUBSCRIBE_RESUME_CHIDX(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_RESUME.Reg, volatile.LoadUint32(&o.SUBSCRIBE_RESUME.Reg)&^(0xff)|value)
}
func (o *SPIM_Type) GetSUBSCRIBE_RESUME_CHIDX() uint32 {
	return volatile.LoadUint32(&o.SUBSCRIBE_RESUME.Reg) & 0xff
}
func (o *SPIM_Type) SetSUBSCRIBE_RESUME_EN(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_RESUME.Reg, volatile.LoadUint32(&o.SUBSCRIBE_RESUME.Reg)&^(0x80000000)|value<<31)
}
func (o *SPIM_Type) GetSUBSCRIBE_RESUME_EN() uint32 {
	return (volatile.LoadUint32(&o.SUBSCRIBE_RESUME.Reg) & 0x80000000) >> 31
}

// SPIM.EVENTS_STOPPED: SPI transaction has stopped
func (o *SPIM_Type) SetEVENTS_STOPPED(value uint32) {
	volatile.StoreUint32(&o.EVENTS_STOPPED.Reg, volatile.LoadUint32(&o.EVENTS_STOPPED.Reg)&^(0x1)|value)
}
func (o *SPIM_Type) GetEVENTS_STOPPED() uint32 {
	return volatile.LoadUint32(&o.EVENTS_STOPPED.Reg) & 0x1
}

// SPIM.EVENTS_ENDRX: End of RXD buffer reached
func (o *SPIM_Type) SetEVENTS_ENDRX(value uint32) {
	volatile.StoreUint32(&o.EVENTS_ENDRX.Reg, volatile.LoadUint32(&o.EVENTS_ENDRX.Reg)&^(0x1)|value)
}
func (o *SPIM_Type) GetEVENTS_ENDRX() uint32 {
	return volatile.LoadUint32(&o.EVENTS_ENDRX.Reg) & 0x1
}

// SPIM.EVENTS_END: End of RXD buffer and TXD buffer reached
func (o *SPIM_Type) SetEVENTS_END(value uint32) {
	volatile.StoreUint32(&o.EVENTS_END.Reg, volatile.LoadUint32(&o.EVENTS_END.Reg)&^(0x1)|value)
}
func (o *SPIM_Type) GetEVENTS_END() uint32 {
	return volatile.LoadUint32(&o.EVENTS_END.Reg) & 0x1
}

// SPIM.EVENTS_ENDTX: End of TXD buffer reached
func (o *SPIM_Type) SetEVENTS_ENDTX(value uint32) {
	volatile.StoreUint32(&o.EVENTS_ENDTX.Reg, volatile.LoadUint32(&o.EVENTS_ENDTX.Reg)&^(0x1)|value)
}
func (o *SPIM_Type) GetEVENTS_ENDTX() uint32 {
	return volatile.LoadUint32(&o.EVENTS_ENDTX.Reg) & 0x1
}

// SPIM.EVENTS_STARTED: Transaction started
func (o *SPIM_Type) SetEVENTS_STARTED(value uint32) {
	volatile.StoreUint32(&o.EVENTS_STARTED.Reg, volatile.LoadUint32(&o.EVENTS_STARTED.Reg)&^(0x1)|value)
}
func (o *SPIM_Type) GetEVENTS_STARTED() uint32 {
	return volatile.LoadUint32(&o.EVENTS_STARTED.Reg) & 0x1
}

// SPIM.PUBLISH_STOPPED: Publish configuration for event STOPPED
func (o *SPIM_Type) SetPUBLISH_STOPPED_CHIDX(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_STOPPED.Reg, volatile.LoadUint32(&o.PUBLISH_STOPPED.Reg)&^(0xff)|value)
}
func (o *SPIM_Type) GetPUBLISH_STOPPED_CHIDX() uint32 {
	return volatile.LoadUint32(&o.PUBLISH_STOPPED.Reg) & 0xff
}
func (o *SPIM_Type) SetPUBLISH_STOPPED_EN(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_STOPPED.Reg, volatile.LoadUint32(&o.PUBLISH_STOPPED.Reg)&^(0x80000000)|value<<31)
}
func (o *SPIM_Type) GetPUBLISH_STOPPED_EN() uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_STOPPED.Reg) & 0x80000000) >> 31
}

// SPIM.PUBLISH_ENDRX: Publish configuration for event ENDRX
func (o *SPIM_Type) SetPUBLISH_ENDRX_CHIDX(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_ENDRX.Reg, volatile.LoadUint32(&o.PUBLISH_ENDRX.Reg)&^(0xff)|value)
}
func (o *SPIM_Type) GetPUBLISH_ENDRX_CHIDX() uint32 {
	return volatile.LoadUint32(&o.PUBLISH_ENDRX.Reg) & 0xff
}
func (o *SPIM_Type) SetPUBLISH_ENDRX_EN(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_ENDRX.Reg, volatile.LoadUint32(&o.PUBLISH_ENDRX.Reg)&^(0x80000000)|value<<31)
}
func (o *SPIM_Type) GetPUBLISH_ENDRX_EN() uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_ENDRX.Reg) & 0x80000000) >> 31
}

// SPIM.PUBLISH_END: Publish configuration for event END
func (o *SPIM_Type) SetPUBLISH_END_CHIDX(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_END.Reg, volatile.LoadUint32(&o.PUBLISH_END.Reg)&^(0xff)|value)
}
func (o *SPIM_Type) GetPUBLISH_END_CHIDX() uint32 {
	return volatile.LoadUint32(&o.PUBLISH_END.Reg) & 0xff
}
func (o *SPIM_Type) SetPUBLISH_END_EN(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_END.Reg, volatile.LoadUint32(&o.PUBLISH_END.Reg)&^(0x80000000)|value<<31)
}
func (o *SPIM_Type) GetPUBLISH_END_EN() uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_END.Reg) & 0x80000000) >> 31
}

// SPIM.PUBLISH_ENDTX: Publish configuration for event ENDTX
func (o *SPIM_Type) SetPUBLISH_ENDTX_CHIDX(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_ENDTX.Reg, volatile.LoadUint32(&o.PUBLISH_ENDTX.Reg)&^(0xff)|value)
}
func (o *SPIM_Type) GetPUBLISH_ENDTX_CHIDX() uint32 {
	return volatile.LoadUint32(&o.PUBLISH_ENDTX.Reg) & 0xff
}
func (o *SPIM_Type) SetPUBLISH_ENDTX_EN(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_ENDTX.Reg, volatile.LoadUint32(&o.PUBLISH_ENDTX.Reg)&^(0x80000000)|value<<31)
}
func (o *SPIM_Type) GetPUBLISH_ENDTX_EN() uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_ENDTX.Reg) & 0x80000000) >> 31
}

// SPIM.PUBLISH_STARTED: Publish configuration for event STARTED
func (o *SPIM_Type) SetPUBLISH_STARTED_CHIDX(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_STARTED.Reg, volatile.LoadUint32(&o.PUBLISH_STARTED.Reg)&^(0xff)|value)
}
func (o *SPIM_Type) GetPUBLISH_STARTED_CHIDX() uint32 {
	return volatile.LoadUint32(&o.PUBLISH_STARTED.Reg) & 0xff
}
func (o *SPIM_Type) SetPUBLISH_STARTED_EN(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_STARTED.Reg, volatile.LoadUint32(&o.PUBLISH_STARTED.Reg)&^(0x80000000)|value<<31)
}
func (o *SPIM_Type) GetPUBLISH_STARTED_EN() uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_STARTED.Reg) & 0x80000000) >> 31
}

// SPIM.SHORTS: Shortcuts between local events and tasks
func (o *SPIM_Type) SetSHORTS_END_START(value uint32) {
	volatile.StoreUint32(&o.SHORTS.Reg, volatile.LoadUint32(&o.SHORTS.Reg)&^(0x20000)|value<<17)
}
func (o *SPIM_Type) GetSHORTS_END_START() uint32 {
	return (volatile.LoadUint32(&o.SHORTS.Reg) & 0x20000) >> 17
}

// SPIM.INTENSET: Enable interrupt
func (o *SPIM_Type) SetINTENSET_STOPPED(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x2)|value<<1)
}
func (o *SPIM_Type) GetINTENSET_STOPPED() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x2) >> 1
}
func (o *SPIM_Type) SetINTENSET_ENDRX(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x10)|value<<4)
}
func (o *SPIM_Type) GetINTENSET_ENDRX() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x10) >> 4
}
func (o *SPIM_Type) SetINTENSET_END(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x40)|value<<6)
}
func (o *SPIM_Type) GetINTENSET_END() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x40) >> 6
}
func (o *SPIM_Type) SetINTENSET_ENDTX(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x100)|value<<8)
}
func (o *SPIM_Type) GetINTENSET_ENDTX() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x100) >> 8
}
func (o *SPIM_Type) SetINTENSET_STARTED(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x80000)|value<<19)
}
func (o *SPIM_Type) GetINTENSET_STARTED() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x80000) >> 19
}

// SPIM.INTENCLR: Disable interrupt
func (o *SPIM_Type) SetINTENCLR_STOPPED(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x2)|value<<1)
}
func (o *SPIM_Type) GetINTENCLR_STOPPED() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x2) >> 1
}
func (o *SPIM_Type) SetINTENCLR_ENDRX(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x10)|value<<4)
}
func (o *SPIM_Type) GetINTENCLR_ENDRX() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x10) >> 4
}
func (o *SPIM_Type) SetINTENCLR_END(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x40)|value<<6)
}
func (o *SPIM_Type) GetINTENCLR_END() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x40) >> 6
}
func (o *SPIM_Type) SetINTENCLR_ENDTX(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x100)|value<<8)
}
func (o *SPIM_Type) GetINTENCLR_ENDTX() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x100) >> 8
}
func (o *SPIM_Type) SetINTENCLR_STARTED(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x80000)|value<<19)
}
func (o *SPIM_Type) GetINTENCLR_STARTED() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x80000) >> 19
}

// SPIM.STALLSTAT: Stall status for EasyDMA RAM accesses. The fields in this register is set to STALL by hardware whenever a stall occurres and can be cleared (set to NOSTALL) by the CPU.
func (o *SPIM_Type) SetSTALLSTAT_TX(value uint32) {
	volatile.StoreUint32(&o.STALLSTAT.Reg, volatile.LoadUint32(&o.STALLSTAT.Reg)&^(0x1)|value)
}
func (o *SPIM_Type) GetSTALLSTAT_TX() uint32 {
	return volatile.LoadUint32(&o.STALLSTAT.Reg) & 0x1
}
func (o *SPIM_Type) SetSTALLSTAT_RX(value uint32) {
	volatile.StoreUint32(&o.STALLSTAT.Reg, volatile.LoadUint32(&o.STALLSTAT.Reg)&^(0x2)|value<<1)
}
func (o *SPIM_Type) GetSTALLSTAT_RX() uint32 {
	return (volatile.LoadUint32(&o.STALLSTAT.Reg) & 0x2) >> 1
}

// SPIM.ENABLE: Enable SPIM
func (o *SPIM_Type) SetENABLE(value uint32) {
	volatile.StoreUint32(&o.ENABLE.Reg, volatile.LoadUint32(&o.ENABLE.Reg)&^(0xf)|value)
}
func (o *SPIM_Type) GetENABLE() uint32 {
	return volatile.LoadUint32(&o.ENABLE.Reg) & 0xf
}

// SPIM.FREQUENCY: SPI frequency. Accuracy depends on the HFCLK source selected.
func (o *SPIM_Type) SetFREQUENCY(value uint32) {
	volatile.StoreUint32(&o.FREQUENCY.Reg, value)
}
func (o *SPIM_Type) GetFREQUENCY() uint32 {
	return volatile.LoadUint32(&o.FREQUENCY.Reg)
}

// SPIM.CONFIG: Configuration register
func (o *SPIM_Type) SetCONFIG_ORDER(value uint32) {
	volatile.StoreUint32(&o.CONFIG.Reg, volatile.LoadUint32(&o.CONFIG.Reg)&^(0x1)|value)
}
func (o *SPIM_Type) GetCONFIG_ORDER() uint32 {
	return volatile.LoadUint32(&o.CONFIG.Reg) & 0x1
}
func (o *SPIM_Type) SetCONFIG_CPHA(value uint32) {
	volatile.StoreUint32(&o.CONFIG.Reg, volatile.LoadUint32(&o.CONFIG.Reg)&^(0x2)|value<<1)
}
func (o *SPIM_Type) GetCONFIG_CPHA() uint32 {
	return (volatile.LoadUint32(&o.CONFIG.Reg) & 0x2) >> 1
}
func (o *SPIM_Type) SetCONFIG_CPOL(value uint32) {
	volatile.StoreUint32(&o.CONFIG.Reg, volatile.LoadUint32(&o.CONFIG.Reg)&^(0x4)|value<<2)
}
func (o *SPIM_Type) GetCONFIG_CPOL() uint32 {
	return (volatile.LoadUint32(&o.CONFIG.Reg) & 0x4) >> 2
}

// SPIM.CSNPOL: Polarity of CSN output
func (o *SPIM_Type) SetCSNPOL(value uint32) {
	volatile.StoreUint32(&o.CSNPOL.Reg, volatile.LoadUint32(&o.CSNPOL.Reg)&^(0x1)|value)
}
func (o *SPIM_Type) GetCSNPOL() uint32 {
	return volatile.LoadUint32(&o.CSNPOL.Reg) & 0x1
}

// SPIM.PSELDCX: Pin select for DCX signal
func (o *SPIM_Type) SetPSELDCX_PIN(value uint32) {
	volatile.StoreUint32(&o.PSELDCX.Reg, volatile.LoadUint32(&o.PSELDCX.Reg)&^(0x1f)|value)
}
func (o *SPIM_Type) GetPSELDCX_PIN() uint32 {
	return volatile.LoadUint32(&o.PSELDCX.Reg) & 0x1f
}
func (o *SPIM_Type) SetPSELDCX_PORT(value uint32) {
	volatile.StoreUint32(&o.PSELDCX.Reg, volatile.LoadUint32(&o.PSELDCX.Reg)&^(0x20)|value<<5)
}
func (o *SPIM_Type) GetPSELDCX_PORT() uint32 {
	return (volatile.LoadUint32(&o.PSELDCX.Reg) & 0x20) >> 5
}
func (o *SPIM_Type) SetPSELDCX_CONNECT(value uint32) {
	volatile.StoreUint32(&o.PSELDCX.Reg, volatile.LoadUint32(&o.PSELDCX.Reg)&^(0x80000000)|value<<31)
}
func (o *SPIM_Type) GetPSELDCX_CONNECT() uint32 {
	return (volatile.LoadUint32(&o.PSELDCX.Reg) & 0x80000000) >> 31
}

// SPIM.DCXCNT: DCX configuration
func (o *SPIM_Type) SetDCXCNT(value uint32) {
	volatile.StoreUint32(&o.DCXCNT.Reg, volatile.LoadUint32(&o.DCXCNT.Reg)&^(0xf)|value)
}
func (o *SPIM_Type) GetDCXCNT() uint32 {
	return volatile.LoadUint32(&o.DCXCNT.Reg) & 0xf
}

// SPIM.ORC: Byte transmitted after TXD.MAXCNT bytes have been transmitted in the case when RXD.MAXCNT is greater than TXD.MAXCNT
func (o *SPIM_Type) SetORC(value uint32) {
	volatile.StoreUint32(&o.ORC.Reg, volatile.LoadUint32(&o.ORC.Reg)&^(0xff)|value)
}
func (o *SPIM_Type) GetORC() uint32 {
	return volatile.LoadUint32(&o.ORC.Reg) & 0xff
}

// Unspecified
type SPIM_PSEL_Type struct {
	SCK  volatile.Register32 // 0x508
	MOSI volatile.Register32 // 0x50C
	MISO volatile.Register32 // 0x510
	CSN  volatile.Register32 // 0x514
}

// SPIM_PSEL.SCK: Pin select for SCK
func (o *SPIM_PSEL_Type) SetSCK_PIN(value uint32) {
	volatile.StoreUint32(&o.SCK.Reg, volatile.LoadUint32(&o.SCK.Reg)&^(0x1f)|value)
}
func (o *SPIM_PSEL_Type) GetSCK_PIN() uint32 {
	return volatile.LoadUint32(&o.SCK.Reg) & 0x1f
}
func (o *SPIM_PSEL_Type) SetSCK_PORT(value uint32) {
	volatile.StoreUint32(&o.SCK.Reg, volatile.LoadUint32(&o.SCK.Reg)&^(0x20)|value<<5)
}
func (o *SPIM_PSEL_Type) GetSCK_PORT() uint32 {
	return (volatile.LoadUint32(&o.SCK.Reg) & 0x20) >> 5
}
func (o *SPIM_PSEL_Type) SetSCK_CONNECT(value uint32) {
	volatile.StoreUint32(&o.SCK.Reg, volatile.LoadUint32(&o.SCK.Reg)&^(0x80000000)|value<<31)
}
func (o *SPIM_PSEL_Type) GetSCK_CONNECT() uint32 {
	return (volatile.LoadUint32(&o.SCK.Reg) & 0x80000000) >> 31
}

// SPIM_PSEL.MOSI: Pin select for MOSI signal
func (o *SPIM_PSEL_Type) SetMOSI_PIN(value uint32) {
	volatile.StoreUint32(&o.MOSI.Reg, volatile.LoadUint32(&o.MOSI.Reg)&^(0x1f)|value)
}
func (o *SPIM_PSEL_Type) GetMOSI_PIN() uint32 {
	return volatile.LoadUint32(&o.MOSI.Reg) & 0x1f
}
func (o *SPIM_PSEL_Type) SetMOSI_PORT(value uint32) {
	volatile.StoreUint32(&o.MOSI.Reg, volatile.LoadUint32(&o.MOSI.Reg)&^(0x20)|value<<5)
}
func (o *SPIM_PSEL_Type) GetMOSI_PORT() uint32 {
	return (volatile.LoadUint32(&o.MOSI.Reg) & 0x20) >> 5
}
func (o *SPIM_PSEL_Type) SetMOSI_CONNECT(value uint32) {
	volatile.StoreUint32(&o.MOSI.Reg, volatile.LoadUint32(&o.MOSI.Reg)&^(0x80000000)|value<<31)
}
func (o *SPIM_PSEL_Type) GetMOSI_CONNECT() uint32 {
	return (volatile.LoadUint32(&o.MOSI.Reg) & 0x80000000) >> 31
}

// SPIM_PSEL.MISO: Pin select for MISO signal
func (o *SPIM_PSEL_Type) SetMISO_PIN(value uint32) {
	volatile.StoreUint32(&o.MISO.Reg, volatile.LoadUint32(&o.MISO.Reg)&^(0x1f)|value)
}
func (o *SPIM_PSEL_Type) GetMISO_PIN() uint32 {
	return volatile.LoadUint32(&o.MISO.Reg) & 0x1f
}
func (o *SPIM_PSEL_Type) SetMISO_PORT(value uint32) {
	volatile.StoreUint32(&o.MISO.Reg, volatile.LoadUint32(&o.MISO.Reg)&^(0x20)|value<<5)
}
func (o *SPIM_PSEL_Type) GetMISO_PORT() uint32 {
	return (volatile.LoadUint32(&o.MISO.Reg) & 0x20) >> 5
}
func (o *SPIM_PSEL_Type) SetMISO_CONNECT(value uint32) {
	volatile.StoreUint32(&o.MISO.Reg, volatile.LoadUint32(&o.MISO.Reg)&^(0x80000000)|value<<31)
}
func (o *SPIM_PSEL_Type) GetMISO_CONNECT() uint32 {
	return (volatile.LoadUint32(&o.MISO.Reg) & 0x80000000) >> 31
}

// SPIM_PSEL.CSN: Pin select for CSN
func (o *SPIM_PSEL_Type) SetCSN_PIN(value uint32) {
	volatile.StoreUint32(&o.CSN.Reg, volatile.LoadUint32(&o.CSN.Reg)&^(0x1f)|value)
}
func (o *SPIM_PSEL_Type) GetCSN_PIN() uint32 {
	return volatile.LoadUint32(&o.CSN.Reg) & 0x1f
}
func (o *SPIM_PSEL_Type) SetCSN_PORT(value uint32) {
	volatile.StoreUint32(&o.CSN.Reg, volatile.LoadUint32(&o.CSN.Reg)&^(0x20)|value<<5)
}
func (o *SPIM_PSEL_Type) GetCSN_PORT() uint32 {
	return (volatile.LoadUint32(&o.CSN.Reg) & 0x20) >> 5
}
func (o *SPIM_PSEL_Type) SetCSN_CONNECT(value uint32) {
	volatile.StoreUint32(&o.CSN.Reg, volatile.LoadUint32(&o.CSN.Reg)&^(0x80000000)|value<<31)
}
func (o *SPIM_PSEL_Type) GetCSN_CONNECT() uint32 {
	return (volatile.LoadUint32(&o.CSN.Reg) & 0x80000000) >> 31
}

// RXD EasyDMA channel
type SPIM_RXD_Type struct {
	PTR    volatile.Register32 // 0x534
	MAXCNT volatile.Register32 // 0x538
	AMOUNT volatile.Register32 // 0x53C
	LIST   volatile.Register32 // 0x540
}

// SPIM_RXD.PTR: Data pointer
func (o *SPIM_RXD_Type) SetPTR(value uint32) {
	volatile.StoreUint32(&o.PTR.Reg, value)
}
func (o *SPIM_RXD_Type) GetPTR() uint32 {
	return volatile.LoadUint32(&o.PTR.Reg)
}

// SPIM_RXD.MAXCNT: Maximum number of bytes in receive buffer
func (o *SPIM_RXD_Type) SetMAXCNT(value uint32) {
	volatile.StoreUint32(&o.MAXCNT.Reg, volatile.LoadUint32(&o.MAXCNT.Reg)&^(0xffff)|value)
}
func (o *SPIM_RXD_Type) GetMAXCNT() uint32 {
	return volatile.LoadUint32(&o.MAXCNT.Reg) & 0xffff
}

// SPIM_RXD.AMOUNT: Number of bytes transferred in the last transaction
func (o *SPIM_RXD_Type) SetAMOUNT(value uint32) {
	volatile.StoreUint32(&o.AMOUNT.Reg, volatile.LoadUint32(&o.AMOUNT.Reg)&^(0xffff)|value)
}
func (o *SPIM_RXD_Type) GetAMOUNT() uint32 {
	return volatile.LoadUint32(&o.AMOUNT.Reg) & 0xffff
}

// SPIM_RXD.LIST: EasyDMA list type
func (o *SPIM_RXD_Type) SetLIST(value uint32) {
	volatile.StoreUint32(&o.LIST.Reg, volatile.LoadUint32(&o.LIST.Reg)&^(0x3)|value)
}
func (o *SPIM_RXD_Type) GetLIST() uint32 {
	return volatile.LoadUint32(&o.LIST.Reg) & 0x3
}

// TXD EasyDMA channel
type SPIM_TXD_Type struct {
	PTR    volatile.Register32 // 0x544
	MAXCNT volatile.Register32 // 0x548
	AMOUNT volatile.Register32 // 0x54C
	LIST   volatile.Register32 // 0x550
}

// SPIM_TXD.PTR: Data pointer
func (o *SPIM_TXD_Type) SetPTR(value uint32) {
	volatile.StoreUint32(&o.PTR.Reg, value)
}
func (o *SPIM_TXD_Type) GetPTR() uint32 {
	return volatile.LoadUint32(&o.PTR.Reg)
}

// SPIM_TXD.MAXCNT: Number of bytes in transmit buffer
func (o *SPIM_TXD_Type) SetMAXCNT(value uint32) {
	volatile.StoreUint32(&o.MAXCNT.Reg, volatile.LoadUint32(&o.MAXCNT.Reg)&^(0xffff)|value)
}
func (o *SPIM_TXD_Type) GetMAXCNT() uint32 {
	return volatile.LoadUint32(&o.MAXCNT.Reg) & 0xffff
}

// SPIM_TXD.AMOUNT: Number of bytes transferred in the last transaction
func (o *SPIM_TXD_Type) SetAMOUNT(value uint32) {
	volatile.StoreUint32(&o.AMOUNT.Reg, volatile.LoadUint32(&o.AMOUNT.Reg)&^(0xffff)|value)
}
func (o *SPIM_TXD_Type) GetAMOUNT() uint32 {
	return volatile.LoadUint32(&o.AMOUNT.Reg) & 0xffff
}

// SPIM_TXD.LIST: EasyDMA list type
func (o *SPIM_TXD_Type) SetLIST(value uint32) {
	volatile.StoreUint32(&o.LIST.Reg, volatile.LoadUint32(&o.LIST.Reg)&^(0x3)|value)
}
func (o *SPIM_TXD_Type) GetLIST() uint32 {
	return volatile.LoadUint32(&o.LIST.Reg) & 0x3
}

// Unspecified
type SPIM_IFTIMING_Type struct {
	RXDELAY volatile.Register32 // 0x560
	CSNDUR  volatile.Register32 // 0x564
}

// SPIM_IFTIMING.RXDELAY: Sample delay for input serial data on MISO
func (o *SPIM_IFTIMING_Type) SetRXDELAY(value uint32) {
	volatile.StoreUint32(&o.RXDELAY.Reg, volatile.LoadUint32(&o.RXDELAY.Reg)&^(0x7)|value)
}
func (o *SPIM_IFTIMING_Type) GetRXDELAY() uint32 {
	return volatile.LoadUint32(&o.RXDELAY.Reg) & 0x7
}

// SPIM_IFTIMING.CSNDUR: Minimum duration between edge of CSN and edge of SCK and minimum duration CSN must stay high between transactions
func (o *SPIM_IFTIMING_Type) SetCSNDUR(value uint32) {
	volatile.StoreUint32(&o.CSNDUR.Reg, volatile.LoadUint32(&o.CSNDUR.Reg)&^(0xff)|value)
}
func (o *SPIM_IFTIMING_Type) GetCSNDUR() uint32 {
	return volatile.LoadUint32(&o.CSNDUR.Reg) & 0xff
}

// SPI Slave
type SPIS_Type struct {
	_                 [36]byte
	TASKS_ACQUIRE     volatile.Register32 // 0x24
	TASKS_RELEASE     volatile.Register32 // 0x28
	_                 [120]byte
	SUBSCRIBE_ACQUIRE volatile.Register32 // 0xA4
	SUBSCRIBE_RELEASE volatile.Register32 // 0xA8
	_                 [88]byte
	EVENTS_END        volatile.Register32 // 0x104
	_                 [8]byte
	EVENTS_ENDRX      volatile.Register32 // 0x110
	_                 [20]byte
	EVENTS_ACQUIRED   volatile.Register32 // 0x128
	_                 [88]byte
	PUBLISH_END       volatile.Register32 // 0x184
	_                 [8]byte
	PUBLISH_ENDRX     volatile.Register32 // 0x190
	_                 [20]byte
	PUBLISH_ACQUIRED  volatile.Register32 // 0x1A8
	_                 [84]byte
	SHORTS            volatile.Register32 // 0x200
	_                 [256]byte
	INTENSET          volatile.Register32 // 0x304
	INTENCLR          volatile.Register32 // 0x308
	_                 [244]byte
	SEMSTAT           volatile.Register32 // 0x400
	_                 [60]byte
	STATUS            volatile.Register32 // 0x440
	_                 [188]byte
	ENABLE            volatile.Register32 // 0x500
	_                 [4]byte
	PSEL              SPIS_PSEL_Type // 0x508
	_                 [28]byte
	RXD               SPIS_RXD_Type       // 0x534
	TXD               SPIS_TXD_Type       // 0x544
	CONFIG            volatile.Register32 // 0x554
	_                 [4]byte
	DEF               volatile.Register32 // 0x55C
	_                 [96]byte
	ORC               volatile.Register32 // 0x5C0
}

// SPIS.TASKS_ACQUIRE: Acquire SPI semaphore
func (o *SPIS_Type) SetTASKS_ACQUIRE(value uint32) {
	volatile.StoreUint32(&o.TASKS_ACQUIRE.Reg, volatile.LoadUint32(&o.TASKS_ACQUIRE.Reg)&^(0x1)|value)
}
func (o *SPIS_Type) GetTASKS_ACQUIRE() uint32 {
	return volatile.LoadUint32(&o.TASKS_ACQUIRE.Reg) & 0x1
}

// SPIS.TASKS_RELEASE: Release SPI semaphore, enabling the SPI slave to acquire it
func (o *SPIS_Type) SetTASKS_RELEASE(value uint32) {
	volatile.StoreUint32(&o.TASKS_RELEASE.Reg, volatile.LoadUint32(&o.TASKS_RELEASE.Reg)&^(0x1)|value)
}
func (o *SPIS_Type) GetTASKS_RELEASE() uint32 {
	return volatile.LoadUint32(&o.TASKS_RELEASE.Reg) & 0x1
}

// SPIS.SUBSCRIBE_ACQUIRE: Subscribe configuration for task ACQUIRE
func (o *SPIS_Type) SetSUBSCRIBE_ACQUIRE_CHIDX(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_ACQUIRE.Reg, volatile.LoadUint32(&o.SUBSCRIBE_ACQUIRE.Reg)&^(0xff)|value)
}
func (o *SPIS_Type) GetSUBSCRIBE_ACQUIRE_CHIDX() uint32 {
	return volatile.LoadUint32(&o.SUBSCRIBE_ACQUIRE.Reg) & 0xff
}
func (o *SPIS_Type) SetSUBSCRIBE_ACQUIRE_EN(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_ACQUIRE.Reg, volatile.LoadUint32(&o.SUBSCRIBE_ACQUIRE.Reg)&^(0x80000000)|value<<31)
}
func (o *SPIS_Type) GetSUBSCRIBE_ACQUIRE_EN() uint32 {
	return (volatile.LoadUint32(&o.SUBSCRIBE_ACQUIRE.Reg) & 0x80000000) >> 31
}

// SPIS.SUBSCRIBE_RELEASE: Subscribe configuration for task RELEASE
func (o *SPIS_Type) SetSUBSCRIBE_RELEASE_CHIDX(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_RELEASE.Reg, volatile.LoadUint32(&o.SUBSCRIBE_RELEASE.Reg)&^(0xff)|value)
}
func (o *SPIS_Type) GetSUBSCRIBE_RELEASE_CHIDX() uint32 {
	return volatile.LoadUint32(&o.SUBSCRIBE_RELEASE.Reg) & 0xff
}
func (o *SPIS_Type) SetSUBSCRIBE_RELEASE_EN(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_RELEASE.Reg, volatile.LoadUint32(&o.SUBSCRIBE_RELEASE.Reg)&^(0x80000000)|value<<31)
}
func (o *SPIS_Type) GetSUBSCRIBE_RELEASE_EN() uint32 {
	return (volatile.LoadUint32(&o.SUBSCRIBE_RELEASE.Reg) & 0x80000000) >> 31
}

// SPIS.EVENTS_END: Granted transaction completed
func (o *SPIS_Type) SetEVENTS_END(value uint32) {
	volatile.StoreUint32(&o.EVENTS_END.Reg, volatile.LoadUint32(&o.EVENTS_END.Reg)&^(0x1)|value)
}
func (o *SPIS_Type) GetEVENTS_END() uint32 {
	return volatile.LoadUint32(&o.EVENTS_END.Reg) & 0x1
}

// SPIS.EVENTS_ENDRX: End of RXD buffer reached
func (o *SPIS_Type) SetEVENTS_ENDRX(value uint32) {
	volatile.StoreUint32(&o.EVENTS_ENDRX.Reg, volatile.LoadUint32(&o.EVENTS_ENDRX.Reg)&^(0x1)|value)
}
func (o *SPIS_Type) GetEVENTS_ENDRX() uint32 {
	return volatile.LoadUint32(&o.EVENTS_ENDRX.Reg) & 0x1
}

// SPIS.EVENTS_ACQUIRED: Semaphore acquired
func (o *SPIS_Type) SetEVENTS_ACQUIRED(value uint32) {
	volatile.StoreUint32(&o.EVENTS_ACQUIRED.Reg, volatile.LoadUint32(&o.EVENTS_ACQUIRED.Reg)&^(0x1)|value)
}
func (o *SPIS_Type) GetEVENTS_ACQUIRED() uint32 {
	return volatile.LoadUint32(&o.EVENTS_ACQUIRED.Reg) & 0x1
}

// SPIS.PUBLISH_END: Publish configuration for event END
func (o *SPIS_Type) SetPUBLISH_END_CHIDX(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_END.Reg, volatile.LoadUint32(&o.PUBLISH_END.Reg)&^(0xff)|value)
}
func (o *SPIS_Type) GetPUBLISH_END_CHIDX() uint32 {
	return volatile.LoadUint32(&o.PUBLISH_END.Reg) & 0xff
}
func (o *SPIS_Type) SetPUBLISH_END_EN(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_END.Reg, volatile.LoadUint32(&o.PUBLISH_END.Reg)&^(0x80000000)|value<<31)
}
func (o *SPIS_Type) GetPUBLISH_END_EN() uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_END.Reg) & 0x80000000) >> 31
}

// SPIS.PUBLISH_ENDRX: Publish configuration for event ENDRX
func (o *SPIS_Type) SetPUBLISH_ENDRX_CHIDX(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_ENDRX.Reg, volatile.LoadUint32(&o.PUBLISH_ENDRX.Reg)&^(0xff)|value)
}
func (o *SPIS_Type) GetPUBLISH_ENDRX_CHIDX() uint32 {
	return volatile.LoadUint32(&o.PUBLISH_ENDRX.Reg) & 0xff
}
func (o *SPIS_Type) SetPUBLISH_ENDRX_EN(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_ENDRX.Reg, volatile.LoadUint32(&o.PUBLISH_ENDRX.Reg)&^(0x80000000)|value<<31)
}
func (o *SPIS_Type) GetPUBLISH_ENDRX_EN() uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_ENDRX.Reg) & 0x80000000) >> 31
}

// SPIS.PUBLISH_ACQUIRED: Publish configuration for event ACQUIRED
func (o *SPIS_Type) SetPUBLISH_ACQUIRED_CHIDX(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_ACQUIRED.Reg, volatile.LoadUint32(&o.PUBLISH_ACQUIRED.Reg)&^(0xff)|value)
}
func (o *SPIS_Type) GetPUBLISH_ACQUIRED_CHIDX() uint32 {
	return volatile.LoadUint32(&o.PUBLISH_ACQUIRED.Reg) & 0xff
}
func (o *SPIS_Type) SetPUBLISH_ACQUIRED_EN(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_ACQUIRED.Reg, volatile.LoadUint32(&o.PUBLISH_ACQUIRED.Reg)&^(0x80000000)|value<<31)
}
func (o *SPIS_Type) GetPUBLISH_ACQUIRED_EN() uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_ACQUIRED.Reg) & 0x80000000) >> 31
}

// SPIS.SHORTS: Shortcuts between local events and tasks
func (o *SPIS_Type) SetSHORTS_END_ACQUIRE(value uint32) {
	volatile.StoreUint32(&o.SHORTS.Reg, volatile.LoadUint32(&o.SHORTS.Reg)&^(0x4)|value<<2)
}
func (o *SPIS_Type) GetSHORTS_END_ACQUIRE() uint32 {
	return (volatile.LoadUint32(&o.SHORTS.Reg) & 0x4) >> 2
}

// SPIS.INTENSET: Enable interrupt
func (o *SPIS_Type) SetINTENSET_END(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x2)|value<<1)
}
func (o *SPIS_Type) GetINTENSET_END() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x2) >> 1
}
func (o *SPIS_Type) SetINTENSET_ENDRX(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x10)|value<<4)
}
func (o *SPIS_Type) GetINTENSET_ENDRX() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x10) >> 4
}
func (o *SPIS_Type) SetINTENSET_ACQUIRED(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x400)|value<<10)
}
func (o *SPIS_Type) GetINTENSET_ACQUIRED() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x400) >> 10
}

// SPIS.INTENCLR: Disable interrupt
func (o *SPIS_Type) SetINTENCLR_END(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x2)|value<<1)
}
func (o *SPIS_Type) GetINTENCLR_END() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x2) >> 1
}
func (o *SPIS_Type) SetINTENCLR_ENDRX(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x10)|value<<4)
}
func (o *SPIS_Type) GetINTENCLR_ENDRX() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x10) >> 4
}
func (o *SPIS_Type) SetINTENCLR_ACQUIRED(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x400)|value<<10)
}
func (o *SPIS_Type) GetINTENCLR_ACQUIRED() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x400) >> 10
}

// SPIS.SEMSTAT: Semaphore status register
func (o *SPIS_Type) SetSEMSTAT(value uint32) {
	volatile.StoreUint32(&o.SEMSTAT.Reg, volatile.LoadUint32(&o.SEMSTAT.Reg)&^(0x3)|value)
}
func (o *SPIS_Type) GetSEMSTAT() uint32 {
	return volatile.LoadUint32(&o.SEMSTAT.Reg) & 0x3
}

// SPIS.STATUS: Status from last transaction
func (o *SPIS_Type) SetSTATUS_OVERREAD(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x1)|value)
}
func (o *SPIS_Type) GetSTATUS_OVERREAD() uint32 {
	return volatile.LoadUint32(&o.STATUS.Reg) & 0x1
}
func (o *SPIS_Type) SetSTATUS_OVERFLOW(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x2)|value<<1)
}
func (o *SPIS_Type) GetSTATUS_OVERFLOW() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0x2) >> 1
}

// SPIS.ENABLE: Enable SPI slave
func (o *SPIS_Type) SetENABLE(value uint32) {
	volatile.StoreUint32(&o.ENABLE.Reg, volatile.LoadUint32(&o.ENABLE.Reg)&^(0xf)|value)
}
func (o *SPIS_Type) GetENABLE() uint32 {
	return volatile.LoadUint32(&o.ENABLE.Reg) & 0xf
}

// SPIS.CONFIG: Configuration register
func (o *SPIS_Type) SetCONFIG_ORDER(value uint32) {
	volatile.StoreUint32(&o.CONFIG.Reg, volatile.LoadUint32(&o.CONFIG.Reg)&^(0x1)|value)
}
func (o *SPIS_Type) GetCONFIG_ORDER() uint32 {
	return volatile.LoadUint32(&o.CONFIG.Reg) & 0x1
}
func (o *SPIS_Type) SetCONFIG_CPHA(value uint32) {
	volatile.StoreUint32(&o.CONFIG.Reg, volatile.LoadUint32(&o.CONFIG.Reg)&^(0x2)|value<<1)
}
func (o *SPIS_Type) GetCONFIG_CPHA() uint32 {
	return (volatile.LoadUint32(&o.CONFIG.Reg) & 0x2) >> 1
}
func (o *SPIS_Type) SetCONFIG_CPOL(value uint32) {
	volatile.StoreUint32(&o.CONFIG.Reg, volatile.LoadUint32(&o.CONFIG.Reg)&^(0x4)|value<<2)
}
func (o *SPIS_Type) GetCONFIG_CPOL() uint32 {
	return (volatile.LoadUint32(&o.CONFIG.Reg) & 0x4) >> 2
}

// SPIS.DEF: Default character. Character clocked out in case of an ignored transaction.
func (o *SPIS_Type) SetDEF(value uint32) {
	volatile.StoreUint32(&o.DEF.Reg, volatile.LoadUint32(&o.DEF.Reg)&^(0xff)|value)
}
func (o *SPIS_Type) GetDEF() uint32 {
	return volatile.LoadUint32(&o.DEF.Reg) & 0xff
}

// SPIS.ORC: Over-read character
func (o *SPIS_Type) SetORC(value uint32) {
	volatile.StoreUint32(&o.ORC.Reg, volatile.LoadUint32(&o.ORC.Reg)&^(0xff)|value)
}
func (o *SPIS_Type) GetORC() uint32 {
	return volatile.LoadUint32(&o.ORC.Reg) & 0xff
}

// Unspecified
type SPIS_PSEL_Type struct {
	SCK  volatile.Register32 // 0x508
	MISO volatile.Register32 // 0x50C
	MOSI volatile.Register32 // 0x510
	CSN  volatile.Register32 // 0x514
}

// SPIS_PSEL.SCK: Pin select for SCK
func (o *SPIS_PSEL_Type) SetSCK_PIN(value uint32) {
	volatile.StoreUint32(&o.SCK.Reg, volatile.LoadUint32(&o.SCK.Reg)&^(0x1f)|value)
}
func (o *SPIS_PSEL_Type) GetSCK_PIN() uint32 {
	return volatile.LoadUint32(&o.SCK.Reg) & 0x1f
}
func (o *SPIS_PSEL_Type) SetSCK_PORT(value uint32) {
	volatile.StoreUint32(&o.SCK.Reg, volatile.LoadUint32(&o.SCK.Reg)&^(0x20)|value<<5)
}
func (o *SPIS_PSEL_Type) GetSCK_PORT() uint32 {
	return (volatile.LoadUint32(&o.SCK.Reg) & 0x20) >> 5
}
func (o *SPIS_PSEL_Type) SetSCK_CONNECT(value uint32) {
	volatile.StoreUint32(&o.SCK.Reg, volatile.LoadUint32(&o.SCK.Reg)&^(0x80000000)|value<<31)
}
func (o *SPIS_PSEL_Type) GetSCK_CONNECT() uint32 {
	return (volatile.LoadUint32(&o.SCK.Reg) & 0x80000000) >> 31
}

// SPIS_PSEL.MISO: Pin select for MISO signal
func (o *SPIS_PSEL_Type) SetMISO_PIN(value uint32) {
	volatile.StoreUint32(&o.MISO.Reg, volatile.LoadUint32(&o.MISO.Reg)&^(0x1f)|value)
}
func (o *SPIS_PSEL_Type) GetMISO_PIN() uint32 {
	return volatile.LoadUint32(&o.MISO.Reg) & 0x1f
}
func (o *SPIS_PSEL_Type) SetMISO_PORT(value uint32) {
	volatile.StoreUint32(&o.MISO.Reg, volatile.LoadUint32(&o.MISO.Reg)&^(0x20)|value<<5)
}
func (o *SPIS_PSEL_Type) GetMISO_PORT() uint32 {
	return (volatile.LoadUint32(&o.MISO.Reg) & 0x20) >> 5
}
func (o *SPIS_PSEL_Type) SetMISO_CONNECT(value uint32) {
	volatile.StoreUint32(&o.MISO.Reg, volatile.LoadUint32(&o.MISO.Reg)&^(0x80000000)|value<<31)
}
func (o *SPIS_PSEL_Type) GetMISO_CONNECT() uint32 {
	return (volatile.LoadUint32(&o.MISO.Reg) & 0x80000000) >> 31
}

// SPIS_PSEL.MOSI: Pin select for MOSI signal
func (o *SPIS_PSEL_Type) SetMOSI_PIN(value uint32) {
	volatile.StoreUint32(&o.MOSI.Reg, volatile.LoadUint32(&o.MOSI.Reg)&^(0x1f)|value)
}
func (o *SPIS_PSEL_Type) GetMOSI_PIN() uint32 {
	return volatile.LoadUint32(&o.MOSI.Reg) & 0x1f
}
func (o *SPIS_PSEL_Type) SetMOSI_PORT(value uint32) {
	volatile.StoreUint32(&o.MOSI.Reg, volatile.LoadUint32(&o.MOSI.Reg)&^(0x20)|value<<5)
}
func (o *SPIS_PSEL_Type) GetMOSI_PORT() uint32 {
	return (volatile.LoadUint32(&o.MOSI.Reg) & 0x20) >> 5
}
func (o *SPIS_PSEL_Type) SetMOSI_CONNECT(value uint32) {
	volatile.StoreUint32(&o.MOSI.Reg, volatile.LoadUint32(&o.MOSI.Reg)&^(0x80000000)|value<<31)
}
func (o *SPIS_PSEL_Type) GetMOSI_CONNECT() uint32 {
	return (volatile.LoadUint32(&o.MOSI.Reg) & 0x80000000) >> 31
}

// SPIS_PSEL.CSN: Pin select for CSN signal
func (o *SPIS_PSEL_Type) SetCSN_PIN(value uint32) {
	volatile.StoreUint32(&o.CSN.Reg, volatile.LoadUint32(&o.CSN.Reg)&^(0x1f)|value)
}
func (o *SPIS_PSEL_Type) GetCSN_PIN() uint32 {
	return volatile.LoadUint32(&o.CSN.Reg) & 0x1f
}
func (o *SPIS_PSEL_Type) SetCSN_PORT(value uint32) {
	volatile.StoreUint32(&o.CSN.Reg, volatile.LoadUint32(&o.CSN.Reg)&^(0x20)|value<<5)
}
func (o *SPIS_PSEL_Type) GetCSN_PORT() uint32 {
	return (volatile.LoadUint32(&o.CSN.Reg) & 0x20) >> 5
}
func (o *SPIS_PSEL_Type) SetCSN_CONNECT(value uint32) {
	volatile.StoreUint32(&o.CSN.Reg, volatile.LoadUint32(&o.CSN.Reg)&^(0x80000000)|value<<31)
}
func (o *SPIS_PSEL_Type) GetCSN_CONNECT() uint32 {
	return (volatile.LoadUint32(&o.CSN.Reg) & 0x80000000) >> 31
}

// Unspecified
type SPIS_RXD_Type struct {
	PTR    volatile.Register32 // 0x534
	MAXCNT volatile.Register32 // 0x538
	AMOUNT volatile.Register32 // 0x53C
	LIST   volatile.Register32 // 0x540
}

// SPIS_RXD.PTR: RXD data pointer
func (o *SPIS_RXD_Type) SetPTR(value uint32) {
	volatile.StoreUint32(&o.PTR.Reg, value)
}
func (o *SPIS_RXD_Type) GetPTR() uint32 {
	return volatile.LoadUint32(&o.PTR.Reg)
}

// SPIS_RXD.MAXCNT: Maximum number of bytes in receive buffer
func (o *SPIS_RXD_Type) SetMAXCNT(value uint32) {
	volatile.StoreUint32(&o.MAXCNT.Reg, volatile.LoadUint32(&o.MAXCNT.Reg)&^(0xffff)|value)
}
func (o *SPIS_RXD_Type) GetMAXCNT() uint32 {
	return volatile.LoadUint32(&o.MAXCNT.Reg) & 0xffff
}

// SPIS_RXD.AMOUNT: Number of bytes received in last granted transaction
func (o *SPIS_RXD_Type) SetAMOUNT(value uint32) {
	volatile.StoreUint32(&o.AMOUNT.Reg, volatile.LoadUint32(&o.AMOUNT.Reg)&^(0xffff)|value)
}
func (o *SPIS_RXD_Type) GetAMOUNT() uint32 {
	return volatile.LoadUint32(&o.AMOUNT.Reg) & 0xffff
}

// SPIS_RXD.LIST: EasyDMA list type
func (o *SPIS_RXD_Type) SetLIST(value uint32) {
	volatile.StoreUint32(&o.LIST.Reg, volatile.LoadUint32(&o.LIST.Reg)&^(0x3)|value)
}
func (o *SPIS_RXD_Type) GetLIST() uint32 {
	return volatile.LoadUint32(&o.LIST.Reg) & 0x3
}

// Unspecified
type SPIS_TXD_Type struct {
	PTR    volatile.Register32 // 0x544
	MAXCNT volatile.Register32 // 0x548
	AMOUNT volatile.Register32 // 0x54C
	LIST   volatile.Register32 // 0x550
}

// SPIS_TXD.PTR: TXD data pointer
func (o *SPIS_TXD_Type) SetPTR(value uint32) {
	volatile.StoreUint32(&o.PTR.Reg, value)
}
func (o *SPIS_TXD_Type) GetPTR() uint32 {
	return volatile.LoadUint32(&o.PTR.Reg)
}

// SPIS_TXD.MAXCNT: Maximum number of bytes in transmit buffer
func (o *SPIS_TXD_Type) SetMAXCNT(value uint32) {
	volatile.StoreUint32(&o.MAXCNT.Reg, volatile.LoadUint32(&o.MAXCNT.Reg)&^(0xffff)|value)
}
func (o *SPIS_TXD_Type) GetMAXCNT() uint32 {
	return volatile.LoadUint32(&o.MAXCNT.Reg) & 0xffff
}

// SPIS_TXD.AMOUNT: Number of bytes transmitted in last granted transaction
func (o *SPIS_TXD_Type) SetAMOUNT(value uint32) {
	volatile.StoreUint32(&o.AMOUNT.Reg, volatile.LoadUint32(&o.AMOUNT.Reg)&^(0xffff)|value)
}
func (o *SPIS_TXD_Type) GetAMOUNT() uint32 {
	return volatile.LoadUint32(&o.AMOUNT.Reg) & 0xffff
}

// SPIS_TXD.LIST: EasyDMA list type
func (o *SPIS_TXD_Type) SetLIST(value uint32) {
	volatile.StoreUint32(&o.LIST.Reg, volatile.LoadUint32(&o.LIST.Reg)&^(0x3)|value)
}
func (o *SPIS_TXD_Type) GetLIST() uint32 {
	return volatile.LoadUint32(&o.LIST.Reg) & 0x3
}

// I2C compatible Two-Wire Master Interface with EasyDMA
type TWIM_Type struct {
	TASKS_STARTRX     volatile.Register32 // 0x0
	_                 [4]byte
	TASKS_STARTTX     volatile.Register32 // 0x8
	_                 [8]byte
	TASKS_STOP        volatile.Register32 // 0x14
	_                 [4]byte
	TASKS_SUSPEND     volatile.Register32 // 0x1C
	TASKS_RESUME      volatile.Register32 // 0x20
	_                 [92]byte
	SUBSCRIBE_STARTRX volatile.Register32 // 0x80
	_                 [4]byte
	SUBSCRIBE_STARTTX volatile.Register32 // 0x88
	_                 [8]byte
	SUBSCRIBE_STOP    volatile.Register32 // 0x94
	_                 [4]byte
	SUBSCRIBE_SUSPEND volatile.Register32 // 0x9C
	SUBSCRIBE_RESUME  volatile.Register32 // 0xA0
	_                 [96]byte
	EVENTS_STOPPED    volatile.Register32 // 0x104
	_                 [28]byte
	EVENTS_ERROR      volatile.Register32 // 0x124
	_                 [32]byte
	EVENTS_SUSPENDED  volatile.Register32 // 0x148
	EVENTS_RXSTARTED  volatile.Register32 // 0x14C
	EVENTS_TXSTARTED  volatile.Register32 // 0x150
	_                 [8]byte
	EVENTS_LASTRX     volatile.Register32 // 0x15C
	EVENTS_LASTTX     volatile.Register32 // 0x160
	_                 [32]byte
	PUBLISH_STOPPED   volatile.Register32 // 0x184
	_                 [28]byte
	PUBLISH_ERROR     volatile.Register32 // 0x1A4
	_                 [32]byte
	PUBLISH_SUSPENDED volatile.Register32 // 0x1C8
	PUBLISH_RXSTARTED volatile.Register32 // 0x1CC
	PUBLISH_TXSTARTED volatile.Register32 // 0x1D0
	_                 [8]byte
	PUBLISH_LASTRX    volatile.Register32 // 0x1DC
	PUBLISH_LASTTX    volatile.Register32 // 0x1E0
	_                 [28]byte
	SHORTS            volatile.Register32 // 0x200
	_                 [252]byte
	INTEN             volatile.Register32 // 0x300
	INTENSET          volatile.Register32 // 0x304
	INTENCLR          volatile.Register32 // 0x308
	_                 [440]byte
	ERRORSRC          volatile.Register32 // 0x4C4
	_                 [56]byte
	ENABLE            volatile.Register32 // 0x500
	_                 [4]byte
	PSEL              TWIM_PSEL_Type // 0x508
	_                 [20]byte
	FREQUENCY         volatile.Register32 // 0x524
	_                 [12]byte
	RXD               TWIM_RXD_Type // 0x534
	TXD               TWIM_TXD_Type // 0x544
	_                 [52]byte
	ADDRESS           volatile.Register32 // 0x588
}

// TWIM.TASKS_STARTRX: Start TWI receive sequence
func (o *TWIM_Type) SetTASKS_STARTRX(value uint32) {
	volatile.StoreUint32(&o.TASKS_STARTRX.Reg, volatile.LoadUint32(&o.TASKS_STARTRX.Reg)&^(0x1)|value)
}
func (o *TWIM_Type) GetTASKS_STARTRX() uint32 {
	return volatile.LoadUint32(&o.TASKS_STARTRX.Reg) & 0x1
}

// TWIM.TASKS_STARTTX: Start TWI transmit sequence
func (o *TWIM_Type) SetTASKS_STARTTX(value uint32) {
	volatile.StoreUint32(&o.TASKS_STARTTX.Reg, volatile.LoadUint32(&o.TASKS_STARTTX.Reg)&^(0x1)|value)
}
func (o *TWIM_Type) GetTASKS_STARTTX() uint32 {
	return volatile.LoadUint32(&o.TASKS_STARTTX.Reg) & 0x1
}

// TWIM.TASKS_STOP: Stop TWI transaction. Must be issued while the TWI master is not suspended.
func (o *TWIM_Type) SetTASKS_STOP(value uint32) {
	volatile.StoreUint32(&o.TASKS_STOP.Reg, volatile.LoadUint32(&o.TASKS_STOP.Reg)&^(0x1)|value)
}
func (o *TWIM_Type) GetTASKS_STOP() uint32 {
	return volatile.LoadUint32(&o.TASKS_STOP.Reg) & 0x1
}

// TWIM.TASKS_SUSPEND: Suspend TWI transaction
func (o *TWIM_Type) SetTASKS_SUSPEND(value uint32) {
	volatile.StoreUint32(&o.TASKS_SUSPEND.Reg, volatile.LoadUint32(&o.TASKS_SUSPEND.Reg)&^(0x1)|value)
}
func (o *TWIM_Type) GetTASKS_SUSPEND() uint32 {
	return volatile.LoadUint32(&o.TASKS_SUSPEND.Reg) & 0x1
}

// TWIM.TASKS_RESUME: Resume TWI transaction
func (o *TWIM_Type) SetTASKS_RESUME(value uint32) {
	volatile.StoreUint32(&o.TASKS_RESUME.Reg, volatile.LoadUint32(&o.TASKS_RESUME.Reg)&^(0x1)|value)
}
func (o *TWIM_Type) GetTASKS_RESUME() uint32 {
	return volatile.LoadUint32(&o.TASKS_RESUME.Reg) & 0x1
}

// TWIM.SUBSCRIBE_STARTRX: Subscribe configuration for task STARTRX
func (o *TWIM_Type) SetSUBSCRIBE_STARTRX_CHIDX(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_STARTRX.Reg, volatile.LoadUint32(&o.SUBSCRIBE_STARTRX.Reg)&^(0xff)|value)
}
func (o *TWIM_Type) GetSUBSCRIBE_STARTRX_CHIDX() uint32 {
	return volatile.LoadUint32(&o.SUBSCRIBE_STARTRX.Reg) & 0xff
}
func (o *TWIM_Type) SetSUBSCRIBE_STARTRX_EN(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_STARTRX.Reg, volatile.LoadUint32(&o.SUBSCRIBE_STARTRX.Reg)&^(0x80000000)|value<<31)
}
func (o *TWIM_Type) GetSUBSCRIBE_STARTRX_EN() uint32 {
	return (volatile.LoadUint32(&o.SUBSCRIBE_STARTRX.Reg) & 0x80000000) >> 31
}

// TWIM.SUBSCRIBE_STARTTX: Subscribe configuration for task STARTTX
func (o *TWIM_Type) SetSUBSCRIBE_STARTTX_CHIDX(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_STARTTX.Reg, volatile.LoadUint32(&o.SUBSCRIBE_STARTTX.Reg)&^(0xff)|value)
}
func (o *TWIM_Type) GetSUBSCRIBE_STARTTX_CHIDX() uint32 {
	return volatile.LoadUint32(&o.SUBSCRIBE_STARTTX.Reg) & 0xff
}
func (o *TWIM_Type) SetSUBSCRIBE_STARTTX_EN(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_STARTTX.Reg, volatile.LoadUint32(&o.SUBSCRIBE_STARTTX.Reg)&^(0x80000000)|value<<31)
}
func (o *TWIM_Type) GetSUBSCRIBE_STARTTX_EN() uint32 {
	return (volatile.LoadUint32(&o.SUBSCRIBE_STARTTX.Reg) & 0x80000000) >> 31
}

// TWIM.SUBSCRIBE_STOP: Subscribe configuration for task STOP
func (o *TWIM_Type) SetSUBSCRIBE_STOP_CHIDX(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_STOP.Reg, volatile.LoadUint32(&o.SUBSCRIBE_STOP.Reg)&^(0xff)|value)
}
func (o *TWIM_Type) GetSUBSCRIBE_STOP_CHIDX() uint32 {
	return volatile.LoadUint32(&o.SUBSCRIBE_STOP.Reg) & 0xff
}
func (o *TWIM_Type) SetSUBSCRIBE_STOP_EN(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_STOP.Reg, volatile.LoadUint32(&o.SUBSCRIBE_STOP.Reg)&^(0x80000000)|value<<31)
}
func (o *TWIM_Type) GetSUBSCRIBE_STOP_EN() uint32 {
	return (volatile.LoadUint32(&o.SUBSCRIBE_STOP.Reg) & 0x80000000) >> 31
}

// TWIM.SUBSCRIBE_SUSPEND: Subscribe configuration for task SUSPEND
func (o *TWIM_Type) SetSUBSCRIBE_SUSPEND_CHIDX(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_SUSPEND.Reg, volatile.LoadUint32(&o.SUBSCRIBE_SUSPEND.Reg)&^(0xff)|value)
}
func (o *TWIM_Type) GetSUBSCRIBE_SUSPEND_CHIDX() uint32 {
	return volatile.LoadUint32(&o.SUBSCRIBE_SUSPEND.Reg) & 0xff
}
func (o *TWIM_Type) SetSUBSCRIBE_SUSPEND_EN(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_SUSPEND.Reg, volatile.LoadUint32(&o.SUBSCRIBE_SUSPEND.Reg)&^(0x80000000)|value<<31)
}
func (o *TWIM_Type) GetSUBSCRIBE_SUSPEND_EN() uint32 {
	return (volatile.LoadUint32(&o.SUBSCRIBE_SUSPEND.Reg) & 0x80000000) >> 31
}

// TWIM.SUBSCRIBE_RESUME: Subscribe configuration for task RESUME
func (o *TWIM_Type) SetSUBSCRIBE_RESUME_CHIDX(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_RESUME.Reg, volatile.LoadUint32(&o.SUBSCRIBE_RESUME.Reg)&^(0xff)|value)
}
func (o *TWIM_Type) GetSUBSCRIBE_RESUME_CHIDX() uint32 {
	return volatile.LoadUint32(&o.SUBSCRIBE_RESUME.Reg) & 0xff
}
func (o *TWIM_Type) SetSUBSCRIBE_RESUME_EN(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_RESUME.Reg, volatile.LoadUint32(&o.SUBSCRIBE_RESUME.Reg)&^(0x80000000)|value<<31)
}
func (o *TWIM_Type) GetSUBSCRIBE_RESUME_EN() uint32 {
	return (volatile.LoadUint32(&o.SUBSCRIBE_RESUME.Reg) & 0x80000000) >> 31
}

// TWIM.EVENTS_STOPPED: TWI stopped
func (o *TWIM_Type) SetEVENTS_STOPPED(value uint32) {
	volatile.StoreUint32(&o.EVENTS_STOPPED.Reg, volatile.LoadUint32(&o.EVENTS_STOPPED.Reg)&^(0x1)|value)
}
func (o *TWIM_Type) GetEVENTS_STOPPED() uint32 {
	return volatile.LoadUint32(&o.EVENTS_STOPPED.Reg) & 0x1
}

// TWIM.EVENTS_ERROR: TWI error
func (o *TWIM_Type) SetEVENTS_ERROR(value uint32) {
	volatile.StoreUint32(&o.EVENTS_ERROR.Reg, volatile.LoadUint32(&o.EVENTS_ERROR.Reg)&^(0x1)|value)
}
func (o *TWIM_Type) GetEVENTS_ERROR() uint32 {
	return volatile.LoadUint32(&o.EVENTS_ERROR.Reg) & 0x1
}

// TWIM.EVENTS_SUSPENDED: SUSPEND task has been issued, TWI traffic is now suspended.
func (o *TWIM_Type) SetEVENTS_SUSPENDED(value uint32) {
	volatile.StoreUint32(&o.EVENTS_SUSPENDED.Reg, volatile.LoadUint32(&o.EVENTS_SUSPENDED.Reg)&^(0x1)|value)
}
func (o *TWIM_Type) GetEVENTS_SUSPENDED() uint32 {
	return volatile.LoadUint32(&o.EVENTS_SUSPENDED.Reg) & 0x1
}

// TWIM.EVENTS_RXSTARTED: Receive sequence started
func (o *TWIM_Type) SetEVENTS_RXSTARTED(value uint32) {
	volatile.StoreUint32(&o.EVENTS_RXSTARTED.Reg, volatile.LoadUint32(&o.EVENTS_RXSTARTED.Reg)&^(0x1)|value)
}
func (o *TWIM_Type) GetEVENTS_RXSTARTED() uint32 {
	return volatile.LoadUint32(&o.EVENTS_RXSTARTED.Reg) & 0x1
}

// TWIM.EVENTS_TXSTARTED: Transmit sequence started
func (o *TWIM_Type) SetEVENTS_TXSTARTED(value uint32) {
	volatile.StoreUint32(&o.EVENTS_TXSTARTED.Reg, volatile.LoadUint32(&o.EVENTS_TXSTARTED.Reg)&^(0x1)|value)
}
func (o *TWIM_Type) GetEVENTS_TXSTARTED() uint32 {
	return volatile.LoadUint32(&o.EVENTS_TXSTARTED.Reg) & 0x1
}

// TWIM.EVENTS_LASTRX: Byte boundary, starting to receive the last byte
func (o *TWIM_Type) SetEVENTS_LASTRX(value uint32) {
	volatile.StoreUint32(&o.EVENTS_LASTRX.Reg, volatile.LoadUint32(&o.EVENTS_LASTRX.Reg)&^(0x1)|value)
}
func (o *TWIM_Type) GetEVENTS_LASTRX() uint32 {
	return volatile.LoadUint32(&o.EVENTS_LASTRX.Reg) & 0x1
}

// TWIM.EVENTS_LASTTX: Byte boundary, starting to transmit the last byte
func (o *TWIM_Type) SetEVENTS_LASTTX(value uint32) {
	volatile.StoreUint32(&o.EVENTS_LASTTX.Reg, volatile.LoadUint32(&o.EVENTS_LASTTX.Reg)&^(0x1)|value)
}
func (o *TWIM_Type) GetEVENTS_LASTTX() uint32 {
	return volatile.LoadUint32(&o.EVENTS_LASTTX.Reg) & 0x1
}

// TWIM.PUBLISH_STOPPED: Publish configuration for event STOPPED
func (o *TWIM_Type) SetPUBLISH_STOPPED_CHIDX(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_STOPPED.Reg, volatile.LoadUint32(&o.PUBLISH_STOPPED.Reg)&^(0xff)|value)
}
func (o *TWIM_Type) GetPUBLISH_STOPPED_CHIDX() uint32 {
	return volatile.LoadUint32(&o.PUBLISH_STOPPED.Reg) & 0xff
}
func (o *TWIM_Type) SetPUBLISH_STOPPED_EN(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_STOPPED.Reg, volatile.LoadUint32(&o.PUBLISH_STOPPED.Reg)&^(0x80000000)|value<<31)
}
func (o *TWIM_Type) GetPUBLISH_STOPPED_EN() uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_STOPPED.Reg) & 0x80000000) >> 31
}

// TWIM.PUBLISH_ERROR: Publish configuration for event ERROR
func (o *TWIM_Type) SetPUBLISH_ERROR_CHIDX(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_ERROR.Reg, volatile.LoadUint32(&o.PUBLISH_ERROR.Reg)&^(0xff)|value)
}
func (o *TWIM_Type) GetPUBLISH_ERROR_CHIDX() uint32 {
	return volatile.LoadUint32(&o.PUBLISH_ERROR.Reg) & 0xff
}
func (o *TWIM_Type) SetPUBLISH_ERROR_EN(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_ERROR.Reg, volatile.LoadUint32(&o.PUBLISH_ERROR.Reg)&^(0x80000000)|value<<31)
}
func (o *TWIM_Type) GetPUBLISH_ERROR_EN() uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_ERROR.Reg) & 0x80000000) >> 31
}

// TWIM.PUBLISH_SUSPENDED: Publish configuration for event SUSPENDED
func (o *TWIM_Type) SetPUBLISH_SUSPENDED_CHIDX(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_SUSPENDED.Reg, volatile.LoadUint32(&o.PUBLISH_SUSPENDED.Reg)&^(0xff)|value)
}
func (o *TWIM_Type) GetPUBLISH_SUSPENDED_CHIDX() uint32 {
	return volatile.LoadUint32(&o.PUBLISH_SUSPENDED.Reg) & 0xff
}
func (o *TWIM_Type) SetPUBLISH_SUSPENDED_EN(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_SUSPENDED.Reg, volatile.LoadUint32(&o.PUBLISH_SUSPENDED.Reg)&^(0x80000000)|value<<31)
}
func (o *TWIM_Type) GetPUBLISH_SUSPENDED_EN() uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_SUSPENDED.Reg) & 0x80000000) >> 31
}

// TWIM.PUBLISH_RXSTARTED: Publish configuration for event RXSTARTED
func (o *TWIM_Type) SetPUBLISH_RXSTARTED_CHIDX(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_RXSTARTED.Reg, volatile.LoadUint32(&o.PUBLISH_RXSTARTED.Reg)&^(0xff)|value)
}
func (o *TWIM_Type) GetPUBLISH_RXSTARTED_CHIDX() uint32 {
	return volatile.LoadUint32(&o.PUBLISH_RXSTARTED.Reg) & 0xff
}
func (o *TWIM_Type) SetPUBLISH_RXSTARTED_EN(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_RXSTARTED.Reg, volatile.LoadUint32(&o.PUBLISH_RXSTARTED.Reg)&^(0x80000000)|value<<31)
}
func (o *TWIM_Type) GetPUBLISH_RXSTARTED_EN() uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_RXSTARTED.Reg) & 0x80000000) >> 31
}

// TWIM.PUBLISH_TXSTARTED: Publish configuration for event TXSTARTED
func (o *TWIM_Type) SetPUBLISH_TXSTARTED_CHIDX(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_TXSTARTED.Reg, volatile.LoadUint32(&o.PUBLISH_TXSTARTED.Reg)&^(0xff)|value)
}
func (o *TWIM_Type) GetPUBLISH_TXSTARTED_CHIDX() uint32 {
	return volatile.LoadUint32(&o.PUBLISH_TXSTARTED.Reg) & 0xff
}
func (o *TWIM_Type) SetPUBLISH_TXSTARTED_EN(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_TXSTARTED.Reg, volatile.LoadUint32(&o.PUBLISH_TXSTARTED.Reg)&^(0x80000000)|value<<31)
}
func (o *TWIM_Type) GetPUBLISH_TXSTARTED_EN() uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_TXSTARTED.Reg) & 0x80000000) >> 31
}

// TWIM.PUBLISH_LASTRX: Publish configuration for event LASTRX
func (o *TWIM_Type) SetPUBLISH_LASTRX_CHIDX(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_LASTRX.Reg, volatile.LoadUint32(&o.PUBLISH_LASTRX.Reg)&^(0xff)|value)
}
func (o *TWIM_Type) GetPUBLISH_LASTRX_CHIDX() uint32 {
	return volatile.LoadUint32(&o.PUBLISH_LASTRX.Reg) & 0xff
}
func (o *TWIM_Type) SetPUBLISH_LASTRX_EN(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_LASTRX.Reg, volatile.LoadUint32(&o.PUBLISH_LASTRX.Reg)&^(0x80000000)|value<<31)
}
func (o *TWIM_Type) GetPUBLISH_LASTRX_EN() uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_LASTRX.Reg) & 0x80000000) >> 31
}

// TWIM.PUBLISH_LASTTX: Publish configuration for event LASTTX
func (o *TWIM_Type) SetPUBLISH_LASTTX_CHIDX(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_LASTTX.Reg, volatile.LoadUint32(&o.PUBLISH_LASTTX.Reg)&^(0xff)|value)
}
func (o *TWIM_Type) GetPUBLISH_LASTTX_CHIDX() uint32 {
	return volatile.LoadUint32(&o.PUBLISH_LASTTX.Reg) & 0xff
}
func (o *TWIM_Type) SetPUBLISH_LASTTX_EN(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_LASTTX.Reg, volatile.LoadUint32(&o.PUBLISH_LASTTX.Reg)&^(0x80000000)|value<<31)
}
func (o *TWIM_Type) GetPUBLISH_LASTTX_EN() uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_LASTTX.Reg) & 0x80000000) >> 31
}

// TWIM.SHORTS: Shortcuts between local events and tasks
func (o *TWIM_Type) SetSHORTS_LASTTX_STARTRX(value uint32) {
	volatile.StoreUint32(&o.SHORTS.Reg, volatile.LoadUint32(&o.SHORTS.Reg)&^(0x80)|value<<7)
}
func (o *TWIM_Type) GetSHORTS_LASTTX_STARTRX() uint32 {
	return (volatile.LoadUint32(&o.SHORTS.Reg) & 0x80) >> 7
}
func (o *TWIM_Type) SetSHORTS_LASTTX_SUSPEND(value uint32) {
	volatile.StoreUint32(&o.SHORTS.Reg, volatile.LoadUint32(&o.SHORTS.Reg)&^(0x100)|value<<8)
}
func (o *TWIM_Type) GetSHORTS_LASTTX_SUSPEND() uint32 {
	return (volatile.LoadUint32(&o.SHORTS.Reg) & 0x100) >> 8
}
func (o *TWIM_Type) SetSHORTS_LASTTX_STOP(value uint32) {
	volatile.StoreUint32(&o.SHORTS.Reg, volatile.LoadUint32(&o.SHORTS.Reg)&^(0x200)|value<<9)
}
func (o *TWIM_Type) GetSHORTS_LASTTX_STOP() uint32 {
	return (volatile.LoadUint32(&o.SHORTS.Reg) & 0x200) >> 9
}
func (o *TWIM_Type) SetSHORTS_LASTRX_STARTTX(value uint32) {
	volatile.StoreUint32(&o.SHORTS.Reg, volatile.LoadUint32(&o.SHORTS.Reg)&^(0x400)|value<<10)
}
func (o *TWIM_Type) GetSHORTS_LASTRX_STARTTX() uint32 {
	return (volatile.LoadUint32(&o.SHORTS.Reg) & 0x400) >> 10
}
func (o *TWIM_Type) SetSHORTS_LASTRX_SUSPEND(value uint32) {
	volatile.StoreUint32(&o.SHORTS.Reg, volatile.LoadUint32(&o.SHORTS.Reg)&^(0x800)|value<<11)
}
func (o *TWIM_Type) GetSHORTS_LASTRX_SUSPEND() uint32 {
	return (volatile.LoadUint32(&o.SHORTS.Reg) & 0x800) >> 11
}
func (o *TWIM_Type) SetSHORTS_LASTRX_STOP(value uint32) {
	volatile.StoreUint32(&o.SHORTS.Reg, volatile.LoadUint32(&o.SHORTS.Reg)&^(0x1000)|value<<12)
}
func (o *TWIM_Type) GetSHORTS_LASTRX_STOP() uint32 {
	return (volatile.LoadUint32(&o.SHORTS.Reg) & 0x1000) >> 12
}

// TWIM.INTEN: Enable or disable interrupt
func (o *TWIM_Type) SetINTEN_STOPPED(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x2)|value<<1)
}
func (o *TWIM_Type) GetINTEN_STOPPED() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x2) >> 1
}
func (o *TWIM_Type) SetINTEN_ERROR(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x200)|value<<9)
}
func (o *TWIM_Type) GetINTEN_ERROR() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x200) >> 9
}
func (o *TWIM_Type) SetINTEN_SUSPENDED(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x40000)|value<<18)
}
func (o *TWIM_Type) GetINTEN_SUSPENDED() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x40000) >> 18
}
func (o *TWIM_Type) SetINTEN_RXSTARTED(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x80000)|value<<19)
}
func (o *TWIM_Type) GetINTEN_RXSTARTED() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x80000) >> 19
}
func (o *TWIM_Type) SetINTEN_TXSTARTED(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x100000)|value<<20)
}
func (o *TWIM_Type) GetINTEN_TXSTARTED() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x100000) >> 20
}
func (o *TWIM_Type) SetINTEN_LASTRX(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x800000)|value<<23)
}
func (o *TWIM_Type) GetINTEN_LASTRX() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x800000) >> 23
}
func (o *TWIM_Type) SetINTEN_LASTTX(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x1000000)|value<<24)
}
func (o *TWIM_Type) GetINTEN_LASTTX() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x1000000) >> 24
}

// TWIM.INTENSET: Enable interrupt
func (o *TWIM_Type) SetINTENSET_STOPPED(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x2)|value<<1)
}
func (o *TWIM_Type) GetINTENSET_STOPPED() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x2) >> 1
}
func (o *TWIM_Type) SetINTENSET_ERROR(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x200)|value<<9)
}
func (o *TWIM_Type) GetINTENSET_ERROR() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x200) >> 9
}
func (o *TWIM_Type) SetINTENSET_SUSPENDED(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x40000)|value<<18)
}
func (o *TWIM_Type) GetINTENSET_SUSPENDED() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x40000) >> 18
}
func (o *TWIM_Type) SetINTENSET_RXSTARTED(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x80000)|value<<19)
}
func (o *TWIM_Type) GetINTENSET_RXSTARTED() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x80000) >> 19
}
func (o *TWIM_Type) SetINTENSET_TXSTARTED(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x100000)|value<<20)
}
func (o *TWIM_Type) GetINTENSET_TXSTARTED() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x100000) >> 20
}
func (o *TWIM_Type) SetINTENSET_LASTRX(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x800000)|value<<23)
}
func (o *TWIM_Type) GetINTENSET_LASTRX() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x800000) >> 23
}
func (o *TWIM_Type) SetINTENSET_LASTTX(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x1000000)|value<<24)
}
func (o *TWIM_Type) GetINTENSET_LASTTX() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x1000000) >> 24
}

// TWIM.INTENCLR: Disable interrupt
func (o *TWIM_Type) SetINTENCLR_STOPPED(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x2)|value<<1)
}
func (o *TWIM_Type) GetINTENCLR_STOPPED() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x2) >> 1
}
func (o *TWIM_Type) SetINTENCLR_ERROR(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x200)|value<<9)
}
func (o *TWIM_Type) GetINTENCLR_ERROR() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x200) >> 9
}
func (o *TWIM_Type) SetINTENCLR_SUSPENDED(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x40000)|value<<18)
}
func (o *TWIM_Type) GetINTENCLR_SUSPENDED() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x40000) >> 18
}
func (o *TWIM_Type) SetINTENCLR_RXSTARTED(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x80000)|value<<19)
}
func (o *TWIM_Type) GetINTENCLR_RXSTARTED() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x80000) >> 19
}
func (o *TWIM_Type) SetINTENCLR_TXSTARTED(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x100000)|value<<20)
}
func (o *TWIM_Type) GetINTENCLR_TXSTARTED() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x100000) >> 20
}
func (o *TWIM_Type) SetINTENCLR_LASTRX(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x800000)|value<<23)
}
func (o *TWIM_Type) GetINTENCLR_LASTRX() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x800000) >> 23
}
func (o *TWIM_Type) SetINTENCLR_LASTTX(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x1000000)|value<<24)
}
func (o *TWIM_Type) GetINTENCLR_LASTTX() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x1000000) >> 24
}

// TWIM.ERRORSRC: Error source
func (o *TWIM_Type) SetERRORSRC_OVERRUN(value uint32) {
	volatile.StoreUint32(&o.ERRORSRC.Reg, volatile.LoadUint32(&o.ERRORSRC.Reg)&^(0x1)|value)
}
func (o *TWIM_Type) GetERRORSRC_OVERRUN() uint32 {
	return volatile.LoadUint32(&o.ERRORSRC.Reg) & 0x1
}
func (o *TWIM_Type) SetERRORSRC_ANACK(value uint32) {
	volatile.StoreUint32(&o.ERRORSRC.Reg, volatile.LoadUint32(&o.ERRORSRC.Reg)&^(0x2)|value<<1)
}
func (o *TWIM_Type) GetERRORSRC_ANACK() uint32 {
	return (volatile.LoadUint32(&o.ERRORSRC.Reg) & 0x2) >> 1
}
func (o *TWIM_Type) SetERRORSRC_DNACK(value uint32) {
	volatile.StoreUint32(&o.ERRORSRC.Reg, volatile.LoadUint32(&o.ERRORSRC.Reg)&^(0x4)|value<<2)
}
func (o *TWIM_Type) GetERRORSRC_DNACK() uint32 {
	return (volatile.LoadUint32(&o.ERRORSRC.Reg) & 0x4) >> 2
}

// TWIM.ENABLE: Enable TWIM
func (o *TWIM_Type) SetENABLE(value uint32) {
	volatile.StoreUint32(&o.ENABLE.Reg, volatile.LoadUint32(&o.ENABLE.Reg)&^(0xf)|value)
}
func (o *TWIM_Type) GetENABLE() uint32 {
	return volatile.LoadUint32(&o.ENABLE.Reg) & 0xf
}

// TWIM.FREQUENCY: TWI frequency. Accuracy depends on the HFCLK source selected.
func (o *TWIM_Type) SetFREQUENCY(value uint32) {
	volatile.StoreUint32(&o.FREQUENCY.Reg, value)
}
func (o *TWIM_Type) GetFREQUENCY() uint32 {
	return volatile.LoadUint32(&o.FREQUENCY.Reg)
}

// TWIM.ADDRESS: Address used in the TWI transfer
func (o *TWIM_Type) SetADDRESS(value uint32) {
	volatile.StoreUint32(&o.ADDRESS.Reg, volatile.LoadUint32(&o.ADDRESS.Reg)&^(0x7f)|value)
}
func (o *TWIM_Type) GetADDRESS() uint32 {
	return volatile.LoadUint32(&o.ADDRESS.Reg) & 0x7f
}

// Unspecified
type TWIM_PSEL_Type struct {
	SCL volatile.Register32 // 0x508
	SDA volatile.Register32 // 0x50C
}

// TWIM_PSEL.SCL: Pin select for SCL signal
func (o *TWIM_PSEL_Type) SetSCL_PIN(value uint32) {
	volatile.StoreUint32(&o.SCL.Reg, volatile.LoadUint32(&o.SCL.Reg)&^(0x1f)|value)
}
func (o *TWIM_PSEL_Type) GetSCL_PIN() uint32 {
	return volatile.LoadUint32(&o.SCL.Reg) & 0x1f
}
func (o *TWIM_PSEL_Type) SetSCL_PORT(value uint32) {
	volatile.StoreUint32(&o.SCL.Reg, volatile.LoadUint32(&o.SCL.Reg)&^(0x20)|value<<5)
}
func (o *TWIM_PSEL_Type) GetSCL_PORT() uint32 {
	return (volatile.LoadUint32(&o.SCL.Reg) & 0x20) >> 5
}
func (o *TWIM_PSEL_Type) SetSCL_CONNECT(value uint32) {
	volatile.StoreUint32(&o.SCL.Reg, volatile.LoadUint32(&o.SCL.Reg)&^(0x80000000)|value<<31)
}
func (o *TWIM_PSEL_Type) GetSCL_CONNECT() uint32 {
	return (volatile.LoadUint32(&o.SCL.Reg) & 0x80000000) >> 31
}

// TWIM_PSEL.SDA: Pin select for SDA signal
func (o *TWIM_PSEL_Type) SetSDA_PIN(value uint32) {
	volatile.StoreUint32(&o.SDA.Reg, volatile.LoadUint32(&o.SDA.Reg)&^(0x1f)|value)
}
func (o *TWIM_PSEL_Type) GetSDA_PIN() uint32 {
	return volatile.LoadUint32(&o.SDA.Reg) & 0x1f
}
func (o *TWIM_PSEL_Type) SetSDA_PORT(value uint32) {
	volatile.StoreUint32(&o.SDA.Reg, volatile.LoadUint32(&o.SDA.Reg)&^(0x20)|value<<5)
}
func (o *TWIM_PSEL_Type) GetSDA_PORT() uint32 {
	return (volatile.LoadUint32(&o.SDA.Reg) & 0x20) >> 5
}
func (o *TWIM_PSEL_Type) SetSDA_CONNECT(value uint32) {
	volatile.StoreUint32(&o.SDA.Reg, volatile.LoadUint32(&o.SDA.Reg)&^(0x80000000)|value<<31)
}
func (o *TWIM_PSEL_Type) GetSDA_CONNECT() uint32 {
	return (volatile.LoadUint32(&o.SDA.Reg) & 0x80000000) >> 31
}

// RXD EasyDMA channel
type TWIM_RXD_Type struct {
	PTR    volatile.Register32 // 0x534
	MAXCNT volatile.Register32 // 0x538
	AMOUNT volatile.Register32 // 0x53C
	LIST   volatile.Register32 // 0x540
}

// TWIM_RXD.PTR: Data pointer
func (o *TWIM_RXD_Type) SetPTR(value uint32) {
	volatile.StoreUint32(&o.PTR.Reg, value)
}
func (o *TWIM_RXD_Type) GetPTR() uint32 {
	return volatile.LoadUint32(&o.PTR.Reg)
}

// TWIM_RXD.MAXCNT: Maximum number of bytes in receive buffer
func (o *TWIM_RXD_Type) SetMAXCNT(value uint32) {
	volatile.StoreUint32(&o.MAXCNT.Reg, volatile.LoadUint32(&o.MAXCNT.Reg)&^(0xffff)|value)
}
func (o *TWIM_RXD_Type) GetMAXCNT() uint32 {
	return volatile.LoadUint32(&o.MAXCNT.Reg) & 0xffff
}

// TWIM_RXD.AMOUNT: Number of bytes transferred in the last transaction
func (o *TWIM_RXD_Type) SetAMOUNT(value uint32) {
	volatile.StoreUint32(&o.AMOUNT.Reg, volatile.LoadUint32(&o.AMOUNT.Reg)&^(0xffff)|value)
}
func (o *TWIM_RXD_Type) GetAMOUNT() uint32 {
	return volatile.LoadUint32(&o.AMOUNT.Reg) & 0xffff
}

// TWIM_RXD.LIST: EasyDMA list type
func (o *TWIM_RXD_Type) SetLIST(value uint32) {
	volatile.StoreUint32(&o.LIST.Reg, volatile.LoadUint32(&o.LIST.Reg)&^(0x7)|value)
}
func (o *TWIM_RXD_Type) GetLIST() uint32 {
	return volatile.LoadUint32(&o.LIST.Reg) & 0x7
}

// TXD EasyDMA channel
type TWIM_TXD_Type struct {
	PTR    volatile.Register32 // 0x544
	MAXCNT volatile.Register32 // 0x548
	AMOUNT volatile.Register32 // 0x54C
	LIST   volatile.Register32 // 0x550
}

// TWIM_TXD.PTR: Data pointer
func (o *TWIM_TXD_Type) SetPTR(value uint32) {
	volatile.StoreUint32(&o.PTR.Reg, value)
}
func (o *TWIM_TXD_Type) GetPTR() uint32 {
	return volatile.LoadUint32(&o.PTR.Reg)
}

// TWIM_TXD.MAXCNT: Maximum number of bytes in transmit buffer
func (o *TWIM_TXD_Type) SetMAXCNT(value uint32) {
	volatile.StoreUint32(&o.MAXCNT.Reg, volatile.LoadUint32(&o.MAXCNT.Reg)&^(0xffff)|value)
}
func (o *TWIM_TXD_Type) GetMAXCNT() uint32 {
	return volatile.LoadUint32(&o.MAXCNT.Reg) & 0xffff
}

// TWIM_TXD.AMOUNT: Number of bytes transferred in the last transaction
func (o *TWIM_TXD_Type) SetAMOUNT(value uint32) {
	volatile.StoreUint32(&o.AMOUNT.Reg, volatile.LoadUint32(&o.AMOUNT.Reg)&^(0xffff)|value)
}
func (o *TWIM_TXD_Type) GetAMOUNT() uint32 {
	return volatile.LoadUint32(&o.AMOUNT.Reg) & 0xffff
}

// TWIM_TXD.LIST: EasyDMA list type
func (o *TWIM_TXD_Type) SetLIST(value uint32) {
	volatile.StoreUint32(&o.LIST.Reg, volatile.LoadUint32(&o.LIST.Reg)&^(0x7)|value)
}
func (o *TWIM_TXD_Type) GetLIST() uint32 {
	return volatile.LoadUint32(&o.LIST.Reg) & 0x7
}

// I2C compatible Two-Wire Slave Interface with EasyDMA
type TWIS_Type struct {
	_                   [20]byte
	TASKS_STOP          volatile.Register32 // 0x14
	_                   [4]byte
	TASKS_SUSPEND       volatile.Register32 // 0x1C
	TASKS_RESUME        volatile.Register32 // 0x20
	_                   [12]byte
	TASKS_PREPARERX     volatile.Register32 // 0x30
	TASKS_PREPARETX     volatile.Register32 // 0x34
	_                   [92]byte
	SUBSCRIBE_STOP      volatile.Register32 // 0x94
	_                   [4]byte
	SUBSCRIBE_SUSPEND   volatile.Register32 // 0x9C
	SUBSCRIBE_RESUME    volatile.Register32 // 0xA0
	_                   [12]byte
	SUBSCRIBE_PREPARERX volatile.Register32 // 0xB0
	SUBSCRIBE_PREPARETX volatile.Register32 // 0xB4
	_                   [76]byte
	EVENTS_STOPPED      volatile.Register32 // 0x104
	_                   [28]byte
	EVENTS_ERROR        volatile.Register32 // 0x124
	_                   [36]byte
	EVENTS_RXSTARTED    volatile.Register32 // 0x14C
	EVENTS_TXSTARTED    volatile.Register32 // 0x150
	_                   [16]byte
	EVENTS_WRITE        volatile.Register32 // 0x164
	EVENTS_READ         volatile.Register32 // 0x168
	_                   [24]byte
	PUBLISH_STOPPED     volatile.Register32 // 0x184
	_                   [28]byte
	PUBLISH_ERROR       volatile.Register32 // 0x1A4
	_                   [36]byte
	PUBLISH_RXSTARTED   volatile.Register32 // 0x1CC
	PUBLISH_TXSTARTED   volatile.Register32 // 0x1D0
	_                   [16]byte
	PUBLISH_WRITE       volatile.Register32 // 0x1E4
	PUBLISH_READ        volatile.Register32 // 0x1E8
	_                   [20]byte
	SHORTS              volatile.Register32 // 0x200
	_                   [252]byte
	INTEN               volatile.Register32 // 0x300
	INTENSET            volatile.Register32 // 0x304
	INTENCLR            volatile.Register32 // 0x308
	_                   [452]byte
	ERRORSRC            volatile.Register32 // 0x4D0
	MATCH               volatile.Register32 // 0x4D4
	_                   [40]byte
	ENABLE              volatile.Register32 // 0x500
	_                   [4]byte
	PSEL                TWIS_PSEL_Type // 0x508
	_                   [36]byte
	RXD                 TWIS_RXD_Type // 0x534
	TXD                 TWIS_TXD_Type // 0x544
	_                   [52]byte
	ADDRESS             [2]volatile.Register32 // 0x588
	_                   [4]byte
	CONFIG              volatile.Register32 // 0x594
	_                   [40]byte
	ORC                 volatile.Register32 // 0x5C0
}

// TWIS.TASKS_STOP: Stop TWI transaction
func (o *TWIS_Type) SetTASKS_STOP(value uint32) {
	volatile.StoreUint32(&o.TASKS_STOP.Reg, volatile.LoadUint32(&o.TASKS_STOP.Reg)&^(0x1)|value)
}
func (o *TWIS_Type) GetTASKS_STOP() uint32 {
	return volatile.LoadUint32(&o.TASKS_STOP.Reg) & 0x1
}

// TWIS.TASKS_SUSPEND: Suspend TWI transaction
func (o *TWIS_Type) SetTASKS_SUSPEND(value uint32) {
	volatile.StoreUint32(&o.TASKS_SUSPEND.Reg, volatile.LoadUint32(&o.TASKS_SUSPEND.Reg)&^(0x1)|value)
}
func (o *TWIS_Type) GetTASKS_SUSPEND() uint32 {
	return volatile.LoadUint32(&o.TASKS_SUSPEND.Reg) & 0x1
}

// TWIS.TASKS_RESUME: Resume TWI transaction
func (o *TWIS_Type) SetTASKS_RESUME(value uint32) {
	volatile.StoreUint32(&o.TASKS_RESUME.Reg, volatile.LoadUint32(&o.TASKS_RESUME.Reg)&^(0x1)|value)
}
func (o *TWIS_Type) GetTASKS_RESUME() uint32 {
	return volatile.LoadUint32(&o.TASKS_RESUME.Reg) & 0x1
}

// TWIS.TASKS_PREPARERX: Prepare the TWI slave to respond to a write command
func (o *TWIS_Type) SetTASKS_PREPARERX(value uint32) {
	volatile.StoreUint32(&o.TASKS_PREPARERX.Reg, volatile.LoadUint32(&o.TASKS_PREPARERX.Reg)&^(0x1)|value)
}
func (o *TWIS_Type) GetTASKS_PREPARERX() uint32 {
	return volatile.LoadUint32(&o.TASKS_PREPARERX.Reg) & 0x1
}

// TWIS.TASKS_PREPARETX: Prepare the TWI slave to respond to a read command
func (o *TWIS_Type) SetTASKS_PREPARETX(value uint32) {
	volatile.StoreUint32(&o.TASKS_PREPARETX.Reg, volatile.LoadUint32(&o.TASKS_PREPARETX.Reg)&^(0x1)|value)
}
func (o *TWIS_Type) GetTASKS_PREPARETX() uint32 {
	return volatile.LoadUint32(&o.TASKS_PREPARETX.Reg) & 0x1
}

// TWIS.SUBSCRIBE_STOP: Subscribe configuration for task STOP
func (o *TWIS_Type) SetSUBSCRIBE_STOP_CHIDX(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_STOP.Reg, volatile.LoadUint32(&o.SUBSCRIBE_STOP.Reg)&^(0xff)|value)
}
func (o *TWIS_Type) GetSUBSCRIBE_STOP_CHIDX() uint32 {
	return volatile.LoadUint32(&o.SUBSCRIBE_STOP.Reg) & 0xff
}
func (o *TWIS_Type) SetSUBSCRIBE_STOP_EN(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_STOP.Reg, volatile.LoadUint32(&o.SUBSCRIBE_STOP.Reg)&^(0x80000000)|value<<31)
}
func (o *TWIS_Type) GetSUBSCRIBE_STOP_EN() uint32 {
	return (volatile.LoadUint32(&o.SUBSCRIBE_STOP.Reg) & 0x80000000) >> 31
}

// TWIS.SUBSCRIBE_SUSPEND: Subscribe configuration for task SUSPEND
func (o *TWIS_Type) SetSUBSCRIBE_SUSPEND_CHIDX(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_SUSPEND.Reg, volatile.LoadUint32(&o.SUBSCRIBE_SUSPEND.Reg)&^(0xff)|value)
}
func (o *TWIS_Type) GetSUBSCRIBE_SUSPEND_CHIDX() uint32 {
	return volatile.LoadUint32(&o.SUBSCRIBE_SUSPEND.Reg) & 0xff
}
func (o *TWIS_Type) SetSUBSCRIBE_SUSPEND_EN(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_SUSPEND.Reg, volatile.LoadUint32(&o.SUBSCRIBE_SUSPEND.Reg)&^(0x80000000)|value<<31)
}
func (o *TWIS_Type) GetSUBSCRIBE_SUSPEND_EN() uint32 {
	return (volatile.LoadUint32(&o.SUBSCRIBE_SUSPEND.Reg) & 0x80000000) >> 31
}

// TWIS.SUBSCRIBE_RESUME: Subscribe configuration for task RESUME
func (o *TWIS_Type) SetSUBSCRIBE_RESUME_CHIDX(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_RESUME.Reg, volatile.LoadUint32(&o.SUBSCRIBE_RESUME.Reg)&^(0xff)|value)
}
func (o *TWIS_Type) GetSUBSCRIBE_RESUME_CHIDX() uint32 {
	return volatile.LoadUint32(&o.SUBSCRIBE_RESUME.Reg) & 0xff
}
func (o *TWIS_Type) SetSUBSCRIBE_RESUME_EN(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_RESUME.Reg, volatile.LoadUint32(&o.SUBSCRIBE_RESUME.Reg)&^(0x80000000)|value<<31)
}
func (o *TWIS_Type) GetSUBSCRIBE_RESUME_EN() uint32 {
	return (volatile.LoadUint32(&o.SUBSCRIBE_RESUME.Reg) & 0x80000000) >> 31
}

// TWIS.SUBSCRIBE_PREPARERX: Subscribe configuration for task PREPARERX
func (o *TWIS_Type) SetSUBSCRIBE_PREPARERX_CHIDX(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_PREPARERX.Reg, volatile.LoadUint32(&o.SUBSCRIBE_PREPARERX.Reg)&^(0xff)|value)
}
func (o *TWIS_Type) GetSUBSCRIBE_PREPARERX_CHIDX() uint32 {
	return volatile.LoadUint32(&o.SUBSCRIBE_PREPARERX.Reg) & 0xff
}
func (o *TWIS_Type) SetSUBSCRIBE_PREPARERX_EN(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_PREPARERX.Reg, volatile.LoadUint32(&o.SUBSCRIBE_PREPARERX.Reg)&^(0x80000000)|value<<31)
}
func (o *TWIS_Type) GetSUBSCRIBE_PREPARERX_EN() uint32 {
	return (volatile.LoadUint32(&o.SUBSCRIBE_PREPARERX.Reg) & 0x80000000) >> 31
}

// TWIS.SUBSCRIBE_PREPARETX: Subscribe configuration for task PREPARETX
func (o *TWIS_Type) SetSUBSCRIBE_PREPARETX_CHIDX(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_PREPARETX.Reg, volatile.LoadUint32(&o.SUBSCRIBE_PREPARETX.Reg)&^(0xff)|value)
}
func (o *TWIS_Type) GetSUBSCRIBE_PREPARETX_CHIDX() uint32 {
	return volatile.LoadUint32(&o.SUBSCRIBE_PREPARETX.Reg) & 0xff
}
func (o *TWIS_Type) SetSUBSCRIBE_PREPARETX_EN(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_PREPARETX.Reg, volatile.LoadUint32(&o.SUBSCRIBE_PREPARETX.Reg)&^(0x80000000)|value<<31)
}
func (o *TWIS_Type) GetSUBSCRIBE_PREPARETX_EN() uint32 {
	return (volatile.LoadUint32(&o.SUBSCRIBE_PREPARETX.Reg) & 0x80000000) >> 31
}

// TWIS.EVENTS_STOPPED: TWI stopped
func (o *TWIS_Type) SetEVENTS_STOPPED(value uint32) {
	volatile.StoreUint32(&o.EVENTS_STOPPED.Reg, volatile.LoadUint32(&o.EVENTS_STOPPED.Reg)&^(0x1)|value)
}
func (o *TWIS_Type) GetEVENTS_STOPPED() uint32 {
	return volatile.LoadUint32(&o.EVENTS_STOPPED.Reg) & 0x1
}

// TWIS.EVENTS_ERROR: TWI error
func (o *TWIS_Type) SetEVENTS_ERROR(value uint32) {
	volatile.StoreUint32(&o.EVENTS_ERROR.Reg, volatile.LoadUint32(&o.EVENTS_ERROR.Reg)&^(0x1)|value)
}
func (o *TWIS_Type) GetEVENTS_ERROR() uint32 {
	return volatile.LoadUint32(&o.EVENTS_ERROR.Reg) & 0x1
}

// TWIS.EVENTS_RXSTARTED: Receive sequence started
func (o *TWIS_Type) SetEVENTS_RXSTARTED(value uint32) {
	volatile.StoreUint32(&o.EVENTS_RXSTARTED.Reg, volatile.LoadUint32(&o.EVENTS_RXSTARTED.Reg)&^(0x1)|value)
}
func (o *TWIS_Type) GetEVENTS_RXSTARTED() uint32 {
	return volatile.LoadUint32(&o.EVENTS_RXSTARTED.Reg) & 0x1
}

// TWIS.EVENTS_TXSTARTED: Transmit sequence started
func (o *TWIS_Type) SetEVENTS_TXSTARTED(value uint32) {
	volatile.StoreUint32(&o.EVENTS_TXSTARTED.Reg, volatile.LoadUint32(&o.EVENTS_TXSTARTED.Reg)&^(0x1)|value)
}
func (o *TWIS_Type) GetEVENTS_TXSTARTED() uint32 {
	return volatile.LoadUint32(&o.EVENTS_TXSTARTED.Reg) & 0x1
}

// TWIS.EVENTS_WRITE: Write command received
func (o *TWIS_Type) SetEVENTS_WRITE(value uint32) {
	volatile.StoreUint32(&o.EVENTS_WRITE.Reg, volatile.LoadUint32(&o.EVENTS_WRITE.Reg)&^(0x1)|value)
}
func (o *TWIS_Type) GetEVENTS_WRITE() uint32 {
	return volatile.LoadUint32(&o.EVENTS_WRITE.Reg) & 0x1
}

// TWIS.EVENTS_READ: Read command received
func (o *TWIS_Type) SetEVENTS_READ(value uint32) {
	volatile.StoreUint32(&o.EVENTS_READ.Reg, volatile.LoadUint32(&o.EVENTS_READ.Reg)&^(0x1)|value)
}
func (o *TWIS_Type) GetEVENTS_READ() uint32 {
	return volatile.LoadUint32(&o.EVENTS_READ.Reg) & 0x1
}

// TWIS.PUBLISH_STOPPED: Publish configuration for event STOPPED
func (o *TWIS_Type) SetPUBLISH_STOPPED_CHIDX(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_STOPPED.Reg, volatile.LoadUint32(&o.PUBLISH_STOPPED.Reg)&^(0xff)|value)
}
func (o *TWIS_Type) GetPUBLISH_STOPPED_CHIDX() uint32 {
	return volatile.LoadUint32(&o.PUBLISH_STOPPED.Reg) & 0xff
}
func (o *TWIS_Type) SetPUBLISH_STOPPED_EN(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_STOPPED.Reg, volatile.LoadUint32(&o.PUBLISH_STOPPED.Reg)&^(0x80000000)|value<<31)
}
func (o *TWIS_Type) GetPUBLISH_STOPPED_EN() uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_STOPPED.Reg) & 0x80000000) >> 31
}

// TWIS.PUBLISH_ERROR: Publish configuration for event ERROR
func (o *TWIS_Type) SetPUBLISH_ERROR_CHIDX(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_ERROR.Reg, volatile.LoadUint32(&o.PUBLISH_ERROR.Reg)&^(0xff)|value)
}
func (o *TWIS_Type) GetPUBLISH_ERROR_CHIDX() uint32 {
	return volatile.LoadUint32(&o.PUBLISH_ERROR.Reg) & 0xff
}
func (o *TWIS_Type) SetPUBLISH_ERROR_EN(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_ERROR.Reg, volatile.LoadUint32(&o.PUBLISH_ERROR.Reg)&^(0x80000000)|value<<31)
}
func (o *TWIS_Type) GetPUBLISH_ERROR_EN() uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_ERROR.Reg) & 0x80000000) >> 31
}

// TWIS.PUBLISH_RXSTARTED: Publish configuration for event RXSTARTED
func (o *TWIS_Type) SetPUBLISH_RXSTARTED_CHIDX(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_RXSTARTED.Reg, volatile.LoadUint32(&o.PUBLISH_RXSTARTED.Reg)&^(0xff)|value)
}
func (o *TWIS_Type) GetPUBLISH_RXSTARTED_CHIDX() uint32 {
	return volatile.LoadUint32(&o.PUBLISH_RXSTARTED.Reg) & 0xff
}
func (o *TWIS_Type) SetPUBLISH_RXSTARTED_EN(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_RXSTARTED.Reg, volatile.LoadUint32(&o.PUBLISH_RXSTARTED.Reg)&^(0x80000000)|value<<31)
}
func (o *TWIS_Type) GetPUBLISH_RXSTARTED_EN() uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_RXSTARTED.Reg) & 0x80000000) >> 31
}

// TWIS.PUBLISH_TXSTARTED: Publish configuration for event TXSTARTED
func (o *TWIS_Type) SetPUBLISH_TXSTARTED_CHIDX(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_TXSTARTED.Reg, volatile.LoadUint32(&o.PUBLISH_TXSTARTED.Reg)&^(0xff)|value)
}
func (o *TWIS_Type) GetPUBLISH_TXSTARTED_CHIDX() uint32 {
	return volatile.LoadUint32(&o.PUBLISH_TXSTARTED.Reg) & 0xff
}
func (o *TWIS_Type) SetPUBLISH_TXSTARTED_EN(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_TXSTARTED.Reg, volatile.LoadUint32(&o.PUBLISH_TXSTARTED.Reg)&^(0x80000000)|value<<31)
}
func (o *TWIS_Type) GetPUBLISH_TXSTARTED_EN() uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_TXSTARTED.Reg) & 0x80000000) >> 31
}

// TWIS.PUBLISH_WRITE: Publish configuration for event WRITE
func (o *TWIS_Type) SetPUBLISH_WRITE_CHIDX(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_WRITE.Reg, volatile.LoadUint32(&o.PUBLISH_WRITE.Reg)&^(0xff)|value)
}
func (o *TWIS_Type) GetPUBLISH_WRITE_CHIDX() uint32 {
	return volatile.LoadUint32(&o.PUBLISH_WRITE.Reg) & 0xff
}
func (o *TWIS_Type) SetPUBLISH_WRITE_EN(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_WRITE.Reg, volatile.LoadUint32(&o.PUBLISH_WRITE.Reg)&^(0x80000000)|value<<31)
}
func (o *TWIS_Type) GetPUBLISH_WRITE_EN() uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_WRITE.Reg) & 0x80000000) >> 31
}

// TWIS.PUBLISH_READ: Publish configuration for event READ
func (o *TWIS_Type) SetPUBLISH_READ_CHIDX(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_READ.Reg, volatile.LoadUint32(&o.PUBLISH_READ.Reg)&^(0xff)|value)
}
func (o *TWIS_Type) GetPUBLISH_READ_CHIDX() uint32 {
	return volatile.LoadUint32(&o.PUBLISH_READ.Reg) & 0xff
}
func (o *TWIS_Type) SetPUBLISH_READ_EN(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_READ.Reg, volatile.LoadUint32(&o.PUBLISH_READ.Reg)&^(0x80000000)|value<<31)
}
func (o *TWIS_Type) GetPUBLISH_READ_EN() uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_READ.Reg) & 0x80000000) >> 31
}

// TWIS.SHORTS: Shortcuts between local events and tasks
func (o *TWIS_Type) SetSHORTS_WRITE_SUSPEND(value uint32) {
	volatile.StoreUint32(&o.SHORTS.Reg, volatile.LoadUint32(&o.SHORTS.Reg)&^(0x2000)|value<<13)
}
func (o *TWIS_Type) GetSHORTS_WRITE_SUSPEND() uint32 {
	return (volatile.LoadUint32(&o.SHORTS.Reg) & 0x2000) >> 13
}
func (o *TWIS_Type) SetSHORTS_READ_SUSPEND(value uint32) {
	volatile.StoreUint32(&o.SHORTS.Reg, volatile.LoadUint32(&o.SHORTS.Reg)&^(0x4000)|value<<14)
}
func (o *TWIS_Type) GetSHORTS_READ_SUSPEND() uint32 {
	return (volatile.LoadUint32(&o.SHORTS.Reg) & 0x4000) >> 14
}

// TWIS.INTEN: Enable or disable interrupt
func (o *TWIS_Type) SetINTEN_STOPPED(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x2)|value<<1)
}
func (o *TWIS_Type) GetINTEN_STOPPED() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x2) >> 1
}
func (o *TWIS_Type) SetINTEN_ERROR(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x200)|value<<9)
}
func (o *TWIS_Type) GetINTEN_ERROR() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x200) >> 9
}
func (o *TWIS_Type) SetINTEN_RXSTARTED(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x80000)|value<<19)
}
func (o *TWIS_Type) GetINTEN_RXSTARTED() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x80000) >> 19
}
func (o *TWIS_Type) SetINTEN_TXSTARTED(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x100000)|value<<20)
}
func (o *TWIS_Type) GetINTEN_TXSTARTED() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x100000) >> 20
}
func (o *TWIS_Type) SetINTEN_WRITE(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x2000000)|value<<25)
}
func (o *TWIS_Type) GetINTEN_WRITE() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x2000000) >> 25
}
func (o *TWIS_Type) SetINTEN_READ(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x4000000)|value<<26)
}
func (o *TWIS_Type) GetINTEN_READ() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x4000000) >> 26
}

// TWIS.INTENSET: Enable interrupt
func (o *TWIS_Type) SetINTENSET_STOPPED(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x2)|value<<1)
}
func (o *TWIS_Type) GetINTENSET_STOPPED() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x2) >> 1
}
func (o *TWIS_Type) SetINTENSET_ERROR(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x200)|value<<9)
}
func (o *TWIS_Type) GetINTENSET_ERROR() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x200) >> 9
}
func (o *TWIS_Type) SetINTENSET_RXSTARTED(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x80000)|value<<19)
}
func (o *TWIS_Type) GetINTENSET_RXSTARTED() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x80000) >> 19
}
func (o *TWIS_Type) SetINTENSET_TXSTARTED(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x100000)|value<<20)
}
func (o *TWIS_Type) GetINTENSET_TXSTARTED() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x100000) >> 20
}
func (o *TWIS_Type) SetINTENSET_WRITE(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x2000000)|value<<25)
}
func (o *TWIS_Type) GetINTENSET_WRITE() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x2000000) >> 25
}
func (o *TWIS_Type) SetINTENSET_READ(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x4000000)|value<<26)
}
func (o *TWIS_Type) GetINTENSET_READ() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x4000000) >> 26
}

// TWIS.INTENCLR: Disable interrupt
func (o *TWIS_Type) SetINTENCLR_STOPPED(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x2)|value<<1)
}
func (o *TWIS_Type) GetINTENCLR_STOPPED() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x2) >> 1
}
func (o *TWIS_Type) SetINTENCLR_ERROR(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x200)|value<<9)
}
func (o *TWIS_Type) GetINTENCLR_ERROR() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x200) >> 9
}
func (o *TWIS_Type) SetINTENCLR_RXSTARTED(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x80000)|value<<19)
}
func (o *TWIS_Type) GetINTENCLR_RXSTARTED() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x80000) >> 19
}
func (o *TWIS_Type) SetINTENCLR_TXSTARTED(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x100000)|value<<20)
}
func (o *TWIS_Type) GetINTENCLR_TXSTARTED() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x100000) >> 20
}
func (o *TWIS_Type) SetINTENCLR_WRITE(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x2000000)|value<<25)
}
func (o *TWIS_Type) GetINTENCLR_WRITE() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x2000000) >> 25
}
func (o *TWIS_Type) SetINTENCLR_READ(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x4000000)|value<<26)
}
func (o *TWIS_Type) GetINTENCLR_READ() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x4000000) >> 26
}

// TWIS.ERRORSRC: Error source
func (o *TWIS_Type) SetERRORSRC_OVERFLOW(value uint32) {
	volatile.StoreUint32(&o.ERRORSRC.Reg, volatile.LoadUint32(&o.ERRORSRC.Reg)&^(0x1)|value)
}
func (o *TWIS_Type) GetERRORSRC_OVERFLOW() uint32 {
	return volatile.LoadUint32(&o.ERRORSRC.Reg) & 0x1
}
func (o *TWIS_Type) SetERRORSRC_DNACK(value uint32) {
	volatile.StoreUint32(&o.ERRORSRC.Reg, volatile.LoadUint32(&o.ERRORSRC.Reg)&^(0x4)|value<<2)
}
func (o *TWIS_Type) GetERRORSRC_DNACK() uint32 {
	return (volatile.LoadUint32(&o.ERRORSRC.Reg) & 0x4) >> 2
}
func (o *TWIS_Type) SetERRORSRC_OVERREAD(value uint32) {
	volatile.StoreUint32(&o.ERRORSRC.Reg, volatile.LoadUint32(&o.ERRORSRC.Reg)&^(0x8)|value<<3)
}
func (o *TWIS_Type) GetERRORSRC_OVERREAD() uint32 {
	return (volatile.LoadUint32(&o.ERRORSRC.Reg) & 0x8) >> 3
}

// TWIS.MATCH: Status register indicating which address had a match
func (o *TWIS_Type) SetMATCH(value uint32) {
	volatile.StoreUint32(&o.MATCH.Reg, volatile.LoadUint32(&o.MATCH.Reg)&^(0x1)|value)
}
func (o *TWIS_Type) GetMATCH() uint32 {
	return volatile.LoadUint32(&o.MATCH.Reg) & 0x1
}

// TWIS.ENABLE: Enable TWIS
func (o *TWIS_Type) SetENABLE(value uint32) {
	volatile.StoreUint32(&o.ENABLE.Reg, volatile.LoadUint32(&o.ENABLE.Reg)&^(0xf)|value)
}
func (o *TWIS_Type) GetENABLE() uint32 {
	return volatile.LoadUint32(&o.ENABLE.Reg) & 0xf
}

// TWIS.ADDRESS: Description collection: TWI slave address n
func (o *TWIS_Type) SetADDRESS(idx int, value uint32) {
	volatile.StoreUint32(&o.ADDRESS[idx].Reg, volatile.LoadUint32(&o.ADDRESS[idx].Reg)&^(0x7f)|value)
}
func (o *TWIS_Type) GetADDRESS(idx int) uint32 {
	return volatile.LoadUint32(&o.ADDRESS[idx].Reg) & 0x7f
}

// TWIS.CONFIG: Configuration register for the address match mechanism
func (o *TWIS_Type) SetCONFIG_ADDRESS0(value uint32) {
	volatile.StoreUint32(&o.CONFIG.Reg, volatile.LoadUint32(&o.CONFIG.Reg)&^(0x1)|value)
}
func (o *TWIS_Type) GetCONFIG_ADDRESS0() uint32 {
	return volatile.LoadUint32(&o.CONFIG.Reg) & 0x1
}
func (o *TWIS_Type) SetCONFIG_ADDRESS1(value uint32) {
	volatile.StoreUint32(&o.CONFIG.Reg, volatile.LoadUint32(&o.CONFIG.Reg)&^(0x2)|value<<1)
}
func (o *TWIS_Type) GetCONFIG_ADDRESS1() uint32 {
	return (volatile.LoadUint32(&o.CONFIG.Reg) & 0x2) >> 1
}

// TWIS.ORC: Over-read character. Character sent out in case of an over-read of the transmit buffer.
func (o *TWIS_Type) SetORC(value uint32) {
	volatile.StoreUint32(&o.ORC.Reg, volatile.LoadUint32(&o.ORC.Reg)&^(0xff)|value)
}
func (o *TWIS_Type) GetORC() uint32 {
	return volatile.LoadUint32(&o.ORC.Reg) & 0xff
}

// Unspecified
type TWIS_PSEL_Type struct {
	SCL volatile.Register32 // 0x508
	SDA volatile.Register32 // 0x50C
}

// TWIS_PSEL.SCL: Pin select for SCL signal
func (o *TWIS_PSEL_Type) SetSCL_PIN(value uint32) {
	volatile.StoreUint32(&o.SCL.Reg, volatile.LoadUint32(&o.SCL.Reg)&^(0x1f)|value)
}
func (o *TWIS_PSEL_Type) GetSCL_PIN() uint32 {
	return volatile.LoadUint32(&o.SCL.Reg) & 0x1f
}
func (o *TWIS_PSEL_Type) SetSCL_PORT(value uint32) {
	volatile.StoreUint32(&o.SCL.Reg, volatile.LoadUint32(&o.SCL.Reg)&^(0x20)|value<<5)
}
func (o *TWIS_PSEL_Type) GetSCL_PORT() uint32 {
	return (volatile.LoadUint32(&o.SCL.Reg) & 0x20) >> 5
}
func (o *TWIS_PSEL_Type) SetSCL_CONNECT(value uint32) {
	volatile.StoreUint32(&o.SCL.Reg, volatile.LoadUint32(&o.SCL.Reg)&^(0x80000000)|value<<31)
}
func (o *TWIS_PSEL_Type) GetSCL_CONNECT() uint32 {
	return (volatile.LoadUint32(&o.SCL.Reg) & 0x80000000) >> 31
}

// TWIS_PSEL.SDA: Pin select for SDA signal
func (o *TWIS_PSEL_Type) SetSDA_PIN(value uint32) {
	volatile.StoreUint32(&o.SDA.Reg, volatile.LoadUint32(&o.SDA.Reg)&^(0x1f)|value)
}
func (o *TWIS_PSEL_Type) GetSDA_PIN() uint32 {
	return volatile.LoadUint32(&o.SDA.Reg) & 0x1f
}
func (o *TWIS_PSEL_Type) SetSDA_PORT(value uint32) {
	volatile.StoreUint32(&o.SDA.Reg, volatile.LoadUint32(&o.SDA.Reg)&^(0x20)|value<<5)
}
func (o *TWIS_PSEL_Type) GetSDA_PORT() uint32 {
	return (volatile.LoadUint32(&o.SDA.Reg) & 0x20) >> 5
}
func (o *TWIS_PSEL_Type) SetSDA_CONNECT(value uint32) {
	volatile.StoreUint32(&o.SDA.Reg, volatile.LoadUint32(&o.SDA.Reg)&^(0x80000000)|value<<31)
}
func (o *TWIS_PSEL_Type) GetSDA_CONNECT() uint32 {
	return (volatile.LoadUint32(&o.SDA.Reg) & 0x80000000) >> 31
}

// RXD EasyDMA channel
type TWIS_RXD_Type struct {
	PTR    volatile.Register32 // 0x534
	MAXCNT volatile.Register32 // 0x538
	AMOUNT volatile.Register32 // 0x53C
	LIST   volatile.Register32 // 0x540
}

// TWIS_RXD.PTR: RXD Data pointer
func (o *TWIS_RXD_Type) SetPTR(value uint32) {
	volatile.StoreUint32(&o.PTR.Reg, value)
}
func (o *TWIS_RXD_Type) GetPTR() uint32 {
	return volatile.LoadUint32(&o.PTR.Reg)
}

// TWIS_RXD.MAXCNT: Maximum number of bytes in RXD buffer
func (o *TWIS_RXD_Type) SetMAXCNT(value uint32) {
	volatile.StoreUint32(&o.MAXCNT.Reg, volatile.LoadUint32(&o.MAXCNT.Reg)&^(0xffff)|value)
}
func (o *TWIS_RXD_Type) GetMAXCNT() uint32 {
	return volatile.LoadUint32(&o.MAXCNT.Reg) & 0xffff
}

// TWIS_RXD.AMOUNT: Number of bytes transferred in the last RXD transaction
func (o *TWIS_RXD_Type) SetAMOUNT(value uint32) {
	volatile.StoreUint32(&o.AMOUNT.Reg, volatile.LoadUint32(&o.AMOUNT.Reg)&^(0xffff)|value)
}
func (o *TWIS_RXD_Type) GetAMOUNT() uint32 {
	return volatile.LoadUint32(&o.AMOUNT.Reg) & 0xffff
}

// TWIS_RXD.LIST: EasyDMA list type
func (o *TWIS_RXD_Type) SetLIST(value uint32) {
	volatile.StoreUint32(&o.LIST.Reg, volatile.LoadUint32(&o.LIST.Reg)&^(0x3)|value)
}
func (o *TWIS_RXD_Type) GetLIST() uint32 {
	return volatile.LoadUint32(&o.LIST.Reg) & 0x3
}

// TXD EasyDMA channel
type TWIS_TXD_Type struct {
	PTR    volatile.Register32 // 0x544
	MAXCNT volatile.Register32 // 0x548
	AMOUNT volatile.Register32 // 0x54C
	LIST   volatile.Register32 // 0x550
}

// TWIS_TXD.PTR: TXD Data pointer
func (o *TWIS_TXD_Type) SetPTR(value uint32) {
	volatile.StoreUint32(&o.PTR.Reg, value)
}
func (o *TWIS_TXD_Type) GetPTR() uint32 {
	return volatile.LoadUint32(&o.PTR.Reg)
}

// TWIS_TXD.MAXCNT: Maximum number of bytes in TXD buffer
func (o *TWIS_TXD_Type) SetMAXCNT(value uint32) {
	volatile.StoreUint32(&o.MAXCNT.Reg, volatile.LoadUint32(&o.MAXCNT.Reg)&^(0xffff)|value)
}
func (o *TWIS_TXD_Type) GetMAXCNT() uint32 {
	return volatile.LoadUint32(&o.MAXCNT.Reg) & 0xffff
}

// TWIS_TXD.AMOUNT: Number of bytes transferred in the last TXD transaction
func (o *TWIS_TXD_Type) SetAMOUNT(value uint32) {
	volatile.StoreUint32(&o.AMOUNT.Reg, volatile.LoadUint32(&o.AMOUNT.Reg)&^(0xffff)|value)
}
func (o *TWIS_TXD_Type) GetAMOUNT() uint32 {
	return volatile.LoadUint32(&o.AMOUNT.Reg) & 0xffff
}

// TWIS_TXD.LIST: EasyDMA list type
func (o *TWIS_TXD_Type) SetLIST(value uint32) {
	volatile.StoreUint32(&o.LIST.Reg, volatile.LoadUint32(&o.LIST.Reg)&^(0x3)|value)
}
func (o *TWIS_TXD_Type) GetLIST() uint32 {
	return volatile.LoadUint32(&o.LIST.Reg) & 0x3
}

// UART with EasyDMA
type UARTE_Type struct {
	TASKS_STARTRX     volatile.Register32 // 0x0
	TASKS_STOPRX      volatile.Register32 // 0x4
	TASKS_STARTTX     volatile.Register32 // 0x8
	TASKS_STOPTX      volatile.Register32 // 0xC
	_                 [28]byte
	TASKS_FLUSHRX     volatile.Register32 // 0x2C
	_                 [80]byte
	SUBSCRIBE_STARTRX volatile.Register32 // 0x80
	SUBSCRIBE_STOPRX  volatile.Register32 // 0x84
	SUBSCRIBE_STARTTX volatile.Register32 // 0x88
	SUBSCRIBE_STOPTX  volatile.Register32 // 0x8C
	_                 [28]byte
	SUBSCRIBE_FLUSHRX volatile.Register32 // 0xAC
	_                 [80]byte
	EVENTS_CTS        volatile.Register32 // 0x100
	EVENTS_NCTS       volatile.Register32 // 0x104
	EVENTS_RXDRDY     volatile.Register32 // 0x108
	_                 [4]byte
	EVENTS_ENDRX      volatile.Register32 // 0x110
	_                 [8]byte
	EVENTS_TXDRDY     volatile.Register32 // 0x11C
	EVENTS_ENDTX      volatile.Register32 // 0x120
	EVENTS_ERROR      volatile.Register32 // 0x124
	_                 [28]byte
	EVENTS_RXTO       volatile.Register32 // 0x144
	_                 [4]byte
	EVENTS_RXSTARTED  volatile.Register32 // 0x14C
	EVENTS_TXSTARTED  volatile.Register32 // 0x150
	_                 [4]byte
	EVENTS_TXSTOPPED  volatile.Register32 // 0x158
	_                 [36]byte
	PUBLISH_CTS       volatile.Register32 // 0x180
	PUBLISH_NCTS      volatile.Register32 // 0x184
	PUBLISH_RXDRDY    volatile.Register32 // 0x188
	_                 [4]byte
	PUBLISH_ENDRX     volatile.Register32 // 0x190
	_                 [8]byte
	PUBLISH_TXDRDY    volatile.Register32 // 0x19C
	PUBLISH_ENDTX     volatile.Register32 // 0x1A0
	PUBLISH_ERROR     volatile.Register32 // 0x1A4
	_                 [28]byte
	PUBLISH_RXTO      volatile.Register32 // 0x1C4
	_                 [4]byte
	PUBLISH_RXSTARTED volatile.Register32 // 0x1CC
	PUBLISH_TXSTARTED volatile.Register32 // 0x1D0
	_                 [4]byte
	PUBLISH_TXSTOPPED volatile.Register32 // 0x1D8
	_                 [36]byte
	SHORTS            volatile.Register32 // 0x200
	_                 [252]byte
	INTEN             volatile.Register32 // 0x300
	INTENSET          volatile.Register32 // 0x304
	INTENCLR          volatile.Register32 // 0x308
	_                 [372]byte
	ERRORSRC          volatile.Register32 // 0x480
	_                 [124]byte
	ENABLE            volatile.Register32 // 0x500
	_                 [4]byte
	PSEL              UARTE_PSEL_Type // 0x508
	_                 [12]byte
	BAUDRATE          volatile.Register32 // 0x524
	_                 [12]byte
	RXD               UARTE_RXD_Type // 0x534
	_                 [4]byte
	TXD               UARTE_TXD_Type // 0x544
	_                 [28]byte
	CONFIG            volatile.Register32 // 0x56C
}

// UARTE.TASKS_STARTRX: Start UART receiver
func (o *UARTE_Type) SetTASKS_STARTRX(value uint32) {
	volatile.StoreUint32(&o.TASKS_STARTRX.Reg, volatile.LoadUint32(&o.TASKS_STARTRX.Reg)&^(0x1)|value)
}
func (o *UARTE_Type) GetTASKS_STARTRX() uint32 {
	return volatile.LoadUint32(&o.TASKS_STARTRX.Reg) & 0x1
}

// UARTE.TASKS_STOPRX: Stop UART receiver
func (o *UARTE_Type) SetTASKS_STOPRX(value uint32) {
	volatile.StoreUint32(&o.TASKS_STOPRX.Reg, volatile.LoadUint32(&o.TASKS_STOPRX.Reg)&^(0x1)|value)
}
func (o *UARTE_Type) GetTASKS_STOPRX() uint32 {
	return volatile.LoadUint32(&o.TASKS_STOPRX.Reg) & 0x1
}

// UARTE.TASKS_STARTTX: Start UART transmitter
func (o *UARTE_Type) SetTASKS_STARTTX(value uint32) {
	volatile.StoreUint32(&o.TASKS_STARTTX.Reg, volatile.LoadUint32(&o.TASKS_STARTTX.Reg)&^(0x1)|value)
}
func (o *UARTE_Type) GetTASKS_STARTTX() uint32 {
	return volatile.LoadUint32(&o.TASKS_STARTTX.Reg) & 0x1
}

// UARTE.TASKS_STOPTX: Stop UART transmitter
func (o *UARTE_Type) SetTASKS_STOPTX(value uint32) {
	volatile.StoreUint32(&o.TASKS_STOPTX.Reg, volatile.LoadUint32(&o.TASKS_STOPTX.Reg)&^(0x1)|value)
}
func (o *UARTE_Type) GetTASKS_STOPTX() uint32 {
	return volatile.LoadUint32(&o.TASKS_STOPTX.Reg) & 0x1
}

// UARTE.TASKS_FLUSHRX: Flush RX FIFO into RX buffer
func (o *UARTE_Type) SetTASKS_FLUSHRX(value uint32) {
	volatile.StoreUint32(&o.TASKS_FLUSHRX.Reg, volatile.LoadUint32(&o.TASKS_FLUSHRX.Reg)&^(0x1)|value)
}
func (o *UARTE_Type) GetTASKS_FLUSHRX() uint32 {
	return volatile.LoadUint32(&o.TASKS_FLUSHRX.Reg) & 0x1
}

// UARTE.SUBSCRIBE_STARTRX: Subscribe configuration for task STARTRX
func (o *UARTE_Type) SetSUBSCRIBE_STARTRX_CHIDX(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_STARTRX.Reg, volatile.LoadUint32(&o.SUBSCRIBE_STARTRX.Reg)&^(0xff)|value)
}
func (o *UARTE_Type) GetSUBSCRIBE_STARTRX_CHIDX() uint32 {
	return volatile.LoadUint32(&o.SUBSCRIBE_STARTRX.Reg) & 0xff
}
func (o *UARTE_Type) SetSUBSCRIBE_STARTRX_EN(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_STARTRX.Reg, volatile.LoadUint32(&o.SUBSCRIBE_STARTRX.Reg)&^(0x80000000)|value<<31)
}
func (o *UARTE_Type) GetSUBSCRIBE_STARTRX_EN() uint32 {
	return (volatile.LoadUint32(&o.SUBSCRIBE_STARTRX.Reg) & 0x80000000) >> 31
}

// UARTE.SUBSCRIBE_STOPRX: Subscribe configuration for task STOPRX
func (o *UARTE_Type) SetSUBSCRIBE_STOPRX_CHIDX(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_STOPRX.Reg, volatile.LoadUint32(&o.SUBSCRIBE_STOPRX.Reg)&^(0xff)|value)
}
func (o *UARTE_Type) GetSUBSCRIBE_STOPRX_CHIDX() uint32 {
	return volatile.LoadUint32(&o.SUBSCRIBE_STOPRX.Reg) & 0xff
}
func (o *UARTE_Type) SetSUBSCRIBE_STOPRX_EN(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_STOPRX.Reg, volatile.LoadUint32(&o.SUBSCRIBE_STOPRX.Reg)&^(0x80000000)|value<<31)
}
func (o *UARTE_Type) GetSUBSCRIBE_STOPRX_EN() uint32 {
	return (volatile.LoadUint32(&o.SUBSCRIBE_STOPRX.Reg) & 0x80000000) >> 31
}

// UARTE.SUBSCRIBE_STARTTX: Subscribe configuration for task STARTTX
func (o *UARTE_Type) SetSUBSCRIBE_STARTTX_CHIDX(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_STARTTX.Reg, volatile.LoadUint32(&o.SUBSCRIBE_STARTTX.Reg)&^(0xff)|value)
}
func (o *UARTE_Type) GetSUBSCRIBE_STARTTX_CHIDX() uint32 {
	return volatile.LoadUint32(&o.SUBSCRIBE_STARTTX.Reg) & 0xff
}
func (o *UARTE_Type) SetSUBSCRIBE_STARTTX_EN(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_STARTTX.Reg, volatile.LoadUint32(&o.SUBSCRIBE_STARTTX.Reg)&^(0x80000000)|value<<31)
}
func (o *UARTE_Type) GetSUBSCRIBE_STARTTX_EN() uint32 {
	return (volatile.LoadUint32(&o.SUBSCRIBE_STARTTX.Reg) & 0x80000000) >> 31
}

// UARTE.SUBSCRIBE_STOPTX: Subscribe configuration for task STOPTX
func (o *UARTE_Type) SetSUBSCRIBE_STOPTX_CHIDX(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_STOPTX.Reg, volatile.LoadUint32(&o.SUBSCRIBE_STOPTX.Reg)&^(0xff)|value)
}
func (o *UARTE_Type) GetSUBSCRIBE_STOPTX_CHIDX() uint32 {
	return volatile.LoadUint32(&o.SUBSCRIBE_STOPTX.Reg) & 0xff
}
func (o *UARTE_Type) SetSUBSCRIBE_STOPTX_EN(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_STOPTX.Reg, volatile.LoadUint32(&o.SUBSCRIBE_STOPTX.Reg)&^(0x80000000)|value<<31)
}
func (o *UARTE_Type) GetSUBSCRIBE_STOPTX_EN() uint32 {
	return (volatile.LoadUint32(&o.SUBSCRIBE_STOPTX.Reg) & 0x80000000) >> 31
}

// UARTE.SUBSCRIBE_FLUSHRX: Subscribe configuration for task FLUSHRX
func (o *UARTE_Type) SetSUBSCRIBE_FLUSHRX_CHIDX(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_FLUSHRX.Reg, volatile.LoadUint32(&o.SUBSCRIBE_FLUSHRX.Reg)&^(0xff)|value)
}
func (o *UARTE_Type) GetSUBSCRIBE_FLUSHRX_CHIDX() uint32 {
	return volatile.LoadUint32(&o.SUBSCRIBE_FLUSHRX.Reg) & 0xff
}
func (o *UARTE_Type) SetSUBSCRIBE_FLUSHRX_EN(value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_FLUSHRX.Reg, volatile.LoadUint32(&o.SUBSCRIBE_FLUSHRX.Reg)&^(0x80000000)|value<<31)
}
func (o *UARTE_Type) GetSUBSCRIBE_FLUSHRX_EN() uint32 {
	return (volatile.LoadUint32(&o.SUBSCRIBE_FLUSHRX.Reg) & 0x80000000) >> 31
}

// UARTE.EVENTS_CTS: CTS is activated (set low). Clear To Send.
func (o *UARTE_Type) SetEVENTS_CTS(value uint32) {
	volatile.StoreUint32(&o.EVENTS_CTS.Reg, volatile.LoadUint32(&o.EVENTS_CTS.Reg)&^(0x1)|value)
}
func (o *UARTE_Type) GetEVENTS_CTS() uint32 {
	return volatile.LoadUint32(&o.EVENTS_CTS.Reg) & 0x1
}

// UARTE.EVENTS_NCTS: CTS is deactivated (set high). Not Clear To Send.
func (o *UARTE_Type) SetEVENTS_NCTS(value uint32) {
	volatile.StoreUint32(&o.EVENTS_NCTS.Reg, volatile.LoadUint32(&o.EVENTS_NCTS.Reg)&^(0x1)|value)
}
func (o *UARTE_Type) GetEVENTS_NCTS() uint32 {
	return volatile.LoadUint32(&o.EVENTS_NCTS.Reg) & 0x1
}

// UARTE.EVENTS_RXDRDY: Data received in RXD (but potentially not yet transferred to Data RAM)
func (o *UARTE_Type) SetEVENTS_RXDRDY(value uint32) {
	volatile.StoreUint32(&o.EVENTS_RXDRDY.Reg, volatile.LoadUint32(&o.EVENTS_RXDRDY.Reg)&^(0x1)|value)
}
func (o *UARTE_Type) GetEVENTS_RXDRDY() uint32 {
	return volatile.LoadUint32(&o.EVENTS_RXDRDY.Reg) & 0x1
}

// UARTE.EVENTS_ENDRX: Receive buffer is filled up
func (o *UARTE_Type) SetEVENTS_ENDRX(value uint32) {
	volatile.StoreUint32(&o.EVENTS_ENDRX.Reg, volatile.LoadUint32(&o.EVENTS_ENDRX.Reg)&^(0x1)|value)
}
func (o *UARTE_Type) GetEVENTS_ENDRX() uint32 {
	return volatile.LoadUint32(&o.EVENTS_ENDRX.Reg) & 0x1
}

// UARTE.EVENTS_TXDRDY: Data sent from TXD
func (o *UARTE_Type) SetEVENTS_TXDRDY(value uint32) {
	volatile.StoreUint32(&o.EVENTS_TXDRDY.Reg, volatile.LoadUint32(&o.EVENTS_TXDRDY.Reg)&^(0x1)|value)
}
func (o *UARTE_Type) GetEVENTS_TXDRDY() uint32 {
	return volatile.LoadUint32(&o.EVENTS_TXDRDY.Reg) & 0x1
}

// UARTE.EVENTS_ENDTX: Last TX byte transmitted
func (o *UARTE_Type) SetEVENTS_ENDTX(value uint32) {
	volatile.StoreUint32(&o.EVENTS_ENDTX.Reg, volatile.LoadUint32(&o.EVENTS_ENDTX.Reg)&^(0x1)|value)
}
func (o *UARTE_Type) GetEVENTS_ENDTX() uint32 {
	return volatile.LoadUint32(&o.EVENTS_ENDTX.Reg) & 0x1
}

// UARTE.EVENTS_ERROR: Error detected
func (o *UARTE_Type) SetEVENTS_ERROR(value uint32) {
	volatile.StoreUint32(&o.EVENTS_ERROR.Reg, volatile.LoadUint32(&o.EVENTS_ERROR.Reg)&^(0x1)|value)
}
func (o *UARTE_Type) GetEVENTS_ERROR() uint32 {
	return volatile.LoadUint32(&o.EVENTS_ERROR.Reg) & 0x1
}

// UARTE.EVENTS_RXTO: Receiver timeout
func (o *UARTE_Type) SetEVENTS_RXTO(value uint32) {
	volatile.StoreUint32(&o.EVENTS_RXTO.Reg, volatile.LoadUint32(&o.EVENTS_RXTO.Reg)&^(0x1)|value)
}
func (o *UARTE_Type) GetEVENTS_RXTO() uint32 {
	return volatile.LoadUint32(&o.EVENTS_RXTO.Reg) & 0x1
}

// UARTE.EVENTS_RXSTARTED: UART receiver has started
func (o *UARTE_Type) SetEVENTS_RXSTARTED(value uint32) {
	volatile.StoreUint32(&o.EVENTS_RXSTARTED.Reg, volatile.LoadUint32(&o.EVENTS_RXSTARTED.Reg)&^(0x1)|value)
}
func (o *UARTE_Type) GetEVENTS_RXSTARTED() uint32 {
	return volatile.LoadUint32(&o.EVENTS_RXSTARTED.Reg) & 0x1
}

// UARTE.EVENTS_TXSTARTED: UART transmitter has started
func (o *UARTE_Type) SetEVENTS_TXSTARTED(value uint32) {
	volatile.StoreUint32(&o.EVENTS_TXSTARTED.Reg, volatile.LoadUint32(&o.EVENTS_TXSTARTED.Reg)&^(0x1)|value)
}
func (o *UARTE_Type) GetEVENTS_TXSTARTED() uint32 {
	return volatile.LoadUint32(&o.EVENTS_TXSTARTED.Reg) & 0x1
}

// UARTE.EVENTS_TXSTOPPED: Transmitter stopped
func (o *UARTE_Type) SetEVENTS_TXSTOPPED(value uint32) {
	volatile.StoreUint32(&o.EVENTS_TXSTOPPED.Reg, volatile.LoadUint32(&o.EVENTS_TXSTOPPED.Reg)&^(0x1)|value)
}
func (o *UARTE_Type) GetEVENTS_TXSTOPPED() uint32 {
	return volatile.LoadUint32(&o.EVENTS_TXSTOPPED.Reg) & 0x1
}

// UARTE.PUBLISH_CTS: Publish configuration for event CTS
func (o *UARTE_Type) SetPUBLISH_CTS_CHIDX(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_CTS.Reg, volatile.LoadUint32(&o.PUBLISH_CTS.Reg)&^(0xff)|value)
}
func (o *UARTE_Type) GetPUBLISH_CTS_CHIDX() uint32 {
	return volatile.LoadUint32(&o.PUBLISH_CTS.Reg) & 0xff
}
func (o *UARTE_Type) SetPUBLISH_CTS_EN(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_CTS.Reg, volatile.LoadUint32(&o.PUBLISH_CTS.Reg)&^(0x80000000)|value<<31)
}
func (o *UARTE_Type) GetPUBLISH_CTS_EN() uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_CTS.Reg) & 0x80000000) >> 31
}

// UARTE.PUBLISH_NCTS: Publish configuration for event NCTS
func (o *UARTE_Type) SetPUBLISH_NCTS_CHIDX(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_NCTS.Reg, volatile.LoadUint32(&o.PUBLISH_NCTS.Reg)&^(0xff)|value)
}
func (o *UARTE_Type) GetPUBLISH_NCTS_CHIDX() uint32 {
	return volatile.LoadUint32(&o.PUBLISH_NCTS.Reg) & 0xff
}
func (o *UARTE_Type) SetPUBLISH_NCTS_EN(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_NCTS.Reg, volatile.LoadUint32(&o.PUBLISH_NCTS.Reg)&^(0x80000000)|value<<31)
}
func (o *UARTE_Type) GetPUBLISH_NCTS_EN() uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_NCTS.Reg) & 0x80000000) >> 31
}

// UARTE.PUBLISH_RXDRDY: Publish configuration for event RXDRDY
func (o *UARTE_Type) SetPUBLISH_RXDRDY_CHIDX(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_RXDRDY.Reg, volatile.LoadUint32(&o.PUBLISH_RXDRDY.Reg)&^(0xff)|value)
}
func (o *UARTE_Type) GetPUBLISH_RXDRDY_CHIDX() uint32 {
	return volatile.LoadUint32(&o.PUBLISH_RXDRDY.Reg) & 0xff
}
func (o *UARTE_Type) SetPUBLISH_RXDRDY_EN(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_RXDRDY.Reg, volatile.LoadUint32(&o.PUBLISH_RXDRDY.Reg)&^(0x80000000)|value<<31)
}
func (o *UARTE_Type) GetPUBLISH_RXDRDY_EN() uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_RXDRDY.Reg) & 0x80000000) >> 31
}

// UARTE.PUBLISH_ENDRX: Publish configuration for event ENDRX
func (o *UARTE_Type) SetPUBLISH_ENDRX_CHIDX(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_ENDRX.Reg, volatile.LoadUint32(&o.PUBLISH_ENDRX.Reg)&^(0xff)|value)
}
func (o *UARTE_Type) GetPUBLISH_ENDRX_CHIDX() uint32 {
	return volatile.LoadUint32(&o.PUBLISH_ENDRX.Reg) & 0xff
}
func (o *UARTE_Type) SetPUBLISH_ENDRX_EN(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_ENDRX.Reg, volatile.LoadUint32(&o.PUBLISH_ENDRX.Reg)&^(0x80000000)|value<<31)
}
func (o *UARTE_Type) GetPUBLISH_ENDRX_EN() uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_ENDRX.Reg) & 0x80000000) >> 31
}

// UARTE.PUBLISH_TXDRDY: Publish configuration for event TXDRDY
func (o *UARTE_Type) SetPUBLISH_TXDRDY_CHIDX(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_TXDRDY.Reg, volatile.LoadUint32(&o.PUBLISH_TXDRDY.Reg)&^(0xff)|value)
}
func (o *UARTE_Type) GetPUBLISH_TXDRDY_CHIDX() uint32 {
	return volatile.LoadUint32(&o.PUBLISH_TXDRDY.Reg) & 0xff
}
func (o *UARTE_Type) SetPUBLISH_TXDRDY_EN(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_TXDRDY.Reg, volatile.LoadUint32(&o.PUBLISH_TXDRDY.Reg)&^(0x80000000)|value<<31)
}
func (o *UARTE_Type) GetPUBLISH_TXDRDY_EN() uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_TXDRDY.Reg) & 0x80000000) >> 31
}

// UARTE.PUBLISH_ENDTX: Publish configuration for event ENDTX
func (o *UARTE_Type) SetPUBLISH_ENDTX_CHIDX(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_ENDTX.Reg, volatile.LoadUint32(&o.PUBLISH_ENDTX.Reg)&^(0xff)|value)
}
func (o *UARTE_Type) GetPUBLISH_ENDTX_CHIDX() uint32 {
	return volatile.LoadUint32(&o.PUBLISH_ENDTX.Reg) & 0xff
}
func (o *UARTE_Type) SetPUBLISH_ENDTX_EN(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_ENDTX.Reg, volatile.LoadUint32(&o.PUBLISH_ENDTX.Reg)&^(0x80000000)|value<<31)
}
func (o *UARTE_Type) GetPUBLISH_ENDTX_EN() uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_ENDTX.Reg) & 0x80000000) >> 31
}

// UARTE.PUBLISH_ERROR: Publish configuration for event ERROR
func (o *UARTE_Type) SetPUBLISH_ERROR_CHIDX(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_ERROR.Reg, volatile.LoadUint32(&o.PUBLISH_ERROR.Reg)&^(0xff)|value)
}
func (o *UARTE_Type) GetPUBLISH_ERROR_CHIDX() uint32 {
	return volatile.LoadUint32(&o.PUBLISH_ERROR.Reg) & 0xff
}
func (o *UARTE_Type) SetPUBLISH_ERROR_EN(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_ERROR.Reg, volatile.LoadUint32(&o.PUBLISH_ERROR.Reg)&^(0x80000000)|value<<31)
}
func (o *UARTE_Type) GetPUBLISH_ERROR_EN() uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_ERROR.Reg) & 0x80000000) >> 31
}

// UARTE.PUBLISH_RXTO: Publish configuration for event RXTO
func (o *UARTE_Type) SetPUBLISH_RXTO_CHIDX(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_RXTO.Reg, volatile.LoadUint32(&o.PUBLISH_RXTO.Reg)&^(0xff)|value)
}
func (o *UARTE_Type) GetPUBLISH_RXTO_CHIDX() uint32 {
	return volatile.LoadUint32(&o.PUBLISH_RXTO.Reg) & 0xff
}
func (o *UARTE_Type) SetPUBLISH_RXTO_EN(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_RXTO.Reg, volatile.LoadUint32(&o.PUBLISH_RXTO.Reg)&^(0x80000000)|value<<31)
}
func (o *UARTE_Type) GetPUBLISH_RXTO_EN() uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_RXTO.Reg) & 0x80000000) >> 31
}

// UARTE.PUBLISH_RXSTARTED: Publish configuration for event RXSTARTED
func (o *UARTE_Type) SetPUBLISH_RXSTARTED_CHIDX(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_RXSTARTED.Reg, volatile.LoadUint32(&o.PUBLISH_RXSTARTED.Reg)&^(0xff)|value)
}
func (o *UARTE_Type) GetPUBLISH_RXSTARTED_CHIDX() uint32 {
	return volatile.LoadUint32(&o.PUBLISH_RXSTARTED.Reg) & 0xff
}
func (o *UARTE_Type) SetPUBLISH_RXSTARTED_EN(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_RXSTARTED.Reg, volatile.LoadUint32(&o.PUBLISH_RXSTARTED.Reg)&^(0x80000000)|value<<31)
}
func (o *UARTE_Type) GetPUBLISH_RXSTARTED_EN() uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_RXSTARTED.Reg) & 0x80000000) >> 31
}

// UARTE.PUBLISH_TXSTARTED: Publish configuration for event TXSTARTED
func (o *UARTE_Type) SetPUBLISH_TXSTARTED_CHIDX(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_TXSTARTED.Reg, volatile.LoadUint32(&o.PUBLISH_TXSTARTED.Reg)&^(0xff)|value)
}
func (o *UARTE_Type) GetPUBLISH_TXSTARTED_CHIDX() uint32 {
	return volatile.LoadUint32(&o.PUBLISH_TXSTARTED.Reg) & 0xff
}
func (o *UARTE_Type) SetPUBLISH_TXSTARTED_EN(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_TXSTARTED.Reg, volatile.LoadUint32(&o.PUBLISH_TXSTARTED.Reg)&^(0x80000000)|value<<31)
}
func (o *UARTE_Type) GetPUBLISH_TXSTARTED_EN() uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_TXSTARTED.Reg) & 0x80000000) >> 31
}

// UARTE.PUBLISH_TXSTOPPED: Publish configuration for event TXSTOPPED
func (o *UARTE_Type) SetPUBLISH_TXSTOPPED_CHIDX(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_TXSTOPPED.Reg, volatile.LoadUint32(&o.PUBLISH_TXSTOPPED.Reg)&^(0xff)|value)
}
func (o *UARTE_Type) GetPUBLISH_TXSTOPPED_CHIDX() uint32 {
	return volatile.LoadUint32(&o.PUBLISH_TXSTOPPED.Reg) & 0xff
}
func (o *UARTE_Type) SetPUBLISH_TXSTOPPED_EN(value uint32) {
	volatile.StoreUint32(&o.PUBLISH_TXSTOPPED.Reg, volatile.LoadUint32(&o.PUBLISH_TXSTOPPED.Reg)&^(0x80000000)|value<<31)
}
func (o *UARTE_Type) GetPUBLISH_TXSTOPPED_EN() uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_TXSTOPPED.Reg) & 0x80000000) >> 31
}

// UARTE.SHORTS: Shortcuts between local events and tasks
func (o *UARTE_Type) SetSHORTS_ENDRX_STARTRX(value uint32) {
	volatile.StoreUint32(&o.SHORTS.Reg, volatile.LoadUint32(&o.SHORTS.Reg)&^(0x20)|value<<5)
}
func (o *UARTE_Type) GetSHORTS_ENDRX_STARTRX() uint32 {
	return (volatile.LoadUint32(&o.SHORTS.Reg) & 0x20) >> 5
}
func (o *UARTE_Type) SetSHORTS_ENDRX_STOPRX(value uint32) {
	volatile.StoreUint32(&o.SHORTS.Reg, volatile.LoadUint32(&o.SHORTS.Reg)&^(0x40)|value<<6)
}
func (o *UARTE_Type) GetSHORTS_ENDRX_STOPRX() uint32 {
	return (volatile.LoadUint32(&o.SHORTS.Reg) & 0x40) >> 6
}

// UARTE.INTEN: Enable or disable interrupt
func (o *UARTE_Type) SetINTEN_CTS(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x1)|value)
}
func (o *UARTE_Type) GetINTEN_CTS() uint32 {
	return volatile.LoadUint32(&o.INTEN.Reg) & 0x1
}
func (o *UARTE_Type) SetINTEN_NCTS(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x2)|value<<1)
}
func (o *UARTE_Type) GetINTEN_NCTS() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x2) >> 1
}
func (o *UARTE_Type) SetINTEN_RXDRDY(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x4)|value<<2)
}
func (o *UARTE_Type) GetINTEN_RXDRDY() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x4) >> 2
}
func (o *UARTE_Type) SetINTEN_ENDRX(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x10)|value<<4)
}
func (o *UARTE_Type) GetINTEN_ENDRX() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x10) >> 4
}
func (o *UARTE_Type) SetINTEN_TXDRDY(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x80)|value<<7)
}
func (o *UARTE_Type) GetINTEN_TXDRDY() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x80) >> 7
}
func (o *UARTE_Type) SetINTEN_ENDTX(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x100)|value<<8)
}
func (o *UARTE_Type) GetINTEN_ENDTX() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x100) >> 8
}
func (o *UARTE_Type) SetINTEN_ERROR(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x200)|value<<9)
}
func (o *UARTE_Type) GetINTEN_ERROR() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x200) >> 9
}
func (o *UARTE_Type) SetINTEN_RXTO(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x20000)|value<<17)
}
func (o *UARTE_Type) GetINTEN_RXTO() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x20000) >> 17
}
func (o *UARTE_Type) SetINTEN_RXSTARTED(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x80000)|value<<19)
}
func (o *UARTE_Type) GetINTEN_RXSTARTED() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x80000) >> 19
}
func (o *UARTE_Type) SetINTEN_TXSTARTED(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x100000)|value<<20)
}
func (o *UARTE_Type) GetINTEN_TXSTARTED() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x100000) >> 20
}
func (o *UARTE_Type) SetINTEN_TXSTOPPED(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x400000)|value<<22)
}
func (o *UARTE_Type) GetINTEN_TXSTOPPED() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x400000) >> 22
}

// UARTE.INTENSET: Enable interrupt
func (o *UARTE_Type) SetINTENSET_CTS(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x1)|value)
}
func (o *UARTE_Type) GetINTENSET_CTS() uint32 {
	return volatile.LoadUint32(&o.INTENSET.Reg) & 0x1
}
func (o *UARTE_Type) SetINTENSET_NCTS(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x2)|value<<1)
}
func (o *UARTE_Type) GetINTENSET_NCTS() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x2) >> 1
}
func (o *UARTE_Type) SetINTENSET_RXDRDY(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x4)|value<<2)
}
func (o *UARTE_Type) GetINTENSET_RXDRDY() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x4) >> 2
}
func (o *UARTE_Type) SetINTENSET_ENDRX(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x10)|value<<4)
}
func (o *UARTE_Type) GetINTENSET_ENDRX() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x10) >> 4
}
func (o *UARTE_Type) SetINTENSET_TXDRDY(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x80)|value<<7)
}
func (o *UARTE_Type) GetINTENSET_TXDRDY() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x80) >> 7
}
func (o *UARTE_Type) SetINTENSET_ENDTX(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x100)|value<<8)
}
func (o *UARTE_Type) GetINTENSET_ENDTX() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x100) >> 8
}
func (o *UARTE_Type) SetINTENSET_ERROR(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x200)|value<<9)
}
func (o *UARTE_Type) GetINTENSET_ERROR() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x200) >> 9
}
func (o *UARTE_Type) SetINTENSET_RXTO(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x20000)|value<<17)
}
func (o *UARTE_Type) GetINTENSET_RXTO() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x20000) >> 17
}
func (o *UARTE_Type) SetINTENSET_RXSTARTED(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x80000)|value<<19)
}
func (o *UARTE_Type) GetINTENSET_RXSTARTED() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x80000) >> 19
}
func (o *UARTE_Type) SetINTENSET_TXSTARTED(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x100000)|value<<20)
}
func (o *UARTE_Type) GetINTENSET_TXSTARTED() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x100000) >> 20
}
func (o *UARTE_Type) SetINTENSET_TXSTOPPED(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x400000)|value<<22)
}
func (o *UARTE_Type) GetINTENSET_TXSTOPPED() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x400000) >> 22
}

// UARTE.INTENCLR: Disable interrupt
func (o *UARTE_Type) SetINTENCLR_CTS(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x1)|value)
}
func (o *UARTE_Type) GetINTENCLR_CTS() uint32 {
	return volatile.LoadUint32(&o.INTENCLR.Reg) & 0x1
}
func (o *UARTE_Type) SetINTENCLR_NCTS(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x2)|value<<1)
}
func (o *UARTE_Type) GetINTENCLR_NCTS() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x2) >> 1
}
func (o *UARTE_Type) SetINTENCLR_RXDRDY(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x4)|value<<2)
}
func (o *UARTE_Type) GetINTENCLR_RXDRDY() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x4) >> 2
}
func (o *UARTE_Type) SetINTENCLR_ENDRX(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x10)|value<<4)
}
func (o *UARTE_Type) GetINTENCLR_ENDRX() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x10) >> 4
}
func (o *UARTE_Type) SetINTENCLR_TXDRDY(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x80)|value<<7)
}
func (o *UARTE_Type) GetINTENCLR_TXDRDY() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x80) >> 7
}
func (o *UARTE_Type) SetINTENCLR_ENDTX(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x100)|value<<8)
}
func (o *UARTE_Type) GetINTENCLR_ENDTX() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x100) >> 8
}
func (o *UARTE_Type) SetINTENCLR_ERROR(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x200)|value<<9)
}
func (o *UARTE_Type) GetINTENCLR_ERROR() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x200) >> 9
}
func (o *UARTE_Type) SetINTENCLR_RXTO(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x20000)|value<<17)
}
func (o *UARTE_Type) GetINTENCLR_RXTO() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x20000) >> 17
}
func (o *UARTE_Type) SetINTENCLR_RXSTARTED(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x80000)|value<<19)
}
func (o *UARTE_Type) GetINTENCLR_RXSTARTED() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x80000) >> 19
}
func (o *UARTE_Type) SetINTENCLR_TXSTARTED(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x100000)|value<<20)
}
func (o *UARTE_Type) GetINTENCLR_TXSTARTED() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x100000) >> 20
}
func (o *UARTE_Type) SetINTENCLR_TXSTOPPED(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x400000)|value<<22)
}
func (o *UARTE_Type) GetINTENCLR_TXSTOPPED() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x400000) >> 22
}

// UARTE.ERRORSRC: Error source Note : this register is read / write one to clear.
func (o *UARTE_Type) SetERRORSRC_OVERRUN(value uint32) {
	volatile.StoreUint32(&o.ERRORSRC.Reg, volatile.LoadUint32(&o.ERRORSRC.Reg)&^(0x1)|value)
}
func (o *UARTE_Type) GetERRORSRC_OVERRUN() uint32 {
	return volatile.LoadUint32(&o.ERRORSRC.Reg) & 0x1
}
func (o *UARTE_Type) SetERRORSRC_PARITY(value uint32) {
	volatile.StoreUint32(&o.ERRORSRC.Reg, volatile.LoadUint32(&o.ERRORSRC.Reg)&^(0x2)|value<<1)
}
func (o *UARTE_Type) GetERRORSRC_PARITY() uint32 {
	return (volatile.LoadUint32(&o.ERRORSRC.Reg) & 0x2) >> 1
}
func (o *UARTE_Type) SetERRORSRC_FRAMING(value uint32) {
	volatile.StoreUint32(&o.ERRORSRC.Reg, volatile.LoadUint32(&o.ERRORSRC.Reg)&^(0x4)|value<<2)
}
func (o *UARTE_Type) GetERRORSRC_FRAMING() uint32 {
	return (volatile.LoadUint32(&o.ERRORSRC.Reg) & 0x4) >> 2
}
func (o *UARTE_Type) SetERRORSRC_BREAK(value uint32) {
	volatile.StoreUint32(&o.ERRORSRC.Reg, volatile.LoadUint32(&o.ERRORSRC.Reg)&^(0x8)|value<<3)
}
func (o *UARTE_Type) GetERRORSRC_BREAK() uint32 {
	return (volatile.LoadUint32(&o.ERRORSRC.Reg) & 0x8) >> 3
}

// UARTE.ENABLE: Enable UART
func (o *UARTE_Type) SetENABLE(value uint32) {
	volatile.StoreUint32(&o.ENABLE.Reg, volatile.LoadUint32(&o.ENABLE.Reg)&^(0xf)|value)
}
func (o *UARTE_Type) GetENABLE() uint32 {
	return volatile.LoadUint32(&o.ENABLE.Reg) & 0xf
}

// UARTE.BAUDRATE: Baud rate. Accuracy depends on the HFCLK source selected.
func (o *UARTE_Type) SetBAUDRATE(value uint32) {
	volatile.StoreUint32(&o.BAUDRATE.Reg, value)
}
func (o *UARTE_Type) GetBAUDRATE() uint32 {
	return volatile.LoadUint32(&o.BAUDRATE.Reg)
}

// UARTE.CONFIG: Configuration of parity and hardware flow control
func (o *UARTE_Type) SetCONFIG_HWFC(value uint32) {
	volatile.StoreUint32(&o.CONFIG.Reg, volatile.LoadUint32(&o.CONFIG.Reg)&^(0x1)|value)
}
func (o *UARTE_Type) GetCONFIG_HWFC() uint32 {
	return volatile.LoadUint32(&o.CONFIG.Reg) & 0x1
}
func (o *UARTE_Type) SetCONFIG_PARITY(value uint32) {
	volatile.StoreUint32(&o.CONFIG.Reg, volatile.LoadUint32(&o.CONFIG.Reg)&^(0xe)|value<<1)
}
func (o *UARTE_Type) GetCONFIG_PARITY() uint32 {
	return (volatile.LoadUint32(&o.CONFIG.Reg) & 0xe) >> 1
}
func (o *UARTE_Type) SetCONFIG_STOP(value uint32) {
	volatile.StoreUint32(&o.CONFIG.Reg, volatile.LoadUint32(&o.CONFIG.Reg)&^(0x10)|value<<4)
}
func (o *UARTE_Type) GetCONFIG_STOP() uint32 {
	return (volatile.LoadUint32(&o.CONFIG.Reg) & 0x10) >> 4
}
func (o *UARTE_Type) SetCONFIG_PARITYTYPE(value uint32) {
	volatile.StoreUint32(&o.CONFIG.Reg, volatile.LoadUint32(&o.CONFIG.Reg)&^(0x100)|value<<8)
}
func (o *UARTE_Type) GetCONFIG_PARITYTYPE() uint32 {
	return (volatile.LoadUint32(&o.CONFIG.Reg) & 0x100) >> 8
}

// Unspecified
type UARTE_PSEL_Type struct {
	RTS volatile.Register32 // 0x508
	TXD volatile.Register32 // 0x50C
	CTS volatile.Register32 // 0x510
	RXD volatile.Register32 // 0x514
}

// UARTE_PSEL.RTS: Pin select for RTS signal
func (o *UARTE_PSEL_Type) SetRTS_PIN(value uint32) {
	volatile.StoreUint32(&o.RTS.Reg, volatile.LoadUint32(&o.RTS.Reg)&^(0x1f)|value)
}
func (o *UARTE_PSEL_Type) GetRTS_PIN() uint32 {
	return volatile.LoadUint32(&o.RTS.Reg) & 0x1f
}
func (o *UARTE_PSEL_Type) SetRTS_PORT(value uint32) {
	volatile.StoreUint32(&o.RTS.Reg, volatile.LoadUint32(&o.RTS.Reg)&^(0x20)|value<<5)
}
func (o *UARTE_PSEL_Type) GetRTS_PORT() uint32 {
	return (volatile.LoadUint32(&o.RTS.Reg) & 0x20) >> 5
}
func (o *UARTE_PSEL_Type) SetRTS_CONNECT(value uint32) {
	volatile.StoreUint32(&o.RTS.Reg, volatile.LoadUint32(&o.RTS.Reg)&^(0x80000000)|value<<31)
}
func (o *UARTE_PSEL_Type) GetRTS_CONNECT() uint32 {
	return (volatile.LoadUint32(&o.RTS.Reg) & 0x80000000) >> 31
}

// UARTE_PSEL.TXD: Pin select for TXD signal
func (o *UARTE_PSEL_Type) SetTXD_PIN(value uint32) {
	volatile.StoreUint32(&o.TXD.Reg, volatile.LoadUint32(&o.TXD.Reg)&^(0x1f)|value)
}
func (o *UARTE_PSEL_Type) GetTXD_PIN() uint32 {
	return volatile.LoadUint32(&o.TXD.Reg) & 0x1f
}
func (o *UARTE_PSEL_Type) SetTXD_PORT(value uint32) {
	volatile.StoreUint32(&o.TXD.Reg, volatile.LoadUint32(&o.TXD.Reg)&^(0x20)|value<<5)
}
func (o *UARTE_PSEL_Type) GetTXD_PORT() uint32 {
	return (volatile.LoadUint32(&o.TXD.Reg) & 0x20) >> 5
}
func (o *UARTE_PSEL_Type) SetTXD_CONNECT(value uint32) {
	volatile.StoreUint32(&o.TXD.Reg, volatile.LoadUint32(&o.TXD.Reg)&^(0x80000000)|value<<31)
}
func (o *UARTE_PSEL_Type) GetTXD_CONNECT() uint32 {
	return (volatile.LoadUint32(&o.TXD.Reg) & 0x80000000) >> 31
}

// UARTE_PSEL.CTS: Pin select for CTS signal
func (o *UARTE_PSEL_Type) SetCTS_PIN(value uint32) {
	volatile.StoreUint32(&o.CTS.Reg, volatile.LoadUint32(&o.CTS.Reg)&^(0x1f)|value)
}
func (o *UARTE_PSEL_Type) GetCTS_PIN() uint32 {
	return volatile.LoadUint32(&o.CTS.Reg) & 0x1f
}
func (o *UARTE_PSEL_Type) SetCTS_PORT(value uint32) {
	volatile.StoreUint32(&o.CTS.Reg, volatile.LoadUint32(&o.CTS.Reg)&^(0x20)|value<<5)
}
func (o *UARTE_PSEL_Type) GetCTS_PORT() uint32 {
	return (volatile.LoadUint32(&o.CTS.Reg) & 0x20) >> 5
}
func (o *UARTE_PSEL_Type) SetCTS_CONNECT(value uint32) {
	volatile.StoreUint32(&o.CTS.Reg, volatile.LoadUint32(&o.CTS.Reg)&^(0x80000000)|value<<31)
}
func (o *UARTE_PSEL_Type) GetCTS_CONNECT() uint32 {
	return (volatile.LoadUint32(&o.CTS.Reg) & 0x80000000) >> 31
}

// UARTE_PSEL.RXD: Pin select for RXD signal
func (o *UARTE_PSEL_Type) SetRXD_PIN(value uint32) {
	volatile.StoreUint32(&o.RXD.Reg, volatile.LoadUint32(&o.RXD.Reg)&^(0x1f)|value)
}
func (o *UARTE_PSEL_Type) GetRXD_PIN() uint32 {
	return volatile.LoadUint32(&o.RXD.Reg) & 0x1f
}
func (o *UARTE_PSEL_Type) SetRXD_PORT(value uint32) {
	volatile.StoreUint32(&o.RXD.Reg, volatile.LoadUint32(&o.RXD.Reg)&^(0x20)|value<<5)
}
func (o *UARTE_PSEL_Type) GetRXD_PORT() uint32 {
	return (volatile.LoadUint32(&o.RXD.Reg) & 0x20) >> 5
}
func (o *UARTE_PSEL_Type) SetRXD_CONNECT(value uint32) {
	volatile.StoreUint32(&o.RXD.Reg, volatile.LoadUint32(&o.RXD.Reg)&^(0x80000000)|value<<31)
}
func (o *UARTE_PSEL_Type) GetRXD_CONNECT() uint32 {
	return (volatile.LoadUint32(&o.RXD.Reg) & 0x80000000) >> 31
}

// RXD EasyDMA channel
type UARTE_RXD_Type struct {
	PTR    volatile.Register32 // 0x534
	MAXCNT volatile.Register32 // 0x538
	AMOUNT volatile.Register32 // 0x53C
}

// UARTE_RXD.PTR: Data pointer
func (o *UARTE_RXD_Type) SetPTR(value uint32) {
	volatile.StoreUint32(&o.PTR.Reg, value)
}
func (o *UARTE_RXD_Type) GetPTR() uint32 {
	return volatile.LoadUint32(&o.PTR.Reg)
}

// UARTE_RXD.MAXCNT: Maximum number of bytes in receive buffer
func (o *UARTE_RXD_Type) SetMAXCNT(value uint32) {
	volatile.StoreUint32(&o.MAXCNT.Reg, volatile.LoadUint32(&o.MAXCNT.Reg)&^(0xffff)|value)
}
func (o *UARTE_RXD_Type) GetMAXCNT() uint32 {
	return volatile.LoadUint32(&o.MAXCNT.Reg) & 0xffff
}

// UARTE_RXD.AMOUNT: Number of bytes transferred in the last transaction
func (o *UARTE_RXD_Type) SetAMOUNT(value uint32) {
	volatile.StoreUint32(&o.AMOUNT.Reg, volatile.LoadUint32(&o.AMOUNT.Reg)&^(0xffff)|value)
}
func (o *UARTE_RXD_Type) GetAMOUNT() uint32 {
	return volatile.LoadUint32(&o.AMOUNT.Reg) & 0xffff
}

// TXD EasyDMA channel
type UARTE_TXD_Type struct {
	PTR    volatile.Register32 // 0x544
	MAXCNT volatile.Register32 // 0x548
	AMOUNT volatile.Register32 // 0x54C
}

// UARTE_TXD.PTR: Data pointer
func (o *UARTE_TXD_Type) SetPTR(value uint32) {
	volatile.StoreUint32(&o.PTR.Reg, value)
}
func (o *UARTE_TXD_Type) GetPTR() uint32 {
	return volatile.LoadUint32(&o.PTR.Reg)
}

// UARTE_TXD.MAXCNT: Maximum number of bytes in transmit buffer
func (o *UARTE_TXD_Type) SetMAXCNT(value uint32) {
	volatile.StoreUint32(&o.MAXCNT.Reg, volatile.LoadUint32(&o.MAXCNT.Reg)&^(0xffff)|value)
}
func (o *UARTE_TXD_Type) GetMAXCNT() uint32 {
	return volatile.LoadUint32(&o.MAXCNT.Reg) & 0xffff
}

// UARTE_TXD.AMOUNT: Number of bytes transferred in the last transaction
func (o *UARTE_TXD_Type) SetAMOUNT(value uint32) {
	volatile.StoreUint32(&o.AMOUNT.Reg, volatile.LoadUint32(&o.AMOUNT.Reg)&^(0xffff)|value)
}
func (o *UARTE_TXD_Type) GetAMOUNT() uint32 {
	return volatile.LoadUint32(&o.AMOUNT.Reg) & 0xffff
}

// Event generator unit
type EGU_Type struct {
	TASKS_TRIGGER     [16]volatile.Register32 // 0x0
	_                 [64]byte
	SUBSCRIBE_TRIGGER [16]volatile.Register32 // 0x80
	_                 [64]byte
	EVENTS_TRIGGERED  [16]volatile.Register32 // 0x100
	_                 [64]byte
	PUBLISH_TRIGGERED [16]volatile.Register32 // 0x180
	_                 [320]byte
	INTEN             volatile.Register32 // 0x300
	INTENSET          volatile.Register32 // 0x304
	INTENCLR          volatile.Register32 // 0x308
}

// EGU.TASKS_TRIGGER: Description collection: Trigger n for triggering the corresponding TRIGGERED[n] event
func (o *EGU_Type) SetTASKS_TRIGGER(idx int, value uint32) {
	volatile.StoreUint32(&o.TASKS_TRIGGER[idx].Reg, volatile.LoadUint32(&o.TASKS_TRIGGER[idx].Reg)&^(0x1)|value)
}
func (o *EGU_Type) GetTASKS_TRIGGER(idx int) uint32 {
	return volatile.LoadUint32(&o.TASKS_TRIGGER[idx].Reg) & 0x1
}

// EGU.SUBSCRIBE_TRIGGER: Description collection: Subscribe configuration for task TRIGGER[n]
func (o *EGU_Type) SetSUBSCRIBE_TRIGGER_CHIDX(idx int, value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_TRIGGER[idx].Reg, volatile.LoadUint32(&o.SUBSCRIBE_TRIGGER[idx].Reg)&^(0xff)|value)
}
func (o *EGU_Type) GetSUBSCRIBE_TRIGGER_CHIDX(idx int) uint32 {
	return volatile.LoadUint32(&o.SUBSCRIBE_TRIGGER[idx].Reg) & 0xff
}
func (o *EGU_Type) SetSUBSCRIBE_TRIGGER_EN(idx int, value uint32) {
	volatile.StoreUint32(&o.SUBSCRIBE_TRIGGER[idx].Reg, volatile.LoadUint32(&o.SUBSCRIBE_TRIGGER[idx].Reg)&^(0x80000000)|value<<31)
}
func (o *EGU_Type) GetSUBSCRIBE_TRIGGER_EN(idx int) uint32 {
	return (volatile.LoadUint32(&o.SUBSCRIBE_TRIGGER[idx].Reg) & 0x80000000) >> 31
}

// EGU.EVENTS_TRIGGERED: Description collection: Event number n generated by triggering the corresponding TRIGGER[n] task
func (o *EGU_Type) SetEVENTS_TRIGGERED(idx int, value uint32) {
	volatile.StoreUint32(&o.EVENTS_TRIGGERED[idx].Reg, volatile.LoadUint32(&o.EVENTS_TRIGGERED[idx].Reg)&^(0x1)|value)
}
func (o *EGU_Type) GetEVENTS_TRIGGERED(idx int) uint32 {
	return volatile.LoadUint32(&o.EVENTS_TRIGGERED[idx].Reg) & 0x1
}

// EGU.PUBLISH_TRIGGERED: Description collection: Publish configuration for event TRIGGERED[n]
func (o *EGU_Type) SetPUBLISH_TRIGGERED_CHIDX(idx int, value uint32) {
	volatile.StoreUint32(&o.PUBLISH_TRIGGERED[idx].Reg, volatile.LoadUint32(&o.PUBLISH_TRIGGERED[idx].Reg)&^(0xff)|value)
}
func (o *EGU_Type) GetPUBLISH_TRIGGERED_CHIDX(idx int) uint32 {
	return volatile.LoadUint32(&o.PUBLISH_TRIGGERED[idx].Reg) & 0xff
}
func (o *EGU_Type) SetPUBLISH_TRIGGERED_EN(idx int, value uint32) {
	volatile.StoreUint32(&o.PUBLISH_TRIGGERED[idx].Reg, volatile.LoadUint32(&o.PUBLISH_TRIGGERED[idx].Reg)&^(0x80000000)|value<<31)
}
func (o *EGU_Type) GetPUBLISH_TRIGGERED_EN(idx int) uint32 {
	return (volatile.LoadUint32(&o.PUBLISH_TRIGGERED[idx].Reg) & 0x80000000) >> 31
}

// EGU.INTEN: Enable or disable interrupt
func (o *EGU_Type) SetINTEN_TRIGGERED0(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x1)|value)
}
func (o *EGU_Type) GetINTEN_TRIGGERED0() uint32 {
	return volatile.LoadUint32(&o.INTEN.Reg) & 0x1
}
func (o *EGU_Type) SetINTEN_TRIGGERED1(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x2)|value<<1)
}
func (o *EGU_Type) GetINTEN_TRIGGERED1() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x2) >> 1
}
func (o *EGU_Type) SetINTEN_TRIGGERED2(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x4)|value<<2)
}
func (o *EGU_Type) GetINTEN_TRIGGERED2() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x4) >> 2
}
func (o *EGU_Type) SetINTEN_TRIGGERED3(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x8)|value<<3)
}
func (o *EGU_Type) GetINTEN_TRIGGERED3() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x8) >> 3
}
func (o *EGU_Type) SetINTEN_TRIGGERED4(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x10)|value<<4)
}
func (o *EGU_Type) GetINTEN_TRIGGERED4() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x10) >> 4
}
func (o *EGU_Type) SetINTEN_TRIGGERED5(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x20)|value<<5)
}
func (o *EGU_Type) GetINTEN_TRIGGERED5() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x20) >> 5
}
func (o *EGU_Type) SetINTEN_TRIGGERED6(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x40)|value<<6)
}
func (o *EGU_Type) GetINTEN_TRIGGERED6() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x40) >> 6
}
func (o *EGU_Type) SetINTEN_TRIGGERED7(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x80)|value<<7)
}
func (o *EGU_Type) GetINTEN_TRIGGERED7() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x80) >> 7
}
func (o *EGU_Type) SetINTEN_TRIGGERED8(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x100)|value<<8)
}
func (o *EGU_Type) GetINTEN_TRIGGERED8() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x100) >> 8
}
func (o *EGU_Type) SetINTEN_TRIGGERED9(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x200)|value<<9)
}
func (o *EGU_Type) GetINTEN_TRIGGERED9() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x200) >> 9
}
func (o *EGU_Type) SetINTEN_TRIGGERED10(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x400)|value<<10)
}
func (o *EGU_Type) GetINTEN_TRIGGERED10() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x400) >> 10
}
func (o *EGU_Type) SetINTEN_TRIGGERED11(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x800)|value<<11)
}
func (o *EGU_Type) GetINTEN_TRIGGERED11() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x800) >> 11
}
func (o *EGU_Type) SetINTEN_TRIGGERED12(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x1000)|value<<12)
}
func (o *EGU_Type) GetINTEN_TRIGGERED12() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x1000) >> 12
}
func (o *EGU_Type) SetINTEN_TRIGGERED13(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x2000)|value<<13)
}
func (o *EGU_Type) GetINTEN_TRIGGERED13() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x2000) >> 13
}
func (o *EGU_Type) SetINTEN_TRIGGERED14(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x4000)|value<<14)
}
func (o *EGU_Type) GetINTEN_TRIGGERED14() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x4000) >> 14
}
func (o *EGU_Type) SetINTEN_TRIGGERED15(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x8000)|value<<15)
}
func (o *EGU_Type) GetINTEN_TRIGGERED15() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x8000) >> 15
}

// EGU.INTENSET: Enable interrupt
func (o *EGU_Type) SetINTENSET_TRIGGERED0(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x1)|value)
}
func (o *EGU_Type) GetINTENSET_TRIGGERED0() uint32 {
	return volatile.LoadUint32(&o.INTENSET.Reg) & 0x1
}
func (o *EGU_Type) SetINTENSET_TRIGGERED1(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x2)|value<<1)
}
func (o *EGU_Type) GetINTENSET_TRIGGERED1() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x2) >> 1
}
func (o *EGU_Type) SetINTENSET_TRIGGERED2(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x4)|value<<2)
}
func (o *EGU_Type) GetINTENSET_TRIGGERED2() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x4) >> 2
}
func (o *EGU_Type) SetINTENSET_TRIGGERED3(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x8)|value<<3)
}
func (o *EGU_Type) GetINTENSET_TRIGGERED3() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x8) >> 3
}
func (o *EGU_Type) SetINTENSET_TRIGGERED4(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x10)|value<<4)
}
func (o *EGU_Type) GetINTENSET_TRIGGERED4() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x10) >> 4
}
func (o *EGU_Type) SetINTENSET_TRIGGERED5(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x20)|value<<5)
}
func (o *EGU_Type) GetINTENSET_TRIGGERED5() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x20) >> 5
}
func (o *EGU_Type) SetINTENSET_TRIGGERED6(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x40)|value<<6)
}
func (o *EGU_Type) GetINTENSET_TRIGGERED6() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x40) >> 6
}
func (o *EGU_Type) SetINTENSET_TRIGGERED7(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x80)|value<<7)
}
func (o *EGU_Type) GetINTENSET_TRIGGERED7() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x80) >> 7
}
func (o *EGU_Type) SetINTENSET_TRIGGERED8(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x100)|value<<8)
}
func (o *EGU_Type) GetINTENSET_TRIGGERED8() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x100) >> 8
}
func (o *EGU_Type) SetINTENSET_TRIGGERED9(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x200)|value<<9)
}
func (o *EGU_Type) GetINTENSET_TRIGGERED9() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x200) >> 9
}
func (o *EGU_Type) SetINTENSET_TRIGGERED10(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x400)|value<<10)
}
func (o *EGU_Type) GetINTENSET_TRIGGERED10() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x400) >> 10
}
func (o *EGU_Type) SetINTENSET_TRIGGERED11(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x800)|value<<11)
}
func (o *EGU_Type) GetINTENSET_TRIGGERED11() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x800) >> 11
}
func (o *EGU_Type) SetINTENSET_TRIGGERED12(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x1000)|value<<12)
}
func (o *EGU_Type) GetINTENSET_TRIGGERED12() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x1000) >> 12
}
func (o *EGU_Type) SetINTENSET_TRIGGERED13(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x2000)|value<<13)
}
func (o *EGU_Type) GetINTENSET_TRIGGERED13() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x2000) >> 13
}
func (o *EGU_Type) SetINTENSET_TRIGGERED14(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x4000)|value<<14)
}
func (o *EGU_Type) GetINTENSET_TRIGGERED14() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x4000) >> 14
}
func (o *EGU_Type) SetINTENSET_TRIGGERED15(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x8000)|value<<15)
}
func (o *EGU_Type) GetINTENSET_TRIGGERED15() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x8000) >> 15
}

// EGU.INTENCLR: Disable interrupt
func (o *EGU_Type) SetINTENCLR_TRIGGERED0(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x1)|value)
}
func (o *EGU_Type) GetINTENCLR_TRIGGERED0() uint32 {
	return volatile.LoadUint32(&o.INTENCLR.Reg) & 0x1
}
func (o *EGU_Type) SetINTENCLR_TRIGGERED1(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x2)|value<<1)
}
func (o *EGU_Type) GetINTENCLR_TRIGGERED1() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x2) >> 1
}
func (o *EGU_Type) SetINTENCLR_TRIGGERED2(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x4)|value<<2)
}
func (o *EGU_Type) GetINTENCLR_TRIGGERED2() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x4) >> 2
}
func (o *EGU_Type) SetINTENCLR_TRIGGERED3(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x8)|value<<3)
}
func (o *EGU_Type) GetINTENCLR_TRIGGERED3() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x8) >> 3
}
func (o *EGU_Type) SetINTENCLR_TRIGGERED4(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x10)|value<<4)
}
func (o *EGU_Type) GetINTENCLR_TRIGGERED4() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x10) >> 4
}
func (o *EGU_Type) SetINTENCLR_TRIGGERED5(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x20)|value<<5)
}
func (o *EGU_Type) GetINTENCLR_TRIGGERED5() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x20) >> 5
}
func (o *EGU_Type) SetINTENCLR_TRIGGERED6(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x40)|value<<6)
}
func (o *EGU_Type) GetINTENCLR_TRIGGERED6() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x40) >> 6
}
func (o *EGU_Type) SetINTENCLR_TRIGGERED7(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x80)|value<<7)
}
func (o *EGU_Type) GetINTENCLR_TRIGGERED7() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x80) >> 7
}
func (o *EGU_Type) SetINTENCLR_TRIGGERED8(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x100)|value<<8)
}
func (o *EGU_Type) GetINTENCLR_TRIGGERED8() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x100) >> 8
}
func (o *EGU_Type) SetINTENCLR_TRIGGERED9(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x200)|value<<9)
}
func (o *EGU_Type) GetINTENCLR_TRIGGERED9() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x200) >> 9
}
func (o *EGU_Type) SetINTENCLR_TRIGGERED10(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x400)|value<<10)
}
func (o *EGU_Type) GetINTENCLR_TRIGGERED10() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x400) >> 10
}
func (o *EGU_Type) SetINTENCLR_TRIGGERED11(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x800)|value<<11)
}
func (o *EGU_Type) GetINTENCLR_TRIGGERED11() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x800) >> 11
}
func (o *EGU_Type) SetINTENCLR_TRIGGERED12(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x1000)|value<<12)
}
func (o *EGU_Type) GetINTENCLR_TRIGGERED12() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x1000) >> 12
}
func (o *EGU_Type) SetINTENCLR_TRIGGERED13(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x2000)|value<<13)
}
func (o *EGU_Type) GetINTENCLR_TRIGGERED13() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x2000) >> 13
}
func (o *EGU_Type) SetINTENCLR_TRIGGERED14(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x4000)|value<<14)
}
func (o *EGU_Type) GetINTENCLR_TRIGGERED14() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x4000) >> 14
}
func (o *EGU_Type) SetINTENCLR_TRIGGERED15(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x8000)|value<<15)
}
func (o *EGU_Type) GetINTENCLR_TRIGGERED15() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x8000) >> 15
}

// Software interrupt 0
type SWI_Type struct {
	UNUSED volatile.Register32 // 0x0
}

// MUTEX 0
type MUTEX_Type struct {
	_     [1024]byte
	MUTEX [16]volatile.Register32 // 0x400
}

// MUTEX.MUTEX: Description collection: Mutex register
func (o *MUTEX_Type) SetMUTEX(idx int, value uint32) {
	volatile.StoreUint32(&o.MUTEX[idx].Reg, volatile.LoadUint32(&o.MUTEX[idx].Reg)&^(0x1)|value)
}
func (o *MUTEX_Type) GetMUTEX(idx int) uint32 {
	return volatile.LoadUint32(&o.MUTEX[idx].Reg) & 0x1
}

// Access control lists
type ACL_Type struct {
	_   [2048]byte
	ACL [8]ACL_ACL_Type // 0x800
}

// Unspecified
type ACL_ACL_Type struct {
	ADDR volatile.Register32 // 0x800
	SIZE volatile.Register32 // 0x804
	PERM volatile.Register32 // 0x808
	_    [4]byte
}

// ACL_ACL.ADDR: Description cluster: Configure the word-aligned start address of region n to protect
func (o *ACL_ACL_Type) SetADDR(value uint32) {
	volatile.StoreUint32(&o.ADDR.Reg, value)
}
func (o *ACL_ACL_Type) GetADDR() uint32 {
	return volatile.LoadUint32(&o.ADDR.Reg)
}

// ACL_ACL.SIZE: Description cluster: Size of region to protect counting from address ACL[n].ADDR. Write '0' as no effect.
func (o *ACL_ACL_Type) SetSIZE(value uint32) {
	volatile.StoreUint32(&o.SIZE.Reg, value)
}
func (o *ACL_ACL_Type) GetSIZE() uint32 {
	return volatile.LoadUint32(&o.SIZE.Reg)
}

// ACL_ACL.PERM: Description cluster: Access permissions for region n as defined by start address ACL[n].ADDR and size ACL[n].SIZE
func (o *ACL_ACL_Type) SetPERM_WRITE(value uint32) {
	volatile.StoreUint32(&o.PERM.Reg, volatile.LoadUint32(&o.PERM.Reg)&^(0x2)|value<<1)
}
func (o *ACL_ACL_Type) GetPERM_WRITE() uint32 {
	return (volatile.LoadUint32(&o.PERM.Reg) & 0x2) >> 1
}
func (o *ACL_ACL_Type) SetPERM_READ(value uint32) {
	volatile.StoreUint32(&o.PERM.Reg, volatile.LoadUint32(&o.PERM.Reg)&^(0x4)|value<<2)
}
func (o *ACL_ACL_Type) GetPERM_READ() uint32 {
	return (volatile.LoadUint32(&o.PERM.Reg) & 0x4) >> 2
}

// Non-volatile memory controller
type NVMC_Type struct {
	_                   [1024]byte
	READY               volatile.Register32 // 0x400
	_                   [4]byte
	READYNEXT           volatile.Register32 // 0x408
	_                   [248]byte
	CONFIG              volatile.Register32 // 0x504
	_                   [4]byte
	ERASEALL            volatile.Register32 // 0x50C
	_                   [12]byte
	ERASEPAGEPARTIALCFG volatile.Register32 // 0x51C
	_                   [32]byte
	ICACHECNF           volatile.Register32 // 0x540
	_                   [4]byte
	IHIT                volatile.Register32 // 0x548
	IMISS               volatile.Register32 // 0x54C
}

// NVMC.READY: Ready flag
func (o *NVMC_Type) SetREADY(value uint32) {
	volatile.StoreUint32(&o.READY.Reg, volatile.LoadUint32(&o.READY.Reg)&^(0x1)|value)
}
func (o *NVMC_Type) GetREADY() uint32 {
	return volatile.LoadUint32(&o.READY.Reg) & 0x1
}

// NVMC.READYNEXT: Ready flag
func (o *NVMC_Type) SetREADYNEXT(value uint32) {
	volatile.StoreUint32(&o.READYNEXT.Reg, volatile.LoadUint32(&o.READYNEXT.Reg)&^(0x1)|value)
}
func (o *NVMC_Type) GetREADYNEXT() uint32 {
	return volatile.LoadUint32(&o.READYNEXT.Reg) & 0x1
}

// NVMC.CONFIG: Configuration register
func (o *NVMC_Type) SetCONFIG_WEN(value uint32) {
	volatile.StoreUint32(&o.CONFIG.Reg, volatile.LoadUint32(&o.CONFIG.Reg)&^(0x7)|value)
}
func (o *NVMC_Type) GetCONFIG_WEN() uint32 {
	return volatile.LoadUint32(&o.CONFIG.Reg) & 0x7
}

// NVMC.ERASEALL: Register for erasing all non-volatile user memory
func (o *NVMC_Type) SetERASEALL(value uint32) {
	volatile.StoreUint32(&o.ERASEALL.Reg, volatile.LoadUint32(&o.ERASEALL.Reg)&^(0x1)|value)
}
func (o *NVMC_Type) GetERASEALL() uint32 {
	return volatile.LoadUint32(&o.ERASEALL.Reg) & 0x1
}

// NVMC.ERASEPAGEPARTIALCFG: Register for partial erase configuration
func (o *NVMC_Type) SetERASEPAGEPARTIALCFG_DURATION(value uint32) {
	volatile.StoreUint32(&o.ERASEPAGEPARTIALCFG.Reg, volatile.LoadUint32(&o.ERASEPAGEPARTIALCFG.Reg)&^(0x7f)|value)
}
func (o *NVMC_Type) GetERASEPAGEPARTIALCFG_DURATION() uint32 {
	return volatile.LoadUint32(&o.ERASEPAGEPARTIALCFG.Reg) & 0x7f
}

// NVMC.ICACHECNF: I-code cache configuration register
func (o *NVMC_Type) SetICACHECNF_CACHEEN(value uint32) {
	volatile.StoreUint32(&o.ICACHECNF.Reg, volatile.LoadUint32(&o.ICACHECNF.Reg)&^(0x1)|value)
}
func (o *NVMC_Type) GetICACHECNF_CACHEEN() uint32 {
	return volatile.LoadUint32(&o.ICACHECNF.Reg) & 0x1
}
func (o *NVMC_Type) SetICACHECNF_CACHEPROFEN(value uint32) {
	volatile.StoreUint32(&o.ICACHECNF.Reg, volatile.LoadUint32(&o.ICACHECNF.Reg)&^(0x100)|value<<8)
}
func (o *NVMC_Type) GetICACHECNF_CACHEPROFEN() uint32 {
	return (volatile.LoadUint32(&o.ICACHECNF.Reg) & 0x100) >> 8
}

// NVMC.IHIT: I-code cache hit counter
func (o *NVMC_Type) SetIHIT(value uint32) {
	volatile.StoreUint32(&o.IHIT.Reg, value)
}
func (o *NVMC_Type) GetIHIT() uint32 {
	return volatile.LoadUint32(&o.IHIT.Reg)
}

// NVMC.IMISS: I-code cache miss counter
func (o *NVMC_Type) SetIMISS(value uint32) {
	volatile.StoreUint32(&o.IMISS.Reg, value)
}
func (o *NVMC_Type) GetIMISS() uint32 {
	return volatile.LoadUint32(&o.IMISS.Reg)
}

// Volatile Memory controller
type VMC_Type struct {
	_   [1536]byte
	RAM [4]VMC_RAM_Type // 0x600
}

// Unspecified
type VMC_RAM_Type struct {
	POWER    volatile.Register32 // 0x600
	POWERSET volatile.Register32 // 0x604
	POWERCLR volatile.Register32 // 0x608
	_        [4]byte
}

// VMC_RAM.POWER: Description cluster: RAM[n] power control register
func (o *VMC_RAM_Type) SetPOWER_S0POWER(value uint32) {
	volatile.StoreUint32(&o.POWER.Reg, volatile.LoadUint32(&o.POWER.Reg)&^(0x1)|value)
}
func (o *VMC_RAM_Type) GetPOWER_S0POWER() uint32 {
	return volatile.LoadUint32(&o.POWER.Reg) & 0x1
}
func (o *VMC_RAM_Type) SetPOWER_S1POWER(value uint32) {
	volatile.StoreUint32(&o.POWER.Reg, volatile.LoadUint32(&o.POWER.Reg)&^(0x2)|value<<1)
}
func (o *VMC_RAM_Type) GetPOWER_S1POWER() uint32 {
	return (volatile.LoadUint32(&o.POWER.Reg) & 0x2) >> 1
}
func (o *VMC_RAM_Type) SetPOWER_S2POWER(value uint32) {
	volatile.StoreUint32(&o.POWER.Reg, volatile.LoadUint32(&o.POWER.Reg)&^(0x4)|value<<2)
}
func (o *VMC_RAM_Type) GetPOWER_S2POWER() uint32 {
	return (volatile.LoadUint32(&o.POWER.Reg) & 0x4) >> 2
}
func (o *VMC_RAM_Type) SetPOWER_S3POWER(value uint32) {
	volatile.StoreUint32(&o.POWER.Reg, volatile.LoadUint32(&o.POWER.Reg)&^(0x8)|value<<3)
}
func (o *VMC_RAM_Type) GetPOWER_S3POWER() uint32 {
	return (volatile.LoadUint32(&o.POWER.Reg) & 0x8) >> 3
}
func (o *VMC_RAM_Type) SetPOWER_S0RETENTION(value uint32) {
	volatile.StoreUint32(&o.POWER.Reg, volatile.LoadUint32(&o.POWER.Reg)&^(0x10000)|value<<16)
}
func (o *VMC_RAM_Type) GetPOWER_S0RETENTION() uint32 {
	return (volatile.LoadUint32(&o.POWER.Reg) & 0x10000) >> 16
}
func (o *VMC_RAM_Type) SetPOWER_S1RETENTION(value uint32) {
	volatile.StoreUint32(&o.POWER.Reg, volatile.LoadUint32(&o.POWER.Reg)&^(0x20000)|value<<17)
}
func (o *VMC_RAM_Type) GetPOWER_S1RETENTION() uint32 {
	return (volatile.LoadUint32(&o.POWER.Reg) & 0x20000) >> 17
}
func (o *VMC_RAM_Type) SetPOWER_S2RETENTION(value uint32) {
	volatile.StoreUint32(&o.POWER.Reg, volatile.LoadUint32(&o.POWER.Reg)&^(0x40000)|value<<18)
}
func (o *VMC_RAM_Type) GetPOWER_S2RETENTION() uint32 {
	return (volatile.LoadUint32(&o.POWER.Reg) & 0x40000) >> 18
}
func (o *VMC_RAM_Type) SetPOWER_S3RETENTION(value uint32) {
	volatile.StoreUint32(&o.POWER.Reg, volatile.LoadUint32(&o.POWER.Reg)&^(0x80000)|value<<19)
}
func (o *VMC_RAM_Type) GetPOWER_S3RETENTION() uint32 {
	return (volatile.LoadUint32(&o.POWER.Reg) & 0x80000) >> 19
}

// VMC_RAM.POWERSET: Description cluster: RAM[n] power control set register
func (o *VMC_RAM_Type) SetPOWERSET_S0POWER(value uint32) {
	volatile.StoreUint32(&o.POWERSET.Reg, volatile.LoadUint32(&o.POWERSET.Reg)&^(0x1)|value)
}
func (o *VMC_RAM_Type) GetPOWERSET_S0POWER() uint32 {
	return volatile.LoadUint32(&o.POWERSET.Reg) & 0x1
}
func (o *VMC_RAM_Type) SetPOWERSET_S1POWER(value uint32) {
	volatile.StoreUint32(&o.POWERSET.Reg, volatile.LoadUint32(&o.POWERSET.Reg)&^(0x2)|value<<1)
}
func (o *VMC_RAM_Type) GetPOWERSET_S1POWER() uint32 {
	return (volatile.LoadUint32(&o.POWERSET.Reg) & 0x2) >> 1
}
func (o *VMC_RAM_Type) SetPOWERSET_S2POWER(value uint32) {
	volatile.StoreUint32(&o.POWERSET.Reg, volatile.LoadUint32(&o.POWERSET.Reg)&^(0x4)|value<<2)
}
func (o *VMC_RAM_Type) GetPOWERSET_S2POWER() uint32 {
	return (volatile.LoadUint32(&o.POWERSET.Reg) & 0x4) >> 2
}
func (o *VMC_RAM_Type) SetPOWERSET_S3POWER(value uint32) {
	volatile.StoreUint32(&o.POWERSET.Reg, volatile.LoadUint32(&o.POWERSET.Reg)&^(0x8)|value<<3)
}
func (o *VMC_RAM_Type) GetPOWERSET_S3POWER() uint32 {
	return (volatile.LoadUint32(&o.POWERSET.Reg) & 0x8) >> 3
}
func (o *VMC_RAM_Type) SetPOWERSET_S0RETENTION(value uint32) {
	volatile.StoreUint32(&o.POWERSET.Reg, volatile.LoadUint32(&o.POWERSET.Reg)&^(0x10000)|value<<16)
}
func (o *VMC_RAM_Type) GetPOWERSET_S0RETENTION() uint32 {
	return (volatile.LoadUint32(&o.POWERSET.Reg) & 0x10000) >> 16
}
func (o *VMC_RAM_Type) SetPOWERSET_S1RETENTION(value uint32) {
	volatile.StoreUint32(&o.POWERSET.Reg, volatile.LoadUint32(&o.POWERSET.Reg)&^(0x20000)|value<<17)
}
func (o *VMC_RAM_Type) GetPOWERSET_S1RETENTION() uint32 {
	return (volatile.LoadUint32(&o.POWERSET.Reg) & 0x20000) >> 17
}
func (o *VMC_RAM_Type) SetPOWERSET_S2RETENTION(value uint32) {
	volatile.StoreUint32(&o.POWERSET.Reg, volatile.LoadUint32(&o.POWERSET.Reg)&^(0x40000)|value<<18)
}
func (o *VMC_RAM_Type) GetPOWERSET_S2RETENTION() uint32 {
	return (volatile.LoadUint32(&o.POWERSET.Reg) & 0x40000) >> 18
}
func (o *VMC_RAM_Type) SetPOWERSET_S3RETENTION(value uint32) {
	volatile.StoreUint32(&o.POWERSET.Reg, volatile.LoadUint32(&o.POWERSET.Reg)&^(0x80000)|value<<19)
}
func (o *VMC_RAM_Type) GetPOWERSET_S3RETENTION() uint32 {
	return (volatile.LoadUint32(&o.POWERSET.Reg) & 0x80000) >> 19
}

// VMC_RAM.POWERCLR: Description cluster: RAM[n] power control clear register
func (o *VMC_RAM_Type) SetPOWERCLR_S0POWER(value uint32) {
	volatile.StoreUint32(&o.POWERCLR.Reg, volatile.LoadUint32(&o.POWERCLR.Reg)&^(0x1)|value)
}
func (o *VMC_RAM_Type) GetPOWERCLR_S0POWER() uint32 {
	return volatile.LoadUint32(&o.POWERCLR.Reg) & 0x1
}
func (o *VMC_RAM_Type) SetPOWERCLR_S1POWER(value uint32) {
	volatile.StoreUint32(&o.POWERCLR.Reg, volatile.LoadUint32(&o.POWERCLR.Reg)&^(0x2)|value<<1)
}
func (o *VMC_RAM_Type) GetPOWERCLR_S1POWER() uint32 {
	return (volatile.LoadUint32(&o.POWERCLR.Reg) & 0x2) >> 1
}
func (o *VMC_RAM_Type) SetPOWERCLR_S2POWER(value uint32) {
	volatile.StoreUint32(&o.POWERCLR.Reg, volatile.LoadUint32(&o.POWERCLR.Reg)&^(0x4)|value<<2)
}
func (o *VMC_RAM_Type) GetPOWERCLR_S2POWER() uint32 {
	return (volatile.LoadUint32(&o.POWERCLR.Reg) & 0x4) >> 2
}
func (o *VMC_RAM_Type) SetPOWERCLR_S3POWER(value uint32) {
	volatile.StoreUint32(&o.POWERCLR.Reg, volatile.LoadUint32(&o.POWERCLR.Reg)&^(0x8)|value<<3)
}
func (o *VMC_RAM_Type) GetPOWERCLR_S3POWER() uint32 {
	return (volatile.LoadUint32(&o.POWERCLR.Reg) & 0x8) >> 3
}
func (o *VMC_RAM_Type) SetPOWERCLR_S0RETENTION(value uint32) {
	volatile.StoreUint32(&o.POWERCLR.Reg, volatile.LoadUint32(&o.POWERCLR.Reg)&^(0x10000)|value<<16)
}
func (o *VMC_RAM_Type) GetPOWERCLR_S0RETENTION() uint32 {
	return (volatile.LoadUint32(&o.POWERCLR.Reg) & 0x10000) >> 16
}
func (o *VMC_RAM_Type) SetPOWERCLR_S1RETENTION(value uint32) {
	volatile.StoreUint32(&o.POWERCLR.Reg, volatile.LoadUint32(&o.POWERCLR.Reg)&^(0x20000)|value<<17)
}
func (o *VMC_RAM_Type) GetPOWERCLR_S1RETENTION() uint32 {
	return (volatile.LoadUint32(&o.POWERCLR.Reg) & 0x20000) >> 17
}
func (o *VMC_RAM_Type) SetPOWERCLR_S2RETENTION(value uint32) {
	volatile.StoreUint32(&o.POWERCLR.Reg, volatile.LoadUint32(&o.POWERCLR.Reg)&^(0x40000)|value<<18)
}
func (o *VMC_RAM_Type) GetPOWERCLR_S2RETENTION() uint32 {
	return (volatile.LoadUint32(&o.POWERCLR.Reg) & 0x40000) >> 18
}
func (o *VMC_RAM_Type) SetPOWERCLR_S3RETENTION(value uint32) {
	volatile.StoreUint32(&o.POWERCLR.Reg, volatile.LoadUint32(&o.POWERCLR.Reg)&^(0x80000)|value<<19)
}
func (o *VMC_RAM_Type) GetPOWERCLR_S3RETENTION() uint32 {
	return (volatile.LoadUint32(&o.POWERCLR.Reg) & 0x80000) >> 19
}

// GPIO Port 0
type GPIO_Type struct {
	_              [4]byte
	OUT            volatile.Register32 // 0x4
	OUTSET         volatile.Register32 // 0x8
	OUTCLR         volatile.Register32 // 0xC
	IN             volatile.Register32 // 0x10
	DIR            volatile.Register32 // 0x14
	DIRSET         volatile.Register32 // 0x18
	DIRCLR         volatile.Register32 // 0x1C
	LATCH          volatile.Register32 // 0x20
	DETECTMODE     volatile.Register32 // 0x24
	DETECTMODE_SEC volatile.Register32 // 0x28
	_              [468]byte
	PIN_CNF        [32]volatile.Register32 // 0x200
}

// GPIO.OUT: Write GPIO port
func (o *GPIO_Type) SetOUT_PIN0(value uint32) {
	volatile.StoreUint32(&o.OUT.Reg, volatile.LoadUint32(&o.OUT.Reg)&^(0x1)|value)
}
func (o *GPIO_Type) GetOUT_PIN0() uint32 {
	return volatile.LoadUint32(&o.OUT.Reg) & 0x1
}
func (o *GPIO_Type) SetOUT_PIN1(value uint32) {
	volatile.StoreUint32(&o.OUT.Reg, volatile.LoadUint32(&o.OUT.Reg)&^(0x2)|value<<1)
}
func (o *GPIO_Type) GetOUT_PIN1() uint32 {
	return (volatile.LoadUint32(&o.OUT.Reg) & 0x2) >> 1
}
func (o *GPIO_Type) SetOUT_PIN2(value uint32) {
	volatile.StoreUint32(&o.OUT.Reg, volatile.LoadUint32(&o.OUT.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetOUT_PIN2() uint32 {
	return (volatile.LoadUint32(&o.OUT.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetOUT_PIN3(value uint32) {
	volatile.StoreUint32(&o.OUT.Reg, volatile.LoadUint32(&o.OUT.Reg)&^(0x8)|value<<3)
}
func (o *GPIO_Type) GetOUT_PIN3() uint32 {
	return (volatile.LoadUint32(&o.OUT.Reg) & 0x8) >> 3
}
func (o *GPIO_Type) SetOUT_PIN4(value uint32) {
	volatile.StoreUint32(&o.OUT.Reg, volatile.LoadUint32(&o.OUT.Reg)&^(0x10)|value<<4)
}
func (o *GPIO_Type) GetOUT_PIN4() uint32 {
	return (volatile.LoadUint32(&o.OUT.Reg) & 0x10) >> 4
}
func (o *GPIO_Type) SetOUT_PIN5(value uint32) {
	volatile.StoreUint32(&o.OUT.Reg, volatile.LoadUint32(&o.OUT.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetOUT_PIN5() uint32 {
	return (volatile.LoadUint32(&o.OUT.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetOUT_PIN6(value uint32) {
	volatile.StoreUint32(&o.OUT.Reg, volatile.LoadUint32(&o.OUT.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetOUT_PIN6() uint32 {
	return (volatile.LoadUint32(&o.OUT.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetOUT_PIN7(value uint32) {
	volatile.StoreUint32(&o.OUT.Reg, volatile.LoadUint32(&o.OUT.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetOUT_PIN7() uint32 {
	return (volatile.LoadUint32(&o.OUT.Reg) & 0x80) >> 7
}
func (o *GPIO_Type) SetOUT_PIN8(value uint32) {
	volatile.StoreUint32(&o.OUT.Reg, volatile.LoadUint32(&o.OUT.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetOUT_PIN8() uint32 {
	return (volatile.LoadUint32(&o.OUT.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetOUT_PIN9(value uint32) {
	volatile.StoreUint32(&o.OUT.Reg, volatile.LoadUint32(&o.OUT.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetOUT_PIN9() uint32 {
	return (volatile.LoadUint32(&o.OUT.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetOUT_PIN10(value uint32) {
	volatile.StoreUint32(&o.OUT.Reg, volatile.LoadUint32(&o.OUT.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetOUT_PIN10() uint32 {
	return (volatile.LoadUint32(&o.OUT.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetOUT_PIN11(value uint32) {
	volatile.StoreUint32(&o.OUT.Reg, volatile.LoadUint32(&o.OUT.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetOUT_PIN11() uint32 {
	return (volatile.LoadUint32(&o.OUT.Reg) & 0x800) >> 11
}
func (o *GPIO_Type) SetOUT_PIN12(value uint32) {
	volatile.StoreUint32(&o.OUT.Reg, volatile.LoadUint32(&o.OUT.Reg)&^(0x1000)|value<<12)
}
func (o *GPIO_Type) GetOUT_PIN12() uint32 {
	return (volatile.LoadUint32(&o.OUT.Reg) & 0x1000) >> 12
}
func (o *GPIO_Type) SetOUT_PIN13(value uint32) {
	volatile.StoreUint32(&o.OUT.Reg, volatile.LoadUint32(&o.OUT.Reg)&^(0x2000)|value<<13)
}
func (o *GPIO_Type) GetOUT_PIN13() uint32 {
	return (volatile.LoadUint32(&o.OUT.Reg) & 0x2000) >> 13
}
func (o *GPIO_Type) SetOUT_PIN14(value uint32) {
	volatile.StoreUint32(&o.OUT.Reg, volatile.LoadUint32(&o.OUT.Reg)&^(0x4000)|value<<14)
}
func (o *GPIO_Type) GetOUT_PIN14() uint32 {
	return (volatile.LoadUint32(&o.OUT.Reg) & 0x4000) >> 14
}
func (o *GPIO_Type) SetOUT_PIN15(value uint32) {
	volatile.StoreUint32(&o.OUT.Reg, volatile.LoadUint32(&o.OUT.Reg)&^(0x8000)|value<<15)
}
func (o *GPIO_Type) GetOUT_PIN15() uint32 {
	return (volatile.LoadUint32(&o.OUT.Reg) & 0x8000) >> 15
}
func (o *GPIO_Type) SetOUT_PIN16(value uint32) {
	volatile.StoreUint32(&o.OUT.Reg, volatile.LoadUint32(&o.OUT.Reg)&^(0x10000)|value<<16)
}
func (o *GPIO_Type) GetOUT_PIN16() uint32 {
	return (volatile.LoadUint32(&o.OUT.Reg) & 0x10000) >> 16
}
func (o *GPIO_Type) SetOUT_PIN17(value uint32) {
	volatile.StoreUint32(&o.OUT.Reg, volatile.LoadUint32(&o.OUT.Reg)&^(0x20000)|value<<17)
}
func (o *GPIO_Type) GetOUT_PIN17() uint32 {
	return (volatile.LoadUint32(&o.OUT.Reg) & 0x20000) >> 17
}
func (o *GPIO_Type) SetOUT_PIN18(value uint32) {
	volatile.StoreUint32(&o.OUT.Reg, volatile.LoadUint32(&o.OUT.Reg)&^(0x40000)|value<<18)
}
func (o *GPIO_Type) GetOUT_PIN18() uint32 {
	return (volatile.LoadUint32(&o.OUT.Reg) & 0x40000) >> 18
}
func (o *GPIO_Type) SetOUT_PIN19(value uint32) {
	volatile.StoreUint32(&o.OUT.Reg, volatile.LoadUint32(&o.OUT.Reg)&^(0x80000)|value<<19)
}
func (o *GPIO_Type) GetOUT_PIN19() uint32 {
	return (volatile.LoadUint32(&o.OUT.Reg) & 0x80000) >> 19
}
func (o *GPIO_Type) SetOUT_PIN20(value uint32) {
	volatile.StoreUint32(&o.OUT.Reg, volatile.LoadUint32(&o.OUT.Reg)&^(0x100000)|value<<20)
}
func (o *GPIO_Type) GetOUT_PIN20() uint32 {
	return (volatile.LoadUint32(&o.OUT.Reg) & 0x100000) >> 20
}
func (o *GPIO_Type) SetOUT_PIN21(value uint32) {
	volatile.StoreUint32(&o.OUT.Reg, volatile.LoadUint32(&o.OUT.Reg)&^(0x200000)|value<<21)
}
func (o *GPIO_Type) GetOUT_PIN21() uint32 {
	return (volatile.LoadUint32(&o.OUT.Reg) & 0x200000) >> 21
}
func (o *GPIO_Type) SetOUT_PIN22(value uint32) {
	volatile.StoreUint32(&o.OUT.Reg, volatile.LoadUint32(&o.OUT.Reg)&^(0x400000)|value<<22)
}
func (o *GPIO_Type) GetOUT_PIN22() uint32 {
	return (volatile.LoadUint32(&o.OUT.Reg) & 0x400000) >> 22
}
func (o *GPIO_Type) SetOUT_PIN23(value uint32) {
	volatile.StoreUint32(&o.OUT.Reg, volatile.LoadUint32(&o.OUT.Reg)&^(0x800000)|value<<23)
}
func (o *GPIO_Type) GetOUT_PIN23() uint32 {
	return (volatile.LoadUint32(&o.OUT.Reg) & 0x800000) >> 23
}
func (o *GPIO_Type) SetOUT_PIN24(value uint32) {
	volatile.StoreUint32(&o.OUT.Reg, volatile.LoadUint32(&o.OUT.Reg)&^(0x1000000)|value<<24)
}
func (o *GPIO_Type) GetOUT_PIN24() uint32 {
	return (volatile.LoadUint32(&o.OUT.Reg) & 0x1000000) >> 24
}
func (o *GPIO_Type) SetOUT_PIN25(value uint32) {
	volatile.StoreUint32(&o.OUT.Reg, volatile.LoadUint32(&o.OUT.Reg)&^(0x2000000)|value<<25)
}
func (o *GPIO_Type) GetOUT_PIN25() uint32 {
	return (volatile.LoadUint32(&o.OUT.Reg) & 0x2000000) >> 25
}
func (o *GPIO_Type) SetOUT_PIN26(value uint32) {
	volatile.StoreUint32(&o.OUT.Reg, volatile.LoadUint32(&o.OUT.Reg)&^(0x4000000)|value<<26)
}
func (o *GPIO_Type) GetOUT_PIN26() uint32 {
	return (volatile.LoadUint32(&o.OUT.Reg) & 0x4000000) >> 26
}
func (o *GPIO_Type) SetOUT_PIN27(value uint32) {
	volatile.StoreUint32(&o.OUT.Reg, volatile.LoadUint32(&o.OUT.Reg)&^(0x8000000)|value<<27)
}
func (o *GPIO_Type) GetOUT_PIN27() uint32 {
	return (volatile.LoadUint32(&o.OUT.Reg) & 0x8000000) >> 27
}
func (o *GPIO_Type) SetOUT_PIN28(value uint32) {
	volatile.StoreUint32(&o.OUT.Reg, volatile.LoadUint32(&o.OUT.Reg)&^(0x10000000)|value<<28)
}
func (o *GPIO_Type) GetOUT_PIN28() uint32 {
	return (volatile.LoadUint32(&o.OUT.Reg) & 0x10000000) >> 28
}
func (o *GPIO_Type) SetOUT_PIN29(value uint32) {
	volatile.StoreUint32(&o.OUT.Reg, volatile.LoadUint32(&o.OUT.Reg)&^(0x20000000)|value<<29)
}
func (o *GPIO_Type) GetOUT_PIN29() uint32 {
	return (volatile.LoadUint32(&o.OUT.Reg) & 0x20000000) >> 29
}
func (o *GPIO_Type) SetOUT_PIN30(value uint32) {
	volatile.StoreUint32(&o.OUT.Reg, volatile.LoadUint32(&o.OUT.Reg)&^(0x40000000)|value<<30)
}
func (o *GPIO_Type) GetOUT_PIN30() uint32 {
	return (volatile.LoadUint32(&o.OUT.Reg) & 0x40000000) >> 30
}
func (o *GPIO_Type) SetOUT_PIN31(value uint32) {
	volatile.StoreUint32(&o.OUT.Reg, volatile.LoadUint32(&o.OUT.Reg)&^(0x80000000)|value<<31)
}
func (o *GPIO_Type) GetOUT_PIN31() uint32 {
	return (volatile.LoadUint32(&o.OUT.Reg) & 0x80000000) >> 31
}

// GPIO.OUTSET: Set individual bits in GPIO port
func (o *GPIO_Type) SetOUTSET_PIN0(value uint32) {
	volatile.StoreUint32(&o.OUTSET.Reg, volatile.LoadUint32(&o.OUTSET.Reg)&^(0x1)|value)
}
func (o *GPIO_Type) GetOUTSET_PIN0() uint32 {
	return volatile.LoadUint32(&o.OUTSET.Reg) & 0x1
}
func (o *GPIO_Type) SetOUTSET_PIN1(value uint32) {
	volatile.StoreUint32(&o.OUTSET.Reg, volatile.LoadUint32(&o.OUTSET.Reg)&^(0x2)|value<<1)
}
func (o *GPIO_Type) GetOUTSET_PIN1() uint32 {
	return (volatile.LoadUint32(&o.OUTSET.Reg) & 0x2) >> 1
}
func (o *GPIO_Type) SetOUTSET_PIN2(value uint32) {
	volatile.StoreUint32(&o.OUTSET.Reg, volatile.LoadUint32(&o.OUTSET.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetOUTSET_PIN2() uint32 {
	return (volatile.LoadUint32(&o.OUTSET.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetOUTSET_PIN3(value uint32) {
	volatile.StoreUint32(&o.OUTSET.Reg, volatile.LoadUint32(&o.OUTSET.Reg)&^(0x8)|value<<3)
}
func (o *GPIO_Type) GetOUTSET_PIN3() uint32 {
	return (volatile.LoadUint32(&o.OUTSET.Reg) & 0x8) >> 3
}
func (o *GPIO_Type) SetOUTSET_PIN4(value uint32) {
	volatile.StoreUint32(&o.OUTSET.Reg, volatile.LoadUint32(&o.OUTSET.Reg)&^(0x10)|value<<4)
}
func (o *GPIO_Type) GetOUTSET_PIN4() uint32 {
	return (volatile.LoadUint32(&o.OUTSET.Reg) & 0x10) >> 4
}
func (o *GPIO_Type) SetOUTSET_PIN5(value uint32) {
	volatile.StoreUint32(&o.OUTSET.Reg, volatile.LoadUint32(&o.OUTSET.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetOUTSET_PIN5() uint32 {
	return (volatile.LoadUint32(&o.OUTSET.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetOUTSET_PIN6(value uint32) {
	volatile.StoreUint32(&o.OUTSET.Reg, volatile.LoadUint32(&o.OUTSET.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetOUTSET_PIN6() uint32 {
	return (volatile.LoadUint32(&o.OUTSET.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetOUTSET_PIN7(value uint32) {
	volatile.StoreUint32(&o.OUTSET.Reg, volatile.LoadUint32(&o.OUTSET.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetOUTSET_PIN7() uint32 {
	return (volatile.LoadUint32(&o.OUTSET.Reg) & 0x80) >> 7
}
func (o *GPIO_Type) SetOUTSET_PIN8(value uint32) {
	volatile.StoreUint32(&o.OUTSET.Reg, volatile.LoadUint32(&o.OUTSET.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetOUTSET_PIN8() uint32 {
	return (volatile.LoadUint32(&o.OUTSET.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetOUTSET_PIN9(value uint32) {
	volatile.StoreUint32(&o.OUTSET.Reg, volatile.LoadUint32(&o.OUTSET.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetOUTSET_PIN9() uint32 {
	return (volatile.LoadUint32(&o.OUTSET.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetOUTSET_PIN10(value uint32) {
	volatile.StoreUint32(&o.OUTSET.Reg, volatile.LoadUint32(&o.OUTSET.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetOUTSET_PIN10() uint32 {
	return (volatile.LoadUint32(&o.OUTSET.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetOUTSET_PIN11(value uint32) {
	volatile.StoreUint32(&o.OUTSET.Reg, volatile.LoadUint32(&o.OUTSET.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetOUTSET_PIN11() uint32 {
	return (volatile.LoadUint32(&o.OUTSET.Reg) & 0x800) >> 11
}
func (o *GPIO_Type) SetOUTSET_PIN12(value uint32) {
	volatile.StoreUint32(&o.OUTSET.Reg, volatile.LoadUint32(&o.OUTSET.Reg)&^(0x1000)|value<<12)
}
func (o *GPIO_Type) GetOUTSET_PIN12() uint32 {
	return (volatile.LoadUint32(&o.OUTSET.Reg) & 0x1000) >> 12
}
func (o *GPIO_Type) SetOUTSET_PIN13(value uint32) {
	volatile.StoreUint32(&o.OUTSET.Reg, volatile.LoadUint32(&o.OUTSET.Reg)&^(0x2000)|value<<13)
}
func (o *GPIO_Type) GetOUTSET_PIN13() uint32 {
	return (volatile.LoadUint32(&o.OUTSET.Reg) & 0x2000) >> 13
}
func (o *GPIO_Type) SetOUTSET_PIN14(value uint32) {
	volatile.StoreUint32(&o.OUTSET.Reg, volatile.LoadUint32(&o.OUTSET.Reg)&^(0x4000)|value<<14)
}
func (o *GPIO_Type) GetOUTSET_PIN14() uint32 {
	return (volatile.LoadUint32(&o.OUTSET.Reg) & 0x4000) >> 14
}
func (o *GPIO_Type) SetOUTSET_PIN15(value uint32) {
	volatile.StoreUint32(&o.OUTSET.Reg, volatile.LoadUint32(&o.OUTSET.Reg)&^(0x8000)|value<<15)
}
func (o *GPIO_Type) GetOUTSET_PIN15() uint32 {
	return (volatile.LoadUint32(&o.OUTSET.Reg) & 0x8000) >> 15
}
func (o *GPIO_Type) SetOUTSET_PIN16(value uint32) {
	volatile.StoreUint32(&o.OUTSET.Reg, volatile.LoadUint32(&o.OUTSET.Reg)&^(0x10000)|value<<16)
}
func (o *GPIO_Type) GetOUTSET_PIN16() uint32 {
	return (volatile.LoadUint32(&o.OUTSET.Reg) & 0x10000) >> 16
}
func (o *GPIO_Type) SetOUTSET_PIN17(value uint32) {
	volatile.StoreUint32(&o.OUTSET.Reg, volatile.LoadUint32(&o.OUTSET.Reg)&^(0x20000)|value<<17)
}
func (o *GPIO_Type) GetOUTSET_PIN17() uint32 {
	return (volatile.LoadUint32(&o.OUTSET.Reg) & 0x20000) >> 17
}
func (o *GPIO_Type) SetOUTSET_PIN18(value uint32) {
	volatile.StoreUint32(&o.OUTSET.Reg, volatile.LoadUint32(&o.OUTSET.Reg)&^(0x40000)|value<<18)
}
func (o *GPIO_Type) GetOUTSET_PIN18() uint32 {
	return (volatile.LoadUint32(&o.OUTSET.Reg) & 0x40000) >> 18
}
func (o *GPIO_Type) SetOUTSET_PIN19(value uint32) {
	volatile.StoreUint32(&o.OUTSET.Reg, volatile.LoadUint32(&o.OUTSET.Reg)&^(0x80000)|value<<19)
}
func (o *GPIO_Type) GetOUTSET_PIN19() uint32 {
	return (volatile.LoadUint32(&o.OUTSET.Reg) & 0x80000) >> 19
}
func (o *GPIO_Type) SetOUTSET_PIN20(value uint32) {
	volatile.StoreUint32(&o.OUTSET.Reg, volatile.LoadUint32(&o.OUTSET.Reg)&^(0x100000)|value<<20)
}
func (o *GPIO_Type) GetOUTSET_PIN20() uint32 {
	return (volatile.LoadUint32(&o.OUTSET.Reg) & 0x100000) >> 20
}
func (o *GPIO_Type) SetOUTSET_PIN21(value uint32) {
	volatile.StoreUint32(&o.OUTSET.Reg, volatile.LoadUint32(&o.OUTSET.Reg)&^(0x200000)|value<<21)
}
func (o *GPIO_Type) GetOUTSET_PIN21() uint32 {
	return (volatile.LoadUint32(&o.OUTSET.Reg) & 0x200000) >> 21
}
func (o *GPIO_Type) SetOUTSET_PIN22(value uint32) {
	volatile.StoreUint32(&o.OUTSET.Reg, volatile.LoadUint32(&o.OUTSET.Reg)&^(0x400000)|value<<22)
}
func (o *GPIO_Type) GetOUTSET_PIN22() uint32 {
	return (volatile.LoadUint32(&o.OUTSET.Reg) & 0x400000) >> 22
}
func (o *GPIO_Type) SetOUTSET_PIN23(value uint32) {
	volatile.StoreUint32(&o.OUTSET.Reg, volatile.LoadUint32(&o.OUTSET.Reg)&^(0x800000)|value<<23)
}
func (o *GPIO_Type) GetOUTSET_PIN23() uint32 {
	return (volatile.LoadUint32(&o.OUTSET.Reg) & 0x800000) >> 23
}
func (o *GPIO_Type) SetOUTSET_PIN24(value uint32) {
	volatile.StoreUint32(&o.OUTSET.Reg, volatile.LoadUint32(&o.OUTSET.Reg)&^(0x1000000)|value<<24)
}
func (o *GPIO_Type) GetOUTSET_PIN24() uint32 {
	return (volatile.LoadUint32(&o.OUTSET.Reg) & 0x1000000) >> 24
}
func (o *GPIO_Type) SetOUTSET_PIN25(value uint32) {
	volatile.StoreUint32(&o.OUTSET.Reg, volatile.LoadUint32(&o.OUTSET.Reg)&^(0x2000000)|value<<25)
}
func (o *GPIO_Type) GetOUTSET_PIN25() uint32 {
	return (volatile.LoadUint32(&o.OUTSET.Reg) & 0x2000000) >> 25
}
func (o *GPIO_Type) SetOUTSET_PIN26(value uint32) {
	volatile.StoreUint32(&o.OUTSET.Reg, volatile.LoadUint32(&o.OUTSET.Reg)&^(0x4000000)|value<<26)
}
func (o *GPIO_Type) GetOUTSET_PIN26() uint32 {
	return (volatile.LoadUint32(&o.OUTSET.Reg) & 0x4000000) >> 26
}
func (o *GPIO_Type) SetOUTSET_PIN27(value uint32) {
	volatile.StoreUint32(&o.OUTSET.Reg, volatile.LoadUint32(&o.OUTSET.Reg)&^(0x8000000)|value<<27)
}
func (o *GPIO_Type) GetOUTSET_PIN27() uint32 {
	return (volatile.LoadUint32(&o.OUTSET.Reg) & 0x8000000) >> 27
}
func (o *GPIO_Type) SetOUTSET_PIN28(value uint32) {
	volatile.StoreUint32(&o.OUTSET.Reg, volatile.LoadUint32(&o.OUTSET.Reg)&^(0x10000000)|value<<28)
}
func (o *GPIO_Type) GetOUTSET_PIN28() uint32 {
	return (volatile.LoadUint32(&o.OUTSET.Reg) & 0x10000000) >> 28
}
func (o *GPIO_Type) SetOUTSET_PIN29(value uint32) {
	volatile.StoreUint32(&o.OUTSET.Reg, volatile.LoadUint32(&o.OUTSET.Reg)&^(0x20000000)|value<<29)
}
func (o *GPIO_Type) GetOUTSET_PIN29() uint32 {
	return (volatile.LoadUint32(&o.OUTSET.Reg) & 0x20000000) >> 29
}
func (o *GPIO_Type) SetOUTSET_PIN30(value uint32) {
	volatile.StoreUint32(&o.OUTSET.Reg, volatile.LoadUint32(&o.OUTSET.Reg)&^(0x40000000)|value<<30)
}
func (o *GPIO_Type) GetOUTSET_PIN30() uint32 {
	return (volatile.LoadUint32(&o.OUTSET.Reg) & 0x40000000) >> 30
}
func (o *GPIO_Type) SetOUTSET_PIN31(value uint32) {
	volatile.StoreUint32(&o.OUTSET.Reg, volatile.LoadUint32(&o.OUTSET.Reg)&^(0x80000000)|value<<31)
}
func (o *GPIO_Type) GetOUTSET_PIN31() uint32 {
	return (volatile.LoadUint32(&o.OUTSET.Reg) & 0x80000000) >> 31
}

// GPIO.OUTCLR: Clear individual bits in GPIO port
func (o *GPIO_Type) SetOUTCLR_PIN0(value uint32) {
	volatile.StoreUint32(&o.OUTCLR.Reg, volatile.LoadUint32(&o.OUTCLR.Reg)&^(0x1)|value)
}
func (o *GPIO_Type) GetOUTCLR_PIN0() uint32 {
	return volatile.LoadUint32(&o.OUTCLR.Reg) & 0x1
}
func (o *GPIO_Type) SetOUTCLR_PIN1(value uint32) {
	volatile.StoreUint32(&o.OUTCLR.Reg, volatile.LoadUint32(&o.OUTCLR.Reg)&^(0x2)|value<<1)
}
func (o *GPIO_Type) GetOUTCLR_PIN1() uint32 {
	return (volatile.LoadUint32(&o.OUTCLR.Reg) & 0x2) >> 1
}
func (o *GPIO_Type) SetOUTCLR_PIN2(value uint32) {
	volatile.StoreUint32(&o.OUTCLR.Reg, volatile.LoadUint32(&o.OUTCLR.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetOUTCLR_PIN2() uint32 {
	return (volatile.LoadUint32(&o.OUTCLR.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetOUTCLR_PIN3(value uint32) {
	volatile.StoreUint32(&o.OUTCLR.Reg, volatile.LoadUint32(&o.OUTCLR.Reg)&^(0x8)|value<<3)
}
func (o *GPIO_Type) GetOUTCLR_PIN3() uint32 {
	return (volatile.LoadUint32(&o.OUTCLR.Reg) & 0x8) >> 3
}
func (o *GPIO_Type) SetOUTCLR_PIN4(value uint32) {
	volatile.StoreUint32(&o.OUTCLR.Reg, volatile.LoadUint32(&o.OUTCLR.Reg)&^(0x10)|value<<4)
}
func (o *GPIO_Type) GetOUTCLR_PIN4() uint32 {
	return (volatile.LoadUint32(&o.OUTCLR.Reg) & 0x10) >> 4
}
func (o *GPIO_Type) SetOUTCLR_PIN5(value uint32) {
	volatile.StoreUint32(&o.OUTCLR.Reg, volatile.LoadUint32(&o.OUTCLR.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetOUTCLR_PIN5() uint32 {
	return (volatile.LoadUint32(&o.OUTCLR.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetOUTCLR_PIN6(value uint32) {
	volatile.StoreUint32(&o.OUTCLR.Reg, volatile.LoadUint32(&o.OUTCLR.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetOUTCLR_PIN6() uint32 {
	return (volatile.LoadUint32(&o.OUTCLR.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetOUTCLR_PIN7(value uint32) {
	volatile.StoreUint32(&o.OUTCLR.Reg, volatile.LoadUint32(&o.OUTCLR.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetOUTCLR_PIN7() uint32 {
	return (volatile.LoadUint32(&o.OUTCLR.Reg) & 0x80) >> 7
}
func (o *GPIO_Type) SetOUTCLR_PIN8(value uint32) {
	volatile.StoreUint32(&o.OUTCLR.Reg, volatile.LoadUint32(&o.OUTCLR.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetOUTCLR_PIN8() uint32 {
	return (volatile.LoadUint32(&o.OUTCLR.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetOUTCLR_PIN9(value uint32) {
	volatile.StoreUint32(&o.OUTCLR.Reg, volatile.LoadUint32(&o.OUTCLR.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetOUTCLR_PIN9() uint32 {
	return (volatile.LoadUint32(&o.OUTCLR.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetOUTCLR_PIN10(value uint32) {
	volatile.StoreUint32(&o.OUTCLR.Reg, volatile.LoadUint32(&o.OUTCLR.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetOUTCLR_PIN10() uint32 {
	return (volatile.LoadUint32(&o.OUTCLR.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetOUTCLR_PIN11(value uint32) {
	volatile.StoreUint32(&o.OUTCLR.Reg, volatile.LoadUint32(&o.OUTCLR.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetOUTCLR_PIN11() uint32 {
	return (volatile.LoadUint32(&o.OUTCLR.Reg) & 0x800) >> 11
}
func (o *GPIO_Type) SetOUTCLR_PIN12(value uint32) {
	volatile.StoreUint32(&o.OUTCLR.Reg, volatile.LoadUint32(&o.OUTCLR.Reg)&^(0x1000)|value<<12)
}
func (o *GPIO_Type) GetOUTCLR_PIN12() uint32 {
	return (volatile.LoadUint32(&o.OUTCLR.Reg) & 0x1000) >> 12
}
func (o *GPIO_Type) SetOUTCLR_PIN13(value uint32) {
	volatile.StoreUint32(&o.OUTCLR.Reg, volatile.LoadUint32(&o.OUTCLR.Reg)&^(0x2000)|value<<13)
}
func (o *GPIO_Type) GetOUTCLR_PIN13() uint32 {
	return (volatile.LoadUint32(&o.OUTCLR.Reg) & 0x2000) >> 13
}
func (o *GPIO_Type) SetOUTCLR_PIN14(value uint32) {
	volatile.StoreUint32(&o.OUTCLR.Reg, volatile.LoadUint32(&o.OUTCLR.Reg)&^(0x4000)|value<<14)
}
func (o *GPIO_Type) GetOUTCLR_PIN14() uint32 {
	return (volatile.LoadUint32(&o.OUTCLR.Reg) & 0x4000) >> 14
}
func (o *GPIO_Type) SetOUTCLR_PIN15(value uint32) {
	volatile.StoreUint32(&o.OUTCLR.Reg, volatile.LoadUint32(&o.OUTCLR.Reg)&^(0x8000)|value<<15)
}
func (o *GPIO_Type) GetOUTCLR_PIN15() uint32 {
	return (volatile.LoadUint32(&o.OUTCLR.Reg) & 0x8000) >> 15
}
func (o *GPIO_Type) SetOUTCLR_PIN16(value uint32) {
	volatile.StoreUint32(&o.OUTCLR.Reg, volatile.LoadUint32(&o.OUTCLR.Reg)&^(0x10000)|value<<16)
}
func (o *GPIO_Type) GetOUTCLR_PIN16() uint32 {
	return (volatile.LoadUint32(&o.OUTCLR.Reg) & 0x10000) >> 16
}
func (o *GPIO_Type) SetOUTCLR_PIN17(value uint32) {
	volatile.StoreUint32(&o.OUTCLR.Reg, volatile.LoadUint32(&o.OUTCLR.Reg)&^(0x20000)|value<<17)
}
func (o *GPIO_Type) GetOUTCLR_PIN17() uint32 {
	return (volatile.LoadUint32(&o.OUTCLR.Reg) & 0x20000) >> 17
}
func (o *GPIO_Type) SetOUTCLR_PIN18(value uint32) {
	volatile.StoreUint32(&o.OUTCLR.Reg, volatile.LoadUint32(&o.OUTCLR.Reg)&^(0x40000)|value<<18)
}
func (o *GPIO_Type) GetOUTCLR_PIN18() uint32 {
	return (volatile.LoadUint32(&o.OUTCLR.Reg) & 0x40000) >> 18
}
func (o *GPIO_Type) SetOUTCLR_PIN19(value uint32) {
	volatile.StoreUint32(&o.OUTCLR.Reg, volatile.LoadUint32(&o.OUTCLR.Reg)&^(0x80000)|value<<19)
}
func (o *GPIO_Type) GetOUTCLR_PIN19() uint32 {
	return (volatile.LoadUint32(&o.OUTCLR.Reg) & 0x80000) >> 19
}
func (o *GPIO_Type) SetOUTCLR_PIN20(value uint32) {
	volatile.StoreUint32(&o.OUTCLR.Reg, volatile.LoadUint32(&o.OUTCLR.Reg)&^(0x100000)|value<<20)
}
func (o *GPIO_Type) GetOUTCLR_PIN20() uint32 {
	return (volatile.LoadUint32(&o.OUTCLR.Reg) & 0x100000) >> 20
}
func (o *GPIO_Type) SetOUTCLR_PIN21(value uint32) {
	volatile.StoreUint32(&o.OUTCLR.Reg, volatile.LoadUint32(&o.OUTCLR.Reg)&^(0x200000)|value<<21)
}
func (o *GPIO_Type) GetOUTCLR_PIN21() uint32 {
	return (volatile.LoadUint32(&o.OUTCLR.Reg) & 0x200000) >> 21
}
func (o *GPIO_Type) SetOUTCLR_PIN22(value uint32) {
	volatile.StoreUint32(&o.OUTCLR.Reg, volatile.LoadUint32(&o.OUTCLR.Reg)&^(0x400000)|value<<22)
}
func (o *GPIO_Type) GetOUTCLR_PIN22() uint32 {
	return (volatile.LoadUint32(&o.OUTCLR.Reg) & 0x400000) >> 22
}
func (o *GPIO_Type) SetOUTCLR_PIN23(value uint32) {
	volatile.StoreUint32(&o.OUTCLR.Reg, volatile.LoadUint32(&o.OUTCLR.Reg)&^(0x800000)|value<<23)
}
func (o *GPIO_Type) GetOUTCLR_PIN23() uint32 {
	return (volatile.LoadUint32(&o.OUTCLR.Reg) & 0x800000) >> 23
}
func (o *GPIO_Type) SetOUTCLR_PIN24(value uint32) {
	volatile.StoreUint32(&o.OUTCLR.Reg, volatile.LoadUint32(&o.OUTCLR.Reg)&^(0x1000000)|value<<24)
}
func (o *GPIO_Type) GetOUTCLR_PIN24() uint32 {
	return (volatile.LoadUint32(&o.OUTCLR.Reg) & 0x1000000) >> 24
}
func (o *GPIO_Type) SetOUTCLR_PIN25(value uint32) {
	volatile.StoreUint32(&o.OUTCLR.Reg, volatile.LoadUint32(&o.OUTCLR.Reg)&^(0x2000000)|value<<25)
}
func (o *GPIO_Type) GetOUTCLR_PIN25() uint32 {
	return (volatile.LoadUint32(&o.OUTCLR.Reg) & 0x2000000) >> 25
}
func (o *GPIO_Type) SetOUTCLR_PIN26(value uint32) {
	volatile.StoreUint32(&o.OUTCLR.Reg, volatile.LoadUint32(&o.OUTCLR.Reg)&^(0x4000000)|value<<26)
}
func (o *GPIO_Type) GetOUTCLR_PIN26() uint32 {
	return (volatile.LoadUint32(&o.OUTCLR.Reg) & 0x4000000) >> 26
}
func (o *GPIO_Type) SetOUTCLR_PIN27(value uint32) {
	volatile.StoreUint32(&o.OUTCLR.Reg, volatile.LoadUint32(&o.OUTCLR.Reg)&^(0x8000000)|value<<27)
}
func (o *GPIO_Type) GetOUTCLR_PIN27() uint32 {
	return (volatile.LoadUint32(&o.OUTCLR.Reg) & 0x8000000) >> 27
}
func (o *GPIO_Type) SetOUTCLR_PIN28(value uint32) {
	volatile.StoreUint32(&o.OUTCLR.Reg, volatile.LoadUint32(&o.OUTCLR.Reg)&^(0x10000000)|value<<28)
}
func (o *GPIO_Type) GetOUTCLR_PIN28() uint32 {
	return (volatile.LoadUint32(&o.OUTCLR.Reg) & 0x10000000) >> 28
}
func (o *GPIO_Type) SetOUTCLR_PIN29(value uint32) {
	volatile.StoreUint32(&o.OUTCLR.Reg, volatile.LoadUint32(&o.OUTCLR.Reg)&^(0x20000000)|value<<29)
}
func (o *GPIO_Type) GetOUTCLR_PIN29() uint32 {
	return (volatile.LoadUint32(&o.OUTCLR.Reg) & 0x20000000) >> 29
}
func (o *GPIO_Type) SetOUTCLR_PIN30(value uint32) {
	volatile.StoreUint32(&o.OUTCLR.Reg, volatile.LoadUint32(&o.OUTCLR.Reg)&^(0x40000000)|value<<30)
}
func (o *GPIO_Type) GetOUTCLR_PIN30() uint32 {
	return (volatile.LoadUint32(&o.OUTCLR.Reg) & 0x40000000) >> 30
}
func (o *GPIO_Type) SetOUTCLR_PIN31(value uint32) {
	volatile.StoreUint32(&o.OUTCLR.Reg, volatile.LoadUint32(&o.OUTCLR.Reg)&^(0x80000000)|value<<31)
}
func (o *GPIO_Type) GetOUTCLR_PIN31() uint32 {
	return (volatile.LoadUint32(&o.OUTCLR.Reg) & 0x80000000) >> 31
}

// GPIO.IN: Read GPIO port
func (o *GPIO_Type) SetIN_PIN0(value uint32) {
	volatile.StoreUint32(&o.IN.Reg, volatile.LoadUint32(&o.IN.Reg)&^(0x1)|value)
}
func (o *GPIO_Type) GetIN_PIN0() uint32 {
	return volatile.LoadUint32(&o.IN.Reg) & 0x1
}
func (o *GPIO_Type) SetIN_PIN1(value uint32) {
	volatile.StoreUint32(&o.IN.Reg, volatile.LoadUint32(&o.IN.Reg)&^(0x2)|value<<1)
}
func (o *GPIO_Type) GetIN_PIN1() uint32 {
	return (volatile.LoadUint32(&o.IN.Reg) & 0x2) >> 1
}
func (o *GPIO_Type) SetIN_PIN2(value uint32) {
	volatile.StoreUint32(&o.IN.Reg, volatile.LoadUint32(&o.IN.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetIN_PIN2() uint32 {
	return (volatile.LoadUint32(&o.IN.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetIN_PIN3(value uint32) {
	volatile.StoreUint32(&o.IN.Reg, volatile.LoadUint32(&o.IN.Reg)&^(0x8)|value<<3)
}
func (o *GPIO_Type) GetIN_PIN3() uint32 {
	return (volatile.LoadUint32(&o.IN.Reg) & 0x8) >> 3
}
func (o *GPIO_Type) SetIN_PIN4(value uint32) {
	volatile.StoreUint32(&o.IN.Reg, volatile.LoadUint32(&o.IN.Reg)&^(0x10)|value<<4)
}
func (o *GPIO_Type) GetIN_PIN4() uint32 {
	return (volatile.LoadUint32(&o.IN.Reg) & 0x10) >> 4
}
func (o *GPIO_Type) SetIN_PIN5(value uint32) {
	volatile.StoreUint32(&o.IN.Reg, volatile.LoadUint32(&o.IN.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetIN_PIN5() uint32 {
	return (volatile.LoadUint32(&o.IN.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetIN_PIN6(value uint32) {
	volatile.StoreUint32(&o.IN.Reg, volatile.LoadUint32(&o.IN.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetIN_PIN6() uint32 {
	return (volatile.LoadUint32(&o.IN.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetIN_PIN7(value uint32) {
	volatile.StoreUint32(&o.IN.Reg, volatile.LoadUint32(&o.IN.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetIN_PIN7() uint32 {
	return (volatile.LoadUint32(&o.IN.Reg) & 0x80) >> 7
}
func (o *GPIO_Type) SetIN_PIN8(value uint32) {
	volatile.StoreUint32(&o.IN.Reg, volatile.LoadUint32(&o.IN.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetIN_PIN8() uint32 {
	return (volatile.LoadUint32(&o.IN.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetIN_PIN9(value uint32) {
	volatile.StoreUint32(&o.IN.Reg, volatile.LoadUint32(&o.IN.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetIN_PIN9() uint32 {
	return (volatile.LoadUint32(&o.IN.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetIN_PIN10(value uint32) {
	volatile.StoreUint32(&o.IN.Reg, volatile.LoadUint32(&o.IN.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetIN_PIN10() uint32 {
	return (volatile.LoadUint32(&o.IN.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetIN_PIN11(value uint32) {
	volatile.StoreUint32(&o.IN.Reg, volatile.LoadUint32(&o.IN.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetIN_PIN11() uint32 {
	return (volatile.LoadUint32(&o.IN.Reg) & 0x800) >> 11
}
func (o *GPIO_Type) SetIN_PIN12(value uint32) {
	volatile.StoreUint32(&o.IN.Reg, volatile.LoadUint32(&o.IN.Reg)&^(0x1000)|value<<12)
}
func (o *GPIO_Type) GetIN_PIN12() uint32 {
	return (volatile.LoadUint32(&o.IN.Reg) & 0x1000) >> 12
}
func (o *GPIO_Type) SetIN_PIN13(value uint32) {
	volatile.StoreUint32(&o.IN.Reg, volatile.LoadUint32(&o.IN.Reg)&^(0x2000)|value<<13)
}
func (o *GPIO_Type) GetIN_PIN13() uint32 {
	return (volatile.LoadUint32(&o.IN.Reg) & 0x2000) >> 13
}
func (o *GPIO_Type) SetIN_PIN14(value uint32) {
	volatile.StoreUint32(&o.IN.Reg, volatile.LoadUint32(&o.IN.Reg)&^(0x4000)|value<<14)
}
func (o *GPIO_Type) GetIN_PIN14() uint32 {
	return (volatile.LoadUint32(&o.IN.Reg) & 0x4000) >> 14
}
func (o *GPIO_Type) SetIN_PIN15(value uint32) {
	volatile.StoreUint32(&o.IN.Reg, volatile.LoadUint32(&o.IN.Reg)&^(0x8000)|value<<15)
}
func (o *GPIO_Type) GetIN_PIN15() uint32 {
	return (volatile.LoadUint32(&o.IN.Reg) & 0x8000) >> 15
}
func (o *GPIO_Type) SetIN_PIN16(value uint32) {
	volatile.StoreUint32(&o.IN.Reg, volatile.LoadUint32(&o.IN.Reg)&^(0x10000)|value<<16)
}
func (o *GPIO_Type) GetIN_PIN16() uint32 {
	return (volatile.LoadUint32(&o.IN.Reg) & 0x10000) >> 16
}
func (o *GPIO_Type) SetIN_PIN17(value uint32) {
	volatile.StoreUint32(&o.IN.Reg, volatile.LoadUint32(&o.IN.Reg)&^(0x20000)|value<<17)
}
func (o *GPIO_Type) GetIN_PIN17() uint32 {
	return (volatile.LoadUint32(&o.IN.Reg) & 0x20000) >> 17
}
func (o *GPIO_Type) SetIN_PIN18(value uint32) {
	volatile.StoreUint32(&o.IN.Reg, volatile.LoadUint32(&o.IN.Reg)&^(0x40000)|value<<18)
}
func (o *GPIO_Type) GetIN_PIN18() uint32 {
	return (volatile.LoadUint32(&o.IN.Reg) & 0x40000) >> 18
}
func (o *GPIO_Type) SetIN_PIN19(value uint32) {
	volatile.StoreUint32(&o.IN.Reg, volatile.LoadUint32(&o.IN.Reg)&^(0x80000)|value<<19)
}
func (o *GPIO_Type) GetIN_PIN19() uint32 {
	return (volatile.LoadUint32(&o.IN.Reg) & 0x80000) >> 19
}
func (o *GPIO_Type) SetIN_PIN20(value uint32) {
	volatile.StoreUint32(&o.IN.Reg, volatile.LoadUint32(&o.IN.Reg)&^(0x100000)|value<<20)
}
func (o *GPIO_Type) GetIN_PIN20() uint32 {
	return (volatile.LoadUint32(&o.IN.Reg) & 0x100000) >> 20
}
func (o *GPIO_Type) SetIN_PIN21(value uint32) {
	volatile.StoreUint32(&o.IN.Reg, volatile.LoadUint32(&o.IN.Reg)&^(0x200000)|value<<21)
}
func (o *GPIO_Type) GetIN_PIN21() uint32 {
	return (volatile.LoadUint32(&o.IN.Reg) & 0x200000) >> 21
}
func (o *GPIO_Type) SetIN_PIN22(value uint32) {
	volatile.StoreUint32(&o.IN.Reg, volatile.LoadUint32(&o.IN.Reg)&^(0x400000)|value<<22)
}
func (o *GPIO_Type) GetIN_PIN22() uint32 {
	return (volatile.LoadUint32(&o.IN.Reg) & 0x400000) >> 22
}
func (o *GPIO_Type) SetIN_PIN23(value uint32) {
	volatile.StoreUint32(&o.IN.Reg, volatile.LoadUint32(&o.IN.Reg)&^(0x800000)|value<<23)
}
func (o *GPIO_Type) GetIN_PIN23() uint32 {
	return (volatile.LoadUint32(&o.IN.Reg) & 0x800000) >> 23
}
func (o *GPIO_Type) SetIN_PIN24(value uint32) {
	volatile.StoreUint32(&o.IN.Reg, volatile.LoadUint32(&o.IN.Reg)&^(0x1000000)|value<<24)
}
func (o *GPIO_Type) GetIN_PIN24() uint32 {
	return (volatile.LoadUint32(&o.IN.Reg) & 0x1000000) >> 24
}
func (o *GPIO_Type) SetIN_PIN25(value uint32) {
	volatile.StoreUint32(&o.IN.Reg, volatile.LoadUint32(&o.IN.Reg)&^(0x2000000)|value<<25)
}
func (o *GPIO_Type) GetIN_PIN25() uint32 {
	return (volatile.LoadUint32(&o.IN.Reg) & 0x2000000) >> 25
}
func (o *GPIO_Type) SetIN_PIN26(value uint32) {
	volatile.StoreUint32(&o.IN.Reg, volatile.LoadUint32(&o.IN.Reg)&^(0x4000000)|value<<26)
}
func (o *GPIO_Type) GetIN_PIN26() uint32 {
	return (volatile.LoadUint32(&o.IN.Reg) & 0x4000000) >> 26
}
func (o *GPIO_Type) SetIN_PIN27(value uint32) {
	volatile.StoreUint32(&o.IN.Reg, volatile.LoadUint32(&o.IN.Reg)&^(0x8000000)|value<<27)
}
func (o *GPIO_Type) GetIN_PIN27() uint32 {
	return (volatile.LoadUint32(&o.IN.Reg) & 0x8000000) >> 27
}
func (o *GPIO_Type) SetIN_PIN28(value uint32) {
	volatile.StoreUint32(&o.IN.Reg, volatile.LoadUint32(&o.IN.Reg)&^(0x10000000)|value<<28)
}
func (o *GPIO_Type) GetIN_PIN28() uint32 {
	return (volatile.LoadUint32(&o.IN.Reg) & 0x10000000) >> 28
}
func (o *GPIO_Type) SetIN_PIN29(value uint32) {
	volatile.StoreUint32(&o.IN.Reg, volatile.LoadUint32(&o.IN.Reg)&^(0x20000000)|value<<29)
}
func (o *GPIO_Type) GetIN_PIN29() uint32 {
	return (volatile.LoadUint32(&o.IN.Reg) & 0x20000000) >> 29
}
func (o *GPIO_Type) SetIN_PIN30(value uint32) {
	volatile.StoreUint32(&o.IN.Reg, volatile.LoadUint32(&o.IN.Reg)&^(0x40000000)|value<<30)
}
func (o *GPIO_Type) GetIN_PIN30() uint32 {
	return (volatile.LoadUint32(&o.IN.Reg) & 0x40000000) >> 30
}
func (o *GPIO_Type) SetIN_PIN31(value uint32) {
	volatile.StoreUint32(&o.IN.Reg, volatile.LoadUint32(&o.IN.Reg)&^(0x80000000)|value<<31)
}
func (o *GPIO_Type) GetIN_PIN31() uint32 {
	return (volatile.LoadUint32(&o.IN.Reg) & 0x80000000) >> 31
}

// GPIO.DIR: Direction of GPIO pins
func (o *GPIO_Type) SetDIR_PIN0(value uint32) {
	volatile.StoreUint32(&o.DIR.Reg, volatile.LoadUint32(&o.DIR.Reg)&^(0x1)|value)
}
func (o *GPIO_Type) GetDIR_PIN0() uint32 {
	return volatile.LoadUint32(&o.DIR.Reg) & 0x1
}
func (o *GPIO_Type) SetDIR_PIN1(value uint32) {
	volatile.StoreUint32(&o.DIR.Reg, volatile.LoadUint32(&o.DIR.Reg)&^(0x2)|value<<1)
}
func (o *GPIO_Type) GetDIR_PIN1() uint32 {
	return (volatile.LoadUint32(&o.DIR.Reg) & 0x2) >> 1
}
func (o *GPIO_Type) SetDIR_PIN2(value uint32) {
	volatile.StoreUint32(&o.DIR.Reg, volatile.LoadUint32(&o.DIR.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetDIR_PIN2() uint32 {
	return (volatile.LoadUint32(&o.DIR.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetDIR_PIN3(value uint32) {
	volatile.StoreUint32(&o.DIR.Reg, volatile.LoadUint32(&o.DIR.Reg)&^(0x8)|value<<3)
}
func (o *GPIO_Type) GetDIR_PIN3() uint32 {
	return (volatile.LoadUint32(&o.DIR.Reg) & 0x8) >> 3
}
func (o *GPIO_Type) SetDIR_PIN4(value uint32) {
	volatile.StoreUint32(&o.DIR.Reg, volatile.LoadUint32(&o.DIR.Reg)&^(0x10)|value<<4)
}
func (o *GPIO_Type) GetDIR_PIN4() uint32 {
	return (volatile.LoadUint32(&o.DIR.Reg) & 0x10) >> 4
}
func (o *GPIO_Type) SetDIR_PIN5(value uint32) {
	volatile.StoreUint32(&o.DIR.Reg, volatile.LoadUint32(&o.DIR.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetDIR_PIN5() uint32 {
	return (volatile.LoadUint32(&o.DIR.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetDIR_PIN6(value uint32) {
	volatile.StoreUint32(&o.DIR.Reg, volatile.LoadUint32(&o.DIR.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetDIR_PIN6() uint32 {
	return (volatile.LoadUint32(&o.DIR.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetDIR_PIN7(value uint32) {
	volatile.StoreUint32(&o.DIR.Reg, volatile.LoadUint32(&o.DIR.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetDIR_PIN7() uint32 {
	return (volatile.LoadUint32(&o.DIR.Reg) & 0x80) >> 7
}
func (o *GPIO_Type) SetDIR_PIN8(value uint32) {
	volatile.StoreUint32(&o.DIR.Reg, volatile.LoadUint32(&o.DIR.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetDIR_PIN8() uint32 {
	return (volatile.LoadUint32(&o.DIR.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetDIR_PIN9(value uint32) {
	volatile.StoreUint32(&o.DIR.Reg, volatile.LoadUint32(&o.DIR.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetDIR_PIN9() uint32 {
	return (volatile.LoadUint32(&o.DIR.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetDIR_PIN10(value uint32) {
	volatile.StoreUint32(&o.DIR.Reg, volatile.LoadUint32(&o.DIR.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetDIR_PIN10() uint32 {
	return (volatile.LoadUint32(&o.DIR.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetDIR_PIN11(value uint32) {
	volatile.StoreUint32(&o.DIR.Reg, volatile.LoadUint32(&o.DIR.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetDIR_PIN11() uint32 {
	return (volatile.LoadUint32(&o.DIR.Reg) & 0x800) >> 11
}
func (o *GPIO_Type) SetDIR_PIN12(value uint32) {
	volatile.StoreUint32(&o.DIR.Reg, volatile.LoadUint32(&o.DIR.Reg)&^(0x1000)|value<<12)
}
func (o *GPIO_Type) GetDIR_PIN12() uint32 {
	return (volatile.LoadUint32(&o.DIR.Reg) & 0x1000) >> 12
}
func (o *GPIO_Type) SetDIR_PIN13(value uint32) {
	volatile.StoreUint32(&o.DIR.Reg, volatile.LoadUint32(&o.DIR.Reg)&^(0x2000)|value<<13)
}
func (o *GPIO_Type) GetDIR_PIN13() uint32 {
	return (volatile.LoadUint32(&o.DIR.Reg) & 0x2000) >> 13
}
func (o *GPIO_Type) SetDIR_PIN14(value uint32) {
	volatile.StoreUint32(&o.DIR.Reg, volatile.LoadUint32(&o.DIR.Reg)&^(0x4000)|value<<14)
}
func (o *GPIO_Type) GetDIR_PIN14() uint32 {
	return (volatile.LoadUint32(&o.DIR.Reg) & 0x4000) >> 14
}
func (o *GPIO_Type) SetDIR_PIN15(value uint32) {
	volatile.StoreUint32(&o.DIR.Reg, volatile.LoadUint32(&o.DIR.Reg)&^(0x8000)|value<<15)
}
func (o *GPIO_Type) GetDIR_PIN15() uint32 {
	return (volatile.LoadUint32(&o.DIR.Reg) & 0x8000) >> 15
}
func (o *GPIO_Type) SetDIR_PIN16(value uint32) {
	volatile.StoreUint32(&o.DIR.Reg, volatile.LoadUint32(&o.DIR.Reg)&^(0x10000)|value<<16)
}
func (o *GPIO_Type) GetDIR_PIN16() uint32 {
	return (volatile.LoadUint32(&o.DIR.Reg) & 0x10000) >> 16
}
func (o *GPIO_Type) SetDIR_PIN17(value uint32) {
	volatile.StoreUint32(&o.DIR.Reg, volatile.LoadUint32(&o.DIR.Reg)&^(0x20000)|value<<17)
}
func (o *GPIO_Type) GetDIR_PIN17() uint32 {
	return (volatile.LoadUint32(&o.DIR.Reg) & 0x20000) >> 17
}
func (o *GPIO_Type) SetDIR_PIN18(value uint32) {
	volatile.StoreUint32(&o.DIR.Reg, volatile.LoadUint32(&o.DIR.Reg)&^(0x40000)|value<<18)
}
func (o *GPIO_Type) GetDIR_PIN18() uint32 {
	return (volatile.LoadUint32(&o.DIR.Reg) & 0x40000) >> 18
}
func (o *GPIO_Type) SetDIR_PIN19(value uint32) {
	volatile.StoreUint32(&o.DIR.Reg, volatile.LoadUint32(&o.DIR.Reg)&^(0x80000)|value<<19)
}
func (o *GPIO_Type) GetDIR_PIN19() uint32 {
	return (volatile.LoadUint32(&o.DIR.Reg) & 0x80000) >> 19
}
func (o *GPIO_Type) SetDIR_PIN20(value uint32) {
	volatile.StoreUint32(&o.DIR.Reg, volatile.LoadUint32(&o.DIR.Reg)&^(0x100000)|value<<20)
}
func (o *GPIO_Type) GetDIR_PIN20() uint32 {
	return (volatile.LoadUint32(&o.DIR.Reg) & 0x100000) >> 20
}
func (o *GPIO_Type) SetDIR_PIN21(value uint32) {
	volatile.StoreUint32(&o.DIR.Reg, volatile.LoadUint32(&o.DIR.Reg)&^(0x200000)|value<<21)
}
func (o *GPIO_Type) GetDIR_PIN21() uint32 {
	return (volatile.LoadUint32(&o.DIR.Reg) & 0x200000) >> 21
}
func (o *GPIO_Type) SetDIR_PIN22(value uint32) {
	volatile.StoreUint32(&o.DIR.Reg, volatile.LoadUint32(&o.DIR.Reg)&^(0x400000)|value<<22)
}
func (o *GPIO_Type) GetDIR_PIN22() uint32 {
	return (volatile.LoadUint32(&o.DIR.Reg) & 0x400000) >> 22
}
func (o *GPIO_Type) SetDIR_PIN23(value uint32) {
	volatile.StoreUint32(&o.DIR.Reg, volatile.LoadUint32(&o.DIR.Reg)&^(0x800000)|value<<23)
}
func (o *GPIO_Type) GetDIR_PIN23() uint32 {
	return (volatile.LoadUint32(&o.DIR.Reg) & 0x800000) >> 23
}
func (o *GPIO_Type) SetDIR_PIN24(value uint32) {
	volatile.StoreUint32(&o.DIR.Reg, volatile.LoadUint32(&o.DIR.Reg)&^(0x1000000)|value<<24)
}
func (o *GPIO_Type) GetDIR_PIN24() uint32 {
	return (volatile.LoadUint32(&o.DIR.Reg) & 0x1000000) >> 24
}
func (o *GPIO_Type) SetDIR_PIN25(value uint32) {
	volatile.StoreUint32(&o.DIR.Reg, volatile.LoadUint32(&o.DIR.Reg)&^(0x2000000)|value<<25)
}
func (o *GPIO_Type) GetDIR_PIN25() uint32 {
	return (volatile.LoadUint32(&o.DIR.Reg) & 0x2000000) >> 25
}
func (o *GPIO_Type) SetDIR_PIN26(value uint32) {
	volatile.StoreUint32(&o.DIR.Reg, volatile.LoadUint32(&o.DIR.Reg)&^(0x4000000)|value<<26)
}
func (o *GPIO_Type) GetDIR_PIN26() uint32 {
	return (volatile.LoadUint32(&o.DIR.Reg) & 0x4000000) >> 26
}
func (o *GPIO_Type) SetDIR_PIN27(value uint32) {
	volatile.StoreUint32(&o.DIR.Reg, volatile.LoadUint32(&o.DIR.Reg)&^(0x8000000)|value<<27)
}
func (o *GPIO_Type) GetDIR_PIN27() uint32 {
	return (volatile.LoadUint32(&o.DIR.Reg) & 0x8000000) >> 27
}
func (o *GPIO_Type) SetDIR_PIN28(value uint32) {
	volatile.StoreUint32(&o.DIR.Reg, volatile.LoadUint32(&o.DIR.Reg)&^(0x10000000)|value<<28)
}
func (o *GPIO_Type) GetDIR_PIN28() uint32 {
	return (volatile.LoadUint32(&o.DIR.Reg) & 0x10000000) >> 28
}
func (o *GPIO_Type) SetDIR_PIN29(value uint32) {
	volatile.StoreUint32(&o.DIR.Reg, volatile.LoadUint32(&o.DIR.Reg)&^(0x20000000)|value<<29)
}
func (o *GPIO_Type) GetDIR_PIN29() uint32 {
	return (volatile.LoadUint32(&o.DIR.Reg) & 0x20000000) >> 29
}
func (o *GPIO_Type) SetDIR_PIN30(value uint32) {
	volatile.StoreUint32(&o.DIR.Reg, volatile.LoadUint32(&o.DIR.Reg)&^(0x40000000)|value<<30)
}
func (o *GPIO_Type) GetDIR_PIN30() uint32 {
	return (volatile.LoadUint32(&o.DIR.Reg) & 0x40000000) >> 30
}
func (o *GPIO_Type) SetDIR_PIN31(value uint32) {
	volatile.StoreUint32(&o.DIR.Reg, volatile.LoadUint32(&o.DIR.Reg)&^(0x80000000)|value<<31)
}
func (o *GPIO_Type) GetDIR_PIN31() uint32 {
	return (volatile.LoadUint32(&o.DIR.Reg) & 0x80000000) >> 31
}

// GPIO.DIRSET: DIR set register
func (o *GPIO_Type) SetDIRSET_PIN0(value uint32) {
	volatile.StoreUint32(&o.DIRSET.Reg, volatile.LoadUint32(&o.DIRSET.Reg)&^(0x1)|value)
}
func (o *GPIO_Type) GetDIRSET_PIN0() uint32 {
	return volatile.LoadUint32(&o.DIRSET.Reg) & 0x1
}
func (o *GPIO_Type) SetDIRSET_PIN1(value uint32) {
	volatile.StoreUint32(&o.DIRSET.Reg, volatile.LoadUint32(&o.DIRSET.Reg)&^(0x2)|value<<1)
}
func (o *GPIO_Type) GetDIRSET_PIN1() uint32 {
	return (volatile.LoadUint32(&o.DIRSET.Reg) & 0x2) >> 1
}
func (o *GPIO_Type) SetDIRSET_PIN2(value uint32) {
	volatile.StoreUint32(&o.DIRSET.Reg, volatile.LoadUint32(&o.DIRSET.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetDIRSET_PIN2() uint32 {
	return (volatile.LoadUint32(&o.DIRSET.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetDIRSET_PIN3(value uint32) {
	volatile.StoreUint32(&o.DIRSET.Reg, volatile.LoadUint32(&o.DIRSET.Reg)&^(0x8)|value<<3)
}
func (o *GPIO_Type) GetDIRSET_PIN3() uint32 {
	return (volatile.LoadUint32(&o.DIRSET.Reg) & 0x8) >> 3
}
func (o *GPIO_Type) SetDIRSET_PIN4(value uint32) {
	volatile.StoreUint32(&o.DIRSET.Reg, volatile.LoadUint32(&o.DIRSET.Reg)&^(0x10)|value<<4)
}
func (o *GPIO_Type) GetDIRSET_PIN4() uint32 {
	return (volatile.LoadUint32(&o.DIRSET.Reg) & 0x10) >> 4
}
func (o *GPIO_Type) SetDIRSET_PIN5(value uint32) {
	volatile.StoreUint32(&o.DIRSET.Reg, volatile.LoadUint32(&o.DIRSET.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetDIRSET_PIN5() uint32 {
	return (volatile.LoadUint32(&o.DIRSET.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetDIRSET_PIN6(value uint32) {
	volatile.StoreUint32(&o.DIRSET.Reg, volatile.LoadUint32(&o.DIRSET.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetDIRSET_PIN6() uint32 {
	return (volatile.LoadUint32(&o.DIRSET.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetDIRSET_PIN7(value uint32) {
	volatile.StoreUint32(&o.DIRSET.Reg, volatile.LoadUint32(&o.DIRSET.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetDIRSET_PIN7() uint32 {
	return (volatile.LoadUint32(&o.DIRSET.Reg) & 0x80) >> 7
}
func (o *GPIO_Type) SetDIRSET_PIN8(value uint32) {
	volatile.StoreUint32(&o.DIRSET.Reg, volatile.LoadUint32(&o.DIRSET.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetDIRSET_PIN8() uint32 {
	return (volatile.LoadUint32(&o.DIRSET.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetDIRSET_PIN9(value uint32) {
	volatile.StoreUint32(&o.DIRSET.Reg, volatile.LoadUint32(&o.DIRSET.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetDIRSET_PIN9() uint32 {
	return (volatile.LoadUint32(&o.DIRSET.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetDIRSET_PIN10(value uint32) {
	volatile.StoreUint32(&o.DIRSET.Reg, volatile.LoadUint32(&o.DIRSET.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetDIRSET_PIN10() uint32 {
	return (volatile.LoadUint32(&o.DIRSET.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetDIRSET_PIN11(value uint32) {
	volatile.StoreUint32(&o.DIRSET.Reg, volatile.LoadUint32(&o.DIRSET.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetDIRSET_PIN11() uint32 {
	return (volatile.LoadUint32(&o.DIRSET.Reg) & 0x800) >> 11
}
func (o *GPIO_Type) SetDIRSET_PIN12(value uint32) {
	volatile.StoreUint32(&o.DIRSET.Reg, volatile.LoadUint32(&o.DIRSET.Reg)&^(0x1000)|value<<12)
}
func (o *GPIO_Type) GetDIRSET_PIN12() uint32 {
	return (volatile.LoadUint32(&o.DIRSET.Reg) & 0x1000) >> 12
}
func (o *GPIO_Type) SetDIRSET_PIN13(value uint32) {
	volatile.StoreUint32(&o.DIRSET.Reg, volatile.LoadUint32(&o.DIRSET.Reg)&^(0x2000)|value<<13)
}
func (o *GPIO_Type) GetDIRSET_PIN13() uint32 {
	return (volatile.LoadUint32(&o.DIRSET.Reg) & 0x2000) >> 13
}
func (o *GPIO_Type) SetDIRSET_PIN14(value uint32) {
	volatile.StoreUint32(&o.DIRSET.Reg, volatile.LoadUint32(&o.DIRSET.Reg)&^(0x4000)|value<<14)
}
func (o *GPIO_Type) GetDIRSET_PIN14() uint32 {
	return (volatile.LoadUint32(&o.DIRSET.Reg) & 0x4000) >> 14
}
func (o *GPIO_Type) SetDIRSET_PIN15(value uint32) {
	volatile.StoreUint32(&o.DIRSET.Reg, volatile.LoadUint32(&o.DIRSET.Reg)&^(0x8000)|value<<15)
}
func (o *GPIO_Type) GetDIRSET_PIN15() uint32 {
	return (volatile.LoadUint32(&o.DIRSET.Reg) & 0x8000) >> 15
}
func (o *GPIO_Type) SetDIRSET_PIN16(value uint32) {
	volatile.StoreUint32(&o.DIRSET.Reg, volatile.LoadUint32(&o.DIRSET.Reg)&^(0x10000)|value<<16)
}
func (o *GPIO_Type) GetDIRSET_PIN16() uint32 {
	return (volatile.LoadUint32(&o.DIRSET.Reg) & 0x10000) >> 16
}
func (o *GPIO_Type) SetDIRSET_PIN17(value uint32) {
	volatile.StoreUint32(&o.DIRSET.Reg, volatile.LoadUint32(&o.DIRSET.Reg)&^(0x20000)|value<<17)
}
func (o *GPIO_Type) GetDIRSET_PIN17() uint32 {
	return (volatile.LoadUint32(&o.DIRSET.Reg) & 0x20000) >> 17
}
func (o *GPIO_Type) SetDIRSET_PIN18(value uint32) {
	volatile.StoreUint32(&o.DIRSET.Reg, volatile.LoadUint32(&o.DIRSET.Reg)&^(0x40000)|value<<18)
}
func (o *GPIO_Type) GetDIRSET_PIN18() uint32 {
	return (volatile.LoadUint32(&o.DIRSET.Reg) & 0x40000) >> 18
}
func (o *GPIO_Type) SetDIRSET_PIN19(value uint32) {
	volatile.StoreUint32(&o.DIRSET.Reg, volatile.LoadUint32(&o.DIRSET.Reg)&^(0x80000)|value<<19)
}
func (o *GPIO_Type) GetDIRSET_PIN19() uint32 {
	return (volatile.LoadUint32(&o.DIRSET.Reg) & 0x80000) >> 19
}
func (o *GPIO_Type) SetDIRSET_PIN20(value uint32) {
	volatile.StoreUint32(&o.DIRSET.Reg, volatile.LoadUint32(&o.DIRSET.Reg)&^(0x100000)|value<<20)
}
func (o *GPIO_Type) GetDIRSET_PIN20() uint32 {
	return (volatile.LoadUint32(&o.DIRSET.Reg) & 0x100000) >> 20
}
func (o *GPIO_Type) SetDIRSET_PIN21(value uint32) {
	volatile.StoreUint32(&o.DIRSET.Reg, volatile.LoadUint32(&o.DIRSET.Reg)&^(0x200000)|value<<21)
}
func (o *GPIO_Type) GetDIRSET_PIN21() uint32 {
	return (volatile.LoadUint32(&o.DIRSET.Reg) & 0x200000) >> 21
}
func (o *GPIO_Type) SetDIRSET_PIN22(value uint32) {
	volatile.StoreUint32(&o.DIRSET.Reg, volatile.LoadUint32(&o.DIRSET.Reg)&^(0x400000)|value<<22)
}
func (o *GPIO_Type) GetDIRSET_PIN22() uint32 {
	return (volatile.LoadUint32(&o.DIRSET.Reg) & 0x400000) >> 22
}
func (o *GPIO_Type) SetDIRSET_PIN23(value uint32) {
	volatile.StoreUint32(&o.DIRSET.Reg, volatile.LoadUint32(&o.DIRSET.Reg)&^(0x800000)|value<<23)
}
func (o *GPIO_Type) GetDIRSET_PIN23() uint32 {
	return (volatile.LoadUint32(&o.DIRSET.Reg) & 0x800000) >> 23
}
func (o *GPIO_Type) SetDIRSET_PIN24(value uint32) {
	volatile.StoreUint32(&o.DIRSET.Reg, volatile.LoadUint32(&o.DIRSET.Reg)&^(0x1000000)|value<<24)
}
func (o *GPIO_Type) GetDIRSET_PIN24() uint32 {
	return (volatile.LoadUint32(&o.DIRSET.Reg) & 0x1000000) >> 24
}
func (o *GPIO_Type) SetDIRSET_PIN25(value uint32) {
	volatile.StoreUint32(&o.DIRSET.Reg, volatile.LoadUint32(&o.DIRSET.Reg)&^(0x2000000)|value<<25)
}
func (o *GPIO_Type) GetDIRSET_PIN25() uint32 {
	return (volatile.LoadUint32(&o.DIRSET.Reg) & 0x2000000) >> 25
}
func (o *GPIO_Type) SetDIRSET_PIN26(value uint32) {
	volatile.StoreUint32(&o.DIRSET.Reg, volatile.LoadUint32(&o.DIRSET.Reg)&^(0x4000000)|value<<26)
}
func (o *GPIO_Type) GetDIRSET_PIN26() uint32 {
	return (volatile.LoadUint32(&o.DIRSET.Reg) & 0x4000000) >> 26
}
func (o *GPIO_Type) SetDIRSET_PIN27(value uint32) {
	volatile.StoreUint32(&o.DIRSET.Reg, volatile.LoadUint32(&o.DIRSET.Reg)&^(0x8000000)|value<<27)
}
func (o *GPIO_Type) GetDIRSET_PIN27() uint32 {
	return (volatile.LoadUint32(&o.DIRSET.Reg) & 0x8000000) >> 27
}
func (o *GPIO_Type) SetDIRSET_PIN28(value uint32) {
	volatile.StoreUint32(&o.DIRSET.Reg, volatile.LoadUint32(&o.DIRSET.Reg)&^(0x10000000)|value<<28)
}
func (o *GPIO_Type) GetDIRSET_PIN28() uint32 {
	return (volatile.LoadUint32(&o.DIRSET.Reg) & 0x10000000) >> 28
}
func (o *GPIO_Type) SetDIRSET_PIN29(value uint32) {
	volatile.StoreUint32(&o.DIRSET.Reg, volatile.LoadUint32(&o.DIRSET.Reg)&^(0x20000000)|value<<29)
}
func (o *GPIO_Type) GetDIRSET_PIN29() uint32 {
	return (volatile.LoadUint32(&o.DIRSET.Reg) & 0x20000000) >> 29
}
func (o *GPIO_Type) SetDIRSET_PIN30(value uint32) {
	volatile.StoreUint32(&o.DIRSET.Reg, volatile.LoadUint32(&o.DIRSET.Reg)&^(0x40000000)|value<<30)
}
func (o *GPIO_Type) GetDIRSET_PIN30() uint32 {
	return (volatile.LoadUint32(&o.DIRSET.Reg) & 0x40000000) >> 30
}
func (o *GPIO_Type) SetDIRSET_PIN31(value uint32) {
	volatile.StoreUint32(&o.DIRSET.Reg, volatile.LoadUint32(&o.DIRSET.Reg)&^(0x80000000)|value<<31)
}
func (o *GPIO_Type) GetDIRSET_PIN31() uint32 {
	return (volatile.LoadUint32(&o.DIRSET.Reg) & 0x80000000) >> 31
}

// GPIO.DIRCLR: DIR clear register
func (o *GPIO_Type) SetDIRCLR_PIN0(value uint32) {
	volatile.StoreUint32(&o.DIRCLR.Reg, volatile.LoadUint32(&o.DIRCLR.Reg)&^(0x1)|value)
}
func (o *GPIO_Type) GetDIRCLR_PIN0() uint32 {
	return volatile.LoadUint32(&o.DIRCLR.Reg) & 0x1
}
func (o *GPIO_Type) SetDIRCLR_PIN1(value uint32) {
	volatile.StoreUint32(&o.DIRCLR.Reg, volatile.LoadUint32(&o.DIRCLR.Reg)&^(0x2)|value<<1)
}
func (o *GPIO_Type) GetDIRCLR_PIN1() uint32 {
	return (volatile.LoadUint32(&o.DIRCLR.Reg) & 0x2) >> 1
}
func (o *GPIO_Type) SetDIRCLR_PIN2(value uint32) {
	volatile.StoreUint32(&o.DIRCLR.Reg, volatile.LoadUint32(&o.DIRCLR.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetDIRCLR_PIN2() uint32 {
	return (volatile.LoadUint32(&o.DIRCLR.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetDIRCLR_PIN3(value uint32) {
	volatile.StoreUint32(&o.DIRCLR.Reg, volatile.LoadUint32(&o.DIRCLR.Reg)&^(0x8)|value<<3)
}
func (o *GPIO_Type) GetDIRCLR_PIN3() uint32 {
	return (volatile.LoadUint32(&o.DIRCLR.Reg) & 0x8) >> 3
}
func (o *GPIO_Type) SetDIRCLR_PIN4(value uint32) {
	volatile.StoreUint32(&o.DIRCLR.Reg, volatile.LoadUint32(&o.DIRCLR.Reg)&^(0x10)|value<<4)
}
func (o *GPIO_Type) GetDIRCLR_PIN4() uint32 {
	return (volatile.LoadUint32(&o.DIRCLR.Reg) & 0x10) >> 4
}
func (o *GPIO_Type) SetDIRCLR_PIN5(value uint32) {
	volatile.StoreUint32(&o.DIRCLR.Reg, volatile.LoadUint32(&o.DIRCLR.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetDIRCLR_PIN5() uint32 {
	return (volatile.LoadUint32(&o.DIRCLR.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetDIRCLR_PIN6(value uint32) {
	volatile.StoreUint32(&o.DIRCLR.Reg, volatile.LoadUint32(&o.DIRCLR.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetDIRCLR_PIN6() uint32 {
	return (volatile.LoadUint32(&o.DIRCLR.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetDIRCLR_PIN7(value uint32) {
	volatile.StoreUint32(&o.DIRCLR.Reg, volatile.LoadUint32(&o.DIRCLR.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetDIRCLR_PIN7() uint32 {
	return (volatile.LoadUint32(&o.DIRCLR.Reg) & 0x80) >> 7
}
func (o *GPIO_Type) SetDIRCLR_PIN8(value uint32) {
	volatile.StoreUint32(&o.DIRCLR.Reg, volatile.LoadUint32(&o.DIRCLR.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetDIRCLR_PIN8() uint32 {
	return (volatile.LoadUint32(&o.DIRCLR.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetDIRCLR_PIN9(value uint32) {
	volatile.StoreUint32(&o.DIRCLR.Reg, volatile.LoadUint32(&o.DIRCLR.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetDIRCLR_PIN9() uint32 {
	return (volatile.LoadUint32(&o.DIRCLR.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetDIRCLR_PIN10(value uint32) {
	volatile.StoreUint32(&o.DIRCLR.Reg, volatile.LoadUint32(&o.DIRCLR.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetDIRCLR_PIN10() uint32 {
	return (volatile.LoadUint32(&o.DIRCLR.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetDIRCLR_PIN11(value uint32) {
	volatile.StoreUint32(&o.DIRCLR.Reg, volatile.LoadUint32(&o.DIRCLR.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetDIRCLR_PIN11() uint32 {
	return (volatile.LoadUint32(&o.DIRCLR.Reg) & 0x800) >> 11
}
func (o *GPIO_Type) SetDIRCLR_PIN12(value uint32) {
	volatile.StoreUint32(&o.DIRCLR.Reg, volatile.LoadUint32(&o.DIRCLR.Reg)&^(0x1000)|value<<12)
}
func (o *GPIO_Type) GetDIRCLR_PIN12() uint32 {
	return (volatile.LoadUint32(&o.DIRCLR.Reg) & 0x1000) >> 12
}
func (o *GPIO_Type) SetDIRCLR_PIN13(value uint32) {
	volatile.StoreUint32(&o.DIRCLR.Reg, volatile.LoadUint32(&o.DIRCLR.Reg)&^(0x2000)|value<<13)
}
func (o *GPIO_Type) GetDIRCLR_PIN13() uint32 {
	return (volatile.LoadUint32(&o.DIRCLR.Reg) & 0x2000) >> 13
}
func (o *GPIO_Type) SetDIRCLR_PIN14(value uint32) {
	volatile.StoreUint32(&o.DIRCLR.Reg, volatile.LoadUint32(&o.DIRCLR.Reg)&^(0x4000)|value<<14)
}
func (o *GPIO_Type) GetDIRCLR_PIN14() uint32 {
	return (volatile.LoadUint32(&o.DIRCLR.Reg) & 0x4000) >> 14
}
func (o *GPIO_Type) SetDIRCLR_PIN15(value uint32) {
	volatile.StoreUint32(&o.DIRCLR.Reg, volatile.LoadUint32(&o.DIRCLR.Reg)&^(0x8000)|value<<15)
}
func (o *GPIO_Type) GetDIRCLR_PIN15() uint32 {
	return (volatile.LoadUint32(&o.DIRCLR.Reg) & 0x8000) >> 15
}
func (o *GPIO_Type) SetDIRCLR_PIN16(value uint32) {
	volatile.StoreUint32(&o.DIRCLR.Reg, volatile.LoadUint32(&o.DIRCLR.Reg)&^(0x10000)|value<<16)
}
func (o *GPIO_Type) GetDIRCLR_PIN16() uint32 {
	return (volatile.LoadUint32(&o.DIRCLR.Reg) & 0x10000) >> 16
}
func (o *GPIO_Type) SetDIRCLR_PIN17(value uint32) {
	volatile.StoreUint32(&o.DIRCLR.Reg, volatile.LoadUint32(&o.DIRCLR.Reg)&^(0x20000)|value<<17)
}
func (o *GPIO_Type) GetDIRCLR_PIN17() uint32 {
	return (volatile.LoadUint32(&o.DIRCLR.Reg) & 0x20000) >> 17
}
func (o *GPIO_Type) SetDIRCLR_PIN18(value uint32) {
	volatile.StoreUint32(&o.DIRCLR.Reg, volatile.LoadUint32(&o.DIRCLR.Reg)&^(0x40000)|value<<18)
}
func (o *GPIO_Type) GetDIRCLR_PIN18() uint32 {
	return (volatile.LoadUint32(&o.DIRCLR.Reg) & 0x40000) >> 18
}
func (o *GPIO_Type) SetDIRCLR_PIN19(value uint32) {
	volatile.StoreUint32(&o.DIRCLR.Reg, volatile.LoadUint32(&o.DIRCLR.Reg)&^(0x80000)|value<<19)
}
func (o *GPIO_Type) GetDIRCLR_PIN19() uint32 {
	return (volatile.LoadUint32(&o.DIRCLR.Reg) & 0x80000) >> 19
}
func (o *GPIO_Type) SetDIRCLR_PIN20(value uint32) {
	volatile.StoreUint32(&o.DIRCLR.Reg, volatile.LoadUint32(&o.DIRCLR.Reg)&^(0x100000)|value<<20)
}
func (o *GPIO_Type) GetDIRCLR_PIN20() uint32 {
	return (volatile.LoadUint32(&o.DIRCLR.Reg) & 0x100000) >> 20
}
func (o *GPIO_Type) SetDIRCLR_PIN21(value uint32) {
	volatile.StoreUint32(&o.DIRCLR.Reg, volatile.LoadUint32(&o.DIRCLR.Reg)&^(0x200000)|value<<21)
}
func (o *GPIO_Type) GetDIRCLR_PIN21() uint32 {
	return (volatile.LoadUint32(&o.DIRCLR.Reg) & 0x200000) >> 21
}
func (o *GPIO_Type) SetDIRCLR_PIN22(value uint32) {
	volatile.StoreUint32(&o.DIRCLR.Reg, volatile.LoadUint32(&o.DIRCLR.Reg)&^(0x400000)|value<<22)
}
func (o *GPIO_Type) GetDIRCLR_PIN22() uint32 {
	return (volatile.LoadUint32(&o.DIRCLR.Reg) & 0x400000) >> 22
}
func (o *GPIO_Type) SetDIRCLR_PIN23(value uint32) {
	volatile.StoreUint32(&o.DIRCLR.Reg, volatile.LoadUint32(&o.DIRCLR.Reg)&^(0x800000)|value<<23)
}
func (o *GPIO_Type) GetDIRCLR_PIN23() uint32 {
	return (volatile.LoadUint32(&o.DIRCLR.Reg) & 0x800000) >> 23
}
func (o *GPIO_Type) SetDIRCLR_PIN24(value uint32) {
	volatile.StoreUint32(&o.DIRCLR.Reg, volatile.LoadUint32(&o.DIRCLR.Reg)&^(0x1000000)|value<<24)
}
func (o *GPIO_Type) GetDIRCLR_PIN24() uint32 {
	return (volatile.LoadUint32(&o.DIRCLR.Reg) & 0x1000000) >> 24
}
func (o *GPIO_Type) SetDIRCLR_PIN25(value uint32) {
	volatile.StoreUint32(&o.DIRCLR.Reg, volatile.LoadUint32(&o.DIRCLR.Reg)&^(0x2000000)|value<<25)
}
func (o *GPIO_Type) GetDIRCLR_PIN25() uint32 {
	return (volatile.LoadUint32(&o.DIRCLR.Reg) & 0x2000000) >> 25
}
func (o *GPIO_Type) SetDIRCLR_PIN26(value uint32) {
	volatile.StoreUint32(&o.DIRCLR.Reg, volatile.LoadUint32(&o.DIRCLR.Reg)&^(0x4000000)|value<<26)
}
func (o *GPIO_Type) GetDIRCLR_PIN26() uint32 {
	return (volatile.LoadUint32(&o.DIRCLR.Reg) & 0x4000000) >> 26
}
func (o *GPIO_Type) SetDIRCLR_PIN27(value uint32) {
	volatile.StoreUint32(&o.DIRCLR.Reg, volatile.LoadUint32(&o.DIRCLR.Reg)&^(0x8000000)|value<<27)
}
func (o *GPIO_Type) GetDIRCLR_PIN27() uint32 {
	return (volatile.LoadUint32(&o.DIRCLR.Reg) & 0x8000000) >> 27
}
func (o *GPIO_Type) SetDIRCLR_PIN28(value uint32) {
	volatile.StoreUint32(&o.DIRCLR.Reg, volatile.LoadUint32(&o.DIRCLR.Reg)&^(0x10000000)|value<<28)
}
func (o *GPIO_Type) GetDIRCLR_PIN28() uint32 {
	return (volatile.LoadUint32(&o.DIRCLR.Reg) & 0x10000000) >> 28
}
func (o *GPIO_Type) SetDIRCLR_PIN29(value uint32) {
	volatile.StoreUint32(&o.DIRCLR.Reg, volatile.LoadUint32(&o.DIRCLR.Reg)&^(0x20000000)|value<<29)
}
func (o *GPIO_Type) GetDIRCLR_PIN29() uint32 {
	return (volatile.LoadUint32(&o.DIRCLR.Reg) & 0x20000000) >> 29
}
func (o *GPIO_Type) SetDIRCLR_PIN30(value uint32) {
	volatile.StoreUint32(&o.DIRCLR.Reg, volatile.LoadUint32(&o.DIRCLR.Reg)&^(0x40000000)|value<<30)
}
func (o *GPIO_Type) GetDIRCLR_PIN30() uint32 {
	return (volatile.LoadUint32(&o.DIRCLR.Reg) & 0x40000000) >> 30
}
func (o *GPIO_Type) SetDIRCLR_PIN31(value uint32) {
	volatile.StoreUint32(&o.DIRCLR.Reg, volatile.LoadUint32(&o.DIRCLR.Reg)&^(0x80000000)|value<<31)
}
func (o *GPIO_Type) GetDIRCLR_PIN31() uint32 {
	return (volatile.LoadUint32(&o.DIRCLR.Reg) & 0x80000000) >> 31
}

// GPIO.LATCH: Latch register indicating what GPIO pins that have met the criteria set in the PIN_CNF[n].SENSE registers
func (o *GPIO_Type) SetLATCH_PIN0(value uint32) {
	volatile.StoreUint32(&o.LATCH.Reg, volatile.LoadUint32(&o.LATCH.Reg)&^(0x1)|value)
}
func (o *GPIO_Type) GetLATCH_PIN0() uint32 {
	return volatile.LoadUint32(&o.LATCH.Reg) & 0x1
}
func (o *GPIO_Type) SetLATCH_PIN1(value uint32) {
	volatile.StoreUint32(&o.LATCH.Reg, volatile.LoadUint32(&o.LATCH.Reg)&^(0x2)|value<<1)
}
func (o *GPIO_Type) GetLATCH_PIN1() uint32 {
	return (volatile.LoadUint32(&o.LATCH.Reg) & 0x2) >> 1
}
func (o *GPIO_Type) SetLATCH_PIN2(value uint32) {
	volatile.StoreUint32(&o.LATCH.Reg, volatile.LoadUint32(&o.LATCH.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetLATCH_PIN2() uint32 {
	return (volatile.LoadUint32(&o.LATCH.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetLATCH_PIN3(value uint32) {
	volatile.StoreUint32(&o.LATCH.Reg, volatile.LoadUint32(&o.LATCH.Reg)&^(0x8)|value<<3)
}
func (o *GPIO_Type) GetLATCH_PIN3() uint32 {
	return (volatile.LoadUint32(&o.LATCH.Reg) & 0x8) >> 3
}
func (o *GPIO_Type) SetLATCH_PIN4(value uint32) {
	volatile.StoreUint32(&o.LATCH.Reg, volatile.LoadUint32(&o.LATCH.Reg)&^(0x10)|value<<4)
}
func (o *GPIO_Type) GetLATCH_PIN4() uint32 {
	return (volatile.LoadUint32(&o.LATCH.Reg) & 0x10) >> 4
}
func (o *GPIO_Type) SetLATCH_PIN5(value uint32) {
	volatile.StoreUint32(&o.LATCH.Reg, volatile.LoadUint32(&o.LATCH.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetLATCH_PIN5() uint32 {
	return (volatile.LoadUint32(&o.LATCH.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetLATCH_PIN6(value uint32) {
	volatile.StoreUint32(&o.LATCH.Reg, volatile.LoadUint32(&o.LATCH.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetLATCH_PIN6() uint32 {
	return (volatile.LoadUint32(&o.LATCH.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetLATCH_PIN7(value uint32) {
	volatile.StoreUint32(&o.LATCH.Reg, volatile.LoadUint32(&o.LATCH.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetLATCH_PIN7() uint32 {
	return (volatile.LoadUint32(&o.LATCH.Reg) & 0x80) >> 7
}
func (o *GPIO_Type) SetLATCH_PIN8(value uint32) {
	volatile.StoreUint32(&o.LATCH.Reg, volatile.LoadUint32(&o.LATCH.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetLATCH_PIN8() uint32 {
	return (volatile.LoadUint32(&o.LATCH.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetLATCH_PIN9(value uint32) {
	volatile.StoreUint32(&o.LATCH.Reg, volatile.LoadUint32(&o.LATCH.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetLATCH_PIN9() uint32 {
	return (volatile.LoadUint32(&o.LATCH.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetLATCH_PIN10(value uint32) {
	volatile.StoreUint32(&o.LATCH.Reg, volatile.LoadUint32(&o.LATCH.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetLATCH_PIN10() uint32 {
	return (volatile.LoadUint32(&o.LATCH.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetLATCH_PIN11(value uint32) {
	volatile.StoreUint32(&o.LATCH.Reg, volatile.LoadUint32(&o.LATCH.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetLATCH_PIN11() uint32 {
	return (volatile.LoadUint32(&o.LATCH.Reg) & 0x800) >> 11
}
func (o *GPIO_Type) SetLATCH_PIN12(value uint32) {
	volatile.StoreUint32(&o.LATCH.Reg, volatile.LoadUint32(&o.LATCH.Reg)&^(0x1000)|value<<12)
}
func (o *GPIO_Type) GetLATCH_PIN12() uint32 {
	return (volatile.LoadUint32(&o.LATCH.Reg) & 0x1000) >> 12
}
func (o *GPIO_Type) SetLATCH_PIN13(value uint32) {
	volatile.StoreUint32(&o.LATCH.Reg, volatile.LoadUint32(&o.LATCH.Reg)&^(0x2000)|value<<13)
}
func (o *GPIO_Type) GetLATCH_PIN13() uint32 {
	return (volatile.LoadUint32(&o.LATCH.Reg) & 0x2000) >> 13
}
func (o *GPIO_Type) SetLATCH_PIN14(value uint32) {
	volatile.StoreUint32(&o.LATCH.Reg, volatile.LoadUint32(&o.LATCH.Reg)&^(0x4000)|value<<14)
}
func (o *GPIO_Type) GetLATCH_PIN14() uint32 {
	return (volatile.LoadUint32(&o.LATCH.Reg) & 0x4000) >> 14
}
func (o *GPIO_Type) SetLATCH_PIN15(value uint32) {
	volatile.StoreUint32(&o.LATCH.Reg, volatile.LoadUint32(&o.LATCH.Reg)&^(0x8000)|value<<15)
}
func (o *GPIO_Type) GetLATCH_PIN15() uint32 {
	return (volatile.LoadUint32(&o.LATCH.Reg) & 0x8000) >> 15
}
func (o *GPIO_Type) SetLATCH_PIN16(value uint32) {
	volatile.StoreUint32(&o.LATCH.Reg, volatile.LoadUint32(&o.LATCH.Reg)&^(0x10000)|value<<16)
}
func (o *GPIO_Type) GetLATCH_PIN16() uint32 {
	return (volatile.LoadUint32(&o.LATCH.Reg) & 0x10000) >> 16
}
func (o *GPIO_Type) SetLATCH_PIN17(value uint32) {
	volatile.StoreUint32(&o.LATCH.Reg, volatile.LoadUint32(&o.LATCH.Reg)&^(0x20000)|value<<17)
}
func (o *GPIO_Type) GetLATCH_PIN17() uint32 {
	return (volatile.LoadUint32(&o.LATCH.Reg) & 0x20000) >> 17
}
func (o *GPIO_Type) SetLATCH_PIN18(value uint32) {
	volatile.StoreUint32(&o.LATCH.Reg, volatile.LoadUint32(&o.LATCH.Reg)&^(0x40000)|value<<18)
}
func (o *GPIO_Type) GetLATCH_PIN18() uint32 {
	return (volatile.LoadUint32(&o.LATCH.Reg) & 0x40000) >> 18
}
func (o *GPIO_Type) SetLATCH_PIN19(value uint32) {
	volatile.StoreUint32(&o.LATCH.Reg, volatile.LoadUint32(&o.LATCH.Reg)&^(0x80000)|value<<19)
}
func (o *GPIO_Type) GetLATCH_PIN19() uint32 {
	return (volatile.LoadUint32(&o.LATCH.Reg) & 0x80000) >> 19
}
func (o *GPIO_Type) SetLATCH_PIN20(value uint32) {
	volatile.StoreUint32(&o.LATCH.Reg, volatile.LoadUint32(&o.LATCH.Reg)&^(0x100000)|value<<20)
}
func (o *GPIO_Type) GetLATCH_PIN20() uint32 {
	return (volatile.LoadUint32(&o.LATCH.Reg) & 0x100000) >> 20
}
func (o *GPIO_Type) SetLATCH_PIN21(value uint32) {
	volatile.StoreUint32(&o.LATCH.Reg, volatile.LoadUint32(&o.LATCH.Reg)&^(0x200000)|value<<21)
}
func (o *GPIO_Type) GetLATCH_PIN21() uint32 {
	return (volatile.LoadUint32(&o.LATCH.Reg) & 0x200000) >> 21
}
func (o *GPIO_Type) SetLATCH_PIN22(value uint32) {
	volatile.StoreUint32(&o.LATCH.Reg, volatile.LoadUint32(&o.LATCH.Reg)&^(0x400000)|value<<22)
}
func (o *GPIO_Type) GetLATCH_PIN22() uint32 {
	return (volatile.LoadUint32(&o.LATCH.Reg) & 0x400000) >> 22
}
func (o *GPIO_Type) SetLATCH_PIN23(value uint32) {
	volatile.StoreUint32(&o.LATCH.Reg, volatile.LoadUint32(&o.LATCH.Reg)&^(0x800000)|value<<23)
}
func (o *GPIO_Type) GetLATCH_PIN23() uint32 {
	return (volatile.LoadUint32(&o.LATCH.Reg) & 0x800000) >> 23
}
func (o *GPIO_Type) SetLATCH_PIN24(value uint32) {
	volatile.StoreUint32(&o.LATCH.Reg, volatile.LoadUint32(&o.LATCH.Reg)&^(0x1000000)|value<<24)
}
func (o *GPIO_Type) GetLATCH_PIN24() uint32 {
	return (volatile.LoadUint32(&o.LATCH.Reg) & 0x1000000) >> 24
}
func (o *GPIO_Type) SetLATCH_PIN25(value uint32) {
	volatile.StoreUint32(&o.LATCH.Reg, volatile.LoadUint32(&o.LATCH.Reg)&^(0x2000000)|value<<25)
}
func (o *GPIO_Type) GetLATCH_PIN25() uint32 {
	return (volatile.LoadUint32(&o.LATCH.Reg) & 0x2000000) >> 25
}
func (o *GPIO_Type) SetLATCH_PIN26(value uint32) {
	volatile.StoreUint32(&o.LATCH.Reg, volatile.LoadUint32(&o.LATCH.Reg)&^(0x4000000)|value<<26)
}
func (o *GPIO_Type) GetLATCH_PIN26() uint32 {
	return (volatile.LoadUint32(&o.LATCH.Reg) & 0x4000000) >> 26
}
func (o *GPIO_Type) SetLATCH_PIN27(value uint32) {
	volatile.StoreUint32(&o.LATCH.Reg, volatile.LoadUint32(&o.LATCH.Reg)&^(0x8000000)|value<<27)
}
func (o *GPIO_Type) GetLATCH_PIN27() uint32 {
	return (volatile.LoadUint32(&o.LATCH.Reg) & 0x8000000) >> 27
}
func (o *GPIO_Type) SetLATCH_PIN28(value uint32) {
	volatile.StoreUint32(&o.LATCH.Reg, volatile.LoadUint32(&o.LATCH.Reg)&^(0x10000000)|value<<28)
}
func (o *GPIO_Type) GetLATCH_PIN28() uint32 {
	return (volatile.LoadUint32(&o.LATCH.Reg) & 0x10000000) >> 28
}
func (o *GPIO_Type) SetLATCH_PIN29(value uint32) {
	volatile.StoreUint32(&o.LATCH.Reg, volatile.LoadUint32(&o.LATCH.Reg)&^(0x20000000)|value<<29)
}
func (o *GPIO_Type) GetLATCH_PIN29() uint32 {
	return (volatile.LoadUint32(&o.LATCH.Reg) & 0x20000000) >> 29
}
func (o *GPIO_Type) SetLATCH_PIN30(value uint32) {
	volatile.StoreUint32(&o.LATCH.Reg, volatile.LoadUint32(&o.LATCH.Reg)&^(0x40000000)|value<<30)
}
func (o *GPIO_Type) GetLATCH_PIN30() uint32 {
	return (volatile.LoadUint32(&o.LATCH.Reg) & 0x40000000) >> 30
}
func (o *GPIO_Type) SetLATCH_PIN31(value uint32) {
	volatile.StoreUint32(&o.LATCH.Reg, volatile.LoadUint32(&o.LATCH.Reg)&^(0x80000000)|value<<31)
}
func (o *GPIO_Type) GetLATCH_PIN31() uint32 {
	return (volatile.LoadUint32(&o.LATCH.Reg) & 0x80000000) >> 31
}

// GPIO.DETECTMODE: Select between default DETECT signal behavior and LDETECT mode (For non-secure pin only)
func (o *GPIO_Type) SetDETECTMODE(value uint32) {
	volatile.StoreUint32(&o.DETECTMODE.Reg, volatile.LoadUint32(&o.DETECTMODE.Reg)&^(0x1)|value)
}
func (o *GPIO_Type) GetDETECTMODE() uint32 {
	return volatile.LoadUint32(&o.DETECTMODE.Reg) & 0x1
}

// GPIO.DETECTMODE_SEC: Select between default DETECT signal behavior and LDETECT mode (For secure pin only)
func (o *GPIO_Type) SetDETECTMODE_SEC_DETECTMODE(value uint32) {
	volatile.StoreUint32(&o.DETECTMODE_SEC.Reg, volatile.LoadUint32(&o.DETECTMODE_SEC.Reg)&^(0x1)|value)
}
func (o *GPIO_Type) GetDETECTMODE_SEC_DETECTMODE() uint32 {
	return volatile.LoadUint32(&o.DETECTMODE_SEC.Reg) & 0x1
}

// GPIO.PIN_CNF: Description collection: Configuration of GPIO pins
func (o *GPIO_Type) SetPIN_CNF_DIR(idx int, value uint32) {
	volatile.StoreUint32(&o.PIN_CNF[idx].Reg, volatile.LoadUint32(&o.PIN_CNF[idx].Reg)&^(0x1)|value)
}
func (o *GPIO_Type) GetPIN_CNF_DIR(idx int) uint32 {
	return volatile.LoadUint32(&o.PIN_CNF[idx].Reg) & 0x1
}
func (o *GPIO_Type) SetPIN_CNF_INPUT(idx int, value uint32) {
	volatile.StoreUint32(&o.PIN_CNF[idx].Reg, volatile.LoadUint32(&o.PIN_CNF[idx].Reg)&^(0x2)|value<<1)
}
func (o *GPIO_Type) GetPIN_CNF_INPUT(idx int) uint32 {
	return (volatile.LoadUint32(&o.PIN_CNF[idx].Reg) & 0x2) >> 1
}
func (o *GPIO_Type) SetPIN_CNF_PULL(idx int, value uint32) {
	volatile.StoreUint32(&o.PIN_CNF[idx].Reg, volatile.LoadUint32(&o.PIN_CNF[idx].Reg)&^(0xc)|value<<2)
}
func (o *GPIO_Type) GetPIN_CNF_PULL(idx int) uint32 {
	return (volatile.LoadUint32(&o.PIN_CNF[idx].Reg) & 0xc) >> 2
}
func (o *GPIO_Type) SetPIN_CNF_DRIVE(idx int, value uint32) {
	volatile.StoreUint32(&o.PIN_CNF[idx].Reg, volatile.LoadUint32(&o.PIN_CNF[idx].Reg)&^(0xf00)|value<<8)
}
func (o *GPIO_Type) GetPIN_CNF_DRIVE(idx int) uint32 {
	return (volatile.LoadUint32(&o.PIN_CNF[idx].Reg) & 0xf00) >> 8
}
func (o *GPIO_Type) SetPIN_CNF_SENSE(idx int, value uint32) {
	volatile.StoreUint32(&o.PIN_CNF[idx].Reg, volatile.LoadUint32(&o.PIN_CNF[idx].Reg)&^(0x30000)|value<<16)
}
func (o *GPIO_Type) GetPIN_CNF_SENSE(idx int) uint32 {
	return (volatile.LoadUint32(&o.PIN_CNF[idx].Reg) & 0x30000) >> 16
}
func (o *GPIO_Type) SetPIN_CNF_MCUSEL(idx int, value uint32) {
	volatile.StoreUint32(&o.PIN_CNF[idx].Reg, volatile.LoadUint32(&o.PIN_CNF[idx].Reg)&^(0x70000000)|value<<28)
}
func (o *GPIO_Type) GetPIN_CNF_MCUSEL(idx int) uint32 {
	return (volatile.LoadUint32(&o.PIN_CNF[idx].Reg) & 0x70000000) >> 28
}

// Constants for FICR_NS: Factory Information Configuration Registers
const (
	// INFO.CONFIGID: Configuration identifier
	// Position of HWID field.
	FICR_INFO_CONFIGID_HWID_Pos = 0x0
	// Bit mask of HWID field.
	FICR_INFO_CONFIGID_HWID_Msk = 0xffff

	// INFO.DEVICEID: Description collection: Device identifier
	// Position of DEVICEID field.
	FICR_INFO_DEVICEID_DEVICEID_Pos = 0x0
	// Bit mask of DEVICEID field.
	FICR_INFO_DEVICEID_DEVICEID_Msk = 0xffffffff

	// INFO.PART: Part code
	// Position of PART field.
	FICR_INFO_PART_PART_Pos = 0x0
	// Bit mask of PART field.
	FICR_INFO_PART_PART_Msk = 0xffffffff
	// nRF5340
	FICR_INFO_PART_PART_N5340 = 0x5340
	// Unspecified
	FICR_INFO_PART_PART_Unspecified = 0xffffffff

	// INFO.VARIANT: Part Variant, Hardware version and Production configuration
	// Position of VARIANT field.
	FICR_INFO_VARIANT_VARIANT_Pos = 0x0
	// Bit mask of VARIANT field.
	FICR_INFO_VARIANT_VARIANT_Msk = 0xffffffff
	// QKAA
	FICR_INFO_VARIANT_VARIANT_QKAA = 0x514b4141
	// Unspecified
	FICR_INFO_VARIANT_VARIANT_Unspecified = 0xffffffff

	// INFO.PACKAGE: Package option
	// Position of PACKAGE field.
	FICR_INFO_PACKAGE_PACKAGE_Pos = 0x0
	// Bit mask of PACKAGE field.
	FICR_INFO_PACKAGE_PACKAGE_Msk = 0xffffffff
	// QFxx - 94 pin QFN
	FICR_INFO_PACKAGE_PACKAGE_QF = 0x2000
	// Unspecified
	FICR_INFO_PACKAGE_PACKAGE_Unspecified = 0xffffffff

	// INFO.RAM: RAM variant
	// Position of RAM field.
	FICR_INFO_RAM_RAM_Pos = 0x0
	// Bit mask of RAM field.
	FICR_INFO_RAM_RAM_Msk = 0xffffffff
	// 16 kByte RAM
	FICR_INFO_RAM_RAM_K16 = 0x10
	// 32 kByte RAM
	FICR_INFO_RAM_RAM_K32 = 0x20
	// 64 kByte RAM
	FICR_INFO_RAM_RAM_K64 = 0x40
	// 128 kByte RAM
	FICR_INFO_RAM_RAM_K128 = 0x80
	// 256 kByte RAM
	FICR_INFO_RAM_RAM_K256 = 0x100
	// 512 kByte RAM
	FICR_INFO_RAM_RAM_K512 = 0x200
	// Unspecified
	FICR_INFO_RAM_RAM_Unspecified = 0xffffffff

	// INFO.FLASH: Flash variant
	// Position of FLASH field.
	FICR_INFO_FLASH_FLASH_Pos = 0x0
	// Bit mask of FLASH field.
	FICR_INFO_FLASH_FLASH_Msk = 0xffffffff
	// 128 kByte FLASH
	FICR_INFO_FLASH_FLASH_K128 = 0x80
	// 256 kByte FLASH
	FICR_INFO_FLASH_FLASH_K256 = 0x100
	// 512 kByte FLASH
	FICR_INFO_FLASH_FLASH_K512 = 0x200
	// 1 MByte FLASH
	FICR_INFO_FLASH_FLASH_K1024 = 0x400
	// 2 MByte FLASH
	FICR_INFO_FLASH_FLASH_K2048 = 0x800
	// Unspecified
	FICR_INFO_FLASH_FLASH_Unspecified = 0xffffffff

	// INFO.CODEPAGESIZE: Code memory page size in bytes
	// Position of CODEPAGESIZE field.
	FICR_INFO_CODEPAGESIZE_CODEPAGESIZE_Pos = 0x0
	// Bit mask of CODEPAGESIZE field.
	FICR_INFO_CODEPAGESIZE_CODEPAGESIZE_Msk = 0xffffffff
	// 2 kByte
	FICR_INFO_CODEPAGESIZE_CODEPAGESIZE_K2048 = 0x800

	// INFO.CODESIZE: Code memory size
	// Position of CODESIZE field.
	FICR_INFO_CODESIZE_CODESIZE_Pos = 0x0
	// Bit mask of CODESIZE field.
	FICR_INFO_CODESIZE_CODESIZE_Msk = 0xffffffff
	// 128 pages
	FICR_INFO_CODESIZE_CODESIZE_P128 = 0x80

	// INFO.DEVICETYPE: Device type
	// Position of DEVICETYPE field.
	FICR_INFO_DEVICETYPE_DEVICETYPE_Pos = 0x0
	// Bit mask of DEVICETYPE field.
	FICR_INFO_DEVICETYPE_DEVICETYPE_Msk = 0xffffffff
	// Device is an physical DIE
	FICR_INFO_DEVICETYPE_DEVICETYPE_Die = 0x0
	// Device is an FPGA
	FICR_INFO_DEVICETYPE_DEVICETYPE_FPGA = 0xffffffff

	// ER: Description collection: Encryption Root, word n
	// Position of ER field.
	FICR_ER_ER_Pos = 0x0
	// Bit mask of ER field.
	FICR_ER_ER_Msk = 0xffffffff

	// IR: Description collection: Identity Root, word n
	// Position of IR field.
	FICR_IR_IR_Pos = 0x0
	// Bit mask of IR field.
	FICR_IR_IR_Msk = 0xffffffff

	// DEVICEADDRTYPE: Device address type
	// Position of DEVICEADDRTYPE field.
	FICR_DEVICEADDRTYPE_DEVICEADDRTYPE_Pos = 0x0
	// Bit mask of DEVICEADDRTYPE field.
	FICR_DEVICEADDRTYPE_DEVICEADDRTYPE_Msk = 0x1
	// Bit DEVICEADDRTYPE.
	FICR_DEVICEADDRTYPE_DEVICEADDRTYPE = 0x1
	// Public address
	FICR_DEVICEADDRTYPE_DEVICEADDRTYPE_Public = 0x0
	// Random address
	FICR_DEVICEADDRTYPE_DEVICEADDRTYPE_Random = 0x1

	// DEVICEADDR: Description collection: Device address n
	// Position of DEVICEADDR field.
	FICR_DEVICEADDR_DEVICEADDR_Pos = 0x0
	// Bit mask of DEVICEADDR field.
	FICR_DEVICEADDR_DEVICEADDR_Msk = 0xffffffff

	// TRIMCNF.ADDR: Description cluster: Address
	// Position of Address field.
	FICR_TRIMCNF_ADDR_Address_Pos = 0x0
	// Bit mask of Address field.
	FICR_TRIMCNF_ADDR_Address_Msk = 0xffffffff

	// TRIMCNF.DATA: Description cluster: Data
	// Position of Data field.
	FICR_TRIMCNF_DATA_Data_Pos = 0x0
	// Bit mask of Data field.
	FICR_TRIMCNF_DATA_Data_Msk = 0xffffffff
)

// Constants for UICR_NS: User Information Configuration Registers
const (
	// APPROTECT: Access port protection
	// Position of PALL field.
	UICR_APPROTECT_PALL_Pos = 0x0
	// Bit mask of PALL field.
	UICR_APPROTECT_PALL_Msk = 0xffffffff
	// Unprotected
	UICR_APPROTECT_PALL_Unprotected = 0xffffffff
	// Protected
	UICR_APPROTECT_PALL_Protected = 0x0

	// ERASEPROTECT: Erase protection
	// Position of PALL field.
	UICR_ERASEPROTECT_PALL_Pos = 0x0
	// Bit mask of PALL field.
	UICR_ERASEPROTECT_PALL_Msk = 0xffffffff
	// Unprotected
	UICR_ERASEPROTECT_PALL_Unprotected = 0xffffffff
	// Protected
	UICR_ERASEPROTECT_PALL_Protected = 0x0

	// NRFFW: Description collection: Reserved for Nordic firmware design
	// Position of NRFFW field.
	UICR_NRFFW_NRFFW_Pos = 0x0
	// Bit mask of NRFFW field.
	UICR_NRFFW_NRFFW_Msk = 0xffffffff

	// CUSTOMER: Description collection: Reserved for customer
	// Position of CUSTOMER field.
	UICR_CUSTOMER_CUSTOMER_Pos = 0x0
	// Bit mask of CUSTOMER field.
	UICR_CUSTOMER_CUSTOMER_Msk = 0xffffffff
)

// Constants for CTI_NS: Cross-Trigger Interface control. NOTE: this is not a separate peripheral, but describes CM33 functionality.
const (
	// CTICONTROL: CTI Control register
	// Position of GLBEN field.
	CTI_CTICONTROL_GLBEN_Pos = 0x0
	// Bit mask of GLBEN field.
	CTI_CTICONTROL_GLBEN_Msk = 0x1
	// Bit GLBEN.
	CTI_CTICONTROL_GLBEN = 0x1
	// All cross-triggering mapping logic functionality is disabled.
	CTI_CTICONTROL_GLBEN_Disabled = 0x0
	// Cross-triggering mapping logic functionality is enabled.
	CTI_CTICONTROL_GLBEN_Enabled = 0x1

	// CTIINTACK: CTI Interrupt Acknowledge register
	// Position of DEBUGREQ field.
	CTI_CTIINTACK_DEBUGREQ_Pos = 0x0
	// Bit mask of DEBUGREQ field.
	CTI_CTIINTACK_DEBUGREQ_Msk = 0x1
	// Bit DEBUGREQ.
	CTI_CTIINTACK_DEBUGREQ = 0x1
	// Clears the ctitrigout.
	CTI_CTIINTACK_DEBUGREQ_Acknowledge = 0x1
	// Position of CPURESTART field.
	CTI_CTIINTACK_CPURESTART_Pos = 0x1
	// Bit mask of CPURESTART field.
	CTI_CTIINTACK_CPURESTART_Msk = 0x2
	// Bit CPURESTART.
	CTI_CTIINTACK_CPURESTART = 0x2
	// Clears the ctitrigout.
	CTI_CTIINTACK_CPURESTART_Acknowledge = 0x1
	// Position of UNUSED0 field.
	CTI_CTIINTACK_UNUSED0_Pos = 0x2
	// Bit mask of UNUSED0 field.
	CTI_CTIINTACK_UNUSED0_Msk = 0x4
	// Bit UNUSED0.
	CTI_CTIINTACK_UNUSED0 = 0x4
	// Clears the ctitrigout.
	CTI_CTIINTACK_UNUSED0_Acknowledge = 0x1
	// Position of UNUSED1 field.
	CTI_CTIINTACK_UNUSED1_Pos = 0x3
	// Bit mask of UNUSED1 field.
	CTI_CTIINTACK_UNUSED1_Msk = 0x8
	// Bit UNUSED1.
	CTI_CTIINTACK_UNUSED1 = 0x8
	// Clears the ctitrigout.
	CTI_CTIINTACK_UNUSED1_Acknowledge = 0x1
	// Position of UNUSED2 field.
	CTI_CTIINTACK_UNUSED2_Pos = 0x4
	// Bit mask of UNUSED2 field.
	CTI_CTIINTACK_UNUSED2_Msk = 0x10
	// Bit UNUSED2.
	CTI_CTIINTACK_UNUSED2 = 0x10
	// Clears the ctitrigout.
	CTI_CTIINTACK_UNUSED2_Acknowledge = 0x1
	// Position of UNUSED3 field.
	CTI_CTIINTACK_UNUSED3_Pos = 0x5
	// Bit mask of UNUSED3 field.
	CTI_CTIINTACK_UNUSED3_Msk = 0x20
	// Bit UNUSED3.
	CTI_CTIINTACK_UNUSED3 = 0x20
	// Clears the ctitrigout.
	CTI_CTIINTACK_UNUSED3_Acknowledge = 0x1
	// Position of UNUSED4 field.
	CTI_CTIINTACK_UNUSED4_Pos = 0x6
	// Bit mask of UNUSED4 field.
	CTI_CTIINTACK_UNUSED4_Msk = 0x40
	// Bit UNUSED4.
	CTI_CTIINTACK_UNUSED4 = 0x40
	// Clears the ctitrigout.
	CTI_CTIINTACK_UNUSED4_Acknowledge = 0x1
	// Position of UNUSED5 field.
	CTI_CTIINTACK_UNUSED5_Pos = 0x7
	// Bit mask of UNUSED5 field.
	CTI_CTIINTACK_UNUSED5_Msk = 0x80
	// Bit UNUSED5.
	CTI_CTIINTACK_UNUSED5 = 0x80
	// Clears the ctitrigout.
	CTI_CTIINTACK_UNUSED5_Acknowledge = 0x1

	// CTIAPPSET: CTI Application Trigger Set register
	// Position of APPSET_0 field.
	CTI_CTIAPPSET_APPSET_0_Pos = 0x0
	// Bit mask of APPSET_0 field.
	CTI_CTIAPPSET_APPSET_0_Msk = 0x1
	// Bit APPSET_0.
	CTI_CTIAPPSET_APPSET_0 = 0x1
	// Application trigger 0 is inactive.
	CTI_CTIAPPSET_APPSET_0_Inactive = 0x0
	// Application trigger 0 is active.
	CTI_CTIAPPSET_APPSET_0_Active = 0x1
	// Generate channel event for channel 0.
	CTI_CTIAPPSET_APPSET_0_Activate = 0x1
	// Position of APPSET_1 field.
	CTI_CTIAPPSET_APPSET_1_Pos = 0x1
	// Bit mask of APPSET_1 field.
	CTI_CTIAPPSET_APPSET_1_Msk = 0x2
	// Bit APPSET_1.
	CTI_CTIAPPSET_APPSET_1 = 0x2
	// Application trigger 1 is inactive.
	CTI_CTIAPPSET_APPSET_1_Inactive = 0x0
	// Application trigger 1 is active.
	CTI_CTIAPPSET_APPSET_1_Active = 0x1
	// Generate channel event for channel 1.
	CTI_CTIAPPSET_APPSET_1_Activate = 0x1
	// Position of APPSET_2 field.
	CTI_CTIAPPSET_APPSET_2_Pos = 0x2
	// Bit mask of APPSET_2 field.
	CTI_CTIAPPSET_APPSET_2_Msk = 0x4
	// Bit APPSET_2.
	CTI_CTIAPPSET_APPSET_2 = 0x4
	// Application trigger 2 is inactive.
	CTI_CTIAPPSET_APPSET_2_Inactive = 0x0
	// Application trigger 2 is active.
	CTI_CTIAPPSET_APPSET_2_Active = 0x1
	// Generate channel event for channel 2.
	CTI_CTIAPPSET_APPSET_2_Activate = 0x1
	// Position of APPSET_3 field.
	CTI_CTIAPPSET_APPSET_3_Pos = 0x3
	// Bit mask of APPSET_3 field.
	CTI_CTIAPPSET_APPSET_3_Msk = 0x8
	// Bit APPSET_3.
	CTI_CTIAPPSET_APPSET_3 = 0x8
	// Application trigger 3 is inactive.
	CTI_CTIAPPSET_APPSET_3_Inactive = 0x0
	// Application trigger 3 is active.
	CTI_CTIAPPSET_APPSET_3_Active = 0x1
	// Generate channel event for channel 3.
	CTI_CTIAPPSET_APPSET_3_Activate = 0x1

	// CTIAPPCLEAR: CTI Application Trigger Clear register
	// Position of APPCLEAR_0 field.
	CTI_CTIAPPCLEAR_APPCLEAR_0_Pos = 0x0
	// Bit mask of APPCLEAR_0 field.
	CTI_CTIAPPCLEAR_APPCLEAR_0_Msk = 0x1
	// Bit APPCLEAR_0.
	CTI_CTIAPPCLEAR_APPCLEAR_0 = 0x1
	// Clears the event for channel 0.
	CTI_CTIAPPCLEAR_APPCLEAR_0_Clear = 0x1
	// Position of APPCLEAR_1 field.
	CTI_CTIAPPCLEAR_APPCLEAR_1_Pos = 0x1
	// Bit mask of APPCLEAR_1 field.
	CTI_CTIAPPCLEAR_APPCLEAR_1_Msk = 0x2
	// Bit APPCLEAR_1.
	CTI_CTIAPPCLEAR_APPCLEAR_1 = 0x2
	// Clears the event for channel 1.
	CTI_CTIAPPCLEAR_APPCLEAR_1_Clear = 0x1
	// Position of APPCLEAR_2 field.
	CTI_CTIAPPCLEAR_APPCLEAR_2_Pos = 0x2
	// Bit mask of APPCLEAR_2 field.
	CTI_CTIAPPCLEAR_APPCLEAR_2_Msk = 0x4
	// Bit APPCLEAR_2.
	CTI_CTIAPPCLEAR_APPCLEAR_2 = 0x4
	// Clears the event for channel 2.
	CTI_CTIAPPCLEAR_APPCLEAR_2_Clear = 0x1
	// Position of APPCLEAR_3 field.
	CTI_CTIAPPCLEAR_APPCLEAR_3_Pos = 0x3
	// Bit mask of APPCLEAR_3 field.
	CTI_CTIAPPCLEAR_APPCLEAR_3_Msk = 0x8
	// Bit APPCLEAR_3.
	CTI_CTIAPPCLEAR_APPCLEAR_3 = 0x8
	// Clears the event for channel 3.
	CTI_CTIAPPCLEAR_APPCLEAR_3_Clear = 0x1

	// CTIAPPPULSE: CTI Application Pulse register
	// Position of APPULSE_0 field.
	CTI_CTIAPPPULSE_APPULSE_0_Pos = 0x0
	// Bit mask of APPULSE_0 field.
	CTI_CTIAPPPULSE_APPULSE_0_Msk = 0x1
	// Bit APPULSE_0.
	CTI_CTIAPPPULSE_APPULSE_0 = 0x1
	// Generates an event pulse on channel 0.
	CTI_CTIAPPPULSE_APPULSE_0_Generate = 0x1
	// Position of APPULSE_1 field.
	CTI_CTIAPPPULSE_APPULSE_1_Pos = 0x1
	// Bit mask of APPULSE_1 field.
	CTI_CTIAPPPULSE_APPULSE_1_Msk = 0x2
	// Bit APPULSE_1.
	CTI_CTIAPPPULSE_APPULSE_1 = 0x2
	// Generates an event pulse on channel 1.
	CTI_CTIAPPPULSE_APPULSE_1_Generate = 0x1
	// Position of APPULSE_2 field.
	CTI_CTIAPPPULSE_APPULSE_2_Pos = 0x2
	// Bit mask of APPULSE_2 field.
	CTI_CTIAPPPULSE_APPULSE_2_Msk = 0x4
	// Bit APPULSE_2.
	CTI_CTIAPPPULSE_APPULSE_2 = 0x4
	// Generates an event pulse on channel 2.
	CTI_CTIAPPPULSE_APPULSE_2_Generate = 0x1
	// Position of APPULSE_3 field.
	CTI_CTIAPPPULSE_APPULSE_3_Pos = 0x3
	// Bit mask of APPULSE_3 field.
	CTI_CTIAPPPULSE_APPULSE_3_Msk = 0x8
	// Bit APPULSE_3.
	CTI_CTIAPPPULSE_APPULSE_3 = 0x8
	// Generates an event pulse on channel 3.
	CTI_CTIAPPPULSE_APPULSE_3_Generate = 0x1

	// CTIINEN: Description collection: CTI Trigger input
	// Position of TRIGINEN_0 field.
	CTI_CTIINEN_TRIGINEN_0_Pos = 0x0
	// Bit mask of TRIGINEN_0 field.
	CTI_CTIINEN_TRIGINEN_0_Msk = 0x1
	// Bit TRIGINEN_0.
	CTI_CTIINEN_TRIGINEN_0 = 0x1
	// Input trigger n events are ignored by channel 0.
	CTI_CTIINEN_TRIGINEN_0_Disabled = 0x0
	// When an event is received on input trigger n (ctitrigin[n]), generate an event on channel 0.
	CTI_CTIINEN_TRIGINEN_0_Enabled = 0x1
	// Position of TRIGINEN_1 field.
	CTI_CTIINEN_TRIGINEN_1_Pos = 0x1
	// Bit mask of TRIGINEN_1 field.
	CTI_CTIINEN_TRIGINEN_1_Msk = 0x2
	// Bit TRIGINEN_1.
	CTI_CTIINEN_TRIGINEN_1 = 0x2
	// Input trigger n events are ignored by channel 1.
	CTI_CTIINEN_TRIGINEN_1_Disabled = 0x0
	// When an event is received on input trigger n (ctitrigin[n]), generate an event on channel 1.
	CTI_CTIINEN_TRIGINEN_1_Enabled = 0x1
	// Position of TRIGINEN_2 field.
	CTI_CTIINEN_TRIGINEN_2_Pos = 0x2
	// Bit mask of TRIGINEN_2 field.
	CTI_CTIINEN_TRIGINEN_2_Msk = 0x4
	// Bit TRIGINEN_2.
	CTI_CTIINEN_TRIGINEN_2 = 0x4
	// Input trigger n events are ignored by channel 2.
	CTI_CTIINEN_TRIGINEN_2_Disabled = 0x0
	// When an event is received on input trigger n (ctitrigin[n]), generate an event on channel 2.
	CTI_CTIINEN_TRIGINEN_2_Enabled = 0x1
	// Position of TRIGINEN_3 field.
	CTI_CTIINEN_TRIGINEN_3_Pos = 0x3
	// Bit mask of TRIGINEN_3 field.
	CTI_CTIINEN_TRIGINEN_3_Msk = 0x8
	// Bit TRIGINEN_3.
	CTI_CTIINEN_TRIGINEN_3 = 0x8
	// Input trigger n events are ignored by channel 3.
	CTI_CTIINEN_TRIGINEN_3_Disabled = 0x0
	// When an event is received on input trigger n (ctitrigin[n]), generate an event on channel 3.
	CTI_CTIINEN_TRIGINEN_3_Enabled = 0x1

	// CTIOUTEN: Description collection: CTI Trigger output
	// Position of TRIGOUTEN_0 field.
	CTI_CTIOUTEN_TRIGOUTEN_0_Pos = 0x0
	// Bit mask of TRIGOUTEN_0 field.
	CTI_CTIOUTEN_TRIGOUTEN_0_Msk = 0x1
	// Bit TRIGOUTEN_0.
	CTI_CTIOUTEN_TRIGOUTEN_0 = 0x1
	// Channel 0 is ignored by output trigger n.
	CTI_CTIOUTEN_TRIGOUTEN_0_Disabled = 0x0
	// When an event occurs on channel 0, generate an event on output event n (ctitrigout[n]).
	CTI_CTIOUTEN_TRIGOUTEN_0_Enabled = 0x1
	// Position of TRIGOUTEN_1 field.
	CTI_CTIOUTEN_TRIGOUTEN_1_Pos = 0x1
	// Bit mask of TRIGOUTEN_1 field.
	CTI_CTIOUTEN_TRIGOUTEN_1_Msk = 0x2
	// Bit TRIGOUTEN_1.
	CTI_CTIOUTEN_TRIGOUTEN_1 = 0x2
	// Channel 1 is ignored by output trigger n.
	CTI_CTIOUTEN_TRIGOUTEN_1_Disabled = 0x0
	// When an event occurs on channel 1, generate an event on output event n (ctitrigout[n]).
	CTI_CTIOUTEN_TRIGOUTEN_1_Enabled = 0x1
	// Position of TRIGOUTEN_2 field.
	CTI_CTIOUTEN_TRIGOUTEN_2_Pos = 0x2
	// Bit mask of TRIGOUTEN_2 field.
	CTI_CTIOUTEN_TRIGOUTEN_2_Msk = 0x4
	// Bit TRIGOUTEN_2.
	CTI_CTIOUTEN_TRIGOUTEN_2 = 0x4
	// Channel 2 is ignored by output trigger n.
	CTI_CTIOUTEN_TRIGOUTEN_2_Disabled = 0x0
	// When an event occurs on channel 2, generate an event on output event n (ctitrigout[n]).
	CTI_CTIOUTEN_TRIGOUTEN_2_Enabled = 0x1
	// Position of TRIGOUTEN_3 field.
	CTI_CTIOUTEN_TRIGOUTEN_3_Pos = 0x3
	// Bit mask of TRIGOUTEN_3 field.
	CTI_CTIOUTEN_TRIGOUTEN_3_Msk = 0x8
	// Bit TRIGOUTEN_3.
	CTI_CTIOUTEN_TRIGOUTEN_3 = 0x8
	// Channel 3 is ignored by output trigger n.
	CTI_CTIOUTEN_TRIGOUTEN_3_Disabled = 0x0
	// When an event occurs on channel 3, generate an event on output event n (ctitrigout[n]).
	CTI_CTIOUTEN_TRIGOUTEN_3_Enabled = 0x1

	// CTITRIGINSTATUS: CTI Trigger In Status register
	// Position of CPUHALTED field.
	CTI_CTITRIGINSTATUS_CPUHALTED_Pos = 0x0
	// Bit mask of CPUHALTED field.
	CTI_CTITRIGINSTATUS_CPUHALTED_Msk = 0x1
	// Bit CPUHALTED.
	CTI_CTITRIGINSTATUS_CPUHALTED = 0x1
	// Ctitrigin 0 is active.
	CTI_CTITRIGINSTATUS_CPUHALTED_Active = 0x1
	// Ctitrigin 0 is inactive.
	CTI_CTITRIGINSTATUS_CPUHALTED_Inactive = 0x0
	// Position of DWTCOMPOUT0 field.
	CTI_CTITRIGINSTATUS_DWTCOMPOUT0_Pos = 0x1
	// Bit mask of DWTCOMPOUT0 field.
	CTI_CTITRIGINSTATUS_DWTCOMPOUT0_Msk = 0x2
	// Bit DWTCOMPOUT0.
	CTI_CTITRIGINSTATUS_DWTCOMPOUT0 = 0x2
	// Ctitrigin 1 is active.
	CTI_CTITRIGINSTATUS_DWTCOMPOUT0_Active = 0x1
	// Ctitrigin 1 is inactive.
	CTI_CTITRIGINSTATUS_DWTCOMPOUT0_Inactive = 0x0
	// Position of DWTCOMPOUT1 field.
	CTI_CTITRIGINSTATUS_DWTCOMPOUT1_Pos = 0x2
	// Bit mask of DWTCOMPOUT1 field.
	CTI_CTITRIGINSTATUS_DWTCOMPOUT1_Msk = 0x4
	// Bit DWTCOMPOUT1.
	CTI_CTITRIGINSTATUS_DWTCOMPOUT1 = 0x4
	// Ctitrigin 2 is active.
	CTI_CTITRIGINSTATUS_DWTCOMPOUT1_Active = 0x1
	// Ctitrigin 2 is inactive.
	CTI_CTITRIGINSTATUS_DWTCOMPOUT1_Inactive = 0x0
	// Position of DWTCOMPOUT2 field.
	CTI_CTITRIGINSTATUS_DWTCOMPOUT2_Pos = 0x3
	// Bit mask of DWTCOMPOUT2 field.
	CTI_CTITRIGINSTATUS_DWTCOMPOUT2_Msk = 0x8
	// Bit DWTCOMPOUT2.
	CTI_CTITRIGINSTATUS_DWTCOMPOUT2 = 0x8
	// Ctitrigin 3 is active.
	CTI_CTITRIGINSTATUS_DWTCOMPOUT2_Active = 0x1
	// Ctitrigin 3 is inactive.
	CTI_CTITRIGINSTATUS_DWTCOMPOUT2_Inactive = 0x0
	// Position of UNUSED0 field.
	CTI_CTITRIGINSTATUS_UNUSED0_Pos = 0x4
	// Bit mask of UNUSED0 field.
	CTI_CTITRIGINSTATUS_UNUSED0_Msk = 0x10
	// Bit UNUSED0.
	CTI_CTITRIGINSTATUS_UNUSED0 = 0x10
	// Ctitrigin 4 is active.
	CTI_CTITRIGINSTATUS_UNUSED0_Active = 0x1
	// Ctitrigin 4 is inactive.
	CTI_CTITRIGINSTATUS_UNUSED0_Inactive = 0x0
	// Position of UNUSED1 field.
	CTI_CTITRIGINSTATUS_UNUSED1_Pos = 0x5
	// Bit mask of UNUSED1 field.
	CTI_CTITRIGINSTATUS_UNUSED1_Msk = 0x20
	// Bit UNUSED1.
	CTI_CTITRIGINSTATUS_UNUSED1 = 0x20
	// Ctitrigin 5 is active.
	CTI_CTITRIGINSTATUS_UNUSED1_Active = 0x1
	// Ctitrigin 5 is inactive.
	CTI_CTITRIGINSTATUS_UNUSED1_Inactive = 0x0
	// Position of UNUSED2 field.
	CTI_CTITRIGINSTATUS_UNUSED2_Pos = 0x6
	// Bit mask of UNUSED2 field.
	CTI_CTITRIGINSTATUS_UNUSED2_Msk = 0x40
	// Bit UNUSED2.
	CTI_CTITRIGINSTATUS_UNUSED2 = 0x40
	// Ctitrigin 6 is active.
	CTI_CTITRIGINSTATUS_UNUSED2_Active = 0x1
	// Ctitrigin 6 is inactive.
	CTI_CTITRIGINSTATUS_UNUSED2_Inactive = 0x0
	// Position of UNUSED3 field.
	CTI_CTITRIGINSTATUS_UNUSED3_Pos = 0x7
	// Bit mask of UNUSED3 field.
	CTI_CTITRIGINSTATUS_UNUSED3_Msk = 0x80
	// Bit UNUSED3.
	CTI_CTITRIGINSTATUS_UNUSED3 = 0x80
	// Ctitrigin 7 is active.
	CTI_CTITRIGINSTATUS_UNUSED3_Active = 0x1
	// Ctitrigin 7 is inactive.
	CTI_CTITRIGINSTATUS_UNUSED3_Inactive = 0x0

	// CTITRIGOUTSTATUS: CTI Trigger Out Status register
	// Position of DEBUGREQ field.
	CTI_CTITRIGOUTSTATUS_DEBUGREQ_Pos = 0x0
	// Bit mask of DEBUGREQ field.
	CTI_CTITRIGOUTSTATUS_DEBUGREQ_Msk = 0x1
	// Bit DEBUGREQ.
	CTI_CTITRIGOUTSTATUS_DEBUGREQ = 0x1
	// Ctitrigout 0 is active.
	CTI_CTITRIGOUTSTATUS_DEBUGREQ_Active = 0x1
	// Ctitrigout 0 is inactive.
	CTI_CTITRIGOUTSTATUS_DEBUGREQ_Inactive = 0x0
	// Position of CPURESTART field.
	CTI_CTITRIGOUTSTATUS_CPURESTART_Pos = 0x1
	// Bit mask of CPURESTART field.
	CTI_CTITRIGOUTSTATUS_CPURESTART_Msk = 0x2
	// Bit CPURESTART.
	CTI_CTITRIGOUTSTATUS_CPURESTART = 0x2
	// Ctitrigout 1 is active.
	CTI_CTITRIGOUTSTATUS_CPURESTART_Active = 0x1
	// Ctitrigout 1 is inactive.
	CTI_CTITRIGOUTSTATUS_CPURESTART_Inactive = 0x0
	// Position of UNUSED0 field.
	CTI_CTITRIGOUTSTATUS_UNUSED0_Pos = 0x2
	// Bit mask of UNUSED0 field.
	CTI_CTITRIGOUTSTATUS_UNUSED0_Msk = 0x4
	// Bit UNUSED0.
	CTI_CTITRIGOUTSTATUS_UNUSED0 = 0x4
	// Ctitrigout 2 is active.
	CTI_CTITRIGOUTSTATUS_UNUSED0_Active = 0x1
	// Ctitrigout 2 is inactive.
	CTI_CTITRIGOUTSTATUS_UNUSED0_Inactive = 0x0
	// Position of UNUSED1 field.
	CTI_CTITRIGOUTSTATUS_UNUSED1_Pos = 0x3
	// Bit mask of UNUSED1 field.
	CTI_CTITRIGOUTSTATUS_UNUSED1_Msk = 0x8
	// Bit UNUSED1.
	CTI_CTITRIGOUTSTATUS_UNUSED1 = 0x8
	// Ctitrigout 3 is active.
	CTI_CTITRIGOUTSTATUS_UNUSED1_Active = 0x1
	// Ctitrigout 3 is inactive.
	CTI_CTITRIGOUTSTATUS_UNUSED1_Inactive = 0x0
	// Position of UNUSED2 field.
	CTI_CTITRIGOUTSTATUS_UNUSED2_Pos = 0x4
	// Bit mask of UNUSED2 field.
	CTI_CTITRIGOUTSTATUS_UNUSED2_Msk = 0x10
	// Bit UNUSED2.
	CTI_CTITRIGOUTSTATUS_UNUSED2 = 0x10
	// Ctitrigout 4 is active.
	CTI_CTITRIGOUTSTATUS_UNUSED2_Active = 0x1
	// Ctitrigout 4 is inactive.
	CTI_CTITRIGOUTSTATUS_UNUSED2_Inactive = 0x0
	// Position of UNUSED3 field.
	CTI_CTITRIGOUTSTATUS_UNUSED3_Pos = 0x5
	// Bit mask of UNUSED3 field.
	CTI_CTITRIGOUTSTATUS_UNUSED3_Msk = 0x20
	// Bit UNUSED3.
	CTI_CTITRIGOUTSTATUS_UNUSED3 = 0x20
	// Ctitrigout 5 is active.
	CTI_CTITRIGOUTSTATUS_UNUSED3_Active = 0x1
	// Ctitrigout 5 is inactive.
	CTI_CTITRIGOUTSTATUS_UNUSED3_Inactive = 0x0
	// Position of UNUSED4 field.
	CTI_CTITRIGOUTSTATUS_UNUSED4_Pos = 0x6
	// Bit mask of UNUSED4 field.
	CTI_CTITRIGOUTSTATUS_UNUSED4_Msk = 0x40
	// Bit UNUSED4.
	CTI_CTITRIGOUTSTATUS_UNUSED4 = 0x40
	// Ctitrigout 6 is active.
	CTI_CTITRIGOUTSTATUS_UNUSED4_Active = 0x1
	// Ctitrigout 6 is inactive.
	CTI_CTITRIGOUTSTATUS_UNUSED4_Inactive = 0x0
	// Position of UNUSED5 field.
	CTI_CTITRIGOUTSTATUS_UNUSED5_Pos = 0x7
	// Bit mask of UNUSED5 field.
	CTI_CTITRIGOUTSTATUS_UNUSED5_Msk = 0x80
	// Bit UNUSED5.
	CTI_CTITRIGOUTSTATUS_UNUSED5 = 0x80
	// Ctitrigout 7 is active.
	CTI_CTITRIGOUTSTATUS_UNUSED5_Active = 0x1
	// Ctitrigout 7 is inactive.
	CTI_CTITRIGOUTSTATUS_UNUSED5_Inactive = 0x0

	// CTICHINSTATUS: CTI Channel In Status register
	// Position of CTICHINSTATUS_0 field.
	CTI_CTICHINSTATUS_CTICHINSTATUS_0_Pos = 0x0
	// Bit mask of CTICHINSTATUS_0 field.
	CTI_CTICHINSTATUS_CTICHINSTATUS_0_Msk = 0x1
	// Bit CTICHINSTATUS_0.
	CTI_CTICHINSTATUS_CTICHINSTATUS_0 = 0x1
	// Ctichin 0 is active.
	CTI_CTICHINSTATUS_CTICHINSTATUS_0_Active = 0x1
	// Ctichin 0 is inactive.
	CTI_CTICHINSTATUS_CTICHINSTATUS_0_Inactive = 0x0
	// Position of CTICHINSTATUS_1 field.
	CTI_CTICHINSTATUS_CTICHINSTATUS_1_Pos = 0x1
	// Bit mask of CTICHINSTATUS_1 field.
	CTI_CTICHINSTATUS_CTICHINSTATUS_1_Msk = 0x2
	// Bit CTICHINSTATUS_1.
	CTI_CTICHINSTATUS_CTICHINSTATUS_1 = 0x2
	// Ctichin 1 is active.
	CTI_CTICHINSTATUS_CTICHINSTATUS_1_Active = 0x1
	// Ctichin 1 is inactive.
	CTI_CTICHINSTATUS_CTICHINSTATUS_1_Inactive = 0x0
	// Position of CTICHINSTATUS_2 field.
	CTI_CTICHINSTATUS_CTICHINSTATUS_2_Pos = 0x2
	// Bit mask of CTICHINSTATUS_2 field.
	CTI_CTICHINSTATUS_CTICHINSTATUS_2_Msk = 0x4
	// Bit CTICHINSTATUS_2.
	CTI_CTICHINSTATUS_CTICHINSTATUS_2 = 0x4
	// Ctichin 2 is active.
	CTI_CTICHINSTATUS_CTICHINSTATUS_2_Active = 0x1
	// Ctichin 2 is inactive.
	CTI_CTICHINSTATUS_CTICHINSTATUS_2_Inactive = 0x0
	// Position of CTICHINSTATUS_3 field.
	CTI_CTICHINSTATUS_CTICHINSTATUS_3_Pos = 0x3
	// Bit mask of CTICHINSTATUS_3 field.
	CTI_CTICHINSTATUS_CTICHINSTATUS_3_Msk = 0x8
	// Bit CTICHINSTATUS_3.
	CTI_CTICHINSTATUS_CTICHINSTATUS_3 = 0x8
	// Ctichin 3 is active.
	CTI_CTICHINSTATUS_CTICHINSTATUS_3_Active = 0x1
	// Ctichin 3 is inactive.
	CTI_CTICHINSTATUS_CTICHINSTATUS_3_Inactive = 0x0

	// CTIGATE: Enable CTI Channel Gate register
	// Position of CTIGATEEN_0 field.
	CTI_CTIGATE_CTIGATEEN_0_Pos = 0x0
	// Bit mask of CTIGATEEN_0 field.
	CTI_CTIGATE_CTIGATEEN_0_Msk = 0x1
	// Bit CTIGATEEN_0.
	CTI_CTIGATE_CTIGATEEN_0 = 0x1
	// Enable ctichout channel 0 propagation.
	CTI_CTIGATE_CTIGATEEN_0_Enabled = 0x1
	// Disable ctichout channel 0 propagation.
	CTI_CTIGATE_CTIGATEEN_0_Disabled = 0x0
	// Position of CTIGATEEN_1 field.
	CTI_CTIGATE_CTIGATEEN_1_Pos = 0x1
	// Bit mask of CTIGATEEN_1 field.
	CTI_CTIGATE_CTIGATEEN_1_Msk = 0x2
	// Bit CTIGATEEN_1.
	CTI_CTIGATE_CTIGATEEN_1 = 0x2
	// Enable ctichout channel 1 propagation.
	CTI_CTIGATE_CTIGATEEN_1_Enabled = 0x1
	// Disable ctichout channel 1 propagation.
	CTI_CTIGATE_CTIGATEEN_1_Disabled = 0x0
	// Position of CTIGATEEN_2 field.
	CTI_CTIGATE_CTIGATEEN_2_Pos = 0x2
	// Bit mask of CTIGATEEN_2 field.
	CTI_CTIGATE_CTIGATEEN_2_Msk = 0x4
	// Bit CTIGATEEN_2.
	CTI_CTIGATE_CTIGATEEN_2 = 0x4
	// Enable ctichout channel 2 propagation.
	CTI_CTIGATE_CTIGATEEN_2_Enabled = 0x1
	// Disable ctichout channel 2 propagation.
	CTI_CTIGATE_CTIGATEEN_2_Disabled = 0x0
	// Position of CTIGATEEN_3 field.
	CTI_CTIGATE_CTIGATEEN_3_Pos = 0x3
	// Bit mask of CTIGATEEN_3 field.
	CTI_CTIGATE_CTIGATEEN_3_Msk = 0x8
	// Bit CTIGATEEN_3.
	CTI_CTIGATE_CTIGATEEN_3 = 0x8
	// Enable ctichout channel 3 propagation.
	CTI_CTIGATE_CTIGATEEN_3_Enabled = 0x1
	// Disable ctichout channel 3 propagation.
	CTI_CTIGATE_CTIGATEEN_3_Disabled = 0x0

	// DEVARCH: Device Architecture register
	// Position of Architecture field.
	CTI_DEVARCH_Architecture_Pos = 0x0
	// Bit mask of Architecture field.
	CTI_DEVARCH_Architecture_Msk = 0x1
	// Bit Architecture.
	CTI_DEVARCH_Architecture = 0x1

	// DEVID: Device Configuration register
	// Position of EXTMUXNUM field.
	CTI_DEVID_EXTMUXNUM_Pos = 0x0
	// Bit mask of EXTMUXNUM field.
	CTI_DEVID_EXTMUXNUM_Msk = 0x1f
	// Position of NUMTRIG field.
	CTI_DEVID_NUMTRIG_Pos = 0x8
	// Bit mask of NUMTRIG field.
	CTI_DEVID_NUMTRIG_Msk = 0xff00
	// Position of NUMCH field.
	CTI_DEVID_NUMCH_Pos = 0x10
	// Bit mask of NUMCH field.
	CTI_DEVID_NUMCH_Msk = 0xf0000

	// DEVTYPE: Device Type Identifier register
	// Position of MAJOR field.
	CTI_DEVTYPE_MAJOR_Pos = 0x0
	// Bit mask of MAJOR field.
	CTI_DEVTYPE_MAJOR_Msk = 0xf
	// Indicates that this component allows a debugger to control other components in a CoreSight SoC-400 system.
	CTI_DEVTYPE_MAJOR_Controller = 0x4
	// Position of SUB field.
	CTI_DEVTYPE_SUB_Pos = 0x4
	// Bit mask of SUB field.
	CTI_DEVTYPE_SUB_Msk = 0xf0
	// Indicates that this component is a sub-triggering component.
	CTI_DEVTYPE_SUB_Crosstrigger = 0x1

	// PIDR4: Peripheral ID4 Register
	// Position of DES_2 field.
	CTI_PIDR4_DES_2_Pos = 0x0
	// Bit mask of DES_2 field.
	CTI_PIDR4_DES_2_Msk = 0xf
	// JEDEC continuation code
	CTI_PIDR4_DES_2_Code = 0x4
	// Position of SIZE field.
	CTI_PIDR4_SIZE_Pos = 0x4
	// Bit mask of SIZE field.
	CTI_PIDR4_SIZE_Msk = 0xf0

	// PIDR0: Peripheral ID0 Register
	// Position of PART_0 field.
	CTI_PIDR0_PART_0_Pos = 0x0
	// Bit mask of PART_0 field.
	CTI_PIDR0_PART_0_Msk = 0xff
	// Indicates bits[7:0] of the part number of the component.
	CTI_PIDR0_PART_0_PartnumberL = 0x21

	// PIDR1: Peripheral ID1 Register
	// Position of PART_1 field.
	CTI_PIDR1_PART_1_Pos = 0x0
	// Bit mask of PART_1 field.
	CTI_PIDR1_PART_1_Msk = 0xf
	// Indicates bits[11:8] of the part number of the component.
	CTI_PIDR1_PART_1_PartnumberH = 0xd
	// Position of DES_0 field.
	CTI_PIDR1_DES_0_Pos = 0x4
	// Bit mask of DES_0 field.
	CTI_PIDR1_DES_0_Msk = 0xf0
	// ARM. Bits[3:0] of the JEDEC JEP106 Identity Code
	CTI_PIDR1_DES_0_Arm = 0xb

	// PIDR2: Peripheral ID2 Register
	// Position of DES_1 field.
	CTI_PIDR2_DES_1_Pos = 0x0
	// Bit mask of DES_1 field.
	CTI_PIDR2_DES_1_Msk = 0x7
	// ARM. Bits[6:4] of the JEDEC JEP106 Identity Code
	CTI_PIDR2_DES_1_Arm = 0x3
	// Position of JEDEC field.
	CTI_PIDR2_JEDEC_Pos = 0x3
	// Bit mask of JEDEC field.
	CTI_PIDR2_JEDEC_Msk = 0x8
	// Bit JEDEC.
	CTI_PIDR2_JEDEC = 0x8
	// Position of REVISION field.
	CTI_PIDR2_REVISION_Pos = 0x4
	// Bit mask of REVISION field.
	CTI_PIDR2_REVISION_Msk = 0xf0
	// This device is at r0p0
	CTI_PIDR2_REVISION_Rev0p0 = 0x0

	// PIDR3: Peripheral ID3 Register
	// Position of CMOD field.
	CTI_PIDR3_CMOD_Pos = 0x0
	// Bit mask of CMOD field.
	CTI_PIDR3_CMOD_Msk = 0xf
	// Indicates that the customer has not modified this component.
	CTI_PIDR3_CMOD_Unmodified = 0x0
	// Position of REVAND field.
	CTI_PIDR3_REVAND_Pos = 0x4
	// Bit mask of REVAND field.
	CTI_PIDR3_REVAND_Msk = 0xf0
	// Indicates that there are no errata fixes to this component.
	CTI_PIDR3_REVAND_NoErrata = 0x0

	// CIDR0: Component ID0 Register
	// Position of PRMBL_0 field.
	CTI_CIDR0_PRMBL_0_Pos = 0x0
	// Bit mask of PRMBL_0 field.
	CTI_CIDR0_PRMBL_0_Msk = 0xff
	// Bits[7:0] of the identification code.
	CTI_CIDR0_PRMBL_0_Value = 0xd

	// CIDR1: Component ID1 Register
	// Position of PRMBL_1 field.
	CTI_CIDR1_PRMBL_1_Pos = 0x0
	// Bit mask of PRMBL_1 field.
	CTI_CIDR1_PRMBL_1_Msk = 0xf
	// Bits[11:8] of the identification code.
	CTI_CIDR1_PRMBL_1_Value = 0x0
	// Position of CLASS field.
	CTI_CIDR1_CLASS_Pos = 0x4
	// Bit mask of CLASS field.
	CTI_CIDR1_CLASS_Msk = 0xf0
	// Indicates that the component is a CoreSight component.
	CTI_CIDR1_CLASS_Coresight = 0x9

	// CIDR2: Component ID2 Register
	// Position of PRMBL_2 field.
	CTI_CIDR2_PRMBL_2_Pos = 0x0
	// Bit mask of PRMBL_2 field.
	CTI_CIDR2_PRMBL_2_Msk = 0xff
	// Bits[23:16] of the identification code.
	CTI_CIDR2_PRMBL_2_Value = 0x5

	// CIDR3: Component ID3 Register
	// Position of PRMBL_3 field.
	CTI_CIDR3_PRMBL_3_Pos = 0x0
	// Bit mask of PRMBL_3 field.
	CTI_CIDR3_PRMBL_3_Msk = 0xff
	// Bits[31:24] of the identification code.
	CTI_CIDR3_PRMBL_3_Value = 0xb1
)

// Constants for DCNF_NS: Domain configuration management
const (
	// CPUID: CPU ID of this subsystem
	// Position of CPUID field.
	DCNF_CPUID_CPUID_Pos = 0x0
	// Bit mask of CPUID field.
	DCNF_CPUID_CPUID_Msk = 0xff
)

// Constants for VREQCTRL_NS: Voltage request control
const (
	// VREGRADIO.VREQH: Request high voltage on RADIO After requesting high voltage, the user must wait until VREQHREADY is set to Ready
	// Position of VREQH field.
	VREQCTRL_VREGRADIO_VREQH_VREQH_Pos = 0x0
	// Bit mask of VREQH field.
	VREQCTRL_VREGRADIO_VREQH_VREQH_Msk = 0x1
	// Bit VREQH.
	VREQCTRL_VREGRADIO_VREQH_VREQH = 0x1
	// Disable
	VREQCTRL_VREGRADIO_VREQH_VREQH_Disabled = 0x0
	// Enable
	VREQCTRL_VREGRADIO_VREQH_VREQH_Enabled = 0x1

	// VREGRADIO.VREQHREADY: High voltage on RADIO is ready
	// Position of READY field.
	VREQCTRL_VREGRADIO_VREQHREADY_READY_Pos = 0x0
	// Bit mask of READY field.
	VREQCTRL_VREGRADIO_VREQHREADY_READY_Msk = 0x1
	// Bit READY.
	VREQCTRL_VREGRADIO_VREQHREADY_READY = 0x1
	// Not ready
	VREQCTRL_VREGRADIO_VREQHREADY_READY_NotReady = 0x0
	// Ready
	VREQCTRL_VREGRADIO_VREQHREADY_READY_Ready = 0x1
)

// Constants for CLOCK_NS: Clock management
const (
	// TASKS_HFCLKSTART: Start HFCLK128M/HFCLK64M source as selected in HFCLKSRC
	// Position of TASKS_HFCLKSTART field.
	CLOCK_TASKS_HFCLKSTART_TASKS_HFCLKSTART_Pos = 0x0
	// Bit mask of TASKS_HFCLKSTART field.
	CLOCK_TASKS_HFCLKSTART_TASKS_HFCLKSTART_Msk = 0x1
	// Bit TASKS_HFCLKSTART.
	CLOCK_TASKS_HFCLKSTART_TASKS_HFCLKSTART = 0x1
	// Trigger task
	CLOCK_TASKS_HFCLKSTART_TASKS_HFCLKSTART_Trigger = 0x1

	// TASKS_HFCLKSTOP: Stop HFCLK128M/HFCLK64M source
	// Position of TASKS_HFCLKSTOP field.
	CLOCK_TASKS_HFCLKSTOP_TASKS_HFCLKSTOP_Pos = 0x0
	// Bit mask of TASKS_HFCLKSTOP field.
	CLOCK_TASKS_HFCLKSTOP_TASKS_HFCLKSTOP_Msk = 0x1
	// Bit TASKS_HFCLKSTOP.
	CLOCK_TASKS_HFCLKSTOP_TASKS_HFCLKSTOP = 0x1
	// Trigger task
	CLOCK_TASKS_HFCLKSTOP_TASKS_HFCLKSTOP_Trigger = 0x1

	// TASKS_LFCLKSTART: Start LFCLK source as selected in LFCLKSRC
	// Position of TASKS_LFCLKSTART field.
	CLOCK_TASKS_LFCLKSTART_TASKS_LFCLKSTART_Pos = 0x0
	// Bit mask of TASKS_LFCLKSTART field.
	CLOCK_TASKS_LFCLKSTART_TASKS_LFCLKSTART_Msk = 0x1
	// Bit TASKS_LFCLKSTART.
	CLOCK_TASKS_LFCLKSTART_TASKS_LFCLKSTART = 0x1
	// Trigger task
	CLOCK_TASKS_LFCLKSTART_TASKS_LFCLKSTART_Trigger = 0x1

	// TASKS_LFCLKSTOP: Stop LFCLK source
	// Position of TASKS_LFCLKSTOP field.
	CLOCK_TASKS_LFCLKSTOP_TASKS_LFCLKSTOP_Pos = 0x0
	// Bit mask of TASKS_LFCLKSTOP field.
	CLOCK_TASKS_LFCLKSTOP_TASKS_LFCLKSTOP_Msk = 0x1
	// Bit TASKS_LFCLKSTOP.
	CLOCK_TASKS_LFCLKSTOP_TASKS_LFCLKSTOP = 0x1
	// Trigger task
	CLOCK_TASKS_LFCLKSTOP_TASKS_LFCLKSTOP_Trigger = 0x1

	// TASKS_CAL: Start calibration of LFRC oscillator
	// Position of TASKS_CAL field.
	CLOCK_TASKS_CAL_TASKS_CAL_Pos = 0x0
	// Bit mask of TASKS_CAL field.
	CLOCK_TASKS_CAL_TASKS_CAL_Msk = 0x1
	// Bit TASKS_CAL.
	CLOCK_TASKS_CAL_TASKS_CAL = 0x1
	// Trigger task
	CLOCK_TASKS_CAL_TASKS_CAL_Trigger = 0x1

	// SUBSCRIBE_HFCLKSTART: Subscribe configuration for task HFCLKSTART
	// Position of CHIDX field.
	CLOCK_SUBSCRIBE_HFCLKSTART_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	CLOCK_SUBSCRIBE_HFCLKSTART_CHIDX_Msk = 0xff
	// Position of EN field.
	CLOCK_SUBSCRIBE_HFCLKSTART_EN_Pos = 0x1f
	// Bit mask of EN field.
	CLOCK_SUBSCRIBE_HFCLKSTART_EN_Msk = 0x80000000
	// Bit EN.
	CLOCK_SUBSCRIBE_HFCLKSTART_EN = 0x80000000
	// Disable subscription
	CLOCK_SUBSCRIBE_HFCLKSTART_EN_Disabled = 0x0
	// Enable subscription
	CLOCK_SUBSCRIBE_HFCLKSTART_EN_Enabled = 0x1

	// SUBSCRIBE_HFCLKSTOP: Subscribe configuration for task HFCLKSTOP
	// Position of CHIDX field.
	CLOCK_SUBSCRIBE_HFCLKSTOP_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	CLOCK_SUBSCRIBE_HFCLKSTOP_CHIDX_Msk = 0xff
	// Position of EN field.
	CLOCK_SUBSCRIBE_HFCLKSTOP_EN_Pos = 0x1f
	// Bit mask of EN field.
	CLOCK_SUBSCRIBE_HFCLKSTOP_EN_Msk = 0x80000000
	// Bit EN.
	CLOCK_SUBSCRIBE_HFCLKSTOP_EN = 0x80000000
	// Disable subscription
	CLOCK_SUBSCRIBE_HFCLKSTOP_EN_Disabled = 0x0
	// Enable subscription
	CLOCK_SUBSCRIBE_HFCLKSTOP_EN_Enabled = 0x1

	// SUBSCRIBE_LFCLKSTART: Subscribe configuration for task LFCLKSTART
	// Position of CHIDX field.
	CLOCK_SUBSCRIBE_LFCLKSTART_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	CLOCK_SUBSCRIBE_LFCLKSTART_CHIDX_Msk = 0xff
	// Position of EN field.
	CLOCK_SUBSCRIBE_LFCLKSTART_EN_Pos = 0x1f
	// Bit mask of EN field.
	CLOCK_SUBSCRIBE_LFCLKSTART_EN_Msk = 0x80000000
	// Bit EN.
	CLOCK_SUBSCRIBE_LFCLKSTART_EN = 0x80000000
	// Disable subscription
	CLOCK_SUBSCRIBE_LFCLKSTART_EN_Disabled = 0x0
	// Enable subscription
	CLOCK_SUBSCRIBE_LFCLKSTART_EN_Enabled = 0x1

	// SUBSCRIBE_LFCLKSTOP: Subscribe configuration for task LFCLKSTOP
	// Position of CHIDX field.
	CLOCK_SUBSCRIBE_LFCLKSTOP_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	CLOCK_SUBSCRIBE_LFCLKSTOP_CHIDX_Msk = 0xff
	// Position of EN field.
	CLOCK_SUBSCRIBE_LFCLKSTOP_EN_Pos = 0x1f
	// Bit mask of EN field.
	CLOCK_SUBSCRIBE_LFCLKSTOP_EN_Msk = 0x80000000
	// Bit EN.
	CLOCK_SUBSCRIBE_LFCLKSTOP_EN = 0x80000000
	// Disable subscription
	CLOCK_SUBSCRIBE_LFCLKSTOP_EN_Disabled = 0x0
	// Enable subscription
	CLOCK_SUBSCRIBE_LFCLKSTOP_EN_Enabled = 0x1

	// SUBSCRIBE_CAL: Subscribe configuration for task CAL
	// Position of CHIDX field.
	CLOCK_SUBSCRIBE_CAL_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	CLOCK_SUBSCRIBE_CAL_CHIDX_Msk = 0xff
	// Position of EN field.
	CLOCK_SUBSCRIBE_CAL_EN_Pos = 0x1f
	// Bit mask of EN field.
	CLOCK_SUBSCRIBE_CAL_EN_Msk = 0x80000000
	// Bit EN.
	CLOCK_SUBSCRIBE_CAL_EN = 0x80000000
	// Disable subscription
	CLOCK_SUBSCRIBE_CAL_EN_Disabled = 0x0
	// Enable subscription
	CLOCK_SUBSCRIBE_CAL_EN_Enabled = 0x1

	// EVENTS_HFCLKSTARTED: HFCLK128M/HFCLK64M source started
	// Position of EVENTS_HFCLKSTARTED field.
	CLOCK_EVENTS_HFCLKSTARTED_EVENTS_HFCLKSTARTED_Pos = 0x0
	// Bit mask of EVENTS_HFCLKSTARTED field.
	CLOCK_EVENTS_HFCLKSTARTED_EVENTS_HFCLKSTARTED_Msk = 0x1
	// Bit EVENTS_HFCLKSTARTED.
	CLOCK_EVENTS_HFCLKSTARTED_EVENTS_HFCLKSTARTED = 0x1
	// Event not generated
	CLOCK_EVENTS_HFCLKSTARTED_EVENTS_HFCLKSTARTED_NotGenerated = 0x0
	// Event generated
	CLOCK_EVENTS_HFCLKSTARTED_EVENTS_HFCLKSTARTED_Generated = 0x1

	// EVENTS_LFCLKSTARTED: LFCLK source started
	// Position of EVENTS_LFCLKSTARTED field.
	CLOCK_EVENTS_LFCLKSTARTED_EVENTS_LFCLKSTARTED_Pos = 0x0
	// Bit mask of EVENTS_LFCLKSTARTED field.
	CLOCK_EVENTS_LFCLKSTARTED_EVENTS_LFCLKSTARTED_Msk = 0x1
	// Bit EVENTS_LFCLKSTARTED.
	CLOCK_EVENTS_LFCLKSTARTED_EVENTS_LFCLKSTARTED = 0x1
	// Event not generated
	CLOCK_EVENTS_LFCLKSTARTED_EVENTS_LFCLKSTARTED_NotGenerated = 0x0
	// Event generated
	CLOCK_EVENTS_LFCLKSTARTED_EVENTS_LFCLKSTARTED_Generated = 0x1

	// EVENTS_DONE: Calibration of LFRC oscillator complete event
	// Position of EVENTS_DONE field.
	CLOCK_EVENTS_DONE_EVENTS_DONE_Pos = 0x0
	// Bit mask of EVENTS_DONE field.
	CLOCK_EVENTS_DONE_EVENTS_DONE_Msk = 0x1
	// Bit EVENTS_DONE.
	CLOCK_EVENTS_DONE_EVENTS_DONE = 0x1
	// Event not generated
	CLOCK_EVENTS_DONE_EVENTS_DONE_NotGenerated = 0x0
	// Event generated
	CLOCK_EVENTS_DONE_EVENTS_DONE_Generated = 0x1

	// PUBLISH_HFCLKSTARTED: Publish configuration for event HFCLKSTARTED
	// Position of CHIDX field.
	CLOCK_PUBLISH_HFCLKSTARTED_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	CLOCK_PUBLISH_HFCLKSTARTED_CHIDX_Msk = 0xff
	// Position of EN field.
	CLOCK_PUBLISH_HFCLKSTARTED_EN_Pos = 0x1f
	// Bit mask of EN field.
	CLOCK_PUBLISH_HFCLKSTARTED_EN_Msk = 0x80000000
	// Bit EN.
	CLOCK_PUBLISH_HFCLKSTARTED_EN = 0x80000000
	// Disable publishing
	CLOCK_PUBLISH_HFCLKSTARTED_EN_Disabled = 0x0
	// Enable publishing
	CLOCK_PUBLISH_HFCLKSTARTED_EN_Enabled = 0x1

	// PUBLISH_LFCLKSTARTED: Publish configuration for event LFCLKSTARTED
	// Position of CHIDX field.
	CLOCK_PUBLISH_LFCLKSTARTED_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	CLOCK_PUBLISH_LFCLKSTARTED_CHIDX_Msk = 0xff
	// Position of EN field.
	CLOCK_PUBLISH_LFCLKSTARTED_EN_Pos = 0x1f
	// Bit mask of EN field.
	CLOCK_PUBLISH_LFCLKSTARTED_EN_Msk = 0x80000000
	// Bit EN.
	CLOCK_PUBLISH_LFCLKSTARTED_EN = 0x80000000
	// Disable publishing
	CLOCK_PUBLISH_LFCLKSTARTED_EN_Disabled = 0x0
	// Enable publishing
	CLOCK_PUBLISH_LFCLKSTARTED_EN_Enabled = 0x1

	// PUBLISH_DONE: Publish configuration for event DONE
	// Position of CHIDX field.
	CLOCK_PUBLISH_DONE_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	CLOCK_PUBLISH_DONE_CHIDX_Msk = 0xff
	// Position of EN field.
	CLOCK_PUBLISH_DONE_EN_Pos = 0x1f
	// Bit mask of EN field.
	CLOCK_PUBLISH_DONE_EN_Msk = 0x80000000
	// Bit EN.
	CLOCK_PUBLISH_DONE_EN = 0x80000000
	// Disable publishing
	CLOCK_PUBLISH_DONE_EN_Disabled = 0x0
	// Enable publishing
	CLOCK_PUBLISH_DONE_EN_Enabled = 0x1

	// INTEN: Enable or disable interrupt
	// Position of HFCLKSTARTED field.
	CLOCK_INTEN_HFCLKSTARTED_Pos = 0x0
	// Bit mask of HFCLKSTARTED field.
	CLOCK_INTEN_HFCLKSTARTED_Msk = 0x1
	// Bit HFCLKSTARTED.
	CLOCK_INTEN_HFCLKSTARTED = 0x1
	// Disable
	CLOCK_INTEN_HFCLKSTARTED_Disabled = 0x0
	// Enable
	CLOCK_INTEN_HFCLKSTARTED_Enabled = 0x1
	// Position of LFCLKSTARTED field.
	CLOCK_INTEN_LFCLKSTARTED_Pos = 0x1
	// Bit mask of LFCLKSTARTED field.
	CLOCK_INTEN_LFCLKSTARTED_Msk = 0x2
	// Bit LFCLKSTARTED.
	CLOCK_INTEN_LFCLKSTARTED = 0x2
	// Disable
	CLOCK_INTEN_LFCLKSTARTED_Disabled = 0x0
	// Enable
	CLOCK_INTEN_LFCLKSTARTED_Enabled = 0x1
	// Position of DONE field.
	CLOCK_INTEN_DONE_Pos = 0x7
	// Bit mask of DONE field.
	CLOCK_INTEN_DONE_Msk = 0x80
	// Bit DONE.
	CLOCK_INTEN_DONE = 0x80
	// Disable
	CLOCK_INTEN_DONE_Disabled = 0x0
	// Enable
	CLOCK_INTEN_DONE_Enabled = 0x1

	// INTENSET: Enable interrupt
	// Position of HFCLKSTARTED field.
	CLOCK_INTENSET_HFCLKSTARTED_Pos = 0x0
	// Bit mask of HFCLKSTARTED field.
	CLOCK_INTENSET_HFCLKSTARTED_Msk = 0x1
	// Bit HFCLKSTARTED.
	CLOCK_INTENSET_HFCLKSTARTED = 0x1
	// Read: Disabled
	CLOCK_INTENSET_HFCLKSTARTED_Disabled = 0x0
	// Read: Enabled
	CLOCK_INTENSET_HFCLKSTARTED_Enabled = 0x1
	// Enable
	CLOCK_INTENSET_HFCLKSTARTED_Set = 0x1
	// Position of LFCLKSTARTED field.
	CLOCK_INTENSET_LFCLKSTARTED_Pos = 0x1
	// Bit mask of LFCLKSTARTED field.
	CLOCK_INTENSET_LFCLKSTARTED_Msk = 0x2
	// Bit LFCLKSTARTED.
	CLOCK_INTENSET_LFCLKSTARTED = 0x2
	// Read: Disabled
	CLOCK_INTENSET_LFCLKSTARTED_Disabled = 0x0
	// Read: Enabled
	CLOCK_INTENSET_LFCLKSTARTED_Enabled = 0x1
	// Enable
	CLOCK_INTENSET_LFCLKSTARTED_Set = 0x1
	// Position of DONE field.
	CLOCK_INTENSET_DONE_Pos = 0x7
	// Bit mask of DONE field.
	CLOCK_INTENSET_DONE_Msk = 0x80
	// Bit DONE.
	CLOCK_INTENSET_DONE = 0x80
	// Read: Disabled
	CLOCK_INTENSET_DONE_Disabled = 0x0
	// Read: Enabled
	CLOCK_INTENSET_DONE_Enabled = 0x1
	// Enable
	CLOCK_INTENSET_DONE_Set = 0x1

	// INTENCLR: Disable interrupt
	// Position of HFCLKSTARTED field.
	CLOCK_INTENCLR_HFCLKSTARTED_Pos = 0x0
	// Bit mask of HFCLKSTARTED field.
	CLOCK_INTENCLR_HFCLKSTARTED_Msk = 0x1
	// Bit HFCLKSTARTED.
	CLOCK_INTENCLR_HFCLKSTARTED = 0x1
	// Read: Disabled
	CLOCK_INTENCLR_HFCLKSTARTED_Disabled = 0x0
	// Read: Enabled
	CLOCK_INTENCLR_HFCLKSTARTED_Enabled = 0x1
	// Disable
	CLOCK_INTENCLR_HFCLKSTARTED_Clear = 0x1
	// Position of LFCLKSTARTED field.
	CLOCK_INTENCLR_LFCLKSTARTED_Pos = 0x1
	// Bit mask of LFCLKSTARTED field.
	CLOCK_INTENCLR_LFCLKSTARTED_Msk = 0x2
	// Bit LFCLKSTARTED.
	CLOCK_INTENCLR_LFCLKSTARTED = 0x2
	// Read: Disabled
	CLOCK_INTENCLR_LFCLKSTARTED_Disabled = 0x0
	// Read: Enabled
	CLOCK_INTENCLR_LFCLKSTARTED_Enabled = 0x1
	// Disable
	CLOCK_INTENCLR_LFCLKSTARTED_Clear = 0x1
	// Position of DONE field.
	CLOCK_INTENCLR_DONE_Pos = 0x7
	// Bit mask of DONE field.
	CLOCK_INTENCLR_DONE_Msk = 0x80
	// Bit DONE.
	CLOCK_INTENCLR_DONE = 0x80
	// Read: Disabled
	CLOCK_INTENCLR_DONE_Disabled = 0x0
	// Read: Enabled
	CLOCK_INTENCLR_DONE_Enabled = 0x1
	// Disable
	CLOCK_INTENCLR_DONE_Clear = 0x1

	// INTPEND: Pending interrupts
	// Position of HFCLKSTARTED field.
	CLOCK_INTPEND_HFCLKSTARTED_Pos = 0x0
	// Bit mask of HFCLKSTARTED field.
	CLOCK_INTPEND_HFCLKSTARTED_Msk = 0x1
	// Bit HFCLKSTARTED.
	CLOCK_INTPEND_HFCLKSTARTED = 0x1
	// Read: Not pending
	CLOCK_INTPEND_HFCLKSTARTED_NotPending = 0x0
	// Read: Pending
	CLOCK_INTPEND_HFCLKSTARTED_Pending = 0x1
	// Position of LFCLKSTARTED field.
	CLOCK_INTPEND_LFCLKSTARTED_Pos = 0x1
	// Bit mask of LFCLKSTARTED field.
	CLOCK_INTPEND_LFCLKSTARTED_Msk = 0x2
	// Bit LFCLKSTARTED.
	CLOCK_INTPEND_LFCLKSTARTED = 0x2
	// Read: Not pending
	CLOCK_INTPEND_LFCLKSTARTED_NotPending = 0x0
	// Read: Pending
	CLOCK_INTPEND_LFCLKSTARTED_Pending = 0x1
	// Position of DONE field.
	CLOCK_INTPEND_DONE_Pos = 0x7
	// Bit mask of DONE field.
	CLOCK_INTPEND_DONE_Msk = 0x80
	// Bit DONE.
	CLOCK_INTPEND_DONE = 0x80
	// Read: Not pending
	CLOCK_INTPEND_DONE_NotPending = 0x0
	// Read: Pending
	CLOCK_INTPEND_DONE_Pending = 0x1

	// HFCLKRUN: Status indicating that HFCLKSTART task has been triggered
	// Position of STATUS field.
	CLOCK_HFCLKRUN_STATUS_Pos = 0x0
	// Bit mask of STATUS field.
	CLOCK_HFCLKRUN_STATUS_Msk = 0x1
	// Bit STATUS.
	CLOCK_HFCLKRUN_STATUS = 0x1
	// Task not triggered
	CLOCK_HFCLKRUN_STATUS_NotTriggered = 0x0
	// Task triggered
	CLOCK_HFCLKRUN_STATUS_Triggered = 0x1

	// HFCLKSTAT: Status indicating which HFCLK128M/HFCLK64M source is running This register value in any CLOCK instance reflects status only due to configurations/actions in that CLOCK instance.
	// Position of SRC field.
	CLOCK_HFCLKSTAT_SRC_Pos = 0x0
	// Bit mask of SRC field.
	CLOCK_HFCLKSTAT_SRC_Msk = 0x1
	// Bit SRC.
	CLOCK_HFCLKSTAT_SRC = 0x1
	// Clock source: HFINT - 128 MHz on-chip oscillator
	CLOCK_HFCLKSTAT_SRC_HFINT = 0x0
	// Clock source: HFXO - 128 MHz clock derived from external 32 MHz crystal oscillator
	CLOCK_HFCLKSTAT_SRC_HFXO = 0x1
	// Position of ALWAYSRUNNING field.
	CLOCK_HFCLKSTAT_ALWAYSRUNNING_Pos = 0x4
	// Bit mask of ALWAYSRUNNING field.
	CLOCK_HFCLKSTAT_ALWAYSRUNNING_Msk = 0x10
	// Bit ALWAYSRUNNING.
	CLOCK_HFCLKSTAT_ALWAYSRUNNING = 0x10
	// Automatic clock control enabled
	CLOCK_HFCLKSTAT_ALWAYSRUNNING_NotRunning = 0x0
	// Oscillator is always running
	CLOCK_HFCLKSTAT_ALWAYSRUNNING_Running = 0x1
	// Position of STATE field.
	CLOCK_HFCLKSTAT_STATE_Pos = 0x10
	// Bit mask of STATE field.
	CLOCK_HFCLKSTAT_STATE_Msk = 0x10000
	// Bit STATE.
	CLOCK_HFCLKSTAT_STATE = 0x10000
	// HFCLK not running
	CLOCK_HFCLKSTAT_STATE_NotRunning = 0x0
	// HFCLK running
	CLOCK_HFCLKSTAT_STATE_Running = 0x1

	// LFCLKRUN: Status indicating that LFCLKSTART task has been triggered
	// Position of STATUS field.
	CLOCK_LFCLKRUN_STATUS_Pos = 0x0
	// Bit mask of STATUS field.
	CLOCK_LFCLKRUN_STATUS_Msk = 0x1
	// Bit STATUS.
	CLOCK_LFCLKRUN_STATUS = 0x1
	// Task not triggered
	CLOCK_LFCLKRUN_STATUS_NotTriggered = 0x0
	// Task triggered
	CLOCK_LFCLKRUN_STATUS_Triggered = 0x1

	// LFCLKSTAT: Status indicating which LFCLK source is running This register value in any CLOCK instance reflects status only due to configurations/actions in that CLOCK instance.
	// Position of SRC field.
	CLOCK_LFCLKSTAT_SRC_Pos = 0x0
	// Bit mask of SRC field.
	CLOCK_LFCLKSTAT_SRC_Msk = 0x3
	// 32.768 kHz ultra-low power RC oscillator
	CLOCK_LFCLKSTAT_SRC_LFULP = 0x0
	// 32.768 kHz RC oscillator
	CLOCK_LFCLKSTAT_SRC_LFRC = 0x1
	// 32.768 kHz crystal oscillator
	CLOCK_LFCLKSTAT_SRC_LFXO = 0x2
	// 32.768 kHz synthesized from HFCLK
	CLOCK_LFCLKSTAT_SRC_LFSYNT = 0x3
	// Position of ALWAYSRUNNING field.
	CLOCK_LFCLKSTAT_ALWAYSRUNNING_Pos = 0x4
	// Bit mask of ALWAYSRUNNING field.
	CLOCK_LFCLKSTAT_ALWAYSRUNNING_Msk = 0x10
	// Bit ALWAYSRUNNING.
	CLOCK_LFCLKSTAT_ALWAYSRUNNING = 0x10
	// Automatic clock control enabled
	CLOCK_LFCLKSTAT_ALWAYSRUNNING_NotRunning = 0x0
	// Oscillator is always running
	CLOCK_LFCLKSTAT_ALWAYSRUNNING_Running = 0x1
	// Position of STATE field.
	CLOCK_LFCLKSTAT_STATE_Pos = 0x10
	// Bit mask of STATE field.
	CLOCK_LFCLKSTAT_STATE_Msk = 0x10000
	// Bit STATE.
	CLOCK_LFCLKSTAT_STATE = 0x10000
	// LFCLK not running
	CLOCK_LFCLKSTAT_STATE_NotRunning = 0x0
	// LFCLK running
	CLOCK_LFCLKSTAT_STATE_Running = 0x1

	// LFCLKSRCCOPY: Copy of LFCLKSRC register, set when LFCLKSTART task was triggered
	// Position of SRC field.
	CLOCK_LFCLKSRCCOPY_SRC_Pos = 0x0
	// Bit mask of SRC field.
	CLOCK_LFCLKSRCCOPY_SRC_Msk = 0x3
	// 32.768 kHz ultra-low power RC oscillator
	CLOCK_LFCLKSRCCOPY_SRC_LFULP = 0x0
	// 32.768 kHz RC oscillator
	CLOCK_LFCLKSRCCOPY_SRC_LFRC = 0x1
	// 32.768 kHz crystal oscillator
	CLOCK_LFCLKSRCCOPY_SRC_LFXO = 0x2
	// 32.768 kHz synthesized from HFCLK
	CLOCK_LFCLKSRCCOPY_SRC_LFSYNT = 0x3

	// HFCLKSRC: Clock source for HFCLK128M/HFCLK64M
	// Position of SRC field.
	CLOCK_HFCLKSRC_SRC_Pos = 0x0
	// Bit mask of SRC field.
	CLOCK_HFCLKSRC_SRC_Msk = 0x1
	// Bit SRC.
	CLOCK_HFCLKSRC_SRC = 0x1
	// HFCLKSTART task starts HFINT oscillator
	CLOCK_HFCLKSRC_SRC_HFINT = 0x0
	// HFCLKSTART task starts HFXO oscillator
	CLOCK_HFCLKSRC_SRC_HFXO = 0x1

	// LFCLKSRC: Clock source for LFCLK
	// Position of SRC field.
	CLOCK_LFCLKSRC_SRC_Pos = 0x0
	// Bit mask of SRC field.
	CLOCK_LFCLKSRC_SRC_Msk = 0x3
	// 32.768 kHz ultra-low power RC oscillator
	CLOCK_LFCLKSRC_SRC_LFULP = 0x0
	// 32.768 kHz RC oscillator
	CLOCK_LFCLKSRC_SRC_LFRC = 0x1
	// 32.768 kHz crystal oscillator
	CLOCK_LFCLKSRC_SRC_LFXO = 0x2
	// 32.768 kHz synthesized from HFCLK
	CLOCK_LFCLKSRC_SRC_LFSYNT = 0x3

	// HFCLKCTRL: HFCLK128M frequency configuration
	// Position of HCLK field.
	CLOCK_HFCLKCTRL_HCLK_Pos = 0x0
	// Bit mask of HCLK field.
	CLOCK_HFCLKCTRL_HCLK_Msk = 0x3
	// Divide HFCLK by 1
	CLOCK_HFCLKCTRL_HCLK_Div1 = 0x0
	// Divide HFCLK by 2
	CLOCK_HFCLKCTRL_HCLK_Div2 = 0x1

	// HFCLKALWAYSRUN: Automatic or manual control of HFCLK128M/HFCLK64M
	// Position of ALWAYSRUN field.
	CLOCK_HFCLKALWAYSRUN_ALWAYSRUN_Pos = 0x0
	// Bit mask of ALWAYSRUN field.
	CLOCK_HFCLKALWAYSRUN_ALWAYSRUN_Msk = 0x1
	// Bit ALWAYSRUN.
	CLOCK_HFCLKALWAYSRUN_ALWAYSRUN = 0x1
	// Use automatic clock control
	CLOCK_HFCLKALWAYSRUN_ALWAYSRUN_Automatic = 0x0
	// Ensure clock is always running
	CLOCK_HFCLKALWAYSRUN_ALWAYSRUN_AlwaysRun = 0x1

	// LFCLKALWAYSRUN: Automatic or manual control of LFCLK
	// Position of ALWAYSRUN field.
	CLOCK_LFCLKALWAYSRUN_ALWAYSRUN_Pos = 0x0
	// Bit mask of ALWAYSRUN field.
	CLOCK_LFCLKALWAYSRUN_ALWAYSRUN_Msk = 0x1
	// Bit ALWAYSRUN.
	CLOCK_LFCLKALWAYSRUN_ALWAYSRUN = 0x1
	// Use automatic clock control
	CLOCK_LFCLKALWAYSRUN_ALWAYSRUN_Automatic = 0x0
	// Ensure clock is always running
	CLOCK_LFCLKALWAYSRUN_ALWAYSRUN_AlwaysRun = 0x1
)

// Constants for POWER_NS: Power control
const (
	// TASKS_CONSTLAT: Enable Constant Latency mode
	// Position of TASKS_CONSTLAT field.
	POWER_TASKS_CONSTLAT_TASKS_CONSTLAT_Pos = 0x0
	// Bit mask of TASKS_CONSTLAT field.
	POWER_TASKS_CONSTLAT_TASKS_CONSTLAT_Msk = 0x1
	// Bit TASKS_CONSTLAT.
	POWER_TASKS_CONSTLAT_TASKS_CONSTLAT = 0x1
	// Trigger task
	POWER_TASKS_CONSTLAT_TASKS_CONSTLAT_Trigger = 0x1

	// TASKS_LOWPWR: Enable Low-Power mode (variable latency)
	// Position of TASKS_LOWPWR field.
	POWER_TASKS_LOWPWR_TASKS_LOWPWR_Pos = 0x0
	// Bit mask of TASKS_LOWPWR field.
	POWER_TASKS_LOWPWR_TASKS_LOWPWR_Msk = 0x1
	// Bit TASKS_LOWPWR.
	POWER_TASKS_LOWPWR_TASKS_LOWPWR = 0x1
	// Trigger task
	POWER_TASKS_LOWPWR_TASKS_LOWPWR_Trigger = 0x1

	// SUBSCRIBE_CONSTLAT: Subscribe configuration for task CONSTLAT
	// Position of CHIDX field.
	POWER_SUBSCRIBE_CONSTLAT_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	POWER_SUBSCRIBE_CONSTLAT_CHIDX_Msk = 0xff
	// Position of EN field.
	POWER_SUBSCRIBE_CONSTLAT_EN_Pos = 0x1f
	// Bit mask of EN field.
	POWER_SUBSCRIBE_CONSTLAT_EN_Msk = 0x80000000
	// Bit EN.
	POWER_SUBSCRIBE_CONSTLAT_EN = 0x80000000
	// Disable subscription
	POWER_SUBSCRIBE_CONSTLAT_EN_Disabled = 0x0
	// Enable subscription
	POWER_SUBSCRIBE_CONSTLAT_EN_Enabled = 0x1

	// SUBSCRIBE_LOWPWR: Subscribe configuration for task LOWPWR
	// Position of CHIDX field.
	POWER_SUBSCRIBE_LOWPWR_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	POWER_SUBSCRIBE_LOWPWR_CHIDX_Msk = 0xff
	// Position of EN field.
	POWER_SUBSCRIBE_LOWPWR_EN_Pos = 0x1f
	// Bit mask of EN field.
	POWER_SUBSCRIBE_LOWPWR_EN_Msk = 0x80000000
	// Bit EN.
	POWER_SUBSCRIBE_LOWPWR_EN = 0x80000000
	// Disable subscription
	POWER_SUBSCRIBE_LOWPWR_EN_Disabled = 0x0
	// Enable subscription
	POWER_SUBSCRIBE_LOWPWR_EN_Enabled = 0x1

	// EVENTS_POFWARN: Power failure warning
	// Position of EVENTS_POFWARN field.
	POWER_EVENTS_POFWARN_EVENTS_POFWARN_Pos = 0x0
	// Bit mask of EVENTS_POFWARN field.
	POWER_EVENTS_POFWARN_EVENTS_POFWARN_Msk = 0x1
	// Bit EVENTS_POFWARN.
	POWER_EVENTS_POFWARN_EVENTS_POFWARN = 0x1
	// Event not generated
	POWER_EVENTS_POFWARN_EVENTS_POFWARN_NotGenerated = 0x0
	// Event generated
	POWER_EVENTS_POFWARN_EVENTS_POFWARN_Generated = 0x1

	// EVENTS_SLEEPENTER: CPU entered WFI/WFE sleep
	// Position of EVENTS_SLEEPENTER field.
	POWER_EVENTS_SLEEPENTER_EVENTS_SLEEPENTER_Pos = 0x0
	// Bit mask of EVENTS_SLEEPENTER field.
	POWER_EVENTS_SLEEPENTER_EVENTS_SLEEPENTER_Msk = 0x1
	// Bit EVENTS_SLEEPENTER.
	POWER_EVENTS_SLEEPENTER_EVENTS_SLEEPENTER = 0x1
	// Event not generated
	POWER_EVENTS_SLEEPENTER_EVENTS_SLEEPENTER_NotGenerated = 0x0
	// Event generated
	POWER_EVENTS_SLEEPENTER_EVENTS_SLEEPENTER_Generated = 0x1

	// EVENTS_SLEEPEXIT: CPU exited WFI/WFE sleep
	// Position of EVENTS_SLEEPEXIT field.
	POWER_EVENTS_SLEEPEXIT_EVENTS_SLEEPEXIT_Pos = 0x0
	// Bit mask of EVENTS_SLEEPEXIT field.
	POWER_EVENTS_SLEEPEXIT_EVENTS_SLEEPEXIT_Msk = 0x1
	// Bit EVENTS_SLEEPEXIT.
	POWER_EVENTS_SLEEPEXIT_EVENTS_SLEEPEXIT = 0x1
	// Event not generated
	POWER_EVENTS_SLEEPEXIT_EVENTS_SLEEPEXIT_NotGenerated = 0x0
	// Event generated
	POWER_EVENTS_SLEEPEXIT_EVENTS_SLEEPEXIT_Generated = 0x1

	// PUBLISH_POFWARN: Publish configuration for event POFWARN
	// Position of CHIDX field.
	POWER_PUBLISH_POFWARN_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	POWER_PUBLISH_POFWARN_CHIDX_Msk = 0xff
	// Position of EN field.
	POWER_PUBLISH_POFWARN_EN_Pos = 0x1f
	// Bit mask of EN field.
	POWER_PUBLISH_POFWARN_EN_Msk = 0x80000000
	// Bit EN.
	POWER_PUBLISH_POFWARN_EN = 0x80000000
	// Disable publishing
	POWER_PUBLISH_POFWARN_EN_Disabled = 0x0
	// Enable publishing
	POWER_PUBLISH_POFWARN_EN_Enabled = 0x1

	// PUBLISH_SLEEPENTER: Publish configuration for event SLEEPENTER
	// Position of CHIDX field.
	POWER_PUBLISH_SLEEPENTER_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	POWER_PUBLISH_SLEEPENTER_CHIDX_Msk = 0xff
	// Position of EN field.
	POWER_PUBLISH_SLEEPENTER_EN_Pos = 0x1f
	// Bit mask of EN field.
	POWER_PUBLISH_SLEEPENTER_EN_Msk = 0x80000000
	// Bit EN.
	POWER_PUBLISH_SLEEPENTER_EN = 0x80000000
	// Disable publishing
	POWER_PUBLISH_SLEEPENTER_EN_Disabled = 0x0
	// Enable publishing
	POWER_PUBLISH_SLEEPENTER_EN_Enabled = 0x1

	// PUBLISH_SLEEPEXIT: Publish configuration for event SLEEPEXIT
	// Position of CHIDX field.
	POWER_PUBLISH_SLEEPEXIT_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	POWER_PUBLISH_SLEEPEXIT_CHIDX_Msk = 0xff
	// Position of EN field.
	POWER_PUBLISH_SLEEPEXIT_EN_Pos = 0x1f
	// Bit mask of EN field.
	POWER_PUBLISH_SLEEPEXIT_EN_Msk = 0x80000000
	// Bit EN.
	POWER_PUBLISH_SLEEPEXIT_EN = 0x80000000
	// Disable publishing
	POWER_PUBLISH_SLEEPEXIT_EN_Disabled = 0x0
	// Enable publishing
	POWER_PUBLISH_SLEEPEXIT_EN_Enabled = 0x1

	// INTEN: Enable or disable interrupt
	// Position of POFWARN field.
	POWER_INTEN_POFWARN_Pos = 0x2
	// Bit mask of POFWARN field.
	POWER_INTEN_POFWARN_Msk = 0x4
	// Bit POFWARN.
	POWER_INTEN_POFWARN = 0x4
	// Disable
	POWER_INTEN_POFWARN_Disabled = 0x0
	// Enable
	POWER_INTEN_POFWARN_Enabled = 0x1
	// Position of SLEEPENTER field.
	POWER_INTEN_SLEEPENTER_Pos = 0x5
	// Bit mask of SLEEPENTER field.
	POWER_INTEN_SLEEPENTER_Msk = 0x20
	// Bit SLEEPENTER.
	POWER_INTEN_SLEEPENTER = 0x20
	// Disable
	POWER_INTEN_SLEEPENTER_Disabled = 0x0
	// Enable
	POWER_INTEN_SLEEPENTER_Enabled = 0x1
	// Position of SLEEPEXIT field.
	POWER_INTEN_SLEEPEXIT_Pos = 0x6
	// Bit mask of SLEEPEXIT field.
	POWER_INTEN_SLEEPEXIT_Msk = 0x40
	// Bit SLEEPEXIT.
	POWER_INTEN_SLEEPEXIT = 0x40
	// Disable
	POWER_INTEN_SLEEPEXIT_Disabled = 0x0
	// Enable
	POWER_INTEN_SLEEPEXIT_Enabled = 0x1

	// INTENSET: Enable interrupt
	// Position of POFWARN field.
	POWER_INTENSET_POFWARN_Pos = 0x2
	// Bit mask of POFWARN field.
	POWER_INTENSET_POFWARN_Msk = 0x4
	// Bit POFWARN.
	POWER_INTENSET_POFWARN = 0x4
	// Read: Disabled
	POWER_INTENSET_POFWARN_Disabled = 0x0
	// Read: Enabled
	POWER_INTENSET_POFWARN_Enabled = 0x1
	// Enable
	POWER_INTENSET_POFWARN_Set = 0x1
	// Position of SLEEPENTER field.
	POWER_INTENSET_SLEEPENTER_Pos = 0x5
	// Bit mask of SLEEPENTER field.
	POWER_INTENSET_SLEEPENTER_Msk = 0x20
	// Bit SLEEPENTER.
	POWER_INTENSET_SLEEPENTER = 0x20
	// Read: Disabled
	POWER_INTENSET_SLEEPENTER_Disabled = 0x0
	// Read: Enabled
	POWER_INTENSET_SLEEPENTER_Enabled = 0x1
	// Enable
	POWER_INTENSET_SLEEPENTER_Set = 0x1
	// Position of SLEEPEXIT field.
	POWER_INTENSET_SLEEPEXIT_Pos = 0x6
	// Bit mask of SLEEPEXIT field.
	POWER_INTENSET_SLEEPEXIT_Msk = 0x40
	// Bit SLEEPEXIT.
	POWER_INTENSET_SLEEPEXIT = 0x40
	// Read: Disabled
	POWER_INTENSET_SLEEPEXIT_Disabled = 0x0
	// Read: Enabled
	POWER_INTENSET_SLEEPEXIT_Enabled = 0x1
	// Enable
	POWER_INTENSET_SLEEPEXIT_Set = 0x1

	// INTENCLR: Disable interrupt
	// Position of POFWARN field.
	POWER_INTENCLR_POFWARN_Pos = 0x2
	// Bit mask of POFWARN field.
	POWER_INTENCLR_POFWARN_Msk = 0x4
	// Bit POFWARN.
	POWER_INTENCLR_POFWARN = 0x4
	// Read: Disabled
	POWER_INTENCLR_POFWARN_Disabled = 0x0
	// Read: Enabled
	POWER_INTENCLR_POFWARN_Enabled = 0x1
	// Disable
	POWER_INTENCLR_POFWARN_Clear = 0x1
	// Position of SLEEPENTER field.
	POWER_INTENCLR_SLEEPENTER_Pos = 0x5
	// Bit mask of SLEEPENTER field.
	POWER_INTENCLR_SLEEPENTER_Msk = 0x20
	// Bit SLEEPENTER.
	POWER_INTENCLR_SLEEPENTER = 0x20
	// Read: Disabled
	POWER_INTENCLR_SLEEPENTER_Disabled = 0x0
	// Read: Enabled
	POWER_INTENCLR_SLEEPENTER_Enabled = 0x1
	// Disable
	POWER_INTENCLR_SLEEPENTER_Clear = 0x1
	// Position of SLEEPEXIT field.
	POWER_INTENCLR_SLEEPEXIT_Pos = 0x6
	// Bit mask of SLEEPEXIT field.
	POWER_INTENCLR_SLEEPEXIT_Msk = 0x40
	// Bit SLEEPEXIT.
	POWER_INTENCLR_SLEEPEXIT = 0x40
	// Read: Disabled
	POWER_INTENCLR_SLEEPEXIT_Disabled = 0x0
	// Read: Enabled
	POWER_INTENCLR_SLEEPEXIT_Enabled = 0x1
	// Disable
	POWER_INTENCLR_SLEEPEXIT_Clear = 0x1

	// GPREGRET: Description collection: General purpose retention register
	// Position of GPREGRET field.
	POWER_GPREGRET_GPREGRET_Pos = 0x0
	// Bit mask of GPREGRET field.
	POWER_GPREGRET_GPREGRET_Msk = 0xff
)

// Constants for RESET_NS: Reset control
const (
	// RESETREAS: Reset reason
	// Position of RESETPIN field.
	RESET_RESETREAS_RESETPIN_Pos = 0x0
	// Bit mask of RESETPIN field.
	RESET_RESETREAS_RESETPIN_Msk = 0x1
	// Bit RESETPIN.
	RESET_RESETREAS_RESETPIN = 0x1
	// Not detected
	RESET_RESETREAS_RESETPIN_NotDetected = 0x0
	// Detected
	RESET_RESETREAS_RESETPIN_Detected = 0x1
	// Position of DOG0 field.
	RESET_RESETREAS_DOG0_Pos = 0x1
	// Bit mask of DOG0 field.
	RESET_RESETREAS_DOG0_Msk = 0x2
	// Bit DOG0.
	RESET_RESETREAS_DOG0 = 0x2
	// Not detected
	RESET_RESETREAS_DOG0_NotDetected = 0x0
	// Detected
	RESET_RESETREAS_DOG0_Detected = 0x1
	// Position of CTRLAP field.
	RESET_RESETREAS_CTRLAP_Pos = 0x2
	// Bit mask of CTRLAP field.
	RESET_RESETREAS_CTRLAP_Msk = 0x4
	// Bit CTRLAP.
	RESET_RESETREAS_CTRLAP = 0x4
	// Not detected
	RESET_RESETREAS_CTRLAP_NotDetected = 0x0
	// Detected
	RESET_RESETREAS_CTRLAP_Detected = 0x1
	// Position of SREQ field.
	RESET_RESETREAS_SREQ_Pos = 0x3
	// Bit mask of SREQ field.
	RESET_RESETREAS_SREQ_Msk = 0x8
	// Bit SREQ.
	RESET_RESETREAS_SREQ = 0x8
	// Not detected
	RESET_RESETREAS_SREQ_NotDetected = 0x0
	// Detected
	RESET_RESETREAS_SREQ_Detected = 0x1
	// Position of LOCKUP field.
	RESET_RESETREAS_LOCKUP_Pos = 0x4
	// Bit mask of LOCKUP field.
	RESET_RESETREAS_LOCKUP_Msk = 0x10
	// Bit LOCKUP.
	RESET_RESETREAS_LOCKUP = 0x10
	// Not detected
	RESET_RESETREAS_LOCKUP_NotDetected = 0x0
	// Detected
	RESET_RESETREAS_LOCKUP_Detected = 0x1
	// Position of OFF field.
	RESET_RESETREAS_OFF_Pos = 0x5
	// Bit mask of OFF field.
	RESET_RESETREAS_OFF_Msk = 0x20
	// Bit OFF.
	RESET_RESETREAS_OFF = 0x20
	// Not detected
	RESET_RESETREAS_OFF_NotDetected = 0x0
	// Detected
	RESET_RESETREAS_OFF_Detected = 0x1
	// Position of LPCOMP field.
	RESET_RESETREAS_LPCOMP_Pos = 0x6
	// Bit mask of LPCOMP field.
	RESET_RESETREAS_LPCOMP_Msk = 0x40
	// Bit LPCOMP.
	RESET_RESETREAS_LPCOMP = 0x40
	// Not detected
	RESET_RESETREAS_LPCOMP_NotDetected = 0x0
	// Detected
	RESET_RESETREAS_LPCOMP_Detected = 0x1
	// Position of DIF field.
	RESET_RESETREAS_DIF_Pos = 0x7
	// Bit mask of DIF field.
	RESET_RESETREAS_DIF_Msk = 0x80
	// Bit DIF.
	RESET_RESETREAS_DIF = 0x80
	// Not detected
	RESET_RESETREAS_DIF_NotDetected = 0x0
	// Detected
	RESET_RESETREAS_DIF_Detected = 0x1
	// Position of LSREQ field.
	RESET_RESETREAS_LSREQ_Pos = 0x10
	// Bit mask of LSREQ field.
	RESET_RESETREAS_LSREQ_Msk = 0x10000
	// Bit LSREQ.
	RESET_RESETREAS_LSREQ = 0x10000
	// Not detected
	RESET_RESETREAS_LSREQ_NotDetected = 0x0
	// Detected
	RESET_RESETREAS_LSREQ_Detected = 0x1
	// Position of LLOCKUP field.
	RESET_RESETREAS_LLOCKUP_Pos = 0x11
	// Bit mask of LLOCKUP field.
	RESET_RESETREAS_LLOCKUP_Msk = 0x20000
	// Bit LLOCKUP.
	RESET_RESETREAS_LLOCKUP = 0x20000
	// Not detected
	RESET_RESETREAS_LLOCKUP_NotDetected = 0x0
	// Detected
	RESET_RESETREAS_LLOCKUP_Detected = 0x1
	// Position of LDOG field.
	RESET_RESETREAS_LDOG_Pos = 0x12
	// Bit mask of LDOG field.
	RESET_RESETREAS_LDOG_Msk = 0x40000
	// Bit LDOG.
	RESET_RESETREAS_LDOG = 0x40000
	// Not detected
	RESET_RESETREAS_LDOG_NotDetected = 0x0
	// Detected
	RESET_RESETREAS_LDOG_Detected = 0x1
	// Position of MFORCEOFF field.
	RESET_RESETREAS_MFORCEOFF_Pos = 0x17
	// Bit mask of MFORCEOFF field.
	RESET_RESETREAS_MFORCEOFF_Msk = 0x800000
	// Bit MFORCEOFF.
	RESET_RESETREAS_MFORCEOFF = 0x800000
	// Not detected
	RESET_RESETREAS_MFORCEOFF_NotDetected = 0x0
	// Detected
	RESET_RESETREAS_MFORCEOFF_Detected = 0x1
	// Position of NFC field.
	RESET_RESETREAS_NFC_Pos = 0x18
	// Bit mask of NFC field.
	RESET_RESETREAS_NFC_Msk = 0x1000000
	// Bit NFC.
	RESET_RESETREAS_NFC = 0x1000000
	// Not detected
	RESET_RESETREAS_NFC_NotDetected = 0x0
	// Detected
	RESET_RESETREAS_NFC_Detected = 0x1
	// Position of DOG1 field.
	RESET_RESETREAS_DOG1_Pos = 0x19
	// Bit mask of DOG1 field.
	RESET_RESETREAS_DOG1_Msk = 0x2000000
	// Bit DOG1.
	RESET_RESETREAS_DOG1 = 0x2000000
	// Not detected
	RESET_RESETREAS_DOG1_NotDetected = 0x0
	// Detected
	RESET_RESETREAS_DOG1_Detected = 0x1
	// Position of VBUS field.
	RESET_RESETREAS_VBUS_Pos = 0x1a
	// Bit mask of VBUS field.
	RESET_RESETREAS_VBUS_Msk = 0x4000000
	// Bit VBUS.
	RESET_RESETREAS_VBUS = 0x4000000
	// Not detected
	RESET_RESETREAS_VBUS_NotDetected = 0x0
	// Detected
	RESET_RESETREAS_VBUS_Detected = 0x1
	// Position of LCTRLAP field.
	RESET_RESETREAS_LCTRLAP_Pos = 0x1b
	// Bit mask of LCTRLAP field.
	RESET_RESETREAS_LCTRLAP_Msk = 0x8000000
	// Bit LCTRLAP.
	RESET_RESETREAS_LCTRLAP = 0x8000000
	// Not detected
	RESET_RESETREAS_LCTRLAP_NotDetected = 0x0
	// Detected
	RESET_RESETREAS_LCTRLAP_Detected = 0x1
)

// Constants for CTRLAP_NS: Control access port
const (
	// MAILBOX.RXDATA: Data sent from the debugger to the CPU.
	// Position of RXDATA field.
	CTRLAPPERI_MAILBOX_RXDATA_RXDATA_Pos = 0x0
	// Bit mask of RXDATA field.
	CTRLAPPERI_MAILBOX_RXDATA_RXDATA_Msk = 0xffffffff

	// MAILBOX.RXSTATUS: This register shows a status that indicates if data sent from the debugger to the CPU has been read.
	// Position of RXSTATUS field.
	CTRLAPPERI_MAILBOX_RXSTATUS_RXSTATUS_Pos = 0x0
	// Bit mask of RXSTATUS field.
	CTRLAPPERI_MAILBOX_RXSTATUS_RXSTATUS_Msk = 0x1
	// Bit RXSTATUS.
	CTRLAPPERI_MAILBOX_RXSTATUS_RXSTATUS = 0x1
	// No data pending in register RXDATA
	CTRLAPPERI_MAILBOX_RXSTATUS_RXSTATUS_NoDataPending = 0x0
	// Data pending in register RXDATA
	CTRLAPPERI_MAILBOX_RXSTATUS_RXSTATUS_DataPending = 0x1

	// MAILBOX.TXDATA: Data sent from the CPU to the debugger.
	// Position of TXDATA field.
	CTRLAPPERI_MAILBOX_TXDATA_TXDATA_Pos = 0x0
	// Bit mask of TXDATA field.
	CTRLAPPERI_MAILBOX_TXDATA_TXDATA_Msk = 0xffffffff

	// MAILBOX.TXSTATUS: This register shows a status that indicates if the data sent from the CPU to the debugger has been read.
	// Position of TXSTATUS field.
	CTRLAPPERI_MAILBOX_TXSTATUS_TXSTATUS_Pos = 0x0
	// Bit mask of TXSTATUS field.
	CTRLAPPERI_MAILBOX_TXSTATUS_TXSTATUS_Msk = 0x1
	// Bit TXSTATUS.
	CTRLAPPERI_MAILBOX_TXSTATUS_TXSTATUS = 0x1
	// No data pending in register TXDATA
	CTRLAPPERI_MAILBOX_TXSTATUS_TXSTATUS_NoDataPending = 0x0
	// Data pending in register TXDATA
	CTRLAPPERI_MAILBOX_TXSTATUS_TXSTATUS_DataPending = 0x1

	// ERASEPROTECT.LOCK: This register locks the ERASEPROTECT.DISABLE register from being written until next reset.
	// Position of LOCK field.
	CTRLAPPERI_ERASEPROTECT_LOCK_LOCK_Pos = 0x0
	// Bit mask of LOCK field.
	CTRLAPPERI_ERASEPROTECT_LOCK_LOCK_Msk = 0x1
	// Bit LOCK.
	CTRLAPPERI_ERASEPROTECT_LOCK_LOCK = 0x1
	// Register ERASEPROTECT.DISABLE is writeable
	CTRLAPPERI_ERASEPROTECT_LOCK_LOCK_Unlocked = 0x0
	// Register ERASEPROTECT.DISABLE is read-only
	CTRLAPPERI_ERASEPROTECT_LOCK_LOCK_Locked = 0x1

	// ERASEPROTECT.DISABLE: This register disables the ERASEPROTECT register and performs an ERASEALL operation.
	// Position of KEY field.
	CTRLAPPERI_ERASEPROTECT_DISABLE_KEY_Pos = 0x0
	// Bit mask of KEY field.
	CTRLAPPERI_ERASEPROTECT_DISABLE_KEY_Msk = 0xffffffff

	// APPROTECT.LOCK: This register locks the APPROTECT.DISABLE register from being written to until next reset.
	// Position of LOCK field.
	CTRLAPPERI_APPROTECT_LOCK_LOCK_Pos = 0x0
	// Bit mask of LOCK field.
	CTRLAPPERI_APPROTECT_LOCK_LOCK_Msk = 0x1
	// Bit LOCK.
	CTRLAPPERI_APPROTECT_LOCK_LOCK = 0x1
	// Register APPROTECT.DISABLE is writeable
	CTRLAPPERI_APPROTECT_LOCK_LOCK_Unlocked = 0x0
	// Register APPROTECT.DISABLE is read-only
	CTRLAPPERI_APPROTECT_LOCK_LOCK_Locked = 0x1

	// APPROTECT.DISABLE: This register disables the APPROTECT register and enables debug access to non-secure mode.
	// Position of KEY field.
	CTRLAPPERI_APPROTECT_DISABLE_KEY_Pos = 0x0
	// Bit mask of KEY field.
	CTRLAPPERI_APPROTECT_DISABLE_KEY_Msk = 0xffffffff

	// STATUS: Status bits for CTRL-AP peripheral
	// Position of APPROTECT field.
	CTRLAPPERI_STATUS_APPROTECT_Pos = 0x0
	// Bit mask of APPROTECT field.
	CTRLAPPERI_STATUS_APPROTECT_Msk = 0x1
	// Bit APPROTECT.
	CTRLAPPERI_STATUS_APPROTECT = 0x1
	// Non-secure mode access port protection is currently disabled
	CTRLAPPERI_STATUS_APPROTECT_Disabled = 0x0
	// Non-secure mode access port protection is currently enabled
	CTRLAPPERI_STATUS_APPROTECT_Enabled = 0x1
	// Position of DBGIFACEMODE field.
	CTRLAPPERI_STATUS_DBGIFACEMODE_Pos = 0x2
	// Bit mask of DBGIFACEMODE field.
	CTRLAPPERI_STATUS_DBGIFACEMODE_Msk = 0x4
	// Bit DBGIFACEMODE.
	CTRLAPPERI_STATUS_DBGIFACEMODE = 0x4
	// No debugger attached
	CTRLAPPERI_STATUS_DBGIFACEMODE_Disabled = 0x0
	// Debugger is attached and device is in debug interface mode
	CTRLAPPERI_STATUS_DBGIFACEMODE_Enabled = 0x1
)

// Constants for RADIO_NS: 2.4 GHz radio
const (
	// TASKS_TXEN: Enable RADIO in TX mode
	// Position of TASKS_TXEN field.
	RADIO_TASKS_TXEN_TASKS_TXEN_Pos = 0x0
	// Bit mask of TASKS_TXEN field.
	RADIO_TASKS_TXEN_TASKS_TXEN_Msk = 0x1
	// Bit TASKS_TXEN.
	RADIO_TASKS_TXEN_TASKS_TXEN = 0x1
	// Trigger task
	RADIO_TASKS_TXEN_TASKS_TXEN_Trigger = 0x1

	// TASKS_RXEN: Enable RADIO in RX mode
	// Position of TASKS_RXEN field.
	RADIO_TASKS_RXEN_TASKS_RXEN_Pos = 0x0
	// Bit mask of TASKS_RXEN field.
	RADIO_TASKS_RXEN_TASKS_RXEN_Msk = 0x1
	// Bit TASKS_RXEN.
	RADIO_TASKS_RXEN_TASKS_RXEN = 0x1
	// Trigger task
	RADIO_TASKS_RXEN_TASKS_RXEN_Trigger = 0x1

	// TASKS_START: Start RADIO
	// Position of TASKS_START field.
	RADIO_TASKS_START_TASKS_START_Pos = 0x0
	// Bit mask of TASKS_START field.
	RADIO_TASKS_START_TASKS_START_Msk = 0x1
	// Bit TASKS_START.
	RADIO_TASKS_START_TASKS_START = 0x1
	// Trigger task
	RADIO_TASKS_START_TASKS_START_Trigger = 0x1

	// TASKS_STOP: Stop RADIO
	// Position of TASKS_STOP field.
	RADIO_TASKS_STOP_TASKS_STOP_Pos = 0x0
	// Bit mask of TASKS_STOP field.
	RADIO_TASKS_STOP_TASKS_STOP_Msk = 0x1
	// Bit TASKS_STOP.
	RADIO_TASKS_STOP_TASKS_STOP = 0x1
	// Trigger task
	RADIO_TASKS_STOP_TASKS_STOP_Trigger = 0x1

	// TASKS_DISABLE: Disable RADIO
	// Position of TASKS_DISABLE field.
	RADIO_TASKS_DISABLE_TASKS_DISABLE_Pos = 0x0
	// Bit mask of TASKS_DISABLE field.
	RADIO_TASKS_DISABLE_TASKS_DISABLE_Msk = 0x1
	// Bit TASKS_DISABLE.
	RADIO_TASKS_DISABLE_TASKS_DISABLE = 0x1
	// Trigger task
	RADIO_TASKS_DISABLE_TASKS_DISABLE_Trigger = 0x1

	// TASKS_RSSISTART: Start the RSSI and take one single sample of the receive signal strength
	// Position of TASKS_RSSISTART field.
	RADIO_TASKS_RSSISTART_TASKS_RSSISTART_Pos = 0x0
	// Bit mask of TASKS_RSSISTART field.
	RADIO_TASKS_RSSISTART_TASKS_RSSISTART_Msk = 0x1
	// Bit TASKS_RSSISTART.
	RADIO_TASKS_RSSISTART_TASKS_RSSISTART = 0x1
	// Trigger task
	RADIO_TASKS_RSSISTART_TASKS_RSSISTART_Trigger = 0x1

	// TASKS_RSSISTOP: Stop the RSSI measurement
	// Position of TASKS_RSSISTOP field.
	RADIO_TASKS_RSSISTOP_TASKS_RSSISTOP_Pos = 0x0
	// Bit mask of TASKS_RSSISTOP field.
	RADIO_TASKS_RSSISTOP_TASKS_RSSISTOP_Msk = 0x1
	// Bit TASKS_RSSISTOP.
	RADIO_TASKS_RSSISTOP_TASKS_RSSISTOP = 0x1
	// Trigger task
	RADIO_TASKS_RSSISTOP_TASKS_RSSISTOP_Trigger = 0x1

	// TASKS_BCSTART: Start the bit counter
	// Position of TASKS_BCSTART field.
	RADIO_TASKS_BCSTART_TASKS_BCSTART_Pos = 0x0
	// Bit mask of TASKS_BCSTART field.
	RADIO_TASKS_BCSTART_TASKS_BCSTART_Msk = 0x1
	// Bit TASKS_BCSTART.
	RADIO_TASKS_BCSTART_TASKS_BCSTART = 0x1
	// Trigger task
	RADIO_TASKS_BCSTART_TASKS_BCSTART_Trigger = 0x1

	// TASKS_BCSTOP: Stop the bit counter
	// Position of TASKS_BCSTOP field.
	RADIO_TASKS_BCSTOP_TASKS_BCSTOP_Pos = 0x0
	// Bit mask of TASKS_BCSTOP field.
	RADIO_TASKS_BCSTOP_TASKS_BCSTOP_Msk = 0x1
	// Bit TASKS_BCSTOP.
	RADIO_TASKS_BCSTOP_TASKS_BCSTOP = 0x1
	// Trigger task
	RADIO_TASKS_BCSTOP_TASKS_BCSTOP_Trigger = 0x1

	// TASKS_EDSTART: Start the energy detect measurement used in IEEE 802.15.4 mode
	// Position of TASKS_EDSTART field.
	RADIO_TASKS_EDSTART_TASKS_EDSTART_Pos = 0x0
	// Bit mask of TASKS_EDSTART field.
	RADIO_TASKS_EDSTART_TASKS_EDSTART_Msk = 0x1
	// Bit TASKS_EDSTART.
	RADIO_TASKS_EDSTART_TASKS_EDSTART = 0x1
	// Trigger task
	RADIO_TASKS_EDSTART_TASKS_EDSTART_Trigger = 0x1

	// TASKS_EDSTOP: Stop the energy detect measurement
	// Position of TASKS_EDSTOP field.
	RADIO_TASKS_EDSTOP_TASKS_EDSTOP_Pos = 0x0
	// Bit mask of TASKS_EDSTOP field.
	RADIO_TASKS_EDSTOP_TASKS_EDSTOP_Msk = 0x1
	// Bit TASKS_EDSTOP.
	RADIO_TASKS_EDSTOP_TASKS_EDSTOP = 0x1
	// Trigger task
	RADIO_TASKS_EDSTOP_TASKS_EDSTOP_Trigger = 0x1

	// TASKS_CCASTART: Start the clear channel assessment used in IEEE 802.15.4 mode
	// Position of TASKS_CCASTART field.
	RADIO_TASKS_CCASTART_TASKS_CCASTART_Pos = 0x0
	// Bit mask of TASKS_CCASTART field.
	RADIO_TASKS_CCASTART_TASKS_CCASTART_Msk = 0x1
	// Bit TASKS_CCASTART.
	RADIO_TASKS_CCASTART_TASKS_CCASTART = 0x1
	// Trigger task
	RADIO_TASKS_CCASTART_TASKS_CCASTART_Trigger = 0x1

	// TASKS_CCASTOP: Stop the clear channel assessment
	// Position of TASKS_CCASTOP field.
	RADIO_TASKS_CCASTOP_TASKS_CCASTOP_Pos = 0x0
	// Bit mask of TASKS_CCASTOP field.
	RADIO_TASKS_CCASTOP_TASKS_CCASTOP_Msk = 0x1
	// Bit TASKS_CCASTOP.
	RADIO_TASKS_CCASTOP_TASKS_CCASTOP = 0x1
	// Trigger task
	RADIO_TASKS_CCASTOP_TASKS_CCASTOP_Trigger = 0x1

	// SUBSCRIBE_TXEN: Subscribe configuration for task TXEN
	// Position of CHIDX field.
	RADIO_SUBSCRIBE_TXEN_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	RADIO_SUBSCRIBE_TXEN_CHIDX_Msk = 0xff
	// Position of EN field.
	RADIO_SUBSCRIBE_TXEN_EN_Pos = 0x1f
	// Bit mask of EN field.
	RADIO_SUBSCRIBE_TXEN_EN_Msk = 0x80000000
	// Bit EN.
	RADIO_SUBSCRIBE_TXEN_EN = 0x80000000
	// Disable subscription
	RADIO_SUBSCRIBE_TXEN_EN_Disabled = 0x0
	// Enable subscription
	RADIO_SUBSCRIBE_TXEN_EN_Enabled = 0x1

	// SUBSCRIBE_RXEN: Subscribe configuration for task RXEN
	// Position of CHIDX field.
	RADIO_SUBSCRIBE_RXEN_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	RADIO_SUBSCRIBE_RXEN_CHIDX_Msk = 0xff
	// Position of EN field.
	RADIO_SUBSCRIBE_RXEN_EN_Pos = 0x1f
	// Bit mask of EN field.
	RADIO_SUBSCRIBE_RXEN_EN_Msk = 0x80000000
	// Bit EN.
	RADIO_SUBSCRIBE_RXEN_EN = 0x80000000
	// Disable subscription
	RADIO_SUBSCRIBE_RXEN_EN_Disabled = 0x0
	// Enable subscription
	RADIO_SUBSCRIBE_RXEN_EN_Enabled = 0x1

	// SUBSCRIBE_START: Subscribe configuration for task START
	// Position of CHIDX field.
	RADIO_SUBSCRIBE_START_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	RADIO_SUBSCRIBE_START_CHIDX_Msk = 0xff
	// Position of EN field.
	RADIO_SUBSCRIBE_START_EN_Pos = 0x1f
	// Bit mask of EN field.
	RADIO_SUBSCRIBE_START_EN_Msk = 0x80000000
	// Bit EN.
	RADIO_SUBSCRIBE_START_EN = 0x80000000
	// Disable subscription
	RADIO_SUBSCRIBE_START_EN_Disabled = 0x0
	// Enable subscription
	RADIO_SUBSCRIBE_START_EN_Enabled = 0x1

	// SUBSCRIBE_STOP: Subscribe configuration for task STOP
	// Position of CHIDX field.
	RADIO_SUBSCRIBE_STOP_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	RADIO_SUBSCRIBE_STOP_CHIDX_Msk = 0xff
	// Position of EN field.
	RADIO_SUBSCRIBE_STOP_EN_Pos = 0x1f
	// Bit mask of EN field.
	RADIO_SUBSCRIBE_STOP_EN_Msk = 0x80000000
	// Bit EN.
	RADIO_SUBSCRIBE_STOP_EN = 0x80000000
	// Disable subscription
	RADIO_SUBSCRIBE_STOP_EN_Disabled = 0x0
	// Enable subscription
	RADIO_SUBSCRIBE_STOP_EN_Enabled = 0x1

	// SUBSCRIBE_DISABLE: Subscribe configuration for task DISABLE
	// Position of CHIDX field.
	RADIO_SUBSCRIBE_DISABLE_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	RADIO_SUBSCRIBE_DISABLE_CHIDX_Msk = 0xff
	// Position of EN field.
	RADIO_SUBSCRIBE_DISABLE_EN_Pos = 0x1f
	// Bit mask of EN field.
	RADIO_SUBSCRIBE_DISABLE_EN_Msk = 0x80000000
	// Bit EN.
	RADIO_SUBSCRIBE_DISABLE_EN = 0x80000000
	// Disable subscription
	RADIO_SUBSCRIBE_DISABLE_EN_Disabled = 0x0
	// Enable subscription
	RADIO_SUBSCRIBE_DISABLE_EN_Enabled = 0x1

	// SUBSCRIBE_RSSISTART: Subscribe configuration for task RSSISTART
	// Position of CHIDX field.
	RADIO_SUBSCRIBE_RSSISTART_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	RADIO_SUBSCRIBE_RSSISTART_CHIDX_Msk = 0xff
	// Position of EN field.
	RADIO_SUBSCRIBE_RSSISTART_EN_Pos = 0x1f
	// Bit mask of EN field.
	RADIO_SUBSCRIBE_RSSISTART_EN_Msk = 0x80000000
	// Bit EN.
	RADIO_SUBSCRIBE_RSSISTART_EN = 0x80000000
	// Disable subscription
	RADIO_SUBSCRIBE_RSSISTART_EN_Disabled = 0x0
	// Enable subscription
	RADIO_SUBSCRIBE_RSSISTART_EN_Enabled = 0x1

	// SUBSCRIBE_RSSISTOP: Subscribe configuration for task RSSISTOP
	// Position of CHIDX field.
	RADIO_SUBSCRIBE_RSSISTOP_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	RADIO_SUBSCRIBE_RSSISTOP_CHIDX_Msk = 0xff
	// Position of EN field.
	RADIO_SUBSCRIBE_RSSISTOP_EN_Pos = 0x1f
	// Bit mask of EN field.
	RADIO_SUBSCRIBE_RSSISTOP_EN_Msk = 0x80000000
	// Bit EN.
	RADIO_SUBSCRIBE_RSSISTOP_EN = 0x80000000
	// Disable subscription
	RADIO_SUBSCRIBE_RSSISTOP_EN_Disabled = 0x0
	// Enable subscription
	RADIO_SUBSCRIBE_RSSISTOP_EN_Enabled = 0x1

	// SUBSCRIBE_BCSTART: Subscribe configuration for task BCSTART
	// Position of CHIDX field.
	RADIO_SUBSCRIBE_BCSTART_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	RADIO_SUBSCRIBE_BCSTART_CHIDX_Msk = 0xff
	// Position of EN field.
	RADIO_SUBSCRIBE_BCSTART_EN_Pos = 0x1f
	// Bit mask of EN field.
	RADIO_SUBSCRIBE_BCSTART_EN_Msk = 0x80000000
	// Bit EN.
	RADIO_SUBSCRIBE_BCSTART_EN = 0x80000000
	// Disable subscription
	RADIO_SUBSCRIBE_BCSTART_EN_Disabled = 0x0
	// Enable subscription
	RADIO_SUBSCRIBE_BCSTART_EN_Enabled = 0x1

	// SUBSCRIBE_BCSTOP: Subscribe configuration for task BCSTOP
	// Position of CHIDX field.
	RADIO_SUBSCRIBE_BCSTOP_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	RADIO_SUBSCRIBE_BCSTOP_CHIDX_Msk = 0xff
	// Position of EN field.
	RADIO_SUBSCRIBE_BCSTOP_EN_Pos = 0x1f
	// Bit mask of EN field.
	RADIO_SUBSCRIBE_BCSTOP_EN_Msk = 0x80000000
	// Bit EN.
	RADIO_SUBSCRIBE_BCSTOP_EN = 0x80000000
	// Disable subscription
	RADIO_SUBSCRIBE_BCSTOP_EN_Disabled = 0x0
	// Enable subscription
	RADIO_SUBSCRIBE_BCSTOP_EN_Enabled = 0x1

	// SUBSCRIBE_EDSTART: Subscribe configuration for task EDSTART
	// Position of CHIDX field.
	RADIO_SUBSCRIBE_EDSTART_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	RADIO_SUBSCRIBE_EDSTART_CHIDX_Msk = 0xff
	// Position of EN field.
	RADIO_SUBSCRIBE_EDSTART_EN_Pos = 0x1f
	// Bit mask of EN field.
	RADIO_SUBSCRIBE_EDSTART_EN_Msk = 0x80000000
	// Bit EN.
	RADIO_SUBSCRIBE_EDSTART_EN = 0x80000000
	// Disable subscription
	RADIO_SUBSCRIBE_EDSTART_EN_Disabled = 0x0
	// Enable subscription
	RADIO_SUBSCRIBE_EDSTART_EN_Enabled = 0x1

	// SUBSCRIBE_EDSTOP: Subscribe configuration for task EDSTOP
	// Position of CHIDX field.
	RADIO_SUBSCRIBE_EDSTOP_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	RADIO_SUBSCRIBE_EDSTOP_CHIDX_Msk = 0xff
	// Position of EN field.
	RADIO_SUBSCRIBE_EDSTOP_EN_Pos = 0x1f
	// Bit mask of EN field.
	RADIO_SUBSCRIBE_EDSTOP_EN_Msk = 0x80000000
	// Bit EN.
	RADIO_SUBSCRIBE_EDSTOP_EN = 0x80000000
	// Disable subscription
	RADIO_SUBSCRIBE_EDSTOP_EN_Disabled = 0x0
	// Enable subscription
	RADIO_SUBSCRIBE_EDSTOP_EN_Enabled = 0x1

	// SUBSCRIBE_CCASTART: Subscribe configuration for task CCASTART
	// Position of CHIDX field.
	RADIO_SUBSCRIBE_CCASTART_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	RADIO_SUBSCRIBE_CCASTART_CHIDX_Msk = 0xff
	// Position of EN field.
	RADIO_SUBSCRIBE_CCASTART_EN_Pos = 0x1f
	// Bit mask of EN field.
	RADIO_SUBSCRIBE_CCASTART_EN_Msk = 0x80000000
	// Bit EN.
	RADIO_SUBSCRIBE_CCASTART_EN = 0x80000000
	// Disable subscription
	RADIO_SUBSCRIBE_CCASTART_EN_Disabled = 0x0
	// Enable subscription
	RADIO_SUBSCRIBE_CCASTART_EN_Enabled = 0x1

	// SUBSCRIBE_CCASTOP: Subscribe configuration for task CCASTOP
	// Position of CHIDX field.
	RADIO_SUBSCRIBE_CCASTOP_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	RADIO_SUBSCRIBE_CCASTOP_CHIDX_Msk = 0xff
	// Position of EN field.
	RADIO_SUBSCRIBE_CCASTOP_EN_Pos = 0x1f
	// Bit mask of EN field.
	RADIO_SUBSCRIBE_CCASTOP_EN_Msk = 0x80000000
	// Bit EN.
	RADIO_SUBSCRIBE_CCASTOP_EN = 0x80000000
	// Disable subscription
	RADIO_SUBSCRIBE_CCASTOP_EN_Disabled = 0x0
	// Enable subscription
	RADIO_SUBSCRIBE_CCASTOP_EN_Enabled = 0x1

	// EVENTS_READY: RADIO has ramped up and is ready to be started
	// Position of EVENTS_READY field.
	RADIO_EVENTS_READY_EVENTS_READY_Pos = 0x0
	// Bit mask of EVENTS_READY field.
	RADIO_EVENTS_READY_EVENTS_READY_Msk = 0x1
	// Bit EVENTS_READY.
	RADIO_EVENTS_READY_EVENTS_READY = 0x1
	// Event not generated
	RADIO_EVENTS_READY_EVENTS_READY_NotGenerated = 0x0
	// Event generated
	RADIO_EVENTS_READY_EVENTS_READY_Generated = 0x1

	// EVENTS_ADDRESS: Address sent or received
	// Position of EVENTS_ADDRESS field.
	RADIO_EVENTS_ADDRESS_EVENTS_ADDRESS_Pos = 0x0
	// Bit mask of EVENTS_ADDRESS field.
	RADIO_EVENTS_ADDRESS_EVENTS_ADDRESS_Msk = 0x1
	// Bit EVENTS_ADDRESS.
	RADIO_EVENTS_ADDRESS_EVENTS_ADDRESS = 0x1
	// Event not generated
	RADIO_EVENTS_ADDRESS_EVENTS_ADDRESS_NotGenerated = 0x0
	// Event generated
	RADIO_EVENTS_ADDRESS_EVENTS_ADDRESS_Generated = 0x1

	// EVENTS_PAYLOAD: Packet payload sent or received
	// Position of EVENTS_PAYLOAD field.
	RADIO_EVENTS_PAYLOAD_EVENTS_PAYLOAD_Pos = 0x0
	// Bit mask of EVENTS_PAYLOAD field.
	RADIO_EVENTS_PAYLOAD_EVENTS_PAYLOAD_Msk = 0x1
	// Bit EVENTS_PAYLOAD.
	RADIO_EVENTS_PAYLOAD_EVENTS_PAYLOAD = 0x1
	// Event not generated
	RADIO_EVENTS_PAYLOAD_EVENTS_PAYLOAD_NotGenerated = 0x0
	// Event generated
	RADIO_EVENTS_PAYLOAD_EVENTS_PAYLOAD_Generated = 0x1

	// EVENTS_END: Packet sent or received
	// Position of EVENTS_END field.
	RADIO_EVENTS_END_EVENTS_END_Pos = 0x0
	// Bit mask of EVENTS_END field.
	RADIO_EVENTS_END_EVENTS_END_Msk = 0x1
	// Bit EVENTS_END.
	RADIO_EVENTS_END_EVENTS_END = 0x1
	// Event not generated
	RADIO_EVENTS_END_EVENTS_END_NotGenerated = 0x0
	// Event generated
	RADIO_EVENTS_END_EVENTS_END_Generated = 0x1

	// EVENTS_DISABLED: RADIO has been disabled
	// Position of EVENTS_DISABLED field.
	RADIO_EVENTS_DISABLED_EVENTS_DISABLED_Pos = 0x0
	// Bit mask of EVENTS_DISABLED field.
	RADIO_EVENTS_DISABLED_EVENTS_DISABLED_Msk = 0x1
	// Bit EVENTS_DISABLED.
	RADIO_EVENTS_DISABLED_EVENTS_DISABLED = 0x1
	// Event not generated
	RADIO_EVENTS_DISABLED_EVENTS_DISABLED_NotGenerated = 0x0
	// Event generated
	RADIO_EVENTS_DISABLED_EVENTS_DISABLED_Generated = 0x1

	// EVENTS_DEVMATCH: A device address match occurred on the last received packet
	// Position of EVENTS_DEVMATCH field.
	RADIO_EVENTS_DEVMATCH_EVENTS_DEVMATCH_Pos = 0x0
	// Bit mask of EVENTS_DEVMATCH field.
	RADIO_EVENTS_DEVMATCH_EVENTS_DEVMATCH_Msk = 0x1
	// Bit EVENTS_DEVMATCH.
	RADIO_EVENTS_DEVMATCH_EVENTS_DEVMATCH = 0x1
	// Event not generated
	RADIO_EVENTS_DEVMATCH_EVENTS_DEVMATCH_NotGenerated = 0x0
	// Event generated
	RADIO_EVENTS_DEVMATCH_EVENTS_DEVMATCH_Generated = 0x1

	// EVENTS_DEVMISS: No device address match occurred on the last received packet
	// Position of EVENTS_DEVMISS field.
	RADIO_EVENTS_DEVMISS_EVENTS_DEVMISS_Pos = 0x0
	// Bit mask of EVENTS_DEVMISS field.
	RADIO_EVENTS_DEVMISS_EVENTS_DEVMISS_Msk = 0x1
	// Bit EVENTS_DEVMISS.
	RADIO_EVENTS_DEVMISS_EVENTS_DEVMISS = 0x1
	// Event not generated
	RADIO_EVENTS_DEVMISS_EVENTS_DEVMISS_NotGenerated = 0x0
	// Event generated
	RADIO_EVENTS_DEVMISS_EVENTS_DEVMISS_Generated = 0x1

	// EVENTS_RSSIEND: Sampling of receive signal strength complete
	// Position of EVENTS_RSSIEND field.
	RADIO_EVENTS_RSSIEND_EVENTS_RSSIEND_Pos = 0x0
	// Bit mask of EVENTS_RSSIEND field.
	RADIO_EVENTS_RSSIEND_EVENTS_RSSIEND_Msk = 0x1
	// Bit EVENTS_RSSIEND.
	RADIO_EVENTS_RSSIEND_EVENTS_RSSIEND = 0x1
	// Event not generated
	RADIO_EVENTS_RSSIEND_EVENTS_RSSIEND_NotGenerated = 0x0
	// Event generated
	RADIO_EVENTS_RSSIEND_EVENTS_RSSIEND_Generated = 0x1

	// EVENTS_BCMATCH: Bit counter reached bit count value
	// Position of EVENTS_BCMATCH field.
	RADIO_EVENTS_BCMATCH_EVENTS_BCMATCH_Pos = 0x0
	// Bit mask of EVENTS_BCMATCH field.
	RADIO_EVENTS_BCMATCH_EVENTS_BCMATCH_Msk = 0x1
	// Bit EVENTS_BCMATCH.
	RADIO_EVENTS_BCMATCH_EVENTS_BCMATCH = 0x1
	// Event not generated
	RADIO_EVENTS_BCMATCH_EVENTS_BCMATCH_NotGenerated = 0x0
	// Event generated
	RADIO_EVENTS_BCMATCH_EVENTS_BCMATCH_Generated = 0x1

	// EVENTS_CRCOK: Packet received with CRC ok
	// Position of EVENTS_CRCOK field.
	RADIO_EVENTS_CRCOK_EVENTS_CRCOK_Pos = 0x0
	// Bit mask of EVENTS_CRCOK field.
	RADIO_EVENTS_CRCOK_EVENTS_CRCOK_Msk = 0x1
	// Bit EVENTS_CRCOK.
	RADIO_EVENTS_CRCOK_EVENTS_CRCOK = 0x1
	// Event not generated
	RADIO_EVENTS_CRCOK_EVENTS_CRCOK_NotGenerated = 0x0
	// Event generated
	RADIO_EVENTS_CRCOK_EVENTS_CRCOK_Generated = 0x1

	// EVENTS_CRCERROR: Packet received with CRC error
	// Position of EVENTS_CRCERROR field.
	RADIO_EVENTS_CRCERROR_EVENTS_CRCERROR_Pos = 0x0
	// Bit mask of EVENTS_CRCERROR field.
	RADIO_EVENTS_CRCERROR_EVENTS_CRCERROR_Msk = 0x1
	// Bit EVENTS_CRCERROR.
	RADIO_EVENTS_CRCERROR_EVENTS_CRCERROR = 0x1
	// Event not generated
	RADIO_EVENTS_CRCERROR_EVENTS_CRCERROR_NotGenerated = 0x0
	// Event generated
	RADIO_EVENTS_CRCERROR_EVENTS_CRCERROR_Generated = 0x1

	// EVENTS_FRAMESTART: IEEE 802.15.4 length field received
	// Position of EVENTS_FRAMESTART field.
	RADIO_EVENTS_FRAMESTART_EVENTS_FRAMESTART_Pos = 0x0
	// Bit mask of EVENTS_FRAMESTART field.
	RADIO_EVENTS_FRAMESTART_EVENTS_FRAMESTART_Msk = 0x1
	// Bit EVENTS_FRAMESTART.
	RADIO_EVENTS_FRAMESTART_EVENTS_FRAMESTART = 0x1
	// Event not generated
	RADIO_EVENTS_FRAMESTART_EVENTS_FRAMESTART_NotGenerated = 0x0
	// Event generated
	RADIO_EVENTS_FRAMESTART_EVENTS_FRAMESTART_Generated = 0x1

	// EVENTS_EDEND: Sampling of energy detection complete. A new ED sample is ready for readout from the RADIO.EDSAMPLE register
	// Position of EVENTS_EDEND field.
	RADIO_EVENTS_EDEND_EVENTS_EDEND_Pos = 0x0
	// Bit mask of EVENTS_EDEND field.
	RADIO_EVENTS_EDEND_EVENTS_EDEND_Msk = 0x1
	// Bit EVENTS_EDEND.
	RADIO_EVENTS_EDEND_EVENTS_EDEND = 0x1
	// Event not generated
	RADIO_EVENTS_EDEND_EVENTS_EDEND_NotGenerated = 0x0
	// Event generated
	RADIO_EVENTS_EDEND_EVENTS_EDEND_Generated = 0x1

	// EVENTS_EDSTOPPED: The sampling of energy detection has stopped
	// Position of EVENTS_EDSTOPPED field.
	RADIO_EVENTS_EDSTOPPED_EVENTS_EDSTOPPED_Pos = 0x0
	// Bit mask of EVENTS_EDSTOPPED field.
	RADIO_EVENTS_EDSTOPPED_EVENTS_EDSTOPPED_Msk = 0x1
	// Bit EVENTS_EDSTOPPED.
	RADIO_EVENTS_EDSTOPPED_EVENTS_EDSTOPPED = 0x1
	// Event not generated
	RADIO_EVENTS_EDSTOPPED_EVENTS_EDSTOPPED_NotGenerated = 0x0
	// Event generated
	RADIO_EVENTS_EDSTOPPED_EVENTS_EDSTOPPED_Generated = 0x1

	// EVENTS_CCAIDLE: Wireless medium in idle - clear to send
	// Position of EVENTS_CCAIDLE field.
	RADIO_EVENTS_CCAIDLE_EVENTS_CCAIDLE_Pos = 0x0
	// Bit mask of EVENTS_CCAIDLE field.
	RADIO_EVENTS_CCAIDLE_EVENTS_CCAIDLE_Msk = 0x1
	// Bit EVENTS_CCAIDLE.
	RADIO_EVENTS_CCAIDLE_EVENTS_CCAIDLE = 0x1
	// Event not generated
	RADIO_EVENTS_CCAIDLE_EVENTS_CCAIDLE_NotGenerated = 0x0
	// Event generated
	RADIO_EVENTS_CCAIDLE_EVENTS_CCAIDLE_Generated = 0x1

	// EVENTS_CCABUSY: Wireless medium busy - do not send
	// Position of EVENTS_CCABUSY field.
	RADIO_EVENTS_CCABUSY_EVENTS_CCABUSY_Pos = 0x0
	// Bit mask of EVENTS_CCABUSY field.
	RADIO_EVENTS_CCABUSY_EVENTS_CCABUSY_Msk = 0x1
	// Bit EVENTS_CCABUSY.
	RADIO_EVENTS_CCABUSY_EVENTS_CCABUSY = 0x1
	// Event not generated
	RADIO_EVENTS_CCABUSY_EVENTS_CCABUSY_NotGenerated = 0x0
	// Event generated
	RADIO_EVENTS_CCABUSY_EVENTS_CCABUSY_Generated = 0x1

	// EVENTS_CCASTOPPED: The CCA has stopped
	// Position of EVENTS_CCASTOPPED field.
	RADIO_EVENTS_CCASTOPPED_EVENTS_CCASTOPPED_Pos = 0x0
	// Bit mask of EVENTS_CCASTOPPED field.
	RADIO_EVENTS_CCASTOPPED_EVENTS_CCASTOPPED_Msk = 0x1
	// Bit EVENTS_CCASTOPPED.
	RADIO_EVENTS_CCASTOPPED_EVENTS_CCASTOPPED = 0x1
	// Event not generated
	RADIO_EVENTS_CCASTOPPED_EVENTS_CCASTOPPED_NotGenerated = 0x0
	// Event generated
	RADIO_EVENTS_CCASTOPPED_EVENTS_CCASTOPPED_Generated = 0x1

	// EVENTS_RATEBOOST: Ble_LR CI field received, receive mode is changed from Ble_LR125Kbit to Ble_LR500Kbit.
	// Position of EVENTS_RATEBOOST field.
	RADIO_EVENTS_RATEBOOST_EVENTS_RATEBOOST_Pos = 0x0
	// Bit mask of EVENTS_RATEBOOST field.
	RADIO_EVENTS_RATEBOOST_EVENTS_RATEBOOST_Msk = 0x1
	// Bit EVENTS_RATEBOOST.
	RADIO_EVENTS_RATEBOOST_EVENTS_RATEBOOST = 0x1
	// Event not generated
	RADIO_EVENTS_RATEBOOST_EVENTS_RATEBOOST_NotGenerated = 0x0
	// Event generated
	RADIO_EVENTS_RATEBOOST_EVENTS_RATEBOOST_Generated = 0x1

	// EVENTS_TXREADY: RADIO has ramped up and is ready to be started TX path
	// Position of EVENTS_TXREADY field.
	RADIO_EVENTS_TXREADY_EVENTS_TXREADY_Pos = 0x0
	// Bit mask of EVENTS_TXREADY field.
	RADIO_EVENTS_TXREADY_EVENTS_TXREADY_Msk = 0x1
	// Bit EVENTS_TXREADY.
	RADIO_EVENTS_TXREADY_EVENTS_TXREADY = 0x1
	// Event not generated
	RADIO_EVENTS_TXREADY_EVENTS_TXREADY_NotGenerated = 0x0
	// Event generated
	RADIO_EVENTS_TXREADY_EVENTS_TXREADY_Generated = 0x1

	// EVENTS_RXREADY: RADIO has ramped up and is ready to be started RX path
	// Position of EVENTS_RXREADY field.
	RADIO_EVENTS_RXREADY_EVENTS_RXREADY_Pos = 0x0
	// Bit mask of EVENTS_RXREADY field.
	RADIO_EVENTS_RXREADY_EVENTS_RXREADY_Msk = 0x1
	// Bit EVENTS_RXREADY.
	RADIO_EVENTS_RXREADY_EVENTS_RXREADY = 0x1
	// Event not generated
	RADIO_EVENTS_RXREADY_EVENTS_RXREADY_NotGenerated = 0x0
	// Event generated
	RADIO_EVENTS_RXREADY_EVENTS_RXREADY_Generated = 0x1

	// EVENTS_MHRMATCH: MAC header match found
	// Position of EVENTS_MHRMATCH field.
	RADIO_EVENTS_MHRMATCH_EVENTS_MHRMATCH_Pos = 0x0
	// Bit mask of EVENTS_MHRMATCH field.
	RADIO_EVENTS_MHRMATCH_EVENTS_MHRMATCH_Msk = 0x1
	// Bit EVENTS_MHRMATCH.
	RADIO_EVENTS_MHRMATCH_EVENTS_MHRMATCH = 0x1
	// Event not generated
	RADIO_EVENTS_MHRMATCH_EVENTS_MHRMATCH_NotGenerated = 0x0
	// Event generated
	RADIO_EVENTS_MHRMATCH_EVENTS_MHRMATCH_Generated = 0x1

	// EVENTS_SYNC: Preamble indicator
	// Position of EVENTS_SYNC field.
	RADIO_EVENTS_SYNC_EVENTS_SYNC_Pos = 0x0
	// Bit mask of EVENTS_SYNC field.
	RADIO_EVENTS_SYNC_EVENTS_SYNC_Msk = 0x1
	// Bit EVENTS_SYNC.
	RADIO_EVENTS_SYNC_EVENTS_SYNC = 0x1
	// Event not generated
	RADIO_EVENTS_SYNC_EVENTS_SYNC_NotGenerated = 0x0
	// Event generated
	RADIO_EVENTS_SYNC_EVENTS_SYNC_Generated = 0x1

	// EVENTS_PHYEND: Generated when last bit is sent on air, or received from air
	// Position of EVENTS_PHYEND field.
	RADIO_EVENTS_PHYEND_EVENTS_PHYEND_Pos = 0x0
	// Bit mask of EVENTS_PHYEND field.
	RADIO_EVENTS_PHYEND_EVENTS_PHYEND_Msk = 0x1
	// Bit EVENTS_PHYEND.
	RADIO_EVENTS_PHYEND_EVENTS_PHYEND = 0x1
	// Event not generated
	RADIO_EVENTS_PHYEND_EVENTS_PHYEND_NotGenerated = 0x0
	// Event generated
	RADIO_EVENTS_PHYEND_EVENTS_PHYEND_Generated = 0x1

	// EVENTS_CTEPRESENT: CTE is present (early warning right after receiving CTEInfo byte)
	// Position of EVENTS_CTEPRESENT field.
	RADIO_EVENTS_CTEPRESENT_EVENTS_CTEPRESENT_Pos = 0x0
	// Bit mask of EVENTS_CTEPRESENT field.
	RADIO_EVENTS_CTEPRESENT_EVENTS_CTEPRESENT_Msk = 0x1
	// Bit EVENTS_CTEPRESENT.
	RADIO_EVENTS_CTEPRESENT_EVENTS_CTEPRESENT = 0x1
	// Event not generated
	RADIO_EVENTS_CTEPRESENT_EVENTS_CTEPRESENT_NotGenerated = 0x0
	// Event generated
	RADIO_EVENTS_CTEPRESENT_EVENTS_CTEPRESENT_Generated = 0x1

	// PUBLISH_READY: Publish configuration for event READY
	// Position of CHIDX field.
	RADIO_PUBLISH_READY_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	RADIO_PUBLISH_READY_CHIDX_Msk = 0xff
	// Position of EN field.
	RADIO_PUBLISH_READY_EN_Pos = 0x1f
	// Bit mask of EN field.
	RADIO_PUBLISH_READY_EN_Msk = 0x80000000
	// Bit EN.
	RADIO_PUBLISH_READY_EN = 0x80000000
	// Disable publishing
	RADIO_PUBLISH_READY_EN_Disabled = 0x0
	// Enable publishing
	RADIO_PUBLISH_READY_EN_Enabled = 0x1

	// PUBLISH_ADDRESS: Publish configuration for event ADDRESS
	// Position of CHIDX field.
	RADIO_PUBLISH_ADDRESS_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	RADIO_PUBLISH_ADDRESS_CHIDX_Msk = 0xff
	// Position of EN field.
	RADIO_PUBLISH_ADDRESS_EN_Pos = 0x1f
	// Bit mask of EN field.
	RADIO_PUBLISH_ADDRESS_EN_Msk = 0x80000000
	// Bit EN.
	RADIO_PUBLISH_ADDRESS_EN = 0x80000000
	// Disable publishing
	RADIO_PUBLISH_ADDRESS_EN_Disabled = 0x0
	// Enable publishing
	RADIO_PUBLISH_ADDRESS_EN_Enabled = 0x1

	// PUBLISH_PAYLOAD: Publish configuration for event PAYLOAD
	// Position of CHIDX field.
	RADIO_PUBLISH_PAYLOAD_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	RADIO_PUBLISH_PAYLOAD_CHIDX_Msk = 0xff
	// Position of EN field.
	RADIO_PUBLISH_PAYLOAD_EN_Pos = 0x1f
	// Bit mask of EN field.
	RADIO_PUBLISH_PAYLOAD_EN_Msk = 0x80000000
	// Bit EN.
	RADIO_PUBLISH_PAYLOAD_EN = 0x80000000
	// Disable publishing
	RADIO_PUBLISH_PAYLOAD_EN_Disabled = 0x0
	// Enable publishing
	RADIO_PUBLISH_PAYLOAD_EN_Enabled = 0x1

	// PUBLISH_END: Publish configuration for event END
	// Position of CHIDX field.
	RADIO_PUBLISH_END_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	RADIO_PUBLISH_END_CHIDX_Msk = 0xff
	// Position of EN field.
	RADIO_PUBLISH_END_EN_Pos = 0x1f
	// Bit mask of EN field.
	RADIO_PUBLISH_END_EN_Msk = 0x80000000
	// Bit EN.
	RADIO_PUBLISH_END_EN = 0x80000000
	// Disable publishing
	RADIO_PUBLISH_END_EN_Disabled = 0x0
	// Enable publishing
	RADIO_PUBLISH_END_EN_Enabled = 0x1

	// PUBLISH_DISABLED: Publish configuration for event DISABLED
	// Position of CHIDX field.
	RADIO_PUBLISH_DISABLED_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	RADIO_PUBLISH_DISABLED_CHIDX_Msk = 0xff
	// Position of EN field.
	RADIO_PUBLISH_DISABLED_EN_Pos = 0x1f
	// Bit mask of EN field.
	RADIO_PUBLISH_DISABLED_EN_Msk = 0x80000000
	// Bit EN.
	RADIO_PUBLISH_DISABLED_EN = 0x80000000
	// Disable publishing
	RADIO_PUBLISH_DISABLED_EN_Disabled = 0x0
	// Enable publishing
	RADIO_PUBLISH_DISABLED_EN_Enabled = 0x1

	// PUBLISH_DEVMATCH: Publish configuration for event DEVMATCH
	// Position of CHIDX field.
	RADIO_PUBLISH_DEVMATCH_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	RADIO_PUBLISH_DEVMATCH_CHIDX_Msk = 0xff
	// Position of EN field.
	RADIO_PUBLISH_DEVMATCH_EN_Pos = 0x1f
	// Bit mask of EN field.
	RADIO_PUBLISH_DEVMATCH_EN_Msk = 0x80000000
	// Bit EN.
	RADIO_PUBLISH_DEVMATCH_EN = 0x80000000
	// Disable publishing
	RADIO_PUBLISH_DEVMATCH_EN_Disabled = 0x0
	// Enable publishing
	RADIO_PUBLISH_DEVMATCH_EN_Enabled = 0x1

	// PUBLISH_DEVMISS: Publish configuration for event DEVMISS
	// Position of CHIDX field.
	RADIO_PUBLISH_DEVMISS_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	RADIO_PUBLISH_DEVMISS_CHIDX_Msk = 0xff
	// Position of EN field.
	RADIO_PUBLISH_DEVMISS_EN_Pos = 0x1f
	// Bit mask of EN field.
	RADIO_PUBLISH_DEVMISS_EN_Msk = 0x80000000
	// Bit EN.
	RADIO_PUBLISH_DEVMISS_EN = 0x80000000
	// Disable publishing
	RADIO_PUBLISH_DEVMISS_EN_Disabled = 0x0
	// Enable publishing
	RADIO_PUBLISH_DEVMISS_EN_Enabled = 0x1

	// PUBLISH_RSSIEND: Publish configuration for event RSSIEND
	// Position of CHIDX field.
	RADIO_PUBLISH_RSSIEND_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	RADIO_PUBLISH_RSSIEND_CHIDX_Msk = 0xff
	// Position of EN field.
	RADIO_PUBLISH_RSSIEND_EN_Pos = 0x1f
	// Bit mask of EN field.
	RADIO_PUBLISH_RSSIEND_EN_Msk = 0x80000000
	// Bit EN.
	RADIO_PUBLISH_RSSIEND_EN = 0x80000000
	// Disable publishing
	RADIO_PUBLISH_RSSIEND_EN_Disabled = 0x0
	// Enable publishing
	RADIO_PUBLISH_RSSIEND_EN_Enabled = 0x1

	// PUBLISH_BCMATCH: Publish configuration for event BCMATCH
	// Position of CHIDX field.
	RADIO_PUBLISH_BCMATCH_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	RADIO_PUBLISH_BCMATCH_CHIDX_Msk = 0xff
	// Position of EN field.
	RADIO_PUBLISH_BCMATCH_EN_Pos = 0x1f
	// Bit mask of EN field.
	RADIO_PUBLISH_BCMATCH_EN_Msk = 0x80000000
	// Bit EN.
	RADIO_PUBLISH_BCMATCH_EN = 0x80000000
	// Disable publishing
	RADIO_PUBLISH_BCMATCH_EN_Disabled = 0x0
	// Enable publishing
	RADIO_PUBLISH_BCMATCH_EN_Enabled = 0x1

	// PUBLISH_CRCOK: Publish configuration for event CRCOK
	// Position of CHIDX field.
	RADIO_PUBLISH_CRCOK_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	RADIO_PUBLISH_CRCOK_CHIDX_Msk = 0xff
	// Position of EN field.
	RADIO_PUBLISH_CRCOK_EN_Pos = 0x1f
	// Bit mask of EN field.
	RADIO_PUBLISH_CRCOK_EN_Msk = 0x80000000
	// Bit EN.
	RADIO_PUBLISH_CRCOK_EN = 0x80000000
	// Disable publishing
	RADIO_PUBLISH_CRCOK_EN_Disabled = 0x0
	// Enable publishing
	RADIO_PUBLISH_CRCOK_EN_Enabled = 0x1

	// PUBLISH_CRCERROR: Publish configuration for event CRCERROR
	// Position of CHIDX field.
	RADIO_PUBLISH_CRCERROR_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	RADIO_PUBLISH_CRCERROR_CHIDX_Msk = 0xff
	// Position of EN field.
	RADIO_PUBLISH_CRCERROR_EN_Pos = 0x1f
	// Bit mask of EN field.
	RADIO_PUBLISH_CRCERROR_EN_Msk = 0x80000000
	// Bit EN.
	RADIO_PUBLISH_CRCERROR_EN = 0x80000000
	// Disable publishing
	RADIO_PUBLISH_CRCERROR_EN_Disabled = 0x0
	// Enable publishing
	RADIO_PUBLISH_CRCERROR_EN_Enabled = 0x1

	// PUBLISH_FRAMESTART: Publish configuration for event FRAMESTART
	// Position of CHIDX field.
	RADIO_PUBLISH_FRAMESTART_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	RADIO_PUBLISH_FRAMESTART_CHIDX_Msk = 0xff
	// Position of EN field.
	RADIO_PUBLISH_FRAMESTART_EN_Pos = 0x1f
	// Bit mask of EN field.
	RADIO_PUBLISH_FRAMESTART_EN_Msk = 0x80000000
	// Bit EN.
	RADIO_PUBLISH_FRAMESTART_EN = 0x80000000
	// Disable publishing
	RADIO_PUBLISH_FRAMESTART_EN_Disabled = 0x0
	// Enable publishing
	RADIO_PUBLISH_FRAMESTART_EN_Enabled = 0x1

	// PUBLISH_EDEND: Publish configuration for event EDEND
	// Position of CHIDX field.
	RADIO_PUBLISH_EDEND_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	RADIO_PUBLISH_EDEND_CHIDX_Msk = 0xff
	// Position of EN field.
	RADIO_PUBLISH_EDEND_EN_Pos = 0x1f
	// Bit mask of EN field.
	RADIO_PUBLISH_EDEND_EN_Msk = 0x80000000
	// Bit EN.
	RADIO_PUBLISH_EDEND_EN = 0x80000000
	// Disable publishing
	RADIO_PUBLISH_EDEND_EN_Disabled = 0x0
	// Enable publishing
	RADIO_PUBLISH_EDEND_EN_Enabled = 0x1

	// PUBLISH_EDSTOPPED: Publish configuration for event EDSTOPPED
	// Position of CHIDX field.
	RADIO_PUBLISH_EDSTOPPED_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	RADIO_PUBLISH_EDSTOPPED_CHIDX_Msk = 0xff
	// Position of EN field.
	RADIO_PUBLISH_EDSTOPPED_EN_Pos = 0x1f
	// Bit mask of EN field.
	RADIO_PUBLISH_EDSTOPPED_EN_Msk = 0x80000000
	// Bit EN.
	RADIO_PUBLISH_EDSTOPPED_EN = 0x80000000
	// Disable publishing
	RADIO_PUBLISH_EDSTOPPED_EN_Disabled = 0x0
	// Enable publishing
	RADIO_PUBLISH_EDSTOPPED_EN_Enabled = 0x1

	// PUBLISH_CCAIDLE: Publish configuration for event CCAIDLE
	// Position of CHIDX field.
	RADIO_PUBLISH_CCAIDLE_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	RADIO_PUBLISH_CCAIDLE_CHIDX_Msk = 0xff
	// Position of EN field.
	RADIO_PUBLISH_CCAIDLE_EN_Pos = 0x1f
	// Bit mask of EN field.
	RADIO_PUBLISH_CCAIDLE_EN_Msk = 0x80000000
	// Bit EN.
	RADIO_PUBLISH_CCAIDLE_EN = 0x80000000
	// Disable publishing
	RADIO_PUBLISH_CCAIDLE_EN_Disabled = 0x0
	// Enable publishing
	RADIO_PUBLISH_CCAIDLE_EN_Enabled = 0x1

	// PUBLISH_CCABUSY: Publish configuration for event CCABUSY
	// Position of CHIDX field.
	RADIO_PUBLISH_CCABUSY_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	RADIO_PUBLISH_CCABUSY_CHIDX_Msk = 0xff
	// Position of EN field.
	RADIO_PUBLISH_CCABUSY_EN_Pos = 0x1f
	// Bit mask of EN field.
	RADIO_PUBLISH_CCABUSY_EN_Msk = 0x80000000
	// Bit EN.
	RADIO_PUBLISH_CCABUSY_EN = 0x80000000
	// Disable publishing
	RADIO_PUBLISH_CCABUSY_EN_Disabled = 0x0
	// Enable publishing
	RADIO_PUBLISH_CCABUSY_EN_Enabled = 0x1

	// PUBLISH_CCASTOPPED: Publish configuration for event CCASTOPPED
	// Position of CHIDX field.
	RADIO_PUBLISH_CCASTOPPED_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	RADIO_PUBLISH_CCASTOPPED_CHIDX_Msk = 0xff
	// Position of EN field.
	RADIO_PUBLISH_CCASTOPPED_EN_Pos = 0x1f
	// Bit mask of EN field.
	RADIO_PUBLISH_CCASTOPPED_EN_Msk = 0x80000000
	// Bit EN.
	RADIO_PUBLISH_CCASTOPPED_EN = 0x80000000
	// Disable publishing
	RADIO_PUBLISH_CCASTOPPED_EN_Disabled = 0x0
	// Enable publishing
	RADIO_PUBLISH_CCASTOPPED_EN_Enabled = 0x1

	// PUBLISH_RATEBOOST: Publish configuration for event RATEBOOST
	// Position of CHIDX field.
	RADIO_PUBLISH_RATEBOOST_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	RADIO_PUBLISH_RATEBOOST_CHIDX_Msk = 0xff
	// Position of EN field.
	RADIO_PUBLISH_RATEBOOST_EN_Pos = 0x1f
	// Bit mask of EN field.
	RADIO_PUBLISH_RATEBOOST_EN_Msk = 0x80000000
	// Bit EN.
	RADIO_PUBLISH_RATEBOOST_EN = 0x80000000
	// Disable publishing
	RADIO_PUBLISH_RATEBOOST_EN_Disabled = 0x0
	// Enable publishing
	RADIO_PUBLISH_RATEBOOST_EN_Enabled = 0x1

	// PUBLISH_TXREADY: Publish configuration for event TXREADY
	// Position of CHIDX field.
	RADIO_PUBLISH_TXREADY_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	RADIO_PUBLISH_TXREADY_CHIDX_Msk = 0xff
	// Position of EN field.
	RADIO_PUBLISH_TXREADY_EN_Pos = 0x1f
	// Bit mask of EN field.
	RADIO_PUBLISH_TXREADY_EN_Msk = 0x80000000
	// Bit EN.
	RADIO_PUBLISH_TXREADY_EN = 0x80000000
	// Disable publishing
	RADIO_PUBLISH_TXREADY_EN_Disabled = 0x0
	// Enable publishing
	RADIO_PUBLISH_TXREADY_EN_Enabled = 0x1

	// PUBLISH_RXREADY: Publish configuration for event RXREADY
	// Position of CHIDX field.
	RADIO_PUBLISH_RXREADY_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	RADIO_PUBLISH_RXREADY_CHIDX_Msk = 0xff
	// Position of EN field.
	RADIO_PUBLISH_RXREADY_EN_Pos = 0x1f
	// Bit mask of EN field.
	RADIO_PUBLISH_RXREADY_EN_Msk = 0x80000000
	// Bit EN.
	RADIO_PUBLISH_RXREADY_EN = 0x80000000
	// Disable publishing
	RADIO_PUBLISH_RXREADY_EN_Disabled = 0x0
	// Enable publishing
	RADIO_PUBLISH_RXREADY_EN_Enabled = 0x1

	// PUBLISH_MHRMATCH: Publish configuration for event MHRMATCH
	// Position of CHIDX field.
	RADIO_PUBLISH_MHRMATCH_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	RADIO_PUBLISH_MHRMATCH_CHIDX_Msk = 0xff
	// Position of EN field.
	RADIO_PUBLISH_MHRMATCH_EN_Pos = 0x1f
	// Bit mask of EN field.
	RADIO_PUBLISH_MHRMATCH_EN_Msk = 0x80000000
	// Bit EN.
	RADIO_PUBLISH_MHRMATCH_EN = 0x80000000
	// Disable publishing
	RADIO_PUBLISH_MHRMATCH_EN_Disabled = 0x0
	// Enable publishing
	RADIO_PUBLISH_MHRMATCH_EN_Enabled = 0x1

	// PUBLISH_SYNC: Publish configuration for event SYNC
	// Position of CHIDX field.
	RADIO_PUBLISH_SYNC_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	RADIO_PUBLISH_SYNC_CHIDX_Msk = 0xff
	// Position of EN field.
	RADIO_PUBLISH_SYNC_EN_Pos = 0x1f
	// Bit mask of EN field.
	RADIO_PUBLISH_SYNC_EN_Msk = 0x80000000
	// Bit EN.
	RADIO_PUBLISH_SYNC_EN = 0x80000000
	// Disable publishing
	RADIO_PUBLISH_SYNC_EN_Disabled = 0x0
	// Enable publishing
	RADIO_PUBLISH_SYNC_EN_Enabled = 0x1

	// PUBLISH_PHYEND: Publish configuration for event PHYEND
	// Position of CHIDX field.
	RADIO_PUBLISH_PHYEND_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	RADIO_PUBLISH_PHYEND_CHIDX_Msk = 0xff
	// Position of EN field.
	RADIO_PUBLISH_PHYEND_EN_Pos = 0x1f
	// Bit mask of EN field.
	RADIO_PUBLISH_PHYEND_EN_Msk = 0x80000000
	// Bit EN.
	RADIO_PUBLISH_PHYEND_EN = 0x80000000
	// Disable publishing
	RADIO_PUBLISH_PHYEND_EN_Disabled = 0x0
	// Enable publishing
	RADIO_PUBLISH_PHYEND_EN_Enabled = 0x1

	// PUBLISH_CTEPRESENT: Publish configuration for event CTEPRESENT
	// Position of CHIDX field.
	RADIO_PUBLISH_CTEPRESENT_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	RADIO_PUBLISH_CTEPRESENT_CHIDX_Msk = 0xff
	// Position of EN field.
	RADIO_PUBLISH_CTEPRESENT_EN_Pos = 0x1f
	// Bit mask of EN field.
	RADIO_PUBLISH_CTEPRESENT_EN_Msk = 0x80000000
	// Bit EN.
	RADIO_PUBLISH_CTEPRESENT_EN = 0x80000000
	// Disable publishing
	RADIO_PUBLISH_CTEPRESENT_EN_Disabled = 0x0
	// Enable publishing
	RADIO_PUBLISH_CTEPRESENT_EN_Enabled = 0x1

	// SHORTS: Shortcuts between local events and tasks
	// Position of READY_START field.
	RADIO_SHORTS_READY_START_Pos = 0x0
	// Bit mask of READY_START field.
	RADIO_SHORTS_READY_START_Msk = 0x1
	// Bit READY_START.
	RADIO_SHORTS_READY_START = 0x1
	// Disable shortcut
	RADIO_SHORTS_READY_START_Disabled = 0x0
	// Enable shortcut
	RADIO_SHORTS_READY_START_Enabled = 0x1
	// Position of END_DISABLE field.
	RADIO_SHORTS_END_DISABLE_Pos = 0x1
	// Bit mask of END_DISABLE field.
	RADIO_SHORTS_END_DISABLE_Msk = 0x2
	// Bit END_DISABLE.
	RADIO_SHORTS_END_DISABLE = 0x2
	// Disable shortcut
	RADIO_SHORTS_END_DISABLE_Disabled = 0x0
	// Enable shortcut
	RADIO_SHORTS_END_DISABLE_Enabled = 0x1
	// Position of DISABLED_TXEN field.
	RADIO_SHORTS_DISABLED_TXEN_Pos = 0x2
	// Bit mask of DISABLED_TXEN field.
	RADIO_SHORTS_DISABLED_TXEN_Msk = 0x4
	// Bit DISABLED_TXEN.
	RADIO_SHORTS_DISABLED_TXEN = 0x4
	// Disable shortcut
	RADIO_SHORTS_DISABLED_TXEN_Disabled = 0x0
	// Enable shortcut
	RADIO_SHORTS_DISABLED_TXEN_Enabled = 0x1
	// Position of DISABLED_RXEN field.
	RADIO_SHORTS_DISABLED_RXEN_Pos = 0x3
	// Bit mask of DISABLED_RXEN field.
	RADIO_SHORTS_DISABLED_RXEN_Msk = 0x8
	// Bit DISABLED_RXEN.
	RADIO_SHORTS_DISABLED_RXEN = 0x8
	// Disable shortcut
	RADIO_SHORTS_DISABLED_RXEN_Disabled = 0x0
	// Enable shortcut
	RADIO_SHORTS_DISABLED_RXEN_Enabled = 0x1
	// Position of ADDRESS_RSSISTART field.
	RADIO_SHORTS_ADDRESS_RSSISTART_Pos = 0x4
	// Bit mask of ADDRESS_RSSISTART field.
	RADIO_SHORTS_ADDRESS_RSSISTART_Msk = 0x10
	// Bit ADDRESS_RSSISTART.
	RADIO_SHORTS_ADDRESS_RSSISTART = 0x10
	// Disable shortcut
	RADIO_SHORTS_ADDRESS_RSSISTART_Disabled = 0x0
	// Enable shortcut
	RADIO_SHORTS_ADDRESS_RSSISTART_Enabled = 0x1
	// Position of END_START field.
	RADIO_SHORTS_END_START_Pos = 0x5
	// Bit mask of END_START field.
	RADIO_SHORTS_END_START_Msk = 0x20
	// Bit END_START.
	RADIO_SHORTS_END_START = 0x20
	// Disable shortcut
	RADIO_SHORTS_END_START_Disabled = 0x0
	// Enable shortcut
	RADIO_SHORTS_END_START_Enabled = 0x1
	// Position of ADDRESS_BCSTART field.
	RADIO_SHORTS_ADDRESS_BCSTART_Pos = 0x6
	// Bit mask of ADDRESS_BCSTART field.
	RADIO_SHORTS_ADDRESS_BCSTART_Msk = 0x40
	// Bit ADDRESS_BCSTART.
	RADIO_SHORTS_ADDRESS_BCSTART = 0x40
	// Disable shortcut
	RADIO_SHORTS_ADDRESS_BCSTART_Disabled = 0x0
	// Enable shortcut
	RADIO_SHORTS_ADDRESS_BCSTART_Enabled = 0x1
	// Position of DISABLED_RSSISTOP field.
	RADIO_SHORTS_DISABLED_RSSISTOP_Pos = 0x8
	// Bit mask of DISABLED_RSSISTOP field.
	RADIO_SHORTS_DISABLED_RSSISTOP_Msk = 0x100
	// Bit DISABLED_RSSISTOP.
	RADIO_SHORTS_DISABLED_RSSISTOP = 0x100
	// Disable shortcut
	RADIO_SHORTS_DISABLED_RSSISTOP_Disabled = 0x0
	// Enable shortcut
	RADIO_SHORTS_DISABLED_RSSISTOP_Enabled = 0x1
	// Position of RXREADY_CCASTART field.
	RADIO_SHORTS_RXREADY_CCASTART_Pos = 0xb
	// Bit mask of RXREADY_CCASTART field.
	RADIO_SHORTS_RXREADY_CCASTART_Msk = 0x800
	// Bit RXREADY_CCASTART.
	RADIO_SHORTS_RXREADY_CCASTART = 0x800
	// Disable shortcut
	RADIO_SHORTS_RXREADY_CCASTART_Disabled = 0x0
	// Enable shortcut
	RADIO_SHORTS_RXREADY_CCASTART_Enabled = 0x1
	// Position of CCAIDLE_TXEN field.
	RADIO_SHORTS_CCAIDLE_TXEN_Pos = 0xc
	// Bit mask of CCAIDLE_TXEN field.
	RADIO_SHORTS_CCAIDLE_TXEN_Msk = 0x1000
	// Bit CCAIDLE_TXEN.
	RADIO_SHORTS_CCAIDLE_TXEN = 0x1000
	// Disable shortcut
	RADIO_SHORTS_CCAIDLE_TXEN_Disabled = 0x0
	// Enable shortcut
	RADIO_SHORTS_CCAIDLE_TXEN_Enabled = 0x1
	// Position of CCABUSY_DISABLE field.
	RADIO_SHORTS_CCABUSY_DISABLE_Pos = 0xd
	// Bit mask of CCABUSY_DISABLE field.
	RADIO_SHORTS_CCABUSY_DISABLE_Msk = 0x2000
	// Bit CCABUSY_DISABLE.
	RADIO_SHORTS_CCABUSY_DISABLE = 0x2000
	// Disable shortcut
	RADIO_SHORTS_CCABUSY_DISABLE_Disabled = 0x0
	// Enable shortcut
	RADIO_SHORTS_CCABUSY_DISABLE_Enabled = 0x1
	// Position of FRAMESTART_BCSTART field.
	RADIO_SHORTS_FRAMESTART_BCSTART_Pos = 0xe
	// Bit mask of FRAMESTART_BCSTART field.
	RADIO_SHORTS_FRAMESTART_BCSTART_Msk = 0x4000
	// Bit FRAMESTART_BCSTART.
	RADIO_SHORTS_FRAMESTART_BCSTART = 0x4000
	// Disable shortcut
	RADIO_SHORTS_FRAMESTART_BCSTART_Disabled = 0x0
	// Enable shortcut
	RADIO_SHORTS_FRAMESTART_BCSTART_Enabled = 0x1
	// Position of READY_EDSTART field.
	RADIO_SHORTS_READY_EDSTART_Pos = 0xf
	// Bit mask of READY_EDSTART field.
	RADIO_SHORTS_READY_EDSTART_Msk = 0x8000
	// Bit READY_EDSTART.
	RADIO_SHORTS_READY_EDSTART = 0x8000
	// Disable shortcut
	RADIO_SHORTS_READY_EDSTART_Disabled = 0x0
	// Enable shortcut
	RADIO_SHORTS_READY_EDSTART_Enabled = 0x1
	// Position of EDEND_DISABLE field.
	RADIO_SHORTS_EDEND_DISABLE_Pos = 0x10
	// Bit mask of EDEND_DISABLE field.
	RADIO_SHORTS_EDEND_DISABLE_Msk = 0x10000
	// Bit EDEND_DISABLE.
	RADIO_SHORTS_EDEND_DISABLE = 0x10000
	// Disable shortcut
	RADIO_SHORTS_EDEND_DISABLE_Disabled = 0x0
	// Enable shortcut
	RADIO_SHORTS_EDEND_DISABLE_Enabled = 0x1
	// Position of CCAIDLE_STOP field.
	RADIO_SHORTS_CCAIDLE_STOP_Pos = 0x11
	// Bit mask of CCAIDLE_STOP field.
	RADIO_SHORTS_CCAIDLE_STOP_Msk = 0x20000
	// Bit CCAIDLE_STOP.
	RADIO_SHORTS_CCAIDLE_STOP = 0x20000
	// Disable shortcut
	RADIO_SHORTS_CCAIDLE_STOP_Disabled = 0x0
	// Enable shortcut
	RADIO_SHORTS_CCAIDLE_STOP_Enabled = 0x1
	// Position of TXREADY_START field.
	RADIO_SHORTS_TXREADY_START_Pos = 0x12
	// Bit mask of TXREADY_START field.
	RADIO_SHORTS_TXREADY_START_Msk = 0x40000
	// Bit TXREADY_START.
	RADIO_SHORTS_TXREADY_START = 0x40000
	// Disable shortcut
	RADIO_SHORTS_TXREADY_START_Disabled = 0x0
	// Enable shortcut
	RADIO_SHORTS_TXREADY_START_Enabled = 0x1
	// Position of RXREADY_START field.
	RADIO_SHORTS_RXREADY_START_Pos = 0x13
	// Bit mask of RXREADY_START field.
	RADIO_SHORTS_RXREADY_START_Msk = 0x80000
	// Bit RXREADY_START.
	RADIO_SHORTS_RXREADY_START = 0x80000
	// Disable shortcut
	RADIO_SHORTS_RXREADY_START_Disabled = 0x0
	// Enable shortcut
	RADIO_SHORTS_RXREADY_START_Enabled = 0x1
	// Position of PHYEND_DISABLE field.
	RADIO_SHORTS_PHYEND_DISABLE_Pos = 0x14
	// Bit mask of PHYEND_DISABLE field.
	RADIO_SHORTS_PHYEND_DISABLE_Msk = 0x100000
	// Bit PHYEND_DISABLE.
	RADIO_SHORTS_PHYEND_DISABLE = 0x100000
	// Disable shortcut
	RADIO_SHORTS_PHYEND_DISABLE_Disabled = 0x0
	// Enable shortcut
	RADIO_SHORTS_PHYEND_DISABLE_Enabled = 0x1
	// Position of PHYEND_START field.
	RADIO_SHORTS_PHYEND_START_Pos = 0x15
	// Bit mask of PHYEND_START field.
	RADIO_SHORTS_PHYEND_START_Msk = 0x200000
	// Bit PHYEND_START.
	RADIO_SHORTS_PHYEND_START = 0x200000
	// Disable shortcut
	RADIO_SHORTS_PHYEND_START_Disabled = 0x0
	// Enable shortcut
	RADIO_SHORTS_PHYEND_START_Enabled = 0x1

	// INTENSET: Enable interrupt
	// Position of READY field.
	RADIO_INTENSET_READY_Pos = 0x0
	// Bit mask of READY field.
	RADIO_INTENSET_READY_Msk = 0x1
	// Bit READY.
	RADIO_INTENSET_READY = 0x1
	// Read: Disabled
	RADIO_INTENSET_READY_Disabled = 0x0
	// Read: Enabled
	RADIO_INTENSET_READY_Enabled = 0x1
	// Enable
	RADIO_INTENSET_READY_Set = 0x1
	// Position of ADDRESS field.
	RADIO_INTENSET_ADDRESS_Pos = 0x1
	// Bit mask of ADDRESS field.
	RADIO_INTENSET_ADDRESS_Msk = 0x2
	// Bit ADDRESS.
	RADIO_INTENSET_ADDRESS = 0x2
	// Read: Disabled
	RADIO_INTENSET_ADDRESS_Disabled = 0x0
	// Read: Enabled
	RADIO_INTENSET_ADDRESS_Enabled = 0x1
	// Enable
	RADIO_INTENSET_ADDRESS_Set = 0x1
	// Position of PAYLOAD field.
	RADIO_INTENSET_PAYLOAD_Pos = 0x2
	// Bit mask of PAYLOAD field.
	RADIO_INTENSET_PAYLOAD_Msk = 0x4
	// Bit PAYLOAD.
	RADIO_INTENSET_PAYLOAD = 0x4
	// Read: Disabled
	RADIO_INTENSET_PAYLOAD_Disabled = 0x0
	// Read: Enabled
	RADIO_INTENSET_PAYLOAD_Enabled = 0x1
	// Enable
	RADIO_INTENSET_PAYLOAD_Set = 0x1
	// Position of END field.
	RADIO_INTENSET_END_Pos = 0x3
	// Bit mask of END field.
	RADIO_INTENSET_END_Msk = 0x8
	// Bit END.
	RADIO_INTENSET_END = 0x8
	// Read: Disabled
	RADIO_INTENSET_END_Disabled = 0x0
	// Read: Enabled
	RADIO_INTENSET_END_Enabled = 0x1
	// Enable
	RADIO_INTENSET_END_Set = 0x1
	// Position of DISABLED field.
	RADIO_INTENSET_DISABLED_Pos = 0x4
	// Bit mask of DISABLED field.
	RADIO_INTENSET_DISABLED_Msk = 0x10
	// Bit DISABLED.
	RADIO_INTENSET_DISABLED = 0x10
	// Read: Disabled
	RADIO_INTENSET_DISABLED_Disabled = 0x0
	// Read: Enabled
	RADIO_INTENSET_DISABLED_Enabled = 0x1
	// Enable
	RADIO_INTENSET_DISABLED_Set = 0x1
	// Position of DEVMATCH field.
	RADIO_INTENSET_DEVMATCH_Pos = 0x5
	// Bit mask of DEVMATCH field.
	RADIO_INTENSET_DEVMATCH_Msk = 0x20
	// Bit DEVMATCH.
	RADIO_INTENSET_DEVMATCH = 0x20
	// Read: Disabled
	RADIO_INTENSET_DEVMATCH_Disabled = 0x0
	// Read: Enabled
	RADIO_INTENSET_DEVMATCH_Enabled = 0x1
	// Enable
	RADIO_INTENSET_DEVMATCH_Set = 0x1
	// Position of DEVMISS field.
	RADIO_INTENSET_DEVMISS_Pos = 0x6
	// Bit mask of DEVMISS field.
	RADIO_INTENSET_DEVMISS_Msk = 0x40
	// Bit DEVMISS.
	RADIO_INTENSET_DEVMISS = 0x40
	// Read: Disabled
	RADIO_INTENSET_DEVMISS_Disabled = 0x0
	// Read: Enabled
	RADIO_INTENSET_DEVMISS_Enabled = 0x1
	// Enable
	RADIO_INTENSET_DEVMISS_Set = 0x1
	// Position of RSSIEND field.
	RADIO_INTENSET_RSSIEND_Pos = 0x7
	// Bit mask of RSSIEND field.
	RADIO_INTENSET_RSSIEND_Msk = 0x80
	// Bit RSSIEND.
	RADIO_INTENSET_RSSIEND = 0x80
	// Read: Disabled
	RADIO_INTENSET_RSSIEND_Disabled = 0x0
	// Read: Enabled
	RADIO_INTENSET_RSSIEND_Enabled = 0x1
	// Enable
	RADIO_INTENSET_RSSIEND_Set = 0x1
	// Position of BCMATCH field.
	RADIO_INTENSET_BCMATCH_Pos = 0xa
	// Bit mask of BCMATCH field.
	RADIO_INTENSET_BCMATCH_Msk = 0x400
	// Bit BCMATCH.
	RADIO_INTENSET_BCMATCH = 0x400
	// Read: Disabled
	RADIO_INTENSET_BCMATCH_Disabled = 0x0
	// Read: Enabled
	RADIO_INTENSET_BCMATCH_Enabled = 0x1
	// Enable
	RADIO_INTENSET_BCMATCH_Set = 0x1
	// Position of CRCOK field.
	RADIO_INTENSET_CRCOK_Pos = 0xc
	// Bit mask of CRCOK field.
	RADIO_INTENSET_CRCOK_Msk = 0x1000
	// Bit CRCOK.
	RADIO_INTENSET_CRCOK = 0x1000
	// Read: Disabled
	RADIO_INTENSET_CRCOK_Disabled = 0x0
	// Read: Enabled
	RADIO_INTENSET_CRCOK_Enabled = 0x1
	// Enable
	RADIO_INTENSET_CRCOK_Set = 0x1
	// Position of CRCERROR field.
	RADIO_INTENSET_CRCERROR_Pos = 0xd
	// Bit mask of CRCERROR field.
	RADIO_INTENSET_CRCERROR_Msk = 0x2000
	// Bit CRCERROR.
	RADIO_INTENSET_CRCERROR = 0x2000
	// Read: Disabled
	RADIO_INTENSET_CRCERROR_Disabled = 0x0
	// Read: Enabled
	RADIO_INTENSET_CRCERROR_Enabled = 0x1
	// Enable
	RADIO_INTENSET_CRCERROR_Set = 0x1
	// Position of FRAMESTART field.
	RADIO_INTENSET_FRAMESTART_Pos = 0xe
	// Bit mask of FRAMESTART field.
	RADIO_INTENSET_FRAMESTART_Msk = 0x4000
	// Bit FRAMESTART.
	RADIO_INTENSET_FRAMESTART = 0x4000
	// Read: Disabled
	RADIO_INTENSET_FRAMESTART_Disabled = 0x0
	// Read: Enabled
	RADIO_INTENSET_FRAMESTART_Enabled = 0x1
	// Enable
	RADIO_INTENSET_FRAMESTART_Set = 0x1
	// Position of EDEND field.
	RADIO_INTENSET_EDEND_Pos = 0xf
	// Bit mask of EDEND field.
	RADIO_INTENSET_EDEND_Msk = 0x8000
	// Bit EDEND.
	RADIO_INTENSET_EDEND = 0x8000
	// Read: Disabled
	RADIO_INTENSET_EDEND_Disabled = 0x0
	// Read: Enabled
	RADIO_INTENSET_EDEND_Enabled = 0x1
	// Enable
	RADIO_INTENSET_EDEND_Set = 0x1
	// Position of EDSTOPPED field.
	RADIO_INTENSET_EDSTOPPED_Pos = 0x10
	// Bit mask of EDSTOPPED field.
	RADIO_INTENSET_EDSTOPPED_Msk = 0x10000
	// Bit EDSTOPPED.
	RADIO_INTENSET_EDSTOPPED = 0x10000
	// Read: Disabled
	RADIO_INTENSET_EDSTOPPED_Disabled = 0x0
	// Read: Enabled
	RADIO_INTENSET_EDSTOPPED_Enabled = 0x1
	// Enable
	RADIO_INTENSET_EDSTOPPED_Set = 0x1
	// Position of CCAIDLE field.
	RADIO_INTENSET_CCAIDLE_Pos = 0x11
	// Bit mask of CCAIDLE field.
	RADIO_INTENSET_CCAIDLE_Msk = 0x20000
	// Bit CCAIDLE.
	RADIO_INTENSET_CCAIDLE = 0x20000
	// Read: Disabled
	RADIO_INTENSET_CCAIDLE_Disabled = 0x0
	// Read: Enabled
	RADIO_INTENSET_CCAIDLE_Enabled = 0x1
	// Enable
	RADIO_INTENSET_CCAIDLE_Set = 0x1
	// Position of CCABUSY field.
	RADIO_INTENSET_CCABUSY_Pos = 0x12
	// Bit mask of CCABUSY field.
	RADIO_INTENSET_CCABUSY_Msk = 0x40000
	// Bit CCABUSY.
	RADIO_INTENSET_CCABUSY = 0x40000
	// Read: Disabled
	RADIO_INTENSET_CCABUSY_Disabled = 0x0
	// Read: Enabled
	RADIO_INTENSET_CCABUSY_Enabled = 0x1
	// Enable
	RADIO_INTENSET_CCABUSY_Set = 0x1
	// Position of CCASTOPPED field.
	RADIO_INTENSET_CCASTOPPED_Pos = 0x13
	// Bit mask of CCASTOPPED field.
	RADIO_INTENSET_CCASTOPPED_Msk = 0x80000
	// Bit CCASTOPPED.
	RADIO_INTENSET_CCASTOPPED = 0x80000
	// Read: Disabled
	RADIO_INTENSET_CCASTOPPED_Disabled = 0x0
	// Read: Enabled
	RADIO_INTENSET_CCASTOPPED_Enabled = 0x1
	// Enable
	RADIO_INTENSET_CCASTOPPED_Set = 0x1
	// Position of RATEBOOST field.
	RADIO_INTENSET_RATEBOOST_Pos = 0x14
	// Bit mask of RATEBOOST field.
	RADIO_INTENSET_RATEBOOST_Msk = 0x100000
	// Bit RATEBOOST.
	RADIO_INTENSET_RATEBOOST = 0x100000
	// Read: Disabled
	RADIO_INTENSET_RATEBOOST_Disabled = 0x0
	// Read: Enabled
	RADIO_INTENSET_RATEBOOST_Enabled = 0x1
	// Enable
	RADIO_INTENSET_RATEBOOST_Set = 0x1
	// Position of TXREADY field.
	RADIO_INTENSET_TXREADY_Pos = 0x15
	// Bit mask of TXREADY field.
	RADIO_INTENSET_TXREADY_Msk = 0x200000
	// Bit TXREADY.
	RADIO_INTENSET_TXREADY = 0x200000
	// Read: Disabled
	RADIO_INTENSET_TXREADY_Disabled = 0x0
	// Read: Enabled
	RADIO_INTENSET_TXREADY_Enabled = 0x1
	// Enable
	RADIO_INTENSET_TXREADY_Set = 0x1
	// Position of RXREADY field.
	RADIO_INTENSET_RXREADY_Pos = 0x16
	// Bit mask of RXREADY field.
	RADIO_INTENSET_RXREADY_Msk = 0x400000
	// Bit RXREADY.
	RADIO_INTENSET_RXREADY = 0x400000
	// Read: Disabled
	RADIO_INTENSET_RXREADY_Disabled = 0x0
	// Read: Enabled
	RADIO_INTENSET_RXREADY_Enabled = 0x1
	// Enable
	RADIO_INTENSET_RXREADY_Set = 0x1
	// Position of MHRMATCH field.
	RADIO_INTENSET_MHRMATCH_Pos = 0x17
	// Bit mask of MHRMATCH field.
	RADIO_INTENSET_MHRMATCH_Msk = 0x800000
	// Bit MHRMATCH.
	RADIO_INTENSET_MHRMATCH = 0x800000
	// Read: Disabled
	RADIO_INTENSET_MHRMATCH_Disabled = 0x0
	// Read: Enabled
	RADIO_INTENSET_MHRMATCH_Enabled = 0x1
	// Enable
	RADIO_INTENSET_MHRMATCH_Set = 0x1
	// Position of SYNC field.
	RADIO_INTENSET_SYNC_Pos = 0x1a
	// Bit mask of SYNC field.
	RADIO_INTENSET_SYNC_Msk = 0x4000000
	// Bit SYNC.
	RADIO_INTENSET_SYNC = 0x4000000
	// Read: Disabled
	RADIO_INTENSET_SYNC_Disabled = 0x0
	// Read: Enabled
	RADIO_INTENSET_SYNC_Enabled = 0x1
	// Enable
	RADIO_INTENSET_SYNC_Set = 0x1
	// Position of PHYEND field.
	RADIO_INTENSET_PHYEND_Pos = 0x1b
	// Bit mask of PHYEND field.
	RADIO_INTENSET_PHYEND_Msk = 0x8000000
	// Bit PHYEND.
	RADIO_INTENSET_PHYEND = 0x8000000
	// Read: Disabled
	RADIO_INTENSET_PHYEND_Disabled = 0x0
	// Read: Enabled
	RADIO_INTENSET_PHYEND_Enabled = 0x1
	// Enable
	RADIO_INTENSET_PHYEND_Set = 0x1
	// Position of CTEPRESENT field.
	RADIO_INTENSET_CTEPRESENT_Pos = 0x1c
	// Bit mask of CTEPRESENT field.
	RADIO_INTENSET_CTEPRESENT_Msk = 0x10000000
	// Bit CTEPRESENT.
	RADIO_INTENSET_CTEPRESENT = 0x10000000
	// Read: Disabled
	RADIO_INTENSET_CTEPRESENT_Disabled = 0x0
	// Read: Enabled
	RADIO_INTENSET_CTEPRESENT_Enabled = 0x1
	// Enable
	RADIO_INTENSET_CTEPRESENT_Set = 0x1

	// INTENCLR: Disable interrupt
	// Position of READY field.
	RADIO_INTENCLR_READY_Pos = 0x0
	// Bit mask of READY field.
	RADIO_INTENCLR_READY_Msk = 0x1
	// Bit READY.
	RADIO_INTENCLR_READY = 0x1
	// Read: Disabled
	RADIO_INTENCLR_READY_Disabled = 0x0
	// Read: Enabled
	RADIO_INTENCLR_READY_Enabled = 0x1
	// Disable
	RADIO_INTENCLR_READY_Clear = 0x1
	// Position of ADDRESS field.
	RADIO_INTENCLR_ADDRESS_Pos = 0x1
	// Bit mask of ADDRESS field.
	RADIO_INTENCLR_ADDRESS_Msk = 0x2
	// Bit ADDRESS.
	RADIO_INTENCLR_ADDRESS = 0x2
	// Read: Disabled
	RADIO_INTENCLR_ADDRESS_Disabled = 0x0
	// Read: Enabled
	RADIO_INTENCLR_ADDRESS_Enabled = 0x1
	// Disable
	RADIO_INTENCLR_ADDRESS_Clear = 0x1
	// Position of PAYLOAD field.
	RADIO_INTENCLR_PAYLOAD_Pos = 0x2
	// Bit mask of PAYLOAD field.
	RADIO_INTENCLR_PAYLOAD_Msk = 0x4
	// Bit PAYLOAD.
	RADIO_INTENCLR_PAYLOAD = 0x4
	// Read: Disabled
	RADIO_INTENCLR_PAYLOAD_Disabled = 0x0
	// Read: Enabled
	RADIO_INTENCLR_PAYLOAD_Enabled = 0x1
	// Disable
	RADIO_INTENCLR_PAYLOAD_Clear = 0x1
	// Position of END field.
	RADIO_INTENCLR_END_Pos = 0x3
	// Bit mask of END field.
	RADIO_INTENCLR_END_Msk = 0x8
	// Bit END.
	RADIO_INTENCLR_END = 0x8
	// Read: Disabled
	RADIO_INTENCLR_END_Disabled = 0x0
	// Read: Enabled
	RADIO_INTENCLR_END_Enabled = 0x1
	// Disable
	RADIO_INTENCLR_END_Clear = 0x1
	// Position of DISABLED field.
	RADIO_INTENCLR_DISABLED_Pos = 0x4
	// Bit mask of DISABLED field.
	RADIO_INTENCLR_DISABLED_Msk = 0x10
	// Bit DISABLED.
	RADIO_INTENCLR_DISABLED = 0x10
	// Read: Disabled
	RADIO_INTENCLR_DISABLED_Disabled = 0x0
	// Read: Enabled
	RADIO_INTENCLR_DISABLED_Enabled = 0x1
	// Disable
	RADIO_INTENCLR_DISABLED_Clear = 0x1
	// Position of DEVMATCH field.
	RADIO_INTENCLR_DEVMATCH_Pos = 0x5
	// Bit mask of DEVMATCH field.
	RADIO_INTENCLR_DEVMATCH_Msk = 0x20
	// Bit DEVMATCH.
	RADIO_INTENCLR_DEVMATCH = 0x20
	// Read: Disabled
	RADIO_INTENCLR_DEVMATCH_Disabled = 0x0
	// Read: Enabled
	RADIO_INTENCLR_DEVMATCH_Enabled = 0x1
	// Disable
	RADIO_INTENCLR_DEVMATCH_Clear = 0x1
	// Position of DEVMISS field.
	RADIO_INTENCLR_DEVMISS_Pos = 0x6
	// Bit mask of DEVMISS field.
	RADIO_INTENCLR_DEVMISS_Msk = 0x40
	// Bit DEVMISS.
	RADIO_INTENCLR_DEVMISS = 0x40
	// Read: Disabled
	RADIO_INTENCLR_DEVMISS_Disabled = 0x0
	// Read: Enabled
	RADIO_INTENCLR_DEVMISS_Enabled = 0x1
	// Disable
	RADIO_INTENCLR_DEVMISS_Clear = 0x1
	// Position of RSSIEND field.
	RADIO_INTENCLR_RSSIEND_Pos = 0x7
	// Bit mask of RSSIEND field.
	RADIO_INTENCLR_RSSIEND_Msk = 0x80
	// Bit RSSIEND.
	RADIO_INTENCLR_RSSIEND = 0x80
	// Read: Disabled
	RADIO_INTENCLR_RSSIEND_Disabled = 0x0
	// Read: Enabled
	RADIO_INTENCLR_RSSIEND_Enabled = 0x1
	// Disable
	RADIO_INTENCLR_RSSIEND_Clear = 0x1
	// Position of BCMATCH field.
	RADIO_INTENCLR_BCMATCH_Pos = 0xa
	// Bit mask of BCMATCH field.
	RADIO_INTENCLR_BCMATCH_Msk = 0x400
	// Bit BCMATCH.
	RADIO_INTENCLR_BCMATCH = 0x400
	// Read: Disabled
	RADIO_INTENCLR_BCMATCH_Disabled = 0x0
	// Read: Enabled
	RADIO_INTENCLR_BCMATCH_Enabled = 0x1
	// Disable
	RADIO_INTENCLR_BCMATCH_Clear = 0x1
	// Position of CRCOK field.
	RADIO_INTENCLR_CRCOK_Pos = 0xc
	// Bit mask of CRCOK field.
	RADIO_INTENCLR_CRCOK_Msk = 0x1000
	// Bit CRCOK.
	RADIO_INTENCLR_CRCOK = 0x1000
	// Read: Disabled
	RADIO_INTENCLR_CRCOK_Disabled = 0x0
	// Read: Enabled
	RADIO_INTENCLR_CRCOK_Enabled = 0x1
	// Disable
	RADIO_INTENCLR_CRCOK_Clear = 0x1
	// Position of CRCERROR field.
	RADIO_INTENCLR_CRCERROR_Pos = 0xd
	// Bit mask of CRCERROR field.
	RADIO_INTENCLR_CRCERROR_Msk = 0x2000
	// Bit CRCERROR.
	RADIO_INTENCLR_CRCERROR = 0x2000
	// Read: Disabled
	RADIO_INTENCLR_CRCERROR_Disabled = 0x0
	// Read: Enabled
	RADIO_INTENCLR_CRCERROR_Enabled = 0x1
	// Disable
	RADIO_INTENCLR_CRCERROR_Clear = 0x1
	// Position of FRAMESTART field.
	RADIO_INTENCLR_FRAMESTART_Pos = 0xe
	// Bit mask of FRAMESTART field.
	RADIO_INTENCLR_FRAMESTART_Msk = 0x4000
	// Bit FRAMESTART.
	RADIO_INTENCLR_FRAMESTART = 0x4000
	// Read: Disabled
	RADIO_INTENCLR_FRAMESTART_Disabled = 0x0
	// Read: Enabled
	RADIO_INTENCLR_FRAMESTART_Enabled = 0x1
	// Disable
	RADIO_INTENCLR_FRAMESTART_Clear = 0x1
	// Position of EDEND field.
	RADIO_INTENCLR_EDEND_Pos = 0xf
	// Bit mask of EDEND field.
	RADIO_INTENCLR_EDEND_Msk = 0x8000
	// Bit EDEND.
	RADIO_INTENCLR_EDEND = 0x8000
	// Read: Disabled
	RADIO_INTENCLR_EDEND_Disabled = 0x0
	// Read: Enabled
	RADIO_INTENCLR_EDEND_Enabled = 0x1
	// Disable
	RADIO_INTENCLR_EDEND_Clear = 0x1
	// Position of EDSTOPPED field.
	RADIO_INTENCLR_EDSTOPPED_Pos = 0x10
	// Bit mask of EDSTOPPED field.
	RADIO_INTENCLR_EDSTOPPED_Msk = 0x10000
	// Bit EDSTOPPED.
	RADIO_INTENCLR_EDSTOPPED = 0x10000
	// Read: Disabled
	RADIO_INTENCLR_EDSTOPPED_Disabled = 0x0
	// Read: Enabled
	RADIO_INTENCLR_EDSTOPPED_Enabled = 0x1
	// Disable
	RADIO_INTENCLR_EDSTOPPED_Clear = 0x1
	// Position of CCAIDLE field.
	RADIO_INTENCLR_CCAIDLE_Pos = 0x11
	// Bit mask of CCAIDLE field.
	RADIO_INTENCLR_CCAIDLE_Msk = 0x20000
	// Bit CCAIDLE.
	RADIO_INTENCLR_CCAIDLE = 0x20000
	// Read: Disabled
	RADIO_INTENCLR_CCAIDLE_Disabled = 0x0
	// Read: Enabled
	RADIO_INTENCLR_CCAIDLE_Enabled = 0x1
	// Disable
	RADIO_INTENCLR_CCAIDLE_Clear = 0x1
	// Position of CCABUSY field.
	RADIO_INTENCLR_CCABUSY_Pos = 0x12
	// Bit mask of CCABUSY field.
	RADIO_INTENCLR_CCABUSY_Msk = 0x40000
	// Bit CCABUSY.
	RADIO_INTENCLR_CCABUSY = 0x40000
	// Read: Disabled
	RADIO_INTENCLR_CCABUSY_Disabled = 0x0
	// Read: Enabled
	RADIO_INTENCLR_CCABUSY_Enabled = 0x1
	// Disable
	RADIO_INTENCLR_CCABUSY_Clear = 0x1
	// Position of CCASTOPPED field.
	RADIO_INTENCLR_CCASTOPPED_Pos = 0x13
	// Bit mask of CCASTOPPED field.
	RADIO_INTENCLR_CCASTOPPED_Msk = 0x80000
	// Bit CCASTOPPED.
	RADIO_INTENCLR_CCASTOPPED = 0x80000
	// Read: Disabled
	RADIO_INTENCLR_CCASTOPPED_Disabled = 0x0
	// Read: Enabled
	RADIO_INTENCLR_CCASTOPPED_Enabled = 0x1
	// Disable
	RADIO_INTENCLR_CCASTOPPED_Clear = 0x1
	// Position of RATEBOOST field.
	RADIO_INTENCLR_RATEBOOST_Pos = 0x14
	// Bit mask of RATEBOOST field.
	RADIO_INTENCLR_RATEBOOST_Msk = 0x100000
	// Bit RATEBOOST.
	RADIO_INTENCLR_RATEBOOST = 0x100000
	// Read: Disabled
	RADIO_INTENCLR_RATEBOOST_Disabled = 0x0
	// Read: Enabled
	RADIO_INTENCLR_RATEBOOST_Enabled = 0x1
	// Disable
	RADIO_INTENCLR_RATEBOOST_Clear = 0x1
	// Position of TXREADY field.
	RADIO_INTENCLR_TXREADY_Pos = 0x15
	// Bit mask of TXREADY field.
	RADIO_INTENCLR_TXREADY_Msk = 0x200000
	// Bit TXREADY.
	RADIO_INTENCLR_TXREADY = 0x200000
	// Read: Disabled
	RADIO_INTENCLR_TXREADY_Disabled = 0x0
	// Read: Enabled
	RADIO_INTENCLR_TXREADY_Enabled = 0x1
	// Disable
	RADIO_INTENCLR_TXREADY_Clear = 0x1
	// Position of RXREADY field.
	RADIO_INTENCLR_RXREADY_Pos = 0x16
	// Bit mask of RXREADY field.
	RADIO_INTENCLR_RXREADY_Msk = 0x400000
	// Bit RXREADY.
	RADIO_INTENCLR_RXREADY = 0x400000
	// Read: Disabled
	RADIO_INTENCLR_RXREADY_Disabled = 0x0
	// Read: Enabled
	RADIO_INTENCLR_RXREADY_Enabled = 0x1
	// Disable
	RADIO_INTENCLR_RXREADY_Clear = 0x1
	// Position of MHRMATCH field.
	RADIO_INTENCLR_MHRMATCH_Pos = 0x17
	// Bit mask of MHRMATCH field.
	RADIO_INTENCLR_MHRMATCH_Msk = 0x800000
	// Bit MHRMATCH.
	RADIO_INTENCLR_MHRMATCH = 0x800000
	// Read: Disabled
	RADIO_INTENCLR_MHRMATCH_Disabled = 0x0
	// Read: Enabled
	RADIO_INTENCLR_MHRMATCH_Enabled = 0x1
	// Disable
	RADIO_INTENCLR_MHRMATCH_Clear = 0x1
	// Position of SYNC field.
	RADIO_INTENCLR_SYNC_Pos = 0x1a
	// Bit mask of SYNC field.
	RADIO_INTENCLR_SYNC_Msk = 0x4000000
	// Bit SYNC.
	RADIO_INTENCLR_SYNC = 0x4000000
	// Read: Disabled
	RADIO_INTENCLR_SYNC_Disabled = 0x0
	// Read: Enabled
	RADIO_INTENCLR_SYNC_Enabled = 0x1
	// Disable
	RADIO_INTENCLR_SYNC_Clear = 0x1
	// Position of PHYEND field.
	RADIO_INTENCLR_PHYEND_Pos = 0x1b
	// Bit mask of PHYEND field.
	RADIO_INTENCLR_PHYEND_Msk = 0x8000000
	// Bit PHYEND.
	RADIO_INTENCLR_PHYEND = 0x8000000
	// Read: Disabled
	RADIO_INTENCLR_PHYEND_Disabled = 0x0
	// Read: Enabled
	RADIO_INTENCLR_PHYEND_Enabled = 0x1
	// Disable
	RADIO_INTENCLR_PHYEND_Clear = 0x1
	// Position of CTEPRESENT field.
	RADIO_INTENCLR_CTEPRESENT_Pos = 0x1c
	// Bit mask of CTEPRESENT field.
	RADIO_INTENCLR_CTEPRESENT_Msk = 0x10000000
	// Bit CTEPRESENT.
	RADIO_INTENCLR_CTEPRESENT = 0x10000000
	// Read: Disabled
	RADIO_INTENCLR_CTEPRESENT_Disabled = 0x0
	// Read: Enabled
	RADIO_INTENCLR_CTEPRESENT_Enabled = 0x1
	// Disable
	RADIO_INTENCLR_CTEPRESENT_Clear = 0x1

	// CRCSTATUS: CRC status
	// Position of CRCSTATUS field.
	RADIO_CRCSTATUS_CRCSTATUS_Pos = 0x0
	// Bit mask of CRCSTATUS field.
	RADIO_CRCSTATUS_CRCSTATUS_Msk = 0x1
	// Bit CRCSTATUS.
	RADIO_CRCSTATUS_CRCSTATUS = 0x1
	// Packet received with CRC error
	RADIO_CRCSTATUS_CRCSTATUS_CRCError = 0x0
	// Packet received with CRC ok
	RADIO_CRCSTATUS_CRCSTATUS_CRCOk = 0x1

	// RXMATCH: Received address
	// Position of RXMATCH field.
	RADIO_RXMATCH_RXMATCH_Pos = 0x0
	// Bit mask of RXMATCH field.
	RADIO_RXMATCH_RXMATCH_Msk = 0x7

	// RXCRC: CRC field of previously received packet
	// Position of RXCRC field.
	RADIO_RXCRC_RXCRC_Pos = 0x0
	// Bit mask of RXCRC field.
	RADIO_RXCRC_RXCRC_Msk = 0xffffff

	// DAI: Device address match index
	// Position of DAI field.
	RADIO_DAI_DAI_Pos = 0x0
	// Bit mask of DAI field.
	RADIO_DAI_DAI_Msk = 0x7

	// PDUSTAT: Payload status
	// Position of PDUSTAT field.
	RADIO_PDUSTAT_PDUSTAT_Pos = 0x0
	// Bit mask of PDUSTAT field.
	RADIO_PDUSTAT_PDUSTAT_Msk = 0x1
	// Bit PDUSTAT.
	RADIO_PDUSTAT_PDUSTAT = 0x1
	// Payload less than PCNF1.MAXLEN
	RADIO_PDUSTAT_PDUSTAT_LessThan = 0x0
	// Payload greater than PCNF1.MAXLEN
	RADIO_PDUSTAT_PDUSTAT_GreaterThan = 0x1
	// Position of CISTAT field.
	RADIO_PDUSTAT_CISTAT_Pos = 0x1
	// Bit mask of CISTAT field.
	RADIO_PDUSTAT_CISTAT_Msk = 0x6
	// Frame is received at 125 kbps
	RADIO_PDUSTAT_CISTAT_LR125kbit = 0x0
	// Frame is received at 500 kbps
	RADIO_PDUSTAT_CISTAT_LR500kbit = 0x1

	// CTESTATUS: CTEInfo parsed from received packet
	// Position of CTETIME field.
	RADIO_CTESTATUS_CTETIME_Pos = 0x0
	// Bit mask of CTETIME field.
	RADIO_CTESTATUS_CTETIME_Msk = 0x1f
	// Position of RFU field.
	RADIO_CTESTATUS_RFU_Pos = 0x5
	// Bit mask of RFU field.
	RADIO_CTESTATUS_RFU_Msk = 0x20
	// Bit RFU.
	RADIO_CTESTATUS_RFU = 0x20
	// Position of CTETYPE field.
	RADIO_CTESTATUS_CTETYPE_Pos = 0x6
	// Bit mask of CTETYPE field.
	RADIO_CTESTATUS_CTETYPE_Msk = 0xc0

	// DFESTATUS: DFE status information
	// Position of SWITCHINGSTATE field.
	RADIO_DFESTATUS_SWITCHINGSTATE_Pos = 0x0
	// Bit mask of SWITCHINGSTATE field.
	RADIO_DFESTATUS_SWITCHINGSTATE_Msk = 0x7
	// Switching state Idle
	RADIO_DFESTATUS_SWITCHINGSTATE_Idle = 0x0
	// Switching state Offset
	RADIO_DFESTATUS_SWITCHINGSTATE_Offset = 0x1
	// Switching state Guard
	RADIO_DFESTATUS_SWITCHINGSTATE_Guard = 0x2
	// Switching state Ref
	RADIO_DFESTATUS_SWITCHINGSTATE_Ref = 0x3
	// Switching state Switching
	RADIO_DFESTATUS_SWITCHINGSTATE_Switching = 0x4
	// Switching state Ending
	RADIO_DFESTATUS_SWITCHINGSTATE_Ending = 0x5
	// Position of SAMPLINGSTATE field.
	RADIO_DFESTATUS_SAMPLINGSTATE_Pos = 0x4
	// Bit mask of SAMPLINGSTATE field.
	RADIO_DFESTATUS_SAMPLINGSTATE_Msk = 0x10
	// Bit SAMPLINGSTATE.
	RADIO_DFESTATUS_SAMPLINGSTATE = 0x10
	// Sampling state Idle
	RADIO_DFESTATUS_SAMPLINGSTATE_Idle = 0x0
	// Sampling state Sampling
	RADIO_DFESTATUS_SAMPLINGSTATE_Sampling = 0x1

	// PACKETPTR: Packet pointer
	// Position of PACKETPTR field.
	RADIO_PACKETPTR_PACKETPTR_Pos = 0x0
	// Bit mask of PACKETPTR field.
	RADIO_PACKETPTR_PACKETPTR_Msk = 0xffffffff

	// FREQUENCY: Frequency
	// Position of FREQUENCY field.
	RADIO_FREQUENCY_FREQUENCY_Pos = 0x0
	// Bit mask of FREQUENCY field.
	RADIO_FREQUENCY_FREQUENCY_Msk = 0x7f
	// Position of MAP field.
	RADIO_FREQUENCY_MAP_Pos = 0x8
	// Bit mask of MAP field.
	RADIO_FREQUENCY_MAP_Msk = 0x100
	// Bit MAP.
	RADIO_FREQUENCY_MAP = 0x100
	// Channel map between 2400 MHZ .. 2500 MHz
	RADIO_FREQUENCY_MAP_Default = 0x0
	// Channel map between 2360 MHZ .. 2460 MHz
	RADIO_FREQUENCY_MAP_Low = 0x1

	// TXPOWER: Output power
	// Position of TXPOWER field.
	RADIO_TXPOWER_TXPOWER_Pos = 0x0
	// Bit mask of TXPOWER field.
	RADIO_TXPOWER_TXPOWER_Msk = 0xff
	// 0 dBm
	RADIO_TXPOWER_TXPOWER_0dBm = 0x0
	// -1 dBm
	RADIO_TXPOWER_TXPOWER_Neg1dBm = 0xff
	// -2 dBm
	RADIO_TXPOWER_TXPOWER_Neg2dBm = 0xfe
	// -3 dBm
	RADIO_TXPOWER_TXPOWER_Neg3dBm = 0xfd
	// -4 dBm
	RADIO_TXPOWER_TXPOWER_Neg4dBm = 0xfc
	// -5 dBm
	RADIO_TXPOWER_TXPOWER_Neg5dBm = 0xfb
	// -6 dBm
	RADIO_TXPOWER_TXPOWER_Neg6dBm = 0xfa
	// -7 dBm
	RADIO_TXPOWER_TXPOWER_Neg7dBm = 0xf9
	// -8 dBm
	RADIO_TXPOWER_TXPOWER_Neg8dBm = 0xf8
	// -12 dBm
	RADIO_TXPOWER_TXPOWER_Neg12dBm = 0xf4
	// -16 dBm
	RADIO_TXPOWER_TXPOWER_Neg16dBm = 0xf0
	// -20 dBm
	RADIO_TXPOWER_TXPOWER_Neg20dBm = 0xec
	// Deprecated enumerator - -40 dBm
	RADIO_TXPOWER_TXPOWER_Neg30dBm = 0xe2
	// -40 dBm
	RADIO_TXPOWER_TXPOWER_Neg40dBm = 0xd8

	// MODE: Data rate and modulation
	// Position of MODE field.
	RADIO_MODE_MODE_Pos = 0x0
	// Bit mask of MODE field.
	RADIO_MODE_MODE_Msk = 0xf
	// 1 Mbps Nordic proprietary radio mode
	RADIO_MODE_MODE_Nrf_1Mbit = 0x0
	// 2 Mbps Nordic proprietary radio mode
	RADIO_MODE_MODE_Nrf_2Mbit = 0x1
	// 1 Mbps BLE
	RADIO_MODE_MODE_Ble_1Mbit = 0x3
	// 2 Mbps BLE
	RADIO_MODE_MODE_Ble_2Mbit = 0x4
	// Long range 125 kbps TX, 125 kbps and 500 kbps RX
	RADIO_MODE_MODE_Ble_LR125Kbit = 0x5
	// Long range 500 kbps TX, 125 kbps and 500 kbps RX
	RADIO_MODE_MODE_Ble_LR500Kbit = 0x6
	// IEEE 802.15.4-2006 250 kbps
	RADIO_MODE_MODE_Ieee802154_250Kbit = 0xf

	// PCNF0: Packet configuration register 0
	// Position of LFLEN field.
	RADIO_PCNF0_LFLEN_Pos = 0x0
	// Bit mask of LFLEN field.
	RADIO_PCNF0_LFLEN_Msk = 0xf
	// Position of S0LEN field.
	RADIO_PCNF0_S0LEN_Pos = 0x8
	// Bit mask of S0LEN field.
	RADIO_PCNF0_S0LEN_Msk = 0x100
	// Bit S0LEN.
	RADIO_PCNF0_S0LEN = 0x100
	// Position of S1LEN field.
	RADIO_PCNF0_S1LEN_Pos = 0x10
	// Bit mask of S1LEN field.
	RADIO_PCNF0_S1LEN_Msk = 0xf0000
	// Position of S1INCL field.
	RADIO_PCNF0_S1INCL_Pos = 0x14
	// Bit mask of S1INCL field.
	RADIO_PCNF0_S1INCL_Msk = 0x100000
	// Bit S1INCL.
	RADIO_PCNF0_S1INCL = 0x100000
	// Include S1 field in RAM only if S1LEN &gt; 0
	RADIO_PCNF0_S1INCL_Automatic = 0x0
	// Always include S1 field in RAM independent of S1LEN
	RADIO_PCNF0_S1INCL_Include = 0x1
	// Position of CILEN field.
	RADIO_PCNF0_CILEN_Pos = 0x16
	// Bit mask of CILEN field.
	RADIO_PCNF0_CILEN_Msk = 0xc00000
	// Position of PLEN field.
	RADIO_PCNF0_PLEN_Pos = 0x18
	// Bit mask of PLEN field.
	RADIO_PCNF0_PLEN_Msk = 0x3000000
	// 8-bit preamble
	RADIO_PCNF0_PLEN_8bit = 0x0
	// 16-bit preamble
	RADIO_PCNF0_PLEN_16bit = 0x1
	// 32-bit zero preamble - used for IEEE 802.15.4
	RADIO_PCNF0_PLEN_32bitZero = 0x2
	// Preamble - used for BLE long range
	RADIO_PCNF0_PLEN_LongRange = 0x3
	// Position of CRCINC field.
	RADIO_PCNF0_CRCINC_Pos = 0x1a
	// Bit mask of CRCINC field.
	RADIO_PCNF0_CRCINC_Msk = 0x4000000
	// Bit CRCINC.
	RADIO_PCNF0_CRCINC = 0x4000000
	// LENGTH does not contain CRC
	RADIO_PCNF0_CRCINC_Exclude = 0x0
	// LENGTH includes CRC
	RADIO_PCNF0_CRCINC_Include = 0x1
	// Position of TERMLEN field.
	RADIO_PCNF0_TERMLEN_Pos = 0x1d
	// Bit mask of TERMLEN field.
	RADIO_PCNF0_TERMLEN_Msk = 0x60000000

	// PCNF1: Packet configuration register 1
	// Position of MAXLEN field.
	RADIO_PCNF1_MAXLEN_Pos = 0x0
	// Bit mask of MAXLEN field.
	RADIO_PCNF1_MAXLEN_Msk = 0xff
	// Position of STATLEN field.
	RADIO_PCNF1_STATLEN_Pos = 0x8
	// Bit mask of STATLEN field.
	RADIO_PCNF1_STATLEN_Msk = 0xff00
	// Position of BALEN field.
	RADIO_PCNF1_BALEN_Pos = 0x10
	// Bit mask of BALEN field.
	RADIO_PCNF1_BALEN_Msk = 0x70000
	// Position of ENDIAN field.
	RADIO_PCNF1_ENDIAN_Pos = 0x18
	// Bit mask of ENDIAN field.
	RADIO_PCNF1_ENDIAN_Msk = 0x1000000
	// Bit ENDIAN.
	RADIO_PCNF1_ENDIAN = 0x1000000
	// Least significant bit on air first
	RADIO_PCNF1_ENDIAN_Little = 0x0
	// Most significant bit on air first
	RADIO_PCNF1_ENDIAN_Big = 0x1
	// Position of WHITEEN field.
	RADIO_PCNF1_WHITEEN_Pos = 0x19
	// Bit mask of WHITEEN field.
	RADIO_PCNF1_WHITEEN_Msk = 0x2000000
	// Bit WHITEEN.
	RADIO_PCNF1_WHITEEN = 0x2000000
	// Disable
	RADIO_PCNF1_WHITEEN_Disabled = 0x0
	// Enable
	RADIO_PCNF1_WHITEEN_Enabled = 0x1

	// BASE0: Base address 0
	// Position of BASE0 field.
	RADIO_BASE0_BASE0_Pos = 0x0
	// Bit mask of BASE0 field.
	RADIO_BASE0_BASE0_Msk = 0xffffffff

	// BASE1: Base address 1
	// Position of BASE1 field.
	RADIO_BASE1_BASE1_Pos = 0x0
	// Bit mask of BASE1 field.
	RADIO_BASE1_BASE1_Msk = 0xffffffff

	// PREFIX0: Prefixes bytes for logical addresses 0-3
	// Position of AP0 field.
	RADIO_PREFIX0_AP0_Pos = 0x0
	// Bit mask of AP0 field.
	RADIO_PREFIX0_AP0_Msk = 0xff
	// Position of AP1 field.
	RADIO_PREFIX0_AP1_Pos = 0x8
	// Bit mask of AP1 field.
	RADIO_PREFIX0_AP1_Msk = 0xff00
	// Position of AP2 field.
	RADIO_PREFIX0_AP2_Pos = 0x10
	// Bit mask of AP2 field.
	RADIO_PREFIX0_AP2_Msk = 0xff0000
	// Position of AP3 field.
	RADIO_PREFIX0_AP3_Pos = 0x18
	// Bit mask of AP3 field.
	RADIO_PREFIX0_AP3_Msk = 0xff000000

	// PREFIX1: Prefixes bytes for logical addresses 4-7
	// Position of AP4 field.
	RADIO_PREFIX1_AP4_Pos = 0x0
	// Bit mask of AP4 field.
	RADIO_PREFIX1_AP4_Msk = 0xff
	// Position of AP5 field.
	RADIO_PREFIX1_AP5_Pos = 0x8
	// Bit mask of AP5 field.
	RADIO_PREFIX1_AP5_Msk = 0xff00
	// Position of AP6 field.
	RADIO_PREFIX1_AP6_Pos = 0x10
	// Bit mask of AP6 field.
	RADIO_PREFIX1_AP6_Msk = 0xff0000
	// Position of AP7 field.
	RADIO_PREFIX1_AP7_Pos = 0x18
	// Bit mask of AP7 field.
	RADIO_PREFIX1_AP7_Msk = 0xff000000

	// TXADDRESS: Transmit address select
	// Position of TXADDRESS field.
	RADIO_TXADDRESS_TXADDRESS_Pos = 0x0
	// Bit mask of TXADDRESS field.
	RADIO_TXADDRESS_TXADDRESS_Msk = 0x7

	// RXADDRESSES: Receive address select
	// Position of ADDR0 field.
	RADIO_RXADDRESSES_ADDR0_Pos = 0x0
	// Bit mask of ADDR0 field.
	RADIO_RXADDRESSES_ADDR0_Msk = 0x1
	// Bit ADDR0.
	RADIO_RXADDRESSES_ADDR0 = 0x1
	// Disable
	RADIO_RXADDRESSES_ADDR0_Disabled = 0x0
	// Enable
	RADIO_RXADDRESSES_ADDR0_Enabled = 0x1
	// Position of ADDR1 field.
	RADIO_RXADDRESSES_ADDR1_Pos = 0x1
	// Bit mask of ADDR1 field.
	RADIO_RXADDRESSES_ADDR1_Msk = 0x2
	// Bit ADDR1.
	RADIO_RXADDRESSES_ADDR1 = 0x2
	// Disable
	RADIO_RXADDRESSES_ADDR1_Disabled = 0x0
	// Enable
	RADIO_RXADDRESSES_ADDR1_Enabled = 0x1
	// Position of ADDR2 field.
	RADIO_RXADDRESSES_ADDR2_Pos = 0x2
	// Bit mask of ADDR2 field.
	RADIO_RXADDRESSES_ADDR2_Msk = 0x4
	// Bit ADDR2.
	RADIO_RXADDRESSES_ADDR2 = 0x4
	// Disable
	RADIO_RXADDRESSES_ADDR2_Disabled = 0x0
	// Enable
	RADIO_RXADDRESSES_ADDR2_Enabled = 0x1
	// Position of ADDR3 field.
	RADIO_RXADDRESSES_ADDR3_Pos = 0x3
	// Bit mask of ADDR3 field.
	RADIO_RXADDRESSES_ADDR3_Msk = 0x8
	// Bit ADDR3.
	RADIO_RXADDRESSES_ADDR3 = 0x8
	// Disable
	RADIO_RXADDRESSES_ADDR3_Disabled = 0x0
	// Enable
	RADIO_RXADDRESSES_ADDR3_Enabled = 0x1
	// Position of ADDR4 field.
	RADIO_RXADDRESSES_ADDR4_Pos = 0x4
	// Bit mask of ADDR4 field.
	RADIO_RXADDRESSES_ADDR4_Msk = 0x10
	// Bit ADDR4.
	RADIO_RXADDRESSES_ADDR4 = 0x10
	// Disable
	RADIO_RXADDRESSES_ADDR4_Disabled = 0x0
	// Enable
	RADIO_RXADDRESSES_ADDR4_Enabled = 0x1
	// Position of ADDR5 field.
	RADIO_RXADDRESSES_ADDR5_Pos = 0x5
	// Bit mask of ADDR5 field.
	RADIO_RXADDRESSES_ADDR5_Msk = 0x20
	// Bit ADDR5.
	RADIO_RXADDRESSES_ADDR5 = 0x20
	// Disable
	RADIO_RXADDRESSES_ADDR5_Disabled = 0x0
	// Enable
	RADIO_RXADDRESSES_ADDR5_Enabled = 0x1
	// Position of ADDR6 field.
	RADIO_RXADDRESSES_ADDR6_Pos = 0x6
	// Bit mask of ADDR6 field.
	RADIO_RXADDRESSES_ADDR6_Msk = 0x40
	// Bit ADDR6.
	RADIO_RXADDRESSES_ADDR6 = 0x40
	// Disable
	RADIO_RXADDRESSES_ADDR6_Disabled = 0x0
	// Enable
	RADIO_RXADDRESSES_ADDR6_Enabled = 0x1
	// Position of ADDR7 field.
	RADIO_RXADDRESSES_ADDR7_Pos = 0x7
	// Bit mask of ADDR7 field.
	RADIO_RXADDRESSES_ADDR7_Msk = 0x80
	// Bit ADDR7.
	RADIO_RXADDRESSES_ADDR7 = 0x80
	// Disable
	RADIO_RXADDRESSES_ADDR7_Disabled = 0x0
	// Enable
	RADIO_RXADDRESSES_ADDR7_Enabled = 0x1

	// CRCCNF: CRC configuration
	// Position of LEN field.
	RADIO_CRCCNF_LEN_Pos = 0x0
	// Bit mask of LEN field.
	RADIO_CRCCNF_LEN_Msk = 0x3
	// CRC length is zero and CRC calculation is disabled
	RADIO_CRCCNF_LEN_Disabled = 0x0
	// CRC length is one byte and CRC calculation is enabled
	RADIO_CRCCNF_LEN_One = 0x1
	// CRC length is two bytes and CRC calculation is enabled
	RADIO_CRCCNF_LEN_Two = 0x2
	// CRC length is three bytes and CRC calculation is enabled
	RADIO_CRCCNF_LEN_Three = 0x3
	// Position of SKIPADDR field.
	RADIO_CRCCNF_SKIPADDR_Pos = 0x8
	// Bit mask of SKIPADDR field.
	RADIO_CRCCNF_SKIPADDR_Msk = 0x300
	// CRC calculation includes address field
	RADIO_CRCCNF_SKIPADDR_Include = 0x0
	// CRC calculation does not include address field. The CRC calculation will start at the first byte after the address.
	RADIO_CRCCNF_SKIPADDR_Skip = 0x1
	// CRC calculation as per 802.15.4 standard. Starting at first byte after length field.
	RADIO_CRCCNF_SKIPADDR_Ieee802154 = 0x2

	// CRCPOLY: CRC polynomial
	// Position of CRCPOLY field.
	RADIO_CRCPOLY_CRCPOLY_Pos = 0x0
	// Bit mask of CRCPOLY field.
	RADIO_CRCPOLY_CRCPOLY_Msk = 0xffffff

	// CRCINIT: CRC initial value
	// Position of CRCINIT field.
	RADIO_CRCINIT_CRCINIT_Pos = 0x0
	// Bit mask of CRCINIT field.
	RADIO_CRCINIT_CRCINIT_Msk = 0xffffff

	// TIFS: Interframe spacing in us
	// Position of TIFS field.
	RADIO_TIFS_TIFS_Pos = 0x0
	// Bit mask of TIFS field.
	RADIO_TIFS_TIFS_Msk = 0x3ff

	// RSSISAMPLE: RSSI sample
	// Position of RSSISAMPLE field.
	RADIO_RSSISAMPLE_RSSISAMPLE_Pos = 0x0
	// Bit mask of RSSISAMPLE field.
	RADIO_RSSISAMPLE_RSSISAMPLE_Msk = 0x7f

	// STATE: Current radio state
	// Position of STATE field.
	RADIO_STATE_STATE_Pos = 0x0
	// Bit mask of STATE field.
	RADIO_STATE_STATE_Msk = 0xf
	// RADIO is in the Disabled state
	RADIO_STATE_STATE_Disabled = 0x0
	// RADIO is in the RXRU state
	RADIO_STATE_STATE_RxRu = 0x1
	// RADIO is in the RXIDLE state
	RADIO_STATE_STATE_RxIdle = 0x2
	// RADIO is in the RX state
	RADIO_STATE_STATE_Rx = 0x3
	// RADIO is in the RXDISABLED state
	RADIO_STATE_STATE_RxDisable = 0x4
	// RADIO is in the TXRU state
	RADIO_STATE_STATE_TxRu = 0x9
	// RADIO is in the TXIDLE state
	RADIO_STATE_STATE_TxIdle = 0xa
	// RADIO is in the TX state
	RADIO_STATE_STATE_Tx = 0xb
	// RADIO is in the TXDISABLED state
	RADIO_STATE_STATE_TxDisable = 0xc

	// DATAWHITEIV: Data whitening initial value
	// Position of DATAWHITEIV field.
	RADIO_DATAWHITEIV_DATAWHITEIV_Pos = 0x0
	// Bit mask of DATAWHITEIV field.
	RADIO_DATAWHITEIV_DATAWHITEIV_Msk = 0x7f

	// BCC: Bit counter compare
	// Position of BCC field.
	RADIO_BCC_BCC_Pos = 0x0
	// Bit mask of BCC field.
	RADIO_BCC_BCC_Msk = 0xffffffff

	// DAB: Description collection: Device address base segment n
	// Position of DAB field.
	RADIO_DAB_DAB_Pos = 0x0
	// Bit mask of DAB field.
	RADIO_DAB_DAB_Msk = 0xffffffff

	// DAP: Description collection: Device address prefix n
	// Position of DAP field.
	RADIO_DAP_DAP_Pos = 0x0
	// Bit mask of DAP field.
	RADIO_DAP_DAP_Msk = 0xffff

	// DACNF: Device address match configuration
	// Position of ENA0 field.
	RADIO_DACNF_ENA0_Pos = 0x0
	// Bit mask of ENA0 field.
	RADIO_DACNF_ENA0_Msk = 0x1
	// Bit ENA0.
	RADIO_DACNF_ENA0 = 0x1
	// Disabled
	RADIO_DACNF_ENA0_Disabled = 0x0
	// Enabled
	RADIO_DACNF_ENA0_Enabled = 0x1
	// Position of ENA1 field.
	RADIO_DACNF_ENA1_Pos = 0x1
	// Bit mask of ENA1 field.
	RADIO_DACNF_ENA1_Msk = 0x2
	// Bit ENA1.
	RADIO_DACNF_ENA1 = 0x2
	// Disabled
	RADIO_DACNF_ENA1_Disabled = 0x0
	// Enabled
	RADIO_DACNF_ENA1_Enabled = 0x1
	// Position of ENA2 field.
	RADIO_DACNF_ENA2_Pos = 0x2
	// Bit mask of ENA2 field.
	RADIO_DACNF_ENA2_Msk = 0x4
	// Bit ENA2.
	RADIO_DACNF_ENA2 = 0x4
	// Disabled
	RADIO_DACNF_ENA2_Disabled = 0x0
	// Enabled
	RADIO_DACNF_ENA2_Enabled = 0x1
	// Position of ENA3 field.
	RADIO_DACNF_ENA3_Pos = 0x3
	// Bit mask of ENA3 field.
	RADIO_DACNF_ENA3_Msk = 0x8
	// Bit ENA3.
	RADIO_DACNF_ENA3 = 0x8
	// Disabled
	RADIO_DACNF_ENA3_Disabled = 0x0
	// Enabled
	RADIO_DACNF_ENA3_Enabled = 0x1
	// Position of ENA4 field.
	RADIO_DACNF_ENA4_Pos = 0x4
	// Bit mask of ENA4 field.
	RADIO_DACNF_ENA4_Msk = 0x10
	// Bit ENA4.
	RADIO_DACNF_ENA4 = 0x10
	// Disabled
	RADIO_DACNF_ENA4_Disabled = 0x0
	// Enabled
	RADIO_DACNF_ENA4_Enabled = 0x1
	// Position of ENA5 field.
	RADIO_DACNF_ENA5_Pos = 0x5
	// Bit mask of ENA5 field.
	RADIO_DACNF_ENA5_Msk = 0x20
	// Bit ENA5.
	RADIO_DACNF_ENA5 = 0x20
	// Disabled
	RADIO_DACNF_ENA5_Disabled = 0x0
	// Enabled
	RADIO_DACNF_ENA5_Enabled = 0x1
	// Position of ENA6 field.
	RADIO_DACNF_ENA6_Pos = 0x6
	// Bit mask of ENA6 field.
	RADIO_DACNF_ENA6_Msk = 0x40
	// Bit ENA6.
	RADIO_DACNF_ENA6 = 0x40
	// Disabled
	RADIO_DACNF_ENA6_Disabled = 0x0
	// Enabled
	RADIO_DACNF_ENA6_Enabled = 0x1
	// Position of ENA7 field.
	RADIO_DACNF_ENA7_Pos = 0x7
	// Bit mask of ENA7 field.
	RADIO_DACNF_ENA7_Msk = 0x80
	// Bit ENA7.
	RADIO_DACNF_ENA7 = 0x80
	// Disabled
	RADIO_DACNF_ENA7_Disabled = 0x0
	// Enabled
	RADIO_DACNF_ENA7_Enabled = 0x1
	// Position of TXADD0 field.
	RADIO_DACNF_TXADD0_Pos = 0x8
	// Bit mask of TXADD0 field.
	RADIO_DACNF_TXADD0_Msk = 0x100
	// Bit TXADD0.
	RADIO_DACNF_TXADD0 = 0x100
	// Position of TXADD1 field.
	RADIO_DACNF_TXADD1_Pos = 0x9
	// Bit mask of TXADD1 field.
	RADIO_DACNF_TXADD1_Msk = 0x200
	// Bit TXADD1.
	RADIO_DACNF_TXADD1 = 0x200
	// Position of TXADD2 field.
	RADIO_DACNF_TXADD2_Pos = 0xa
	// Bit mask of TXADD2 field.
	RADIO_DACNF_TXADD2_Msk = 0x400
	// Bit TXADD2.
	RADIO_DACNF_TXADD2 = 0x400
	// Position of TXADD3 field.
	RADIO_DACNF_TXADD3_Pos = 0xb
	// Bit mask of TXADD3 field.
	RADIO_DACNF_TXADD3_Msk = 0x800
	// Bit TXADD3.
	RADIO_DACNF_TXADD3 = 0x800
	// Position of TXADD4 field.
	RADIO_DACNF_TXADD4_Pos = 0xc
	// Bit mask of TXADD4 field.
	RADIO_DACNF_TXADD4_Msk = 0x1000
	// Bit TXADD4.
	RADIO_DACNF_TXADD4 = 0x1000
	// Position of TXADD5 field.
	RADIO_DACNF_TXADD5_Pos = 0xd
	// Bit mask of TXADD5 field.
	RADIO_DACNF_TXADD5_Msk = 0x2000
	// Bit TXADD5.
	RADIO_DACNF_TXADD5 = 0x2000
	// Position of TXADD6 field.
	RADIO_DACNF_TXADD6_Pos = 0xe
	// Bit mask of TXADD6 field.
	RADIO_DACNF_TXADD6_Msk = 0x4000
	// Bit TXADD6.
	RADIO_DACNF_TXADD6 = 0x4000
	// Position of TXADD7 field.
	RADIO_DACNF_TXADD7_Pos = 0xf
	// Bit mask of TXADD7 field.
	RADIO_DACNF_TXADD7_Msk = 0x8000
	// Bit TXADD7.
	RADIO_DACNF_TXADD7 = 0x8000

	// MHRMATCHCONF: Search pattern configuration
	// Position of MHRMATCHCONF field.
	RADIO_MHRMATCHCONF_MHRMATCHCONF_Pos = 0x0
	// Bit mask of MHRMATCHCONF field.
	RADIO_MHRMATCHCONF_MHRMATCHCONF_Msk = 0xffffffff

	// MHRMATCHMAS: Pattern mask
	// Position of MHRMATCHMAS field.
	RADIO_MHRMATCHMAS_MHRMATCHMAS_Pos = 0x0
	// Bit mask of MHRMATCHMAS field.
	RADIO_MHRMATCHMAS_MHRMATCHMAS_Msk = 0xffffffff

	// MODECNF0: Radio mode configuration register 0
	// Position of RU field.
	RADIO_MODECNF0_RU_Pos = 0x0
	// Bit mask of RU field.
	RADIO_MODECNF0_RU_Msk = 0x1
	// Bit RU.
	RADIO_MODECNF0_RU = 0x1
	// Default ramp-up time (tRXEN and tTXEN), compatible with firmware written for nRF51
	RADIO_MODECNF0_RU_Default = 0x0
	// Fast ramp-up (tRXEN,FAST and tTXEN,FAST), see electrical specification for more information
	RADIO_MODECNF0_RU_Fast = 0x1
	// Position of DTX field.
	RADIO_MODECNF0_DTX_Pos = 0x8
	// Bit mask of DTX field.
	RADIO_MODECNF0_DTX_Msk = 0x300
	// Transmit '1'
	RADIO_MODECNF0_DTX_B1 = 0x0
	// Transmit '0'
	RADIO_MODECNF0_DTX_B0 = 0x1
	// Transmit center frequency
	RADIO_MODECNF0_DTX_Center = 0x2

	// SFD: IEEE 802.15.4 start of frame delimiter
	// Position of SFD field.
	RADIO_SFD_SFD_Pos = 0x0
	// Bit mask of SFD field.
	RADIO_SFD_SFD_Msk = 0xff

	// EDCNT: IEEE 802.15.4 energy detect loop count
	// Position of EDCNT field.
	RADIO_EDCNT_EDCNT_Pos = 0x0
	// Bit mask of EDCNT field.
	RADIO_EDCNT_EDCNT_Msk = 0x1fffff

	// EDSAMPLE: IEEE 802.15.4 energy detect level
	// Position of EDLVL field.
	RADIO_EDSAMPLE_EDLVL_Pos = 0x0
	// Bit mask of EDLVL field.
	RADIO_EDSAMPLE_EDLVL_Msk = 0xff

	// CCACTRL: IEEE 802.15.4 clear channel assessment control
	// Position of CCAMODE field.
	RADIO_CCACTRL_CCAMODE_Pos = 0x0
	// Bit mask of CCAMODE field.
	RADIO_CCACTRL_CCAMODE_Msk = 0x7
	// Energy above threshold
	RADIO_CCACTRL_CCAMODE_EdMode = 0x0
	// Carrier seen
	RADIO_CCACTRL_CCAMODE_CarrierMode = 0x1
	// Energy above threshold AND carrier seen
	RADIO_CCACTRL_CCAMODE_CarrierAndEdMode = 0x2
	// Energy above threshold OR carrier seen
	RADIO_CCACTRL_CCAMODE_CarrierOrEdMode = 0x3
	// Energy above threshold test mode that will abort when first ED measurement over threshold is seen. No averaging.
	RADIO_CCACTRL_CCAMODE_EdModeTest1 = 0x4
	// Position of CCAEDTHRES field.
	RADIO_CCACTRL_CCAEDTHRES_Pos = 0x8
	// Bit mask of CCAEDTHRES field.
	RADIO_CCACTRL_CCAEDTHRES_Msk = 0xff00
	// Position of CCACORRTHRES field.
	RADIO_CCACTRL_CCACORRTHRES_Pos = 0x10
	// Bit mask of CCACORRTHRES field.
	RADIO_CCACTRL_CCACORRTHRES_Msk = 0xff0000
	// Position of CCACORRCNT field.
	RADIO_CCACTRL_CCACORRCNT_Pos = 0x18
	// Bit mask of CCACORRCNT field.
	RADIO_CCACTRL_CCACORRCNT_Msk = 0xff000000

	// DFEMODE: Whether to use Angle-of-Arrival (AOA) or Angle-of-Departure (AOD)
	// Position of DFEOPMODE field.
	RADIO_DFEMODE_DFEOPMODE_Pos = 0x0
	// Bit mask of DFEOPMODE field.
	RADIO_DFEMODE_DFEOPMODE_Msk = 0x3
	// Direction finding mode disabled
	RADIO_DFEMODE_DFEOPMODE_Disabled = 0x0
	// Direction finding mode set to AoD
	RADIO_DFEMODE_DFEOPMODE_AoD = 0x2
	// Direction finding mode set to AoA
	RADIO_DFEMODE_DFEOPMODE_AoA = 0x3

	// CTEINLINECONF: Configuration for CTE inline mode
	// Position of CTEINLINECTRLEN field.
	RADIO_CTEINLINECONF_CTEINLINECTRLEN_Pos = 0x0
	// Bit mask of CTEINLINECTRLEN field.
	RADIO_CTEINLINECONF_CTEINLINECTRLEN_Msk = 0x1
	// Bit CTEINLINECTRLEN.
	RADIO_CTEINLINECONF_CTEINLINECTRLEN = 0x1
	// Parsing of CTEInfo is enabled
	RADIO_CTEINLINECONF_CTEINLINECTRLEN_Enabled = 0x1
	// Parsing of CTEInfo is disabled
	RADIO_CTEINLINECONF_CTEINLINECTRLEN_Disabled = 0x0
	// Position of CTEINFOINS1 field.
	RADIO_CTEINLINECONF_CTEINFOINS1_Pos = 0x3
	// Bit mask of CTEINFOINS1 field.
	RADIO_CTEINLINECONF_CTEINFOINS1_Msk = 0x8
	// Bit CTEINFOINS1.
	RADIO_CTEINLINECONF_CTEINFOINS1 = 0x8
	// CTEInfo is in S1 byte (data PDU)
	RADIO_CTEINLINECONF_CTEINFOINS1_InS1 = 0x1
	// CTEInfo is NOT in S1 byte (advertising PDU)
	RADIO_CTEINLINECONF_CTEINFOINS1_NotInS1 = 0x0
	// Position of CTEERRORHANDLING field.
	RADIO_CTEINLINECONF_CTEERRORHANDLING_Pos = 0x4
	// Bit mask of CTEERRORHANDLING field.
	RADIO_CTEINLINECONF_CTEERRORHANDLING_Msk = 0x10
	// Bit CTEERRORHANDLING.
	RADIO_CTEINLINECONF_CTEERRORHANDLING = 0x10
	// Sampling and antenna switching also when CRC is not OK
	RADIO_CTEINLINECONF_CTEERRORHANDLING_Yes = 0x1
	// No sampling and antenna switching when CRC is not OK
	RADIO_CTEINLINECONF_CTEERRORHANDLING_No = 0x0
	// Position of CTETIMEVALIDRANGE field.
	RADIO_CTEINLINECONF_CTETIMEVALIDRANGE_Pos = 0x6
	// Bit mask of CTETIMEVALIDRANGE field.
	RADIO_CTEINLINECONF_CTETIMEVALIDRANGE_Msk = 0xc0
	// 20 in 8us unit (default) Set to 20 if parsed CTETime is larger han 20
	RADIO_CTEINLINECONF_CTETIMEVALIDRANGE_20 = 0x0
	// 31 in 8us unit
	RADIO_CTEINLINECONF_CTETIMEVALIDRANGE_31 = 0x1
	// 63 in 8us unit
	RADIO_CTEINLINECONF_CTETIMEVALIDRANGE_63 = 0x2
	// Position of CTEINLINERXMODE1US field.
	RADIO_CTEINLINECONF_CTEINLINERXMODE1US_Pos = 0xa
	// Bit mask of CTEINLINERXMODE1US field.
	RADIO_CTEINLINECONF_CTEINLINERXMODE1US_Msk = 0x1c00
	// 4us
	RADIO_CTEINLINECONF_CTEINLINERXMODE1US_4us = 0x1
	// 2us
	RADIO_CTEINLINECONF_CTEINLINERXMODE1US_2us = 0x2
	// 1us
	RADIO_CTEINLINECONF_CTEINLINERXMODE1US_1us = 0x3
	// 0.5us
	RADIO_CTEINLINECONF_CTEINLINERXMODE1US_500ns = 0x4
	// 0.25us
	RADIO_CTEINLINECONF_CTEINLINERXMODE1US_250ns = 0x5
	// 0.125us
	RADIO_CTEINLINECONF_CTEINLINERXMODE1US_125ns = 0x6
	// Position of CTEINLINERXMODE2US field.
	RADIO_CTEINLINECONF_CTEINLINERXMODE2US_Pos = 0xd
	// Bit mask of CTEINLINERXMODE2US field.
	RADIO_CTEINLINECONF_CTEINLINERXMODE2US_Msk = 0xe000
	// 4us
	RADIO_CTEINLINECONF_CTEINLINERXMODE2US_4us = 0x1
	// 2us
	RADIO_CTEINLINECONF_CTEINLINERXMODE2US_2us = 0x2
	// 1us
	RADIO_CTEINLINECONF_CTEINLINERXMODE2US_1us = 0x3
	// 0.5us
	RADIO_CTEINLINECONF_CTEINLINERXMODE2US_500ns = 0x4
	// 0.25us
	RADIO_CTEINLINECONF_CTEINLINERXMODE2US_250ns = 0x5
	// 0.125us
	RADIO_CTEINLINECONF_CTEINLINERXMODE2US_125ns = 0x6
	// Position of S0CONF field.
	RADIO_CTEINLINECONF_S0CONF_Pos = 0x10
	// Bit mask of S0CONF field.
	RADIO_CTEINLINECONF_S0CONF_Msk = 0xff0000
	// Position of S0MASK field.
	RADIO_CTEINLINECONF_S0MASK_Pos = 0x18
	// Bit mask of S0MASK field.
	RADIO_CTEINLINECONF_S0MASK_Msk = 0xff000000

	// DFECTRL1: Various configuration for Direction finding
	// Position of NUMBEROF8US field.
	RADIO_DFECTRL1_NUMBEROF8US_Pos = 0x0
	// Bit mask of NUMBEROF8US field.
	RADIO_DFECTRL1_NUMBEROF8US_Msk = 0x3f
	// Position of DFEINEXTENSION field.
	RADIO_DFECTRL1_DFEINEXTENSION_Pos = 0x7
	// Bit mask of DFEINEXTENSION field.
	RADIO_DFECTRL1_DFEINEXTENSION_Msk = 0x80
	// Bit DFEINEXTENSION.
	RADIO_DFECTRL1_DFEINEXTENSION = 0x80
	// AoA/AoD procedure triggered at end of CRC
	RADIO_DFECTRL1_DFEINEXTENSION_CRC = 0x1
	// Antenna switching/sampling is done in the packet payload
	RADIO_DFECTRL1_DFEINEXTENSION_Payload = 0x0
	// Position of TSWITCHSPACING field.
	RADIO_DFECTRL1_TSWITCHSPACING_Pos = 0x8
	// Bit mask of TSWITCHSPACING field.
	RADIO_DFECTRL1_TSWITCHSPACING_Msk = 0x700
	// 4us
	RADIO_DFECTRL1_TSWITCHSPACING_4us = 0x1
	// 2us
	RADIO_DFECTRL1_TSWITCHSPACING_2us = 0x2
	// 1us
	RADIO_DFECTRL1_TSWITCHSPACING_1us = 0x3
	// Position of TSAMPLESPACINGREF field.
	RADIO_DFECTRL1_TSAMPLESPACINGREF_Pos = 0xc
	// Bit mask of TSAMPLESPACINGREF field.
	RADIO_DFECTRL1_TSAMPLESPACINGREF_Msk = 0x7000
	// 4us
	RADIO_DFECTRL1_TSAMPLESPACINGREF_4us = 0x1
	// 2us
	RADIO_DFECTRL1_TSAMPLESPACINGREF_2us = 0x2
	// 1us
	RADIO_DFECTRL1_TSAMPLESPACINGREF_1us = 0x3
	// 0.5us
	RADIO_DFECTRL1_TSAMPLESPACINGREF_500ns = 0x4
	// 0.25us
	RADIO_DFECTRL1_TSAMPLESPACINGREF_250ns = 0x5
	// 0.125us
	RADIO_DFECTRL1_TSAMPLESPACINGREF_125ns = 0x6
	// Position of SAMPLETYPE field.
	RADIO_DFECTRL1_SAMPLETYPE_Pos = 0xf
	// Bit mask of SAMPLETYPE field.
	RADIO_DFECTRL1_SAMPLETYPE_Msk = 0x8000
	// Bit SAMPLETYPE.
	RADIO_DFECTRL1_SAMPLETYPE = 0x8000
	// Complex samples in I and Q
	RADIO_DFECTRL1_SAMPLETYPE_IQ = 0x0
	// Complex samples as magnitude and phase
	RADIO_DFECTRL1_SAMPLETYPE_MagPhase = 0x1
	// Position of TSAMPLESPACING field.
	RADIO_DFECTRL1_TSAMPLESPACING_Pos = 0x10
	// Bit mask of TSAMPLESPACING field.
	RADIO_DFECTRL1_TSAMPLESPACING_Msk = 0x70000
	// 4us
	RADIO_DFECTRL1_TSAMPLESPACING_4us = 0x1
	// 2us
	RADIO_DFECTRL1_TSAMPLESPACING_2us = 0x2
	// 1us
	RADIO_DFECTRL1_TSAMPLESPACING_1us = 0x3
	// 0.5us
	RADIO_DFECTRL1_TSAMPLESPACING_500ns = 0x4
	// 0.25us
	RADIO_DFECTRL1_TSAMPLESPACING_250ns = 0x5
	// 0.125us
	RADIO_DFECTRL1_TSAMPLESPACING_125ns = 0x6
	// Position of REPEATPATTERN field.
	RADIO_DFECTRL1_REPEATPATTERN_Pos = 0x14
	// Bit mask of REPEATPATTERN field.
	RADIO_DFECTRL1_REPEATPATTERN_Msk = 0xf00000
	// Do not repeat (1 time in total)
	RADIO_DFECTRL1_REPEATPATTERN_NoRepeat = 0x0
	// Position of AGCBACKOFFGAIN field.
	RADIO_DFECTRL1_AGCBACKOFFGAIN_Pos = 0x18
	// Bit mask of AGCBACKOFFGAIN field.
	RADIO_DFECTRL1_AGCBACKOFFGAIN_Msk = 0xf000000

	// DFECTRL2: Start offset for Direction finding
	// Position of TSWITCHOFFSET field.
	RADIO_DFECTRL2_TSWITCHOFFSET_Pos = 0x0
	// Bit mask of TSWITCHOFFSET field.
	RADIO_DFECTRL2_TSWITCHOFFSET_Msk = 0x1fff
	// Position of TSAMPLEOFFSET field.
	RADIO_DFECTRL2_TSAMPLEOFFSET_Pos = 0x10
	// Bit mask of TSAMPLEOFFSET field.
	RADIO_DFECTRL2_TSAMPLEOFFSET_Msk = 0xfff0000

	// SWITCHPATTERN: GPIO patterns to be used for each antenna
	// Position of SWITCHPATTERN field.
	RADIO_SWITCHPATTERN_SWITCHPATTERN_Pos = 0x0
	// Bit mask of SWITCHPATTERN field.
	RADIO_SWITCHPATTERN_SWITCHPATTERN_Msk = 0xff

	// CLEARPATTERN: Clear the GPIO pattern array for antenna control
	// Position of CLEARPATTERN field.
	RADIO_CLEARPATTERN_CLEARPATTERN_Pos = 0x0
	// Bit mask of CLEARPATTERN field.
	RADIO_CLEARPATTERN_CLEARPATTERN_Msk = 0x1
	// Bit CLEARPATTERN.
	RADIO_CLEARPATTERN_CLEARPATTERN = 0x1
	// Clear the GPIO pattern
	RADIO_CLEARPATTERN_CLEARPATTERN_Clear = 0x1

	// PSEL.DFEGPIO: Description collection: Pin select for DFE pin n
	// Position of PIN field.
	RADIO_PSEL_DFEGPIO_PIN_Pos = 0x0
	// Bit mask of PIN field.
	RADIO_PSEL_DFEGPIO_PIN_Msk = 0x1f
	// Position of PORT field.
	RADIO_PSEL_DFEGPIO_PORT_Pos = 0x5
	// Bit mask of PORT field.
	RADIO_PSEL_DFEGPIO_PORT_Msk = 0x20
	// Bit PORT.
	RADIO_PSEL_DFEGPIO_PORT = 0x20
	// Position of CONNECT field.
	RADIO_PSEL_DFEGPIO_CONNECT_Pos = 0x1f
	// Bit mask of CONNECT field.
	RADIO_PSEL_DFEGPIO_CONNECT_Msk = 0x80000000
	// Bit CONNECT.
	RADIO_PSEL_DFEGPIO_CONNECT = 0x80000000
	// Disconnect
	RADIO_PSEL_DFEGPIO_CONNECT_Disconnected = 0x1
	// Connect
	RADIO_PSEL_DFEGPIO_CONNECT_Connected = 0x0

	// DFEPACKET.PTR: Data pointer
	// Position of PTR field.
	RADIO_DFEPACKET_PTR_PTR_Pos = 0x0
	// Bit mask of PTR field.
	RADIO_DFEPACKET_PTR_PTR_Msk = 0xffffffff

	// DFEPACKET.MAXCNT: Maximum number of buffer words to transfer
	// Position of MAXCNT field.
	RADIO_DFEPACKET_MAXCNT_MAXCNT_Pos = 0x0
	// Bit mask of MAXCNT field.
	RADIO_DFEPACKET_MAXCNT_MAXCNT_Msk = 0x3fff

	// DFEPACKET.AMOUNT: Number of samples transferred in the last transaction
	// Position of AMOUNT field.
	RADIO_DFEPACKET_AMOUNT_AMOUNT_Pos = 0x0
	// Bit mask of AMOUNT field.
	RADIO_DFEPACKET_AMOUNT_AMOUNT_Msk = 0xffff

	// POWER: Peripheral power control
	// Position of POWER field.
	RADIO_POWER_POWER_Pos = 0x0
	// Bit mask of POWER field.
	RADIO_POWER_POWER_Msk = 0x1
	// Bit POWER.
	RADIO_POWER_POWER = 0x1
	// Peripheral is powered off
	RADIO_POWER_POWER_Disabled = 0x0
	// Peripheral is powered on
	RADIO_POWER_POWER_Enabled = 0x1
)

// Constants for RNG_NS: Random Number Generator
const (
	// TASKS_START: Task starting the random number generator
	// Position of TASKS_START field.
	RNG_TASKS_START_TASKS_START_Pos = 0x0
	// Bit mask of TASKS_START field.
	RNG_TASKS_START_TASKS_START_Msk = 0x1
	// Bit TASKS_START.
	RNG_TASKS_START_TASKS_START = 0x1
	// Trigger task
	RNG_TASKS_START_TASKS_START_Trigger = 0x1

	// TASKS_STOP: Task stopping the random number generator
	// Position of TASKS_STOP field.
	RNG_TASKS_STOP_TASKS_STOP_Pos = 0x0
	// Bit mask of TASKS_STOP field.
	RNG_TASKS_STOP_TASKS_STOP_Msk = 0x1
	// Bit TASKS_STOP.
	RNG_TASKS_STOP_TASKS_STOP = 0x1
	// Trigger task
	RNG_TASKS_STOP_TASKS_STOP_Trigger = 0x1

	// SUBSCRIBE_START: Subscribe configuration for task START
	// Position of CHIDX field.
	RNG_SUBSCRIBE_START_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	RNG_SUBSCRIBE_START_CHIDX_Msk = 0xff
	// Position of EN field.
	RNG_SUBSCRIBE_START_EN_Pos = 0x1f
	// Bit mask of EN field.
	RNG_SUBSCRIBE_START_EN_Msk = 0x80000000
	// Bit EN.
	RNG_SUBSCRIBE_START_EN = 0x80000000
	// Disable subscription
	RNG_SUBSCRIBE_START_EN_Disabled = 0x0
	// Enable subscription
	RNG_SUBSCRIBE_START_EN_Enabled = 0x1

	// SUBSCRIBE_STOP: Subscribe configuration for task STOP
	// Position of CHIDX field.
	RNG_SUBSCRIBE_STOP_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	RNG_SUBSCRIBE_STOP_CHIDX_Msk = 0xff
	// Position of EN field.
	RNG_SUBSCRIBE_STOP_EN_Pos = 0x1f
	// Bit mask of EN field.
	RNG_SUBSCRIBE_STOP_EN_Msk = 0x80000000
	// Bit EN.
	RNG_SUBSCRIBE_STOP_EN = 0x80000000
	// Disable subscription
	RNG_SUBSCRIBE_STOP_EN_Disabled = 0x0
	// Enable subscription
	RNG_SUBSCRIBE_STOP_EN_Enabled = 0x1

	// EVENTS_VALRDY: Event being generated for every new random number written to the VALUE register
	// Position of EVENTS_VALRDY field.
	RNG_EVENTS_VALRDY_EVENTS_VALRDY_Pos = 0x0
	// Bit mask of EVENTS_VALRDY field.
	RNG_EVENTS_VALRDY_EVENTS_VALRDY_Msk = 0x1
	// Bit EVENTS_VALRDY.
	RNG_EVENTS_VALRDY_EVENTS_VALRDY = 0x1
	// Event not generated
	RNG_EVENTS_VALRDY_EVENTS_VALRDY_NotGenerated = 0x0
	// Event generated
	RNG_EVENTS_VALRDY_EVENTS_VALRDY_Generated = 0x1

	// PUBLISH_VALRDY: Publish configuration for event VALRDY
	// Position of CHIDX field.
	RNG_PUBLISH_VALRDY_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	RNG_PUBLISH_VALRDY_CHIDX_Msk = 0xff
	// Position of EN field.
	RNG_PUBLISH_VALRDY_EN_Pos = 0x1f
	// Bit mask of EN field.
	RNG_PUBLISH_VALRDY_EN_Msk = 0x80000000
	// Bit EN.
	RNG_PUBLISH_VALRDY_EN = 0x80000000
	// Disable publishing
	RNG_PUBLISH_VALRDY_EN_Disabled = 0x0
	// Enable publishing
	RNG_PUBLISH_VALRDY_EN_Enabled = 0x1

	// SHORTS: Shortcuts between local events and tasks
	// Position of VALRDY_STOP field.
	RNG_SHORTS_VALRDY_STOP_Pos = 0x0
	// Bit mask of VALRDY_STOP field.
	RNG_SHORTS_VALRDY_STOP_Msk = 0x1
	// Bit VALRDY_STOP.
	RNG_SHORTS_VALRDY_STOP = 0x1
	// Disable shortcut
	RNG_SHORTS_VALRDY_STOP_Disabled = 0x0
	// Enable shortcut
	RNG_SHORTS_VALRDY_STOP_Enabled = 0x1

	// INTENSET: Enable interrupt
	// Position of VALRDY field.
	RNG_INTENSET_VALRDY_Pos = 0x0
	// Bit mask of VALRDY field.
	RNG_INTENSET_VALRDY_Msk = 0x1
	// Bit VALRDY.
	RNG_INTENSET_VALRDY = 0x1
	// Read: Disabled
	RNG_INTENSET_VALRDY_Disabled = 0x0
	// Read: Enabled
	RNG_INTENSET_VALRDY_Enabled = 0x1
	// Enable
	RNG_INTENSET_VALRDY_Set = 0x1

	// INTENCLR: Disable interrupt
	// Position of VALRDY field.
	RNG_INTENCLR_VALRDY_Pos = 0x0
	// Bit mask of VALRDY field.
	RNG_INTENCLR_VALRDY_Msk = 0x1
	// Bit VALRDY.
	RNG_INTENCLR_VALRDY = 0x1
	// Read: Disabled
	RNG_INTENCLR_VALRDY_Disabled = 0x0
	// Read: Enabled
	RNG_INTENCLR_VALRDY_Enabled = 0x1
	// Disable
	RNG_INTENCLR_VALRDY_Clear = 0x1

	// CONFIG: Configuration register
	// Position of DERCEN field.
	RNG_CONFIG_DERCEN_Pos = 0x0
	// Bit mask of DERCEN field.
	RNG_CONFIG_DERCEN_Msk = 0x1
	// Bit DERCEN.
	RNG_CONFIG_DERCEN = 0x1
	// Disabled
	RNG_CONFIG_DERCEN_Disabled = 0x0
	// Enabled
	RNG_CONFIG_DERCEN_Enabled = 0x1

	// VALUE: Output random number
	// Position of VALUE field.
	RNG_VALUE_VALUE_Pos = 0x0
	// Bit mask of VALUE field.
	RNG_VALUE_VALUE_Msk = 0xff
)

// Constants for GPIOTE_NS: GPIO Tasks and Events
const (
	// TASKS_OUT: Description collection: Task for writing to pin specified in CONFIG[n].PSEL. Action on pin is configured in CONFIG[n].POLARITY.
	// Position of TASKS_OUT field.
	GPIOTE_TASKS_OUT_TASKS_OUT_Pos = 0x0
	// Bit mask of TASKS_OUT field.
	GPIOTE_TASKS_OUT_TASKS_OUT_Msk = 0x1
	// Bit TASKS_OUT.
	GPIOTE_TASKS_OUT_TASKS_OUT = 0x1
	// Trigger task
	GPIOTE_TASKS_OUT_TASKS_OUT_Trigger = 0x1

	// TASKS_SET: Description collection: Task for writing to pin specified in CONFIG[n].PSEL. Action on pin is to set it high.
	// Position of TASKS_SET field.
	GPIOTE_TASKS_SET_TASKS_SET_Pos = 0x0
	// Bit mask of TASKS_SET field.
	GPIOTE_TASKS_SET_TASKS_SET_Msk = 0x1
	// Bit TASKS_SET.
	GPIOTE_TASKS_SET_TASKS_SET = 0x1
	// Trigger task
	GPIOTE_TASKS_SET_TASKS_SET_Trigger = 0x1

	// TASKS_CLR: Description collection: Task for writing to pin specified in CONFIG[n].PSEL. Action on pin is to set it low.
	// Position of TASKS_CLR field.
	GPIOTE_TASKS_CLR_TASKS_CLR_Pos = 0x0
	// Bit mask of TASKS_CLR field.
	GPIOTE_TASKS_CLR_TASKS_CLR_Msk = 0x1
	// Bit TASKS_CLR.
	GPIOTE_TASKS_CLR_TASKS_CLR = 0x1
	// Trigger task
	GPIOTE_TASKS_CLR_TASKS_CLR_Trigger = 0x1

	// SUBSCRIBE_OUT: Description collection: Subscribe configuration for task OUT[n]
	// Position of CHIDX field.
	GPIOTE_SUBSCRIBE_OUT_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	GPIOTE_SUBSCRIBE_OUT_CHIDX_Msk = 0xff
	// Position of EN field.
	GPIOTE_SUBSCRIBE_OUT_EN_Pos = 0x1f
	// Bit mask of EN field.
	GPIOTE_SUBSCRIBE_OUT_EN_Msk = 0x80000000
	// Bit EN.
	GPIOTE_SUBSCRIBE_OUT_EN = 0x80000000
	// Disable subscription
	GPIOTE_SUBSCRIBE_OUT_EN_Disabled = 0x0
	// Enable subscription
	GPIOTE_SUBSCRIBE_OUT_EN_Enabled = 0x1

	// SUBSCRIBE_SET: Description collection: Subscribe configuration for task SET[n]
	// Position of CHIDX field.
	GPIOTE_SUBSCRIBE_SET_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	GPIOTE_SUBSCRIBE_SET_CHIDX_Msk = 0xff
	// Position of EN field.
	GPIOTE_SUBSCRIBE_SET_EN_Pos = 0x1f
	// Bit mask of EN field.
	GPIOTE_SUBSCRIBE_SET_EN_Msk = 0x80000000
	// Bit EN.
	GPIOTE_SUBSCRIBE_SET_EN = 0x80000000
	// Disable subscription
	GPIOTE_SUBSCRIBE_SET_EN_Disabled = 0x0
	// Enable subscription
	GPIOTE_SUBSCRIBE_SET_EN_Enabled = 0x1

	// SUBSCRIBE_CLR: Description collection: Subscribe configuration for task CLR[n]
	// Position of CHIDX field.
	GPIOTE_SUBSCRIBE_CLR_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	GPIOTE_SUBSCRIBE_CLR_CHIDX_Msk = 0xff
	// Position of EN field.
	GPIOTE_SUBSCRIBE_CLR_EN_Pos = 0x1f
	// Bit mask of EN field.
	GPIOTE_SUBSCRIBE_CLR_EN_Msk = 0x80000000
	// Bit EN.
	GPIOTE_SUBSCRIBE_CLR_EN = 0x80000000
	// Disable subscription
	GPIOTE_SUBSCRIBE_CLR_EN_Disabled = 0x0
	// Enable subscription
	GPIOTE_SUBSCRIBE_CLR_EN_Enabled = 0x1

	// EVENTS_IN: Description collection: Event generated from pin specified in CONFIG[n].PSEL
	// Position of EVENTS_IN field.
	GPIOTE_EVENTS_IN_EVENTS_IN_Pos = 0x0
	// Bit mask of EVENTS_IN field.
	GPIOTE_EVENTS_IN_EVENTS_IN_Msk = 0x1
	// Bit EVENTS_IN.
	GPIOTE_EVENTS_IN_EVENTS_IN = 0x1
	// Event not generated
	GPIOTE_EVENTS_IN_EVENTS_IN_NotGenerated = 0x0
	// Event generated
	GPIOTE_EVENTS_IN_EVENTS_IN_Generated = 0x1

	// EVENTS_PORT: Event generated from multiple input GPIO pins with SENSE mechanism enabled
	// Position of EVENTS_PORT field.
	GPIOTE_EVENTS_PORT_EVENTS_PORT_Pos = 0x0
	// Bit mask of EVENTS_PORT field.
	GPIOTE_EVENTS_PORT_EVENTS_PORT_Msk = 0x1
	// Bit EVENTS_PORT.
	GPIOTE_EVENTS_PORT_EVENTS_PORT = 0x1
	// Event not generated
	GPIOTE_EVENTS_PORT_EVENTS_PORT_NotGenerated = 0x0
	// Event generated
	GPIOTE_EVENTS_PORT_EVENTS_PORT_Generated = 0x1

	// PUBLISH_IN: Description collection: Publish configuration for event IN[n]
	// Position of CHIDX field.
	GPIOTE_PUBLISH_IN_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	GPIOTE_PUBLISH_IN_CHIDX_Msk = 0xff
	// Position of EN field.
	GPIOTE_PUBLISH_IN_EN_Pos = 0x1f
	// Bit mask of EN field.
	GPIOTE_PUBLISH_IN_EN_Msk = 0x80000000
	// Bit EN.
	GPIOTE_PUBLISH_IN_EN = 0x80000000
	// Disable publishing
	GPIOTE_PUBLISH_IN_EN_Disabled = 0x0
	// Enable publishing
	GPIOTE_PUBLISH_IN_EN_Enabled = 0x1

	// PUBLISH_PORT: Publish configuration for event PORT
	// Position of CHIDX field.
	GPIOTE_PUBLISH_PORT_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	GPIOTE_PUBLISH_PORT_CHIDX_Msk = 0xff
	// Position of EN field.
	GPIOTE_PUBLISH_PORT_EN_Pos = 0x1f
	// Bit mask of EN field.
	GPIOTE_PUBLISH_PORT_EN_Msk = 0x80000000
	// Bit EN.
	GPIOTE_PUBLISH_PORT_EN = 0x80000000
	// Disable publishing
	GPIOTE_PUBLISH_PORT_EN_Disabled = 0x0
	// Enable publishing
	GPIOTE_PUBLISH_PORT_EN_Enabled = 0x1

	// INTENSET: Enable interrupt
	// Position of IN0 field.
	GPIOTE_INTENSET_IN0_Pos = 0x0
	// Bit mask of IN0 field.
	GPIOTE_INTENSET_IN0_Msk = 0x1
	// Bit IN0.
	GPIOTE_INTENSET_IN0 = 0x1
	// Read: Disabled
	GPIOTE_INTENSET_IN0_Disabled = 0x0
	// Read: Enabled
	GPIOTE_INTENSET_IN0_Enabled = 0x1
	// Enable
	GPIOTE_INTENSET_IN0_Set = 0x1
	// Position of IN1 field.
	GPIOTE_INTENSET_IN1_Pos = 0x1
	// Bit mask of IN1 field.
	GPIOTE_INTENSET_IN1_Msk = 0x2
	// Bit IN1.
	GPIOTE_INTENSET_IN1 = 0x2
	// Read: Disabled
	GPIOTE_INTENSET_IN1_Disabled = 0x0
	// Read: Enabled
	GPIOTE_INTENSET_IN1_Enabled = 0x1
	// Enable
	GPIOTE_INTENSET_IN1_Set = 0x1
	// Position of IN2 field.
	GPIOTE_INTENSET_IN2_Pos = 0x2
	// Bit mask of IN2 field.
	GPIOTE_INTENSET_IN2_Msk = 0x4
	// Bit IN2.
	GPIOTE_INTENSET_IN2 = 0x4
	// Read: Disabled
	GPIOTE_INTENSET_IN2_Disabled = 0x0
	// Read: Enabled
	GPIOTE_INTENSET_IN2_Enabled = 0x1
	// Enable
	GPIOTE_INTENSET_IN2_Set = 0x1
	// Position of IN3 field.
	GPIOTE_INTENSET_IN3_Pos = 0x3
	// Bit mask of IN3 field.
	GPIOTE_INTENSET_IN3_Msk = 0x8
	// Bit IN3.
	GPIOTE_INTENSET_IN3 = 0x8
	// Read: Disabled
	GPIOTE_INTENSET_IN3_Disabled = 0x0
	// Read: Enabled
	GPIOTE_INTENSET_IN3_Enabled = 0x1
	// Enable
	GPIOTE_INTENSET_IN3_Set = 0x1
	// Position of IN4 field.
	GPIOTE_INTENSET_IN4_Pos = 0x4
	// Bit mask of IN4 field.
	GPIOTE_INTENSET_IN4_Msk = 0x10
	// Bit IN4.
	GPIOTE_INTENSET_IN4 = 0x10
	// Read: Disabled
	GPIOTE_INTENSET_IN4_Disabled = 0x0
	// Read: Enabled
	GPIOTE_INTENSET_IN4_Enabled = 0x1
	// Enable
	GPIOTE_INTENSET_IN4_Set = 0x1
	// Position of IN5 field.
	GPIOTE_INTENSET_IN5_Pos = 0x5
	// Bit mask of IN5 field.
	GPIOTE_INTENSET_IN5_Msk = 0x20
	// Bit IN5.
	GPIOTE_INTENSET_IN5 = 0x20
	// Read: Disabled
	GPIOTE_INTENSET_IN5_Disabled = 0x0
	// Read: Enabled
	GPIOTE_INTENSET_IN5_Enabled = 0x1
	// Enable
	GPIOTE_INTENSET_IN5_Set = 0x1
	// Position of IN6 field.
	GPIOTE_INTENSET_IN6_Pos = 0x6
	// Bit mask of IN6 field.
	GPIOTE_INTENSET_IN6_Msk = 0x40
	// Bit IN6.
	GPIOTE_INTENSET_IN6 = 0x40
	// Read: Disabled
	GPIOTE_INTENSET_IN6_Disabled = 0x0
	// Read: Enabled
	GPIOTE_INTENSET_IN6_Enabled = 0x1
	// Enable
	GPIOTE_INTENSET_IN6_Set = 0x1
	// Position of IN7 field.
	GPIOTE_INTENSET_IN7_Pos = 0x7
	// Bit mask of IN7 field.
	GPIOTE_INTENSET_IN7_Msk = 0x80
	// Bit IN7.
	GPIOTE_INTENSET_IN7 = 0x80
	// Read: Disabled
	GPIOTE_INTENSET_IN7_Disabled = 0x0
	// Read: Enabled
	GPIOTE_INTENSET_IN7_Enabled = 0x1
	// Enable
	GPIOTE_INTENSET_IN7_Set = 0x1
	// Position of PORT field.
	GPIOTE_INTENSET_PORT_Pos = 0x1f
	// Bit mask of PORT field.
	GPIOTE_INTENSET_PORT_Msk = 0x80000000
	// Bit PORT.
	GPIOTE_INTENSET_PORT = 0x80000000
	// Read: Disabled
	GPIOTE_INTENSET_PORT_Disabled = 0x0
	// Read: Enabled
	GPIOTE_INTENSET_PORT_Enabled = 0x1
	// Enable
	GPIOTE_INTENSET_PORT_Set = 0x1

	// INTENCLR: Disable interrupt
	// Position of IN0 field.
	GPIOTE_INTENCLR_IN0_Pos = 0x0
	// Bit mask of IN0 field.
	GPIOTE_INTENCLR_IN0_Msk = 0x1
	// Bit IN0.
	GPIOTE_INTENCLR_IN0 = 0x1
	// Read: Disabled
	GPIOTE_INTENCLR_IN0_Disabled = 0x0
	// Read: Enabled
	GPIOTE_INTENCLR_IN0_Enabled = 0x1
	// Disable
	GPIOTE_INTENCLR_IN0_Clear = 0x1
	// Position of IN1 field.
	GPIOTE_INTENCLR_IN1_Pos = 0x1
	// Bit mask of IN1 field.
	GPIOTE_INTENCLR_IN1_Msk = 0x2
	// Bit IN1.
	GPIOTE_INTENCLR_IN1 = 0x2
	// Read: Disabled
	GPIOTE_INTENCLR_IN1_Disabled = 0x0
	// Read: Enabled
	GPIOTE_INTENCLR_IN1_Enabled = 0x1
	// Disable
	GPIOTE_INTENCLR_IN1_Clear = 0x1
	// Position of IN2 field.
	GPIOTE_INTENCLR_IN2_Pos = 0x2
	// Bit mask of IN2 field.
	GPIOTE_INTENCLR_IN2_Msk = 0x4
	// Bit IN2.
	GPIOTE_INTENCLR_IN2 = 0x4
	// Read: Disabled
	GPIOTE_INTENCLR_IN2_Disabled = 0x0
	// Read: Enabled
	GPIOTE_INTENCLR_IN2_Enabled = 0x1
	// Disable
	GPIOTE_INTENCLR_IN2_Clear = 0x1
	// Position of IN3 field.
	GPIOTE_INTENCLR_IN3_Pos = 0x3
	// Bit mask of IN3 field.
	GPIOTE_INTENCLR_IN3_Msk = 0x8
	// Bit IN3.
	GPIOTE_INTENCLR_IN3 = 0x8
	// Read: Disabled
	GPIOTE_INTENCLR_IN3_Disabled = 0x0
	// Read: Enabled
	GPIOTE_INTENCLR_IN3_Enabled = 0x1
	// Disable
	GPIOTE_INTENCLR_IN3_Clear = 0x1
	// Position of IN4 field.
	GPIOTE_INTENCLR_IN4_Pos = 0x4
	// Bit mask of IN4 field.
	GPIOTE_INTENCLR_IN4_Msk = 0x10
	// Bit IN4.
	GPIOTE_INTENCLR_IN4 = 0x10
	// Read: Disabled
	GPIOTE_INTENCLR_IN4_Disabled = 0x0
	// Read: Enabled
	GPIOTE_INTENCLR_IN4_Enabled = 0x1
	// Disable
	GPIOTE_INTENCLR_IN4_Clear = 0x1
	// Position of IN5 field.
	GPIOTE_INTENCLR_IN5_Pos = 0x5
	// Bit mask of IN5 field.
	GPIOTE_INTENCLR_IN5_Msk = 0x20
	// Bit IN5.
	GPIOTE_INTENCLR_IN5 = 0x20
	// Read: Disabled
	GPIOTE_INTENCLR_IN5_Disabled = 0x0
	// Read: Enabled
	GPIOTE_INTENCLR_IN5_Enabled = 0x1
	// Disable
	GPIOTE_INTENCLR_IN5_Clear = 0x1
	// Position of IN6 field.
	GPIOTE_INTENCLR_IN6_Pos = 0x6
	// Bit mask of IN6 field.
	GPIOTE_INTENCLR_IN6_Msk = 0x40
	// Bit IN6.
	GPIOTE_INTENCLR_IN6 = 0x40
	// Read: Disabled
	GPIOTE_INTENCLR_IN6_Disabled = 0x0
	// Read: Enabled
	GPIOTE_INTENCLR_IN6_Enabled = 0x1
	// Disable
	GPIOTE_INTENCLR_IN6_Clear = 0x1
	// Position of IN7 field.
	GPIOTE_INTENCLR_IN7_Pos = 0x7
	// Bit mask of IN7 field.
	GPIOTE_INTENCLR_IN7_Msk = 0x80
	// Bit IN7.
	GPIOTE_INTENCLR_IN7 = 0x80
	// Read: Disabled
	GPIOTE_INTENCLR_IN7_Disabled = 0x0
	// Read: Enabled
	GPIOTE_INTENCLR_IN7_Enabled = 0x1
	// Disable
	GPIOTE_INTENCLR_IN7_Clear = 0x1
	// Position of PORT field.
	GPIOTE_INTENCLR_PORT_Pos = 0x1f
	// Bit mask of PORT field.
	GPIOTE_INTENCLR_PORT_Msk = 0x80000000
	// Bit PORT.
	GPIOTE_INTENCLR_PORT = 0x80000000
	// Read: Disabled
	GPIOTE_INTENCLR_PORT_Disabled = 0x0
	// Read: Enabled
	GPIOTE_INTENCLR_PORT_Enabled = 0x1
	// Disable
	GPIOTE_INTENCLR_PORT_Clear = 0x1

	// LATENCY: Latency selection for Event mode (MODE=Event) with rising or falling edge detection on the pin.
	// Position of LATENCY field.
	GPIOTE_LATENCY_LATENCY_Pos = 0x0
	// Bit mask of LATENCY field.
	GPIOTE_LATENCY_LATENCY_Msk = 0x1
	// Bit LATENCY.
	GPIOTE_LATENCY_LATENCY = 0x1
	// Low power setting, for signals with minimum hold time tGPIOTE,HOLD,LP; refer to Electrical specification section
	GPIOTE_LATENCY_LATENCY_LowPower = 0x0
	// Low latency setting, for signals with minimum hold time tGPIOTE,HOLD,LL; refer to Electrical specification section
	GPIOTE_LATENCY_LATENCY_LowLatency = 0x1

	// CONFIG: Description collection: Configuration for OUT[n], SET[n], and CLR[n] tasks and IN[n] event
	// Position of MODE field.
	GPIOTE_CONFIG_MODE_Pos = 0x0
	// Bit mask of MODE field.
	GPIOTE_CONFIG_MODE_Msk = 0x3
	// Disabled. Pin specified by PSEL will not be acquired by the GPIOTE module.
	GPIOTE_CONFIG_MODE_Disabled = 0x0
	// Event mode
	GPIOTE_CONFIG_MODE_Event = 0x1
	// Task mode
	GPIOTE_CONFIG_MODE_Task = 0x3
	// Position of PSEL field.
	GPIOTE_CONFIG_PSEL_Pos = 0x8
	// Bit mask of PSEL field.
	GPIOTE_CONFIG_PSEL_Msk = 0x1f00
	// Position of PORT field.
	GPIOTE_CONFIG_PORT_Pos = 0xd
	// Bit mask of PORT field.
	GPIOTE_CONFIG_PORT_Msk = 0x2000
	// Bit PORT.
	GPIOTE_CONFIG_PORT = 0x2000
	// Position of POLARITY field.
	GPIOTE_CONFIG_POLARITY_Pos = 0x10
	// Bit mask of POLARITY field.
	GPIOTE_CONFIG_POLARITY_Msk = 0x30000
	// Task mode: No effect on pin from OUT[n] task. Event mode: no IN[n] event generated on pin activity.
	GPIOTE_CONFIG_POLARITY_None = 0x0
	// Task mode: Set pin from OUT[n] task. Event mode: Generate IN[n] event when rising edge on pin.
	GPIOTE_CONFIG_POLARITY_LoToHi = 0x1
	// Task mode: Clear pin from OUT[n] task. Event mode: Generate IN[n] event when falling edge on pin.
	GPIOTE_CONFIG_POLARITY_HiToLo = 0x2
	// Task mode: Toggle pin from OUT[n]. Event mode: Generate IN[n] when any change on pin.
	GPIOTE_CONFIG_POLARITY_Toggle = 0x3
	// Position of OUTINIT field.
	GPIOTE_CONFIG_OUTINIT_Pos = 0x14
	// Bit mask of OUTINIT field.
	GPIOTE_CONFIG_OUTINIT_Msk = 0x100000
	// Bit OUTINIT.
	GPIOTE_CONFIG_OUTINIT = 0x100000
	// Task mode: Initial value of pin before task triggering is low
	GPIOTE_CONFIG_OUTINIT_Low = 0x0
	// Task mode: Initial value of pin before task triggering is high
	GPIOTE_CONFIG_OUTINIT_High = 0x1
)

// Constants for WDT_NS: Watchdog Timer
const (
	// TASKS_START: Start the watchdog
	// Position of TASKS_START field.
	WDT_TASKS_START_TASKS_START_Pos = 0x0
	// Bit mask of TASKS_START field.
	WDT_TASKS_START_TASKS_START_Msk = 0x1
	// Bit TASKS_START.
	WDT_TASKS_START_TASKS_START = 0x1
	// Trigger task
	WDT_TASKS_START_TASKS_START_Trigger = 0x1

	// TASKS_STOP: Stop the watchdog timer.
	// Position of TASKS_STOP field.
	WDT_TASKS_STOP_TASKS_STOP_Pos = 0x0
	// Bit mask of TASKS_STOP field.
	WDT_TASKS_STOP_TASKS_STOP_Msk = 0x1
	// Bit TASKS_STOP.
	WDT_TASKS_STOP_TASKS_STOP = 0x1
	// Trigger task
	WDT_TASKS_STOP_TASKS_STOP_Trigger = 0x1

	// SUBSCRIBE_START: Subscribe configuration for task START
	// Position of CHIDX field.
	WDT_SUBSCRIBE_START_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	WDT_SUBSCRIBE_START_CHIDX_Msk = 0xff
	// Position of EN field.
	WDT_SUBSCRIBE_START_EN_Pos = 0x1f
	// Bit mask of EN field.
	WDT_SUBSCRIBE_START_EN_Msk = 0x80000000
	// Bit EN.
	WDT_SUBSCRIBE_START_EN = 0x80000000
	// Disable subscription
	WDT_SUBSCRIBE_START_EN_Disabled = 0x0
	// Enable subscription
	WDT_SUBSCRIBE_START_EN_Enabled = 0x1

	// SUBSCRIBE_STOP: Subscribe configuration for task STOP
	// Position of CHIDX field.
	WDT_SUBSCRIBE_STOP_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	WDT_SUBSCRIBE_STOP_CHIDX_Msk = 0xff
	// Position of EN field.
	WDT_SUBSCRIBE_STOP_EN_Pos = 0x1f
	// Bit mask of EN field.
	WDT_SUBSCRIBE_STOP_EN_Msk = 0x80000000
	// Bit EN.
	WDT_SUBSCRIBE_STOP_EN = 0x80000000
	// Disable subscription
	WDT_SUBSCRIBE_STOP_EN_Disabled = 0x0
	// Enable subscription
	WDT_SUBSCRIBE_STOP_EN_Enabled = 0x1

	// EVENTS_TIMEOUT: Watchdog timeout
	// Position of EVENTS_TIMEOUT field.
	WDT_EVENTS_TIMEOUT_EVENTS_TIMEOUT_Pos = 0x0
	// Bit mask of EVENTS_TIMEOUT field.
	WDT_EVENTS_TIMEOUT_EVENTS_TIMEOUT_Msk = 0x1
	// Bit EVENTS_TIMEOUT.
	WDT_EVENTS_TIMEOUT_EVENTS_TIMEOUT = 0x1
	// Event not generated
	WDT_EVENTS_TIMEOUT_EVENTS_TIMEOUT_NotGenerated = 0x0
	// Event generated
	WDT_EVENTS_TIMEOUT_EVENTS_TIMEOUT_Generated = 0x1

	// EVENTS_STOPPED: Watchdog stopped
	// Position of EVENTS_STOPPED field.
	WDT_EVENTS_STOPPED_EVENTS_STOPPED_Pos = 0x0
	// Bit mask of EVENTS_STOPPED field.
	WDT_EVENTS_STOPPED_EVENTS_STOPPED_Msk = 0x1
	// Bit EVENTS_STOPPED.
	WDT_EVENTS_STOPPED_EVENTS_STOPPED = 0x1
	// Event not generated
	WDT_EVENTS_STOPPED_EVENTS_STOPPED_NotGenerated = 0x0
	// Event generated
	WDT_EVENTS_STOPPED_EVENTS_STOPPED_Generated = 0x1

	// PUBLISH_TIMEOUT: Publish configuration for event TIMEOUT
	// Position of CHIDX field.
	WDT_PUBLISH_TIMEOUT_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	WDT_PUBLISH_TIMEOUT_CHIDX_Msk = 0xff
	// Position of EN field.
	WDT_PUBLISH_TIMEOUT_EN_Pos = 0x1f
	// Bit mask of EN field.
	WDT_PUBLISH_TIMEOUT_EN_Msk = 0x80000000
	// Bit EN.
	WDT_PUBLISH_TIMEOUT_EN = 0x80000000
	// Disable publishing
	WDT_PUBLISH_TIMEOUT_EN_Disabled = 0x0
	// Enable publishing
	WDT_PUBLISH_TIMEOUT_EN_Enabled = 0x1

	// PUBLISH_STOPPED: Publish configuration for event STOPPED
	// Position of CHIDX field.
	WDT_PUBLISH_STOPPED_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	WDT_PUBLISH_STOPPED_CHIDX_Msk = 0xff
	// Position of EN field.
	WDT_PUBLISH_STOPPED_EN_Pos = 0x1f
	// Bit mask of EN field.
	WDT_PUBLISH_STOPPED_EN_Msk = 0x80000000
	// Bit EN.
	WDT_PUBLISH_STOPPED_EN = 0x80000000
	// Disable publishing
	WDT_PUBLISH_STOPPED_EN_Disabled = 0x0
	// Enable publishing
	WDT_PUBLISH_STOPPED_EN_Enabled = 0x1

	// INTENSET: Enable interrupt
	// Position of TIMEOUT field.
	WDT_INTENSET_TIMEOUT_Pos = 0x0
	// Bit mask of TIMEOUT field.
	WDT_INTENSET_TIMEOUT_Msk = 0x1
	// Bit TIMEOUT.
	WDT_INTENSET_TIMEOUT = 0x1
	// Read: Disabled
	WDT_INTENSET_TIMEOUT_Disabled = 0x0
	// Read: Enabled
	WDT_INTENSET_TIMEOUT_Enabled = 0x1
	// Enable
	WDT_INTENSET_TIMEOUT_Set = 0x1
	// Position of STOPPED field.
	WDT_INTENSET_STOPPED_Pos = 0x1
	// Bit mask of STOPPED field.
	WDT_INTENSET_STOPPED_Msk = 0x2
	// Bit STOPPED.
	WDT_INTENSET_STOPPED = 0x2
	// Read: Disabled
	WDT_INTENSET_STOPPED_Disabled = 0x0
	// Read: Enabled
	WDT_INTENSET_STOPPED_Enabled = 0x1
	// Enable
	WDT_INTENSET_STOPPED_Set = 0x1

	// INTENCLR: Disable interrupt
	// Position of TIMEOUT field.
	WDT_INTENCLR_TIMEOUT_Pos = 0x0
	// Bit mask of TIMEOUT field.
	WDT_INTENCLR_TIMEOUT_Msk = 0x1
	// Bit TIMEOUT.
	WDT_INTENCLR_TIMEOUT = 0x1
	// Read: Disabled
	WDT_INTENCLR_TIMEOUT_Disabled = 0x0
	// Read: Enabled
	WDT_INTENCLR_TIMEOUT_Enabled = 0x1
	// Disable
	WDT_INTENCLR_TIMEOUT_Clear = 0x1
	// Position of STOPPED field.
	WDT_INTENCLR_STOPPED_Pos = 0x1
	// Bit mask of STOPPED field.
	WDT_INTENCLR_STOPPED_Msk = 0x2
	// Bit STOPPED.
	WDT_INTENCLR_STOPPED = 0x2
	// Read: Disabled
	WDT_INTENCLR_STOPPED_Disabled = 0x0
	// Read: Enabled
	WDT_INTENCLR_STOPPED_Enabled = 0x1
	// Disable
	WDT_INTENCLR_STOPPED_Clear = 0x1

	// NMIENSET: Enable interrupt
	// Position of TIMEOUT field.
	WDT_NMIENSET_TIMEOUT_Pos = 0x0
	// Bit mask of TIMEOUT field.
	WDT_NMIENSET_TIMEOUT_Msk = 0x1
	// Bit TIMEOUT.
	WDT_NMIENSET_TIMEOUT = 0x1
	// Read: Disabled
	WDT_NMIENSET_TIMEOUT_Disabled = 0x0
	// Read: Enabled
	WDT_NMIENSET_TIMEOUT_Enabled = 0x1
	// Enable
	WDT_NMIENSET_TIMEOUT_Set = 0x1
	// Position of STOPPED field.
	WDT_NMIENSET_STOPPED_Pos = 0x1
	// Bit mask of STOPPED field.
	WDT_NMIENSET_STOPPED_Msk = 0x2
	// Bit STOPPED.
	WDT_NMIENSET_STOPPED = 0x2
	// Read: Disabled
	WDT_NMIENSET_STOPPED_Disabled = 0x0
	// Read: Enabled
	WDT_NMIENSET_STOPPED_Enabled = 0x1
	// Enable
	WDT_NMIENSET_STOPPED_Set = 0x1

	// NMIENCLR: Disable interrupt
	// Position of TIMEOUT field.
	WDT_NMIENCLR_TIMEOUT_Pos = 0x0
	// Bit mask of TIMEOUT field.
	WDT_NMIENCLR_TIMEOUT_Msk = 0x1
	// Bit TIMEOUT.
	WDT_NMIENCLR_TIMEOUT = 0x1
	// Read: Disabled
	WDT_NMIENCLR_TIMEOUT_Disabled = 0x0
	// Read: Enabled
	WDT_NMIENCLR_TIMEOUT_Enabled = 0x1
	// Disable
	WDT_NMIENCLR_TIMEOUT_Clear = 0x1
	// Position of STOPPED field.
	WDT_NMIENCLR_STOPPED_Pos = 0x1
	// Bit mask of STOPPED field.
	WDT_NMIENCLR_STOPPED_Msk = 0x2
	// Bit STOPPED.
	WDT_NMIENCLR_STOPPED = 0x2
	// Read: Disabled
	WDT_NMIENCLR_STOPPED_Disabled = 0x0
	// Read: Enabled
	WDT_NMIENCLR_STOPPED_Enabled = 0x1
	// Disable
	WDT_NMIENCLR_STOPPED_Clear = 0x1

	// RUNSTATUS: Run status
	// Position of RUNSTATUSWDT field.
	WDT_RUNSTATUS_RUNSTATUSWDT_Pos = 0x0
	// Bit mask of RUNSTATUSWDT field.
	WDT_RUNSTATUS_RUNSTATUSWDT_Msk = 0x1
	// Bit RUNSTATUSWDT.
	WDT_RUNSTATUS_RUNSTATUSWDT = 0x1
	// Watchdog not running
	WDT_RUNSTATUS_RUNSTATUSWDT_NotRunning = 0x0
	// Watchdog is running
	WDT_RUNSTATUS_RUNSTATUSWDT_Running = 0x1

	// REQSTATUS: Request status
	// Position of RR0 field.
	WDT_REQSTATUS_RR0_Pos = 0x0
	// Bit mask of RR0 field.
	WDT_REQSTATUS_RR0_Msk = 0x1
	// Bit RR0.
	WDT_REQSTATUS_RR0 = 0x1
	// RR[0] register is not enabled, or are already requesting reload
	WDT_REQSTATUS_RR0_DisabledOrRequested = 0x0
	// RR[0] register is enabled, and are not yet requesting reload
	WDT_REQSTATUS_RR0_EnabledAndUnrequested = 0x1
	// Position of RR1 field.
	WDT_REQSTATUS_RR1_Pos = 0x1
	// Bit mask of RR1 field.
	WDT_REQSTATUS_RR1_Msk = 0x2
	// Bit RR1.
	WDT_REQSTATUS_RR1 = 0x2
	// RR[1] register is not enabled, or are already requesting reload
	WDT_REQSTATUS_RR1_DisabledOrRequested = 0x0
	// RR[1] register is enabled, and are not yet requesting reload
	WDT_REQSTATUS_RR1_EnabledAndUnrequested = 0x1
	// Position of RR2 field.
	WDT_REQSTATUS_RR2_Pos = 0x2
	// Bit mask of RR2 field.
	WDT_REQSTATUS_RR2_Msk = 0x4
	// Bit RR2.
	WDT_REQSTATUS_RR2 = 0x4
	// RR[2] register is not enabled, or are already requesting reload
	WDT_REQSTATUS_RR2_DisabledOrRequested = 0x0
	// RR[2] register is enabled, and are not yet requesting reload
	WDT_REQSTATUS_RR2_EnabledAndUnrequested = 0x1
	// Position of RR3 field.
	WDT_REQSTATUS_RR3_Pos = 0x3
	// Bit mask of RR3 field.
	WDT_REQSTATUS_RR3_Msk = 0x8
	// Bit RR3.
	WDT_REQSTATUS_RR3 = 0x8
	// RR[3] register is not enabled, or are already requesting reload
	WDT_REQSTATUS_RR3_DisabledOrRequested = 0x0
	// RR[3] register is enabled, and are not yet requesting reload
	WDT_REQSTATUS_RR3_EnabledAndUnrequested = 0x1
	// Position of RR4 field.
	WDT_REQSTATUS_RR4_Pos = 0x4
	// Bit mask of RR4 field.
	WDT_REQSTATUS_RR4_Msk = 0x10
	// Bit RR4.
	WDT_REQSTATUS_RR4 = 0x10
	// RR[4] register is not enabled, or are already requesting reload
	WDT_REQSTATUS_RR4_DisabledOrRequested = 0x0
	// RR[4] register is enabled, and are not yet requesting reload
	WDT_REQSTATUS_RR4_EnabledAndUnrequested = 0x1
	// Position of RR5 field.
	WDT_REQSTATUS_RR5_Pos = 0x5
	// Bit mask of RR5 field.
	WDT_REQSTATUS_RR5_Msk = 0x20
	// Bit RR5.
	WDT_REQSTATUS_RR5 = 0x20
	// RR[5] register is not enabled, or are already requesting reload
	WDT_REQSTATUS_RR5_DisabledOrRequested = 0x0
	// RR[5] register is enabled, and are not yet requesting reload
	WDT_REQSTATUS_RR5_EnabledAndUnrequested = 0x1
	// Position of RR6 field.
	WDT_REQSTATUS_RR6_Pos = 0x6
	// Bit mask of RR6 field.
	WDT_REQSTATUS_RR6_Msk = 0x40
	// Bit RR6.
	WDT_REQSTATUS_RR6 = 0x40
	// RR[6] register is not enabled, or are already requesting reload
	WDT_REQSTATUS_RR6_DisabledOrRequested = 0x0
	// RR[6] register is enabled, and are not yet requesting reload
	WDT_REQSTATUS_RR6_EnabledAndUnrequested = 0x1
	// Position of RR7 field.
	WDT_REQSTATUS_RR7_Pos = 0x7
	// Bit mask of RR7 field.
	WDT_REQSTATUS_RR7_Msk = 0x80
	// Bit RR7.
	WDT_REQSTATUS_RR7 = 0x80
	// RR[7] register is not enabled, or are already requesting reload
	WDT_REQSTATUS_RR7_DisabledOrRequested = 0x0
	// RR[7] register is enabled, and are not yet requesting reload
	WDT_REQSTATUS_RR7_EnabledAndUnrequested = 0x1

	// CRV: Counter reload value
	// Position of CRV field.
	WDT_CRV_CRV_Pos = 0x0
	// Bit mask of CRV field.
	WDT_CRV_CRV_Msk = 0xffffffff

	// RREN: Enable register for reload request registers
	// Position of RR0 field.
	WDT_RREN_RR0_Pos = 0x0
	// Bit mask of RR0 field.
	WDT_RREN_RR0_Msk = 0x1
	// Bit RR0.
	WDT_RREN_RR0 = 0x1
	// Disable RR[0] register
	WDT_RREN_RR0_Disabled = 0x0
	// Enable RR[0] register
	WDT_RREN_RR0_Enabled = 0x1
	// Position of RR1 field.
	WDT_RREN_RR1_Pos = 0x1
	// Bit mask of RR1 field.
	WDT_RREN_RR1_Msk = 0x2
	// Bit RR1.
	WDT_RREN_RR1 = 0x2
	// Disable RR[1] register
	WDT_RREN_RR1_Disabled = 0x0
	// Enable RR[1] register
	WDT_RREN_RR1_Enabled = 0x1
	// Position of RR2 field.
	WDT_RREN_RR2_Pos = 0x2
	// Bit mask of RR2 field.
	WDT_RREN_RR2_Msk = 0x4
	// Bit RR2.
	WDT_RREN_RR2 = 0x4
	// Disable RR[2] register
	WDT_RREN_RR2_Disabled = 0x0
	// Enable RR[2] register
	WDT_RREN_RR2_Enabled = 0x1
	// Position of RR3 field.
	WDT_RREN_RR3_Pos = 0x3
	// Bit mask of RR3 field.
	WDT_RREN_RR3_Msk = 0x8
	// Bit RR3.
	WDT_RREN_RR3 = 0x8
	// Disable RR[3] register
	WDT_RREN_RR3_Disabled = 0x0
	// Enable RR[3] register
	WDT_RREN_RR3_Enabled = 0x1
	// Position of RR4 field.
	WDT_RREN_RR4_Pos = 0x4
	// Bit mask of RR4 field.
	WDT_RREN_RR4_Msk = 0x10
	// Bit RR4.
	WDT_RREN_RR4 = 0x10
	// Disable RR[4] register
	WDT_RREN_RR4_Disabled = 0x0
	// Enable RR[4] register
	WDT_RREN_RR4_Enabled = 0x1
	// Position of RR5 field.
	WDT_RREN_RR5_Pos = 0x5
	// Bit mask of RR5 field.
	WDT_RREN_RR5_Msk = 0x20
	// Bit RR5.
	WDT_RREN_RR5 = 0x20
	// Disable RR[5] register
	WDT_RREN_RR5_Disabled = 0x0
	// Enable RR[5] register
	WDT_RREN_RR5_Enabled = 0x1
	// Position of RR6 field.
	WDT_RREN_RR6_Pos = 0x6
	// Bit mask of RR6 field.
	WDT_RREN_RR6_Msk = 0x40
	// Bit RR6.
	WDT_RREN_RR6 = 0x40
	// Disable RR[6] register
	WDT_RREN_RR6_Disabled = 0x0
	// Enable RR[6] register
	WDT_RREN_RR6_Enabled = 0x1
	// Position of RR7 field.
	WDT_RREN_RR7_Pos = 0x7
	// Bit mask of RR7 field.
	WDT_RREN_RR7_Msk = 0x80
	// Bit RR7.
	WDT_RREN_RR7 = 0x80
	// Disable RR[7] register
	WDT_RREN_RR7_Disabled = 0x0
	// Enable RR[7] register
	WDT_RREN_RR7_Enabled = 0x1

	// CONFIG: Configuration register
	// Position of SLEEP field.
	WDT_CONFIG_SLEEP_Pos = 0x0
	// Bit mask of SLEEP field.
	WDT_CONFIG_SLEEP_Msk = 0x1
	// Bit SLEEP.
	WDT_CONFIG_SLEEP = 0x1
	// Pause watchdog while the CPU is sleeping
	WDT_CONFIG_SLEEP_Pause = 0x0
	// Keep the watchdog running while the CPU is sleeping
	WDT_CONFIG_SLEEP_Run = 0x1
	// Position of HALT field.
	WDT_CONFIG_HALT_Pos = 0x3
	// Bit mask of HALT field.
	WDT_CONFIG_HALT_Msk = 0x8
	// Bit HALT.
	WDT_CONFIG_HALT = 0x8
	// Pause watchdog while the CPU is halted by the debugger
	WDT_CONFIG_HALT_Pause = 0x0
	// Keep the watchdog running while the CPU is halted by the debugger
	WDT_CONFIG_HALT_Run = 0x1
	// Position of STOPEN field.
	WDT_CONFIG_STOPEN_Pos = 0x6
	// Bit mask of STOPEN field.
	WDT_CONFIG_STOPEN_Msk = 0x40
	// Bit STOPEN.
	WDT_CONFIG_STOPEN = 0x40
	// Do not allow stopping the watchdog
	WDT_CONFIG_STOPEN_Disable = 0x0
	// Allow stopping the watchdog
	WDT_CONFIG_STOPEN_Enable = 0x1

	// TSEN: Task Stop Enable
	// Position of TSEN field.
	WDT_TSEN_TSEN_Pos = 0x0
	// Bit mask of TSEN field.
	WDT_TSEN_TSEN_Msk = 0xffffffff
	// Value to allow stopping the watchdog
	WDT_TSEN_TSEN_Enable = 0x6e524635

	// RR: Description collection: Reload request n
	// Position of RR field.
	WDT_RR_RR_Pos = 0x0
	// Bit mask of RR field.
	WDT_RR_RR_Msk = 0xffffffff
	// Value to request a reload of the watchdog timer
	WDT_RR_RR_Reload = 0x6e524635
)

// Constants for TIMER0_NS: Timer/Counter 0
const (
	// TASKS_START: Start Timer
	// Position of TASKS_START field.
	TIMER_TASKS_START_TASKS_START_Pos = 0x0
	// Bit mask of TASKS_START field.
	TIMER_TASKS_START_TASKS_START_Msk = 0x1
	// Bit TASKS_START.
	TIMER_TASKS_START_TASKS_START = 0x1
	// Trigger task
	TIMER_TASKS_START_TASKS_START_Trigger = 0x1

	// TASKS_STOP: Stop Timer
	// Position of TASKS_STOP field.
	TIMER_TASKS_STOP_TASKS_STOP_Pos = 0x0
	// Bit mask of TASKS_STOP field.
	TIMER_TASKS_STOP_TASKS_STOP_Msk = 0x1
	// Bit TASKS_STOP.
	TIMER_TASKS_STOP_TASKS_STOP = 0x1
	// Trigger task
	TIMER_TASKS_STOP_TASKS_STOP_Trigger = 0x1

	// TASKS_COUNT: Increment Timer (Counter mode only)
	// Position of TASKS_COUNT field.
	TIMER_TASKS_COUNT_TASKS_COUNT_Pos = 0x0
	// Bit mask of TASKS_COUNT field.
	TIMER_TASKS_COUNT_TASKS_COUNT_Msk = 0x1
	// Bit TASKS_COUNT.
	TIMER_TASKS_COUNT_TASKS_COUNT = 0x1
	// Trigger task
	TIMER_TASKS_COUNT_TASKS_COUNT_Trigger = 0x1

	// TASKS_CLEAR: Clear time
	// Position of TASKS_CLEAR field.
	TIMER_TASKS_CLEAR_TASKS_CLEAR_Pos = 0x0
	// Bit mask of TASKS_CLEAR field.
	TIMER_TASKS_CLEAR_TASKS_CLEAR_Msk = 0x1
	// Bit TASKS_CLEAR.
	TIMER_TASKS_CLEAR_TASKS_CLEAR = 0x1
	// Trigger task
	TIMER_TASKS_CLEAR_TASKS_CLEAR_Trigger = 0x1

	// TASKS_SHUTDOWN: Deprecated register - Shut down timer
	// Position of TASKS_SHUTDOWN field.
	TIMER_TASKS_SHUTDOWN_TASKS_SHUTDOWN_Pos = 0x0
	// Bit mask of TASKS_SHUTDOWN field.
	TIMER_TASKS_SHUTDOWN_TASKS_SHUTDOWN_Msk = 0x1
	// Bit TASKS_SHUTDOWN.
	TIMER_TASKS_SHUTDOWN_TASKS_SHUTDOWN = 0x1
	// Trigger task
	TIMER_TASKS_SHUTDOWN_TASKS_SHUTDOWN_Trigger = 0x1

	// TASKS_CAPTURE: Description collection: Capture Timer value to CC[n] register
	// Position of TASKS_CAPTURE field.
	TIMER_TASKS_CAPTURE_TASKS_CAPTURE_Pos = 0x0
	// Bit mask of TASKS_CAPTURE field.
	TIMER_TASKS_CAPTURE_TASKS_CAPTURE_Msk = 0x1
	// Bit TASKS_CAPTURE.
	TIMER_TASKS_CAPTURE_TASKS_CAPTURE = 0x1
	// Trigger task
	TIMER_TASKS_CAPTURE_TASKS_CAPTURE_Trigger = 0x1

	// SUBSCRIBE_START: Subscribe configuration for task START
	// Position of CHIDX field.
	TIMER_SUBSCRIBE_START_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	TIMER_SUBSCRIBE_START_CHIDX_Msk = 0xff
	// Position of EN field.
	TIMER_SUBSCRIBE_START_EN_Pos = 0x1f
	// Bit mask of EN field.
	TIMER_SUBSCRIBE_START_EN_Msk = 0x80000000
	// Bit EN.
	TIMER_SUBSCRIBE_START_EN = 0x80000000
	// Disable subscription
	TIMER_SUBSCRIBE_START_EN_Disabled = 0x0
	// Enable subscription
	TIMER_SUBSCRIBE_START_EN_Enabled = 0x1

	// SUBSCRIBE_STOP: Subscribe configuration for task STOP
	// Position of CHIDX field.
	TIMER_SUBSCRIBE_STOP_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	TIMER_SUBSCRIBE_STOP_CHIDX_Msk = 0xff
	// Position of EN field.
	TIMER_SUBSCRIBE_STOP_EN_Pos = 0x1f
	// Bit mask of EN field.
	TIMER_SUBSCRIBE_STOP_EN_Msk = 0x80000000
	// Bit EN.
	TIMER_SUBSCRIBE_STOP_EN = 0x80000000
	// Disable subscription
	TIMER_SUBSCRIBE_STOP_EN_Disabled = 0x0
	// Enable subscription
	TIMER_SUBSCRIBE_STOP_EN_Enabled = 0x1

	// SUBSCRIBE_COUNT: Subscribe configuration for task COUNT
	// Position of CHIDX field.
	TIMER_SUBSCRIBE_COUNT_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	TIMER_SUBSCRIBE_COUNT_CHIDX_Msk = 0xff
	// Position of EN field.
	TIMER_SUBSCRIBE_COUNT_EN_Pos = 0x1f
	// Bit mask of EN field.
	TIMER_SUBSCRIBE_COUNT_EN_Msk = 0x80000000
	// Bit EN.
	TIMER_SUBSCRIBE_COUNT_EN = 0x80000000
	// Disable subscription
	TIMER_SUBSCRIBE_COUNT_EN_Disabled = 0x0
	// Enable subscription
	TIMER_SUBSCRIBE_COUNT_EN_Enabled = 0x1

	// SUBSCRIBE_CLEAR: Subscribe configuration for task CLEAR
	// Position of CHIDX field.
	TIMER_SUBSCRIBE_CLEAR_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	TIMER_SUBSCRIBE_CLEAR_CHIDX_Msk = 0xff
	// Position of EN field.
	TIMER_SUBSCRIBE_CLEAR_EN_Pos = 0x1f
	// Bit mask of EN field.
	TIMER_SUBSCRIBE_CLEAR_EN_Msk = 0x80000000
	// Bit EN.
	TIMER_SUBSCRIBE_CLEAR_EN = 0x80000000
	// Disable subscription
	TIMER_SUBSCRIBE_CLEAR_EN_Disabled = 0x0
	// Enable subscription
	TIMER_SUBSCRIBE_CLEAR_EN_Enabled = 0x1

	// SUBSCRIBE_SHUTDOWN: Deprecated register - Subscribe configuration for task SHUTDOWN
	// Position of CHIDX field.
	TIMER_SUBSCRIBE_SHUTDOWN_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	TIMER_SUBSCRIBE_SHUTDOWN_CHIDX_Msk = 0xff
	// Position of EN field.
	TIMER_SUBSCRIBE_SHUTDOWN_EN_Pos = 0x1f
	// Bit mask of EN field.
	TIMER_SUBSCRIBE_SHUTDOWN_EN_Msk = 0x80000000
	// Bit EN.
	TIMER_SUBSCRIBE_SHUTDOWN_EN = 0x80000000
	// Disable subscription
	TIMER_SUBSCRIBE_SHUTDOWN_EN_Disabled = 0x0
	// Enable subscription
	TIMER_SUBSCRIBE_SHUTDOWN_EN_Enabled = 0x1

	// SUBSCRIBE_CAPTURE: Description collection: Subscribe configuration for task CAPTURE[n]
	// Position of CHIDX field.
	TIMER_SUBSCRIBE_CAPTURE_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	TIMER_SUBSCRIBE_CAPTURE_CHIDX_Msk = 0xff
	// Position of EN field.
	TIMER_SUBSCRIBE_CAPTURE_EN_Pos = 0x1f
	// Bit mask of EN field.
	TIMER_SUBSCRIBE_CAPTURE_EN_Msk = 0x80000000
	// Bit EN.
	TIMER_SUBSCRIBE_CAPTURE_EN = 0x80000000
	// Disable subscription
	TIMER_SUBSCRIBE_CAPTURE_EN_Disabled = 0x0
	// Enable subscription
	TIMER_SUBSCRIBE_CAPTURE_EN_Enabled = 0x1

	// EVENTS_COMPARE: Description collection: Compare event on CC[n] match
	// Position of EVENTS_COMPARE field.
	TIMER_EVENTS_COMPARE_EVENTS_COMPARE_Pos = 0x0
	// Bit mask of EVENTS_COMPARE field.
	TIMER_EVENTS_COMPARE_EVENTS_COMPARE_Msk = 0x1
	// Bit EVENTS_COMPARE.
	TIMER_EVENTS_COMPARE_EVENTS_COMPARE = 0x1
	// Event not generated
	TIMER_EVENTS_COMPARE_EVENTS_COMPARE_NotGenerated = 0x0
	// Event generated
	TIMER_EVENTS_COMPARE_EVENTS_COMPARE_Generated = 0x1

	// PUBLISH_COMPARE: Description collection: Publish configuration for event COMPARE[n]
	// Position of CHIDX field.
	TIMER_PUBLISH_COMPARE_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	TIMER_PUBLISH_COMPARE_CHIDX_Msk = 0xff
	// Position of EN field.
	TIMER_PUBLISH_COMPARE_EN_Pos = 0x1f
	// Bit mask of EN field.
	TIMER_PUBLISH_COMPARE_EN_Msk = 0x80000000
	// Bit EN.
	TIMER_PUBLISH_COMPARE_EN = 0x80000000
	// Disable publishing
	TIMER_PUBLISH_COMPARE_EN_Disabled = 0x0
	// Enable publishing
	TIMER_PUBLISH_COMPARE_EN_Enabled = 0x1

	// SHORTS: Shortcuts between local events and tasks
	// Position of COMPARE0_CLEAR field.
	TIMER_SHORTS_COMPARE0_CLEAR_Pos = 0x0
	// Bit mask of COMPARE0_CLEAR field.
	TIMER_SHORTS_COMPARE0_CLEAR_Msk = 0x1
	// Bit COMPARE0_CLEAR.
	TIMER_SHORTS_COMPARE0_CLEAR = 0x1
	// Disable shortcut
	TIMER_SHORTS_COMPARE0_CLEAR_Disabled = 0x0
	// Enable shortcut
	TIMER_SHORTS_COMPARE0_CLEAR_Enabled = 0x1
	// Position of COMPARE1_CLEAR field.
	TIMER_SHORTS_COMPARE1_CLEAR_Pos = 0x1
	// Bit mask of COMPARE1_CLEAR field.
	TIMER_SHORTS_COMPARE1_CLEAR_Msk = 0x2
	// Bit COMPARE1_CLEAR.
	TIMER_SHORTS_COMPARE1_CLEAR = 0x2
	// Disable shortcut
	TIMER_SHORTS_COMPARE1_CLEAR_Disabled = 0x0
	// Enable shortcut
	TIMER_SHORTS_COMPARE1_CLEAR_Enabled = 0x1
	// Position of COMPARE2_CLEAR field.
	TIMER_SHORTS_COMPARE2_CLEAR_Pos = 0x2
	// Bit mask of COMPARE2_CLEAR field.
	TIMER_SHORTS_COMPARE2_CLEAR_Msk = 0x4
	// Bit COMPARE2_CLEAR.
	TIMER_SHORTS_COMPARE2_CLEAR = 0x4
	// Disable shortcut
	TIMER_SHORTS_COMPARE2_CLEAR_Disabled = 0x0
	// Enable shortcut
	TIMER_SHORTS_COMPARE2_CLEAR_Enabled = 0x1
	// Position of COMPARE3_CLEAR field.
	TIMER_SHORTS_COMPARE3_CLEAR_Pos = 0x3
	// Bit mask of COMPARE3_CLEAR field.
	TIMER_SHORTS_COMPARE3_CLEAR_Msk = 0x8
	// Bit COMPARE3_CLEAR.
	TIMER_SHORTS_COMPARE3_CLEAR = 0x8
	// Disable shortcut
	TIMER_SHORTS_COMPARE3_CLEAR_Disabled = 0x0
	// Enable shortcut
	TIMER_SHORTS_COMPARE3_CLEAR_Enabled = 0x1
	// Position of COMPARE4_CLEAR field.
	TIMER_SHORTS_COMPARE4_CLEAR_Pos = 0x4
	// Bit mask of COMPARE4_CLEAR field.
	TIMER_SHORTS_COMPARE4_CLEAR_Msk = 0x10
	// Bit COMPARE4_CLEAR.
	TIMER_SHORTS_COMPARE4_CLEAR = 0x10
	// Disable shortcut
	TIMER_SHORTS_COMPARE4_CLEAR_Disabled = 0x0
	// Enable shortcut
	TIMER_SHORTS_COMPARE4_CLEAR_Enabled = 0x1
	// Position of COMPARE5_CLEAR field.
	TIMER_SHORTS_COMPARE5_CLEAR_Pos = 0x5
	// Bit mask of COMPARE5_CLEAR field.
	TIMER_SHORTS_COMPARE5_CLEAR_Msk = 0x20
	// Bit COMPARE5_CLEAR.
	TIMER_SHORTS_COMPARE5_CLEAR = 0x20
	// Disable shortcut
	TIMER_SHORTS_COMPARE5_CLEAR_Disabled = 0x0
	// Enable shortcut
	TIMER_SHORTS_COMPARE5_CLEAR_Enabled = 0x1
	// Position of COMPARE6_CLEAR field.
	TIMER_SHORTS_COMPARE6_CLEAR_Pos = 0x6
	// Bit mask of COMPARE6_CLEAR field.
	TIMER_SHORTS_COMPARE6_CLEAR_Msk = 0x40
	// Bit COMPARE6_CLEAR.
	TIMER_SHORTS_COMPARE6_CLEAR = 0x40
	// Disable shortcut
	TIMER_SHORTS_COMPARE6_CLEAR_Disabled = 0x0
	// Enable shortcut
	TIMER_SHORTS_COMPARE6_CLEAR_Enabled = 0x1
	// Position of COMPARE7_CLEAR field.
	TIMER_SHORTS_COMPARE7_CLEAR_Pos = 0x7
	// Bit mask of COMPARE7_CLEAR field.
	TIMER_SHORTS_COMPARE7_CLEAR_Msk = 0x80
	// Bit COMPARE7_CLEAR.
	TIMER_SHORTS_COMPARE7_CLEAR = 0x80
	// Disable shortcut
	TIMER_SHORTS_COMPARE7_CLEAR_Disabled = 0x0
	// Enable shortcut
	TIMER_SHORTS_COMPARE7_CLEAR_Enabled = 0x1
	// Position of COMPARE0_STOP field.
	TIMER_SHORTS_COMPARE0_STOP_Pos = 0x10
	// Bit mask of COMPARE0_STOP field.
	TIMER_SHORTS_COMPARE0_STOP_Msk = 0x10000
	// Bit COMPARE0_STOP.
	TIMER_SHORTS_COMPARE0_STOP = 0x10000
	// Disable shortcut
	TIMER_SHORTS_COMPARE0_STOP_Disabled = 0x0
	// Enable shortcut
	TIMER_SHORTS_COMPARE0_STOP_Enabled = 0x1
	// Position of COMPARE1_STOP field.
	TIMER_SHORTS_COMPARE1_STOP_Pos = 0x11
	// Bit mask of COMPARE1_STOP field.
	TIMER_SHORTS_COMPARE1_STOP_Msk = 0x20000
	// Bit COMPARE1_STOP.
	TIMER_SHORTS_COMPARE1_STOP = 0x20000
	// Disable shortcut
	TIMER_SHORTS_COMPARE1_STOP_Disabled = 0x0
	// Enable shortcut
	TIMER_SHORTS_COMPARE1_STOP_Enabled = 0x1
	// Position of COMPARE2_STOP field.
	TIMER_SHORTS_COMPARE2_STOP_Pos = 0x12
	// Bit mask of COMPARE2_STOP field.
	TIMER_SHORTS_COMPARE2_STOP_Msk = 0x40000
	// Bit COMPARE2_STOP.
	TIMER_SHORTS_COMPARE2_STOP = 0x40000
	// Disable shortcut
	TIMER_SHORTS_COMPARE2_STOP_Disabled = 0x0
	// Enable shortcut
	TIMER_SHORTS_COMPARE2_STOP_Enabled = 0x1
	// Position of COMPARE3_STOP field.
	TIMER_SHORTS_COMPARE3_STOP_Pos = 0x13
	// Bit mask of COMPARE3_STOP field.
	TIMER_SHORTS_COMPARE3_STOP_Msk = 0x80000
	// Bit COMPARE3_STOP.
	TIMER_SHORTS_COMPARE3_STOP = 0x80000
	// Disable shortcut
	TIMER_SHORTS_COMPARE3_STOP_Disabled = 0x0
	// Enable shortcut
	TIMER_SHORTS_COMPARE3_STOP_Enabled = 0x1
	// Position of COMPARE4_STOP field.
	TIMER_SHORTS_COMPARE4_STOP_Pos = 0x14
	// Bit mask of COMPARE4_STOP field.
	TIMER_SHORTS_COMPARE4_STOP_Msk = 0x100000
	// Bit COMPARE4_STOP.
	TIMER_SHORTS_COMPARE4_STOP = 0x100000
	// Disable shortcut
	TIMER_SHORTS_COMPARE4_STOP_Disabled = 0x0
	// Enable shortcut
	TIMER_SHORTS_COMPARE4_STOP_Enabled = 0x1
	// Position of COMPARE5_STOP field.
	TIMER_SHORTS_COMPARE5_STOP_Pos = 0x15
	// Bit mask of COMPARE5_STOP field.
	TIMER_SHORTS_COMPARE5_STOP_Msk = 0x200000
	// Bit COMPARE5_STOP.
	TIMER_SHORTS_COMPARE5_STOP = 0x200000
	// Disable shortcut
	TIMER_SHORTS_COMPARE5_STOP_Disabled = 0x0
	// Enable shortcut
	TIMER_SHORTS_COMPARE5_STOP_Enabled = 0x1
	// Position of COMPARE6_STOP field.
	TIMER_SHORTS_COMPARE6_STOP_Pos = 0x16
	// Bit mask of COMPARE6_STOP field.
	TIMER_SHORTS_COMPARE6_STOP_Msk = 0x400000
	// Bit COMPARE6_STOP.
	TIMER_SHORTS_COMPARE6_STOP = 0x400000
	// Disable shortcut
	TIMER_SHORTS_COMPARE6_STOP_Disabled = 0x0
	// Enable shortcut
	TIMER_SHORTS_COMPARE6_STOP_Enabled = 0x1
	// Position of COMPARE7_STOP field.
	TIMER_SHORTS_COMPARE7_STOP_Pos = 0x17
	// Bit mask of COMPARE7_STOP field.
	TIMER_SHORTS_COMPARE7_STOP_Msk = 0x800000
	// Bit COMPARE7_STOP.
	TIMER_SHORTS_COMPARE7_STOP = 0x800000
	// Disable shortcut
	TIMER_SHORTS_COMPARE7_STOP_Disabled = 0x0
	// Enable shortcut
	TIMER_SHORTS_COMPARE7_STOP_Enabled = 0x1

	// INTEN: Enable or disable interrupt
	// Position of COMPARE0 field.
	TIMER_INTEN_COMPARE0_Pos = 0x10
	// Bit mask of COMPARE0 field.
	TIMER_INTEN_COMPARE0_Msk = 0x10000
	// Bit COMPARE0.
	TIMER_INTEN_COMPARE0 = 0x10000
	// Disable
	TIMER_INTEN_COMPARE0_Disabled = 0x0
	// Enable
	TIMER_INTEN_COMPARE0_Enabled = 0x1
	// Position of COMPARE1 field.
	TIMER_INTEN_COMPARE1_Pos = 0x11
	// Bit mask of COMPARE1 field.
	TIMER_INTEN_COMPARE1_Msk = 0x20000
	// Bit COMPARE1.
	TIMER_INTEN_COMPARE1 = 0x20000
	// Disable
	TIMER_INTEN_COMPARE1_Disabled = 0x0
	// Enable
	TIMER_INTEN_COMPARE1_Enabled = 0x1
	// Position of COMPARE2 field.
	TIMER_INTEN_COMPARE2_Pos = 0x12
	// Bit mask of COMPARE2 field.
	TIMER_INTEN_COMPARE2_Msk = 0x40000
	// Bit COMPARE2.
	TIMER_INTEN_COMPARE2 = 0x40000
	// Disable
	TIMER_INTEN_COMPARE2_Disabled = 0x0
	// Enable
	TIMER_INTEN_COMPARE2_Enabled = 0x1
	// Position of COMPARE3 field.
	TIMER_INTEN_COMPARE3_Pos = 0x13
	// Bit mask of COMPARE3 field.
	TIMER_INTEN_COMPARE3_Msk = 0x80000
	// Bit COMPARE3.
	TIMER_INTEN_COMPARE3 = 0x80000
	// Disable
	TIMER_INTEN_COMPARE3_Disabled = 0x0
	// Enable
	TIMER_INTEN_COMPARE3_Enabled = 0x1
	// Position of COMPARE4 field.
	TIMER_INTEN_COMPARE4_Pos = 0x14
	// Bit mask of COMPARE4 field.
	TIMER_INTEN_COMPARE4_Msk = 0x100000
	// Bit COMPARE4.
	TIMER_INTEN_COMPARE4 = 0x100000
	// Disable
	TIMER_INTEN_COMPARE4_Disabled = 0x0
	// Enable
	TIMER_INTEN_COMPARE4_Enabled = 0x1
	// Position of COMPARE5 field.
	TIMER_INTEN_COMPARE5_Pos = 0x15
	// Bit mask of COMPARE5 field.
	TIMER_INTEN_COMPARE5_Msk = 0x200000
	// Bit COMPARE5.
	TIMER_INTEN_COMPARE5 = 0x200000
	// Disable
	TIMER_INTEN_COMPARE5_Disabled = 0x0
	// Enable
	TIMER_INTEN_COMPARE5_Enabled = 0x1
	// Position of COMPARE6 field.
	TIMER_INTEN_COMPARE6_Pos = 0x16
	// Bit mask of COMPARE6 field.
	TIMER_INTEN_COMPARE6_Msk = 0x400000
	// Bit COMPARE6.
	TIMER_INTEN_COMPARE6 = 0x400000
	// Disable
	TIMER_INTEN_COMPARE6_Disabled = 0x0
	// Enable
	TIMER_INTEN_COMPARE6_Enabled = 0x1
	// Position of COMPARE7 field.
	TIMER_INTEN_COMPARE7_Pos = 0x17
	// Bit mask of COMPARE7 field.
	TIMER_INTEN_COMPARE7_Msk = 0x800000
	// Bit COMPARE7.
	TIMER_INTEN_COMPARE7 = 0x800000
	// Disable
	TIMER_INTEN_COMPARE7_Disabled = 0x0
	// Enable
	TIMER_INTEN_COMPARE7_Enabled = 0x1

	// INTENSET: Enable interrupt
	// Position of COMPARE0 field.
	TIMER_INTENSET_COMPARE0_Pos = 0x10
	// Bit mask of COMPARE0 field.
	TIMER_INTENSET_COMPARE0_Msk = 0x10000
	// Bit COMPARE0.
	TIMER_INTENSET_COMPARE0 = 0x10000
	// Read: Disabled
	TIMER_INTENSET_COMPARE0_Disabled = 0x0
	// Read: Enabled
	TIMER_INTENSET_COMPARE0_Enabled = 0x1
	// Enable
	TIMER_INTENSET_COMPARE0_Set = 0x1
	// Position of COMPARE1 field.
	TIMER_INTENSET_COMPARE1_Pos = 0x11
	// Bit mask of COMPARE1 field.
	TIMER_INTENSET_COMPARE1_Msk = 0x20000
	// Bit COMPARE1.
	TIMER_INTENSET_COMPARE1 = 0x20000
	// Read: Disabled
	TIMER_INTENSET_COMPARE1_Disabled = 0x0
	// Read: Enabled
	TIMER_INTENSET_COMPARE1_Enabled = 0x1
	// Enable
	TIMER_INTENSET_COMPARE1_Set = 0x1
	// Position of COMPARE2 field.
	TIMER_INTENSET_COMPARE2_Pos = 0x12
	// Bit mask of COMPARE2 field.
	TIMER_INTENSET_COMPARE2_Msk = 0x40000
	// Bit COMPARE2.
	TIMER_INTENSET_COMPARE2 = 0x40000
	// Read: Disabled
	TIMER_INTENSET_COMPARE2_Disabled = 0x0
	// Read: Enabled
	TIMER_INTENSET_COMPARE2_Enabled = 0x1
	// Enable
	TIMER_INTENSET_COMPARE2_Set = 0x1
	// Position of COMPARE3 field.
	TIMER_INTENSET_COMPARE3_Pos = 0x13
	// Bit mask of COMPARE3 field.
	TIMER_INTENSET_COMPARE3_Msk = 0x80000
	// Bit COMPARE3.
	TIMER_INTENSET_COMPARE3 = 0x80000
	// Read: Disabled
	TIMER_INTENSET_COMPARE3_Disabled = 0x0
	// Read: Enabled
	TIMER_INTENSET_COMPARE3_Enabled = 0x1
	// Enable
	TIMER_INTENSET_COMPARE3_Set = 0x1
	// Position of COMPARE4 field.
	TIMER_INTENSET_COMPARE4_Pos = 0x14
	// Bit mask of COMPARE4 field.
	TIMER_INTENSET_COMPARE4_Msk = 0x100000
	// Bit COMPARE4.
	TIMER_INTENSET_COMPARE4 = 0x100000
	// Read: Disabled
	TIMER_INTENSET_COMPARE4_Disabled = 0x0
	// Read: Enabled
	TIMER_INTENSET_COMPARE4_Enabled = 0x1
	// Enable
	TIMER_INTENSET_COMPARE4_Set = 0x1
	// Position of COMPARE5 field.
	TIMER_INTENSET_COMPARE5_Pos = 0x15
	// Bit mask of COMPARE5 field.
	TIMER_INTENSET_COMPARE5_Msk = 0x200000
	// Bit COMPARE5.
	TIMER_INTENSET_COMPARE5 = 0x200000
	// Read: Disabled
	TIMER_INTENSET_COMPARE5_Disabled = 0x0
	// Read: Enabled
	TIMER_INTENSET_COMPARE5_Enabled = 0x1
	// Enable
	TIMER_INTENSET_COMPARE5_Set = 0x1
	// Position of COMPARE6 field.
	TIMER_INTENSET_COMPARE6_Pos = 0x16
	// Bit mask of COMPARE6 field.
	TIMER_INTENSET_COMPARE6_Msk = 0x400000
	// Bit COMPARE6.
	TIMER_INTENSET_COMPARE6 = 0x400000
	// Read: Disabled
	TIMER_INTENSET_COMPARE6_Disabled = 0x0
	// Read: Enabled
	TIMER_INTENSET_COMPARE6_Enabled = 0x1
	// Enable
	TIMER_INTENSET_COMPARE6_Set = 0x1
	// Position of COMPARE7 field.
	TIMER_INTENSET_COMPARE7_Pos = 0x17
	// Bit mask of COMPARE7 field.
	TIMER_INTENSET_COMPARE7_Msk = 0x800000
	// Bit COMPARE7.
	TIMER_INTENSET_COMPARE7 = 0x800000
	// Read: Disabled
	TIMER_INTENSET_COMPARE7_Disabled = 0x0
	// Read: Enabled
	TIMER_INTENSET_COMPARE7_Enabled = 0x1
	// Enable
	TIMER_INTENSET_COMPARE7_Set = 0x1

	// INTENCLR: Disable interrupt
	// Position of COMPARE0 field.
	TIMER_INTENCLR_COMPARE0_Pos = 0x10
	// Bit mask of COMPARE0 field.
	TIMER_INTENCLR_COMPARE0_Msk = 0x10000
	// Bit COMPARE0.
	TIMER_INTENCLR_COMPARE0 = 0x10000
	// Read: Disabled
	TIMER_INTENCLR_COMPARE0_Disabled = 0x0
	// Read: Enabled
	TIMER_INTENCLR_COMPARE0_Enabled = 0x1
	// Disable
	TIMER_INTENCLR_COMPARE0_Clear = 0x1
	// Position of COMPARE1 field.
	TIMER_INTENCLR_COMPARE1_Pos = 0x11
	// Bit mask of COMPARE1 field.
	TIMER_INTENCLR_COMPARE1_Msk = 0x20000
	// Bit COMPARE1.
	TIMER_INTENCLR_COMPARE1 = 0x20000
	// Read: Disabled
	TIMER_INTENCLR_COMPARE1_Disabled = 0x0
	// Read: Enabled
	TIMER_INTENCLR_COMPARE1_Enabled = 0x1
	// Disable
	TIMER_INTENCLR_COMPARE1_Clear = 0x1
	// Position of COMPARE2 field.
	TIMER_INTENCLR_COMPARE2_Pos = 0x12
	// Bit mask of COMPARE2 field.
	TIMER_INTENCLR_COMPARE2_Msk = 0x40000
	// Bit COMPARE2.
	TIMER_INTENCLR_COMPARE2 = 0x40000
	// Read: Disabled
	TIMER_INTENCLR_COMPARE2_Disabled = 0x0
	// Read: Enabled
	TIMER_INTENCLR_COMPARE2_Enabled = 0x1
	// Disable
	TIMER_INTENCLR_COMPARE2_Clear = 0x1
	// Position of COMPARE3 field.
	TIMER_INTENCLR_COMPARE3_Pos = 0x13
	// Bit mask of COMPARE3 field.
	TIMER_INTENCLR_COMPARE3_Msk = 0x80000
	// Bit COMPARE3.
	TIMER_INTENCLR_COMPARE3 = 0x80000
	// Read: Disabled
	TIMER_INTENCLR_COMPARE3_Disabled = 0x0
	// Read: Enabled
	TIMER_INTENCLR_COMPARE3_Enabled = 0x1
	// Disable
	TIMER_INTENCLR_COMPARE3_Clear = 0x1
	// Position of COMPARE4 field.
	TIMER_INTENCLR_COMPARE4_Pos = 0x14
	// Bit mask of COMPARE4 field.
	TIMER_INTENCLR_COMPARE4_Msk = 0x100000
	// Bit COMPARE4.
	TIMER_INTENCLR_COMPARE4 = 0x100000
	// Read: Disabled
	TIMER_INTENCLR_COMPARE4_Disabled = 0x0
	// Read: Enabled
	TIMER_INTENCLR_COMPARE4_Enabled = 0x1
	// Disable
	TIMER_INTENCLR_COMPARE4_Clear = 0x1
	// Position of COMPARE5 field.
	TIMER_INTENCLR_COMPARE5_Pos = 0x15
	// Bit mask of COMPARE5 field.
	TIMER_INTENCLR_COMPARE5_Msk = 0x200000
	// Bit COMPARE5.
	TIMER_INTENCLR_COMPARE5 = 0x200000
	// Read: Disabled
	TIMER_INTENCLR_COMPARE5_Disabled = 0x0
	// Read: Enabled
	TIMER_INTENCLR_COMPARE5_Enabled = 0x1
	// Disable
	TIMER_INTENCLR_COMPARE5_Clear = 0x1
	// Position of COMPARE6 field.
	TIMER_INTENCLR_COMPARE6_Pos = 0x16
	// Bit mask of COMPARE6 field.
	TIMER_INTENCLR_COMPARE6_Msk = 0x400000
	// Bit COMPARE6.
	TIMER_INTENCLR_COMPARE6 = 0x400000
	// Read: Disabled
	TIMER_INTENCLR_COMPARE6_Disabled = 0x0
	// Read: Enabled
	TIMER_INTENCLR_COMPARE6_Enabled = 0x1
	// Disable
	TIMER_INTENCLR_COMPARE6_Clear = 0x1
	// Position of COMPARE7 field.
	TIMER_INTENCLR_COMPARE7_Pos = 0x17
	// Bit mask of COMPARE7 field.
	TIMER_INTENCLR_COMPARE7_Msk = 0x800000
	// Bit COMPARE7.
	TIMER_INTENCLR_COMPARE7 = 0x800000
	// Read: Disabled
	TIMER_INTENCLR_COMPARE7_Disabled = 0x0
	// Read: Enabled
	TIMER_INTENCLR_COMPARE7_Enabled = 0x1
	// Disable
	TIMER_INTENCLR_COMPARE7_Clear = 0x1

	// MODE: Timer mode selection
	// Position of MODE field.
	TIMER_MODE_MODE_Pos = 0x0
	// Bit mask of MODE field.
	TIMER_MODE_MODE_Msk = 0x3
	// Select Timer mode
	TIMER_MODE_MODE_Timer = 0x0
	// Deprecated enumerator - Select Counter mode
	TIMER_MODE_MODE_Counter = 0x1
	// Select Low Power Counter mode
	TIMER_MODE_MODE_LowPowerCounter = 0x2

	// BITMODE: Configure the number of bits used by the TIMER
	// Position of BITMODE field.
	TIMER_BITMODE_BITMODE_Pos = 0x0
	// Bit mask of BITMODE field.
	TIMER_BITMODE_BITMODE_Msk = 0x3
	// 16 bit timer bit width
	TIMER_BITMODE_BITMODE_16Bit = 0x0
	// 8 bit timer bit width
	TIMER_BITMODE_BITMODE_08Bit = 0x1
	// 24 bit timer bit width
	TIMER_BITMODE_BITMODE_24Bit = 0x2
	// 32 bit timer bit width
	TIMER_BITMODE_BITMODE_32Bit = 0x3

	// PRESCALER: Timer prescaler register
	// Position of PRESCALER field.
	TIMER_PRESCALER_PRESCALER_Pos = 0x0
	// Bit mask of PRESCALER field.
	TIMER_PRESCALER_PRESCALER_Msk = 0xf

	// CC: Description collection: Capture/Compare register n
	// Position of CC field.
	TIMER_CC_CC_Pos = 0x0
	// Bit mask of CC field.
	TIMER_CC_CC_Msk = 0xffffffff

	// ONESHOTEN: Description collection: Enable one-shot operation for Capture/Compare channel n
	// Position of ONESHOTEN field.
	TIMER_ONESHOTEN_ONESHOTEN_Pos = 0x0
	// Bit mask of ONESHOTEN field.
	TIMER_ONESHOTEN_ONESHOTEN_Msk = 0x1
	// Bit ONESHOTEN.
	TIMER_ONESHOTEN_ONESHOTEN = 0x1
	// Disable one-shot operation
	TIMER_ONESHOTEN_ONESHOTEN_Disable = 0x0
	// Enable one-shot operation
	TIMER_ONESHOTEN_ONESHOTEN_Enable = 0x1
)

// Constants for ECB_NS: AES ECB Mode Encryption
const (
	// TASKS_STARTECB: Start ECB block encrypt
	// Position of TASKS_STARTECB field.
	ECB_TASKS_STARTECB_TASKS_STARTECB_Pos = 0x0
	// Bit mask of TASKS_STARTECB field.
	ECB_TASKS_STARTECB_TASKS_STARTECB_Msk = 0x1
	// Bit TASKS_STARTECB.
	ECB_TASKS_STARTECB_TASKS_STARTECB = 0x1
	// Trigger task
	ECB_TASKS_STARTECB_TASKS_STARTECB_Trigger = 0x1

	// TASKS_STOPECB: Abort a possible executing ECB operation
	// Position of TASKS_STOPECB field.
	ECB_TASKS_STOPECB_TASKS_STOPECB_Pos = 0x0
	// Bit mask of TASKS_STOPECB field.
	ECB_TASKS_STOPECB_TASKS_STOPECB_Msk = 0x1
	// Bit TASKS_STOPECB.
	ECB_TASKS_STOPECB_TASKS_STOPECB = 0x1
	// Trigger task
	ECB_TASKS_STOPECB_TASKS_STOPECB_Trigger = 0x1

	// SUBSCRIBE_STARTECB: Subscribe configuration for task STARTECB
	// Position of CHIDX field.
	ECB_SUBSCRIBE_STARTECB_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	ECB_SUBSCRIBE_STARTECB_CHIDX_Msk = 0xff
	// Position of EN field.
	ECB_SUBSCRIBE_STARTECB_EN_Pos = 0x1f
	// Bit mask of EN field.
	ECB_SUBSCRIBE_STARTECB_EN_Msk = 0x80000000
	// Bit EN.
	ECB_SUBSCRIBE_STARTECB_EN = 0x80000000
	// Disable subscription
	ECB_SUBSCRIBE_STARTECB_EN_Disabled = 0x0
	// Enable subscription
	ECB_SUBSCRIBE_STARTECB_EN_Enabled = 0x1

	// SUBSCRIBE_STOPECB: Subscribe configuration for task STOPECB
	// Position of CHIDX field.
	ECB_SUBSCRIBE_STOPECB_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	ECB_SUBSCRIBE_STOPECB_CHIDX_Msk = 0xff
	// Position of EN field.
	ECB_SUBSCRIBE_STOPECB_EN_Pos = 0x1f
	// Bit mask of EN field.
	ECB_SUBSCRIBE_STOPECB_EN_Msk = 0x80000000
	// Bit EN.
	ECB_SUBSCRIBE_STOPECB_EN = 0x80000000
	// Disable subscription
	ECB_SUBSCRIBE_STOPECB_EN_Disabled = 0x0
	// Enable subscription
	ECB_SUBSCRIBE_STOPECB_EN_Enabled = 0x1

	// EVENTS_ENDECB: ECB block encrypt complete
	// Position of EVENTS_ENDECB field.
	ECB_EVENTS_ENDECB_EVENTS_ENDECB_Pos = 0x0
	// Bit mask of EVENTS_ENDECB field.
	ECB_EVENTS_ENDECB_EVENTS_ENDECB_Msk = 0x1
	// Bit EVENTS_ENDECB.
	ECB_EVENTS_ENDECB_EVENTS_ENDECB = 0x1
	// Event not generated
	ECB_EVENTS_ENDECB_EVENTS_ENDECB_NotGenerated = 0x0
	// Event generated
	ECB_EVENTS_ENDECB_EVENTS_ENDECB_Generated = 0x1

	// EVENTS_ERRORECB: ECB block encrypt aborted because of a STOPECB task or due to an error
	// Position of EVENTS_ERRORECB field.
	ECB_EVENTS_ERRORECB_EVENTS_ERRORECB_Pos = 0x0
	// Bit mask of EVENTS_ERRORECB field.
	ECB_EVENTS_ERRORECB_EVENTS_ERRORECB_Msk = 0x1
	// Bit EVENTS_ERRORECB.
	ECB_EVENTS_ERRORECB_EVENTS_ERRORECB = 0x1
	// Event not generated
	ECB_EVENTS_ERRORECB_EVENTS_ERRORECB_NotGenerated = 0x0
	// Event generated
	ECB_EVENTS_ERRORECB_EVENTS_ERRORECB_Generated = 0x1

	// PUBLISH_ENDECB: Publish configuration for event ENDECB
	// Position of CHIDX field.
	ECB_PUBLISH_ENDECB_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	ECB_PUBLISH_ENDECB_CHIDX_Msk = 0xff
	// Position of EN field.
	ECB_PUBLISH_ENDECB_EN_Pos = 0x1f
	// Bit mask of EN field.
	ECB_PUBLISH_ENDECB_EN_Msk = 0x80000000
	// Bit EN.
	ECB_PUBLISH_ENDECB_EN = 0x80000000
	// Disable publishing
	ECB_PUBLISH_ENDECB_EN_Disabled = 0x0
	// Enable publishing
	ECB_PUBLISH_ENDECB_EN_Enabled = 0x1

	// PUBLISH_ERRORECB: Publish configuration for event ERRORECB
	// Position of CHIDX field.
	ECB_PUBLISH_ERRORECB_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	ECB_PUBLISH_ERRORECB_CHIDX_Msk = 0xff
	// Position of EN field.
	ECB_PUBLISH_ERRORECB_EN_Pos = 0x1f
	// Bit mask of EN field.
	ECB_PUBLISH_ERRORECB_EN_Msk = 0x80000000
	// Bit EN.
	ECB_PUBLISH_ERRORECB_EN = 0x80000000
	// Disable publishing
	ECB_PUBLISH_ERRORECB_EN_Disabled = 0x0
	// Enable publishing
	ECB_PUBLISH_ERRORECB_EN_Enabled = 0x1

	// INTENSET: Enable interrupt
	// Position of ENDECB field.
	ECB_INTENSET_ENDECB_Pos = 0x0
	// Bit mask of ENDECB field.
	ECB_INTENSET_ENDECB_Msk = 0x1
	// Bit ENDECB.
	ECB_INTENSET_ENDECB = 0x1
	// Read: Disabled
	ECB_INTENSET_ENDECB_Disabled = 0x0
	// Read: Enabled
	ECB_INTENSET_ENDECB_Enabled = 0x1
	// Enable
	ECB_INTENSET_ENDECB_Set = 0x1
	// Position of ERRORECB field.
	ECB_INTENSET_ERRORECB_Pos = 0x1
	// Bit mask of ERRORECB field.
	ECB_INTENSET_ERRORECB_Msk = 0x2
	// Bit ERRORECB.
	ECB_INTENSET_ERRORECB = 0x2
	// Read: Disabled
	ECB_INTENSET_ERRORECB_Disabled = 0x0
	// Read: Enabled
	ECB_INTENSET_ERRORECB_Enabled = 0x1
	// Enable
	ECB_INTENSET_ERRORECB_Set = 0x1

	// INTENCLR: Disable interrupt
	// Position of ENDECB field.
	ECB_INTENCLR_ENDECB_Pos = 0x0
	// Bit mask of ENDECB field.
	ECB_INTENCLR_ENDECB_Msk = 0x1
	// Bit ENDECB.
	ECB_INTENCLR_ENDECB = 0x1
	// Read: Disabled
	ECB_INTENCLR_ENDECB_Disabled = 0x0
	// Read: Enabled
	ECB_INTENCLR_ENDECB_Enabled = 0x1
	// Disable
	ECB_INTENCLR_ENDECB_Clear = 0x1
	// Position of ERRORECB field.
	ECB_INTENCLR_ERRORECB_Pos = 0x1
	// Bit mask of ERRORECB field.
	ECB_INTENCLR_ERRORECB_Msk = 0x2
	// Bit ERRORECB.
	ECB_INTENCLR_ERRORECB = 0x2
	// Read: Disabled
	ECB_INTENCLR_ERRORECB_Disabled = 0x0
	// Read: Enabled
	ECB_INTENCLR_ERRORECB_Enabled = 0x1
	// Disable
	ECB_INTENCLR_ERRORECB_Clear = 0x1

	// ECBDATAPTR: ECB block encrypt memory pointers
	// Position of ECBDATAPTR field.
	ECB_ECBDATAPTR_ECBDATAPTR_Pos = 0x0
	// Bit mask of ECBDATAPTR field.
	ECB_ECBDATAPTR_ECBDATAPTR_Msk = 0xffffffff
)

// Constants for AAR_NS: Accelerated Address Resolver
const (
	// TASKS_START: Start resolving addresses based on IRKs specified in the IRK data structure
	// Position of TASKS_START field.
	AAR_TASKS_START_TASKS_START_Pos = 0x0
	// Bit mask of TASKS_START field.
	AAR_TASKS_START_TASKS_START_Msk = 0x1
	// Bit TASKS_START.
	AAR_TASKS_START_TASKS_START = 0x1
	// Trigger task
	AAR_TASKS_START_TASKS_START_Trigger = 0x1

	// TASKS_STOP: Stop resolving addresses
	// Position of TASKS_STOP field.
	AAR_TASKS_STOP_TASKS_STOP_Pos = 0x0
	// Bit mask of TASKS_STOP field.
	AAR_TASKS_STOP_TASKS_STOP_Msk = 0x1
	// Bit TASKS_STOP.
	AAR_TASKS_STOP_TASKS_STOP = 0x1
	// Trigger task
	AAR_TASKS_STOP_TASKS_STOP_Trigger = 0x1

	// SUBSCRIBE_START: Subscribe configuration for task START
	// Position of CHIDX field.
	AAR_SUBSCRIBE_START_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	AAR_SUBSCRIBE_START_CHIDX_Msk = 0xff
	// Position of EN field.
	AAR_SUBSCRIBE_START_EN_Pos = 0x1f
	// Bit mask of EN field.
	AAR_SUBSCRIBE_START_EN_Msk = 0x80000000
	// Bit EN.
	AAR_SUBSCRIBE_START_EN = 0x80000000
	// Disable subscription
	AAR_SUBSCRIBE_START_EN_Disabled = 0x0
	// Enable subscription
	AAR_SUBSCRIBE_START_EN_Enabled = 0x1

	// SUBSCRIBE_STOP: Subscribe configuration for task STOP
	// Position of CHIDX field.
	AAR_SUBSCRIBE_STOP_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	AAR_SUBSCRIBE_STOP_CHIDX_Msk = 0xff
	// Position of EN field.
	AAR_SUBSCRIBE_STOP_EN_Pos = 0x1f
	// Bit mask of EN field.
	AAR_SUBSCRIBE_STOP_EN_Msk = 0x80000000
	// Bit EN.
	AAR_SUBSCRIBE_STOP_EN = 0x80000000
	// Disable subscription
	AAR_SUBSCRIBE_STOP_EN_Disabled = 0x0
	// Enable subscription
	AAR_SUBSCRIBE_STOP_EN_Enabled = 0x1

	// EVENTS_END: Address resolution procedure complete
	// Position of EVENTS_END field.
	AAR_EVENTS_END_EVENTS_END_Pos = 0x0
	// Bit mask of EVENTS_END field.
	AAR_EVENTS_END_EVENTS_END_Msk = 0x1
	// Bit EVENTS_END.
	AAR_EVENTS_END_EVENTS_END = 0x1
	// Event not generated
	AAR_EVENTS_END_EVENTS_END_NotGenerated = 0x0
	// Event generated
	AAR_EVENTS_END_EVENTS_END_Generated = 0x1

	// EVENTS_RESOLVED: Address resolved
	// Position of EVENTS_RESOLVED field.
	AAR_EVENTS_RESOLVED_EVENTS_RESOLVED_Pos = 0x0
	// Bit mask of EVENTS_RESOLVED field.
	AAR_EVENTS_RESOLVED_EVENTS_RESOLVED_Msk = 0x1
	// Bit EVENTS_RESOLVED.
	AAR_EVENTS_RESOLVED_EVENTS_RESOLVED = 0x1
	// Event not generated
	AAR_EVENTS_RESOLVED_EVENTS_RESOLVED_NotGenerated = 0x0
	// Event generated
	AAR_EVENTS_RESOLVED_EVENTS_RESOLVED_Generated = 0x1

	// EVENTS_NOTRESOLVED: Address not resolved
	// Position of EVENTS_NOTRESOLVED field.
	AAR_EVENTS_NOTRESOLVED_EVENTS_NOTRESOLVED_Pos = 0x0
	// Bit mask of EVENTS_NOTRESOLVED field.
	AAR_EVENTS_NOTRESOLVED_EVENTS_NOTRESOLVED_Msk = 0x1
	// Bit EVENTS_NOTRESOLVED.
	AAR_EVENTS_NOTRESOLVED_EVENTS_NOTRESOLVED = 0x1
	// Event not generated
	AAR_EVENTS_NOTRESOLVED_EVENTS_NOTRESOLVED_NotGenerated = 0x0
	// Event generated
	AAR_EVENTS_NOTRESOLVED_EVENTS_NOTRESOLVED_Generated = 0x1

	// PUBLISH_END: Publish configuration for event END
	// Position of CHIDX field.
	AAR_PUBLISH_END_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	AAR_PUBLISH_END_CHIDX_Msk = 0xff
	// Position of EN field.
	AAR_PUBLISH_END_EN_Pos = 0x1f
	// Bit mask of EN field.
	AAR_PUBLISH_END_EN_Msk = 0x80000000
	// Bit EN.
	AAR_PUBLISH_END_EN = 0x80000000
	// Disable publishing
	AAR_PUBLISH_END_EN_Disabled = 0x0
	// Enable publishing
	AAR_PUBLISH_END_EN_Enabled = 0x1

	// PUBLISH_RESOLVED: Publish configuration for event RESOLVED
	// Position of CHIDX field.
	AAR_PUBLISH_RESOLVED_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	AAR_PUBLISH_RESOLVED_CHIDX_Msk = 0xff
	// Position of EN field.
	AAR_PUBLISH_RESOLVED_EN_Pos = 0x1f
	// Bit mask of EN field.
	AAR_PUBLISH_RESOLVED_EN_Msk = 0x80000000
	// Bit EN.
	AAR_PUBLISH_RESOLVED_EN = 0x80000000
	// Disable publishing
	AAR_PUBLISH_RESOLVED_EN_Disabled = 0x0
	// Enable publishing
	AAR_PUBLISH_RESOLVED_EN_Enabled = 0x1

	// PUBLISH_NOTRESOLVED: Publish configuration for event NOTRESOLVED
	// Position of CHIDX field.
	AAR_PUBLISH_NOTRESOLVED_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	AAR_PUBLISH_NOTRESOLVED_CHIDX_Msk = 0xff
	// Position of EN field.
	AAR_PUBLISH_NOTRESOLVED_EN_Pos = 0x1f
	// Bit mask of EN field.
	AAR_PUBLISH_NOTRESOLVED_EN_Msk = 0x80000000
	// Bit EN.
	AAR_PUBLISH_NOTRESOLVED_EN = 0x80000000
	// Disable publishing
	AAR_PUBLISH_NOTRESOLVED_EN_Disabled = 0x0
	// Enable publishing
	AAR_PUBLISH_NOTRESOLVED_EN_Enabled = 0x1

	// INTENSET: Enable interrupt
	// Position of END field.
	AAR_INTENSET_END_Pos = 0x0
	// Bit mask of END field.
	AAR_INTENSET_END_Msk = 0x1
	// Bit END.
	AAR_INTENSET_END = 0x1
	// Read: Disabled
	AAR_INTENSET_END_Disabled = 0x0
	// Read: Enabled
	AAR_INTENSET_END_Enabled = 0x1
	// Enable
	AAR_INTENSET_END_Set = 0x1
	// Position of RESOLVED field.
	AAR_INTENSET_RESOLVED_Pos = 0x1
	// Bit mask of RESOLVED field.
	AAR_INTENSET_RESOLVED_Msk = 0x2
	// Bit RESOLVED.
	AAR_INTENSET_RESOLVED = 0x2
	// Read: Disabled
	AAR_INTENSET_RESOLVED_Disabled = 0x0
	// Read: Enabled
	AAR_INTENSET_RESOLVED_Enabled = 0x1
	// Enable
	AAR_INTENSET_RESOLVED_Set = 0x1
	// Position of NOTRESOLVED field.
	AAR_INTENSET_NOTRESOLVED_Pos = 0x2
	// Bit mask of NOTRESOLVED field.
	AAR_INTENSET_NOTRESOLVED_Msk = 0x4
	// Bit NOTRESOLVED.
	AAR_INTENSET_NOTRESOLVED = 0x4
	// Read: Disabled
	AAR_INTENSET_NOTRESOLVED_Disabled = 0x0
	// Read: Enabled
	AAR_INTENSET_NOTRESOLVED_Enabled = 0x1
	// Enable
	AAR_INTENSET_NOTRESOLVED_Set = 0x1

	// INTENCLR: Disable interrupt
	// Position of END field.
	AAR_INTENCLR_END_Pos = 0x0
	// Bit mask of END field.
	AAR_INTENCLR_END_Msk = 0x1
	// Bit END.
	AAR_INTENCLR_END = 0x1
	// Read: Disabled
	AAR_INTENCLR_END_Disabled = 0x0
	// Read: Enabled
	AAR_INTENCLR_END_Enabled = 0x1
	// Disable
	AAR_INTENCLR_END_Clear = 0x1
	// Position of RESOLVED field.
	AAR_INTENCLR_RESOLVED_Pos = 0x1
	// Bit mask of RESOLVED field.
	AAR_INTENCLR_RESOLVED_Msk = 0x2
	// Bit RESOLVED.
	AAR_INTENCLR_RESOLVED = 0x2
	// Read: Disabled
	AAR_INTENCLR_RESOLVED_Disabled = 0x0
	// Read: Enabled
	AAR_INTENCLR_RESOLVED_Enabled = 0x1
	// Disable
	AAR_INTENCLR_RESOLVED_Clear = 0x1
	// Position of NOTRESOLVED field.
	AAR_INTENCLR_NOTRESOLVED_Pos = 0x2
	// Bit mask of NOTRESOLVED field.
	AAR_INTENCLR_NOTRESOLVED_Msk = 0x4
	// Bit NOTRESOLVED.
	AAR_INTENCLR_NOTRESOLVED = 0x4
	// Read: Disabled
	AAR_INTENCLR_NOTRESOLVED_Disabled = 0x0
	// Read: Enabled
	AAR_INTENCLR_NOTRESOLVED_Enabled = 0x1
	// Disable
	AAR_INTENCLR_NOTRESOLVED_Clear = 0x1

	// STATUS: Resolution status
	// Position of STATUS field.
	AAR_STATUS_STATUS_Pos = 0x0
	// Bit mask of STATUS field.
	AAR_STATUS_STATUS_Msk = 0xf

	// ENABLE: Enable AAR
	// Position of ENABLE field.
	AAR_ENABLE_ENABLE_Pos = 0x0
	// Bit mask of ENABLE field.
	AAR_ENABLE_ENABLE_Msk = 0x3
	// Disable
	AAR_ENABLE_ENABLE_Disabled = 0x0
	// Enable
	AAR_ENABLE_ENABLE_Enabled = 0x3

	// NIRK: Number of IRKs
	// Position of NIRK field.
	AAR_NIRK_NIRK_Pos = 0x0
	// Bit mask of NIRK field.
	AAR_NIRK_NIRK_Msk = 0x1f

	// IRKPTR: Pointer to IRK data structure
	// Position of IRKPTR field.
	AAR_IRKPTR_IRKPTR_Pos = 0x0
	// Bit mask of IRKPTR field.
	AAR_IRKPTR_IRKPTR_Msk = 0xffffffff

	// ADDRPTR: Pointer to the resolvable address
	// Position of ADDRPTR field.
	AAR_ADDRPTR_ADDRPTR_Pos = 0x0
	// Bit mask of ADDRPTR field.
	AAR_ADDRPTR_ADDRPTR_Msk = 0xffffffff

	// SCRATCHPTR: Pointer to data area used for temporary storage
	// Position of SCRATCHPTR field.
	AAR_SCRATCHPTR_SCRATCHPTR_Pos = 0x0
	// Bit mask of SCRATCHPTR field.
	AAR_SCRATCHPTR_SCRATCHPTR_Msk = 0xffffffff
)

// Constants for CCM_NS: AES CCM mode encryption
const (
	// TASKS_KSGEN: Start generation of keystream. This operation will stop by itself when completed.
	// Position of TASKS_KSGEN field.
	CCM_TASKS_KSGEN_TASKS_KSGEN_Pos = 0x0
	// Bit mask of TASKS_KSGEN field.
	CCM_TASKS_KSGEN_TASKS_KSGEN_Msk = 0x1
	// Bit TASKS_KSGEN.
	CCM_TASKS_KSGEN_TASKS_KSGEN = 0x1
	// Trigger task
	CCM_TASKS_KSGEN_TASKS_KSGEN_Trigger = 0x1

	// TASKS_CRYPT: Start encryption/decryption. This operation will stop by itself when completed.
	// Position of TASKS_CRYPT field.
	CCM_TASKS_CRYPT_TASKS_CRYPT_Pos = 0x0
	// Bit mask of TASKS_CRYPT field.
	CCM_TASKS_CRYPT_TASKS_CRYPT_Msk = 0x1
	// Bit TASKS_CRYPT.
	CCM_TASKS_CRYPT_TASKS_CRYPT = 0x1
	// Trigger task
	CCM_TASKS_CRYPT_TASKS_CRYPT_Trigger = 0x1

	// TASKS_STOP: Stop encryption/decryption
	// Position of TASKS_STOP field.
	CCM_TASKS_STOP_TASKS_STOP_Pos = 0x0
	// Bit mask of TASKS_STOP field.
	CCM_TASKS_STOP_TASKS_STOP_Msk = 0x1
	// Bit TASKS_STOP.
	CCM_TASKS_STOP_TASKS_STOP = 0x1
	// Trigger task
	CCM_TASKS_STOP_TASKS_STOP_Trigger = 0x1

	// TASKS_RATEOVERRIDE: Override DATARATE setting in MODE register with the contents of the RATEOVERRIDE register for any ongoing encryption/decryption
	// Position of TASKS_RATEOVERRIDE field.
	CCM_TASKS_RATEOVERRIDE_TASKS_RATEOVERRIDE_Pos = 0x0
	// Bit mask of TASKS_RATEOVERRIDE field.
	CCM_TASKS_RATEOVERRIDE_TASKS_RATEOVERRIDE_Msk = 0x1
	// Bit TASKS_RATEOVERRIDE.
	CCM_TASKS_RATEOVERRIDE_TASKS_RATEOVERRIDE = 0x1
	// Trigger task
	CCM_TASKS_RATEOVERRIDE_TASKS_RATEOVERRIDE_Trigger = 0x1

	// SUBSCRIBE_KSGEN: Subscribe configuration for task KSGEN
	// Position of CHIDX field.
	CCM_SUBSCRIBE_KSGEN_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	CCM_SUBSCRIBE_KSGEN_CHIDX_Msk = 0xff
	// Position of EN field.
	CCM_SUBSCRIBE_KSGEN_EN_Pos = 0x1f
	// Bit mask of EN field.
	CCM_SUBSCRIBE_KSGEN_EN_Msk = 0x80000000
	// Bit EN.
	CCM_SUBSCRIBE_KSGEN_EN = 0x80000000
	// Disable subscription
	CCM_SUBSCRIBE_KSGEN_EN_Disabled = 0x0
	// Enable subscription
	CCM_SUBSCRIBE_KSGEN_EN_Enabled = 0x1

	// SUBSCRIBE_CRYPT: Subscribe configuration for task CRYPT
	// Position of CHIDX field.
	CCM_SUBSCRIBE_CRYPT_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	CCM_SUBSCRIBE_CRYPT_CHIDX_Msk = 0xff
	// Position of EN field.
	CCM_SUBSCRIBE_CRYPT_EN_Pos = 0x1f
	// Bit mask of EN field.
	CCM_SUBSCRIBE_CRYPT_EN_Msk = 0x80000000
	// Bit EN.
	CCM_SUBSCRIBE_CRYPT_EN = 0x80000000
	// Disable subscription
	CCM_SUBSCRIBE_CRYPT_EN_Disabled = 0x0
	// Enable subscription
	CCM_SUBSCRIBE_CRYPT_EN_Enabled = 0x1

	// SUBSCRIBE_STOP: Subscribe configuration for task STOP
	// Position of CHIDX field.
	CCM_SUBSCRIBE_STOP_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	CCM_SUBSCRIBE_STOP_CHIDX_Msk = 0xff
	// Position of EN field.
	CCM_SUBSCRIBE_STOP_EN_Pos = 0x1f
	// Bit mask of EN field.
	CCM_SUBSCRIBE_STOP_EN_Msk = 0x80000000
	// Bit EN.
	CCM_SUBSCRIBE_STOP_EN = 0x80000000
	// Disable subscription
	CCM_SUBSCRIBE_STOP_EN_Disabled = 0x0
	// Enable subscription
	CCM_SUBSCRIBE_STOP_EN_Enabled = 0x1

	// SUBSCRIBE_RATEOVERRIDE: Subscribe configuration for task RATEOVERRIDE
	// Position of CHIDX field.
	CCM_SUBSCRIBE_RATEOVERRIDE_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	CCM_SUBSCRIBE_RATEOVERRIDE_CHIDX_Msk = 0xff
	// Position of EN field.
	CCM_SUBSCRIBE_RATEOVERRIDE_EN_Pos = 0x1f
	// Bit mask of EN field.
	CCM_SUBSCRIBE_RATEOVERRIDE_EN_Msk = 0x80000000
	// Bit EN.
	CCM_SUBSCRIBE_RATEOVERRIDE_EN = 0x80000000
	// Disable subscription
	CCM_SUBSCRIBE_RATEOVERRIDE_EN_Disabled = 0x0
	// Enable subscription
	CCM_SUBSCRIBE_RATEOVERRIDE_EN_Enabled = 0x1

	// EVENTS_ENDKSGEN: Keystream generation complete
	// Position of EVENTS_ENDKSGEN field.
	CCM_EVENTS_ENDKSGEN_EVENTS_ENDKSGEN_Pos = 0x0
	// Bit mask of EVENTS_ENDKSGEN field.
	CCM_EVENTS_ENDKSGEN_EVENTS_ENDKSGEN_Msk = 0x1
	// Bit EVENTS_ENDKSGEN.
	CCM_EVENTS_ENDKSGEN_EVENTS_ENDKSGEN = 0x1
	// Event not generated
	CCM_EVENTS_ENDKSGEN_EVENTS_ENDKSGEN_NotGenerated = 0x0
	// Event generated
	CCM_EVENTS_ENDKSGEN_EVENTS_ENDKSGEN_Generated = 0x1

	// EVENTS_ENDCRYPT: Encrypt/decrypt complete
	// Position of EVENTS_ENDCRYPT field.
	CCM_EVENTS_ENDCRYPT_EVENTS_ENDCRYPT_Pos = 0x0
	// Bit mask of EVENTS_ENDCRYPT field.
	CCM_EVENTS_ENDCRYPT_EVENTS_ENDCRYPT_Msk = 0x1
	// Bit EVENTS_ENDCRYPT.
	CCM_EVENTS_ENDCRYPT_EVENTS_ENDCRYPT = 0x1
	// Event not generated
	CCM_EVENTS_ENDCRYPT_EVENTS_ENDCRYPT_NotGenerated = 0x0
	// Event generated
	CCM_EVENTS_ENDCRYPT_EVENTS_ENDCRYPT_Generated = 0x1

	// EVENTS_ERROR: Deprecated register - CCM error event
	// Position of EVENTS_ERROR field.
	CCM_EVENTS_ERROR_EVENTS_ERROR_Pos = 0x0
	// Bit mask of EVENTS_ERROR field.
	CCM_EVENTS_ERROR_EVENTS_ERROR_Msk = 0x1
	// Bit EVENTS_ERROR.
	CCM_EVENTS_ERROR_EVENTS_ERROR = 0x1
	// Event not generated
	CCM_EVENTS_ERROR_EVENTS_ERROR_NotGenerated = 0x0
	// Event generated
	CCM_EVENTS_ERROR_EVENTS_ERROR_Generated = 0x1

	// PUBLISH_ENDKSGEN: Publish configuration for event ENDKSGEN
	// Position of CHIDX field.
	CCM_PUBLISH_ENDKSGEN_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	CCM_PUBLISH_ENDKSGEN_CHIDX_Msk = 0xff
	// Position of EN field.
	CCM_PUBLISH_ENDKSGEN_EN_Pos = 0x1f
	// Bit mask of EN field.
	CCM_PUBLISH_ENDKSGEN_EN_Msk = 0x80000000
	// Bit EN.
	CCM_PUBLISH_ENDKSGEN_EN = 0x80000000
	// Disable publishing
	CCM_PUBLISH_ENDKSGEN_EN_Disabled = 0x0
	// Enable publishing
	CCM_PUBLISH_ENDKSGEN_EN_Enabled = 0x1

	// PUBLISH_ENDCRYPT: Publish configuration for event ENDCRYPT
	// Position of CHIDX field.
	CCM_PUBLISH_ENDCRYPT_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	CCM_PUBLISH_ENDCRYPT_CHIDX_Msk = 0xff
	// Position of EN field.
	CCM_PUBLISH_ENDCRYPT_EN_Pos = 0x1f
	// Bit mask of EN field.
	CCM_PUBLISH_ENDCRYPT_EN_Msk = 0x80000000
	// Bit EN.
	CCM_PUBLISH_ENDCRYPT_EN = 0x80000000
	// Disable publishing
	CCM_PUBLISH_ENDCRYPT_EN_Disabled = 0x0
	// Enable publishing
	CCM_PUBLISH_ENDCRYPT_EN_Enabled = 0x1

	// PUBLISH_ERROR: Deprecated register - Publish configuration for event ERROR
	// Position of CHIDX field.
	CCM_PUBLISH_ERROR_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	CCM_PUBLISH_ERROR_CHIDX_Msk = 0xff
	// Position of EN field.
	CCM_PUBLISH_ERROR_EN_Pos = 0x1f
	// Bit mask of EN field.
	CCM_PUBLISH_ERROR_EN_Msk = 0x80000000
	// Bit EN.
	CCM_PUBLISH_ERROR_EN = 0x80000000
	// Disable publishing
	CCM_PUBLISH_ERROR_EN_Disabled = 0x0
	// Enable publishing
	CCM_PUBLISH_ERROR_EN_Enabled = 0x1

	// SHORTS: Shortcuts between local events and tasks
	// Position of ENDKSGEN_CRYPT field.
	CCM_SHORTS_ENDKSGEN_CRYPT_Pos = 0x0
	// Bit mask of ENDKSGEN_CRYPT field.
	CCM_SHORTS_ENDKSGEN_CRYPT_Msk = 0x1
	// Bit ENDKSGEN_CRYPT.
	CCM_SHORTS_ENDKSGEN_CRYPT = 0x1
	// Disable shortcut
	CCM_SHORTS_ENDKSGEN_CRYPT_Disabled = 0x0
	// Enable shortcut
	CCM_SHORTS_ENDKSGEN_CRYPT_Enabled = 0x1

	// INTENSET: Enable interrupt
	// Position of ENDKSGEN field.
	CCM_INTENSET_ENDKSGEN_Pos = 0x0
	// Bit mask of ENDKSGEN field.
	CCM_INTENSET_ENDKSGEN_Msk = 0x1
	// Bit ENDKSGEN.
	CCM_INTENSET_ENDKSGEN = 0x1
	// Read: Disabled
	CCM_INTENSET_ENDKSGEN_Disabled = 0x0
	// Read: Enabled
	CCM_INTENSET_ENDKSGEN_Enabled = 0x1
	// Enable
	CCM_INTENSET_ENDKSGEN_Set = 0x1
	// Position of ENDCRYPT field.
	CCM_INTENSET_ENDCRYPT_Pos = 0x1
	// Bit mask of ENDCRYPT field.
	CCM_INTENSET_ENDCRYPT_Msk = 0x2
	// Bit ENDCRYPT.
	CCM_INTENSET_ENDCRYPT = 0x2
	// Read: Disabled
	CCM_INTENSET_ENDCRYPT_Disabled = 0x0
	// Read: Enabled
	CCM_INTENSET_ENDCRYPT_Enabled = 0x1
	// Enable
	CCM_INTENSET_ENDCRYPT_Set = 0x1
	// Position of ERROR field.
	CCM_INTENSET_ERROR_Pos = 0x2
	// Bit mask of ERROR field.
	CCM_INTENSET_ERROR_Msk = 0x4
	// Bit ERROR.
	CCM_INTENSET_ERROR = 0x4
	// Read: Disabled
	CCM_INTENSET_ERROR_Disabled = 0x0
	// Read: Enabled
	CCM_INTENSET_ERROR_Enabled = 0x1
	// Enable
	CCM_INTENSET_ERROR_Set = 0x1

	// INTENCLR: Disable interrupt
	// Position of ENDKSGEN field.
	CCM_INTENCLR_ENDKSGEN_Pos = 0x0
	// Bit mask of ENDKSGEN field.
	CCM_INTENCLR_ENDKSGEN_Msk = 0x1
	// Bit ENDKSGEN.
	CCM_INTENCLR_ENDKSGEN = 0x1
	// Read: Disabled
	CCM_INTENCLR_ENDKSGEN_Disabled = 0x0
	// Read: Enabled
	CCM_INTENCLR_ENDKSGEN_Enabled = 0x1
	// Disable
	CCM_INTENCLR_ENDKSGEN_Clear = 0x1
	// Position of ENDCRYPT field.
	CCM_INTENCLR_ENDCRYPT_Pos = 0x1
	// Bit mask of ENDCRYPT field.
	CCM_INTENCLR_ENDCRYPT_Msk = 0x2
	// Bit ENDCRYPT.
	CCM_INTENCLR_ENDCRYPT = 0x2
	// Read: Disabled
	CCM_INTENCLR_ENDCRYPT_Disabled = 0x0
	// Read: Enabled
	CCM_INTENCLR_ENDCRYPT_Enabled = 0x1
	// Disable
	CCM_INTENCLR_ENDCRYPT_Clear = 0x1
	// Position of ERROR field.
	CCM_INTENCLR_ERROR_Pos = 0x2
	// Bit mask of ERROR field.
	CCM_INTENCLR_ERROR_Msk = 0x4
	// Bit ERROR.
	CCM_INTENCLR_ERROR = 0x4
	// Read: Disabled
	CCM_INTENCLR_ERROR_Disabled = 0x0
	// Read: Enabled
	CCM_INTENCLR_ERROR_Enabled = 0x1
	// Disable
	CCM_INTENCLR_ERROR_Clear = 0x1

	// MICSTATUS: MIC check result
	// Position of MICSTATUS field.
	CCM_MICSTATUS_MICSTATUS_Pos = 0x0
	// Bit mask of MICSTATUS field.
	CCM_MICSTATUS_MICSTATUS_Msk = 0x1
	// Bit MICSTATUS.
	CCM_MICSTATUS_MICSTATUS = 0x1
	// MIC check failed
	CCM_MICSTATUS_MICSTATUS_CheckFailed = 0x0
	// MIC check passed
	CCM_MICSTATUS_MICSTATUS_CheckPassed = 0x1

	// ENABLE: Enable
	// Position of ENABLE field.
	CCM_ENABLE_ENABLE_Pos = 0x0
	// Bit mask of ENABLE field.
	CCM_ENABLE_ENABLE_Msk = 0x3
	// Disable
	CCM_ENABLE_ENABLE_Disabled = 0x0
	// Enable
	CCM_ENABLE_ENABLE_Enabled = 0x2

	// MODE: Operation mode
	// Position of MODE field.
	CCM_MODE_MODE_Pos = 0x0
	// Bit mask of MODE field.
	CCM_MODE_MODE_Msk = 0x1
	// Bit MODE.
	CCM_MODE_MODE = 0x1
	// AES CCM packet encryption mode
	CCM_MODE_MODE_Encryption = 0x0
	// AES CCM packet decryption mode
	CCM_MODE_MODE_Decryption = 0x1
	// Position of DATARATE field.
	CCM_MODE_DATARATE_Pos = 0x10
	// Bit mask of DATARATE field.
	CCM_MODE_DATARATE_Msk = 0x30000
	// 1 Mbps
	CCM_MODE_DATARATE_1Mbit = 0x0
	// 2 Mbps
	CCM_MODE_DATARATE_2Mbit = 0x1
	// 125 Kbps
	CCM_MODE_DATARATE_125Kbps = 0x2
	// 500 Kbps
	CCM_MODE_DATARATE_500Kbps = 0x3
	// Position of LENGTH field.
	CCM_MODE_LENGTH_Pos = 0x18
	// Bit mask of LENGTH field.
	CCM_MODE_LENGTH_Msk = 0x1000000
	// Bit LENGTH.
	CCM_MODE_LENGTH = 0x1000000
	// Default length. Effective length of LENGTH field in encrypted/decrypted packet is 5 bits. A keystream for packet payloads up to 27 bytes will be generated.
	CCM_MODE_LENGTH_Default = 0x0
	// Extended length. Effective length of LENGTH field in encrypted/decrypted packet is 8 bits. A keystream for packet payloads up to MAXPACKETSIZE bytes will be generated.
	CCM_MODE_LENGTH_Extended = 0x1

	// CNFPTR: Pointer to data structure holding the AES key and the NONCE vector
	// Position of CNFPTR field.
	CCM_CNFPTR_CNFPTR_Pos = 0x0
	// Bit mask of CNFPTR field.
	CCM_CNFPTR_CNFPTR_Msk = 0xffffffff

	// INPTR: Input pointer
	// Position of INPTR field.
	CCM_INPTR_INPTR_Pos = 0x0
	// Bit mask of INPTR field.
	CCM_INPTR_INPTR_Msk = 0xffffffff

	// OUTPTR: Output pointer
	// Position of OUTPTR field.
	CCM_OUTPTR_OUTPTR_Pos = 0x0
	// Bit mask of OUTPTR field.
	CCM_OUTPTR_OUTPTR_Msk = 0xffffffff

	// SCRATCHPTR: Pointer to data area used for temporary storage
	// Position of SCRATCHPTR field.
	CCM_SCRATCHPTR_SCRATCHPTR_Pos = 0x0
	// Bit mask of SCRATCHPTR field.
	CCM_SCRATCHPTR_SCRATCHPTR_Msk = 0xffffffff

	// MAXPACKETSIZE: Length of keystream generated when MODE.LENGTH = Extended
	// Position of MAXPACKETSIZE field.
	CCM_MAXPACKETSIZE_MAXPACKETSIZE_Pos = 0x0
	// Bit mask of MAXPACKETSIZE field.
	CCM_MAXPACKETSIZE_MAXPACKETSIZE_Msk = 0xff

	// RATEOVERRIDE: Data rate override setting.
	// Position of RATEOVERRIDE field.
	CCM_RATEOVERRIDE_RATEOVERRIDE_Pos = 0x0
	// Bit mask of RATEOVERRIDE field.
	CCM_RATEOVERRIDE_RATEOVERRIDE_Msk = 0x3
	// 1 Mbps
	CCM_RATEOVERRIDE_RATEOVERRIDE_1Mbit = 0x0
	// 2 Mbps
	CCM_RATEOVERRIDE_RATEOVERRIDE_2Mbit = 0x1
	// 125 Kbps
	CCM_RATEOVERRIDE_RATEOVERRIDE_125Kbps = 0x2
	// 500 Kbps
	CCM_RATEOVERRIDE_RATEOVERRIDE_500Kbps = 0x3

	// HEADERMASK: Header (S0) mask.
	// Position of HEADERMASK field.
	CCM_HEADERMASK_HEADERMASK_Pos = 0x0
	// Bit mask of HEADERMASK field.
	CCM_HEADERMASK_HEADERMASK_Msk = 0xff
)

// Constants for DPPIC_NS: Distributed programmable peripheral interconnect controller
const (
	// TASKS_CHG.EN: Description cluster: Enable channel group n
	// Position of EN field.
	DPPIC_TASKS_CHG_EN_EN_Pos = 0x0
	// Bit mask of EN field.
	DPPIC_TASKS_CHG_EN_EN_Msk = 0x1
	// Bit EN.
	DPPIC_TASKS_CHG_EN_EN = 0x1
	// Trigger task
	DPPIC_TASKS_CHG_EN_EN_Trigger = 0x1

	// TASKS_CHG.DIS: Description cluster: Disable channel group n
	// Position of DIS field.
	DPPIC_TASKS_CHG_DIS_DIS_Pos = 0x0
	// Bit mask of DIS field.
	DPPIC_TASKS_CHG_DIS_DIS_Msk = 0x1
	// Bit DIS.
	DPPIC_TASKS_CHG_DIS_DIS = 0x1
	// Trigger task
	DPPIC_TASKS_CHG_DIS_DIS_Trigger = 0x1

	// SUBSCRIBE_CHG.EN: Description cluster: Subscribe configuration for task CHG[n].EN
	// Position of CHIDX field.
	DPPIC_SUBSCRIBE_CHG_EN_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	DPPIC_SUBSCRIBE_CHG_EN_CHIDX_Msk = 0xff
	// Position of EN field.
	DPPIC_SUBSCRIBE_CHG_EN_EN_Pos = 0x1f
	// Bit mask of EN field.
	DPPIC_SUBSCRIBE_CHG_EN_EN_Msk = 0x80000000
	// Bit EN.
	DPPIC_SUBSCRIBE_CHG_EN_EN = 0x80000000
	// Disable subscription
	DPPIC_SUBSCRIBE_CHG_EN_EN_Disabled = 0x0
	// Enable subscription
	DPPIC_SUBSCRIBE_CHG_EN_EN_Enabled = 0x1

	// SUBSCRIBE_CHG.DIS: Description cluster: Subscribe configuration for task CHG[n].DIS
	// Position of CHIDX field.
	DPPIC_SUBSCRIBE_CHG_DIS_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	DPPIC_SUBSCRIBE_CHG_DIS_CHIDX_Msk = 0xff
	// Position of EN field.
	DPPIC_SUBSCRIBE_CHG_DIS_EN_Pos = 0x1f
	// Bit mask of EN field.
	DPPIC_SUBSCRIBE_CHG_DIS_EN_Msk = 0x80000000
	// Bit EN.
	DPPIC_SUBSCRIBE_CHG_DIS_EN = 0x80000000
	// Disable subscription
	DPPIC_SUBSCRIBE_CHG_DIS_EN_Disabled = 0x0
	// Enable subscription
	DPPIC_SUBSCRIBE_CHG_DIS_EN_Enabled = 0x1

	// CHEN: Channel enable register
	// Position of CH0 field.
	DPPIC_CHEN_CH0_Pos = 0x0
	// Bit mask of CH0 field.
	DPPIC_CHEN_CH0_Msk = 0x1
	// Bit CH0.
	DPPIC_CHEN_CH0 = 0x1
	// Disable channel
	DPPIC_CHEN_CH0_Disabled = 0x0
	// Enable channel
	DPPIC_CHEN_CH0_Enabled = 0x1
	// Position of CH1 field.
	DPPIC_CHEN_CH1_Pos = 0x1
	// Bit mask of CH1 field.
	DPPIC_CHEN_CH1_Msk = 0x2
	// Bit CH1.
	DPPIC_CHEN_CH1 = 0x2
	// Disable channel
	DPPIC_CHEN_CH1_Disabled = 0x0
	// Enable channel
	DPPIC_CHEN_CH1_Enabled = 0x1
	// Position of CH2 field.
	DPPIC_CHEN_CH2_Pos = 0x2
	// Bit mask of CH2 field.
	DPPIC_CHEN_CH2_Msk = 0x4
	// Bit CH2.
	DPPIC_CHEN_CH2 = 0x4
	// Disable channel
	DPPIC_CHEN_CH2_Disabled = 0x0
	// Enable channel
	DPPIC_CHEN_CH2_Enabled = 0x1
	// Position of CH3 field.
	DPPIC_CHEN_CH3_Pos = 0x3
	// Bit mask of CH3 field.
	DPPIC_CHEN_CH3_Msk = 0x8
	// Bit CH3.
	DPPIC_CHEN_CH3 = 0x8
	// Disable channel
	DPPIC_CHEN_CH3_Disabled = 0x0
	// Enable channel
	DPPIC_CHEN_CH3_Enabled = 0x1
	// Position of CH4 field.
	DPPIC_CHEN_CH4_Pos = 0x4
	// Bit mask of CH4 field.
	DPPIC_CHEN_CH4_Msk = 0x10
	// Bit CH4.
	DPPIC_CHEN_CH4 = 0x10
	// Disable channel
	DPPIC_CHEN_CH4_Disabled = 0x0
	// Enable channel
	DPPIC_CHEN_CH4_Enabled = 0x1
	// Position of CH5 field.
	DPPIC_CHEN_CH5_Pos = 0x5
	// Bit mask of CH5 field.
	DPPIC_CHEN_CH5_Msk = 0x20
	// Bit CH5.
	DPPIC_CHEN_CH5 = 0x20
	// Disable channel
	DPPIC_CHEN_CH5_Disabled = 0x0
	// Enable channel
	DPPIC_CHEN_CH5_Enabled = 0x1
	// Position of CH6 field.
	DPPIC_CHEN_CH6_Pos = 0x6
	// Bit mask of CH6 field.
	DPPIC_CHEN_CH6_Msk = 0x40
	// Bit CH6.
	DPPIC_CHEN_CH6 = 0x40
	// Disable channel
	DPPIC_CHEN_CH6_Disabled = 0x0
	// Enable channel
	DPPIC_CHEN_CH6_Enabled = 0x1
	// Position of CH7 field.
	DPPIC_CHEN_CH7_Pos = 0x7
	// Bit mask of CH7 field.
	DPPIC_CHEN_CH7_Msk = 0x80
	// Bit CH7.
	DPPIC_CHEN_CH7 = 0x80
	// Disable channel
	DPPIC_CHEN_CH7_Disabled = 0x0
	// Enable channel
	DPPIC_CHEN_CH7_Enabled = 0x1
	// Position of CH8 field.
	DPPIC_CHEN_CH8_Pos = 0x8
	// Bit mask of CH8 field.
	DPPIC_CHEN_CH8_Msk = 0x100
	// Bit CH8.
	DPPIC_CHEN_CH8 = 0x100
	// Disable channel
	DPPIC_CHEN_CH8_Disabled = 0x0
	// Enable channel
	DPPIC_CHEN_CH8_Enabled = 0x1
	// Position of CH9 field.
	DPPIC_CHEN_CH9_Pos = 0x9
	// Bit mask of CH9 field.
	DPPIC_CHEN_CH9_Msk = 0x200
	// Bit CH9.
	DPPIC_CHEN_CH9 = 0x200
	// Disable channel
	DPPIC_CHEN_CH9_Disabled = 0x0
	// Enable channel
	DPPIC_CHEN_CH9_Enabled = 0x1
	// Position of CH10 field.
	DPPIC_CHEN_CH10_Pos = 0xa
	// Bit mask of CH10 field.
	DPPIC_CHEN_CH10_Msk = 0x400
	// Bit CH10.
	DPPIC_CHEN_CH10 = 0x400
	// Disable channel
	DPPIC_CHEN_CH10_Disabled = 0x0
	// Enable channel
	DPPIC_CHEN_CH10_Enabled = 0x1
	// Position of CH11 field.
	DPPIC_CHEN_CH11_Pos = 0xb
	// Bit mask of CH11 field.
	DPPIC_CHEN_CH11_Msk = 0x800
	// Bit CH11.
	DPPIC_CHEN_CH11 = 0x800
	// Disable channel
	DPPIC_CHEN_CH11_Disabled = 0x0
	// Enable channel
	DPPIC_CHEN_CH11_Enabled = 0x1
	// Position of CH12 field.
	DPPIC_CHEN_CH12_Pos = 0xc
	// Bit mask of CH12 field.
	DPPIC_CHEN_CH12_Msk = 0x1000
	// Bit CH12.
	DPPIC_CHEN_CH12 = 0x1000
	// Disable channel
	DPPIC_CHEN_CH12_Disabled = 0x0
	// Enable channel
	DPPIC_CHEN_CH12_Enabled = 0x1
	// Position of CH13 field.
	DPPIC_CHEN_CH13_Pos = 0xd
	// Bit mask of CH13 field.
	DPPIC_CHEN_CH13_Msk = 0x2000
	// Bit CH13.
	DPPIC_CHEN_CH13 = 0x2000
	// Disable channel
	DPPIC_CHEN_CH13_Disabled = 0x0
	// Enable channel
	DPPIC_CHEN_CH13_Enabled = 0x1
	// Position of CH14 field.
	DPPIC_CHEN_CH14_Pos = 0xe
	// Bit mask of CH14 field.
	DPPIC_CHEN_CH14_Msk = 0x4000
	// Bit CH14.
	DPPIC_CHEN_CH14 = 0x4000
	// Disable channel
	DPPIC_CHEN_CH14_Disabled = 0x0
	// Enable channel
	DPPIC_CHEN_CH14_Enabled = 0x1
	// Position of CH15 field.
	DPPIC_CHEN_CH15_Pos = 0xf
	// Bit mask of CH15 field.
	DPPIC_CHEN_CH15_Msk = 0x8000
	// Bit CH15.
	DPPIC_CHEN_CH15 = 0x8000
	// Disable channel
	DPPIC_CHEN_CH15_Disabled = 0x0
	// Enable channel
	DPPIC_CHEN_CH15_Enabled = 0x1

	// CHENSET: Channel enable set register
	// Position of CH0 field.
	DPPIC_CHENSET_CH0_Pos = 0x0
	// Bit mask of CH0 field.
	DPPIC_CHENSET_CH0_Msk = 0x1
	// Bit CH0.
	DPPIC_CHENSET_CH0 = 0x1
	// Read: Channel disabled
	DPPIC_CHENSET_CH0_Disabled = 0x0
	// Read: Channel enabled
	DPPIC_CHENSET_CH0_Enabled = 0x1
	// Write: Enable channel
	DPPIC_CHENSET_CH0_Set = 0x1
	// Position of CH1 field.
	DPPIC_CHENSET_CH1_Pos = 0x1
	// Bit mask of CH1 field.
	DPPIC_CHENSET_CH1_Msk = 0x2
	// Bit CH1.
	DPPIC_CHENSET_CH1 = 0x2
	// Read: Channel disabled
	DPPIC_CHENSET_CH1_Disabled = 0x0
	// Read: Channel enabled
	DPPIC_CHENSET_CH1_Enabled = 0x1
	// Write: Enable channel
	DPPIC_CHENSET_CH1_Set = 0x1
	// Position of CH2 field.
	DPPIC_CHENSET_CH2_Pos = 0x2
	// Bit mask of CH2 field.
	DPPIC_CHENSET_CH2_Msk = 0x4
	// Bit CH2.
	DPPIC_CHENSET_CH2 = 0x4
	// Read: Channel disabled
	DPPIC_CHENSET_CH2_Disabled = 0x0
	// Read: Channel enabled
	DPPIC_CHENSET_CH2_Enabled = 0x1
	// Write: Enable channel
	DPPIC_CHENSET_CH2_Set = 0x1
	// Position of CH3 field.
	DPPIC_CHENSET_CH3_Pos = 0x3
	// Bit mask of CH3 field.
	DPPIC_CHENSET_CH3_Msk = 0x8
	// Bit CH3.
	DPPIC_CHENSET_CH3 = 0x8
	// Read: Channel disabled
	DPPIC_CHENSET_CH3_Disabled = 0x0
	// Read: Channel enabled
	DPPIC_CHENSET_CH3_Enabled = 0x1
	// Write: Enable channel
	DPPIC_CHENSET_CH3_Set = 0x1
	// Position of CH4 field.
	DPPIC_CHENSET_CH4_Pos = 0x4
	// Bit mask of CH4 field.
	DPPIC_CHENSET_CH4_Msk = 0x10
	// Bit CH4.
	DPPIC_CHENSET_CH4 = 0x10
	// Read: Channel disabled
	DPPIC_CHENSET_CH4_Disabled = 0x0
	// Read: Channel enabled
	DPPIC_CHENSET_CH4_Enabled = 0x1
	// Write: Enable channel
	DPPIC_CHENSET_CH4_Set = 0x1
	// Position of CH5 field.
	DPPIC_CHENSET_CH5_Pos = 0x5
	// Bit mask of CH5 field.
	DPPIC_CHENSET_CH5_Msk = 0x20
	// Bit CH5.
	DPPIC_CHENSET_CH5 = 0x20
	// Read: Channel disabled
	DPPIC_CHENSET_CH5_Disabled = 0x0
	// Read: Channel enabled
	DPPIC_CHENSET_CH5_Enabled = 0x1
	// Write: Enable channel
	DPPIC_CHENSET_CH5_Set = 0x1
	// Position of CH6 field.
	DPPIC_CHENSET_CH6_Pos = 0x6
	// Bit mask of CH6 field.
	DPPIC_CHENSET_CH6_Msk = 0x40
	// Bit CH6.
	DPPIC_CHENSET_CH6 = 0x40
	// Read: Channel disabled
	DPPIC_CHENSET_CH6_Disabled = 0x0
	// Read: Channel enabled
	DPPIC_CHENSET_CH6_Enabled = 0x1
	// Write: Enable channel
	DPPIC_CHENSET_CH6_Set = 0x1
	// Position of CH7 field.
	DPPIC_CHENSET_CH7_Pos = 0x7
	// Bit mask of CH7 field.
	DPPIC_CHENSET_CH7_Msk = 0x80
	// Bit CH7.
	DPPIC_CHENSET_CH7 = 0x80
	// Read: Channel disabled
	DPPIC_CHENSET_CH7_Disabled = 0x0
	// Read: Channel enabled
	DPPIC_CHENSET_CH7_Enabled = 0x1
	// Write: Enable channel
	DPPIC_CHENSET_CH7_Set = 0x1
	// Position of CH8 field.
	DPPIC_CHENSET_CH8_Pos = 0x8
	// Bit mask of CH8 field.
	DPPIC_CHENSET_CH8_Msk = 0x100
	// Bit CH8.
	DPPIC_CHENSET_CH8 = 0x100
	// Read: Channel disabled
	DPPIC_CHENSET_CH8_Disabled = 0x0
	// Read: Channel enabled
	DPPIC_CHENSET_CH8_Enabled = 0x1
	// Write: Enable channel
	DPPIC_CHENSET_CH8_Set = 0x1
	// Position of CH9 field.
	DPPIC_CHENSET_CH9_Pos = 0x9
	// Bit mask of CH9 field.
	DPPIC_CHENSET_CH9_Msk = 0x200
	// Bit CH9.
	DPPIC_CHENSET_CH9 = 0x200
	// Read: Channel disabled
	DPPIC_CHENSET_CH9_Disabled = 0x0
	// Read: Channel enabled
	DPPIC_CHENSET_CH9_Enabled = 0x1
	// Write: Enable channel
	DPPIC_CHENSET_CH9_Set = 0x1
	// Position of CH10 field.
	DPPIC_CHENSET_CH10_Pos = 0xa
	// Bit mask of CH10 field.
	DPPIC_CHENSET_CH10_Msk = 0x400
	// Bit CH10.
	DPPIC_CHENSET_CH10 = 0x400
	// Read: Channel disabled
	DPPIC_CHENSET_CH10_Disabled = 0x0
	// Read: Channel enabled
	DPPIC_CHENSET_CH10_Enabled = 0x1
	// Write: Enable channel
	DPPIC_CHENSET_CH10_Set = 0x1
	// Position of CH11 field.
	DPPIC_CHENSET_CH11_Pos = 0xb
	// Bit mask of CH11 field.
	DPPIC_CHENSET_CH11_Msk = 0x800
	// Bit CH11.
	DPPIC_CHENSET_CH11 = 0x800
	// Read: Channel disabled
	DPPIC_CHENSET_CH11_Disabled = 0x0
	// Read: Channel enabled
	DPPIC_CHENSET_CH11_Enabled = 0x1
	// Write: Enable channel
	DPPIC_CHENSET_CH11_Set = 0x1
	// Position of CH12 field.
	DPPIC_CHENSET_CH12_Pos = 0xc
	// Bit mask of CH12 field.
	DPPIC_CHENSET_CH12_Msk = 0x1000
	// Bit CH12.
	DPPIC_CHENSET_CH12 = 0x1000
	// Read: Channel disabled
	DPPIC_CHENSET_CH12_Disabled = 0x0
	// Read: Channel enabled
	DPPIC_CHENSET_CH12_Enabled = 0x1
	// Write: Enable channel
	DPPIC_CHENSET_CH12_Set = 0x1
	// Position of CH13 field.
	DPPIC_CHENSET_CH13_Pos = 0xd
	// Bit mask of CH13 field.
	DPPIC_CHENSET_CH13_Msk = 0x2000
	// Bit CH13.
	DPPIC_CHENSET_CH13 = 0x2000
	// Read: Channel disabled
	DPPIC_CHENSET_CH13_Disabled = 0x0
	// Read: Channel enabled
	DPPIC_CHENSET_CH13_Enabled = 0x1
	// Write: Enable channel
	DPPIC_CHENSET_CH13_Set = 0x1
	// Position of CH14 field.
	DPPIC_CHENSET_CH14_Pos = 0xe
	// Bit mask of CH14 field.
	DPPIC_CHENSET_CH14_Msk = 0x4000
	// Bit CH14.
	DPPIC_CHENSET_CH14 = 0x4000
	// Read: Channel disabled
	DPPIC_CHENSET_CH14_Disabled = 0x0
	// Read: Channel enabled
	DPPIC_CHENSET_CH14_Enabled = 0x1
	// Write: Enable channel
	DPPIC_CHENSET_CH14_Set = 0x1
	// Position of CH15 field.
	DPPIC_CHENSET_CH15_Pos = 0xf
	// Bit mask of CH15 field.
	DPPIC_CHENSET_CH15_Msk = 0x8000
	// Bit CH15.
	DPPIC_CHENSET_CH15 = 0x8000
	// Read: Channel disabled
	DPPIC_CHENSET_CH15_Disabled = 0x0
	// Read: Channel enabled
	DPPIC_CHENSET_CH15_Enabled = 0x1
	// Write: Enable channel
	DPPIC_CHENSET_CH15_Set = 0x1

	// CHENCLR: Channel enable clear register
	// Position of CH0 field.
	DPPIC_CHENCLR_CH0_Pos = 0x0
	// Bit mask of CH0 field.
	DPPIC_CHENCLR_CH0_Msk = 0x1
	// Bit CH0.
	DPPIC_CHENCLR_CH0 = 0x1
	// Read: Channel disabled
	DPPIC_CHENCLR_CH0_Disabled = 0x0
	// Read: Channel enabled
	DPPIC_CHENCLR_CH0_Enabled = 0x1
	// Write: Disable channel
	DPPIC_CHENCLR_CH0_Clear = 0x1
	// Position of CH1 field.
	DPPIC_CHENCLR_CH1_Pos = 0x1
	// Bit mask of CH1 field.
	DPPIC_CHENCLR_CH1_Msk = 0x2
	// Bit CH1.
	DPPIC_CHENCLR_CH1 = 0x2
	// Read: Channel disabled
	DPPIC_CHENCLR_CH1_Disabled = 0x0
	// Read: Channel enabled
	DPPIC_CHENCLR_CH1_Enabled = 0x1
	// Write: Disable channel
	DPPIC_CHENCLR_CH1_Clear = 0x1
	// Position of CH2 field.
	DPPIC_CHENCLR_CH2_Pos = 0x2
	// Bit mask of CH2 field.
	DPPIC_CHENCLR_CH2_Msk = 0x4
	// Bit CH2.
	DPPIC_CHENCLR_CH2 = 0x4
	// Read: Channel disabled
	DPPIC_CHENCLR_CH2_Disabled = 0x0
	// Read: Channel enabled
	DPPIC_CHENCLR_CH2_Enabled = 0x1
	// Write: Disable channel
	DPPIC_CHENCLR_CH2_Clear = 0x1
	// Position of CH3 field.
	DPPIC_CHENCLR_CH3_Pos = 0x3
	// Bit mask of CH3 field.
	DPPIC_CHENCLR_CH3_Msk = 0x8
	// Bit CH3.
	DPPIC_CHENCLR_CH3 = 0x8
	// Read: Channel disabled
	DPPIC_CHENCLR_CH3_Disabled = 0x0
	// Read: Channel enabled
	DPPIC_CHENCLR_CH3_Enabled = 0x1
	// Write: Disable channel
	DPPIC_CHENCLR_CH3_Clear = 0x1
	// Position of CH4 field.
	DPPIC_CHENCLR_CH4_Pos = 0x4
	// Bit mask of CH4 field.
	DPPIC_CHENCLR_CH4_Msk = 0x10
	// Bit CH4.
	DPPIC_CHENCLR_CH4 = 0x10
	// Read: Channel disabled
	DPPIC_CHENCLR_CH4_Disabled = 0x0
	// Read: Channel enabled
	DPPIC_CHENCLR_CH4_Enabled = 0x1
	// Write: Disable channel
	DPPIC_CHENCLR_CH4_Clear = 0x1
	// Position of CH5 field.
	DPPIC_CHENCLR_CH5_Pos = 0x5
	// Bit mask of CH5 field.
	DPPIC_CHENCLR_CH5_Msk = 0x20
	// Bit CH5.
	DPPIC_CHENCLR_CH5 = 0x20
	// Read: Channel disabled
	DPPIC_CHENCLR_CH5_Disabled = 0x0
	// Read: Channel enabled
	DPPIC_CHENCLR_CH5_Enabled = 0x1
	// Write: Disable channel
	DPPIC_CHENCLR_CH5_Clear = 0x1
	// Position of CH6 field.
	DPPIC_CHENCLR_CH6_Pos = 0x6
	// Bit mask of CH6 field.
	DPPIC_CHENCLR_CH6_Msk = 0x40
	// Bit CH6.
	DPPIC_CHENCLR_CH6 = 0x40
	// Read: Channel disabled
	DPPIC_CHENCLR_CH6_Disabled = 0x0
	// Read: Channel enabled
	DPPIC_CHENCLR_CH6_Enabled = 0x1
	// Write: Disable channel
	DPPIC_CHENCLR_CH6_Clear = 0x1
	// Position of CH7 field.
	DPPIC_CHENCLR_CH7_Pos = 0x7
	// Bit mask of CH7 field.
	DPPIC_CHENCLR_CH7_Msk = 0x80
	// Bit CH7.
	DPPIC_CHENCLR_CH7 = 0x80
	// Read: Channel disabled
	DPPIC_CHENCLR_CH7_Disabled = 0x0
	// Read: Channel enabled
	DPPIC_CHENCLR_CH7_Enabled = 0x1
	// Write: Disable channel
	DPPIC_CHENCLR_CH7_Clear = 0x1
	// Position of CH8 field.
	DPPIC_CHENCLR_CH8_Pos = 0x8
	// Bit mask of CH8 field.
	DPPIC_CHENCLR_CH8_Msk = 0x100
	// Bit CH8.
	DPPIC_CHENCLR_CH8 = 0x100
	// Read: Channel disabled
	DPPIC_CHENCLR_CH8_Disabled = 0x0
	// Read: Channel enabled
	DPPIC_CHENCLR_CH8_Enabled = 0x1
	// Write: Disable channel
	DPPIC_CHENCLR_CH8_Clear = 0x1
	// Position of CH9 field.
	DPPIC_CHENCLR_CH9_Pos = 0x9
	// Bit mask of CH9 field.
	DPPIC_CHENCLR_CH9_Msk = 0x200
	// Bit CH9.
	DPPIC_CHENCLR_CH9 = 0x200
	// Read: Channel disabled
	DPPIC_CHENCLR_CH9_Disabled = 0x0
	// Read: Channel enabled
	DPPIC_CHENCLR_CH9_Enabled = 0x1
	// Write: Disable channel
	DPPIC_CHENCLR_CH9_Clear = 0x1
	// Position of CH10 field.
	DPPIC_CHENCLR_CH10_Pos = 0xa
	// Bit mask of CH10 field.
	DPPIC_CHENCLR_CH10_Msk = 0x400
	// Bit CH10.
	DPPIC_CHENCLR_CH10 = 0x400
	// Read: Channel disabled
	DPPIC_CHENCLR_CH10_Disabled = 0x0
	// Read: Channel enabled
	DPPIC_CHENCLR_CH10_Enabled = 0x1
	// Write: Disable channel
	DPPIC_CHENCLR_CH10_Clear = 0x1
	// Position of CH11 field.
	DPPIC_CHENCLR_CH11_Pos = 0xb
	// Bit mask of CH11 field.
	DPPIC_CHENCLR_CH11_Msk = 0x800
	// Bit CH11.
	DPPIC_CHENCLR_CH11 = 0x800
	// Read: Channel disabled
	DPPIC_CHENCLR_CH11_Disabled = 0x0
	// Read: Channel enabled
	DPPIC_CHENCLR_CH11_Enabled = 0x1
	// Write: Disable channel
	DPPIC_CHENCLR_CH11_Clear = 0x1
	// Position of CH12 field.
	DPPIC_CHENCLR_CH12_Pos = 0xc
	// Bit mask of CH12 field.
	DPPIC_CHENCLR_CH12_Msk = 0x1000
	// Bit CH12.
	DPPIC_CHENCLR_CH12 = 0x1000
	// Read: Channel disabled
	DPPIC_CHENCLR_CH12_Disabled = 0x0
	// Read: Channel enabled
	DPPIC_CHENCLR_CH12_Enabled = 0x1
	// Write: Disable channel
	DPPIC_CHENCLR_CH12_Clear = 0x1
	// Position of CH13 field.
	DPPIC_CHENCLR_CH13_Pos = 0xd
	// Bit mask of CH13 field.
	DPPIC_CHENCLR_CH13_Msk = 0x2000
	// Bit CH13.
	DPPIC_CHENCLR_CH13 = 0x2000
	// Read: Channel disabled
	DPPIC_CHENCLR_CH13_Disabled = 0x0
	// Read: Channel enabled
	DPPIC_CHENCLR_CH13_Enabled = 0x1
	// Write: Disable channel
	DPPIC_CHENCLR_CH13_Clear = 0x1
	// Position of CH14 field.
	DPPIC_CHENCLR_CH14_Pos = 0xe
	// Bit mask of CH14 field.
	DPPIC_CHENCLR_CH14_Msk = 0x4000
	// Bit CH14.
	DPPIC_CHENCLR_CH14 = 0x4000
	// Read: Channel disabled
	DPPIC_CHENCLR_CH14_Disabled = 0x0
	// Read: Channel enabled
	DPPIC_CHENCLR_CH14_Enabled = 0x1
	// Write: Disable channel
	DPPIC_CHENCLR_CH14_Clear = 0x1
	// Position of CH15 field.
	DPPIC_CHENCLR_CH15_Pos = 0xf
	// Bit mask of CH15 field.
	DPPIC_CHENCLR_CH15_Msk = 0x8000
	// Bit CH15.
	DPPIC_CHENCLR_CH15 = 0x8000
	// Read: Channel disabled
	DPPIC_CHENCLR_CH15_Disabled = 0x0
	// Read: Channel enabled
	DPPIC_CHENCLR_CH15_Enabled = 0x1
	// Write: Disable channel
	DPPIC_CHENCLR_CH15_Clear = 0x1

	// CHG: Description collection: Channel group n Note: Writes to this register are ignored if either SUBSCRIBE_CHG[n].EN or SUBSCRIBE_CHG[n].DIS is enabled
	// Position of CH0 field.
	DPPIC_CHG_CH0_Pos = 0x0
	// Bit mask of CH0 field.
	DPPIC_CHG_CH0_Msk = 0x1
	// Bit CH0.
	DPPIC_CHG_CH0 = 0x1
	// Exclude
	DPPIC_CHG_CH0_Excluded = 0x0
	// Include
	DPPIC_CHG_CH0_Included = 0x1
	// Position of CH1 field.
	DPPIC_CHG_CH1_Pos = 0x1
	// Bit mask of CH1 field.
	DPPIC_CHG_CH1_Msk = 0x2
	// Bit CH1.
	DPPIC_CHG_CH1 = 0x2
	// Exclude
	DPPIC_CHG_CH1_Excluded = 0x0
	// Include
	DPPIC_CHG_CH1_Included = 0x1
	// Position of CH2 field.
	DPPIC_CHG_CH2_Pos = 0x2
	// Bit mask of CH2 field.
	DPPIC_CHG_CH2_Msk = 0x4
	// Bit CH2.
	DPPIC_CHG_CH2 = 0x4
	// Exclude
	DPPIC_CHG_CH2_Excluded = 0x0
	// Include
	DPPIC_CHG_CH2_Included = 0x1
	// Position of CH3 field.
	DPPIC_CHG_CH3_Pos = 0x3
	// Bit mask of CH3 field.
	DPPIC_CHG_CH3_Msk = 0x8
	// Bit CH3.
	DPPIC_CHG_CH3 = 0x8
	// Exclude
	DPPIC_CHG_CH3_Excluded = 0x0
	// Include
	DPPIC_CHG_CH3_Included = 0x1
	// Position of CH4 field.
	DPPIC_CHG_CH4_Pos = 0x4
	// Bit mask of CH4 field.
	DPPIC_CHG_CH4_Msk = 0x10
	// Bit CH4.
	DPPIC_CHG_CH4 = 0x10
	// Exclude
	DPPIC_CHG_CH4_Excluded = 0x0
	// Include
	DPPIC_CHG_CH4_Included = 0x1
	// Position of CH5 field.
	DPPIC_CHG_CH5_Pos = 0x5
	// Bit mask of CH5 field.
	DPPIC_CHG_CH5_Msk = 0x20
	// Bit CH5.
	DPPIC_CHG_CH5 = 0x20
	// Exclude
	DPPIC_CHG_CH5_Excluded = 0x0
	// Include
	DPPIC_CHG_CH5_Included = 0x1
	// Position of CH6 field.
	DPPIC_CHG_CH6_Pos = 0x6
	// Bit mask of CH6 field.
	DPPIC_CHG_CH6_Msk = 0x40
	// Bit CH6.
	DPPIC_CHG_CH6 = 0x40
	// Exclude
	DPPIC_CHG_CH6_Excluded = 0x0
	// Include
	DPPIC_CHG_CH6_Included = 0x1
	// Position of CH7 field.
	DPPIC_CHG_CH7_Pos = 0x7
	// Bit mask of CH7 field.
	DPPIC_CHG_CH7_Msk = 0x80
	// Bit CH7.
	DPPIC_CHG_CH7 = 0x80
	// Exclude
	DPPIC_CHG_CH7_Excluded = 0x0
	// Include
	DPPIC_CHG_CH7_Included = 0x1
	// Position of CH8 field.
	DPPIC_CHG_CH8_Pos = 0x8
	// Bit mask of CH8 field.
	DPPIC_CHG_CH8_Msk = 0x100
	// Bit CH8.
	DPPIC_CHG_CH8 = 0x100
	// Exclude
	DPPIC_CHG_CH8_Excluded = 0x0
	// Include
	DPPIC_CHG_CH8_Included = 0x1
	// Position of CH9 field.
	DPPIC_CHG_CH9_Pos = 0x9
	// Bit mask of CH9 field.
	DPPIC_CHG_CH9_Msk = 0x200
	// Bit CH9.
	DPPIC_CHG_CH9 = 0x200
	// Exclude
	DPPIC_CHG_CH9_Excluded = 0x0
	// Include
	DPPIC_CHG_CH9_Included = 0x1
	// Position of CH10 field.
	DPPIC_CHG_CH10_Pos = 0xa
	// Bit mask of CH10 field.
	DPPIC_CHG_CH10_Msk = 0x400
	// Bit CH10.
	DPPIC_CHG_CH10 = 0x400
	// Exclude
	DPPIC_CHG_CH10_Excluded = 0x0
	// Include
	DPPIC_CHG_CH10_Included = 0x1
	// Position of CH11 field.
	DPPIC_CHG_CH11_Pos = 0xb
	// Bit mask of CH11 field.
	DPPIC_CHG_CH11_Msk = 0x800
	// Bit CH11.
	DPPIC_CHG_CH11 = 0x800
	// Exclude
	DPPIC_CHG_CH11_Excluded = 0x0
	// Include
	DPPIC_CHG_CH11_Included = 0x1
	// Position of CH12 field.
	DPPIC_CHG_CH12_Pos = 0xc
	// Bit mask of CH12 field.
	DPPIC_CHG_CH12_Msk = 0x1000
	// Bit CH12.
	DPPIC_CHG_CH12 = 0x1000
	// Exclude
	DPPIC_CHG_CH12_Excluded = 0x0
	// Include
	DPPIC_CHG_CH12_Included = 0x1
	// Position of CH13 field.
	DPPIC_CHG_CH13_Pos = 0xd
	// Bit mask of CH13 field.
	DPPIC_CHG_CH13_Msk = 0x2000
	// Bit CH13.
	DPPIC_CHG_CH13 = 0x2000
	// Exclude
	DPPIC_CHG_CH13_Excluded = 0x0
	// Include
	DPPIC_CHG_CH13_Included = 0x1
	// Position of CH14 field.
	DPPIC_CHG_CH14_Pos = 0xe
	// Bit mask of CH14 field.
	DPPIC_CHG_CH14_Msk = 0x4000
	// Bit CH14.
	DPPIC_CHG_CH14 = 0x4000
	// Exclude
	DPPIC_CHG_CH14_Excluded = 0x0
	// Include
	DPPIC_CHG_CH14_Included = 0x1
	// Position of CH15 field.
	DPPIC_CHG_CH15_Pos = 0xf
	// Bit mask of CH15 field.
	DPPIC_CHG_CH15_Msk = 0x8000
	// Bit CH15.
	DPPIC_CHG_CH15 = 0x8000
	// Exclude
	DPPIC_CHG_CH15_Excluded = 0x0
	// Include
	DPPIC_CHG_CH15_Included = 0x1
)

// Constants for TEMP_NS: Temperature Sensor
const (
	// TASKS_START: Start temperature measurement
	// Position of TASKS_START field.
	TEMP_TASKS_START_TASKS_START_Pos = 0x0
	// Bit mask of TASKS_START field.
	TEMP_TASKS_START_TASKS_START_Msk = 0x1
	// Bit TASKS_START.
	TEMP_TASKS_START_TASKS_START = 0x1
	// Trigger task
	TEMP_TASKS_START_TASKS_START_Trigger = 0x1

	// TASKS_STOP: Stop temperature measurement
	// Position of TASKS_STOP field.
	TEMP_TASKS_STOP_TASKS_STOP_Pos = 0x0
	// Bit mask of TASKS_STOP field.
	TEMP_TASKS_STOP_TASKS_STOP_Msk = 0x1
	// Bit TASKS_STOP.
	TEMP_TASKS_STOP_TASKS_STOP = 0x1
	// Trigger task
	TEMP_TASKS_STOP_TASKS_STOP_Trigger = 0x1

	// SUBSCRIBE_START: Subscribe configuration for task START
	// Position of CHIDX field.
	TEMP_SUBSCRIBE_START_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	TEMP_SUBSCRIBE_START_CHIDX_Msk = 0xff
	// Position of EN field.
	TEMP_SUBSCRIBE_START_EN_Pos = 0x1f
	// Bit mask of EN field.
	TEMP_SUBSCRIBE_START_EN_Msk = 0x80000000
	// Bit EN.
	TEMP_SUBSCRIBE_START_EN = 0x80000000
	// Disable subscription
	TEMP_SUBSCRIBE_START_EN_Disabled = 0x0
	// Enable subscription
	TEMP_SUBSCRIBE_START_EN_Enabled = 0x1

	// SUBSCRIBE_STOP: Subscribe configuration for task STOP
	// Position of CHIDX field.
	TEMP_SUBSCRIBE_STOP_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	TEMP_SUBSCRIBE_STOP_CHIDX_Msk = 0xff
	// Position of EN field.
	TEMP_SUBSCRIBE_STOP_EN_Pos = 0x1f
	// Bit mask of EN field.
	TEMP_SUBSCRIBE_STOP_EN_Msk = 0x80000000
	// Bit EN.
	TEMP_SUBSCRIBE_STOP_EN = 0x80000000
	// Disable subscription
	TEMP_SUBSCRIBE_STOP_EN_Disabled = 0x0
	// Enable subscription
	TEMP_SUBSCRIBE_STOP_EN_Enabled = 0x1

	// EVENTS_DATARDY: Temperature measurement complete, data ready
	// Position of EVENTS_DATARDY field.
	TEMP_EVENTS_DATARDY_EVENTS_DATARDY_Pos = 0x0
	// Bit mask of EVENTS_DATARDY field.
	TEMP_EVENTS_DATARDY_EVENTS_DATARDY_Msk = 0x1
	// Bit EVENTS_DATARDY.
	TEMP_EVENTS_DATARDY_EVENTS_DATARDY = 0x1
	// Event not generated
	TEMP_EVENTS_DATARDY_EVENTS_DATARDY_NotGenerated = 0x0
	// Event generated
	TEMP_EVENTS_DATARDY_EVENTS_DATARDY_Generated = 0x1

	// PUBLISH_DATARDY: Publish configuration for event DATARDY
	// Position of CHIDX field.
	TEMP_PUBLISH_DATARDY_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	TEMP_PUBLISH_DATARDY_CHIDX_Msk = 0xff
	// Position of EN field.
	TEMP_PUBLISH_DATARDY_EN_Pos = 0x1f
	// Bit mask of EN field.
	TEMP_PUBLISH_DATARDY_EN_Msk = 0x80000000
	// Bit EN.
	TEMP_PUBLISH_DATARDY_EN = 0x80000000
	// Disable publishing
	TEMP_PUBLISH_DATARDY_EN_Disabled = 0x0
	// Enable publishing
	TEMP_PUBLISH_DATARDY_EN_Enabled = 0x1

	// INTENSET: Enable interrupt
	// Position of DATARDY field.
	TEMP_INTENSET_DATARDY_Pos = 0x0
	// Bit mask of DATARDY field.
	TEMP_INTENSET_DATARDY_Msk = 0x1
	// Bit DATARDY.
	TEMP_INTENSET_DATARDY = 0x1
	// Read: Disabled
	TEMP_INTENSET_DATARDY_Disabled = 0x0
	// Read: Enabled
	TEMP_INTENSET_DATARDY_Enabled = 0x1
	// Enable
	TEMP_INTENSET_DATARDY_Set = 0x1

	// INTENCLR: Disable interrupt
	// Position of DATARDY field.
	TEMP_INTENCLR_DATARDY_Pos = 0x0
	// Bit mask of DATARDY field.
	TEMP_INTENCLR_DATARDY_Msk = 0x1
	// Bit DATARDY.
	TEMP_INTENCLR_DATARDY = 0x1
	// Read: Disabled
	TEMP_INTENCLR_DATARDY_Disabled = 0x0
	// Read: Enabled
	TEMP_INTENCLR_DATARDY_Enabled = 0x1
	// Disable
	TEMP_INTENCLR_DATARDY_Clear = 0x1

	// TEMP: Temperature in degC (0.25deg steps)
	// Position of TEMP field.
	TEMP_TEMP_TEMP_Pos = 0x0
	// Bit mask of TEMP field.
	TEMP_TEMP_TEMP_Msk = 0xffffffff

	// A0: Slope of 1st piece wise linear function
	// Position of A0 field.
	TEMP_A0_A0_Pos = 0x0
	// Bit mask of A0 field.
	TEMP_A0_A0_Msk = 0xfff

	// A1: Slope of 2nd piece wise linear function
	// Position of A1 field.
	TEMP_A1_A1_Pos = 0x0
	// Bit mask of A1 field.
	TEMP_A1_A1_Msk = 0xfff

	// A2: Slope of 3rd piece wise linear function
	// Position of A2 field.
	TEMP_A2_A2_Pos = 0x0
	// Bit mask of A2 field.
	TEMP_A2_A2_Msk = 0xfff

	// A3: Slope of 4th piece wise linear function
	// Position of A3 field.
	TEMP_A3_A3_Pos = 0x0
	// Bit mask of A3 field.
	TEMP_A3_A3_Msk = 0xfff

	// A4: Slope of 5th piece wise linear function
	// Position of A4 field.
	TEMP_A4_A4_Pos = 0x0
	// Bit mask of A4 field.
	TEMP_A4_A4_Msk = 0xfff

	// A5: Slope of 6th piece wise linear function
	// Position of A5 field.
	TEMP_A5_A5_Pos = 0x0
	// Bit mask of A5 field.
	TEMP_A5_A5_Msk = 0xfff

	// B0: y-intercept of 1st piece wise linear function
	// Position of B0 field.
	TEMP_B0_B0_Pos = 0x0
	// Bit mask of B0 field.
	TEMP_B0_B0_Msk = 0xfff

	// B1: y-intercept of 2nd piece wise linear function
	// Position of B1 field.
	TEMP_B1_B1_Pos = 0x0
	// Bit mask of B1 field.
	TEMP_B1_B1_Msk = 0xfff

	// B2: y-intercept of 3rd piece wise linear function
	// Position of B2 field.
	TEMP_B2_B2_Pos = 0x0
	// Bit mask of B2 field.
	TEMP_B2_B2_Msk = 0xfff

	// B3: y-intercept of 4th piece wise linear function
	// Position of B3 field.
	TEMP_B3_B3_Pos = 0x0
	// Bit mask of B3 field.
	TEMP_B3_B3_Msk = 0xfff

	// B4: y-intercept of 5th piece wise linear function
	// Position of B4 field.
	TEMP_B4_B4_Pos = 0x0
	// Bit mask of B4 field.
	TEMP_B4_B4_Msk = 0xfff

	// B5: y-intercept of 6th piece wise linear function
	// Position of B5 field.
	TEMP_B5_B5_Pos = 0x0
	// Bit mask of B5 field.
	TEMP_B5_B5_Msk = 0xfff

	// T0: End point of 1st piece wise linear function
	// Position of T0 field.
	TEMP_T0_T0_Pos = 0x0
	// Bit mask of T0 field.
	TEMP_T0_T0_Msk = 0xff

	// T1: End point of 2nd piece wise linear function
	// Position of T1 field.
	TEMP_T1_T1_Pos = 0x0
	// Bit mask of T1 field.
	TEMP_T1_T1_Msk = 0xff

	// T2: End point of 3rd piece wise linear function
	// Position of T2 field.
	TEMP_T2_T2_Pos = 0x0
	// Bit mask of T2 field.
	TEMP_T2_T2_Msk = 0xff

	// T3: End point of 4th piece wise linear function
	// Position of T3 field.
	TEMP_T3_T3_Pos = 0x0
	// Bit mask of T3 field.
	TEMP_T3_T3_Msk = 0xff

	// T4: End point of 5th piece wise linear function
	// Position of T4 field.
	TEMP_T4_T4_Pos = 0x0
	// Bit mask of T4 field.
	TEMP_T4_T4_Msk = 0xff
)

// Constants for RTC0_NS: Real-time counter 0
const (
	// TASKS_START: Start RTC counter
	// Position of TASKS_START field.
	RTC_TASKS_START_TASKS_START_Pos = 0x0
	// Bit mask of TASKS_START field.
	RTC_TASKS_START_TASKS_START_Msk = 0x1
	// Bit TASKS_START.
	RTC_TASKS_START_TASKS_START = 0x1
	// Trigger task
	RTC_TASKS_START_TASKS_START_Trigger = 0x1

	// TASKS_STOP: Stop RTC counter
	// Position of TASKS_STOP field.
	RTC_TASKS_STOP_TASKS_STOP_Pos = 0x0
	// Bit mask of TASKS_STOP field.
	RTC_TASKS_STOP_TASKS_STOP_Msk = 0x1
	// Bit TASKS_STOP.
	RTC_TASKS_STOP_TASKS_STOP = 0x1
	// Trigger task
	RTC_TASKS_STOP_TASKS_STOP_Trigger = 0x1

	// TASKS_CLEAR: Clear RTC counter
	// Position of TASKS_CLEAR field.
	RTC_TASKS_CLEAR_TASKS_CLEAR_Pos = 0x0
	// Bit mask of TASKS_CLEAR field.
	RTC_TASKS_CLEAR_TASKS_CLEAR_Msk = 0x1
	// Bit TASKS_CLEAR.
	RTC_TASKS_CLEAR_TASKS_CLEAR = 0x1
	// Trigger task
	RTC_TASKS_CLEAR_TASKS_CLEAR_Trigger = 0x1

	// TASKS_TRIGOVRFLW: Set counter to 0xFFFFF0
	// Position of TASKS_TRIGOVRFLW field.
	RTC_TASKS_TRIGOVRFLW_TASKS_TRIGOVRFLW_Pos = 0x0
	// Bit mask of TASKS_TRIGOVRFLW field.
	RTC_TASKS_TRIGOVRFLW_TASKS_TRIGOVRFLW_Msk = 0x1
	// Bit TASKS_TRIGOVRFLW.
	RTC_TASKS_TRIGOVRFLW_TASKS_TRIGOVRFLW = 0x1
	// Trigger task
	RTC_TASKS_TRIGOVRFLW_TASKS_TRIGOVRFLW_Trigger = 0x1

	// TASKS_CAPTURE: Description collection: Capture RTC counter to CC[n] register
	// Position of TASKS_CAPTURE field.
	RTC_TASKS_CAPTURE_TASKS_CAPTURE_Pos = 0x0
	// Bit mask of TASKS_CAPTURE field.
	RTC_TASKS_CAPTURE_TASKS_CAPTURE_Msk = 0x1
	// Bit TASKS_CAPTURE.
	RTC_TASKS_CAPTURE_TASKS_CAPTURE = 0x1
	// Trigger task
	RTC_TASKS_CAPTURE_TASKS_CAPTURE_Trigger = 0x1

	// SUBSCRIBE_START: Subscribe configuration for task START
	// Position of CHIDX field.
	RTC_SUBSCRIBE_START_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	RTC_SUBSCRIBE_START_CHIDX_Msk = 0xff
	// Position of EN field.
	RTC_SUBSCRIBE_START_EN_Pos = 0x1f
	// Bit mask of EN field.
	RTC_SUBSCRIBE_START_EN_Msk = 0x80000000
	// Bit EN.
	RTC_SUBSCRIBE_START_EN = 0x80000000
	// Disable subscription
	RTC_SUBSCRIBE_START_EN_Disabled = 0x0
	// Enable subscription
	RTC_SUBSCRIBE_START_EN_Enabled = 0x1

	// SUBSCRIBE_STOP: Subscribe configuration for task STOP
	// Position of CHIDX field.
	RTC_SUBSCRIBE_STOP_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	RTC_SUBSCRIBE_STOP_CHIDX_Msk = 0xff
	// Position of EN field.
	RTC_SUBSCRIBE_STOP_EN_Pos = 0x1f
	// Bit mask of EN field.
	RTC_SUBSCRIBE_STOP_EN_Msk = 0x80000000
	// Bit EN.
	RTC_SUBSCRIBE_STOP_EN = 0x80000000
	// Disable subscription
	RTC_SUBSCRIBE_STOP_EN_Disabled = 0x0
	// Enable subscription
	RTC_SUBSCRIBE_STOP_EN_Enabled = 0x1

	// SUBSCRIBE_CLEAR: Subscribe configuration for task CLEAR
	// Position of CHIDX field.
	RTC_SUBSCRIBE_CLEAR_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	RTC_SUBSCRIBE_CLEAR_CHIDX_Msk = 0xff
	// Position of EN field.
	RTC_SUBSCRIBE_CLEAR_EN_Pos = 0x1f
	// Bit mask of EN field.
	RTC_SUBSCRIBE_CLEAR_EN_Msk = 0x80000000
	// Bit EN.
	RTC_SUBSCRIBE_CLEAR_EN = 0x80000000
	// Disable subscription
	RTC_SUBSCRIBE_CLEAR_EN_Disabled = 0x0
	// Enable subscription
	RTC_SUBSCRIBE_CLEAR_EN_Enabled = 0x1

	// SUBSCRIBE_TRIGOVRFLW: Subscribe configuration for task TRIGOVRFLW
	// Position of CHIDX field.
	RTC_SUBSCRIBE_TRIGOVRFLW_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	RTC_SUBSCRIBE_TRIGOVRFLW_CHIDX_Msk = 0xff
	// Position of EN field.
	RTC_SUBSCRIBE_TRIGOVRFLW_EN_Pos = 0x1f
	// Bit mask of EN field.
	RTC_SUBSCRIBE_TRIGOVRFLW_EN_Msk = 0x80000000
	// Bit EN.
	RTC_SUBSCRIBE_TRIGOVRFLW_EN = 0x80000000
	// Disable subscription
	RTC_SUBSCRIBE_TRIGOVRFLW_EN_Disabled = 0x0
	// Enable subscription
	RTC_SUBSCRIBE_TRIGOVRFLW_EN_Enabled = 0x1

	// SUBSCRIBE_CAPTURE: Description collection: Subscribe configuration for task CAPTURE[n]
	// Position of CHIDX field.
	RTC_SUBSCRIBE_CAPTURE_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	RTC_SUBSCRIBE_CAPTURE_CHIDX_Msk = 0xff
	// Position of EN field.
	RTC_SUBSCRIBE_CAPTURE_EN_Pos = 0x1f
	// Bit mask of EN field.
	RTC_SUBSCRIBE_CAPTURE_EN_Msk = 0x80000000
	// Bit EN.
	RTC_SUBSCRIBE_CAPTURE_EN = 0x80000000
	// Disable subscription
	RTC_SUBSCRIBE_CAPTURE_EN_Disabled = 0x0
	// Enable subscription
	RTC_SUBSCRIBE_CAPTURE_EN_Enabled = 0x1

	// EVENTS_TICK: Event on counter increment
	// Position of EVENTS_TICK field.
	RTC_EVENTS_TICK_EVENTS_TICK_Pos = 0x0
	// Bit mask of EVENTS_TICK field.
	RTC_EVENTS_TICK_EVENTS_TICK_Msk = 0x1
	// Bit EVENTS_TICK.
	RTC_EVENTS_TICK_EVENTS_TICK = 0x1
	// Event not generated
	RTC_EVENTS_TICK_EVENTS_TICK_NotGenerated = 0x0
	// Event generated
	RTC_EVENTS_TICK_EVENTS_TICK_Generated = 0x1

	// EVENTS_OVRFLW: Event on counter overflow
	// Position of EVENTS_OVRFLW field.
	RTC_EVENTS_OVRFLW_EVENTS_OVRFLW_Pos = 0x0
	// Bit mask of EVENTS_OVRFLW field.
	RTC_EVENTS_OVRFLW_EVENTS_OVRFLW_Msk = 0x1
	// Bit EVENTS_OVRFLW.
	RTC_EVENTS_OVRFLW_EVENTS_OVRFLW = 0x1
	// Event not generated
	RTC_EVENTS_OVRFLW_EVENTS_OVRFLW_NotGenerated = 0x0
	// Event generated
	RTC_EVENTS_OVRFLW_EVENTS_OVRFLW_Generated = 0x1

	// EVENTS_COMPARE: Description collection: Compare event on CC[n] match
	// Position of EVENTS_COMPARE field.
	RTC_EVENTS_COMPARE_EVENTS_COMPARE_Pos = 0x0
	// Bit mask of EVENTS_COMPARE field.
	RTC_EVENTS_COMPARE_EVENTS_COMPARE_Msk = 0x1
	// Bit EVENTS_COMPARE.
	RTC_EVENTS_COMPARE_EVENTS_COMPARE = 0x1
	// Event not generated
	RTC_EVENTS_COMPARE_EVENTS_COMPARE_NotGenerated = 0x0
	// Event generated
	RTC_EVENTS_COMPARE_EVENTS_COMPARE_Generated = 0x1

	// PUBLISH_TICK: Publish configuration for event TICK
	// Position of CHIDX field.
	RTC_PUBLISH_TICK_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	RTC_PUBLISH_TICK_CHIDX_Msk = 0xff
	// Position of EN field.
	RTC_PUBLISH_TICK_EN_Pos = 0x1f
	// Bit mask of EN field.
	RTC_PUBLISH_TICK_EN_Msk = 0x80000000
	// Bit EN.
	RTC_PUBLISH_TICK_EN = 0x80000000
	// Disable publishing
	RTC_PUBLISH_TICK_EN_Disabled = 0x0
	// Enable publishing
	RTC_PUBLISH_TICK_EN_Enabled = 0x1

	// PUBLISH_OVRFLW: Publish configuration for event OVRFLW
	// Position of CHIDX field.
	RTC_PUBLISH_OVRFLW_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	RTC_PUBLISH_OVRFLW_CHIDX_Msk = 0xff
	// Position of EN field.
	RTC_PUBLISH_OVRFLW_EN_Pos = 0x1f
	// Bit mask of EN field.
	RTC_PUBLISH_OVRFLW_EN_Msk = 0x80000000
	// Bit EN.
	RTC_PUBLISH_OVRFLW_EN = 0x80000000
	// Disable publishing
	RTC_PUBLISH_OVRFLW_EN_Disabled = 0x0
	// Enable publishing
	RTC_PUBLISH_OVRFLW_EN_Enabled = 0x1

	// PUBLISH_COMPARE: Description collection: Publish configuration for event COMPARE[n]
	// Position of CHIDX field.
	RTC_PUBLISH_COMPARE_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	RTC_PUBLISH_COMPARE_CHIDX_Msk = 0xff
	// Position of EN field.
	RTC_PUBLISH_COMPARE_EN_Pos = 0x1f
	// Bit mask of EN field.
	RTC_PUBLISH_COMPARE_EN_Msk = 0x80000000
	// Bit EN.
	RTC_PUBLISH_COMPARE_EN = 0x80000000
	// Disable publishing
	RTC_PUBLISH_COMPARE_EN_Disabled = 0x0
	// Enable publishing
	RTC_PUBLISH_COMPARE_EN_Enabled = 0x1

	// SHORTS: Shortcuts between local events and tasks
	// Position of COMPARE0_CLEAR field.
	RTC_SHORTS_COMPARE0_CLEAR_Pos = 0x0
	// Bit mask of COMPARE0_CLEAR field.
	RTC_SHORTS_COMPARE0_CLEAR_Msk = 0x1
	// Bit COMPARE0_CLEAR.
	RTC_SHORTS_COMPARE0_CLEAR = 0x1
	// Disable shortcut
	RTC_SHORTS_COMPARE0_CLEAR_Disabled = 0x0
	// Enable shortcut
	RTC_SHORTS_COMPARE0_CLEAR_Enabled = 0x1
	// Position of COMPARE1_CLEAR field.
	RTC_SHORTS_COMPARE1_CLEAR_Pos = 0x1
	// Bit mask of COMPARE1_CLEAR field.
	RTC_SHORTS_COMPARE1_CLEAR_Msk = 0x2
	// Bit COMPARE1_CLEAR.
	RTC_SHORTS_COMPARE1_CLEAR = 0x2
	// Disable shortcut
	RTC_SHORTS_COMPARE1_CLEAR_Disabled = 0x0
	// Enable shortcut
	RTC_SHORTS_COMPARE1_CLEAR_Enabled = 0x1
	// Position of COMPARE2_CLEAR field.
	RTC_SHORTS_COMPARE2_CLEAR_Pos = 0x2
	// Bit mask of COMPARE2_CLEAR field.
	RTC_SHORTS_COMPARE2_CLEAR_Msk = 0x4
	// Bit COMPARE2_CLEAR.
	RTC_SHORTS_COMPARE2_CLEAR = 0x4
	// Disable shortcut
	RTC_SHORTS_COMPARE2_CLEAR_Disabled = 0x0
	// Enable shortcut
	RTC_SHORTS_COMPARE2_CLEAR_Enabled = 0x1
	// Position of COMPARE3_CLEAR field.
	RTC_SHORTS_COMPARE3_CLEAR_Pos = 0x3
	// Bit mask of COMPARE3_CLEAR field.
	RTC_SHORTS_COMPARE3_CLEAR_Msk = 0x8
	// Bit COMPARE3_CLEAR.
	RTC_SHORTS_COMPARE3_CLEAR = 0x8
	// Disable shortcut
	RTC_SHORTS_COMPARE3_CLEAR_Disabled = 0x0
	// Enable shortcut
	RTC_SHORTS_COMPARE3_CLEAR_Enabled = 0x1

	// INTENSET: Enable interrupt
	// Position of TICK field.
	RTC_INTENSET_TICK_Pos = 0x0
	// Bit mask of TICK field.
	RTC_INTENSET_TICK_Msk = 0x1
	// Bit TICK.
	RTC_INTENSET_TICK = 0x1
	// Read: Disabled
	RTC_INTENSET_TICK_Disabled = 0x0
	// Read: Enabled
	RTC_INTENSET_TICK_Enabled = 0x1
	// Enable
	RTC_INTENSET_TICK_Set = 0x1
	// Position of OVRFLW field.
	RTC_INTENSET_OVRFLW_Pos = 0x1
	// Bit mask of OVRFLW field.
	RTC_INTENSET_OVRFLW_Msk = 0x2
	// Bit OVRFLW.
	RTC_INTENSET_OVRFLW = 0x2
	// Read: Disabled
	RTC_INTENSET_OVRFLW_Disabled = 0x0
	// Read: Enabled
	RTC_INTENSET_OVRFLW_Enabled = 0x1
	// Enable
	RTC_INTENSET_OVRFLW_Set = 0x1
	// Position of COMPARE0 field.
	RTC_INTENSET_COMPARE0_Pos = 0x10
	// Bit mask of COMPARE0 field.
	RTC_INTENSET_COMPARE0_Msk = 0x10000
	// Bit COMPARE0.
	RTC_INTENSET_COMPARE0 = 0x10000
	// Read: Disabled
	RTC_INTENSET_COMPARE0_Disabled = 0x0
	// Read: Enabled
	RTC_INTENSET_COMPARE0_Enabled = 0x1
	// Enable
	RTC_INTENSET_COMPARE0_Set = 0x1
	// Position of COMPARE1 field.
	RTC_INTENSET_COMPARE1_Pos = 0x11
	// Bit mask of COMPARE1 field.
	RTC_INTENSET_COMPARE1_Msk = 0x20000
	// Bit COMPARE1.
	RTC_INTENSET_COMPARE1 = 0x20000
	// Read: Disabled
	RTC_INTENSET_COMPARE1_Disabled = 0x0
	// Read: Enabled
	RTC_INTENSET_COMPARE1_Enabled = 0x1
	// Enable
	RTC_INTENSET_COMPARE1_Set = 0x1
	// Position of COMPARE2 field.
	RTC_INTENSET_COMPARE2_Pos = 0x12
	// Bit mask of COMPARE2 field.
	RTC_INTENSET_COMPARE2_Msk = 0x40000
	// Bit COMPARE2.
	RTC_INTENSET_COMPARE2 = 0x40000
	// Read: Disabled
	RTC_INTENSET_COMPARE2_Disabled = 0x0
	// Read: Enabled
	RTC_INTENSET_COMPARE2_Enabled = 0x1
	// Enable
	RTC_INTENSET_COMPARE2_Set = 0x1
	// Position of COMPARE3 field.
	RTC_INTENSET_COMPARE3_Pos = 0x13
	// Bit mask of COMPARE3 field.
	RTC_INTENSET_COMPARE3_Msk = 0x80000
	// Bit COMPARE3.
	RTC_INTENSET_COMPARE3 = 0x80000
	// Read: Disabled
	RTC_INTENSET_COMPARE3_Disabled = 0x0
	// Read: Enabled
	RTC_INTENSET_COMPARE3_Enabled = 0x1
	// Enable
	RTC_INTENSET_COMPARE3_Set = 0x1

	// INTENCLR: Disable interrupt
	// Position of TICK field.
	RTC_INTENCLR_TICK_Pos = 0x0
	// Bit mask of TICK field.
	RTC_INTENCLR_TICK_Msk = 0x1
	// Bit TICK.
	RTC_INTENCLR_TICK = 0x1
	// Read: Disabled
	RTC_INTENCLR_TICK_Disabled = 0x0
	// Read: Enabled
	RTC_INTENCLR_TICK_Enabled = 0x1
	// Disable
	RTC_INTENCLR_TICK_Clear = 0x1
	// Position of OVRFLW field.
	RTC_INTENCLR_OVRFLW_Pos = 0x1
	// Bit mask of OVRFLW field.
	RTC_INTENCLR_OVRFLW_Msk = 0x2
	// Bit OVRFLW.
	RTC_INTENCLR_OVRFLW = 0x2
	// Read: Disabled
	RTC_INTENCLR_OVRFLW_Disabled = 0x0
	// Read: Enabled
	RTC_INTENCLR_OVRFLW_Enabled = 0x1
	// Disable
	RTC_INTENCLR_OVRFLW_Clear = 0x1
	// Position of COMPARE0 field.
	RTC_INTENCLR_COMPARE0_Pos = 0x10
	// Bit mask of COMPARE0 field.
	RTC_INTENCLR_COMPARE0_Msk = 0x10000
	// Bit COMPARE0.
	RTC_INTENCLR_COMPARE0 = 0x10000
	// Read: Disabled
	RTC_INTENCLR_COMPARE0_Disabled = 0x0
	// Read: Enabled
	RTC_INTENCLR_COMPARE0_Enabled = 0x1
	// Disable
	RTC_INTENCLR_COMPARE0_Clear = 0x1
	// Position of COMPARE1 field.
	RTC_INTENCLR_COMPARE1_Pos = 0x11
	// Bit mask of COMPARE1 field.
	RTC_INTENCLR_COMPARE1_Msk = 0x20000
	// Bit COMPARE1.
	RTC_INTENCLR_COMPARE1 = 0x20000
	// Read: Disabled
	RTC_INTENCLR_COMPARE1_Disabled = 0x0
	// Read: Enabled
	RTC_INTENCLR_COMPARE1_Enabled = 0x1
	// Disable
	RTC_INTENCLR_COMPARE1_Clear = 0x1
	// Position of COMPARE2 field.
	RTC_INTENCLR_COMPARE2_Pos = 0x12
	// Bit mask of COMPARE2 field.
	RTC_INTENCLR_COMPARE2_Msk = 0x40000
	// Bit COMPARE2.
	RTC_INTENCLR_COMPARE2 = 0x40000
	// Read: Disabled
	RTC_INTENCLR_COMPARE2_Disabled = 0x0
	// Read: Enabled
	RTC_INTENCLR_COMPARE2_Enabled = 0x1
	// Disable
	RTC_INTENCLR_COMPARE2_Clear = 0x1
	// Position of COMPARE3 field.
	RTC_INTENCLR_COMPARE3_Pos = 0x13
	// Bit mask of COMPARE3 field.
	RTC_INTENCLR_COMPARE3_Msk = 0x80000
	// Bit COMPARE3.
	RTC_INTENCLR_COMPARE3 = 0x80000
	// Read: Disabled
	RTC_INTENCLR_COMPARE3_Disabled = 0x0
	// Read: Enabled
	RTC_INTENCLR_COMPARE3_Enabled = 0x1
	// Disable
	RTC_INTENCLR_COMPARE3_Clear = 0x1

	// EVTEN: Enable or disable event routing
	// Position of TICK field.
	RTC_EVTEN_TICK_Pos = 0x0
	// Bit mask of TICK field.
	RTC_EVTEN_TICK_Msk = 0x1
	// Bit TICK.
	RTC_EVTEN_TICK = 0x1
	// Disable
	RTC_EVTEN_TICK_Disabled = 0x0
	// Enable
	RTC_EVTEN_TICK_Enabled = 0x1
	// Position of OVRFLW field.
	RTC_EVTEN_OVRFLW_Pos = 0x1
	// Bit mask of OVRFLW field.
	RTC_EVTEN_OVRFLW_Msk = 0x2
	// Bit OVRFLW.
	RTC_EVTEN_OVRFLW = 0x2
	// Disable
	RTC_EVTEN_OVRFLW_Disabled = 0x0
	// Enable
	RTC_EVTEN_OVRFLW_Enabled = 0x1
	// Position of COMPARE0 field.
	RTC_EVTEN_COMPARE0_Pos = 0x10
	// Bit mask of COMPARE0 field.
	RTC_EVTEN_COMPARE0_Msk = 0x10000
	// Bit COMPARE0.
	RTC_EVTEN_COMPARE0 = 0x10000
	// Disable
	RTC_EVTEN_COMPARE0_Disabled = 0x0
	// Enable
	RTC_EVTEN_COMPARE0_Enabled = 0x1
	// Position of COMPARE1 field.
	RTC_EVTEN_COMPARE1_Pos = 0x11
	// Bit mask of COMPARE1 field.
	RTC_EVTEN_COMPARE1_Msk = 0x20000
	// Bit COMPARE1.
	RTC_EVTEN_COMPARE1 = 0x20000
	// Disable
	RTC_EVTEN_COMPARE1_Disabled = 0x0
	// Enable
	RTC_EVTEN_COMPARE1_Enabled = 0x1
	// Position of COMPARE2 field.
	RTC_EVTEN_COMPARE2_Pos = 0x12
	// Bit mask of COMPARE2 field.
	RTC_EVTEN_COMPARE2_Msk = 0x40000
	// Bit COMPARE2.
	RTC_EVTEN_COMPARE2 = 0x40000
	// Disable
	RTC_EVTEN_COMPARE2_Disabled = 0x0
	// Enable
	RTC_EVTEN_COMPARE2_Enabled = 0x1
	// Position of COMPARE3 field.
	RTC_EVTEN_COMPARE3_Pos = 0x13
	// Bit mask of COMPARE3 field.
	RTC_EVTEN_COMPARE3_Msk = 0x80000
	// Bit COMPARE3.
	RTC_EVTEN_COMPARE3 = 0x80000
	// Disable
	RTC_EVTEN_COMPARE3_Disabled = 0x0
	// Enable
	RTC_EVTEN_COMPARE3_Enabled = 0x1

	// EVTENSET: Enable event routing
	// Position of TICK field.
	RTC_EVTENSET_TICK_Pos = 0x0
	// Bit mask of TICK field.
	RTC_EVTENSET_TICK_Msk = 0x1
	// Bit TICK.
	RTC_EVTENSET_TICK = 0x1
	// Read: Disabled
	RTC_EVTENSET_TICK_Disabled = 0x0
	// Read: Enabled
	RTC_EVTENSET_TICK_Enabled = 0x1
	// Enable
	RTC_EVTENSET_TICK_Set = 0x1
	// Position of OVRFLW field.
	RTC_EVTENSET_OVRFLW_Pos = 0x1
	// Bit mask of OVRFLW field.
	RTC_EVTENSET_OVRFLW_Msk = 0x2
	// Bit OVRFLW.
	RTC_EVTENSET_OVRFLW = 0x2
	// Read: Disabled
	RTC_EVTENSET_OVRFLW_Disabled = 0x0
	// Read: Enabled
	RTC_EVTENSET_OVRFLW_Enabled = 0x1
	// Enable
	RTC_EVTENSET_OVRFLW_Set = 0x1
	// Position of COMPARE0 field.
	RTC_EVTENSET_COMPARE0_Pos = 0x10
	// Bit mask of COMPARE0 field.
	RTC_EVTENSET_COMPARE0_Msk = 0x10000
	// Bit COMPARE0.
	RTC_EVTENSET_COMPARE0 = 0x10000
	// Read: Disabled
	RTC_EVTENSET_COMPARE0_Disabled = 0x0
	// Read: Enabled
	RTC_EVTENSET_COMPARE0_Enabled = 0x1
	// Enable
	RTC_EVTENSET_COMPARE0_Set = 0x1
	// Position of COMPARE1 field.
	RTC_EVTENSET_COMPARE1_Pos = 0x11
	// Bit mask of COMPARE1 field.
	RTC_EVTENSET_COMPARE1_Msk = 0x20000
	// Bit COMPARE1.
	RTC_EVTENSET_COMPARE1 = 0x20000
	// Read: Disabled
	RTC_EVTENSET_COMPARE1_Disabled = 0x0
	// Read: Enabled
	RTC_EVTENSET_COMPARE1_Enabled = 0x1
	// Enable
	RTC_EVTENSET_COMPARE1_Set = 0x1
	// Position of COMPARE2 field.
	RTC_EVTENSET_COMPARE2_Pos = 0x12
	// Bit mask of COMPARE2 field.
	RTC_EVTENSET_COMPARE2_Msk = 0x40000
	// Bit COMPARE2.
	RTC_EVTENSET_COMPARE2 = 0x40000
	// Read: Disabled
	RTC_EVTENSET_COMPARE2_Disabled = 0x0
	// Read: Enabled
	RTC_EVTENSET_COMPARE2_Enabled = 0x1
	// Enable
	RTC_EVTENSET_COMPARE2_Set = 0x1
	// Position of COMPARE3 field.
	RTC_EVTENSET_COMPARE3_Pos = 0x13
	// Bit mask of COMPARE3 field.
	RTC_EVTENSET_COMPARE3_Msk = 0x80000
	// Bit COMPARE3.
	RTC_EVTENSET_COMPARE3 = 0x80000
	// Read: Disabled
	RTC_EVTENSET_COMPARE3_Disabled = 0x0
	// Read: Enabled
	RTC_EVTENSET_COMPARE3_Enabled = 0x1
	// Enable
	RTC_EVTENSET_COMPARE3_Set = 0x1

	// EVTENCLR: Disable event routing
	// Position of TICK field.
	RTC_EVTENCLR_TICK_Pos = 0x0
	// Bit mask of TICK field.
	RTC_EVTENCLR_TICK_Msk = 0x1
	// Bit TICK.
	RTC_EVTENCLR_TICK = 0x1
	// Read: Disabled
	RTC_EVTENCLR_TICK_Disabled = 0x0
	// Read: Enabled
	RTC_EVTENCLR_TICK_Enabled = 0x1
	// Disable
	RTC_EVTENCLR_TICK_Clear = 0x1
	// Position of OVRFLW field.
	RTC_EVTENCLR_OVRFLW_Pos = 0x1
	// Bit mask of OVRFLW field.
	RTC_EVTENCLR_OVRFLW_Msk = 0x2
	// Bit OVRFLW.
	RTC_EVTENCLR_OVRFLW = 0x2
	// Read: Disabled
	RTC_EVTENCLR_OVRFLW_Disabled = 0x0
	// Read: Enabled
	RTC_EVTENCLR_OVRFLW_Enabled = 0x1
	// Disable
	RTC_EVTENCLR_OVRFLW_Clear = 0x1
	// Position of COMPARE0 field.
	RTC_EVTENCLR_COMPARE0_Pos = 0x10
	// Bit mask of COMPARE0 field.
	RTC_EVTENCLR_COMPARE0_Msk = 0x10000
	// Bit COMPARE0.
	RTC_EVTENCLR_COMPARE0 = 0x10000
	// Read: Disabled
	RTC_EVTENCLR_COMPARE0_Disabled = 0x0
	// Read: Enabled
	RTC_EVTENCLR_COMPARE0_Enabled = 0x1
	// Disable
	RTC_EVTENCLR_COMPARE0_Clear = 0x1
	// Position of COMPARE1 field.
	RTC_EVTENCLR_COMPARE1_Pos = 0x11
	// Bit mask of COMPARE1 field.
	RTC_EVTENCLR_COMPARE1_Msk = 0x20000
	// Bit COMPARE1.
	RTC_EVTENCLR_COMPARE1 = 0x20000
	// Read: Disabled
	RTC_EVTENCLR_COMPARE1_Disabled = 0x0
	// Read: Enabled
	RTC_EVTENCLR_COMPARE1_Enabled = 0x1
	// Disable
	RTC_EVTENCLR_COMPARE1_Clear = 0x1
	// Position of COMPARE2 field.
	RTC_EVTENCLR_COMPARE2_Pos = 0x12
	// Bit mask of COMPARE2 field.
	RTC_EVTENCLR_COMPARE2_Msk = 0x40000
	// Bit COMPARE2.
	RTC_EVTENCLR_COMPARE2 = 0x40000
	// Read: Disabled
	RTC_EVTENCLR_COMPARE2_Disabled = 0x0
	// Read: Enabled
	RTC_EVTENCLR_COMPARE2_Enabled = 0x1
	// Disable
	RTC_EVTENCLR_COMPARE2_Clear = 0x1
	// Position of COMPARE3 field.
	RTC_EVTENCLR_COMPARE3_Pos = 0x13
	// Bit mask of COMPARE3 field.
	RTC_EVTENCLR_COMPARE3_Msk = 0x80000
	// Bit COMPARE3.
	RTC_EVTENCLR_COMPARE3 = 0x80000
	// Read: Disabled
	RTC_EVTENCLR_COMPARE3_Disabled = 0x0
	// Read: Enabled
	RTC_EVTENCLR_COMPARE3_Enabled = 0x1
	// Disable
	RTC_EVTENCLR_COMPARE3_Clear = 0x1

	// COUNTER: Current counter value
	// Position of COUNTER field.
	RTC_COUNTER_COUNTER_Pos = 0x0
	// Bit mask of COUNTER field.
	RTC_COUNTER_COUNTER_Msk = 0xffffff

	// PRESCALER: 12-bit prescaler for counter frequency (32768/(PRESCALER+1)). Must be written when RTC is stopped.
	// Position of PRESCALER field.
	RTC_PRESCALER_PRESCALER_Pos = 0x0
	// Bit mask of PRESCALER field.
	RTC_PRESCALER_PRESCALER_Msk = 0xfff

	// CC: Description collection: Compare register n
	// Position of COMPARE field.
	RTC_CC_COMPARE_Pos = 0x0
	// Bit mask of COMPARE field.
	RTC_CC_COMPARE_Msk = 0xffffff
)

// Constants for IPC_NS: Interprocessor communication
const (
	// TASKS_SEND: Description collection: Trigger events on IPC channel enabled in SEND_CNF[n]
	// Position of TASKS_SEND field.
	IPC_TASKS_SEND_TASKS_SEND_Pos = 0x0
	// Bit mask of TASKS_SEND field.
	IPC_TASKS_SEND_TASKS_SEND_Msk = 0x1
	// Bit TASKS_SEND.
	IPC_TASKS_SEND_TASKS_SEND = 0x1
	// Trigger task
	IPC_TASKS_SEND_TASKS_SEND_Trigger = 0x1

	// SUBSCRIBE_SEND: Description collection: Subscribe configuration for task SEND[n]
	// Position of CHIDX field.
	IPC_SUBSCRIBE_SEND_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	IPC_SUBSCRIBE_SEND_CHIDX_Msk = 0xff
	// Position of EN field.
	IPC_SUBSCRIBE_SEND_EN_Pos = 0x1f
	// Bit mask of EN field.
	IPC_SUBSCRIBE_SEND_EN_Msk = 0x80000000
	// Bit EN.
	IPC_SUBSCRIBE_SEND_EN = 0x80000000
	// Disable subscription
	IPC_SUBSCRIBE_SEND_EN_Disabled = 0x0
	// Enable subscription
	IPC_SUBSCRIBE_SEND_EN_Enabled = 0x1

	// EVENTS_RECEIVE: Description collection: Event received on one or more of the enabled IPC channels in RECEIVE_CNF[n]
	// Position of EVENTS_RECEIVE field.
	IPC_EVENTS_RECEIVE_EVENTS_RECEIVE_Pos = 0x0
	// Bit mask of EVENTS_RECEIVE field.
	IPC_EVENTS_RECEIVE_EVENTS_RECEIVE_Msk = 0x1
	// Bit EVENTS_RECEIVE.
	IPC_EVENTS_RECEIVE_EVENTS_RECEIVE = 0x1
	// Event not generated
	IPC_EVENTS_RECEIVE_EVENTS_RECEIVE_NotGenerated = 0x0
	// Event generated
	IPC_EVENTS_RECEIVE_EVENTS_RECEIVE_Generated = 0x1

	// PUBLISH_RECEIVE: Description collection: Publish configuration for event RECEIVE[n]
	// Position of CHIDX field.
	IPC_PUBLISH_RECEIVE_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	IPC_PUBLISH_RECEIVE_CHIDX_Msk = 0xff
	// Position of EN field.
	IPC_PUBLISH_RECEIVE_EN_Pos = 0x1f
	// Bit mask of EN field.
	IPC_PUBLISH_RECEIVE_EN_Msk = 0x80000000
	// Bit EN.
	IPC_PUBLISH_RECEIVE_EN = 0x80000000
	// Disable publishing
	IPC_PUBLISH_RECEIVE_EN_Disabled = 0x0
	// Enable publishing
	IPC_PUBLISH_RECEIVE_EN_Enabled = 0x1

	// INTEN: Enable or disable interrupt
	// Position of RECEIVE0 field.
	IPC_INTEN_RECEIVE0_Pos = 0x0
	// Bit mask of RECEIVE0 field.
	IPC_INTEN_RECEIVE0_Msk = 0x1
	// Bit RECEIVE0.
	IPC_INTEN_RECEIVE0 = 0x1
	// Disable
	IPC_INTEN_RECEIVE0_Disabled = 0x0
	// Enable
	IPC_INTEN_RECEIVE0_Enabled = 0x1
	// Position of RECEIVE1 field.
	IPC_INTEN_RECEIVE1_Pos = 0x1
	// Bit mask of RECEIVE1 field.
	IPC_INTEN_RECEIVE1_Msk = 0x2
	// Bit RECEIVE1.
	IPC_INTEN_RECEIVE1 = 0x2
	// Disable
	IPC_INTEN_RECEIVE1_Disabled = 0x0
	// Enable
	IPC_INTEN_RECEIVE1_Enabled = 0x1
	// Position of RECEIVE2 field.
	IPC_INTEN_RECEIVE2_Pos = 0x2
	// Bit mask of RECEIVE2 field.
	IPC_INTEN_RECEIVE2_Msk = 0x4
	// Bit RECEIVE2.
	IPC_INTEN_RECEIVE2 = 0x4
	// Disable
	IPC_INTEN_RECEIVE2_Disabled = 0x0
	// Enable
	IPC_INTEN_RECEIVE2_Enabled = 0x1
	// Position of RECEIVE3 field.
	IPC_INTEN_RECEIVE3_Pos = 0x3
	// Bit mask of RECEIVE3 field.
	IPC_INTEN_RECEIVE3_Msk = 0x8
	// Bit RECEIVE3.
	IPC_INTEN_RECEIVE3 = 0x8
	// Disable
	IPC_INTEN_RECEIVE3_Disabled = 0x0
	// Enable
	IPC_INTEN_RECEIVE3_Enabled = 0x1
	// Position of RECEIVE4 field.
	IPC_INTEN_RECEIVE4_Pos = 0x4
	// Bit mask of RECEIVE4 field.
	IPC_INTEN_RECEIVE4_Msk = 0x10
	// Bit RECEIVE4.
	IPC_INTEN_RECEIVE4 = 0x10
	// Disable
	IPC_INTEN_RECEIVE4_Disabled = 0x0
	// Enable
	IPC_INTEN_RECEIVE4_Enabled = 0x1
	// Position of RECEIVE5 field.
	IPC_INTEN_RECEIVE5_Pos = 0x5
	// Bit mask of RECEIVE5 field.
	IPC_INTEN_RECEIVE5_Msk = 0x20
	// Bit RECEIVE5.
	IPC_INTEN_RECEIVE5 = 0x20
	// Disable
	IPC_INTEN_RECEIVE5_Disabled = 0x0
	// Enable
	IPC_INTEN_RECEIVE5_Enabled = 0x1
	// Position of RECEIVE6 field.
	IPC_INTEN_RECEIVE6_Pos = 0x6
	// Bit mask of RECEIVE6 field.
	IPC_INTEN_RECEIVE6_Msk = 0x40
	// Bit RECEIVE6.
	IPC_INTEN_RECEIVE6 = 0x40
	// Disable
	IPC_INTEN_RECEIVE6_Disabled = 0x0
	// Enable
	IPC_INTEN_RECEIVE6_Enabled = 0x1
	// Position of RECEIVE7 field.
	IPC_INTEN_RECEIVE7_Pos = 0x7
	// Bit mask of RECEIVE7 field.
	IPC_INTEN_RECEIVE7_Msk = 0x80
	// Bit RECEIVE7.
	IPC_INTEN_RECEIVE7 = 0x80
	// Disable
	IPC_INTEN_RECEIVE7_Disabled = 0x0
	// Enable
	IPC_INTEN_RECEIVE7_Enabled = 0x1
	// Position of RECEIVE8 field.
	IPC_INTEN_RECEIVE8_Pos = 0x8
	// Bit mask of RECEIVE8 field.
	IPC_INTEN_RECEIVE8_Msk = 0x100
	// Bit RECEIVE8.
	IPC_INTEN_RECEIVE8 = 0x100
	// Disable
	IPC_INTEN_RECEIVE8_Disabled = 0x0
	// Enable
	IPC_INTEN_RECEIVE8_Enabled = 0x1
	// Position of RECEIVE9 field.
	IPC_INTEN_RECEIVE9_Pos = 0x9
	// Bit mask of RECEIVE9 field.
	IPC_INTEN_RECEIVE9_Msk = 0x200
	// Bit RECEIVE9.
	IPC_INTEN_RECEIVE9 = 0x200
	// Disable
	IPC_INTEN_RECEIVE9_Disabled = 0x0
	// Enable
	IPC_INTEN_RECEIVE9_Enabled = 0x1
	// Position of RECEIVE10 field.
	IPC_INTEN_RECEIVE10_Pos = 0xa
	// Bit mask of RECEIVE10 field.
	IPC_INTEN_RECEIVE10_Msk = 0x400
	// Bit RECEIVE10.
	IPC_INTEN_RECEIVE10 = 0x400
	// Disable
	IPC_INTEN_RECEIVE10_Disabled = 0x0
	// Enable
	IPC_INTEN_RECEIVE10_Enabled = 0x1
	// Position of RECEIVE11 field.
	IPC_INTEN_RECEIVE11_Pos = 0xb
	// Bit mask of RECEIVE11 field.
	IPC_INTEN_RECEIVE11_Msk = 0x800
	// Bit RECEIVE11.
	IPC_INTEN_RECEIVE11 = 0x800
	// Disable
	IPC_INTEN_RECEIVE11_Disabled = 0x0
	// Enable
	IPC_INTEN_RECEIVE11_Enabled = 0x1
	// Position of RECEIVE12 field.
	IPC_INTEN_RECEIVE12_Pos = 0xc
	// Bit mask of RECEIVE12 field.
	IPC_INTEN_RECEIVE12_Msk = 0x1000
	// Bit RECEIVE12.
	IPC_INTEN_RECEIVE12 = 0x1000
	// Disable
	IPC_INTEN_RECEIVE12_Disabled = 0x0
	// Enable
	IPC_INTEN_RECEIVE12_Enabled = 0x1
	// Position of RECEIVE13 field.
	IPC_INTEN_RECEIVE13_Pos = 0xd
	// Bit mask of RECEIVE13 field.
	IPC_INTEN_RECEIVE13_Msk = 0x2000
	// Bit RECEIVE13.
	IPC_INTEN_RECEIVE13 = 0x2000
	// Disable
	IPC_INTEN_RECEIVE13_Disabled = 0x0
	// Enable
	IPC_INTEN_RECEIVE13_Enabled = 0x1
	// Position of RECEIVE14 field.
	IPC_INTEN_RECEIVE14_Pos = 0xe
	// Bit mask of RECEIVE14 field.
	IPC_INTEN_RECEIVE14_Msk = 0x4000
	// Bit RECEIVE14.
	IPC_INTEN_RECEIVE14 = 0x4000
	// Disable
	IPC_INTEN_RECEIVE14_Disabled = 0x0
	// Enable
	IPC_INTEN_RECEIVE14_Enabled = 0x1
	// Position of RECEIVE15 field.
	IPC_INTEN_RECEIVE15_Pos = 0xf
	// Bit mask of RECEIVE15 field.
	IPC_INTEN_RECEIVE15_Msk = 0x8000
	// Bit RECEIVE15.
	IPC_INTEN_RECEIVE15 = 0x8000
	// Disable
	IPC_INTEN_RECEIVE15_Disabled = 0x0
	// Enable
	IPC_INTEN_RECEIVE15_Enabled = 0x1

	// INTENSET: Enable interrupt
	// Position of RECEIVE0 field.
	IPC_INTENSET_RECEIVE0_Pos = 0x0
	// Bit mask of RECEIVE0 field.
	IPC_INTENSET_RECEIVE0_Msk = 0x1
	// Bit RECEIVE0.
	IPC_INTENSET_RECEIVE0 = 0x1
	// Read: Disabled
	IPC_INTENSET_RECEIVE0_Disabled = 0x0
	// Read: Enabled
	IPC_INTENSET_RECEIVE0_Enabled = 0x1
	// Enable
	IPC_INTENSET_RECEIVE0_Set = 0x1
	// Position of RECEIVE1 field.
	IPC_INTENSET_RECEIVE1_Pos = 0x1
	// Bit mask of RECEIVE1 field.
	IPC_INTENSET_RECEIVE1_Msk = 0x2
	// Bit RECEIVE1.
	IPC_INTENSET_RECEIVE1 = 0x2
	// Read: Disabled
	IPC_INTENSET_RECEIVE1_Disabled = 0x0
	// Read: Enabled
	IPC_INTENSET_RECEIVE1_Enabled = 0x1
	// Enable
	IPC_INTENSET_RECEIVE1_Set = 0x1
	// Position of RECEIVE2 field.
	IPC_INTENSET_RECEIVE2_Pos = 0x2
	// Bit mask of RECEIVE2 field.
	IPC_INTENSET_RECEIVE2_Msk = 0x4
	// Bit RECEIVE2.
	IPC_INTENSET_RECEIVE2 = 0x4
	// Read: Disabled
	IPC_INTENSET_RECEIVE2_Disabled = 0x0
	// Read: Enabled
	IPC_INTENSET_RECEIVE2_Enabled = 0x1
	// Enable
	IPC_INTENSET_RECEIVE2_Set = 0x1
	// Position of RECEIVE3 field.
	IPC_INTENSET_RECEIVE3_Pos = 0x3
	// Bit mask of RECEIVE3 field.
	IPC_INTENSET_RECEIVE3_Msk = 0x8
	// Bit RECEIVE3.
	IPC_INTENSET_RECEIVE3 = 0x8
	// Read: Disabled
	IPC_INTENSET_RECEIVE3_Disabled = 0x0
	// Read: Enabled
	IPC_INTENSET_RECEIVE3_Enabled = 0x1
	// Enable
	IPC_INTENSET_RECEIVE3_Set = 0x1
	// Position of RECEIVE4 field.
	IPC_INTENSET_RECEIVE4_Pos = 0x4
	// Bit mask of RECEIVE4 field.
	IPC_INTENSET_RECEIVE4_Msk = 0x10
	// Bit RECEIVE4.
	IPC_INTENSET_RECEIVE4 = 0x10
	// Read: Disabled
	IPC_INTENSET_RECEIVE4_Disabled = 0x0
	// Read: Enabled
	IPC_INTENSET_RECEIVE4_Enabled = 0x1
	// Enable
	IPC_INTENSET_RECEIVE4_Set = 0x1
	// Position of RECEIVE5 field.
	IPC_INTENSET_RECEIVE5_Pos = 0x5
	// Bit mask of RECEIVE5 field.
	IPC_INTENSET_RECEIVE5_Msk = 0x20
	// Bit RECEIVE5.
	IPC_INTENSET_RECEIVE5 = 0x20
	// Read: Disabled
	IPC_INTENSET_RECEIVE5_Disabled = 0x0
	// Read: Enabled
	IPC_INTENSET_RECEIVE5_Enabled = 0x1
	// Enable
	IPC_INTENSET_RECEIVE5_Set = 0x1
	// Position of RECEIVE6 field.
	IPC_INTENSET_RECEIVE6_Pos = 0x6
	// Bit mask of RECEIVE6 field.
	IPC_INTENSET_RECEIVE6_Msk = 0x40
	// Bit RECEIVE6.
	IPC_INTENSET_RECEIVE6 = 0x40
	// Read: Disabled
	IPC_INTENSET_RECEIVE6_Disabled = 0x0
	// Read: Enabled
	IPC_INTENSET_RECEIVE6_Enabled = 0x1
	// Enable
	IPC_INTENSET_RECEIVE6_Set = 0x1
	// Position of RECEIVE7 field.
	IPC_INTENSET_RECEIVE7_Pos = 0x7
	// Bit mask of RECEIVE7 field.
	IPC_INTENSET_RECEIVE7_Msk = 0x80
	// Bit RECEIVE7.
	IPC_INTENSET_RECEIVE7 = 0x80
	// Read: Disabled
	IPC_INTENSET_RECEIVE7_Disabled = 0x0
	// Read: Enabled
	IPC_INTENSET_RECEIVE7_Enabled = 0x1
	// Enable
	IPC_INTENSET_RECEIVE7_Set = 0x1
	// Position of RECEIVE8 field.
	IPC_INTENSET_RECEIVE8_Pos = 0x8
	// Bit mask of RECEIVE8 field.
	IPC_INTENSET_RECEIVE8_Msk = 0x100
	// Bit RECEIVE8.
	IPC_INTENSET_RECEIVE8 = 0x100
	// Read: Disabled
	IPC_INTENSET_RECEIVE8_Disabled = 0x0
	// Read: Enabled
	IPC_INTENSET_RECEIVE8_Enabled = 0x1
	// Enable
	IPC_INTENSET_RECEIVE8_Set = 0x1
	// Position of RECEIVE9 field.
	IPC_INTENSET_RECEIVE9_Pos = 0x9
	// Bit mask of RECEIVE9 field.
	IPC_INTENSET_RECEIVE9_Msk = 0x200
	// Bit RECEIVE9.
	IPC_INTENSET_RECEIVE9 = 0x200
	// Read: Disabled
	IPC_INTENSET_RECEIVE9_Disabled = 0x0
	// Read: Enabled
	IPC_INTENSET_RECEIVE9_Enabled = 0x1
	// Enable
	IPC_INTENSET_RECEIVE9_Set = 0x1
	// Position of RECEIVE10 field.
	IPC_INTENSET_RECEIVE10_Pos = 0xa
	// Bit mask of RECEIVE10 field.
	IPC_INTENSET_RECEIVE10_Msk = 0x400
	// Bit RECEIVE10.
	IPC_INTENSET_RECEIVE10 = 0x400
	// Read: Disabled
	IPC_INTENSET_RECEIVE10_Disabled = 0x0
	// Read: Enabled
	IPC_INTENSET_RECEIVE10_Enabled = 0x1
	// Enable
	IPC_INTENSET_RECEIVE10_Set = 0x1
	// Position of RECEIVE11 field.
	IPC_INTENSET_RECEIVE11_Pos = 0xb
	// Bit mask of RECEIVE11 field.
	IPC_INTENSET_RECEIVE11_Msk = 0x800
	// Bit RECEIVE11.
	IPC_INTENSET_RECEIVE11 = 0x800
	// Read: Disabled
	IPC_INTENSET_RECEIVE11_Disabled = 0x0
	// Read: Enabled
	IPC_INTENSET_RECEIVE11_Enabled = 0x1
	// Enable
	IPC_INTENSET_RECEIVE11_Set = 0x1
	// Position of RECEIVE12 field.
	IPC_INTENSET_RECEIVE12_Pos = 0xc
	// Bit mask of RECEIVE12 field.
	IPC_INTENSET_RECEIVE12_Msk = 0x1000
	// Bit RECEIVE12.
	IPC_INTENSET_RECEIVE12 = 0x1000
	// Read: Disabled
	IPC_INTENSET_RECEIVE12_Disabled = 0x0
	// Read: Enabled
	IPC_INTENSET_RECEIVE12_Enabled = 0x1
	// Enable
	IPC_INTENSET_RECEIVE12_Set = 0x1
	// Position of RECEIVE13 field.
	IPC_INTENSET_RECEIVE13_Pos = 0xd
	// Bit mask of RECEIVE13 field.
	IPC_INTENSET_RECEIVE13_Msk = 0x2000
	// Bit RECEIVE13.
	IPC_INTENSET_RECEIVE13 = 0x2000
	// Read: Disabled
	IPC_INTENSET_RECEIVE13_Disabled = 0x0
	// Read: Enabled
	IPC_INTENSET_RECEIVE13_Enabled = 0x1
	// Enable
	IPC_INTENSET_RECEIVE13_Set = 0x1
	// Position of RECEIVE14 field.
	IPC_INTENSET_RECEIVE14_Pos = 0xe
	// Bit mask of RECEIVE14 field.
	IPC_INTENSET_RECEIVE14_Msk = 0x4000
	// Bit RECEIVE14.
	IPC_INTENSET_RECEIVE14 = 0x4000
	// Read: Disabled
	IPC_INTENSET_RECEIVE14_Disabled = 0x0
	// Read: Enabled
	IPC_INTENSET_RECEIVE14_Enabled = 0x1
	// Enable
	IPC_INTENSET_RECEIVE14_Set = 0x1
	// Position of RECEIVE15 field.
	IPC_INTENSET_RECEIVE15_Pos = 0xf
	// Bit mask of RECEIVE15 field.
	IPC_INTENSET_RECEIVE15_Msk = 0x8000
	// Bit RECEIVE15.
	IPC_INTENSET_RECEIVE15 = 0x8000
	// Read: Disabled
	IPC_INTENSET_RECEIVE15_Disabled = 0x0
	// Read: Enabled
	IPC_INTENSET_RECEIVE15_Enabled = 0x1
	// Enable
	IPC_INTENSET_RECEIVE15_Set = 0x1

	// INTENCLR: Disable interrupt
	// Position of RECEIVE0 field.
	IPC_INTENCLR_RECEIVE0_Pos = 0x0
	// Bit mask of RECEIVE0 field.
	IPC_INTENCLR_RECEIVE0_Msk = 0x1
	// Bit RECEIVE0.
	IPC_INTENCLR_RECEIVE0 = 0x1
	// Read: Disabled
	IPC_INTENCLR_RECEIVE0_Disabled = 0x0
	// Read: Enabled
	IPC_INTENCLR_RECEIVE0_Enabled = 0x1
	// Disable
	IPC_INTENCLR_RECEIVE0_Clear = 0x1
	// Position of RECEIVE1 field.
	IPC_INTENCLR_RECEIVE1_Pos = 0x1
	// Bit mask of RECEIVE1 field.
	IPC_INTENCLR_RECEIVE1_Msk = 0x2
	// Bit RECEIVE1.
	IPC_INTENCLR_RECEIVE1 = 0x2
	// Read: Disabled
	IPC_INTENCLR_RECEIVE1_Disabled = 0x0
	// Read: Enabled
	IPC_INTENCLR_RECEIVE1_Enabled = 0x1
	// Disable
	IPC_INTENCLR_RECEIVE1_Clear = 0x1
	// Position of RECEIVE2 field.
	IPC_INTENCLR_RECEIVE2_Pos = 0x2
	// Bit mask of RECEIVE2 field.
	IPC_INTENCLR_RECEIVE2_Msk = 0x4
	// Bit RECEIVE2.
	IPC_INTENCLR_RECEIVE2 = 0x4
	// Read: Disabled
	IPC_INTENCLR_RECEIVE2_Disabled = 0x0
	// Read: Enabled
	IPC_INTENCLR_RECEIVE2_Enabled = 0x1
	// Disable
	IPC_INTENCLR_RECEIVE2_Clear = 0x1
	// Position of RECEIVE3 field.
	IPC_INTENCLR_RECEIVE3_Pos = 0x3
	// Bit mask of RECEIVE3 field.
	IPC_INTENCLR_RECEIVE3_Msk = 0x8
	// Bit RECEIVE3.
	IPC_INTENCLR_RECEIVE3 = 0x8
	// Read: Disabled
	IPC_INTENCLR_RECEIVE3_Disabled = 0x0
	// Read: Enabled
	IPC_INTENCLR_RECEIVE3_Enabled = 0x1
	// Disable
	IPC_INTENCLR_RECEIVE3_Clear = 0x1
	// Position of RECEIVE4 field.
	IPC_INTENCLR_RECEIVE4_Pos = 0x4
	// Bit mask of RECEIVE4 field.
	IPC_INTENCLR_RECEIVE4_Msk = 0x10
	// Bit RECEIVE4.
	IPC_INTENCLR_RECEIVE4 = 0x10
	// Read: Disabled
	IPC_INTENCLR_RECEIVE4_Disabled = 0x0
	// Read: Enabled
	IPC_INTENCLR_RECEIVE4_Enabled = 0x1
	// Disable
	IPC_INTENCLR_RECEIVE4_Clear = 0x1
	// Position of RECEIVE5 field.
	IPC_INTENCLR_RECEIVE5_Pos = 0x5
	// Bit mask of RECEIVE5 field.
	IPC_INTENCLR_RECEIVE5_Msk = 0x20
	// Bit RECEIVE5.
	IPC_INTENCLR_RECEIVE5 = 0x20
	// Read: Disabled
	IPC_INTENCLR_RECEIVE5_Disabled = 0x0
	// Read: Enabled
	IPC_INTENCLR_RECEIVE5_Enabled = 0x1
	// Disable
	IPC_INTENCLR_RECEIVE5_Clear = 0x1
	// Position of RECEIVE6 field.
	IPC_INTENCLR_RECEIVE6_Pos = 0x6
	// Bit mask of RECEIVE6 field.
	IPC_INTENCLR_RECEIVE6_Msk = 0x40
	// Bit RECEIVE6.
	IPC_INTENCLR_RECEIVE6 = 0x40
	// Read: Disabled
	IPC_INTENCLR_RECEIVE6_Disabled = 0x0
	// Read: Enabled
	IPC_INTENCLR_RECEIVE6_Enabled = 0x1
	// Disable
	IPC_INTENCLR_RECEIVE6_Clear = 0x1
	// Position of RECEIVE7 field.
	IPC_INTENCLR_RECEIVE7_Pos = 0x7
	// Bit mask of RECEIVE7 field.
	IPC_INTENCLR_RECEIVE7_Msk = 0x80
	// Bit RECEIVE7.
	IPC_INTENCLR_RECEIVE7 = 0x80
	// Read: Disabled
	IPC_INTENCLR_RECEIVE7_Disabled = 0x0
	// Read: Enabled
	IPC_INTENCLR_RECEIVE7_Enabled = 0x1
	// Disable
	IPC_INTENCLR_RECEIVE7_Clear = 0x1
	// Position of RECEIVE8 field.
	IPC_INTENCLR_RECEIVE8_Pos = 0x8
	// Bit mask of RECEIVE8 field.
	IPC_INTENCLR_RECEIVE8_Msk = 0x100
	// Bit RECEIVE8.
	IPC_INTENCLR_RECEIVE8 = 0x100
	// Read: Disabled
	IPC_INTENCLR_RECEIVE8_Disabled = 0x0
	// Read: Enabled
	IPC_INTENCLR_RECEIVE8_Enabled = 0x1
	// Disable
	IPC_INTENCLR_RECEIVE8_Clear = 0x1
	// Position of RECEIVE9 field.
	IPC_INTENCLR_RECEIVE9_Pos = 0x9
	// Bit mask of RECEIVE9 field.
	IPC_INTENCLR_RECEIVE9_Msk = 0x200
	// Bit RECEIVE9.
	IPC_INTENCLR_RECEIVE9 = 0x200
	// Read: Disabled
	IPC_INTENCLR_RECEIVE9_Disabled = 0x0
	// Read: Enabled
	IPC_INTENCLR_RECEIVE9_Enabled = 0x1
	// Disable
	IPC_INTENCLR_RECEIVE9_Clear = 0x1
	// Position of RECEIVE10 field.
	IPC_INTENCLR_RECEIVE10_Pos = 0xa
	// Bit mask of RECEIVE10 field.
	IPC_INTENCLR_RECEIVE10_Msk = 0x400
	// Bit RECEIVE10.
	IPC_INTENCLR_RECEIVE10 = 0x400
	// Read: Disabled
	IPC_INTENCLR_RECEIVE10_Disabled = 0x0
	// Read: Enabled
	IPC_INTENCLR_RECEIVE10_Enabled = 0x1
	// Disable
	IPC_INTENCLR_RECEIVE10_Clear = 0x1
	// Position of RECEIVE11 field.
	IPC_INTENCLR_RECEIVE11_Pos = 0xb
	// Bit mask of RECEIVE11 field.
	IPC_INTENCLR_RECEIVE11_Msk = 0x800
	// Bit RECEIVE11.
	IPC_INTENCLR_RECEIVE11 = 0x800
	// Read: Disabled
	IPC_INTENCLR_RECEIVE11_Disabled = 0x0
	// Read: Enabled
	IPC_INTENCLR_RECEIVE11_Enabled = 0x1
	// Disable
	IPC_INTENCLR_RECEIVE11_Clear = 0x1
	// Position of RECEIVE12 field.
	IPC_INTENCLR_RECEIVE12_Pos = 0xc
	// Bit mask of RECEIVE12 field.
	IPC_INTENCLR_RECEIVE12_Msk = 0x1000
	// Bit RECEIVE12.
	IPC_INTENCLR_RECEIVE12 = 0x1000
	// Read: Disabled
	IPC_INTENCLR_RECEIVE12_Disabled = 0x0
	// Read: Enabled
	IPC_INTENCLR_RECEIVE12_Enabled = 0x1
	// Disable
	IPC_INTENCLR_RECEIVE12_Clear = 0x1
	// Position of RECEIVE13 field.
	IPC_INTENCLR_RECEIVE13_Pos = 0xd
	// Bit mask of RECEIVE13 field.
	IPC_INTENCLR_RECEIVE13_Msk = 0x2000
	// Bit RECEIVE13.
	IPC_INTENCLR_RECEIVE13 = 0x2000
	// Read: Disabled
	IPC_INTENCLR_RECEIVE13_Disabled = 0x0
	// Read: Enabled
	IPC_INTENCLR_RECEIVE13_Enabled = 0x1
	// Disable
	IPC_INTENCLR_RECEIVE13_Clear = 0x1
	// Position of RECEIVE14 field.
	IPC_INTENCLR_RECEIVE14_Pos = 0xe
	// Bit mask of RECEIVE14 field.
	IPC_INTENCLR_RECEIVE14_Msk = 0x4000
	// Bit RECEIVE14.
	IPC_INTENCLR_RECEIVE14 = 0x4000
	// Read: Disabled
	IPC_INTENCLR_RECEIVE14_Disabled = 0x0
	// Read: Enabled
	IPC_INTENCLR_RECEIVE14_Enabled = 0x1
	// Disable
	IPC_INTENCLR_RECEIVE14_Clear = 0x1
	// Position of RECEIVE15 field.
	IPC_INTENCLR_RECEIVE15_Pos = 0xf
	// Bit mask of RECEIVE15 field.
	IPC_INTENCLR_RECEIVE15_Msk = 0x8000
	// Bit RECEIVE15.
	IPC_INTENCLR_RECEIVE15 = 0x8000
	// Read: Disabled
	IPC_INTENCLR_RECEIVE15_Disabled = 0x0
	// Read: Enabled
	IPC_INTENCLR_RECEIVE15_Enabled = 0x1
	// Disable
	IPC_INTENCLR_RECEIVE15_Clear = 0x1

	// INTPEND: Pending interrupts
	// Position of RECEIVE0 field.
	IPC_INTPEND_RECEIVE0_Pos = 0x0
	// Bit mask of RECEIVE0 field.
	IPC_INTPEND_RECEIVE0_Msk = 0x1
	// Bit RECEIVE0.
	IPC_INTPEND_RECEIVE0 = 0x1
	// Read: Not pending
	IPC_INTPEND_RECEIVE0_NotPending = 0x0
	// Read: Pending
	IPC_INTPEND_RECEIVE0_Pending = 0x1
	// Position of RECEIVE1 field.
	IPC_INTPEND_RECEIVE1_Pos = 0x1
	// Bit mask of RECEIVE1 field.
	IPC_INTPEND_RECEIVE1_Msk = 0x2
	// Bit RECEIVE1.
	IPC_INTPEND_RECEIVE1 = 0x2
	// Read: Not pending
	IPC_INTPEND_RECEIVE1_NotPending = 0x0
	// Read: Pending
	IPC_INTPEND_RECEIVE1_Pending = 0x1
	// Position of RECEIVE2 field.
	IPC_INTPEND_RECEIVE2_Pos = 0x2
	// Bit mask of RECEIVE2 field.
	IPC_INTPEND_RECEIVE2_Msk = 0x4
	// Bit RECEIVE2.
	IPC_INTPEND_RECEIVE2 = 0x4
	// Read: Not pending
	IPC_INTPEND_RECEIVE2_NotPending = 0x0
	// Read: Pending
	IPC_INTPEND_RECEIVE2_Pending = 0x1
	// Position of RECEIVE3 field.
	IPC_INTPEND_RECEIVE3_Pos = 0x3
	// Bit mask of RECEIVE3 field.
	IPC_INTPEND_RECEIVE3_Msk = 0x8
	// Bit RECEIVE3.
	IPC_INTPEND_RECEIVE3 = 0x8
	// Read: Not pending
	IPC_INTPEND_RECEIVE3_NotPending = 0x0
	// Read: Pending
	IPC_INTPEND_RECEIVE3_Pending = 0x1
	// Position of RECEIVE4 field.
	IPC_INTPEND_RECEIVE4_Pos = 0x4
	// Bit mask of RECEIVE4 field.
	IPC_INTPEND_RECEIVE4_Msk = 0x10
	// Bit RECEIVE4.
	IPC_INTPEND_RECEIVE4 = 0x10
	// Read: Not pending
	IPC_INTPEND_RECEIVE4_NotPending = 0x0
	// Read: Pending
	IPC_INTPEND_RECEIVE4_Pending = 0x1
	// Position of RECEIVE5 field.
	IPC_INTPEND_RECEIVE5_Pos = 0x5
	// Bit mask of RECEIVE5 field.
	IPC_INTPEND_RECEIVE5_Msk = 0x20
	// Bit RECEIVE5.
	IPC_INTPEND_RECEIVE5 = 0x20
	// Read: Not pending
	IPC_INTPEND_RECEIVE5_NotPending = 0x0
	// Read: Pending
	IPC_INTPEND_RECEIVE5_Pending = 0x1
	// Position of RECEIVE6 field.
	IPC_INTPEND_RECEIVE6_Pos = 0x6
	// Bit mask of RECEIVE6 field.
	IPC_INTPEND_RECEIVE6_Msk = 0x40
	// Bit RECEIVE6.
	IPC_INTPEND_RECEIVE6 = 0x40
	// Read: Not pending
	IPC_INTPEND_RECEIVE6_NotPending = 0x0
	// Read: Pending
	IPC_INTPEND_RECEIVE6_Pending = 0x1
	// Position of RECEIVE7 field.
	IPC_INTPEND_RECEIVE7_Pos = 0x7
	// Bit mask of RECEIVE7 field.
	IPC_INTPEND_RECEIVE7_Msk = 0x80
	// Bit RECEIVE7.
	IPC_INTPEND_RECEIVE7 = 0x80
	// Read: Not pending
	IPC_INTPEND_RECEIVE7_NotPending = 0x0
	// Read: Pending
	IPC_INTPEND_RECEIVE7_Pending = 0x1
	// Position of RECEIVE8 field.
	IPC_INTPEND_RECEIVE8_Pos = 0x8
	// Bit mask of RECEIVE8 field.
	IPC_INTPEND_RECEIVE8_Msk = 0x100
	// Bit RECEIVE8.
	IPC_INTPEND_RECEIVE8 = 0x100
	// Read: Not pending
	IPC_INTPEND_RECEIVE8_NotPending = 0x0
	// Read: Pending
	IPC_INTPEND_RECEIVE8_Pending = 0x1
	// Position of RECEIVE9 field.
	IPC_INTPEND_RECEIVE9_Pos = 0x9
	// Bit mask of RECEIVE9 field.
	IPC_INTPEND_RECEIVE9_Msk = 0x200
	// Bit RECEIVE9.
	IPC_INTPEND_RECEIVE9 = 0x200
	// Read: Not pending
	IPC_INTPEND_RECEIVE9_NotPending = 0x0
	// Read: Pending
	IPC_INTPEND_RECEIVE9_Pending = 0x1
	// Position of RECEIVE10 field.
	IPC_INTPEND_RECEIVE10_Pos = 0xa
	// Bit mask of RECEIVE10 field.
	IPC_INTPEND_RECEIVE10_Msk = 0x400
	// Bit RECEIVE10.
	IPC_INTPEND_RECEIVE10 = 0x400
	// Read: Not pending
	IPC_INTPEND_RECEIVE10_NotPending = 0x0
	// Read: Pending
	IPC_INTPEND_RECEIVE10_Pending = 0x1
	// Position of RECEIVE11 field.
	IPC_INTPEND_RECEIVE11_Pos = 0xb
	// Bit mask of RECEIVE11 field.
	IPC_INTPEND_RECEIVE11_Msk = 0x800
	// Bit RECEIVE11.
	IPC_INTPEND_RECEIVE11 = 0x800
	// Read: Not pending
	IPC_INTPEND_RECEIVE11_NotPending = 0x0
	// Read: Pending
	IPC_INTPEND_RECEIVE11_Pending = 0x1
	// Position of RECEIVE12 field.
	IPC_INTPEND_RECEIVE12_Pos = 0xc
	// Bit mask of RECEIVE12 field.
	IPC_INTPEND_RECEIVE12_Msk = 0x1000
	// Bit RECEIVE12.
	IPC_INTPEND_RECEIVE12 = 0x1000
	// Read: Not pending
	IPC_INTPEND_RECEIVE12_NotPending = 0x0
	// Read: Pending
	IPC_INTPEND_RECEIVE12_Pending = 0x1
	// Position of RECEIVE13 field.
	IPC_INTPEND_RECEIVE13_Pos = 0xd
	// Bit mask of RECEIVE13 field.
	IPC_INTPEND_RECEIVE13_Msk = 0x2000
	// Bit RECEIVE13.
	IPC_INTPEND_RECEIVE13 = 0x2000
	// Read: Not pending
	IPC_INTPEND_RECEIVE13_NotPending = 0x0
	// Read: Pending
	IPC_INTPEND_RECEIVE13_Pending = 0x1
	// Position of RECEIVE14 field.
	IPC_INTPEND_RECEIVE14_Pos = 0xe
	// Bit mask of RECEIVE14 field.
	IPC_INTPEND_RECEIVE14_Msk = 0x4000
	// Bit RECEIVE14.
	IPC_INTPEND_RECEIVE14 = 0x4000
	// Read: Not pending
	IPC_INTPEND_RECEIVE14_NotPending = 0x0
	// Read: Pending
	IPC_INTPEND_RECEIVE14_Pending = 0x1
	// Position of RECEIVE15 field.
	IPC_INTPEND_RECEIVE15_Pos = 0xf
	// Bit mask of RECEIVE15 field.
	IPC_INTPEND_RECEIVE15_Msk = 0x8000
	// Bit RECEIVE15.
	IPC_INTPEND_RECEIVE15 = 0x8000
	// Read: Not pending
	IPC_INTPEND_RECEIVE15_NotPending = 0x0
	// Read: Pending
	IPC_INTPEND_RECEIVE15_Pending = 0x1

	// SEND_CNF: Description collection: Send event configuration for TASKS_SEND[n]
	// Position of CHEN0 field.
	IPC_SEND_CNF_CHEN0_Pos = 0x0
	// Bit mask of CHEN0 field.
	IPC_SEND_CNF_CHEN0_Msk = 0x1
	// Bit CHEN0.
	IPC_SEND_CNF_CHEN0 = 0x1
	// Disable broadcast
	IPC_SEND_CNF_CHEN0_Disable = 0x0
	// Enable broadcast
	IPC_SEND_CNF_CHEN0_Enable = 0x1
	// Position of CHEN1 field.
	IPC_SEND_CNF_CHEN1_Pos = 0x1
	// Bit mask of CHEN1 field.
	IPC_SEND_CNF_CHEN1_Msk = 0x2
	// Bit CHEN1.
	IPC_SEND_CNF_CHEN1 = 0x2
	// Disable broadcast
	IPC_SEND_CNF_CHEN1_Disable = 0x0
	// Enable broadcast
	IPC_SEND_CNF_CHEN1_Enable = 0x1
	// Position of CHEN2 field.
	IPC_SEND_CNF_CHEN2_Pos = 0x2
	// Bit mask of CHEN2 field.
	IPC_SEND_CNF_CHEN2_Msk = 0x4
	// Bit CHEN2.
	IPC_SEND_CNF_CHEN2 = 0x4
	// Disable broadcast
	IPC_SEND_CNF_CHEN2_Disable = 0x0
	// Enable broadcast
	IPC_SEND_CNF_CHEN2_Enable = 0x1
	// Position of CHEN3 field.
	IPC_SEND_CNF_CHEN3_Pos = 0x3
	// Bit mask of CHEN3 field.
	IPC_SEND_CNF_CHEN3_Msk = 0x8
	// Bit CHEN3.
	IPC_SEND_CNF_CHEN3 = 0x8
	// Disable broadcast
	IPC_SEND_CNF_CHEN3_Disable = 0x0
	// Enable broadcast
	IPC_SEND_CNF_CHEN3_Enable = 0x1
	// Position of CHEN4 field.
	IPC_SEND_CNF_CHEN4_Pos = 0x4
	// Bit mask of CHEN4 field.
	IPC_SEND_CNF_CHEN4_Msk = 0x10
	// Bit CHEN4.
	IPC_SEND_CNF_CHEN4 = 0x10
	// Disable broadcast
	IPC_SEND_CNF_CHEN4_Disable = 0x0
	// Enable broadcast
	IPC_SEND_CNF_CHEN4_Enable = 0x1
	// Position of CHEN5 field.
	IPC_SEND_CNF_CHEN5_Pos = 0x5
	// Bit mask of CHEN5 field.
	IPC_SEND_CNF_CHEN5_Msk = 0x20
	// Bit CHEN5.
	IPC_SEND_CNF_CHEN5 = 0x20
	// Disable broadcast
	IPC_SEND_CNF_CHEN5_Disable = 0x0
	// Enable broadcast
	IPC_SEND_CNF_CHEN5_Enable = 0x1
	// Position of CHEN6 field.
	IPC_SEND_CNF_CHEN6_Pos = 0x6
	// Bit mask of CHEN6 field.
	IPC_SEND_CNF_CHEN6_Msk = 0x40
	// Bit CHEN6.
	IPC_SEND_CNF_CHEN6 = 0x40
	// Disable broadcast
	IPC_SEND_CNF_CHEN6_Disable = 0x0
	// Enable broadcast
	IPC_SEND_CNF_CHEN6_Enable = 0x1
	// Position of CHEN7 field.
	IPC_SEND_CNF_CHEN7_Pos = 0x7
	// Bit mask of CHEN7 field.
	IPC_SEND_CNF_CHEN7_Msk = 0x80
	// Bit CHEN7.
	IPC_SEND_CNF_CHEN7 = 0x80
	// Disable broadcast
	IPC_SEND_CNF_CHEN7_Disable = 0x0
	// Enable broadcast
	IPC_SEND_CNF_CHEN7_Enable = 0x1
	// Position of CHEN8 field.
	IPC_SEND_CNF_CHEN8_Pos = 0x8
	// Bit mask of CHEN8 field.
	IPC_SEND_CNF_CHEN8_Msk = 0x100
	// Bit CHEN8.
	IPC_SEND_CNF_CHEN8 = 0x100
	// Disable broadcast
	IPC_SEND_CNF_CHEN8_Disable = 0x0
	// Enable broadcast
	IPC_SEND_CNF_CHEN8_Enable = 0x1
	// Position of CHEN9 field.
	IPC_SEND_CNF_CHEN9_Pos = 0x9
	// Bit mask of CHEN9 field.
	IPC_SEND_CNF_CHEN9_Msk = 0x200
	// Bit CHEN9.
	IPC_SEND_CNF_CHEN9 = 0x200
	// Disable broadcast
	IPC_SEND_CNF_CHEN9_Disable = 0x0
	// Enable broadcast
	IPC_SEND_CNF_CHEN9_Enable = 0x1
	// Position of CHEN10 field.
	IPC_SEND_CNF_CHEN10_Pos = 0xa
	// Bit mask of CHEN10 field.
	IPC_SEND_CNF_CHEN10_Msk = 0x400
	// Bit CHEN10.
	IPC_SEND_CNF_CHEN10 = 0x400
	// Disable broadcast
	IPC_SEND_CNF_CHEN10_Disable = 0x0
	// Enable broadcast
	IPC_SEND_CNF_CHEN10_Enable = 0x1
	// Position of CHEN11 field.
	IPC_SEND_CNF_CHEN11_Pos = 0xb
	// Bit mask of CHEN11 field.
	IPC_SEND_CNF_CHEN11_Msk = 0x800
	// Bit CHEN11.
	IPC_SEND_CNF_CHEN11 = 0x800
	// Disable broadcast
	IPC_SEND_CNF_CHEN11_Disable = 0x0
	// Enable broadcast
	IPC_SEND_CNF_CHEN11_Enable = 0x1
	// Position of CHEN12 field.
	IPC_SEND_CNF_CHEN12_Pos = 0xc
	// Bit mask of CHEN12 field.
	IPC_SEND_CNF_CHEN12_Msk = 0x1000
	// Bit CHEN12.
	IPC_SEND_CNF_CHEN12 = 0x1000
	// Disable broadcast
	IPC_SEND_CNF_CHEN12_Disable = 0x0
	// Enable broadcast
	IPC_SEND_CNF_CHEN12_Enable = 0x1
	// Position of CHEN13 field.
	IPC_SEND_CNF_CHEN13_Pos = 0xd
	// Bit mask of CHEN13 field.
	IPC_SEND_CNF_CHEN13_Msk = 0x2000
	// Bit CHEN13.
	IPC_SEND_CNF_CHEN13 = 0x2000
	// Disable broadcast
	IPC_SEND_CNF_CHEN13_Disable = 0x0
	// Enable broadcast
	IPC_SEND_CNF_CHEN13_Enable = 0x1
	// Position of CHEN14 field.
	IPC_SEND_CNF_CHEN14_Pos = 0xe
	// Bit mask of CHEN14 field.
	IPC_SEND_CNF_CHEN14_Msk = 0x4000
	// Bit CHEN14.
	IPC_SEND_CNF_CHEN14 = 0x4000
	// Disable broadcast
	IPC_SEND_CNF_CHEN14_Disable = 0x0
	// Enable broadcast
	IPC_SEND_CNF_CHEN14_Enable = 0x1
	// Position of CHEN15 field.
	IPC_SEND_CNF_CHEN15_Pos = 0xf
	// Bit mask of CHEN15 field.
	IPC_SEND_CNF_CHEN15_Msk = 0x8000
	// Bit CHEN15.
	IPC_SEND_CNF_CHEN15 = 0x8000
	// Disable broadcast
	IPC_SEND_CNF_CHEN15_Disable = 0x0
	// Enable broadcast
	IPC_SEND_CNF_CHEN15_Enable = 0x1

	// RECEIVE_CNF: Description collection: Receive event configuration for EVENTS_RECEIVE[n]
	// Position of CHEN0 field.
	IPC_RECEIVE_CNF_CHEN0_Pos = 0x0
	// Bit mask of CHEN0 field.
	IPC_RECEIVE_CNF_CHEN0_Msk = 0x1
	// Bit CHEN0.
	IPC_RECEIVE_CNF_CHEN0 = 0x1
	// Disable events
	IPC_RECEIVE_CNF_CHEN0_Disable = 0x0
	// Enable events
	IPC_RECEIVE_CNF_CHEN0_Enable = 0x1
	// Position of CHEN1 field.
	IPC_RECEIVE_CNF_CHEN1_Pos = 0x1
	// Bit mask of CHEN1 field.
	IPC_RECEIVE_CNF_CHEN1_Msk = 0x2
	// Bit CHEN1.
	IPC_RECEIVE_CNF_CHEN1 = 0x2
	// Disable events
	IPC_RECEIVE_CNF_CHEN1_Disable = 0x0
	// Enable events
	IPC_RECEIVE_CNF_CHEN1_Enable = 0x1
	// Position of CHEN2 field.
	IPC_RECEIVE_CNF_CHEN2_Pos = 0x2
	// Bit mask of CHEN2 field.
	IPC_RECEIVE_CNF_CHEN2_Msk = 0x4
	// Bit CHEN2.
	IPC_RECEIVE_CNF_CHEN2 = 0x4
	// Disable events
	IPC_RECEIVE_CNF_CHEN2_Disable = 0x0
	// Enable events
	IPC_RECEIVE_CNF_CHEN2_Enable = 0x1
	// Position of CHEN3 field.
	IPC_RECEIVE_CNF_CHEN3_Pos = 0x3
	// Bit mask of CHEN3 field.
	IPC_RECEIVE_CNF_CHEN3_Msk = 0x8
	// Bit CHEN3.
	IPC_RECEIVE_CNF_CHEN3 = 0x8
	// Disable events
	IPC_RECEIVE_CNF_CHEN3_Disable = 0x0
	// Enable events
	IPC_RECEIVE_CNF_CHEN3_Enable = 0x1
	// Position of CHEN4 field.
	IPC_RECEIVE_CNF_CHEN4_Pos = 0x4
	// Bit mask of CHEN4 field.
	IPC_RECEIVE_CNF_CHEN4_Msk = 0x10
	// Bit CHEN4.
	IPC_RECEIVE_CNF_CHEN4 = 0x10
	// Disable events
	IPC_RECEIVE_CNF_CHEN4_Disable = 0x0
	// Enable events
	IPC_RECEIVE_CNF_CHEN4_Enable = 0x1
	// Position of CHEN5 field.
	IPC_RECEIVE_CNF_CHEN5_Pos = 0x5
	// Bit mask of CHEN5 field.
	IPC_RECEIVE_CNF_CHEN5_Msk = 0x20
	// Bit CHEN5.
	IPC_RECEIVE_CNF_CHEN5 = 0x20
	// Disable events
	IPC_RECEIVE_CNF_CHEN5_Disable = 0x0
	// Enable events
	IPC_RECEIVE_CNF_CHEN5_Enable = 0x1
	// Position of CHEN6 field.
	IPC_RECEIVE_CNF_CHEN6_Pos = 0x6
	// Bit mask of CHEN6 field.
	IPC_RECEIVE_CNF_CHEN6_Msk = 0x40
	// Bit CHEN6.
	IPC_RECEIVE_CNF_CHEN6 = 0x40
	// Disable events
	IPC_RECEIVE_CNF_CHEN6_Disable = 0x0
	// Enable events
	IPC_RECEIVE_CNF_CHEN6_Enable = 0x1
	// Position of CHEN7 field.
	IPC_RECEIVE_CNF_CHEN7_Pos = 0x7
	// Bit mask of CHEN7 field.
	IPC_RECEIVE_CNF_CHEN7_Msk = 0x80
	// Bit CHEN7.
	IPC_RECEIVE_CNF_CHEN7 = 0x80
	// Disable events
	IPC_RECEIVE_CNF_CHEN7_Disable = 0x0
	// Enable events
	IPC_RECEIVE_CNF_CHEN7_Enable = 0x1
	// Position of CHEN8 field.
	IPC_RECEIVE_CNF_CHEN8_Pos = 0x8
	// Bit mask of CHEN8 field.
	IPC_RECEIVE_CNF_CHEN8_Msk = 0x100
	// Bit CHEN8.
	IPC_RECEIVE_CNF_CHEN8 = 0x100
	// Disable events
	IPC_RECEIVE_CNF_CHEN8_Disable = 0x0
	// Enable events
	IPC_RECEIVE_CNF_CHEN8_Enable = 0x1
	// Position of CHEN9 field.
	IPC_RECEIVE_CNF_CHEN9_Pos = 0x9
	// Bit mask of CHEN9 field.
	IPC_RECEIVE_CNF_CHEN9_Msk = 0x200
	// Bit CHEN9.
	IPC_RECEIVE_CNF_CHEN9 = 0x200
	// Disable events
	IPC_RECEIVE_CNF_CHEN9_Disable = 0x0
	// Enable events
	IPC_RECEIVE_CNF_CHEN9_Enable = 0x1
	// Position of CHEN10 field.
	IPC_RECEIVE_CNF_CHEN10_Pos = 0xa
	// Bit mask of CHEN10 field.
	IPC_RECEIVE_CNF_CHEN10_Msk = 0x400
	// Bit CHEN10.
	IPC_RECEIVE_CNF_CHEN10 = 0x400
	// Disable events
	IPC_RECEIVE_CNF_CHEN10_Disable = 0x0
	// Enable events
	IPC_RECEIVE_CNF_CHEN10_Enable = 0x1
	// Position of CHEN11 field.
	IPC_RECEIVE_CNF_CHEN11_Pos = 0xb
	// Bit mask of CHEN11 field.
	IPC_RECEIVE_CNF_CHEN11_Msk = 0x800
	// Bit CHEN11.
	IPC_RECEIVE_CNF_CHEN11 = 0x800
	// Disable events
	IPC_RECEIVE_CNF_CHEN11_Disable = 0x0
	// Enable events
	IPC_RECEIVE_CNF_CHEN11_Enable = 0x1
	// Position of CHEN12 field.
	IPC_RECEIVE_CNF_CHEN12_Pos = 0xc
	// Bit mask of CHEN12 field.
	IPC_RECEIVE_CNF_CHEN12_Msk = 0x1000
	// Bit CHEN12.
	IPC_RECEIVE_CNF_CHEN12 = 0x1000
	// Disable events
	IPC_RECEIVE_CNF_CHEN12_Disable = 0x0
	// Enable events
	IPC_RECEIVE_CNF_CHEN12_Enable = 0x1
	// Position of CHEN13 field.
	IPC_RECEIVE_CNF_CHEN13_Pos = 0xd
	// Bit mask of CHEN13 field.
	IPC_RECEIVE_CNF_CHEN13_Msk = 0x2000
	// Bit CHEN13.
	IPC_RECEIVE_CNF_CHEN13 = 0x2000
	// Disable events
	IPC_RECEIVE_CNF_CHEN13_Disable = 0x0
	// Enable events
	IPC_RECEIVE_CNF_CHEN13_Enable = 0x1
	// Position of CHEN14 field.
	IPC_RECEIVE_CNF_CHEN14_Pos = 0xe
	// Bit mask of CHEN14 field.
	IPC_RECEIVE_CNF_CHEN14_Msk = 0x4000
	// Bit CHEN14.
	IPC_RECEIVE_CNF_CHEN14 = 0x4000
	// Disable events
	IPC_RECEIVE_CNF_CHEN14_Disable = 0x0
	// Enable events
	IPC_RECEIVE_CNF_CHEN14_Enable = 0x1
	// Position of CHEN15 field.
	IPC_RECEIVE_CNF_CHEN15_Pos = 0xf
	// Bit mask of CHEN15 field.
	IPC_RECEIVE_CNF_CHEN15_Msk = 0x8000
	// Bit CHEN15.
	IPC_RECEIVE_CNF_CHEN15 = 0x8000
	// Disable events
	IPC_RECEIVE_CNF_CHEN15_Disable = 0x0
	// Enable events
	IPC_RECEIVE_CNF_CHEN15_Enable = 0x1

	// GPMEM: Description collection: General purpose memory
	// Position of GPMEM field.
	IPC_GPMEM_GPMEM_Pos = 0x0
	// Bit mask of GPMEM field.
	IPC_GPMEM_GPMEM_Msk = 0xffffffff
)

// Constants for SPIM0_NS: Serial Peripheral Interface Master with EasyDMA
const (
	// TASKS_START: Start SPI transaction
	// Position of TASKS_START field.
	SPIM_TASKS_START_TASKS_START_Pos = 0x0
	// Bit mask of TASKS_START field.
	SPIM_TASKS_START_TASKS_START_Msk = 0x1
	// Bit TASKS_START.
	SPIM_TASKS_START_TASKS_START = 0x1
	// Trigger task
	SPIM_TASKS_START_TASKS_START_Trigger = 0x1

	// TASKS_STOP: Stop SPI transaction
	// Position of TASKS_STOP field.
	SPIM_TASKS_STOP_TASKS_STOP_Pos = 0x0
	// Bit mask of TASKS_STOP field.
	SPIM_TASKS_STOP_TASKS_STOP_Msk = 0x1
	// Bit TASKS_STOP.
	SPIM_TASKS_STOP_TASKS_STOP = 0x1
	// Trigger task
	SPIM_TASKS_STOP_TASKS_STOP_Trigger = 0x1

	// TASKS_SUSPEND: Suspend SPI transaction
	// Position of TASKS_SUSPEND field.
	SPIM_TASKS_SUSPEND_TASKS_SUSPEND_Pos = 0x0
	// Bit mask of TASKS_SUSPEND field.
	SPIM_TASKS_SUSPEND_TASKS_SUSPEND_Msk = 0x1
	// Bit TASKS_SUSPEND.
	SPIM_TASKS_SUSPEND_TASKS_SUSPEND = 0x1
	// Trigger task
	SPIM_TASKS_SUSPEND_TASKS_SUSPEND_Trigger = 0x1

	// TASKS_RESUME: Resume SPI transaction
	// Position of TASKS_RESUME field.
	SPIM_TASKS_RESUME_TASKS_RESUME_Pos = 0x0
	// Bit mask of TASKS_RESUME field.
	SPIM_TASKS_RESUME_TASKS_RESUME_Msk = 0x1
	// Bit TASKS_RESUME.
	SPIM_TASKS_RESUME_TASKS_RESUME = 0x1
	// Trigger task
	SPIM_TASKS_RESUME_TASKS_RESUME_Trigger = 0x1

	// SUBSCRIBE_START: Subscribe configuration for task START
	// Position of CHIDX field.
	SPIM_SUBSCRIBE_START_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	SPIM_SUBSCRIBE_START_CHIDX_Msk = 0xff
	// Position of EN field.
	SPIM_SUBSCRIBE_START_EN_Pos = 0x1f
	// Bit mask of EN field.
	SPIM_SUBSCRIBE_START_EN_Msk = 0x80000000
	// Bit EN.
	SPIM_SUBSCRIBE_START_EN = 0x80000000
	// Disable subscription
	SPIM_SUBSCRIBE_START_EN_Disabled = 0x0
	// Enable subscription
	SPIM_SUBSCRIBE_START_EN_Enabled = 0x1

	// SUBSCRIBE_STOP: Subscribe configuration for task STOP
	// Position of CHIDX field.
	SPIM_SUBSCRIBE_STOP_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	SPIM_SUBSCRIBE_STOP_CHIDX_Msk = 0xff
	// Position of EN field.
	SPIM_SUBSCRIBE_STOP_EN_Pos = 0x1f
	// Bit mask of EN field.
	SPIM_SUBSCRIBE_STOP_EN_Msk = 0x80000000
	// Bit EN.
	SPIM_SUBSCRIBE_STOP_EN = 0x80000000
	// Disable subscription
	SPIM_SUBSCRIBE_STOP_EN_Disabled = 0x0
	// Enable subscription
	SPIM_SUBSCRIBE_STOP_EN_Enabled = 0x1

	// SUBSCRIBE_SUSPEND: Subscribe configuration for task SUSPEND
	// Position of CHIDX field.
	SPIM_SUBSCRIBE_SUSPEND_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	SPIM_SUBSCRIBE_SUSPEND_CHIDX_Msk = 0xff
	// Position of EN field.
	SPIM_SUBSCRIBE_SUSPEND_EN_Pos = 0x1f
	// Bit mask of EN field.
	SPIM_SUBSCRIBE_SUSPEND_EN_Msk = 0x80000000
	// Bit EN.
	SPIM_SUBSCRIBE_SUSPEND_EN = 0x80000000
	// Disable subscription
	SPIM_SUBSCRIBE_SUSPEND_EN_Disabled = 0x0
	// Enable subscription
	SPIM_SUBSCRIBE_SUSPEND_EN_Enabled = 0x1

	// SUBSCRIBE_RESUME: Subscribe configuration for task RESUME
	// Position of CHIDX field.
	SPIM_SUBSCRIBE_RESUME_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	SPIM_SUBSCRIBE_RESUME_CHIDX_Msk = 0xff
	// Position of EN field.
	SPIM_SUBSCRIBE_RESUME_EN_Pos = 0x1f
	// Bit mask of EN field.
	SPIM_SUBSCRIBE_RESUME_EN_Msk = 0x80000000
	// Bit EN.
	SPIM_SUBSCRIBE_RESUME_EN = 0x80000000
	// Disable subscription
	SPIM_SUBSCRIBE_RESUME_EN_Disabled = 0x0
	// Enable subscription
	SPIM_SUBSCRIBE_RESUME_EN_Enabled = 0x1

	// EVENTS_STOPPED: SPI transaction has stopped
	// Position of EVENTS_STOPPED field.
	SPIM_EVENTS_STOPPED_EVENTS_STOPPED_Pos = 0x0
	// Bit mask of EVENTS_STOPPED field.
	SPIM_EVENTS_STOPPED_EVENTS_STOPPED_Msk = 0x1
	// Bit EVENTS_STOPPED.
	SPIM_EVENTS_STOPPED_EVENTS_STOPPED = 0x1
	// Event not generated
	SPIM_EVENTS_STOPPED_EVENTS_STOPPED_NotGenerated = 0x0
	// Event generated
	SPIM_EVENTS_STOPPED_EVENTS_STOPPED_Generated = 0x1

	// EVENTS_ENDRX: End of RXD buffer reached
	// Position of EVENTS_ENDRX field.
	SPIM_EVENTS_ENDRX_EVENTS_ENDRX_Pos = 0x0
	// Bit mask of EVENTS_ENDRX field.
	SPIM_EVENTS_ENDRX_EVENTS_ENDRX_Msk = 0x1
	// Bit EVENTS_ENDRX.
	SPIM_EVENTS_ENDRX_EVENTS_ENDRX = 0x1
	// Event not generated
	SPIM_EVENTS_ENDRX_EVENTS_ENDRX_NotGenerated = 0x0
	// Event generated
	SPIM_EVENTS_ENDRX_EVENTS_ENDRX_Generated = 0x1

	// EVENTS_END: End of RXD buffer and TXD buffer reached
	// Position of EVENTS_END field.
	SPIM_EVENTS_END_EVENTS_END_Pos = 0x0
	// Bit mask of EVENTS_END field.
	SPIM_EVENTS_END_EVENTS_END_Msk = 0x1
	// Bit EVENTS_END.
	SPIM_EVENTS_END_EVENTS_END = 0x1
	// Event not generated
	SPIM_EVENTS_END_EVENTS_END_NotGenerated = 0x0
	// Event generated
	SPIM_EVENTS_END_EVENTS_END_Generated = 0x1

	// EVENTS_ENDTX: End of TXD buffer reached
	// Position of EVENTS_ENDTX field.
	SPIM_EVENTS_ENDTX_EVENTS_ENDTX_Pos = 0x0
	// Bit mask of EVENTS_ENDTX field.
	SPIM_EVENTS_ENDTX_EVENTS_ENDTX_Msk = 0x1
	// Bit EVENTS_ENDTX.
	SPIM_EVENTS_ENDTX_EVENTS_ENDTX = 0x1
	// Event not generated
	SPIM_EVENTS_ENDTX_EVENTS_ENDTX_NotGenerated = 0x0
	// Event generated
	SPIM_EVENTS_ENDTX_EVENTS_ENDTX_Generated = 0x1

	// EVENTS_STARTED: Transaction started
	// Position of EVENTS_STARTED field.
	SPIM_EVENTS_STARTED_EVENTS_STARTED_Pos = 0x0
	// Bit mask of EVENTS_STARTED field.
	SPIM_EVENTS_STARTED_EVENTS_STARTED_Msk = 0x1
	// Bit EVENTS_STARTED.
	SPIM_EVENTS_STARTED_EVENTS_STARTED = 0x1
	// Event not generated
	SPIM_EVENTS_STARTED_EVENTS_STARTED_NotGenerated = 0x0
	// Event generated
	SPIM_EVENTS_STARTED_EVENTS_STARTED_Generated = 0x1

	// PUBLISH_STOPPED: Publish configuration for event STOPPED
	// Position of CHIDX field.
	SPIM_PUBLISH_STOPPED_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	SPIM_PUBLISH_STOPPED_CHIDX_Msk = 0xff
	// Position of EN field.
	SPIM_PUBLISH_STOPPED_EN_Pos = 0x1f
	// Bit mask of EN field.
	SPIM_PUBLISH_STOPPED_EN_Msk = 0x80000000
	// Bit EN.
	SPIM_PUBLISH_STOPPED_EN = 0x80000000
	// Disable publishing
	SPIM_PUBLISH_STOPPED_EN_Disabled = 0x0
	// Enable publishing
	SPIM_PUBLISH_STOPPED_EN_Enabled = 0x1

	// PUBLISH_ENDRX: Publish configuration for event ENDRX
	// Position of CHIDX field.
	SPIM_PUBLISH_ENDRX_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	SPIM_PUBLISH_ENDRX_CHIDX_Msk = 0xff
	// Position of EN field.
	SPIM_PUBLISH_ENDRX_EN_Pos = 0x1f
	// Bit mask of EN field.
	SPIM_PUBLISH_ENDRX_EN_Msk = 0x80000000
	// Bit EN.
	SPIM_PUBLISH_ENDRX_EN = 0x80000000
	// Disable publishing
	SPIM_PUBLISH_ENDRX_EN_Disabled = 0x0
	// Enable publishing
	SPIM_PUBLISH_ENDRX_EN_Enabled = 0x1

	// PUBLISH_END: Publish configuration for event END
	// Position of CHIDX field.
	SPIM_PUBLISH_END_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	SPIM_PUBLISH_END_CHIDX_Msk = 0xff
	// Position of EN field.
	SPIM_PUBLISH_END_EN_Pos = 0x1f
	// Bit mask of EN field.
	SPIM_PUBLISH_END_EN_Msk = 0x80000000
	// Bit EN.
	SPIM_PUBLISH_END_EN = 0x80000000
	// Disable publishing
	SPIM_PUBLISH_END_EN_Disabled = 0x0
	// Enable publishing
	SPIM_PUBLISH_END_EN_Enabled = 0x1

	// PUBLISH_ENDTX: Publish configuration for event ENDTX
	// Position of CHIDX field.
	SPIM_PUBLISH_ENDTX_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	SPIM_PUBLISH_ENDTX_CHIDX_Msk = 0xff
	// Position of EN field.
	SPIM_PUBLISH_ENDTX_EN_Pos = 0x1f
	// Bit mask of EN field.
	SPIM_PUBLISH_ENDTX_EN_Msk = 0x80000000
	// Bit EN.
	SPIM_PUBLISH_ENDTX_EN = 0x80000000
	// Disable publishing
	SPIM_PUBLISH_ENDTX_EN_Disabled = 0x0
	// Enable publishing
	SPIM_PUBLISH_ENDTX_EN_Enabled = 0x1

	// PUBLISH_STARTED: Publish configuration for event STARTED
	// Position of CHIDX field.
	SPIM_PUBLISH_STARTED_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	SPIM_PUBLISH_STARTED_CHIDX_Msk = 0xff
	// Position of EN field.
	SPIM_PUBLISH_STARTED_EN_Pos = 0x1f
	// Bit mask of EN field.
	SPIM_PUBLISH_STARTED_EN_Msk = 0x80000000
	// Bit EN.
	SPIM_PUBLISH_STARTED_EN = 0x80000000
	// Disable publishing
	SPIM_PUBLISH_STARTED_EN_Disabled = 0x0
	// Enable publishing
	SPIM_PUBLISH_STARTED_EN_Enabled = 0x1

	// SHORTS: Shortcuts between local events and tasks
	// Position of END_START field.
	SPIM_SHORTS_END_START_Pos = 0x11
	// Bit mask of END_START field.
	SPIM_SHORTS_END_START_Msk = 0x20000
	// Bit END_START.
	SPIM_SHORTS_END_START = 0x20000
	// Disable shortcut
	SPIM_SHORTS_END_START_Disabled = 0x0
	// Enable shortcut
	SPIM_SHORTS_END_START_Enabled = 0x1

	// INTENSET: Enable interrupt
	// Position of STOPPED field.
	SPIM_INTENSET_STOPPED_Pos = 0x1
	// Bit mask of STOPPED field.
	SPIM_INTENSET_STOPPED_Msk = 0x2
	// Bit STOPPED.
	SPIM_INTENSET_STOPPED = 0x2
	// Read: Disabled
	SPIM_INTENSET_STOPPED_Disabled = 0x0
	// Read: Enabled
	SPIM_INTENSET_STOPPED_Enabled = 0x1
	// Enable
	SPIM_INTENSET_STOPPED_Set = 0x1
	// Position of ENDRX field.
	SPIM_INTENSET_ENDRX_Pos = 0x4
	// Bit mask of ENDRX field.
	SPIM_INTENSET_ENDRX_Msk = 0x10
	// Bit ENDRX.
	SPIM_INTENSET_ENDRX = 0x10
	// Read: Disabled
	SPIM_INTENSET_ENDRX_Disabled = 0x0
	// Read: Enabled
	SPIM_INTENSET_ENDRX_Enabled = 0x1
	// Enable
	SPIM_INTENSET_ENDRX_Set = 0x1
	// Position of END field.
	SPIM_INTENSET_END_Pos = 0x6
	// Bit mask of END field.
	SPIM_INTENSET_END_Msk = 0x40
	// Bit END.
	SPIM_INTENSET_END = 0x40
	// Read: Disabled
	SPIM_INTENSET_END_Disabled = 0x0
	// Read: Enabled
	SPIM_INTENSET_END_Enabled = 0x1
	// Enable
	SPIM_INTENSET_END_Set = 0x1
	// Position of ENDTX field.
	SPIM_INTENSET_ENDTX_Pos = 0x8
	// Bit mask of ENDTX field.
	SPIM_INTENSET_ENDTX_Msk = 0x100
	// Bit ENDTX.
	SPIM_INTENSET_ENDTX = 0x100
	// Read: Disabled
	SPIM_INTENSET_ENDTX_Disabled = 0x0
	// Read: Enabled
	SPIM_INTENSET_ENDTX_Enabled = 0x1
	// Enable
	SPIM_INTENSET_ENDTX_Set = 0x1
	// Position of STARTED field.
	SPIM_INTENSET_STARTED_Pos = 0x13
	// Bit mask of STARTED field.
	SPIM_INTENSET_STARTED_Msk = 0x80000
	// Bit STARTED.
	SPIM_INTENSET_STARTED = 0x80000
	// Read: Disabled
	SPIM_INTENSET_STARTED_Disabled = 0x0
	// Read: Enabled
	SPIM_INTENSET_STARTED_Enabled = 0x1
	// Enable
	SPIM_INTENSET_STARTED_Set = 0x1

	// INTENCLR: Disable interrupt
	// Position of STOPPED field.
	SPIM_INTENCLR_STOPPED_Pos = 0x1
	// Bit mask of STOPPED field.
	SPIM_INTENCLR_STOPPED_Msk = 0x2
	// Bit STOPPED.
	SPIM_INTENCLR_STOPPED = 0x2
	// Read: Disabled
	SPIM_INTENCLR_STOPPED_Disabled = 0x0
	// Read: Enabled
	SPIM_INTENCLR_STOPPED_Enabled = 0x1
	// Disable
	SPIM_INTENCLR_STOPPED_Clear = 0x1
	// Position of ENDRX field.
	SPIM_INTENCLR_ENDRX_Pos = 0x4
	// Bit mask of ENDRX field.
	SPIM_INTENCLR_ENDRX_Msk = 0x10
	// Bit ENDRX.
	SPIM_INTENCLR_ENDRX = 0x10
	// Read: Disabled
	SPIM_INTENCLR_ENDRX_Disabled = 0x0
	// Read: Enabled
	SPIM_INTENCLR_ENDRX_Enabled = 0x1
	// Disable
	SPIM_INTENCLR_ENDRX_Clear = 0x1
	// Position of END field.
	SPIM_INTENCLR_END_Pos = 0x6
	// Bit mask of END field.
	SPIM_INTENCLR_END_Msk = 0x40
	// Bit END.
	SPIM_INTENCLR_END = 0x40
	// Read: Disabled
	SPIM_INTENCLR_END_Disabled = 0x0
	// Read: Enabled
	SPIM_INTENCLR_END_Enabled = 0x1
	// Disable
	SPIM_INTENCLR_END_Clear = 0x1
	// Position of ENDTX field.
	SPIM_INTENCLR_ENDTX_Pos = 0x8
	// Bit mask of ENDTX field.
	SPIM_INTENCLR_ENDTX_Msk = 0x100
	// Bit ENDTX.
	SPIM_INTENCLR_ENDTX = 0x100
	// Read: Disabled
	SPIM_INTENCLR_ENDTX_Disabled = 0x0
	// Read: Enabled
	SPIM_INTENCLR_ENDTX_Enabled = 0x1
	// Disable
	SPIM_INTENCLR_ENDTX_Clear = 0x1
	// Position of STARTED field.
	SPIM_INTENCLR_STARTED_Pos = 0x13
	// Bit mask of STARTED field.
	SPIM_INTENCLR_STARTED_Msk = 0x80000
	// Bit STARTED.
	SPIM_INTENCLR_STARTED = 0x80000
	// Read: Disabled
	SPIM_INTENCLR_STARTED_Disabled = 0x0
	// Read: Enabled
	SPIM_INTENCLR_STARTED_Enabled = 0x1
	// Disable
	SPIM_INTENCLR_STARTED_Clear = 0x1

	// STALLSTAT: Stall status for EasyDMA RAM accesses. The fields in this register is set to STALL by hardware whenever a stall occurres and can be cleared (set to NOSTALL) by the CPU.
	// Position of TX field.
	SPIM_STALLSTAT_TX_Pos = 0x0
	// Bit mask of TX field.
	SPIM_STALLSTAT_TX_Msk = 0x1
	// Bit TX.
	SPIM_STALLSTAT_TX = 0x1
	// No stall
	SPIM_STALLSTAT_TX_NOSTALL = 0x0
	// A stall has occurred
	SPIM_STALLSTAT_TX_STALL = 0x1
	// Position of RX field.
	SPIM_STALLSTAT_RX_Pos = 0x1
	// Bit mask of RX field.
	SPIM_STALLSTAT_RX_Msk = 0x2
	// Bit RX.
	SPIM_STALLSTAT_RX = 0x2
	// No stall
	SPIM_STALLSTAT_RX_NOSTALL = 0x0
	// A stall has occurred
	SPIM_STALLSTAT_RX_STALL = 0x1

	// ENABLE: Enable SPIM
	// Position of ENABLE field.
	SPIM_ENABLE_ENABLE_Pos = 0x0
	// Bit mask of ENABLE field.
	SPIM_ENABLE_ENABLE_Msk = 0xf
	// Disable SPIM
	SPIM_ENABLE_ENABLE_Disabled = 0x0
	// Enable SPIM
	SPIM_ENABLE_ENABLE_Enabled = 0x7

	// PSEL.SCK: Pin select for SCK
	// Position of PIN field.
	SPIM_PSEL_SCK_PIN_Pos = 0x0
	// Bit mask of PIN field.
	SPIM_PSEL_SCK_PIN_Msk = 0x1f
	// Position of PORT field.
	SPIM_PSEL_SCK_PORT_Pos = 0x5
	// Bit mask of PORT field.
	SPIM_PSEL_SCK_PORT_Msk = 0x20
	// Bit PORT.
	SPIM_PSEL_SCK_PORT = 0x20
	// Position of CONNECT field.
	SPIM_PSEL_SCK_CONNECT_Pos = 0x1f
	// Bit mask of CONNECT field.
	SPIM_PSEL_SCK_CONNECT_Msk = 0x80000000
	// Bit CONNECT.
	SPIM_PSEL_SCK_CONNECT = 0x80000000
	// Disconnect
	SPIM_PSEL_SCK_CONNECT_Disconnected = 0x1
	// Connect
	SPIM_PSEL_SCK_CONNECT_Connected = 0x0

	// PSEL.MOSI: Pin select for MOSI signal
	// Position of PIN field.
	SPIM_PSEL_MOSI_PIN_Pos = 0x0
	// Bit mask of PIN field.
	SPIM_PSEL_MOSI_PIN_Msk = 0x1f
	// Position of PORT field.
	SPIM_PSEL_MOSI_PORT_Pos = 0x5
	// Bit mask of PORT field.
	SPIM_PSEL_MOSI_PORT_Msk = 0x20
	// Bit PORT.
	SPIM_PSEL_MOSI_PORT = 0x20
	// Position of CONNECT field.
	SPIM_PSEL_MOSI_CONNECT_Pos = 0x1f
	// Bit mask of CONNECT field.
	SPIM_PSEL_MOSI_CONNECT_Msk = 0x80000000
	// Bit CONNECT.
	SPIM_PSEL_MOSI_CONNECT = 0x80000000
	// Disconnect
	SPIM_PSEL_MOSI_CONNECT_Disconnected = 0x1
	// Connect
	SPIM_PSEL_MOSI_CONNECT_Connected = 0x0

	// PSEL.MISO: Pin select for MISO signal
	// Position of PIN field.
	SPIM_PSEL_MISO_PIN_Pos = 0x0
	// Bit mask of PIN field.
	SPIM_PSEL_MISO_PIN_Msk = 0x1f
	// Position of PORT field.
	SPIM_PSEL_MISO_PORT_Pos = 0x5
	// Bit mask of PORT field.
	SPIM_PSEL_MISO_PORT_Msk = 0x20
	// Bit PORT.
	SPIM_PSEL_MISO_PORT = 0x20
	// Position of CONNECT field.
	SPIM_PSEL_MISO_CONNECT_Pos = 0x1f
	// Bit mask of CONNECT field.
	SPIM_PSEL_MISO_CONNECT_Msk = 0x80000000
	// Bit CONNECT.
	SPIM_PSEL_MISO_CONNECT = 0x80000000
	// Disconnect
	SPIM_PSEL_MISO_CONNECT_Disconnected = 0x1
	// Connect
	SPIM_PSEL_MISO_CONNECT_Connected = 0x0

	// PSEL.CSN: Pin select for CSN
	// Position of PIN field.
	SPIM_PSEL_CSN_PIN_Pos = 0x0
	// Bit mask of PIN field.
	SPIM_PSEL_CSN_PIN_Msk = 0x1f
	// Position of PORT field.
	SPIM_PSEL_CSN_PORT_Pos = 0x5
	// Bit mask of PORT field.
	SPIM_PSEL_CSN_PORT_Msk = 0x20
	// Bit PORT.
	SPIM_PSEL_CSN_PORT = 0x20
	// Position of CONNECT field.
	SPIM_PSEL_CSN_CONNECT_Pos = 0x1f
	// Bit mask of CONNECT field.
	SPIM_PSEL_CSN_CONNECT_Msk = 0x80000000
	// Bit CONNECT.
	SPIM_PSEL_CSN_CONNECT = 0x80000000
	// Disconnect
	SPIM_PSEL_CSN_CONNECT_Disconnected = 0x1
	// Connect
	SPIM_PSEL_CSN_CONNECT_Connected = 0x0

	// FREQUENCY: SPI frequency. Accuracy depends on the HFCLK source selected.
	// Position of FREQUENCY field.
	SPIM_FREQUENCY_FREQUENCY_Pos = 0x0
	// Bit mask of FREQUENCY field.
	SPIM_FREQUENCY_FREQUENCY_Msk = 0xffffffff
	// 125 kbps
	SPIM_FREQUENCY_FREQUENCY_K125 = 0x2000000
	// 250 kbps
	SPIM_FREQUENCY_FREQUENCY_K250 = 0x4000000
	// 500 kbps
	SPIM_FREQUENCY_FREQUENCY_K500 = 0x8000000
	// 1 Mbps
	SPIM_FREQUENCY_FREQUENCY_M1 = 0x10000000
	// 2 Mbps
	SPIM_FREQUENCY_FREQUENCY_M2 = 0x20000000
	// 4 Mbps
	SPIM_FREQUENCY_FREQUENCY_M4 = 0x40000000
	// 8 Mbps
	SPIM_FREQUENCY_FREQUENCY_M8 = 0x80000000
	// 16 Mbps
	SPIM_FREQUENCY_FREQUENCY_M16 = 0xa000000
	// 32 Mbps
	SPIM_FREQUENCY_FREQUENCY_M32 = 0x14000000

	// RXD.PTR: Data pointer
	// Position of PTR field.
	SPIM_RXD_PTR_PTR_Pos = 0x0
	// Bit mask of PTR field.
	SPIM_RXD_PTR_PTR_Msk = 0xffffffff

	// RXD.MAXCNT: Maximum number of bytes in receive buffer
	// Position of MAXCNT field.
	SPIM_RXD_MAXCNT_MAXCNT_Pos = 0x0
	// Bit mask of MAXCNT field.
	SPIM_RXD_MAXCNT_MAXCNT_Msk = 0xffff

	// RXD.AMOUNT: Number of bytes transferred in the last transaction
	// Position of AMOUNT field.
	SPIM_RXD_AMOUNT_AMOUNT_Pos = 0x0
	// Bit mask of AMOUNT field.
	SPIM_RXD_AMOUNT_AMOUNT_Msk = 0xffff

	// RXD.LIST: EasyDMA list type
	// Position of LIST field.
	SPIM_RXD_LIST_LIST_Pos = 0x0
	// Bit mask of LIST field.
	SPIM_RXD_LIST_LIST_Msk = 0x3
	// Disable EasyDMA list
	SPIM_RXD_LIST_LIST_Disabled = 0x0
	// Use array list
	SPIM_RXD_LIST_LIST_ArrayList = 0x1

	// TXD.PTR: Data pointer
	// Position of PTR field.
	SPIM_TXD_PTR_PTR_Pos = 0x0
	// Bit mask of PTR field.
	SPIM_TXD_PTR_PTR_Msk = 0xffffffff

	// TXD.MAXCNT: Number of bytes in transmit buffer
	// Position of MAXCNT field.
	SPIM_TXD_MAXCNT_MAXCNT_Pos = 0x0
	// Bit mask of MAXCNT field.
	SPIM_TXD_MAXCNT_MAXCNT_Msk = 0xffff

	// TXD.AMOUNT: Number of bytes transferred in the last transaction
	// Position of AMOUNT field.
	SPIM_TXD_AMOUNT_AMOUNT_Pos = 0x0
	// Bit mask of AMOUNT field.
	SPIM_TXD_AMOUNT_AMOUNT_Msk = 0xffff

	// TXD.LIST: EasyDMA list type
	// Position of LIST field.
	SPIM_TXD_LIST_LIST_Pos = 0x0
	// Bit mask of LIST field.
	SPIM_TXD_LIST_LIST_Msk = 0x3
	// Disable EasyDMA list
	SPIM_TXD_LIST_LIST_Disabled = 0x0
	// Use array list
	SPIM_TXD_LIST_LIST_ArrayList = 0x1

	// CONFIG: Configuration register
	// Position of ORDER field.
	SPIM_CONFIG_ORDER_Pos = 0x0
	// Bit mask of ORDER field.
	SPIM_CONFIG_ORDER_Msk = 0x1
	// Bit ORDER.
	SPIM_CONFIG_ORDER = 0x1
	// Most significant bit shifted out first
	SPIM_CONFIG_ORDER_MsbFirst = 0x0
	// Least significant bit shifted out first
	SPIM_CONFIG_ORDER_LsbFirst = 0x1
	// Position of CPHA field.
	SPIM_CONFIG_CPHA_Pos = 0x1
	// Bit mask of CPHA field.
	SPIM_CONFIG_CPHA_Msk = 0x2
	// Bit CPHA.
	SPIM_CONFIG_CPHA = 0x2
	// Sample on leading edge of clock, shift serial data on trailing edge
	SPIM_CONFIG_CPHA_Leading = 0x0
	// Sample on trailing edge of clock, shift serial data on leading edge
	SPIM_CONFIG_CPHA_Trailing = 0x1
	// Position of CPOL field.
	SPIM_CONFIG_CPOL_Pos = 0x2
	// Bit mask of CPOL field.
	SPIM_CONFIG_CPOL_Msk = 0x4
	// Bit CPOL.
	SPIM_CONFIG_CPOL = 0x4
	// Active high
	SPIM_CONFIG_CPOL_ActiveHigh = 0x0
	// Active low
	SPIM_CONFIG_CPOL_ActiveLow = 0x1

	// IFTIMING.RXDELAY: Sample delay for input serial data on MISO
	// Position of RXDELAY field.
	SPIM_IFTIMING_RXDELAY_RXDELAY_Pos = 0x0
	// Bit mask of RXDELAY field.
	SPIM_IFTIMING_RXDELAY_RXDELAY_Msk = 0x7

	// IFTIMING.CSNDUR: Minimum duration between edge of CSN and edge of SCK and minimum duration CSN must stay high between transactions
	// Position of CSNDUR field.
	SPIM_IFTIMING_CSNDUR_CSNDUR_Pos = 0x0
	// Bit mask of CSNDUR field.
	SPIM_IFTIMING_CSNDUR_CSNDUR_Msk = 0xff

	// CSNPOL: Polarity of CSN output
	// Position of CSNPOL field.
	SPIM_CSNPOL_CSNPOL_Pos = 0x0
	// Bit mask of CSNPOL field.
	SPIM_CSNPOL_CSNPOL_Msk = 0x1
	// Bit CSNPOL.
	SPIM_CSNPOL_CSNPOL = 0x1
	// Active low (idle state high)
	SPIM_CSNPOL_CSNPOL_LOW = 0x0
	// Active high (idle state low)
	SPIM_CSNPOL_CSNPOL_HIGH = 0x1

	// PSELDCX: Pin select for DCX signal
	// Position of PIN field.
	SPIM_PSELDCX_PIN_Pos = 0x0
	// Bit mask of PIN field.
	SPIM_PSELDCX_PIN_Msk = 0x1f
	// Position of PORT field.
	SPIM_PSELDCX_PORT_Pos = 0x5
	// Bit mask of PORT field.
	SPIM_PSELDCX_PORT_Msk = 0x20
	// Bit PORT.
	SPIM_PSELDCX_PORT = 0x20
	// Position of CONNECT field.
	SPIM_PSELDCX_CONNECT_Pos = 0x1f
	// Bit mask of CONNECT field.
	SPIM_PSELDCX_CONNECT_Msk = 0x80000000
	// Bit CONNECT.
	SPIM_PSELDCX_CONNECT = 0x80000000
	// Disconnect
	SPIM_PSELDCX_CONNECT_Disconnected = 0x1
	// Connect
	SPIM_PSELDCX_CONNECT_Connected = 0x0

	// DCXCNT: DCX configuration
	// Position of DCXCNT field.
	SPIM_DCXCNT_DCXCNT_Pos = 0x0
	// Bit mask of DCXCNT field.
	SPIM_DCXCNT_DCXCNT_Msk = 0xf

	// ORC: Byte transmitted after TXD.MAXCNT bytes have been transmitted in the case when RXD.MAXCNT is greater than TXD.MAXCNT
	// Position of ORC field.
	SPIM_ORC_ORC_Pos = 0x0
	// Bit mask of ORC field.
	SPIM_ORC_ORC_Msk = 0xff
)

// Constants for SPIS0_NS: SPI Slave
const (
	// TASKS_ACQUIRE: Acquire SPI semaphore
	// Position of TASKS_ACQUIRE field.
	SPIS_TASKS_ACQUIRE_TASKS_ACQUIRE_Pos = 0x0
	// Bit mask of TASKS_ACQUIRE field.
	SPIS_TASKS_ACQUIRE_TASKS_ACQUIRE_Msk = 0x1
	// Bit TASKS_ACQUIRE.
	SPIS_TASKS_ACQUIRE_TASKS_ACQUIRE = 0x1
	// Trigger task
	SPIS_TASKS_ACQUIRE_TASKS_ACQUIRE_Trigger = 0x1

	// TASKS_RELEASE: Release SPI semaphore, enabling the SPI slave to acquire it
	// Position of TASKS_RELEASE field.
	SPIS_TASKS_RELEASE_TASKS_RELEASE_Pos = 0x0
	// Bit mask of TASKS_RELEASE field.
	SPIS_TASKS_RELEASE_TASKS_RELEASE_Msk = 0x1
	// Bit TASKS_RELEASE.
	SPIS_TASKS_RELEASE_TASKS_RELEASE = 0x1
	// Trigger task
	SPIS_TASKS_RELEASE_TASKS_RELEASE_Trigger = 0x1

	// SUBSCRIBE_ACQUIRE: Subscribe configuration for task ACQUIRE
	// Position of CHIDX field.
	SPIS_SUBSCRIBE_ACQUIRE_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	SPIS_SUBSCRIBE_ACQUIRE_CHIDX_Msk = 0xff
	// Position of EN field.
	SPIS_SUBSCRIBE_ACQUIRE_EN_Pos = 0x1f
	// Bit mask of EN field.
	SPIS_SUBSCRIBE_ACQUIRE_EN_Msk = 0x80000000
	// Bit EN.
	SPIS_SUBSCRIBE_ACQUIRE_EN = 0x80000000
	// Disable subscription
	SPIS_SUBSCRIBE_ACQUIRE_EN_Disabled = 0x0
	// Enable subscription
	SPIS_SUBSCRIBE_ACQUIRE_EN_Enabled = 0x1

	// SUBSCRIBE_RELEASE: Subscribe configuration for task RELEASE
	// Position of CHIDX field.
	SPIS_SUBSCRIBE_RELEASE_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	SPIS_SUBSCRIBE_RELEASE_CHIDX_Msk = 0xff
	// Position of EN field.
	SPIS_SUBSCRIBE_RELEASE_EN_Pos = 0x1f
	// Bit mask of EN field.
	SPIS_SUBSCRIBE_RELEASE_EN_Msk = 0x80000000
	// Bit EN.
	SPIS_SUBSCRIBE_RELEASE_EN = 0x80000000
	// Disable subscription
	SPIS_SUBSCRIBE_RELEASE_EN_Disabled = 0x0
	// Enable subscription
	SPIS_SUBSCRIBE_RELEASE_EN_Enabled = 0x1

	// EVENTS_END: Granted transaction completed
	// Position of EVENTS_END field.
	SPIS_EVENTS_END_EVENTS_END_Pos = 0x0
	// Bit mask of EVENTS_END field.
	SPIS_EVENTS_END_EVENTS_END_Msk = 0x1
	// Bit EVENTS_END.
	SPIS_EVENTS_END_EVENTS_END = 0x1
	// Event not generated
	SPIS_EVENTS_END_EVENTS_END_NotGenerated = 0x0
	// Event generated
	SPIS_EVENTS_END_EVENTS_END_Generated = 0x1

	// EVENTS_ENDRX: End of RXD buffer reached
	// Position of EVENTS_ENDRX field.
	SPIS_EVENTS_ENDRX_EVENTS_ENDRX_Pos = 0x0
	// Bit mask of EVENTS_ENDRX field.
	SPIS_EVENTS_ENDRX_EVENTS_ENDRX_Msk = 0x1
	// Bit EVENTS_ENDRX.
	SPIS_EVENTS_ENDRX_EVENTS_ENDRX = 0x1
	// Event not generated
	SPIS_EVENTS_ENDRX_EVENTS_ENDRX_NotGenerated = 0x0
	// Event generated
	SPIS_EVENTS_ENDRX_EVENTS_ENDRX_Generated = 0x1

	// EVENTS_ACQUIRED: Semaphore acquired
	// Position of EVENTS_ACQUIRED field.
	SPIS_EVENTS_ACQUIRED_EVENTS_ACQUIRED_Pos = 0x0
	// Bit mask of EVENTS_ACQUIRED field.
	SPIS_EVENTS_ACQUIRED_EVENTS_ACQUIRED_Msk = 0x1
	// Bit EVENTS_ACQUIRED.
	SPIS_EVENTS_ACQUIRED_EVENTS_ACQUIRED = 0x1
	// Event not generated
	SPIS_EVENTS_ACQUIRED_EVENTS_ACQUIRED_NotGenerated = 0x0
	// Event generated
	SPIS_EVENTS_ACQUIRED_EVENTS_ACQUIRED_Generated = 0x1

	// PUBLISH_END: Publish configuration for event END
	// Position of CHIDX field.
	SPIS_PUBLISH_END_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	SPIS_PUBLISH_END_CHIDX_Msk = 0xff
	// Position of EN field.
	SPIS_PUBLISH_END_EN_Pos = 0x1f
	// Bit mask of EN field.
	SPIS_PUBLISH_END_EN_Msk = 0x80000000
	// Bit EN.
	SPIS_PUBLISH_END_EN = 0x80000000
	// Disable publishing
	SPIS_PUBLISH_END_EN_Disabled = 0x0
	// Enable publishing
	SPIS_PUBLISH_END_EN_Enabled = 0x1

	// PUBLISH_ENDRX: Publish configuration for event ENDRX
	// Position of CHIDX field.
	SPIS_PUBLISH_ENDRX_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	SPIS_PUBLISH_ENDRX_CHIDX_Msk = 0xff
	// Position of EN field.
	SPIS_PUBLISH_ENDRX_EN_Pos = 0x1f
	// Bit mask of EN field.
	SPIS_PUBLISH_ENDRX_EN_Msk = 0x80000000
	// Bit EN.
	SPIS_PUBLISH_ENDRX_EN = 0x80000000
	// Disable publishing
	SPIS_PUBLISH_ENDRX_EN_Disabled = 0x0
	// Enable publishing
	SPIS_PUBLISH_ENDRX_EN_Enabled = 0x1

	// PUBLISH_ACQUIRED: Publish configuration for event ACQUIRED
	// Position of CHIDX field.
	SPIS_PUBLISH_ACQUIRED_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	SPIS_PUBLISH_ACQUIRED_CHIDX_Msk = 0xff
	// Position of EN field.
	SPIS_PUBLISH_ACQUIRED_EN_Pos = 0x1f
	// Bit mask of EN field.
	SPIS_PUBLISH_ACQUIRED_EN_Msk = 0x80000000
	// Bit EN.
	SPIS_PUBLISH_ACQUIRED_EN = 0x80000000
	// Disable publishing
	SPIS_PUBLISH_ACQUIRED_EN_Disabled = 0x0
	// Enable publishing
	SPIS_PUBLISH_ACQUIRED_EN_Enabled = 0x1

	// SHORTS: Shortcuts between local events and tasks
	// Position of END_ACQUIRE field.
	SPIS_SHORTS_END_ACQUIRE_Pos = 0x2
	// Bit mask of END_ACQUIRE field.
	SPIS_SHORTS_END_ACQUIRE_Msk = 0x4
	// Bit END_ACQUIRE.
	SPIS_SHORTS_END_ACQUIRE = 0x4
	// Disable shortcut
	SPIS_SHORTS_END_ACQUIRE_Disabled = 0x0
	// Enable shortcut
	SPIS_SHORTS_END_ACQUIRE_Enabled = 0x1

	// INTENSET: Enable interrupt
	// Position of END field.
	SPIS_INTENSET_END_Pos = 0x1
	// Bit mask of END field.
	SPIS_INTENSET_END_Msk = 0x2
	// Bit END.
	SPIS_INTENSET_END = 0x2
	// Read: Disabled
	SPIS_INTENSET_END_Disabled = 0x0
	// Read: Enabled
	SPIS_INTENSET_END_Enabled = 0x1
	// Enable
	SPIS_INTENSET_END_Set = 0x1
	// Position of ENDRX field.
	SPIS_INTENSET_ENDRX_Pos = 0x4
	// Bit mask of ENDRX field.
	SPIS_INTENSET_ENDRX_Msk = 0x10
	// Bit ENDRX.
	SPIS_INTENSET_ENDRX = 0x10
	// Read: Disabled
	SPIS_INTENSET_ENDRX_Disabled = 0x0
	// Read: Enabled
	SPIS_INTENSET_ENDRX_Enabled = 0x1
	// Enable
	SPIS_INTENSET_ENDRX_Set = 0x1
	// Position of ACQUIRED field.
	SPIS_INTENSET_ACQUIRED_Pos = 0xa
	// Bit mask of ACQUIRED field.
	SPIS_INTENSET_ACQUIRED_Msk = 0x400
	// Bit ACQUIRED.
	SPIS_INTENSET_ACQUIRED = 0x400
	// Read: Disabled
	SPIS_INTENSET_ACQUIRED_Disabled = 0x0
	// Read: Enabled
	SPIS_INTENSET_ACQUIRED_Enabled = 0x1
	// Enable
	SPIS_INTENSET_ACQUIRED_Set = 0x1

	// INTENCLR: Disable interrupt
	// Position of END field.
	SPIS_INTENCLR_END_Pos = 0x1
	// Bit mask of END field.
	SPIS_INTENCLR_END_Msk = 0x2
	// Bit END.
	SPIS_INTENCLR_END = 0x2
	// Read: Disabled
	SPIS_INTENCLR_END_Disabled = 0x0
	// Read: Enabled
	SPIS_INTENCLR_END_Enabled = 0x1
	// Disable
	SPIS_INTENCLR_END_Clear = 0x1
	// Position of ENDRX field.
	SPIS_INTENCLR_ENDRX_Pos = 0x4
	// Bit mask of ENDRX field.
	SPIS_INTENCLR_ENDRX_Msk = 0x10
	// Bit ENDRX.
	SPIS_INTENCLR_ENDRX = 0x10
	// Read: Disabled
	SPIS_INTENCLR_ENDRX_Disabled = 0x0
	// Read: Enabled
	SPIS_INTENCLR_ENDRX_Enabled = 0x1
	// Disable
	SPIS_INTENCLR_ENDRX_Clear = 0x1
	// Position of ACQUIRED field.
	SPIS_INTENCLR_ACQUIRED_Pos = 0xa
	// Bit mask of ACQUIRED field.
	SPIS_INTENCLR_ACQUIRED_Msk = 0x400
	// Bit ACQUIRED.
	SPIS_INTENCLR_ACQUIRED = 0x400
	// Read: Disabled
	SPIS_INTENCLR_ACQUIRED_Disabled = 0x0
	// Read: Enabled
	SPIS_INTENCLR_ACQUIRED_Enabled = 0x1
	// Disable
	SPIS_INTENCLR_ACQUIRED_Clear = 0x1

	// SEMSTAT: Semaphore status register
	// Position of SEMSTAT field.
	SPIS_SEMSTAT_SEMSTAT_Pos = 0x0
	// Bit mask of SEMSTAT field.
	SPIS_SEMSTAT_SEMSTAT_Msk = 0x3
	// Semaphore is free
	SPIS_SEMSTAT_SEMSTAT_Free = 0x0
	// Semaphore is assigned to CPU
	SPIS_SEMSTAT_SEMSTAT_CPU = 0x1
	// Semaphore is assigned to SPI slave
	SPIS_SEMSTAT_SEMSTAT_SPIS = 0x2
	// Semaphore is assigned to SPI but a handover to the CPU is pending
	SPIS_SEMSTAT_SEMSTAT_CPUPending = 0x3

	// STATUS: Status from last transaction
	// Position of OVERREAD field.
	SPIS_STATUS_OVERREAD_Pos = 0x0
	// Bit mask of OVERREAD field.
	SPIS_STATUS_OVERREAD_Msk = 0x1
	// Bit OVERREAD.
	SPIS_STATUS_OVERREAD = 0x1
	// Read: error not present
	SPIS_STATUS_OVERREAD_NotPresent = 0x0
	// Read: error present
	SPIS_STATUS_OVERREAD_Present = 0x1
	// Write: clear error on writing '1'
	SPIS_STATUS_OVERREAD_Clear = 0x1
	// Position of OVERFLOW field.
	SPIS_STATUS_OVERFLOW_Pos = 0x1
	// Bit mask of OVERFLOW field.
	SPIS_STATUS_OVERFLOW_Msk = 0x2
	// Bit OVERFLOW.
	SPIS_STATUS_OVERFLOW = 0x2
	// Read: error not present
	SPIS_STATUS_OVERFLOW_NotPresent = 0x0
	// Read: error present
	SPIS_STATUS_OVERFLOW_Present = 0x1
	// Write: clear error on writing '1'
	SPIS_STATUS_OVERFLOW_Clear = 0x1

	// ENABLE: Enable SPI slave
	// Position of ENABLE field.
	SPIS_ENABLE_ENABLE_Pos = 0x0
	// Bit mask of ENABLE field.
	SPIS_ENABLE_ENABLE_Msk = 0xf
	// Disable SPI slave
	SPIS_ENABLE_ENABLE_Disabled = 0x0
	// Enable SPI slave
	SPIS_ENABLE_ENABLE_Enabled = 0x2

	// PSEL.SCK: Pin select for SCK
	// Position of PIN field.
	SPIS_PSEL_SCK_PIN_Pos = 0x0
	// Bit mask of PIN field.
	SPIS_PSEL_SCK_PIN_Msk = 0x1f
	// Position of PORT field.
	SPIS_PSEL_SCK_PORT_Pos = 0x5
	// Bit mask of PORT field.
	SPIS_PSEL_SCK_PORT_Msk = 0x20
	// Bit PORT.
	SPIS_PSEL_SCK_PORT = 0x20
	// Position of CONNECT field.
	SPIS_PSEL_SCK_CONNECT_Pos = 0x1f
	// Bit mask of CONNECT field.
	SPIS_PSEL_SCK_CONNECT_Msk = 0x80000000
	// Bit CONNECT.
	SPIS_PSEL_SCK_CONNECT = 0x80000000
	// Disconnect
	SPIS_PSEL_SCK_CONNECT_Disconnected = 0x1
	// Connect
	SPIS_PSEL_SCK_CONNECT_Connected = 0x0

	// PSEL.MISO: Pin select for MISO signal
	// Position of PIN field.
	SPIS_PSEL_MISO_PIN_Pos = 0x0
	// Bit mask of PIN field.
	SPIS_PSEL_MISO_PIN_Msk = 0x1f
	// Position of PORT field.
	SPIS_PSEL_MISO_PORT_Pos = 0x5
	// Bit mask of PORT field.
	SPIS_PSEL_MISO_PORT_Msk = 0x20
	// Bit PORT.
	SPIS_PSEL_MISO_PORT = 0x20
	// Position of CONNECT field.
	SPIS_PSEL_MISO_CONNECT_Pos = 0x1f
	// Bit mask of CONNECT field.
	SPIS_PSEL_MISO_CONNECT_Msk = 0x80000000
	// Bit CONNECT.
	SPIS_PSEL_MISO_CONNECT = 0x80000000
	// Disconnect
	SPIS_PSEL_MISO_CONNECT_Disconnected = 0x1
	// Connect
	SPIS_PSEL_MISO_CONNECT_Connected = 0x0

	// PSEL.MOSI: Pin select for MOSI signal
	// Position of PIN field.
	SPIS_PSEL_MOSI_PIN_Pos = 0x0
	// Bit mask of PIN field.
	SPIS_PSEL_MOSI_PIN_Msk = 0x1f
	// Position of PORT field.
	SPIS_PSEL_MOSI_PORT_Pos = 0x5
	// Bit mask of PORT field.
	SPIS_PSEL_MOSI_PORT_Msk = 0x20
	// Bit PORT.
	SPIS_PSEL_MOSI_PORT = 0x20
	// Position of CONNECT field.
	SPIS_PSEL_MOSI_CONNECT_Pos = 0x1f
	// Bit mask of CONNECT field.
	SPIS_PSEL_MOSI_CONNECT_Msk = 0x80000000
	// Bit CONNECT.
	SPIS_PSEL_MOSI_CONNECT = 0x80000000
	// Disconnect
	SPIS_PSEL_MOSI_CONNECT_Disconnected = 0x1
	// Connect
	SPIS_PSEL_MOSI_CONNECT_Connected = 0x0

	// PSEL.CSN: Pin select for CSN signal
	// Position of PIN field.
	SPIS_PSEL_CSN_PIN_Pos = 0x0
	// Bit mask of PIN field.
	SPIS_PSEL_CSN_PIN_Msk = 0x1f
	// Position of PORT field.
	SPIS_PSEL_CSN_PORT_Pos = 0x5
	// Bit mask of PORT field.
	SPIS_PSEL_CSN_PORT_Msk = 0x20
	// Bit PORT.
	SPIS_PSEL_CSN_PORT = 0x20
	// Position of CONNECT field.
	SPIS_PSEL_CSN_CONNECT_Pos = 0x1f
	// Bit mask of CONNECT field.
	SPIS_PSEL_CSN_CONNECT_Msk = 0x80000000
	// Bit CONNECT.
	SPIS_PSEL_CSN_CONNECT = 0x80000000
	// Disconnect
	SPIS_PSEL_CSN_CONNECT_Disconnected = 0x1
	// Connect
	SPIS_PSEL_CSN_CONNECT_Connected = 0x0

	// RXD.PTR: RXD data pointer
	// Position of PTR field.
	SPIS_RXD_PTR_PTR_Pos = 0x0
	// Bit mask of PTR field.
	SPIS_RXD_PTR_PTR_Msk = 0xffffffff

	// RXD.MAXCNT: Maximum number of bytes in receive buffer
	// Position of MAXCNT field.
	SPIS_RXD_MAXCNT_MAXCNT_Pos = 0x0
	// Bit mask of MAXCNT field.
	SPIS_RXD_MAXCNT_MAXCNT_Msk = 0xffff

	// RXD.AMOUNT: Number of bytes received in last granted transaction
	// Position of AMOUNT field.
	SPIS_RXD_AMOUNT_AMOUNT_Pos = 0x0
	// Bit mask of AMOUNT field.
	SPIS_RXD_AMOUNT_AMOUNT_Msk = 0xffff

	// RXD.LIST: EasyDMA list type
	// Position of LIST field.
	SPIS_RXD_LIST_LIST_Pos = 0x0
	// Bit mask of LIST field.
	SPIS_RXD_LIST_LIST_Msk = 0x3
	// Disable EasyDMA list
	SPIS_RXD_LIST_LIST_Disabled = 0x0
	// Use array list
	SPIS_RXD_LIST_LIST_ArrayList = 0x1

	// TXD.PTR: TXD data pointer
	// Position of PTR field.
	SPIS_TXD_PTR_PTR_Pos = 0x0
	// Bit mask of PTR field.
	SPIS_TXD_PTR_PTR_Msk = 0xffffffff

	// TXD.MAXCNT: Maximum number of bytes in transmit buffer
	// Position of MAXCNT field.
	SPIS_TXD_MAXCNT_MAXCNT_Pos = 0x0
	// Bit mask of MAXCNT field.
	SPIS_TXD_MAXCNT_MAXCNT_Msk = 0xffff

	// TXD.AMOUNT: Number of bytes transmitted in last granted transaction
	// Position of AMOUNT field.
	SPIS_TXD_AMOUNT_AMOUNT_Pos = 0x0
	// Bit mask of AMOUNT field.
	SPIS_TXD_AMOUNT_AMOUNT_Msk = 0xffff

	// TXD.LIST: EasyDMA list type
	// Position of LIST field.
	SPIS_TXD_LIST_LIST_Pos = 0x0
	// Bit mask of LIST field.
	SPIS_TXD_LIST_LIST_Msk = 0x3
	// Disable EasyDMA list
	SPIS_TXD_LIST_LIST_Disabled = 0x0
	// Use array list
	SPIS_TXD_LIST_LIST_ArrayList = 0x1

	// CONFIG: Configuration register
	// Position of ORDER field.
	SPIS_CONFIG_ORDER_Pos = 0x0
	// Bit mask of ORDER field.
	SPIS_CONFIG_ORDER_Msk = 0x1
	// Bit ORDER.
	SPIS_CONFIG_ORDER = 0x1
	// Most significant bit shifted out first
	SPIS_CONFIG_ORDER_MsbFirst = 0x0
	// Least significant bit shifted out first
	SPIS_CONFIG_ORDER_LsbFirst = 0x1
	// Position of CPHA field.
	SPIS_CONFIG_CPHA_Pos = 0x1
	// Bit mask of CPHA field.
	SPIS_CONFIG_CPHA_Msk = 0x2
	// Bit CPHA.
	SPIS_CONFIG_CPHA = 0x2
	// Sample on leading edge of clock, shift serial data on trailing edge
	SPIS_CONFIG_CPHA_Leading = 0x0
	// Sample on trailing edge of clock, shift serial data on leading edge
	SPIS_CONFIG_CPHA_Trailing = 0x1
	// Position of CPOL field.
	SPIS_CONFIG_CPOL_Pos = 0x2
	// Bit mask of CPOL field.
	SPIS_CONFIG_CPOL_Msk = 0x4
	// Bit CPOL.
	SPIS_CONFIG_CPOL = 0x4
	// Active high
	SPIS_CONFIG_CPOL_ActiveHigh = 0x0
	// Active low
	SPIS_CONFIG_CPOL_ActiveLow = 0x1

	// DEF: Default character. Character clocked out in case of an ignored transaction.
	// Position of DEF field.
	SPIS_DEF_DEF_Pos = 0x0
	// Bit mask of DEF field.
	SPIS_DEF_DEF_Msk = 0xff

	// ORC: Over-read character
	// Position of ORC field.
	SPIS_ORC_ORC_Pos = 0x0
	// Bit mask of ORC field.
	SPIS_ORC_ORC_Msk = 0xff
)

// Constants for TWIM0_NS: I2C compatible Two-Wire Master Interface with EasyDMA
const (
	// TASKS_STARTRX: Start TWI receive sequence
	// Position of TASKS_STARTRX field.
	TWIM_TASKS_STARTRX_TASKS_STARTRX_Pos = 0x0
	// Bit mask of TASKS_STARTRX field.
	TWIM_TASKS_STARTRX_TASKS_STARTRX_Msk = 0x1
	// Bit TASKS_STARTRX.
	TWIM_TASKS_STARTRX_TASKS_STARTRX = 0x1
	// Trigger task
	TWIM_TASKS_STARTRX_TASKS_STARTRX_Trigger = 0x1

	// TASKS_STARTTX: Start TWI transmit sequence
	// Position of TASKS_STARTTX field.
	TWIM_TASKS_STARTTX_TASKS_STARTTX_Pos = 0x0
	// Bit mask of TASKS_STARTTX field.
	TWIM_TASKS_STARTTX_TASKS_STARTTX_Msk = 0x1
	// Bit TASKS_STARTTX.
	TWIM_TASKS_STARTTX_TASKS_STARTTX = 0x1
	// Trigger task
	TWIM_TASKS_STARTTX_TASKS_STARTTX_Trigger = 0x1

	// TASKS_STOP: Stop TWI transaction. Must be issued while the TWI master is not suspended.
	// Position of TASKS_STOP field.
	TWIM_TASKS_STOP_TASKS_STOP_Pos = 0x0
	// Bit mask of TASKS_STOP field.
	TWIM_TASKS_STOP_TASKS_STOP_Msk = 0x1
	// Bit TASKS_STOP.
	TWIM_TASKS_STOP_TASKS_STOP = 0x1
	// Trigger task
	TWIM_TASKS_STOP_TASKS_STOP_Trigger = 0x1

	// TASKS_SUSPEND: Suspend TWI transaction
	// Position of TASKS_SUSPEND field.
	TWIM_TASKS_SUSPEND_TASKS_SUSPEND_Pos = 0x0
	// Bit mask of TASKS_SUSPEND field.
	TWIM_TASKS_SUSPEND_TASKS_SUSPEND_Msk = 0x1
	// Bit TASKS_SUSPEND.
	TWIM_TASKS_SUSPEND_TASKS_SUSPEND = 0x1
	// Trigger task
	TWIM_TASKS_SUSPEND_TASKS_SUSPEND_Trigger = 0x1

	// TASKS_RESUME: Resume TWI transaction
	// Position of TASKS_RESUME field.
	TWIM_TASKS_RESUME_TASKS_RESUME_Pos = 0x0
	// Bit mask of TASKS_RESUME field.
	TWIM_TASKS_RESUME_TASKS_RESUME_Msk = 0x1
	// Bit TASKS_RESUME.
	TWIM_TASKS_RESUME_TASKS_RESUME = 0x1
	// Trigger task
	TWIM_TASKS_RESUME_TASKS_RESUME_Trigger = 0x1

	// SUBSCRIBE_STARTRX: Subscribe configuration for task STARTRX
	// Position of CHIDX field.
	TWIM_SUBSCRIBE_STARTRX_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	TWIM_SUBSCRIBE_STARTRX_CHIDX_Msk = 0xff
	// Position of EN field.
	TWIM_SUBSCRIBE_STARTRX_EN_Pos = 0x1f
	// Bit mask of EN field.
	TWIM_SUBSCRIBE_STARTRX_EN_Msk = 0x80000000
	// Bit EN.
	TWIM_SUBSCRIBE_STARTRX_EN = 0x80000000
	// Disable subscription
	TWIM_SUBSCRIBE_STARTRX_EN_Disabled = 0x0
	// Enable subscription
	TWIM_SUBSCRIBE_STARTRX_EN_Enabled = 0x1

	// SUBSCRIBE_STARTTX: Subscribe configuration for task STARTTX
	// Position of CHIDX field.
	TWIM_SUBSCRIBE_STARTTX_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	TWIM_SUBSCRIBE_STARTTX_CHIDX_Msk = 0xff
	// Position of EN field.
	TWIM_SUBSCRIBE_STARTTX_EN_Pos = 0x1f
	// Bit mask of EN field.
	TWIM_SUBSCRIBE_STARTTX_EN_Msk = 0x80000000
	// Bit EN.
	TWIM_SUBSCRIBE_STARTTX_EN = 0x80000000
	// Disable subscription
	TWIM_SUBSCRIBE_STARTTX_EN_Disabled = 0x0
	// Enable subscription
	TWIM_SUBSCRIBE_STARTTX_EN_Enabled = 0x1

	// SUBSCRIBE_STOP: Subscribe configuration for task STOP
	// Position of CHIDX field.
	TWIM_SUBSCRIBE_STOP_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	TWIM_SUBSCRIBE_STOP_CHIDX_Msk = 0xff
	// Position of EN field.
	TWIM_SUBSCRIBE_STOP_EN_Pos = 0x1f
	// Bit mask of EN field.
	TWIM_SUBSCRIBE_STOP_EN_Msk = 0x80000000
	// Bit EN.
	TWIM_SUBSCRIBE_STOP_EN = 0x80000000
	// Disable subscription
	TWIM_SUBSCRIBE_STOP_EN_Disabled = 0x0
	// Enable subscription
	TWIM_SUBSCRIBE_STOP_EN_Enabled = 0x1

	// SUBSCRIBE_SUSPEND: Subscribe configuration for task SUSPEND
	// Position of CHIDX field.
	TWIM_SUBSCRIBE_SUSPEND_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	TWIM_SUBSCRIBE_SUSPEND_CHIDX_Msk = 0xff
	// Position of EN field.
	TWIM_SUBSCRIBE_SUSPEND_EN_Pos = 0x1f
	// Bit mask of EN field.
	TWIM_SUBSCRIBE_SUSPEND_EN_Msk = 0x80000000
	// Bit EN.
	TWIM_SUBSCRIBE_SUSPEND_EN = 0x80000000
	// Disable subscription
	TWIM_SUBSCRIBE_SUSPEND_EN_Disabled = 0x0
	// Enable subscription
	TWIM_SUBSCRIBE_SUSPEND_EN_Enabled = 0x1

	// SUBSCRIBE_RESUME: Subscribe configuration for task RESUME
	// Position of CHIDX field.
	TWIM_SUBSCRIBE_RESUME_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	TWIM_SUBSCRIBE_RESUME_CHIDX_Msk = 0xff
	// Position of EN field.
	TWIM_SUBSCRIBE_RESUME_EN_Pos = 0x1f
	// Bit mask of EN field.
	TWIM_SUBSCRIBE_RESUME_EN_Msk = 0x80000000
	// Bit EN.
	TWIM_SUBSCRIBE_RESUME_EN = 0x80000000
	// Disable subscription
	TWIM_SUBSCRIBE_RESUME_EN_Disabled = 0x0
	// Enable subscription
	TWIM_SUBSCRIBE_RESUME_EN_Enabled = 0x1

	// EVENTS_STOPPED: TWI stopped
	// Position of EVENTS_STOPPED field.
	TWIM_EVENTS_STOPPED_EVENTS_STOPPED_Pos = 0x0
	// Bit mask of EVENTS_STOPPED field.
	TWIM_EVENTS_STOPPED_EVENTS_STOPPED_Msk = 0x1
	// Bit EVENTS_STOPPED.
	TWIM_EVENTS_STOPPED_EVENTS_STOPPED = 0x1
	// Event not generated
	TWIM_EVENTS_STOPPED_EVENTS_STOPPED_NotGenerated = 0x0
	// Event generated
	TWIM_EVENTS_STOPPED_EVENTS_STOPPED_Generated = 0x1

	// EVENTS_ERROR: TWI error
	// Position of EVENTS_ERROR field.
	TWIM_EVENTS_ERROR_EVENTS_ERROR_Pos = 0x0
	// Bit mask of EVENTS_ERROR field.
	TWIM_EVENTS_ERROR_EVENTS_ERROR_Msk = 0x1
	// Bit EVENTS_ERROR.
	TWIM_EVENTS_ERROR_EVENTS_ERROR = 0x1
	// Event not generated
	TWIM_EVENTS_ERROR_EVENTS_ERROR_NotGenerated = 0x0
	// Event generated
	TWIM_EVENTS_ERROR_EVENTS_ERROR_Generated = 0x1

	// EVENTS_SUSPENDED: SUSPEND task has been issued, TWI traffic is now suspended.
	// Position of EVENTS_SUSPENDED field.
	TWIM_EVENTS_SUSPENDED_EVENTS_SUSPENDED_Pos = 0x0
	// Bit mask of EVENTS_SUSPENDED field.
	TWIM_EVENTS_SUSPENDED_EVENTS_SUSPENDED_Msk = 0x1
	// Bit EVENTS_SUSPENDED.
	TWIM_EVENTS_SUSPENDED_EVENTS_SUSPENDED = 0x1
	// Event not generated
	TWIM_EVENTS_SUSPENDED_EVENTS_SUSPENDED_NotGenerated = 0x0
	// Event generated
	TWIM_EVENTS_SUSPENDED_EVENTS_SUSPENDED_Generated = 0x1

	// EVENTS_RXSTARTED: Receive sequence started
	// Position of EVENTS_RXSTARTED field.
	TWIM_EVENTS_RXSTARTED_EVENTS_RXSTARTED_Pos = 0x0
	// Bit mask of EVENTS_RXSTARTED field.
	TWIM_EVENTS_RXSTARTED_EVENTS_RXSTARTED_Msk = 0x1
	// Bit EVENTS_RXSTARTED.
	TWIM_EVENTS_RXSTARTED_EVENTS_RXSTARTED = 0x1
	// Event not generated
	TWIM_EVENTS_RXSTARTED_EVENTS_RXSTARTED_NotGenerated = 0x0
	// Event generated
	TWIM_EVENTS_RXSTARTED_EVENTS_RXSTARTED_Generated = 0x1

	// EVENTS_TXSTARTED: Transmit sequence started
	// Position of EVENTS_TXSTARTED field.
	TWIM_EVENTS_TXSTARTED_EVENTS_TXSTARTED_Pos = 0x0
	// Bit mask of EVENTS_TXSTARTED field.
	TWIM_EVENTS_TXSTARTED_EVENTS_TXSTARTED_Msk = 0x1
	// Bit EVENTS_TXSTARTED.
	TWIM_EVENTS_TXSTARTED_EVENTS_TXSTARTED = 0x1
	// Event not generated
	TWIM_EVENTS_TXSTARTED_EVENTS_TXSTARTED_NotGenerated = 0x0
	// Event generated
	TWIM_EVENTS_TXSTARTED_EVENTS_TXSTARTED_Generated = 0x1

	// EVENTS_LASTRX: Byte boundary, starting to receive the last byte
	// Position of EVENTS_LASTRX field.
	TWIM_EVENTS_LASTRX_EVENTS_LASTRX_Pos = 0x0
	// Bit mask of EVENTS_LASTRX field.
	TWIM_EVENTS_LASTRX_EVENTS_LASTRX_Msk = 0x1
	// Bit EVENTS_LASTRX.
	TWIM_EVENTS_LASTRX_EVENTS_LASTRX = 0x1
	// Event not generated
	TWIM_EVENTS_LASTRX_EVENTS_LASTRX_NotGenerated = 0x0
	// Event generated
	TWIM_EVENTS_LASTRX_EVENTS_LASTRX_Generated = 0x1

	// EVENTS_LASTTX: Byte boundary, starting to transmit the last byte
	// Position of EVENTS_LASTTX field.
	TWIM_EVENTS_LASTTX_EVENTS_LASTTX_Pos = 0x0
	// Bit mask of EVENTS_LASTTX field.
	TWIM_EVENTS_LASTTX_EVENTS_LASTTX_Msk = 0x1
	// Bit EVENTS_LASTTX.
	TWIM_EVENTS_LASTTX_EVENTS_LASTTX = 0x1
	// Event not generated
	TWIM_EVENTS_LASTTX_EVENTS_LASTTX_NotGenerated = 0x0
	// Event generated
	TWIM_EVENTS_LASTTX_EVENTS_LASTTX_Generated = 0x1

	// PUBLISH_STOPPED: Publish configuration for event STOPPED
	// Position of CHIDX field.
	TWIM_PUBLISH_STOPPED_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	TWIM_PUBLISH_STOPPED_CHIDX_Msk = 0xff
	// Position of EN field.
	TWIM_PUBLISH_STOPPED_EN_Pos = 0x1f
	// Bit mask of EN field.
	TWIM_PUBLISH_STOPPED_EN_Msk = 0x80000000
	// Bit EN.
	TWIM_PUBLISH_STOPPED_EN = 0x80000000
	// Disable publishing
	TWIM_PUBLISH_STOPPED_EN_Disabled = 0x0
	// Enable publishing
	TWIM_PUBLISH_STOPPED_EN_Enabled = 0x1

	// PUBLISH_ERROR: Publish configuration for event ERROR
	// Position of CHIDX field.
	TWIM_PUBLISH_ERROR_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	TWIM_PUBLISH_ERROR_CHIDX_Msk = 0xff
	// Position of EN field.
	TWIM_PUBLISH_ERROR_EN_Pos = 0x1f
	// Bit mask of EN field.
	TWIM_PUBLISH_ERROR_EN_Msk = 0x80000000
	// Bit EN.
	TWIM_PUBLISH_ERROR_EN = 0x80000000
	// Disable publishing
	TWIM_PUBLISH_ERROR_EN_Disabled = 0x0
	// Enable publishing
	TWIM_PUBLISH_ERROR_EN_Enabled = 0x1

	// PUBLISH_SUSPENDED: Publish configuration for event SUSPENDED
	// Position of CHIDX field.
	TWIM_PUBLISH_SUSPENDED_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	TWIM_PUBLISH_SUSPENDED_CHIDX_Msk = 0xff
	// Position of EN field.
	TWIM_PUBLISH_SUSPENDED_EN_Pos = 0x1f
	// Bit mask of EN field.
	TWIM_PUBLISH_SUSPENDED_EN_Msk = 0x80000000
	// Bit EN.
	TWIM_PUBLISH_SUSPENDED_EN = 0x80000000
	// Disable publishing
	TWIM_PUBLISH_SUSPENDED_EN_Disabled = 0x0
	// Enable publishing
	TWIM_PUBLISH_SUSPENDED_EN_Enabled = 0x1

	// PUBLISH_RXSTARTED: Publish configuration for event RXSTARTED
	// Position of CHIDX field.
	TWIM_PUBLISH_RXSTARTED_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	TWIM_PUBLISH_RXSTARTED_CHIDX_Msk = 0xff
	// Position of EN field.
	TWIM_PUBLISH_RXSTARTED_EN_Pos = 0x1f
	// Bit mask of EN field.
	TWIM_PUBLISH_RXSTARTED_EN_Msk = 0x80000000
	// Bit EN.
	TWIM_PUBLISH_RXSTARTED_EN = 0x80000000
	// Disable publishing
	TWIM_PUBLISH_RXSTARTED_EN_Disabled = 0x0
	// Enable publishing
	TWIM_PUBLISH_RXSTARTED_EN_Enabled = 0x1

	// PUBLISH_TXSTARTED: Publish configuration for event TXSTARTED
	// Position of CHIDX field.
	TWIM_PUBLISH_TXSTARTED_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	TWIM_PUBLISH_TXSTARTED_CHIDX_Msk = 0xff
	// Position of EN field.
	TWIM_PUBLISH_TXSTARTED_EN_Pos = 0x1f
	// Bit mask of EN field.
	TWIM_PUBLISH_TXSTARTED_EN_Msk = 0x80000000
	// Bit EN.
	TWIM_PUBLISH_TXSTARTED_EN = 0x80000000
	// Disable publishing
	TWIM_PUBLISH_TXSTARTED_EN_Disabled = 0x0
	// Enable publishing
	TWIM_PUBLISH_TXSTARTED_EN_Enabled = 0x1

	// PUBLISH_LASTRX: Publish configuration for event LASTRX
	// Position of CHIDX field.
	TWIM_PUBLISH_LASTRX_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	TWIM_PUBLISH_LASTRX_CHIDX_Msk = 0xff
	// Position of EN field.
	TWIM_PUBLISH_LASTRX_EN_Pos = 0x1f
	// Bit mask of EN field.
	TWIM_PUBLISH_LASTRX_EN_Msk = 0x80000000
	// Bit EN.
	TWIM_PUBLISH_LASTRX_EN = 0x80000000
	// Disable publishing
	TWIM_PUBLISH_LASTRX_EN_Disabled = 0x0
	// Enable publishing
	TWIM_PUBLISH_LASTRX_EN_Enabled = 0x1

	// PUBLISH_LASTTX: Publish configuration for event LASTTX
	// Position of CHIDX field.
	TWIM_PUBLISH_LASTTX_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	TWIM_PUBLISH_LASTTX_CHIDX_Msk = 0xff
	// Position of EN field.
	TWIM_PUBLISH_LASTTX_EN_Pos = 0x1f
	// Bit mask of EN field.
	TWIM_PUBLISH_LASTTX_EN_Msk = 0x80000000
	// Bit EN.
	TWIM_PUBLISH_LASTTX_EN = 0x80000000
	// Disable publishing
	TWIM_PUBLISH_LASTTX_EN_Disabled = 0x0
	// Enable publishing
	TWIM_PUBLISH_LASTTX_EN_Enabled = 0x1

	// SHORTS: Shortcuts between local events and tasks
	// Position of LASTTX_STARTRX field.
	TWIM_SHORTS_LASTTX_STARTRX_Pos = 0x7
	// Bit mask of LASTTX_STARTRX field.
	TWIM_SHORTS_LASTTX_STARTRX_Msk = 0x80
	// Bit LASTTX_STARTRX.
	TWIM_SHORTS_LASTTX_STARTRX = 0x80
	// Disable shortcut
	TWIM_SHORTS_LASTTX_STARTRX_Disabled = 0x0
	// Enable shortcut
	TWIM_SHORTS_LASTTX_STARTRX_Enabled = 0x1
	// Position of LASTTX_SUSPEND field.
	TWIM_SHORTS_LASTTX_SUSPEND_Pos = 0x8
	// Bit mask of LASTTX_SUSPEND field.
	TWIM_SHORTS_LASTTX_SUSPEND_Msk = 0x100
	// Bit LASTTX_SUSPEND.
	TWIM_SHORTS_LASTTX_SUSPEND = 0x100
	// Disable shortcut
	TWIM_SHORTS_LASTTX_SUSPEND_Disabled = 0x0
	// Enable shortcut
	TWIM_SHORTS_LASTTX_SUSPEND_Enabled = 0x1
	// Position of LASTTX_STOP field.
	TWIM_SHORTS_LASTTX_STOP_Pos = 0x9
	// Bit mask of LASTTX_STOP field.
	TWIM_SHORTS_LASTTX_STOP_Msk = 0x200
	// Bit LASTTX_STOP.
	TWIM_SHORTS_LASTTX_STOP = 0x200
	// Disable shortcut
	TWIM_SHORTS_LASTTX_STOP_Disabled = 0x0
	// Enable shortcut
	TWIM_SHORTS_LASTTX_STOP_Enabled = 0x1
	// Position of LASTRX_STARTTX field.
	TWIM_SHORTS_LASTRX_STARTTX_Pos = 0xa
	// Bit mask of LASTRX_STARTTX field.
	TWIM_SHORTS_LASTRX_STARTTX_Msk = 0x400
	// Bit LASTRX_STARTTX.
	TWIM_SHORTS_LASTRX_STARTTX = 0x400
	// Disable shortcut
	TWIM_SHORTS_LASTRX_STARTTX_Disabled = 0x0
	// Enable shortcut
	TWIM_SHORTS_LASTRX_STARTTX_Enabled = 0x1
	// Position of LASTRX_SUSPEND field.
	TWIM_SHORTS_LASTRX_SUSPEND_Pos = 0xb
	// Bit mask of LASTRX_SUSPEND field.
	TWIM_SHORTS_LASTRX_SUSPEND_Msk = 0x800
	// Bit LASTRX_SUSPEND.
	TWIM_SHORTS_LASTRX_SUSPEND = 0x800
	// Disable shortcut
	TWIM_SHORTS_LASTRX_SUSPEND_Disabled = 0x0
	// Enable shortcut
	TWIM_SHORTS_LASTRX_SUSPEND_Enabled = 0x1
	// Position of LASTRX_STOP field.
	TWIM_SHORTS_LASTRX_STOP_Pos = 0xc
	// Bit mask of LASTRX_STOP field.
	TWIM_SHORTS_LASTRX_STOP_Msk = 0x1000
	// Bit LASTRX_STOP.
	TWIM_SHORTS_LASTRX_STOP = 0x1000
	// Disable shortcut
	TWIM_SHORTS_LASTRX_STOP_Disabled = 0x0
	// Enable shortcut
	TWIM_SHORTS_LASTRX_STOP_Enabled = 0x1

	// INTEN: Enable or disable interrupt
	// Position of STOPPED field.
	TWIM_INTEN_STOPPED_Pos = 0x1
	// Bit mask of STOPPED field.
	TWIM_INTEN_STOPPED_Msk = 0x2
	// Bit STOPPED.
	TWIM_INTEN_STOPPED = 0x2
	// Disable
	TWIM_INTEN_STOPPED_Disabled = 0x0
	// Enable
	TWIM_INTEN_STOPPED_Enabled = 0x1
	// Position of ERROR field.
	TWIM_INTEN_ERROR_Pos = 0x9
	// Bit mask of ERROR field.
	TWIM_INTEN_ERROR_Msk = 0x200
	// Bit ERROR.
	TWIM_INTEN_ERROR = 0x200
	// Disable
	TWIM_INTEN_ERROR_Disabled = 0x0
	// Enable
	TWIM_INTEN_ERROR_Enabled = 0x1
	// Position of SUSPENDED field.
	TWIM_INTEN_SUSPENDED_Pos = 0x12
	// Bit mask of SUSPENDED field.
	TWIM_INTEN_SUSPENDED_Msk = 0x40000
	// Bit SUSPENDED.
	TWIM_INTEN_SUSPENDED = 0x40000
	// Disable
	TWIM_INTEN_SUSPENDED_Disabled = 0x0
	// Enable
	TWIM_INTEN_SUSPENDED_Enabled = 0x1
	// Position of RXSTARTED field.
	TWIM_INTEN_RXSTARTED_Pos = 0x13
	// Bit mask of RXSTARTED field.
	TWIM_INTEN_RXSTARTED_Msk = 0x80000
	// Bit RXSTARTED.
	TWIM_INTEN_RXSTARTED = 0x80000
	// Disable
	TWIM_INTEN_RXSTARTED_Disabled = 0x0
	// Enable
	TWIM_INTEN_RXSTARTED_Enabled = 0x1
	// Position of TXSTARTED field.
	TWIM_INTEN_TXSTARTED_Pos = 0x14
	// Bit mask of TXSTARTED field.
	TWIM_INTEN_TXSTARTED_Msk = 0x100000
	// Bit TXSTARTED.
	TWIM_INTEN_TXSTARTED = 0x100000
	// Disable
	TWIM_INTEN_TXSTARTED_Disabled = 0x0
	// Enable
	TWIM_INTEN_TXSTARTED_Enabled = 0x1
	// Position of LASTRX field.
	TWIM_INTEN_LASTRX_Pos = 0x17
	// Bit mask of LASTRX field.
	TWIM_INTEN_LASTRX_Msk = 0x800000
	// Bit LASTRX.
	TWIM_INTEN_LASTRX = 0x800000
	// Disable
	TWIM_INTEN_LASTRX_Disabled = 0x0
	// Enable
	TWIM_INTEN_LASTRX_Enabled = 0x1
	// Position of LASTTX field.
	TWIM_INTEN_LASTTX_Pos = 0x18
	// Bit mask of LASTTX field.
	TWIM_INTEN_LASTTX_Msk = 0x1000000
	// Bit LASTTX.
	TWIM_INTEN_LASTTX = 0x1000000
	// Disable
	TWIM_INTEN_LASTTX_Disabled = 0x0
	// Enable
	TWIM_INTEN_LASTTX_Enabled = 0x1

	// INTENSET: Enable interrupt
	// Position of STOPPED field.
	TWIM_INTENSET_STOPPED_Pos = 0x1
	// Bit mask of STOPPED field.
	TWIM_INTENSET_STOPPED_Msk = 0x2
	// Bit STOPPED.
	TWIM_INTENSET_STOPPED = 0x2
	// Read: Disabled
	TWIM_INTENSET_STOPPED_Disabled = 0x0
	// Read: Enabled
	TWIM_INTENSET_STOPPED_Enabled = 0x1
	// Enable
	TWIM_INTENSET_STOPPED_Set = 0x1
	// Position of ERROR field.
	TWIM_INTENSET_ERROR_Pos = 0x9
	// Bit mask of ERROR field.
	TWIM_INTENSET_ERROR_Msk = 0x200
	// Bit ERROR.
	TWIM_INTENSET_ERROR = 0x200
	// Read: Disabled
	TWIM_INTENSET_ERROR_Disabled = 0x0
	// Read: Enabled
	TWIM_INTENSET_ERROR_Enabled = 0x1
	// Enable
	TWIM_INTENSET_ERROR_Set = 0x1
	// Position of SUSPENDED field.
	TWIM_INTENSET_SUSPENDED_Pos = 0x12
	// Bit mask of SUSPENDED field.
	TWIM_INTENSET_SUSPENDED_Msk = 0x40000
	// Bit SUSPENDED.
	TWIM_INTENSET_SUSPENDED = 0x40000
	// Read: Disabled
	TWIM_INTENSET_SUSPENDED_Disabled = 0x0
	// Read: Enabled
	TWIM_INTENSET_SUSPENDED_Enabled = 0x1
	// Enable
	TWIM_INTENSET_SUSPENDED_Set = 0x1
	// Position of RXSTARTED field.
	TWIM_INTENSET_RXSTARTED_Pos = 0x13
	// Bit mask of RXSTARTED field.
	TWIM_INTENSET_RXSTARTED_Msk = 0x80000
	// Bit RXSTARTED.
	TWIM_INTENSET_RXSTARTED = 0x80000
	// Read: Disabled
	TWIM_INTENSET_RXSTARTED_Disabled = 0x0
	// Read: Enabled
	TWIM_INTENSET_RXSTARTED_Enabled = 0x1
	// Enable
	TWIM_INTENSET_RXSTARTED_Set = 0x1
	// Position of TXSTARTED field.
	TWIM_INTENSET_TXSTARTED_Pos = 0x14
	// Bit mask of TXSTARTED field.
	TWIM_INTENSET_TXSTARTED_Msk = 0x100000
	// Bit TXSTARTED.
	TWIM_INTENSET_TXSTARTED = 0x100000
	// Read: Disabled
	TWIM_INTENSET_TXSTARTED_Disabled = 0x0
	// Read: Enabled
	TWIM_INTENSET_TXSTARTED_Enabled = 0x1
	// Enable
	TWIM_INTENSET_TXSTARTED_Set = 0x1
	// Position of LASTRX field.
	TWIM_INTENSET_LASTRX_Pos = 0x17
	// Bit mask of LASTRX field.
	TWIM_INTENSET_LASTRX_Msk = 0x800000
	// Bit LASTRX.
	TWIM_INTENSET_LASTRX = 0x800000
	// Read: Disabled
	TWIM_INTENSET_LASTRX_Disabled = 0x0
	// Read: Enabled
	TWIM_INTENSET_LASTRX_Enabled = 0x1
	// Enable
	TWIM_INTENSET_LASTRX_Set = 0x1
	// Position of LASTTX field.
	TWIM_INTENSET_LASTTX_Pos = 0x18
	// Bit mask of LASTTX field.
	TWIM_INTENSET_LASTTX_Msk = 0x1000000
	// Bit LASTTX.
	TWIM_INTENSET_LASTTX = 0x1000000
	// Read: Disabled
	TWIM_INTENSET_LASTTX_Disabled = 0x0
	// Read: Enabled
	TWIM_INTENSET_LASTTX_Enabled = 0x1
	// Enable
	TWIM_INTENSET_LASTTX_Set = 0x1

	// INTENCLR: Disable interrupt
	// Position of STOPPED field.
	TWIM_INTENCLR_STOPPED_Pos = 0x1
	// Bit mask of STOPPED field.
	TWIM_INTENCLR_STOPPED_Msk = 0x2
	// Bit STOPPED.
	TWIM_INTENCLR_STOPPED = 0x2
	// Read: Disabled
	TWIM_INTENCLR_STOPPED_Disabled = 0x0
	// Read: Enabled
	TWIM_INTENCLR_STOPPED_Enabled = 0x1
	// Disable
	TWIM_INTENCLR_STOPPED_Clear = 0x1
	// Position of ERROR field.
	TWIM_INTENCLR_ERROR_Pos = 0x9
	// Bit mask of ERROR field.
	TWIM_INTENCLR_ERROR_Msk = 0x200
	// Bit ERROR.
	TWIM_INTENCLR_ERROR = 0x200
	// Read: Disabled
	TWIM_INTENCLR_ERROR_Disabled = 0x0
	// Read: Enabled
	TWIM_INTENCLR_ERROR_Enabled = 0x1
	// Disable
	TWIM_INTENCLR_ERROR_Clear = 0x1
	// Position of SUSPENDED field.
	TWIM_INTENCLR_SUSPENDED_Pos = 0x12
	// Bit mask of SUSPENDED field.
	TWIM_INTENCLR_SUSPENDED_Msk = 0x40000
	// Bit SUSPENDED.
	TWIM_INTENCLR_SUSPENDED = 0x40000
	// Read: Disabled
	TWIM_INTENCLR_SUSPENDED_Disabled = 0x0
	// Read: Enabled
	TWIM_INTENCLR_SUSPENDED_Enabled = 0x1
	// Disable
	TWIM_INTENCLR_SUSPENDED_Clear = 0x1
	// Position of RXSTARTED field.
	TWIM_INTENCLR_RXSTARTED_Pos = 0x13
	// Bit mask of RXSTARTED field.
	TWIM_INTENCLR_RXSTARTED_Msk = 0x80000
	// Bit RXSTARTED.
	TWIM_INTENCLR_RXSTARTED = 0x80000
	// Read: Disabled
	TWIM_INTENCLR_RXSTARTED_Disabled = 0x0
	// Read: Enabled
	TWIM_INTENCLR_RXSTARTED_Enabled = 0x1
	// Disable
	TWIM_INTENCLR_RXSTARTED_Clear = 0x1
	// Position of TXSTARTED field.
	TWIM_INTENCLR_TXSTARTED_Pos = 0x14
	// Bit mask of TXSTARTED field.
	TWIM_INTENCLR_TXSTARTED_Msk = 0x100000
	// Bit TXSTARTED.
	TWIM_INTENCLR_TXSTARTED = 0x100000
	// Read: Disabled
	TWIM_INTENCLR_TXSTARTED_Disabled = 0x0
	// Read: Enabled
	TWIM_INTENCLR_TXSTARTED_Enabled = 0x1
	// Disable
	TWIM_INTENCLR_TXSTARTED_Clear = 0x1
	// Position of LASTRX field.
	TWIM_INTENCLR_LASTRX_Pos = 0x17
	// Bit mask of LASTRX field.
	TWIM_INTENCLR_LASTRX_Msk = 0x800000
	// Bit LASTRX.
	TWIM_INTENCLR_LASTRX = 0x800000
	// Read: Disabled
	TWIM_INTENCLR_LASTRX_Disabled = 0x0
	// Read: Enabled
	TWIM_INTENCLR_LASTRX_Enabled = 0x1
	// Disable
	TWIM_INTENCLR_LASTRX_Clear = 0x1
	// Position of LASTTX field.
	TWIM_INTENCLR_LASTTX_Pos = 0x18
	// Bit mask of LASTTX field.
	TWIM_INTENCLR_LASTTX_Msk = 0x1000000
	// Bit LASTTX.
	TWIM_INTENCLR_LASTTX = 0x1000000
	// Read: Disabled
	TWIM_INTENCLR_LASTTX_Disabled = 0x0
	// Read: Enabled
	TWIM_INTENCLR_LASTTX_Enabled = 0x1
	// Disable
	TWIM_INTENCLR_LASTTX_Clear = 0x1

	// ERRORSRC: Error source
	// Position of OVERRUN field.
	TWIM_ERRORSRC_OVERRUN_Pos = 0x0
	// Bit mask of OVERRUN field.
	TWIM_ERRORSRC_OVERRUN_Msk = 0x1
	// Bit OVERRUN.
	TWIM_ERRORSRC_OVERRUN = 0x1
	// Error did not occur
	TWIM_ERRORSRC_OVERRUN_NotReceived = 0x0
	// Error occurred
	TWIM_ERRORSRC_OVERRUN_Received = 0x1
	// Position of ANACK field.
	TWIM_ERRORSRC_ANACK_Pos = 0x1
	// Bit mask of ANACK field.
	TWIM_ERRORSRC_ANACK_Msk = 0x2
	// Bit ANACK.
	TWIM_ERRORSRC_ANACK = 0x2
	// Error did not occur
	TWIM_ERRORSRC_ANACK_NotReceived = 0x0
	// Error occurred
	TWIM_ERRORSRC_ANACK_Received = 0x1
	// Position of DNACK field.
	TWIM_ERRORSRC_DNACK_Pos = 0x2
	// Bit mask of DNACK field.
	TWIM_ERRORSRC_DNACK_Msk = 0x4
	// Bit DNACK.
	TWIM_ERRORSRC_DNACK = 0x4
	// Error did not occur
	TWIM_ERRORSRC_DNACK_NotReceived = 0x0
	// Error occurred
	TWIM_ERRORSRC_DNACK_Received = 0x1

	// ENABLE: Enable TWIM
	// Position of ENABLE field.
	TWIM_ENABLE_ENABLE_Pos = 0x0
	// Bit mask of ENABLE field.
	TWIM_ENABLE_ENABLE_Msk = 0xf
	// Disable TWIM
	TWIM_ENABLE_ENABLE_Disabled = 0x0
	// Enable TWIM
	TWIM_ENABLE_ENABLE_Enabled = 0x6

	// PSEL.SCL: Pin select for SCL signal
	// Position of PIN field.
	TWIM_PSEL_SCL_PIN_Pos = 0x0
	// Bit mask of PIN field.
	TWIM_PSEL_SCL_PIN_Msk = 0x1f
	// Position of PORT field.
	TWIM_PSEL_SCL_PORT_Pos = 0x5
	// Bit mask of PORT field.
	TWIM_PSEL_SCL_PORT_Msk = 0x20
	// Bit PORT.
	TWIM_PSEL_SCL_PORT = 0x20
	// Position of CONNECT field.
	TWIM_PSEL_SCL_CONNECT_Pos = 0x1f
	// Bit mask of CONNECT field.
	TWIM_PSEL_SCL_CONNECT_Msk = 0x80000000
	// Bit CONNECT.
	TWIM_PSEL_SCL_CONNECT = 0x80000000
	// Disconnect
	TWIM_PSEL_SCL_CONNECT_Disconnected = 0x1
	// Connect
	TWIM_PSEL_SCL_CONNECT_Connected = 0x0

	// PSEL.SDA: Pin select for SDA signal
	// Position of PIN field.
	TWIM_PSEL_SDA_PIN_Pos = 0x0
	// Bit mask of PIN field.
	TWIM_PSEL_SDA_PIN_Msk = 0x1f
	// Position of PORT field.
	TWIM_PSEL_SDA_PORT_Pos = 0x5
	// Bit mask of PORT field.
	TWIM_PSEL_SDA_PORT_Msk = 0x20
	// Bit PORT.
	TWIM_PSEL_SDA_PORT = 0x20
	// Position of CONNECT field.
	TWIM_PSEL_SDA_CONNECT_Pos = 0x1f
	// Bit mask of CONNECT field.
	TWIM_PSEL_SDA_CONNECT_Msk = 0x80000000
	// Bit CONNECT.
	TWIM_PSEL_SDA_CONNECT = 0x80000000
	// Disconnect
	TWIM_PSEL_SDA_CONNECT_Disconnected = 0x1
	// Connect
	TWIM_PSEL_SDA_CONNECT_Connected = 0x0

	// FREQUENCY: TWI frequency. Accuracy depends on the HFCLK source selected.
	// Position of FREQUENCY field.
	TWIM_FREQUENCY_FREQUENCY_Pos = 0x0
	// Bit mask of FREQUENCY field.
	TWIM_FREQUENCY_FREQUENCY_Msk = 0xffffffff
	// 100 kbps
	TWIM_FREQUENCY_FREQUENCY_K100 = 0x1980000
	// 250 kbps
	TWIM_FREQUENCY_FREQUENCY_K250 = 0x4000000
	// 400 kbps
	TWIM_FREQUENCY_FREQUENCY_K400 = 0x6400000
	// 1000 kbps
	TWIM_FREQUENCY_FREQUENCY_K1000 = 0xff00000

	// RXD.PTR: Data pointer
	// Position of PTR field.
	TWIM_RXD_PTR_PTR_Pos = 0x0
	// Bit mask of PTR field.
	TWIM_RXD_PTR_PTR_Msk = 0xffffffff

	// RXD.MAXCNT: Maximum number of bytes in receive buffer
	// Position of MAXCNT field.
	TWIM_RXD_MAXCNT_MAXCNT_Pos = 0x0
	// Bit mask of MAXCNT field.
	TWIM_RXD_MAXCNT_MAXCNT_Msk = 0xffff

	// RXD.AMOUNT: Number of bytes transferred in the last transaction
	// Position of AMOUNT field.
	TWIM_RXD_AMOUNT_AMOUNT_Pos = 0x0
	// Bit mask of AMOUNT field.
	TWIM_RXD_AMOUNT_AMOUNT_Msk = 0xffff

	// RXD.LIST: EasyDMA list type
	// Position of LIST field.
	TWIM_RXD_LIST_LIST_Pos = 0x0
	// Bit mask of LIST field.
	TWIM_RXD_LIST_LIST_Msk = 0x7
	// Disable EasyDMA list
	TWIM_RXD_LIST_LIST_Disabled = 0x0
	// Use array list
	TWIM_RXD_LIST_LIST_ArrayList = 0x1

	// TXD.PTR: Data pointer
	// Position of PTR field.
	TWIM_TXD_PTR_PTR_Pos = 0x0
	// Bit mask of PTR field.
	TWIM_TXD_PTR_PTR_Msk = 0xffffffff

	// TXD.MAXCNT: Maximum number of bytes in transmit buffer
	// Position of MAXCNT field.
	TWIM_TXD_MAXCNT_MAXCNT_Pos = 0x0
	// Bit mask of MAXCNT field.
	TWIM_TXD_MAXCNT_MAXCNT_Msk = 0xffff

	// TXD.AMOUNT: Number of bytes transferred in the last transaction
	// Position of AMOUNT field.
	TWIM_TXD_AMOUNT_AMOUNT_Pos = 0x0
	// Bit mask of AMOUNT field.
	TWIM_TXD_AMOUNT_AMOUNT_Msk = 0xffff

	// TXD.LIST: EasyDMA list type
	// Position of LIST field.
	TWIM_TXD_LIST_LIST_Pos = 0x0
	// Bit mask of LIST field.
	TWIM_TXD_LIST_LIST_Msk = 0x7
	// Disable EasyDMA list
	TWIM_TXD_LIST_LIST_Disabled = 0x0
	// Use array list
	TWIM_TXD_LIST_LIST_ArrayList = 0x1

	// ADDRESS: Address used in the TWI transfer
	// Position of ADDRESS field.
	TWIM_ADDRESS_ADDRESS_Pos = 0x0
	// Bit mask of ADDRESS field.
	TWIM_ADDRESS_ADDRESS_Msk = 0x7f
)

// Constants for TWIS0_NS: I2C compatible Two-Wire Slave Interface with EasyDMA
const (
	// TASKS_STOP: Stop TWI transaction
	// Position of TASKS_STOP field.
	TWIS_TASKS_STOP_TASKS_STOP_Pos = 0x0
	// Bit mask of TASKS_STOP field.
	TWIS_TASKS_STOP_TASKS_STOP_Msk = 0x1
	// Bit TASKS_STOP.
	TWIS_TASKS_STOP_TASKS_STOP = 0x1
	// Trigger task
	TWIS_TASKS_STOP_TASKS_STOP_Trigger = 0x1

	// TASKS_SUSPEND: Suspend TWI transaction
	// Position of TASKS_SUSPEND field.
	TWIS_TASKS_SUSPEND_TASKS_SUSPEND_Pos = 0x0
	// Bit mask of TASKS_SUSPEND field.
	TWIS_TASKS_SUSPEND_TASKS_SUSPEND_Msk = 0x1
	// Bit TASKS_SUSPEND.
	TWIS_TASKS_SUSPEND_TASKS_SUSPEND = 0x1
	// Trigger task
	TWIS_TASKS_SUSPEND_TASKS_SUSPEND_Trigger = 0x1

	// TASKS_RESUME: Resume TWI transaction
	// Position of TASKS_RESUME field.
	TWIS_TASKS_RESUME_TASKS_RESUME_Pos = 0x0
	// Bit mask of TASKS_RESUME field.
	TWIS_TASKS_RESUME_TASKS_RESUME_Msk = 0x1
	// Bit TASKS_RESUME.
	TWIS_TASKS_RESUME_TASKS_RESUME = 0x1
	// Trigger task
	TWIS_TASKS_RESUME_TASKS_RESUME_Trigger = 0x1

	// TASKS_PREPARERX: Prepare the TWI slave to respond to a write command
	// Position of TASKS_PREPARERX field.
	TWIS_TASKS_PREPARERX_TASKS_PREPARERX_Pos = 0x0
	// Bit mask of TASKS_PREPARERX field.
	TWIS_TASKS_PREPARERX_TASKS_PREPARERX_Msk = 0x1
	// Bit TASKS_PREPARERX.
	TWIS_TASKS_PREPARERX_TASKS_PREPARERX = 0x1
	// Trigger task
	TWIS_TASKS_PREPARERX_TASKS_PREPARERX_Trigger = 0x1

	// TASKS_PREPARETX: Prepare the TWI slave to respond to a read command
	// Position of TASKS_PREPARETX field.
	TWIS_TASKS_PREPARETX_TASKS_PREPARETX_Pos = 0x0
	// Bit mask of TASKS_PREPARETX field.
	TWIS_TASKS_PREPARETX_TASKS_PREPARETX_Msk = 0x1
	// Bit TASKS_PREPARETX.
	TWIS_TASKS_PREPARETX_TASKS_PREPARETX = 0x1
	// Trigger task
	TWIS_TASKS_PREPARETX_TASKS_PREPARETX_Trigger = 0x1

	// SUBSCRIBE_STOP: Subscribe configuration for task STOP
	// Position of CHIDX field.
	TWIS_SUBSCRIBE_STOP_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	TWIS_SUBSCRIBE_STOP_CHIDX_Msk = 0xff
	// Position of EN field.
	TWIS_SUBSCRIBE_STOP_EN_Pos = 0x1f
	// Bit mask of EN field.
	TWIS_SUBSCRIBE_STOP_EN_Msk = 0x80000000
	// Bit EN.
	TWIS_SUBSCRIBE_STOP_EN = 0x80000000
	// Disable subscription
	TWIS_SUBSCRIBE_STOP_EN_Disabled = 0x0
	// Enable subscription
	TWIS_SUBSCRIBE_STOP_EN_Enabled = 0x1

	// SUBSCRIBE_SUSPEND: Subscribe configuration for task SUSPEND
	// Position of CHIDX field.
	TWIS_SUBSCRIBE_SUSPEND_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	TWIS_SUBSCRIBE_SUSPEND_CHIDX_Msk = 0xff
	// Position of EN field.
	TWIS_SUBSCRIBE_SUSPEND_EN_Pos = 0x1f
	// Bit mask of EN field.
	TWIS_SUBSCRIBE_SUSPEND_EN_Msk = 0x80000000
	// Bit EN.
	TWIS_SUBSCRIBE_SUSPEND_EN = 0x80000000
	// Disable subscription
	TWIS_SUBSCRIBE_SUSPEND_EN_Disabled = 0x0
	// Enable subscription
	TWIS_SUBSCRIBE_SUSPEND_EN_Enabled = 0x1

	// SUBSCRIBE_RESUME: Subscribe configuration for task RESUME
	// Position of CHIDX field.
	TWIS_SUBSCRIBE_RESUME_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	TWIS_SUBSCRIBE_RESUME_CHIDX_Msk = 0xff
	// Position of EN field.
	TWIS_SUBSCRIBE_RESUME_EN_Pos = 0x1f
	// Bit mask of EN field.
	TWIS_SUBSCRIBE_RESUME_EN_Msk = 0x80000000
	// Bit EN.
	TWIS_SUBSCRIBE_RESUME_EN = 0x80000000
	// Disable subscription
	TWIS_SUBSCRIBE_RESUME_EN_Disabled = 0x0
	// Enable subscription
	TWIS_SUBSCRIBE_RESUME_EN_Enabled = 0x1

	// SUBSCRIBE_PREPARERX: Subscribe configuration for task PREPARERX
	// Position of CHIDX field.
	TWIS_SUBSCRIBE_PREPARERX_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	TWIS_SUBSCRIBE_PREPARERX_CHIDX_Msk = 0xff
	// Position of EN field.
	TWIS_SUBSCRIBE_PREPARERX_EN_Pos = 0x1f
	// Bit mask of EN field.
	TWIS_SUBSCRIBE_PREPARERX_EN_Msk = 0x80000000
	// Bit EN.
	TWIS_SUBSCRIBE_PREPARERX_EN = 0x80000000
	// Disable subscription
	TWIS_SUBSCRIBE_PREPARERX_EN_Disabled = 0x0
	// Enable subscription
	TWIS_SUBSCRIBE_PREPARERX_EN_Enabled = 0x1

	// SUBSCRIBE_PREPARETX: Subscribe configuration for task PREPARETX
	// Position of CHIDX field.
	TWIS_SUBSCRIBE_PREPARETX_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	TWIS_SUBSCRIBE_PREPARETX_CHIDX_Msk = 0xff
	// Position of EN field.
	TWIS_SUBSCRIBE_PREPARETX_EN_Pos = 0x1f
	// Bit mask of EN field.
	TWIS_SUBSCRIBE_PREPARETX_EN_Msk = 0x80000000
	// Bit EN.
	TWIS_SUBSCRIBE_PREPARETX_EN = 0x80000000
	// Disable subscription
	TWIS_SUBSCRIBE_PREPARETX_EN_Disabled = 0x0
	// Enable subscription
	TWIS_SUBSCRIBE_PREPARETX_EN_Enabled = 0x1

	// EVENTS_STOPPED: TWI stopped
	// Position of EVENTS_STOPPED field.
	TWIS_EVENTS_STOPPED_EVENTS_STOPPED_Pos = 0x0
	// Bit mask of EVENTS_STOPPED field.
	TWIS_EVENTS_STOPPED_EVENTS_STOPPED_Msk = 0x1
	// Bit EVENTS_STOPPED.
	TWIS_EVENTS_STOPPED_EVENTS_STOPPED = 0x1
	// Event not generated
	TWIS_EVENTS_STOPPED_EVENTS_STOPPED_NotGenerated = 0x0
	// Event generated
	TWIS_EVENTS_STOPPED_EVENTS_STOPPED_Generated = 0x1

	// EVENTS_ERROR: TWI error
	// Position of EVENTS_ERROR field.
	TWIS_EVENTS_ERROR_EVENTS_ERROR_Pos = 0x0
	// Bit mask of EVENTS_ERROR field.
	TWIS_EVENTS_ERROR_EVENTS_ERROR_Msk = 0x1
	// Bit EVENTS_ERROR.
	TWIS_EVENTS_ERROR_EVENTS_ERROR = 0x1
	// Event not generated
	TWIS_EVENTS_ERROR_EVENTS_ERROR_NotGenerated = 0x0
	// Event generated
	TWIS_EVENTS_ERROR_EVENTS_ERROR_Generated = 0x1

	// EVENTS_RXSTARTED: Receive sequence started
	// Position of EVENTS_RXSTARTED field.
	TWIS_EVENTS_RXSTARTED_EVENTS_RXSTARTED_Pos = 0x0
	// Bit mask of EVENTS_RXSTARTED field.
	TWIS_EVENTS_RXSTARTED_EVENTS_RXSTARTED_Msk = 0x1
	// Bit EVENTS_RXSTARTED.
	TWIS_EVENTS_RXSTARTED_EVENTS_RXSTARTED = 0x1
	// Event not generated
	TWIS_EVENTS_RXSTARTED_EVENTS_RXSTARTED_NotGenerated = 0x0
	// Event generated
	TWIS_EVENTS_RXSTARTED_EVENTS_RXSTARTED_Generated = 0x1

	// EVENTS_TXSTARTED: Transmit sequence started
	// Position of EVENTS_TXSTARTED field.
	TWIS_EVENTS_TXSTARTED_EVENTS_TXSTARTED_Pos = 0x0
	// Bit mask of EVENTS_TXSTARTED field.
	TWIS_EVENTS_TXSTARTED_EVENTS_TXSTARTED_Msk = 0x1
	// Bit EVENTS_TXSTARTED.
	TWIS_EVENTS_TXSTARTED_EVENTS_TXSTARTED = 0x1
	// Event not generated
	TWIS_EVENTS_TXSTARTED_EVENTS_TXSTARTED_NotGenerated = 0x0
	// Event generated
	TWIS_EVENTS_TXSTARTED_EVENTS_TXSTARTED_Generated = 0x1

	// EVENTS_WRITE: Write command received
	// Position of EVENTS_WRITE field.
	TWIS_EVENTS_WRITE_EVENTS_WRITE_Pos = 0x0
	// Bit mask of EVENTS_WRITE field.
	TWIS_EVENTS_WRITE_EVENTS_WRITE_Msk = 0x1
	// Bit EVENTS_WRITE.
	TWIS_EVENTS_WRITE_EVENTS_WRITE = 0x1
	// Event not generated
	TWIS_EVENTS_WRITE_EVENTS_WRITE_NotGenerated = 0x0
	// Event generated
	TWIS_EVENTS_WRITE_EVENTS_WRITE_Generated = 0x1

	// EVENTS_READ: Read command received
	// Position of EVENTS_READ field.
	TWIS_EVENTS_READ_EVENTS_READ_Pos = 0x0
	// Bit mask of EVENTS_READ field.
	TWIS_EVENTS_READ_EVENTS_READ_Msk = 0x1
	// Bit EVENTS_READ.
	TWIS_EVENTS_READ_EVENTS_READ = 0x1
	// Event not generated
	TWIS_EVENTS_READ_EVENTS_READ_NotGenerated = 0x0
	// Event generated
	TWIS_EVENTS_READ_EVENTS_READ_Generated = 0x1

	// PUBLISH_STOPPED: Publish configuration for event STOPPED
	// Position of CHIDX field.
	TWIS_PUBLISH_STOPPED_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	TWIS_PUBLISH_STOPPED_CHIDX_Msk = 0xff
	// Position of EN field.
	TWIS_PUBLISH_STOPPED_EN_Pos = 0x1f
	// Bit mask of EN field.
	TWIS_PUBLISH_STOPPED_EN_Msk = 0x80000000
	// Bit EN.
	TWIS_PUBLISH_STOPPED_EN = 0x80000000
	// Disable publishing
	TWIS_PUBLISH_STOPPED_EN_Disabled = 0x0
	// Enable publishing
	TWIS_PUBLISH_STOPPED_EN_Enabled = 0x1

	// PUBLISH_ERROR: Publish configuration for event ERROR
	// Position of CHIDX field.
	TWIS_PUBLISH_ERROR_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	TWIS_PUBLISH_ERROR_CHIDX_Msk = 0xff
	// Position of EN field.
	TWIS_PUBLISH_ERROR_EN_Pos = 0x1f
	// Bit mask of EN field.
	TWIS_PUBLISH_ERROR_EN_Msk = 0x80000000
	// Bit EN.
	TWIS_PUBLISH_ERROR_EN = 0x80000000
	// Disable publishing
	TWIS_PUBLISH_ERROR_EN_Disabled = 0x0
	// Enable publishing
	TWIS_PUBLISH_ERROR_EN_Enabled = 0x1

	// PUBLISH_RXSTARTED: Publish configuration for event RXSTARTED
	// Position of CHIDX field.
	TWIS_PUBLISH_RXSTARTED_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	TWIS_PUBLISH_RXSTARTED_CHIDX_Msk = 0xff
	// Position of EN field.
	TWIS_PUBLISH_RXSTARTED_EN_Pos = 0x1f
	// Bit mask of EN field.
	TWIS_PUBLISH_RXSTARTED_EN_Msk = 0x80000000
	// Bit EN.
	TWIS_PUBLISH_RXSTARTED_EN = 0x80000000
	// Disable publishing
	TWIS_PUBLISH_RXSTARTED_EN_Disabled = 0x0
	// Enable publishing
	TWIS_PUBLISH_RXSTARTED_EN_Enabled = 0x1

	// PUBLISH_TXSTARTED: Publish configuration for event TXSTARTED
	// Position of CHIDX field.
	TWIS_PUBLISH_TXSTARTED_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	TWIS_PUBLISH_TXSTARTED_CHIDX_Msk = 0xff
	// Position of EN field.
	TWIS_PUBLISH_TXSTARTED_EN_Pos = 0x1f
	// Bit mask of EN field.
	TWIS_PUBLISH_TXSTARTED_EN_Msk = 0x80000000
	// Bit EN.
	TWIS_PUBLISH_TXSTARTED_EN = 0x80000000
	// Disable publishing
	TWIS_PUBLISH_TXSTARTED_EN_Disabled = 0x0
	// Enable publishing
	TWIS_PUBLISH_TXSTARTED_EN_Enabled = 0x1

	// PUBLISH_WRITE: Publish configuration for event WRITE
	// Position of CHIDX field.
	TWIS_PUBLISH_WRITE_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	TWIS_PUBLISH_WRITE_CHIDX_Msk = 0xff
	// Position of EN field.
	TWIS_PUBLISH_WRITE_EN_Pos = 0x1f
	// Bit mask of EN field.
	TWIS_PUBLISH_WRITE_EN_Msk = 0x80000000
	// Bit EN.
	TWIS_PUBLISH_WRITE_EN = 0x80000000
	// Disable publishing
	TWIS_PUBLISH_WRITE_EN_Disabled = 0x0
	// Enable publishing
	TWIS_PUBLISH_WRITE_EN_Enabled = 0x1

	// PUBLISH_READ: Publish configuration for event READ
	// Position of CHIDX field.
	TWIS_PUBLISH_READ_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	TWIS_PUBLISH_READ_CHIDX_Msk = 0xff
	// Position of EN field.
	TWIS_PUBLISH_READ_EN_Pos = 0x1f
	// Bit mask of EN field.
	TWIS_PUBLISH_READ_EN_Msk = 0x80000000
	// Bit EN.
	TWIS_PUBLISH_READ_EN = 0x80000000
	// Disable publishing
	TWIS_PUBLISH_READ_EN_Disabled = 0x0
	// Enable publishing
	TWIS_PUBLISH_READ_EN_Enabled = 0x1

	// SHORTS: Shortcuts between local events and tasks
	// Position of WRITE_SUSPEND field.
	TWIS_SHORTS_WRITE_SUSPEND_Pos = 0xd
	// Bit mask of WRITE_SUSPEND field.
	TWIS_SHORTS_WRITE_SUSPEND_Msk = 0x2000
	// Bit WRITE_SUSPEND.
	TWIS_SHORTS_WRITE_SUSPEND = 0x2000
	// Disable shortcut
	TWIS_SHORTS_WRITE_SUSPEND_Disabled = 0x0
	// Enable shortcut
	TWIS_SHORTS_WRITE_SUSPEND_Enabled = 0x1
	// Position of READ_SUSPEND field.
	TWIS_SHORTS_READ_SUSPEND_Pos = 0xe
	// Bit mask of READ_SUSPEND field.
	TWIS_SHORTS_READ_SUSPEND_Msk = 0x4000
	// Bit READ_SUSPEND.
	TWIS_SHORTS_READ_SUSPEND = 0x4000
	// Disable shortcut
	TWIS_SHORTS_READ_SUSPEND_Disabled = 0x0
	// Enable shortcut
	TWIS_SHORTS_READ_SUSPEND_Enabled = 0x1

	// INTEN: Enable or disable interrupt
	// Position of STOPPED field.
	TWIS_INTEN_STOPPED_Pos = 0x1
	// Bit mask of STOPPED field.
	TWIS_INTEN_STOPPED_Msk = 0x2
	// Bit STOPPED.
	TWIS_INTEN_STOPPED = 0x2
	// Disable
	TWIS_INTEN_STOPPED_Disabled = 0x0
	// Enable
	TWIS_INTEN_STOPPED_Enabled = 0x1
	// Position of ERROR field.
	TWIS_INTEN_ERROR_Pos = 0x9
	// Bit mask of ERROR field.
	TWIS_INTEN_ERROR_Msk = 0x200
	// Bit ERROR.
	TWIS_INTEN_ERROR = 0x200
	// Disable
	TWIS_INTEN_ERROR_Disabled = 0x0
	// Enable
	TWIS_INTEN_ERROR_Enabled = 0x1
	// Position of RXSTARTED field.
	TWIS_INTEN_RXSTARTED_Pos = 0x13
	// Bit mask of RXSTARTED field.
	TWIS_INTEN_RXSTARTED_Msk = 0x80000
	// Bit RXSTARTED.
	TWIS_INTEN_RXSTARTED = 0x80000
	// Disable
	TWIS_INTEN_RXSTARTED_Disabled = 0x0
	// Enable
	TWIS_INTEN_RXSTARTED_Enabled = 0x1
	// Position of TXSTARTED field.
	TWIS_INTEN_TXSTARTED_Pos = 0x14
	// Bit mask of TXSTARTED field.
	TWIS_INTEN_TXSTARTED_Msk = 0x100000
	// Bit TXSTARTED.
	TWIS_INTEN_TXSTARTED = 0x100000
	// Disable
	TWIS_INTEN_TXSTARTED_Disabled = 0x0
	// Enable
	TWIS_INTEN_TXSTARTED_Enabled = 0x1
	// Position of WRITE field.
	TWIS_INTEN_WRITE_Pos = 0x19
	// Bit mask of WRITE field.
	TWIS_INTEN_WRITE_Msk = 0x2000000
	// Bit WRITE.
	TWIS_INTEN_WRITE = 0x2000000
	// Disable
	TWIS_INTEN_WRITE_Disabled = 0x0
	// Enable
	TWIS_INTEN_WRITE_Enabled = 0x1
	// Position of READ field.
	TWIS_INTEN_READ_Pos = 0x1a
	// Bit mask of READ field.
	TWIS_INTEN_READ_Msk = 0x4000000
	// Bit READ.
	TWIS_INTEN_READ = 0x4000000
	// Disable
	TWIS_INTEN_READ_Disabled = 0x0
	// Enable
	TWIS_INTEN_READ_Enabled = 0x1

	// INTENSET: Enable interrupt
	// Position of STOPPED field.
	TWIS_INTENSET_STOPPED_Pos = 0x1
	// Bit mask of STOPPED field.
	TWIS_INTENSET_STOPPED_Msk = 0x2
	// Bit STOPPED.
	TWIS_INTENSET_STOPPED = 0x2
	// Read: Disabled
	TWIS_INTENSET_STOPPED_Disabled = 0x0
	// Read: Enabled
	TWIS_INTENSET_STOPPED_Enabled = 0x1
	// Enable
	TWIS_INTENSET_STOPPED_Set = 0x1
	// Position of ERROR field.
	TWIS_INTENSET_ERROR_Pos = 0x9
	// Bit mask of ERROR field.
	TWIS_INTENSET_ERROR_Msk = 0x200
	// Bit ERROR.
	TWIS_INTENSET_ERROR = 0x200
	// Read: Disabled
	TWIS_INTENSET_ERROR_Disabled = 0x0
	// Read: Enabled
	TWIS_INTENSET_ERROR_Enabled = 0x1
	// Enable
	TWIS_INTENSET_ERROR_Set = 0x1
	// Position of RXSTARTED field.
	TWIS_INTENSET_RXSTARTED_Pos = 0x13
	// Bit mask of RXSTARTED field.
	TWIS_INTENSET_RXSTARTED_Msk = 0x80000
	// Bit RXSTARTED.
	TWIS_INTENSET_RXSTARTED = 0x80000
	// Read: Disabled
	TWIS_INTENSET_RXSTARTED_Disabled = 0x0
	// Read: Enabled
	TWIS_INTENSET_RXSTARTED_Enabled = 0x1
	// Enable
	TWIS_INTENSET_RXSTARTED_Set = 0x1
	// Position of TXSTARTED field.
	TWIS_INTENSET_TXSTARTED_Pos = 0x14
	// Bit mask of TXSTARTED field.
	TWIS_INTENSET_TXSTARTED_Msk = 0x100000
	// Bit TXSTARTED.
	TWIS_INTENSET_TXSTARTED = 0x100000
	// Read: Disabled
	TWIS_INTENSET_TXSTARTED_Disabled = 0x0
	// Read: Enabled
	TWIS_INTENSET_TXSTARTED_Enabled = 0x1
	// Enable
	TWIS_INTENSET_TXSTARTED_Set = 0x1
	// Position of WRITE field.
	TWIS_INTENSET_WRITE_Pos = 0x19
	// Bit mask of WRITE field.
	TWIS_INTENSET_WRITE_Msk = 0x2000000
	// Bit WRITE.
	TWIS_INTENSET_WRITE = 0x2000000
	// Read: Disabled
	TWIS_INTENSET_WRITE_Disabled = 0x0
	// Read: Enabled
	TWIS_INTENSET_WRITE_Enabled = 0x1
	// Enable
	TWIS_INTENSET_WRITE_Set = 0x1
	// Position of READ field.
	TWIS_INTENSET_READ_Pos = 0x1a
	// Bit mask of READ field.
	TWIS_INTENSET_READ_Msk = 0x4000000
	// Bit READ.
	TWIS_INTENSET_READ = 0x4000000
	// Read: Disabled
	TWIS_INTENSET_READ_Disabled = 0x0
	// Read: Enabled
	TWIS_INTENSET_READ_Enabled = 0x1
	// Enable
	TWIS_INTENSET_READ_Set = 0x1

	// INTENCLR: Disable interrupt
	// Position of STOPPED field.
	TWIS_INTENCLR_STOPPED_Pos = 0x1
	// Bit mask of STOPPED field.
	TWIS_INTENCLR_STOPPED_Msk = 0x2
	// Bit STOPPED.
	TWIS_INTENCLR_STOPPED = 0x2
	// Read: Disabled
	TWIS_INTENCLR_STOPPED_Disabled = 0x0
	// Read: Enabled
	TWIS_INTENCLR_STOPPED_Enabled = 0x1
	// Disable
	TWIS_INTENCLR_STOPPED_Clear = 0x1
	// Position of ERROR field.
	TWIS_INTENCLR_ERROR_Pos = 0x9
	// Bit mask of ERROR field.
	TWIS_INTENCLR_ERROR_Msk = 0x200
	// Bit ERROR.
	TWIS_INTENCLR_ERROR = 0x200
	// Read: Disabled
	TWIS_INTENCLR_ERROR_Disabled = 0x0
	// Read: Enabled
	TWIS_INTENCLR_ERROR_Enabled = 0x1
	// Disable
	TWIS_INTENCLR_ERROR_Clear = 0x1
	// Position of RXSTARTED field.
	TWIS_INTENCLR_RXSTARTED_Pos = 0x13
	// Bit mask of RXSTARTED field.
	TWIS_INTENCLR_RXSTARTED_Msk = 0x80000
	// Bit RXSTARTED.
	TWIS_INTENCLR_RXSTARTED = 0x80000
	// Read: Disabled
	TWIS_INTENCLR_RXSTARTED_Disabled = 0x0
	// Read: Enabled
	TWIS_INTENCLR_RXSTARTED_Enabled = 0x1
	// Disable
	TWIS_INTENCLR_RXSTARTED_Clear = 0x1
	// Position of TXSTARTED field.
	TWIS_INTENCLR_TXSTARTED_Pos = 0x14
	// Bit mask of TXSTARTED field.
	TWIS_INTENCLR_TXSTARTED_Msk = 0x100000
	// Bit TXSTARTED.
	TWIS_INTENCLR_TXSTARTED = 0x100000
	// Read: Disabled
	TWIS_INTENCLR_TXSTARTED_Disabled = 0x0
	// Read: Enabled
	TWIS_INTENCLR_TXSTARTED_Enabled = 0x1
	// Disable
	TWIS_INTENCLR_TXSTARTED_Clear = 0x1
	// Position of WRITE field.
	TWIS_INTENCLR_WRITE_Pos = 0x19
	// Bit mask of WRITE field.
	TWIS_INTENCLR_WRITE_Msk = 0x2000000
	// Bit WRITE.
	TWIS_INTENCLR_WRITE = 0x2000000
	// Read: Disabled
	TWIS_INTENCLR_WRITE_Disabled = 0x0
	// Read: Enabled
	TWIS_INTENCLR_WRITE_Enabled = 0x1
	// Disable
	TWIS_INTENCLR_WRITE_Clear = 0x1
	// Position of READ field.
	TWIS_INTENCLR_READ_Pos = 0x1a
	// Bit mask of READ field.
	TWIS_INTENCLR_READ_Msk = 0x4000000
	// Bit READ.
	TWIS_INTENCLR_READ = 0x4000000
	// Read: Disabled
	TWIS_INTENCLR_READ_Disabled = 0x0
	// Read: Enabled
	TWIS_INTENCLR_READ_Enabled = 0x1
	// Disable
	TWIS_INTENCLR_READ_Clear = 0x1

	// ERRORSRC: Error source
	// Position of OVERFLOW field.
	TWIS_ERRORSRC_OVERFLOW_Pos = 0x0
	// Bit mask of OVERFLOW field.
	TWIS_ERRORSRC_OVERFLOW_Msk = 0x1
	// Bit OVERFLOW.
	TWIS_ERRORSRC_OVERFLOW = 0x1
	// Error did not occur
	TWIS_ERRORSRC_OVERFLOW_NotDetected = 0x0
	// Error occurred
	TWIS_ERRORSRC_OVERFLOW_Detected = 0x1
	// Position of DNACK field.
	TWIS_ERRORSRC_DNACK_Pos = 0x2
	// Bit mask of DNACK field.
	TWIS_ERRORSRC_DNACK_Msk = 0x4
	// Bit DNACK.
	TWIS_ERRORSRC_DNACK = 0x4
	// Error did not occur
	TWIS_ERRORSRC_DNACK_NotReceived = 0x0
	// Error occurred
	TWIS_ERRORSRC_DNACK_Received = 0x1
	// Position of OVERREAD field.
	TWIS_ERRORSRC_OVERREAD_Pos = 0x3
	// Bit mask of OVERREAD field.
	TWIS_ERRORSRC_OVERREAD_Msk = 0x8
	// Bit OVERREAD.
	TWIS_ERRORSRC_OVERREAD = 0x8
	// Error did not occur
	TWIS_ERRORSRC_OVERREAD_NotDetected = 0x0
	// Error occurred
	TWIS_ERRORSRC_OVERREAD_Detected = 0x1

	// MATCH: Status register indicating which address had a match
	// Position of MATCH field.
	TWIS_MATCH_MATCH_Pos = 0x0
	// Bit mask of MATCH field.
	TWIS_MATCH_MATCH_Msk = 0x1
	// Bit MATCH.
	TWIS_MATCH_MATCH = 0x1

	// ENABLE: Enable TWIS
	// Position of ENABLE field.
	TWIS_ENABLE_ENABLE_Pos = 0x0
	// Bit mask of ENABLE field.
	TWIS_ENABLE_ENABLE_Msk = 0xf
	// Disable TWIS
	TWIS_ENABLE_ENABLE_Disabled = 0x0
	// Enable TWIS
	TWIS_ENABLE_ENABLE_Enabled = 0x9

	// PSEL.SCL: Pin select for SCL signal
	// Position of PIN field.
	TWIS_PSEL_SCL_PIN_Pos = 0x0
	// Bit mask of PIN field.
	TWIS_PSEL_SCL_PIN_Msk = 0x1f
	// Position of PORT field.
	TWIS_PSEL_SCL_PORT_Pos = 0x5
	// Bit mask of PORT field.
	TWIS_PSEL_SCL_PORT_Msk = 0x20
	// Bit PORT.
	TWIS_PSEL_SCL_PORT = 0x20
	// Position of CONNECT field.
	TWIS_PSEL_SCL_CONNECT_Pos = 0x1f
	// Bit mask of CONNECT field.
	TWIS_PSEL_SCL_CONNECT_Msk = 0x80000000
	// Bit CONNECT.
	TWIS_PSEL_SCL_CONNECT = 0x80000000
	// Disconnect
	TWIS_PSEL_SCL_CONNECT_Disconnected = 0x1
	// Connect
	TWIS_PSEL_SCL_CONNECT_Connected = 0x0

	// PSEL.SDA: Pin select for SDA signal
	// Position of PIN field.
	TWIS_PSEL_SDA_PIN_Pos = 0x0
	// Bit mask of PIN field.
	TWIS_PSEL_SDA_PIN_Msk = 0x1f
	// Position of PORT field.
	TWIS_PSEL_SDA_PORT_Pos = 0x5
	// Bit mask of PORT field.
	TWIS_PSEL_SDA_PORT_Msk = 0x20
	// Bit PORT.
	TWIS_PSEL_SDA_PORT = 0x20
	// Position of CONNECT field.
	TWIS_PSEL_SDA_CONNECT_Pos = 0x1f
	// Bit mask of CONNECT field.
	TWIS_PSEL_SDA_CONNECT_Msk = 0x80000000
	// Bit CONNECT.
	TWIS_PSEL_SDA_CONNECT = 0x80000000
	// Disconnect
	TWIS_PSEL_SDA_CONNECT_Disconnected = 0x1
	// Connect
	TWIS_PSEL_SDA_CONNECT_Connected = 0x0

	// RXD.PTR: RXD Data pointer
	// Position of PTR field.
	TWIS_RXD_PTR_PTR_Pos = 0x0
	// Bit mask of PTR field.
	TWIS_RXD_PTR_PTR_Msk = 0xffffffff

	// RXD.MAXCNT: Maximum number of bytes in RXD buffer
	// Position of MAXCNT field.
	TWIS_RXD_MAXCNT_MAXCNT_Pos = 0x0
	// Bit mask of MAXCNT field.
	TWIS_RXD_MAXCNT_MAXCNT_Msk = 0xffff

	// RXD.AMOUNT: Number of bytes transferred in the last RXD transaction
	// Position of AMOUNT field.
	TWIS_RXD_AMOUNT_AMOUNT_Pos = 0x0
	// Bit mask of AMOUNT field.
	TWIS_RXD_AMOUNT_AMOUNT_Msk = 0xffff

	// RXD.LIST: EasyDMA list type
	// Position of LIST field.
	TWIS_RXD_LIST_LIST_Pos = 0x0
	// Bit mask of LIST field.
	TWIS_RXD_LIST_LIST_Msk = 0x3
	// Disable EasyDMA list
	TWIS_RXD_LIST_LIST_Disabled = 0x0
	// Use array list
	TWIS_RXD_LIST_LIST_ArrayList = 0x1

	// TXD.PTR: TXD Data pointer
	// Position of PTR field.
	TWIS_TXD_PTR_PTR_Pos = 0x0
	// Bit mask of PTR field.
	TWIS_TXD_PTR_PTR_Msk = 0xffffffff

	// TXD.MAXCNT: Maximum number of bytes in TXD buffer
	// Position of MAXCNT field.
	TWIS_TXD_MAXCNT_MAXCNT_Pos = 0x0
	// Bit mask of MAXCNT field.
	TWIS_TXD_MAXCNT_MAXCNT_Msk = 0xffff

	// TXD.AMOUNT: Number of bytes transferred in the last TXD transaction
	// Position of AMOUNT field.
	TWIS_TXD_AMOUNT_AMOUNT_Pos = 0x0
	// Bit mask of AMOUNT field.
	TWIS_TXD_AMOUNT_AMOUNT_Msk = 0xffff

	// TXD.LIST: EasyDMA list type
	// Position of LIST field.
	TWIS_TXD_LIST_LIST_Pos = 0x0
	// Bit mask of LIST field.
	TWIS_TXD_LIST_LIST_Msk = 0x3
	// Disable EasyDMA list
	TWIS_TXD_LIST_LIST_Disabled = 0x0
	// Use array list
	TWIS_TXD_LIST_LIST_ArrayList = 0x1

	// ADDRESS: Description collection: TWI slave address n
	// Position of ADDRESS field.
	TWIS_ADDRESS_ADDRESS_Pos = 0x0
	// Bit mask of ADDRESS field.
	TWIS_ADDRESS_ADDRESS_Msk = 0x7f

	// CONFIG: Configuration register for the address match mechanism
	// Position of ADDRESS0 field.
	TWIS_CONFIG_ADDRESS0_Pos = 0x0
	// Bit mask of ADDRESS0 field.
	TWIS_CONFIG_ADDRESS0_Msk = 0x1
	// Bit ADDRESS0.
	TWIS_CONFIG_ADDRESS0 = 0x1
	// Disabled
	TWIS_CONFIG_ADDRESS0_Disabled = 0x0
	// Enabled
	TWIS_CONFIG_ADDRESS0_Enabled = 0x1
	// Position of ADDRESS1 field.
	TWIS_CONFIG_ADDRESS1_Pos = 0x1
	// Bit mask of ADDRESS1 field.
	TWIS_CONFIG_ADDRESS1_Msk = 0x2
	// Bit ADDRESS1.
	TWIS_CONFIG_ADDRESS1 = 0x2
	// Disabled
	TWIS_CONFIG_ADDRESS1_Disabled = 0x0
	// Enabled
	TWIS_CONFIG_ADDRESS1_Enabled = 0x1

	// ORC: Over-read character. Character sent out in case of an over-read of the transmit buffer.
	// Position of ORC field.
	TWIS_ORC_ORC_Pos = 0x0
	// Bit mask of ORC field.
	TWIS_ORC_ORC_Msk = 0xff
)

// Constants for UARTE0_NS: UART with EasyDMA
const (
	// TASKS_STARTRX: Start UART receiver
	// Position of TASKS_STARTRX field.
	UARTE_TASKS_STARTRX_TASKS_STARTRX_Pos = 0x0
	// Bit mask of TASKS_STARTRX field.
	UARTE_TASKS_STARTRX_TASKS_STARTRX_Msk = 0x1
	// Bit TASKS_STARTRX.
	UARTE_TASKS_STARTRX_TASKS_STARTRX = 0x1
	// Trigger task
	UARTE_TASKS_STARTRX_TASKS_STARTRX_Trigger = 0x1

	// TASKS_STOPRX: Stop UART receiver
	// Position of TASKS_STOPRX field.
	UARTE_TASKS_STOPRX_TASKS_STOPRX_Pos = 0x0
	// Bit mask of TASKS_STOPRX field.
	UARTE_TASKS_STOPRX_TASKS_STOPRX_Msk = 0x1
	// Bit TASKS_STOPRX.
	UARTE_TASKS_STOPRX_TASKS_STOPRX = 0x1
	// Trigger task
	UARTE_TASKS_STOPRX_TASKS_STOPRX_Trigger = 0x1

	// TASKS_STARTTX: Start UART transmitter
	// Position of TASKS_STARTTX field.
	UARTE_TASKS_STARTTX_TASKS_STARTTX_Pos = 0x0
	// Bit mask of TASKS_STARTTX field.
	UARTE_TASKS_STARTTX_TASKS_STARTTX_Msk = 0x1
	// Bit TASKS_STARTTX.
	UARTE_TASKS_STARTTX_TASKS_STARTTX = 0x1
	// Trigger task
	UARTE_TASKS_STARTTX_TASKS_STARTTX_Trigger = 0x1

	// TASKS_STOPTX: Stop UART transmitter
	// Position of TASKS_STOPTX field.
	UARTE_TASKS_STOPTX_TASKS_STOPTX_Pos = 0x0
	// Bit mask of TASKS_STOPTX field.
	UARTE_TASKS_STOPTX_TASKS_STOPTX_Msk = 0x1
	// Bit TASKS_STOPTX.
	UARTE_TASKS_STOPTX_TASKS_STOPTX = 0x1
	// Trigger task
	UARTE_TASKS_STOPTX_TASKS_STOPTX_Trigger = 0x1

	// TASKS_FLUSHRX: Flush RX FIFO into RX buffer
	// Position of TASKS_FLUSHRX field.
	UARTE_TASKS_FLUSHRX_TASKS_FLUSHRX_Pos = 0x0
	// Bit mask of TASKS_FLUSHRX field.
	UARTE_TASKS_FLUSHRX_TASKS_FLUSHRX_Msk = 0x1
	// Bit TASKS_FLUSHRX.
	UARTE_TASKS_FLUSHRX_TASKS_FLUSHRX = 0x1
	// Trigger task
	UARTE_TASKS_FLUSHRX_TASKS_FLUSHRX_Trigger = 0x1

	// SUBSCRIBE_STARTRX: Subscribe configuration for task STARTRX
	// Position of CHIDX field.
	UARTE_SUBSCRIBE_STARTRX_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	UARTE_SUBSCRIBE_STARTRX_CHIDX_Msk = 0xff
	// Position of EN field.
	UARTE_SUBSCRIBE_STARTRX_EN_Pos = 0x1f
	// Bit mask of EN field.
	UARTE_SUBSCRIBE_STARTRX_EN_Msk = 0x80000000
	// Bit EN.
	UARTE_SUBSCRIBE_STARTRX_EN = 0x80000000
	// Disable subscription
	UARTE_SUBSCRIBE_STARTRX_EN_Disabled = 0x0
	// Enable subscription
	UARTE_SUBSCRIBE_STARTRX_EN_Enabled = 0x1

	// SUBSCRIBE_STOPRX: Subscribe configuration for task STOPRX
	// Position of CHIDX field.
	UARTE_SUBSCRIBE_STOPRX_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	UARTE_SUBSCRIBE_STOPRX_CHIDX_Msk = 0xff
	// Position of EN field.
	UARTE_SUBSCRIBE_STOPRX_EN_Pos = 0x1f
	// Bit mask of EN field.
	UARTE_SUBSCRIBE_STOPRX_EN_Msk = 0x80000000
	// Bit EN.
	UARTE_SUBSCRIBE_STOPRX_EN = 0x80000000
	// Disable subscription
	UARTE_SUBSCRIBE_STOPRX_EN_Disabled = 0x0
	// Enable subscription
	UARTE_SUBSCRIBE_STOPRX_EN_Enabled = 0x1

	// SUBSCRIBE_STARTTX: Subscribe configuration for task STARTTX
	// Position of CHIDX field.
	UARTE_SUBSCRIBE_STARTTX_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	UARTE_SUBSCRIBE_STARTTX_CHIDX_Msk = 0xff
	// Position of EN field.
	UARTE_SUBSCRIBE_STARTTX_EN_Pos = 0x1f
	// Bit mask of EN field.
	UARTE_SUBSCRIBE_STARTTX_EN_Msk = 0x80000000
	// Bit EN.
	UARTE_SUBSCRIBE_STARTTX_EN = 0x80000000
	// Disable subscription
	UARTE_SUBSCRIBE_STARTTX_EN_Disabled = 0x0
	// Enable subscription
	UARTE_SUBSCRIBE_STARTTX_EN_Enabled = 0x1

	// SUBSCRIBE_STOPTX: Subscribe configuration for task STOPTX
	// Position of CHIDX field.
	UARTE_SUBSCRIBE_STOPTX_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	UARTE_SUBSCRIBE_STOPTX_CHIDX_Msk = 0xff
	// Position of EN field.
	UARTE_SUBSCRIBE_STOPTX_EN_Pos = 0x1f
	// Bit mask of EN field.
	UARTE_SUBSCRIBE_STOPTX_EN_Msk = 0x80000000
	// Bit EN.
	UARTE_SUBSCRIBE_STOPTX_EN = 0x80000000
	// Disable subscription
	UARTE_SUBSCRIBE_STOPTX_EN_Disabled = 0x0
	// Enable subscription
	UARTE_SUBSCRIBE_STOPTX_EN_Enabled = 0x1

	// SUBSCRIBE_FLUSHRX: Subscribe configuration for task FLUSHRX
	// Position of CHIDX field.
	UARTE_SUBSCRIBE_FLUSHRX_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	UARTE_SUBSCRIBE_FLUSHRX_CHIDX_Msk = 0xff
	// Position of EN field.
	UARTE_SUBSCRIBE_FLUSHRX_EN_Pos = 0x1f
	// Bit mask of EN field.
	UARTE_SUBSCRIBE_FLUSHRX_EN_Msk = 0x80000000
	// Bit EN.
	UARTE_SUBSCRIBE_FLUSHRX_EN = 0x80000000
	// Disable subscription
	UARTE_SUBSCRIBE_FLUSHRX_EN_Disabled = 0x0
	// Enable subscription
	UARTE_SUBSCRIBE_FLUSHRX_EN_Enabled = 0x1

	// EVENTS_CTS: CTS is activated (set low). Clear To Send.
	// Position of EVENTS_CTS field.
	UARTE_EVENTS_CTS_EVENTS_CTS_Pos = 0x0
	// Bit mask of EVENTS_CTS field.
	UARTE_EVENTS_CTS_EVENTS_CTS_Msk = 0x1
	// Bit EVENTS_CTS.
	UARTE_EVENTS_CTS_EVENTS_CTS = 0x1
	// Event not generated
	UARTE_EVENTS_CTS_EVENTS_CTS_NotGenerated = 0x0
	// Event generated
	UARTE_EVENTS_CTS_EVENTS_CTS_Generated = 0x1

	// EVENTS_NCTS: CTS is deactivated (set high). Not Clear To Send.
	// Position of EVENTS_NCTS field.
	UARTE_EVENTS_NCTS_EVENTS_NCTS_Pos = 0x0
	// Bit mask of EVENTS_NCTS field.
	UARTE_EVENTS_NCTS_EVENTS_NCTS_Msk = 0x1
	// Bit EVENTS_NCTS.
	UARTE_EVENTS_NCTS_EVENTS_NCTS = 0x1
	// Event not generated
	UARTE_EVENTS_NCTS_EVENTS_NCTS_NotGenerated = 0x0
	// Event generated
	UARTE_EVENTS_NCTS_EVENTS_NCTS_Generated = 0x1

	// EVENTS_RXDRDY: Data received in RXD (but potentially not yet transferred to Data RAM)
	// Position of EVENTS_RXDRDY field.
	UARTE_EVENTS_RXDRDY_EVENTS_RXDRDY_Pos = 0x0
	// Bit mask of EVENTS_RXDRDY field.
	UARTE_EVENTS_RXDRDY_EVENTS_RXDRDY_Msk = 0x1
	// Bit EVENTS_RXDRDY.
	UARTE_EVENTS_RXDRDY_EVENTS_RXDRDY = 0x1
	// Event not generated
	UARTE_EVENTS_RXDRDY_EVENTS_RXDRDY_NotGenerated = 0x0
	// Event generated
	UARTE_EVENTS_RXDRDY_EVENTS_RXDRDY_Generated = 0x1

	// EVENTS_ENDRX: Receive buffer is filled up
	// Position of EVENTS_ENDRX field.
	UARTE_EVENTS_ENDRX_EVENTS_ENDRX_Pos = 0x0
	// Bit mask of EVENTS_ENDRX field.
	UARTE_EVENTS_ENDRX_EVENTS_ENDRX_Msk = 0x1
	// Bit EVENTS_ENDRX.
	UARTE_EVENTS_ENDRX_EVENTS_ENDRX = 0x1
	// Event not generated
	UARTE_EVENTS_ENDRX_EVENTS_ENDRX_NotGenerated = 0x0
	// Event generated
	UARTE_EVENTS_ENDRX_EVENTS_ENDRX_Generated = 0x1

	// EVENTS_TXDRDY: Data sent from TXD
	// Position of EVENTS_TXDRDY field.
	UARTE_EVENTS_TXDRDY_EVENTS_TXDRDY_Pos = 0x0
	// Bit mask of EVENTS_TXDRDY field.
	UARTE_EVENTS_TXDRDY_EVENTS_TXDRDY_Msk = 0x1
	// Bit EVENTS_TXDRDY.
	UARTE_EVENTS_TXDRDY_EVENTS_TXDRDY = 0x1
	// Event not generated
	UARTE_EVENTS_TXDRDY_EVENTS_TXDRDY_NotGenerated = 0x0
	// Event generated
	UARTE_EVENTS_TXDRDY_EVENTS_TXDRDY_Generated = 0x1

	// EVENTS_ENDTX: Last TX byte transmitted
	// Position of EVENTS_ENDTX field.
	UARTE_EVENTS_ENDTX_EVENTS_ENDTX_Pos = 0x0
	// Bit mask of EVENTS_ENDTX field.
	UARTE_EVENTS_ENDTX_EVENTS_ENDTX_Msk = 0x1
	// Bit EVENTS_ENDTX.
	UARTE_EVENTS_ENDTX_EVENTS_ENDTX = 0x1
	// Event not generated
	UARTE_EVENTS_ENDTX_EVENTS_ENDTX_NotGenerated = 0x0
	// Event generated
	UARTE_EVENTS_ENDTX_EVENTS_ENDTX_Generated = 0x1

	// EVENTS_ERROR: Error detected
	// Position of EVENTS_ERROR field.
	UARTE_EVENTS_ERROR_EVENTS_ERROR_Pos = 0x0
	// Bit mask of EVENTS_ERROR field.
	UARTE_EVENTS_ERROR_EVENTS_ERROR_Msk = 0x1
	// Bit EVENTS_ERROR.
	UARTE_EVENTS_ERROR_EVENTS_ERROR = 0x1
	// Event not generated
	UARTE_EVENTS_ERROR_EVENTS_ERROR_NotGenerated = 0x0
	// Event generated
	UARTE_EVENTS_ERROR_EVENTS_ERROR_Generated = 0x1

	// EVENTS_RXTO: Receiver timeout
	// Position of EVENTS_RXTO field.
	UARTE_EVENTS_RXTO_EVENTS_RXTO_Pos = 0x0
	// Bit mask of EVENTS_RXTO field.
	UARTE_EVENTS_RXTO_EVENTS_RXTO_Msk = 0x1
	// Bit EVENTS_RXTO.
	UARTE_EVENTS_RXTO_EVENTS_RXTO = 0x1
	// Event not generated
	UARTE_EVENTS_RXTO_EVENTS_RXTO_NotGenerated = 0x0
	// Event generated
	UARTE_EVENTS_RXTO_EVENTS_RXTO_Generated = 0x1

	// EVENTS_RXSTARTED: UART receiver has started
	// Position of EVENTS_RXSTARTED field.
	UARTE_EVENTS_RXSTARTED_EVENTS_RXSTARTED_Pos = 0x0
	// Bit mask of EVENTS_RXSTARTED field.
	UARTE_EVENTS_RXSTARTED_EVENTS_RXSTARTED_Msk = 0x1
	// Bit EVENTS_RXSTARTED.
	UARTE_EVENTS_RXSTARTED_EVENTS_RXSTARTED = 0x1
	// Event not generated
	UARTE_EVENTS_RXSTARTED_EVENTS_RXSTARTED_NotGenerated = 0x0
	// Event generated
	UARTE_EVENTS_RXSTARTED_EVENTS_RXSTARTED_Generated = 0x1

	// EVENTS_TXSTARTED: UART transmitter has started
	// Position of EVENTS_TXSTARTED field.
	UARTE_EVENTS_TXSTARTED_EVENTS_TXSTARTED_Pos = 0x0
	// Bit mask of EVENTS_TXSTARTED field.
	UARTE_EVENTS_TXSTARTED_EVENTS_TXSTARTED_Msk = 0x1
	// Bit EVENTS_TXSTARTED.
	UARTE_EVENTS_TXSTARTED_EVENTS_TXSTARTED = 0x1
	// Event not generated
	UARTE_EVENTS_TXSTARTED_EVENTS_TXSTARTED_NotGenerated = 0x0
	// Event generated
	UARTE_EVENTS_TXSTARTED_EVENTS_TXSTARTED_Generated = 0x1

	// EVENTS_TXSTOPPED: Transmitter stopped
	// Position of EVENTS_TXSTOPPED field.
	UARTE_EVENTS_TXSTOPPED_EVENTS_TXSTOPPED_Pos = 0x0
	// Bit mask of EVENTS_TXSTOPPED field.
	UARTE_EVENTS_TXSTOPPED_EVENTS_TXSTOPPED_Msk = 0x1
	// Bit EVENTS_TXSTOPPED.
	UARTE_EVENTS_TXSTOPPED_EVENTS_TXSTOPPED = 0x1
	// Event not generated
	UARTE_EVENTS_TXSTOPPED_EVENTS_TXSTOPPED_NotGenerated = 0x0
	// Event generated
	UARTE_EVENTS_TXSTOPPED_EVENTS_TXSTOPPED_Generated = 0x1

	// PUBLISH_CTS: Publish configuration for event CTS
	// Position of CHIDX field.
	UARTE_PUBLISH_CTS_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	UARTE_PUBLISH_CTS_CHIDX_Msk = 0xff
	// Position of EN field.
	UARTE_PUBLISH_CTS_EN_Pos = 0x1f
	// Bit mask of EN field.
	UARTE_PUBLISH_CTS_EN_Msk = 0x80000000
	// Bit EN.
	UARTE_PUBLISH_CTS_EN = 0x80000000
	// Disable publishing
	UARTE_PUBLISH_CTS_EN_Disabled = 0x0
	// Enable publishing
	UARTE_PUBLISH_CTS_EN_Enabled = 0x1

	// PUBLISH_NCTS: Publish configuration for event NCTS
	// Position of CHIDX field.
	UARTE_PUBLISH_NCTS_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	UARTE_PUBLISH_NCTS_CHIDX_Msk = 0xff
	// Position of EN field.
	UARTE_PUBLISH_NCTS_EN_Pos = 0x1f
	// Bit mask of EN field.
	UARTE_PUBLISH_NCTS_EN_Msk = 0x80000000
	// Bit EN.
	UARTE_PUBLISH_NCTS_EN = 0x80000000
	// Disable publishing
	UARTE_PUBLISH_NCTS_EN_Disabled = 0x0
	// Enable publishing
	UARTE_PUBLISH_NCTS_EN_Enabled = 0x1

	// PUBLISH_RXDRDY: Publish configuration for event RXDRDY
	// Position of CHIDX field.
	UARTE_PUBLISH_RXDRDY_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	UARTE_PUBLISH_RXDRDY_CHIDX_Msk = 0xff
	// Position of EN field.
	UARTE_PUBLISH_RXDRDY_EN_Pos = 0x1f
	// Bit mask of EN field.
	UARTE_PUBLISH_RXDRDY_EN_Msk = 0x80000000
	// Bit EN.
	UARTE_PUBLISH_RXDRDY_EN = 0x80000000
	// Disable publishing
	UARTE_PUBLISH_RXDRDY_EN_Disabled = 0x0
	// Enable publishing
	UARTE_PUBLISH_RXDRDY_EN_Enabled = 0x1

	// PUBLISH_ENDRX: Publish configuration for event ENDRX
	// Position of CHIDX field.
	UARTE_PUBLISH_ENDRX_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	UARTE_PUBLISH_ENDRX_CHIDX_Msk = 0xff
	// Position of EN field.
	UARTE_PUBLISH_ENDRX_EN_Pos = 0x1f
	// Bit mask of EN field.
	UARTE_PUBLISH_ENDRX_EN_Msk = 0x80000000
	// Bit EN.
	UARTE_PUBLISH_ENDRX_EN = 0x80000000
	// Disable publishing
	UARTE_PUBLISH_ENDRX_EN_Disabled = 0x0
	// Enable publishing
	UARTE_PUBLISH_ENDRX_EN_Enabled = 0x1

	// PUBLISH_TXDRDY: Publish configuration for event TXDRDY
	// Position of CHIDX field.
	UARTE_PUBLISH_TXDRDY_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	UARTE_PUBLISH_TXDRDY_CHIDX_Msk = 0xff
	// Position of EN field.
	UARTE_PUBLISH_TXDRDY_EN_Pos = 0x1f
	// Bit mask of EN field.
	UARTE_PUBLISH_TXDRDY_EN_Msk = 0x80000000
	// Bit EN.
	UARTE_PUBLISH_TXDRDY_EN = 0x80000000
	// Disable publishing
	UARTE_PUBLISH_TXDRDY_EN_Disabled = 0x0
	// Enable publishing
	UARTE_PUBLISH_TXDRDY_EN_Enabled = 0x1

	// PUBLISH_ENDTX: Publish configuration for event ENDTX
	// Position of CHIDX field.
	UARTE_PUBLISH_ENDTX_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	UARTE_PUBLISH_ENDTX_CHIDX_Msk = 0xff
	// Position of EN field.
	UARTE_PUBLISH_ENDTX_EN_Pos = 0x1f
	// Bit mask of EN field.
	UARTE_PUBLISH_ENDTX_EN_Msk = 0x80000000
	// Bit EN.
	UARTE_PUBLISH_ENDTX_EN = 0x80000000
	// Disable publishing
	UARTE_PUBLISH_ENDTX_EN_Disabled = 0x0
	// Enable publishing
	UARTE_PUBLISH_ENDTX_EN_Enabled = 0x1

	// PUBLISH_ERROR: Publish configuration for event ERROR
	// Position of CHIDX field.
	UARTE_PUBLISH_ERROR_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	UARTE_PUBLISH_ERROR_CHIDX_Msk = 0xff
	// Position of EN field.
	UARTE_PUBLISH_ERROR_EN_Pos = 0x1f
	// Bit mask of EN field.
	UARTE_PUBLISH_ERROR_EN_Msk = 0x80000000
	// Bit EN.
	UARTE_PUBLISH_ERROR_EN = 0x80000000
	// Disable publishing
	UARTE_PUBLISH_ERROR_EN_Disabled = 0x0
	// Enable publishing
	UARTE_PUBLISH_ERROR_EN_Enabled = 0x1

	// PUBLISH_RXTO: Publish configuration for event RXTO
	// Position of CHIDX field.
	UARTE_PUBLISH_RXTO_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	UARTE_PUBLISH_RXTO_CHIDX_Msk = 0xff
	// Position of EN field.
	UARTE_PUBLISH_RXTO_EN_Pos = 0x1f
	// Bit mask of EN field.
	UARTE_PUBLISH_RXTO_EN_Msk = 0x80000000
	// Bit EN.
	UARTE_PUBLISH_RXTO_EN = 0x80000000
	// Disable publishing
	UARTE_PUBLISH_RXTO_EN_Disabled = 0x0
	// Enable publishing
	UARTE_PUBLISH_RXTO_EN_Enabled = 0x1

	// PUBLISH_RXSTARTED: Publish configuration for event RXSTARTED
	// Position of CHIDX field.
	UARTE_PUBLISH_RXSTARTED_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	UARTE_PUBLISH_RXSTARTED_CHIDX_Msk = 0xff
	// Position of EN field.
	UARTE_PUBLISH_RXSTARTED_EN_Pos = 0x1f
	// Bit mask of EN field.
	UARTE_PUBLISH_RXSTARTED_EN_Msk = 0x80000000
	// Bit EN.
	UARTE_PUBLISH_RXSTARTED_EN = 0x80000000
	// Disable publishing
	UARTE_PUBLISH_RXSTARTED_EN_Disabled = 0x0
	// Enable publishing
	UARTE_PUBLISH_RXSTARTED_EN_Enabled = 0x1

	// PUBLISH_TXSTARTED: Publish configuration for event TXSTARTED
	// Position of CHIDX field.
	UARTE_PUBLISH_TXSTARTED_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	UARTE_PUBLISH_TXSTARTED_CHIDX_Msk = 0xff
	// Position of EN field.
	UARTE_PUBLISH_TXSTARTED_EN_Pos = 0x1f
	// Bit mask of EN field.
	UARTE_PUBLISH_TXSTARTED_EN_Msk = 0x80000000
	// Bit EN.
	UARTE_PUBLISH_TXSTARTED_EN = 0x80000000
	// Disable publishing
	UARTE_PUBLISH_TXSTARTED_EN_Disabled = 0x0
	// Enable publishing
	UARTE_PUBLISH_TXSTARTED_EN_Enabled = 0x1

	// PUBLISH_TXSTOPPED: Publish configuration for event TXSTOPPED
	// Position of CHIDX field.
	UARTE_PUBLISH_TXSTOPPED_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	UARTE_PUBLISH_TXSTOPPED_CHIDX_Msk = 0xff
	// Position of EN field.
	UARTE_PUBLISH_TXSTOPPED_EN_Pos = 0x1f
	// Bit mask of EN field.
	UARTE_PUBLISH_TXSTOPPED_EN_Msk = 0x80000000
	// Bit EN.
	UARTE_PUBLISH_TXSTOPPED_EN = 0x80000000
	// Disable publishing
	UARTE_PUBLISH_TXSTOPPED_EN_Disabled = 0x0
	// Enable publishing
	UARTE_PUBLISH_TXSTOPPED_EN_Enabled = 0x1

	// SHORTS: Shortcuts between local events and tasks
	// Position of ENDRX_STARTRX field.
	UARTE_SHORTS_ENDRX_STARTRX_Pos = 0x5
	// Bit mask of ENDRX_STARTRX field.
	UARTE_SHORTS_ENDRX_STARTRX_Msk = 0x20
	// Bit ENDRX_STARTRX.
	UARTE_SHORTS_ENDRX_STARTRX = 0x20
	// Disable shortcut
	UARTE_SHORTS_ENDRX_STARTRX_Disabled = 0x0
	// Enable shortcut
	UARTE_SHORTS_ENDRX_STARTRX_Enabled = 0x1
	// Position of ENDRX_STOPRX field.
	UARTE_SHORTS_ENDRX_STOPRX_Pos = 0x6
	// Bit mask of ENDRX_STOPRX field.
	UARTE_SHORTS_ENDRX_STOPRX_Msk = 0x40
	// Bit ENDRX_STOPRX.
	UARTE_SHORTS_ENDRX_STOPRX = 0x40
	// Disable shortcut
	UARTE_SHORTS_ENDRX_STOPRX_Disabled = 0x0
	// Enable shortcut
	UARTE_SHORTS_ENDRX_STOPRX_Enabled = 0x1

	// INTEN: Enable or disable interrupt
	// Position of CTS field.
	UARTE_INTEN_CTS_Pos = 0x0
	// Bit mask of CTS field.
	UARTE_INTEN_CTS_Msk = 0x1
	// Bit CTS.
	UARTE_INTEN_CTS = 0x1
	// Disable
	UARTE_INTEN_CTS_Disabled = 0x0
	// Enable
	UARTE_INTEN_CTS_Enabled = 0x1
	// Position of NCTS field.
	UARTE_INTEN_NCTS_Pos = 0x1
	// Bit mask of NCTS field.
	UARTE_INTEN_NCTS_Msk = 0x2
	// Bit NCTS.
	UARTE_INTEN_NCTS = 0x2
	// Disable
	UARTE_INTEN_NCTS_Disabled = 0x0
	// Enable
	UARTE_INTEN_NCTS_Enabled = 0x1
	// Position of RXDRDY field.
	UARTE_INTEN_RXDRDY_Pos = 0x2
	// Bit mask of RXDRDY field.
	UARTE_INTEN_RXDRDY_Msk = 0x4
	// Bit RXDRDY.
	UARTE_INTEN_RXDRDY = 0x4
	// Disable
	UARTE_INTEN_RXDRDY_Disabled = 0x0
	// Enable
	UARTE_INTEN_RXDRDY_Enabled = 0x1
	// Position of ENDRX field.
	UARTE_INTEN_ENDRX_Pos = 0x4
	// Bit mask of ENDRX field.
	UARTE_INTEN_ENDRX_Msk = 0x10
	// Bit ENDRX.
	UARTE_INTEN_ENDRX = 0x10
	// Disable
	UARTE_INTEN_ENDRX_Disabled = 0x0
	// Enable
	UARTE_INTEN_ENDRX_Enabled = 0x1
	// Position of TXDRDY field.
	UARTE_INTEN_TXDRDY_Pos = 0x7
	// Bit mask of TXDRDY field.
	UARTE_INTEN_TXDRDY_Msk = 0x80
	// Bit TXDRDY.
	UARTE_INTEN_TXDRDY = 0x80
	// Disable
	UARTE_INTEN_TXDRDY_Disabled = 0x0
	// Enable
	UARTE_INTEN_TXDRDY_Enabled = 0x1
	// Position of ENDTX field.
	UARTE_INTEN_ENDTX_Pos = 0x8
	// Bit mask of ENDTX field.
	UARTE_INTEN_ENDTX_Msk = 0x100
	// Bit ENDTX.
	UARTE_INTEN_ENDTX = 0x100
	// Disable
	UARTE_INTEN_ENDTX_Disabled = 0x0
	// Enable
	UARTE_INTEN_ENDTX_Enabled = 0x1
	// Position of ERROR field.
	UARTE_INTEN_ERROR_Pos = 0x9
	// Bit mask of ERROR field.
	UARTE_INTEN_ERROR_Msk = 0x200
	// Bit ERROR.
	UARTE_INTEN_ERROR = 0x200
	// Disable
	UARTE_INTEN_ERROR_Disabled = 0x0
	// Enable
	UARTE_INTEN_ERROR_Enabled = 0x1
	// Position of RXTO field.
	UARTE_INTEN_RXTO_Pos = 0x11
	// Bit mask of RXTO field.
	UARTE_INTEN_RXTO_Msk = 0x20000
	// Bit RXTO.
	UARTE_INTEN_RXTO = 0x20000
	// Disable
	UARTE_INTEN_RXTO_Disabled = 0x0
	// Enable
	UARTE_INTEN_RXTO_Enabled = 0x1
	// Position of RXSTARTED field.
	UARTE_INTEN_RXSTARTED_Pos = 0x13
	// Bit mask of RXSTARTED field.
	UARTE_INTEN_RXSTARTED_Msk = 0x80000
	// Bit RXSTARTED.
	UARTE_INTEN_RXSTARTED = 0x80000
	// Disable
	UARTE_INTEN_RXSTARTED_Disabled = 0x0
	// Enable
	UARTE_INTEN_RXSTARTED_Enabled = 0x1
	// Position of TXSTARTED field.
	UARTE_INTEN_TXSTARTED_Pos = 0x14
	// Bit mask of TXSTARTED field.
	UARTE_INTEN_TXSTARTED_Msk = 0x100000
	// Bit TXSTARTED.
	UARTE_INTEN_TXSTARTED = 0x100000
	// Disable
	UARTE_INTEN_TXSTARTED_Disabled = 0x0
	// Enable
	UARTE_INTEN_TXSTARTED_Enabled = 0x1
	// Position of TXSTOPPED field.
	UARTE_INTEN_TXSTOPPED_Pos = 0x16
	// Bit mask of TXSTOPPED field.
	UARTE_INTEN_TXSTOPPED_Msk = 0x400000
	// Bit TXSTOPPED.
	UARTE_INTEN_TXSTOPPED = 0x400000
	// Disable
	UARTE_INTEN_TXSTOPPED_Disabled = 0x0
	// Enable
	UARTE_INTEN_TXSTOPPED_Enabled = 0x1

	// INTENSET: Enable interrupt
	// Position of CTS field.
	UARTE_INTENSET_CTS_Pos = 0x0
	// Bit mask of CTS field.
	UARTE_INTENSET_CTS_Msk = 0x1
	// Bit CTS.
	UARTE_INTENSET_CTS = 0x1
	// Read: Disabled
	UARTE_INTENSET_CTS_Disabled = 0x0
	// Read: Enabled
	UARTE_INTENSET_CTS_Enabled = 0x1
	// Enable
	UARTE_INTENSET_CTS_Set = 0x1
	// Position of NCTS field.
	UARTE_INTENSET_NCTS_Pos = 0x1
	// Bit mask of NCTS field.
	UARTE_INTENSET_NCTS_Msk = 0x2
	// Bit NCTS.
	UARTE_INTENSET_NCTS = 0x2
	// Read: Disabled
	UARTE_INTENSET_NCTS_Disabled = 0x0
	// Read: Enabled
	UARTE_INTENSET_NCTS_Enabled = 0x1
	// Enable
	UARTE_INTENSET_NCTS_Set = 0x1
	// Position of RXDRDY field.
	UARTE_INTENSET_RXDRDY_Pos = 0x2
	// Bit mask of RXDRDY field.
	UARTE_INTENSET_RXDRDY_Msk = 0x4
	// Bit RXDRDY.
	UARTE_INTENSET_RXDRDY = 0x4
	// Read: Disabled
	UARTE_INTENSET_RXDRDY_Disabled = 0x0
	// Read: Enabled
	UARTE_INTENSET_RXDRDY_Enabled = 0x1
	// Enable
	UARTE_INTENSET_RXDRDY_Set = 0x1
	// Position of ENDRX field.
	UARTE_INTENSET_ENDRX_Pos = 0x4
	// Bit mask of ENDRX field.
	UARTE_INTENSET_ENDRX_Msk = 0x10
	// Bit ENDRX.
	UARTE_INTENSET_ENDRX = 0x10
	// Read: Disabled
	UARTE_INTENSET_ENDRX_Disabled = 0x0
	// Read: Enabled
	UARTE_INTENSET_ENDRX_Enabled = 0x1
	// Enable
	UARTE_INTENSET_ENDRX_Set = 0x1
	// Position of TXDRDY field.
	UARTE_INTENSET_TXDRDY_Pos = 0x7
	// Bit mask of TXDRDY field.
	UARTE_INTENSET_TXDRDY_Msk = 0x80
	// Bit TXDRDY.
	UARTE_INTENSET_TXDRDY = 0x80
	// Read: Disabled
	UARTE_INTENSET_TXDRDY_Disabled = 0x0
	// Read: Enabled
	UARTE_INTENSET_TXDRDY_Enabled = 0x1
	// Enable
	UARTE_INTENSET_TXDRDY_Set = 0x1
	// Position of ENDTX field.
	UARTE_INTENSET_ENDTX_Pos = 0x8
	// Bit mask of ENDTX field.
	UARTE_INTENSET_ENDTX_Msk = 0x100
	// Bit ENDTX.
	UARTE_INTENSET_ENDTX = 0x100
	// Read: Disabled
	UARTE_INTENSET_ENDTX_Disabled = 0x0
	// Read: Enabled
	UARTE_INTENSET_ENDTX_Enabled = 0x1
	// Enable
	UARTE_INTENSET_ENDTX_Set = 0x1
	// Position of ERROR field.
	UARTE_INTENSET_ERROR_Pos = 0x9
	// Bit mask of ERROR field.
	UARTE_INTENSET_ERROR_Msk = 0x200
	// Bit ERROR.
	UARTE_INTENSET_ERROR = 0x200
	// Read: Disabled
	UARTE_INTENSET_ERROR_Disabled = 0x0
	// Read: Enabled
	UARTE_INTENSET_ERROR_Enabled = 0x1
	// Enable
	UARTE_INTENSET_ERROR_Set = 0x1
	// Position of RXTO field.
	UARTE_INTENSET_RXTO_Pos = 0x11
	// Bit mask of RXTO field.
	UARTE_INTENSET_RXTO_Msk = 0x20000
	// Bit RXTO.
	UARTE_INTENSET_RXTO = 0x20000
	// Read: Disabled
	UARTE_INTENSET_RXTO_Disabled = 0x0
	// Read: Enabled
	UARTE_INTENSET_RXTO_Enabled = 0x1
	// Enable
	UARTE_INTENSET_RXTO_Set = 0x1
	// Position of RXSTARTED field.
	UARTE_INTENSET_RXSTARTED_Pos = 0x13
	// Bit mask of RXSTARTED field.
	UARTE_INTENSET_RXSTARTED_Msk = 0x80000
	// Bit RXSTARTED.
	UARTE_INTENSET_RXSTARTED = 0x80000
	// Read: Disabled
	UARTE_INTENSET_RXSTARTED_Disabled = 0x0
	// Read: Enabled
	UARTE_INTENSET_RXSTARTED_Enabled = 0x1
	// Enable
	UARTE_INTENSET_RXSTARTED_Set = 0x1
	// Position of TXSTARTED field.
	UARTE_INTENSET_TXSTARTED_Pos = 0x14
	// Bit mask of TXSTARTED field.
	UARTE_INTENSET_TXSTARTED_Msk = 0x100000
	// Bit TXSTARTED.
	UARTE_INTENSET_TXSTARTED = 0x100000
	// Read: Disabled
	UARTE_INTENSET_TXSTARTED_Disabled = 0x0
	// Read: Enabled
	UARTE_INTENSET_TXSTARTED_Enabled = 0x1
	// Enable
	UARTE_INTENSET_TXSTARTED_Set = 0x1
	// Position of TXSTOPPED field.
	UARTE_INTENSET_TXSTOPPED_Pos = 0x16
	// Bit mask of TXSTOPPED field.
	UARTE_INTENSET_TXSTOPPED_Msk = 0x400000
	// Bit TXSTOPPED.
	UARTE_INTENSET_TXSTOPPED = 0x400000
	// Read: Disabled
	UARTE_INTENSET_TXSTOPPED_Disabled = 0x0
	// Read: Enabled
	UARTE_INTENSET_TXSTOPPED_Enabled = 0x1
	// Enable
	UARTE_INTENSET_TXSTOPPED_Set = 0x1

	// INTENCLR: Disable interrupt
	// Position of CTS field.
	UARTE_INTENCLR_CTS_Pos = 0x0
	// Bit mask of CTS field.
	UARTE_INTENCLR_CTS_Msk = 0x1
	// Bit CTS.
	UARTE_INTENCLR_CTS = 0x1
	// Read: Disabled
	UARTE_INTENCLR_CTS_Disabled = 0x0
	// Read: Enabled
	UARTE_INTENCLR_CTS_Enabled = 0x1
	// Disable
	UARTE_INTENCLR_CTS_Clear = 0x1
	// Position of NCTS field.
	UARTE_INTENCLR_NCTS_Pos = 0x1
	// Bit mask of NCTS field.
	UARTE_INTENCLR_NCTS_Msk = 0x2
	// Bit NCTS.
	UARTE_INTENCLR_NCTS = 0x2
	// Read: Disabled
	UARTE_INTENCLR_NCTS_Disabled = 0x0
	// Read: Enabled
	UARTE_INTENCLR_NCTS_Enabled = 0x1
	// Disable
	UARTE_INTENCLR_NCTS_Clear = 0x1
	// Position of RXDRDY field.
	UARTE_INTENCLR_RXDRDY_Pos = 0x2
	// Bit mask of RXDRDY field.
	UARTE_INTENCLR_RXDRDY_Msk = 0x4
	// Bit RXDRDY.
	UARTE_INTENCLR_RXDRDY = 0x4
	// Read: Disabled
	UARTE_INTENCLR_RXDRDY_Disabled = 0x0
	// Read: Enabled
	UARTE_INTENCLR_RXDRDY_Enabled = 0x1
	// Disable
	UARTE_INTENCLR_RXDRDY_Clear = 0x1
	// Position of ENDRX field.
	UARTE_INTENCLR_ENDRX_Pos = 0x4
	// Bit mask of ENDRX field.
	UARTE_INTENCLR_ENDRX_Msk = 0x10
	// Bit ENDRX.
	UARTE_INTENCLR_ENDRX = 0x10
	// Read: Disabled
	UARTE_INTENCLR_ENDRX_Disabled = 0x0
	// Read: Enabled
	UARTE_INTENCLR_ENDRX_Enabled = 0x1
	// Disable
	UARTE_INTENCLR_ENDRX_Clear = 0x1
	// Position of TXDRDY field.
	UARTE_INTENCLR_TXDRDY_Pos = 0x7
	// Bit mask of TXDRDY field.
	UARTE_INTENCLR_TXDRDY_Msk = 0x80
	// Bit TXDRDY.
	UARTE_INTENCLR_TXDRDY = 0x80
	// Read: Disabled
	UARTE_INTENCLR_TXDRDY_Disabled = 0x0
	// Read: Enabled
	UARTE_INTENCLR_TXDRDY_Enabled = 0x1
	// Disable
	UARTE_INTENCLR_TXDRDY_Clear = 0x1
	// Position of ENDTX field.
	UARTE_INTENCLR_ENDTX_Pos = 0x8
	// Bit mask of ENDTX field.
	UARTE_INTENCLR_ENDTX_Msk = 0x100
	// Bit ENDTX.
	UARTE_INTENCLR_ENDTX = 0x100
	// Read: Disabled
	UARTE_INTENCLR_ENDTX_Disabled = 0x0
	// Read: Enabled
	UARTE_INTENCLR_ENDTX_Enabled = 0x1
	// Disable
	UARTE_INTENCLR_ENDTX_Clear = 0x1
	// Position of ERROR field.
	UARTE_INTENCLR_ERROR_Pos = 0x9
	// Bit mask of ERROR field.
	UARTE_INTENCLR_ERROR_Msk = 0x200
	// Bit ERROR.
	UARTE_INTENCLR_ERROR = 0x200
	// Read: Disabled
	UARTE_INTENCLR_ERROR_Disabled = 0x0
	// Read: Enabled
	UARTE_INTENCLR_ERROR_Enabled = 0x1
	// Disable
	UARTE_INTENCLR_ERROR_Clear = 0x1
	// Position of RXTO field.
	UARTE_INTENCLR_RXTO_Pos = 0x11
	// Bit mask of RXTO field.
	UARTE_INTENCLR_RXTO_Msk = 0x20000
	// Bit RXTO.
	UARTE_INTENCLR_RXTO = 0x20000
	// Read: Disabled
	UARTE_INTENCLR_RXTO_Disabled = 0x0
	// Read: Enabled
	UARTE_INTENCLR_RXTO_Enabled = 0x1
	// Disable
	UARTE_INTENCLR_RXTO_Clear = 0x1
	// Position of RXSTARTED field.
	UARTE_INTENCLR_RXSTARTED_Pos = 0x13
	// Bit mask of RXSTARTED field.
	UARTE_INTENCLR_RXSTARTED_Msk = 0x80000
	// Bit RXSTARTED.
	UARTE_INTENCLR_RXSTARTED = 0x80000
	// Read: Disabled
	UARTE_INTENCLR_RXSTARTED_Disabled = 0x0
	// Read: Enabled
	UARTE_INTENCLR_RXSTARTED_Enabled = 0x1
	// Disable
	UARTE_INTENCLR_RXSTARTED_Clear = 0x1
	// Position of TXSTARTED field.
	UARTE_INTENCLR_TXSTARTED_Pos = 0x14
	// Bit mask of TXSTARTED field.
	UARTE_INTENCLR_TXSTARTED_Msk = 0x100000
	// Bit TXSTARTED.
	UARTE_INTENCLR_TXSTARTED = 0x100000
	// Read: Disabled
	UARTE_INTENCLR_TXSTARTED_Disabled = 0x0
	// Read: Enabled
	UARTE_INTENCLR_TXSTARTED_Enabled = 0x1
	// Disable
	UARTE_INTENCLR_TXSTARTED_Clear = 0x1
	// Position of TXSTOPPED field.
	UARTE_INTENCLR_TXSTOPPED_Pos = 0x16
	// Bit mask of TXSTOPPED field.
	UARTE_INTENCLR_TXSTOPPED_Msk = 0x400000
	// Bit TXSTOPPED.
	UARTE_INTENCLR_TXSTOPPED = 0x400000
	// Read: Disabled
	UARTE_INTENCLR_TXSTOPPED_Disabled = 0x0
	// Read: Enabled
	UARTE_INTENCLR_TXSTOPPED_Enabled = 0x1
	// Disable
	UARTE_INTENCLR_TXSTOPPED_Clear = 0x1

	// ERRORSRC: Error source Note : this register is read / write one to clear.
	// Position of OVERRUN field.
	UARTE_ERRORSRC_OVERRUN_Pos = 0x0
	// Bit mask of OVERRUN field.
	UARTE_ERRORSRC_OVERRUN_Msk = 0x1
	// Bit OVERRUN.
	UARTE_ERRORSRC_OVERRUN = 0x1
	// Read: error not present
	UARTE_ERRORSRC_OVERRUN_NotPresent = 0x0
	// Read: error present
	UARTE_ERRORSRC_OVERRUN_Present = 0x1
	// Position of PARITY field.
	UARTE_ERRORSRC_PARITY_Pos = 0x1
	// Bit mask of PARITY field.
	UARTE_ERRORSRC_PARITY_Msk = 0x2
	// Bit PARITY.
	UARTE_ERRORSRC_PARITY = 0x2
	// Read: error not present
	UARTE_ERRORSRC_PARITY_NotPresent = 0x0
	// Read: error present
	UARTE_ERRORSRC_PARITY_Present = 0x1
	// Position of FRAMING field.
	UARTE_ERRORSRC_FRAMING_Pos = 0x2
	// Bit mask of FRAMING field.
	UARTE_ERRORSRC_FRAMING_Msk = 0x4
	// Bit FRAMING.
	UARTE_ERRORSRC_FRAMING = 0x4
	// Read: error not present
	UARTE_ERRORSRC_FRAMING_NotPresent = 0x0
	// Read: error present
	UARTE_ERRORSRC_FRAMING_Present = 0x1
	// Position of BREAK field.
	UARTE_ERRORSRC_BREAK_Pos = 0x3
	// Bit mask of BREAK field.
	UARTE_ERRORSRC_BREAK_Msk = 0x8
	// Bit BREAK.
	UARTE_ERRORSRC_BREAK = 0x8
	// Read: error not present
	UARTE_ERRORSRC_BREAK_NotPresent = 0x0
	// Read: error present
	UARTE_ERRORSRC_BREAK_Present = 0x1

	// ENABLE: Enable UART
	// Position of ENABLE field.
	UARTE_ENABLE_ENABLE_Pos = 0x0
	// Bit mask of ENABLE field.
	UARTE_ENABLE_ENABLE_Msk = 0xf
	// Disable UARTE
	UARTE_ENABLE_ENABLE_Disabled = 0x0
	// Enable UARTE
	UARTE_ENABLE_ENABLE_Enabled = 0x8

	// PSEL.RTS: Pin select for RTS signal
	// Position of PIN field.
	UARTE_PSEL_RTS_PIN_Pos = 0x0
	// Bit mask of PIN field.
	UARTE_PSEL_RTS_PIN_Msk = 0x1f
	// Position of PORT field.
	UARTE_PSEL_RTS_PORT_Pos = 0x5
	// Bit mask of PORT field.
	UARTE_PSEL_RTS_PORT_Msk = 0x20
	// Bit PORT.
	UARTE_PSEL_RTS_PORT = 0x20
	// Position of CONNECT field.
	UARTE_PSEL_RTS_CONNECT_Pos = 0x1f
	// Bit mask of CONNECT field.
	UARTE_PSEL_RTS_CONNECT_Msk = 0x80000000
	// Bit CONNECT.
	UARTE_PSEL_RTS_CONNECT = 0x80000000
	// Disconnect
	UARTE_PSEL_RTS_CONNECT_Disconnected = 0x1
	// Connect
	UARTE_PSEL_RTS_CONNECT_Connected = 0x0

	// PSEL.TXD: Pin select for TXD signal
	// Position of PIN field.
	UARTE_PSEL_TXD_PIN_Pos = 0x0
	// Bit mask of PIN field.
	UARTE_PSEL_TXD_PIN_Msk = 0x1f
	// Position of PORT field.
	UARTE_PSEL_TXD_PORT_Pos = 0x5
	// Bit mask of PORT field.
	UARTE_PSEL_TXD_PORT_Msk = 0x20
	// Bit PORT.
	UARTE_PSEL_TXD_PORT = 0x20
	// Position of CONNECT field.
	UARTE_PSEL_TXD_CONNECT_Pos = 0x1f
	// Bit mask of CONNECT field.
	UARTE_PSEL_TXD_CONNECT_Msk = 0x80000000
	// Bit CONNECT.
	UARTE_PSEL_TXD_CONNECT = 0x80000000
	// Disconnect
	UARTE_PSEL_TXD_CONNECT_Disconnected = 0x1
	// Connect
	UARTE_PSEL_TXD_CONNECT_Connected = 0x0

	// PSEL.CTS: Pin select for CTS signal
	// Position of PIN field.
	UARTE_PSEL_CTS_PIN_Pos = 0x0
	// Bit mask of PIN field.
	UARTE_PSEL_CTS_PIN_Msk = 0x1f
	// Position of PORT field.
	UARTE_PSEL_CTS_PORT_Pos = 0x5
	// Bit mask of PORT field.
	UARTE_PSEL_CTS_PORT_Msk = 0x20
	// Bit PORT.
	UARTE_PSEL_CTS_PORT = 0x20
	// Position of CONNECT field.
	UARTE_PSEL_CTS_CONNECT_Pos = 0x1f
	// Bit mask of CONNECT field.
	UARTE_PSEL_CTS_CONNECT_Msk = 0x80000000
	// Bit CONNECT.
	UARTE_PSEL_CTS_CONNECT = 0x80000000
	// Disconnect
	UARTE_PSEL_CTS_CONNECT_Disconnected = 0x1
	// Connect
	UARTE_PSEL_CTS_CONNECT_Connected = 0x0

	// PSEL.RXD: Pin select for RXD signal
	// Position of PIN field.
	UARTE_PSEL_RXD_PIN_Pos = 0x0
	// Bit mask of PIN field.
	UARTE_PSEL_RXD_PIN_Msk = 0x1f
	// Position of PORT field.
	UARTE_PSEL_RXD_PORT_Pos = 0x5
	// Bit mask of PORT field.
	UARTE_PSEL_RXD_PORT_Msk = 0x20
	// Bit PORT.
	UARTE_PSEL_RXD_PORT = 0x20
	// Position of CONNECT field.
	UARTE_PSEL_RXD_CONNECT_Pos = 0x1f
	// Bit mask of CONNECT field.
	UARTE_PSEL_RXD_CONNECT_Msk = 0x80000000
	// Bit CONNECT.
	UARTE_PSEL_RXD_CONNECT = 0x80000000
	// Disconnect
	UARTE_PSEL_RXD_CONNECT_Disconnected = 0x1
	// Connect
	UARTE_PSEL_RXD_CONNECT_Connected = 0x0

	// BAUDRATE: Baud rate. Accuracy depends on the HFCLK source selected.
	// Position of BAUDRATE field.
	UARTE_BAUDRATE_BAUDRATE_Pos = 0x0
	// Bit mask of BAUDRATE field.
	UARTE_BAUDRATE_BAUDRATE_Msk = 0xffffffff
	// 1200 baud (actual rate: 1205)
	UARTE_BAUDRATE_BAUDRATE_Baud1200 = 0x4f000
	// 2400 baud (actual rate: 2396)
	UARTE_BAUDRATE_BAUDRATE_Baud2400 = 0x9d000
	// 4800 baud (actual rate: 4808)
	UARTE_BAUDRATE_BAUDRATE_Baud4800 = 0x13b000
	// 9600 baud (actual rate: 9598)
	UARTE_BAUDRATE_BAUDRATE_Baud9600 = 0x275000
	// 14400 baud (actual rate: 14401)
	UARTE_BAUDRATE_BAUDRATE_Baud14400 = 0x3af000
	// 19200 baud (actual rate: 19208)
	UARTE_BAUDRATE_BAUDRATE_Baud19200 = 0x4ea000
	// 28800 baud (actual rate: 28777)
	UARTE_BAUDRATE_BAUDRATE_Baud28800 = 0x75c000
	// 31250 baud
	UARTE_BAUDRATE_BAUDRATE_Baud31250 = 0x800000
	// 38400 baud (actual rate: 38369)
	UARTE_BAUDRATE_BAUDRATE_Baud38400 = 0x9d0000
	// 56000 baud (actual rate: 55944)
	UARTE_BAUDRATE_BAUDRATE_Baud56000 = 0xe50000
	// 57600 baud (actual rate: 57554)
	UARTE_BAUDRATE_BAUDRATE_Baud57600 = 0xeb0000
	// 76800 baud (actual rate: 76923)
	UARTE_BAUDRATE_BAUDRATE_Baud76800 = 0x13a9000
	// 115200 baud (actual rate: 115108)
	UARTE_BAUDRATE_BAUDRATE_Baud115200 = 0x1d60000
	// 230400 baud (actual rate: 231884)
	UARTE_BAUDRATE_BAUDRATE_Baud230400 = 0x3b00000
	// 250000 baud
	UARTE_BAUDRATE_BAUDRATE_Baud250000 = 0x4000000
	// 460800 baud (actual rate: 457143)
	UARTE_BAUDRATE_BAUDRATE_Baud460800 = 0x7400000
	// 921600 baud (actual rate: 941176)
	UARTE_BAUDRATE_BAUDRATE_Baud921600 = 0xf000000
	// 1Mega baud
	UARTE_BAUDRATE_BAUDRATE_Baud1M = 0x10000000

	// RXD.PTR: Data pointer
	// Position of PTR field.
	UARTE_RXD_PTR_PTR_Pos = 0x0
	// Bit mask of PTR field.
	UARTE_RXD_PTR_PTR_Msk = 0xffffffff

	// RXD.MAXCNT: Maximum number of bytes in receive buffer
	// Position of MAXCNT field.
	UARTE_RXD_MAXCNT_MAXCNT_Pos = 0x0
	// Bit mask of MAXCNT field.
	UARTE_RXD_MAXCNT_MAXCNT_Msk = 0xffff

	// RXD.AMOUNT: Number of bytes transferred in the last transaction
	// Position of AMOUNT field.
	UARTE_RXD_AMOUNT_AMOUNT_Pos = 0x0
	// Bit mask of AMOUNT field.
	UARTE_RXD_AMOUNT_AMOUNT_Msk = 0xffff

	// TXD.PTR: Data pointer
	// Position of PTR field.
	UARTE_TXD_PTR_PTR_Pos = 0x0
	// Bit mask of PTR field.
	UARTE_TXD_PTR_PTR_Msk = 0xffffffff

	// TXD.MAXCNT: Maximum number of bytes in transmit buffer
	// Position of MAXCNT field.
	UARTE_TXD_MAXCNT_MAXCNT_Pos = 0x0
	// Bit mask of MAXCNT field.
	UARTE_TXD_MAXCNT_MAXCNT_Msk = 0xffff

	// TXD.AMOUNT: Number of bytes transferred in the last transaction
	// Position of AMOUNT field.
	UARTE_TXD_AMOUNT_AMOUNT_Pos = 0x0
	// Bit mask of AMOUNT field.
	UARTE_TXD_AMOUNT_AMOUNT_Msk = 0xffff

	// CONFIG: Configuration of parity and hardware flow control
	// Position of HWFC field.
	UARTE_CONFIG_HWFC_Pos = 0x0
	// Bit mask of HWFC field.
	UARTE_CONFIG_HWFC_Msk = 0x1
	// Bit HWFC.
	UARTE_CONFIG_HWFC = 0x1
	// Disabled
	UARTE_CONFIG_HWFC_Disabled = 0x0
	// Enabled
	UARTE_CONFIG_HWFC_Enabled = 0x1
	// Position of PARITY field.
	UARTE_CONFIG_PARITY_Pos = 0x1
	// Bit mask of PARITY field.
	UARTE_CONFIG_PARITY_Msk = 0xe
	// Exclude parity bit
	UARTE_CONFIG_PARITY_Excluded = 0x0
	// Include even parity bit
	UARTE_CONFIG_PARITY_Included = 0x7
	// Position of STOP field.
	UARTE_CONFIG_STOP_Pos = 0x4
	// Bit mask of STOP field.
	UARTE_CONFIG_STOP_Msk = 0x10
	// Bit STOP.
	UARTE_CONFIG_STOP = 0x10
	// One stop bit
	UARTE_CONFIG_STOP_One = 0x0
	// Two stop bits
	UARTE_CONFIG_STOP_Two = 0x1
	// Position of PARITYTYPE field.
	UARTE_CONFIG_PARITYTYPE_Pos = 0x8
	// Bit mask of PARITYTYPE field.
	UARTE_CONFIG_PARITYTYPE_Msk = 0x100
	// Bit PARITYTYPE.
	UARTE_CONFIG_PARITYTYPE = 0x100
	// Even parity
	UARTE_CONFIG_PARITYTYPE_Even = 0x0
	// Odd parity
	UARTE_CONFIG_PARITYTYPE_Odd = 0x1
)

// Constants for EGU0_NS: Event generator unit
const (
	// TASKS_TRIGGER: Description collection: Trigger n for triggering the corresponding TRIGGERED[n] event
	// Position of TASKS_TRIGGER field.
	EGU_TASKS_TRIGGER_TASKS_TRIGGER_Pos = 0x0
	// Bit mask of TASKS_TRIGGER field.
	EGU_TASKS_TRIGGER_TASKS_TRIGGER_Msk = 0x1
	// Bit TASKS_TRIGGER.
	EGU_TASKS_TRIGGER_TASKS_TRIGGER = 0x1
	// Trigger task
	EGU_TASKS_TRIGGER_TASKS_TRIGGER_Trigger = 0x1

	// SUBSCRIBE_TRIGGER: Description collection: Subscribe configuration for task TRIGGER[n]
	// Position of CHIDX field.
	EGU_SUBSCRIBE_TRIGGER_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	EGU_SUBSCRIBE_TRIGGER_CHIDX_Msk = 0xff
	// Position of EN field.
	EGU_SUBSCRIBE_TRIGGER_EN_Pos = 0x1f
	// Bit mask of EN field.
	EGU_SUBSCRIBE_TRIGGER_EN_Msk = 0x80000000
	// Bit EN.
	EGU_SUBSCRIBE_TRIGGER_EN = 0x80000000
	// Disable subscription
	EGU_SUBSCRIBE_TRIGGER_EN_Disabled = 0x0
	// Enable subscription
	EGU_SUBSCRIBE_TRIGGER_EN_Enabled = 0x1

	// EVENTS_TRIGGERED: Description collection: Event number n generated by triggering the corresponding TRIGGER[n] task
	// Position of EVENTS_TRIGGERED field.
	EGU_EVENTS_TRIGGERED_EVENTS_TRIGGERED_Pos = 0x0
	// Bit mask of EVENTS_TRIGGERED field.
	EGU_EVENTS_TRIGGERED_EVENTS_TRIGGERED_Msk = 0x1
	// Bit EVENTS_TRIGGERED.
	EGU_EVENTS_TRIGGERED_EVENTS_TRIGGERED = 0x1
	// Event not generated
	EGU_EVENTS_TRIGGERED_EVENTS_TRIGGERED_NotGenerated = 0x0
	// Event generated
	EGU_EVENTS_TRIGGERED_EVENTS_TRIGGERED_Generated = 0x1

	// PUBLISH_TRIGGERED: Description collection: Publish configuration for event TRIGGERED[n]
	// Position of CHIDX field.
	EGU_PUBLISH_TRIGGERED_CHIDX_Pos = 0x0
	// Bit mask of CHIDX field.
	EGU_PUBLISH_TRIGGERED_CHIDX_Msk = 0xff
	// Position of EN field.
	EGU_PUBLISH_TRIGGERED_EN_Pos = 0x1f
	// Bit mask of EN field.
	EGU_PUBLISH_TRIGGERED_EN_Msk = 0x80000000
	// Bit EN.
	EGU_PUBLISH_TRIGGERED_EN = 0x80000000
	// Disable publishing
	EGU_PUBLISH_TRIGGERED_EN_Disabled = 0x0
	// Enable publishing
	EGU_PUBLISH_TRIGGERED_EN_Enabled = 0x1

	// INTEN: Enable or disable interrupt
	// Position of TRIGGERED0 field.
	EGU_INTEN_TRIGGERED0_Pos = 0x0
	// Bit mask of TRIGGERED0 field.
	EGU_INTEN_TRIGGERED0_Msk = 0x1
	// Bit TRIGGERED0.
	EGU_INTEN_TRIGGERED0 = 0x1
	// Disable
	EGU_INTEN_TRIGGERED0_Disabled = 0x0
	// Enable
	EGU_INTEN_TRIGGERED0_Enabled = 0x1
	// Position of TRIGGERED1 field.
	EGU_INTEN_TRIGGERED1_Pos = 0x1
	// Bit mask of TRIGGERED1 field.
	EGU_INTEN_TRIGGERED1_Msk = 0x2
	// Bit TRIGGERED1.
	EGU_INTEN_TRIGGERED1 = 0x2
	// Disable
	EGU_INTEN_TRIGGERED1_Disabled = 0x0
	// Enable
	EGU_INTEN_TRIGGERED1_Enabled = 0x1
	// Position of TRIGGERED2 field.
	EGU_INTEN_TRIGGERED2_Pos = 0x2
	// Bit mask of TRIGGERED2 field.
	EGU_INTEN_TRIGGERED2_Msk = 0x4
	// Bit TRIGGERED2.
	EGU_INTEN_TRIGGERED2 = 0x4
	// Disable
	EGU_INTEN_TRIGGERED2_Disabled = 0x0
	// Enable
	EGU_INTEN_TRIGGERED2_Enabled = 0x1
	// Position of TRIGGERED3 field.
	EGU_INTEN_TRIGGERED3_Pos = 0x3
	// Bit mask of TRIGGERED3 field.
	EGU_INTEN_TRIGGERED3_Msk = 0x8
	// Bit TRIGGERED3.
	EGU_INTEN_TRIGGERED3 = 0x8
	// Disable
	EGU_INTEN_TRIGGERED3_Disabled = 0x0
	// Enable
	EGU_INTEN_TRIGGERED3_Enabled = 0x1
	// Position of TRIGGERED4 field.
	EGU_INTEN_TRIGGERED4_Pos = 0x4
	// Bit mask of TRIGGERED4 field.
	EGU_INTEN_TRIGGERED4_Msk = 0x10
	// Bit TRIGGERED4.
	EGU_INTEN_TRIGGERED4 = 0x10
	// Disable
	EGU_INTEN_TRIGGERED4_Disabled = 0x0
	// Enable
	EGU_INTEN_TRIGGERED4_Enabled = 0x1
	// Position of TRIGGERED5 field.
	EGU_INTEN_TRIGGERED5_Pos = 0x5
	// Bit mask of TRIGGERED5 field.
	EGU_INTEN_TRIGGERED5_Msk = 0x20
	// Bit TRIGGERED5.
	EGU_INTEN_TRIGGERED5 = 0x20
	// Disable
	EGU_INTEN_TRIGGERED5_Disabled = 0x0
	// Enable
	EGU_INTEN_TRIGGERED5_Enabled = 0x1
	// Position of TRIGGERED6 field.
	EGU_INTEN_TRIGGERED6_Pos = 0x6
	// Bit mask of TRIGGERED6 field.
	EGU_INTEN_TRIGGERED6_Msk = 0x40
	// Bit TRIGGERED6.
	EGU_INTEN_TRIGGERED6 = 0x40
	// Disable
	EGU_INTEN_TRIGGERED6_Disabled = 0x0
	// Enable
	EGU_INTEN_TRIGGERED6_Enabled = 0x1
	// Position of TRIGGERED7 field.
	EGU_INTEN_TRIGGERED7_Pos = 0x7
	// Bit mask of TRIGGERED7 field.
	EGU_INTEN_TRIGGERED7_Msk = 0x80
	// Bit TRIGGERED7.
	EGU_INTEN_TRIGGERED7 = 0x80
	// Disable
	EGU_INTEN_TRIGGERED7_Disabled = 0x0
	// Enable
	EGU_INTEN_TRIGGERED7_Enabled = 0x1
	// Position of TRIGGERED8 field.
	EGU_INTEN_TRIGGERED8_Pos = 0x8
	// Bit mask of TRIGGERED8 field.
	EGU_INTEN_TRIGGERED8_Msk = 0x100
	// Bit TRIGGERED8.
	EGU_INTEN_TRIGGERED8 = 0x100
	// Disable
	EGU_INTEN_TRIGGERED8_Disabled = 0x0
	// Enable
	EGU_INTEN_TRIGGERED8_Enabled = 0x1
	// Position of TRIGGERED9 field.
	EGU_INTEN_TRIGGERED9_Pos = 0x9
	// Bit mask of TRIGGERED9 field.
	EGU_INTEN_TRIGGERED9_Msk = 0x200
	// Bit TRIGGERED9.
	EGU_INTEN_TRIGGERED9 = 0x200
	// Disable
	EGU_INTEN_TRIGGERED9_Disabled = 0x0
	// Enable
	EGU_INTEN_TRIGGERED9_Enabled = 0x1
	// Position of TRIGGERED10 field.
	EGU_INTEN_TRIGGERED10_Pos = 0xa
	// Bit mask of TRIGGERED10 field.
	EGU_INTEN_TRIGGERED10_Msk = 0x400
	// Bit TRIGGERED10.
	EGU_INTEN_TRIGGERED10 = 0x400
	// Disable
	EGU_INTEN_TRIGGERED10_Disabled = 0x0
	// Enable
	EGU_INTEN_TRIGGERED10_Enabled = 0x1
	// Position of TRIGGERED11 field.
	EGU_INTEN_TRIGGERED11_Pos = 0xb
	// Bit mask of TRIGGERED11 field.
	EGU_INTEN_TRIGGERED11_Msk = 0x800
	// Bit TRIGGERED11.
	EGU_INTEN_TRIGGERED11 = 0x800
	// Disable
	EGU_INTEN_TRIGGERED11_Disabled = 0x0
	// Enable
	EGU_INTEN_TRIGGERED11_Enabled = 0x1
	// Position of TRIGGERED12 field.
	EGU_INTEN_TRIGGERED12_Pos = 0xc
	// Bit mask of TRIGGERED12 field.
	EGU_INTEN_TRIGGERED12_Msk = 0x1000
	// Bit TRIGGERED12.
	EGU_INTEN_TRIGGERED12 = 0x1000
	// Disable
	EGU_INTEN_TRIGGERED12_Disabled = 0x0
	// Enable
	EGU_INTEN_TRIGGERED12_Enabled = 0x1
	// Position of TRIGGERED13 field.
	EGU_INTEN_TRIGGERED13_Pos = 0xd
	// Bit mask of TRIGGERED13 field.
	EGU_INTEN_TRIGGERED13_Msk = 0x2000
	// Bit TRIGGERED13.
	EGU_INTEN_TRIGGERED13 = 0x2000
	// Disable
	EGU_INTEN_TRIGGERED13_Disabled = 0x0
	// Enable
	EGU_INTEN_TRIGGERED13_Enabled = 0x1
	// Position of TRIGGERED14 field.
	EGU_INTEN_TRIGGERED14_Pos = 0xe
	// Bit mask of TRIGGERED14 field.
	EGU_INTEN_TRIGGERED14_Msk = 0x4000
	// Bit TRIGGERED14.
	EGU_INTEN_TRIGGERED14 = 0x4000
	// Disable
	EGU_INTEN_TRIGGERED14_Disabled = 0x0
	// Enable
	EGU_INTEN_TRIGGERED14_Enabled = 0x1
	// Position of TRIGGERED15 field.
	EGU_INTEN_TRIGGERED15_Pos = 0xf
	// Bit mask of TRIGGERED15 field.
	EGU_INTEN_TRIGGERED15_Msk = 0x8000
	// Bit TRIGGERED15.
	EGU_INTEN_TRIGGERED15 = 0x8000
	// Disable
	EGU_INTEN_TRIGGERED15_Disabled = 0x0
	// Enable
	EGU_INTEN_TRIGGERED15_Enabled = 0x1

	// INTENSET: Enable interrupt
	// Position of TRIGGERED0 field.
	EGU_INTENSET_TRIGGERED0_Pos = 0x0
	// Bit mask of TRIGGERED0 field.
	EGU_INTENSET_TRIGGERED0_Msk = 0x1
	// Bit TRIGGERED0.
	EGU_INTENSET_TRIGGERED0 = 0x1
	// Read: Disabled
	EGU_INTENSET_TRIGGERED0_Disabled = 0x0
	// Read: Enabled
	EGU_INTENSET_TRIGGERED0_Enabled = 0x1
	// Enable
	EGU_INTENSET_TRIGGERED0_Set = 0x1
	// Position of TRIGGERED1 field.
	EGU_INTENSET_TRIGGERED1_Pos = 0x1
	// Bit mask of TRIGGERED1 field.
	EGU_INTENSET_TRIGGERED1_Msk = 0x2
	// Bit TRIGGERED1.
	EGU_INTENSET_TRIGGERED1 = 0x2
	// Read: Disabled
	EGU_INTENSET_TRIGGERED1_Disabled = 0x0
	// Read: Enabled
	EGU_INTENSET_TRIGGERED1_Enabled = 0x1
	// Enable
	EGU_INTENSET_TRIGGERED1_Set = 0x1
	// Position of TRIGGERED2 field.
	EGU_INTENSET_TRIGGERED2_Pos = 0x2
	// Bit mask of TRIGGERED2 field.
	EGU_INTENSET_TRIGGERED2_Msk = 0x4
	// Bit TRIGGERED2.
	EGU_INTENSET_TRIGGERED2 = 0x4
	// Read: Disabled
	EGU_INTENSET_TRIGGERED2_Disabled = 0x0
	// Read: Enabled
	EGU_INTENSET_TRIGGERED2_Enabled = 0x1
	// Enable
	EGU_INTENSET_TRIGGERED2_Set = 0x1
	// Position of TRIGGERED3 field.
	EGU_INTENSET_TRIGGERED3_Pos = 0x3
	// Bit mask of TRIGGERED3 field.
	EGU_INTENSET_TRIGGERED3_Msk = 0x8
	// Bit TRIGGERED3.
	EGU_INTENSET_TRIGGERED3 = 0x8
	// Read: Disabled
	EGU_INTENSET_TRIGGERED3_Disabled = 0x0
	// Read: Enabled
	EGU_INTENSET_TRIGGERED3_Enabled = 0x1
	// Enable
	EGU_INTENSET_TRIGGERED3_Set = 0x1
	// Position of TRIGGERED4 field.
	EGU_INTENSET_TRIGGERED4_Pos = 0x4
	// Bit mask of TRIGGERED4 field.
	EGU_INTENSET_TRIGGERED4_Msk = 0x10
	// Bit TRIGGERED4.
	EGU_INTENSET_TRIGGERED4 = 0x10
	// Read: Disabled
	EGU_INTENSET_TRIGGERED4_Disabled = 0x0
	// Read: Enabled
	EGU_INTENSET_TRIGGERED4_Enabled = 0x1
	// Enable
	EGU_INTENSET_TRIGGERED4_Set = 0x1
	// Position of TRIGGERED5 field.
	EGU_INTENSET_TRIGGERED5_Pos = 0x5
	// Bit mask of TRIGGERED5 field.
	EGU_INTENSET_TRIGGERED5_Msk = 0x20
	// Bit TRIGGERED5.
	EGU_INTENSET_TRIGGERED5 = 0x20
	// Read: Disabled
	EGU_INTENSET_TRIGGERED5_Disabled = 0x0
	// Read: Enabled
	EGU_INTENSET_TRIGGERED5_Enabled = 0x1
	// Enable
	EGU_INTENSET_TRIGGERED5_Set = 0x1
	// Position of TRIGGERED6 field.
	EGU_INTENSET_TRIGGERED6_Pos = 0x6
	// Bit mask of TRIGGERED6 field.
	EGU_INTENSET_TRIGGERED6_Msk = 0x40
	// Bit TRIGGERED6.
	EGU_INTENSET_TRIGGERED6 = 0x40
	// Read: Disabled
	EGU_INTENSET_TRIGGERED6_Disabled = 0x0
	// Read: Enabled
	EGU_INTENSET_TRIGGERED6_Enabled = 0x1
	// Enable
	EGU_INTENSET_TRIGGERED6_Set = 0x1
	// Position of TRIGGERED7 field.
	EGU_INTENSET_TRIGGERED7_Pos = 0x7
	// Bit mask of TRIGGERED7 field.
	EGU_INTENSET_TRIGGERED7_Msk = 0x80
	// Bit TRIGGERED7.
	EGU_INTENSET_TRIGGERED7 = 0x80
	// Read: Disabled
	EGU_INTENSET_TRIGGERED7_Disabled = 0x0
	// Read: Enabled
	EGU_INTENSET_TRIGGERED7_Enabled = 0x1
	// Enable
	EGU_INTENSET_TRIGGERED7_Set = 0x1
	// Position of TRIGGERED8 field.
	EGU_INTENSET_TRIGGERED8_Pos = 0x8
	// Bit mask of TRIGGERED8 field.
	EGU_INTENSET_TRIGGERED8_Msk = 0x100
	// Bit TRIGGERED8.
	EGU_INTENSET_TRIGGERED8 = 0x100
	// Read: Disabled
	EGU_INTENSET_TRIGGERED8_Disabled = 0x0
	// Read: Enabled
	EGU_INTENSET_TRIGGERED8_Enabled = 0x1
	// Enable
	EGU_INTENSET_TRIGGERED8_Set = 0x1
	// Position of TRIGGERED9 field.
	EGU_INTENSET_TRIGGERED9_Pos = 0x9
	// Bit mask of TRIGGERED9 field.
	EGU_INTENSET_TRIGGERED9_Msk = 0x200
	// Bit TRIGGERED9.
	EGU_INTENSET_TRIGGERED9 = 0x200
	// Read: Disabled
	EGU_INTENSET_TRIGGERED9_Disabled = 0x0
	// Read: Enabled
	EGU_INTENSET_TRIGGERED9_Enabled = 0x1
	// Enable
	EGU_INTENSET_TRIGGERED9_Set = 0x1
	// Position of TRIGGERED10 field.
	EGU_INTENSET_TRIGGERED10_Pos = 0xa
	// Bit mask of TRIGGERED10 field.
	EGU_INTENSET_TRIGGERED10_Msk = 0x400
	// Bit TRIGGERED10.
	EGU_INTENSET_TRIGGERED10 = 0x400
	// Read: Disabled
	EGU_INTENSET_TRIGGERED10_Disabled = 0x0
	// Read: Enabled
	EGU_INTENSET_TRIGGERED10_Enabled = 0x1
	// Enable
	EGU_INTENSET_TRIGGERED10_Set = 0x1
	// Position of TRIGGERED11 field.
	EGU_INTENSET_TRIGGERED11_Pos = 0xb
	// Bit mask of TRIGGERED11 field.
	EGU_INTENSET_TRIGGERED11_Msk = 0x800
	// Bit TRIGGERED11.
	EGU_INTENSET_TRIGGERED11 = 0x800
	// Read: Disabled
	EGU_INTENSET_TRIGGERED11_Disabled = 0x0
	// Read: Enabled
	EGU_INTENSET_TRIGGERED11_Enabled = 0x1
	// Enable
	EGU_INTENSET_TRIGGERED11_Set = 0x1
	// Position of TRIGGERED12 field.
	EGU_INTENSET_TRIGGERED12_Pos = 0xc
	// Bit mask of TRIGGERED12 field.
	EGU_INTENSET_TRIGGERED12_Msk = 0x1000
	// Bit TRIGGERED12.
	EGU_INTENSET_TRIGGERED12 = 0x1000
	// Read: Disabled
	EGU_INTENSET_TRIGGERED12_Disabled = 0x0
	// Read: Enabled
	EGU_INTENSET_TRIGGERED12_Enabled = 0x1
	// Enable
	EGU_INTENSET_TRIGGERED12_Set = 0x1
	// Position of TRIGGERED13 field.
	EGU_INTENSET_TRIGGERED13_Pos = 0xd
	// Bit mask of TRIGGERED13 field.
	EGU_INTENSET_TRIGGERED13_Msk = 0x2000
	// Bit TRIGGERED13.
	EGU_INTENSET_TRIGGERED13 = 0x2000
	// Read: Disabled
	EGU_INTENSET_TRIGGERED13_Disabled = 0x0
	// Read: Enabled
	EGU_INTENSET_TRIGGERED13_Enabled = 0x1
	// Enable
	EGU_INTENSET_TRIGGERED13_Set = 0x1
	// Position of TRIGGERED14 field.
	EGU_INTENSET_TRIGGERED14_Pos = 0xe
	// Bit mask of TRIGGERED14 field.
	EGU_INTENSET_TRIGGERED14_Msk = 0x4000
	// Bit TRIGGERED14.
	EGU_INTENSET_TRIGGERED14 = 0x4000
	// Read: Disabled
	EGU_INTENSET_TRIGGERED14_Disabled = 0x0
	// Read: Enabled
	EGU_INTENSET_TRIGGERED14_Enabled = 0x1
	// Enable
	EGU_INTENSET_TRIGGERED14_Set = 0x1
	// Position of TRIGGERED15 field.
	EGU_INTENSET_TRIGGERED15_Pos = 0xf
	// Bit mask of TRIGGERED15 field.
	EGU_INTENSET_TRIGGERED15_Msk = 0x8000
	// Bit TRIGGERED15.
	EGU_INTENSET_TRIGGERED15 = 0x8000
	// Read: Disabled
	EGU_INTENSET_TRIGGERED15_Disabled = 0x0
	// Read: Enabled
	EGU_INTENSET_TRIGGERED15_Enabled = 0x1
	// Enable
	EGU_INTENSET_TRIGGERED15_Set = 0x1

	// INTENCLR: Disable interrupt
	// Position of TRIGGERED0 field.
	EGU_INTENCLR_TRIGGERED0_Pos = 0x0
	// Bit mask of TRIGGERED0 field.
	EGU_INTENCLR_TRIGGERED0_Msk = 0x1
	// Bit TRIGGERED0.
	EGU_INTENCLR_TRIGGERED0 = 0x1
	// Read: Disabled
	EGU_INTENCLR_TRIGGERED0_Disabled = 0x0
	// Read: Enabled
	EGU_INTENCLR_TRIGGERED0_Enabled = 0x1
	// Disable
	EGU_INTENCLR_TRIGGERED0_Clear = 0x1
	// Position of TRIGGERED1 field.
	EGU_INTENCLR_TRIGGERED1_Pos = 0x1
	// Bit mask of TRIGGERED1 field.
	EGU_INTENCLR_TRIGGERED1_Msk = 0x2
	// Bit TRIGGERED1.
	EGU_INTENCLR_TRIGGERED1 = 0x2
	// Read: Disabled
	EGU_INTENCLR_TRIGGERED1_Disabled = 0x0
	// Read: Enabled
	EGU_INTENCLR_TRIGGERED1_Enabled = 0x1
	// Disable
	EGU_INTENCLR_TRIGGERED1_Clear = 0x1
	// Position of TRIGGERED2 field.
	EGU_INTENCLR_TRIGGERED2_Pos = 0x2
	// Bit mask of TRIGGERED2 field.
	EGU_INTENCLR_TRIGGERED2_Msk = 0x4
	// Bit TRIGGERED2.
	EGU_INTENCLR_TRIGGERED2 = 0x4
	// Read: Disabled
	EGU_INTENCLR_TRIGGERED2_Disabled = 0x0
	// Read: Enabled
	EGU_INTENCLR_TRIGGERED2_Enabled = 0x1
	// Disable
	EGU_INTENCLR_TRIGGERED2_Clear = 0x1
	// Position of TRIGGERED3 field.
	EGU_INTENCLR_TRIGGERED3_Pos = 0x3
	// Bit mask of TRIGGERED3 field.
	EGU_INTENCLR_TRIGGERED3_Msk = 0x8
	// Bit TRIGGERED3.
	EGU_INTENCLR_TRIGGERED3 = 0x8
	// Read: Disabled
	EGU_INTENCLR_TRIGGERED3_Disabled = 0x0
	// Read: Enabled
	EGU_INTENCLR_TRIGGERED3_Enabled = 0x1
	// Disable
	EGU_INTENCLR_TRIGGERED3_Clear = 0x1
	// Position of TRIGGERED4 field.
	EGU_INTENCLR_TRIGGERED4_Pos = 0x4
	// Bit mask of TRIGGERED4 field.
	EGU_INTENCLR_TRIGGERED4_Msk = 0x10
	// Bit TRIGGERED4.
	EGU_INTENCLR_TRIGGERED4 = 0x10
	// Read: Disabled
	EGU_INTENCLR_TRIGGERED4_Disabled = 0x0
	// Read: Enabled
	EGU_INTENCLR_TRIGGERED4_Enabled = 0x1
	// Disable
	EGU_INTENCLR_TRIGGERED4_Clear = 0x1
	// Position of TRIGGERED5 field.
	EGU_INTENCLR_TRIGGERED5_Pos = 0x5
	// Bit mask of TRIGGERED5 field.
	EGU_INTENCLR_TRIGGERED5_Msk = 0x20
	// Bit TRIGGERED5.
	EGU_INTENCLR_TRIGGERED5 = 0x20
	// Read: Disabled
	EGU_INTENCLR_TRIGGERED5_Disabled = 0x0
	// Read: Enabled
	EGU_INTENCLR_TRIGGERED5_Enabled = 0x1
	// Disable
	EGU_INTENCLR_TRIGGERED5_Clear = 0x1
	// Position of TRIGGERED6 field.
	EGU_INTENCLR_TRIGGERED6_Pos = 0x6
	// Bit mask of TRIGGERED6 field.
	EGU_INTENCLR_TRIGGERED6_Msk = 0x40
	// Bit TRIGGERED6.
	EGU_INTENCLR_TRIGGERED6 = 0x40
	// Read: Disabled
	EGU_INTENCLR_TRIGGERED6_Disabled = 0x0
	// Read: Enabled
	EGU_INTENCLR_TRIGGERED6_Enabled = 0x1
	// Disable
	EGU_INTENCLR_TRIGGERED6_Clear = 0x1
	// Position of TRIGGERED7 field.
	EGU_INTENCLR_TRIGGERED7_Pos = 0x7
	// Bit mask of TRIGGERED7 field.
	EGU_INTENCLR_TRIGGERED7_Msk = 0x80
	// Bit TRIGGERED7.
	EGU_INTENCLR_TRIGGERED7 = 0x80
	// Read: Disabled
	EGU_INTENCLR_TRIGGERED7_Disabled = 0x0
	// Read: Enabled
	EGU_INTENCLR_TRIGGERED7_Enabled = 0x1
	// Disable
	EGU_INTENCLR_TRIGGERED7_Clear = 0x1
	// Position of TRIGGERED8 field.
	EGU_INTENCLR_TRIGGERED8_Pos = 0x8
	// Bit mask of TRIGGERED8 field.
	EGU_INTENCLR_TRIGGERED8_Msk = 0x100
	// Bit TRIGGERED8.
	EGU_INTENCLR_TRIGGERED8 = 0x100
	// Read: Disabled
	EGU_INTENCLR_TRIGGERED8_Disabled = 0x0
	// Read: Enabled
	EGU_INTENCLR_TRIGGERED8_Enabled = 0x1
	// Disable
	EGU_INTENCLR_TRIGGERED8_Clear = 0x1
	// Position of TRIGGERED9 field.
	EGU_INTENCLR_TRIGGERED9_Pos = 0x9
	// Bit mask of TRIGGERED9 field.
	EGU_INTENCLR_TRIGGERED9_Msk = 0x200
	// Bit TRIGGERED9.
	EGU_INTENCLR_TRIGGERED9 = 0x200
	// Read: Disabled
	EGU_INTENCLR_TRIGGERED9_Disabled = 0x0
	// Read: Enabled
	EGU_INTENCLR_TRIGGERED9_Enabled = 0x1
	// Disable
	EGU_INTENCLR_TRIGGERED9_Clear = 0x1
	// Position of TRIGGERED10 field.
	EGU_INTENCLR_TRIGGERED10_Pos = 0xa
	// Bit mask of TRIGGERED10 field.
	EGU_INTENCLR_TRIGGERED10_Msk = 0x400
	// Bit TRIGGERED10.
	EGU_INTENCLR_TRIGGERED10 = 0x400
	// Read: Disabled
	EGU_INTENCLR_TRIGGERED10_Disabled = 0x0
	// Read: Enabled
	EGU_INTENCLR_TRIGGERED10_Enabled = 0x1
	// Disable
	EGU_INTENCLR_TRIGGERED10_Clear = 0x1
	// Position of TRIGGERED11 field.
	EGU_INTENCLR_TRIGGERED11_Pos = 0xb
	// Bit mask of TRIGGERED11 field.
	EGU_INTENCLR_TRIGGERED11_Msk = 0x800
	// Bit TRIGGERED11.
	EGU_INTENCLR_TRIGGERED11 = 0x800
	// Read: Disabled
	EGU_INTENCLR_TRIGGERED11_Disabled = 0x0
	// Read: Enabled
	EGU_INTENCLR_TRIGGERED11_Enabled = 0x1
	// Disable
	EGU_INTENCLR_TRIGGERED11_Clear = 0x1
	// Position of TRIGGERED12 field.
	EGU_INTENCLR_TRIGGERED12_Pos = 0xc
	// Bit mask of TRIGGERED12 field.
	EGU_INTENCLR_TRIGGERED12_Msk = 0x1000
	// Bit TRIGGERED12.
	EGU_INTENCLR_TRIGGERED12 = 0x1000
	// Read: Disabled
	EGU_INTENCLR_TRIGGERED12_Disabled = 0x0
	// Read: Enabled
	EGU_INTENCLR_TRIGGERED12_Enabled = 0x1
	// Disable
	EGU_INTENCLR_TRIGGERED12_Clear = 0x1
	// Position of TRIGGERED13 field.
	EGU_INTENCLR_TRIGGERED13_Pos = 0xd
	// Bit mask of TRIGGERED13 field.
	EGU_INTENCLR_TRIGGERED13_Msk = 0x2000
	// Bit TRIGGERED13.
	EGU_INTENCLR_TRIGGERED13 = 0x2000
	// Read: Disabled
	EGU_INTENCLR_TRIGGERED13_Disabled = 0x0
	// Read: Enabled
	EGU_INTENCLR_TRIGGERED13_Enabled = 0x1
	// Disable
	EGU_INTENCLR_TRIGGERED13_Clear = 0x1
	// Position of TRIGGERED14 field.
	EGU_INTENCLR_TRIGGERED14_Pos = 0xe
	// Bit mask of TRIGGERED14 field.
	EGU_INTENCLR_TRIGGERED14_Msk = 0x4000
	// Bit TRIGGERED14.
	EGU_INTENCLR_TRIGGERED14 = 0x4000
	// Read: Disabled
	EGU_INTENCLR_TRIGGERED14_Disabled = 0x0
	// Read: Enabled
	EGU_INTENCLR_TRIGGERED14_Enabled = 0x1
	// Disable
	EGU_INTENCLR_TRIGGERED14_Clear = 0x1
	// Position of TRIGGERED15 field.
	EGU_INTENCLR_TRIGGERED15_Pos = 0xf
	// Bit mask of TRIGGERED15 field.
	EGU_INTENCLR_TRIGGERED15_Msk = 0x8000
	// Bit TRIGGERED15.
	EGU_INTENCLR_TRIGGERED15 = 0x8000
	// Read: Disabled
	EGU_INTENCLR_TRIGGERED15_Disabled = 0x0
	// Read: Enabled
	EGU_INTENCLR_TRIGGERED15_Enabled = 0x1
	// Disable
	EGU_INTENCLR_TRIGGERED15_Clear = 0x1
)

// Constants for SWI0_NS: Software interrupt 0
const ()

// Constants for APPMUTEX_NS: MUTEX 0
const (
	// MUTEX: Description collection: Mutex register
	// Position of MUTEX field.
	MUTEX_MUTEX_MUTEX_Pos = 0x0
	// Bit mask of MUTEX field.
	MUTEX_MUTEX_MUTEX_Msk = 0x1
	// Bit MUTEX.
	MUTEX_MUTEX_MUTEX = 0x1
	// Mutex n is in unlocked state
	MUTEX_MUTEX_MUTEX_Unlocked = 0x0
	// Mutex n is in locked state
	MUTEX_MUTEX_MUTEX_Locked = 0x1
)

// Constants for ACL_NS: Access control lists
const (
	// ACL.ADDR: Description cluster: Configure the word-aligned start address of region n to protect
	// Position of ADDR field.
	ACL_ACL_ADDR_ADDR_Pos = 0x0
	// Bit mask of ADDR field.
	ACL_ACL_ADDR_ADDR_Msk = 0xffffffff

	// ACL.SIZE: Description cluster: Size of region to protect counting from address ACL[n].ADDR. Write '0' as no effect.
	// Position of SIZE field.
	ACL_ACL_SIZE_SIZE_Pos = 0x0
	// Bit mask of SIZE field.
	ACL_ACL_SIZE_SIZE_Msk = 0xffffffff

	// ACL.PERM: Description cluster: Access permissions for region n as defined by start address ACL[n].ADDR and size ACL[n].SIZE
	// Position of WRITE field.
	ACL_ACL_PERM_WRITE_Pos = 0x1
	// Bit mask of WRITE field.
	ACL_ACL_PERM_WRITE_Msk = 0x2
	// Bit WRITE.
	ACL_ACL_PERM_WRITE = 0x2
	// Allow write and erase instructions to region n
	ACL_ACL_PERM_WRITE_Enable = 0x0
	// Block write and erase instructions to region n
	ACL_ACL_PERM_WRITE_Disable = 0x1
	// Position of READ field.
	ACL_ACL_PERM_READ_Pos = 0x2
	// Bit mask of READ field.
	ACL_ACL_PERM_READ_Msk = 0x4
	// Bit READ.
	ACL_ACL_PERM_READ = 0x4
	// Allow read instructions to region n
	ACL_ACL_PERM_READ_Enable = 0x0
	// Block read instructions to region n
	ACL_ACL_PERM_READ_Disable = 0x1
)

// Constants for NVMC_NS: Non-volatile memory controller
const (
	// READY: Ready flag
	// Position of READY field.
	NVMC_READY_READY_Pos = 0x0
	// Bit mask of READY field.
	NVMC_READY_READY_Msk = 0x1
	// Bit READY.
	NVMC_READY_READY = 0x1
	// NVMC is busy (on-going write or erase operation)
	NVMC_READY_READY_Busy = 0x0
	// NVMC is ready
	NVMC_READY_READY_Ready = 0x1

	// READYNEXT: Ready flag
	// Position of READYNEXT field.
	NVMC_READYNEXT_READYNEXT_Pos = 0x0
	// Bit mask of READYNEXT field.
	NVMC_READYNEXT_READYNEXT_Msk = 0x1
	// Bit READYNEXT.
	NVMC_READYNEXT_READYNEXT = 0x1
	// NVMC cannot accept any write operation
	NVMC_READYNEXT_READYNEXT_Busy = 0x0
	// NVMC is ready
	NVMC_READYNEXT_READYNEXT_Ready = 0x1

	// CONFIG: Configuration register
	// Position of WEN field.
	NVMC_CONFIG_WEN_Pos = 0x0
	// Bit mask of WEN field.
	NVMC_CONFIG_WEN_Msk = 0x7
	// Read only access
	NVMC_CONFIG_WEN_Ren = 0x0
	// Write enabled
	NVMC_CONFIG_WEN_Wen = 0x1
	// Erase enabled
	NVMC_CONFIG_WEN_Een = 0x2
	// Partial erase enabled
	NVMC_CONFIG_WEN_PEen = 0x4

	// ERASEALL: Register for erasing all non-volatile user memory
	// Position of ERASEALL field.
	NVMC_ERASEALL_ERASEALL_Pos = 0x0
	// Bit mask of ERASEALL field.
	NVMC_ERASEALL_ERASEALL_Msk = 0x1
	// Bit ERASEALL.
	NVMC_ERASEALL_ERASEALL = 0x1
	// No operation
	NVMC_ERASEALL_ERASEALL_NoOperation = 0x0
	// Start chip erase
	NVMC_ERASEALL_ERASEALL_Erase = 0x1

	// ERASEPAGEPARTIALCFG: Register for partial erase configuration
	// Position of DURATION field.
	NVMC_ERASEPAGEPARTIALCFG_DURATION_Pos = 0x0
	// Bit mask of DURATION field.
	NVMC_ERASEPAGEPARTIALCFG_DURATION_Msk = 0x7f

	// ICACHECNF: I-code cache configuration register
	// Position of CACHEEN field.
	NVMC_ICACHECNF_CACHEEN_Pos = 0x0
	// Bit mask of CACHEEN field.
	NVMC_ICACHECNF_CACHEEN_Msk = 0x1
	// Bit CACHEEN.
	NVMC_ICACHECNF_CACHEEN = 0x1
	// Disable cache. Invalidates all cache entries.
	NVMC_ICACHECNF_CACHEEN_Disabled = 0x0
	// Enable cache
	NVMC_ICACHECNF_CACHEEN_Enabled = 0x1
	// Position of CACHEPROFEN field.
	NVMC_ICACHECNF_CACHEPROFEN_Pos = 0x8
	// Bit mask of CACHEPROFEN field.
	NVMC_ICACHECNF_CACHEPROFEN_Msk = 0x100
	// Bit CACHEPROFEN.
	NVMC_ICACHECNF_CACHEPROFEN = 0x100
	// Disable cache profiling
	NVMC_ICACHECNF_CACHEPROFEN_Disabled = 0x0
	// Enable cache profiling
	NVMC_ICACHECNF_CACHEPROFEN_Enabled = 0x1

	// IHIT: I-code cache hit counter
	// Position of HITS field.
	NVMC_IHIT_HITS_Pos = 0x0
	// Bit mask of HITS field.
	NVMC_IHIT_HITS_Msk = 0xffffffff

	// IMISS: I-code cache miss counter
	// Position of MISSES field.
	NVMC_IMISS_MISSES_Pos = 0x0
	// Bit mask of MISSES field.
	NVMC_IMISS_MISSES_Msk = 0xffffffff
)

// Constants for VMC_NS: Volatile Memory controller
const (
	// RAM.POWER: Description cluster: RAM[n] power control register
	// Position of S0POWER field.
	VMC_RAM_POWER_S0POWER_Pos = 0x0
	// Bit mask of S0POWER field.
	VMC_RAM_POWER_S0POWER_Msk = 0x1
	// Bit S0POWER.
	VMC_RAM_POWER_S0POWER = 0x1
	// Off
	VMC_RAM_POWER_S0POWER_Off = 0x0
	// On
	VMC_RAM_POWER_S0POWER_On = 0x1
	// Position of S1POWER field.
	VMC_RAM_POWER_S1POWER_Pos = 0x1
	// Bit mask of S1POWER field.
	VMC_RAM_POWER_S1POWER_Msk = 0x2
	// Bit S1POWER.
	VMC_RAM_POWER_S1POWER = 0x2
	// Off
	VMC_RAM_POWER_S1POWER_Off = 0x0
	// On
	VMC_RAM_POWER_S1POWER_On = 0x1
	// Position of S2POWER field.
	VMC_RAM_POWER_S2POWER_Pos = 0x2
	// Bit mask of S2POWER field.
	VMC_RAM_POWER_S2POWER_Msk = 0x4
	// Bit S2POWER.
	VMC_RAM_POWER_S2POWER = 0x4
	// Off
	VMC_RAM_POWER_S2POWER_Off = 0x0
	// On
	VMC_RAM_POWER_S2POWER_On = 0x1
	// Position of S3POWER field.
	VMC_RAM_POWER_S3POWER_Pos = 0x3
	// Bit mask of S3POWER field.
	VMC_RAM_POWER_S3POWER_Msk = 0x8
	// Bit S3POWER.
	VMC_RAM_POWER_S3POWER = 0x8
	// Off
	VMC_RAM_POWER_S3POWER_Off = 0x0
	// On
	VMC_RAM_POWER_S3POWER_On = 0x1
	// Position of S0RETENTION field.
	VMC_RAM_POWER_S0RETENTION_Pos = 0x10
	// Bit mask of S0RETENTION field.
	VMC_RAM_POWER_S0RETENTION_Msk = 0x10000
	// Bit S0RETENTION.
	VMC_RAM_POWER_S0RETENTION = 0x10000
	// Off
	VMC_RAM_POWER_S0RETENTION_Off = 0x0
	// On
	VMC_RAM_POWER_S0RETENTION_On = 0x1
	// Position of S1RETENTION field.
	VMC_RAM_POWER_S1RETENTION_Pos = 0x11
	// Bit mask of S1RETENTION field.
	VMC_RAM_POWER_S1RETENTION_Msk = 0x20000
	// Bit S1RETENTION.
	VMC_RAM_POWER_S1RETENTION = 0x20000
	// Off
	VMC_RAM_POWER_S1RETENTION_Off = 0x0
	// On
	VMC_RAM_POWER_S1RETENTION_On = 0x1
	// Position of S2RETENTION field.
	VMC_RAM_POWER_S2RETENTION_Pos = 0x12
	// Bit mask of S2RETENTION field.
	VMC_RAM_POWER_S2RETENTION_Msk = 0x40000
	// Bit S2RETENTION.
	VMC_RAM_POWER_S2RETENTION = 0x40000
	// Off
	VMC_RAM_POWER_S2RETENTION_Off = 0x0
	// On
	VMC_RAM_POWER_S2RETENTION_On = 0x1
	// Position of S3RETENTION field.
	VMC_RAM_POWER_S3RETENTION_Pos = 0x13
	// Bit mask of S3RETENTION field.
	VMC_RAM_POWER_S3RETENTION_Msk = 0x80000
	// Bit S3RETENTION.
	VMC_RAM_POWER_S3RETENTION = 0x80000
	// Off
	VMC_RAM_POWER_S3RETENTION_Off = 0x0
	// On
	VMC_RAM_POWER_S3RETENTION_On = 0x1

	// RAM.POWERSET: Description cluster: RAM[n] power control set register
	// Position of S0POWER field.
	VMC_RAM_POWERSET_S0POWER_Pos = 0x0
	// Bit mask of S0POWER field.
	VMC_RAM_POWERSET_S0POWER_Msk = 0x1
	// Bit S0POWER.
	VMC_RAM_POWERSET_S0POWER = 0x1
	// On
	VMC_RAM_POWERSET_S0POWER_On = 0x1
	// Position of S1POWER field.
	VMC_RAM_POWERSET_S1POWER_Pos = 0x1
	// Bit mask of S1POWER field.
	VMC_RAM_POWERSET_S1POWER_Msk = 0x2
	// Bit S1POWER.
	VMC_RAM_POWERSET_S1POWER = 0x2
	// On
	VMC_RAM_POWERSET_S1POWER_On = 0x1
	// Position of S2POWER field.
	VMC_RAM_POWERSET_S2POWER_Pos = 0x2
	// Bit mask of S2POWER field.
	VMC_RAM_POWERSET_S2POWER_Msk = 0x4
	// Bit S2POWER.
	VMC_RAM_POWERSET_S2POWER = 0x4
	// On
	VMC_RAM_POWERSET_S2POWER_On = 0x1
	// Position of S3POWER field.
	VMC_RAM_POWERSET_S3POWER_Pos = 0x3
	// Bit mask of S3POWER field.
	VMC_RAM_POWERSET_S3POWER_Msk = 0x8
	// Bit S3POWER.
	VMC_RAM_POWERSET_S3POWER = 0x8
	// On
	VMC_RAM_POWERSET_S3POWER_On = 0x1
	// Position of S0RETENTION field.
	VMC_RAM_POWERSET_S0RETENTION_Pos = 0x10
	// Bit mask of S0RETENTION field.
	VMC_RAM_POWERSET_S0RETENTION_Msk = 0x10000
	// Bit S0RETENTION.
	VMC_RAM_POWERSET_S0RETENTION = 0x10000
	// On
	VMC_RAM_POWERSET_S0RETENTION_On = 0x1
	// Position of S1RETENTION field.
	VMC_RAM_POWERSET_S1RETENTION_Pos = 0x11
	// Bit mask of S1RETENTION field.
	VMC_RAM_POWERSET_S1RETENTION_Msk = 0x20000
	// Bit S1RETENTION.
	VMC_RAM_POWERSET_S1RETENTION = 0x20000
	// On
	VMC_RAM_POWERSET_S1RETENTION_On = 0x1
	// Position of S2RETENTION field.
	VMC_RAM_POWERSET_S2RETENTION_Pos = 0x12
	// Bit mask of S2RETENTION field.
	VMC_RAM_POWERSET_S2RETENTION_Msk = 0x40000
	// Bit S2RETENTION.
	VMC_RAM_POWERSET_S2RETENTION = 0x40000
	// On
	VMC_RAM_POWERSET_S2RETENTION_On = 0x1
	// Position of S3RETENTION field.
	VMC_RAM_POWERSET_S3RETENTION_Pos = 0x13
	// Bit mask of S3RETENTION field.
	VMC_RAM_POWERSET_S3RETENTION_Msk = 0x80000
	// Bit S3RETENTION.
	VMC_RAM_POWERSET_S3RETENTION = 0x80000
	// On
	VMC_RAM_POWERSET_S3RETENTION_On = 0x1

	// RAM.POWERCLR: Description cluster: RAM[n] power control clear register
	// Position of S0POWER field.
	VMC_RAM_POWERCLR_S0POWER_Pos = 0x0
	// Bit mask of S0POWER field.
	VMC_RAM_POWERCLR_S0POWER_Msk = 0x1
	// Bit S0POWER.
	VMC_RAM_POWERCLR_S0POWER = 0x1
	// Off
	VMC_RAM_POWERCLR_S0POWER_Off = 0x1
	// Position of S1POWER field.
	VMC_RAM_POWERCLR_S1POWER_Pos = 0x1
	// Bit mask of S1POWER field.
	VMC_RAM_POWERCLR_S1POWER_Msk = 0x2
	// Bit S1POWER.
	VMC_RAM_POWERCLR_S1POWER = 0x2
	// Off
	VMC_RAM_POWERCLR_S1POWER_Off = 0x1
	// Position of S2POWER field.
	VMC_RAM_POWERCLR_S2POWER_Pos = 0x2
	// Bit mask of S2POWER field.
	VMC_RAM_POWERCLR_S2POWER_Msk = 0x4
	// Bit S2POWER.
	VMC_RAM_POWERCLR_S2POWER = 0x4
	// Off
	VMC_RAM_POWERCLR_S2POWER_Off = 0x1
	// Position of S3POWER field.
	VMC_RAM_POWERCLR_S3POWER_Pos = 0x3
	// Bit mask of S3POWER field.
	VMC_RAM_POWERCLR_S3POWER_Msk = 0x8
	// Bit S3POWER.
	VMC_RAM_POWERCLR_S3POWER = 0x8
	// Off
	VMC_RAM_POWERCLR_S3POWER_Off = 0x1
	// Position of S0RETENTION field.
	VMC_RAM_POWERCLR_S0RETENTION_Pos = 0x10
	// Bit mask of S0RETENTION field.
	VMC_RAM_POWERCLR_S0RETENTION_Msk = 0x10000
	// Bit S0RETENTION.
	VMC_RAM_POWERCLR_S0RETENTION = 0x10000
	// Off
	VMC_RAM_POWERCLR_S0RETENTION_Off = 0x1
	// Position of S1RETENTION field.
	VMC_RAM_POWERCLR_S1RETENTION_Pos = 0x11
	// Bit mask of S1RETENTION field.
	VMC_RAM_POWERCLR_S1RETENTION_Msk = 0x20000
	// Bit S1RETENTION.
	VMC_RAM_POWERCLR_S1RETENTION = 0x20000
	// Off
	VMC_RAM_POWERCLR_S1RETENTION_Off = 0x1
	// Position of S2RETENTION field.
	VMC_RAM_POWERCLR_S2RETENTION_Pos = 0x12
	// Bit mask of S2RETENTION field.
	VMC_RAM_POWERCLR_S2RETENTION_Msk = 0x40000
	// Bit S2RETENTION.
	VMC_RAM_POWERCLR_S2RETENTION = 0x40000
	// Off
	VMC_RAM_POWERCLR_S2RETENTION_Off = 0x1
	// Position of S3RETENTION field.
	VMC_RAM_POWERCLR_S3RETENTION_Pos = 0x13
	// Bit mask of S3RETENTION field.
	VMC_RAM_POWERCLR_S3RETENTION_Msk = 0x80000
	// Bit S3RETENTION.
	VMC_RAM_POWERCLR_S3RETENTION = 0x80000
	// Off
	VMC_RAM_POWERCLR_S3RETENTION_Off = 0x1
)

// Constants for P0_NS: GPIO Port 0
const (
	// OUT: Write GPIO port
	// Position of PIN0 field.
	GPIO_OUT_PIN0_Pos = 0x0
	// Bit mask of PIN0 field.
	GPIO_OUT_PIN0_Msk = 0x1
	// Bit PIN0.
	GPIO_OUT_PIN0 = 0x1
	// Pin driver is low
	GPIO_OUT_PIN0_Low = 0x0
	// Pin driver is high
	GPIO_OUT_PIN0_High = 0x1
	// Position of PIN1 field.
	GPIO_OUT_PIN1_Pos = 0x1
	// Bit mask of PIN1 field.
	GPIO_OUT_PIN1_Msk = 0x2
	// Bit PIN1.
	GPIO_OUT_PIN1 = 0x2
	// Pin driver is low
	GPIO_OUT_PIN1_Low = 0x0
	// Pin driver is high
	GPIO_OUT_PIN1_High = 0x1
	// Position of PIN2 field.
	GPIO_OUT_PIN2_Pos = 0x2
	// Bit mask of PIN2 field.
	GPIO_OUT_PIN2_Msk = 0x4
	// Bit PIN2.
	GPIO_OUT_PIN2 = 0x4
	// Pin driver is low
	GPIO_OUT_PIN2_Low = 0x0
	// Pin driver is high
	GPIO_OUT_PIN2_High = 0x1
	// Position of PIN3 field.
	GPIO_OUT_PIN3_Pos = 0x3
	// Bit mask of PIN3 field.
	GPIO_OUT_PIN3_Msk = 0x8
	// Bit PIN3.
	GPIO_OUT_PIN3 = 0x8
	// Pin driver is low
	GPIO_OUT_PIN3_Low = 0x0
	// Pin driver is high
	GPIO_OUT_PIN3_High = 0x1
	// Position of PIN4 field.
	GPIO_OUT_PIN4_Pos = 0x4
	// Bit mask of PIN4 field.
	GPIO_OUT_PIN4_Msk = 0x10
	// Bit PIN4.
	GPIO_OUT_PIN4 = 0x10
	// Pin driver is low
	GPIO_OUT_PIN4_Low = 0x0
	// Pin driver is high
	GPIO_OUT_PIN4_High = 0x1
	// Position of PIN5 field.
	GPIO_OUT_PIN5_Pos = 0x5
	// Bit mask of PIN5 field.
	GPIO_OUT_PIN5_Msk = 0x20
	// Bit PIN5.
	GPIO_OUT_PIN5 = 0x20
	// Pin driver is low
	GPIO_OUT_PIN5_Low = 0x0
	// Pin driver is high
	GPIO_OUT_PIN5_High = 0x1
	// Position of PIN6 field.
	GPIO_OUT_PIN6_Pos = 0x6
	// Bit mask of PIN6 field.
	GPIO_OUT_PIN6_Msk = 0x40
	// Bit PIN6.
	GPIO_OUT_PIN6 = 0x40
	// Pin driver is low
	GPIO_OUT_PIN6_Low = 0x0
	// Pin driver is high
	GPIO_OUT_PIN6_High = 0x1
	// Position of PIN7 field.
	GPIO_OUT_PIN7_Pos = 0x7
	// Bit mask of PIN7 field.
	GPIO_OUT_PIN7_Msk = 0x80
	// Bit PIN7.
	GPIO_OUT_PIN7 = 0x80
	// Pin driver is low
	GPIO_OUT_PIN7_Low = 0x0
	// Pin driver is high
	GPIO_OUT_PIN7_High = 0x1
	// Position of PIN8 field.
	GPIO_OUT_PIN8_Pos = 0x8
	// Bit mask of PIN8 field.
	GPIO_OUT_PIN8_Msk = 0x100
	// Bit PIN8.
	GPIO_OUT_PIN8 = 0x100
	// Pin driver is low
	GPIO_OUT_PIN8_Low = 0x0
	// Pin driver is high
	GPIO_OUT_PIN8_High = 0x1
	// Position of PIN9 field.
	GPIO_OUT_PIN9_Pos = 0x9
	// Bit mask of PIN9 field.
	GPIO_OUT_PIN9_Msk = 0x200
	// Bit PIN9.
	GPIO_OUT_PIN9 = 0x200
	// Pin 