import { Zh, KeyValueNumberString, Fz, Tz } from './types';
interface KeyValueAny {
    [s: string]: any;
}
declare function getDataValue(dpValue: any): any;
declare function getTypeName(dpValue: any): string;
declare function logUnexpectedDataPoint(where: string, msg: KeyValueAny, dpValue: any, meta: KeyValueAny): void;
declare function logUnexpectedDataType(where: any, msg: any, dpValue: any, meta: any, expectedDataType?: any): void;
declare function getDataPointNames(dpValue: any): string[];
declare function getCoverStateEnums(manufacturerName: string): any;
declare function convertDecimalValueTo4ByteHexArray(value: number): number[];
declare function sendDataPoints(entity: Zh.Endpoint | Zh.Group, dpValues: any, cmd?: string, seq?: number): Promise<number>;
declare function convertStringToHexArray(value: string): number[];
declare function dpValueFromIntValue(dp: number, value: number): {
    dp: number;
    datatype: number;
    data: number[];
};
declare function dpValueFromBool(dp: number, value: boolean | number): {
    dp: number;
    datatype: number;
    data: number[];
};
declare function dpValueFromEnum(dp: number, value: number): {
    dp: number;
    datatype: number;
    data: number[];
};
declare function dpValueFromStringBuffer(dp: number, stringBuffer: string): {
    dp: number;
    datatype: number;
    data: string;
};
declare function dpValueFromRaw(dp: number, rawBuffer: any): {
    dp: number;
    datatype: number;
    data: any;
};
declare function dpValueFromBitmap(dp: number, bitmapBuffer: any): {
    dp: number;
    datatype: number;
    data: any;
};
declare function sendDataPoint(entity: Zh.Endpoint | Zh.Group, dpValue: any, cmd?: string, seq?: number): Promise<number>;
declare function sendDataPointValue(entity: Zh.Endpoint | Zh.Group, dp: number, value: any, cmd?: string, seq?: number): Promise<number>;
declare function sendDataPointBool(entity: Zh.Endpoint | Zh.Group, dp: number, value: boolean | number, cmd?: string, seq?: number): Promise<number>;
declare function sendDataPointEnum(entity: Zh.Endpoint | Zh.Group, dp: number, value: number, cmd?: string, seq?: number): Promise<number>;
declare function sendDataPointRaw(entity: Zh.Endpoint | Zh.Group, dp: number, value: any, cmd?: string, seq?: number): Promise<number>;
declare function sendDataPointBitmap(entity: Zh.Endpoint | Zh.Group, dp: number, value: any, cmd?: string, seq?: number): Promise<number>;
declare function sendDataPointStringBuffer(entity: Zh.Endpoint | Zh.Group, dp: number, value: any, cmd?: string, seq?: number): Promise<number>;
declare function convertRawToCycleTimer(value: any): {
    timernr: number;
    starttime: string;
    endtime: string;
    irrigationDuration: number;
    pauseDuration: number;
    weekdays: string;
    active: number;
};
declare function logDataPoint(where: string, msg: KeyValueAny, dpValue: any, meta: any): void;
declare const thermostatSystemModes2: KeyValueAny;
declare const thermostatSystemModes3: KeyValueAny;
declare const thermostatSystemModes4: KeyValueNumberString;
declare const thermostatPresets: KeyValueNumberString;
declare const msLookups: KeyValueAny;
declare const ZMLookups: KeyValueAny;
declare const moesSwitch: KeyValueAny;
declare const tuyaHPSCheckingResult: KeyValueAny;
declare function convertWeekdaysTo1ByteHexArray(weekdays: string): number | number[];
declare function convertRawToTimer(value: any): {
    timernr: number;
    time: string;
    duration: number;
    weekdays: string;
    active: string;
};
declare function logUnexpectedDataValue(where: string, msg: KeyValueAny, dpValue: any, meta: any, valueKind: any, expectedMinValue?: any, expectedMaxValue?: any): void;
declare function isCoverInverted(manufacturerName: string): boolean;
declare function convertDecimalValueTo2ByteHexArray(value: any): number[];
declare function convertTimeTo2ByteHexArray(time: string): number[];
declare const dataPoints: {
    wateringTimer: {
        valve_state_auto_shutdown: number;
        water_flow: number;
        shutdown_timer: number;
        remaining_watering_time: number;
        valve_state: number;
        last_watering_duration: number;
        battery: number;
    };
    state: number;
    heatingSetpoint: number;
    coverPosition: number;
    dimmerLevel: number;
    dimmerMinLevel: number;
    localTemp: number;
    coverArrived: number;
    occupancy: number;
    mode: number;
    fanMode: number;
    dimmerMaxLevel: number;
    motorDirection: number;
    config: number;
    childLock: number;
    coverChange: number;
    runningState: number;
    valveDetection: number;
    battery: number;
    tempCalibration: number;
    waterLeak: number;
    minTemp: number;
    maxTemp: number;
    windowDetection: number;
    boostTime: number;
    coverSpeed: number;
    forceMode: number;
    comfortTemp: number;
    ecoTemp: number;
    valvePos: number;
    batteryLow: number;
    weekFormat: number;
    scheduleWorkday: number;
    scheduleHoliday: number;
    awayTemp: number;
    windowOpen: number;
    autoLock: number;
    awayDays: number;
    eardaDimmerLevel: number;
    siterwellWindowDetection: number;
    moesHold: number;
    moesScheduleEnable: number;
    moesHeatingSetpoint: number;
    moesMaxTempLimit: number;
    moesMaxTemp: number;
    moesDeadZoneTemp: number;
    moesLocalTemp: number;
    moesMinTempLimit: number;
    moesTempCalibration: number;
    moesValve: number;
    moesChildLock: number;
    moesSensor: number;
    moesSchedule: number;
    etopErrorStatus: number;
    moesSsystemMode: number;
    moesSheatingSetpoint: number;
    moesSlocalTemp: number;
    moesSboostHeating: number;
    moesSboostHeatingCountdown: number;
    moesSreset: number;
    moesSwindowDetectionFunktion_A2: number;
    moesSwindowDetection: number;
    moesSchildLock: number;
    moesSbattery: number;
    moesSschedule: number;
    moesSvalvePosition: number;
    moesSboostHeatingCountdownTimeSet: number;
    moesScompensationTempSet: number;
    moesSecoMode: number;
    moesSecoModeTempSet: number;
    moesSmaxTempSet: number;
    moesSminTempSet: number;
    moesCoverCalibration: number;
    moesCoverBacklight: number;
    moesCoverMotorReversal: number;
    neoOccupancy: number;
    neoPowerType: number;
    neoMelody: number;
    neoDuration: number;
    neoTamper: number;
    neoAlarm: number;
    neoTemp: number;
    neoTempScale: number;
    neoHumidity: number;
    neoMinTemp: number;
    neoMaxTemp: number;
    neoMinHumidity: number;
    neoMaxHumidity: number;
    neoUnknown2: number;
    neoTempAlarm: number;
    neoTempHumidityAlarm: number;
    neoHumidityAlarm: number;
    neoUnknown3: number;
    neoVolume: number;
    neoAOBattPerc: number;
    neoAOMelody: number;
    neoAODuration: number;
    neoAOAlarm: number;
    neoAOVolume: number;
    saswellHeating: number;
    saswellWindowDetection: number;
    saswellFrostDetection: number;
    saswellTempCalibration: number;
    saswellChildLock: number;
    saswellState: number;
    saswellLocalTemp: number;
    saswellHeatingSetpoint: number;
    saswellValvePos: number;
    saswellBatteryLow: number;
    saswellAwayMode: number;
    saswellScheduleMode: number;
    saswellScheduleEnable: number;
    saswellScheduleSet: number;
    saswellSetpointHistoryDay: number;
    saswellTimeSync: number;
    saswellSetpointHistoryWeek: number;
    saswellSetpointHistoryMonth: number;
    saswellSetpointHistoryYear: number;
    saswellLocalHistoryDay: number;
    saswellLocalHistoryWeek: number;
    saswellLocalHistoryMonth: number;
    saswellLocalHistoryYear: number;
    saswellMotorHistoryDay: number;
    saswellMotorHistoryWeek: number;
    saswellMotorHistoryMonth: number;
    saswellMotorHistoryYear: number;
    saswellScheduleSunday: number;
    saswellScheduleMonday: number;
    saswellScheduleTuesday: number;
    saswellScheduleWednesday: number;
    saswellScheduleThursday: number;
    saswellScheduleFriday: number;
    saswellScheduleSaturday: number;
    saswellAntiScaling: number;
    hyHeating: number;
    hyExternalTemp: number;
    hyAwayDays: number;
    hyAwayTemp: number;
    hyMaxTempProtection: number;
    hyMinTempProtection: number;
    hyTempCalibration: number;
    hyHysteresis: number;
    hyProtectionHysteresis: number;
    hyProtectionMaxTemp: number;
    hyProtectionMinTemp: number;
    hyMaxTemp: number;
    hyMinTemp: number;
    hySensor: number;
    hyPowerOnBehavior: number;
    hyWeekFormat: number;
    hyWorkdaySchedule1: number;
    hyWorkdaySchedule2: number;
    hyHolidaySchedule1: number;
    hyHolidaySchedule2: number;
    hyState: number;
    hyHeatingSetpoint: number;
    hyLocalTemp: number;
    hyMode: number;
    hyChildLock: number;
    hyAlarm: number;
    silvercrestChangeMode: number;
    silvercrestSetBrightness: number;
    silvercrestSetColorTemp: number;
    silvercrestSetColor: number;
    silvercrestSetEffect: number;
    fantemPowerSupplyMode: number;
    fantemReportingTime: number;
    fantemExtSwitchType: number;
    fantemTempCalibration: number;
    fantemHumidityCalibration: number;
    fantemLoadDetectionMode: number;
    fantemLuxCalibration: number;
    fantemExtSwitchStatus: number;
    fantemTemp: number;
    fantemHumidity: number;
    fantemMotionEnable: number;
    fantemControlMode: number;
    fantemBattery: number;
    fantemLedEnable: number;
    fantemReportingEnable: number;
    fantemLoadType: number;
    fantemLoadDimmable: number;
    wooxSwitch: number;
    wooxBattery: number;
    wooxSmokeTest: number;
    frankEverTimer: number;
    frankEverTreshold: number;
    dinrailPowerMeterTotalEnergy: number;
    dinrailPowerMeterCurrent: number;
    dinrailPowerMeterPower: number;
    dinrailPowerMeterVoltage: number;
    dinrailPowerMeterTotalEnergy2: number;
    dinrailPowerMeterPower2: number;
    tuyaSabCO2: number;
    tuyaSabTemp: number;
    tuyaSabHumidity: number;
    tuyaSabVOC: number;
    tuyaSabFormaldehyd: number;
    tuyaSahkMP25: number;
    tuyaSahkCO2: number;
    tuyaSahkFormaldehyd: number;
    tuyaSabCOalarm: number;
    tuyaSabCO: number;
    moes105DimmerState1: number;
    moes105DimmerLevel1: number;
    moes105DimmerState2: number;
    moes105DimmerLevel2: number;
    trsPresenceState: number;
    trsSensitivity: number;
    trsMotionState: number;
    trsIlluminanceLux: number;
    trsDetectionData: number;
    trsScene: number;
    trsMotionDirection: number;
    trsMotionSpeed: number;
    trsfPresenceState: number;
    trsfSensitivity: number;
    trsfMotionState: number;
    trsfIlluminanceLux: number;
    trsfTumbleSwitch: number;
    trsfTumbleAlarmTime: number;
    trsfScene: number;
    trsfMotionDirection: number;
    trsfMotionSpeed: number;
    trsfFallDownStatus: number;
    trsfStaticDwellAlarm: number;
    trsfFallSensitivity: number;
    msVSensitivity: number;
    msOSensitivity: number;
    msVacancyDelay: number;
    msMode: number;
    msVacantConfirmTime: number;
    msReferenceLuminance: number;
    msLightOnLuminancePrefer: number;
    msLightOffLuminancePrefer: number;
    msLuminanceLevel: number;
    msLedStatus: number;
    tvMode: number;
    tvWindowDetection: number;
    tvFrostDetection: number;
    tvHeatingSetpoint: number;
    tvLocalTemp: number;
    tvTempCalibration: number;
    tvWorkingDay: number;
    tvHolidayTemp: number;
    tvBattery: number;
    tvChildLock: number;
    tvErrorStatus: number;
    tvHolidayMode: number;
    tvBoostTime: number;
    tvOpenWindowTemp: number;
    tvComfortTemp: number;
    tvEcoTemp: number;
    tvWeekSchedule: number;
    tvHeatingStop: number;
    tvMondaySchedule: number;
    tvWednesdaySchedule: number;
    tvFridaySchedule: number;
    tvSundaySchedule: number;
    tvTuesdaySchedule: number;
    tvThursdaySchedule: number;
    tvSaturdaySchedule: number;
    tvBoostMode: number;
    hochCountdownTimer: number;
    hochFaultCode: number;
    hochRelayStatus: number;
    hochChildLock: number;
    hochVoltage: number;
    hochCurrent: number;
    hochActivePower: number;
    hochLeakageCurrent: number;
    hochTemperature: number;
    hochRemainingEnergy: number;
    hochRechargeEnergy: number;
    hochCostParameters: number;
    hochLeakageParameters: number;
    hochVoltageThreshold: number;
    hochCurrentThreshold: number;
    hochTemperatureThreshold: number;
    hochTotalActivePower: number;
    hochEquipmentNumberType: number;
    hochClearEnergy: number;
    hochLocking: number;
    hochTotalReverseActivePower: number;
    hochHistoricalVoltage: number;
    hochHistoricalCurrent: number;
    nousTemperature: number;
    nousHumidity: number;
    nousBattery: number;
    nousTempUnitConvert: number;
    nousMaxTemp: number;
    nousMinTemp: number;
    nousMaxHumi: number;
    nousMinHumi: number;
    nousTempAlarm: number;
    nousHumiAlarm: number;
    nousHumiSensitivity: number;
    nousTempSensitivity: number;
    nousTempReportInterval: number;
    nousHumiReportInterval: number;
    tthTemperature: number;
    tthHumidity: number;
    tthBatteryLevel: number;
    tthBattery: number;
    thitBatteryPercentage: number;
    thitIlluminanceLux: number;
    tIlluminanceLux: number;
    thitHumidity: number;
    thitTemperature: number;
    tuyaVibration: number;
    wlsWaterLeak: number;
    wlsBatteryPercentage: number;
    evanellMode: number;
    evanellHeatingSetpoint: number;
    evanellLocalTemp: number;
    evanellBattery: number;
    evanellChildLock: number;
    AM02Control: number;
    AM02PercentControl: number;
    AM02PercentState: number;
    AM02Mode: number;
    AM02Direction: number;
    AM02WorkState: number;
    AM02CountdownLeft: number;
    AM02TimeTotal: number;
    AM02SituationSet: number;
    AM02Fault: number;
    AM02Border: number;
    AM02MotorWorkingMode: number;
    AM02AddRemoter: number;
    garageDoorTrigger: number;
    garageDoorContact: number;
    garageDoorStatus: number;
    moesSwitchPowerOnBehavior: number;
    moesSwitchIndicateLight: number;
    x5hState: number;
    x5hMode: number;
    x5hWorkingStatus: number;
    x5hSound: number;
    x5hFrostProtection: number;
    x5hSetTemp: number;
    x5hSetTempCeiling: number;
    x5hCurrentTemp: number;
    x5hTempCorrection: number;
    x5hWeeklyProcedure: number;
    x5hWorkingDaySetting: number;
    x5hFactoryReset: number;
    x5hChildLock: number;
    x5hSensorSelection: number;
    x5hFaultAlarm: number;
    x5hTempDiff: number;
    x5hProtectionTempLimit: number;
    x5hOutputReverse: number;
    x5hBackplaneBrightness: number;
    connecteState: number;
    connecteMode: number;
    connecteHeatingSetpoint: number;
    connecteLocalTemp: number;
    connecteTempCalibration: number;
    connecteChildLock: number;
    connecteTempFloor: number;
    connecteSensorType: number;
    connecteHysteresis: number;
    connecteRunningState: number;
    connecteTempProgram: number;
    connecteOpenWindow: number;
    connecteMaxProtectTemp: number;
    tshpsPresenceState: number;
    tshpscSensitivity: number;
    tshpsMinimumRange: number;
    tshpsMaximumRange: number;
    tshpsTargetDistance: number;
    tshpsDetectionDelay: number;
    tshpsFadingTime: number;
    tshpsIlluminanceLux: number;
    tshpsCLI: number;
    tshpsSelfTest: number;
    lmsState: number;
    lmsBattery: number;
    lmsSensitivity: number;
    lmsKeepTime: number;
    lmsIlluminance: number;
    alectoSmokeState: number;
    alectoSmokeValue: number;
    alectoSelfChecking: number;
    alectoCheckingResult: number;
    alectoSmokeTest: number;
    alectoLifecycle: number;
    alectoBatteryState: number;
    alectoBatteryPercentage: number;
    alectoSilence: number;
    bacFanMode: number;
    HPSZInductionState: number;
    HPSZPresenceTime: number;
    HPSZLeavingTime: number;
    HPSZLEDState: number;
    giexWaterValve: {
        battery: number;
        currentTemperature: number;
        cycleIrrigationInterval: number;
        cycleIrrigationNumTimes: number;
        irrigationEndTime: number;
        irrigationStartTime: number;
        irrigationTarget: number;
        lastIrrigationDuration: number;
        mode: number;
        state: number;
        waterConsumed: number;
    };
    zsHeatingSetpoint: number;
    zsChildLock: number;
    zsTempCalibration: number;
    zsLocalTemp: number;
    zsBatteryVoltage: number;
    zsComfortTemp: number;
    zsEcoTemp: number;
    zsHeatingSetpointAuto: number;
    zsOpenwindowTemp: number;
    zsOpenwindowTime: number;
    zsErrorStatus: number;
    zsMode: number;
    zsAwaySetting: number;
    zsBinaryOne: number;
    zsBinaryTwo: number;
    zsScheduleMonday: number;
    zsScheduleTuesday: number;
    zsScheduleWednesday: number;
    zsScheduleThursday: number;
    zsScheduleFriday: number;
    zsScheduleSaturday: number;
    zsScheduleSunday: number;
};
declare function firstDpValue(msg: any, meta: any, converterName: any): any;
declare function getMetaValue(entity: any, definition: any, key: string, groupStrategy?: string): any;
declare const tuyaGetDataValue: (dataType: any, data: any) => any;
declare const giexWaterValve: {
    battery: string;
    currentTemperature: string;
    cycleIrrigationInterval: string;
    cycleIrrigationNumTimes: string;
    irrigationEndTime: string;
    irrigationStartTime: string;
    irrigationTarget: string;
    lastIrrigationDuration: string;
    mode: string;
    state: string;
    waterConsumed: string;
};
declare const thermostatControlSequenceOfOperations: {
    0: string;
    1: string;
    2: string;
    3: string;
    4: string;
    5: string;
};
declare const thermostatSystemModes: {
    0: string;
    1: string;
    3: string;
    4: string;
    5: string;
    6: string;
    7: string;
    8: string;
    9: string;
};
declare const fromZigbee: {
    tuya_thermostat_weekly_schedule_1: Fz.Converter;
    TS0222: Fz.Converter;
    watering_timer: Fz.Converter;
    ZM35HQ_battery: Fz.Converter;
    ZMRM02: Fz.Converter;
    SA12IZL: Fz.Converter;
    R7049_status: Fz.Converter;
    woox_R7060: Fz.Converter;
    hpsz: Fz.Converter;
    zb_sm_cover: Fz.Converter;
    x5h_thermostat: Fz.Converter;
    zs_thermostat: Fz.Converter;
    giexWaterValve: Fz.Converter;
    tuya_alecto_smoke: Fz.Converter;
    WXKG11LM_click: Fz.Converter;
    SmartButton_skip: Fz.Converter;
    konke_click: Fz.Converter;
    xiaomi_action_click_multistate: Fz.Converter;
    WXKG12LM_action_click_multistate: Fz.Converter;
    terncy_raw: Fz.Converter;
    CCTSwitch_D0001_on_off: Fz.Converter;
    ptvo_switch_buttons: Fz.Converter;
    ZGRC013_brightness_onoff: Fz.Converter;
    ZGRC013_brightness_stop: Fz.Converter;
    ZGRC013_scene: Fz.Converter;
    ZGRC013_cmdOn: Fz.Converter;
    ZGRC013_cmdOff: Fz.Converter;
    ZGRC013_brightness: Fz.Converter;
    CTR_U_scene: Fz.Converter;
    st_button_state: Fz.Converter;
    QBKG11LM_click: Fz.Converter;
    QBKG12LM_click: Fz.Converter;
    QBKG03LM_QBKG12LM_click: Fz.Converter;
    QBKG04LM_QBKG11LM_click: Fz.Converter;
    cover_stop: Fz.Converter;
    cover_open: Fz.Converter;
    cover_close: Fz.Converter;
    WXKG03LM_click: Fz.Converter;
    TS0218_click: Fz.Converter;
    xiaomi_on_off_action: Fz.Converter;
    WXKG02LM_click: Fz.Converter;
    WXKG02LM_click_multistate: Fz.Converter;
    WXKG01LM_click: Fz.Converter;
    scenes_recall_click: Fz.Converter;
    AV2010_34_click: Fz.Converter;
    E1743_brightness_down: Fz.Converter;
    E1743_brightness_up: Fz.Converter;
    E1743_brightness_stop: Fz.Converter;
    genOnOff_cmdOn: Fz.Converter;
    genOnOff_cmdOff: Fz.Converter;
    RM01_on_click: Fz.Converter;
    RM01_off_click: Fz.Converter;
    RM01_down_hold: Fz.Converter;
    RM01_up_hold: Fz.Converter;
    RM01_stop: Fz.Converter;
    xiaomi_multistate_action: Fz.Converter;
    E1744_play_pause: Fz.Converter;
    E1744_skip: Fz.Converter;
    cmd_move: Fz.Converter;
    cmd_move_with_onoff: Fz.Converter;
    cmd_stop: Fz.Converter;
    cmd_stop_with_onoff: Fz.Converter;
    cmd_move_to_level_with_onoff: Fz.Converter;
    immax_07046L_arm: Fz.Converter;
    KEF1PA_arm: Fz.Converter;
    QBKG25LM_click: Fz.Converter;
    QBKG03LM_buttons: Fz.Converter;
    CTR_U_brightness_updown_click: Fz.Converter;
    CTR_U_brightness_updown_hold: Fz.Converter;
    CTR_U_brightness_updown_release: Fz.Converter;
    osram_lightify_switch_cmdOn: Fz.Converter;
    osram_lightify_switch_cmdOff: Fz.Converter;
    osram_lightify_switch_cmdMoveWithOnOff: Fz.Converter;
    osram_lightify_switch_AC0251100NJ_cmdStop: Fz.Converter;
    osram_lightify_switch_cmdMove: Fz.Converter;
    osram_lightify_switch_cmdMoveHue: Fz.Converter;
    osram_lightify_switch_cmdMoveToSaturation: Fz.Converter;
    osram_lightify_switch_cmdMoveToLevelWithOnOff: Fz.Converter;
    osram_lightify_switch_cmdMoveToColorTemp: Fz.Converter;
    osram_lightify_switch_73743_cmdStop: Fz.Converter;
    osram_lightify_switch_AB371860355_cmdOn: Fz.Converter;
    osram_lightify_switch_AB371860355_cmdOff: Fz.Converter;
    osram_lightify_switch_AB371860355_cmdStepColorTemp: Fz.Converter;
    osram_lightify_switch_AB371860355_cmdMoveWithOnOff: Fz.Converter;
    osram_lightify_switch_AB371860355_cmdMove: Fz.Converter;
    osram_lightify_switch_AB371860355_cmdStop: Fz.Converter;
    osram_lightify_switch_AB371860355_cmdMoveHue: Fz.Converter;
    osram_lightify_switch_AB371860355_cmdMoveSat: Fz.Converter;
    insta_scene_click: Fz.Converter;
    insta_down_hold: Fz.Converter;
    insta_up_hold: Fz.Converter;
    insta_stop: Fz.Converter;
    tint404011_brightness_updown_click: Fz.Converter;
    tint404011_brightness_updown_hold: Fz.Converter;
    tint404011_brightness_updown_release: Fz.Converter;
    tint404011_move_to_color_temp: Fz.Converter;
    tint404011_move_to_color: Fz.Converter;
    heiman_smart_controller_armmode: Fz.Converter;
    LZL4B_onoff: Fz.Converter;
    eria_81825_updown: Fz.Converter;
    ZYCT202_stop: Fz.Converter;
    ZYCT202_up_down: Fz.Converter;
    STS_PRS_251_beeping: Fz.Converter;
    dimmer_passthru_brightness: Fz.Converter;
    bitron_thermostat_att_report: Fz.Converter;
    thermostat_att_report: Fz.Converter;
    stelpro_thermostat: Fz.Converter;
    viessmann_thermostat_att_report: Fz.Converter;
    eurotronic_thermostat: Fz.Converter;
    wiser_thermostat: Fz.Converter;
    hvac_user_interface: Fz.Converter;
    thermostat_weekly_schedule_rsp: Fz.Converter;
    terncy_knob: Fz.Converter;
    wiser_itrv_battery: Fz.Converter;
    ubisys_c4_scenes: Fz.Converter;
    ubisys_c4_onoff: Fz.Converter;
    ubisys_c4_level: Fz.Converter;
    ubisys_c4_cover: Fz.Converter;
    hue_dimmer_switch: Fz.Converter;
    blitzwolf_occupancy_with_timeout: Fz.Converter;
    moes_thermostat: Fz.Converter;
    moesS_thermostat: Fz.Converter;
    tuya_air_quality: Fz.Converter;
    tuya_CO: Fz.Converter;
    connecte_thermostat: Fz.Converter;
    saswell_thermostat: Fz.Converter;
    evanell_thermostat: Fz.Converter;
    etop_thermostat: Fz.Converter;
    tuya_thermostat: Fz.Converter;
    tuya_dimmer: Fz.Converter;
    tuya_motion_sensor: Fz.Converter;
    tuya_smart_vibration_sensor: Fz.Converter;
    matsee_garage_door_opener: Fz.Converter;
    moes_thermostat_tv: Fz.Converter;
    hoch_din: Fz.Converter;
    tuya_light_wz5: Fz.Converter;
    ZMAM02_cover: Fz.Converter;
    tm081: Fz.Converter;
    tuya_remote: Fz.Converter;
    tuya_smart_human_presense_sensor: Fz.Converter;
    ZG204ZL_lms: Fz.Converter;
    moes_cover: Fz.Converter;
    tuya_temperature_humidity_sensor: Fz.Converter;
    nous_lcd_temperature_humidity_sensor: Fz.Converter;
    tuya_illuminance_temperature_humidity_sensor: Fz.Converter;
    tuya_illuminance_sensor: Fz.Converter;
    hy_thermostat: Fz.Converter;
    neo_nas_pd07: Fz.Converter;
    neo_t_h_alarm: Fz.Converter;
    neo_alarm: Fz.Converter;
    ZB006X_settings: Fz.Converter;
    tuya_cover: Fz.Converter;
    moes_switch: Fz.Converter;
    tuya_water_leak: Fz.Converter;
    wls100z_water_leak: Fz.Converter;
    silvercrest_smart_led_string: Fz.Converter;
    frankever_valve: Fz.Converter;
    tuya_woox_smoke: Fz.Converter;
    tuya_switch: Fz.Converter;
    tuya_dinrail_switch: Fz.Converter;
    ZVG1: Fz.Converter;
    ZB003X: Fz.Converter;
    tuya_thermostat_weekly_schedule_2: Fz.Converter;
    tuya_data_point_dump: Fz.Converter;
    javis_microwave_sensor: Fz.Converter;
    SLUXZB: Fz.Converter;
};
declare const toZigbee: {
    zb_sm_cover: Tz.Converter;
    x5h_thermostat: Tz.Converter;
    zs_thermostat_child_lock: Tz.Converter;
    zs_thermostat_binary_one: Tz.Converter;
    zs_thermostat_binary_two: Tz.Converter;
    zs_thermostat_current_heating_setpoint: Tz.Converter;
    zs_thermostat_current_heating_setpoint_auto: Tz.Converter;
    zs_thermostat_comfort_temp: Tz.Converter;
    zs_thermostat_openwindow_temp: Tz.Converter;
    zs_thermostat_openwindow_time: Tz.Converter;
    zs_thermostat_eco_temp: Tz.Converter;
    zs_thermostat_preset_mode: Tz.Converter;
    zs_thermostat_system_mode: Tz.Converter;
    zs_thermostat_local_temperature_calibration: Tz.Converter;
    zs_thermostat_away_setting: Tz.Converter;
    zs_thermostat_local_schedule: Tz.Converter;
    giexWaterValve: Tz.Converter;
    tuya_alecto_smoke: Tz.Converter;
    matsee_garage_door_opener: Tz.Converter;
    connecte_thermostat: Tz.Converter;
    moes_thermostat_child_lock: Tz.Converter;
    moes_thermostat_current_heating_setpoint: Tz.Converter;
    moes_thermostat_deadzone_temperature: Tz.Converter;
    moes_thermostat_calibration: Tz.Converter;
    moes_thermostat_min_temperature_limit: Tz.Converter;
    moes_thermostat_max_temperature_limit: Tz.Converter;
    moes_thermostat_mode: Tz.Converter;
    moes_thermostat_standby: Tz.Converter;
    moes_thermostat_program_schedule: Tz.Converter;
    moesS_thermostat_system_mode: Tz.Converter;
    moesS_thermostat_preset: Tz.Converter;
    moesS_thermostat_current_heating_setpoint: Tz.Converter;
    moesS_thermostat_boost_heating: Tz.Converter;
    moesS_thermostat_window_detection: Tz.Converter;
    moesS_thermostat_child_lock: Tz.Converter;
    moesS_thermostat_boostHeatingCountdownTimeSet: Tz.Converter;
    moesS_thermostat_temperature_calibration: Tz.Converter;
    moesS_thermostat_moesSecoMode: Tz.Converter;
    moesS_thermostat_eco_temperature: Tz.Converter;
    moesS_thermostat_max_temperature: Tz.Converter;
    moesS_thermostat_min_temperature: Tz.Converter;
    moesS_thermostat_schedule_programming: Tz.Converter;
    hgkg_thermostat_standby: Tz.Converter;
    moes_switch: Tz.Converter;
    moes_thermostat_sensor: Tz.Converter;
    tuya_dimmer_state: Tz.Converter;
    tuya_dimmer_level: Tz.Converter;
    tuya_switch_state: Tz.Converter;
    frankever_threshold: Tz.Converter;
    frankever_timer: Tz.Converter;
    ZVG1_timer: Tz.Converter;
    ZVG1_weather_delay: Tz.Converter;
    ZVG1_cycle_timer: Tz.Converter;
    ZVG1_normal_schedule_timer: Tz.Converter;
    etop_thermostat_system_mode: Tz.Converter;
    etop_thermostat_away_mode: Tz.Converter;
    tuya_thermostat_weekly_schedule: Tz.Converter;
    tuya_thermostat_child_lock: Tz.Converter;
    tuya_thermostat_window_detection: Tz.Converter;
    siterwell_thermostat_window_detection: Tz.Converter;
    tuya_thermostat_valve_detection: Tz.Converter;
    tuya_thermostat_current_heating_setpoint: Tz.Converter;
    tuya_thermostat_system_mode: Tz.Converter;
    tuya_thermostat_preset: Tz.Converter;
    tuya_thermostat_away_mode: Tz.Converter;
    tuya_thermostat_fan_mode: Tz.Converter;
    tuya_thermostat_bac_fan_mode: Tz.Converter;
    tuya_thermostat_auto_lock: Tz.Converter;
    tuya_thermostat_calibration: Tz.Converter;
    tuya_thermostat_min_temp: Tz.Converter;
    tuya_thermostat_max_temp: Tz.Converter;
    tuya_thermostat_boost_time: Tz.Converter;
    tuya_thermostat_comfort_temp: Tz.Converter;
    tuya_thermostat_eco_temp: Tz.Converter;
    tuya_thermostat_force: Tz.Converter;
    tuya_thermostat_force_to_mode: Tz.Converter;
    tuya_thermostat_away_preset: Tz.Converter;
    tuya_thermostat_window_detect: Tz.Converter;
    tuya_thermostat_schedule: Tz.Converter;
    tuya_thermostat_schedule_programming_mode: Tz.Converter;
    tuya_thermostat_week: Tz.Converter;
    tuya_cover_options: Tz.Converter;
    neo_nas_pd07: Tz.Converter;
    neo_t_h_alarm: Tz.Converter;
    neo_alarm: Tz.Converter;
    nous_lcd_temperature_humidity_sensor: Tz.Converter;
    saswell_thermostat_current_heating_setpoint: Tz.Converter;
    saswell_thermostat_mode: Tz.Converter;
    saswell_thermostat_away: Tz.Converter;
    saswell_thermostat_child_lock: Tz.Converter;
    saswell_thermostat_window_detection: Tz.Converter;
    saswell_thermostat_frost_detection: Tz.Converter;
    saswell_thermostat_anti_scaling: Tz.Converter;
    saswell_thermostat_calibration: Tz.Converter;
    evanell_thermostat_current_heating_setpoint: Tz.Converter;
    evanell_thermostat_system_mode: Tz.Converter;
    evanell_thermostat_child_lock: Tz.Converter;
    silvercrest_smart_led_string: Tz.Converter;
    tuya_data_point_test: Tz.Converter;
    hy_thermostat: Tz.Converter;
    ZB003X: Tz.Converter;
    ZB006X_settings: Tz.Converter;
    tuya_motion_sensor: Tz.Converter;
    javis_microwave_sensor: Tz.Converter;
    moes_thermostat_tv: Tz.Converter;
    tuya_light_wz5: Tz.Converter;
    ZMAM02_cover: Tz.Converter;
    tuya_smart_human_presense_sensor: Tz.Converter;
    ZG204ZL_lms: Tz.Converter;
    moes_cover: Tz.Converter;
    hoch_din: Tz.Converter;
    SA12IZL_silence_siren: Tz.Converter;
    SA12IZL_alarm: Tz.Converter;
    R7049_silenceSiren: Tz.Converter;
    R7049_testAlarm: Tz.Converter;
    R7049_alarm: Tz.Converter;
    valve_state: Tz.Converter;
    shutdown_timer: Tz.Converter;
    valve_state_auto_shutdown: Tz.Converter;
    hpsz: Tz.Converter;
    tuya_cover_control: Tz.Converter;
};
export { fromZigbee as fz, fromZigbee, toZigbee as tz, toZigbee, thermostatControlSequenceOfOperations, thermostatSystemModes, tuyaHPSCheckingResult, thermostatSystemModes2, thermostatSystemModes3, thermostatSystemModes4, thermostatPresets, giexWaterValve, msLookups, ZMLookups, firstDpValue, dpValueFromEnum, dataPoints, dpValueFromBool, dpValueFromIntValue, dpValueFromRaw, dpValueFromBitmap, dpValueFromStringBuffer, moesSwitch, getDataValue, getTypeName, logUnexpectedDataPoint, logUnexpectedDataType, getDataPointNames, getCoverStateEnums, convertDecimalValueTo4ByteHexArray, sendDataPoints, convertStringToHexArray, sendDataPoint, sendDataPointValue, sendDataPointBool, sendDataPointEnum, sendDataPointRaw, sendDataPointBitmap, sendDataPointStringBuffer, convertRawToCycleTimer, logDataPoint, convertWeekdaysTo1ByteHexArray, convertRawToTimer, logUnexpectedDataValue, isCoverInverted, convertDecimalValueTo2ByteHexArray, convertTimeTo2ByteHexArray, getMetaValue, tuyaGetDataValue, };
//# sourceMappingURL=legacy.d.ts.map