"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.GET_FINDINGS_SORT_FIELDS = exports.DEFAULT_GET_FINDINGS_PARAMS = void 0;
var _lodash = _interopRequireDefault(require("lodash"));
var _MDSEnabledClientService = require("./MDSEnabledClientService");
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return typeof key === "symbol" ? key : String(key); }
function _toPrimitive(input, hint) { if (typeof input !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (typeof res !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); } /*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
// TODO DRAFT: Are these sortField options appropriate?
const GET_FINDINGS_SORT_FIELDS = exports.GET_FINDINGS_SORT_FIELDS = {
  INDEX: 'index',
  MONITOR_NAME: 'monitor_name',
  TIMESTAMP: 'timestamp'
};

// TODO DRAFT: RestGetFindingsAction.kt in the backend references a `missing` field in params.
//  Investigate if/how we should make use of that.
const DEFAULT_GET_FINDINGS_PARAMS = exports.DEFAULT_GET_FINDINGS_PARAMS = {
  // TODO DRAFT: Does providing a finding ID serve a particular function? Results with/without the ID seemed the same.
  id: undefined,
  from: 0,
  search: '',
  size: 20,
  sortDirection: 'desc',
  sortField: GET_FINDINGS_SORT_FIELDS.TIMESTAMP
};
class FindingService extends _MDSEnabledClientService.MDSEnabledClientService {
  constructor(...args) {
    super(...args);
    _defineProperty(this, "getFindings", async (context, req, res) => {
      const {
        id = DEFAULT_GET_FINDINGS_PARAMS.id,
        from = DEFAULT_GET_FINDINGS_PARAMS.from,
        size = DEFAULT_GET_FINDINGS_PARAMS.size,
        search = DEFAULT_GET_FINDINGS_PARAMS.search,
        sortDirection = DEFAULT_GET_FINDINGS_PARAMS.sortDirection,
        sortField = DEFAULT_GET_FINDINGS_PARAMS.sortField
      } = req.query;
      var params;
      switch (sortField) {
        case GET_FINDINGS_SORT_FIELDS.INDEX:
          params = {
            sortString: `${sortField}.keyword`,
            sortOrder: sortDirection
          };
          break;
        case GET_FINDINGS_SORT_FIELDS.MONITOR_NAME:
          params = {
            sortString: `${sortField}.keyword`,
            sortOrder: sortDirection
          };
          break;
        default:
          // If the sortField parsed from the URL isn't a valid option for this API, use a default option.
          params = {
            sortString: GET_FINDINGS_SORT_FIELDS.TIMESTAMP,
            sortOrder: sortDirection
          };
      }
      if (!_lodash.default.isEmpty(id)) params.findingId = id;
      params.startIndex = from;
      params.size = size;
      params.searchString = search;
      if (search.trim()) params.searchString = `*${search.trim().split(' ').join('* *')}*`;
      const client = this.getClientBasedOnDataSource(context, req);
      try {
        const resp = await client('alerting.getFindings', params);
        const findings = resp.findings.map(result => ({
          [result.finding.id]: {
            ...result
          }
        }));
        const totalFindings = resp.totalFindings;
        return res.ok({
          body: {
            ok: true,
            findings,
            totalFindings
          }
        });
      } catch (err) {
        console.log(err.message);
        return res.ok({
          body: {
            ok: false,
            err: err.message
          }
        });
      }
    });
  }
}
exports.default = FindingService;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJuYW1lcyI6WyJfbG9kYXNoIiwiX2ludGVyb3BSZXF1aXJlRGVmYXVsdCIsInJlcXVpcmUiLCJfTURTRW5hYmxlZENsaWVudFNlcnZpY2UiLCJvYmoiLCJfX2VzTW9kdWxlIiwiZGVmYXVsdCIsIl9kZWZpbmVQcm9wZXJ0eSIsImtleSIsInZhbHVlIiwiX3RvUHJvcGVydHlLZXkiLCJPYmplY3QiLCJkZWZpbmVQcm9wZXJ0eSIsImVudW1lcmFibGUiLCJjb25maWd1cmFibGUiLCJ3cml0YWJsZSIsImFyZyIsIl90b1ByaW1pdGl2ZSIsIlN0cmluZyIsImlucHV0IiwiaGludCIsInByaW0iLCJTeW1ib2wiLCJ0b1ByaW1pdGl2ZSIsInVuZGVmaW5lZCIsInJlcyIsImNhbGwiLCJUeXBlRXJyb3IiLCJOdW1iZXIiLCJHRVRfRklORElOR1NfU09SVF9GSUVMRFMiLCJleHBvcnRzIiwiSU5ERVgiLCJNT05JVE9SX05BTUUiLCJUSU1FU1RBTVAiLCJERUZBVUxUX0dFVF9GSU5ESU5HU19QQVJBTVMiLCJpZCIsImZyb20iLCJzZWFyY2giLCJzaXplIiwic29ydERpcmVjdGlvbiIsInNvcnRGaWVsZCIsIkZpbmRpbmdTZXJ2aWNlIiwiTURTRW5hYmxlZENsaWVudFNlcnZpY2UiLCJjb25zdHJ1Y3RvciIsImFyZ3MiLCJjb250ZXh0IiwicmVxIiwicXVlcnkiLCJwYXJhbXMiLCJzb3J0U3RyaW5nIiwic29ydE9yZGVyIiwiXyIsImlzRW1wdHkiLCJmaW5kaW5nSWQiLCJzdGFydEluZGV4Iiwic2VhcmNoU3RyaW5nIiwidHJpbSIsInNwbGl0Iiwiam9pbiIsImNsaWVudCIsImdldENsaWVudEJhc2VkT25EYXRhU291cmNlIiwicmVzcCIsImZpbmRpbmdzIiwibWFwIiwicmVzdWx0IiwiZmluZGluZyIsInRvdGFsRmluZGluZ3MiLCJvayIsImJvZHkiLCJlcnIiLCJjb25zb2xlIiwibG9nIiwibWVzc2FnZSJdLCJzb3VyY2VzIjpbIkZpbmRpbmdTZXJ2aWNlLmpzIl0sInNvdXJjZXNDb250ZW50IjpbIi8qXG4gKiBDb3B5cmlnaHQgT3BlblNlYXJjaCBDb250cmlidXRvcnNcbiAqIFNQRFgtTGljZW5zZS1JZGVudGlmaWVyOiBBcGFjaGUtMi4wXG4gKi9cblxuaW1wb3J0IF8gZnJvbSAnbG9kYXNoJztcbmltcG9ydCB7IE1EU0VuYWJsZWRDbGllbnRTZXJ2aWNlIH0gZnJvbSAnLi9NRFNFbmFibGVkQ2xpZW50U2VydmljZSc7XG5cbi8vIFRPRE8gRFJBRlQ6IEFyZSB0aGVzZSBzb3J0RmllbGQgb3B0aW9ucyBhcHByb3ByaWF0ZT9cbmV4cG9ydCBjb25zdCBHRVRfRklORElOR1NfU09SVF9GSUVMRFMgPSB7XG4gIElOREVYOiAnaW5kZXgnLFxuICBNT05JVE9SX05BTUU6ICdtb25pdG9yX25hbWUnLFxuICBUSU1FU1RBTVA6ICd0aW1lc3RhbXAnLFxufTtcblxuLy8gVE9ETyBEUkFGVDogUmVzdEdldEZpbmRpbmdzQWN0aW9uLmt0IGluIHRoZSBiYWNrZW5kIHJlZmVyZW5jZXMgYSBgbWlzc2luZ2AgZmllbGQgaW4gcGFyYW1zLlxuLy8gIEludmVzdGlnYXRlIGlmL2hvdyB3ZSBzaG91bGQgbWFrZSB1c2Ugb2YgdGhhdC5cbmV4cG9ydCBjb25zdCBERUZBVUxUX0dFVF9GSU5ESU5HU19QQVJBTVMgPSB7XG4gIC8vIFRPRE8gRFJBRlQ6IERvZXMgcHJvdmlkaW5nIGEgZmluZGluZyBJRCBzZXJ2ZSBhIHBhcnRpY3VsYXIgZnVuY3Rpb24/IFJlc3VsdHMgd2l0aC93aXRob3V0IHRoZSBJRCBzZWVtZWQgdGhlIHNhbWUuXG4gIGlkOiB1bmRlZmluZWQsXG4gIGZyb206IDAsXG4gIHNlYXJjaDogJycsXG4gIHNpemU6IDIwLFxuICBzb3J0RGlyZWN0aW9uOiAnZGVzYycsXG4gIHNvcnRGaWVsZDogR0VUX0ZJTkRJTkdTX1NPUlRfRklFTERTLlRJTUVTVEFNUCxcbn07XG5cbmV4cG9ydCBkZWZhdWx0IGNsYXNzIEZpbmRpbmdTZXJ2aWNlIGV4dGVuZHMgTURTRW5hYmxlZENsaWVudFNlcnZpY2Uge1xuICBnZXRGaW5kaW5ncyA9IGFzeW5jIChjb250ZXh0LCByZXEsIHJlcykgPT4ge1xuICAgIGNvbnN0IHtcbiAgICAgIGlkID0gREVGQVVMVF9HRVRfRklORElOR1NfUEFSQU1TLmlkLFxuICAgICAgZnJvbSA9IERFRkFVTFRfR0VUX0ZJTkRJTkdTX1BBUkFNUy5mcm9tLFxuICAgICAgc2l6ZSA9IERFRkFVTFRfR0VUX0ZJTkRJTkdTX1BBUkFNUy5zaXplLFxuICAgICAgc2VhcmNoID0gREVGQVVMVF9HRVRfRklORElOR1NfUEFSQU1TLnNlYXJjaCxcbiAgICAgIHNvcnREaXJlY3Rpb24gPSBERUZBVUxUX0dFVF9GSU5ESU5HU19QQVJBTVMuc29ydERpcmVjdGlvbixcbiAgICAgIHNvcnRGaWVsZCA9IERFRkFVTFRfR0VUX0ZJTkRJTkdTX1BBUkFNUy5zb3J0RmllbGQsXG4gICAgfSA9IHJlcS5xdWVyeTtcblxuICAgIHZhciBwYXJhbXM7XG4gICAgc3dpdGNoIChzb3J0RmllbGQpIHtcbiAgICAgIGNhc2UgR0VUX0ZJTkRJTkdTX1NPUlRfRklFTERTLklOREVYOlxuICAgICAgICBwYXJhbXMgPSB7XG4gICAgICAgICAgc29ydFN0cmluZzogYCR7c29ydEZpZWxkfS5rZXl3b3JkYCxcbiAgICAgICAgICBzb3J0T3JkZXI6IHNvcnREaXJlY3Rpb24sXG4gICAgICAgIH07XG4gICAgICAgIGJyZWFrO1xuICAgICAgY2FzZSBHRVRfRklORElOR1NfU09SVF9GSUVMRFMuTU9OSVRPUl9OQU1FOlxuICAgICAgICBwYXJhbXMgPSB7XG4gICAgICAgICAgc29ydFN0cmluZzogYCR7c29ydEZpZWxkfS5rZXl3b3JkYCxcbiAgICAgICAgICBzb3J0T3JkZXI6IHNvcnREaXJlY3Rpb24sXG4gICAgICAgIH07XG4gICAgICAgIGJyZWFrO1xuICAgICAgZGVmYXVsdDpcbiAgICAgICAgLy8gSWYgdGhlIHNvcnRGaWVsZCBwYXJzZWQgZnJvbSB0aGUgVVJMIGlzbid0IGEgdmFsaWQgb3B0aW9uIGZvciB0aGlzIEFQSSwgdXNlIGEgZGVmYXVsdCBvcHRpb24uXG4gICAgICAgIHBhcmFtcyA9IHtcbiAgICAgICAgICBzb3J0U3RyaW5nOiBHRVRfRklORElOR1NfU09SVF9GSUVMRFMuVElNRVNUQU1QLFxuICAgICAgICAgIHNvcnRPcmRlcjogc29ydERpcmVjdGlvbixcbiAgICAgICAgfTtcbiAgICB9XG5cbiAgICBpZiAoIV8uaXNFbXB0eShpZCkpIHBhcmFtcy5maW5kaW5nSWQgPSBpZDtcbiAgICBwYXJhbXMuc3RhcnRJbmRleCA9IGZyb207XG4gICAgcGFyYW1zLnNpemUgPSBzaXplO1xuICAgIHBhcmFtcy5zZWFyY2hTdHJpbmcgPSBzZWFyY2g7XG4gICAgaWYgKHNlYXJjaC50cmltKCkpIHBhcmFtcy5zZWFyY2hTdHJpbmcgPSBgKiR7c2VhcmNoLnRyaW0oKS5zcGxpdCgnICcpLmpvaW4oJyogKicpfSpgO1xuXG4gICAgY29uc3QgY2xpZW50ID0gdGhpcy5nZXRDbGllbnRCYXNlZE9uRGF0YVNvdXJjZShjb250ZXh0LCByZXEpO1xuICAgIHRyeSB7XG4gICAgICBjb25zdCByZXNwID0gYXdhaXQgY2xpZW50KCdhbGVydGluZy5nZXRGaW5kaW5ncycsIHBhcmFtcyk7XG4gICAgICBjb25zdCBmaW5kaW5ncyA9IHJlc3AuZmluZGluZ3MubWFwKChyZXN1bHQpID0+ICh7IFtyZXN1bHQuZmluZGluZy5pZF06IHsgLi4ucmVzdWx0IH0gfSkpO1xuICAgICAgY29uc3QgdG90YWxGaW5kaW5ncyA9IHJlc3AudG90YWxGaW5kaW5ncztcbiAgICAgIHJldHVybiByZXMub2soe1xuICAgICAgICBib2R5OiB7XG4gICAgICAgICAgb2s6IHRydWUsXG4gICAgICAgICAgZmluZGluZ3MsXG4gICAgICAgICAgdG90YWxGaW5kaW5ncyxcbiAgICAgICAgfSxcbiAgICAgIH0pO1xuICAgIH0gY2F0Y2ggKGVycikge1xuICAgICAgY29uc29sZS5sb2coZXJyLm1lc3NhZ2UpO1xuICAgICAgcmV0dXJuIHJlcy5vayh7XG4gICAgICAgIGJvZHk6IHtcbiAgICAgICAgICBvazogZmFsc2UsXG4gICAgICAgICAgZXJyOiBlcnIubWVzc2FnZSxcbiAgICAgICAgfSxcbiAgICAgIH0pO1xuICAgIH1cbiAgfTtcbn1cbiJdLCJtYXBwaW5ncyI6Ijs7Ozs7O0FBS0EsSUFBQUEsT0FBQSxHQUFBQyxzQkFBQSxDQUFBQyxPQUFBO0FBQ0EsSUFBQUMsd0JBQUEsR0FBQUQsT0FBQTtBQUFvRSxTQUFBRCx1QkFBQUcsR0FBQSxXQUFBQSxHQUFBLElBQUFBLEdBQUEsQ0FBQUMsVUFBQSxHQUFBRCxHQUFBLEtBQUFFLE9BQUEsRUFBQUYsR0FBQTtBQUFBLFNBQUFHLGdCQUFBSCxHQUFBLEVBQUFJLEdBQUEsRUFBQUMsS0FBQSxJQUFBRCxHQUFBLEdBQUFFLGNBQUEsQ0FBQUYsR0FBQSxPQUFBQSxHQUFBLElBQUFKLEdBQUEsSUFBQU8sTUFBQSxDQUFBQyxjQUFBLENBQUFSLEdBQUEsRUFBQUksR0FBQSxJQUFBQyxLQUFBLEVBQUFBLEtBQUEsRUFBQUksVUFBQSxRQUFBQyxZQUFBLFFBQUFDLFFBQUEsb0JBQUFYLEdBQUEsQ0FBQUksR0FBQSxJQUFBQyxLQUFBLFdBQUFMLEdBQUE7QUFBQSxTQUFBTSxlQUFBTSxHQUFBLFFBQUFSLEdBQUEsR0FBQVMsWUFBQSxDQUFBRCxHQUFBLDJCQUFBUixHQUFBLGdCQUFBQSxHQUFBLEdBQUFVLE1BQUEsQ0FBQVYsR0FBQTtBQUFBLFNBQUFTLGFBQUFFLEtBQUEsRUFBQUMsSUFBQSxlQUFBRCxLQUFBLGlCQUFBQSxLQUFBLGtCQUFBQSxLQUFBLE1BQUFFLElBQUEsR0FBQUYsS0FBQSxDQUFBRyxNQUFBLENBQUFDLFdBQUEsT0FBQUYsSUFBQSxLQUFBRyxTQUFBLFFBQUFDLEdBQUEsR0FBQUosSUFBQSxDQUFBSyxJQUFBLENBQUFQLEtBQUEsRUFBQUMsSUFBQSwyQkFBQUssR0FBQSxzQkFBQUEsR0FBQSxZQUFBRSxTQUFBLDREQUFBUCxJQUFBLGdCQUFBRixNQUFBLEdBQUFVLE1BQUEsRUFBQVQsS0FBQSxLQU5wRTtBQUNBO0FBQ0E7QUFDQTtBQUtBO0FBQ08sTUFBTVUsd0JBQXdCLEdBQUFDLE9BQUEsQ0FBQUQsd0JBQUEsR0FBRztFQUN0Q0UsS0FBSyxFQUFFLE9BQU87RUFDZEMsWUFBWSxFQUFFLGNBQWM7RUFDNUJDLFNBQVMsRUFBRTtBQUNiLENBQUM7O0FBRUQ7QUFDQTtBQUNPLE1BQU1DLDJCQUEyQixHQUFBSixPQUFBLENBQUFJLDJCQUFBLEdBQUc7RUFDekM7RUFDQUMsRUFBRSxFQUFFWCxTQUFTO0VBQ2JZLElBQUksRUFBRSxDQUFDO0VBQ1BDLE1BQU0sRUFBRSxFQUFFO0VBQ1ZDLElBQUksRUFBRSxFQUFFO0VBQ1JDLGFBQWEsRUFBRSxNQUFNO0VBQ3JCQyxTQUFTLEVBQUVYLHdCQUF3QixDQUFDSTtBQUN0QyxDQUFDO0FBRWMsTUFBTVEsY0FBYyxTQUFTQyxnREFBdUIsQ0FBQztFQUFBQyxZQUFBLEdBQUFDLElBQUE7SUFBQSxTQUFBQSxJQUFBO0lBQUFyQyxlQUFBLHNCQUNwRCxPQUFPc0MsT0FBTyxFQUFFQyxHQUFHLEVBQUVyQixHQUFHLEtBQUs7TUFDekMsTUFBTTtRQUNKVSxFQUFFLEdBQUdELDJCQUEyQixDQUFDQyxFQUFFO1FBQ25DQyxJQUFJLEdBQUdGLDJCQUEyQixDQUFDRSxJQUFJO1FBQ3ZDRSxJQUFJLEdBQUdKLDJCQUEyQixDQUFDSSxJQUFJO1FBQ3ZDRCxNQUFNLEdBQUdILDJCQUEyQixDQUFDRyxNQUFNO1FBQzNDRSxhQUFhLEdBQUdMLDJCQUEyQixDQUFDSyxhQUFhO1FBQ3pEQyxTQUFTLEdBQUdOLDJCQUEyQixDQUFDTTtNQUMxQyxDQUFDLEdBQUdNLEdBQUcsQ0FBQ0MsS0FBSztNQUViLElBQUlDLE1BQU07TUFDVixRQUFRUixTQUFTO1FBQ2YsS0FBS1gsd0JBQXdCLENBQUNFLEtBQUs7VUFDakNpQixNQUFNLEdBQUc7WUFDUEMsVUFBVSxFQUFHLEdBQUVULFNBQVUsVUFBUztZQUNsQ1UsU0FBUyxFQUFFWDtVQUNiLENBQUM7VUFDRDtRQUNGLEtBQUtWLHdCQUF3QixDQUFDRyxZQUFZO1VBQ3hDZ0IsTUFBTSxHQUFHO1lBQ1BDLFVBQVUsRUFBRyxHQUFFVCxTQUFVLFVBQVM7WUFDbENVLFNBQVMsRUFBRVg7VUFDYixDQUFDO1VBQ0Q7UUFDRjtVQUNFO1VBQ0FTLE1BQU0sR0FBRztZQUNQQyxVQUFVLEVBQUVwQix3QkFBd0IsQ0FBQ0ksU0FBUztZQUM5Q2lCLFNBQVMsRUFBRVg7VUFDYixDQUFDO01BQ0w7TUFFQSxJQUFJLENBQUNZLGVBQUMsQ0FBQ0MsT0FBTyxDQUFDakIsRUFBRSxDQUFDLEVBQUVhLE1BQU0sQ0FBQ0ssU0FBUyxHQUFHbEIsRUFBRTtNQUN6Q2EsTUFBTSxDQUFDTSxVQUFVLEdBQUdsQixJQUFJO01BQ3hCWSxNQUFNLENBQUNWLElBQUksR0FBR0EsSUFBSTtNQUNsQlUsTUFBTSxDQUFDTyxZQUFZLEdBQUdsQixNQUFNO01BQzVCLElBQUlBLE1BQU0sQ0FBQ21CLElBQUksQ0FBQyxDQUFDLEVBQUVSLE1BQU0sQ0FBQ08sWUFBWSxHQUFJLElBQUdsQixNQUFNLENBQUNtQixJQUFJLENBQUMsQ0FBQyxDQUFDQyxLQUFLLENBQUMsR0FBRyxDQUFDLENBQUNDLElBQUksQ0FBQyxLQUFLLENBQUUsR0FBRTtNQUVwRixNQUFNQyxNQUFNLEdBQUcsSUFBSSxDQUFDQywwQkFBMEIsQ0FBQ2YsT0FBTyxFQUFFQyxHQUFHLENBQUM7TUFDNUQsSUFBSTtRQUNGLE1BQU1lLElBQUksR0FBRyxNQUFNRixNQUFNLENBQUMsc0JBQXNCLEVBQUVYLE1BQU0sQ0FBQztRQUN6RCxNQUFNYyxRQUFRLEdBQUdELElBQUksQ0FBQ0MsUUFBUSxDQUFDQyxHQUFHLENBQUVDLE1BQU0sS0FBTTtVQUFFLENBQUNBLE1BQU0sQ0FBQ0MsT0FBTyxDQUFDOUIsRUFBRSxHQUFHO1lBQUUsR0FBRzZCO1VBQU87UUFBRSxDQUFDLENBQUMsQ0FBQztRQUN4RixNQUFNRSxhQUFhLEdBQUdMLElBQUksQ0FBQ0ssYUFBYTtRQUN4QyxPQUFPekMsR0FBRyxDQUFDMEMsRUFBRSxDQUFDO1VBQ1pDLElBQUksRUFBRTtZQUNKRCxFQUFFLEVBQUUsSUFBSTtZQUNSTCxRQUFRO1lBQ1JJO1VBQ0Y7UUFDRixDQUFDLENBQUM7TUFDSixDQUFDLENBQUMsT0FBT0csR0FBRyxFQUFFO1FBQ1pDLE9BQU8sQ0FBQ0MsR0FBRyxDQUFDRixHQUFHLENBQUNHLE9BQU8sQ0FBQztRQUN4QixPQUFPL0MsR0FBRyxDQUFDMEMsRUFBRSxDQUFDO1VBQ1pDLElBQUksRUFBRTtZQUNKRCxFQUFFLEVBQUUsS0FBSztZQUNURSxHQUFHLEVBQUVBLEdBQUcsQ0FBQ0c7VUFDWDtRQUNGLENBQUMsQ0FBQztNQUNKO0lBQ0YsQ0FBQztFQUFBO0FBQ0g7QUFBQzFDLE9BQUEsQ0FBQXhCLE9BQUEsR0FBQW1DLGNBQUEifQ==