# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class DataLakeAnalyticsAccountUpdateParameters(Model):
    """The parameters that can be used to update an existing Data Lake Analytics
    account.

    :param tags: Resource tags
    :type tags: dict
    :param max_degree_of_parallelism: the maximum supported degree of
     parallelism for this account.
    :type max_degree_of_parallelism: int
    :param query_store_retention: the number of days that job metadata is
     retained.
    :type query_store_retention: int
    :param max_job_count: the maximum supported jobs running under the account
     at the same time.
    :type max_job_count: int
    :param new_tier: the commitment tier to use for next month. Possible
     values include: 'Consumption', 'Commitment_100AUHours',
     'Commitment_500AUHours', 'Commitment_1000AUHours',
     'Commitment_5000AUHours', 'Commitment_10000AUHours',
     'Commitment_50000AUHours', 'Commitment_100000AUHours',
     'Commitment_500000AUHours'
    :type new_tier: str or :class:`TierType
     <azure.mgmt.datalake.analytics.account.models.TierType>`
    :param firewall_state: The current state of the IP address firewall for
     this Data Lake Analytics account. Possible values include: 'Enabled',
     'Disabled'
    :type firewall_state: str or :class:`FirewallState
     <azure.mgmt.datalake.analytics.account.models.FirewallState>`
    :param firewall_allow_azure_ips: The current state of allowing or
     disallowing IPs originating within Azure through the firewall. If the
     firewall is disabled, this is not enforced. Possible values include:
     'Enabled', 'Disabled'
    :type firewall_allow_azure_ips: str or :class:`FirewallAllowAzureIpsState
     <azure.mgmt.datalake.analytics.account.models.FirewallAllowAzureIpsState>`
    :param firewall_rules: The list of firewall rules associated with this
     Data Lake Analytics account.
    :type firewall_rules: list of :class:`FirewallRule
     <azure.mgmt.datalake.analytics.account.models.FirewallRule>`
    :param max_degree_of_parallelism_per_job: the maximum supported degree of
     parallelism per job for this account.
    :type max_degree_of_parallelism_per_job: int
    :param min_priority_per_job: the minimum supported priority per job for
     this account.
    :type min_priority_per_job: int
    :param compute_policies: the list of existing compute policies to update
     in this account.
    :type compute_policies: list of :class:`ComputePolicy
     <azure.mgmt.datalake.analytics.account.models.ComputePolicy>`
    """

    _validation = {
        'max_degree_of_parallelism': {'minimum': 1},
        'query_store_retention': {'maximum': 180, 'minimum': 1},
        'max_job_count': {'minimum': 1},
        'max_degree_of_parallelism_per_job': {'minimum': 1},
        'min_priority_per_job': {'minimum': 1},
    }

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
        'max_degree_of_parallelism': {'key': 'properties.maxDegreeOfParallelism', 'type': 'int'},
        'query_store_retention': {'key': 'properties.queryStoreRetention', 'type': 'int'},
        'max_job_count': {'key': 'properties.maxJobCount', 'type': 'int'},
        'new_tier': {'key': 'properties.newTier', 'type': 'TierType'},
        'firewall_state': {'key': 'properties.firewallState', 'type': 'FirewallState'},
        'firewall_allow_azure_ips': {'key': 'properties.firewallAllowAzureIps', 'type': 'FirewallAllowAzureIpsState'},
        'firewall_rules': {'key': 'properties.firewallRules', 'type': '[FirewallRule]'},
        'max_degree_of_parallelism_per_job': {'key': 'properties.maxDegreeOfParallelismPerJob', 'type': 'int'},
        'min_priority_per_job': {'key': 'properties.minPriorityPerJob', 'type': 'int'},
        'compute_policies': {'key': 'properties.computePolicies', 'type': '[ComputePolicy]'},
    }

    def __init__(self, tags=None, max_degree_of_parallelism=None, query_store_retention=None, max_job_count=None, new_tier=None, firewall_state=None, firewall_allow_azure_ips=None, firewall_rules=None, max_degree_of_parallelism_per_job=None, min_priority_per_job=None, compute_policies=None):
        self.tags = tags
        self.max_degree_of_parallelism = max_degree_of_parallelism
        self.query_store_retention = query_store_retention
        self.max_job_count = max_job_count
        self.new_tier = new_tier
        self.firewall_state = firewall_state
        self.firewall_allow_azure_ips = firewall_allow_azure_ips
        self.firewall_rules = firewall_rules
        self.max_degree_of_parallelism_per_job = max_degree_of_parallelism_per_job
        self.min_priority_per_job = min_priority_per_job
        self.compute_policies = compute_policies
