# --------------------------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
#
# Code generated by aaz-dev-tools
# --------------------------------------------------------------------------------------------

# pylint: skip-file
# flake8: noqa

from azure.cli.core.aaz import *


@register_command(
    "vm host show",
)
class Show(AAZCommand):
    """Get the details of a dedicated host.

    :example: Get the details of a dedicated host.
        az vm host show --host-group MyHostGroup --name MyDedicatedHost --resource-group MyResourceGroup
    """

    _aaz_info = {
        "version": "2022-11-01",
        "resources": [
            ["mgmt-plane", "/subscriptions/{}/resourcegroups/{}/providers/microsoft.compute/hostgroups/{}/hosts/{}", "2022-11-01"],
        ]
    }

    def _handler(self, command_args):
        super()._handler(command_args)
        self._execute_operations()
        return self._output()

    _args_schema = None

    @classmethod
    def _build_arguments_schema(cls, *args, **kwargs):
        if cls._args_schema is not None:
            return cls._args_schema
        cls._args_schema = super()._build_arguments_schema(*args, **kwargs)

        # define Arg Group ""

        _args_schema = cls._args_schema
        _args_schema.host_group_name = AAZStrArg(
            options=["--host-group", "--host-group-name"],
            help="The name of the dedicated host group.",
            required=True,
            id_part="name",
        )
        _args_schema.host_name = AAZStrArg(
            options=["-n", "--name", "--host-name"],
            help="The name of the dedicated host.",
            required=True,
            id_part="child_name_1",
        )
        _args_schema.resource_group = AAZResourceGroupNameArg(
            help="Name of resource group. You can configure the default group using `az configure --defaults group=<name>`.",
            required=True,
        )
        _args_schema.expand = AAZStrArg(
            options=["--expand"],
            help="The expand expression to apply on the operation. 'InstanceView' will retrieve the list of instance views of the dedicated host. 'UserData' is not supported for dedicated host.",
            enum={"instanceView": "instanceView", "userData": "userData"},
        )
        return cls._args_schema

    def _execute_operations(self):
        self.pre_operations()
        self.DedicatedHostsGet(ctx=self.ctx)()
        self.post_operations()

    @register_callback
    def pre_operations(self):
        pass

    @register_callback
    def post_operations(self):
        pass

    def _output(self, *args, **kwargs):
        result = self.deserialize_output(self.ctx.vars.instance, client_flatten=True)
        return result

    class DedicatedHostsGet(AAZHttpOperation):
        CLIENT_TYPE = "MgmtClient"

        def __call__(self, *args, **kwargs):
            request = self.make_request()
            session = self.client.send_request(request=request, stream=False, **kwargs)
            if session.http_response.status_code in [200]:
                return self.on_200(session)

            return self.on_error(session.http_response)

        @property
        def url(self):
            return self.client.format_url(
                "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/hostGroups/{hostGroupName}/hosts/{hostName}",
                **self.url_parameters
            )

        @property
        def method(self):
            return "GET"

        @property
        def error_format(self):
            return "ODataV4Format"

        @property
        def url_parameters(self):
            parameters = {
                **self.serialize_url_param(
                    "hostGroupName", self.ctx.args.host_group_name,
                    required=True,
                ),
                **self.serialize_url_param(
                    "hostName", self.ctx.args.host_name,
                    required=True,
                ),
                **self.serialize_url_param(
                    "resourceGroupName", self.ctx.args.resource_group,
                    required=True,
                ),
                **self.serialize_url_param(
                    "subscriptionId", self.ctx.subscription_id,
                    required=True,
                ),
            }
            return parameters

        @property
        def query_parameters(self):
            parameters = {
                **self.serialize_query_param(
                    "$expand", self.ctx.args.expand,
                ),
                **self.serialize_query_param(
                    "api-version", "2022-11-01",
                    required=True,
                ),
            }
            return parameters

        @property
        def header_parameters(self):
            parameters = {
                **self.serialize_header_param(
                    "Accept", "application/json",
                ),
            }
            return parameters

        def on_200(self, session):
            data = self.deserialize_http_content(session)
            self.ctx.set_var(
                "instance",
                data,
                schema_builder=self._build_schema_on_200
            )

        _schema_on_200 = None

        @classmethod
        def _build_schema_on_200(cls):
            if cls._schema_on_200 is not None:
                return cls._schema_on_200

            cls._schema_on_200 = AAZObjectType()

            _schema_on_200 = cls._schema_on_200
            _schema_on_200.id = AAZStrType(
                flags={"read_only": True},
            )
            _schema_on_200.location = AAZStrType(
                flags={"required": True},
            )
            _schema_on_200.name = AAZStrType(
                flags={"read_only": True},
            )
            _schema_on_200.properties = AAZObjectType(
                flags={"client_flatten": True},
            )
            _schema_on_200.sku = AAZObjectType(
                flags={"required": True},
            )
            _schema_on_200.tags = AAZDictType()
            _schema_on_200.type = AAZStrType(
                flags={"read_only": True},
            )

            properties = cls._schema_on_200.properties
            properties.auto_replace_on_failure = AAZBoolType(
                serialized_name="autoReplaceOnFailure",
            )
            properties.host_id = AAZStrType(
                serialized_name="hostId",
                flags={"read_only": True},
            )
            properties.instance_view = AAZObjectType(
                serialized_name="instanceView",
            )
            properties.license_type = AAZStrType(
                serialized_name="licenseType",
            )
            properties.platform_fault_domain = AAZIntType(
                serialized_name="platformFaultDomain",
            )
            properties.provisioning_state = AAZStrType(
                serialized_name="provisioningState",
                flags={"read_only": True},
            )
            properties.provisioning_time = AAZStrType(
                serialized_name="provisioningTime",
                flags={"read_only": True},
            )
            properties.time_created = AAZStrType(
                serialized_name="timeCreated",
                flags={"read_only": True},
            )
            properties.virtual_machines = AAZListType(
                serialized_name="virtualMachines",
                flags={"read_only": True},
            )

            instance_view = cls._schema_on_200.properties.instance_view
            instance_view.asset_id = AAZStrType(
                serialized_name="assetId",
                flags={"read_only": True},
            )
            instance_view.available_capacity = AAZObjectType(
                serialized_name="availableCapacity",
            )
            instance_view.statuses = AAZListType()

            available_capacity = cls._schema_on_200.properties.instance_view.available_capacity
            available_capacity.allocatable_v_ms = AAZListType(
                serialized_name="allocatableVMs",
            )

            allocatable_v_ms = cls._schema_on_200.properties.instance_view.available_capacity.allocatable_v_ms
            allocatable_v_ms.Element = AAZObjectType()

            _element = cls._schema_on_200.properties.instance_view.available_capacity.allocatable_v_ms.Element
            _element.count = AAZFloatType()
            _element.vm_size = AAZStrType(
                serialized_name="vmSize",
            )

            statuses = cls._schema_on_200.properties.instance_view.statuses
            statuses.Element = AAZObjectType()

            _element = cls._schema_on_200.properties.instance_view.statuses.Element
            _element.code = AAZStrType()
            _element.display_status = AAZStrType(
                serialized_name="displayStatus",
            )
            _element.level = AAZStrType()
            _element.message = AAZStrType()
            _element.time = AAZStrType()

            virtual_machines = cls._schema_on_200.properties.virtual_machines
            virtual_machines.Element = AAZObjectType()

            _element = cls._schema_on_200.properties.virtual_machines.Element
            _element.id = AAZStrType(
                flags={"read_only": True},
            )

            sku = cls._schema_on_200.sku
            sku.capacity = AAZIntType()
            sku.name = AAZStrType()
            sku.tier = AAZStrType()

            tags = cls._schema_on_200.tags
            tags.Element = AAZStrType()

            return cls._schema_on_200


class _ShowHelper:
    """Helper class for Show"""


__all__ = ["Show"]
