/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.cmce;

import org.bouncycastle.math.raw.Interleave;
import org.bouncycastle.pqc.crypto.cmce.GF;

final class GF13
extends GF {
    GF13() {
    }

    @Override
    protected void gf_mul_poly(int length, int[] poly, short[] out, short[] left, short[] right, int[] temp) {
        int i;
        temp[0] = this.gf_mul_ext(left[0], right[0]);
        for (i = 1; i < length; ++i) {
            temp[i + i - 1] = 0;
            short left_i = left[i];
            short right_i = right[i];
            for (int j = 0; j < i; ++j) {
                int n = i + j;
                temp[n] = temp[n] ^ this.gf_mul_ext_par(left_i, right[j], left[j], right_i);
            }
            temp[i + i] = this.gf_mul_ext(left_i, right_i);
        }
        for (i = (length - 1) * 2; i >= length; --i) {
            int temp_i = temp[i];
            for (int j = 0; j < poly.length; ++j) {
                int n = i - length + poly[j];
                temp[n] = temp[n] ^ temp_i;
            }
        }
        for (i = 0; i < length; ++i) {
            out[i] = this.gf_reduce(temp[i]);
        }
    }

    @Override
    protected void gf_sqr_poly(int length, int[] poly, short[] out, short[] input, int[] temp) {
        int i;
        temp[0] = this.gf_sq_ext(input[0]);
        for (i = 1; i < length; ++i) {
            temp[i + i - 1] = 0;
            temp[i + i] = this.gf_sq_ext(input[i]);
        }
        for (i = (length - 1) * 2; i >= length; --i) {
            int temp_i = temp[i];
            for (int j = 0; j < poly.length; ++j) {
                int n = i - length + poly[j];
                temp[n] = temp[n] ^ temp_i;
            }
        }
        for (i = 0; i < length; ++i) {
            out[i] = this.gf_reduce(temp[i]);
        }
    }

    @Override
    protected short gf_frac(short den, short num) {
        short tmp_11 = this.gf_sqmul(den, den);
        short tmp_1111 = this.gf_sq2mul(tmp_11, tmp_11);
        short out = this.gf_sq2(tmp_1111);
        out = this.gf_sq2mul(out, tmp_1111);
        out = this.gf_sq2(out);
        out = this.gf_sq2mul(out, tmp_1111);
        return this.gf_sqmul(out, num);
    }

    @Override
    protected short gf_inv(short den) {
        return this.gf_frac(den, (short)1);
    }

    @Override
    protected short gf_mul(short in0, short in1) {
        short x = in0;
        short y = in1;
        int z = x * (y & 1);
        for (int i = 1; i < 13; ++i) {
            z ^= x * (y & 1 << i);
        }
        return this.gf_reduce(z);
    }

    @Override
    protected int gf_mul_ext(short in0, short in1) {
        short x = in0;
        short y = in1;
        int z = x * (y & 1);
        for (int i = 1; i < 13; ++i) {
            z ^= x * (y & 1 << i);
        }
        return z;
    }

    private int gf_mul_ext_par(short in0, short in1, short in2, short in3) {
        short x0 = in0;
        short y0 = in1;
        short x1 = in2;
        short y1 = in3;
        int z0 = x0 * (y0 & 1);
        int z1 = x1 * (y1 & 1);
        for (int i = 1; i < 13; ++i) {
            z0 ^= x0 * (y0 & 1 << i);
            z1 ^= x1 * (y1 & 1 << i);
        }
        return z0 ^ z1;
    }

    @Override
    protected short gf_reduce(int x) {
        int u0 = x & 0x1FFF;
        int u1 = x >>> 13;
        int t2 = u1 << 4 ^ u1 << 3 ^ u1 << 1;
        int u2 = t2 >>> 13;
        int u3 = t2 & 0x1FFF;
        int u4 = u2 << 4 ^ u2 << 3 ^ u2 << 1;
        return (short)(u0 ^ u1 ^ u2 ^ u3 ^ u4);
    }

    @Override
    protected short gf_sq(short input) {
        int z = Interleave.expand16to32(input);
        return this.gf_reduce(z);
    }

    @Override
    protected int gf_sq_ext(short input) {
        return Interleave.expand16to32(input);
    }

    private short gf_sq2(short in) {
        int z1 = Interleave.expand16to32(in);
        in = this.gf_reduce(z1);
        int z2 = Interleave.expand16to32(in);
        return this.gf_reduce(z2);
    }

    private short gf_sqmul(short in, short m) {
        long t0 = in;
        long t1 = m;
        long x = (t1 << 6) * (t0 & 0x40L);
        t0 ^= t0 << 7;
        x ^= (t1 << 0) * (t0 & 0x4001L);
        x ^= (t1 << 1) * (t0 & 0x8002L);
        x ^= (t1 << 2) * (t0 & 0x10004L);
        x ^= (t1 << 3) * (t0 & 0x20008L);
        x ^= (t1 << 4) * (t0 & 0x40010L);
        long t = (x ^= (t1 << 5) * (t0 & 0x80020L)) & 0x1FFC000000L;
        return this.gf_reduce((int)(x ^= t >>> 18 ^ t >>> 20 ^ t >>> 24 ^ t >>> 26) & 0x3FFFFFF);
    }

    private short gf_sq2mul(short in, short m) {
        long t0 = in;
        long t1 = m;
        long x = (t1 << 18) * (t0 & 0x40L);
        t0 ^= t0 << 21;
        x ^= (t1 << 0) * (t0 & 0x10000001L);
        x ^= (t1 << 3) * (t0 & 0x20000002L);
        x ^= (t1 << 6) * (t0 & 0x40000004L);
        x ^= (t1 << 9) * (t0 & 0x80000008L);
        x ^= (t1 << 12) * (t0 & 0x100000010L);
        long t = (x ^= (t1 << 15) * (t0 & 0x200000020L)) & 0x1FFFF80000000000L;
        x ^= t >>> 18 ^ t >>> 20 ^ t >>> 24 ^ t >>> 26;
        t = x & 0x7FFFC000000L;
        return this.gf_reduce((int)(x ^= t >>> 18 ^ t >>> 20 ^ t >>> 24 ^ t >>> 26) & 0x3FFFFFF);
    }
}

