/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.slhdsa;

import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.Xof;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.bouncycastle.crypto.digests.SHA512Digest;
import org.bouncycastle.crypto.digests.SHAKEDigest;
import org.bouncycastle.crypto.generators.MGF1BytesGenerator;
import org.bouncycastle.crypto.macs.HMac;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.MGFParameters;
import org.bouncycastle.pqc.crypto.slhdsa.ADRS;
import org.bouncycastle.pqc.crypto.slhdsa.IndexedDigest;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Bytes;
import org.bouncycastle.util.Memoable;
import org.bouncycastle.util.Pack;

abstract class SLHDSAEngine {
    final int N;
    final int WOTS_W;
    final int WOTS_LOGW;
    final int WOTS_LEN;
    final int WOTS_LEN1;
    final int WOTS_LEN2;
    final int D;
    final int A;
    final int K;
    final int H;
    final int H_PRIME;
    final int T;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public SLHDSAEngine(int n, int w, int d, int a, int k, int h) {
        this.N = n;
        if (w == 16) {
            this.WOTS_LOGW = 4;
            this.WOTS_LEN1 = 8 * this.N / this.WOTS_LOGW;
            if (this.N <= 8) {
                this.WOTS_LEN2 = 2;
            } else if (this.N <= 136) {
                this.WOTS_LEN2 = 3;
            } else {
                if (this.N > 256) throw new IllegalArgumentException("cannot precompute SPX_WOTS_LEN2 for n outside {2, .., 256}");
                this.WOTS_LEN2 = 4;
            }
        } else {
            if (w != 256) throw new IllegalArgumentException("wots_w assumed 16 or 256");
            this.WOTS_LOGW = 8;
            this.WOTS_LEN1 = 8 * this.N / this.WOTS_LOGW;
            if (this.N <= 1) {
                this.WOTS_LEN2 = 1;
            } else {
                if (this.N > 256) throw new IllegalArgumentException("cannot precompute SPX_WOTS_LEN2 for n outside {2, .., 256}");
                this.WOTS_LEN2 = 2;
            }
        }
        this.WOTS_W = w;
        this.WOTS_LEN = this.WOTS_LEN1 + this.WOTS_LEN2;
        this.D = d;
        this.A = a;
        this.K = k;
        this.H = h;
        this.H_PRIME = h / d;
        this.T = 1 << a;
    }

    abstract void init(byte[] var1);

    abstract byte[] F(byte[] var1, ADRS var2, byte[] var3);

    abstract byte[] H(byte[] var1, ADRS var2, byte[] var3, byte[] var4);

    abstract IndexedDigest H_msg(byte[] var1, byte[] var2, byte[] var3, byte[] var4, byte[] var5);

    abstract byte[] T_l(byte[] var1, ADRS var2, byte[] var3);

    abstract byte[] PRF(byte[] var1, byte[] var2, ADRS var3);

    abstract byte[] PRF_msg(byte[] var1, byte[] var2, byte[] var3, byte[] var4);

    static class Shake256Engine
    extends SLHDSAEngine {
        private final Xof treeDigest = new SHAKEDigest(256);
        private final Xof maskDigest = new SHAKEDigest(256);

        public Shake256Engine(int n, int w, int d, int a, int k, int h) {
            super(n, w, d, a, k, h);
        }

        @Override
        void init(byte[] pkSeed) {
        }

        @Override
        byte[] F(byte[] pkSeed, ADRS adrs, byte[] m1) {
            byte[] mTheta = m1;
            byte[] rv = new byte[this.N];
            this.treeDigest.update(pkSeed, 0, pkSeed.length);
            this.treeDigest.update(adrs.value, 0, adrs.value.length);
            this.treeDigest.update(mTheta, 0, mTheta.length);
            this.treeDigest.doFinal(rv, 0, rv.length);
            return rv;
        }

        @Override
        byte[] H(byte[] pkSeed, ADRS adrs, byte[] m1, byte[] m2) {
            byte[] rv = new byte[this.N];
            this.treeDigest.update(pkSeed, 0, pkSeed.length);
            this.treeDigest.update(adrs.value, 0, adrs.value.length);
            this.treeDigest.update(m1, 0, m1.length);
            this.treeDigest.update(m2, 0, m2.length);
            this.treeDigest.doFinal(rv, 0, rv.length);
            return rv;
        }

        @Override
        IndexedDigest H_msg(byte[] R, byte[] pkSeed, byte[] pkRoot, byte[] msgPrefix, byte[] msg) {
            int forsMsgBytes = (this.A * this.K + 7) / 8;
            int leafBits = this.H / this.D;
            int treeBits = this.H - leafBits;
            int leafBytes = (leafBits + 7) / 8;
            int treeBytes = (treeBits + 7) / 8;
            int m = forsMsgBytes + leafBytes + treeBytes;
            byte[] out = new byte[m];
            this.treeDigest.update(R, 0, R.length);
            this.treeDigest.update(pkSeed, 0, pkSeed.length);
            this.treeDigest.update(pkRoot, 0, pkRoot.length);
            if (msgPrefix != null) {
                this.treeDigest.update(msgPrefix, 0, msgPrefix.length);
            }
            this.treeDigest.update(msg, 0, msg.length);
            this.treeDigest.doFinal(out, 0, out.length);
            byte[] treeIndexBuf = new byte[8];
            System.arraycopy(out, forsMsgBytes, treeIndexBuf, 8 - treeBytes, treeBytes);
            long treeIndex = Pack.bigEndianToLong(treeIndexBuf, 0);
            byte[] leafIndexBuf = new byte[4];
            System.arraycopy(out, forsMsgBytes + treeBytes, leafIndexBuf, 4 - leafBytes, leafBytes);
            int leafIndex = Pack.bigEndianToInt(leafIndexBuf, 0);
            return new IndexedDigest(treeIndex &= -1L >>> 64 - treeBits, leafIndex &= -1 >>> 32 - leafBits, Arrays.copyOfRange(out, 0, forsMsgBytes));
        }

        @Override
        byte[] T_l(byte[] pkSeed, ADRS adrs, byte[] m) {
            byte[] mTheta = m;
            byte[] rv = new byte[this.N];
            this.treeDigest.update(pkSeed, 0, pkSeed.length);
            this.treeDigest.update(adrs.value, 0, adrs.value.length);
            this.treeDigest.update(mTheta, 0, mTheta.length);
            this.treeDigest.doFinal(rv, 0, rv.length);
            return rv;
        }

        @Override
        byte[] PRF(byte[] pkSeed, byte[] skSeed, ADRS adrs) {
            this.treeDigest.update(pkSeed, 0, pkSeed.length);
            this.treeDigest.update(adrs.value, 0, adrs.value.length);
            this.treeDigest.update(skSeed, 0, skSeed.length);
            byte[] prf = new byte[this.N];
            this.treeDigest.doFinal(prf, 0, this.N);
            return prf;
        }

        @Override
        public byte[] PRF_msg(byte[] prf, byte[] randomiser, byte[] msgPrefix, byte[] msg) {
            this.treeDigest.update(prf, 0, prf.length);
            this.treeDigest.update(randomiser, 0, randomiser.length);
            if (msgPrefix != null) {
                this.treeDigest.update(msgPrefix, 0, msgPrefix.length);
            }
            this.treeDigest.update(msg, 0, msg.length);
            byte[] out = new byte[this.N];
            this.treeDigest.doFinal(out, 0, out.length);
            return out;
        }

        protected byte[] bitmask(byte[] pkSeed, ADRS adrs, byte[] m) {
            byte[] mask = new byte[m.length];
            this.maskDigest.update(pkSeed, 0, pkSeed.length);
            this.maskDigest.update(adrs.value, 0, adrs.value.length);
            this.maskDigest.doFinal(mask, 0, mask.length);
            Bytes.xorTo(m.length, m, mask);
            return mask;
        }

        protected byte[] bitmask(byte[] pkSeed, ADRS adrs, byte[] m1, byte[] m2) {
            byte[] mask = new byte[m1.length + m2.length];
            this.maskDigest.update(pkSeed, 0, pkSeed.length);
            this.maskDigest.update(adrs.value, 0, adrs.value.length);
            this.maskDigest.doFinal(mask, 0, mask.length);
            Bytes.xorTo(m1.length, m1, mask);
            Bytes.xorTo(m2.length, m2, 0, mask, m1.length);
            return mask;
        }
    }

    static class Sha2Engine
    extends SLHDSAEngine {
        private final HMac treeHMac;
        private final MGF1BytesGenerator mgf1;
        private final byte[] hmacBuf;
        private final Digest msgDigest;
        private final byte[] msgDigestBuf;
        private final int bl;
        private final Digest sha256 = new SHA256Digest();
        private final byte[] sha256Buf = new byte[this.sha256.getDigestSize()];
        private Memoable msgMemo;
        private Memoable sha256Memo;

        public Sha2Engine(int n, int w, int d, int a, int k, int h) {
            super(n, w, d, a, k, h);
            if (n == 16) {
                this.msgDigest = new SHA256Digest();
                this.treeHMac = new HMac(new SHA256Digest());
                this.mgf1 = new MGF1BytesGenerator(new SHA256Digest());
                this.bl = 64;
            } else {
                this.msgDigest = new SHA512Digest();
                this.treeHMac = new HMac(new SHA512Digest());
                this.mgf1 = new MGF1BytesGenerator(new SHA512Digest());
                this.bl = 128;
            }
            this.hmacBuf = new byte[this.treeHMac.getMacSize()];
            this.msgDigestBuf = new byte[this.msgDigest.getDigestSize()];
        }

        @Override
        void init(byte[] pkSeed) {
            byte[] padding = new byte[this.bl];
            this.msgDigest.update(pkSeed, 0, pkSeed.length);
            this.msgDigest.update(padding, 0, this.bl - this.N);
            this.msgMemo = ((Memoable)((Object)this.msgDigest)).copy();
            this.msgDigest.reset();
            this.sha256.update(pkSeed, 0, pkSeed.length);
            this.sha256.update(padding, 0, 64 - pkSeed.length);
            this.sha256Memo = ((Memoable)((Object)this.sha256)).copy();
            this.sha256.reset();
        }

        @Override
        public byte[] F(byte[] pkSeed, ADRS adrs, byte[] m1) {
            byte[] compressedADRS = this.compressedADRS(adrs);
            ((Memoable)((Object)this.sha256)).reset(this.sha256Memo);
            this.sha256.update(compressedADRS, 0, compressedADRS.length);
            this.sha256.update(m1, 0, m1.length);
            this.sha256.doFinal(this.sha256Buf, 0);
            return Arrays.copyOfRange(this.sha256Buf, 0, this.N);
        }

        @Override
        public byte[] H(byte[] pkSeed, ADRS adrs, byte[] m1, byte[] m2) {
            byte[] compressedADRS = this.compressedADRS(adrs);
            ((Memoable)((Object)this.msgDigest)).reset(this.msgMemo);
            this.msgDigest.update(compressedADRS, 0, compressedADRS.length);
            this.msgDigest.update(m1, 0, m1.length);
            this.msgDigest.update(m2, 0, m2.length);
            this.msgDigest.doFinal(this.msgDigestBuf, 0);
            return Arrays.copyOfRange(this.msgDigestBuf, 0, this.N);
        }

        @Override
        IndexedDigest H_msg(byte[] prf, byte[] pkSeed, byte[] pkRoot, byte[] msgPrefix, byte[] msg) {
            int forsMsgBytes = (this.A * this.K + 7) / 8;
            int leafBits = this.H / this.D;
            int treeBits = this.H - leafBits;
            int leafBytes = (leafBits + 7) / 8;
            int treeBytes = (treeBits + 7) / 8;
            int m = forsMsgBytes + leafBytes + treeBytes;
            byte[] out = new byte[m];
            byte[] dig = new byte[this.msgDigest.getDigestSize()];
            this.msgDigest.update(prf, 0, prf.length);
            this.msgDigest.update(pkSeed, 0, pkSeed.length);
            this.msgDigest.update(pkRoot, 0, pkRoot.length);
            if (msgPrefix != null) {
                this.msgDigest.update(msgPrefix, 0, msgPrefix.length);
            }
            this.msgDigest.update(msg, 0, msg.length);
            this.msgDigest.doFinal(dig, 0);
            out = this.bitmask(Arrays.concatenate(prf, pkSeed, dig), out);
            byte[] treeIndexBuf = new byte[8];
            System.arraycopy(out, forsMsgBytes, treeIndexBuf, 8 - treeBytes, treeBytes);
            long treeIndex = Pack.bigEndianToLong(treeIndexBuf, 0);
            byte[] leafIndexBuf = new byte[4];
            System.arraycopy(out, forsMsgBytes + treeBytes, leafIndexBuf, 4 - leafBytes, leafBytes);
            int leafIndex = Pack.bigEndianToInt(leafIndexBuf, 0);
            return new IndexedDigest(treeIndex &= -1L >>> 64 - treeBits, leafIndex &= -1 >>> 32 - leafBits, Arrays.copyOfRange(out, 0, forsMsgBytes));
        }

        @Override
        public byte[] T_l(byte[] pkSeed, ADRS adrs, byte[] m) {
            byte[] compressedADRS = this.compressedADRS(adrs);
            ((Memoable)((Object)this.msgDigest)).reset(this.msgMemo);
            this.msgDigest.update(compressedADRS, 0, compressedADRS.length);
            this.msgDigest.update(m, 0, m.length);
            this.msgDigest.doFinal(this.msgDigestBuf, 0);
            return Arrays.copyOfRange(this.msgDigestBuf, 0, this.N);
        }

        @Override
        byte[] PRF(byte[] pkSeed, byte[] skSeed, ADRS adrs) {
            int n = skSeed.length;
            ((Memoable)((Object)this.sha256)).reset(this.sha256Memo);
            byte[] compressedADRS = this.compressedADRS(adrs);
            this.sha256.update(compressedADRS, 0, compressedADRS.length);
            this.sha256.update(skSeed, 0, skSeed.length);
            this.sha256.doFinal(this.sha256Buf, 0);
            return Arrays.copyOfRange(this.sha256Buf, 0, n);
        }

        @Override
        public byte[] PRF_msg(byte[] prf, byte[] randomiser, byte[] msgPrefix, byte[] msg) {
            this.treeHMac.init(new KeyParameter(prf));
            this.treeHMac.update(randomiser, 0, randomiser.length);
            if (msgPrefix != null) {
                this.treeHMac.update(msgPrefix, 0, msgPrefix.length);
            }
            this.treeHMac.update(msg, 0, msg.length);
            this.treeHMac.doFinal(this.hmacBuf, 0);
            return Arrays.copyOfRange(this.hmacBuf, 0, this.N);
        }

        private byte[] compressedADRS(ADRS adrs) {
            byte[] rv = new byte[22];
            System.arraycopy(adrs.value, 3, rv, 0, 1);
            System.arraycopy(adrs.value, 8, rv, 1, 8);
            System.arraycopy(adrs.value, 19, rv, 9, 1);
            System.arraycopy(adrs.value, 20, rv, 10, 12);
            return rv;
        }

        protected byte[] bitmask(byte[] key, byte[] m) {
            byte[] mask = new byte[m.length];
            this.mgf1.init(new MGFParameters(key));
            this.mgf1.generateBytes(mask, 0, mask.length);
            Bytes.xorTo(m.length, m, mask);
            return mask;
        }

        protected byte[] bitmask(byte[] key, byte[] m1, byte[] m2) {
            byte[] mask = new byte[m1.length + m2.length];
            this.mgf1.init(new MGFParameters(key));
            this.mgf1.generateBytes(mask, 0, mask.length);
            Bytes.xorTo(m1.length, m1, mask);
            Bytes.xorTo(m2.length, m2, 0, mask, m1.length);
            return mask;
        }

        protected byte[] bitmask256(byte[] key, byte[] m) {
            byte[] mask = new byte[m.length];
            MGF1BytesGenerator mgf1 = new MGF1BytesGenerator(new SHA256Digest());
            mgf1.init(new MGFParameters(key));
            mgf1.generateBytes(mask, 0, mask.length);
            Bytes.xorTo(m.length, m, mask);
            return mask;
        }
    }
}

