;;; media-types.el --- Look up the template of a media-type
;;
;; This file was automatically generated by
;; https://github.com/for-GET/know-your-http-well
;;
;;; Commentary:
;;; Code goes here:

(defconst media-types
  '(("application/1d-interleaved-parityfec" ("https://www.iana.org/assignments/media-types/application/1d-interleaved-parityfec"))
("application/a2l" ("https://www.iana.org/assignments/media-types/application/A2L"))
("application/activemessage" ("https://www.iana.org/assignments/media-types/application/activemessage"))
("application/activemessage" ("https://www.iana.org/assignments/media-types/application/activemessage"))
("application/aml" ("https://www.iana.org/assignments/media-types/application/AML"))
("application/andrew-inset" ("https://www.iana.org/assignments/media-types/application/andrew-inset"))
("application/applefile" ("https://www.iana.org/assignments/media-types/application/applefile"))
("application/atf" ("https://www.iana.org/assignments/media-types/application/ATF"))
("application/atfx" ("https://www.iana.org/assignments/media-types/application/ATFX"))
("application/atomicmail" ("https://www.iana.org/assignments/media-types/application/atomicmail"))
("application/atxml" ("https://www.iana.org/assignments/media-types/application/ATXML"))
("application/batch-smtp" ("https://www.iana.org/assignments/media-types/application/batch-SMTP"))
("application/call-completion" ("https://www.iana.org/assignments/media-types/application/call-completion"))
("application/cals-1840" ("https://www.iana.org/assignments/media-types/application/CALS-1840"))
("application/cbor" ("https://www.iana.org/assignments/media-types/application/cbor"))
("application/cdmi-capability" ("https://www.iana.org/assignments/media-types/application/cdmi-capability"))
("application/cdmi-container" ("https://www.iana.org/assignments/media-types/application/cdmi-container"))
("application/cdmi-domain" ("https://www.iana.org/assignments/media-types/application/cdmi-domain"))
("application/cdmi-object" ("https://www.iana.org/assignments/media-types/application/cdmi-object"))
("application/cdmi-queue" ("https://www.iana.org/assignments/media-types/application/cdmi-queue"))
("application/cdni" ("https://www.iana.org/assignments/media-types/application/cdni"))
("application/cea" ("https://www.iana.org/assignments/media-types/application/CEA"))
("application/cfw" ("https://www.iana.org/assignments/media-types/application/cfw"))
("application/cms" ("https://www.iana.org/assignments/media-types/application/cms"))
("application/commonground" ("https://www.iana.org/assignments/media-types/application/commonground"))
("application/csrattrs" ("https://www.iana.org/assignments/media-types/application/csrattrs"))
("application/cybercash" ("https://www.iana.org/assignments/media-types/application/cybercash"))
("application/dashdelta" ("https://www.iana.org/assignments/media-types/application/dashdelta"))
("application/dca-rft" ("https://www.iana.org/assignments/media-types/application/dca-rft"))
("application/dcd" ("https://www.iana.org/assignments/media-types/application/DCD"))
("application/dec-dx" ("https://www.iana.org/assignments/media-types/application/dec-dx"))
("application/dicom" ("https://www.iana.org/assignments/media-types/application/dicom"))
("application/dii" ("https://www.iana.org/assignments/media-types/application/DII"))
("application/dit" ("https://www.iana.org/assignments/media-types/application/DIT"))
("application/dns" ("https://www.iana.org/assignments/media-types/application/dns"))
("application/dvcs" ("https://www.iana.org/assignments/media-types/application/dvcs"))
("application/ecmascript" ("https://www.iana.org/assignments/media-types/application/ecmascript"))
("application/edi-consent" ("https://www.iana.org/assignments/media-types/application/EDI-consent"))
("application/edifact" ("https://www.iana.org/assignments/media-types/application/EDIFACT"))
("application/edi-x12" ("https://www.iana.org/assignments/media-types/application/EDI-X12"))
("application/encaprtp" ("https://www.iana.org/assignments/media-types/application/encaprtp"))
("application/eshop" ("https://www.iana.org/assignments/media-types/application/eshop"))
("application/example" ("https://www.iana.org/assignments/media-types/application/example"))
("application/fastinfoset" ("https://www.iana.org/assignments/media-types/application/fastinfoset"))
("application/fastsoap" ("https://www.iana.org/assignments/media-types/application/fastsoap"))
("application/fits" ("https://www.iana.org/assignments/media-types/application/fits"))
("application/font-sfnt" ("https://www.iana.org/assignments/media-types/application/font-sfnt"))
("application/font-tdpfr" ("https://www.iana.org/assignments/media-types/application/font-tdpfr"))
("application/font-woff" ("https://www.iana.org/assignments/media-types/application/font-woff"))
("application/gzip" ("https://www.iana.org/assignments/media-types/application/gzip"))
("application/h224" ("https://www.iana.org/assignments/media-types/application/H224"))
("application/http" ("https://www.iana.org/assignments/media-types/application/http"))
("application/hyperstudio" ("https://www.iana.org/assignments/media-types/application/hyperstudio"))
("application/ibe-pp-data" ("https://www.iana.org/assignments/media-types/application/ibe-pp-data"))
("application/iges" ("https://www.iana.org/assignments/media-types/application/iges"))
("application/index" ("https://www.iana.org/assignments/media-types/application/index"))
("application/iotp" ("https://www.iana.org/assignments/media-types/application/IOTP"))
("application/ipfix" ("https://www.iana.org/assignments/media-types/application/ipfix"))
("application/ipp" ("https://www.iana.org/assignments/media-types/application/ipp"))
("application/isup" ("https://www.iana.org/assignments/media-types/application/ISUP"))
("application/javascript" ("https://www.iana.org/assignments/media-types/application/javascript"))
("application/jose" ("https://www.iana.org/assignments/media-types/application/jose"))
("application/json" ("https://www.iana.org/assignments/media-types/application/json"))
("application/json-seq" ("https://www.iana.org/assignments/media-types/application/json-seq"))
("application/jwt" ("https://www.iana.org/assignments/media-types/application/jwt"))
("application/link-format" ("https://www.iana.org/assignments/media-types/application/link-format"))
("application/lxf" ("https://www.iana.org/assignments/media-types/application/LXF"))
("application/mac-binhex40" ("https://www.iana.org/assignments/media-types/application/mac-binhex40"))
("application/macwriteii" ("https://www.iana.org/assignments/media-types/application/macwriteii"))
("application/marc" ("https://www.iana.org/assignments/media-types/application/marc"))
("application/mathematica" ("https://www.iana.org/assignments/media-types/application/mathematica"))
("application/mbox" ("https://www.iana.org/assignments/media-types/application/mbox"))
("application/mf4" ("https://www.iana.org/assignments/media-types/application/MF4"))
("application/mikey" ("https://www.iana.org/assignments/media-types/application/mikey"))
("application/moss-keys" ("https://www.iana.org/assignments/media-types/application/moss-keys"))
("application/moss-signature" ("https://www.iana.org/assignments/media-types/application/moss-signature"))
("application/mosskey-data" ("https://www.iana.org/assignments/media-types/application/mosskey-data"))
("application/mosskey-request" ("https://www.iana.org/assignments/media-types/application/mosskey-request"))
("application/mp21" ("https://www.iana.org/assignments/media-types/application/mp21"))
("application/mp4" ("https://www.iana.org/assignments/media-types/application/mp4"))
("application/mpeg4-generic" ("https://www.iana.org/assignments/media-types/application/mpeg4-generic"))
("application/mpeg4-iod" ("https://www.iana.org/assignments/media-types/application/mpeg4-iod"))
("application/mpeg4-iod-xmt" ("https://www.iana.org/assignments/media-types/application/mpeg4-iod-xmt"))
("application/msword" ("https://www.iana.org/assignments/media-types/application/msword"))
("application/mxf" ("https://www.iana.org/assignments/media-types/application/mxf"))
("application/nasdata" ("https://www.iana.org/assignments/media-types/application/nasdata"))
("application/news-checkgroups" ("https://www.iana.org/assignments/media-types/application/news-checkgroups"))
("application/news-groupinfo" ("https://www.iana.org/assignments/media-types/application/news-groupinfo"))
("application/news-transmission" ("https://www.iana.org/assignments/media-types/application/news-transmission"))
("application/nss" ("https://www.iana.org/assignments/media-types/application/nss"))
("application/ocsp-request" ("https://www.iana.org/assignments/media-types/application/ocsp-request"))
("application/ocsp-response" ("https://www.iana.org/assignments/media-types/application/ocsp-response"))
("application/octet-stream" ("https://www.iana.org/assignments/media-types/application/octet-stream"))
("application/oda" ("https://www.iana.org/assignments/media-types/application/ODA"))
("application/odx" ("https://www.iana.org/assignments/media-types/application/ODX"))
("application/ogg" ("https://www.iana.org/assignments/media-types/application/ogg"))
("application/oxps" ("https://www.iana.org/assignments/media-types/application/oxps"))
("application/pdf" ("https://www.iana.org/assignments/media-types/application/pdf"))
("application/pdx" ("https://www.iana.org/assignments/media-types/application/PDX"))
("application/pgp-encrypted" ("https://www.iana.org/assignments/media-types/application/pgp-encrypted"))
("application/pgp-signature" ("https://www.iana.org/assignments/media-types/application/pgp-signature"))
("application/pkcs10" ("https://www.iana.org/assignments/media-types/application/pkcs10"))
("application/pkcs7-mime" ("https://www.iana.org/assignments/media-types/application/pkcs7-mime"))
("application/pkcs7-signature" ("https://www.iana.org/assignments/media-types/application/pkcs7-signature"))
("application/pkcs8" ("https://www.iana.org/assignments/media-types/application/pkcs8"))
("application/pkcs12" ("https://www.iana.org/assignments/media-types/application/pkcs12"))
("application/pkix-attr-cert" ("https://www.iana.org/assignments/media-types/application/pkix-attr-cert"))
("application/pkix-cert" ("https://www.iana.org/assignments/media-types/application/pkix-cert"))
("application/pkix-crl" ("https://www.iana.org/assignments/media-types/application/pkix-crl"))
("application/pkix-pkipath" ("https://www.iana.org/assignments/media-types/application/pkix-pkipath"))
("application/pkixcmp" ("https://www.iana.org/assignments/media-types/application/pkixcmp"))
("application/postscript" ("https://www.iana.org/assignments/media-types/application/postscript"))
("application/qsig" ("https://www.iana.org/assignments/media-types/application/QSIG"))
("application/raptorfec" ("https://www.iana.org/assignments/media-types/application/raptorfec"))
("application/relax-ng-compact-syntax" ("https://www.iana.org/assignments/media-types/application/relax-ng-compact-syntax"))
("application/remote-printing" ("https://www.iana.org/assignments/media-types/application/remote-printing"))
("application/riscos" ("https://www.iana.org/assignments/media-types/application/riscos"))
("application/rpki-ghostbusters" ("https://www.iana.org/assignments/media-types/application/rpki-ghostbusters"))
("application/rpki-manifest" ("https://www.iana.org/assignments/media-types/application/rpki-manifest"))
("application/rpki-roa" ("https://www.iana.org/assignments/media-types/application/rpki-roa"))
("application/rpki-updown" ("https://www.iana.org/assignments/media-types/application/rpki-updown"))
("application/rtf" ("https://www.iana.org/assignments/media-types/application/rtf"))
("application/rtploopback" ("https://www.iana.org/assignments/media-types/application/rtploopback"))
("application/rtx" ("https://www.iana.org/assignments/media-types/application/rtx"))
("application/scvp-cv-request" ("https://www.iana.org/assignments/media-types/application/scvp-cv-request"))
("application/scvp-cv-response" ("https://www.iana.org/assignments/media-types/application/scvp-cv-response"))
("application/scvp-vp-request" ("https://www.iana.org/assignments/media-types/application/scvp-vp-request"))
("application/scvp-vp-response" ("https://www.iana.org/assignments/media-types/application/scvp-vp-response"))
("application/sdp" ("https://www.iana.org/assignments/media-types/application/sdp"))
("application/sep-exi" ("https://www.iana.org/assignments/media-types/application/sep-exi"))
("application/session-info" ("https://www.iana.org/assignments/media-types/application/session-info"))
("application/set-payment" ("https://www.iana.org/assignments/media-types/application/set-payment"))
("application/set-payment-initiation" ("https://www.iana.org/assignments/media-types/application/set-payment-initiation"))
("application/set-registration" ("https://www.iana.org/assignments/media-types/application/set-registration"))
("application/set-registration-initiation" ("https://www.iana.org/assignments/media-types/application/set-registration-initiation"))
("application/sgml" ("https://www.iana.org/assignments/media-types/application/SGML"))
("application/sgml-open-catalog" ("https://www.iana.org/assignments/media-types/application/sgml-open-catalog"))
("application/sieve" ("https://www.iana.org/assignments/media-types/application/sieve"))
("application/simple-message-summary" ("https://www.iana.org/assignments/media-types/application/simple-message-summary"))
("application/simplesymbolcontainer" ("https://www.iana.org/assignments/media-types/application/simpleSymbolContainer"))
("application/slate" ("https://www.iana.org/assignments/media-types/application/slate"))
("application/smpte336m" ("https://www.iana.org/assignments/media-types/application/smpte336m"))
("application/sql" ("https://www.iana.org/assignments/media-types/application/sql"))
("application/srgs" ("https://www.iana.org/assignments/media-types/application/srgs"))
("application/tamp-apex-update" ("https://www.iana.org/assignments/media-types/application/tamp-apex-update"))
("application/tamp-apex-update-confirm" ("https://www.iana.org/assignments/media-types/application/tamp-apex-update-confirm"))
("application/tamp-community-update" ("https://www.iana.org/assignments/media-types/application/tamp-community-update"))
("application/tamp-community-update-confirm" ("https://www.iana.org/assignments/media-types/application/tamp-community-update-confirm"))
("application/tamp-error" ("https://www.iana.org/assignments/media-types/application/tamp-error"))
("application/tamp-sequence-adjust" ("https://www.iana.org/assignments/media-types/application/tamp-sequence-adjust"))
("application/tamp-sequence-adjust-confirm" ("https://www.iana.org/assignments/media-types/application/tamp-sequence-adjust-confirm"))
("application/tamp-status-query" ("https://www.iana.org/assignments/media-types/application/tamp-status-query"))
("application/tamp-status-response" ("https://www.iana.org/assignments/media-types/application/tamp-status-response"))
("application/tamp-update" ("https://www.iana.org/assignments/media-types/application/tamp-update"))
("application/tamp-update-confirm" ("https://www.iana.org/assignments/media-types/application/tamp-update-confirm"))
("application/timestamp-query" ("https://www.iana.org/assignments/media-types/application/timestamp-query"))
("application/timestamp-reply" ("https://www.iana.org/assignments/media-types/application/timestamp-reply"))
("application/timestamped-data" ("https://www.iana.org/assignments/media-types/application/timestamped-data"))
("application/tve-trigger" ("https://www.iana.org/assignments/media-types/application/tve-trigger"))
("application/ulpfec" ("https://www.iana.org/assignments/media-types/application/ulpfec"))
("application/vemmi" ("https://www.iana.org/assignments/media-types/application/vemmi"))
("application/vq-rtcpxr" ("https://www.iana.org/assignments/media-types/application/vq-rtcpxr"))
("application/whoispp-query" ("https://www.iana.org/assignments/media-types/application/whoispp-query"))
("application/whoispp-response" ("https://www.iana.org/assignments/media-types/application/whoispp-response"))
("application/wita" ("https://www.iana.org/assignments/media-types/application/wita"))
("application/x-www-form-urlencoded" ("https://www.iana.org/assignments/media-types/application/x-www-form-urlencoded"))
("application/x400-bp" ("https://www.iana.org/assignments/media-types/application/x400-bp"))
("application/xml" ("https://www.iana.org/assignments/media-types/application/xml"))
("application/xml-dtd" ("https://www.iana.org/assignments/media-types/application/xml-dtd"))
("application/xml-external-parsed-entity" ("https://www.iana.org/assignments/media-types/application/xml-external-parsed-entity"))
("application/yang" ("https://www.iana.org/assignments/media-types/application/yang"))
("application/zip" ("https://www.iana.org/assignments/media-types/application/zip"))
("application/zlib" ("https://www.iana.org/assignments/media-types/application/zlib"))
("audio/1d-interleaved-parityfec" ("https://www.iana.org/assignments/media-types/audio/1d-interleaved-parityfec"))
("audio/32kadpcm" ("https://www.iana.org/assignments/media-types/audio/32kadpcm"))
("audio/3gpp" ("https://www.iana.org/assignments/media-types/audio/3gpp"))
("audio/3gpp2" ("https://www.iana.org/assignments/media-types/audio/3gpp2"))
("audio/ac3" ("https://www.iana.org/assignments/media-types/audio/ac3"))
("audio/amr" ("https://www.iana.org/assignments/media-types/audio/AMR"))
("audio/amr-wb" ("https://www.iana.org/assignments/media-types/audio/AMR-WB"))
("audio/aptx" ("https://www.iana.org/assignments/media-types/audio/aptx"))
("audio/asc" ("https://www.iana.org/assignments/media-types/audio/asc"))
("audio/atrac-advanced-lossless" ("https://www.iana.org/assignments/media-types/audio/ATRAC-ADVANCED-LOSSLESS"))
("audio/atrac-x" ("https://www.iana.org/assignments/media-types/audio/ATRAC-X"))
("audio/atrac3" ("https://www.iana.org/assignments/media-types/audio/ATRAC3"))
("audio/basic" ("https://www.iana.org/assignments/media-types/audio/basic"))
("audio/bv16" ("https://www.iana.org/assignments/media-types/audio/BV16"))
("audio/bv32" ("https://www.iana.org/assignments/media-types/audio/BV32"))
("audio/clearmode" ("https://www.iana.org/assignments/media-types/audio/clearmode"))
("audio/cn" ("https://www.iana.org/assignments/media-types/audio/CN"))
("audio/dat12" ("https://www.iana.org/assignments/media-types/audio/DAT12"))
("audio/dls" ("https://www.iana.org/assignments/media-types/audio/dls"))
("audio/dsr-es201108" ("https://www.iana.org/assignments/media-types/audio/dsr-es201108"))
("audio/dsr-es202050" ("https://www.iana.org/assignments/media-types/audio/dsr-es202050"))
("audio/dsr-es202211" ("https://www.iana.org/assignments/media-types/audio/dsr-es202211"))
("audio/dsr-es202212" ("https://www.iana.org/assignments/media-types/audio/dsr-es202212"))
("audio/dv" ("https://www.iana.org/assignments/media-types/audio/DV"))
("audio/dvi4" ("https://www.iana.org/assignments/media-types/audio/DVI4"))
("audio/eac3" ("https://www.iana.org/assignments/media-types/audio/eac3"))
("audio/encaprtp" ("https://www.iana.org/assignments/media-types/audio/encaprtp"))
("audio/evrc" ("https://www.iana.org/assignments/media-types/audio/EVRC"))
("audio/evrc-qcp" ("https://www.iana.org/assignments/media-types/audio/EVRC-QCP"))
("audio/evrc0" ("https://www.iana.org/assignments/media-types/audio/EVRC0"))
("audio/evrc1" ("https://www.iana.org/assignments/media-types/audio/EVRC1"))
("audio/evrcb" ("https://www.iana.org/assignments/media-types/audio/EVRCB"))
("audio/evrcb0" ("https://www.iana.org/assignments/media-types/audio/EVRCB0"))
("audio/evrcb1" ("https://www.iana.org/assignments/media-types/audio/EVRCB1"))
("audio/evrcnw" ("https://www.iana.org/assignments/media-types/audio/EVRCNW"))
("audio/evrcnw0" ("https://www.iana.org/assignments/media-types/audio/EVRCNW0"))
("audio/evrcnw1" ("https://www.iana.org/assignments/media-types/audio/EVRCNW1"))
("audio/evrcwb" ("https://www.iana.org/assignments/media-types/audio/EVRCWB"))
("audio/evrcwb0" ("https://www.iana.org/assignments/media-types/audio/EVRCWB0"))
("audio/evrcwb1" ("https://www.iana.org/assignments/media-types/audio/EVRCWB1"))
("audio/evs" ("https://www.iana.org/assignments/media-types/audio/EVS"))
("audio/example" ("https://www.iana.org/assignments/media-types/audio/example"))
("audio/fwdred" ("https://www.iana.org/assignments/media-types/audio/fwdred"))
("audio/g711-0" ("https://www.iana.org/assignments/media-types/audio/G711-0"))
("audio/g719" ("https://www.iana.org/assignments/media-types/audio/G719"))
("audio/g7221" ("https://www.iana.org/assignments/media-types/audio/G7221"))
("audio/g722" ("https://www.iana.org/assignments/media-types/audio/G722"))
("audio/g723" ("https://www.iana.org/assignments/media-types/audio/G723"))
("audio/g726-16" ("https://www.iana.org/assignments/media-types/audio/G726-16"))
("audio/g726-24" ("https://www.iana.org/assignments/media-types/audio/G726-24"))
("audio/g726-32" ("https://www.iana.org/assignments/media-types/audio/G726-32"))
("audio/g726-40" ("https://www.iana.org/assignments/media-types/audio/G726-40"))
("audio/g728" ("https://www.iana.org/assignments/media-types/audio/G728"))
("audio/g729" ("https://www.iana.org/assignments/media-types/audio/G729"))
("audio/g729d" ("https://www.iana.org/assignments/media-types/audio/G729D"))
("audio/g729e" ("https://www.iana.org/assignments/media-types/audio/G729E"))
("audio/gsm" ("https://www.iana.org/assignments/media-types/audio/GSM"))
("audio/gsm-efr" ("https://www.iana.org/assignments/media-types/audio/GSM-EFR"))
("audio/gsm-hr-08" ("https://www.iana.org/assignments/media-types/audio/GSM-HR-08"))
("audio/ilbc" ("https://www.iana.org/assignments/media-types/audio/iLBC"))
("audio/l8" ("https://www.iana.org/assignments/media-types/audio/L8"))
("audio/l16" ("https://www.iana.org/assignments/media-types/audio/L16"))
("audio/l20" ("https://www.iana.org/assignments/media-types/audio/L20"))
("audio/l24" ("https://www.iana.org/assignments/media-types/audio/L24"))
("audio/lpc" ("https://www.iana.org/assignments/media-types/audio/LPC"))
("audio/mobile-xmf" ("https://www.iana.org/assignments/media-types/audio/mobile-xmf"))
("audio/mpa" ("https://www.iana.org/assignments/media-types/audio/MPA"))
("audio/mp4" ("https://www.iana.org/assignments/media-types/audio/mp4"))
("audio/mp4a-latm" ("https://www.iana.org/assignments/media-types/audio/MP4A-LATM"))
("audio/mpa-robust" ("https://www.iana.org/assignments/media-types/audio/mpa-robust"))
("audio/mpeg" ("https://www.iana.org/assignments/media-types/audio/mpeg"))
("audio/mpeg4-generic" ("https://www.iana.org/assignments/media-types/audio/mpeg4-generic"))
("audio/ogg" ("https://www.iana.org/assignments/media-types/audio/ogg"))
("audio/opus" ("https://www.iana.org/assignments/media-types/audio/opus"))
("audio/pcma" ("https://www.iana.org/assignments/media-types/audio/PCMA"))
("audio/pcma-wb" ("https://www.iana.org/assignments/media-types/audio/PCMA-WB"))
("audio/pcmu" ("https://www.iana.org/assignments/media-types/audio/PCMU"))
("audio/pcmu-wb" ("https://www.iana.org/assignments/media-types/audio/PCMU-WB"))
("audio/raptorfec" ("https://www.iana.org/assignments/media-types/audio/raptorfec"))
("audio/red" ("https://www.iana.org/assignments/media-types/audio/RED"))
("audio/rtp-enc-aescm128" ("https://www.iana.org/assignments/media-types/audio/rtp-enc-aescm128"))
("audio/rtploopback" ("https://www.iana.org/assignments/media-types/audio/rtploopback"))
("audio/rtp-midi" ("https://www.iana.org/assignments/media-types/audio/rtp-midi"))
("audio/rtx" ("https://www.iana.org/assignments/media-types/audio/rtx"))
("audio/smv" ("https://www.iana.org/assignments/media-types/audio/SMV"))
("audio/smv0" ("https://www.iana.org/assignments/media-types/audio/SMV0"))
("audio/smv-qcp" ("https://www.iana.org/assignments/media-types/audio/SMV-QCP"))
("audio/sp-midi" ("https://www.iana.org/assignments/media-types/audio/sp-midi"))
("audio/speex" ("https://www.iana.org/assignments/media-types/audio/speex"))
("audio/t140c" ("https://www.iana.org/assignments/media-types/audio/t140c"))
("audio/t38" ("https://www.iana.org/assignments/media-types/audio/t38"))
("audio/telephone-event" ("https://www.iana.org/assignments/media-types/audio/telephone-event"))
("audio/tone" ("https://www.iana.org/assignments/media-types/audio/tone"))
("audio/uemclip" ("https://www.iana.org/assignments/media-types/audio/UEMCLIP"))
("audio/ulpfec" ("https://www.iana.org/assignments/media-types/audio/ulpfec"))
("audio/vdvi" ("https://www.iana.org/assignments/media-types/audio/VDVI"))
("audio/vmr-wb" ("https://www.iana.org/assignments/media-types/audio/VMR-WB"))
("audio/vorbis" ("https://www.iana.org/assignments/media-types/audio/vorbis"))
("audio/vorbis-config" ("https://www.iana.org/assignments/media-types/audio/vorbis-config"))
("image/cgm" ("https://www.iana.org/assignments/media-types/image/cgm"))
("image/example" ("https://www.iana.org/assignments/media-types/image/example"))
("image/fits" ("https://www.iana.org/assignments/media-types/image/fits"))
("image/g3fax" ("https://www.iana.org/assignments/media-types/image/g3fax"))
("image/jp2" ("https://www.iana.org/assignments/media-types/image/jp2"))
("image/jpm" ("https://www.iana.org/assignments/media-types/image/jpm"))
("image/jpx" ("https://www.iana.org/assignments/media-types/image/jpx"))
("image/naplps" ("https://www.iana.org/assignments/media-types/image/naplps"))
("image/png" ("https://www.iana.org/assignments/media-types/image/png"))
("image/pwg-raster" ("https://www.iana.org/assignments/media-types/image/pwg-raster"))
("image/t38" ("https://www.iana.org/assignments/media-types/image/t38"))
("image/tiff" ("https://www.iana.org/assignments/media-types/image/tiff"))
("image/tiff-fx" ("https://www.iana.org/assignments/media-types/image/tiff-fx"))
("message/cpim" ("https://www.iana.org/assignments/media-types/message/CPIM"))
("message/delivery-status" ("https://www.iana.org/assignments/media-types/message/delivery-status"))
("message/disposition-notification" ("https://www.iana.org/assignments/media-types/message/disposition-notification"))
("message/example" ("https://www.iana.org/assignments/media-types/message/example"))
("message/feedback-report" ("https://www.iana.org/assignments/media-types/message/feedback-report"))
("message/global" ("https://www.iana.org/assignments/media-types/message/global"))
("message/global-delivery-status" ("https://www.iana.org/assignments/media-types/message/global-delivery-status"))
("message/global-disposition-notification" ("https://www.iana.org/assignments/media-types/message/global-disposition-notification"))
("message/global-headers" ("https://www.iana.org/assignments/media-types/message/global-headers"))
("message/http" ("https://www.iana.org/assignments/media-types/message/http"))
("message/s-http" ("https://www.iana.org/assignments/media-types/message/s-http"))
("message/sip" ("https://www.iana.org/assignments/media-types/message/sip"))
("message/sipfrag" ("https://www.iana.org/assignments/media-types/message/sipfrag"))
("message/tracking-status" ("https://www.iana.org/assignments/media-types/message/tracking-status"))
("model/example" ("https://www.iana.org/assignments/media-types/model/example"))
("model/iges" ("https://www.iana.org/assignments/media-types/model/iges"))
("model/x3d-vrml" ("https://www.iana.org/assignments/media-types/model/x3d-vrml"))
("multipart/appledouble" ("https://www.iana.org/assignments/media-types/multipart/appledouble"))
("multipart/byteranges" ("https://www.iana.org/assignments/media-types/multipart/byteranges"))
("multipart/encrypted" ("https://www.iana.org/assignments/media-types/multipart/encrypted"))
("multipart/example" ("https://www.iana.org/assignments/media-types/multipart/example"))
("multipart/form-data" ("https://www.iana.org/assignments/media-types/multipart/form-data"))
("multipart/header-set" ("https://www.iana.org/assignments/media-types/multipart/header-set"))
("multipart/related" ("https://www.iana.org/assignments/media-types/multipart/related"))
("multipart/report" ("https://www.iana.org/assignments/media-types/multipart/report"))
("multipart/signed" ("https://www.iana.org/assignments/media-types/multipart/signed"))
("multipart/voice-message" ("https://www.iana.org/assignments/media-types/multipart/voice-message"))
("multipart/x-mixed-replace" ("https://www.iana.org/assignments/media-types/multipart/x-mixed-replace"))
("text/1d-interleaved-parityfec" ("https://www.iana.org/assignments/media-types/text/1d-interleaved-parityfec"))
("text/cache-manifest" ("https://www.iana.org/assignments/media-types/text/cache-manifest"))
("text/calendar" ("https://www.iana.org/assignments/media-types/text/calendar"))
("text/css" ("https://www.iana.org/assignments/media-types/text/css"))
("text/csv" ("https://www.iana.org/assignments/media-types/text/csv"))
("text/csv-schema" ("https://www.iana.org/assignments/media-types/text/csv-schema"))
("text/dns" ("https://www.iana.org/assignments/media-types/text/dns"))
("text/encaprtp" ("https://www.iana.org/assignments/media-types/text/encaprtp"))
("text/example" ("https://www.iana.org/assignments/media-types/text/example"))
("text/fwdred" ("https://www.iana.org/assignments/media-types/text/fwdred"))
("text/grammar-ref-list" ("https://www.iana.org/assignments/media-types/text/grammar-ref-list"))
("text/html" ("https://www.iana.org/assignments/media-types/text/html"))
("text/jcr-cnd" ("https://www.iana.org/assignments/media-types/text/jcr-cnd"))
("text/markdown" ("https://www.iana.org/assignments/media-types/text/markdown"))
("text/mizar" ("https://www.iana.org/assignments/media-types/text/mizar"))
("text/n3" ("https://www.iana.org/assignments/media-types/text/n3"))
("text/parameters" ("https://www.iana.org/assignments/media-types/text/parameters"))
("text/provenance-notation" ("https://www.iana.org/assignments/media-types/text/provenance-notation"))
("text/raptorfec" ("https://www.iana.org/assignments/media-types/text/raptorfec"))
("text/red" ("https://www.iana.org/assignments/media-types/text/RED"))
("text/rfc822-headers" ("https://www.iana.org/assignments/media-types/text/rfc822-headers"))
("text/rtf" ("https://www.iana.org/assignments/media-types/text/rtf"))
("text/rtp-enc-aescm128" ("https://www.iana.org/assignments/media-types/text/rtp-enc-aescm128"))
("text/rtploopback" ("https://www.iana.org/assignments/media-types/text/rtploopback"))
("text/rtx" ("https://www.iana.org/assignments/media-types/text/rtx"))
("text/sgml" ("https://www.iana.org/assignments/media-types/text/SGML"))
("text/t140" ("https://www.iana.org/assignments/media-types/text/t140"))
("text/tab-separated-values" ("https://www.iana.org/assignments/media-types/text/tab-separated-values"))
("text/troff" ("https://www.iana.org/assignments/media-types/text/troff"))
("text/turtle" ("https://www.iana.org/assignments/media-types/text/turtle"))
("text/ulpfec" ("https://www.iana.org/assignments/media-types/text/ulpfec"))
("text/uri-list" ("https://www.iana.org/assignments/media-types/text/uri-list"))
("text/vcard" ("https://www.iana.org/assignments/media-types/text/vcard"))
("text/xml" ("https://www.iana.org/assignments/media-types/text/xml"))
("text/xml-external-parsed-entity" ("https://www.iana.org/assignments/media-types/text/xml-external-parsed-entity"))
("video/1d-interleaved-parityfec" ("https://www.iana.org/assignments/media-types/video/1d-interleaved-parityfec"))
("video/3gpp" ("https://www.iana.org/assignments/media-types/video/3gpp"))
("video/3gpp2" ("https://www.iana.org/assignments/media-types/video/3gpp2"))
("video/3gpp-tt" ("https://www.iana.org/assignments/media-types/video/3gpp-tt"))
("video/bmpeg" ("https://www.iana.org/assignments/media-types/video/BMPEG"))
("video/bt656" ("https://www.iana.org/assignments/media-types/video/BT656"))
("video/celb" ("https://www.iana.org/assignments/media-types/video/CelB"))
("video/dv" ("https://www.iana.org/assignments/media-types/video/DV"))
("video/encaprtp" ("https://www.iana.org/assignments/media-types/video/encaprtp"))
("video/example" ("https://www.iana.org/assignments/media-types/video/example"))
("video/h261" ("https://www.iana.org/assignments/media-types/video/H261"))
("video/h263" ("https://www.iana.org/assignments/media-types/video/H263"))
("video/h263-1998" ("https://www.iana.org/assignments/media-types/video/H263-1998"))
("video/h263-2000" ("https://www.iana.org/assignments/media-types/video/H263-2000"))
("video/h264" ("https://www.iana.org/assignments/media-types/video/H264"))
("video/h264-rcdo" ("https://www.iana.org/assignments/media-types/video/H264-RCDO"))
("video/h264-svc" ("https://www.iana.org/assignments/media-types/video/H264-SVC"))
("video/h265" ("https://www.iana.org/assignments/media-types/video/H265"))
("video/jpeg" ("https://www.iana.org/assignments/media-types/video/JPEG"))
("video/jpeg2000" ("https://www.iana.org/assignments/media-types/video/jpeg2000"))
("video/mj2" ("https://www.iana.org/assignments/media-types/video/mj2"))
("video/mp1s" ("https://www.iana.org/assignments/media-types/video/MP1S"))
("video/mp2p" ("https://www.iana.org/assignments/media-types/video/MP2P"))
("video/mp2t" ("https://www.iana.org/assignments/media-types/video/MP2T"))
("video/mp4" ("https://www.iana.org/assignments/media-types/video/mp4"))
("video/mp4v-es" ("https://www.iana.org/assignments/media-types/video/MP4V-ES"))
("video/mpv" ("https://www.iana.org/assignments/media-types/video/MPV"))
("video/mpeg4-generic" ("https://www.iana.org/assignments/media-types/video/mpeg4-generic"))
("video/nv" ("https://www.iana.org/assignments/media-types/video/nv"))
("video/ogg" ("https://www.iana.org/assignments/media-types/video/ogg"))
("video/pointer" ("https://www.iana.org/assignments/media-types/video/pointer"))
("video/quicktime" ("https://www.iana.org/assignments/media-types/video/quicktime"))
("video/raptorfec" ("https://www.iana.org/assignments/media-types/video/raptorfec"))
("video/rtp-enc-aescm128" ("https://www.iana.org/assignments/media-types/video/rtp-enc-aescm128"))
("video/rtploopback" ("https://www.iana.org/assignments/media-types/video/rtploopback"))
("video/rtx" ("https://www.iana.org/assignments/media-types/video/rtx"))
("video/smpte292m" ("https://www.iana.org/assignments/media-types/video/SMPTE292M"))
("video/ulpfec" ("https://www.iana.org/assignments/media-types/video/ulpfec"))
("video/vc1" ("https://www.iana.org/assignments/media-types/video/vc1"))
("video/vp8" ("https://www.iana.org/assignments/media-types/video/VP8"))))

;;;###autoload
(defun media-type (media-type)
  "Display the template of a media-type"
  (interactive
   (list (completing-read "Enter media-type: " media-types)))
  (let* ((lowercased-media-type (downcase media-type))
        (found (assoc lowercased-media-type media-types)))
    (if found
        (let ((template (car (cdr found))))
          (message
           "%s - media-type\n%s"
           lowercased-media-type (car template) ))
      (message "%s - media-type\nUNKNOWN" lowercased-media-type))
    ))

(provide 'media-types)

;;; media-types.el ends here

