/*
 * Decompiled with CFR 0.152.
 */
package java2d.demos.Arcs_Curves;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Ellipse2D;
import java2d.AnimatingSurface;

public final class Ellipses
extends AnimatingSurface {
    private static Color[] colors = new Color[]{Color.BLUE, Color.CYAN, Color.GREEN, Color.MAGENTA, Color.ORANGE, Color.PINK, Color.RED, Color.YELLOW, Color.LIGHT_GRAY, Color.WHITE};
    private Ellipse2D.Float[] ellipses;
    private double[] esize;
    private float[] estroke;
    private double maxSize;

    public Ellipses() {
        this.setBackground(Color.BLACK);
        this.ellipses = new Ellipse2D.Float[25];
        this.esize = new double[this.ellipses.length];
        this.estroke = new float[this.ellipses.length];
        for (int i = 0; i < this.ellipses.length; ++i) {
            this.ellipses[i] = new Ellipse2D.Float();
            this.getRandomXY(i, 20.0 * Math.random(), 200, 200);
        }
    }

    public void getRandomXY(int i, double size, int w, int h) {
        this.esize[i] = size;
        this.estroke[i] = 1.0f;
        double x = Math.random() * ((double)w - this.maxSize / 2.0);
        double y = Math.random() * ((double)h - this.maxSize / 2.0);
        this.ellipses[i].setFrame(x, y, size, size);
    }

    @Override
    public void reset(int w, int h) {
        this.maxSize = w / 10;
        for (int i = 0; i < this.ellipses.length; ++i) {
            this.getRandomXY(i, this.maxSize * Math.random(), w, h);
        }
    }

    @Override
    public void step(int w, int h) {
        for (int i = 0; i < this.ellipses.length; ++i) {
            int n = i;
            this.estroke[n] = this.estroke[n] + 0.025f;
            int n2 = i;
            this.esize[n2] = this.esize[n2] + 1.0;
            if (this.esize[i] > this.maxSize) {
                this.getRandomXY(i, 1.0, w, h);
                continue;
            }
            this.ellipses[i].setFrame(this.ellipses[i].getX(), this.ellipses[i].getY(), this.esize[i], this.esize[i]);
        }
    }

    @Override
    public void render(int w, int h, Graphics2D g2) {
        for (int i = 0; i < this.ellipses.length; ++i) {
            g2.setColor(colors[i % colors.length]);
            g2.setStroke(new BasicStroke(this.estroke[i]));
            g2.draw(this.ellipses[i]);
        }
    }

    public static void main(String[] argv) {
        Ellipses.createDemoFrame(new Ellipses());
    }
}

