/*
 * Decompiled with CFR 0.152.
 */
package jspecview.app;

import java.net.URL;
import java.util.Map;
import javajs.util.Lst;
import javajs.util.PT;
import jspecview.api.AppletFrame;
import jspecview.api.JSVAppInterface;
import jspecview.api.JSVPanel;
import jspecview.api.PanelListener;
import jspecview.api.ScriptInterface;
import jspecview.api.js.JSVAppletObject;
import jspecview.common.Coordinate;
import jspecview.common.JSVFileManager;
import jspecview.common.JSVersion;
import jspecview.common.JSViewer;
import jspecview.common.PanelData;
import jspecview.common.PanelNode;
import jspecview.common.PeakPickEvent;
import jspecview.common.ScriptToken;
import jspecview.common.Spectrum;
import jspecview.common.SubSpecChangeEvent;
import jspecview.common.ZoomEvent;
import jspecview.source.JDXSource;
import org.jmol.util.Logger;

public class JSVApp
implements PanelListener,
JSVAppInterface,
ScriptInterface {
    public static final String CREDITS = "Authors:\nProf. Robert M. Hanson,\nD. Facey, K. Bryan, C. Walters, Prof. Robert J. Lancashire and\nvolunteer developers through sourceforge.";
    protected AppletFrame appletFrame;
    boolean isNewWindow;
    public String appletReadyCallbackFunctionName;
    private String coordCallbackFunctionName;
    private String loadFileCallbackFunctionName;
    private String peakCallbackFunctionName;
    private String syncCallbackFunctionName;
    public JSViewer vwr;
    private JSVPanel prevPanel;

    public JSVApp(AppletFrame appletFrame, boolean bl) {
        this.appletFrame = appletFrame;
        this.initViewer(bl);
        this.initParams(appletFrame.getParameter("script"));
    }

    private void initViewer(boolean bl) {
        this.vwr = new JSViewer(this, true, bl);
        this.appletFrame.setDropTargetListener(this.isSigned(), this.vwr);
        URL uRL = this.appletFrame.getDocumentBase();
        JSVFileManager.setDocumentBase(this.vwr, uRL);
    }

    @Override
    public boolean isPro() {
        return this.isSigned();
    }

    @Override
    public boolean isSigned() {
        return false;
    }

    public AppletFrame getAppletFrame() {
        return this.appletFrame;
    }

    public void dispose() {
        try {
            this.vwr.dispose();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public Map<String, Object> getPropertyAsJavaObject(String string) {
        return this.vwr.getPropertyAsJavaObject(string);
    }

    @Override
    public String getPropertyAsJSON(String string) {
        return PT.toJSON(null, this.getPropertyAsJavaObject(string));
    }

    @Override
    public String getCoordinate() {
        return this.vwr.getCoordinate();
    }

    @Override
    public void loadInline(String string) {
        this.siOpenDataOrFile(string, "[inline]", null, null, -1, -1, true, null, null);
        this.appletFrame.validateContent(3);
    }

    @Override
    public String exportSpectrum(String string, int n) {
        return this.vwr.export(string, n);
    }

    @Override
    public void setFilePath(String string) {
        this.runScript("load " + PT.esc(string));
    }

    @Override
    public void setSpectrumNumber(int n) {
        this.runScript((Object)((Object)ScriptToken.SPECTRUMNUMBER) + " " + n);
    }

    @Override
    public void reversePlot() {
        this.toggle(ScriptToken.REVERSEPLOT);
    }

    @Override
    public void toggleGrid() {
        this.toggle(ScriptToken.GRIDON);
    }

    @Override
    public void toggleCoordinate() {
        this.toggle(ScriptToken.COORDINATESON);
    }

    @Override
    public void togglePointsOnly() {
        this.toggle(ScriptToken.POINTSONLY);
    }

    @Override
    public void toggleIntegration() {
        this.toggle(ScriptToken.INTEGRATE);
    }

    private void toggle(ScriptToken scriptToken) {
        if (this.vwr.selectedPanel != null) {
            this.runScript((Object)((Object)scriptToken) + " TOGGLE");
        }
    }

    @Override
    public void addHighlight(double d, double d2, int n, int n2, int n3, int n4) {
        this.runScript("HIGHLIGHT " + d + " " + d2 + " " + n + " " + n2 + " " + n3 + " " + n4);
    }

    @Override
    public void removeHighlight(double d, double d2) {
        this.runScript("HIGHLIGHT " + d + " " + d2 + " OFF");
    }

    @Override
    public void removeAllHighlights() {
        this.runScript("HIGHLIGHT OFF");
    }

    @Override
    public void syncScript(String string) {
        this.vwr.syncScript(string);
    }

    @Override
    public void writeStatus(String string) {
        Logger.info(string);
    }

    public void initParams(String string) {
        this.vwr.parseInitScript(string);
        this.newAppletPanel();
        this.vwr.setPopupMenu(this.vwr.allowMenu, this.vwr.parameters.getBoolean(ScriptToken.ENABLEZOOM));
        if (this.vwr.allowMenu) {
            this.vwr.closeSource(null);
        }
        this.runScriptNow(string);
    }

    private void newAppletPanel() {
        Logger.info("newAppletPanel");
        this.appletFrame.createMainPanel(this.vwr);
    }

    @Override
    public void repaint() {
        JSVAppletObject jSVAppletObject;
        JSVAppletObject jSVAppletObject2 = jSVAppletObject = this.vwr == null ? null : this.vwr.html5Applet;
        if (JSViewer.jmolObject == null) {
            this.appletFrame.repaint();
        } else if (jSVAppletObject != null) {
            JSViewer.jmolObject.repaint(jSVAppletObject, true);
        }
    }

    public void updateJS(int n, int n2) {
    }

    @Override
    public boolean runScriptNow(String string) {
        return this.vwr.runScriptNow(string);
    }

    private void checkCallbacks() {
        Coordinate coordinate;
        if (this.coordCallbackFunctionName == null && this.peakCallbackFunctionName == null) {
            return;
        }
        Coordinate coordinate2 = new Coordinate();
        Coordinate coordinate3 = coordinate = this.peakCallbackFunctionName == null ? null : new Coordinate();
        if (!this.vwr.pd().getPickedCoordinates(coordinate2, coordinate)) {
            return;
        }
        int n = this.vwr.mainPanel.getCurrentPanelIndex();
        if (coordinate == null) {
            this.appletFrame.callToJavaScript(this.coordCallbackFunctionName, new Object[]{coordinate2.getXVal(), coordinate2.getYVal(), n + 1});
        } else {
            this.appletFrame.callToJavaScript(this.peakCallbackFunctionName, new Object[]{coordinate2.getXVal(), coordinate2.getYVal(), coordinate.getXVal(), coordinate.getYVal(), n + 1});
        }
    }

    public void doAdvanced(String string) {
    }

    @Override
    public void panelEvent(Object object) {
        if (object instanceof PeakPickEvent) {
            this.vwr.processPeakPickEvent(object, false);
        } else if (!(object instanceof ZoomEvent)) {
            boolean cfr_ignored_0 = object instanceof SubSpecChangeEvent;
        }
    }

    @Override
    public String getSolnColour() {
        return this.vwr.getSolutionColorStr(true);
    }

    private void updateJSView(String string) {
        JSVAppletObject jSVAppletObject = this.vwr.html5Applet;
        JSVPanel jSVPanel = jSVAppletObject == null ? null : this.vwr.selectedPanel;
        jSVAppletObject._updateView(jSVPanel, string);
    }

    @Override
    public synchronized void syncToJmol(String string) {
        this.updateJSView(string);
        if (this.syncCallbackFunctionName == null) {
            return;
        }
        Logger.info("JSVApp.syncToJmol JSV>Jmol " + string);
        this.appletFrame.callToJavaScript(this.syncCallbackFunctionName, new Object[]{this.vwr.fullName, string});
    }

    @Override
    public void setVisible(boolean bl) {
        this.appletFrame.setPanelVisible(bl);
    }

    @Override
    public void setCursor(int n) {
        this.vwr.apiPlatform.setCursor(n, this.appletFrame);
    }

    @Override
    public void runScript(String string) {
        this.vwr.runScript(string);
    }

    @Override
    public Lst<String> getScriptQueue() {
        return this.vwr.scriptQueue;
    }

    @Override
    public void siSetCurrentSource(JDXSource jDXSource) {
        this.vwr.currentSource = jDXSource;
    }

    @Override
    public void siSendPanelChange() {
        if (this.vwr.selectedPanel == this.prevPanel) {
            return;
        }
        this.prevPanel = this.vwr.selectedPanel;
        this.vwr.sendPanelChange();
    }

    @Override
    public void siNewWindow(boolean bl, boolean bl2) {
        this.isNewWindow = bl;
        if (bl2) {
            if (this.vwr.jsvpPopupMenu != null) {
                this.vwr.jsvpPopupMenu.setSelected("Window", false);
            }
        } else {
            this.appletFrame.newWindow(bl);
        }
    }

    @Override
    public void siValidateAndRepaint(boolean bl) {
        PanelData panelData = this.vwr.pd();
        if (panelData != null) {
            panelData.setTaintedAll();
        }
        this.appletFrame.validate();
        this.repaint();
    }

    @Override
    public void siSyncLoad(String string) {
        this.newAppletPanel();
        Logger.info("JSVP syncLoad reading " + string);
        this.siOpenDataOrFile(null, null, null, string, -1, -1, false, null, null);
        this.appletFrame.validateContent(3);
    }

    @Override
    public void siOpenDataOrFile(Object object, String string, Lst<Spectrum> lst, String string2, int n, int n2, boolean bl, String string3, String string4) {
        switch (this.vwr.openDataOrFile(object, string, lst, string2, n, n2, bl, string4)) {
            case 0: {
                if (string3 == null) break;
                this.runScript(string3);
                break;
            }
            case -1: {
                return;
            }
            default: {
                this.siSetSelectedPanel(null);
                return;
            }
        }
        Logger.info(String.valueOf(this.appletFrame.getAppletInfo()) + " File " + this.vwr.currentSource.getFilePath() + " Loaded Successfully");
    }

    @Override
    public void siProcessCommand(String string) {
        this.vwr.runScriptNow(string);
    }

    @Override
    public void siSetSelectedPanel(JSVPanel jSVPanel) {
        this.vwr.mainPanel.setSelectedPanel(this.vwr, jSVPanel, this.vwr.panelNodes);
        this.vwr.selectedPanel = jSVPanel;
        this.vwr.spectraTree.setSelectedPanel(this, jSVPanel);
        if (jSVPanel == null) {
            this.vwr.selectedPanel = jSVPanel = this.appletFrame.getJSVPanel(this.vwr, null);
            this.vwr.mainPanel.setSelectedPanel(this.vwr, jSVPanel, null);
        }
        this.appletFrame.validate();
        if (jSVPanel != null) {
            jSVPanel.setEnabled(true);
            jSVPanel.setFocusable(true);
        }
    }

    @Override
    public void siExecSetCallback(ScriptToken scriptToken, String string) {
        switch (scriptToken) {
            case APPLETREADYCALLBACKFUNCTIONNAME: {
                this.appletReadyCallbackFunctionName = string;
                break;
            }
            case LOADFILECALLBACKFUNCTIONNAME: {
                this.loadFileCallbackFunctionName = string;
                break;
            }
            case PEAKCALLBACKFUNCTIONNAME: {
                this.peakCallbackFunctionName = string;
                break;
            }
            case SYNCCALLBACKFUNCTIONNAME: {
                this.syncCallbackFunctionName = string;
                break;
            }
            case COORDCALLBACKFUNCTIONNAME: {
                this.coordCallbackFunctionName = string;
            }
        }
    }

    @Override
    public String siLoaded(String string) {
        if (this.loadFileCallbackFunctionName != null) {
            this.appletFrame.callToJavaScript(this.loadFileCallbackFunctionName, new Object[]{this.vwr.appletName, string});
        }
        this.updateJSView(null);
        return null;
    }

    @Override
    public void siExecHidden(boolean bl) {
    }

    @Override
    public void siExecScriptComplete(String string, boolean bl) {
        if (!bl) {
            this.vwr.showMessage(string);
        }
        this.siValidateAndRepaint(false);
    }

    @Override
    public void siUpdateBoolean(ScriptToken scriptToken, boolean bl) {
    }

    @Override
    public void siCheckCallbacks(String string) {
        this.checkCallbacks();
    }

    @Override
    public void siNodeSet(PanelNode panelNode) {
        this.appletFrame.validateContent(2);
        this.siValidateAndRepaint(false);
    }

    @Override
    public void siSourceClosed(JDXSource jDXSource) {
    }

    @Override
    public JSVPanel siGetNewJSVPanel(Spectrum spectrum) {
        if (spectrum == null) {
            this.vwr.initialStartIndex = -1;
            this.vwr.initialEndIndex = -1;
            return null;
        }
        Lst<Spectrum> lst = new Lst<Spectrum>();
        lst.addLast(spectrum);
        JSVPanel jSVPanel = this.appletFrame.getJSVPanel(this.vwr, lst);
        jSVPanel.getPanelData().addListener(this);
        this.vwr.parameters.setFor(jSVPanel, null, true);
        return jSVPanel;
    }

    @Override
    public JSVPanel siGetNewJSVPanel2(Lst<Spectrum> lst) {
        if (lst == null) {
            this.vwr.initialStartIndex = -1;
            this.vwr.initialEndIndex = -1;
            return this.appletFrame.getJSVPanel(this.vwr, null);
        }
        JSVPanel jSVPanel = this.appletFrame.getJSVPanel(this.vwr, lst);
        this.vwr.initialStartIndex = -1;
        this.vwr.initialEndIndex = -1;
        jSVPanel.getPanelData().addListener(this);
        this.vwr.parameters.setFor(jSVPanel, null, true);
        return jSVPanel;
    }

    @Override
    public void siSetPropertiesFromPreferences(JSVPanel jSVPanel, boolean bl) {
        this.vwr.checkAutoIntegrate();
    }

    @Override
    public void siSetLoaded(String string, String string2) {
    }

    @Override
    public void siSetMenuEnables(PanelNode panelNode, boolean bl) {
    }

    @Override
    public void siUpdateRecentMenus(String string) {
    }

    @Override
    public void siExecTest(String string) {
        String string2 = "";
        this.loadInline(string2);
    }

    @Override
    public String print(String string) {
        return this.vwr.print(string);
    }

    @Override
    public String checkScript(String string) {
        return this.vwr.checkScript(string);
    }

    public static String getAppletInfo() {
        return "JSpecView Applet " + JSVersion.VERSION + "\n\n" + CREDITS;
    }
}

