/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.symmetry;

import java.util.Map;
import org.jmol.symmetry.SpaceGroup;
import org.jmol.symmetry.SpecialGroup;
import org.jmol.symmetry.Symmetry;
import org.jmol.viewer.Viewer;

public class SpecialGroupFactory {
    public SpecialGroupFactory() {
        System.out.println("created");
    }

    SpecialGroup createSpecialGroup(SpecialGroup base, Symmetry sym, Map<String, Object> info, int type) {
        SpecialGroup spg;
        switch (type) {
            case 300: {
                spg = new SpecialGroup.PlaneGroup(sym, info);
                break;
            }
            case 400: {
                spg = new SpecialGroup.LayerGroup(sym, info);
                break;
            }
            case 500: {
                spg = new SpecialGroup.RodGroup(sym, info);
                break;
            }
            case 600: {
                spg = new SpecialGroup.FriezeGroup(sym, info);
                break;
            }
            default: {
                return null;
            }
        }
        if (base != null) {
            spg.embeddingSymmetry = base.embeddingSymmetry;
            spg.periodicity = base.periodicity;
        }
        return spg;
    }

    SpaceGroup getSpecialGroup(Symmetry sym, Viewer vwr, String name, int type) {
        return this.createSpecialGroup(null, sym, Symmetry.getSpecialSettingInfo(vwr, name, type), type);
    }
}

