/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.xml;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Map;
import javajs.util.Rdr;
import javajs.util.SB;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.jmol.adapter.readers.xml.XmlHandler;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollection;
import org.jmol.adapter.smarter.AtomSetCollectionReader;
import org.jmol.adapter.smarter.Bond;
import org.jmol.adapter.smarter.Resolver;
import org.jmol.api.Interface;
import org.jmol.api.js.JSmolAppletObject;
import org.jmol.util.Logger;
import org.xml.sax.XMLReader;

public abstract class XmlReader
extends AtomSetCollectionReader {
    protected Atom atom;
    protected Bond bond;
    public XmlReader parent = this;
    public Map<String, String> atts;
    private XmlReader thisReader = null;
    protected boolean keepChars;
    protected SB chars = SB.newN(2000);
    private Object[] domObj = new Object[1];
    private Object[] attribs;

    @Override
    public void initializeReader() throws Exception {
        this.atts = new Hashtable<String, String>();
        this.setMyError(this.parseXML());
        this.continuing = false;
    }

    private void setMyError(String err) {
        if (err != null && (this.asc == null || this.asc.errorMessage == null)) {
            this.asc = new AtomSetCollection("xml", this, null, null);
            this.asc.errorMessage = err;
        }
    }

    private String parseXML() {
        XMLReader saxReader;
        block4: {
            saxReader = null;
            try {
                SAXParserFactory spf = SAXParserFactory.newInstance();
                spf.setNamespaceAware(true);
                SAXParser saxParser = spf.newSAXParser();
                saxReader = saxParser.getXMLReader();
                saxReader.setFeature("http://xml.org/sax/features/validation", false);
                saxReader.setFeature("http://apache.org/xml/features/nonvalidating/load-dtd-grammar", false);
                saxReader.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
                if (this.debugging) {
                    Logger.debug("Using JAXP/SAX XML parser.");
                }
            }
            catch (Exception e) {
                if (!this.debugging) break block4;
                Logger.debug("Could not instantiate JAXP/SAX XML reader: " + e.getMessage());
            }
        }
        if (saxReader == null) {
            return "No XML reader found";
        }
        return this.selectReaderAndGo(saxReader);
    }

    private String selectReaderAndGo(Object saxReader) {
        String className = null;
        int pt = this.readerName.indexOf("(");
        String name = pt < 0 ? this.readerName : this.readerName.substring(0, pt);
        className = Resolver.getReaderClassBase(name);
        if (className.equals(this.getClass().getName())) {
            this.thisReader = this.parent = this;
        } else {
            this.asc = new AtomSetCollection(this.readerName, this, null, null);
            this.thisReader = (XmlReader)this.getInterface(className);
            if (this.thisReader == null) {
                return "File reader was not found: " + className;
            }
        }
        try {
            this.thisReader.processXml(this, saxReader);
        }
        catch (Exception e) {
            e.printStackTrace();
            return "Error reading XML: " + e.getMessage();
        }
        return null;
    }

    protected void processXml(XmlReader parent, Object saxReader) throws Exception {
        this.processXml2(parent, saxReader);
    }

    protected void processXml2(XmlReader parent, Object saxReader) throws Exception {
        this.parent = parent;
        if (parent != this) {
            this.asc = parent.asc;
            this.reader = parent.reader;
            this.atts = parent.atts;
        }
        if (saxReader == null) {
            this.attribs = new Object[1];
            this.domObj = new Object[1];
            String o = "";
            byte[] data = null;
            if (o instanceof BufferedInputStream) {
                o = Rdr.streamToUTF8String(Rdr.getBIS(data));
            }
            boolean isjs = false;
            this.walkDOMTree();
            if (isjs) {
                this.domObj[0] = this.createDomNodeJS("xmlReader", o);
                this.walkDOMTree();
                this.createDomNodeJS("xmlReader", null);
            }
        } else {
            ((XmlHandler)Interface.getOption("adapter.readers.xml.XmlHandler", this.vwr, "file")).parseXML(this, saxReader, this.reader);
        }
    }

    Object createDomNodeJS(String id, Object data) {
        JSmolAppletObject applet = (this.parent == null ? this : this.parent).vwr.html5Applet;
        Object d = null;
        return d;
    }

    @Override
    public void applySymmetryAndSetTrajectory() {
        try {
            if (this.parent == null || this.parent == this) {
                this.applySymTrajASCR();
            } else {
                this.parent.applySymmetryAndSetTrajectory();
            }
        }
        catch (Exception e) {
            Logger.error("applySymmetry failed: " + e);
        }
    }

    @Override
    protected void processDOM(Object DOMNode) {
        this.domObj = new Object[]{DOMNode};
        this.setMyError(this.selectReaderAndGo(null));
    }

    protected void processStartElement(String localName, String nodeName) {
    }

    protected void setKeepChars(boolean TF) {
        this.keepChars = TF;
        this.chars.setLength(0);
    }

    void processEndElement(String localName) {
    }

    private void walkDOMTree() {
        String localName = "localName";
        String nodeName = (String)this.jsObjectGetMember(this.domObj, localName);
        if ((localName = this.fixLocal(nodeName)) == null) {
            return;
        }
        if (localName.equals("#text")) {
            if (this.keepChars) {
                this.chars.append((String)this.jsObjectGetMember(this.domObj, "data"));
            }
            return;
        }
        localName = localName.toLowerCase();
        nodeName = nodeName.toLowerCase();
        this.attribs[0] = this.jsObjectGetMember(this.domObj, "attributes");
        this.getDOMAttributesA(this.attribs);
        this.processStartElement(localName, nodeName);
        boolean haveChildren = false;
        if (haveChildren) {
            Object nextNode = this.jsObjectGetMember(this.domObj, "firstChild");
            while (nextNode != null) {
                this.domObj[0] = nextNode;
                this.walkDOMTree();
                this.domObj[0] = nextNode;
                nextNode = this.jsObjectGetMember(this.domObj, "nextSibling");
            }
        }
        this.processEndElement(localName);
    }

    private String fixLocal(String name) {
        return name;
    }

    private void getDOMAttributesA(Object[] attributes) {
        this.atts.clear();
        if (attributes == null) {
            return;
        }
        Object nodes = null;
    }

    private Object jsObjectGetMember(Object[] jsObject, String name) {
        return null;
    }

    public void endDocument() {
    }

    @Override
    protected void finalizeSubclassReader() throws Exception {
        if (this.thisReader != null && this.thisReader != this) {
            this.thisReader.finalizeSubclassReader();
        }
        this.thisReader = null;
    }

    protected BufferedReader previewXML(BufferedReader reader) throws IOException {
        return reader;
    }

    private class NVPair {
        String name;
        String value;

        private NVPair() {
        }
    }
}

