/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.dns;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.StreamCorruptedException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import javax.naming.CompositeName;
import javax.naming.InvalidNameException;
import javax.naming.Name;

public final class DnsName
implements Name {
    private String domain = "";
    private ArrayList<String> labels = new ArrayList();
    private short octets = 1;
    private static final long serialVersionUID = 7040187611324710271L;

    public DnsName() {
    }

    public DnsName(String string) throws InvalidNameException {
        this.parse(string);
    }

    private DnsName(DnsName dnsName, int n, int n2) {
        int n3 = dnsName.size() - n2;
        int n4 = dnsName.size() - n;
        this.labels.addAll(dnsName.labels.subList(n3, n4));
        if (this.size() == dnsName.size()) {
            this.domain = dnsName.domain;
            this.octets = dnsName.octets;
        } else {
            for (String string : this.labels) {
                if (string.length() <= 0) continue;
                this.octets = (short)(this.octets + (short)(string.length() + 1));
            }
        }
    }

    public String toString() {
        if (this.domain == null) {
            StringBuilder stringBuilder = new StringBuilder();
            for (String string : this.labels) {
                if (stringBuilder.length() > 0 || string.length() == 0) {
                    stringBuilder.append('.');
                }
                DnsName.escape(stringBuilder, string);
            }
            this.domain = stringBuilder.toString();
        }
        return this.domain;
    }

    public boolean isHostName() {
        for (String string : this.labels) {
            if (DnsName.isHostNameLabel(string)) continue;
            return false;
        }
        return true;
    }

    public short getOctets() {
        return this.octets;
    }

    @Override
    public int size() {
        return this.labels.size();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    public int hashCode() {
        int n = 0;
        for (int i = 0; i < this.size(); ++i) {
            n = 31 * n + this.getKey(i).hashCode();
        }
        return n;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Name) || object instanceof CompositeName) {
            return false;
        }
        Name name = (Name)object;
        return this.size() == name.size() && this.compareTo(object) == 0;
    }

    @Override
    public int compareTo(Object object) {
        Name name = (Name)object;
        return this.compareRange(0, this.size(), name);
    }

    @Override
    public boolean startsWith(Name name) {
        return this.size() >= name.size() && this.compareRange(0, name.size(), name) == 0;
    }

    @Override
    public boolean endsWith(Name name) {
        return this.size() >= name.size() && this.compareRange(this.size() - name.size(), this.size(), name) == 0;
    }

    @Override
    public String get(int n) {
        if (n < 0 || n >= this.size()) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int n2 = this.size() - n - 1;
        return this.labels.get(n2);
    }

    @Override
    public Enumeration<String> getAll() {
        return new Enumeration<String>(){
            int pos = 0;

            @Override
            public boolean hasMoreElements() {
                return this.pos < DnsName.this.size();
            }

            @Override
            public String nextElement() {
                if (this.pos < DnsName.this.size()) {
                    return DnsName.this.get(this.pos++);
                }
                throw new NoSuchElementException();
            }
        };
    }

    @Override
    public Name getPrefix(int n) {
        return new DnsName(this, 0, n);
    }

    @Override
    public Name getSuffix(int n) {
        return new DnsName(this, n, this.size());
    }

    @Override
    public Object clone() {
        return new DnsName(this, 0, this.size());
    }

    @Override
    public Object remove(int n) {
        if (n < 0 || n >= this.size()) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int n2 = this.size() - n - 1;
        String string = this.labels.remove(n2);
        int n3 = string.length();
        if (n3 > 0) {
            this.octets = (short)(this.octets - (short)(n3 + 1));
        }
        this.domain = null;
        return string;
    }

    @Override
    public Name add(String string) throws InvalidNameException {
        return this.add(this.size(), string);
    }

    @Override
    public Name add(int n, String string) throws InvalidNameException {
        if (n < 0 || n > this.size()) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int n2 = string.length();
        if (n > 0 && n2 == 0 || n == 0 && this.hasRootLabel()) {
            throw new InvalidNameException("Empty label must be the last label in a domain name");
        }
        if (n2 > 0) {
            if (this.octets + n2 + 1 >= 256) {
                throw new InvalidNameException("Name too long");
            }
            this.octets = (short)(this.octets + (short)(n2 + 1));
        }
        int n3 = this.size() - n;
        DnsName.verifyLabel(string);
        this.labels.add(n3, string);
        this.domain = null;
        return this;
    }

    @Override
    public Name addAll(Name name) throws InvalidNameException {
        return this.addAll(this.size(), name);
    }

    @Override
    public Name addAll(int n, Name name) throws InvalidNameException {
        if (name instanceof DnsName) {
            DnsName dnsName = (DnsName)name;
            if (dnsName.isEmpty()) {
                return this;
            }
            if (n > 0 && dnsName.hasRootLabel() || n == 0 && this.hasRootLabel()) {
                throw new InvalidNameException("Empty label must be the last label in a domain name");
            }
            short s = (short)(this.octets + dnsName.octets - 1);
            if (s > 255) {
                throw new InvalidNameException("Name too long");
            }
            this.octets = s;
            int n2 = this.size() - n;
            this.labels.addAll(n2, dnsName.labels);
            this.domain = this.isEmpty() ? dnsName.domain : (this.domain == null || dnsName.domain == null ? null : (n == 0 ? this.domain + (dnsName.domain.equals(".") ? "" : ".") + dnsName.domain : (n == this.size() ? dnsName.domain + (this.domain.equals(".") ? "" : ".") + this.domain : null)));
        } else if (name instanceof CompositeName) {
            name = (DnsName)name;
        } else {
            for (int i = name.size() - 1; i >= 0; --i) {
                this.add(n, name.get(i));
            }
        }
        return this;
    }

    boolean hasRootLabel() {
        return !this.isEmpty() && this.get(0).equals("");
    }

    private int compareRange(int n, int n2, Name name) {
        if (name instanceof CompositeName) {
            name = (DnsName)name;
        }
        int n3 = Math.min(n2 - n, name.size());
        for (int i = 0; i < n3; ++i) {
            String string = this.get(i + n);
            String string2 = name.get(i);
            int n4 = this.size() - (i + n) - 1;
            int n5 = DnsName.compareLabels(string, string2);
            if (n5 == 0) continue;
            return n5;
        }
        return n2 - n - name.size();
    }

    String getKey(int n) {
        return DnsName.keyForLabel(this.get(n));
    }

    private void parse(String string) throws InvalidNameException {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '\\') {
                c = DnsName.getEscapedOctet(string, i++);
                if (DnsName.isDigit(string.charAt(i))) {
                    i += 2;
                }
                stringBuffer.append(c);
                continue;
            }
            if (c != '.') {
                stringBuffer.append(c);
                continue;
            }
            this.add(0, stringBuffer.toString());
            stringBuffer.delete(0, i);
        }
        if (!string.equals("") && !string.equals(".")) {
            this.add(0, stringBuffer.toString());
        }
        this.domain = string;
    }

    private static char getEscapedOctet(String string, int n) throws InvalidNameException {
        try {
            char c = string.charAt(++n);
            if (DnsName.isDigit(c)) {
                char c2 = string.charAt(++n);
                char c3 = string.charAt(++n);
                if (DnsName.isDigit(c2) && DnsName.isDigit(c3)) {
                    return (char)((c - 48) * 100 + (c2 - 48) * 10 + (c3 - 48));
                }
                throw new InvalidNameException("Invalid escape sequence in " + string);
            }
            return c;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new InvalidNameException("Invalid escape sequence in " + string);
        }
    }

    private static void verifyLabel(String string) throws InvalidNameException {
        if (string.length() > 63) {
            throw new InvalidNameException("Label exceeds 63 octets: " + string);
        }
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if ((c & 0xFF00) == 0) continue;
            throw new InvalidNameException("Label has two-byte char: " + string);
        }
    }

    private static boolean isHostNameLabel(String string) {
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (DnsName.isHostNameChar(c)) continue;
            return false;
        }
        return !string.startsWith("-") && !string.endsWith("-");
    }

    private static boolean isHostNameChar(char c) {
        return c == '-' || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9';
    }

    private static boolean isDigit(char c) {
        return c >= '0' && c <= '9';
    }

    private static void escape(StringBuilder stringBuilder, String string) {
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '.' || c == '\\') {
                stringBuilder.append('\\');
            }
            stringBuilder.append(c);
        }
    }

    private static int compareLabels(String string, String string2) {
        int n = Math.min(string.length(), string2.length());
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            char c2 = string2.charAt(i);
            if (c >= 'A' && c <= 'Z') {
                c = (char)(c + 32);
            }
            if (c2 >= 'A' && c2 <= 'Z') {
                c2 = (char)(c2 + 32);
            }
            if (c == c2) continue;
            return c - c2;
        }
        return string.length() - string2.length();
    }

    private static String keyForLabel(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length());
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c >= 'A' && c <= 'Z') {
                c = (char)(c + 32);
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeObject(this.toString());
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        try {
            this.parse((String)objectInputStream.readObject());
        }
        catch (InvalidNameException invalidNameException) {
            throw new StreamCorruptedException("Invalid name: " + this.domain);
        }
    }
}

