/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent;

import java.security.AccessControlContext;
import java.security.ProtectionDomain;
import java.util.concurrent.ForkJoinPool;
import sun.misc.Unsafe;

public class ForkJoinWorkerThread
extends Thread {
    final ForkJoinPool pool;
    final ForkJoinPool.WorkQueue workQueue;
    private static final AccessControlContext INNOCUOUS_ACC = new AccessControlContext(new ProtectionDomain[]{new ProtectionDomain(null, null)});
    private static final Unsafe U;
    private static final long THREADLOCALS;
    private static final long INHERITABLETHREADLOCALS;
    private static final long INHERITEDACCESSCONTROLCONTEXT;

    protected ForkJoinWorkerThread(ForkJoinPool forkJoinPool) {
        super("aForkJoinWorkerThread");
        this.pool = forkJoinPool;
        this.workQueue = forkJoinPool.registerWorker(this);
    }

    ForkJoinWorkerThread(ForkJoinPool forkJoinPool, boolean bl) {
        super("aForkJoinWorkerThread");
        if (bl) {
            U.putOrderedObject(this, INHERITEDACCESSCONTROLCONTEXT, INNOCUOUS_ACC);
        }
        this.pool = forkJoinPool;
        this.workQueue = forkJoinPool.registerWorker(this);
    }

    ForkJoinWorkerThread(ForkJoinPool forkJoinPool, ThreadGroup threadGroup, AccessControlContext accessControlContext) {
        super(threadGroup, null, "aForkJoinWorkerThread");
        U.putOrderedObject(this, INHERITEDACCESSCONTROLCONTEXT, accessControlContext);
        this.eraseThreadLocals();
        this.pool = forkJoinPool;
        this.workQueue = forkJoinPool.registerWorker(this);
    }

    public ForkJoinPool getPool() {
        return this.pool;
    }

    public int getPoolIndex() {
        return this.workQueue.getPoolIndex();
    }

    protected void onStart() {
    }

    protected void onTermination(Throwable throwable) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (this.workQueue.array == null) {
            Throwable throwable = null;
            try {
                this.onStart();
                this.pool.runWorker(this.workQueue);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
            }
            finally {
                try {
                    this.onTermination(throwable);
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                    }
                }
                finally {
                    this.pool.deregisterWorker(this, throwable);
                }
            }
        }
    }

    final void eraseThreadLocals() {
        U.putObject((Object)this, THREADLOCALS, null);
        U.putObject((Object)this, INHERITABLETHREADLOCALS, null);
    }

    void afterTopLevelExec() {
    }

    static {
        try {
            U = Unsafe.getUnsafe();
            Class<Thread> clazz = Thread.class;
            THREADLOCALS = U.objectFieldOffset(clazz.getDeclaredField("threadLocals"));
            INHERITABLETHREADLOCALS = U.objectFieldOffset(clazz.getDeclaredField("inheritableThreadLocals"));
            INHERITEDACCESSCONTROLCONTEXT = U.objectFieldOffset(clazz.getDeclaredField("inheritedAccessControlContext"));
        }
        catch (Exception exception) {
            throw new Error(exception);
        }
    }

    static final class InnocuousForkJoinWorkerThread
    extends ForkJoinWorkerThread {
        private static final ThreadGroup innocuousThreadGroup = InnocuousForkJoinWorkerThread.createThreadGroup();

        InnocuousForkJoinWorkerThread(ForkJoinPool forkJoinPool) {
            super(forkJoinPool, innocuousThreadGroup, INNOCUOUS_ACC);
        }

        @Override
        void afterTopLevelExec() {
            this.eraseThreadLocals();
        }

        @Override
        public ClassLoader getContextClassLoader() {
            return ClassLoader.getSystemClassLoader();
        }

        @Override
        public void setUncaughtExceptionHandler(Thread.UncaughtExceptionHandler uncaughtExceptionHandler) {
        }

        @Override
        public void setContextClassLoader(ClassLoader classLoader) {
            throw new SecurityException("setContextClassLoader");
        }

        private static ThreadGroup createThreadGroup() {
            try {
                Unsafe unsafe = Unsafe.getUnsafe();
                Class<Thread> clazz = Thread.class;
                Class<ThreadGroup> clazz2 = ThreadGroup.class;
                long l = unsafe.objectFieldOffset(clazz.getDeclaredField("group"));
                long l2 = unsafe.objectFieldOffset(clazz2.getDeclaredField("parent"));
                ThreadGroup threadGroup = (ThreadGroup)unsafe.getObject((Object)Thread.currentThread(), l);
                while (threadGroup != null) {
                    ThreadGroup threadGroup2 = (ThreadGroup)unsafe.getObject((Object)threadGroup, l2);
                    if (threadGroup2 == null) {
                        return new ThreadGroup(threadGroup, "InnocuousForkJoinWorkerThreadGroup");
                    }
                    threadGroup = threadGroup2;
                }
            }
            catch (Exception exception) {
                throw new Error(exception);
            }
            throw new Error("Cannot create ThreadGroup");
        }
    }
}

