/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.incremental.classpathDiff;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.incremental.classpathDiff.BasicClassInfoClassVisitor;
import org.jetbrains.kotlin.incremental.classpathDiff.InnerClassesClassVisitor;
import org.jetbrains.kotlin.incremental.classpathDiff.KotlinClassHeaderClassVisitor;
import org.jetbrains.kotlin.load.kotlin.FileBasedKotlinClass;
import org.jetbrains.kotlin.load.kotlin.header.KotlinClassHeader;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.resolve.jvm.JvmClassName;
import org.jetbrains.org.objectweb.asm.ClassReader;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0011\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0018\u0010\u001a\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u001b\u001a\u00020\nH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0015R\u0011\u0010\u0016\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0015R\u0011\u0010\u0017\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0015R\u0011\u0010\u0018\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0015R\u0011\u0010\u0019\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0015\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/incremental/classpathDiff/BasicClassInfo;", "", "classId", "Lorg/jetbrains/kotlin/name/ClassId;", "kotlinClassHeader", "Lorg/jetbrains/kotlin/load/kotlin/header/KotlinClassHeader;", "supertypes", "", "Lorg/jetbrains/kotlin/resolve/jvm/JvmClassName;", "accessFlags", "", "isAnonymous", "", "<init>", "(Lorg/jetbrains/kotlin/name/ClassId;Lorg/jetbrains/kotlin/load/kotlin/header/KotlinClassHeader;Ljava/util/List;IZ)V", "getClassId", "()Lorg/jetbrains/kotlin/name/ClassId;", "getKotlinClassHeader", "()Lorg/jetbrains/kotlin/load/kotlin/header/KotlinClassHeader;", "getSupertypes", "()Ljava/util/List;", "()Z", "isKotlinClass", "isPrivate", "isLocal", "isSynthetic", "flagEnabled", "flagToCheck", "Companion", "incremental-compilation-impl"})
public final class BasicClassInfo {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ClassId classId;
    @Nullable
    private final KotlinClassHeader kotlinClassHeader;
    @NotNull
    private final List<JvmClassName> supertypes;
    private final int accessFlags;
    private final boolean isAnonymous;
    private final boolean isKotlinClass;
    private final boolean isPrivate;
    private final boolean isLocal;
    private final boolean isSynthetic;

    public BasicClassInfo(@NotNull ClassId classId, @Nullable KotlinClassHeader kotlinClassHeader, @NotNull List<? extends JvmClassName> supertypes, int accessFlags, boolean isAnonymous) {
        boolean bl;
        Intrinsics.checkNotNullParameter(classId, "classId");
        Intrinsics.checkNotNullParameter(supertypes, "supertypes");
        this.classId = classId;
        this.kotlinClassHeader = kotlinClassHeader;
        this.supertypes = supertypes;
        this.accessFlags = accessFlags;
        this.isAnonymous = isAnonymous;
        this.isKotlinClass = this.kotlinClassHeader != null;
        this.isPrivate = this.flagEnabled(this.accessFlags, 2);
        this.isLocal = this.classId.isLocal();
        if (this.isKotlinClass) {
            KotlinClassHeader kotlinClassHeader2 = this.kotlinClassHeader;
            Intrinsics.checkNotNull(kotlinClassHeader2);
            bl = kotlinClassHeader2.getKind() == KotlinClassHeader.Kind.SYNTHETIC_CLASS || this.flagEnabled(this.accessFlags, 4096);
        } else {
            bl = this.flagEnabled(this.accessFlags, 4096);
        }
        this.isSynthetic = bl;
    }

    @NotNull
    public final ClassId getClassId() {
        return this.classId;
    }

    @Nullable
    public final KotlinClassHeader getKotlinClassHeader() {
        return this.kotlinClassHeader;
    }

    @NotNull
    public final List<JvmClassName> getSupertypes() {
        return this.supertypes;
    }

    public final boolean isAnonymous() {
        return this.isAnonymous;
    }

    public final boolean isKotlinClass() {
        return this.isKotlinClass;
    }

    public final boolean isPrivate() {
        return this.isPrivate;
    }

    public final boolean isLocal() {
        return this.isLocal;
    }

    public final boolean isSynthetic() {
        return this.isSynthetic;
    }

    private final boolean flagEnabled(int accessFlags, int flagToCheck) {
        return (accessFlags & flagToCheck) != 0;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/incremental/classpathDiff/BasicClassInfo$Companion;", "", "<init>", "()V", "compute", "Lorg/jetbrains/kotlin/incremental/classpathDiff/BasicClassInfo;", "classContents", "", "incremental-compilation-impl"})
    @SourceDebugExtension(value={"SMAP\nBasicClassInfo.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BasicClassInfo.kt\norg/jetbrains/kotlin/incremental/classpathDiff/BasicClassInfo$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,112:1\n1#2:113\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final BasicClassInfo compute(@NotNull byte[] classContents) {
            boolean bl;
            Intrinsics.checkNotNullParameter(classContents, "classContents");
            KotlinClassHeaderClassVisitor kotlinClassHeaderClassVisitor = new KotlinClassHeaderClassVisitor();
            InnerClassesClassVisitor innerClassesClassVisitor = new InnerClassesClassVisitor(kotlinClassHeaderClassVisitor);
            BasicClassInfoClassVisitor basicClassInfoVisitor = new BasicClassInfoClassVisitor(innerClassesClassVisitor);
            new ClassReader(classContents).accept(basicClassInfoVisitor, 3);
            String className = basicClassInfoVisitor.getClassName();
            FileBasedKotlinClass.InnerClassesInfo innerClassesInfo = innerClassesClassVisitor.getInnerClassesInfo();
            ClassId classId = FileBasedKotlinClass.resolveNameByInternalName(className, innerClassesInfo);
            ClassId classId2 = classId;
            Intrinsics.checkNotNullExpressionValue(classId, "resolveNameByInternalName(...)");
            KotlinClassHeader kotlinClassHeader = kotlinClassHeaderClassVisitor.getKotlinClassHeader();
            List<JvmClassName> list = basicClassInfoVisitor.getSupertypes();
            int n = basicClassInfoVisitor.getAccessFlags();
            FileBasedKotlinClass.OuterAndInnerName outerAndInnerName = innerClassesInfo.get(className);
            if (outerAndInnerName != null) {
                void it;
                FileBasedKotlinClass.OuterAndInnerName outerAndInnerName2 = outerAndInnerName;
                int n2 = n;
                List<JvmClassName> list2 = list;
                KotlinClassHeader kotlinClassHeader2 = kotlinClassHeader;
                ClassId classId3 = classId2;
                boolean bl2 = false;
                boolean bl3 = it.innerSimpleName == null;
                classId2 = classId3;
                kotlinClassHeader = kotlinClassHeader2;
                list = list2;
                n = n2;
                bl = bl3;
            } else {
                bl = false;
            }
            boolean bl4 = bl;
            int n3 = n;
            List<JvmClassName> list3 = list;
            KotlinClassHeader kotlinClassHeader3 = kotlinClassHeader;
            ClassId classId4 = classId2;
            return new BasicClassInfo(classId4, kotlinClassHeader3, list3, n3, bl4);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

