//
// Vulkan wrapper generated from "https://raw.githubusercontent.com/KhronosGroup/Vulkan-Headers/master/include/vulkan/vulkan_core.h"
//
package vulkan
API_VERSION_1_0 :: (1<<22) | (0<<12) | (0)
API_VERSION_1_1 :: (1<<22) | (1<<12) | (0)
API_VERSION_1_2 :: (1<<22) | (2<<12) | (0)
API_VERSION_1_3 :: (1<<22) | (3<<12) | (0)

MAKE_VERSION :: proc(major, minor, patch: u32) -> u32 {
	return (major<<22) | (minor<<12) | (patch)
}

// Base types
Flags         :: distinct u32
Flags64       :: distinct u64
DeviceSize    :: distinct u64
DeviceAddress :: distinct u64
SampleMask    :: distinct u32

Handle                :: distinct rawptr
NonDispatchableHandle :: distinct u64

SetProcAddressType :: #type proc(p: rawptr, name: cstring)


RemoteAddressNV :: distinct rawptr // Declared inline before MemoryGetRemoteAddressInfoNV

// Base constants
LOD_CLAMP_NONE                        :: 1000.0
REMAINING_MIP_LEVELS                  :: ~u32(0)
REMAINING_ARRAY_LAYERS                :: ~u32(0)
WHOLE_SIZE                            :: ~u64(0)
ATTACHMENT_UNUSED                     :: ~u32(0)
TRUE                                  :: 1
FALSE                                 :: 0
QUEUE_FAMILY_IGNORED                  :: ~u32(0)
SUBPASS_EXTERNAL                      :: ~u32(0)
MAX_PHYSICAL_DEVICE_NAME_SIZE         :: 256
MAX_SHADER_MODULE_IDENTIFIER_SIZE_EXT :: 32
UUID_SIZE                             :: 16
MAX_MEMORY_TYPES                      :: 32
MAX_MEMORY_HEAPS                      :: 16
MAX_EXTENSION_NAME_SIZE               :: 256
MAX_DESCRIPTION_SIZE                  :: 256
MAX_DEVICE_GROUP_SIZE                 :: 32
LUID_SIZE_KHX                         :: 8
LUID_SIZE                             :: 8
MAX_QUEUE_FAMILY_EXTERNAL             :: ~u32(1)
MAX_GLOBAL_PRIORITY_SIZE_EXT          :: 16
QUEUE_FAMILY_EXTERNAL                 :: MAX_QUEUE_FAMILY_EXTERNAL

// General Constants
HEADER_VERSION       :: 296
MAX_DRIVER_NAME_SIZE :: 256
MAX_DRIVER_INFO_SIZE :: 256

// Vulkan Video Constants
VIDEO_AV1_NUM_REF_FRAMES                            :: 8
VIDEO_AV1_REFS_PER_FRAME                            :: 7
VIDEO_AV1_TOTAL_REFS_PER_FRAME                      :: 8
VIDEO_AV1_MAX_TILE_COLS                             :: 64
VIDEO_AV1_MAX_TILE_ROWS                             :: 64
VIDEO_AV1_MAX_SEGMENTS                              :: 8
VIDEO_AV1_SEG_LVL_MAX                               :: 8
VIDEO_AV1_PRIMARY_REF_NONE                          :: 7
VIDEO_AV1_SELECT_INTEGER_MV                         :: 2
VIDEO_AV1_SELECT_SCREEN_CONTENT_TOOLS               :: 2
VIDEO_AV1_SKIP_MODE_FRAMES                          :: 2
VIDEO_AV1_MAX_LOOP_FILTER_STRENGTHS                 :: 4
VIDEO_AV1_LOOP_FILTER_ADJUSTMENTS                   :: 2
VIDEO_AV1_MAX_CDEF_FILTER_STRENGTHS                 :: 8
VIDEO_AV1_MAX_NUM_PLANES                            :: 3
VIDEO_AV1_GLOBAL_MOTION_PARAMS                      :: 6
VIDEO_AV1_MAX_NUM_Y_POINTS                          :: 14
VIDEO_AV1_MAX_NUM_CB_POINTS                         :: 10
VIDEO_AV1_MAX_NUM_CR_POINTS                         :: 10
VIDEO_AV1_MAX_NUM_POS_LUMA                          :: 24
VIDEO_AV1_MAX_NUM_POS_CHROMA                        :: 25
VIDEO_H264_CPB_CNT_LIST_SIZE                        :: 32
VIDEO_H264_SCALING_LIST_4X4_NUM_LISTS               :: 6
VIDEO_H264_SCALING_LIST_4X4_NUM_ELEMENTS            :: 16
VIDEO_H264_SCALING_LIST_8X8_NUM_LISTS               :: 6
VIDEO_H264_SCALING_LIST_8X8_NUM_ELEMENTS            :: 64
VIDEO_H264_MAX_NUM_LIST_REF                         :: 32
VIDEO_H264_MAX_CHROMA_PLANES                        :: 2
VIDEO_H264_NO_REFERENCE_PICTURE                     :: 0xFF
VIDEO_H265_CPB_CNT_LIST_SIZE                        :: 32
VIDEO_H265_SUBLAYERS_LIST_SIZE                      :: 7
VIDEO_H265_SCALING_LIST_4X4_NUM_LISTS               :: 6
VIDEO_H265_SCALING_LIST_4X4_NUM_ELEMENTS            :: 16
VIDEO_H265_SCALING_LIST_8X8_NUM_LISTS               :: 6
VIDEO_H265_SCALING_LIST_8X8_NUM_ELEMENTS            :: 64
VIDEO_H265_SCALING_LIST_16X16_NUM_LISTS             :: 6
VIDEO_H265_SCALING_LIST_16X16_NUM_ELEMENTS          :: 64
VIDEO_H265_SCALING_LIST_32X32_NUM_LISTS             :: 2
VIDEO_H265_SCALING_LIST_32X32_NUM_ELEMENTS          :: 64
VIDEO_H265_CHROMA_QP_OFFSET_LIST_SIZE               :: 6
VIDEO_H265_CHROMA_QP_OFFSET_TILE_COLS_LIST_SIZE     :: 19
VIDEO_H265_CHROMA_QP_OFFSET_TILE_ROWS_LIST_SIZE     :: 21
VIDEO_H265_PREDICTOR_PALETTE_COMPONENTS_LIST_SIZE   :: 3
VIDEO_H265_PREDICTOR_PALETTE_COMP_ENTRIES_LIST_SIZE :: 128
VIDEO_H265_MAX_NUM_LIST_REF                         :: 15
VIDEO_H265_MAX_CHROMA_PLANES                        :: 2
VIDEO_H265_MAX_SHORT_TERM_REF_PIC_SETS              :: 64
VIDEO_H265_MAX_DPB_SIZE                             :: 16
VIDEO_H265_MAX_LONG_TERM_REF_PICS_SPS               :: 32
VIDEO_H265_MAX_LONG_TERM_PICS                       :: 16
VIDEO_H265_MAX_DELTA_POC                            :: 48
VIDEO_H265_NO_REFERENCE_PICTURE                     :: 0xFF
VIDEO_DECODE_H264_FIELD_ORDER_COUNT_LIST_SIZE       :: 2
VIDEO_DECODE_H265_REF_PIC_SET_LIST_SIZE             :: 8

// Vendor Constants
KHR_surface                                               :: 1
KHR_SURFACE_SPEC_VERSION                                  :: 25
KHR_SURFACE_EXTENSION_NAME                                :: "VK_KHR_surface"
KHR_swapchain                                             :: 1
KHR_SWAPCHAIN_SPEC_VERSION                                :: 70
KHR_SWAPCHAIN_EXTENSION_NAME                              :: "VK_KHR_swapchain"
KHR_display                                               :: 1
KHR_DISPLAY_SPEC_VERSION                                  :: 23
KHR_DISPLAY_EXTENSION_NAME                                :: "VK_KHR_display"
KHR_display_swapchain                                     :: 1
KHR_DISPLAY_SWAPCHAIN_SPEC_VERSION                        :: 10
KHR_DISPLAY_SWAPCHAIN_EXTENSION_NAME                      :: "VK_KHR_display_swapchain"
KHR_sampler_mirror_clamp_to_edge                          :: 1
KHR_SAMPLER_MIRROR_CLAMP_TO_EDGE_SPEC_VERSION             :: 3
KHR_SAMPLER_MIRROR_CLAMP_TO_EDGE_EXTENSION_NAME           :: "VK_KHR_sampler_mirror_clamp_to_edge"
KHR_video_queue                                           :: 1
KHR_VIDEO_QUEUE_SPEC_VERSION                              :: 8
KHR_VIDEO_QUEUE_EXTENSION_NAME                            :: "VK_KHR_video_queue"
KHR_video_decode_queue                                    :: 1
KHR_VIDEO_DECODE_QUEUE_SPEC_VERSION                       :: 8
KHR_VIDEO_DECODE_QUEUE_EXTENSION_NAME                     :: "VK_KHR_video_decode_queue"
KHR_video_encode_h264                                     :: 1
KHR_VIDEO_ENCODE_H264_SPEC_VERSION                        :: 14
KHR_VIDEO_ENCODE_H264_EXTENSION_NAME                      :: "VK_KHR_video_encode_h264"
KHR_video_encode_h265                                     :: 1
KHR_VIDEO_ENCODE_H265_SPEC_VERSION                        :: 14
KHR_VIDEO_ENCODE_H265_EXTENSION_NAME                      :: "VK_KHR_video_encode_h265"
KHR_video_decode_h264                                     :: 1
KHR_VIDEO_DECODE_H264_SPEC_VERSION                        :: 9
KHR_VIDEO_DECODE_H264_EXTENSION_NAME                      :: "VK_KHR_video_decode_h264"
KHR_dynamic_rendering                                     :: 1
KHR_DYNAMIC_RENDERING_SPEC_VERSION                        :: 1
KHR_DYNAMIC_RENDERING_EXTENSION_NAME                      :: "VK_KHR_dynamic_rendering"
KHR_multiview                                             :: 1
KHR_MULTIVIEW_SPEC_VERSION                                :: 1
KHR_MULTIVIEW_EXTENSION_NAME                              :: "VK_KHR_multiview"
KHR_get_physical_device_properties2                       :: 1
KHR_GET_PHYSICAL_DEVICE_PROPERTIES_2_SPEC_VERSION         :: 2
KHR_GET_PHYSICAL_DEVICE_PROPERTIES_2_EXTENSION_NAME       :: "VK_KHR_get_physical_device_properties2"
KHR_device_group                                          :: 1
KHR_DEVICE_GROUP_SPEC_VERSION                             :: 4
KHR_DEVICE_GROUP_EXTENSION_NAME                           :: "VK_KHR_device_group"
KHR_shader_draw_parameters                                :: 1
KHR_SHADER_DRAW_PARAMETERS_SPEC_VERSION                   :: 1
KHR_SHADER_DRAW_PARAMETERS_EXTENSION_NAME                 :: "VK_KHR_shader_draw_parameters"
KHR_maintenance1                                          :: 1
KHR_MAINTENANCE_1_SPEC_VERSION                            :: 2
KHR_MAINTENANCE_1_EXTENSION_NAME                          :: "VK_KHR_maintenance1"
KHR_MAINTENANCE1_SPEC_VERSION                             :: KHR_MAINTENANCE_1_SPEC_VERSION
KHR_MAINTENANCE1_EXTENSION_NAME                           :: KHR_MAINTENANCE_1_EXTENSION_NAME
KHR_device_group_creation                                 :: 1
KHR_DEVICE_GROUP_CREATION_SPEC_VERSION                    :: 1
KHR_DEVICE_GROUP_CREATION_EXTENSION_NAME                  :: "VK_KHR_device_group_creation"
MAX_DEVICE_GROUP_SIZE_KHR                                 :: MAX_DEVICE_GROUP_SIZE
KHR_external_memory_capabilities                          :: 1
KHR_EXTERNAL_MEMORY_CAPABILITIES_SPEC_VERSION             :: 1
KHR_EXTERNAL_MEMORY_CAPABILITIES_EXTENSION_NAME           :: "VK_KHR_external_memory_capabilities"
LUID_SIZE_KHR                                             :: LUID_SIZE
KHR_external_memory                                       :: 1
KHR_EXTERNAL_MEMORY_SPEC_VERSION                          :: 1
KHR_EXTERNAL_MEMORY_EXTENSION_NAME                        :: "VK_KHR_external_memory"
QUEUE_FAMILY_EXTERNAL_KHR                                 :: QUEUE_FAMILY_EXTERNAL
KHR_external_memory_fd                                    :: 1
KHR_EXTERNAL_MEMORY_FD_SPEC_VERSION                       :: 1
KHR_EXTERNAL_MEMORY_FD_EXTENSION_NAME                     :: "VK_KHR_external_memory_fd"
KHR_external_semaphore_capabilities                       :: 1
KHR_EXTERNAL_SEMAPHORE_CAPABILITIES_SPEC_VERSION          :: 1
KHR_EXTERNAL_SEMAPHORE_CAPABILITIES_EXTENSION_NAME        :: "VK_KHR_external_semaphore_capabilities"
KHR_external_semaphore                                    :: 1
KHR_EXTERNAL_SEMAPHORE_SPEC_VERSION                       :: 1
KHR_EXTERNAL_SEMAPHORE_EXTENSION_NAME                     :: "VK_KHR_external_semaphore"
KHR_external_semaphore_fd                                 :: 1
KHR_EXTERNAL_SEMAPHORE_FD_SPEC_VERSION                    :: 1
KHR_EXTERNAL_SEMAPHORE_FD_EXTENSION_NAME                  :: "VK_KHR_external_semaphore_fd"
KHR_push_descriptor                                       :: 1
KHR_PUSH_DESCRIPTOR_SPEC_VERSION                          :: 2
KHR_PUSH_DESCRIPTOR_EXTENSION_NAME                        :: "VK_KHR_push_descriptor"
KHR_shader_float16_int8                                   :: 1
KHR_SHADER_FLOAT16_INT8_SPEC_VERSION                      :: 1
KHR_SHADER_FLOAT16_INT8_EXTENSION_NAME                    :: "VK_KHR_shader_float16_int8"
KHR_16bit_storage                                         :: 1
KHR_16BIT_STORAGE_SPEC_VERSION                            :: 1
KHR_16BIT_STORAGE_EXTENSION_NAME                          :: "VK_KHR_16bit_storage"
KHR_incremental_present                                   :: 1
KHR_INCREMENTAL_PRESENT_SPEC_VERSION                      :: 2
KHR_INCREMENTAL_PRESENT_EXTENSION_NAME                    :: "VK_KHR_incremental_present"
KHR_descriptor_update_template                            :: 1
KHR_DESCRIPTOR_UPDATE_TEMPLATE_SPEC_VERSION               :: 1
KHR_DESCRIPTOR_UPDATE_TEMPLATE_EXTENSION_NAME             :: "VK_KHR_descriptor_update_template"
KHR_imageless_framebuffer                                 :: 1
KHR_IMAGELESS_FRAMEBUFFER_SPEC_VERSION                    :: 1
KHR_IMAGELESS_FRAMEBUFFER_EXTENSION_NAME                  :: "VK_KHR_imageless_framebuffer"
KHR_create_renderpass2                                    :: 1
KHR_CREATE_RENDERPASS_2_SPEC_VERSION                      :: 1
KHR_CREATE_RENDERPASS_2_EXTENSION_NAME                    :: "VK_KHR_create_renderpass2"
KHR_shared_presentable_image                              :: 1
KHR_SHARED_PRESENTABLE_IMAGE_SPEC_VERSION                 :: 1
KHR_SHARED_PRESENTABLE_IMAGE_EXTENSION_NAME               :: "VK_KHR_shared_presentable_image"
KHR_external_fence_capabilities                           :: 1
KHR_EXTERNAL_FENCE_CAPABILITIES_SPEC_VERSION              :: 1
KHR_EXTERNAL_FENCE_CAPABILITIES_EXTENSION_NAME            :: "VK_KHR_external_fence_capabilities"
KHR_external_fence                                        :: 1
KHR_EXTERNAL_FENCE_SPEC_VERSION                           :: 1
KHR_EXTERNAL_FENCE_EXTENSION_NAME                         :: "VK_KHR_external_fence"
KHR_external_fence_fd                                     :: 1
KHR_EXTERNAL_FENCE_FD_SPEC_VERSION                        :: 1
KHR_EXTERNAL_FENCE_FD_EXTENSION_NAME                      :: "VK_KHR_external_fence_fd"
KHR_performance_query                                     :: 1
KHR_PERFORMANCE_QUERY_SPEC_VERSION                        :: 1
KHR_PERFORMANCE_QUERY_EXTENSION_NAME                      :: "VK_KHR_performance_query"
KHR_maintenance2                                          :: 1
KHR_MAINTENANCE_2_SPEC_VERSION                            :: 1
KHR_MAINTENANCE_2_EXTENSION_NAME                          :: "VK_KHR_maintenance2"
KHR_MAINTENANCE2_SPEC_VERSION                             :: KHR_MAINTENANCE_2_SPEC_VERSION
KHR_MAINTENANCE2_EXTENSION_NAME                           :: KHR_MAINTENANCE_2_EXTENSION_NAME
KHR_get_surface_capabilities2                             :: 1
KHR_GET_SURFACE_CAPABILITIES_2_SPEC_VERSION               :: 1
KHR_GET_SURFACE_CAPABILITIES_2_EXTENSION_NAME             :: "VK_KHR_get_surface_capabilities2"
KHR_variable_pointers                                     :: 1
KHR_VARIABLE_POINTERS_SPEC_VERSION                        :: 1
KHR_VARIABLE_POINTERS_EXTENSION_NAME                      :: "VK_KHR_variable_pointers"
KHR_get_display_properties2                               :: 1
KHR_GET_DISPLAY_PROPERTIES_2_SPEC_VERSION                 :: 1
KHR_GET_DISPLAY_PROPERTIES_2_EXTENSION_NAME               :: "VK_KHR_get_display_properties2"
KHR_dedicated_allocation                                  :: 1
KHR_DEDICATED_ALLOCATION_SPEC_VERSION                     :: 3
KHR_DEDICATED_ALLOCATION_EXTENSION_NAME                   :: "VK_KHR_dedicated_allocation"
KHR_storage_buffer_storage_class                          :: 1
KHR_STORAGE_BUFFER_STORAGE_CLASS_SPEC_VERSION             :: 1
KHR_STORAGE_BUFFER_STORAGE_CLASS_EXTENSION_NAME           :: "VK_KHR_storage_buffer_storage_class"
KHR_relaxed_block_layout                                  :: 1
KHR_RELAXED_BLOCK_LAYOUT_SPEC_VERSION                     :: 1
KHR_RELAXED_BLOCK_LAYOUT_EXTENSION_NAME                   :: "VK_KHR_relaxed_block_layout"
KHR_get_memory_requirements2                              :: 1
KHR_GET_MEMORY_REQUIREMENTS_2_SPEC_VERSION                :: 1
KHR_GET_MEMORY_REQUIREMENTS_2_EXTENSION_NAME              :: "VK_KHR_get_memory_requirements2"
KHR_image_format_list                                     :: 1
KHR_IMAGE_FORMAT_LIST_SPEC_VERSION                        :: 1
KHR_IMAGE_FORMAT_LIST_EXTENSION_NAME                      :: "VK_KHR_image_format_list"
KHR_sampler_ycbcr_conversion                              :: 1
KHR_SAMPLER_YCBCR_CONVERSION_SPEC_VERSION                 :: 14
KHR_SAMPLER_YCBCR_CONVERSION_EXTENSION_NAME               :: "VK_KHR_sampler_ycbcr_conversion"
KHR_bind_memory2                                          :: 1
KHR_BIND_MEMORY_2_SPEC_VERSION                            :: 1
KHR_BIND_MEMORY_2_EXTENSION_NAME                          :: "VK_KHR_bind_memory2"
KHR_maintenance3                                          :: 1
KHR_MAINTENANCE_3_SPEC_VERSION                            :: 1
KHR_MAINTENANCE_3_EXTENSION_NAME                          :: "VK_KHR_maintenance3"
KHR_MAINTENANCE3_SPEC_VERSION                             :: KHR_MAINTENANCE_3_SPEC_VERSION
KHR_MAINTENANCE3_EXTENSION_NAME                           :: KHR_MAINTENANCE_3_EXTENSION_NAME
KHR_draw_indirect_count                                   :: 1
KHR_DRAW_INDIRECT_COUNT_SPEC_VERSION                      :: 1
KHR_DRAW_INDIRECT_COUNT_EXTENSION_NAME                    :: "VK_KHR_draw_indirect_count"
KHR_shader_subgroup_extended_types                        :: 1
KHR_SHADER_SUBGROUP_EXTENDED_TYPES_SPEC_VERSION           :: 1
KHR_SHADER_SUBGROUP_EXTENDED_TYPES_EXTENSION_NAME         :: "VK_KHR_shader_subgroup_extended_types"
KHR_8bit_storage                                          :: 1
KHR_8BIT_STORAGE_SPEC_VERSION                             :: 1
KHR_8BIT_STORAGE_EXTENSION_NAME                           :: "VK_KHR_8bit_storage"
KHR_shader_atomic_int64                                   :: 1
KHR_SHADER_ATOMIC_INT64_SPEC_VERSION                      :: 1
KHR_SHADER_ATOMIC_INT64_EXTENSION_NAME                    :: "VK_KHR_shader_atomic_int64"
KHR_shader_clock                                          :: 1
KHR_SHADER_CLOCK_SPEC_VERSION                             :: 1
KHR_SHADER_CLOCK_EXTENSION_NAME                           :: "VK_KHR_shader_clock"
KHR_video_decode_h265                                     :: 1
KHR_VIDEO_DECODE_H265_SPEC_VERSION                        :: 8
KHR_VIDEO_DECODE_H265_EXTENSION_NAME                      :: "VK_KHR_video_decode_h265"
KHR_global_priority                                       :: 1
MAX_GLOBAL_PRIORITY_SIZE_KHR                              :: 16
KHR_GLOBAL_PRIORITY_SPEC_VERSION                          :: 1
KHR_GLOBAL_PRIORITY_EXTENSION_NAME                        :: "VK_KHR_global_priority"
KHR_driver_properties                                     :: 1
KHR_DRIVER_PROPERTIES_SPEC_VERSION                        :: 1
KHR_DRIVER_PROPERTIES_EXTENSION_NAME                      :: "VK_KHR_driver_properties"
MAX_DRIVER_NAME_SIZE_KHR                                  :: MAX_DRIVER_NAME_SIZE
MAX_DRIVER_INFO_SIZE_KHR                                  :: MAX_DRIVER_INFO_SIZE
KHR_shader_float_controls                                 :: 1
KHR_SHADER_FLOAT_CONTROLS_SPEC_VERSION                    :: 4
KHR_SHADER_FLOAT_CONTROLS_EXTENSION_NAME                  :: "VK_KHR_shader_float_controls"
KHR_depth_stencil_resolve                                 :: 1
KHR_DEPTH_STENCIL_RESOLVE_SPEC_VERSION                    :: 1
KHR_DEPTH_STENCIL_RESOLVE_EXTENSION_NAME                  :: "VK_KHR_depth_stencil_resolve"
KHR_swapchain_mutable_format                              :: 1
KHR_SWAPCHAIN_MUTABLE_FORMAT_SPEC_VERSION                 :: 1
KHR_SWAPCHAIN_MUTABLE_FORMAT_EXTENSION_NAME               :: "VK_KHR_swapchain_mutable_format"
KHR_timeline_semaphore                                    :: 1
KHR_TIMELINE_SEMAPHORE_SPEC_VERSION                       :: 2
KHR_TIMELINE_SEMAPHORE_EXTENSION_NAME                     :: "VK_KHR_timeline_semaphore"
KHR_vulkan_memory_model                                   :: 1
KHR_VULKAN_MEMORY_MODEL_SPEC_VERSION                      :: 3
KHR_VULKAN_MEMORY_MODEL_EXTENSION_NAME                    :: "VK_KHR_vulkan_memory_model"
KHR_shader_terminate_invocation                           :: 1
KHR_SHADER_TERMINATE_INVOCATION_SPEC_VERSION              :: 1
KHR_SHADER_TERMINATE_INVOCATION_EXTENSION_NAME            :: "VK_KHR_shader_terminate_invocation"
KHR_fragment_shading_rate                                 :: 1
KHR_FRAGMENT_SHADING_RATE_SPEC_VERSION                    :: 2
KHR_FRAGMENT_SHADING_RATE_EXTENSION_NAME                  :: "VK_KHR_fragment_shading_rate"
KHR_dynamic_rendering_local_read                          :: 1
KHR_DYNAMIC_RENDERING_LOCAL_READ_SPEC_VERSION             :: 1
KHR_DYNAMIC_RENDERING_LOCAL_READ_EXTENSION_NAME           :: "VK_KHR_dynamic_rendering_local_read"
KHR_shader_quad_control                                   :: 1
KHR_SHADER_QUAD_CONTROL_SPEC_VERSION                      :: 1
KHR_SHADER_QUAD_CONTROL_EXTENSION_NAME                    :: "VK_KHR_shader_quad_control"
KHR_spirv_1_4                                             :: 1
KHR_SPIRV_1_4_SPEC_VERSION                                :: 1
KHR_SPIRV_1_4_EXTENSION_NAME                              :: "VK_KHR_spirv_1_4"
KHR_surface_protected_capabilities                        :: 1
KHR_SURFACE_PROTECTED_CAPABILITIES_SPEC_VERSION           :: 1
KHR_SURFACE_PROTECTED_CAPABILITIES_EXTENSION_NAME         :: "VK_KHR_surface_protected_capabilities"
KHR_separate_depth_stencil_layouts                        :: 1
KHR_SEPARATE_DEPTH_STENCIL_LAYOUTS_SPEC_VERSION           :: 1
KHR_SEPARATE_DEPTH_STENCIL_LAYOUTS_EXTENSION_NAME         :: "VK_KHR_separate_depth_stencil_layouts"
KHR_present_wait                                          :: 1
KHR_PRESENT_WAIT_SPEC_VERSION                             :: 1
KHR_PRESENT_WAIT_EXTENSION_NAME                           :: "VK_KHR_present_wait"
KHR_uniform_buffer_standard_layout                        :: 1
KHR_UNIFORM_BUFFER_STANDARD_LAYOUT_SPEC_VERSION           :: 1
KHR_UNIFORM_BUFFER_STANDARD_LAYOUT_EXTENSION_NAME         :: "VK_KHR_uniform_buffer_standard_layout"
KHR_buffer_device_address                                 :: 1
KHR_BUFFER_DEVICE_ADDRESS_SPEC_VERSION                    :: 1
KHR_BUFFER_DEVICE_ADDRESS_EXTENSION_NAME                  :: "VK_KHR_buffer_device_address"
KHR_deferred_host_operations                              :: 1
KHR_DEFERRED_HOST_OPERATIONS_SPEC_VERSION                 :: 4
KHR_DEFERRED_HOST_OPERATIONS_EXTENSION_NAME               :: "VK_KHR_deferred_host_operations"
KHR_pipeline_executable_properties                        :: 1
KHR_PIPELINE_EXECUTABLE_PROPERTIES_SPEC_VERSION           :: 1
KHR_PIPELINE_EXECUTABLE_PROPERTIES_EXTENSION_NAME         :: "VK_KHR_pipeline_executable_properties"
KHR_map_memory2                                           :: 1
KHR_MAP_MEMORY_2_SPEC_VERSION                             :: 1
KHR_MAP_MEMORY_2_EXTENSION_NAME                           :: "VK_KHR_map_memory2"
KHR_shader_integer_dot_product                            :: 1
KHR_SHADER_INTEGER_DOT_PRODUCT_SPEC_VERSION               :: 1
KHR_SHADER_INTEGER_DOT_PRODUCT_EXTENSION_NAME             :: "VK_KHR_shader_integer_dot_product"
KHR_pipeline_library                                      :: 1
KHR_PIPELINE_LIBRARY_SPEC_VERSION                         :: 1
KHR_PIPELINE_LIBRARY_EXTENSION_NAME                       :: "VK_KHR_pipeline_library"
KHR_shader_non_semantic_info                              :: 1
KHR_SHADER_NON_SEMANTIC_INFO_SPEC_VERSION                 :: 1
KHR_SHADER_NON_SEMANTIC_INFO_EXTENSION_NAME               :: "VK_KHR_shader_non_semantic_info"
KHR_present_id                                            :: 1
KHR_PRESENT_ID_SPEC_VERSION                               :: 1
KHR_PRESENT_ID_EXTENSION_NAME                             :: "VK_KHR_present_id"
KHR_video_encode_queue                                    :: 1
KHR_VIDEO_ENCODE_QUEUE_SPEC_VERSION                       :: 12
KHR_VIDEO_ENCODE_QUEUE_EXTENSION_NAME                     :: "VK_KHR_video_encode_queue"
KHR_synchronization2                                      :: 1
KHR_SYNCHRONIZATION_2_SPEC_VERSION                        :: 1
KHR_SYNCHRONIZATION_2_EXTENSION_NAME                      :: "VK_KHR_synchronization2"
KHR_fragment_shader_barycentric                           :: 1
KHR_FRAGMENT_SHADER_BARYCENTRIC_SPEC_VERSION              :: 1
KHR_FRAGMENT_SHADER_BARYCENTRIC_EXTENSION_NAME            :: "VK_KHR_fragment_shader_barycentric"
KHR_shader_subgroup_uniform_control_flow                  :: 1
KHR_SHADER_SUBGROUP_UNIFORM_CONTROL_FLOW_SPEC_VERSION     :: 1
KHR_SHADER_SUBGROUP_UNIFORM_CONTROL_FLOW_EXTENSION_NAME   :: "VK_KHR_shader_subgroup_uniform_control_flow"
KHR_zero_initialize_workgroup_memory                      :: 1
KHR_ZERO_INITIALIZE_WORKGROUP_MEMORY_SPEC_VERSION         :: 1
KHR_ZERO_INITIALIZE_WORKGROUP_MEMORY_EXTENSION_NAME       :: "VK_KHR_zero_initialize_workgroup_memory"
KHR_workgroup_memory_explicit_layout                      :: 1
KHR_WORKGROUP_MEMORY_EXPLICIT_LAYOUT_SPEC_VERSION         :: 1
KHR_WORKGROUP_MEMORY_EXPLICIT_LAYOUT_EXTENSION_NAME       :: "VK_KHR_workgroup_memory_explicit_layout"
KHR_copy_commands2                                        :: 1
KHR_COPY_COMMANDS_2_SPEC_VERSION                          :: 1
KHR_COPY_COMMANDS_2_EXTENSION_NAME                        :: "VK_KHR_copy_commands2"
KHR_format_feature_flags2                                 :: 1
KHR_FORMAT_FEATURE_FLAGS_2_SPEC_VERSION                   :: 2
KHR_FORMAT_FEATURE_FLAGS_2_EXTENSION_NAME                 :: "VK_KHR_format_feature_flags2"
KHR_ray_tracing_maintenance1                              :: 1
KHR_RAY_TRACING_MAINTENANCE_1_SPEC_VERSION                :: 1
KHR_RAY_TRACING_MAINTENANCE_1_EXTENSION_NAME              :: "VK_KHR_ray_tracing_maintenance1"
KHR_portability_enumeration                               :: 1
KHR_PORTABILITY_ENUMERATION_SPEC_VERSION                  :: 1
KHR_PORTABILITY_ENUMERATION_EXTENSION_NAME                :: "VK_KHR_portability_enumeration"
KHR_maintenance4                                          :: 1
KHR_MAINTENANCE_4_SPEC_VERSION                            :: 2
KHR_MAINTENANCE_4_EXTENSION_NAME                          :: "VK_KHR_maintenance4"
KHR_shader_subgroup_rotate                                :: 1
KHR_SHADER_SUBGROUP_ROTATE_SPEC_VERSION                   :: 2
KHR_SHADER_SUBGROUP_ROTATE_EXTENSION_NAME                 :: "VK_KHR_shader_subgroup_rotate"
KHR_shader_maximal_reconvergence                          :: 1
KHR_SHADER_MAXIMAL_RECONVERGENCE_SPEC_VERSION             :: 1
KHR_SHADER_MAXIMAL_RECONVERGENCE_EXTENSION_NAME           :: "VK_KHR_shader_maximal_reconvergence"
KHR_maintenance5                                          :: 1
KHR_MAINTENANCE_5_SPEC_VERSION                            :: 1
KHR_MAINTENANCE_5_EXTENSION_NAME                          :: "VK_KHR_maintenance5"
KHR_ray_tracing_position_fetch                            :: 1
KHR_RAY_TRACING_POSITION_FETCH_SPEC_VERSION               :: 1
KHR_RAY_TRACING_POSITION_FETCH_EXTENSION_NAME             :: "VK_KHR_ray_tracing_position_fetch"
KHR_pipeline_binary                                       :: 1
MAX_PIPELINE_BINARY_KEY_SIZE_KHR                          :: 32
KHR_PIPELINE_BINARY_SPEC_VERSION                          :: 1
KHR_PIPELINE_BINARY_EXTENSION_NAME                        :: "VK_KHR_pipeline_binary"
KHR_cooperative_matrix                                    :: 1
KHR_COOPERATIVE_MATRIX_SPEC_VERSION                       :: 2
KHR_COOPERATIVE_MATRIX_EXTENSION_NAME                     :: "VK_KHR_cooperative_matrix"
KHR_compute_shader_derivatives                            :: 1
KHR_COMPUTE_SHADER_DERIVATIVES_SPEC_VERSION               :: 1
KHR_COMPUTE_SHADER_DERIVATIVES_EXTENSION_NAME             :: "VK_KHR_compute_shader_derivatives"
KHR_video_decode_av1                                      :: 1
MAX_VIDEO_AV1_REFERENCES_PER_FRAME_KHR                    :: 7
KHR_VIDEO_DECODE_AV1_SPEC_VERSION                         :: 1
KHR_VIDEO_DECODE_AV1_EXTENSION_NAME                       :: "VK_KHR_video_decode_av1"
KHR_video_maintenance1                                    :: 1
KHR_VIDEO_MAINTENANCE_1_SPEC_VERSION                      :: 1
KHR_VIDEO_MAINTENANCE_1_EXTENSION_NAME                    :: "VK_KHR_video_maintenance1"
KHR_vertex_attribute_divisor                              :: 1
KHR_VERTEX_ATTRIBUTE_DIVISOR_SPEC_VERSION                 :: 1
KHR_VERTEX_ATTRIBUTE_DIVISOR_EXTENSION_NAME               :: "VK_KHR_vertex_attribute_divisor"
KHR_load_store_op_none                                    :: 1
KHR_LOAD_STORE_OP_NONE_SPEC_VERSION                       :: 1
KHR_LOAD_STORE_OP_NONE_EXTENSION_NAME                     :: "VK_KHR_load_store_op_none"
KHR_shader_float_controls2                                :: 1
KHR_SHADER_FLOAT_CONTROLS_2_SPEC_VERSION                  :: 1
KHR_SHADER_FLOAT_CONTROLS_2_EXTENSION_NAME                :: "VK_KHR_shader_float_controls2"
KHR_index_type_uint8                                      :: 1
KHR_INDEX_TYPE_UINT8_SPEC_VERSION                         :: 1
KHR_INDEX_TYPE_UINT8_EXTENSION_NAME                       :: "VK_KHR_index_type_uint8"
KHR_line_rasterization                                    :: 1
KHR_LINE_RASTERIZATION_SPEC_VERSION                       :: 1
KHR_LINE_RASTERIZATION_EXTENSION_NAME                     :: "VK_KHR_line_rasterization"
KHR_calibrated_timestamps                                 :: 1
KHR_CALIBRATED_TIMESTAMPS_SPEC_VERSION                    :: 1
KHR_CALIBRATED_TIMESTAMPS_EXTENSION_NAME                  :: "VK_KHR_calibrated_timestamps"
KHR_shader_expect_assume                                  :: 1
KHR_SHADER_EXPECT_ASSUME_SPEC_VERSION                     :: 1
KHR_SHADER_EXPECT_ASSUME_EXTENSION_NAME                   :: "VK_KHR_shader_expect_assume"
KHR_maintenance6                                          :: 1
KHR_MAINTENANCE_6_SPEC_VERSION                            :: 1
KHR_MAINTENANCE_6_EXTENSION_NAME                          :: "VK_KHR_maintenance6"
KHR_shader_relaxed_extended_instruction                   :: 1
KHR_SHADER_RELAXED_EXTENDED_INSTRUCTION_SPEC_VERSION      :: 1
KHR_SHADER_RELAXED_EXTENDED_INSTRUCTION_EXTENSION_NAME    :: "VK_KHR_shader_relaxed_extended_instruction"
KHR_maintenance7                                          :: 1
KHR_MAINTENANCE_7_SPEC_VERSION                            :: 1
KHR_MAINTENANCE_7_EXTENSION_NAME                          :: "VK_KHR_maintenance7"
EXT_debug_report                                          :: 1
EXT_DEBUG_REPORT_SPEC_VERSION                             :: 10
EXT_DEBUG_REPORT_EXTENSION_NAME                           :: "VK_EXT_debug_report"
NV_glsl_shader                                            :: 1
NV_GLSL_SHADER_SPEC_VERSION                               :: 1
NV_GLSL_SHADER_EXTENSION_NAME                             :: "VK_NV_glsl_shader"
EXT_depth_range_unrestricted                              :: 1
EXT_DEPTH_RANGE_UNRESTRICTED_SPEC_VERSION                 :: 1
EXT_DEPTH_RANGE_UNRESTRICTED_EXTENSION_NAME               :: "VK_EXT_depth_range_unrestricted"
AMD_rasterization_order                                   :: 1
AMD_RASTERIZATION_ORDER_SPEC_VERSION                      :: 1
AMD_RASTERIZATION_ORDER_EXTENSION_NAME                    :: "VK_AMD_rasterization_order"
AMD_shader_trinary_minmax                                 :: 1
AMD_SHADER_TRINARY_MINMAX_SPEC_VERSION                    :: 1
AMD_SHADER_TRINARY_MINMAX_EXTENSION_NAME                  :: "VK_AMD_shader_trinary_minmax"
AMD_shader_explicit_vertex_parameter                      :: 1
AMD_SHADER_EXPLICIT_VERTEX_PARAMETER_SPEC_VERSION         :: 1
AMD_SHADER_EXPLICIT_VERTEX_PARAMETER_EXTENSION_NAME       :: "VK_AMD_shader_explicit_vertex_parameter"
EXT_debug_marker                                          :: 1
EXT_DEBUG_MARKER_SPEC_VERSION                             :: 4
EXT_DEBUG_MARKER_EXTENSION_NAME                           :: "VK_EXT_debug_marker"
AMD_gcn_shader                                            :: 1
AMD_GCN_SHADER_SPEC_VERSION                               :: 1
AMD_GCN_SHADER_EXTENSION_NAME                             :: "VK_AMD_gcn_shader"
NV_dedicated_allocation                                   :: 1
NV_DEDICATED_ALLOCATION_SPEC_VERSION                      :: 1
NV_DEDICATED_ALLOCATION_EXTENSION_NAME                    :: "VK_NV_dedicated_allocation"
EXT_transform_feedback                                    :: 1
EXT_TRANSFORM_FEEDBACK_SPEC_VERSION                       :: 1
EXT_TRANSFORM_FEEDBACK_EXTENSION_NAME                     :: "VK_EXT_transform_feedback"
NVX_binary_import                                         :: 1
NVX_BINARY_IMPORT_SPEC_VERSION                            :: 1
NVX_BINARY_IMPORT_EXTENSION_NAME                          :: "VK_NVX_binary_import"
NVX_image_view_handle                                     :: 1
NVX_IMAGE_VIEW_HANDLE_SPEC_VERSION                        :: 2
NVX_IMAGE_VIEW_HANDLE_EXTENSION_NAME                      :: "VK_NVX_image_view_handle"
AMD_draw_indirect_count                                   :: 1
AMD_DRAW_INDIRECT_COUNT_SPEC_VERSION                      :: 2
AMD_DRAW_INDIRECT_COUNT_EXTENSION_NAME                    :: "VK_AMD_draw_indirect_count"
AMD_negative_viewport_height                              :: 1
AMD_NEGATIVE_VIEWPORT_HEIGHT_SPEC_VERSION                 :: 1
AMD_NEGATIVE_VIEWPORT_HEIGHT_EXTENSION_NAME               :: "VK_AMD_negative_viewport_height"
AMD_gpu_shader_half_float                                 :: 1
AMD_GPU_SHADER_HALF_FLOAT_SPEC_VERSION                    :: 2
AMD_GPU_SHADER_HALF_FLOAT_EXTENSION_NAME                  :: "VK_AMD_gpu_shader_half_float"
AMD_shader_ballot                                         :: 1
AMD_SHADER_BALLOT_SPEC_VERSION                            :: 1
AMD_SHADER_BALLOT_EXTENSION_NAME                          :: "VK_AMD_shader_ballot"
AMD_texture_gather_bias_lod                               :: 1
AMD_TEXTURE_GATHER_BIAS_LOD_SPEC_VERSION                  :: 1
AMD_TEXTURE_GATHER_BIAS_LOD_EXTENSION_NAME                :: "VK_AMD_texture_gather_bias_lod"
AMD_shader_info                                           :: 1
AMD_SHADER_INFO_SPEC_VERSION                              :: 1
AMD_SHADER_INFO_EXTENSION_NAME                            :: "VK_AMD_shader_info"
AMD_shader_image_load_store_lod                           :: 1
AMD_SHADER_IMAGE_LOAD_STORE_LOD_SPEC_VERSION              :: 1
AMD_SHADER_IMAGE_LOAD_STORE_LOD_EXTENSION_NAME            :: "VK_AMD_shader_image_load_store_lod"
NV_corner_sampled_image                                   :: 1
NV_CORNER_SAMPLED_IMAGE_SPEC_VERSION                      :: 2
NV_CORNER_SAMPLED_IMAGE_EXTENSION_NAME                    :: "VK_NV_corner_sampled_image"
NV_external_memory_capabilities                           :: 1
NV_EXTERNAL_MEMORY_CAPABILITIES_SPEC_VERSION              :: 1
NV_EXTERNAL_MEMORY_CAPABILITIES_EXTENSION_NAME            :: "VK_NV_external_memory_capabilities"
NV_external_memory                                        :: 1
NV_EXTERNAL_MEMORY_SPEC_VERSION                           :: 1
NV_EXTERNAL_MEMORY_EXTENSION_NAME                         :: "VK_NV_external_memory"
EXT_validation_flags                                      :: 1
EXT_VALIDATION_FLAGS_SPEC_VERSION                         :: 3
EXT_VALIDATION_FLAGS_EXTENSION_NAME                       :: "VK_EXT_validation_flags"
EXT_shader_subgroup_ballot                                :: 1
EXT_SHADER_SUBGROUP_BALLOT_SPEC_VERSION                   :: 1
EXT_SHADER_SUBGROUP_BALLOT_EXTENSION_NAME                 :: "VK_EXT_shader_subgroup_ballot"
EXT_shader_subgroup_vote                                  :: 1
EXT_SHADER_SUBGROUP_VOTE_SPEC_VERSION                     :: 1
EXT_SHADER_SUBGROUP_VOTE_EXTENSION_NAME                   :: "VK_EXT_shader_subgroup_vote"
EXT_texture_compression_astc_hdr                          :: 1
EXT_TEXTURE_COMPRESSION_ASTC_HDR_SPEC_VERSION             :: 1
EXT_TEXTURE_COMPRESSION_ASTC_HDR_EXTENSION_NAME           :: "VK_EXT_texture_compression_astc_hdr"
EXT_astc_decode_mode                                      :: 1
EXT_ASTC_DECODE_MODE_SPEC_VERSION                         :: 1
EXT_ASTC_DECODE_MODE_EXTENSION_NAME                       :: "VK_EXT_astc_decode_mode"
EXT_pipeline_robustness                                   :: 1
EXT_PIPELINE_ROBUSTNESS_SPEC_VERSION                      :: 1
EXT_PIPELINE_ROBUSTNESS_EXTENSION_NAME                    :: "VK_EXT_pipeline_robustness"
EXT_conditional_rendering                                 :: 1
EXT_CONDITIONAL_RENDERING_SPEC_VERSION                    :: 2
EXT_CONDITIONAL_RENDERING_EXTENSION_NAME                  :: "VK_EXT_conditional_rendering"
NV_clip_space_w_scaling                                   :: 1
NV_CLIP_SPACE_W_SCALING_SPEC_VERSION                      :: 1
NV_CLIP_SPACE_W_SCALING_EXTENSION_NAME                    :: "VK_NV_clip_space_w_scaling"
EXT_direct_mode_display                                   :: 1
EXT_DIRECT_MODE_DISPLAY_SPEC_VERSION                      :: 1
EXT_DIRECT_MODE_DISPLAY_EXTENSION_NAME                    :: "VK_EXT_direct_mode_display"
EXT_display_surface_counter                               :: 1
EXT_DISPLAY_SURFACE_COUNTER_SPEC_VERSION                  :: 1
EXT_DISPLAY_SURFACE_COUNTER_EXTENSION_NAME                :: "VK_EXT_display_surface_counter"
EXT_display_control                                       :: 1
EXT_DISPLAY_CONTROL_SPEC_VERSION                          :: 1
EXT_DISPLAY_CONTROL_EXTENSION_NAME                        :: "VK_EXT_display_control"
GOOGLE_display_timing                                     :: 1
GOOGLE_DISPLAY_TIMING_SPEC_VERSION                        :: 1
GOOGLE_DISPLAY_TIMING_EXTENSION_NAME                      :: "VK_GOOGLE_display_timing"
NV_sample_mask_override_coverage                          :: 1
NV_SAMPLE_MASK_OVERRIDE_COVERAGE_SPEC_VERSION             :: 1
NV_SAMPLE_MASK_OVERRIDE_COVERAGE_EXTENSION_NAME           :: "VK_NV_sample_mask_override_coverage"
NV_geometry_shader_passthrough                            :: 1
NV_GEOMETRY_SHADER_PASSTHROUGH_SPEC_VERSION               :: 1
NV_GEOMETRY_SHADER_PASSTHROUGH_EXTENSION_NAME             :: "VK_NV_geometry_shader_passthrough"
NV_viewport_array2                                        :: 1
NV_VIEWPORT_ARRAY_2_SPEC_VERSION                          :: 1
NV_VIEWPORT_ARRAY_2_EXTENSION_NAME                        :: "VK_NV_viewport_array2"
NV_VIEWPORT_ARRAY2_SPEC_VERSION                           :: NV_VIEWPORT_ARRAY_2_SPEC_VERSION
NV_VIEWPORT_ARRAY2_EXTENSION_NAME                         :: NV_VIEWPORT_ARRAY_2_EXTENSION_NAME
NVX_multiview_per_view_attributes                         :: 1
NVX_MULTIVIEW_PER_VIEW_ATTRIBUTES_SPEC_VERSION            :: 1
NVX_MULTIVIEW_PER_VIEW_ATTRIBUTES_EXTENSION_NAME          :: "VK_NVX_multiview_per_view_attributes"
NV_viewport_swizzle                                       :: 1
NV_VIEWPORT_SWIZZLE_SPEC_VERSION                          :: 1
NV_VIEWPORT_SWIZZLE_EXTENSION_NAME                        :: "VK_NV_viewport_swizzle"
EXT_discard_rectangles                                    :: 1
EXT_DISCARD_RECTANGLES_SPEC_VERSION                       :: 2
EXT_DISCARD_RECTANGLES_EXTENSION_NAME                     :: "VK_EXT_discard_rectangles"
EXT_conservative_rasterization                            :: 1
EXT_CONSERVATIVE_RASTERIZATION_SPEC_VERSION               :: 1
EXT_CONSERVATIVE_RASTERIZATION_EXTENSION_NAME             :: "VK_EXT_conservative_rasterization"
EXT_depth_clip_enable                                     :: 1
EXT_DEPTH_CLIP_ENABLE_SPEC_VERSION                        :: 1
EXT_DEPTH_CLIP_ENABLE_EXTENSION_NAME                      :: "VK_EXT_depth_clip_enable"
EXT_swapchain_colorspace                                  :: 1
EXT_SWAPCHAIN_COLOR_SPACE_SPEC_VERSION                    :: 5
EXT_SWAPCHAIN_COLOR_SPACE_EXTENSION_NAME                  :: "VK_EXT_swapchain_colorspace"
EXT_hdr_metadata                                          :: 1
EXT_HDR_METADATA_SPEC_VERSION                             :: 3
EXT_HDR_METADATA_EXTENSION_NAME                           :: "VK_EXT_hdr_metadata"
EXT_external_memory_dma_buf                               :: 1
EXT_EXTERNAL_MEMORY_DMA_BUF_SPEC_VERSION                  :: 1
EXT_EXTERNAL_MEMORY_DMA_BUF_EXTENSION_NAME                :: "VK_EXT_external_memory_dma_buf"
EXT_queue_family_foreign                                  :: 1
EXT_QUEUE_FAMILY_FOREIGN_SPEC_VERSION                     :: 1
EXT_QUEUE_FAMILY_FOREIGN_EXTENSION_NAME                   :: "VK_EXT_queue_family_foreign"
EXT_debug_utils                                           :: 1
EXT_DEBUG_UTILS_SPEC_VERSION                              :: 2
EXT_DEBUG_UTILS_EXTENSION_NAME                            :: "VK_EXT_debug_utils"
EXT_sampler_filter_minmax                                 :: 1
EXT_SAMPLER_FILTER_MINMAX_SPEC_VERSION                    :: 2
EXT_SAMPLER_FILTER_MINMAX_EXTENSION_NAME                  :: "VK_EXT_sampler_filter_minmax"
AMD_gpu_shader_int16                                      :: 1
AMD_GPU_SHADER_INT16_SPEC_VERSION                         :: 2
AMD_GPU_SHADER_INT16_EXTENSION_NAME                       :: "VK_AMD_gpu_shader_int16"
AMD_mixed_attachment_samples                              :: 1
AMD_MIXED_ATTACHMENT_SAMPLES_SPEC_VERSION                 :: 1
AMD_MIXED_ATTACHMENT_SAMPLES_EXTENSION_NAME               :: "VK_AMD_mixed_attachment_samples"
AMD_shader_fragment_mask                                  :: 1
AMD_SHADER_FRAGMENT_MASK_SPEC_VERSION                     :: 1
AMD_SHADER_FRAGMENT_MASK_EXTENSION_NAME                   :: "VK_AMD_shader_fragment_mask"
EXT_inline_uniform_block                                  :: 1
EXT_INLINE_UNIFORM_BLOCK_SPEC_VERSION                     :: 1
EXT_INLINE_UNIFORM_BLOCK_EXTENSION_NAME                   :: "VK_EXT_inline_uniform_block"
EXT_shader_stencil_export                                 :: 1
EXT_SHADER_STENCIL_EXPORT_SPEC_VERSION                    :: 1
EXT_SHADER_STENCIL_EXPORT_EXTENSION_NAME                  :: "VK_EXT_shader_stencil_export"
EXT_sample_locations                                      :: 1
EXT_SAMPLE_LOCATIONS_SPEC_VERSION                         :: 1
EXT_SAMPLE_LOCATIONS_EXTENSION_NAME                       :: "VK_EXT_sample_locations"
EXT_blend_operation_advanced                              :: 1
EXT_BLEND_OPERATION_ADVANCED_SPEC_VERSION                 :: 2
EXT_BLEND_OPERATION_ADVANCED_EXTENSION_NAME               :: "VK_EXT_blend_operation_advanced"
NV_fragment_coverage_to_color                             :: 1
NV_FRAGMENT_COVERAGE_TO_COLOR_SPEC_VERSION                :: 1
NV_FRAGMENT_COVERAGE_TO_COLOR_EXTENSION_NAME              :: "VK_NV_fragment_coverage_to_color"
NV_framebuffer_mixed_samples                              :: 1
NV_FRAMEBUFFER_MIXED_SAMPLES_SPEC_VERSION                 :: 1
NV_FRAMEBUFFER_MIXED_SAMPLES_EXTENSION_NAME               :: "VK_NV_framebuffer_mixed_samples"
NV_fill_rectangle                                         :: 1
NV_FILL_RECTANGLE_SPEC_VERSION                            :: 1
NV_FILL_RECTANGLE_EXTENSION_NAME                          :: "VK_NV_fill_rectangle"
NV_shader_sm_builtins                                     :: 1
NV_SHADER_SM_BUILTINS_SPEC_VERSION                        :: 1
NV_SHADER_SM_BUILTINS_EXTENSION_NAME                      :: "VK_NV_shader_sm_builtins"
EXT_post_depth_coverage                                   :: 1
EXT_POST_DEPTH_COVERAGE_SPEC_VERSION                      :: 1
EXT_POST_DEPTH_COVERAGE_EXTENSION_NAME                    :: "VK_EXT_post_depth_coverage"
EXT_image_drm_format_modifier                             :: 1
EXT_IMAGE_DRM_FORMAT_MODIFIER_SPEC_VERSION                :: 2
EXT_IMAGE_DRM_FORMAT_MODIFIER_EXTENSION_NAME              :: "VK_EXT_image_drm_format_modifier"
EXT_validation_cache                                      :: 1
EXT_VALIDATION_CACHE_SPEC_VERSION                         :: 1
EXT_VALIDATION_CACHE_EXTENSION_NAME                       :: "VK_EXT_validation_cache"
EXT_descriptor_indexing                                   :: 1
EXT_DESCRIPTOR_INDEXING_SPEC_VERSION                      :: 2
EXT_DESCRIPTOR_INDEXING_EXTENSION_NAME                    :: "VK_EXT_descriptor_indexing"
EXT_shader_viewport_index_layer                           :: 1
EXT_SHADER_VIEWPORT_INDEX_LAYER_SPEC_VERSION              :: 1
EXT_SHADER_VIEWPORT_INDEX_LAYER_EXTENSION_NAME            :: "VK_EXT_shader_viewport_index_layer"
NV_shading_rate_image                                     :: 1
NV_SHADING_RATE_IMAGE_SPEC_VERSION                        :: 3
NV_SHADING_RATE_IMAGE_EXTENSION_NAME                      :: "VK_NV_shading_rate_image"
NV_ray_tracing                                            :: 1
NV_RAY_TRACING_SPEC_VERSION                               :: 3
NV_RAY_TRACING_EXTENSION_NAME                             :: "VK_NV_ray_tracing"
SHADER_UNUSED_KHR                                         :: 0
NV_representative_fragment_test                           :: 1
NV_REPRESENTATIVE_FRAGMENT_TEST_SPEC_VERSION              :: 2
NV_REPRESENTATIVE_FRAGMENT_TEST_EXTENSION_NAME            :: "VK_NV_representative_fragment_test"
EXT_filter_cubic                                          :: 1
EXT_FILTER_CUBIC_SPEC_VERSION                             :: 3
EXT_FILTER_CUBIC_EXTENSION_NAME                           :: "VK_EXT_filter_cubic"
EXT_global_priority                                       :: 1
EXT_GLOBAL_PRIORITY_SPEC_VERSION                          :: 2
EXT_GLOBAL_PRIORITY_EXTENSION_NAME                        :: "VK_EXT_global_priority"
EXT_external_memory_host                                  :: 1
EXT_EXTERNAL_MEMORY_HOST_SPEC_VERSION                     :: 1
EXT_EXTERNAL_MEMORY_HOST_EXTENSION_NAME                   :: "VK_EXT_external_memory_host"
AMD_buffer_marker                                         :: 1
AMD_BUFFER_MARKER_SPEC_VERSION                            :: 1
AMD_BUFFER_MARKER_EXTENSION_NAME                          :: "VK_AMD_buffer_marker"
AMD_pipeline_compiler_control                             :: 1
AMD_PIPELINE_COMPILER_CONTROL_SPEC_VERSION                :: 1
AMD_PIPELINE_COMPILER_CONTROL_EXTENSION_NAME              :: "VK_AMD_pipeline_compiler_control"
EXT_calibrated_timestamps                                 :: 1
EXT_CALIBRATED_TIMESTAMPS_SPEC_VERSION                    :: 2
EXT_CALIBRATED_TIMESTAMPS_EXTENSION_NAME                  :: "VK_EXT_calibrated_timestamps"
AMD_shader_core_properties                                :: 1
AMD_SHADER_CORE_PROPERTIES_SPEC_VERSION                   :: 2
AMD_SHADER_CORE_PROPERTIES_EXTENSION_NAME                 :: "VK_AMD_shader_core_properties"
AMD_memory_overallocation_behavior                        :: 1
AMD_MEMORY_OVERALLOCATION_BEHAVIOR_SPEC_VERSION           :: 1
AMD_MEMORY_OVERALLOCATION_BEHAVIOR_EXTENSION_NAME         :: "VK_AMD_memory_overallocation_behavior"
EXT_vertex_attribute_divisor                              :: 1
EXT_VERTEX_ATTRIBUTE_DIVISOR_SPEC_VERSION                 :: 3
EXT_VERTEX_ATTRIBUTE_DIVISOR_EXTENSION_NAME               :: "VK_EXT_vertex_attribute_divisor"
EXT_pipeline_creation_feedback                            :: 1
EXT_PIPELINE_CREATION_FEEDBACK_SPEC_VERSION               :: 1
EXT_PIPELINE_CREATION_FEEDBACK_EXTENSION_NAME             :: "VK_EXT_pipeline_creation_feedback"
NV_shader_subgroup_partitioned                            :: 1
NV_SHADER_SUBGROUP_PARTITIONED_SPEC_VERSION               :: 1
NV_SHADER_SUBGROUP_PARTITIONED_EXTENSION_NAME             :: "VK_NV_shader_subgroup_partitioned"
NV_compute_shader_derivatives                             :: 1
NV_COMPUTE_SHADER_DERIVATIVES_SPEC_VERSION                :: 1
NV_COMPUTE_SHADER_DERIVATIVES_EXTENSION_NAME              :: "VK_NV_compute_shader_derivatives"
NV_mesh_shader                                            :: 1
NV_MESH_SHADER_SPEC_VERSION                               :: 1
NV_MESH_SHADER_EXTENSION_NAME                             :: "VK_NV_mesh_shader"
NV_fragment_shader_barycentric                            :: 1
NV_FRAGMENT_SHADER_BARYCENTRIC_SPEC_VERSION               :: 1
NV_FRAGMENT_SHADER_BARYCENTRIC_EXTENSION_NAME             :: "VK_NV_fragment_shader_barycentric"
NV_shader_image_footprint                                 :: 1
NV_SHADER_IMAGE_FOOTPRINT_SPEC_VERSION                    :: 2
NV_SHADER_IMAGE_FOOTPRINT_EXTENSION_NAME                  :: "VK_NV_shader_image_footprint"
NV_scissor_exclusive                                      :: 1
NV_SCISSOR_EXCLUSIVE_SPEC_VERSION                         :: 2
NV_SCISSOR_EXCLUSIVE_EXTENSION_NAME                       :: "VK_NV_scissor_exclusive"
NV_device_diagnostic_checkpoints                          :: 1
NV_DEVICE_DIAGNOSTIC_CHECKPOINTS_SPEC_VERSION             :: 2
NV_DEVICE_DIAGNOSTIC_CHECKPOINTS_EXTENSION_NAME           :: "VK_NV_device_diagnostic_checkpoints"
EXT_pci_bus_info                                          :: 1
EXT_PCI_BUS_INFO_SPEC_VERSION                             :: 2
EXT_PCI_BUS_INFO_EXTENSION_NAME                           :: "VK_EXT_pci_bus_info"
AMD_display_native_hdr                                    :: 1
AMD_DISPLAY_NATIVE_HDR_SPEC_VERSION                       :: 1
AMD_DISPLAY_NATIVE_HDR_EXTENSION_NAME                     :: "VK_AMD_display_native_hdr"
EXT_fragment_density_map                                  :: 1
EXT_FRAGMENT_DENSITY_MAP_SPEC_VERSION                     :: 2
EXT_FRAGMENT_DENSITY_MAP_EXTENSION_NAME                   :: "VK_EXT_fragment_density_map"
EXT_scalar_block_layout                                   :: 1
EXT_SCALAR_BLOCK_LAYOUT_SPEC_VERSION                      :: 1
EXT_SCALAR_BLOCK_LAYOUT_EXTENSION_NAME                    :: "VK_EXT_scalar_block_layout"
GOOGLE_hlsl_functionality1                                :: 1
GOOGLE_HLSL_FUNCTIONALITY_1_SPEC_VERSION                  :: 1
GOOGLE_HLSL_FUNCTIONALITY_1_EXTENSION_NAME                :: "VK_GOOGLE_hlsl_functionality1"
GOOGLE_HLSL_FUNCTIONALITY1_SPEC_VERSION                   :: GOOGLE_HLSL_FUNCTIONALITY_1_SPEC_VERSION
GOOGLE_HLSL_FUNCTIONALITY1_EXTENSION_NAME                 :: GOOGLE_HLSL_FUNCTIONALITY_1_EXTENSION_NAME
GOOGLE_decorate_string                                    :: 1
GOOGLE_DECORATE_STRING_SPEC_VERSION                       :: 1
GOOGLE_DECORATE_STRING_EXTENSION_NAME                     :: "VK_GOOGLE_decorate_string"
EXT_subgroup_size_control                                 :: 1
EXT_SUBGROUP_SIZE_CONTROL_SPEC_VERSION                    :: 2
EXT_SUBGROUP_SIZE_CONTROL_EXTENSION_NAME                  :: "VK_EXT_subgroup_size_control"
AMD_shader_core_properties2                               :: 1
AMD_SHADER_CORE_PROPERTIES_2_SPEC_VERSION                 :: 1
AMD_SHADER_CORE_PROPERTIES_2_EXTENSION_NAME               :: "VK_AMD_shader_core_properties2"
AMD_device_coherent_memory                                :: 1
AMD_DEVICE_COHERENT_MEMORY_SPEC_VERSION                   :: 1
AMD_DEVICE_COHERENT_MEMORY_EXTENSION_NAME                 :: "VK_AMD_device_coherent_memory"
EXT_shader_image_atomic_int64                             :: 1
EXT_SHADER_IMAGE_ATOMIC_INT64_SPEC_VERSION                :: 1
EXT_SHADER_IMAGE_ATOMIC_INT64_EXTENSION_NAME              :: "VK_EXT_shader_image_atomic_int64"
EXT_memory_budget                                         :: 1
EXT_MEMORY_BUDGET_SPEC_VERSION                            :: 1
EXT_MEMORY_BUDGET_EXTENSION_NAME                          :: "VK_EXT_memory_budget"
EXT_memory_priority                                       :: 1
EXT_MEMORY_PRIORITY_SPEC_VERSION                          :: 1
EXT_MEMORY_PRIORITY_EXTENSION_NAME                        :: "VK_EXT_memory_priority"
NV_dedicated_allocation_image_aliasing                    :: 1
NV_DEDICATED_ALLOCATION_IMAGE_ALIASING_SPEC_VERSION       :: 1
NV_DEDICATED_ALLOCATION_IMAGE_ALIASING_EXTENSION_NAME     :: "VK_NV_dedicated_allocation_image_aliasing"
EXT_buffer_device_address                                 :: 1
EXT_BUFFER_DEVICE_ADDRESS_SPEC_VERSION                    :: 2
EXT_BUFFER_DEVICE_ADDRESS_EXTENSION_NAME                  :: "VK_EXT_buffer_device_address"
EXT_tooling_info                                          :: 1
EXT_TOOLING_INFO_SPEC_VERSION                             :: 1
EXT_TOOLING_INFO_EXTENSION_NAME                           :: "VK_EXT_tooling_info"
EXT_separate_stencil_usage                                :: 1
EXT_SEPARATE_STENCIL_USAGE_SPEC_VERSION                   :: 1
EXT_SEPARATE_STENCIL_USAGE_EXTENSION_NAME                 :: "VK_EXT_separate_stencil_usage"
EXT_validation_features                                   :: 1
EXT_VALIDATION_FEATURES_SPEC_VERSION                      :: 6
EXT_VALIDATION_FEATURES_EXTENSION_NAME                    :: "VK_EXT_validation_features"
NV_cooperative_matrix                                     :: 1
NV_COOPERATIVE_MATRIX_SPEC_VERSION                        :: 1
NV_COOPERATIVE_MATRIX_EXTENSION_NAME                      :: "VK_NV_cooperative_matrix"
NV_coverage_reduction_mode                                :: 1
NV_COVERAGE_REDUCTION_MODE_SPEC_VERSION                   :: 1
NV_COVERAGE_REDUCTION_MODE_EXTENSION_NAME                 :: "VK_NV_coverage_reduction_mode"
EXT_fragment_shader_interlock                             :: 1
EXT_FRAGMENT_SHADER_INTERLOCK_SPEC_VERSION                :: 1
EXT_FRAGMENT_SHADER_INTERLOCK_EXTENSION_NAME              :: "VK_EXT_fragment_shader_interlock"
EXT_ycbcr_image_arrays                                    :: 1
EXT_YCBCR_IMAGE_ARRAYS_SPEC_VERSION                       :: 1
EXT_YCBCR_IMAGE_ARRAYS_EXTENSION_NAME                     :: "VK_EXT_ycbcr_image_arrays"
EXT_provoking_vertex                                      :: 1
EXT_PROVOKING_VERTEX_SPEC_VERSION                         :: 1
EXT_PROVOKING_VERTEX_EXTENSION_NAME                       :: "VK_EXT_provoking_vertex"
EXT_headless_surface                                      :: 1
EXT_HEADLESS_SURFACE_SPEC_VERSION                         :: 1
EXT_HEADLESS_SURFACE_EXTENSION_NAME                       :: "VK_EXT_headless_surface"
EXT_line_rasterization                                    :: 1
EXT_LINE_RASTERIZATION_SPEC_VERSION                       :: 1
EXT_LINE_RASTERIZATION_EXTENSION_NAME                     :: "VK_EXT_line_rasterization"
EXT_shader_atomic_float                                   :: 1
EXT_SHADER_ATOMIC_FLOAT_SPEC_VERSION                      :: 1
EXT_SHADER_ATOMIC_FLOAT_EXTENSION_NAME                    :: "VK_EXT_shader_atomic_float"
EXT_host_query_reset                                      :: 1
EXT_HOST_QUERY_RESET_SPEC_VERSION                         :: 1
EXT_HOST_QUERY_RESET_EXTENSION_NAME                       :: "VK_EXT_host_query_reset"
EXT_index_type_uint8                                      :: 1
EXT_INDEX_TYPE_UINT8_SPEC_VERSION                         :: 1
EXT_INDEX_TYPE_UINT8_EXTENSION_NAME                       :: "VK_EXT_index_type_uint8"
EXT_extended_dynamic_state                                :: 1
EXT_EXTENDED_DYNAMIC_STATE_SPEC_VERSION                   :: 1
EXT_EXTENDED_DYNAMIC_STATE_EXTENSION_NAME                 :: "VK_EXT_extended_dynamic_state"
EXT_host_image_copy                                       :: 1
EXT_HOST_IMAGE_COPY_SPEC_VERSION                          :: 1
EXT_HOST_IMAGE_COPY_EXTENSION_NAME                        :: "VK_EXT_host_image_copy"
EXT_map_memory_placed                                     :: 1
EXT_MAP_MEMORY_PLACED_SPEC_VERSION                        :: 1
EXT_MAP_MEMORY_PLACED_EXTENSION_NAME                      :: "VK_EXT_map_memory_placed"
EXT_shader_atomic_float2                                  :: 1
EXT_SHADER_ATOMIC_FLOAT_2_SPEC_VERSION                    :: 1
EXT_SHADER_ATOMIC_FLOAT_2_EXTENSION_NAME                  :: "VK_EXT_shader_atomic_float2"
EXT_surface_maintenance1                                  :: 1
EXT_SURFACE_MAINTENANCE_1_SPEC_VERSION                    :: 1
EXT_SURFACE_MAINTENANCE_1_EXTENSION_NAME                  :: "VK_EXT_surface_maintenance1"
EXT_swapchain_maintenance1                                :: 1
EXT_SWAPCHAIN_MAINTENANCE_1_SPEC_VERSION                  :: 1
EXT_SWAPCHAIN_MAINTENANCE_1_EXTENSION_NAME                :: "VK_EXT_swapchain_maintenance1"
EXT_shader_demote_to_helper_invocation                    :: 1
EXT_SHADER_DEMOTE_TO_HELPER_INVOCATION_SPEC_VERSION       :: 1
EXT_SHADER_DEMOTE_TO_HELPER_INVOCATION_EXTENSION_NAME     :: "VK_EXT_shader_demote_to_helper_invocation"
NV_device_generated_commands                              :: 1
NV_DEVICE_GENERATED_COMMANDS_SPEC_VERSION                 :: 3
NV_DEVICE_GENERATED_COMMANDS_EXTENSION_NAME               :: "VK_NV_device_generated_commands"
NV_inherited_viewport_scissor                             :: 1
NV_INHERITED_VIEWPORT_SCISSOR_SPEC_VERSION                :: 1
NV_INHERITED_VIEWPORT_SCISSOR_EXTENSION_NAME              :: "VK_NV_inherited_viewport_scissor"
EXT_texel_buffer_alignment                                :: 1
EXT_TEXEL_BUFFER_ALIGNMENT_SPEC_VERSION                   :: 1
EXT_TEXEL_BUFFER_ALIGNMENT_EXTENSION_NAME                 :: "VK_EXT_texel_buffer_alignment"
EXT_depth_bias_control                                    :: 1
EXT_DEPTH_BIAS_CONTROL_SPEC_VERSION                       :: 1
EXT_DEPTH_BIAS_CONTROL_EXTENSION_NAME                     :: "VK_EXT_depth_bias_control"
EXT_device_memory_report                                  :: 1
EXT_DEVICE_MEMORY_REPORT_SPEC_VERSION                     :: 2
EXT_DEVICE_MEMORY_REPORT_EXTENSION_NAME                   :: "VK_EXT_device_memory_report"
EXT_acquire_drm_display                                   :: 1
EXT_ACQUIRE_DRM_DISPLAY_SPEC_VERSION                      :: 1
EXT_ACQUIRE_DRM_DISPLAY_EXTENSION_NAME                    :: "VK_EXT_acquire_drm_display"
EXT_robustness2                                           :: 1
EXT_ROBUSTNESS_2_SPEC_VERSION                             :: 1
EXT_ROBUSTNESS_2_EXTENSION_NAME                           :: "VK_EXT_robustness2"
EXT_custom_border_color                                   :: 1
EXT_CUSTOM_BORDER_COLOR_SPEC_VERSION                      :: 12
EXT_CUSTOM_BORDER_COLOR_EXTENSION_NAME                    :: "VK_EXT_custom_border_color"
GOOGLE_user_type                                          :: 1
GOOGLE_USER_TYPE_SPEC_VERSION                             :: 1
GOOGLE_USER_TYPE_EXTENSION_NAME                           :: "VK_GOOGLE_user_type"
NV_present_barrier                                        :: 1
NV_PRESENT_BARRIER_SPEC_VERSION                           :: 1
NV_PRESENT_BARRIER_EXTENSION_NAME                         :: "VK_NV_present_barrier"
EXT_private_data                                          :: 1
EXT_PRIVATE_DATA_SPEC_VERSION                             :: 1
EXT_PRIVATE_DATA_EXTENSION_NAME                           :: "VK_EXT_private_data"
EXT_pipeline_creation_cache_control                       :: 1
EXT_PIPELINE_CREATION_CACHE_CONTROL_SPEC_VERSION          :: 3
EXT_PIPELINE_CREATION_CACHE_CONTROL_EXTENSION_NAME        :: "VK_EXT_pipeline_creation_cache_control"
NV_device_diagnostics_config                              :: 1
NV_DEVICE_DIAGNOSTICS_CONFIG_SPEC_VERSION                 :: 2
NV_DEVICE_DIAGNOSTICS_CONFIG_EXTENSION_NAME               :: "VK_NV_device_diagnostics_config"
NV_cuda_kernel_launch                                     :: 1
NV_CUDA_KERNEL_LAUNCH_SPEC_VERSION                        :: 2
NV_CUDA_KERNEL_LAUNCH_EXTENSION_NAME                      :: "VK_NV_cuda_kernel_launch"
NV_low_latency                                            :: 1
NV_LOW_LATENCY_SPEC_VERSION                               :: 1
NV_LOW_LATENCY_EXTENSION_NAME                             :: "VK_NV_low_latency"
EXT_descriptor_buffer                                     :: 1
EXT_DESCRIPTOR_BUFFER_SPEC_VERSION                        :: 1
EXT_DESCRIPTOR_BUFFER_EXTENSION_NAME                      :: "VK_EXT_descriptor_buffer"
EXT_graphics_pipeline_library                             :: 1
EXT_GRAPHICS_PIPELINE_LIBRARY_SPEC_VERSION                :: 1
EXT_GRAPHICS_PIPELINE_LIBRARY_EXTENSION_NAME              :: "VK_EXT_graphics_pipeline_library"
AMD_shader_early_and_late_fragment_tests                  :: 1
AMD_SHADER_EARLY_AND_LATE_FRAGMENT_TESTS_SPEC_VERSION     :: 1
AMD_SHADER_EARLY_AND_LATE_FRAGMENT_TESTS_EXTENSION_NAME   :: "VK_AMD_shader_early_and_late_fragment_tests"
NV_fragment_shading_rate_enums                            :: 1
NV_FRAGMENT_SHADING_RATE_ENUMS_SPEC_VERSION               :: 1
NV_FRAGMENT_SHADING_RATE_ENUMS_EXTENSION_NAME             :: "VK_NV_fragment_shading_rate_enums"
NV_ray_tracing_motion_blur                                :: 1
NV_RAY_TRACING_MOTION_BLUR_SPEC_VERSION                   :: 1
NV_RAY_TRACING_MOTION_BLUR_EXTENSION_NAME                 :: "VK_NV_ray_tracing_motion_blur"
EXT_ycbcr_2plane_444_formats                              :: 1
EXT_YCBCR_2PLANE_444_FORMATS_SPEC_VERSION                 :: 1
EXT_YCBCR_2PLANE_444_FORMATS_EXTENSION_NAME               :: "VK_EXT_ycbcr_2plane_444_formats"
EXT_fragment_density_map2                                 :: 1
EXT_FRAGMENT_DENSITY_MAP_2_SPEC_VERSION                   :: 1
EXT_FRAGMENT_DENSITY_MAP_2_EXTENSION_NAME                 :: "VK_EXT_fragment_density_map2"
EXT_image_robustness                                      :: 1
EXT_IMAGE_ROBUSTNESS_SPEC_VERSION                         :: 1
EXT_IMAGE_ROBUSTNESS_EXTENSION_NAME                       :: "VK_EXT_image_robustness"
EXT_image_compression_control                             :: 1
EXT_IMAGE_COMPRESSION_CONTROL_SPEC_VERSION                :: 1
EXT_IMAGE_COMPRESSION_CONTROL_EXTENSION_NAME              :: "VK_EXT_image_compression_control"
EXT_attachment_feedback_loop_layout                       :: 1
EXT_ATTACHMENT_FEEDBACK_LOOP_LAYOUT_SPEC_VERSION          :: 2
EXT_ATTACHMENT_FEEDBACK_LOOP_LAYOUT_EXTENSION_NAME        :: "VK_EXT_attachment_feedback_loop_layout"
EXT_4444_formats                                          :: 1
EXT_4444_FORMATS_SPEC_VERSION                             :: 1
EXT_4444_FORMATS_EXTENSION_NAME                           :: "VK_EXT_4444_formats"
EXT_device_fault                                          :: 1
EXT_DEVICE_FAULT_SPEC_VERSION                             :: 2
EXT_DEVICE_FAULT_EXTENSION_NAME                           :: "VK_EXT_device_fault"
EXT_rgba10x6_formats                                      :: 1
EXT_RGBA10X6_FORMATS_SPEC_VERSION                         :: 1
EXT_RGBA10X6_FORMATS_EXTENSION_NAME                       :: "VK_EXT_rgba10x6_formats"
EXT_vertex_input_dynamic_state                            :: 1
EXT_VERTEX_INPUT_DYNAMIC_STATE_SPEC_VERSION               :: 2
EXT_VERTEX_INPUT_DYNAMIC_STATE_EXTENSION_NAME             :: "VK_EXT_vertex_input_dynamic_state"
EXT_physical_device_drm                                   :: 1
EXT_PHYSICAL_DEVICE_DRM_SPEC_VERSION                      :: 1
EXT_PHYSICAL_DEVICE_DRM_EXTENSION_NAME                    :: "VK_EXT_physical_device_drm"
EXT_device_address_binding_report                         :: 1
EXT_DEVICE_ADDRESS_BINDING_REPORT_SPEC_VERSION            :: 1
EXT_DEVICE_ADDRESS_BINDING_REPORT_EXTENSION_NAME          :: "VK_EXT_device_address_binding_report"
EXT_depth_clip_control                                    :: 1
EXT_DEPTH_CLIP_CONTROL_SPEC_VERSION                       :: 1
EXT_DEPTH_CLIP_CONTROL_EXTENSION_NAME                     :: "VK_EXT_depth_clip_control"
EXT_primitive_topology_list_restart                       :: 1
EXT_PRIMITIVE_TOPOLOGY_LIST_RESTART_SPEC_VERSION          :: 1
EXT_PRIMITIVE_TOPOLOGY_LIST_RESTART_EXTENSION_NAME        :: "VK_EXT_primitive_topology_list_restart"
NV_external_memory_rdma                                   :: 1
NV_EXTERNAL_MEMORY_RDMA_SPEC_VERSION                      :: 1
NV_EXTERNAL_MEMORY_RDMA_EXTENSION_NAME                    :: "VK_NV_external_memory_rdma"
EXT_pipeline_properties                                   :: 1
EXT_PIPELINE_PROPERTIES_SPEC_VERSION                      :: 1
EXT_PIPELINE_PROPERTIES_EXTENSION_NAME                    :: "VK_EXT_pipeline_properties"
EXT_frame_boundary                                        :: 1
EXT_FRAME_BOUNDARY_SPEC_VERSION                           :: 1
EXT_FRAME_BOUNDARY_EXTENSION_NAME                         :: "VK_EXT_frame_boundary"
EXT_multisampled_render_to_single_sampled                 :: 1
EXT_MULTISAMPLED_RENDER_TO_SINGLE_SAMPLED_SPEC_VERSION    :: 1
EXT_MULTISAMPLED_RENDER_TO_SINGLE_SAMPLED_EXTENSION_NAME  :: "VK_EXT_multisampled_render_to_single_sampled"
EXT_extended_dynamic_state2                               :: 1
EXT_EXTENDED_DYNAMIC_STATE_2_SPEC_VERSION                 :: 1
EXT_EXTENDED_DYNAMIC_STATE_2_EXTENSION_NAME               :: "VK_EXT_extended_dynamic_state2"
EXT_color_write_enable                                    :: 1
EXT_COLOR_WRITE_ENABLE_SPEC_VERSION                       :: 1
EXT_COLOR_WRITE_ENABLE_EXTENSION_NAME                     :: "VK_EXT_color_write_enable"
EXT_primitives_generated_query                            :: 1
EXT_PRIMITIVES_GENERATED_QUERY_SPEC_VERSION               :: 1
EXT_PRIMITIVES_GENERATED_QUERY_EXTENSION_NAME             :: "VK_EXT_primitives_generated_query"
EXT_global_priority_query                                 :: 1
EXT_GLOBAL_PRIORITY_QUERY_SPEC_VERSION                    :: 1
EXT_GLOBAL_PRIORITY_QUERY_EXTENSION_NAME                  :: "VK_EXT_global_priority_query"
EXT_image_view_min_lod                                    :: 1
EXT_IMAGE_VIEW_MIN_LOD_SPEC_VERSION                       :: 1
EXT_IMAGE_VIEW_MIN_LOD_EXTENSION_NAME                     :: "VK_EXT_image_view_min_lod"
EXT_multi_draw                                            :: 1
EXT_MULTI_DRAW_SPEC_VERSION                               :: 1
EXT_MULTI_DRAW_EXTENSION_NAME                             :: "VK_EXT_multi_draw"
EXT_image_2d_view_of_3d                                   :: 1
EXT_IMAGE_2D_VIEW_OF_3D_SPEC_VERSION                      :: 1
EXT_IMAGE_2D_VIEW_OF_3D_EXTENSION_NAME                    :: "VK_EXT_image_2d_view_of_3d"
EXT_shader_tile_image                                     :: 1
EXT_SHADER_TILE_IMAGE_SPEC_VERSION                        :: 1
EXT_SHADER_TILE_IMAGE_EXTENSION_NAME                      :: "VK_EXT_shader_tile_image"
EXT_opacity_micromap                                      :: 1
EXT_OPACITY_MICROMAP_SPEC_VERSION                         :: 2
EXT_OPACITY_MICROMAP_EXTENSION_NAME                       :: "VK_EXT_opacity_micromap"
EXT_load_store_op_none                                    :: 1
EXT_LOAD_STORE_OP_NONE_SPEC_VERSION                       :: 1
EXT_LOAD_STORE_OP_NONE_EXTENSION_NAME                     :: "VK_EXT_load_store_op_none"
EXT_border_color_swizzle                                  :: 1
EXT_BORDER_COLOR_SWIZZLE_SPEC_VERSION                     :: 1
EXT_BORDER_COLOR_SWIZZLE_EXTENSION_NAME                   :: "VK_EXT_border_color_swizzle"
EXT_pageable_device_local_memory                          :: 1
EXT_PAGEABLE_DEVICE_LOCAL_MEMORY_SPEC_VERSION             :: 1
EXT_PAGEABLE_DEVICE_LOCAL_MEMORY_EXTENSION_NAME           :: "VK_EXT_pageable_device_local_memory"
EXT_image_sliced_view_of_3d                               :: 1
EXT_IMAGE_SLICED_VIEW_OF_3D_SPEC_VERSION                  :: 1
EXT_IMAGE_SLICED_VIEW_OF_3D_EXTENSION_NAME                :: "VK_EXT_image_sliced_view_of_3d"
EXT_depth_clamp_zero_one                                  :: 1
EXT_DEPTH_CLAMP_ZERO_ONE_SPEC_VERSION                     :: 1
EXT_DEPTH_CLAMP_ZERO_ONE_EXTENSION_NAME                   :: "VK_EXT_depth_clamp_zero_one"
EXT_non_seamless_cube_map                                 :: 1
EXT_NON_SEAMLESS_CUBE_MAP_SPEC_VERSION                    :: 1
EXT_NON_SEAMLESS_CUBE_MAP_EXTENSION_NAME                  :: "VK_EXT_non_seamless_cube_map"
NV_copy_memory_indirect                                   :: 1
NV_COPY_MEMORY_INDIRECT_SPEC_VERSION                      :: 1
NV_COPY_MEMORY_INDIRECT_EXTENSION_NAME                    :: "VK_NV_copy_memory_indirect"
NV_memory_decompression                                   :: 1
NV_MEMORY_DECOMPRESSION_SPEC_VERSION                      :: 1
NV_MEMORY_DECOMPRESSION_EXTENSION_NAME                    :: "VK_NV_memory_decompression"
NV_device_generated_commands_compute                      :: 1
NV_DEVICE_GENERATED_COMMANDS_COMPUTE_SPEC_VERSION         :: 2
NV_DEVICE_GENERATED_COMMANDS_COMPUTE_EXTENSION_NAME       :: "VK_NV_device_generated_commands_compute"
NV_linear_color_attachment                                :: 1
NV_LINEAR_COLOR_ATTACHMENT_SPEC_VERSION                   :: 1
NV_LINEAR_COLOR_ATTACHMENT_EXTENSION_NAME                 :: "VK_NV_linear_color_attachment"
GOOGLE_surfaceless_query                                  :: 1
GOOGLE_SURFACELESS_QUERY_SPEC_VERSION                     :: 2
GOOGLE_SURFACELESS_QUERY_EXTENSION_NAME                   :: "VK_GOOGLE_surfaceless_query"
EXT_image_compression_control_swapchain                   :: 1
EXT_IMAGE_COMPRESSION_CONTROL_SWAPCHAIN_SPEC_VERSION      :: 1
EXT_IMAGE_COMPRESSION_CONTROL_SWAPCHAIN_EXTENSION_NAME    :: "VK_EXT_image_compression_control_swapchain"
EXT_nested_command_buffer                                 :: 1
EXT_NESTED_COMMAND_BUFFER_SPEC_VERSION                    :: 1
EXT_NESTED_COMMAND_BUFFER_EXTENSION_NAME                  :: "VK_EXT_nested_command_buffer"
EXT_external_memory_acquire_unmodified                    :: 1
EXT_EXTERNAL_MEMORY_ACQUIRE_UNMODIFIED_SPEC_VERSION       :: 1
EXT_EXTERNAL_MEMORY_ACQUIRE_UNMODIFIED_EXTENSION_NAME     :: "VK_EXT_external_memory_acquire_unmodified"
EXT_extended_dynamic_state3                               :: 1
EXT_EXTENDED_DYNAMIC_STATE_3_SPEC_VERSION                 :: 2
EXT_EXTENDED_DYNAMIC_STATE_3_EXTENSION_NAME               :: "VK_EXT_extended_dynamic_state3"
EXT_subpass_merge_feedback                                :: 1
EXT_SUBPASS_MERGE_FEEDBACK_SPEC_VERSION                   :: 2
EXT_SUBPASS_MERGE_FEEDBACK_EXTENSION_NAME                 :: "VK_EXT_subpass_merge_feedback"
EXT_shader_module_identifier                              :: 1
EXT_SHADER_MODULE_IDENTIFIER_SPEC_VERSION                 :: 1
EXT_SHADER_MODULE_IDENTIFIER_EXTENSION_NAME               :: "VK_EXT_shader_module_identifier"
EXT_rasterization_order_attachment_access                 :: 1
EXT_RASTERIZATION_ORDER_ATTACHMENT_ACCESS_SPEC_VERSION    :: 1
EXT_RASTERIZATION_ORDER_ATTACHMENT_ACCESS_EXTENSION_NAME  :: "VK_EXT_rasterization_order_attachment_access"
NV_optical_flow                                           :: 1
NV_OPTICAL_FLOW_SPEC_VERSION                              :: 1
NV_OPTICAL_FLOW_EXTENSION_NAME                            :: "VK_NV_optical_flow"
EXT_legacy_dithering                                      :: 1
EXT_LEGACY_DITHERING_SPEC_VERSION                         :: 2
EXT_LEGACY_DITHERING_EXTENSION_NAME                       :: "VK_EXT_legacy_dithering"
EXT_pipeline_protected_access                             :: 1
EXT_PIPELINE_PROTECTED_ACCESS_SPEC_VERSION                :: 1
EXT_PIPELINE_PROTECTED_ACCESS_EXTENSION_NAME              :: "VK_EXT_pipeline_protected_access"
AMD_anti_lag                                              :: 1
AMD_ANTI_LAG_SPEC_VERSION                                 :: 1
AMD_ANTI_LAG_EXTENSION_NAME                               :: "VK_AMD_anti_lag"
EXT_shader_object                                         :: 1
EXT_SHADER_OBJECT_SPEC_VERSION                            :: 1
EXT_SHADER_OBJECT_EXTENSION_NAME                          :: "VK_EXT_shader_object"
NV_ray_tracing_invocation_reorder                         :: 1
NV_RAY_TRACING_INVOCATION_REORDER_SPEC_VERSION            :: 1
NV_RAY_TRACING_INVOCATION_REORDER_EXTENSION_NAME          :: "VK_NV_ray_tracing_invocation_reorder"
NV_extended_sparse_address_space                          :: 1
NV_EXTENDED_SPARSE_ADDRESS_SPACE_SPEC_VERSION             :: 1
NV_EXTENDED_SPARSE_ADDRESS_SPACE_EXTENSION_NAME           :: "VK_NV_extended_sparse_address_space"
EXT_mutable_descriptor_type                               :: 1
EXT_MUTABLE_DESCRIPTOR_TYPE_SPEC_VERSION                  :: 1
EXT_MUTABLE_DESCRIPTOR_TYPE_EXTENSION_NAME                :: "VK_EXT_mutable_descriptor_type"
EXT_legacy_vertex_attributes                              :: 1
EXT_LEGACY_VERTEX_ATTRIBUTES_SPEC_VERSION                 :: 1
EXT_LEGACY_VERTEX_ATTRIBUTES_EXTENSION_NAME               :: "VK_EXT_legacy_vertex_attributes"
EXT_layer_settings                                        :: 1
EXT_LAYER_SETTINGS_SPEC_VERSION                           :: 2
EXT_LAYER_SETTINGS_EXTENSION_NAME                         :: "VK_EXT_layer_settings"
EXT_pipeline_library_group_handles                        :: 1
EXT_PIPELINE_LIBRARY_GROUP_HANDLES_SPEC_VERSION           :: 1
EXT_PIPELINE_LIBRARY_GROUP_HANDLES_EXTENSION_NAME         :: "VK_EXT_pipeline_library_group_handles"
EXT_dynamic_rendering_unused_attachments                  :: 1
EXT_DYNAMIC_RENDERING_UNUSED_ATTACHMENTS_SPEC_VERSION     :: 1
EXT_DYNAMIC_RENDERING_UNUSED_ATTACHMENTS_EXTENSION_NAME   :: "VK_EXT_dynamic_rendering_unused_attachments"
NV_low_latency2                                           :: 1
NV_LOW_LATENCY_2_SPEC_VERSION                             :: 2
NV_LOW_LATENCY_2_EXTENSION_NAME                           :: "VK_NV_low_latency2"
NV_per_stage_descriptor_set                               :: 1
NV_PER_STAGE_DESCRIPTOR_SET_SPEC_VERSION                  :: 1
NV_PER_STAGE_DESCRIPTOR_SET_EXTENSION_NAME                :: "VK_NV_per_stage_descriptor_set"
EXT_attachment_feedback_loop_dynamic_state                :: 1
EXT_ATTACHMENT_FEEDBACK_LOOP_DYNAMIC_STATE_SPEC_VERSION   :: 1
EXT_ATTACHMENT_FEEDBACK_LOOP_DYNAMIC_STATE_EXTENSION_NAME :: "VK_EXT_attachment_feedback_loop_dynamic_state"
NV_descriptor_pool_overallocation                         :: 1
NV_DESCRIPTOR_POOL_OVERALLOCATION_SPEC_VERSION            :: 1
NV_DESCRIPTOR_POOL_OVERALLOCATION_EXTENSION_NAME          :: "VK_NV_descriptor_pool_overallocation"
NV_raw_access_chains                                      :: 1
NV_RAW_ACCESS_CHAINS_SPEC_VERSION                         :: 1
NV_RAW_ACCESS_CHAINS_EXTENSION_NAME                       :: "VK_NV_raw_access_chains"
NV_command_buffer_inheritance                             :: 1
NV_COMMAND_BUFFER_INHERITANCE_SPEC_VERSION                :: 1
NV_COMMAND_BUFFER_INHERITANCE_EXTENSION_NAME              :: "VK_NV_command_buffer_inheritance"
NV_shader_atomic_float16_vector                           :: 1
NV_SHADER_ATOMIC_FLOAT16_VECTOR_SPEC_VERSION              :: 1
NV_SHADER_ATOMIC_FLOAT16_VECTOR_EXTENSION_NAME            :: "VK_NV_shader_atomic_float16_vector"
EXT_shader_replicated_composites                          :: 1
EXT_SHADER_REPLICATED_COMPOSITES_SPEC_VERSION             :: 1
EXT_SHADER_REPLICATED_COMPOSITES_EXTENSION_NAME           :: "VK_EXT_shader_replicated_composites"
NV_ray_tracing_validation                                 :: 1
NV_RAY_TRACING_VALIDATION_SPEC_VERSION                    :: 1
NV_RAY_TRACING_VALIDATION_EXTENSION_NAME                  :: "VK_NV_ray_tracing_validation"
EXT_device_generated_commands                             :: 1
EXT_DEVICE_GENERATED_COMMANDS_SPEC_VERSION                :: 1
EXT_DEVICE_GENERATED_COMMANDS_EXTENSION_NAME              :: "VK_EXT_device_generated_commands"
EXT_depth_clamp_control                                   :: 1
EXT_DEPTH_CLAMP_CONTROL_SPEC_VERSION                      :: 1
EXT_DEPTH_CLAMP_CONTROL_EXTENSION_NAME                    :: "VK_EXT_depth_clamp_control"
KHR_acceleration_structure                                :: 1
KHR_ACCELERATION_STRUCTURE_SPEC_VERSION                   :: 13
KHR_ACCELERATION_STRUCTURE_EXTENSION_NAME                 :: "VK_KHR_acceleration_structure"
KHR_ray_tracing_pipeline                                  :: 1
KHR_RAY_TRACING_PIPELINE_SPEC_VERSION                     :: 1
KHR_RAY_TRACING_PIPELINE_EXTENSION_NAME                   :: "VK_KHR_ray_tracing_pipeline"
KHR_ray_query                                             :: 1
KHR_RAY_QUERY_SPEC_VERSION                                :: 1
KHR_RAY_QUERY_EXTENSION_NAME                              :: "VK_KHR_ray_query"
EXT_mesh_shader                                           :: 1
EXT_MESH_SHADER_SPEC_VERSION                              :: 1
EXT_MESH_SHADER_EXTENSION_NAME                            :: "VK_EXT_mesh_shader"
KHR_win32_surface                                         :: 1
KHR_WIN32_SURFACE_SPEC_VERSION                            :: 6
KHR_WIN32_SURFACE_EXTENSION_NAME                          :: "VK_KHR_win32_surface"
KHR_external_memory_win32                                 :: 1
KHR_EXTERNAL_MEMORY_WIN32_SPEC_VERSION                    :: 1
KHR_EXTERNAL_MEMORY_WIN32_EXTENSION_NAME                  :: "VK_KHR_external_memory_win32"
KHR_win32_keyed_mutex                                     :: 1
KHR_WIN32_KEYED_MUTEX_SPEC_VERSION                        :: 1
KHR_WIN32_KEYED_MUTEX_EXTENSION_NAME                      :: "VK_KHR_win32_keyed_mutex"
KHR_external_semaphore_win32                              :: 1
KHR_EXTERNAL_SEMAPHORE_WIN32_SPEC_VERSION                 :: 1
KHR_EXTERNAL_SEMAPHORE_WIN32_EXTENSION_NAME               :: "VK_KHR_external_semaphore_win32"
KHR_external_fence_win32                                  :: 1
KHR_EXTERNAL_FENCE_WIN32_SPEC_VERSION                     :: 1
KHR_EXTERNAL_FENCE_WIN32_EXTENSION_NAME                   :: "VK_KHR_external_fence_win32"
NV_external_memory_win32                                  :: 1
NV_EXTERNAL_MEMORY_WIN32_SPEC_VERSION                     :: 1
NV_EXTERNAL_MEMORY_WIN32_EXTENSION_NAME                   :: "VK_NV_external_memory_win32"
NV_win32_keyed_mutex                                      :: 1
NV_WIN32_KEYED_MUTEX_SPEC_VERSION                         :: 2
NV_WIN32_KEYED_MUTEX_EXTENSION_NAME                       :: "VK_NV_win32_keyed_mutex"
EXT_full_screen_exclusive                                 :: 1
EXT_FULL_SCREEN_EXCLUSIVE_SPEC_VERSION                    :: 4
EXT_FULL_SCREEN_EXCLUSIVE_EXTENSION_NAME                  :: "VK_EXT_full_screen_exclusive"
NV_acquire_winrt_display                                  :: 1
NV_ACQUIRE_WINRT_DISPLAY_SPEC_VERSION                     :: 1
NV_ACQUIRE_WINRT_DISPLAY_EXTENSION_NAME                   :: "VK_NV_acquire_winrt_display"
EXT_metal_surface                                         :: 1
EXT_METAL_SURFACE_SPEC_VERSION                            :: 1
EXT_METAL_SURFACE_EXTENSION_NAME                          :: "VK_EXT_metal_surface"
EXT_metal_objects                                         :: 1
EXT_METAL_OBJECTS_SPEC_VERSION                            :: 2
EXT_METAL_OBJECTS_EXTENSION_NAME                          :: "VK_EXT_metal_objects"
KHR_wayland_surface                                       :: 1
KHR_WAYLAND_SURFACE_SPEC_VERSION                          :: 6
KHR_WAYLAND_SURFACE_EXTENSION_NAME                        :: "VK_KHR_wayland_surface"

// Handles types
Instance       :: distinct Handle
PhysicalDevice :: distinct Handle
Device         :: distinct Handle
Queue          :: distinct Handle
CommandBuffer  :: distinct Handle
Buffer                        :: distinct NonDispatchableHandle
Image                         :: distinct NonDispatchableHandle
Semaphore                     :: distinct NonDispatchableHandle
Fence                         :: distinct NonDispatchableHandle
DeviceMemory                  :: distinct NonDispatchableHandle
Event                         :: distinct NonDispatchableHandle
QueryPool                     :: distinct NonDispatchableHandle
BufferView                    :: distinct NonDispatchableHandle
ImageView                     :: distinct NonDispatchableHandle
ShaderModule                  :: distinct NonDispatchableHandle
PipelineCache                 :: distinct NonDispatchableHandle
PipelineLayout                :: distinct NonDispatchableHandle
Pipeline                      :: distinct NonDispatchableHandle
RenderPass                    :: distinct NonDispatchableHandle
DescriptorSetLayout           :: distinct NonDispatchableHandle
Sampler                       :: distinct NonDispatchableHandle
DescriptorSet                 :: distinct NonDispatchableHandle
DescriptorPool                :: distinct NonDispatchableHandle
Framebuffer                   :: distinct NonDispatchableHandle
CommandPool                   :: distinct NonDispatchableHandle
SamplerYcbcrConversion        :: distinct NonDispatchableHandle
DescriptorUpdateTemplate      :: distinct NonDispatchableHandle
PrivateDataSlot               :: distinct NonDispatchableHandle
SurfaceKHR                    :: distinct NonDispatchableHandle
SwapchainKHR                  :: distinct NonDispatchableHandle
DisplayKHR                    :: distinct NonDispatchableHandle
DisplayModeKHR                :: distinct NonDispatchableHandle
VideoSessionKHR               :: distinct NonDispatchableHandle
VideoSessionParametersKHR     :: distinct NonDispatchableHandle
DeferredOperationKHR          :: distinct NonDispatchableHandle
PipelineBinaryKHR             :: distinct NonDispatchableHandle
DebugReportCallbackEXT        :: distinct NonDispatchableHandle
CuModuleNVX                   :: distinct NonDispatchableHandle
CuFunctionNVX                 :: distinct NonDispatchableHandle
DebugUtilsMessengerEXT        :: distinct NonDispatchableHandle
ValidationCacheEXT            :: distinct NonDispatchableHandle
AccelerationStructureNV       :: distinct NonDispatchableHandle
PerformanceConfigurationINTEL :: distinct NonDispatchableHandle
IndirectCommandsLayoutNV      :: distinct NonDispatchableHandle
CudaModuleNV                  :: distinct NonDispatchableHandle
CudaFunctionNV                :: distinct NonDispatchableHandle
AccelerationStructureKHR      :: distinct NonDispatchableHandle
MicromapEXT                   :: distinct NonDispatchableHandle
OpticalFlowSessionNV          :: distinct NonDispatchableHandle
ShaderEXT                     :: distinct NonDispatchableHandle
IndirectExecutionSetEXT       :: distinct NonDispatchableHandle
IndirectCommandsLayoutEXT     :: distinct NonDispatchableHandle


