/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.annotations;

import java.util.Objects;
import org.eclipse.jetty.annotations.AnnotationIntrospector;
import org.eclipse.jetty.annotations.DeclareRolesAnnotationHandler;
import org.eclipse.jetty.annotations.MultiPartConfigAnnotationHandler;
import org.eclipse.jetty.annotations.PostConstructAnnotationHandler;
import org.eclipse.jetty.annotations.PreDestroyAnnotationHandler;
import org.eclipse.jetty.annotations.ResourceAnnotationHandler;
import org.eclipse.jetty.annotations.ResourcesAnnotationHandler;
import org.eclipse.jetty.annotations.RunAsAnnotationHandler;
import org.eclipse.jetty.annotations.ServletSecurityAnnotationHandler;
import org.eclipse.jetty.util.DecoratedObjectFactory;
import org.eclipse.jetty.util.Decorator;
import org.eclipse.jetty.webapp.WebAppContext;

public class AnnotationDecorator
implements Decorator {
    protected AnnotationIntrospector _introspector;
    protected WebAppContext _context;

    public AnnotationDecorator(WebAppContext context) {
        this._context = Objects.requireNonNull(context);
        this._introspector = new AnnotationIntrospector(this._context);
        this.registerHandlers();
    }

    private void registerHandlers() {
        this._introspector.registerHandler(new ResourceAnnotationHandler(this._context));
        this._introspector.registerHandler(new ResourcesAnnotationHandler(this._context));
        this._introspector.registerHandler(new RunAsAnnotationHandler(this._context));
        this._introspector.registerHandler(new PostConstructAnnotationHandler(this._context));
        this._introspector.registerHandler(new PreDestroyAnnotationHandler(this._context));
        this._introspector.registerHandler(new DeclareRolesAnnotationHandler(this._context));
        this._introspector.registerHandler(new MultiPartConfigAnnotationHandler(this._context));
        this._introspector.registerHandler(new ServletSecurityAnnotationHandler(this._context));
    }

    protected void introspect(Object o, Object metaInfo) {
        if (o == null) {
            return;
        }
        this._introspector.introspect(o, metaInfo);
    }

    public Object decorate(Object o) {
        this.introspect(o, DecoratedObjectFactory.getAssociatedInfo());
        return o;
    }

    @Override
    public void destroy(Object o) {
    }
}

