/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.owlapi.explanation.util;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLOntologyChangeListener;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;

public class DefinitionTracker
implements OWLOntologyChangeListener {
    private final Map<OWLEntity, AtomicInteger> referenceCounts = new HashMap<OWLEntity, AtomicInteger>();
    private final OWLOntology ontology;
    private final Set<OWLAxiom> axioms = new HashSet<OWLAxiom>();

    public DefinitionTracker(@Nonnull OWLOntology ontology) {
        this.ontology = OWLAPIPreconditions.checkNotNull(ontology, "ontology cannot be null");
        for (OWLOntology importOnt : ontology.getImportsClosure()) {
            for (OWLAxiom axiom : importOnt.getAxioms()) {
                assert (axiom != null);
                this.addAxiom(axiom);
            }
        }
        ontology.getOWLOntologyManager().addOntologyChangeListener(this);
    }

    private void addAxiom(@Nonnull OWLAxiom axiom) {
        if (this.axioms.add(axiom)) {
            for (OWLEntity entity : axiom.getSignature()) {
                this.referenceCounts.computeIfAbsent(entity, x -> new AtomicInteger(0)).incrementAndGet();
            }
        }
    }

    private void removeAxiom(@Nonnull OWLAxiom axiom) {
        if (this.axioms.remove(axiom)) {
            for (OWLEntity entity : axiom.getSignature()) {
                AtomicInteger count = this.referenceCounts.get(entity);
                if (count == null) continue;
                count.decrementAndGet();
                if (count.get() >= 1) continue;
                this.referenceCounts.remove(entity);
            }
        }
    }

    public boolean isDefined(@Nonnull OWLEntity entity) {
        return OWLAPIPreconditions.checkNotNull(entity, "entity cannot be null").isBuiltIn() || this.referenceCounts.containsKey(entity);
    }

    public boolean isDefined(@Nonnull OWLClassExpression classExpression) {
        for (OWLEntity entity : OWLAPIPreconditions.checkNotNull(classExpression, "classExpression cannot be null").getSignature()) {
            assert (entity != null);
            if (this.isDefined(entity)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void ontologiesChanged(List<? extends OWLOntologyChange> changes) {
        for (OWLOntologyChange oWLOntologyChange : changes) {
            if (!oWLOntologyChange.isAxiomChange() || !this.ontology.getImportsClosure().contains(oWLOntologyChange.getOntology())) continue;
            OWLAxiom axiom = oWLOntologyChange.getAxiom();
            assert (axiom != null);
            if (oWLOntologyChange.isAddAxiom()) {
                this.addAxiom(axiom);
                continue;
            }
            if (oWLOntologyChange.isRemoveAxiom()) {
                this.removeAxiom(axiom);
                continue;
            }
            throw new UnsupportedOperationException("Unrecognized axiom change: " + oWLOntologyChange);
        }
    }
}

