if not modules then modules = { } end modules ['font-agl'] = {
    version   = 1.001,
    comment   = "companion to font-ini.mkiv",
    author    = "Hans Hagen, PRAGMA-ADE, Hasselt NL",
    copyright = "derived from http://www.adobe.com/devnet/opentype/archives/glyphlist.txt",
    original  = "Adobe Glyph List, version 2.0, September 20, 2002",
}

-- This one is somewhat over the top and we can probably remove quite some of these. It mostly relates
-- to obsolete Type1 fonts anyway. It makes no sense to keep part of these list in char-def so we now
-- moved them here.

local next = next

local allocate      = utilities.storage.allocate
local mark          = utilities.storage.mark

fonts               = fonts or { }
local encodings     = fonts.encodings or { }
fonts.encodings     = encodings
local agl           = fonts.encodings.agl or { }
fonts.encodings.agl = agl

table.setmetatableindex(agl,nil) -- prevent recursive lookups otherwise when autoloaded

local unicodes = {
    A                                       = 0x00041,
    AE                                      = 0x000C6,
    AEacute                                 = 0x001FC,
    AEmacron                                = 0x001E2,
    Aacute                                  = 0x000C1,
    Abreve                                  = 0x00102,
    Abreveacute                             = 0x01EAE,
    Abrevecyrillic                          = 0x004D0,
    Abrevedotbelow                          = 0x01EB6,
    Abrevegrave                             = 0x01EB0,
    Abrevehookabove                         = 0x01EB2,
    Abrevetilde                             = 0x01EB4,
    Acaron                                  = 0x001CD,
    Acircle                                 = 0x024B6,
    Acircumflex                             = 0x000C2,
    Acircumflexacute                        = 0x01EA4,
    Acircumflexdotbelow                     = 0x01EAC,
    Acircumflexgrave                        = 0x01EA6,
    Acircumflexhookabove                    = 0x01EA8,
    Acircumflextilde                        = 0x01EAA,
    Acyrillic                               = 0x00410,
    Adblgrave                               = 0x00200,
    Adieresis                               = 0x000C4,
    Adieresiscyrillic                       = 0x004D2,
    Adieresismacron                         = 0x001DE,
    Adotbelow                               = 0x01EA0,
    Adotmacron                              = 0x001E0,
    Agrave                                  = 0x000C0,
    Ahookabove                              = 0x01EA2,
    Aiecyrillic                             = 0x004D4,
    Ainvertedbreve                          = 0x00202,
    Alpha                                   = 0x00391,
    Alphatonos                              = 0x00386,
    Amacron                                 = 0x00100,
    Amonospace                              = 0x0FF21,
    Aogonek                                 = 0x00104,
    Aring                                   = 0x000C5,
    Aringacute                              = 0x001FA,
    Aringbelow                              = 0x01E00,
    Atilde                                  = 0x000C3,
    Aybarmenian                             = 0x00531,
    B                                       = 0x00042,
    Bcircle                                 = 0x024B7,
    Bdotaccent                              = 0x01E02,
    Bdotbelow                               = 0x01E04,
    Becyrillic                              = 0x00411,
    Benarmenian                             = 0x00532,
    Beta                                    = 0x00392,
    Bhook                                   = 0x00181,
    Blinebelow                              = 0x01E06,
    Bmonospace                              = 0x0FF22,
    Btopbar                                 = 0x00182,
    C                                       = 0x00043,
    Caarmenian                              = 0x0053E,
    Cacute                                  = 0x00106,
    Ccaron                                  = 0x0010C,
    Ccedilla                                = 0x000C7,
    Ccedillaacute                           = 0x01E08,
    Ccircle                                 = 0x024B8,
    Ccircumflex                             = 0x00108,
    Cdot                                    = 0x0010A,
    Cdotaccent                              = 0x0010A,
    Chaarmenian                             = 0x00549,
    Cheabkhasiancyrillic                    = 0x004BC,
    Checyrillic                             = 0x00427,
    Chedescenderabkhasiancyrillic           = 0x004BE,
    Chedescendercyrillic                    = 0x004B6,
    Chedieresiscyrillic                     = 0x004F4,
    Cheharmenian                            = 0x00543,
    Chekhakassiancyrillic                   = 0x004CB,
    Cheverticalstrokecyrillic               = 0x004B8,
    Chi                                     = 0x003A7,
    Chook                                   = 0x00187,
    Cmonospace                              = 0x0FF23,
    Coarmenian                              = 0x00551,
    D                                       = 0x00044,
    DZ                                      = 0x001F1,
    DZcaron                                 = 0x001C4,
    Daarmenian                              = 0x00534,
    Dafrican                                = 0x00189,
    Dcaron                                  = 0x0010E,
    Dcedilla                                = 0x01E10,
    Dcircle                                 = 0x024B9,
    Dcircumflexbelow                        = 0x01E12,
    Dcroat                                  = 0x00110,
    Ddotaccent                              = 0x01E0A,
    Ddotbelow                               = 0x01E0C,
    Decyrillic                              = 0x00414,
    Deicoptic                               = 0x003EE,
    Delta                                   = 0x02206,
    Deltagreek                              = 0x00394,
    Dhook                                   = 0x0018A,
    Digammagreek                            = 0x003DC,
    Djecyrillic                             = 0x00402,
    Dlinebelow                              = 0x01E0E,
    Dmonospace                              = 0x0FF24,
    Dslash                                  = 0x00110,
    Dtopbar                                 = 0x0018B,
    Dz                                      = 0x001F2,
    Dzcaron                                 = 0x001C5,
    Dzeabkhasiancyrillic                    = 0x004E0,
    Dzecyrillic                             = 0x00405,
    Dzhecyrillic                            = 0x0040F,
    E                                       = 0x00045,
    Eacute                                  = 0x000C9,
    Ebreve                                  = 0x00114,
    Ecaron                                  = 0x0011A,
    Ecedillabreve                           = 0x01E1C,
    Echarmenian                             = 0x00535,
    Ecircle                                 = 0x024BA,
    Ecircumflex                             = 0x000CA,
    Ecircumflexacute                        = 0x01EBE,
    Ecircumflexbelow                        = 0x01E18,
    Ecircumflexdotbelow                     = 0x01EC6,
    Ecircumflexgrave                        = 0x01EC0,
    Ecircumflexhookabove                    = 0x01EC2,
    Ecircumflextilde                        = 0x01EC4,
    Ecyrillic                               = 0x00404,
    Edblgrave                               = 0x00204,
    Edieresis                               = 0x000CB,
    Edot                                    = 0x00116,
    Edotaccent                              = 0x00116,
    Edotbelow                               = 0x01EB8,
    Efcyrillic                              = 0x00424,
    Egrave                                  = 0x000C8,
    Eharmenian                              = 0x00537,
    Ehookabove                              = 0x01EBA,
    Eightroman                              = 0x02167,
    Einvertedbreve                          = 0x00206,
    Eiotifiedcyrillic                       = 0x00464,
    Elcyrillic                              = 0x0041B,
    Elevenroman                             = 0x0216A,
    Emacron                                 = 0x00112,
    Emacronacute                            = 0x01E16,
    Emacrongrave                            = 0x01E14,
    Emcyrillic                              = 0x0041C,
    Emonospace                              = 0x0FF25,
    Encyrillic                              = 0x0041D,
    Endescendercyrillic                     = 0x004A2,
    Eng                                     = 0x0014A,
    Enghecyrillic                           = 0x004A4,
    Enhookcyrillic                          = 0x004C7,
    Eogonek                                 = 0x00118,
    Eopen                                   = 0x00190,
    Epsilon                                 = 0x00395,
    Epsilontonos                            = 0x00388,
    Ercyrillic                              = 0x00420,
    Ereversed                               = 0x0018E,
    Ereversedcyrillic                       = 0x0042D,
    Escyrillic                              = 0x00421,
    Esdescendercyrillic                     = 0x004AA,
    Esh                                     = 0x001A9,
    Eta                                     = 0x00397,
    Etarmenian                              = 0x00538,
    Etatonos                                = 0x00389,
    Eth                                     = 0x000D0,
    Etilde                                  = 0x01EBC,
    Etildebelow                             = 0x01E1A,
    Euro                                    = 0x020AC,
    Ezh                                     = 0x001B7,
    Ezhcaron                                = 0x001EE,
    Ezhreversed                             = 0x001B8,
    F                                       = 0x00046,
    Fcircle                                 = 0x024BB,
    Fdotaccent                              = 0x01E1E,
    Feharmenian                             = 0x00556,
    Feicoptic                               = 0x003E4,
    Fhook                                   = 0x00191,
    Fitacyrillic                            = 0x00472,
    Fiveroman                               = 0x02164,
    Fmonospace                              = 0x0FF26,
    Fourroman                               = 0x02163,
    G                                       = 0x00047,
    GBsquare                                = 0x03387,
    Gacute                                  = 0x001F4,
    Gamma                                   = 0x00393,
    Gammaafrican                            = 0x00194,
    Gangiacoptic                            = 0x003EA,
    Gbreve                                  = 0x0011E,
    Gcaron                                  = 0x001E6,
    Gcedilla                                = 0x00122,
    Gcircle                                 = 0x024BC,
    Gcircumflex                             = 0x0011C,
    Gcommaaccent                            = 0x00122,
    Gdot                                    = 0x00120,
    Gdotaccent                              = 0x00120,
    Gecyrillic                              = 0x00413,
    Ghadarmenian                            = 0x00542,
    Ghemiddlehookcyrillic                   = 0x00494,
    Ghestrokecyrillic                       = 0x00492,
    Gheupturncyrillic                       = 0x00490,
    Ghook                                   = 0x00193,
    Gimarmenian                             = 0x00533,
    Gjecyrillic                             = 0x00403,
    Gmacron                                 = 0x01E20,
    Gmonospace                              = 0x0FF27,
    Gsmallhook                              = 0x0029B,
    Gstroke                                 = 0x001E4,
    H                                       = 0x00048,
    H18533                                  = 0x025CF,
    H18543                                  = 0x025AA,
    H18551                                  = 0x025AB,
    H22073                                  = 0x025A1,
    HPsquare                                = 0x033CB,
    Haabkhasiancyrillic                     = 0x004A8,
    Hadescendercyrillic                     = 0x004B2,
    Hardsigncyrillic                        = 0x0042A,
    Hbar                                    = 0x00126,
    Hbrevebelow                             = 0x01E2A,
    Hcedilla                                = 0x01E28,
    Hcircle                                 = 0x024BD,
    Hcircumflex                             = 0x00124,
    Hdieresis                               = 0x01E26,
    Hdotaccent                              = 0x01E22,
    Hdotbelow                               = 0x01E24,
    Hmonospace                              = 0x0FF28,
    Hoarmenian                              = 0x00540,
    Horicoptic                              = 0x003E8,
    Hzsquare                                = 0x03390,
    I                                       = 0x00049,
    IAcyrillic                              = 0x0042F,
    IJ                                      = 0x00132,
    IUcyrillic                              = 0x0042E,
    Iacute                                  = 0x000CD,
    Ibreve                                  = 0x0012C,
    Icaron                                  = 0x001CF,
    Icircle                                 = 0x024BE,
    Icircumflex                             = 0x000CE,
    Icyrillic                               = 0x00406,
    Idblgrave                               = 0x00208,
    Idieresis                               = 0x000CF,
    Idieresisacute                          = 0x01E2E,
    Idieresiscyrillic                       = 0x004E4,
    Idot                                    = 0x00130,
    Idotaccent                              = 0x00130,
    Idotbelow                               = 0x01ECA,
    Iebrevecyrillic                         = 0x004D6,
    Iecyrillic                              = 0x00415,
    Ifraktur                                = 0x02111,
    Igrave                                  = 0x000CC,
    Ihookabove                              = 0x01EC8,
    Iicyrillic                              = 0x00418,
    Iinvertedbreve                          = 0x0020A,
    Iishortcyrillic                         = 0x00419,
    Imacron                                 = 0x0012A,
    Imacroncyrillic                         = 0x004E2,
    Imonospace                              = 0x0FF29,
    Iniarmenian                             = 0x0053B,
    Iocyrillic                              = 0x00401,
    Iogonek                                 = 0x0012E,
    Iota                                    = 0x00399,
    Iotaafrican                             = 0x00196,
    Iotadieresis                            = 0x003AA,
    Iotatonos                               = 0x0038A,
    Istroke                                 = 0x00197,
    Itilde                                  = 0x00128,
    Itildebelow                             = 0x01E2C,
    Izhitsacyrillic                         = 0x00474,
    Izhitsadblgravecyrillic                 = 0x00476,
    J                                       = 0x0004A,
    Jaarmenian                              = 0x00541,
    Jcircle                                 = 0x024BF,
    Jcircumflex                             = 0x00134,
    Jecyrillic                              = 0x00408,
    Jheharmenian                            = 0x0054B,
    Jmonospace                              = 0x0FF2A,
    K                                       = 0x0004B,
    KBsquare                                = 0x03385,
    KKsquare                                = 0x033CD,
    Kabashkircyrillic                       = 0x004A0,
    Kacute                                  = 0x01E30,
    Kacyrillic                              = 0x0041A,
    Kadescendercyrillic                     = 0x0049A,
    Kahookcyrillic                          = 0x004C3,
    Kappa                                   = 0x0039A,
    Kastrokecyrillic                        = 0x0049E,
    Kaverticalstrokecyrillic                = 0x0049C,
    Kcaron                                  = 0x001E8,
    Kcedilla                                = 0x00136,
    Kcircle                                 = 0x024C0,
    Kcommaaccent                            = 0x00136,
    Kdotbelow                               = 0x01E32,
    Keharmenian                             = 0x00554,
    Kenarmenian                             = 0x0053F,
    Khacyrillic                             = 0x00425,
    Kheicoptic                              = 0x003E6,
    Khook                                   = 0x00198,
    Kjecyrillic                             = 0x0040C,
    Klinebelow                              = 0x01E34,
    Kmonospace                              = 0x0FF2B,
    Koppacyrillic                           = 0x00480,
    Koppagreek                              = 0x003DE,
    Ksicyrillic                             = 0x0046E,
    L                                       = 0x0004C,
    LJ                                      = 0x001C7,
    Lacute                                  = 0x00139,
    Lambda                                  = 0x0039B,
    Lcaron                                  = 0x0013D,
    Lcedilla                                = 0x0013B,
    Lcircle                                 = 0x024C1,
    Lcircumflexbelow                        = 0x01E3C,
    Lcommaaccent                            = 0x0013B,
    Ldot                                    = 0x0013F,
    Ldotaccent                              = 0x0013F,
    Ldotbelow                               = 0x01E36,
    Ldotbelowmacron                         = 0x01E38,
    Liwnarmenian                            = 0x0053C,
    Lj                                      = 0x001C8,
    Ljecyrillic                             = 0x00409,
    Llinebelow                              = 0x01E3A,
    Lmonospace                              = 0x0FF2C,
    Lslash                                  = 0x00141,
    M                                       = 0x0004D,
    MBsquare                                = 0x03386,
    Macute                                  = 0x01E3E,
    Mcircle                                 = 0x024C2,
    Mdotaccent                              = 0x01E40,
    Mdotbelow                               = 0x01E42,
    Menarmenian                             = 0x00544,
    Mmonospace                              = 0x0FF2D,
    Mturned                                 = 0x0019C,
    Mu                                      = 0x0039C,
    N                                       = 0x0004E,
    NJ                                      = 0x001CA,
    Nacute                                  = 0x00143,
    Ncaron                                  = 0x00147,
    Ncedilla                                = 0x00145,
    Ncircle                                 = 0x024C3,
    Ncircumflexbelow                        = 0x01E4A,
    Ncommaaccent                            = 0x00145,
    Ndotaccent                              = 0x01E44,
    Ndotbelow                               = 0x01E46,
    Nhookleft                               = 0x0019D,
    Nineroman                               = 0x02168,
    Nj                                      = 0x001CB,
    Njecyrillic                             = 0x0040A,
    Nlinebelow                              = 0x01E48,
    Nmonospace                              = 0x0FF2E,
    Nowarmenian                             = 0x00546,
    Ntilde                                  = 0x000D1,
    Nu                                      = 0x0039D,
    O                                       = 0x0004F,
    OE                                      = 0x00152,
    Oacute                                  = 0x000D3,
    Obarredcyrillic                         = 0x004E8,
    Obarreddieresiscyrillic                 = 0x004EA,
    Obreve                                  = 0x0014E,
    Ocaron                                  = 0x001D1,
    Ocenteredtilde                          = 0x0019F,
    Ocircle                                 = 0x024C4,
    Ocircumflex                             = 0x000D4,
    Ocircumflexacute                        = 0x01ED0,
    Ocircumflexdotbelow                     = 0x01ED8,
    Ocircumflexgrave                        = 0x01ED2,
    Ocircumflexhookabove                    = 0x01ED4,
    Ocircumflextilde                        = 0x01ED6,
    Ocyrillic                               = 0x0041E,
    Odblacute                               = 0x00150,
    Odblgrave                               = 0x0020C,
    Odieresis                               = 0x000D6,
    Odieresiscyrillic                       = 0x004E6,
    Odotbelow                               = 0x01ECC,
    Ograve                                  = 0x000D2,
    Oharmenian                              = 0x00555,
    Ohm                                     = 0x02126,
    Ohookabove                              = 0x01ECE,
    Ohorn                                   = 0x001A0,
    Ohornacute                              = 0x01EDA,
    Ohorndotbelow                           = 0x01EE2,
    Ohorngrave                              = 0x01EDC,
    Ohornhookabove                          = 0x01EDE,
    Ohorntilde                              = 0x01EE0,
    Ohungarumlaut                           = 0x00150,
    Oi                                      = 0x001A2,
    Oinvertedbreve                          = 0x0020E,
    Omacron                                 = 0x0014C,
    Omacronacute                            = 0x01E52,
    Omacrongrave                            = 0x01E50,
    Omega                                   = 0x02126,
    Omegacyrillic                           = 0x00460,
    Omegagreek                              = 0x003A9,
    Omegaroundcyrillic                      = 0x0047A,
    Omegatitlocyrillic                      = 0x0047C,
    Omegatonos                              = 0x0038F,
    Omicron                                 = 0x0039F,
    Omicrontonos                            = 0x0038C,
    Omonospace                              = 0x0FF2F,
    Oneroman                                = 0x02160,
    Oogonek                                 = 0x001EA,
    Oogonekmacron                           = 0x001EC,
    Oopen                                   = 0x00186,
    Oslash                                  = 0x000D8,
    Oslashacute                             = 0x001FE,
    Ostrokeacute                            = 0x001FE,
    Otcyrillic                              = 0x0047E,
    Otilde                                  = 0x000D5,
    Otildeacute                             = 0x01E4C,
    Otildedieresis                          = 0x01E4E,
    P                                       = 0x00050,
    Pacute                                  = 0x01E54,
    Pcircle                                 = 0x024C5,
    Pdotaccent                              = 0x01E56,
    Pecyrillic                              = 0x0041F,
    Peharmenian                             = 0x0054A,
    Pemiddlehookcyrillic                    = 0x004A6,
    Phi                                     = 0x003A6,
    Phook                                   = 0x001A4,
    Pi                                      = 0x003A0,
    Piwrarmenian                            = 0x00553,
    Pmonospace                              = 0x0FF30,
    Psi                                     = 0x003A8,
    Psicyrillic                             = 0x00470,
    Q                                       = 0x00051,
    Qcircle                                 = 0x024C6,
    Qmonospace                              = 0x0FF31,
    R                                       = 0x00052,
    Raarmenian                              = 0x0054C,
    Racute                                  = 0x00154,
    Rcaron                                  = 0x00158,
    Rcedilla                                = 0x00156,
    Rcircle                                 = 0x024C7,
    Rcommaaccent                            = 0x00156,
    Rdblgrave                               = 0x00210,
    Rdotaccent                              = 0x01E58,
    Rdotbelow                               = 0x01E5A,
    Rdotbelowmacron                         = 0x01E5C,
    Reharmenian                             = 0x00550,
    Rfraktur                                = 0x0211C,
    Rho                                     = 0x003A1,
    Rinvertedbreve                          = 0x00212,
    Rlinebelow                              = 0x01E5E,
    Rmonospace                              = 0x0FF32,
    Rsmallinverted                          = 0x00281,
    Rsmallinvertedsuperior                  = 0x002B6,
    S                                       = 0x00053,
    SF010000                                = 0x0250C,
    SF020000                                = 0x02514,
    SF030000                                = 0x02510,
    SF040000                                = 0x02518,
    SF050000                                = 0x0253C,
    SF060000                                = 0x0252C,
    SF070000                                = 0x02534,
    SF080000                                = 0x0251C,
    SF090000                                = 0x02524,
    SF10000                                 = 0x0250C,
    SF100000                                = 0x02500,
    SF110000                                = 0x02502,
    SF190000                                = 0x02561,
    SF20000                                 = 0x02514,
    SF200000                                = 0x02562,
    SF210000                                = 0x02556,
    SF220000                                = 0x02555,
    SF230000                                = 0x02563,
    SF240000                                = 0x02551,
    SF250000                                = 0x02557,
    SF260000                                = 0x0255D,
    SF270000                                = 0x0255C,
    SF280000                                = 0x0255B,
    SF30000                                 = 0x02510,
    SF360000                                = 0x0255E,
    SF370000                                = 0x0255F,
    SF380000                                = 0x0255A,
    SF390000                                = 0x02554,
    SF40000                                 = 0x02518,
    SF400000                                = 0x02569,
    SF410000                                = 0x02566,
    SF420000                                = 0x02560,
    SF430000                                = 0x02550,
    SF440000                                = 0x0256C,
    SF450000                                = 0x02567,
    SF460000                                = 0x02568,
    SF470000                                = 0x02564,
    SF480000                                = 0x02565,
    SF490000                                = 0x02559,
    SF50000                                 = 0x0253C,
    SF500000                                = 0x02558,
    SF510000                                = 0x02552,
    SF520000                                = 0x02553,
    SF530000                                = 0x0256B,
    SF540000                                = 0x0256A,
    SF60000                                 = 0x0252C,
    SF70000                                 = 0x02534,
    SF80000                                 = 0x0251C,
    SF90000                                 = 0x02524,
    Sacute                                  = 0x0015A,
    Sacutedotaccent                         = 0x01E64,
    Sampigreek                              = 0x003E0,
    Scaron                                  = 0x00160,
    Scarondotaccent                         = 0x01E66,
    Scedilla                                = 0x0015E,
    Schwa                                   = 0x0018F,
    Schwacyrillic                           = 0x004D8,
    Schwadieresiscyrillic                   = 0x004DA,
    Scircle                                 = 0x024C8,
    Scircumflex                             = 0x0015C,
    Scommaaccent                            = 0x00218,
    Sdotaccent                              = 0x01E60,
    Sdotbelow                               = 0x01E62,
    Sdotbelowdotaccent                      = 0x01E68,
    Seharmenian                             = 0x0054D,
    Sevenroman                              = 0x02166,
    Shaarmenian                             = 0x00547,
    Shacyrillic                             = 0x00428,
    Shchacyrillic                           = 0x00429,
    Sheicoptic                              = 0x003E2,
    Shhacyrillic                            = 0x004BA,
    Shimacoptic                             = 0x003EC,
    Sigma                                   = 0x003A3,
    Sixroman                                = 0x02165,
    Smonospace                              = 0x0FF33,
    Softsigncyrillic                        = 0x0042C,
    Stigmagreek                             = 0x003DA,
    T                                       = 0x00054,
    Tau                                     = 0x003A4,
    Tbar                                    = 0x00166,
    Tcaron                                  = 0x00164,
    Tcedilla                                = 0x00162,
    Tcircle                                 = 0x024C9,
    Tcircumflexbelow                        = 0x01E70,
    Tcommaaccent                            = 0x00162,
    Tdotaccent                              = 0x01E6A,
    Tdotbelow                               = 0x01E6C,
    Tecyrillic                              = 0x00422,
    Tedescendercyrillic                     = 0x004AC,
    Tenroman                                = 0x02169,
    Tetsecyrillic                           = 0x004B4,
    Theta                                   = 0x00398,
    Thook                                   = 0x001AC,
    Thorn                                   = 0x000DE,
    Threeroman                              = 0x02162,
    Tiwnarmenian                            = 0x0054F,
    Tlinebelow                              = 0x01E6E,
    Tmonospace                              = 0x0FF34,
    Toarmenian                              = 0x00539,
    Tonefive                                = 0x001BC,
    Tonesix                                 = 0x00184,
    Tonetwo                                 = 0x001A7,
    Tretroflexhook                          = 0x001AE,
    Tsecyrillic                             = 0x00426,
    Tshecyrillic                            = 0x0040B,
    Twelveroman                             = 0x0216B,
    Tworoman                                = 0x02161,
    U                                       = 0x00055,
    Uacute                                  = 0x000DA,
    Ubreve                                  = 0x0016C,
    Ucaron                                  = 0x001D3,
    Ucircle                                 = 0x024CA,
    Ucircumflex                             = 0x000DB,
    Ucircumflexbelow                        = 0x01E76,
    Ucyrillic                               = 0x00423,
    Udblacute                               = 0x00170,
    Udblgrave                               = 0x00214,
    Udieresis                               = 0x000DC,
    Udieresisacute                          = 0x001D7,
    Udieresisbelow                          = 0x01E72,
    Udieresiscaron                          = 0x001D9,
    Udieresiscyrillic                       = 0x004F0,
    Udieresisgrave                          = 0x001DB,
    Udieresismacron                         = 0x001D5,
    Udotbelow                               = 0x01EE4,
    Ugrave                                  = 0x000D9,
    Uhookabove                              = 0x01EE6,
    Uhorn                                   = 0x001AF,
    Uhornacute                              = 0x01EE8,
    Uhorndotbelow                           = 0x01EF0,
    Uhorngrave                              = 0x01EEA,
    Uhornhookabove                          = 0x01EEC,
    Uhorntilde                              = 0x01EEE,
    Uhungarumlaut                           = 0x00170,
    Uhungarumlautcyrillic                   = 0x004F2,
    Uinvertedbreve                          = 0x00216,
    Ukcyrillic                              = 0x00478,
    Umacron                                 = 0x0016A,
    Umacroncyrillic                         = 0x004EE,
    Umacrondieresis                         = 0x01E7A,
    Umonospace                              = 0x0FF35,
    Uogonek                                 = 0x00172,
    Upsilon                                 = 0x003A5,
    Upsilon1                                = 0x003D2,
    Upsilonacutehooksymbolgreek             = 0x003D3,
    Upsilonafrican                          = 0x001B1,
    Upsilondieresis                         = 0x003AB,
    Upsilondieresishooksymbolgreek          = 0x003D4,
    Upsilonhooksymbol                       = 0x003D2,
    Upsilontonos                            = 0x0038E,
    Uring                                   = 0x0016E,
    Ushortcyrillic                          = 0x0040E,
    Ustraightcyrillic                       = 0x004AE,
    Ustraightstrokecyrillic                 = 0x004B0,
    Utilde                                  = 0x00168,
    Utildeacute                             = 0x01E78,
    Utildebelow                             = 0x01E74,
    V                                       = 0x00056,
    Vcircle                                 = 0x024CB,
    Vdotbelow                               = 0x01E7E,
    Vecyrillic                              = 0x00412,
    Vewarmenian                             = 0x0054E,
    Vhook                                   = 0x001B2,
    Vmonospace                              = 0x0FF36,
    Voarmenian                              = 0x00548,
    Vtilde                                  = 0x01E7C,
    W                                       = 0x00057,
    Wacute                                  = 0x01E82,
    Wcircle                                 = 0x024CC,
    Wcircumflex                             = 0x00174,
    Wdieresis                               = 0x01E84,
    Wdotaccent                              = 0x01E86,
    Wdotbelow                               = 0x01E88,
    Wgrave                                  = 0x01E80,
    Wmonospace                              = 0x0FF37,
    X                                       = 0x00058,
    Xcircle                                 = 0x024CD,
    Xdieresis                               = 0x01E8C,
    Xdotaccent                              = 0x01E8A,
    Xeharmenian                             = 0x0053D,
    Xi                                      = 0x0039E,
    Xmonospace                              = 0x0FF38,
    Y                                       = 0x00059,
    Yacute                                  = 0x000DD,
    Yatcyrillic                             = 0x00462,
    Ycircle                                 = 0x024CE,
    Ycircumflex                             = 0x00176,
    Ydieresis                               = 0x00178,
    Ydotaccent                              = 0x01E8E,
    Ydotbelow                               = 0x01EF4,
    Yericyrillic                            = 0x0042B,
    Yerudieresiscyrillic                    = 0x004F8,
    Ygrave                                  = 0x01EF2,
    Yhook                                   = 0x001B3,
    Yhookabove                              = 0x01EF6,
    Yiarmenian                              = 0x00545,
    Yicyrillic                              = 0x00407,
    Yiwnarmenian                            = 0x00552,
    Ymonospace                              = 0x0FF39,
    Ytilde                                  = 0x01EF8,
    Yusbigcyrillic                          = 0x0046A,
    Yusbigiotifiedcyrillic                  = 0x0046C,
    Yuslittlecyrillic                       = 0x00466,
    Yuslittleiotifiedcyrillic               = 0x00468,
    Z                                       = 0x0005A,
    Zaarmenian                              = 0x00536,
    Zacute                                  = 0x00179,
    Zcaron                                  = 0x0017D,
    Zcircle                                 = 0x024CF,
    Zcircumflex                             = 0x01E90,
    Zdot                                    = 0x0017B,
    Zdotaccent                              = 0x0017B,
    Zdotbelow                               = 0x01E92,
    Zecyrillic                              = 0x00417,
    Zedescendercyrillic                     = 0x00498,
    Zedieresiscyrillic                      = 0x004DE,
    Zeta                                    = 0x00396,
    Zhearmenian                             = 0x0053A,
    Zhebrevecyrillic                        = 0x004C1,
    Zhecyrillic                             = 0x00416,
    Zhedescendercyrillic                    = 0x00496,
    Zhedieresiscyrillic                     = 0x004DC,
    Zlinebelow                              = 0x01E94,
    Zmonospace                              = 0x0FF3A,
    Zstroke                                 = 0x001B5,
    a                                       = 0x00061,
    aabengali                               = 0x00986,
    aacute                                  = 0x000E1,
    aadeva                                  = 0x00906,
    aagujarati                              = 0x00A86,
    aagurmukhi                              = 0x00A06,
    aamatragurmukhi                         = 0x00A3E,
    aarusquare                              = 0x03303,
    aavowelsignbengali                      = 0x009BE,
    aavowelsigndeva                         = 0x0093E,
    aavowelsigngujarati                     = 0x00ABE,
    abbreviationmarkarmenian                = 0x0055F,
    abbreviationsigndeva                    = 0x00970,
    abengali                                = 0x00985,
    abopomofo                               = 0x0311A,
    abreve                                  = 0x00103,
    abreveacute                             = 0x01EAF,
    abrevecyrillic                          = 0x004D1,
    abrevedotbelow                          = 0x01EB7,
    abrevegrave                             = 0x01EB1,
    abrevehookabove                         = 0x01EB3,
    abrevetilde                             = 0x01EB5,
    acaron                                  = 0x001CE,
    acircle                                 = 0x024D0,
    acircumflex                             = 0x000E2,
    acircumflexacute                        = 0x01EA5,
    acircumflexdotbelow                     = 0x01EAD,
    acircumflexgrave                        = 0x01EA7,
    acircumflexhookabove                    = 0x01EA9,
    acircumflextilde                        = 0x01EAB,
    acute                                   = 0x000B4,
    acutebelowcmb                           = 0x00317,
    acutecmb                                = 0x00301,
    acutecomb                               = 0x00301,
    acutedeva                               = 0x00954,
    acutelowmod                             = 0x002CF,
    acutetonecmb                            = 0x00341,
    acyrillic                               = 0x00430,
    adblgrave                               = 0x00201,
    addakgurmukhi                           = 0x00A71,
    adeva                                   = 0x00905,
    adieresis                               = 0x000E4,
    adieresiscyrillic                       = 0x004D3,
    adieresismacron                         = 0x001DF,
    adotbelow                               = 0x01EA1,
    adotmacron                              = 0x001E1,
    ae                                      = 0x000E6,
    aeacute                                 = 0x001FD,
    aekorean                                = 0x03150,
    aemacron                                = 0x001E3,
    afii00208                               = 0x02015,
    afii08941                               = 0x020A4,
    afii10017                               = 0x00410,
    afii10018                               = 0x00411,
    afii10019                               = 0x00412,
    afii10020                               = 0x00413,
    afii10021                               = 0x00414,
    afii10022                               = 0x00415,
    afii10023                               = 0x00401,
    afii10024                               = 0x00416,
    afii10025                               = 0x00417,
    afii10026                               = 0x00418,
    afii10027                               = 0x00419,
    afii10028                               = 0x0041A,
    afii10029                               = 0x0041B,
    afii10030                               = 0x0041C,
    afii10031                               = 0x0041D,
    afii10032                               = 0x0041E,
    afii10033                               = 0x0041F,
    afii10034                               = 0x00420,
    afii10035                               = 0x00421,
    afii10036                               = 0x00422,
    afii10037                               = 0x00423,
    afii10038                               = 0x00424,
    afii10039                               = 0x00425,
    afii10040                               = 0x00426,
    afii10041                               = 0x00427,
    afii10042                               = 0x00428,
    afii10043                               = 0x00429,
    afii10044                               = 0x0042A,
    afii10045                               = 0x0042B,
    afii10046                               = 0x0042C,
    afii10047                               = 0x0042D,
    afii10048                               = 0x0042E,
    afii10049                               = 0x0042F,
    afii10050                               = 0x00490,
    afii10051                               = 0x00402,
    afii10052                               = 0x00403,
    afii10053                               = 0x00404,
    afii10054                               = 0x00405,
    afii10055                               = 0x00406,
    afii10056                               = 0x00407,
    afii10057                               = 0x00408,
    afii10058                               = 0x00409,
    afii10059                               = 0x0040A,
    afii10060                               = 0x0040B,
    afii10061                               = 0x0040C,
    afii10062                               = 0x0040E,
    afii10065                               = 0x00430,
    afii10066                               = 0x00431,
    afii10067                               = 0x00432,
    afii10068                               = 0x00433,
    afii10069                               = 0x00434,
    afii10070                               = 0x00435,
    afii10071                               = 0x00451,
    afii10072                               = 0x00436,
    afii10073                               = 0x00437,
    afii10074                               = 0x00438,
    afii10075                               = 0x00439,
    afii10076                               = 0x0043A,
    afii10077                               = 0x0043B,
    afii10078                               = 0x0043C,
    afii10079                               = 0x0043D,
    afii10080                               = 0x0043E,
    afii10081                               = 0x0043F,
    afii10082                               = 0x00440,
    afii10083                               = 0x00441,
    afii10084                               = 0x00442,
    afii10085                               = 0x00443,
    afii10086                               = 0x00444,
    afii10087                               = 0x00445,
    afii10088                               = 0x00446,
    afii10089                               = 0x00447,
    afii10090                               = 0x00448,
    afii10091                               = 0x00449,
    afii10092                               = 0x0044A,
    afii10093                               = 0x0044B,
    afii10094                               = 0x0044C,
    afii10095                               = 0x0044D,
    afii10096                               = 0x0044E,
    afii10097                               = 0x0044F,
    afii10098                               = 0x00491,
    afii10099                               = 0x00452,
    afii10100                               = 0x00453,
    afii10101                               = 0x00454,
    afii10102                               = 0x00455,
    afii10103                               = 0x00456,
    afii10104                               = 0x00457,
    afii10105                               = 0x00458,
    afii10106                               = 0x00459,
    afii10107                               = 0x0045A,
    afii10108                               = 0x0045B,
    afii10109                               = 0x0045C,
    afii10110                               = 0x0045E,
    afii10145                               = 0x0040F,
    afii10146                               = 0x00462,
    afii10147                               = 0x00472,
    afii10148                               = 0x00474,
    afii10193                               = 0x0045F,
    afii10194                               = 0x00463,
    afii10195                               = 0x00473,
    afii10196                               = 0x00475,
    afii10846                               = 0x004D9,
    afii208                                 = 0x02015,
    afii299                                 = 0x0200E,
    afii300                                 = 0x0200F,
    afii301                                 = 0x0200D,
    afii57381                               = 0x0066A,
    afii57388                               = 0x0060C,
    afii57392                               = 0x00660,
    afii57393                               = 0x00661,
    afii57394                               = 0x00662,
    afii57395                               = 0x00663,
    afii57396                               = 0x00664,
    afii57397                               = 0x00665,
    afii57398                               = 0x00666,
    afii57399                               = 0x00667,
    afii57400                               = 0x00668,
    afii57401                               = 0x00669,
    afii57403                               = 0x0061B,
    afii57407                               = 0x0061F,
    afii57409                               = 0x00621,
    afii57410                               = 0x00622,
    afii57411                               = 0x00623,
    afii57412                               = 0x00624,
    afii57413                               = 0x00625,
    afii57414                               = 0x00626,
    afii57415                               = 0x00627,
    afii57416                               = 0x00628,
    afii57417                               = 0x00629,
    afii57418                               = 0x0062A,
    afii57419                               = 0x0062B,
    afii57420                               = 0x0062C,
    afii57421                               = 0x0062D,
    afii57422                               = 0x0062E,
    afii57423                               = 0x0062F,
    afii57424                               = 0x00630,
    afii57425                               = 0x00631,
    afii57426                               = 0x00632,
    afii57427                               = 0x00633,
    afii57428                               = 0x00634,
    afii57429                               = 0x00635,
    afii57430                               = 0x00636,
    afii57431                               = 0x00637,
    afii57432                               = 0x00638,
    afii57433                               = 0x00639,
    afii57434                               = 0x0063A,
    afii57440                               = 0x00640,
    afii57441                               = 0x00641,
    afii57442                               = 0x00642,
    afii57443                               = 0x00643,
    afii57444                               = 0x00644,
    afii57445                               = 0x00645,
    afii57446                               = 0x00646,
    afii57448                               = 0x00648,
    afii57449                               = 0x00649,
    afii57450                               = 0x0064A,
    afii57451                               = 0x0064B,
    afii57452                               = 0x0064C,
    afii57453                               = 0x0064D,
    afii57454                               = 0x0064E,
    afii57455                               = 0x0064F,
    afii57456                               = 0x00650,
    afii57457                               = 0x00651,
    afii57458                               = 0x00652,
    afii57470                               = 0x00647,
    afii57505                               = 0x006A4,
    afii57506                               = 0x0067E,
    afii57507                               = 0x00686,
    afii57508                               = 0x00698,
    afii57509                               = 0x006AF,
    afii57511                               = 0x00679,
    afii57512                               = 0x00688,
    afii57513                               = 0x00691,
    afii57514                               = 0x006BA,
    afii57519                               = 0x006D2,
    afii57534                               = 0x006D5,
    afii57636                               = 0x020AA,
    afii57645                               = 0x005BE,
    afii57658                               = 0x005C3,
    afii57664                               = 0x005D0,
    afii57665                               = 0x005D1,
    afii57666                               = 0x005D2,
    afii57667                               = 0x005D3,
    afii57668                               = 0x005D4,
    afii57669                               = 0x005D5,
    afii57670                               = 0x005D6,
    afii57671                               = 0x005D7,
    afii57672                               = 0x005D8,
    afii57673                               = 0x005D9,
    afii57674                               = 0x005DA,
    afii57675                               = 0x005DB,
    afii57676                               = 0x005DC,
    afii57677                               = 0x005DD,
    afii57678                               = 0x005DE,
    afii57679                               = 0x005DF,
    afii57680                               = 0x005E0,
    afii57681                               = 0x005E1,
    afii57682                               = 0x005E2,
    afii57683                               = 0x005E3,
    afii57684                               = 0x005E4,
    afii57685                               = 0x005E5,
    afii57686                               = 0x005E6,
    afii57687                               = 0x005E7,
    afii57688                               = 0x005E8,
    afii57689                               = 0x005E9,
    afii57690                               = 0x005EA,
    afii57694                               = 0x0FB2A,
    afii57695                               = 0x0FB2B,
    afii57700                               = 0x0FB4B,
    afii57705                               = 0x0FB1F,
    afii57716                               = 0x005F0,
    afii57717                               = 0x005F1,
    afii57718                               = 0x005F2,
    afii57723                               = 0x0FB35,
    afii57793                               = 0x005B4,
    afii57794                               = 0x005B5,
    afii57795                               = 0x005B6,
    afii57796                               = 0x005BB,
    afii57797                               = 0x005B8,
    afii57798                               = 0x005B7,
    afii57799                               = 0x005B0,
    afii57800                               = 0x005B2,
    afii57801                               = 0x005B1,
    afii57802                               = 0x005B3,
    afii57803                               = 0x005C2,
    afii57804                               = 0x005C1,
    afii57806                               = 0x005B9,
    afii57807                               = 0x005BC,
    afii57839                               = 0x005BD,
    afii57841                               = 0x005BF,
    afii57842                               = 0x005C0,
    afii57929                               = 0x002BC,
    afii61248                               = 0x02105,
    afii61289                               = 0x02113,
    afii61352                               = 0x02116,
    afii61573                               = 0x0202C,
    afii61574                               = 0x0202D,
    afii61575                               = 0x0202E,
    afii61664                               = 0x0200C,
    afii63167                               = 0x0066D,
    afii64937                               = 0x002BD,
    agrave                                  = 0x000E0,
    agujarati                               = 0x00A85,
    agurmukhi                               = 0x00A05,
    ahiragana                               = 0x03042,
    ahookabove                              = 0x01EA3,
    aibengali                               = 0x00990,
    aibopomofo                              = 0x0311E,
    aideva                                  = 0x00910,
    aiecyrillic                             = 0x004D5,
    aigujarati                              = 0x00A90,
    aigurmukhi                              = 0x00A10,
    aimatragurmukhi                         = 0x00A48,
    ainarabic                               = 0x00639,
    ainfinalarabic                          = 0x0FECA,
    aininitialarabic                        = 0x0FECB,
    ainmedialarabic                         = 0x0FECC,
    ainvertedbreve                          = 0x00203,
    aivowelsignbengali                      = 0x009C8,
    aivowelsigndeva                         = 0x00948,
    aivowelsigngujarati                     = 0x00AC8,
    akatakana                               = 0x030A2,
    akatakanahalfwidth                      = 0x0FF71,
    akorean                                 = 0x0314F,
    alef                                    = 0x005D0,
    alefarabic                              = 0x00627,
    alefdageshhebrew                        = 0x0FB30,
    aleffinalarabic                         = 0x0FE8E,
    alefhamzaabovearabic                    = 0x00623,
    alefhamzaabovefinalarabic               = 0x0FE84,
    alefhamzabelowarabic                    = 0x00625,
    alefhamzabelowfinalarabic               = 0x0FE88,
    alefhebrew                              = 0x005D0,
    aleflamedhebrew                         = 0x0FB4F,
    alefmaddaabovearabic                    = 0x00622,
    alefmaddaabovefinalarabic               = 0x0FE82,
    alefmaksuraarabic                       = 0x00649,
    alefmaksurafinalarabic                  = 0x0FEF0,
    alefmaksurainitialarabic                = 0x0FEF3,
    alefmaksuramedialarabic                 = 0x0FEF4,
    alefpatahhebrew                         = 0x0FB2E,
    alefqamatshebrew                        = 0x0FB2F,
    aleph                                   = 0x02135,
    allequal                                = 0x0224C,
    alpha                                   = 0x003B1,
    alphatonos                              = 0x003AC,
    amacron                                 = 0x00101,
    amonospace                              = 0x0FF41,
    ampersand                               = 0x00026,
    ampersandmonospace                      = 0x0FF06,
    amsquare                                = 0x033C2,
    anbopomofo                              = 0x03122,
    angbopomofo                             = 0x03124,
    angkhankhuthai                          = 0x00E5A,
    angle                                   = 0x02220,
    anglebracketleft                        = 0x03008,
    anglebracketleftvertical                = 0x0FE3F,
    anglebracketright                       = 0x03009,
    anglebracketrightvertical               = 0x0FE40,
    angleleft                               = 0x02329,
    angleright                              = 0x0232A,
    angstrom                                = 0x0212B,
    anoteleia                               = 0x00387,
    anudattadeva                            = 0x00952,
    anusvarabengali                         = 0x00982,
    anusvaradeva                            = 0x00902,
    anusvaragujarati                        = 0x00A82,
    aogonek                                 = 0x00105,
    apaatosquare                            = 0x03300,
    aparen                                  = 0x0249C,
    apostrophearmenian                      = 0x0055A,
    apostrophemod                           = 0x002BC,
    apple                                   = 0x0F8FF,
    approaches                              = 0x02250,
    approxequal                             = 0x02248,
    approxequalorimage                      = 0x02252,
    approximatelyequal                      = 0x02245,
    araeaekorean                            = 0x0318E,
    araeakorean                             = 0x0318D,
    arc                                     = 0x02312,
    arighthalfring                          = 0x01E9A,
    aring                                   = 0x000E5,
    aringacute                              = 0x001FB,
    aringbelow                              = 0x01E01,
    arrowboth                               = 0x02194,
    arrowdashdown                           = 0x021E3,
    arrowdashleft                           = 0x021E0,
    arrowdashright                          = 0x021E2,
    arrowdashup                             = 0x021E1,
    arrowdblboth                            = 0x021D4,
    arrowdbldown                            = 0x021D3,
    arrowdblleft                            = 0x021D0,
    arrowdblright                           = 0x021D2,
    arrowdblup                              = 0x021D1,
    arrowdown                               = 0x02193,
    arrowdownleft                           = 0x02199,
    arrowdownright                          = 0x02198,
    arrowdownwhite                          = 0x021E9,
    arrowheaddownmod                        = 0x002C5,
    arrowheadleftmod                        = 0x002C2,
    arrowheadrightmod                       = 0x002C3,
    arrowheadupmod                          = 0x002C4,
    arrowleft                               = 0x02190,
    arrowleftdbl                            = 0x021D0,
    arrowleftdblstroke                      = 0x021CD,
    arrowleftoverright                      = 0x021C6,
    arrowleftwhite                          = 0x021E6,
    arrowright                              = 0x02192,
    arrowrightdblstroke                     = 0x021CF,
    arrowrightheavy                         = 0x0279E,
    arrowrightoverleft                      = 0x021C4,
    arrowrightwhite                         = 0x021E8,
    arrowtableft                            = 0x021E4,
    arrowtabright                           = 0x021E5,
    arrowup                                 = 0x02191,
    arrowupdn                               = 0x02195,
    arrowupdnbse                            = 0x021A8,
    arrowupdownbase                         = 0x021A8,
    arrowupleft                             = 0x02196,
    arrowupleftofdown                       = 0x021C5,
    arrowupright                            = 0x02197,
    arrowupwhite                            = 0x021E7,
    asciicircum                             = 0x0005E,
    asciicircummonospace                    = 0x0FF3E,
    asciitilde                              = 0x0007E,
    asciitildemonospace                     = 0x0FF5E,
    ascript                                 = 0x00251,
    ascriptturned                           = 0x00252,
    asmallhiragana                          = 0x03041,
    asmallkatakana                          = 0x030A1,
    asmallkatakanahalfwidth                 = 0x0FF67,
    asterisk                                = 0x0002A,
    asteriskaltonearabic                    = 0x0066D,
    asteriskarabic                          = 0x0066D,
    asteriskmath                            = 0x02217,
    asteriskmonospace                       = 0x0FF0A,
    asterisksmall                           = 0x0FE61,
    asterism                                = 0x02042,
    asymptoticallyequal                     = 0x02243,
    at                                      = 0x00040,
    atilde                                  = 0x000E3,
    atmonospace                             = 0x0FF20,
    atsmall                                 = 0x0FE6B,
    aturned                                 = 0x00250,
    aubengali                               = 0x00994,
    aubopomofo                              = 0x03120,
    audeva                                  = 0x00914,
    augujarati                              = 0x00A94,
    augurmukhi                              = 0x00A14,
    aulengthmarkbengali                     = 0x009D7,
    aumatragurmukhi                         = 0x00A4C,
    auvowelsignbengali                      = 0x009CC,
    auvowelsigndeva                         = 0x0094C,
    auvowelsigngujarati                     = 0x00ACC,
    avagrahadeva                            = 0x0093D,
    aybarmenian                             = 0x00561,
    ayin                                    = 0x005E2,
    ayinaltonehebrew                        = 0x0FB20,
    ayinhebrew                              = 0x005E2,
    b                                       = 0x00062,
    babengali                               = 0x009AC,
    backslash                               = 0x0005C,
    backslashmonospace                      = 0x0FF3C,
    badeva                                  = 0x0092C,
    bagujarati                              = 0x00AAC,
    bagurmukhi                              = 0x00A2C,
    bahiragana                              = 0x03070,
    bahtthai                                = 0x00E3F,
    bakatakana                              = 0x030D0,
    bar                                     = 0x0007C,
    barmonospace                            = 0x0FF5C,
    bbopomofo                               = 0x03105,
    bcircle                                 = 0x024D1,
    bdotaccent                              = 0x01E03,
    bdotbelow                               = 0x01E05,
    beamedsixteenthnotes                    = 0x0266C,
    because                                 = 0x02235,
    becyrillic                              = 0x00431,
    beharabic                               = 0x00628,
    behfinalarabic                          = 0x0FE90,
    behinitialarabic                        = 0x0FE91,
    behiragana                              = 0x03079,
    behmedialarabic                         = 0x0FE92,
    behmeeminitialarabic                    = 0x0FC9F,
    behmeemisolatedarabic                   = 0x0FC08,
    behnoonfinalarabic                      = 0x0FC6D,
    bekatakana                              = 0x030D9,
    benarmenian                             = 0x00562,
    bet                                     = 0x005D1,
    beta                                    = 0x003B2,
    betasymbolgreek                         = 0x003D0,
    betdagesh                               = 0x0FB31,
    betdageshhebrew                         = 0x0FB31,
    bethebrew                               = 0x005D1,
    betrafehebrew                           = 0x0FB4C,
    bhabengali                              = 0x009AD,
    bhadeva                                 = 0x0092D,
    bhagujarati                             = 0x00AAD,
    bhagurmukhi                             = 0x00A2D,
    bhook                                   = 0x00253,
    bihiragana                              = 0x03073,
    bikatakana                              = 0x030D3,
    bilabialclick                           = 0x00298,
    bindigurmukhi                           = 0x00A02,
    birusquare                              = 0x03331,
    blackcircle                             = 0x025CF,
    blackdiamond                            = 0x025C6,
    blackdownpointingtriangle               = 0x025BC,
    blackleftpointingpointer                = 0x025C4,
    blackleftpointingtriangle               = 0x025C0,
    blacklenticularbracketleft              = 0x03010,
    blacklenticularbracketleftvertical      = 0x0FE3B,
    blacklenticularbracketright             = 0x03011,
    blacklenticularbracketrightvertical     = 0x0FE3C,
    blacklowerlefttriangle                  = 0x025E3,
    blacklowerrighttriangle                 = 0x025E2,
    blackrectangle                          = 0x025AC,
    blackrightpointingpointer               = 0x025BA,
    blackrightpointingtriangle              = 0x025B6,
    blacksmallsquare                        = 0x025AA,
    blacksmilingface                        = 0x0263B,
    blacksquare                             = 0x025A0,
    blackstar                               = 0x02605,
    blackupperlefttriangle                  = 0x025E4,
    blackupperrighttriangle                 = 0x025E5,
    blackuppointingsmalltriangle            = 0x025B4,
    blackuppointingtriangle                 = 0x025B2,
    blank                                   = 0x02423,
    blinebelow                              = 0x01E07,
    block                                   = 0x02588,
    bmonospace                              = 0x0FF42,
    bobaimaithai                            = 0x00E1A,
    bohiragana                              = 0x0307C,
    bokatakana                              = 0x030DC,
    bparen                                  = 0x0249D,
    bqsquare                                = 0x033C3,
    braceleft                               = 0x0007B,
    braceleftmonospace                      = 0x0FF5B,
    braceleftsmall                          = 0x0FE5B,
    braceleftvertical                       = 0x0FE37,
    braceright                              = 0x0007D,
    bracerightmonospace                     = 0x0FF5D,
    bracerightsmall                         = 0x0FE5C,
    bracerightvertical                      = 0x0FE38,
    bracketleft                             = 0x0005B,
    bracketleftmonospace                    = 0x0FF3B,
    bracketright                            = 0x0005D,
    bracketrightmonospace                   = 0x0FF3D,
    breve                                   = 0x002D8,
    brevebelowcmb                           = 0x0032E,
    brevecmb                                = 0x00306,
    breveinvertedbelowcmb                   = 0x0032F,
    breveinvertedcmb                        = 0x00311,
    breveinverteddoublecmb                  = 0x00361,
    bridgebelowcmb                          = 0x0032A,
    bridgeinvertedbelowcmb                  = 0x0033A,
    brokenbar                               = 0x000A6,
    bstroke                                 = 0x00180,
    btopbar                                 = 0x00183,
    buhiragana                              = 0x03076,
    bukatakana                              = 0x030D6,
    bullet                                  = 0x02022,
    bulletinverse                           = 0x025D8,
    bulletoperator                          = 0x02219,
    bullseye                                = 0x025CE,
    c                                       = 0x00063,
    caarmenian                              = 0x0056E,
    cabengali                               = 0x0099A,
    cacute                                  = 0x00107,
    cadeva                                  = 0x0091A,
    cagujarati                              = 0x00A9A,
    cagurmukhi                              = 0x00A1A,
    calsquare                               = 0x03388,
    candrabindubengali                      = 0x00981,
    candrabinducmb                          = 0x00310,
    candrabindudeva                         = 0x00901,
    candrabindugujarati                     = 0x00A81,
    capslock                                = 0x021EA,
    careof                                  = 0x02105,
    caron                                   = 0x002C7,
    caronbelowcmb                           = 0x0032C,
    caroncmb                                = 0x0030C,
    carriagereturn                          = 0x021B5,
    cbopomofo                               = 0x03118,
    ccaron                                  = 0x0010D,
    ccedilla                                = 0x000E7,
    ccedillaacute                           = 0x01E09,
    ccircle                                 = 0x024D2,
    ccircumflex                             = 0x00109,
    ccurl                                   = 0x00255,
    cdot                                    = 0x0010B,
    cdotaccent                              = 0x0010B,
    cdsquare                                = 0x033C5,
    cedilla                                 = 0x000B8,
    cedillacmb                              = 0x00327,
    cent                                    = 0x000A2,
    centigrade                              = 0x02103,
    centmonospace                           = 0x0FFE0,
    chaarmenian                             = 0x00579,
    chabengali                              = 0x0099B,
    chadeva                                 = 0x0091B,
    chagujarati                             = 0x00A9B,
    chagurmukhi                             = 0x00A1B,
    chbopomofo                              = 0x03114,
    cheabkhasiancyrillic                    = 0x004BD,
    checkmark                               = 0x02713,
    checyrillic                             = 0x00447,
    chedescenderabkhasiancyrillic           = 0x004BF,
    chedescendercyrillic                    = 0x004B7,
    chedieresiscyrillic                     = 0x004F5,
    cheharmenian                            = 0x00573,
    chekhakassiancyrillic                   = 0x004CC,
    cheverticalstrokecyrillic               = 0x004B9,
    chi                                     = 0x003C7,
    chieuchacirclekorean                    = 0x03277,
    chieuchaparenkorean                     = 0x03217,
    chieuchcirclekorean                     = 0x03269,
    chieuchkorean                           = 0x0314A,
    chieuchparenkorean                      = 0x03209,
    chochangthai                            = 0x00E0A,
    chochanthai                             = 0x00E08,
    chochingthai                            = 0x00E09,
    chochoethai                             = 0x00E0C,
    chook                                   = 0x00188,
    cieucacirclekorean                      = 0x03276,
    cieucaparenkorean                       = 0x03216,
    cieuccirclekorean                       = 0x03268,
    cieuckorean                             = 0x03148,
    cieucparenkorean                        = 0x03208,
    cieucuparenkorean                       = 0x0321C,
    circle                                  = 0x025CB,
    circlemultiply                          = 0x02297,
    circleot                                = 0x02299,
    circleplus                              = 0x02295,
    circlepostalmark                        = 0x03036,
    circlewithlefthalfblack                 = 0x025D0,
    circlewithrighthalfblack                = 0x025D1,
    circumflex                              = 0x002C6,
    circumflexbelowcmb                      = 0x0032D,
    circumflexcmb                           = 0x00302,
    clear                                   = 0x02327,
    clickalveolar                           = 0x001C2,
    clickdental                             = 0x001C0,
    clicklateral                            = 0x001C1,
    clickretroflex                          = 0x001C3,
    club                                    = 0x02663,
    clubsuitblack                           = 0x02663,
    clubsuitwhite                           = 0x02667,
    cmcubedsquare                           = 0x033A4,
    cmonospace                              = 0x0FF43,
    cmsquaredsquare                         = 0x033A0,
    coarmenian                              = 0x00581,
    colon                                   = 0x0003A,
    colonmonetary                           = 0x020A1,
    colonmonospace                          = 0x0FF1A,
    colonsign                               = 0x020A1,
    colonsmall                              = 0x0FE55,
    colontriangularhalfmod                  = 0x002D1,
    colontriangularmod                      = 0x002D0,
    comma                                   = 0x0002C,
    commaabovecmb                           = 0x00313,
    commaaboverightcmb                      = 0x00315,
    commaarabic                             = 0x0060C,
    commaarmenian                           = 0x0055D,
    commamonospace                          = 0x0FF0C,
    commareversedabovecmb                   = 0x00314,
    commareversedmod                        = 0x002BD,
    commasmall                              = 0x0FE50,
    commaturnedabovecmb                     = 0x00312,
    commaturnedmod                          = 0x002BB,
    compass                                 = 0x0263C,
    congruent                               = 0x02245,
    contourintegral                         = 0x0222E,
    control                                 = 0x02303,
    controlACK                              = 0x00006,
    controlBEL                              = 0x00007,
    controlBS                               = 0x00008,
    controlCAN                              = 0x00018,
    controlCR                               = 0x0000D,
    controlDC1                              = 0x00011,
    controlDC2                              = 0x00012,
    controlDC3                              = 0x00013,
    controlDC4                              = 0x00014,
    controlDEL                              = 0x0007F,
    controlDLE                              = 0x00010,
    controlEM                               = 0x00019,
    controlENQ                              = 0x00005,
    controlEOT                              = 0x00004,
    controlESC                              = 0x0001B,
    controlETB                              = 0x00017,
    controlETX                              = 0x00003,
    controlFF                               = 0x0000C,
    controlFS                               = 0x0001C,
    controlGS                               = 0x0001D,
    controlHT                               = 0x00009,
    controlLF                               = 0x0000A,
    controlNAK                              = 0x00015,
    controlRS                               = 0x0001E,
    controlSI                               = 0x0000F,
    controlSO                               = 0x0000E,
    controlSOT                              = 0x00002,
    controlSTX                              = 0x00001,
    controlSUB                              = 0x0001A,
    controlSYN                              = 0x00016,
    controlUS                               = 0x0001F,
    controlVT                               = 0x0000B,
    copyright                               = 0x000A9,
    cornerbracketleft                       = 0x0300C,
    cornerbracketlefthalfwidth              = 0x0FF62,
    cornerbracketleftvertical               = 0x0FE41,
    cornerbracketright                      = 0x0300D,
    cornerbracketrighthalfwidth             = 0x0FF63,
    cornerbracketrightvertical              = 0x0FE42,
    corporationsquare                       = 0x0337F,
    cosquare                                = 0x033C7,
    coverkgsquare                           = 0x033C6,
    cparen                                  = 0x0249E,
    cruzeiro                                = 0x020A2,
    cstretched                              = 0x00297,
    curlyand                                = 0x022CF,
    curlyor                                 = 0x022CE,
    currency                                = 0x000A4,
    d                                       = 0x00064,
    daarmenian                              = 0x00564,
    dabengali                               = 0x009A6,
    dadarabic                               = 0x00636,
    dadeva                                  = 0x00926,
    dadfinalarabic                          = 0x0FEBE,
    dadinitialarabic                        = 0x0FEBF,
    dadmedialarabic                         = 0x0FEC0,
    dagesh                                  = 0x005BC,
    dageshhebrew                            = 0x005BC,
    dagger                                  = 0x02020,
    daggerdbl                               = 0x02021,
    dagujarati                              = 0x00AA6,
    dagurmukhi                              = 0x00A26,
    dahiragana                              = 0x03060,
    dakatakana                              = 0x030C0,
    dalarabic                               = 0x0062F,
    dalet                                   = 0x005D3,
    daletdagesh                             = 0x0FB33,
    daletdageshhebrew                       = 0x0FB33,
    dalethatafpatah                         = 0x005D3,
    dalethatafpatahhebrew                   = 0x005D3,
    dalethatafsegol                         = 0x005D3,
    dalethatafsegolhebrew                   = 0x005D3,
    dalethebrew                             = 0x005D3,
    dalethiriq                              = 0x005D3,
    dalethiriqhebrew                        = 0x005D3,
    daletholam                              = 0x005D3,
    daletholamhebrew                        = 0x005D3,
    daletpatah                              = 0x005D3,
    daletpatahhebrew                        = 0x005D3,
    daletqamats                             = 0x005D3,
    daletqamatshebrew                       = 0x005D3,
    daletqubuts                             = 0x005D3,
    daletqubutshebrew                       = 0x005D3,
    daletsegol                              = 0x005D3,
    daletsegolhebrew                        = 0x005D3,
    daletsheva                              = 0x005D3,
    daletshevahebrew                        = 0x005D3,
    dalettsere                              = 0x005D3,
    dalettserehebrew                        = 0x005D3,
    dalfinalarabic                          = 0x0FEAA,
    dammaarabic                             = 0x0064F,
    dammalowarabic                          = 0x0064F,
    dammatanaltonearabic                    = 0x0064C,
    dammatanarabic                          = 0x0064C,
    danda                                   = 0x00964,
    dargahebrew                             = 0x005A7,
    dargalefthebrew                         = 0x005A7,
    dasiapneumatacyrilliccmb                = 0x00485,
    dblanglebracketleft                     = 0x0300A,
    dblanglebracketleftvertical             = 0x0FE3D,
    dblanglebracketright                    = 0x0300B,
    dblanglebracketrightvertical            = 0x0FE3E,
    dblarchinvertedbelowcmb                 = 0x0032B,
    dblarrowleft                            = 0x021D4,
    dblarrowright                           = 0x021D2,
    dbldanda                                = 0x00965,
    dblgravecmb                             = 0x0030F,
    dblintegral                             = 0x0222C,
    dbllowline                              = 0x02017,
    dbllowlinecmb                           = 0x00333,
    dbloverlinecmb                          = 0x0033F,
    dblprimemod                             = 0x002BA,
    dblverticalbar                          = 0x02016,
    dblverticallineabovecmb                 = 0x0030E,
    dbopomofo                               = 0x03109,
    dbsquare                                = 0x033C8,
    dcaron                                  = 0x0010F,
    dcedilla                                = 0x01E11,
    dcircle                                 = 0x024D3,
    dcircumflexbelow                        = 0x01E13,
    dcroat                                  = 0x00111,
    ddabengali                              = 0x009A1,
    ddadeva                                 = 0x00921,
    ddagujarati                             = 0x00AA1,
    ddagurmukhi                             = 0x00A21,
    ddalarabic                              = 0x00688,
    ddalfinalarabic                         = 0x0FB89,
    dddhadeva                               = 0x0095C,
    ddhabengali                             = 0x009A2,
    ddhadeva                                = 0x00922,
    ddhagujarati                            = 0x00AA2,
    ddhagurmukhi                            = 0x00A22,
    ddotaccent                              = 0x01E0B,
    ddotbelow                               = 0x01E0D,
    decimalseparatorarabic                  = 0x0066B,
    decimalseparatorpersian                 = 0x0066B,
    decyrillic                              = 0x00434,
    degree                                  = 0x000B0,
    dehihebrew                              = 0x005AD,
    dehiragana                              = 0x03067,
    deicoptic                               = 0x003EF,
    dekatakana                              = 0x030C7,
    deleteleft                              = 0x0232B,
    deleteright                             = 0x02326,
    delta                                   = 0x003B4,
    deltaturned                             = 0x0018D,
    denominatorminusonenumeratorbengali     = 0x009F8,
    dezh                                    = 0x002A4,
    dhabengali                              = 0x009A7,
    dhadeva                                 = 0x00927,
    dhagujarati                             = 0x00AA7,
    dhagurmukhi                             = 0x00A27,
    dhook                                   = 0x00257,
    dialytikatonos                          = 0x00385,
    dialytikatonoscmb                       = 0x00344,
    diamond                                 = 0x02666,
    diamondsuitwhite                        = 0x02662,
    dieresis                                = 0x000A8,
    dieresisbelowcmb                        = 0x00324,
    dieresiscmb                             = 0x00308,
    dieresistonos                           = 0x00385,
    dihiragana                              = 0x03062,
    dikatakana                              = 0x030C2,
    dittomark                               = 0x03003,
    divide                                  = 0x000F7,
    divides                                 = 0x02223,
    divisionslash                           = 0x02215,
    djecyrillic                             = 0x00452,
    dkshade                                 = 0x02593,
    dlinebelow                              = 0x01E0F,
    dlsquare                                = 0x03397,
    dmacron                                 = 0x00111,
    dmonospace                              = 0x0FF44,
    dnblock                                 = 0x02584,
    dochadathai                             = 0x00E0E,
    dodekthai                               = 0x00E14,
    dohiragana                              = 0x03069,
    dokatakana                              = 0x030C9,
    dollar                                  = 0x00024,
    dollarmonospace                         = 0x0FF04,
    dollarsmall                             = 0x0FE69,
    dong                                    = 0x020AB,
    dorusquare                              = 0x03326,
    dotaccent                               = 0x002D9,
    dotaccentcmb                            = 0x00307,
    dotbelowcmb                             = 0x00323,
    dotbelowcomb                            = 0x00323,
    dotkatakana                             = 0x030FB,
    dotlessi                                = 0x00131,
    dotlessj                                = 0x00237,
    dotlessjstrokehook                      = 0x00284,
    dotmath                                 = 0x022C5,
    dottedcircle                            = 0x025CC,
    doubleyodpatah                          = 0x0FB1F,
    doubleyodpatahhebrew                    = 0x0FB1F,
    downtackbelowcmb                        = 0x0031E,
    downtackmod                             = 0x002D5,
    dparen                                  = 0x0249F,
    dtail                                   = 0x00256,
    dtopbar                                 = 0x0018C,
    duhiragana                              = 0x03065,
    dukatakana                              = 0x030C5,
    dz                                      = 0x001F3,
    dzaltone                                = 0x002A3,
    dzcaron                                 = 0x001C6,
    dzcurl                                  = 0x002A5,
    dzeabkhasiancyrillic                    = 0x004E1,
    dzecyrillic                             = 0x00455,
    dzhecyrillic                            = 0x0045F,
    e                                       = 0x00065,
    eacute                                  = 0x000E9,
    earth                                   = 0x02641,
    ebengali                                = 0x0098F,
    ebopomofo                               = 0x0311C,
    ebreve                                  = 0x00115,
    ecandradeva                             = 0x0090D,
    ecandragujarati                         = 0x00A8D,
    ecandravowelsigndeva                    = 0x00945,
    ecandravowelsigngujarati                = 0x00AC5,
    ecaron                                  = 0x0011B,
    ecedillabreve                           = 0x01E1D,
    echarmenian                             = 0x00565,
    echyiwnarmenian                         = 0x00587,
    ecircle                                 = 0x024D4,
    ecircumflex                             = 0x000EA,
    ecircumflexacute                        = 0x01EBF,
    ecircumflexbelow                        = 0x01E19,
    ecircumflexdotbelow                     = 0x01EC7,
    ecircumflexgrave                        = 0x01EC1,
    ecircumflexhookabove                    = 0x01EC3,
    ecircumflextilde                        = 0x01EC5,
    ecyrillic                               = 0x00454,
    edblgrave                               = 0x00205,
    edeva                                   = 0x0090F,
    edieresis                               = 0x000EB,
    edot                                    = 0x00117,
    edotaccent                              = 0x00117,
    edotbelow                               = 0x01EB9,
    eegurmukhi                              = 0x00A0F,
    eematragurmukhi                         = 0x00A47,
    efcyrillic                              = 0x00444,
    egrave                                  = 0x000E8,
    egujarati                               = 0x00A8F,
    eharmenian                              = 0x00567,
    ehbopomofo                              = 0x0311D,
    ehiragana                               = 0x03048,
    ehookabove                              = 0x01EBB,
    eibopomofo                              = 0x0311F,
    eight                                   = 0x00038,
    eightarabic                             = 0x00668,
    eightbengali                            = 0x009EE,
    eightcircle                             = 0x02467,
    eightcircleinversesansserif             = 0x02791,
    eightdeva                               = 0x0096E,
    eighteencircle                          = 0x02471,
    eighteenparen                           = 0x02485,
    eighteenperiod                          = 0x02499,
    eightgujarati                           = 0x00AEE,
    eightgurmukhi                           = 0x00A6E,
    eighthackarabic                         = 0x00668,
    eighthangzhou                           = 0x03028,
    eighthnotebeamed                        = 0x0266B,
    eightideographicparen                   = 0x03227,
    eightinferior                           = 0x02088,
    eightmonospace                          = 0x0FF18,
    eightoldstyle                           = 0x00038,
    eightparen                              = 0x0247B,
    eightperiod                             = 0x0248F,
    eightpersian                            = 0x006F8,
    eightroman                              = 0x02177,
    eightsuperior                           = 0x02078,
    eightthai                               = 0x00E58,
    einvertedbreve                          = 0x00207,
    eiotifiedcyrillic                       = 0x00465,
    ekatakana                               = 0x030A8,
    ekatakanahalfwidth                      = 0x0FF74,
    ekonkargurmukhi                         = 0x00A74,
    ekorean                                 = 0x03154,
    elcyrillic                              = 0x0043B,
    element                                 = 0x02208,
    elevencircle                            = 0x0246A,
    elevenparen                             = 0x0247E,
    elevenperiod                            = 0x02492,
    elevenroman                             = 0x0217A,
    ellipsis                                = 0x02026,
    ellipsisvertical                        = 0x022EE,
    emacron                                 = 0x00113,
    emacronacute                            = 0x01E17,
    emacrongrave                            = 0x01E15,
    emcyrillic                              = 0x0043C,
    emdash                                  = 0x02014,
    emdashvertical                          = 0x0FE31,
    emonospace                              = 0x0FF45,
    emphasismarkarmenian                    = 0x0055B,
    emptyset                                = 0x02205,
    enbopomofo                              = 0x03123,
    encyrillic                              = 0x0043D,
    endash                                  = 0x02013,
    endashvertical                          = 0x0FE32,
    endescendercyrillic                     = 0x004A3,
    eng                                     = 0x0014B,
    engbopomofo                             = 0x03125,
    enghecyrillic                           = 0x004A5,
    enhookcyrillic                          = 0x004C8,
    enspace                                 = 0x02002,
    eogonek                                 = 0x00119,
    eokorean                                = 0x03153,
    eopen                                   = 0x0025B,
    eopenclosed                             = 0x0029A,
    eopenreversed                           = 0x0025C,
    eopenreversedclosed                     = 0x0025E,
    eopenreversedhook                       = 0x0025D,
    eparen                                  = 0x024A0,
    epsilon                                 = 0x003B5,
    epsilontonos                            = 0x003AD,
    equal                                   = 0x0003D,
    equalmonospace                          = 0x0FF1D,
    equalsmall                              = 0x0FE66,
    equalsuperior                           = 0x0207C,
    equivalence                             = 0x02261,
    erbopomofo                              = 0x03126,
    ercyrillic                              = 0x00440,
    ereversed                               = 0x00258,
    ereversedcyrillic                       = 0x0044D,
    escyrillic                              = 0x00441,
    esdescendercyrillic                     = 0x004AB,
    esh                                     = 0x00283,
    eshcurl                                 = 0x00286,
    eshortdeva                              = 0x0090E,
    eshortvowelsigndeva                     = 0x00946,
    eshreversedloop                         = 0x001AA,
    eshsquatreversed                        = 0x00285,
    esmallhiragana                          = 0x03047,
    esmallkatakana                          = 0x030A7,
    esmallkatakanahalfwidth                 = 0x0FF6A,
    estimated                               = 0x0212E,
    eta                                     = 0x003B7,
    etarmenian                              = 0x00568,
    etatonos                                = 0x003AE,
    eth                                     = 0x000F0,
    etilde                                  = 0x01EBD,
    etildebelow                             = 0x01E1B,
    etnahtafoukhhebrew                      = 0x00591,
    etnahtafoukhlefthebrew                  = 0x00591,
    etnahtahebrew                           = 0x00591,
    etnahtalefthebrew                       = 0x00591,
    eturned                                 = 0x001DD,
    eukorean                                = 0x03161,
    euro                                    = 0x020AC,
    evowelsignbengali                       = 0x009C7,
    evowelsigndeva                          = 0x00947,
    evowelsigngujarati                      = 0x00AC7,
    exclam                                  = 0x00021,
    exclamarmenian                          = 0x0055C,
    exclamdbl                               = 0x0203C,
    exclamdown                              = 0x000A1,
    exclammonospace                         = 0x0FF01,
    existential                             = 0x02203,
    ezh                                     = 0x00292,
    ezhcaron                                = 0x001EF,
    ezhcurl                                 = 0x00293,
    ezhreversed                             = 0x001B9,
    ezhtail                                 = 0x001BA,
    f                                       = 0x00066,
    fadeva                                  = 0x0095E,
    fagurmukhi                              = 0x00A5E,
    fahrenheit                              = 0x02109,
    fathaarabic                             = 0x0064E,
    fathalowarabic                          = 0x0064E,
    fathatanarabic                          = 0x0064B,
    fbopomofo                               = 0x03108,
    fcircle                                 = 0x024D5,
    fdotaccent                              = 0x01E1F,
    feharabic                               = 0x00641,
    feharmenian                             = 0x00586,
    fehfinalarabic                          = 0x0FED2,
    fehinitialarabic                        = 0x0FED3,
    fehmedialarabic                         = 0x0FED4,
    feicoptic                               = 0x003E5,
    female                                  = 0x02640,
    ff                                      = 0x0FB00,
    ffi                                     = 0x0FB03,
    ffl                                     = 0x0FB04,
    fi                                      = 0x0FB01,
    fifteencircle                           = 0x0246E,
    fifteenparen                            = 0x02482,
    fifteenperiod                           = 0x02496,
    figuredash                              = 0x02012,
    filledbox                               = 0x025A0,
    filledrect                              = 0x025AC,
    finalkaf                                = 0x005DA,
    finalkafdagesh                          = 0x0FB3A,
    finalkafdageshhebrew                    = 0x0FB3A,
    finalkafhebrew                          = 0x005DA,
    finalkafqamats                          = 0x005DA,
    finalkafqamatshebrew                    = 0x005DA,
    finalkafsheva                           = 0x005DA,
    finalkafshevahebrew                     = 0x005DA,
    finalmem                                = 0x005DD,
    finalmemhebrew                          = 0x005DD,
    finalnun                                = 0x005DF,
    finalnunhebrew                          = 0x005DF,
    finalpe                                 = 0x005E3,
    finalpehebrew                           = 0x005E3,
    finaltsadi                              = 0x005E5,
    finaltsadihebrew                        = 0x005E5,
    firsttonechinese                        = 0x002C9,
    fisheye                                 = 0x025C9,
    fitacyrillic                            = 0x00473,
    five                                    = 0x00035,
    fivearabic                              = 0x00665,
    fivebengali                             = 0x009EB,
    fivecircle                              = 0x02464,
    fivecircleinversesansserif              = 0x0278E,
    fivedeva                                = 0x0096B,
    fiveeighths                             = 0x0215D,
    fivegujarati                            = 0x00AEB,
    fivegurmukhi                            = 0x00A6B,
    fivehackarabic                          = 0x00665,
    fivehangzhou                            = 0x03025,
    fiveideographicparen                    = 0x03224,
    fiveinferior                            = 0x02085,
    fivemonospace                           = 0x0FF15,
    fiveoldstyle                            = 0x00035,
    fiveparen                               = 0x02478,
    fiveperiod                              = 0x0248C,
    fivepersian                             = 0x006F5,
    fiveroman                               = 0x02174,
    fivesuperior                            = 0x02075,
    fivethai                                = 0x00E55,
    fl                                      = 0x0FB02,
    florin                                  = 0x00192,
    fmonospace                              = 0x0FF46,
    fmsquare                                = 0x03399,
    fofanthai                               = 0x00E1F,
    fofathai                                = 0x00E1D,
    fongmanthai                             = 0x00E4F,
    forall                                  = 0x02200,
    four                                    = 0x00034,
    fourarabic                              = 0x00664,
    fourbengali                             = 0x009EA,
    fourcircle                              = 0x02463,
    fourcircleinversesansserif              = 0x0278D,
    fourdeva                                = 0x0096A,
    fourgujarati                            = 0x00AEA,
    fourgurmukhi                            = 0x00A6A,
    fourhackarabic                          = 0x00664,
    fourhangzhou                            = 0x03024,
    fourideographicparen                    = 0x03223,
    fourinferior                            = 0x02084,
    fourmonospace                           = 0x0FF14,
    fournumeratorbengali                    = 0x009F7,
    fouroldstyle                            = 0x00034,
    fourparen                               = 0x02477,
    fourperiod                              = 0x0248B,
    fourpersian                             = 0x006F4,
    fourroman                               = 0x02173,
    foursuperior                            = 0x02074,
    fourteencircle                          = 0x0246D,
    fourteenparen                           = 0x02481,
    fourteenperiod                          = 0x02495,
    fourthai                                = 0x00E54,
    fourthtonechinese                       = 0x002CB,
    fparen                                  = 0x024A1,
    fraction                                = 0x02044,
    franc                                   = 0x020A3,
    g                                       = 0x00067,
    gabengali                               = 0x00997,
    gacute                                  = 0x001F5,
    gadeva                                  = 0x00917,
    gafarabic                               = 0x006AF,
    gaffinalarabic                          = 0x0FB93,
    gafinitialarabic                        = 0x0FB94,
    gafmedialarabic                         = 0x0FB95,
    gagujarati                              = 0x00A97,
    gagurmukhi                              = 0x00A17,
    gahiragana                              = 0x0304C,
    gakatakana                              = 0x030AC,
    gamma                                   = 0x003B3,
    gammalatinsmall                         = 0x00263,
    gammasuperior                           = 0x002E0,
    gangiacoptic                            = 0x003EB,
    gbopomofo                               = 0x0310D,
    gbreve                                  = 0x0011F,
    gcaron                                  = 0x001E7,
    gcedilla                                = 0x00123,
    gcircle                                 = 0x024D6,
    gcircumflex                             = 0x0011D,
    gcommaaccent                            = 0x00123,
    gdot                                    = 0x00121,
    gdotaccent                              = 0x00121,
    gecyrillic                              = 0x00433,
    gehiragana                              = 0x03052,
    gekatakana                              = 0x030B2,
    geometricallyequal                      = 0x02251,
    gereshaccenthebrew                      = 0x0059C,
    gereshhebrew                            = 0x005F3,
    gereshmuqdamhebrew                      = 0x0059D,
    germandbls                              = 0x000DF,
    gershayimaccenthebrew                   = 0x0059E,
    gershayimhebrew                         = 0x005F4,
    getamark                                = 0x03013,
    ghabengali                              = 0x00998,
    ghadarmenian                            = 0x00572,
    ghadeva                                 = 0x00918,
    ghagujarati                             = 0x00A98,
    ghagurmukhi                             = 0x00A18,
    ghainarabic                             = 0x0063A,
    ghainfinalarabic                        = 0x0FECE,
    ghaininitialarabic                      = 0x0FECF,
    ghainmedialarabic                       = 0x0FED0,
    ghemiddlehookcyrillic                   = 0x00495,
    ghestrokecyrillic                       = 0x00493,
    gheupturncyrillic                       = 0x00491,
    ghhadeva                                = 0x0095A,
    ghhagurmukhi                            = 0x00A5A,
    ghook                                   = 0x00260,
    ghzsquare                               = 0x03393,
    gihiragana                              = 0x0304E,
    gikatakana                              = 0x030AE,
    gimarmenian                             = 0x00563,
    gimel                                   = 0x005D2,
    gimeldagesh                             = 0x0FB32,
    gimeldageshhebrew                       = 0x0FB32,
    gimelhebrew                             = 0x005D2,
    gjecyrillic                             = 0x00453,
    glottalinvertedstroke                   = 0x001BE,
    glottalstop                             = 0x00294,
    glottalstopinverted                     = 0x00296,
    glottalstopmod                          = 0x002C0,
    glottalstopreversed                     = 0x00295,
    glottalstopreversedmod                  = 0x002C1,
    glottalstopreversedsuperior             = 0x002E4,
    glottalstopstroke                       = 0x002A1,
    glottalstopstrokereversed               = 0x002A2,
    gmacron                                 = 0x01E21,
    gmonospace                              = 0x0FF47,
    gohiragana                              = 0x03054,
    gokatakana                              = 0x030B4,
    gparen                                  = 0x024A2,
    gpasquare                               = 0x033AC,
    gradient                                = 0x02207,
    grave                                   = 0x00060,
    gravebelowcmb                           = 0x00316,
    gravecmb                                = 0x00300,
    gravecomb                               = 0x00300,
    gravedeva                               = 0x00953,
    gravelowmod                             = 0x002CE,
    gravemonospace                          = 0x0FF40,
    gravetonecmb                            = 0x00340,
    greater                                 = 0x0003E,
    greaterequal                            = 0x02265,
    greaterequalorless                      = 0x022DB,
    greatermonospace                        = 0x0FF1E,
    greaterorequivalent                     = 0x02273,
    greaterorless                           = 0x02277,
    greateroverequal                        = 0x02267,
    greatersmall                            = 0x0FE65,
    gscript                                 = 0x00261,
    gstroke                                 = 0x001E5,
    guhiragana                              = 0x03050,
    guillemotleft                           = 0x000AB,
    guillemotright                          = 0x000BB,
    guilsinglleft                           = 0x02039,
    guilsinglright                          = 0x0203A,
    gukatakana                              = 0x030B0,
    guramusquare                            = 0x03318,
    gysquare                                = 0x033C9,
    h                                       = 0x00068,
    haabkhasiancyrillic                     = 0x004A9,
    haaltonearabic                          = 0x006C1,
    habengali                               = 0x009B9,
    hadescendercyrillic                     = 0x004B3,
    hadeva                                  = 0x00939,
    hagujarati                              = 0x00AB9,
    hagurmukhi                              = 0x00A39,
    haharabic                               = 0x0062D,
    hahfinalarabic                          = 0x0FEA2,
    hahinitialarabic                        = 0x0FEA3,
    hahiragana                              = 0x0306F,
    hahmedialarabic                         = 0x0FEA4,
    haitusquare                             = 0x0332A,
    hakatakana                              = 0x030CF,
    hakatakanahalfwidth                     = 0x0FF8A,
    halantgurmukhi                          = 0x00A4D,
    hamzaarabic                             = 0x00621,
    hamzadammaarabic                        = 0x00621,
    hamzadammatanarabic                     = 0x00621,
    hamzafathaarabic                        = 0x00621,
    hamzafathatanarabic                     = 0x00621,
    hamzalowarabic                          = 0x00621,
    hamzalowkasraarabic                     = 0x00621,
    hamzalowkasratanarabic                  = 0x00621,
    hamzasukunarabic                        = 0x00621,
    hangulfiller                            = 0x03164,
    hardsigncyrillic                        = 0x0044A,
    harpoonleftbarbup                       = 0x021BC,
    harpoonrightbarbup                      = 0x021C0,
    hasquare                                = 0x033CA,
    hatafpatah                              = 0x005B2,
    hatafpatah16                            = 0x005B2,
    hatafpatah23                            = 0x005B2,
    hatafpatah2f                            = 0x005B2,
    hatafpatahhebrew                        = 0x005B2,
    hatafpatahnarrowhebrew                  = 0x005B2,
    hatafpatahquarterhebrew                 = 0x005B2,
    hatafpatahwidehebrew                    = 0x005B2,
    hatafqamats                             = 0x005B3,
    hatafqamats1b                           = 0x005B3,
    hatafqamats28                           = 0x005B3,
    hatafqamats34                           = 0x005B3,
    hatafqamatshebrew                       = 0x005B3,
    hatafqamatsnarrowhebrew                 = 0x005B3,
    hatafqamatsquarterhebrew                = 0x005B3,
    hatafqamatswidehebrew                   = 0x005B3,
    hatafsegol                              = 0x005B1,
    hatafsegol17                            = 0x005B1,
    hatafsegol24                            = 0x005B1,
    hatafsegol30                            = 0x005B1,
    hatafsegolhebrew                        = 0x005B1,
    hatafsegolnarrowhebrew                  = 0x005B1,
    hatafsegolquarterhebrew                 = 0x005B1,
    hatafsegolwidehebrew                    = 0x005B1,
    hbar                                    = 0x00127,
    hbopomofo                               = 0x0310F,
    hbrevebelow                             = 0x01E2B,
    hcedilla                                = 0x01E29,
    hcircle                                 = 0x024D7,
    hcircumflex                             = 0x00125,
    hdieresis                               = 0x01E27,
    hdotaccent                              = 0x01E23,
    hdotbelow                               = 0x01E25,
    he                                      = 0x005D4,
    heart                                   = 0x02665,
    heartsuitblack                          = 0x02665,
    heartsuitwhite                          = 0x02661,
    hedagesh                                = 0x0FB34,
    hedageshhebrew                          = 0x0FB34,
    hehaltonearabic                         = 0x006C1,
    heharabic                               = 0x00647,
    hehebrew                                = 0x005D4,
    hehfinalaltonearabic                    = 0x0FBA7,
    hehfinalalttwoarabic                    = 0x0FEEA,
    hehfinalarabic                          = 0x0FEEA,
    hehhamzaabovefinalarabic                = 0x0FBA5,
    hehhamzaaboveisolatedarabic             = 0x0FBA4,
    hehinitialaltonearabic                  = 0x0FBA8,
    hehinitialarabic                        = 0x0FEEB,
    hehiragana                              = 0x03078,
    hehmedialaltonearabic                   = 0x0FBA9,
    hehmedialarabic                         = 0x0FEEC,
    heiseierasquare                         = 0x0337B,
    hekatakana                              = 0x030D8,
    hekatakanahalfwidth                     = 0x0FF8D,
    hekutaarusquare                         = 0x03336,
    henghook                                = 0x00267,
    herutusquare                            = 0x03339,
    het                                     = 0x005D7,
    hethebrew                               = 0x005D7,
    hhook                                   = 0x00266,
    hhooksuperior                           = 0x002B1,
    hieuhacirclekorean                      = 0x0327B,
    hieuhaparenkorean                       = 0x0321B,
    hieuhcirclekorean                       = 0x0326D,
    hieuhkorean                             = 0x0314E,
    hieuhparenkorean                        = 0x0320D,
    hihiragana                              = 0x03072,
    hikatakana                              = 0x030D2,
    hikatakanahalfwidth                     = 0x0FF8B,
    hiriq                                   = 0x005B4,
    hiriq14                                 = 0x005B4,
    hiriq21                                 = 0x005B4,
    hiriq2d                                 = 0x005B4,
    hiriqhebrew                             = 0x005B4,
    hiriqnarrowhebrew                       = 0x005B4,
    hiriqquarterhebrew                      = 0x005B4,
    hiriqwidehebrew                         = 0x005B4,
    hlinebelow                              = 0x01E96,
    hmonospace                              = 0x0FF48,
    hoarmenian                              = 0x00570,
    hohipthai                               = 0x00E2B,
    hohiragana                              = 0x0307B,
    hokatakana                              = 0x030DB,
    hokatakanahalfwidth                     = 0x0FF8E,
    holam                                   = 0x005B9,
    holam19                                 = 0x005B9,
    holam26                                 = 0x005B9,
    holam32                                 = 0x005B9,
    holamhebrew                             = 0x005B9,
    holamnarrowhebrew                       = 0x005B9,
    holamquarterhebrew                      = 0x005B9,
    holamwidehebrew                         = 0x005B9,
    honokhukthai                            = 0x00E2E,
    hookabovecomb                           = 0x00309,
    hookcmb                                 = 0x00309,
    hookpalatalizedbelowcmb                 = 0x00321,
    hookretroflexbelowcmb                   = 0x00322,
    hoonsquare                              = 0x03342,
    horicoptic                              = 0x003E9,
    horizontalbar                           = 0x02015,
    horncmb                                 = 0x0031B,
    hotsprings                              = 0x02668,
    house                                   = 0x02302,
    hparen                                  = 0x024A3,
    hsuperior                               = 0x002B0,
    hturned                                 = 0x00265,
    huhiragana                              = 0x03075,
    huiitosquare                            = 0x03333,
    hukatakana                              = 0x030D5,
    hukatakanahalfwidth                     = 0x0FF8C,
    hungarumlaut                            = 0x002DD,
    hungarumlautcmb                         = 0x0030B,
    hv                                      = 0x00195,
    hyphen                                  = 0x0002D,
    hyphenmonospace                         = 0x0FF0D,
    hyphensmall                             = 0x0FE63,
    hyphentwo                               = 0x02010,
    i                                       = 0x00069,
    iacute                                  = 0x000ED,
    iacyrillic                              = 0x0044F,
    ibengali                                = 0x00987,
    ibopomofo                               = 0x03127,
    ibreve                                  = 0x0012D,
    icaron                                  = 0x001D0,
    icircle                                 = 0x024D8,
    icircumflex                             = 0x000EE,
    icyrillic                               = 0x00456,
    idblgrave                               = 0x00209,
    ideographearthcircle                    = 0x0328F,
    ideographfirecircle                     = 0x0328B,
    ideographicallianceparen                = 0x0323F,
    ideographiccallparen                    = 0x0323A,
    ideographiccentrecircle                 = 0x032A5,
    ideographicclose                        = 0x03006,
    ideographiccomma                        = 0x03001,
    ideographiccommaleft                    = 0x0FF64,
    ideographiccongratulationparen          = 0x03237,
    ideographiccorrectcircle                = 0x032A3,
    ideographicearthparen                   = 0x0322F,
    ideographicenterpriseparen              = 0x0323D,
    ideographicexcellentcircle              = 0x0329D,
    ideographicfestivalparen                = 0x03240,
    ideographicfinancialcircle              = 0x03296,
    ideographicfinancialparen               = 0x03236,
    ideographicfireparen                    = 0x0322B,
    ideographichaveparen                    = 0x03232,
    ideographichighcircle                   = 0x032A4,
    ideographiciterationmark                = 0x03005,
    ideographiclaborcircle                  = 0x03298,
    ideographiclaborparen                   = 0x03238,
    ideographicleftcircle                   = 0x032A7,
    ideographiclowcircle                    = 0x032A6,
    ideographicmedicinecircle               = 0x032A9,
    ideographicmetalparen                   = 0x0322E,
    ideographicmoonparen                    = 0x0322A,
    ideographicnameparen                    = 0x03234,
    ideographicperiod                       = 0x03002,
    ideographicprintcircle                  = 0x0329E,
    ideographicreachparen                   = 0x03243,
    ideographicrepresentparen               = 0x03239,
    ideographicresourceparen                = 0x0323E,
    ideographicrightcircle                  = 0x032A8,
    ideographicsecretcircle                 = 0x03299,
    ideographicselfparen                    = 0x03242,
    ideographicsocietyparen                 = 0x03233,
    ideographicspace                        = 0x03000,
    ideographicspecialparen                 = 0x03235,
    ideographicstockparen                   = 0x03231,
    ideographicstudyparen                   = 0x0323B,
    ideographicsunparen                     = 0x03230,
    ideographicsuperviseparen               = 0x0323C,
    ideographicwaterparen                   = 0x0322C,
    ideographicwoodparen                    = 0x0322D,
    ideographiczero                         = 0x03007,
    ideographmetalcircle                    = 0x0328E,
    ideographmooncircle                     = 0x0328A,
    ideographnamecircle                     = 0x03294,
    ideographsuncircle                      = 0x03290,
    ideographwatercircle                    = 0x0328C,
    ideographwoodcircle                     = 0x0328D,
    ideva                                   = 0x00907,
    idieresis                               = 0x000EF,
    idieresisacute                          = 0x01E2F,
    idieresiscyrillic                       = 0x004E5,
    idotbelow                               = 0x01ECB,
    iebrevecyrillic                         = 0x004D7,
    iecyrillic                              = 0x00435,
    ieungacirclekorean                      = 0x03275,
    ieungaparenkorean                       = 0x03215,
    ieungcirclekorean                       = 0x03267,
    ieungkorean                             = 0x03147,
    ieungparenkorean                        = 0x03207,
    igrave                                  = 0x000EC,
    igujarati                               = 0x00A87,
    igurmukhi                               = 0x00A07,
    ihiragana                               = 0x03044,
    ihookabove                              = 0x01EC9,
    iibengali                               = 0x00988,
    iicyrillic                              = 0x00438,
    iideva                                  = 0x00908,
    iigujarati                              = 0x00A88,
    iigurmukhi                              = 0x00A08,
    iimatragurmukhi                         = 0x00A40,
    iinvertedbreve                          = 0x0020B,
    iishortcyrillic                         = 0x00439,
    iivowelsignbengali                      = 0x009C0,
    iivowelsigndeva                         = 0x00940,
    iivowelsigngujarati                     = 0x00AC0,
    ij                                      = 0x00133,
    ikatakana                               = 0x030A4,
    ikatakanahalfwidth                      = 0x0FF72,
    ikorean                                 = 0x03163,
    ilde                                    = 0x002DC,
    iluyhebrew                              = 0x005AC,
    imacron                                 = 0x0012B,
    imacroncyrillic                         = 0x004E3,
    imageorapproximatelyequal               = 0x02253,
    imatragurmukhi                          = 0x00A3F,
    imonospace                              = 0x0FF49,
    increment                               = 0x02206,
    infinity                                = 0x0221E,
    iniarmenian                             = 0x0056B,
    integral                                = 0x0222B,
    integralbottom                          = 0x02321,
    integralbt                              = 0x02321,
    integraltop                             = 0x02320,
    integraltp                              = 0x02320,
    intersection                            = 0x02229,
    intisquare                              = 0x03305,
    invbullet                               = 0x025D8,
    invcircle                               = 0x025D9,
    invsmileface                            = 0x0263B,
    iocyrillic                              = 0x00451,
    iogonek                                 = 0x0012F,
    iota                                    = 0x003B9,
    iotadieresis                            = 0x003CA,
    iotadieresistonos                       = 0x00390,
    iotalatin                               = 0x00269,
    iotatonos                               = 0x003AF,
    iparen                                  = 0x024A4,
    irigurmukhi                             = 0x00A72,
    ismallhiragana                          = 0x03043,
    ismallkatakana                          = 0x030A3,
    ismallkatakanahalfwidth                 = 0x0FF68,
    issharbengali                           = 0x009FA,
    istroke                                 = 0x00268,
    iterationhiragana                       = 0x0309D,
    iterationkatakana                       = 0x030FD,
    itilde                                  = 0x00129,
    itildebelow                             = 0x01E2D,
    iubopomofo                              = 0x03129,
    iucyrillic                              = 0x0044E,
    ivowelsignbengali                       = 0x009BF,
    ivowelsigndeva                          = 0x0093F,
    ivowelsigngujarati                      = 0x00ABF,
    izhitsacyrillic                         = 0x00475,
    izhitsadblgravecyrillic                 = 0x00477,
    j                                       = 0x0006A,
    jaarmenian                              = 0x00571,
    jabengali                               = 0x0099C,
    jadeva                                  = 0x0091C,
    jagujarati                              = 0x00A9C,
    jagurmukhi                              = 0x00A1C,
    jbopomofo                               = 0x03110,
    jcaron                                  = 0x001F0,
    jcircle                                 = 0x024D9,
    jcircumflex                             = 0x00135,
    jcrossedtail                            = 0x0029D,
    jdotlessstroke                          = 0x0025F,
    jecyrillic                              = 0x00458,
    jeemarabic                              = 0x0062C,
    jeemfinalarabic                         = 0x0FE9E,
    jeeminitialarabic                       = 0x0FE9F,
    jeemmedialarabic                        = 0x0FEA0,
    jeharabic                               = 0x00698,
    jehfinalarabic                          = 0x0FB8B,
    jhabengali                              = 0x0099D,
    jhadeva                                 = 0x0091D,
    jhagujarati                             = 0x00A9D,
    jhagurmukhi                             = 0x00A1D,
    jheharmenian                            = 0x0057B,
    jis                                     = 0x03004,
    jmonospace                              = 0x0FF4A,
    jparen                                  = 0x024A5,
    jsuperior                               = 0x002B2,
    k                                       = 0x0006B,
    kabashkircyrillic                       = 0x004A1,
    kabengali                               = 0x00995,
    kacute                                  = 0x01E31,
    kacyrillic                              = 0x0043A,
    kadescendercyrillic                     = 0x0049B,
    kadeva                                  = 0x00915,
    kaf                                     = 0x005DB,
    kafarabic                               = 0x00643,
    kafdagesh                               = 0x0FB3B,
    kafdageshhebrew                         = 0x0FB3B,
    kaffinalarabic                          = 0x0FEDA,
    kafhebrew                               = 0x005DB,
    kafinitialarabic                        = 0x0FEDB,
    kafmedialarabic                         = 0x0FEDC,
    kafrafehebrew                           = 0x0FB4D,
    kagujarati                              = 0x00A95,
    kagurmukhi                              = 0x00A15,
    kahiragana                              = 0x0304B,
    kahookcyrillic                          = 0x004C4,
    kakatakana                              = 0x030AB,
    kakatakanahalfwidth                     = 0x0FF76,
    kappa                                   = 0x003BA,
    kappasymbolgreek                        = 0x003F0,
    kapyeounmieumkorean                     = 0x03171,
    kapyeounphieuphkorean                   = 0x03184,
    kapyeounpieupkorean                     = 0x03178,
    kapyeounssangpieupkorean                = 0x03179,
    karoriisquare                           = 0x0330D,
    kashidaautoarabic                       = 0x00640,
    kashidaautonosidebearingarabic          = 0x00640,
    kasmallkatakana                         = 0x030F5,
    kasquare                                = 0x03384,
    kasraarabic                             = 0x00650,
    kasratanarabic                          = 0x0064D,
    kastrokecyrillic                        = 0x0049F,
    katahiraprolongmarkhalfwidth            = 0x0FF70,
    kaverticalstrokecyrillic                = 0x0049D,
    kbopomofo                               = 0x0310E,
    kcalsquare                              = 0x03389,
    kcaron                                  = 0x001E9,
    kcedilla                                = 0x00137,
    kcircle                                 = 0x024DA,
    kcommaaccent                            = 0x00137,
    kdotbelow                               = 0x01E33,
    keharmenian                             = 0x00584,
    kehiragana                              = 0x03051,
    kekatakana                              = 0x030B1,
    kekatakanahalfwidth                     = 0x0FF79,
    kenarmenian                             = 0x0056F,
    kesmallkatakana                         = 0x030F6,
    kgreenlandic                            = 0x00138,
    khabengali                              = 0x00996,
    khacyrillic                             = 0x00445,
    khadeva                                 = 0x00916,
    khagujarati                             = 0x00A96,
    khagurmukhi                             = 0x00A16,
    khaharabic                              = 0x0062E,
    khahfinalarabic                         = 0x0FEA6,
    khahinitialarabic                       = 0x0FEA7,
    khahmedialarabic                        = 0x0FEA8,
    kheicoptic                              = 0x003E7,
    khhadeva                                = 0x00959,
    khhagurmukhi                            = 0x00A59,
    khieukhacirclekorean                    = 0x03278,
    khieukhaparenkorean                     = 0x03218,
    khieukhcirclekorean                     = 0x0326A,
    khieukhkorean                           = 0x0314B,
    khieukhparenkorean                      = 0x0320A,
    khokhaithai                             = 0x00E02,
    khokhonthai                             = 0x00E05,
    khokhuatthai                            = 0x00E03,
    khokhwaithai                            = 0x00E04,
    khomutthai                              = 0x00E5B,
    khook                                   = 0x00199,
    khorakhangthai                          = 0x00E06,
    khzsquare                               = 0x03391,
    kihiragana                              = 0x0304D,
    kikatakana                              = 0x030AD,
    kikatakanahalfwidth                     = 0x0FF77,
    kiroguramusquare                        = 0x03315,
    kiromeetorusquare                       = 0x03316,
    kirosquare                              = 0x03314,
    kiyeokacirclekorean                     = 0x0326E,
    kiyeokaparenkorean                      = 0x0320E,
    kiyeokcirclekorean                      = 0x03260,
    kiyeokkorean                            = 0x03131,
    kiyeokparenkorean                       = 0x03200,
    kiyeoksioskorean                        = 0x03133,
    kjecyrillic                             = 0x0045C,
    klinebelow                              = 0x01E35,
    klsquare                                = 0x03398,
    kmcubedsquare                           = 0x033A6,
    kmonospace                              = 0x0FF4B,
    kmsquaredsquare                         = 0x033A2,
    kohiragana                              = 0x03053,
    kohmsquare                              = 0x033C0,
    kokaithai                               = 0x00E01,
    kokatakana                              = 0x030B3,
    kokatakanahalfwidth                     = 0x0FF7A,
    kooposquare                             = 0x0331E,
    koppacyrillic                           = 0x00481,
    koreanstandardsymbol                    = 0x0327F,
    koroniscmb                              = 0x00343,
    kparen                                  = 0x024A6,
    kpasquare                               = 0x033AA,
    ksicyrillic                             = 0x0046F,
    ktsquare                                = 0x033CF,
    kturned                                 = 0x0029E,
    kuhiragana                              = 0x0304F,
    kukatakana                              = 0x030AF,
    kukatakanahalfwidth                     = 0x0FF78,
    kvsquare                                = 0x033B8,
    kwsquare                                = 0x033BE,
    l                                       = 0x0006C,
    labengali                               = 0x009B2,
    lacute                                  = 0x0013A,
    ladeva                                  = 0x00932,
    lagujarati                              = 0x00AB2,
    lagurmukhi                              = 0x00A32,
    lakkhangyaothai                         = 0x00E45,
    lamaleffinalarabic                      = 0x0FEFC,
    lamalefhamzaabovefinalarabic            = 0x0FEF8,
    lamalefhamzaaboveisolatedarabic         = 0x0FEF7,
    lamalefhamzabelowfinalarabic            = 0x0FEFA,
    lamalefhamzabelowisolatedarabic         = 0x0FEF9,
    lamalefisolatedarabic                   = 0x0FEFB,
    lamalefmaddaabovefinalarabic            = 0x0FEF6,
    lamalefmaddaaboveisolatedarabic         = 0x0FEF5,
    lamarabic                               = 0x00644,
    lambda                                  = 0x003BB,
    lambdastroke                            = 0x0019B,
    lamed                                   = 0x005DC,
    lameddagesh                             = 0x0FB3C,
    lameddageshhebrew                       = 0x0FB3C,
    lamedhebrew                             = 0x005DC,
    lamedholam                              = 0x005DC,
    lamedholamdagesh                        = 0x005DC,
    lamedholamdageshhebrew                  = 0x005DC,
    lamedholamhebrew                        = 0x005DC,
    lamfinalarabic                          = 0x0FEDE,
    lamhahinitialarabic                     = 0x0FCCA,
    laminitialarabic                        = 0x0FEDF,
    lamjeeminitialarabic                    = 0x0FCC9,
    lamkhahinitialarabic                    = 0x0FCCB,
    lamlamhehisolatedarabic                 = 0x0FDF2,
    lammedialarabic                         = 0x0FEE0,
    lammeemhahinitialarabic                 = 0x0FD88,
    lammeeminitialarabic                    = 0x0FCCC,
    lammeemjeeminitialarabic                = 0x0FEDF,
    lammeemkhahinitialarabic                = 0x0FEDF,
    largecircle                             = 0x025EF,
    lbar                                    = 0x0019A,
    lbelt                                   = 0x0026C,
    lbopomofo                               = 0x0310C,
    lcaron                                  = 0x0013E,
    lcedilla                                = 0x0013C,
    lcircle                                 = 0x024DB,
    lcircumflexbelow                        = 0x01E3D,
    lcommaaccent                            = 0x0013C,
    ldot                                    = 0x00140,
    ldotaccent                              = 0x00140,
    ldotbelow                               = 0x01E37,
    ldotbelowmacron                         = 0x01E39,
    leftangleabovecmb                       = 0x0031A,
    lefttackbelowcmb                        = 0x00318,
    less                                    = 0x0003C,
    lessequal                               = 0x02264,
    lessequalorgreater                      = 0x022DA,
    lessmonospace                           = 0x0FF1C,
    lessorequivalent                        = 0x02272,
    lessorgreater                           = 0x02276,
    lessoverequal                           = 0x02266,
    lesssmall                               = 0x0FE64,
    lezh                                    = 0x0026E,
    lfblock                                 = 0x0258C,
    lhookretroflex                          = 0x0026D,
    lira                                    = 0x020A4,
    liwnarmenian                            = 0x0056C,
    lj                                      = 0x001C9,
    ljecyrillic                             = 0x00459,
    lladeva                                 = 0x00933,
    llagujarati                             = 0x00AB3,
    llinebelow                              = 0x01E3B,
    llladeva                                = 0x00934,
    llvocalicbengali                        = 0x009E1,
    llvocalicdeva                           = 0x00961,
    llvocalicvowelsignbengali               = 0x009E3,
    llvocalicvowelsigndeva                  = 0x00963,
    lmiddletilde                            = 0x0026B,
    lmonospace                              = 0x0FF4C,
    lmsquare                                = 0x033D0,
    lochulathai                             = 0x00E2C,
    logicaland                              = 0x02227,
    logicalnot                              = 0x000AC,
    logicalnotreversed                      = 0x02310,
    logicalor                               = 0x02228,
    lolingthai                              = 0x00E25,
    longs                                   = 0x0017F,
    lowlinecenterline                       = 0x0FE4E,
    lowlinecmb                              = 0x00332,
    lowlinedashed                           = 0x0FE4D,
    lozenge                                 = 0x025CA,
    lparen                                  = 0x024A7,
    lslash                                  = 0x00142,
    lsquare                                 = 0x02113,
    ltshade                                 = 0x02591,
    luthai                                  = 0x00E26,
    lvocalicbengali                         = 0x0098C,
    lvocalicdeva                            = 0x0090C,
    lvocalicvowelsignbengali                = 0x009E2,
    lvocalicvowelsigndeva                   = 0x00962,
    lxsquare                                = 0x033D3,
    m                                       = 0x0006D,
    mabengali                               = 0x009AE,
    macron                                  = 0x000AF,
    macronbelowcmb                          = 0x00331,
    macroncmb                               = 0x00304,
    macronlowmod                            = 0x002CD,
    macronmonospace                         = 0x0FFE3,
    macute                                  = 0x01E3F,
    madeva                                  = 0x0092E,
    magujarati                              = 0x00AAE,
    magurmukhi                              = 0x00A2E,
    mahapakhhebrew                          = 0x005A4,
    mahapakhlefthebrew                      = 0x005A4,
    mahiragana                              = 0x0307E,
    maichattawathai                         = 0x00E4B,
    maiekthai                               = 0x00E48,
    maihanakatthai                          = 0x00E31,
    maitaikhuthai                           = 0x00E47,
    maithothai                              = 0x00E49,
    maitrithai                              = 0x00E4A,
    maiyamokthai                            = 0x00E46,
    makatakana                              = 0x030DE,
    makatakanahalfwidth                     = 0x0FF8F,
    male                                    = 0x02642,
    mansyonsquare                           = 0x03347,
    maqafhebrew                             = 0x005BE,
    mars                                    = 0x02642,
    masoracirclehebrew                      = 0x005AF,
    masquare                                = 0x03383,
    mbopomofo                               = 0x03107,
    mbsquare                                = 0x033D4,
    mcircle                                 = 0x024DC,
    mcubedsquare                            = 0x033A5,
    mdotaccent                              = 0x01E41,
    mdotbelow                               = 0x01E43,
    meemarabic                              = 0x00645,
    meemfinalarabic                         = 0x0FEE2,
    meeminitialarabic                       = 0x0FEE3,
    meemmedialarabic                        = 0x0FEE4,
    meemmeeminitialarabic                   = 0x0FCD1,
    meemmeemisolatedarabic                  = 0x0FC48,
    meetorusquare                           = 0x0334D,
    mehiragana                              = 0x03081,
    meizierasquare                          = 0x0337E,
    mekatakana                              = 0x030E1,
    mekatakanahalfwidth                     = 0x0FF92,
    mem                                     = 0x005DE,
    memdagesh                               = 0x0FB3E,
    memdageshhebrew                         = 0x0FB3E,
    memhebrew                               = 0x005DE,
    menarmenian                             = 0x00574,
    merkhahebrew                            = 0x005A5,
    merkhakefulahebrew                      = 0x005A6,
    merkhakefulalefthebrew                  = 0x005A6,
    merkhalefthebrew                        = 0x005A5,
    mhook                                   = 0x00271,
    mhzsquare                               = 0x03392,
    middledotkatakanahalfwidth              = 0x0FF65,
    middot                                  = 0x000B7,
    mieumacirclekorean                      = 0x03272,
    mieumaparenkorean                       = 0x03212,
    mieumcirclekorean                       = 0x03264,
    mieumkorean                             = 0x03141,
    mieumpansioskorean                      = 0x03170,
    mieumparenkorean                        = 0x03204,
    mieumpieupkorean                        = 0x0316E,
    mieumsioskorean                         = 0x0316F,
    mihiragana                              = 0x0307F,
    mikatakana                              = 0x030DF,
    mikatakanahalfwidth                     = 0x0FF90,
    minus                                   = 0x02212,
    minusbelowcmb                           = 0x00320,
    minuscircle                             = 0x02296,
    minusmod                                = 0x002D7,
    minusplus                               = 0x02213,
    minute                                  = 0x02032,
    miribaarusquare                         = 0x0334A,
    mirisquare                              = 0x03349,
    mlonglegturned                          = 0x00270,
    mlsquare                                = 0x03396,
    mmcubedsquare                           = 0x033A3,
    mmonospace                              = 0x0FF4D,
    mmsquaredsquare                         = 0x0339F,
    mohiragana                              = 0x03082,
    mohmsquare                              = 0x033C1,
    mokatakana                              = 0x030E2,
    mokatakanahalfwidth                     = 0x0FF93,
    molsquare                               = 0x033D6,
    momathai                                = 0x00E21,
    moverssquare                            = 0x033A7,
    moverssquaredsquare                     = 0x033A8,
    mparen                                  = 0x024A8,
    mpasquare                               = 0x033AB,
    mssquare                                = 0x033B3,
    mturned                                 = 0x0026F,
    mu                                      = 0x000B5,
    mu1                                     = 0x000B5,
    muasquare                               = 0x03382,
    muchgreater                             = 0x0226B,
    muchless                                = 0x0226A,
    mufsquare                               = 0x0338C,
    mugreek                                 = 0x003BC,
    mugsquare                               = 0x0338D,
    muhiragana                              = 0x03080,
    mukatakana                              = 0x030E0,
    mukatakanahalfwidth                     = 0x0FF91,
    mulsquare                               = 0x03395,
    multiply                                = 0x000D7,
    mumsquare                               = 0x0339B,
    munahhebrew                             = 0x005A3,
    munahlefthebrew                         = 0x005A3,
    musicalnote                             = 0x0266A,
    musicalnotedbl                          = 0x0266B,
    musicflatsign                           = 0x0266D,
    musicsharpsign                          = 0x0266F,
    mussquare                               = 0x033B2,
    muvsquare                               = 0x033B6,
    muwsquare                               = 0x033BC,
    mvmegasquare                            = 0x033B9,
    mvsquare                                = 0x033B7,
    mwmegasquare                            = 0x033BF,
    mwsquare                                = 0x033BD,
    n                                       = 0x0006E,
    nabengali                               = 0x009A8,
    nabla                                   = 0x02207,
    nacute                                  = 0x00144,
    nadeva                                  = 0x00928,
    nagujarati                              = 0x00AA8,
    nagurmukhi                              = 0x00A28,
    nahiragana                              = 0x0306A,
    nakatakana                              = 0x030CA,
    nakatakanahalfwidth                     = 0x0FF85,
    napostrophe                             = 0x00149,
    nasquare                                = 0x03381,
    nbopomofo                               = 0x0310B,
    nbspace                                 = 0x000A0,
    ncaron                                  = 0x00148,
    ncedilla                                = 0x00146,
    ncircle                                 = 0x024DD,
    ncircumflexbelow                        = 0x01E4B,
    ncommaaccent                            = 0x00146,
    ndotaccent                              = 0x01E45,
    ndotbelow                               = 0x01E47,
    nehiragana                              = 0x0306D,
    nekatakana                              = 0x030CD,
    nekatakanahalfwidth                     = 0x0FF88,
    newsheqelsign                           = 0x020AA,
    nfsquare                                = 0x0338B,
    ngabengali                              = 0x00999,
    ngadeva                                 = 0x00919,
    ngagujarati                             = 0x00A99,
    ngagurmukhi                             = 0x00A19,
    ngonguthai                              = 0x00E07,
    nhiragana                               = 0x03093,
    nhookleft                               = 0x00272,
    nhookretroflex                          = 0x00273,
    nieunacirclekorean                      = 0x0326F,
    nieunaparenkorean                       = 0x0320F,
    nieuncieuckorean                        = 0x03135,
    nieuncirclekorean                       = 0x03261,
    nieunhieuhkorean                        = 0x03136,
    nieunkorean                             = 0x03134,
    nieunpansioskorean                      = 0x03168,
    nieunparenkorean                        = 0x03201,
    nieunsioskorean                         = 0x03167,
    nieuntikeutkorean                       = 0x03166,
    nihiragana                              = 0x0306B,
    nikatakana                              = 0x030CB,
    nikatakanahalfwidth                     = 0x0FF86,
    nikhahitthai                            = 0x00E4D,
    nine                                    = 0x00039,
    ninearabic                              = 0x00669,
    ninebengali                             = 0x009EF,
    ninecircle                              = 0x02468,
    ninecircleinversesansserif              = 0x02792,
    ninedeva                                = 0x0096F,
    ninegujarati                            = 0x00AEF,
    ninegurmukhi                            = 0x00A6F,
    ninehackarabic                          = 0x00669,
    ninehangzhou                            = 0x03029,
    nineideographicparen                    = 0x03228,
    nineinferior                            = 0x02089,
    ninemonospace                           = 0x0FF19,
    nineoldstyle                            = 0x00039,
    nineparen                               = 0x0247C,
    nineperiod                              = 0x02490,
    ninepersian                             = 0x006F9,
    nineroman                               = 0x02178,
    ninesuperior                            = 0x02079,
    nineteencircle                          = 0x02472,
    nineteenparen                           = 0x02486,
    nineteenperiod                          = 0x0249A,
    ninethai                                = 0x00E59,
    nj                                      = 0x001CC,
    njecyrillic                             = 0x0045A,
    nkatakana                               = 0x030F3,
    nkatakanahalfwidth                      = 0x0FF9D,
    nlegrightlong                           = 0x0019E,
    nlinebelow                              = 0x01E49,
    nmonospace                              = 0x0FF4E,
    nmsquare                                = 0x0339A,
    nnabengali                              = 0x009A3,
    nnadeva                                 = 0x00923,
    nnagujarati                             = 0x00AA3,
    nnagurmukhi                             = 0x00A23,
    nnnadeva                                = 0x00929,
    nohiragana                              = 0x0306E,
    nokatakana                              = 0x030CE,
    nokatakanahalfwidth                     = 0x0FF89,
    nonbreakingspace                        = 0x000A0,
    nonenthai                               = 0x00E13,
    nonuthai                                = 0x00E19,
    noonarabic                              = 0x00646,
    noonfinalarabic                         = 0x0FEE6,
    noonghunnaarabic                        = 0x006BA,
    noonghunnafinalarabic                   = 0x0FB9F,
    noonhehinitialarabic                    = 0x0FEE7,
    nooninitialarabic                       = 0x0FEE7,
    noonjeeminitialarabic                   = 0x0FCD2,
    noonjeemisolatedarabic                  = 0x0FC4B,
    noonmedialarabic                        = 0x0FEE8,
    noonmeeminitialarabic                   = 0x0FCD5,
    noonmeemisolatedarabic                  = 0x0FC4E,
    noonnoonfinalarabic                     = 0x0FC8D,
    notcontains                             = 0x0220C,
    notelement                              = 0x02209,
    notelementof                            = 0x02209,
    notequal                                = 0x02260,
    notgreater                              = 0x0226F,
    notgreaternorequal                      = 0x02271,
    notgreaternorless                       = 0x02279,
    notidentical                            = 0x02262,
    notless                                 = 0x0226E,
    notlessnorequal                         = 0x02270,
    notparallel                             = 0x02226,
    notprecedes                             = 0x02280,
    notsubset                               = 0x02284,
    notsucceeds                             = 0x02281,
    notsuperset                             = 0x02285,
    nowarmenian                             = 0x00576,
    nparen                                  = 0x024A9,
    nssquare                                = 0x033B1,
    nsuperior                               = 0x0207F,
    ntilde                                  = 0x000F1,
    nu                                      = 0x003BD,
    nuhiragana                              = 0x0306C,
    nukatakana                              = 0x030CC,
    nukatakanahalfwidth                     = 0x0FF87,
    nuktabengali                            = 0x009BC,
    nuktadeva                               = 0x0093C,
    nuktagujarati                           = 0x00ABC,
    nuktagurmukhi                           = 0x00A3C,
    numbersign                              = 0x00023,
    numbersignmonospace                     = 0x0FF03,
    numbersignsmall                         = 0x0FE5F,
    numeralsigngreek                        = 0x00374,
    numeralsignlowergreek                   = 0x00375,
    numero                                  = 0x02116,
    nun                                     = 0x005E0,
    nundagesh                               = 0x0FB40,
    nundageshhebrew                         = 0x0FB40,
    nunhebrew                               = 0x005E0,
    nvsquare                                = 0x033B5,
    nwsquare                                = 0x033BB,
    nyabengali                              = 0x0099E,
    nyadeva                                 = 0x0091E,
    nyagujarati                             = 0x00A9E,
    nyagurmukhi                             = 0x00A1E,
    o                                       = 0x0006F,
    oacute                                  = 0x000F3,
    oangthai                                = 0x00E2D,
    obarred                                 = 0x00275,
    obarredcyrillic                         = 0x004E9,
    obarreddieresiscyrillic                 = 0x004EB,
    obengali                                = 0x00993,
    obopomofo                               = 0x0311B,
    obreve                                  = 0x0014F,
    ocandradeva                             = 0x00911,
    ocandragujarati                         = 0x00A91,
    ocandravowelsigndeva                    = 0x00949,
    ocandravowelsigngujarati                = 0x00AC9,
    ocaron                                  = 0x001D2,
    ocircle                                 = 0x024DE,
    ocircumflex                             = 0x000F4,
    ocircumflexacute                        = 0x01ED1,
    ocircumflexdotbelow                     = 0x01ED9,
    ocircumflexgrave                        = 0x01ED3,
    ocircumflexhookabove                    = 0x01ED5,
    ocircumflextilde                        = 0x01ED7,
    ocyrillic                               = 0x0043E,
    odblacute                               = 0x00151,
    odblgrave                               = 0x0020D,
    odeva                                   = 0x00913,
    odieresis                               = 0x000F6,
    odieresiscyrillic                       = 0x004E7,
    odotbelow                               = 0x01ECD,
    oe                                      = 0x00153,
    oekorean                                = 0x0315A,
    ogonek                                  = 0x002DB,
    ogonekcmb                               = 0x00328,
    ograve                                  = 0x000F2,
    ogujarati                               = 0x00A93,
    oharmenian                              = 0x00585,
    ohiragana                               = 0x0304A,
    ohookabove                              = 0x01ECF,
    ohorn                                   = 0x001A1,
    ohornacute                              = 0x01EDB,
    ohorndotbelow                           = 0x01EE3,
    ohorngrave                              = 0x01EDD,
    ohornhookabove                          = 0x01EDF,
    ohorntilde                              = 0x01EE1,
    ohungarumlaut                           = 0x00151,
    oi                                      = 0x001A3,
    oinvertedbreve                          = 0x0020F,
    okatakana                               = 0x030AA,
    okatakanahalfwidth                      = 0x0FF75,
    okorean                                 = 0x03157,
    olehebrew                               = 0x005AB,
    omacron                                 = 0x0014D,
    omacronacute                            = 0x01E53,
    omacrongrave                            = 0x01E51,
    omdeva                                  = 0x00950,
    omega                                   = 0x003C9,
    omega1                                  = 0x003D6,
    omegacyrillic                           = 0x00461,
    omegalatinclosed                        = 0x00277,
    omegaroundcyrillic                      = 0x0047B,
    omegatitlocyrillic                      = 0x0047D,
    omegatonos                              = 0x003CE,
    omgujarati                              = 0x00AD0,
    omicron                                 = 0x003BF,
    omicrontonos                            = 0x003CC,
    omonospace                              = 0x0FF4F,
    one                                     = 0x00031,
    onearabic                               = 0x00661,
    onebengali                              = 0x009E7,
    onecircle                               = 0x02460,
    onecircleinversesansserif               = 0x0278A,
    onedeva                                 = 0x00967,
    onedotenleader                          = 0x02024,
    oneeighth                               = 0x0215B,
    onegujarati                             = 0x00AE7,
    onegurmukhi                             = 0x00A67,
    onehackarabic                           = 0x00661,
    onehalf                                 = 0x000BD,
    onehangzhou                             = 0x03021,
    oneideographicparen                     = 0x03220,
    oneinferior                             = 0x02081,
    onemonospace                            = 0x0FF11,
    onenumeratorbengali                     = 0x009F4,
    oneoldstyle                             = 0x00031,
    oneparen                                = 0x02474,
    oneperiod                               = 0x02488,
    onepersian                              = 0x006F1,
    onequarter                              = 0x000BC,
    oneroman                                = 0x02170,
    onesuperior                             = 0x000B9,
    onethai                                 = 0x00E51,
    onethird                                = 0x02153,
    oogonek                                 = 0x001EB,
    oogonekmacron                           = 0x001ED,
    oogurmukhi                              = 0x00A13,
    oomatragurmukhi                         = 0x00A4B,
    oopen                                   = 0x00254,
    oparen                                  = 0x024AA,
    openbullet                              = 0x025E6,
    option                                  = 0x02325,
    ordfeminine                             = 0x000AA,
    ordmasculine                            = 0x000BA,
    orthogonal                              = 0x0221F,
    oshortdeva                              = 0x00912,
    oshortvowelsigndeva                     = 0x0094A,
    oslash                                  = 0x000F8,
    oslashacute                             = 0x001FF,
    osmallhiragana                          = 0x03049,
    osmallkatakana                          = 0x030A9,
    osmallkatakanahalfwidth                 = 0x0FF6B,
    ostrokeacute                            = 0x001FF,
    otcyrillic                              = 0x0047F,
    otilde                                  = 0x000F5,
    otildeacute                             = 0x01E4D,
    otildedieresis                          = 0x01E4F,
    oubopomofo                              = 0x03121,
    overline                                = 0x0203E,
    overlinecenterline                      = 0x0FE4A,
    overlinecmb                             = 0x00305,
    overlinedashed                          = 0x0FE49,
    overlinedblwavy                         = 0x0FE4C,
    overlinewavy                            = 0x0FE4B,
    overscore                               = 0x000AF,
    ovowelsignbengali                       = 0x009CB,
    ovowelsigndeva                          = 0x0094B,
    ovowelsigngujarati                      = 0x00ACB,
    p                                       = 0x00070,
    paampssquare                            = 0x03380,
    paasentosquare                          = 0x0332B,
    pabengali                               = 0x009AA,
    pacute                                  = 0x01E55,
    padeva                                  = 0x0092A,
    pagedown                                = 0x021DF,
    pageup                                  = 0x021DE,
    pagujarati                              = 0x00AAA,
    pagurmukhi                              = 0x00A2A,
    pahiragana                              = 0x03071,
    paiyannoithai                           = 0x00E2F,
    pakatakana                              = 0x030D1,
    palatalizationcyrilliccmb               = 0x00484,
    palochkacyrillic                        = 0x004C0,
    pansioskorean                           = 0x0317F,
    paragraph                               = 0x000B6,
    parallel                                = 0x02225,
    parenleft                               = 0x00028,
    parenleftaltonearabic                   = 0x0FD3E,
    parenleftinferior                       = 0x0208D,
    parenleftmonospace                      = 0x0FF08,
    parenleftsmall                          = 0x0FE59,
    parenleftsuperior                       = 0x0207D,
    parenleftvertical                       = 0x0FE35,
    parenright                              = 0x00029,
    parenrightaltonearabic                  = 0x0FD3F,
    parenrightinferior                      = 0x0208E,
    parenrightmonospace                     = 0x0FF09,
    parenrightsmall                         = 0x0FE5A,
    parenrightsuperior                      = 0x0207E,
    parenrightvertical                      = 0x0FE36,
    partialdiff                             = 0x02202,
    paseqhebrew                             = 0x005C0,
    pashtahebrew                            = 0x00599,
    pasquare                                = 0x033A9,
    patah                                   = 0x005B7,
    patah11                                 = 0x005B7,
    patah1d                                 = 0x005B7,
    patah2a                                 = 0x005B7,
    patahhebrew                             = 0x005B7,
    patahnarrowhebrew                       = 0x005B7,
    patahquarterhebrew                      = 0x005B7,
    patahwidehebrew                         = 0x005B7,
    pazerhebrew                             = 0x005A1,
    pbopomofo                               = 0x03106,
    pcircle                                 = 0x024DF,
    pdotaccent                              = 0x01E57,
    pe                                      = 0x005E4,
    pecyrillic                              = 0x0043F,
    pedagesh                                = 0x0FB44,
    pedageshhebrew                          = 0x0FB44,
    peezisquare                             = 0x0333B,
    pefinaldageshhebrew                     = 0x0FB43,
    peharabic                               = 0x0067E,
    peharmenian                             = 0x0057A,
    pehebrew                                = 0x005E4,
    pehfinalarabic                          = 0x0FB57,
    pehinitialarabic                        = 0x0FB58,
    pehiragana                              = 0x0307A,
    pehmedialarabic                         = 0x0FB59,
    pekatakana                              = 0x030DA,
    pemiddlehookcyrillic                    = 0x004A7,
    perafehebrew                            = 0x0FB4E,
    percent                                 = 0x00025,
    percentarabic                           = 0x0066A,
    percentmonospace                        = 0x0FF05,
    percentsmall                            = 0x0FE6A,
    period                                  = 0x0002E,
    periodarmenian                          = 0x00589,
    periodcentered                          = 0x000B7,
    periodhalfwidth                         = 0x0FF61,
    periodmonospace                         = 0x0FF0E,
    periodsmall                             = 0x0FE52,
    perispomenigreekcmb                     = 0x00342,
    perpendicular                           = 0x022A5,
    perthousand                             = 0x02030,
    peseta                                  = 0x020A7,
    pfsquare                                = 0x0338A,
    phabengali                              = 0x009AB,
    phadeva                                 = 0x0092B,
    phagujarati                             = 0x00AAB,
    phagurmukhi                             = 0x00A2B,
    phi                                     = 0x003C6,
    phi1                                    = 0x003D5,
    phieuphacirclekorean                    = 0x0327A,
    phieuphaparenkorean                     = 0x0321A,
    phieuphcirclekorean                     = 0x0326C,
    phieuphkorean                           = 0x0314D,
    phieuphparenkorean                      = 0x0320C,
    philatin                                = 0x00278,
    phinthuthai                             = 0x00E3A,
    phisymbolgreek                          = 0x003D5,
    phook                                   = 0x001A5,
    phophanthai                             = 0x00E1E,
    phophungthai                            = 0x00E1C,
    phosamphaothai                          = 0x00E20,
    pi                                      = 0x003C0,
    pieupacirclekorean                      = 0x03273,
    pieupaparenkorean                       = 0x03213,
    pieupcieuckorean                        = 0x03176,
    pieupcirclekorean                       = 0x03265,
    pieupkiyeokkorean                       = 0x03172,
    pieupkorean                             = 0x03142,
    pieupparenkorean                        = 0x03205,
    pieupsioskiyeokkorean                   = 0x03174,
    pieupsioskorean                         = 0x03144,
    pieupsiostikeutkorean                   = 0x03175,
    pieupthieuthkorean                      = 0x03177,
    pieuptikeutkorean                       = 0x03173,
    pihiragana                              = 0x03074,
    pikatakana                              = 0x030D4,
    pisymbolgreek                           = 0x003D6,
    piwrarmenian                            = 0x00583,
    plus                                    = 0x0002B,
    plusbelowcmb                            = 0x0031F,
    pluscircle                              = 0x02295,
    plusminus                               = 0x000B1,
    plusmod                                 = 0x002D6,
    plusmonospace                           = 0x0FF0B,
    plussmall                               = 0x0FE62,
    plussuperior                            = 0x0207A,
    pmonospace                              = 0x0FF50,
    pmsquare                                = 0x033D8,
    pohiragana                              = 0x0307D,
    pointingindexdownwhite                  = 0x0261F,
    pointingindexleftwhite                  = 0x0261C,
    pointingindexrightwhite                 = 0x0261E,
    pointingindexupwhite                    = 0x0261D,
    pokatakana                              = 0x030DD,
    poplathai                               = 0x00E1B,
    postalmark                              = 0x03012,
    postalmarkface                          = 0x03020,
    pparen                                  = 0x024AB,
    precedes                                = 0x0227A,
    prescription                            = 0x0211E,
    primemod                                = 0x002B9,
    primereversed                           = 0x02035,
    product                                 = 0x0220F,
    projective                              = 0x02305,
    prolongedkana                           = 0x030FC,
    propellor                               = 0x02318,
    propersubset                            = 0x02282,
    propersuperset                          = 0x02283,
    proportion                              = 0x02237,
    proportional                            = 0x0221D,
    psi                                     = 0x003C8,
    psicyrillic                             = 0x00471,
    psilipneumatacyrilliccmb                = 0x00486,
    pssquare                                = 0x033B0,
    puhiragana                              = 0x03077,
    pukatakana                              = 0x030D7,
    pvsquare                                = 0x033B4,
    pwsquare                                = 0x033BA,
    q                                       = 0x00071,
    qadeva                                  = 0x00958,
    qadmahebrew                             = 0x005A8,
    qafarabic                               = 0x00642,
    qaffinalarabic                          = 0x0FED6,
    qafinitialarabic                        = 0x0FED7,
    qafmedialarabic                         = 0x0FED8,
    qamats                                  = 0x005B8,
    qamats10                                = 0x005B8,
    qamats1a                                = 0x005B8,
    qamats1c                                = 0x005B8,
    qamats27                                = 0x005B8,
    qamats29                                = 0x005B8,
    qamats33                                = 0x005B8,
    qamatsde                                = 0x005B8,
    qamatshebrew                            = 0x005B8,
    qamatsnarrowhebrew                      = 0x005B8,
    qamatsqatanhebrew                       = 0x005B8,
    qamatsqatannarrowhebrew                 = 0x005B8,
    qamatsqatanquarterhebrew                = 0x005B8,
    qamatsqatanwidehebrew                   = 0x005B8,
    qamatsquarterhebrew                     = 0x005B8,
    qamatswidehebrew                        = 0x005B8,
    qarneyparahebrew                        = 0x0059F,
    qbopomofo                               = 0x03111,
    qcircle                                 = 0x024E0,
    qhook                                   = 0x002A0,
    qmonospace                              = 0x0FF51,
    qof                                     = 0x005E7,
    qofdagesh                               = 0x0FB47,
    qofdageshhebrew                         = 0x0FB47,
    qofhatafpatah                           = 0x005E7,
    qofhatafpatahhebrew                     = 0x005E7,
    qofhatafsegol                           = 0x005E7,
    qofhatafsegolhebrew                     = 0x005E7,
    qofhebrew                               = 0x005E7,
    qofhiriq                                = 0x005E7,
    qofhiriqhebrew                          = 0x005E7,
    qofholam                                = 0x005E7,
    qofholamhebrew                          = 0x005E7,
    qofpatah                                = 0x005E7,
    qofpatahhebrew                          = 0x005E7,
    qofqamats                               = 0x005E7,
    qofqamatshebrew                         = 0x005E7,
    qofqubuts                               = 0x005E7,
    qofqubutshebrew                         = 0x005E7,
    qofsegol                                = 0x005E7,
    qofsegolhebrew                          = 0x005E7,
    qofsheva                                = 0x005E7,
    qofshevahebrew                          = 0x005E7,
    qoftsere                                = 0x005E7,
    qoftserehebrew                          = 0x005E7,
    qparen                                  = 0x024AC,
    quarternote                             = 0x02669,
    qubuts                                  = 0x005BB,
    qubuts18                                = 0x005BB,
    qubuts25                                = 0x005BB,
    qubuts31                                = 0x005BB,
    qubutshebrew                            = 0x005BB,
    qubutsnarrowhebrew                      = 0x005BB,
    qubutsquarterhebrew                     = 0x005BB,
    qubutswidehebrew                        = 0x005BB,
    question                                = 0x0003F,
    questionarabic                          = 0x0061F,
    questionarmenian                        = 0x0055E,
    questiondown                            = 0x000BF,
    questiongreek                           = 0x0037E,
    questionmonospace                       = 0x0FF1F,
    quotedbl                                = 0x00022,
    quotedblbase                            = 0x0201E,
    quotedblleft                            = 0x0201C,
    quotedblmonospace                       = 0x0FF02,
    quotedblprime                           = 0x0301E,
    quotedblprimereversed                   = 0x0301D,
    quotedblright                           = 0x0201D,
    quoteleft                               = 0x02018,
    quoteleftreversed                       = 0x0201B,
    quotereversed                           = 0x0201B,
    quoteright                              = 0x02019,
    quoterightn                             = 0x00149,
    quotesinglbase                          = 0x0201A,
    quotesingle                             = 0x00027,
    quotesinglemonospace                    = 0x0FF07,
    r                                       = 0x00072,
    raarmenian                              = 0x0057C,
    rabengali                               = 0x009B0,
    racute                                  = 0x00155,
    radeva                                  = 0x00930,
    radical                                 = 0x0221A,
    radoverssquare                          = 0x033AE,
    radoverssquaredsquare                   = 0x033AF,
    radsquare                               = 0x033AD,
    rafe                                    = 0x005BF,
    rafehebrew                              = 0x005BF,
    ragujarati                              = 0x00AB0,
    ragurmukhi                              = 0x00A30,
    rahiragana                              = 0x03089,
    rakatakana                              = 0x030E9,
    rakatakanahalfwidth                     = 0x0FF97,
    ralowerdiagonalbengali                  = 0x009F1,
    ramiddlediagonalbengali                 = 0x009F0,
    ramshorn                                = 0x00264,
    ratio                                   = 0x02236,
    rbopomofo                               = 0x03116,
    rcaron                                  = 0x00159,
    rcedilla                                = 0x00157,
    rcircle                                 = 0x024E1,
    rcommaaccent                            = 0x00157,
    rdblgrave                               = 0x00211,
    rdotaccent                              = 0x01E59,
    rdotbelow                               = 0x01E5B,
    rdotbelowmacron                         = 0x01E5D,
    referencemark                           = 0x0203B,
    reflexsubset                            = 0x02286,
    reflexsuperset                          = 0x02287,
    registered                              = 0x000AE,
    reharabic                               = 0x00631,
    reharmenian                             = 0x00580,
    rehfinalarabic                          = 0x0FEAE,
    rehiragana                              = 0x0308C,
    rehyehaleflamarabic                     = 0x00631,
    rekatakana                              = 0x030EC,
    rekatakanahalfwidth                     = 0x0FF9A,
    resh                                    = 0x005E8,
    reshdageshhebrew                        = 0x0FB48,
    reshhatafpatah                          = 0x005E8,
    reshhatafpatahhebrew                    = 0x005E8,
    reshhatafsegol                          = 0x005E8,
    reshhatafsegolhebrew                    = 0x005E8,
    reshhebrew                              = 0x005E8,
    reshhiriq                               = 0x005E8,
    reshhiriqhebrew                         = 0x005E8,
    reshholam                               = 0x005E8,
    reshholamhebrew                         = 0x005E8,
    reshpatah                               = 0x005E8,
    reshpatahhebrew                         = 0x005E8,
    reshqamats                              = 0x005E8,
    reshqamatshebrew                        = 0x005E8,
    reshqubuts                              = 0x005E8,
    reshqubutshebrew                        = 0x005E8,
    reshsegol                               = 0x005E8,
    reshsegolhebrew                         = 0x005E8,
    reshsheva                               = 0x005E8,
    reshshevahebrew                         = 0x005E8,
    reshtsere                               = 0x005E8,
    reshtserehebrew                         = 0x005E8,
    reversedtilde                           = 0x0223D,
    reviahebrew                             = 0x00597,
    reviamugrashhebrew                      = 0x00597,
    revlogicalnot                           = 0x02310,
    rfishhook                               = 0x0027E,
    rfishhookreversed                       = 0x0027F,
    rhabengali                              = 0x009DD,
    rhadeva                                 = 0x0095D,
    rho                                     = 0x003C1,
    rhook                                   = 0x0027D,
    rhookturned                             = 0x0027B,
    rhookturnedsuperior                     = 0x002B5,
    rhosymbolgreek                          = 0x003F1,
    rhotichookmod                           = 0x002DE,
    rieulacirclekorean                      = 0x03271,
    rieulaparenkorean                       = 0x03211,
    rieulcirclekorean                       = 0x03263,
    rieulhieuhkorean                        = 0x03140,
    rieulkiyeokkorean                       = 0x0313A,
    rieulkiyeoksioskorean                   = 0x03169,
    rieulkorean                             = 0x03139,
    rieulmieumkorean                        = 0x0313B,
    rieulpansioskorean                      = 0x0316C,
    rieulparenkorean                        = 0x03203,
    rieulphieuphkorean                      = 0x0313F,
    rieulpieupkorean                        = 0x0313C,
    rieulpieupsioskorean                    = 0x0316B,
    rieulsioskorean                         = 0x0313D,
    rieulthieuthkorean                      = 0x0313E,
    rieultikeutkorean                       = 0x0316A,
    rieulyeorinhieuhkorean                  = 0x0316D,
    rightangle                              = 0x0221F,
    righttackbelowcmb                       = 0x00319,
    righttriangle                           = 0x022BF,
    rihiragana                              = 0x0308A,
    rikatakana                              = 0x030EA,
    rikatakanahalfwidth                     = 0x0FF98,
    ring                                    = 0x002DA,
    ringbelowcmb                            = 0x00325,
    ringcmb                                 = 0x0030A,
    ringhalfleft                            = 0x002BF,
    ringhalfleftarmenian                    = 0x00559,
    ringhalfleftbelowcmb                    = 0x0031C,
    ringhalfleftcentered                    = 0x002D3,
    ringhalfright                           = 0x002BE,
    ringhalfrightbelowcmb                   = 0x00339,
    ringhalfrightcentered                   = 0x002D2,
    rinvertedbreve                          = 0x00213,
    rittorusquare                           = 0x03351,
    rlinebelow                              = 0x01E5F,
    rlongleg                                = 0x0027C,
    rlonglegturned                          = 0x0027A,
    rmonospace                              = 0x0FF52,
    rohiragana                              = 0x0308D,
    rokatakana                              = 0x030ED,
    rokatakanahalfwidth                     = 0x0FF9B,
    roruathai                               = 0x00E23,
    rparen                                  = 0x024AD,
    rrabengali                              = 0x009DC,
    rradeva                                 = 0x00931,
    rragurmukhi                             = 0x00A5C,
    rreharabic                              = 0x00691,
    rrehfinalarabic                         = 0x0FB8D,
    rrvocalicbengali                        = 0x009E0,
    rrvocalicdeva                           = 0x00960,
    rrvocalicgujarati                       = 0x00AE0,
    rrvocalicvowelsignbengali               = 0x009C4,
    rrvocalicvowelsigndeva                  = 0x00944,
    rrvocalicvowelsigngujarati              = 0x00AC4,
    rtblock                                 = 0x02590,
    rturned                                 = 0x00279,
    rturnedsuperior                         = 0x002B4,
    ruhiragana                              = 0x0308B,
    rukatakana                              = 0x030EB,
    rukatakanahalfwidth                     = 0x0FF99,
    rupeemarkbengali                        = 0x009F2,
    rupeesignbengali                        = 0x009F3,
    ruthai                                  = 0x00E24,
    rvocalicbengali                         = 0x0098B,
    rvocalicdeva                            = 0x0090B,
    rvocalicgujarati                        = 0x00A8B,
    rvocalicvowelsignbengali                = 0x009C3,
    rvocalicvowelsigndeva                   = 0x00943,
    rvocalicvowelsigngujarati               = 0x00AC3,
    s                                       = 0x00073,
    sabengali                               = 0x009B8,
    sacute                                  = 0x0015B,
    sacutedotaccent                         = 0x01E65,
    sadarabic                               = 0x00635,
    sadeva                                  = 0x00938,
    sadfinalarabic                          = 0x0FEBA,
    sadinitialarabic                        = 0x0FEBB,
    sadmedialarabic                         = 0x0FEBC,
    sagujarati                              = 0x00AB8,
    sagurmukhi                              = 0x00A38,
    sahiragana                              = 0x03055,
    sakatakana                              = 0x030B5,
    sakatakanahalfwidth                     = 0x0FF7B,
    sallallahoualayhewasallamarabic         = 0x0FDFA,
    samekh                                  = 0x005E1,
    samekhdagesh                            = 0x0FB41,
    samekhdageshhebrew                      = 0x0FB41,
    samekhhebrew                            = 0x005E1,
    saraaathai                              = 0x00E32,
    saraaethai                              = 0x00E41,
    saraaimaimalaithai                      = 0x00E44,
    saraaimaimuanthai                       = 0x00E43,
    saraamthai                              = 0x00E33,
    saraathai                               = 0x00E30,
    saraethai                               = 0x00E40,
    saraiithai                              = 0x00E35,
    saraithai                               = 0x00E34,
    saraothai                               = 0x00E42,
    saraueethai                             = 0x00E37,
    sarauethai                              = 0x00E36,
    sarauthai                               = 0x00E38,
    sarauuthai                              = 0x00E39,
    sbopomofo                               = 0x03119,
    scaron                                  = 0x00161,
    scarondotaccent                         = 0x01E67,
    scedilla                                = 0x0015F,
    schwa                                   = 0x00259,
    schwacyrillic                           = 0x004D9,
    schwadieresiscyrillic                   = 0x004DB,
    schwahook                               = 0x0025A,
    scircle                                 = 0x024E2,
    scircumflex                             = 0x0015D,
    scommaaccent                            = 0x00219,
    sdotaccent                              = 0x01E61,
    sdotbelow                               = 0x01E63,
    sdotbelowdotaccent                      = 0x01E69,
    seagullbelowcmb                         = 0x0033C,
    second                                  = 0x02033,
    secondtonechinese                       = 0x002CA,
    section                                 = 0x000A7,
    seenarabic                              = 0x00633,
    seenfinalarabic                         = 0x0FEB2,
    seeninitialarabic                       = 0x0FEB3,
    seenmedialarabic                        = 0x0FEB4,
    segol                                   = 0x005B6,
    segol13                                 = 0x005B6,
    segol1f                                 = 0x005B6,
    segol2c                                 = 0x005B6,
    segolhebrew                             = 0x005B6,
    segolnarrowhebrew                       = 0x005B6,
    segolquarterhebrew                      = 0x005B6,
    segoltahebrew                           = 0x00592,
    segolwidehebrew                         = 0x005B6,
    seharmenian                             = 0x0057D,
    sehiragana                              = 0x0305B,
    sekatakana                              = 0x030BB,
    sekatakanahalfwidth                     = 0x0FF7E,
    semicolon                               = 0x0003B,
    semicolonarabic                         = 0x0061B,
    semicolonmonospace                      = 0x0FF1B,
    semicolonsmall                          = 0x0FE54,
    semivoicedmarkkana                      = 0x0309C,
    semivoicedmarkkanahalfwidth             = 0x0FF9F,
    sentisquare                             = 0x03322,
    sentosquare                             = 0x03323,
    seven                                   = 0x00037,
    sevenarabic                             = 0x00667,
    sevenbengali                            = 0x009ED,
    sevencircle                             = 0x02466,
    sevencircleinversesansserif             = 0x02790,
    sevendeva                               = 0x0096D,
    seveneighths                            = 0x0215E,
    sevengujarati                           = 0x00AED,
    sevengurmukhi                           = 0x00A6D,
    sevenhackarabic                         = 0x00667,
    sevenhangzhou                           = 0x03027,
    sevenideographicparen                   = 0x03226,
    seveninferior                           = 0x02087,
    sevenmonospace                          = 0x0FF17,
    sevenoldstyle                           = 0x00037,
    sevenparen                              = 0x0247A,
    sevenperiod                             = 0x0248E,
    sevenpersian                            = 0x006F7,
    sevenroman                              = 0x02176,
    sevensuperior                           = 0x02077,
    seventeencircle                         = 0x02470,
    seventeenparen                          = 0x02484,
    seventeenperiod                         = 0x02498,
    seventhai                               = 0x00E57,
    sfthyphen                               = 0x000AD,
    shaarmenian                             = 0x00577,
    shabengali                              = 0x009B6,
    shacyrillic                             = 0x00448,
    shaddaarabic                            = 0x00651,
    shaddadammaarabic                       = 0x0FC61,
    shaddadammatanarabic                    = 0x0FC5E,
    shaddafathaarabic                       = 0x0FC60,
    shaddafathatanarabic                    = 0x00651,
    shaddakasraarabic                       = 0x0FC62,
    shaddakasratanarabic                    = 0x0FC5F,
    shade                                   = 0x02592,
    shadedark                               = 0x02593,
    shadelight                              = 0x02591,
    shademedium                             = 0x02592,
    shadeva                                 = 0x00936,
    shagujarati                             = 0x00AB6,
    shagurmukhi                             = 0x00A36,
    shalshelethebrew                        = 0x00593,
    shbopomofo                              = 0x03115,
    shchacyrillic                           = 0x00449,
    sheenarabic                             = 0x00634,
    sheenfinalarabic                        = 0x0FEB6,
    sheeninitialarabic                      = 0x0FEB7,
    sheenmedialarabic                       = 0x0FEB8,
    sheicoptic                              = 0x003E3,
    sheqel                                  = 0x020AA,
    sheqelhebrew                            = 0x020AA,
    sheva                                   = 0x005B0,
    sheva115                                = 0x005B0,
    sheva15                                 = 0x005B0,
    sheva22                                 = 0x005B0,
    sheva2e                                 = 0x005B0,
    shevahebrew                             = 0x005B0,
    shevanarrowhebrew                       = 0x005B0,
    shevaquarterhebrew                      = 0x005B0,
    shevawidehebrew                         = 0x005B0,
    shhacyrillic                            = 0x004BB,
    shimacoptic                             = 0x003ED,
    shin                                    = 0x005E9,
    shindagesh                              = 0x0FB49,
    shindageshhebrew                        = 0x0FB49,
    shindageshshindot                       = 0x0FB2C,
    shindageshshindothebrew                 = 0x0FB2C,
    shindageshsindot                        = 0x0FB2D,
    shindageshsindothebrew                  = 0x0FB2D,
    shindothebrew                           = 0x005C1,
    shinhebrew                              = 0x005E9,
    shinshindot                             = 0x0FB2A,
    shinshindothebrew                       = 0x0FB2A,
    shinsindot                              = 0x0FB2B,
    shinsindothebrew                        = 0x0FB2B,
    shook                                   = 0x00282,
    sigma                                   = 0x003C3,
    sigma1                                  = 0x003C2,
    sigmafinal                              = 0x003C2,
    sigmalunatesymbolgreek                  = 0x003F2,
    sihiragana                              = 0x03057,
    sikatakana                              = 0x030B7,
    sikatakanahalfwidth                     = 0x0FF7C,
    siluqhebrew                             = 0x005BD,
    siluqlefthebrew                         = 0x005BD,
    similar                                 = 0x0223C,
    sindothebrew                            = 0x005C2,
    siosacirclekorean                       = 0x03274,
    siosaparenkorean                        = 0x03214,
    sioscieuckorean                         = 0x0317E,
    sioscirclekorean                        = 0x03266,
    sioskiyeokkorean                        = 0x0317A,
    sioskorean                              = 0x03145,
    siosnieunkorean                         = 0x0317B,
    siosparenkorean                         = 0x03206,
    siospieupkorean                         = 0x0317D,
    siostikeutkorean                        = 0x0317C,
    six                                     = 0x00036,
    sixarabic                               = 0x00666,
    sixbengali                              = 0x009EC,
    sixcircle                               = 0x02465,
    sixcircleinversesansserif               = 0x0278F,
    sixdeva                                 = 0x0096C,
    sixgujarati                             = 0x00AEC,
    sixgurmukhi                             = 0x00A6C,
    sixhackarabic                           = 0x00666,
    sixhangzhou                             = 0x03026,
    sixideographicparen                     = 0x03225,
    sixinferior                             = 0x02086,
    sixmonospace                            = 0x0FF16,
    sixoldstyle                             = 0x00036,
    sixparen                                = 0x02479,
    sixperiod                               = 0x0248D,
    sixpersian                              = 0x006F6,
    sixroman                                = 0x02175,
    sixsuperior                             = 0x02076,
    sixteencircle                           = 0x0246F,
    sixteencurrencydenominatorbengali       = 0x009F9,
    sixteenparen                            = 0x02483,
    sixteenperiod                           = 0x02497,
    sixthai                                 = 0x00E56,
    slash                                   = 0x0002F,
    slashmonospace                          = 0x0FF0F,
    slong                                   = 0x0017F,
    slongdotaccent                          = 0x01E9B,
    smileface                               = 0x0263A,
    smonospace                              = 0x0FF53,
    sofpasuqhebrew                          = 0x005C3,
    softhyphen                              = 0x000AD,
    softsigncyrillic                        = 0x0044C,
    sohiragana                              = 0x0305D,
    sokatakana                              = 0x030BD,
    sokatakanahalfwidth                     = 0x0FF7F,
    soliduslongoverlaycmb                   = 0x00338,
    solidusshortoverlaycmb                  = 0x00337,
    sorusithai                              = 0x00E29,
    sosalathai                              = 0x00E28,
    sosothai                                = 0x00E0B,
    sosuathai                               = 0x00E2A,
    space                                   = 0x00020,
    spacehackarabic                         = 0x00020,
    spade                                   = 0x02660,
    spadesuitblack                          = 0x02660,
    spadesuitwhite                          = 0x02664,
    sparen                                  = 0x024AE,
    squarebelowcmb                          = 0x0033B,
    squarecc                                = 0x033C4,
    squarecm                                = 0x0339D,
    squarediagonalcrosshatchfill            = 0x025A9,
    squarehorizontalfill                    = 0x025A4,
    squarekg                                = 0x0338F,
    squarekm                                = 0x0339E,
    squarekmcapital                         = 0x033CE,
    squareln                                = 0x033D1,
    squarelog                               = 0x033D2,
    squaremg                                = 0x0338E,
    squaremil                               = 0x033D5,
    squaremm                                = 0x0339C,
    squaremsquared                          = 0x033A1,
    squareorthogonalcrosshatchfill          = 0x025A6,
    squareupperlefttolowerrightfill         = 0x025A7,
    squareupperrighttolowerleftfill         = 0x025A8,
    squareverticalfill                      = 0x025A5,
    squarewhitewithsmallblack               = 0x025A3,
    srsquare                                = 0x033DB,
    ssabengali                              = 0x009B7,
    ssadeva                                 = 0x00937,
    ssagujarati                             = 0x00AB7,
    ssangcieuckorean                        = 0x03149,
    ssanghieuhkorean                        = 0x03185,
    ssangieungkorean                        = 0x03180,
    ssangkiyeokkorean                       = 0x03132,
    ssangnieunkorean                        = 0x03165,
    ssangpieupkorean                        = 0x03143,
    ssangsioskorean                         = 0x03146,
    ssangtikeutkorean                       = 0x03138,
    sterling                                = 0x000A3,
    sterlingmonospace                       = 0x0FFE1,
    strokelongoverlaycmb                    = 0x00336,
    strokeshortoverlaycmb                   = 0x00335,
    subset                                  = 0x02282,
    subsetnotequal                          = 0x0228A,
    subsetorequal                           = 0x02286,
    succeeds                                = 0x0227B,
    suchthat                                = 0x0220B,
    suhiragana                              = 0x03059,
    sukatakana                              = 0x030B9,
    sukatakanahalfwidth                     = 0x0FF7D,
    sukunarabic                             = 0x00652,
    summation                               = 0x02211,
    sun                                     = 0x0263C,
    superset                                = 0x02283,
    supersetnotequal                        = 0x0228B,
    supersetorequal                         = 0x02287,
    svsquare                                = 0x033DC,
    syouwaerasquare                         = 0x0337C,
    t                                       = 0x00074,
    tabengali                               = 0x009A4,
    tackdown                                = 0x022A4,
    tackleft                                = 0x022A3,
    tadeva                                  = 0x00924,
    tagujarati                              = 0x00AA4,
    tagurmukhi                              = 0x00A24,
    taharabic                               = 0x00637,
    tahfinalarabic                          = 0x0FEC2,
    tahinitialarabic                        = 0x0FEC3,
    tahiragana                              = 0x0305F,
    tahmedialarabic                         = 0x0FEC4,
    taisyouerasquare                        = 0x0337D,
    takatakana                              = 0x030BF,
    takatakanahalfwidth                     = 0x0FF80,
    tatweelarabic                           = 0x00640,
    tau                                     = 0x003C4,
    tav                                     = 0x005EA,
    tavdages                                = 0x0FB4A,
    tavdagesh                               = 0x0FB4A,
    tavdageshhebrew                         = 0x0FB4A,
    tavhebrew                               = 0x005EA,
    tbar                                    = 0x00167,
    tbopomofo                               = 0x0310A,
    tcaron                                  = 0x00165,
    tccurl                                  = 0x002A8,
    tcedilla                                = 0x00163,
    tcheharabic                             = 0x00686,
    tchehfinalarabic                        = 0x0FB7B,
    tchehinitialarabic                      = 0x0FB7C,
    tchehmedialarabic                       = 0x0FB7D,
    tchehmeeminitialarabic                  = 0x0FB7C,
    tcircle                                 = 0x024E3,
    tcircumflexbelow                        = 0x01E71,
    tcommaaccent                            = 0x00163,
    tdieresis                               = 0x01E97,
    tdotaccent                              = 0x01E6B,
    tdotbelow                               = 0x01E6D,
    tecyrillic                              = 0x00442,
    tedescendercyrillic                     = 0x004AD,
    teharabic                               = 0x0062A,
    tehfinalarabic                          = 0x0FE96,
    tehhahinitialarabic                     = 0x0FCA2,
    tehhahisolatedarabic                    = 0x0FC0C,
    tehinitialarabic                        = 0x0FE97,
    tehiragana                              = 0x03066,
    tehjeeminitialarabic                    = 0x0FCA1,
    tehjeemisolatedarabic                   = 0x0FC0B,
    tehmarbutaarabic                        = 0x00629,
    tehmarbutafinalarabic                   = 0x0FE94,
    tehmedialarabic                         = 0x0FE98,
    tehmeeminitialarabic                    = 0x0FCA4,
    tehmeemisolatedarabic                   = 0x0FC0E,
    tehnoonfinalarabic                      = 0x0FC73,
    tekatakana                              = 0x030C6,
    tekatakanahalfwidth                     = 0x0FF83,
    telephone                               = 0x02121,
    telephoneblack                          = 0x0260E,
    telishagedolahebrew                     = 0x005A0,
    telishaqetanahebrew                     = 0x005A9,
    tencircle                               = 0x02469,
    tenideographicparen                     = 0x03229,
    tenparen                                = 0x0247D,
    tenperiod                               = 0x02491,
    tenroman                                = 0x02179,
    tesh                                    = 0x002A7,
    tet                                     = 0x005D8,
    tetdagesh                               = 0x0FB38,
    tetdageshhebrew                         = 0x0FB38,
    tethebrew                               = 0x005D8,
    tetsecyrillic                           = 0x004B5,
    tevirhebrew                             = 0x0059B,
    tevirlefthebrew                         = 0x0059B,
    thabengali                              = 0x009A5,
    thadeva                                 = 0x00925,
    thagujarati                             = 0x00AA5,
    thagurmukhi                             = 0x00A25,
    thalarabic                              = 0x00630,
    thalfinalarabic                         = 0x0FEAC,
    thanthakhatthai                         = 0x00E4C,
    theharabic                              = 0x0062B,
    thehfinalarabic                         = 0x0FE9A,
    thehinitialarabic                       = 0x0FE9B,
    thehmedialarabic                        = 0x0FE9C,
    thereexists                             = 0x02203,
    therefore                               = 0x02234,
    theta                                   = 0x003B8,
    theta1                                  = 0x003D1,
    thetasymbolgreek                        = 0x003D1,
    thieuthacirclekorean                    = 0x03279,
    thieuthaparenkorean                     = 0x03219,
    thieuthcirclekorean                     = 0x0326B,
    thieuthkorean                           = 0x0314C,
    thieuthparenkorean                      = 0x0320B,
    thirteencircle                          = 0x0246C,
    thirteenparen                           = 0x02480,
    thirteenperiod                          = 0x02494,
    thonangmonthothai                       = 0x00E11,
    thook                                   = 0x001AD,
    thophuthaothai                          = 0x00E12,
    thorn                                   = 0x000FE,
    thothahanthai                           = 0x00E17,
    thothanthai                             = 0x00E10,
    thothongthai                            = 0x00E18,
    thothungthai                            = 0x00E16,
    thousandcyrillic                        = 0x00482,
    thousandsseparatorarabic                = 0x0066C,
    thousandsseparatorpersian               = 0x0066C,
    three                                   = 0x00033,
    threearabic                             = 0x00663,
    threebengali                            = 0x009E9,
    threecircle                             = 0x02462,
    threecircleinversesansserif             = 0x0278C,
    threedeva                               = 0x00969,
    threeeighths                            = 0x0215C,
    threegujarati                           = 0x00AE9,
    threegurmukhi                           = 0x00A69,
    threehackarabic                         = 0x00663,
    threehangzhou                           = 0x03023,
    threeideographicparen                   = 0x03222,
    threeinferior                           = 0x02083,
    threemonospace                          = 0x0FF13,
    threenumeratorbengali                   = 0x009F6,
    threeoldstyle                           = 0x00033,
    threeparen                              = 0x02476,
    threeperiod                             = 0x0248A,
    threepersian                            = 0x006F3,
    threequarters                           = 0x000BE,
    threeroman                              = 0x02172,
    threesuperior                           = 0x000B3,
    threethai                               = 0x00E53,
    thzsquare                               = 0x03394,
    tihiragana                              = 0x03061,
    tikatakana                              = 0x030C1,
    tikatakanahalfwidth                     = 0x0FF81,
    tikeutacirclekorean                     = 0x03270,
    tikeutaparenkorean                      = 0x03210,
    tikeutcirclekorean                      = 0x03262,
    tikeutkorean                            = 0x03137,
    tikeutparenkorean                       = 0x03202,
    tilde                                   = 0x002DC,
    tildebelowcmb                           = 0x00330,
    tildecmb                                = 0x00303,
    tildecomb                               = 0x00303,
    tildedoublecmb                          = 0x00360,
    tildeoperator                           = 0x0223C,
    tildeoverlaycmb                         = 0x00334,
    tildeverticalcmb                        = 0x0033E,
    timescircle                             = 0x02297,
    tipehahebrew                            = 0x00596,
    tipehalefthebrew                        = 0x00596,
    tippigurmukhi                           = 0x00A70,
    titlocyrilliccmb                        = 0x00483,
    tiwnarmenian                            = 0x0057F,
    tlinebelow                              = 0x01E6F,
    tmonospace                              = 0x0FF54,
    toarmenian                              = 0x00569,
    tohiragana                              = 0x03068,
    tokatakana                              = 0x030C8,
    tokatakanahalfwidth                     = 0x0FF84,
    tonebarextrahighmod                     = 0x002E5,
    tonebarextralowmod                      = 0x002E9,
    tonebarhighmod                          = 0x002E6,
    tonebarlowmod                           = 0x002E8,
    tonebarmidmod                           = 0x002E7,
    tonefive                                = 0x001BD,
    tonesix                                 = 0x00185,
    tonetwo                                 = 0x001A8,
    tonos                                   = 0x00384,
    tonsquare                               = 0x03327,
    topatakthai                             = 0x00E0F,
    tortoiseshellbracketleft                = 0x03014,
    tortoiseshellbracketleftsmall           = 0x0FE5D,
    tortoiseshellbracketleftvertical        = 0x0FE39,
    tortoiseshellbracketright               = 0x03015,
    tortoiseshellbracketrightsmall          = 0x0FE5E,
    tortoiseshellbracketrightvertical       = 0x0FE3A,
    totaothai                               = 0x00E15,
    tpalatalhook                            = 0x001AB,
    tparen                                  = 0x024AF,
    trademark                               = 0x02122,
    tretroflexhook                          = 0x00288,
    triagdn                                 = 0x025BC,
    triaglf                                 = 0x025C4,
    triagrt                                 = 0x025BA,
    triagup                                 = 0x025B2,
    ts                                      = 0x002A6,
    tsadi                                   = 0x005E6,
    tsadidagesh                             = 0x0FB46,
    tsadidageshhebrew                       = 0x0FB46,
    tsadihebrew                             = 0x005E6,
    tsecyrillic                             = 0x00446,
    tsere                                   = 0x005B5,
    tsere12                                 = 0x005B5,
    tsere1e                                 = 0x005B5,
    tsere2b                                 = 0x005B5,
    tserehebrew                             = 0x005B5,
    tserenarrowhebrew                       = 0x005B5,
    tserequarterhebrew                      = 0x005B5,
    tserewidehebrew                         = 0x005B5,
    tshecyrillic                            = 0x0045B,
    ttabengali                              = 0x0099F,
    ttadeva                                 = 0x0091F,
    ttagujarati                             = 0x00A9F,
    ttagurmukhi                             = 0x00A1F,
    tteharabic                              = 0x00679,
    ttehfinalarabic                         = 0x0FB67,
    ttehinitialarabic                       = 0x0FB68,
    ttehmedialarabic                        = 0x0FB69,
    tthabengali                             = 0x009A0,
    tthadeva                                = 0x00920,
    tthagujarati                            = 0x00AA0,
    tthagurmukhi                            = 0x00A20,
    tturned                                 = 0x00287,
    tuhiragana                              = 0x03064,
    tukatakana                              = 0x030C4,
    tukatakanahalfwidth                     = 0x0FF82,
    tusmallhiragana                         = 0x03063,
    tusmallkatakana                         = 0x030C3,
    tusmallkatakanahalfwidth                = 0x0FF6F,
    twelvecircle                            = 0x0246B,
    twelveparen                             = 0x0247F,
    twelveperiod                            = 0x02493,
    twelveroman                             = 0x0217B,
    twentycircle                            = 0x02473,
    twentyparen                             = 0x02487,
    twentyperiod                            = 0x0249B,
    two                                     = 0x00032,
    twoarabic                               = 0x00662,
    twobengali                              = 0x009E8,
    twocircle                               = 0x02461,
    twocircleinversesansserif               = 0x0278B,
    twodeva                                 = 0x00968,
    twodotenleader                          = 0x02025,
    twodotleader                            = 0x02025,
    twodotleadervertical                    = 0x0FE30,
    twogujarati                             = 0x00AE8,
    twogurmukhi                             = 0x00A68,
    twohackarabic                           = 0x00662,
    twohangzhou                             = 0x03022,
    twoideographicparen                     = 0x03221,
    twoinferior                             = 0x02082,
    twomonospace                            = 0x0FF12,
    twonumeratorbengali                     = 0x009F5,
    twooldstyle                             = 0x00032,
    twoparen                                = 0x02475,
    twoperiod                               = 0x02489,
    twopersian                              = 0x006F2,
    tworoman                                = 0x02171,
    twostroke                               = 0x001BB,
    twosuperior                             = 0x000B2,
    twothai                                 = 0x00E52,
    twothirds                               = 0x02154,
    u                                       = 0x00075,
    uacute                                  = 0x000FA,
    ubar                                    = 0x00289,
    ubengali                                = 0x00989,
    ubopomofo                               = 0x03128,
    ubreve                                  = 0x0016D,
    ucaron                                  = 0x001D4,
    ucircle                                 = 0x024E4,
    ucircumflex                             = 0x000FB,
    ucircumflexbelow                        = 0x01E77,
    ucyrillic                               = 0x00443,
    udattadeva                              = 0x00951,
    udblacute                               = 0x00171,
    udblgrave                               = 0x00215,
    udeva                                   = 0x00909,
    udieresis                               = 0x000FC,
    udieresisacute                          = 0x001D8,
    udieresisbelow                          = 0x01E73,
    udieresiscaron                          = 0x001DA,
    udieresiscyrillic                       = 0x004F1,
    udieresisgrave                          = 0x001DC,
    udieresismacron                         = 0x001D6,
    udotbelow                               = 0x01EE5,
    ugrave                                  = 0x000F9,
    ugujarati                               = 0x00A89,
    ugurmukhi                               = 0x00A09,
    uhiragana                               = 0x03046,
    uhookabove                              = 0x01EE7,
    uhorn                                   = 0x001B0,
    uhornacute                              = 0x01EE9,
    uhorndotbelow                           = 0x01EF1,
    uhorngrave                              = 0x01EEB,
    uhornhookabove                          = 0x01EED,
    uhorntilde                              = 0x01EEF,
    uhungarumlaut                           = 0x00171,
    uhungarumlautcyrillic                   = 0x004F3,
    uinvertedbreve                          = 0x00217,
    ukatakana                               = 0x030A6,
    ukatakanahalfwidth                      = 0x0FF73,
    ukcyrillic                              = 0x00479,
    ukorean                                 = 0x0315C,
    umacron                                 = 0x0016B,
    umacroncyrillic                         = 0x004EF,
    umacrondieresis                         = 0x01E7B,
    umatragurmukhi                          = 0x00A41,
    umonospace                              = 0x0FF55,
    underscore                              = 0x0005F,
    underscoredbl                           = 0x02017,
    underscoremonospace                     = 0x0FF3F,
    underscorevertical                      = 0x0FE33,
    underscorewavy                          = 0x0FE4F,
    union                                   = 0x0222A,
    universal                               = 0x02200,
    uogonek                                 = 0x00173,
    uparen                                  = 0x024B0,
    upblock                                 = 0x02580,
    upperdothebrew                          = 0x005C4,
    upsilon                                 = 0x003C5,
    upsilondieresis                         = 0x003CB,
    upsilondieresistonos                    = 0x003B0,
    upsilonlatin                            = 0x0028A,
    upsilontonos                            = 0x003CD,
    uptackbelowcmb                          = 0x0031D,
    uptackmod                               = 0x002D4,
    uragurmukhi                             = 0x00A73,
    uring                                   = 0x0016F,
    ushortcyrillic                          = 0x0045E,
    usmallhiragana                          = 0x03045,
    usmallkatakana                          = 0x030A5,
    usmallkatakanahalfwidth                 = 0x0FF69,
    ustraightcyrillic                       = 0x004AF,
    ustraightstrokecyrillic                 = 0x004B1,
    utilde                                  = 0x00169,
    utildeacute                             = 0x01E79,
    utildebelow                             = 0x01E75,
    uubengali                               = 0x0098A,
    uudeva                                  = 0x0090A,
    uugujarati                              = 0x00A8A,
    uugurmukhi                              = 0x00A0A,
    uumatragurmukhi                         = 0x00A42,
    uuvowelsignbengali                      = 0x009C2,
    uuvowelsigndeva                         = 0x00942,
    uuvowelsigngujarati                     = 0x00AC2,
    uvowelsignbengali                       = 0x009C1,
    uvowelsigndeva                          = 0x00941,
    uvowelsigngujarati                      = 0x00AC1,
    v                                       = 0x00076,
    vadeva                                  = 0x00935,
    vagujarati                              = 0x00AB5,
    vagurmukhi                              = 0x00A35,
    vakatakana                              = 0x030F7,
    vav                                     = 0x005D5,
    vavdagesh                               = 0x0FB35,
    vavdagesh65                             = 0x0FB35,
    vavdageshhebrew                         = 0x0FB35,
    vavhebrew                               = 0x005D5,
    vavholam                                = 0x0FB4B,
    vavholamhebrew                          = 0x0FB4B,
    vavvavhebrew                            = 0x005F0,
    vavyodhebrew                            = 0x005F1,
    vcircle                                 = 0x024E5,
    vdotbelow                               = 0x01E7F,
    vecyrillic                              = 0x00432,
    veharabic                               = 0x006A4,
    vehfinalarabic                          = 0x0FB6B,
    vehinitialarabic                        = 0x0FB6C,
    vehmedialarabic                         = 0x0FB6D,
    vekatakana                              = 0x030F9,
    venus                                   = 0x02640,
    verticalbar                             = 0x0007C,
    verticallineabovecmb                    = 0x0030D,
    verticallinebelowcmb                    = 0x00329,
    verticallinelowmod                      = 0x002CC,
    verticallinemod                         = 0x002C8,
    vewarmenian                             = 0x0057E,
    vhook                                   = 0x0028B,
    vikatakana                              = 0x030F8,
    viramabengali                           = 0x009CD,
    viramadeva                              = 0x0094D,
    viramagujarati                          = 0x00ACD,
    visargabengali                          = 0x00983,
    visargadeva                             = 0x00903,
    visargagujarati                         = 0x00A83,
    vmonospace                              = 0x0FF56,
    voarmenian                              = 0x00578,
    voicediterationhiragana                 = 0x0309E,
    voicediterationkatakana                 = 0x030FE,
    voicedmarkkana                          = 0x0309B,
    voicedmarkkanahalfwidth                 = 0x0FF9E,
    vokatakana                              = 0x030FA,
    vparen                                  = 0x024B1,
    vtilde                                  = 0x01E7D,
    vturned                                 = 0x0028C,
    vuhiragana                              = 0x03094,
    vukatakana                              = 0x030F4,
    w                                       = 0x00077,
    wacute                                  = 0x01E83,
    waekorean                               = 0x03159,
    wahiragana                              = 0x0308F,
    wakatakana                              = 0x030EF,
    wakatakanahalfwidth                     = 0x0FF9C,
    wakorean                                = 0x03158,
    wasmallhiragana                         = 0x0308E,
    wasmallkatakana                         = 0x030EE,
    wattosquare                             = 0x03357,
    wavedash                                = 0x0301C,
    wavyunderscorevertical                  = 0x0FE34,
    wawarabic                               = 0x00648,
    wawfinalarabic                          = 0x0FEEE,
    wawhamzaabovearabic                     = 0x00624,
    wawhamzaabovefinalarabic                = 0x0FE86,
    wbsquare                                = 0x033DD,
    wcircle                                 = 0x024E6,
    wcircumflex                             = 0x00175,
    wdieresis                               = 0x01E85,
    wdotaccent                              = 0x01E87,
    wdotbelow                               = 0x01E89,
    wehiragana                              = 0x03091,
    weierstrass                             = 0x02118,
    wekatakana                              = 0x030F1,
    wekorean                                = 0x0315E,
    weokorean                               = 0x0315D,
    wgrave                                  = 0x01E81,
    whitebullet                             = 0x025E6,
    whitecircle                             = 0x025CB,
    whitecircleinverse                      = 0x025D9,
    whitecornerbracketleft                  = 0x0300E,
    whitecornerbracketleftvertical          = 0x0FE43,
    whitecornerbracketright                 = 0x0300F,
    whitecornerbracketrightvertical         = 0x0FE44,
    whitediamond                            = 0x025C7,
    whitediamondcontainingblacksmalldiamond = 0x025C8,
    whitedownpointingsmalltriangle          = 0x025BF,
    whitedownpointingtriangle               = 0x025BD,
    whiteleftpointingsmalltriangle          = 0x025C3,
    whiteleftpointingtriangle               = 0x025C1,
    whitelenticularbracketleft              = 0x03016,
    whitelenticularbracketright             = 0x03017,
    whiterightpointingsmalltriangle         = 0x025B9,
    whiterightpointingtriangle              = 0x025B7,
    whitesmallsquare                        = 0x025AB,
    whitesmilingface                        = 0x0263A,
    whitesquare                             = 0x025A1,
    whitestar                               = 0x02606,
    whitetelephone                          = 0x0260F,
    whitetortoiseshellbracketleft           = 0x03018,
    whitetortoiseshellbracketright          = 0x03019,
    whiteuppointingsmalltriangle            = 0x025B5,
    whiteuppointingtriangle                 = 0x025B3,
    wihiragana                              = 0x03090,
    wikatakana                              = 0x030F0,
    wikorean                                = 0x0315F,
    wmonospace                              = 0x0FF57,
    wohiragana                              = 0x03092,
    wokatakana                              = 0x030F2,
    wokatakanahalfwidth                     = 0x0FF66,
    won                                     = 0x020A9,
    wonmonospace                            = 0x0FFE6,
    wowaenthai                              = 0x00E27,
    wparen                                  = 0x024B2,
    wring                                   = 0x01E98,
    wsuperior                               = 0x002B7,
    wturned                                 = 0x0028D,
    wynn                                    = 0x001BF,
    x                                       = 0x00078,
    xabovecmb                               = 0x0033D,
    xbopomofo                               = 0x03112,
    xcircle                                 = 0x024E7,
    xdieresis                               = 0x01E8D,
    xdotaccent                              = 0x01E8B,
    xeharmenian                             = 0x0056D,
    xi                                      = 0x003BE,
    xmonospace                              = 0x0FF58,
    xparen                                  = 0x024B3,
    xsuperior                               = 0x002E3,
    y                                       = 0x00079,
    yaadosquare                             = 0x0334E,
    yabengali                               = 0x009AF,
    yacute                                  = 0x000FD,
    yadeva                                  = 0x0092F,
    yaekorean                               = 0x03152,
    yagujarati                              = 0x00AAF,
    yagurmukhi                              = 0x00A2F,
    yahiragana                              = 0x03084,
    yakatakana                              = 0x030E4,
    yakatakanahalfwidth                     = 0x0FF94,
    yakorean                                = 0x03151,
    yamakkanthai                            = 0x00E4E,
    yasmallhiragana                         = 0x03083,
    yasmallkatakana                         = 0x030E3,
    yasmallkatakanahalfwidth                = 0x0FF6C,
    yatcyrillic                             = 0x00463,
    ycircle                                 = 0x024E8,
    ycircumflex                             = 0x00177,
    ydieresis                               = 0x000FF,
    ydotaccent                              = 0x01E8F,
    ydotbelow                               = 0x01EF5,
    yeharabic                               = 0x0064A,
    yehbarreearabic                         = 0x006D2,
    yehbarreefinalarabic                    = 0x0FBAF,
    yehfinalarabic                          = 0x0FEF2,
    yehhamzaabovearabic                     = 0x00626,
    yehhamzaabovefinalarabic                = 0x0FE8A,
    yehhamzaaboveinitialarabic              = 0x0FE8B,
    yehhamzaabovemedialarabic               = 0x0FE8C,
    yehinitialarabic                        = 0x0FEF3,
    yehmedialarabic                         = 0x0FEF4,
    yehmeeminitialarabic                    = 0x0FCDD,
    yehmeemisolatedarabic                   = 0x0FC58,
    yehnoonfinalarabic                      = 0x0FC94,
    yehthreedotsbelowarabic                 = 0x006D1,
    yekorean                                = 0x03156,
    yen                                     = 0x000A5,
    yenmonospace                            = 0x0FFE5,
    yeokorean                               = 0x03155,
    yeorinhieuhkorean                       = 0x03186,
    yerahbenyomohebrew                      = 0x005AA,
    yerahbenyomolefthebrew                  = 0x005AA,
    yericyrillic                            = 0x0044B,
    yerudieresiscyrillic                    = 0x004F9,
    yesieungkorean                          = 0x03181,
    yesieungpansioskorean                   = 0x03183,
    yesieungsioskorean                      = 0x03182,
    yetivhebrew                             = 0x0059A,
    ygrave                                  = 0x01EF3,
    yhook                                   = 0x001B4,
    yhookabove                              = 0x01EF7,
    yiarmenian                              = 0x00575,
    yicyrillic                              = 0x00457,
    yikorean                                = 0x03162,
    yinyang                                 = 0x0262F,
    yiwnarmenian                            = 0x00582,
    ymonospace                              = 0x0FF59,
    yod                                     = 0x005D9,
    yoddagesh                               = 0x0FB39,
    yoddageshhebrew                         = 0x0FB39,
    yodhebrew                               = 0x005D9,
    yodyodhebrew                            = 0x005F2,
    yodyodpatahhebrew                       = 0x0FB1F,
    yohiragana                              = 0x03088,
    yoikorean                               = 0x03189,
    yokatakana                              = 0x030E8,
    yokatakanahalfwidth                     = 0x0FF96,
    yokorean                                = 0x0315B,
    yosmallhiragana                         = 0x03087,
    yosmallkatakana                         = 0x030E7,
    yosmallkatakanahalfwidth                = 0x0FF6E,
    yotgreek                                = 0x003F3,
    yoyaekorean                             = 0x03188,
    yoyakorean                              = 0x03187,
    yoyakthai                               = 0x00E22,
    yoyingthai                              = 0x00E0D,
    yparen                                  = 0x024B4,
    ypogegrammeni                           = 0x0037A,
    ypogegrammenigreekcmb                   = 0x00345,
    yr                                      = 0x001A6,
    yring                                   = 0x01E99,
    ysuperior                               = 0x002B8,
    ytilde                                  = 0x01EF9,
    yturned                                 = 0x0028E,
    yuhiragana                              = 0x03086,
    yuikorean                               = 0x0318C,
    yukatakana                              = 0x030E6,
    yukatakanahalfwidth                     = 0x0FF95,
    yukorean                                = 0x03160,
    yusbigcyrillic                          = 0x0046B,
    yusbigiotifiedcyrillic                  = 0x0046D,
    yuslittlecyrillic                       = 0x00467,
    yuslittleiotifiedcyrillic               = 0x00469,
    yusmallhiragana                         = 0x03085,
    yusmallkatakana                         = 0x030E5,
    yusmallkatakanahalfwidth                = 0x0FF6D,
    yuyekorean                              = 0x0318B,
    yuyeokorean                             = 0x0318A,
    yyabengali                              = 0x009DF,
    yyadeva                                 = 0x0095F,
    z                                       = 0x0007A,
    zaarmenian                              = 0x00566,
    zacute                                  = 0x0017A,
    zadeva                                  = 0x0095B,
    zagurmukhi                              = 0x00A5B,
    zaharabic                               = 0x00638,
    zahfinalarabic                          = 0x0FEC6,
    zahinitialarabic                        = 0x0FEC7,
    zahiragana                              = 0x03056,
    zahmedialarabic                         = 0x0FEC8,
    zainarabic                              = 0x00632,
    zainfinalarabic                         = 0x0FEB0,
    zakatakana                              = 0x030B6,
    zaqefgadolhebrew                        = 0x00595,
    zaqefqatanhebrew                        = 0x00594,
    zarqahebrew                             = 0x00598,
    zayin                                   = 0x005D6,
    zayindagesh                             = 0x0FB36,
    zayindageshhebrew                       = 0x0FB36,
    zayinhebrew                             = 0x005D6,
    zbopomofo                               = 0x03117,
    zcaron                                  = 0x0017E,
    zcircle                                 = 0x024E9,
    zcircumflex                             = 0x01E91,
    zcurl                                   = 0x00291,
    zdot                                    = 0x0017C,
    zdotaccent                              = 0x0017C,
    zdotbelow                               = 0x01E93,
    zecyrillic                              = 0x00437,
    zedescendercyrillic                     = 0x00499,
    zedieresiscyrillic                      = 0x004DF,
    zehiragana                              = 0x0305C,
    zekatakana                              = 0x030BC,
    zero                                    = 0x00030,
    zeroarabic                              = 0x00660,
    zerobengali                             = 0x009E6,
    zerodeva                                = 0x00966,
    zerogujarati                            = 0x00AE6,
    zerogurmukhi                            = 0x00A66,
    zerohackarabic                          = 0x00660,
    zeroinferior                            = 0x02080,
    zeromonospace                           = 0x0FF10,
    zerooldstyle                            = 0x00030,
    zeropersian                             = 0x006F0,
    zerosuperior                            = 0x02070,
    zerothai                                = 0x00E50,
    zerowidthjoiner                         = 0x0FEFF,
    zerowidthnonjoiner                      = 0x0200C,
    zerowidthspace                          = 0x0200B,
    zeta                                    = 0x003B6,
    zhbopomofo                              = 0x03113,
    zhearmenian                             = 0x0056A,
    zhebrevecyrillic                        = 0x004C2,
    zhecyrillic                             = 0x00436,
    zhedescendercyrillic                    = 0x00497,
    zhedieresiscyrillic                     = 0x004DD,
    zihiragana                              = 0x03058,
    zikatakana                              = 0x030B8,
    zinorhebrew                             = 0x005AE,
    zlinebelow                              = 0x01E95,
    zmonospace                              = 0x0FF5A,
    zohiragana                              = 0x0305E,
    zokatakana                              = 0x030BE,
    zparen                                  = 0x024B5,
    zretroflexhook                          = 0x00290,
    zstroke                                 = 0x001B6,
    zuhiragana                              = 0x0305A,
    zukatakana                              = 0x030BA,
}

local synonyms = allocate {
    Acyrillic                      = 0x0410,
    Becyrillic                     = 0x0411,
    Cdot                           = 0x010A,
    Checyrillic                    = 0x0427,
    Decyrillic                     = 0x0414,
    Djecyrillic                    = 0x0402,
    Dzecyrillic                    = 0x0405,
    Dzhecyrillic                   = 0x040F,
    Ecyrillic                      = 0x0404,
    Edot                           = 0x0116,
    Efcyrillic                     = 0x0424,
    Elcyrillic                     = 0x041B,
    Emcyrillic                     = 0x041C,
    Encyrillic                     = 0x041D,
    Ercyrillic                     = 0x0420,
    Ereversedcyrillic              = 0x042D,
    Escyrillic                     = 0x0421,
    Fitacyrillic                   = 0x0472,
    Gcedilla                       = 0x0122,
    Gdot                           = 0x0120,
    Gecyrillic                     = 0x0413,
    Gheupturncyrillic              = 0x0490,
    Gjecyrillic                    = 0x0403,
    Hardsigncyrillic               = 0x042A,
    IAcyrillic                     = 0x042F,
    IUcyrillic                     = 0x042E,
    Icyrillic                      = 0x0406,
    Idot                           = 0x0130,
    Iecyrillic                     = 0x0415,
    Iicyrillic                     = 0x0418,
    Iishortcyrillic                = 0x0419,
    Iocyrillic                     = 0x0401,
    Izhitsacyrillic                = 0x0474,
    Jecyrillic                     = 0x0408,
    Kacyrillic                     = 0x041A,
    Kcedilla                       = 0x0136,
    Khacyrillic                    = 0x0425,
    Kjecyrillic                    = 0x040C,
    Lcedilla                       = 0x013B,
    Ljecyrillic                    = 0x0409,
    Ncedilla                       = 0x0145,
    Njecyrillic                    = 0x040A,
    Ocyrillic                      = 0x041E,
    Odblacute                      = 0x0150,
    Ohm                            = 0x2126,
    Pecyrillic                     = 0x041F,
    Rcedilla                       = 0x0156,
    Shacyrillic                    = 0x0428,
    Shchacyrillic                  = 0x0429,
    Softsigncyrillic               = 0x042C,
    Tcedilla                       = 0x0162,
    Tecyrillic                     = 0x0422,
    Tsecyrillic                    = 0x0426,
    Tshecyrillic                   = 0x040B,
    Ucyrillic                      = 0x0423,
    Udblacute                      = 0x0170,
    Ushortcyrillic                 = 0x040E,
    Vecyrillic                     = 0x0412,
    Yatcyrillic                    = 0x0462,
    Yericyrillic                   = 0x042B,
    Yicyrillic                     = 0x0407,
    Zdot                           = 0x017B,
    Zecyrillic                     = 0x0417,
    Zhecyrillic                    = 0x0416,
    acutecmb                       = 0x0301,
    acyrillic                      = 0x0430,
    afii00208                      = 0x2015,
    afii08941                      = 0x20A4,
    afii57694                      = 0xFB2A,
    afii57695                      = 0xFB2B,
    afii57700                      = 0xFB4B,
    afii57705                      = 0xFB1F,
    afii57723                      = 0xFB35,
    alef                           = 0x05D0,
    alefmaksurainitialarabic       = 0xFEF3,
    alefmaksuramedialarabic        = 0xFEF4,
    approximatelyequal             = 0x2245,
    asteriskaltonearabic           = 0x066D,
    ayin                           = 0x05E2,
    bet                            = 0x05D1,
    betdagesh                      = 0xFB31,
    blackdownpointingtriangle      = 0x25BC,
    blackleftpointingpointer       = 0x25C4,
    blackrectangle                 = 0x25AC,
    blackrightpointingpointer      = 0x25BA,
    blacksmilingface               = 0x263B,
    blacksquare                    = 0x25A0,
    blackuppointingtriangle        = 0x25B2,
    bulletinverse                  = 0x25D8,
    cdot                           = 0x010B,
    compass                        = 0x263C,
    dagesh                         = 0x05BC,
    dalet                          = 0x05D3,
    daletdagesh                    = 0xFB33,
    dalethatafpatah                = 0x05D3,
    dalethatafpatahhebrew          = 0x05D3,
    dalethatafsegol                = 0x05D3,
    dalethatafsegolhebrew          = 0x05D3,
    dalethebrew                    = 0x05D3,
    dalethiriq                     = 0x05D3,
    dalethiriqhebrew               = 0x05D3,
    daletholam                     = 0x05D3,
    daletholamhebrew               = 0x05D3,
    daletpatah                     = 0x05D3,
    daletpatahhebrew               = 0x05D3,
    daletqamats                    = 0x05D3,
    daletqamatshebrew              = 0x05D3,
    daletqubuts                    = 0x05D3,
    daletqubutshebrew              = 0x05D3,
    daletsegol                     = 0x05D3,
    daletsegolhebrew               = 0x05D3,
    daletsheva                     = 0x05D3,
    daletshevahebrew               = 0x05D3,
    dalettsere                     = 0x05D3,
    dammaarabic                    = 0x064F,
    dammatanaltonearabic           = 0x064C,
    dargahebrew                    = 0x05A7,
    dbllowline                     = 0x2017,
    decimalseparatorarabic         = 0x066B,
    dialytikatonos                 = 0x0385,
    dotbelowcmb                    = 0x0323,
    doubleyodpatah                 = 0xFB1F,
    doubleyodpatahhebrew           = 0xFB1F,
    edot                           = 0x0117,
    eightarabic                    = 0x0668,
    eighthnotebeamed               = 0x266B,
    etnahtafoukhhebrew             = 0x0591,
    etnahtafoukhlefthebrew         = 0x0591,
    etnahtahebrew                  = 0x0591,
    fathaarabic                    = 0x064E,
    finalkaf                       = 0x05DA,
    finalkafdagesh                 = 0xFB3A,
    finalkafhebrew                 = 0x05DA,
    finalkafqamats                 = 0x05DA,
    finalkafqamatshebrew           = 0x05DA,
    finalkafsheva                  = 0x05DA,
    finalmem                       = 0x05DD,
    finalnun                       = 0x05DF,
    finalpe                        = 0x05E3,
    finaltsadi                     = 0x05E5,
    fivearabic                     = 0x0665,
    forall                         = 0x2200,
    fourarabic                     = 0x0664,
    gcedilla                       = 0x0123,
    gdot                           = 0x0121,
    gimel                          = 0x05D2,
    gimeldagesh                    = 0xFB32,
    gravecmb                       = 0x0300,
    haaltonearabic                 = 0x06C1,
    hamzaarabic                    = 0x0621,
    hamzadammaarabic               = 0x0621,
    hamzadammatanarabic            = 0x0621,
    hamzafathaarabic               = 0x0621,
    hamzafathatanarabic            = 0x0621,
    hamzalowarabic                 = 0x0621,
    hamzalowkasraarabic            = 0x0621,
    hamzalowkasratanarabic         = 0x0621,
    hatafpatah                     = 0x05B2,
    hatafpatah16                   = 0x05B2,
    hatafpatah23                   = 0x05B2,
    hatafpatah2f                   = 0x05B2,
    hatafpatahhebrew               = 0x05B2,
    hatafpatahnarrowhebrew         = 0x05B2,
    hatafpatahquarterhebrew        = 0x05B2,
    hatafqamats                    = 0x05B3,
    hatafqamats1b                  = 0x05B3,
    hatafqamats28                  = 0x05B3,
    hatafqamats34                  = 0x05B3,
    hatafqamatshebrew              = 0x05B3,
    hatafqamatsnarrowhebrew        = 0x05B3,
    hatafqamatsquarterhebrew       = 0x05B3,
    hatafsegol                     = 0x05B1,
    hatafsegol17                   = 0x05B1,
    hatafsegol24                   = 0x05B1,
    hatafsegol30                   = 0x05B1,
    hatafsegolhebrew               = 0x05B1,
    hatafsegolnarrowhebrew         = 0x05B1,
    hatafsegolquarterhebrew        = 0x05B1,
    he                             = 0x05D4,
    hedagesh                       = 0xFB34,
    hehfinalalttwoarabic           = 0xFEEA,
    het                            = 0x05D7,
    hiriq                          = 0x05B4,
    hiriq14                        = 0x05B4,
    hiriq21                        = 0x05B4,
    hiriq2d                        = 0x05B4,
    hiriqhebrew                    = 0x05B4,
    hiriqnarrowhebrew              = 0x05B4,
    hiriqquarterhebrew             = 0x05B4,
    holam                          = 0x05B9,
    holam19                        = 0x05B9,
    holam26                        = 0x05B9,
    holam32                        = 0x05B9,
    holamhebrew                    = 0x05B9,
    holamnarrowhebrew              = 0x05B9,
    holamquarterhebrew             = 0x05B9,
    ilde                           = 0x02DC,
    integralbottom                 = 0x2321,
    integraltop                    = 0x2320,
    kaf                            = 0x05DB,
    kafdagesh                      = 0xFB3B,
    kashidaautoarabic              = 0x0640,
    kashidaautonosidebearingarabic = 0x0640,
    kcedilla                       = 0x0137,
    lamed                          = 0x05DC,
    lameddagesh                    = 0xFB3C,
    lamedhebrew                    = 0x05DC,
    lamedholam                     = 0x05DC,
    lamedholamdagesh               = 0x05DC,
    lamedholamdageshhebrew         = 0x05DC,
    laminitialarabic               = 0xFEDF,
    lammeemjeeminitialarabic       = 0xFEDF,
    lcedilla                       = 0x013C,
    logicalnotreversed             = 0x2310,
    mahapakhhebrew                 = 0x05A4,
    mem                            = 0x05DE,
    memdagesh                      = 0xFB3E,
    merkhahebrew                   = 0x05A5,
    merkhakefulahebrew             = 0x05A6,
    middot                         = 0x00B7,
    munahhebrew                    = 0x05A3,
    nbspace                        = 0x00A0,
    ncedilla                       = 0x0146,
    newsheqelsign                  = 0x20AA,
    ninearabic                     = 0x0669,
    noonhehinitialarabic           = 0xFEE7,
    nun                            = 0x05E0,
    nundagesh                      = 0xFB40,
    odblacute                      = 0x0151,
    onearabic                      = 0x0661,
    overscore                      = 0x00AF,
    patah                          = 0x05B7,
    patah11                        = 0x05B7,
    patah1d                        = 0x05B7,
    patah2a                        = 0x05B7,
    patahhebrew                    = 0x05B7,
    patahnarrowhebrew              = 0x05B7,
    patahquarterhebrew             = 0x05B7,
    pe                             = 0x05E4,
    pedagesh                       = 0xFB44,
    qamats                         = 0x05B8,
    qamats10                       = 0x05B8,
    qamats1a                       = 0x05B8,
    qamats1c                       = 0x05B8,
    qamats27                       = 0x05B8,
    qamats29                       = 0x05B8,
    qamats33                       = 0x05B8,
    qamatsde                       = 0x05B8,
    qamatshebrew                   = 0x05B8,
    qamatsnarrowhebrew             = 0x05B8,
    qamatsqatanhebrew              = 0x05B8,
    qamatsqatannarrowhebrew        = 0x05B8,
    qamatsqatanquarterhebrew       = 0x05B8,
    qamatsqatanwidehebrew          = 0x05B8,
    qamatsquarterhebrew            = 0x05B8,
    qof                            = 0x05E7,
    qofdagesh                      = 0xFB47,
    qofhatafpatah                  = 0x05E7,
    qofhatafpatahhebrew            = 0x05E7,
    qofhatafsegol                  = 0x05E7,
    qofhatafsegolhebrew            = 0x05E7,
    qofhebrew                      = 0x05E7,
    qofhiriq                       = 0x05E7,
    qofhiriqhebrew                 = 0x05E7,
    qofholam                       = 0x05E7,
    qofholamhebrew                 = 0x05E7,
    qofpatah                       = 0x05E7,
    qofpatahhebrew                 = 0x05E7,
    qofqamats                      = 0x05E7,
    qofqamatshebrew                = 0x05E7,
    qofqubuts                      = 0x05E7,
    qofqubutshebrew                = 0x05E7,
    qofsegol                       = 0x05E7,
    qofsegolhebrew                 = 0x05E7,
    qofsheva                       = 0x05E7,
    qofshevahebrew                 = 0x05E7,
    qoftsere                       = 0x05E7,
    qubuts                         = 0x05BB,
    qubuts18                       = 0x05BB,
    qubuts25                       = 0x05BB,
    qubuts31                       = 0x05BB,
    qubutshebrew                   = 0x05BB,
    qubutsnarrowhebrew             = 0x05BB,
    qubutsquarterhebrew            = 0x05BB,
    quoteleftreversed              = 0x201B,
    rafe                           = 0x05BF,
    rcedilla                       = 0x0157,
    reharabic                      = 0x0631,
    resh                           = 0x05E8,
    reshhatafpatah                 = 0x05E8,
    reshhatafpatahhebrew           = 0x05E8,
    reshhatafsegol                 = 0x05E8,
    reshhatafsegolhebrew           = 0x05E8,
    reshhebrew                     = 0x05E8,
    reshhiriq                      = 0x05E8,
    reshhiriqhebrew                = 0x05E8,
    reshholam                      = 0x05E8,
    reshholamhebrew                = 0x05E8,
    reshpatah                      = 0x05E8,
    reshpatahhebrew                = 0x05E8,
    reshqamats                     = 0x05E8,
    reshqamatshebrew               = 0x05E8,
    reshqubuts                     = 0x05E8,
    reshqubutshebrew               = 0x05E8,
    reshsegol                      = 0x05E8,
    reshsegolhebrew                = 0x05E8,
    reshsheva                      = 0x05E8,
    reshshevahebrew                = 0x05E8,
    reshtsere                      = 0x05E8,
    reviahebrew                    = 0x0597,
    samekh                         = 0x05E1,
    samekhdagesh                   = 0xFB41,
    segol                          = 0x05B6,
    segol13                        = 0x05B6,
    segol1f                        = 0x05B6,
    segol2c                        = 0x05B6,
    segolhebrew                    = 0x05B6,
    segolnarrowhebrew              = 0x05B6,
    segolquarterhebrew             = 0x05B6,
    sevenarabic                    = 0x0667,
    sfthyphen                      = 0x00AD,
    shaddaarabic                   = 0x0651,
    sheqel                         = 0x20AA,
    sheva                          = 0x05B0,
    sheva115                       = 0x05B0,
    sheva15                        = 0x05B0,
    sheva22                        = 0x05B0,
    sheva2e                        = 0x05B0,
    shevahebrew                    = 0x05B0,
    shevanarrowhebrew              = 0x05B0,
    shevaquarterhebrew             = 0x05B0,
    shin                           = 0x05E9,
    shindagesh                     = 0xFB49,
    shindageshshindot              = 0xFB2C,
    shindageshsindot               = 0xFB2D,
    shinshindot                    = 0xFB2A,
    shinsindot                     = 0xFB2B,
    siluqhebrew                    = 0x05BD,
    sixarabic                      = 0x0666,
    tav                            = 0x05EA,
    tavdages                       = 0xFB4A,
    tavdagesh                      = 0xFB4A,
    tcedilla                       = 0x0163,
    tchehinitialarabic             = 0xFB7C,
    tet                            = 0x05D8,
    tetdagesh                      = 0xFB38,
    tevirhebrew                    = 0x059B,
    thousandsseparatorarabic       = 0x066C,
    threearabic                    = 0x0663,
    tildecmb                       = 0x0303,
    tipehahebrew                   = 0x0596,
    tsadi                          = 0x05E6,
    tsadidagesh                    = 0xFB46,
    tsere                          = 0x05B5,
    tsere12                        = 0x05B5,
    tsere1e                        = 0x05B5,
    tsere2b                        = 0x05B5,
    tserehebrew                    = 0x05B5,
    tserenarrowhebrew              = 0x05B5,
    tserequarterhebrew             = 0x05B5,
    twoarabic                      = 0x0662,
    udblacute                      = 0x0171,
    vav                            = 0x05D5,
    vavdagesh                      = 0xFB35,
    vavdagesh65                    = 0xFB35,
    vavholam                       = 0xFB4B,
    yerahbenyomohebrew             = 0x05AA,
    yod                            = 0x05D9,
    yoddagesh                      = 0xFB39,
    zayin                          = 0x05D6,
    zayindagesh                    = 0xFB36,
    zdot                           = 0x017C,
    zeroarabic                     = 0x0660,
}

local extras = allocate { -- private extensions
    Dcroat          = 0x0110,
    Delta           = 0x2206,
    Euro            = 0x20AC,
    H18533          = 0x25CF,
    H18543          = 0x25AA,
    H18551          = 0x25AB,
    H22073          = 0x25A1,
    Ldot            = 0x013F,
    Oslashacute     = 0x01FE,
    SF10000         = 0x250C,
    SF20000         = 0x2514,
    SF30000         = 0x2510,
    SF40000         = 0x2518,
    SF50000         = 0x253C,
    SF60000         = 0x252C,
    SF70000         = 0x2534,
    SF80000         = 0x251C,
    SF90000         = 0x2524,
    Upsilon1        = 0x03D2,
    afii10066       = 0x0431,
    afii10067       = 0x0432,
    afii10068       = 0x0433,
    afii10069       = 0x0434,
    afii10070       = 0x0435,
    afii10071       = 0x0451,
    afii10072       = 0x0436,
    afii10073       = 0x0437,
    afii10074       = 0x0438,
    afii10075       = 0x0439,
    afii10076       = 0x043A,
    afii10077       = 0x043B,
    afii10078       = 0x043C,
    afii10079       = 0x043D,
    afii10080       = 0x043E,
    afii10081       = 0x043F,
    afii10082       = 0x0440,
    afii10083       = 0x0441,
    afii10084       = 0x0442,
    afii10085       = 0x0443,
    afii10086       = 0x0444,
    afii10087       = 0x0445,
    afii10088       = 0x0446,
    afii10089       = 0x0447,
    afii10090       = 0x0448,
    afii10091       = 0x0449,
    afii10092       = 0x044A,
    afii10093       = 0x044B,
    afii10094       = 0x044C,
    afii10095       = 0x044D,
    afii10096       = 0x044E,
    afii10097       = 0x044F,
    afii10098       = 0x0491,
    afii10099       = 0x0452,
    afii10100       = 0x0453,
    afii10101       = 0x0454,
    afii10102       = 0x0455,
    afii10103       = 0x0456,
    afii10104       = 0x0457,
    afii10105       = 0x0458,
    afii10106       = 0x0459,
    afii10107       = 0x045A,
    afii10108       = 0x045B,
    afii10109       = 0x045C,
    afii10110       = 0x045E,
    afii10193       = 0x045F,
    afii10194       = 0x0463,
    afii10195       = 0x0473,
    afii10196       = 0x0475,
    afii10846       = 0x04D9,
    afii208         = 0x2015,
    afii57381       = 0x066A,
    afii57388       = 0x060C,
    afii57392       = 0x0660,
    afii57393       = 0x0661,
    afii57394       = 0x0662,
    afii57395       = 0x0663,
    afii57396       = 0x0664,
    afii57397       = 0x0665,
    afii57398       = 0x0666,
    afii57399       = 0x0667,
    afii57400       = 0x0668,
    afii57401       = 0x0669,
    afii57403       = 0x061B,
    afii57407       = 0x061F,
    afii57409       = 0x0621,
    afii57410       = 0x0622,
    afii57411       = 0x0623,
    afii57412       = 0x0624,
    afii57413       = 0x0625,
    afii57414       = 0x0626,
    afii57415       = 0x0627,
    afii57416       = 0x0628,
    afii57417       = 0x0629,
    afii57418       = 0x062A,
    afii57419       = 0x062B,
    afii57420       = 0x062C,
    afii57421       = 0x062D,
    afii57422       = 0x062E,
    afii57423       = 0x062F,
    afii57424       = 0x0630,
    afii57425       = 0x0631,
    afii57426       = 0x0632,
    afii57427       = 0x0633,
    afii57428       = 0x0634,
    afii57429       = 0x0635,
    afii57430       = 0x0636,
    afii57431       = 0x0637,
    afii57432       = 0x0638,
    afii57433       = 0x0639,
    afii57434       = 0x063A,
    afii57440       = 0x0640,
    afii57441       = 0x0641,
    afii57442       = 0x0642,
    afii57443       = 0x0643,
    afii57444       = 0x0644,
    afii57445       = 0x0645,
    afii57446       = 0x0646,
    afii57448       = 0x0648,
    afii57449       = 0x0649,
    afii57450       = 0x064A,
    afii57451       = 0x064B,
    afii57452       = 0x064C,
    afii57453       = 0x064D,
    afii57454       = 0x064E,
    afii57455       = 0x064F,
    afii57456       = 0x0650,
    afii57457       = 0x0651,
    afii57458       = 0x0652,
    afii57470       = 0x0647,
    afii57505       = 0x06A4,
    afii57506       = 0x067E,
    afii57507       = 0x0686,
    afii57508       = 0x0698,
    afii57509       = 0x06AF,
    afii57511       = 0x0679,
    afii57512       = 0x0688,
    afii57513       = 0x0691,
    afii57514       = 0x06BA,
    afii57519       = 0x06D2,
    afii57636       = 0x20AA,
    afii57645       = 0x05BE,
    afii57658       = 0x05C3,
    afii57664       = 0x05D0,
    afii57665       = 0x05D1,
    afii57666       = 0x05D2,
    afii57667       = 0x05D3,
    afii57668       = 0x05D4,
    afii57669       = 0x05D5,
    afii57670       = 0x05D6,
    afii57671       = 0x05D7,
    afii57672       = 0x05D8,
    afii57673       = 0x05D9,
    afii57674       = 0x05DA,
    afii57675       = 0x05DB,
    afii57676       = 0x05DC,
    afii57677       = 0x05DD,
    afii57678       = 0x05DE,
    afii57679       = 0x05DF,
    afii57680       = 0x05E0,
    afii57681       = 0x05E1,
    afii57682       = 0x05E2,
    afii57683       = 0x05E3,
    afii57684       = 0x05E4,
    afii57685       = 0x05E5,
    afii57686       = 0x05E6,
    afii57687       = 0x05E7,
    afii57688       = 0x05E8,
    afii57689       = 0x05E9,
    afii57690       = 0x05EA,
    afii57716       = 0x05F0,
    afii57717       = 0x05F1,
    afii57718       = 0x05F2,
    afii57793       = 0x05B4,
    afii57794       = 0x05B5,
    afii57795       = 0x05B6,
    afii57796       = 0x05BB,
    afii57797       = 0x05B8,
    afii57798       = 0x05B7,
    afii57799       = 0x05B0,
    afii57800       = 0x05B2,
    afii57801       = 0x05B1,
    afii57802       = 0x05B3,
    afii57803       = 0x05C2,
    afii57804       = 0x05C1,
    afii57806       = 0x05B9,
    afii57807       = 0x05BC,
    afii57839       = 0x05BD,
    afii57841       = 0x05BF,
    afii57842       = 0x05C0,
    afii57929       = 0x02BC,
    afii61248       = 0x2105,
    afii61289       = 0x2113,
    afii61352       = 0x2116,
    afii61664       = 0x200C,
    afii63167       = 0x066D,
    afii64937       = 0x02BD,
    arrowdblboth    = 0x21D4,
    arrowdblleft    = 0x21D0,
    arrowdblright   = 0x21D2,
    arrowupdnbse    = 0x21A8,
    bar             = 0x007C,
    circle          = 0x25CB,
    circlemultiply  = 0x2297,
    circleplus      = 0x2295,
    club            = 0x2663,
    colonmonetary   = 0x20A1,
    dcroat          = 0x0111,
    dkshade         = 0x2593,
    existential     = 0x2203,
    female          = 0x2640,
    gradient        = 0x2207,
    heart           = 0x2665,
    hookabovecomb   = 0x0309,
    invcircle       = 0x25D9,
    ldot            = 0x0140,
    longs           = 0x017F,
    ltshade         = 0x2591,
    male            = 0x2642,
    mu              = 0x00B5,
    napostrophe     = 0x0149,
    notelement      = 0x2209,
    omega1          = 0x03D6,
    openbullet      = 0x25E6,
    orthogonal      = 0x221F,
    oslashacute     = 0x01FF,
    phi1            = 0x03D5,
    propersubset    = 0x2282,
    propersuperset  = 0x2283,
    reflexsubset    = 0x2286,
    reflexsuperset  = 0x2287,
    shade           = 0x2592,
    sigma1          = 0x03C2,
    similar         = 0x223C,
    smileface       = 0x263A,
    spacehackarabic = 0x0020,
    spade           = 0x2660,
    theta1          = 0x03D1,
    twodotenleader  = 0x2025,

    zerooldstyle    = 0x0030,
    oneoldstyle     = 0x0031,
    twooldstyle     = 0x0032,
    threeoldstyle   = 0x0033,
    fouroldstyle    = 0x0034,
    fiveoldstyle    = 0x0035,
    sixoldstyle     = 0x0036,
    sevenoldstyle   = 0x0037,
    eightoldstyle   = 0x0038,
    nineoldstyle    = 0x0039,

    dotlessj        = 0x0237,
}

-- We load this table only when needed. We could use a loading mechanism
-- return the table but there are no more vectors like this so why bother.
--
-- Well, we currently have this table preloaded anyway.

local names    = agl.names
----- unicodes = agl.unicodes
local ctxcodes = agl.ctxcodes

if names then

    mark(names)
    mark(unicodes)
    mark(ctxcodes)

elseif characters then

    names    = allocate { } -- filled from char-def.lua
 -- unicodes = allocate { }
    ctxcodes = allocate { }

    for u, c in next, characters.data do
     -- local a = c.adobename
     -- if a then
     --  -- unicodes[a] = u
     --     names   [u] = a
     -- end
        local n = c.contextname
        if n then
            ctxcodes[n] = u
         -- names   [u] = a
        end
    end

    for a, u in next, extras do
        unicodes[a] = u
     -- if names[u] then
     --     -- comment
     --  -- print("dup extra",a,u)
     -- else
     --     names[u] = a
     -- end
    end

    for s, u in next, synonyms do
        unicodes[s] = u
     -- if names[u] then
     --     -- comment
     --  -- print("dup synonym",s,u)
     -- else
     --     names[u] = s
     -- end
    end

    if storage then
     -- storage.register("encodings/names",    names,    "fonts.encodings.agl.names")
        storage.register("encodings/unicodes", unicodes, "fonts.encodings.agl.unicodes")
        storage.register("encodings/ctxcodes", ctxcodes, "fonts.encodings.agl.ctxcodes")
    end

end

---.names    = names     -- unicode -> name
agl.unicodes = unicodes  -- name -> unicode
agl.ctxcodes = ctxcodes  -- name -> unicode
agl.synonyms = synonyms  -- merged into the other two -- used?
agl.extras   = extras    -- merged into the other two -- used?

return agl
