/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.dbcp.pool2.impl;

import java.time.Duration;
import org.apache.tomcat.dbcp.pool2.BaseObject;
import org.apache.tomcat.dbcp.pool2.impl.DefaultEvictionPolicy;
import org.apache.tomcat.dbcp.pool2.impl.EvictionPolicy;
import org.apache.tomcat.dbcp.pool2.impl.PoolImplUtils;

public abstract class BaseObjectPoolConfig<T>
extends BaseObject
implements Cloneable {
    public static final boolean DEFAULT_LIFO = true;
    public static final boolean DEFAULT_FAIRNESS = false;
    @Deprecated
    public static final long DEFAULT_MAX_WAIT_MILLIS = -1L;
    public static final Duration DEFAULT_MAX_WAIT = Duration.ofMillis(-1L);
    @Deprecated
    public static final long DEFAULT_MIN_EVICTABLE_IDLE_TIME_MILLIS = 1800000L;
    public static final Duration DEFAULT_MIN_EVICTABLE_IDLE_DURATION = Duration.ofMillis(1800000L);
    @Deprecated
    public static final Duration DEFAULT_MIN_EVICTABLE_IDLE_TIME = Duration.ofMillis(1800000L);
    @Deprecated
    public static final long DEFAULT_SOFT_MIN_EVICTABLE_IDLE_TIME_MILLIS = -1L;
    @Deprecated
    public static final Duration DEFAULT_SOFT_MIN_EVICTABLE_IDLE_TIME = Duration.ofMillis(-1L);
    public static final Duration DEFAULT_SOFT_MIN_EVICTABLE_IDLE_DURATION = Duration.ofMillis(-1L);
    @Deprecated
    public static final long DEFAULT_EVICTOR_SHUTDOWN_TIMEOUT_MILLIS = 10000L;
    public static final Duration DEFAULT_EVICTOR_SHUTDOWN_TIMEOUT = Duration.ofMillis(10000L);
    public static final int DEFAULT_NUM_TESTS_PER_EVICTION_RUN = 3;
    public static final boolean DEFAULT_TEST_ON_CREATE = false;
    public static final boolean DEFAULT_TEST_ON_BORROW = false;
    public static final boolean DEFAULT_TEST_ON_RETURN = false;
    public static final boolean DEFAULT_TEST_WHILE_IDLE = false;
    @Deprecated
    public static final long DEFAULT_TIME_BETWEEN_EVICTION_RUNS_MILLIS = -1L;
    public static final Duration DEFAULT_DURATION_BETWEEN_EVICTION_RUNS = Duration.ofMillis(-1L);
    @Deprecated
    public static final Duration DEFAULT_TIME_BETWEEN_EVICTION_RUNS = Duration.ofMillis(-1L);
    public static final boolean DEFAULT_BLOCK_WHEN_EXHAUSTED = true;
    public static final boolean DEFAULT_JMX_ENABLE = true;
    public static final String DEFAULT_JMX_NAME_PREFIX = "pool";
    public static final String DEFAULT_JMX_NAME_BASE = null;
    public static final String DEFAULT_EVICTION_POLICY_CLASS_NAME = DefaultEvictionPolicy.class.getName();
    private boolean lifo = true;
    private boolean fairness = false;
    private Duration maxWaitDuration = DEFAULT_MAX_WAIT;
    private Duration minEvictableIdleDuration = DEFAULT_MIN_EVICTABLE_IDLE_TIME;
    private Duration evictorShutdownTimeoutDuration = DEFAULT_EVICTOR_SHUTDOWN_TIMEOUT;
    private Duration softMinEvictableIdleDuration = DEFAULT_SOFT_MIN_EVICTABLE_IDLE_TIME;
    private int numTestsPerEvictionRun = 3;
    private EvictionPolicy<T> evictionPolicy;
    private String evictionPolicyClassName = DEFAULT_EVICTION_POLICY_CLASS_NAME;
    private boolean testOnCreate = false;
    private boolean testOnBorrow = false;
    private boolean testOnReturn = false;
    private boolean testWhileIdle = false;
    private Duration durationBetweenEvictionRuns = DEFAULT_DURATION_BETWEEN_EVICTION_RUNS;
    private boolean blockWhenExhausted = true;
    private boolean jmxEnabled = true;
    private String jmxNamePrefix = "pool";
    private String jmxNameBase = DEFAULT_JMX_NAME_BASE;

    public boolean getBlockWhenExhausted() {
        return this.blockWhenExhausted;
    }

    public Duration getDurationBetweenEvictionRuns() {
        return this.durationBetweenEvictionRuns;
    }

    public EvictionPolicy<T> getEvictionPolicy() {
        return this.evictionPolicy;
    }

    public String getEvictionPolicyClassName() {
        return this.evictionPolicyClassName;
    }

    @Deprecated
    public Duration getEvictorShutdownTimeout() {
        return this.evictorShutdownTimeoutDuration;
    }

    public Duration getEvictorShutdownTimeoutDuration() {
        return this.evictorShutdownTimeoutDuration;
    }

    @Deprecated
    public long getEvictorShutdownTimeoutMillis() {
        return this.evictorShutdownTimeoutDuration.toMillis();
    }

    public boolean getFairness() {
        return this.fairness;
    }

    public boolean getJmxEnabled() {
        return this.jmxEnabled;
    }

    public String getJmxNameBase() {
        return this.jmxNameBase;
    }

    public String getJmxNamePrefix() {
        return this.jmxNamePrefix;
    }

    public boolean getLifo() {
        return this.lifo;
    }

    public Duration getMaxWaitDuration() {
        return this.maxWaitDuration;
    }

    @Deprecated
    public long getMaxWaitMillis() {
        return this.maxWaitDuration.toMillis();
    }

    public Duration getMinEvictableIdleDuration() {
        return this.minEvictableIdleDuration;
    }

    @Deprecated
    public Duration getMinEvictableIdleTime() {
        return this.minEvictableIdleDuration;
    }

    @Deprecated
    public long getMinEvictableIdleTimeMillis() {
        return this.minEvictableIdleDuration.toMillis();
    }

    public int getNumTestsPerEvictionRun() {
        return this.numTestsPerEvictionRun;
    }

    public Duration getSoftMinEvictableIdleDuration() {
        return this.softMinEvictableIdleDuration;
    }

    @Deprecated
    public Duration getSoftMinEvictableIdleTime() {
        return this.softMinEvictableIdleDuration;
    }

    @Deprecated
    public long getSoftMinEvictableIdleTimeMillis() {
        return this.softMinEvictableIdleDuration.toMillis();
    }

    public boolean getTestOnBorrow() {
        return this.testOnBorrow;
    }

    public boolean getTestOnCreate() {
        return this.testOnCreate;
    }

    public boolean getTestOnReturn() {
        return this.testOnReturn;
    }

    public boolean getTestWhileIdle() {
        return this.testWhileIdle;
    }

    @Deprecated
    public Duration getTimeBetweenEvictionRuns() {
        return this.durationBetweenEvictionRuns;
    }

    @Deprecated
    public long getTimeBetweenEvictionRunsMillis() {
        return this.durationBetweenEvictionRuns.toMillis();
    }

    public void setBlockWhenExhausted(boolean bl) {
        this.blockWhenExhausted = bl;
    }

    public void setEvictionPolicy(EvictionPolicy<T> evictionPolicy) {
        this.evictionPolicy = evictionPolicy;
    }

    public void setEvictionPolicyClassName(String string) {
        this.evictionPolicyClassName = string;
    }

    public void setEvictorShutdownTimeout(Duration duration) {
        this.evictorShutdownTimeoutDuration = PoolImplUtils.nonNull(duration, DEFAULT_EVICTOR_SHUTDOWN_TIMEOUT);
    }

    @Deprecated
    public void setEvictorShutdownTimeoutMillis(Duration duration) {
        this.setEvictorShutdownTimeout(duration);
    }

    @Deprecated
    public void setEvictorShutdownTimeoutMillis(long l) {
        this.setEvictorShutdownTimeout(Duration.ofMillis(l));
    }

    public void setFairness(boolean bl) {
        this.fairness = bl;
    }

    public void setJmxEnabled(boolean bl) {
        this.jmxEnabled = bl;
    }

    public void setJmxNameBase(String string) {
        this.jmxNameBase = string;
    }

    public void setJmxNamePrefix(String string) {
        this.jmxNamePrefix = string;
    }

    public void setLifo(boolean bl) {
        this.lifo = bl;
    }

    public void setMaxWait(Duration duration) {
        this.maxWaitDuration = PoolImplUtils.nonNull(duration, DEFAULT_MAX_WAIT);
    }

    @Deprecated
    public void setMaxWaitMillis(long l) {
        this.setMaxWait(Duration.ofMillis(l));
    }

    public void setMinEvictableIdleDuration(Duration duration) {
        this.minEvictableIdleDuration = PoolImplUtils.nonNull(duration, DEFAULT_MIN_EVICTABLE_IDLE_TIME);
    }

    @Deprecated
    public void setMinEvictableIdleTime(Duration duration) {
        this.minEvictableIdleDuration = PoolImplUtils.nonNull(duration, DEFAULT_MIN_EVICTABLE_IDLE_TIME);
    }

    @Deprecated
    public void setMinEvictableIdleTimeMillis(long l) {
        this.minEvictableIdleDuration = Duration.ofMillis(l);
    }

    public void setNumTestsPerEvictionRun(int n) {
        this.numTestsPerEvictionRun = n;
    }

    public void setSoftMinEvictableIdleDuration(Duration duration) {
        this.softMinEvictableIdleDuration = PoolImplUtils.nonNull(duration, DEFAULT_SOFT_MIN_EVICTABLE_IDLE_TIME);
    }

    @Deprecated
    public void setSoftMinEvictableIdleTime(Duration duration) {
        this.softMinEvictableIdleDuration = PoolImplUtils.nonNull(duration, DEFAULT_SOFT_MIN_EVICTABLE_IDLE_TIME);
    }

    @Deprecated
    public void setSoftMinEvictableIdleTimeMillis(long l) {
        this.setSoftMinEvictableIdleTime(Duration.ofMillis(l));
    }

    public void setTestOnBorrow(boolean bl) {
        this.testOnBorrow = bl;
    }

    public void setTestOnCreate(boolean bl) {
        this.testOnCreate = bl;
    }

    public void setTestOnReturn(boolean bl) {
        this.testOnReturn = bl;
    }

    public void setTestWhileIdle(boolean bl) {
        this.testWhileIdle = bl;
    }

    public void setTimeBetweenEvictionRuns(Duration duration) {
        this.durationBetweenEvictionRuns = PoolImplUtils.nonNull(duration, DEFAULT_DURATION_BETWEEN_EVICTION_RUNS);
    }

    @Deprecated
    public void setTimeBetweenEvictionRunsMillis(long l) {
        this.setTimeBetweenEvictionRuns(Duration.ofMillis(l));
    }

    @Override
    protected void toStringAppendFields(StringBuilder stringBuilder) {
        stringBuilder.append("lifo=");
        stringBuilder.append(this.lifo);
        stringBuilder.append(", fairness=");
        stringBuilder.append(this.fairness);
        stringBuilder.append(", maxWaitDuration=");
        stringBuilder.append(this.maxWaitDuration);
        stringBuilder.append(", minEvictableIdleTime=");
        stringBuilder.append(this.minEvictableIdleDuration);
        stringBuilder.append(", softMinEvictableIdleTime=");
        stringBuilder.append(this.softMinEvictableIdleDuration);
        stringBuilder.append(", numTestsPerEvictionRun=");
        stringBuilder.append(this.numTestsPerEvictionRun);
        stringBuilder.append(", evictionPolicyClassName=");
        stringBuilder.append(this.evictionPolicyClassName);
        stringBuilder.append(", testOnCreate=");
        stringBuilder.append(this.testOnCreate);
        stringBuilder.append(", testOnBorrow=");
        stringBuilder.append(this.testOnBorrow);
        stringBuilder.append(", testOnReturn=");
        stringBuilder.append(this.testOnReturn);
        stringBuilder.append(", testWhileIdle=");
        stringBuilder.append(this.testWhileIdle);
        stringBuilder.append(", timeBetweenEvictionRuns=");
        stringBuilder.append(this.durationBetweenEvictionRuns);
        stringBuilder.append(", blockWhenExhausted=");
        stringBuilder.append(this.blockWhenExhausted);
        stringBuilder.append(", jmxEnabled=");
        stringBuilder.append(this.jmxEnabled);
        stringBuilder.append(", jmxNamePrefix=");
        stringBuilder.append(this.jmxNamePrefix);
        stringBuilder.append(", jmxNameBase=");
        stringBuilder.append(this.jmxNameBase);
    }
}

