# coding=utf-8
# pylint: disable=too-many-lines
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
import sys
from typing import Any, Dict, List, Optional, TYPE_CHECKING, Union

from .. import _serialization

if sys.version_info >= (3, 9):
    from collections.abc import MutableMapping
else:
    from typing import MutableMapping  # type: ignore  # pylint: disable=ungrouped-imports

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from .. import models as _models
JSON = MutableMapping[str, Any]  # pylint: disable=unsubscriptable-object


class AdministratorListResult(_serialization.Model):
    """A List of azure ad administrators.

    :ivar value: The list of azure ad administrator of a server.
    :vartype value: list[~azure.mgmt.mysqlflexibleservers.models.AzureADAdministrator]
    :ivar next_link: The link used to get the next page of operations.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[AzureADAdministrator]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.AzureADAdministrator"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: The list of azure ad administrator of a server.
        :paramtype value: list[~azure.mgmt.mysqlflexibleservers.models.AzureADAdministrator]
        :keyword next_link: The link used to get the next page of operations.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class Resource(_serialization.Model):
    """Common fields that are returned in the response for all Azure Resource Manager resources.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.mysqlflexibleservers.models.SystemData
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.system_data = None


class ProxyResource(Resource):
    """The resource model definition for a Azure Resource Manager proxy resource. It will not have
    tags and a location.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.mysqlflexibleservers.models.SystemData
    """


class AdvancedThreatProtection(ProxyResource):
    """A server's Advanced Threat Protection.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.mysqlflexibleservers.models.SystemData
    :ivar creation_time: Specifies the UTC creation time of the policy.
    :vartype creation_time: ~datetime.datetime
    :ivar state: Specifies the state of the Advanced Threat Protection, whether it is enabled or
     disabled or a state has not been applied yet on the specific database or server. Known values
     are: "Enabled" and "Disabled".
    :vartype state: str or ~azure.mgmt.mysqlflexibleservers.models.AdvancedThreatProtectionState
    :ivar provisioning_state: Provisioning state of the Threat Protection. Known values are:
     "Succeeded", "Updating", "Canceled", and "Failed".
    :vartype provisioning_state: str or
     ~azure.mgmt.mysqlflexibleservers.models.AdvancedThreatProtectionProvisioningState
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "creation_time": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "creation_time": {"key": "properties.creationTime", "type": "iso-8601"},
        "state": {"key": "properties.state", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self, *, state: Optional[Union[str, "_models.AdvancedThreatProtectionState"]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword state: Specifies the state of the Advanced Threat Protection, whether it is enabled or
         disabled or a state has not been applied yet on the specific database or server. Known values
         are: "Enabled" and "Disabled".
        :paramtype state: str or ~azure.mgmt.mysqlflexibleservers.models.AdvancedThreatProtectionState
        """
        super().__init__(**kwargs)
        self.creation_time = None
        self.state = state
        self.provisioning_state = None


class AdvancedThreatProtectionForUpdate(_serialization.Model):
    """Parameters allowed to update advanced threat protection for a server.

    :ivar state: Specifies the state of the Advanced Threat Protection, whether it is enabled or
     disabled or a state has not been applied yet on the specific database or server. Known values
     are: "Enabled" and "Disabled".
    :vartype state: str or ~azure.mgmt.mysqlflexibleservers.models.AdvancedThreatProtectionState
    """

    _attribute_map = {
        "state": {"key": "properties.state", "type": "str"},
    }

    def __init__(
        self, *, state: Optional[Union[str, "_models.AdvancedThreatProtectionState"]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword state: Specifies the state of the Advanced Threat Protection, whether it is enabled or
         disabled or a state has not been applied yet on the specific database or server. Known values
         are: "Enabled" and "Disabled".
        :paramtype state: str or ~azure.mgmt.mysqlflexibleservers.models.AdvancedThreatProtectionState
        """
        super().__init__(**kwargs)
        self.state = state


class AdvancedThreatProtectionListResult(_serialization.Model):
    """A list of the server's Advanced Threat Protection configurations.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of results.
    :vartype value: list[~azure.mgmt.mysqlflexibleservers.models.AdvancedThreatProtection]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[AdvancedThreatProtection]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value = None
        self.next_link = None


class AzureADAdministrator(ProxyResource):
    """Represents a Administrator.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.mysqlflexibleservers.models.SystemData
    :ivar administrator_type: Type of the sever administrator. "ActiveDirectory"
    :vartype administrator_type: str or ~azure.mgmt.mysqlflexibleservers.models.AdministratorType
    :ivar login: Login name of the server administrator.
    :vartype login: str
    :ivar sid: SID (object ID) of the server administrator.
    :vartype sid: str
    :ivar tenant_id: Tenant ID of the administrator.
    :vartype tenant_id: str
    :ivar identity_resource_id: The resource id of the identity used for AAD Authentication.
    :vartype identity_resource_id: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "administrator_type": {"key": "properties.administratorType", "type": "str"},
        "login": {"key": "properties.login", "type": "str"},
        "sid": {"key": "properties.sid", "type": "str"},
        "tenant_id": {"key": "properties.tenantId", "type": "str"},
        "identity_resource_id": {"key": "properties.identityResourceId", "type": "str"},
    }

    def __init__(
        self,
        *,
        administrator_type: Optional[Union[str, "_models.AdministratorType"]] = None,
        login: Optional[str] = None,
        sid: Optional[str] = None,
        tenant_id: Optional[str] = None,
        identity_resource_id: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword administrator_type: Type of the sever administrator. "ActiveDirectory"
        :paramtype administrator_type: str or ~azure.mgmt.mysqlflexibleservers.models.AdministratorType
        :keyword login: Login name of the server administrator.
        :paramtype login: str
        :keyword sid: SID (object ID) of the server administrator.
        :paramtype sid: str
        :keyword tenant_id: Tenant ID of the administrator.
        :paramtype tenant_id: str
        :keyword identity_resource_id: The resource id of the identity used for AAD Authentication.
        :paramtype identity_resource_id: str
        """
        super().__init__(**kwargs)
        self.administrator_type = administrator_type
        self.login = login
        self.sid = sid
        self.tenant_id = tenant_id
        self.identity_resource_id = identity_resource_id


class Backup(_serialization.Model):
    """Storage Profile properties of a server.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar backup_retention_days: Backup retention days for the server.
    :vartype backup_retention_days: int
    :ivar backup_interval_hours: Backup interval hours for the server.
    :vartype backup_interval_hours: int
    :ivar geo_redundant_backup: Whether or not geo redundant backup is enabled. Known values are:
     "Enabled" and "Disabled".
    :vartype geo_redundant_backup: str or ~azure.mgmt.mysqlflexibleservers.models.EnableStatusEnum
    :ivar earliest_restore_date: Earliest restore point creation time (ISO8601 format).
    :vartype earliest_restore_date: ~datetime.datetime
    """

    _validation = {
        "earliest_restore_date": {"readonly": True},
    }

    _attribute_map = {
        "backup_retention_days": {"key": "backupRetentionDays", "type": "int"},
        "backup_interval_hours": {"key": "backupIntervalHours", "type": "int"},
        "geo_redundant_backup": {"key": "geoRedundantBackup", "type": "str"},
        "earliest_restore_date": {"key": "earliestRestoreDate", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        backup_retention_days: Optional[int] = None,
        backup_interval_hours: Optional[int] = None,
        geo_redundant_backup: Optional[Union[str, "_models.EnableStatusEnum"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword backup_retention_days: Backup retention days for the server.
        :paramtype backup_retention_days: int
        :keyword backup_interval_hours: Backup interval hours for the server.
        :paramtype backup_interval_hours: int
        :keyword geo_redundant_backup: Whether or not geo redundant backup is enabled. Known values
         are: "Enabled" and "Disabled".
        :paramtype geo_redundant_backup: str or
         ~azure.mgmt.mysqlflexibleservers.models.EnableStatusEnum
        """
        super().__init__(**kwargs)
        self.backup_retention_days = backup_retention_days
        self.backup_interval_hours = backup_interval_hours
        self.geo_redundant_backup = geo_redundant_backup
        self.earliest_restore_date = None


class BackupRequestBase(_serialization.Model):
    """BackupRequestBase is the base for all backup request.

    All required parameters must be populated in order to send to server.

    :ivar backup_settings: Backup Settings. Required.
    :vartype backup_settings: ~azure.mgmt.mysqlflexibleservers.models.BackupSettings
    """

    _validation = {
        "backup_settings": {"required": True},
    }

    _attribute_map = {
        "backup_settings": {"key": "backupSettings", "type": "BackupSettings"},
    }

    def __init__(self, *, backup_settings: "_models.BackupSettings", **kwargs: Any) -> None:
        """
        :keyword backup_settings: Backup Settings. Required.
        :paramtype backup_settings: ~azure.mgmt.mysqlflexibleservers.models.BackupSettings
        """
        super().__init__(**kwargs)
        self.backup_settings = backup_settings


class BackupAndExportRequest(BackupRequestBase):
    """BackupAndExport API Request.

    All required parameters must be populated in order to send to server.

    :ivar backup_settings: Backup Settings. Required.
    :vartype backup_settings: ~azure.mgmt.mysqlflexibleservers.models.BackupSettings
    :ivar target_details: Backup Target Store Details. Required.
    :vartype target_details: ~azure.mgmt.mysqlflexibleservers.models.BackupStoreDetails
    """

    _validation = {
        "backup_settings": {"required": True},
        "target_details": {"required": True},
    }

    _attribute_map = {
        "backup_settings": {"key": "backupSettings", "type": "BackupSettings"},
        "target_details": {"key": "targetDetails", "type": "BackupStoreDetails"},
    }

    def __init__(
        self, *, backup_settings: "_models.BackupSettings", target_details: "_models.BackupStoreDetails", **kwargs: Any
    ) -> None:
        """
        :keyword backup_settings: Backup Settings. Required.
        :paramtype backup_settings: ~azure.mgmt.mysqlflexibleservers.models.BackupSettings
        :keyword target_details: Backup Target Store Details. Required.
        :paramtype target_details: ~azure.mgmt.mysqlflexibleservers.models.BackupStoreDetails
        """
        super().__init__(backup_settings=backup_settings, **kwargs)
        self.target_details = target_details


class ErrorResponse(_serialization.Model):
    """Common error response for all Azure Resource Manager APIs to return error details for failed
    operations. (This also follows the OData error response format.).

    :ivar error: The error object.
    :vartype error: ~azure.mgmt.mysqlflexibleservers.models.ErrorDetail
    """

    _attribute_map = {
        "error": {"key": "error", "type": "ErrorDetail"},
    }

    def __init__(self, *, error: Optional["_models.ErrorDetail"] = None, **kwargs: Any) -> None:
        """
        :keyword error: The error object.
        :paramtype error: ~azure.mgmt.mysqlflexibleservers.models.ErrorDetail
        """
        super().__init__(**kwargs)
        self.error = error


class BackupAndExportResponse(ProxyResource, ErrorResponse):  # pylint: disable=too-many-instance-attributes
    """Represents BackupAndExport API Response.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar error: The error object.
    :vartype error: ~azure.mgmt.mysqlflexibleservers.models.ErrorDetail
    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.mysqlflexibleservers.models.SystemData
    :ivar status: The operation status. Known values are: "Pending", "InProgress", "Succeeded",
     "Failed", "CancelInProgress", and "Canceled".
    :vartype status: str or ~azure.mgmt.mysqlflexibleservers.models.OperationStatus
    :ivar start_time: Start time.
    :vartype start_time: ~datetime.datetime
    :ivar end_time: End time.
    :vartype end_time: ~datetime.datetime
    :ivar percent_complete: Operation progress (0-100).
    :vartype percent_complete: float
    :ivar datasource_size_in_bytes: Size of datasource in bytes.
    :vartype datasource_size_in_bytes: int
    :ivar data_transferred_in_bytes: Data transferred in bytes.
    :vartype data_transferred_in_bytes: int
    :ivar backup_metadata: Metadata related to backup to be stored for restoring resource in
     key-value pairs.
    :vartype backup_metadata: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "percent_complete": {"maximum": 100, "minimum": 0},
    }

    _attribute_map = {
        "error": {"key": "error", "type": "ErrorDetail"},
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "status": {"key": "status", "type": "str"},
        "start_time": {"key": "startTime", "type": "iso-8601"},
        "end_time": {"key": "endTime", "type": "iso-8601"},
        "percent_complete": {"key": "percentComplete", "type": "float"},
        "datasource_size_in_bytes": {"key": "properties.datasourceSizeInBytes", "type": "int"},
        "data_transferred_in_bytes": {"key": "properties.dataTransferredInBytes", "type": "int"},
        "backup_metadata": {"key": "properties.backupMetadata", "type": "str"},
    }

    def __init__(
        self,
        *,
        error: Optional["_models.ErrorDetail"] = None,
        status: Optional[Union[str, "_models.OperationStatus"]] = None,
        start_time: Optional[datetime.datetime] = None,
        end_time: Optional[datetime.datetime] = None,
        percent_complete: Optional[float] = None,
        datasource_size_in_bytes: Optional[int] = None,
        data_transferred_in_bytes: Optional[int] = None,
        backup_metadata: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword error: The error object.
        :paramtype error: ~azure.mgmt.mysqlflexibleservers.models.ErrorDetail
        :keyword status: The operation status. Known values are: "Pending", "InProgress", "Succeeded",
         "Failed", "CancelInProgress", and "Canceled".
        :paramtype status: str or ~azure.mgmt.mysqlflexibleservers.models.OperationStatus
        :keyword start_time: Start time.
        :paramtype start_time: ~datetime.datetime
        :keyword end_time: End time.
        :paramtype end_time: ~datetime.datetime
        :keyword percent_complete: Operation progress (0-100).
        :paramtype percent_complete: float
        :keyword datasource_size_in_bytes: Size of datasource in bytes.
        :paramtype datasource_size_in_bytes: int
        :keyword data_transferred_in_bytes: Data transferred in bytes.
        :paramtype data_transferred_in_bytes: int
        :keyword backup_metadata: Metadata related to backup to be stored for restoring resource in
         key-value pairs.
        :paramtype backup_metadata: str
        """
        super().__init__(error=error, **kwargs)
        self.error = error
        self.status = status
        self.start_time = start_time
        self.end_time = end_time
        self.percent_complete = percent_complete
        self.datasource_size_in_bytes = datasource_size_in_bytes
        self.data_transferred_in_bytes = data_transferred_in_bytes
        self.backup_metadata = backup_metadata
        self.id = None
        self.name = None
        self.type = None
        self.system_data = None


class OperationProgressResponseType(_serialization.Model):
    """Represents the response properties specific to the operation.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    BackupAndExportResponseType, ImportFromStorageResponseType

    All required parameters must be populated in order to send to server.

    :ivar object_type: Identifies the type of source operation. Required. Known values are:
     "BackupAndExportResponse" and "ImportFromStorageResponse".
    :vartype object_type: str or ~azure.mgmt.mysqlflexibleservers.models.ObjectType
    """

    _validation = {
        "object_type": {"required": True},
    }

    _attribute_map = {
        "object_type": {"key": "objectType", "type": "str"},
    }

    _subtype_map = {
        "object_type": {
            "BackupAndExportResponse": "BackupAndExportResponseType",
            "ImportFromStorageResponse": "ImportFromStorageResponseType",
        }
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.object_type: Optional[str] = None


class BackupAndExportResponseType(OperationProgressResponseType):
    """BackupAndExport Response Properties.

    All required parameters must be populated in order to send to server.

    :ivar object_type: Identifies the type of source operation. Required. Known values are:
     "BackupAndExportResponse" and "ImportFromStorageResponse".
    :vartype object_type: str or ~azure.mgmt.mysqlflexibleservers.models.ObjectType
    :ivar datasource_size_in_bytes: Size of datasource in bytes.
    :vartype datasource_size_in_bytes: int
    :ivar data_transferred_in_bytes: Data transferred in bytes.
    :vartype data_transferred_in_bytes: int
    :ivar backup_metadata: Metadata related to backup to be stored for restoring resource in
     key-value pairs.
    :vartype backup_metadata: str
    """

    _validation = {
        "object_type": {"required": True},
    }

    _attribute_map = {
        "object_type": {"key": "objectType", "type": "str"},
        "datasource_size_in_bytes": {"key": "datasourceSizeInBytes", "type": "int"},
        "data_transferred_in_bytes": {"key": "dataTransferredInBytes", "type": "int"},
        "backup_metadata": {"key": "backupMetadata", "type": "str"},
    }

    def __init__(
        self,
        *,
        datasource_size_in_bytes: Optional[int] = None,
        data_transferred_in_bytes: Optional[int] = None,
        backup_metadata: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword datasource_size_in_bytes: Size of datasource in bytes.
        :paramtype datasource_size_in_bytes: int
        :keyword data_transferred_in_bytes: Data transferred in bytes.
        :paramtype data_transferred_in_bytes: int
        :keyword backup_metadata: Metadata related to backup to be stored for restoring resource in
         key-value pairs.
        :paramtype backup_metadata: str
        """
        super().__init__(**kwargs)
        self.object_type: str = "BackupAndExportResponse"
        self.datasource_size_in_bytes = datasource_size_in_bytes
        self.data_transferred_in_bytes = data_transferred_in_bytes
        self.backup_metadata = backup_metadata


class BackupSettings(_serialization.Model):
    """Backup Settings.

    All required parameters must be populated in order to send to server.

    :ivar backup_name: The name of the backup. Required.
    :vartype backup_name: str
    :ivar backup_format: Backup Format for the current backup. (CollatedFormat is INTERNAL – DO NOT
     USE). Known values are: "CollatedFormat" and "Raw".
    :vartype backup_format: str or ~azure.mgmt.mysqlflexibleservers.models.BackupFormat
    """

    _validation = {
        "backup_name": {"required": True, "pattern": r"(^[a-z0-9]$)|(^[a-z0-9][a-z0-9-]*[a-z0-9]$)"},
    }

    _attribute_map = {
        "backup_name": {"key": "backupName", "type": "str"},
        "backup_format": {"key": "backupFormat", "type": "str"},
    }

    def __init__(
        self, *, backup_name: str, backup_format: Optional[Union[str, "_models.BackupFormat"]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword backup_name: The name of the backup. Required.
        :paramtype backup_name: str
        :keyword backup_format: Backup Format for the current backup. (CollatedFormat is INTERNAL – DO
         NOT USE). Known values are: "CollatedFormat" and "Raw".
        :paramtype backup_format: str or ~azure.mgmt.mysqlflexibleservers.models.BackupFormat
        """
        super().__init__(**kwargs)
        self.backup_name = backup_name
        self.backup_format = backup_format


class BackupStoreDetails(_serialization.Model):
    """Details about the target where the backup content will be stored.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    FullBackupStoreDetails

    All required parameters must be populated in order to send to server.

    :ivar object_type: Type of the specific object - used for deserializing. Required.
    :vartype object_type: str
    """

    _validation = {
        "object_type": {"required": True},
    }

    _attribute_map = {
        "object_type": {"key": "objectType", "type": "str"},
    }

    _subtype_map = {"object_type": {"FullBackupStoreDetails": "FullBackupStoreDetails"}}

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.object_type: Optional[str] = None


class CapabilitiesListResult(_serialization.Model):
    """location capability.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: A list of supported capabilities.
    :vartype value: list[~azure.mgmt.mysqlflexibleservers.models.CapabilityProperties]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[CapabilityProperties]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value = None
        self.next_link = None


class Capability(ProxyResource):
    """Represents a location capability set.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.mysqlflexibleservers.models.SystemData
    :ivar supported_geo_backup_regions: supported geo backup regions.
    :vartype supported_geo_backup_regions: list[str]
    :ivar supported_flexible_server_editions: A list of supported flexible server editions.
    :vartype supported_flexible_server_editions:
     list[~azure.mgmt.mysqlflexibleservers.models.ServerEditionCapabilityV2]
    :ivar supported_server_versions: A list of supported server versions.
    :vartype supported_server_versions:
     list[~azure.mgmt.mysqlflexibleservers.models.ServerVersionCapabilityV2]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "supported_geo_backup_regions": {"readonly": True},
        "supported_flexible_server_editions": {"readonly": True},
        "supported_server_versions": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "supported_geo_backup_regions": {"key": "properties.supportedGeoBackupRegions", "type": "[str]"},
        "supported_flexible_server_editions": {
            "key": "properties.supportedFlexibleServerEditions",
            "type": "[ServerEditionCapabilityV2]",
        },
        "supported_server_versions": {
            "key": "properties.supportedServerVersions",
            "type": "[ServerVersionCapabilityV2]",
        },
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.supported_geo_backup_regions = None
        self.supported_flexible_server_editions = None
        self.supported_server_versions = None


class CapabilityProperties(_serialization.Model):
    """Location capabilities.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar zone: zone name.
    :vartype zone: str
    :ivar supported_ha_mode: Supported high availability mode.
    :vartype supported_ha_mode: list[str]
    :ivar supported_geo_backup_regions: supported geo backup regions.
    :vartype supported_geo_backup_regions: list[str]
    :ivar supported_flexible_server_editions: A list of supported flexible server editions.
    :vartype supported_flexible_server_editions:
     list[~azure.mgmt.mysqlflexibleservers.models.ServerEditionCapability]
    """

    _validation = {
        "zone": {"readonly": True},
        "supported_ha_mode": {"readonly": True},
        "supported_geo_backup_regions": {"readonly": True},
        "supported_flexible_server_editions": {"readonly": True},
    }

    _attribute_map = {
        "zone": {"key": "zone", "type": "str"},
        "supported_ha_mode": {"key": "supportedHAMode", "type": "[str]"},
        "supported_geo_backup_regions": {"key": "supportedGeoBackupRegions", "type": "[str]"},
        "supported_flexible_server_editions": {
            "key": "supportedFlexibleServerEditions",
            "type": "[ServerEditionCapability]",
        },
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.zone = None
        self.supported_ha_mode = None
        self.supported_geo_backup_regions = None
        self.supported_flexible_server_editions = None


class CapabilitySetsList(_serialization.Model):
    """location capability set.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: A list of supported capability sets.
    :vartype value: list[~azure.mgmt.mysqlflexibleservers.models.Capability]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[Capability]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value = None
        self.next_link = None


class Configuration(ProxyResource):  # pylint: disable=too-many-instance-attributes
    """Represents a Configuration.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.mysqlflexibleservers.models.SystemData
    :ivar value: Value of the configuration.
    :vartype value: str
    :ivar current_value: Current value of the configuration.
    :vartype current_value: str
    :ivar description: Description of the configuration.
    :vartype description: str
    :ivar documentation_link: The link used to get the document from community or Azure site.
    :vartype documentation_link: str
    :ivar default_value: Default value of the configuration.
    :vartype default_value: str
    :ivar data_type: Data type of the configuration.
    :vartype data_type: str
    :ivar allowed_values: Allowed values of the configuration.
    :vartype allowed_values: str
    :ivar source: Source of the configuration. Known values are: "system-default" and
     "user-override".
    :vartype source: str or ~azure.mgmt.mysqlflexibleservers.models.ConfigurationSource
    :ivar is_read_only: If is the configuration read only. Known values are: "True" and "False".
    :vartype is_read_only: str or ~azure.mgmt.mysqlflexibleservers.models.IsReadOnly
    :ivar is_config_pending_restart: If is the configuration pending restart or not. Known values
     are: "True" and "False".
    :vartype is_config_pending_restart: str or
     ~azure.mgmt.mysqlflexibleservers.models.IsConfigPendingRestart
    :ivar is_dynamic_config: If is the configuration dynamic. Known values are: "True" and "False".
    :vartype is_dynamic_config: str or ~azure.mgmt.mysqlflexibleservers.models.IsDynamicConfig
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "description": {"readonly": True},
        "documentation_link": {"readonly": True},
        "default_value": {"readonly": True},
        "data_type": {"readonly": True},
        "allowed_values": {"readonly": True},
        "is_read_only": {"readonly": True},
        "is_config_pending_restart": {"readonly": True},
        "is_dynamic_config": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "value": {"key": "properties.value", "type": "str"},
        "current_value": {"key": "properties.currentValue", "type": "str"},
        "description": {"key": "properties.description", "type": "str"},
        "documentation_link": {"key": "properties.documentationLink", "type": "str"},
        "default_value": {"key": "properties.defaultValue", "type": "str"},
        "data_type": {"key": "properties.dataType", "type": "str"},
        "allowed_values": {"key": "properties.allowedValues", "type": "str"},
        "source": {"key": "properties.source", "type": "str"},
        "is_read_only": {"key": "properties.isReadOnly", "type": "str"},
        "is_config_pending_restart": {"key": "properties.isConfigPendingRestart", "type": "str"},
        "is_dynamic_config": {"key": "properties.isDynamicConfig", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[str] = None,
        current_value: Optional[str] = None,
        source: Optional[Union[str, "_models.ConfigurationSource"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: Value of the configuration.
        :paramtype value: str
        :keyword current_value: Current value of the configuration.
        :paramtype current_value: str
        :keyword source: Source of the configuration. Known values are: "system-default" and
         "user-override".
        :paramtype source: str or ~azure.mgmt.mysqlflexibleservers.models.ConfigurationSource
        """
        super().__init__(**kwargs)
        self.value = value
        self.current_value = current_value
        self.description = None
        self.documentation_link = None
        self.default_value = None
        self.data_type = None
        self.allowed_values = None
        self.source = source
        self.is_read_only = None
        self.is_config_pending_restart = None
        self.is_dynamic_config = None


class ConfigurationForBatchUpdate(_serialization.Model):
    """Represents a Configuration.

    :ivar name: Name of the configuration.
    :vartype name: str
    :ivar value: Value of the configuration.
    :vartype value: str
    :ivar source: Source of the configuration.
    :vartype source: str
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "value": {"key": "properties.value", "type": "str"},
        "source": {"key": "properties.source", "type": "str"},
    }

    def __init__(
        self, *, name: Optional[str] = None, value: Optional[str] = None, source: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword name: Name of the configuration.
        :paramtype name: str
        :keyword value: Value of the configuration.
        :paramtype value: str
        :keyword source: Source of the configuration.
        :paramtype source: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.value = value
        self.source = source


class ConfigurationListForBatchUpdate(_serialization.Model):
    """A list of server configurations to update.

    :ivar value: The list of server configurations.
    :vartype value: list[~azure.mgmt.mysqlflexibleservers.models.ConfigurationForBatchUpdate]
    :ivar reset_all_to_default: Whether to reset all server parameters to default. Known values
     are: "True" and "False".
    :vartype reset_all_to_default: str or ~azure.mgmt.mysqlflexibleservers.models.ResetAllToDefault
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[ConfigurationForBatchUpdate]"},
        "reset_all_to_default": {"key": "resetAllToDefault", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.ConfigurationForBatchUpdate"]] = None,
        reset_all_to_default: Optional[Union[str, "_models.ResetAllToDefault"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: The list of server configurations.
        :paramtype value: list[~azure.mgmt.mysqlflexibleservers.models.ConfigurationForBatchUpdate]
        :keyword reset_all_to_default: Whether to reset all server parameters to default. Known values
         are: "True" and "False".
        :paramtype reset_all_to_default: str or
         ~azure.mgmt.mysqlflexibleservers.models.ResetAllToDefault
        """
        super().__init__(**kwargs)
        self.value = value
        self.reset_all_to_default = reset_all_to_default


class ConfigurationListResult(_serialization.Model):
    """A list of server configurations.

    :ivar value: The list of server configurations.
    :vartype value: list[~azure.mgmt.mysqlflexibleservers.models.Configuration]
    :ivar next_link: The link used to get the next page of operations.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[Configuration]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.Configuration"]] = None, next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: The list of server configurations.
        :paramtype value: list[~azure.mgmt.mysqlflexibleservers.models.Configuration]
        :keyword next_link: The link used to get the next page of operations.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class Database(ProxyResource):
    """Represents a Database.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.mysqlflexibleservers.models.SystemData
    :ivar charset: The charset of the database.
    :vartype charset: str
    :ivar collation: The collation of the database.
    :vartype collation: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "charset": {"key": "properties.charset", "type": "str"},
        "collation": {"key": "properties.collation", "type": "str"},
    }

    def __init__(self, *, charset: Optional[str] = None, collation: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword charset: The charset of the database.
        :paramtype charset: str
        :keyword collation: The collation of the database.
        :paramtype collation: str
        """
        super().__init__(**kwargs)
        self.charset = charset
        self.collation = collation


class DatabaseListResult(_serialization.Model):
    """A List of databases.

    :ivar value: The list of databases housed in a server.
    :vartype value: list[~azure.mgmt.mysqlflexibleservers.models.Database]
    :ivar next_link: The link used to get the next page of operations.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[Database]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.Database"]] = None, next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: The list of databases housed in a server.
        :paramtype value: list[~azure.mgmt.mysqlflexibleservers.models.Database]
        :keyword next_link: The link used to get the next page of operations.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class DataEncryption(_serialization.Model):
    """The date encryption for cmk.

    :ivar primary_user_assigned_identity_id: Primary user identity resource id.
    :vartype primary_user_assigned_identity_id: str
    :ivar primary_key_uri: Primary key uri.
    :vartype primary_key_uri: str
    :ivar geo_backup_user_assigned_identity_id: Geo backup user identity resource id as identity
     can't cross region, need identity in same region as geo backup.
    :vartype geo_backup_user_assigned_identity_id: str
    :ivar geo_backup_key_uri: Geo backup key uri as key vault can't cross region, need cmk in same
     region as geo backup.
    :vartype geo_backup_key_uri: str
    :ivar type: The key type, AzureKeyVault for enable cmk, SystemManaged for disable cmk. Known
     values are: "AzureKeyVault" and "SystemManaged".
    :vartype type: str or ~azure.mgmt.mysqlflexibleservers.models.DataEncryptionType
    """

    _attribute_map = {
        "primary_user_assigned_identity_id": {"key": "primaryUserAssignedIdentityId", "type": "str"},
        "primary_key_uri": {"key": "primaryKeyURI", "type": "str"},
        "geo_backup_user_assigned_identity_id": {"key": "geoBackupUserAssignedIdentityId", "type": "str"},
        "geo_backup_key_uri": {"key": "geoBackupKeyURI", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(
        self,
        *,
        primary_user_assigned_identity_id: Optional[str] = None,
        primary_key_uri: Optional[str] = None,
        geo_backup_user_assigned_identity_id: Optional[str] = None,
        geo_backup_key_uri: Optional[str] = None,
        type: Optional[Union[str, "_models.DataEncryptionType"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword primary_user_assigned_identity_id: Primary user identity resource id.
        :paramtype primary_user_assigned_identity_id: str
        :keyword primary_key_uri: Primary key uri.
        :paramtype primary_key_uri: str
        :keyword geo_backup_user_assigned_identity_id: Geo backup user identity resource id as identity
         can't cross region, need identity in same region as geo backup.
        :paramtype geo_backup_user_assigned_identity_id: str
        :keyword geo_backup_key_uri: Geo backup key uri as key vault can't cross region, need cmk in
         same region as geo backup.
        :paramtype geo_backup_key_uri: str
        :keyword type: The key type, AzureKeyVault for enable cmk, SystemManaged for disable cmk. Known
         values are: "AzureKeyVault" and "SystemManaged".
        :paramtype type: str or ~azure.mgmt.mysqlflexibleservers.models.DataEncryptionType
        """
        super().__init__(**kwargs)
        self.primary_user_assigned_identity_id = primary_user_assigned_identity_id
        self.primary_key_uri = primary_key_uri
        self.geo_backup_user_assigned_identity_id = geo_backup_user_assigned_identity_id
        self.geo_backup_key_uri = geo_backup_key_uri
        self.type = type


class DelegatedSubnetUsage(_serialization.Model):
    """Delegated subnet usage data.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar subnet_name: name of the subnet.
    :vartype subnet_name: str
    :ivar usage: Number of used delegated subnets.
    :vartype usage: int
    """

    _validation = {
        "subnet_name": {"readonly": True},
        "usage": {"readonly": True},
    }

    _attribute_map = {
        "subnet_name": {"key": "subnetName", "type": "str"},
        "usage": {"key": "usage", "type": "int"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.subnet_name = None
        self.usage = None


class ErrorAdditionalInfo(_serialization.Model):
    """The resource management error additional info.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: JSON
    """

    _validation = {
        "type": {"readonly": True},
        "info": {"readonly": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "info": {"key": "info", "type": "object"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.type = None
        self.info = None


class ErrorDetail(_serialization.Model):
    """The error detail.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~azure.mgmt.mysqlflexibleservers.models.ErrorDetail]
    :ivar additional_info: The error additional info.
    :vartype additional_info: list[~azure.mgmt.mysqlflexibleservers.models.ErrorAdditionalInfo]
    """

    _validation = {
        "code": {"readonly": True},
        "message": {"readonly": True},
        "target": {"readonly": True},
        "details": {"readonly": True},
        "additional_info": {"readonly": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "target": {"key": "target", "type": "str"},
        "details": {"key": "details", "type": "[ErrorDetail]"},
        "additional_info": {"key": "additionalInfo", "type": "[ErrorAdditionalInfo]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.code = None
        self.message = None
        self.target = None
        self.details = None
        self.additional_info = None


class FirewallRule(ProxyResource):
    """Represents a server firewall rule.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.mysqlflexibleservers.models.SystemData
    :ivar start_ip_address: The start IP address of the server firewall rule. Must be IPv4 format.
     Required.
    :vartype start_ip_address: str
    :ivar end_ip_address: The end IP address of the server firewall rule. Must be IPv4 format.
     Required.
    :vartype end_ip_address: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "start_ip_address": {
            "required": True,
            "pattern": r"^(([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])\.){3}([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])$",
        },
        "end_ip_address": {
            "required": True,
            "pattern": r"^(([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])\.){3}([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])$",
        },
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "start_ip_address": {"key": "properties.startIpAddress", "type": "str"},
        "end_ip_address": {"key": "properties.endIpAddress", "type": "str"},
    }

    def __init__(self, *, start_ip_address: str, end_ip_address: str, **kwargs: Any) -> None:
        """
        :keyword start_ip_address: The start IP address of the server firewall rule. Must be IPv4
         format. Required.
        :paramtype start_ip_address: str
        :keyword end_ip_address: The end IP address of the server firewall rule. Must be IPv4 format.
         Required.
        :paramtype end_ip_address: str
        """
        super().__init__(**kwargs)
        self.start_ip_address = start_ip_address
        self.end_ip_address = end_ip_address


class FirewallRuleListResult(_serialization.Model):
    """A list of firewall rules.

    :ivar value: The list of firewall rules in a server.
    :vartype value: list[~azure.mgmt.mysqlflexibleservers.models.FirewallRule]
    :ivar next_link: The link used to get the next page of operations.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[FirewallRule]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.FirewallRule"]] = None, next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: The list of firewall rules in a server.
        :paramtype value: list[~azure.mgmt.mysqlflexibleservers.models.FirewallRule]
        :keyword next_link: The link used to get the next page of operations.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class FullBackupStoreDetails(BackupStoreDetails):
    """FullBackupStoreDetails is used for scenarios where backup data is streamed/copied over to a
    storage destination.

    All required parameters must be populated in order to send to server.

    :ivar object_type: Type of the specific object - used for deserializing. Required.
    :vartype object_type: str
    :ivar sas_uri_list: SASUriList of storage containers where backup data is to be
     streamed/copied. Required.
    :vartype sas_uri_list: list[str]
    """

    _validation = {
        "object_type": {"required": True},
        "sas_uri_list": {"required": True},
    }

    _attribute_map = {
        "object_type": {"key": "objectType", "type": "str"},
        "sas_uri_list": {"key": "sasUriList", "type": "[str]"},
    }

    def __init__(self, *, sas_uri_list: List[str], **kwargs: Any) -> None:
        """
        :keyword sas_uri_list: SASUriList of storage containers where backup data is to be
         streamed/copied. Required.
        :paramtype sas_uri_list: list[str]
        """
        super().__init__(**kwargs)
        self.object_type: str = "FullBackupStoreDetails"
        self.sas_uri_list = sas_uri_list


class GetPrivateDnsZoneSuffixResponse(_serialization.Model):
    """The response of get private dns zone suffix.

    :ivar private_dns_zone_suffix: Represents the private DNS zone suffix.
    :vartype private_dns_zone_suffix: str
    """

    _attribute_map = {
        "private_dns_zone_suffix": {"key": "privateDnsZoneSuffix", "type": "str"},
    }

    def __init__(self, *, private_dns_zone_suffix: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword private_dns_zone_suffix: Represents the private DNS zone suffix.
        :paramtype private_dns_zone_suffix: str
        """
        super().__init__(**kwargs)
        self.private_dns_zone_suffix = private_dns_zone_suffix


class HighAvailability(_serialization.Model):
    """High availability properties of a server.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar mode: High availability mode for a server. Known values are: "Disabled", "ZoneRedundant",
     and "SameZone".
    :vartype mode: str or ~azure.mgmt.mysqlflexibleservers.models.HighAvailabilityMode
    :ivar state: The state of server high availability. Known values are: "NotEnabled",
     "CreatingStandby", "Healthy", "FailingOver", and "RemovingStandby".
    :vartype state: str or ~azure.mgmt.mysqlflexibleservers.models.HighAvailabilityState
    :ivar standby_availability_zone: Availability zone of the standby server.
    :vartype standby_availability_zone: str
    """

    _validation = {
        "state": {"readonly": True},
    }

    _attribute_map = {
        "mode": {"key": "mode", "type": "str"},
        "state": {"key": "state", "type": "str"},
        "standby_availability_zone": {"key": "standbyAvailabilityZone", "type": "str"},
    }

    def __init__(
        self,
        *,
        mode: Optional[Union[str, "_models.HighAvailabilityMode"]] = None,
        standby_availability_zone: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword mode: High availability mode for a server. Known values are: "Disabled",
         "ZoneRedundant", and "SameZone".
        :paramtype mode: str or ~azure.mgmt.mysqlflexibleservers.models.HighAvailabilityMode
        :keyword standby_availability_zone: Availability zone of the standby server.
        :paramtype standby_availability_zone: str
        """
        super().__init__(**kwargs)
        self.mode = mode
        self.state = None
        self.standby_availability_zone = standby_availability_zone


class HighAvailabilityValidationEstimation(_serialization.Model):
    """High availability validation properties of a server.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar estimated_downtime: Estimated seconds of downtime for the deployment.
    :vartype estimated_downtime: int
    :ivar scheduled_standby_availability_zone: Scheduled Availability zone of the standby server.
    :vartype scheduled_standby_availability_zone: str
    :ivar expected_standby_availability_zone: Expected Availability zone of the standby server.
    :vartype expected_standby_availability_zone: str
    """

    _validation = {
        "estimated_downtime": {"readonly": True},
        "scheduled_standby_availability_zone": {"readonly": True},
    }

    _attribute_map = {
        "estimated_downtime": {"key": "estimatedDowntime", "type": "int"},
        "scheduled_standby_availability_zone": {"key": "scheduledStandbyAvailabilityZone", "type": "str"},
        "expected_standby_availability_zone": {"key": "expectedStandbyAvailabilityZone", "type": "str"},
    }

    def __init__(self, *, expected_standby_availability_zone: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword expected_standby_availability_zone: Expected Availability zone of the standby server.
        :paramtype expected_standby_availability_zone: str
        """
        super().__init__(**kwargs)
        self.estimated_downtime = None
        self.scheduled_standby_availability_zone = None
        self.expected_standby_availability_zone = expected_standby_availability_zone


class ImportFromStorageResponseType(OperationProgressResponseType):
    """ImportFromStorage Response Properties.

    All required parameters must be populated in order to send to server.

    :ivar object_type: Identifies the type of source operation. Required. Known values are:
     "BackupAndExportResponse" and "ImportFromStorageResponse".
    :vartype object_type: str or ~azure.mgmt.mysqlflexibleservers.models.ObjectType
    :ivar estimated_completion_time: The estimated time of operation completion.
    :vartype estimated_completion_time: ~datetime.datetime
    """

    _validation = {
        "object_type": {"required": True},
    }

    _attribute_map = {
        "object_type": {"key": "objectType", "type": "str"},
        "estimated_completion_time": {"key": "estimatedCompletionTime", "type": "iso-8601"},
    }

    def __init__(self, *, estimated_completion_time: Optional[datetime.datetime] = None, **kwargs: Any) -> None:
        """
        :keyword estimated_completion_time: The estimated time of operation completion.
        :paramtype estimated_completion_time: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.object_type: str = "ImportFromStorageResponse"
        self.estimated_completion_time = estimated_completion_time


class ImportSourceProperties(_serialization.Model):
    """Import source related properties.

    :ivar storage_type: Storage type of import source. "AzureBlob"
    :vartype storage_type: str or ~azure.mgmt.mysqlflexibleservers.models.ImportSourceStorageType
    :ivar storage_url: Uri of the import source storage.
    :vartype storage_url: str
    :ivar sas_token: Sas token for accessing source storage. Read and list permissions are required
     for sas token.
    :vartype sas_token: str
    :ivar data_dir_path: Relative path of data directory in storage.
    :vartype data_dir_path: str
    """

    _attribute_map = {
        "storage_type": {"key": "storageType", "type": "str"},
        "storage_url": {"key": "storageUrl", "type": "str"},
        "sas_token": {"key": "sasToken", "type": "str"},
        "data_dir_path": {"key": "dataDirPath", "type": "str"},
    }

    def __init__(
        self,
        *,
        storage_type: Optional[Union[str, "_models.ImportSourceStorageType"]] = None,
        storage_url: Optional[str] = None,
        sas_token: Optional[str] = None,
        data_dir_path: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword storage_type: Storage type of import source. "AzureBlob"
        :paramtype storage_type: str or ~azure.mgmt.mysqlflexibleservers.models.ImportSourceStorageType
        :keyword storage_url: Uri of the import source storage.
        :paramtype storage_url: str
        :keyword sas_token: Sas token for accessing source storage. Read and list permissions are
         required for sas token.
        :paramtype sas_token: str
        :keyword data_dir_path: Relative path of data directory in storage.
        :paramtype data_dir_path: str
        """
        super().__init__(**kwargs)
        self.storage_type = storage_type
        self.storage_url = storage_url
        self.sas_token = sas_token
        self.data_dir_path = data_dir_path


class LogFile(ProxyResource):
    """Represents a logFile.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.mysqlflexibleservers.models.SystemData
    :ivar size_in_kb: The size in kb of the logFile.
    :vartype size_in_kb: int
    :ivar created_time: Creation timestamp of the log file.
    :vartype created_time: ~datetime.datetime
    :ivar type_properties_type: Type of the log file.
    :vartype type_properties_type: str
    :ivar last_modified_time: Last modified timestamp of the log file.
    :vartype last_modified_time: ~datetime.datetime
    :ivar url: The url to download the log file from.
    :vartype url: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "size_in_kb": {"key": "properties.sizeInKB", "type": "int"},
        "created_time": {"key": "properties.createdTime", "type": "iso-8601"},
        "type_properties_type": {"key": "properties.type", "type": "str"},
        "last_modified_time": {"key": "properties.lastModifiedTime", "type": "iso-8601"},
        "url": {"key": "properties.url", "type": "str"},
    }

    def __init__(
        self,
        *,
        size_in_kb: Optional[int] = None,
        created_time: Optional[datetime.datetime] = None,
        type_properties_type: Optional[str] = None,
        last_modified_time: Optional[datetime.datetime] = None,
        url: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword size_in_kb: The size in kb of the logFile.
        :paramtype size_in_kb: int
        :keyword created_time: Creation timestamp of the log file.
        :paramtype created_time: ~datetime.datetime
        :keyword type_properties_type: Type of the log file.
        :paramtype type_properties_type: str
        :keyword last_modified_time: Last modified timestamp of the log file.
        :paramtype last_modified_time: ~datetime.datetime
        :keyword url: The url to download the log file from.
        :paramtype url: str
        """
        super().__init__(**kwargs)
        self.size_in_kb = size_in_kb
        self.created_time = created_time
        self.type_properties_type = type_properties_type
        self.last_modified_time = last_modified_time
        self.url = url


class LogFileListResult(_serialization.Model):
    """A List of logFiles.

    :ivar value: The list of logFiles in a server.
    :vartype value: list[~azure.mgmt.mysqlflexibleservers.models.LogFile]
    :ivar next_link: The link used to get the next page of operations.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[LogFile]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.LogFile"]] = None, next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: The list of logFiles in a server.
        :paramtype value: list[~azure.mgmt.mysqlflexibleservers.models.LogFile]
        :keyword next_link: The link used to get the next page of operations.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class Maintenance(ProxyResource):  # pylint: disable=too-many-instance-attributes
    """Represents a maintenance.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.mysqlflexibleservers.models.SystemData
    :ivar maintenance_type: A string defines maintenance type. Known values are:
     "RoutineMaintenance", "MinorVersionUpgrade", "SecurityPatches", and "HotFixes".
    :vartype maintenance_type: str or ~azure.mgmt.mysqlflexibleservers.models.MaintenanceType
    :ivar maintenance_state: A string describes the maintenance status. Known values are:
     "Scheduled", "ReScheduled", "InPreparation", "Processing", "Completed", and "Canceled".
    :vartype maintenance_state: str or ~azure.mgmt.mysqlflexibleservers.models.MaintenanceState
    :ivar maintenance_start_time: The start time for a maintenance.
    :vartype maintenance_start_time: ~datetime.datetime
    :ivar maintenance_end_time: The end time for a maintenance.
    :vartype maintenance_end_time: ~datetime.datetime
    :ivar maintenance_execution_start_time: The start time for a maintenance execution.
    :vartype maintenance_execution_start_time: ~datetime.datetime
    :ivar maintenance_execution_end_time: The end time for a maintenance execution.
    :vartype maintenance_execution_end_time: ~datetime.datetime
    :ivar maintenance_available_schedule_min_time: The min time the maintenance can be rescheduled.
    :vartype maintenance_available_schedule_min_time: ~datetime.datetime
    :ivar maintenance_available_schedule_max_time: The max time the maintenance can be rescheduled.
    :vartype maintenance_available_schedule_max_time: ~datetime.datetime
    :ivar maintenance_title: The maintenance title.
    :vartype maintenance_title: str
    :ivar maintenance_description: The maintenance description.
    :vartype maintenance_description: str
    :ivar provisioning_state: Provisioning state of the Maintenance. Known values are: "Succeeded",
     "Creating", "Deleting", and "Failed".
    :vartype provisioning_state: str or
     ~azure.mgmt.mysqlflexibleservers.models.MaintenanceProvisioningState
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "maintenance_type": {"readonly": True},
        "maintenance_state": {"readonly": True},
        "maintenance_end_time": {"readonly": True},
        "maintenance_execution_start_time": {"readonly": True},
        "maintenance_execution_end_time": {"readonly": True},
        "maintenance_available_schedule_min_time": {"readonly": True},
        "maintenance_available_schedule_max_time": {"readonly": True},
        "maintenance_title": {"readonly": True},
        "maintenance_description": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "maintenance_type": {"key": "properties.maintenanceType", "type": "str"},
        "maintenance_state": {"key": "properties.maintenanceState", "type": "str"},
        "maintenance_start_time": {"key": "properties.maintenanceStartTime", "type": "iso-8601"},
        "maintenance_end_time": {"key": "properties.maintenanceEndTime", "type": "iso-8601"},
        "maintenance_execution_start_time": {"key": "properties.maintenanceExecutionStartTime", "type": "iso-8601"},
        "maintenance_execution_end_time": {"key": "properties.maintenanceExecutionEndTime", "type": "iso-8601"},
        "maintenance_available_schedule_min_time": {
            "key": "properties.maintenanceAvailableScheduleMinTime",
            "type": "iso-8601",
        },
        "maintenance_available_schedule_max_time": {
            "key": "properties.maintenanceAvailableScheduleMaxTime",
            "type": "iso-8601",
        },
        "maintenance_title": {"key": "properties.maintenanceTitle", "type": "str"},
        "maintenance_description": {"key": "properties.maintenanceDescription", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(self, *, maintenance_start_time: Optional[datetime.datetime] = None, **kwargs: Any) -> None:
        """
        :keyword maintenance_start_time: The start time for a maintenance.
        :paramtype maintenance_start_time: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.maintenance_type = None
        self.maintenance_state = None
        self.maintenance_start_time = maintenance_start_time
        self.maintenance_end_time = None
        self.maintenance_execution_start_time = None
        self.maintenance_execution_end_time = None
        self.maintenance_available_schedule_min_time = None
        self.maintenance_available_schedule_max_time = None
        self.maintenance_title = None
        self.maintenance_description = None
        self.provisioning_state = None


class MaintenanceListResult(_serialization.Model):
    """A list of maintenances.

    :ivar value: The list of maintenances in a server.
    :vartype value: list[~azure.mgmt.mysqlflexibleservers.models.Maintenance]
    :ivar next_link: The link used to get the next page of operations.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[Maintenance]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.Maintenance"]] = None, next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: The list of maintenances in a server.
        :paramtype value: list[~azure.mgmt.mysqlflexibleservers.models.Maintenance]
        :keyword next_link: The link used to get the next page of operations.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class MaintenancePolicy(_serialization.Model):
    """Maintenance policy of a server.

    :ivar patch_strategy: The patch strategy of this server. Known values are: "Regular" and
     "VirtualCanary".
    :vartype patch_strategy: str or ~azure.mgmt.mysqlflexibleservers.models.PatchStrategy
    """

    _attribute_map = {
        "patch_strategy": {"key": "patchStrategy", "type": "str"},
    }

    def __init__(self, *, patch_strategy: Optional[Union[str, "_models.PatchStrategy"]] = None, **kwargs: Any) -> None:
        """
        :keyword patch_strategy: The patch strategy of this server. Known values are: "Regular" and
         "VirtualCanary".
        :paramtype patch_strategy: str or ~azure.mgmt.mysqlflexibleservers.models.PatchStrategy
        """
        super().__init__(**kwargs)
        self.patch_strategy = patch_strategy


class MaintenanceUpdate(_serialization.Model):
    """Represents a maintenance update parameter.

    :ivar maintenance_start_time: The start time for a maintenance.
    :vartype maintenance_start_time: ~datetime.datetime
    """

    _attribute_map = {
        "maintenance_start_time": {"key": "properties.maintenanceStartTime", "type": "iso-8601"},
    }

    def __init__(self, *, maintenance_start_time: Optional[datetime.datetime] = None, **kwargs: Any) -> None:
        """
        :keyword maintenance_start_time: The start time for a maintenance.
        :paramtype maintenance_start_time: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.maintenance_start_time = maintenance_start_time


class MaintenanceWindow(_serialization.Model):
    """Maintenance window of a server.

    :ivar custom_window: indicates whether custom window is enabled or disabled.
    :vartype custom_window: str
    :ivar start_hour: start hour for maintenance window.
    :vartype start_hour: int
    :ivar start_minute: start minute for maintenance window.
    :vartype start_minute: int
    :ivar day_of_week: day of week for maintenance window.
    :vartype day_of_week: int
    """

    _attribute_map = {
        "custom_window": {"key": "customWindow", "type": "str"},
        "start_hour": {"key": "startHour", "type": "int"},
        "start_minute": {"key": "startMinute", "type": "int"},
        "day_of_week": {"key": "dayOfWeek", "type": "int"},
    }

    def __init__(
        self,
        *,
        custom_window: Optional[str] = None,
        start_hour: Optional[int] = None,
        start_minute: Optional[int] = None,
        day_of_week: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword custom_window: indicates whether custom window is enabled or disabled.
        :paramtype custom_window: str
        :keyword start_hour: start hour for maintenance window.
        :paramtype start_hour: int
        :keyword start_minute: start minute for maintenance window.
        :paramtype start_minute: int
        :keyword day_of_week: day of week for maintenance window.
        :paramtype day_of_week: int
        """
        super().__init__(**kwargs)
        self.custom_window = custom_window
        self.start_hour = start_hour
        self.start_minute = start_minute
        self.day_of_week = day_of_week


class MySQLServerIdentity(_serialization.Model):
    """Properties to configure Identity for Bring your Own Keys.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar principal_id: ObjectId from the KeyVault.
    :vartype principal_id: str
    :ivar tenant_id: TenantId from the KeyVault.
    :vartype tenant_id: str
    :ivar type: Type of managed service identity. "UserAssigned"
    :vartype type: str or ~azure.mgmt.mysqlflexibleservers.models.ManagedServiceIdentityType
    :ivar user_assigned_identities: Metadata of user assigned identity.
    :vartype user_assigned_identities: dict[str, JSON]
    """

    _validation = {
        "principal_id": {"readonly": True},
        "tenant_id": {"readonly": True},
    }

    _attribute_map = {
        "principal_id": {"key": "principalId", "type": "str"},
        "tenant_id": {"key": "tenantId", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "user_assigned_identities": {"key": "userAssignedIdentities", "type": "{object}"},
    }

    def __init__(
        self,
        *,
        type: Optional[Union[str, "_models.ManagedServiceIdentityType"]] = None,
        user_assigned_identities: Optional[Dict[str, JSON]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword type: Type of managed service identity. "UserAssigned"
        :paramtype type: str or ~azure.mgmt.mysqlflexibleservers.models.ManagedServiceIdentityType
        :keyword user_assigned_identities: Metadata of user assigned identity.
        :paramtype user_assigned_identities: dict[str, JSON]
        """
        super().__init__(**kwargs)
        self.principal_id = None
        self.tenant_id = None
        self.type = type
        self.user_assigned_identities = user_assigned_identities


class MySQLServerSku(_serialization.Model):
    """Billing information related properties of a server.

    All required parameters must be populated in order to send to server.

    :ivar name: The name of the sku, e.g. Standard_D32s_v3. Required.
    :vartype name: str
    :ivar tier: The tier of the particular SKU, e.g. GeneralPurpose. Required. Known values are:
     "Burstable", "GeneralPurpose", and "MemoryOptimized".
    :vartype tier: str or ~azure.mgmt.mysqlflexibleservers.models.ServerSkuTier
    """

    _validation = {
        "name": {"required": True},
        "tier": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "tier": {"key": "tier", "type": "str"},
    }

    def __init__(self, *, name: str, tier: Union[str, "_models.ServerSkuTier"], **kwargs: Any) -> None:
        """
        :keyword name: The name of the sku, e.g. Standard_D32s_v3. Required.
        :paramtype name: str
        :keyword tier: The tier of the particular SKU, e.g. GeneralPurpose. Required. Known values are:
         "Burstable", "GeneralPurpose", and "MemoryOptimized".
        :paramtype tier: str or ~azure.mgmt.mysqlflexibleservers.models.ServerSkuTier
        """
        super().__init__(**kwargs)
        self.name = name
        self.tier = tier


class NameAvailability(_serialization.Model):
    """Represents a resource name availability.

    :ivar message: Error Message.
    :vartype message: str
    :ivar name_available: Indicates whether the resource name is available.
    :vartype name_available: bool
    :ivar reason: Reason for name being unavailable.
    :vartype reason: str
    """

    _attribute_map = {
        "message": {"key": "message", "type": "str"},
        "name_available": {"key": "nameAvailable", "type": "bool"},
        "reason": {"key": "reason", "type": "str"},
    }

    def __init__(
        self,
        *,
        message: Optional[str] = None,
        name_available: Optional[bool] = None,
        reason: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword message: Error Message.
        :paramtype message: str
        :keyword name_available: Indicates whether the resource name is available.
        :paramtype name_available: bool
        :keyword reason: Reason for name being unavailable.
        :paramtype reason: str
        """
        super().__init__(**kwargs)
        self.message = message
        self.name_available = name_available
        self.reason = reason


class NameAvailabilityRequest(_serialization.Model):
    """Request from client to check resource name availability.

    All required parameters must be populated in order to send to server.

    :ivar name: Resource name to verify. Required.
    :vartype name: str
    :ivar type: Resource type used for verification.
    :vartype type: str
    """

    _validation = {
        "name": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(self, *, name: str, type: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword name: Resource name to verify. Required.
        :paramtype name: str
        :keyword type: Resource type used for verification.
        :paramtype type: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.type = type


class Network(_serialization.Model):
    """Network related properties of a server.

    :ivar public_network_access: Whether or not public network access is allowed for this server.
     Value is 'Disabled' when server has VNet integration. Known values are: "Enabled" and
     "Disabled".
    :vartype public_network_access: str or ~azure.mgmt.mysqlflexibleservers.models.EnableStatusEnum
    :ivar delegated_subnet_resource_id: Delegated subnet resource id used to setup vnet for a
     server.
    :vartype delegated_subnet_resource_id: str
    :ivar private_dns_zone_resource_id: Private DNS zone resource id.
    :vartype private_dns_zone_resource_id: str
    """

    _attribute_map = {
        "public_network_access": {"key": "publicNetworkAccess", "type": "str"},
        "delegated_subnet_resource_id": {"key": "delegatedSubnetResourceId", "type": "str"},
        "private_dns_zone_resource_id": {"key": "privateDnsZoneResourceId", "type": "str"},
    }

    def __init__(
        self,
        *,
        public_network_access: Optional[Union[str, "_models.EnableStatusEnum"]] = None,
        delegated_subnet_resource_id: Optional[str] = None,
        private_dns_zone_resource_id: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword public_network_access: Whether or not public network access is allowed for this
         server. Value is 'Disabled' when server has VNet integration. Known values are: "Enabled" and
         "Disabled".
        :paramtype public_network_access: str or
         ~azure.mgmt.mysqlflexibleservers.models.EnableStatusEnum
        :keyword delegated_subnet_resource_id: Delegated subnet resource id used to setup vnet for a
         server.
        :paramtype delegated_subnet_resource_id: str
        :keyword private_dns_zone_resource_id: Private DNS zone resource id.
        :paramtype private_dns_zone_resource_id: str
        """
        super().__init__(**kwargs)
        self.public_network_access = public_network_access
        self.delegated_subnet_resource_id = delegated_subnet_resource_id
        self.private_dns_zone_resource_id = private_dns_zone_resource_id


class Operation(_serialization.Model):
    """REST API operation definition.

    :ivar name: The name of the operation being performed on this particular object.
    :vartype name: str
    :ivar display: The localized display information for this particular operation or action.
    :vartype display: ~azure.mgmt.mysqlflexibleservers.models.OperationDisplay
    :ivar origin: The intended executor of the operation.
    :vartype origin: str
    :ivar properties: Additional descriptions for the operation.
    :vartype properties: dict[str, JSON]
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "display": {"key": "display", "type": "OperationDisplay"},
        "origin": {"key": "origin", "type": "str"},
        "properties": {"key": "properties", "type": "{object}"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        display: Optional["_models.OperationDisplay"] = None,
        origin: Optional[str] = None,
        properties: Optional[Dict[str, JSON]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: The name of the operation being performed on this particular object.
        :paramtype name: str
        :keyword display: The localized display information for this particular operation or action.
        :paramtype display: ~azure.mgmt.mysqlflexibleservers.models.OperationDisplay
        :keyword origin: The intended executor of the operation.
        :paramtype origin: str
        :keyword properties: Additional descriptions for the operation.
        :paramtype properties: dict[str, JSON]
        """
        super().__init__(**kwargs)
        self.name = name
        self.display = display
        self.origin = origin
        self.properties = properties


class OperationDisplay(_serialization.Model):
    """Display metadata associated with the operation.

    :ivar provider: Operation resource provider name.
    :vartype provider: str
    :ivar resource: Resource on which the operation is performed.
    :vartype resource: str
    :ivar operation: Localized friendly name for the operation.
    :vartype operation: str
    :ivar description: Operation description.
    :vartype description: str
    """

    _attribute_map = {
        "provider": {"key": "provider", "type": "str"},
        "resource": {"key": "resource", "type": "str"},
        "operation": {"key": "operation", "type": "str"},
        "description": {"key": "description", "type": "str"},
    }

    def __init__(
        self,
        *,
        provider: Optional[str] = None,
        resource: Optional[str] = None,
        operation: Optional[str] = None,
        description: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword provider: Operation resource provider name.
        :paramtype provider: str
        :keyword resource: Resource on which the operation is performed.
        :paramtype resource: str
        :keyword operation: Localized friendly name for the operation.
        :paramtype operation: str
        :keyword description: Operation description.
        :paramtype description: str
        """
        super().__init__(**kwargs)
        self.provider = provider
        self.resource = resource
        self.operation = operation
        self.description = description


class OperationListResult(_serialization.Model):
    """A list of resource provider operations.

    :ivar value: Collection of available operation details.
    :vartype value: list[~azure.mgmt.mysqlflexibleservers.models.Operation]
    :ivar next_link: URL client should use to fetch the next page (per server side paging).
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[Operation]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.Operation"]] = None, next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: Collection of available operation details.
        :paramtype value: list[~azure.mgmt.mysqlflexibleservers.models.Operation]
        :keyword next_link: URL client should use to fetch the next page (per server side paging).
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class OperationStatusResult(_serialization.Model):
    """The current status of an async operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Fully qualified ID for the async operation.
    :vartype id: str
    :ivar resource_id: Fully qualified ID of the resource against which the original async
     operation was started.
    :vartype resource_id: str
    :ivar name: Name of the async operation.
    :vartype name: str
    :ivar status: Operation status. Required.
    :vartype status: str
    :ivar percent_complete: Percent of the operation that is complete.
    :vartype percent_complete: float
    :ivar start_time: The start time of the operation.
    :vartype start_time: ~datetime.datetime
    :ivar end_time: The end time of the operation.
    :vartype end_time: ~datetime.datetime
    :ivar operations: The operations list.
    :vartype operations: list[~azure.mgmt.mysqlflexibleservers.models.OperationStatusResult]
    :ivar error: If present, details of the operation error.
    :vartype error: ~azure.mgmt.mysqlflexibleservers.models.ErrorDetail
    """

    _validation = {
        "resource_id": {"readonly": True},
        "status": {"required": True},
        "percent_complete": {"maximum": 100, "minimum": 0},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "resource_id": {"key": "resourceId", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "status": {"key": "status", "type": "str"},
        "percent_complete": {"key": "percentComplete", "type": "float"},
        "start_time": {"key": "startTime", "type": "iso-8601"},
        "end_time": {"key": "endTime", "type": "iso-8601"},
        "operations": {"key": "operations", "type": "[OperationStatusResult]"},
        "error": {"key": "error", "type": "ErrorDetail"},
    }

    def __init__(
        self,
        *,
        status: str,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        percent_complete: Optional[float] = None,
        start_time: Optional[datetime.datetime] = None,
        end_time: Optional[datetime.datetime] = None,
        operations: Optional[List["_models.OperationStatusResult"]] = None,
        error: Optional["_models.ErrorDetail"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Fully qualified ID for the async operation.
        :paramtype id: str
        :keyword name: Name of the async operation.
        :paramtype name: str
        :keyword status: Operation status. Required.
        :paramtype status: str
        :keyword percent_complete: Percent of the operation that is complete.
        :paramtype percent_complete: float
        :keyword start_time: The start time of the operation.
        :paramtype start_time: ~datetime.datetime
        :keyword end_time: The end time of the operation.
        :paramtype end_time: ~datetime.datetime
        :keyword operations: The operations list.
        :paramtype operations: list[~azure.mgmt.mysqlflexibleservers.models.OperationStatusResult]
        :keyword error: If present, details of the operation error.
        :paramtype error: ~azure.mgmt.mysqlflexibleservers.models.ErrorDetail
        """
        super().__init__(**kwargs)
        self.id = id
        self.resource_id = None
        self.name = name
        self.status = status
        self.percent_complete = percent_complete
        self.start_time = start_time
        self.end_time = end_time
        self.operations = operations
        self.error = error


class OperationProgressResult(OperationStatusResult):
    """Represents Operation Results API Response.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Fully qualified ID for the async operation.
    :vartype id: str
    :ivar resource_id: Fully qualified ID of the resource against which the original async
     operation was started.
    :vartype resource_id: str
    :ivar name: Name of the async operation.
    :vartype name: str
    :ivar status: Operation status. Required.
    :vartype status: str
    :ivar percent_complete: Percent of the operation that is complete.
    :vartype percent_complete: float
    :ivar start_time: The start time of the operation.
    :vartype start_time: ~datetime.datetime
    :ivar end_time: The end time of the operation.
    :vartype end_time: ~datetime.datetime
    :ivar operations: The operations list.
    :vartype operations: list[~azure.mgmt.mysqlflexibleservers.models.OperationStatusResult]
    :ivar error: If present, details of the operation error.
    :vartype error: ~azure.mgmt.mysqlflexibleservers.models.ErrorDetail
    :ivar object_type: Identifies the type of source operation. Known values are:
     "BackupAndExportResponse" and "ImportFromStorageResponse".
    :vartype object_type: str or ~azure.mgmt.mysqlflexibleservers.models.ObjectType
    """

    _validation = {
        "resource_id": {"readonly": True},
        "status": {"required": True},
        "percent_complete": {"maximum": 100, "minimum": 0},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "resource_id": {"key": "resourceId", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "status": {"key": "status", "type": "str"},
        "percent_complete": {"key": "percentComplete", "type": "float"},
        "start_time": {"key": "startTime", "type": "iso-8601"},
        "end_time": {"key": "endTime", "type": "iso-8601"},
        "operations": {"key": "operations", "type": "[OperationStatusResult]"},
        "error": {"key": "error", "type": "ErrorDetail"},
        "object_type": {"key": "properties.objectType", "type": "str"},
    }

    def __init__(
        self,
        *,
        status: str,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        percent_complete: Optional[float] = None,
        start_time: Optional[datetime.datetime] = None,
        end_time: Optional[datetime.datetime] = None,
        operations: Optional[List["_models.OperationStatusResult"]] = None,
        error: Optional["_models.ErrorDetail"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Fully qualified ID for the async operation.
        :paramtype id: str
        :keyword name: Name of the async operation.
        :paramtype name: str
        :keyword status: Operation status. Required.
        :paramtype status: str
        :keyword percent_complete: Percent of the operation that is complete.
        :paramtype percent_complete: float
        :keyword start_time: The start time of the operation.
        :paramtype start_time: ~datetime.datetime
        :keyword end_time: The end time of the operation.
        :paramtype end_time: ~datetime.datetime
        :keyword operations: The operations list.
        :paramtype operations: list[~azure.mgmt.mysqlflexibleservers.models.OperationStatusResult]
        :keyword error: If present, details of the operation error.
        :paramtype error: ~azure.mgmt.mysqlflexibleservers.models.ErrorDetail
        """
        super().__init__(
            id=id,
            name=name,
            status=status,
            percent_complete=percent_complete,
            start_time=start_time,
            end_time=end_time,
            operations=operations,
            error=error,
            **kwargs
        )
        self.object_type: Optional[str] = None


class OperationStatusExtendedResult(OperationStatusResult):
    """Represents Operation Results API Response.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Fully qualified ID for the async operation.
    :vartype id: str
    :ivar resource_id: Fully qualified ID of the resource against which the original async
     operation was started.
    :vartype resource_id: str
    :ivar name: Name of the async operation.
    :vartype name: str
    :ivar status: Operation status. Required.
    :vartype status: str
    :ivar percent_complete: Percent of the operation that is complete.
    :vartype percent_complete: float
    :ivar start_time: The start time of the operation.
    :vartype start_time: ~datetime.datetime
    :ivar end_time: The end time of the operation.
    :vartype end_time: ~datetime.datetime
    :ivar operations: The operations list.
    :vartype operations: list[~azure.mgmt.mysqlflexibleservers.models.OperationStatusResult]
    :ivar error: If present, details of the operation error.
    :vartype error: ~azure.mgmt.mysqlflexibleservers.models.ErrorDetail
    :ivar properties: The extended properties of Operation Results.
    :vartype properties: dict[str, any]
    """

    _validation = {
        "resource_id": {"readonly": True},
        "status": {"required": True},
        "percent_complete": {"maximum": 100, "minimum": 0},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "resource_id": {"key": "resourceId", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "status": {"key": "status", "type": "str"},
        "percent_complete": {"key": "percentComplete", "type": "float"},
        "start_time": {"key": "startTime", "type": "iso-8601"},
        "end_time": {"key": "endTime", "type": "iso-8601"},
        "operations": {"key": "operations", "type": "[OperationStatusResult]"},
        "error": {"key": "error", "type": "ErrorDetail"},
        "properties": {"key": "properties", "type": "{object}"},
    }

    def __init__(
        self,
        *,
        status: str,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        percent_complete: Optional[float] = None,
        start_time: Optional[datetime.datetime] = None,
        end_time: Optional[datetime.datetime] = None,
        operations: Optional[List["_models.OperationStatusResult"]] = None,
        error: Optional["_models.ErrorDetail"] = None,
        properties: Optional[Dict[str, Any]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Fully qualified ID for the async operation.
        :paramtype id: str
        :keyword name: Name of the async operation.
        :paramtype name: str
        :keyword status: Operation status. Required.
        :paramtype status: str
        :keyword percent_complete: Percent of the operation that is complete.
        :paramtype percent_complete: float
        :keyword start_time: The start time of the operation.
        :paramtype start_time: ~datetime.datetime
        :keyword end_time: The end time of the operation.
        :paramtype end_time: ~datetime.datetime
        :keyword operations: The operations list.
        :paramtype operations: list[~azure.mgmt.mysqlflexibleservers.models.OperationStatusResult]
        :keyword error: If present, details of the operation error.
        :paramtype error: ~azure.mgmt.mysqlflexibleservers.models.ErrorDetail
        :keyword properties: The extended properties of Operation Results.
        :paramtype properties: dict[str, any]
        """
        super().__init__(
            id=id,
            name=name,
            status=status,
            percent_complete=percent_complete,
            start_time=start_time,
            end_time=end_time,
            operations=operations,
            error=error,
            **kwargs
        )
        self.properties = properties


class PrivateEndpoint(_serialization.Model):
    """The private endpoint resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The ARM identifier for private endpoint.
    :vartype id: str
    """

    _validation = {
        "id": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.id = None


class PrivateEndpointConnection(Resource):
    """The private endpoint connection resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.mysqlflexibleservers.models.SystemData
    :ivar group_ids: The group ids for the private endpoint resource.
    :vartype group_ids: list[str]
    :ivar private_endpoint: The private endpoint resource.
    :vartype private_endpoint: ~azure.mgmt.mysqlflexibleservers.models.PrivateEndpoint
    :ivar private_link_service_connection_state: A collection of information about the state of the
     connection between service consumer and provider.
    :vartype private_link_service_connection_state:
     ~azure.mgmt.mysqlflexibleservers.models.PrivateLinkServiceConnectionState
    :ivar provisioning_state: The provisioning state of the private endpoint connection resource.
     Known values are: "Succeeded", "Creating", "Deleting", and "Failed".
    :vartype provisioning_state: str or
     ~azure.mgmt.mysqlflexibleservers.models.PrivateEndpointConnectionProvisioningState
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "group_ids": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "group_ids": {"key": "properties.groupIds", "type": "[str]"},
        "private_endpoint": {"key": "properties.privateEndpoint", "type": "PrivateEndpoint"},
        "private_link_service_connection_state": {
            "key": "properties.privateLinkServiceConnectionState",
            "type": "PrivateLinkServiceConnectionState",
        },
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        private_endpoint: Optional["_models.PrivateEndpoint"] = None,
        private_link_service_connection_state: Optional["_models.PrivateLinkServiceConnectionState"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword private_endpoint: The private endpoint resource.
        :paramtype private_endpoint: ~azure.mgmt.mysqlflexibleservers.models.PrivateEndpoint
        :keyword private_link_service_connection_state: A collection of information about the state of
         the connection between service consumer and provider.
        :paramtype private_link_service_connection_state:
         ~azure.mgmt.mysqlflexibleservers.models.PrivateLinkServiceConnectionState
        """
        super().__init__(**kwargs)
        self.group_ids = None
        self.private_endpoint = private_endpoint
        self.private_link_service_connection_state = private_link_service_connection_state
        self.provisioning_state = None


class PrivateLinkServiceConnectionState(_serialization.Model):
    """A collection of information about the state of the connection between service consumer and
    provider.

    :ivar status: Indicates whether the connection has been Approved/Rejected/Removed by the owner
     of the service. Known values are: "Pending", "Approved", and "Rejected".
    :vartype status: str or
     ~azure.mgmt.mysqlflexibleservers.models.PrivateEndpointServiceConnectionStatus
    :ivar description: The reason for approval/rejection of the connection.
    :vartype description: str
    :ivar actions_required: A message indicating if changes on the service provider require any
     updates on the consumer.
    :vartype actions_required: str
    """

    _attribute_map = {
        "status": {"key": "status", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "actions_required": {"key": "actionsRequired", "type": "str"},
    }

    def __init__(
        self,
        *,
        status: Optional[Union[str, "_models.PrivateEndpointServiceConnectionStatus"]] = None,
        description: Optional[str] = None,
        actions_required: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword status: Indicates whether the connection has been Approved/Rejected/Removed by the
         owner of the service. Known values are: "Pending", "Approved", and "Rejected".
        :paramtype status: str or
         ~azure.mgmt.mysqlflexibleservers.models.PrivateEndpointServiceConnectionStatus
        :keyword description: The reason for approval/rejection of the connection.
        :paramtype description: str
        :keyword actions_required: A message indicating if changes on the service provider require any
         updates on the consumer.
        :paramtype actions_required: str
        """
        super().__init__(**kwargs)
        self.status = status
        self.description = description
        self.actions_required = actions_required


class Provisioning(ProxyResource):
    """Server backup properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.mysqlflexibleservers.models.SystemData
    :ivar provisioning_state: The provisioning state of backup resource. Known values are:
     "Succeeded", "Creating", "Deleting", "Failed", and "Canceled".
    :vartype provisioning_state: str or ~azure.mgmt.mysqlflexibleservers.models.ProvisioningState
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.provisioning_state = None


class TrackedResource(Resource):
    """The resource model definition for an Azure Resource Manager tracked top level resource which
    has 'tags' and a 'location'.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.mysqlflexibleservers.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "location": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
    }

    def __init__(self, *, location: str, tags: Optional[Dict[str, str]] = None, **kwargs: Any) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        """
        super().__init__(**kwargs)
        self.tags = tags
        self.location = location


class Server(TrackedResource):  # pylint: disable=too-many-instance-attributes
    """Represents a server.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.mysqlflexibleservers.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar identity: The cmk identity for the server.
    :vartype identity: ~azure.mgmt.mysqlflexibleservers.models.MySQLServerIdentity
    :ivar sku: The SKU (pricing tier) of the server.
    :vartype sku: ~azure.mgmt.mysqlflexibleservers.models.MySQLServerSku
    :ivar administrator_login: The administrator's login name of a server. Can only be specified
     when the server is being created (and is required for creation).
    :vartype administrator_login: str
    :ivar administrator_login_password: The password of the administrator login (required for
     server creation).
    :vartype administrator_login_password: str
    :ivar version: Server version. Known values are: "5.7" and "8.0.21".
    :vartype version: str or ~azure.mgmt.mysqlflexibleservers.models.ServerVersion
    :ivar availability_zone: availability Zone information of the server.
    :vartype availability_zone: str
    :ivar create_mode: The mode to create a new MySQL server. Known values are: "Default",
     "PointInTimeRestore", "Replica", and "GeoRestore".
    :vartype create_mode: str or ~azure.mgmt.mysqlflexibleservers.models.CreateMode
    :ivar source_server_resource_id: The source MySQL server id.
    :vartype source_server_resource_id: str
    :ivar restore_point_in_time: Restore point creation time (ISO8601 format), specifying the time
     to restore from.
    :vartype restore_point_in_time: ~datetime.datetime
    :ivar replication_role: The replication role. Known values are: "None", "Source", and
     "Replica".
    :vartype replication_role: str or ~azure.mgmt.mysqlflexibleservers.models.ReplicationRole
    :ivar replica_capacity: The maximum number of replicas that a primary server can have.
    :vartype replica_capacity: int
    :ivar data_encryption: The Data Encryption for CMK.
    :vartype data_encryption: ~azure.mgmt.mysqlflexibleservers.models.DataEncryption
    :ivar state: The state of a server. Known values are: "Ready", "Dropping", "Disabled",
     "Starting", "Stopping", "Stopped", and "Updating".
    :vartype state: str or ~azure.mgmt.mysqlflexibleservers.models.ServerState
    :ivar fully_qualified_domain_name: The fully qualified domain name of a server.
    :vartype fully_qualified_domain_name: str
    :ivar database_port: The server database port. Can only be specified when the server is being
     created.
    :vartype database_port: int
    :ivar storage: Storage related properties of a server.
    :vartype storage: ~azure.mgmt.mysqlflexibleservers.models.Storage
    :ivar backup: Backup related properties of a server.
    :vartype backup: ~azure.mgmt.mysqlflexibleservers.models.Backup
    :ivar high_availability: High availability related properties of a server.
    :vartype high_availability: ~azure.mgmt.mysqlflexibleservers.models.HighAvailability
    :ivar network: Network related properties of a server.
    :vartype network: ~azure.mgmt.mysqlflexibleservers.models.Network
    :ivar private_endpoint_connections: PrivateEndpointConnections related properties of a server.
    :vartype private_endpoint_connections:
     list[~azure.mgmt.mysqlflexibleservers.models.PrivateEndpointConnection]
    :ivar maintenance_policy: Maintenance policy of a server.
    :vartype maintenance_policy: ~azure.mgmt.mysqlflexibleservers.models.MaintenancePolicy
    :ivar maintenance_window: Maintenance window of a server. Known issue: cannot be set during
     server creation or updated with other properties during server update; must be updated
     separately.
    :vartype maintenance_window: ~azure.mgmt.mysqlflexibleservers.models.MaintenanceWindow
    :ivar import_source_properties: Source properties for import from storage.
    :vartype import_source_properties:
     ~azure.mgmt.mysqlflexibleservers.models.ImportSourceProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "location": {"required": True},
        "replica_capacity": {"readonly": True, "minimum": 0},
        "state": {"readonly": True},
        "fully_qualified_domain_name": {"readonly": True},
        "private_endpoint_connections": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
        "identity": {"key": "identity", "type": "MySQLServerIdentity"},
        "sku": {"key": "sku", "type": "MySQLServerSku"},
        "administrator_login": {"key": "properties.administratorLogin", "type": "str"},
        "administrator_login_password": {"key": "properties.administratorLoginPassword", "type": "str"},
        "version": {"key": "properties.version", "type": "str"},
        "availability_zone": {"key": "properties.availabilityZone", "type": "str"},
        "create_mode": {"key": "properties.createMode", "type": "str"},
        "source_server_resource_id": {"key": "properties.sourceServerResourceId", "type": "str"},
        "restore_point_in_time": {"key": "properties.restorePointInTime", "type": "iso-8601"},
        "replication_role": {"key": "properties.replicationRole", "type": "str"},
        "replica_capacity": {"key": "properties.replicaCapacity", "type": "int"},
        "data_encryption": {"key": "properties.dataEncryption", "type": "DataEncryption"},
        "state": {"key": "properties.state", "type": "str"},
        "fully_qualified_domain_name": {"key": "properties.fullyQualifiedDomainName", "type": "str"},
        "database_port": {"key": "properties.databasePort", "type": "int"},
        "storage": {"key": "properties.storage", "type": "Storage"},
        "backup": {"key": "properties.backup", "type": "Backup"},
        "high_availability": {"key": "properties.highAvailability", "type": "HighAvailability"},
        "network": {"key": "properties.network", "type": "Network"},
        "private_endpoint_connections": {
            "key": "properties.privateEndpointConnections",
            "type": "[PrivateEndpointConnection]",
        },
        "maintenance_policy": {"key": "properties.maintenancePolicy", "type": "MaintenancePolicy"},
        "maintenance_window": {"key": "properties.maintenanceWindow", "type": "MaintenanceWindow"},
        "import_source_properties": {"key": "properties.importSourceProperties", "type": "ImportSourceProperties"},
    }

    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        identity: Optional["_models.MySQLServerIdentity"] = None,
        sku: Optional["_models.MySQLServerSku"] = None,
        administrator_login: Optional[str] = None,
        administrator_login_password: Optional[str] = None,
        version: Optional[Union[str, "_models.ServerVersion"]] = None,
        availability_zone: Optional[str] = None,
        create_mode: Optional[Union[str, "_models.CreateMode"]] = None,
        source_server_resource_id: Optional[str] = None,
        restore_point_in_time: Optional[datetime.datetime] = None,
        replication_role: Optional[Union[str, "_models.ReplicationRole"]] = None,
        data_encryption: Optional["_models.DataEncryption"] = None,
        database_port: Optional[int] = None,
        storage: Optional["_models.Storage"] = None,
        backup: Optional["_models.Backup"] = None,
        high_availability: Optional["_models.HighAvailability"] = None,
        network: Optional["_models.Network"] = None,
        maintenance_policy: Optional["_models.MaintenancePolicy"] = None,
        maintenance_window: Optional["_models.MaintenanceWindow"] = None,
        import_source_properties: Optional["_models.ImportSourceProperties"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        :keyword identity: The cmk identity for the server.
        :paramtype identity: ~azure.mgmt.mysqlflexibleservers.models.MySQLServerIdentity
        :keyword sku: The SKU (pricing tier) of the server.
        :paramtype sku: ~azure.mgmt.mysqlflexibleservers.models.MySQLServerSku
        :keyword administrator_login: The administrator's login name of a server. Can only be specified
         when the server is being created (and is required for creation).
        :paramtype administrator_login: str
        :keyword administrator_login_password: The password of the administrator login (required for
         server creation).
        :paramtype administrator_login_password: str
        :keyword version: Server version. Known values are: "5.7" and "8.0.21".
        :paramtype version: str or ~azure.mgmt.mysqlflexibleservers.models.ServerVersion
        :keyword availability_zone: availability Zone information of the server.
        :paramtype availability_zone: str
        :keyword create_mode: The mode to create a new MySQL server. Known values are: "Default",
         "PointInTimeRestore", "Replica", and "GeoRestore".
        :paramtype create_mode: str or ~azure.mgmt.mysqlflexibleservers.models.CreateMode
        :keyword source_server_resource_id: The source MySQL server id.
        :paramtype source_server_resource_id: str
        :keyword restore_point_in_time: Restore point creation time (ISO8601 format), specifying the
         time to restore from.
        :paramtype restore_point_in_time: ~datetime.datetime
        :keyword replication_role: The replication role. Known values are: "None", "Source", and
         "Replica".
        :paramtype replication_role: str or ~azure.mgmt.mysqlflexibleservers.models.ReplicationRole
        :keyword data_encryption: The Data Encryption for CMK.
        :paramtype data_encryption: ~azure.mgmt.mysqlflexibleservers.models.DataEncryption
        :keyword database_port: The server database port. Can only be specified when the server is
         being created.
        :paramtype database_port: int
        :keyword storage: Storage related properties of a server.
        :paramtype storage: ~azure.mgmt.mysqlflexibleservers.models.Storage
        :keyword backup: Backup related properties of a server.
        :paramtype backup: ~azure.mgmt.mysqlflexibleservers.models.Backup
        :keyword high_availability: High availability related properties of a server.
        :paramtype high_availability: ~azure.mgmt.mysqlflexibleservers.models.HighAvailability
        :keyword network: Network related properties of a server.
        :paramtype network: ~azure.mgmt.mysqlflexibleservers.models.Network
        :keyword maintenance_policy: Maintenance policy of a server.
        :paramtype maintenance_policy: ~azure.mgmt.mysqlflexibleservers.models.MaintenancePolicy
        :keyword maintenance_window: Maintenance window of a server. Known issue: cannot be set during
         server creation or updated with other properties during server update; must be updated
         separately.
        :paramtype maintenance_window: ~azure.mgmt.mysqlflexibleservers.models.MaintenanceWindow
        :keyword import_source_properties: Source properties for import from storage.
        :paramtype import_source_properties:
         ~azure.mgmt.mysqlflexibleservers.models.ImportSourceProperties
        """
        super().__init__(tags=tags, location=location, **kwargs)
        self.identity = identity
        self.sku = sku
        self.administrator_login = administrator_login
        self.administrator_login_password = administrator_login_password
        self.version = version
        self.availability_zone = availability_zone
        self.create_mode = create_mode
        self.source_server_resource_id = source_server_resource_id
        self.restore_point_in_time = restore_point_in_time
        self.replication_role = replication_role
        self.replica_capacity = None
        self.data_encryption = data_encryption
        self.state = None
        self.fully_qualified_domain_name = None
        self.database_port = database_port
        self.storage = storage
        self.backup = backup
        self.high_availability = high_availability
        self.network = network
        self.private_endpoint_connections = None
        self.maintenance_policy = maintenance_policy
        self.maintenance_window = maintenance_window
        self.import_source_properties = import_source_properties


class ServerBackup(ProxyResource):
    """Server backup properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.mysqlflexibleservers.models.SystemData
    :ivar backup_type: Backup type.
    :vartype backup_type: str
    :ivar completed_time: Backup completed time (ISO8601 format).
    :vartype completed_time: ~datetime.datetime
    :ivar source: Backup source.
    :vartype source: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "backup_type": {"key": "properties.backupType", "type": "str"},
        "completed_time": {"key": "properties.completedTime", "type": "iso-8601"},
        "source": {"key": "properties.source", "type": "str"},
    }

    def __init__(
        self,
        *,
        backup_type: Optional[str] = None,
        completed_time: Optional[datetime.datetime] = None,
        source: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword backup_type: Backup type.
        :paramtype backup_type: str
        :keyword completed_time: Backup completed time (ISO8601 format).
        :paramtype completed_time: ~datetime.datetime
        :keyword source: Backup source.
        :paramtype source: str
        """
        super().__init__(**kwargs)
        self.backup_type = backup_type
        self.completed_time = completed_time
        self.source = source


class ServerBackupListResult(_serialization.Model):
    """A list of server backups.

    :ivar value: The list of backups of a server.
    :vartype value: list[~azure.mgmt.mysqlflexibleservers.models.ServerBackup]
    :ivar next_link: The link used to get the next page of operations.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[ServerBackup]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.ServerBackup"]] = None, next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: The list of backups of a server.
        :paramtype value: list[~azure.mgmt.mysqlflexibleservers.models.ServerBackup]
        :keyword next_link: The link used to get the next page of operations.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class ServerBackupV2(ProxyResource):
    """Server backup properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.mysqlflexibleservers.models.SystemData
    :ivar backup_name_v2: Backup name.
    :vartype backup_name_v2: str
    :ivar backup_type: "FULL"
    :vartype backup_type: str or ~azure.mgmt.mysqlflexibleservers.models.BackupType
    :ivar completed_time: Backup completed time (ISO8601 format).
    :vartype completed_time: ~datetime.datetime
    :ivar source: Backup source.
    :vartype source: str
    :ivar provisioning_state: The provisioning state of backup resource. Known values are:
     "Succeeded", "Creating", "Deleting", "Failed", and "Canceled".
    :vartype provisioning_state: str or ~azure.mgmt.mysqlflexibleservers.models.ProvisioningState
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "backup_name_v2": {"key": "properties.backupNameV2", "type": "str"},
        "backup_type": {"key": "properties.backupType", "type": "str"},
        "completed_time": {"key": "properties.completedTime", "type": "iso-8601"},
        "source": {"key": "properties.source", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        backup_name_v2: Optional[str] = None,
        backup_type: Optional[Union[str, "_models.BackupType"]] = None,
        completed_time: Optional[datetime.datetime] = None,
        source: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword backup_name_v2: Backup name.
        :paramtype backup_name_v2: str
        :keyword backup_type: "FULL"
        :paramtype backup_type: str or ~azure.mgmt.mysqlflexibleservers.models.BackupType
        :keyword completed_time: Backup completed time (ISO8601 format).
        :paramtype completed_time: ~datetime.datetime
        :keyword source: Backup source.
        :paramtype source: str
        """
        super().__init__(**kwargs)
        self.backup_name_v2 = backup_name_v2
        self.backup_type = backup_type
        self.completed_time = completed_time
        self.source = source
        self.provisioning_state = None


class ServerBackupV2ListResult(_serialization.Model):
    """A list of server backups.

    :ivar value: The list of backups of a server.
    :vartype value: list[~azure.mgmt.mysqlflexibleservers.models.ServerBackupV2]
    :ivar next_link: The link used to get the next page of operations.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[ServerBackupV2]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.ServerBackupV2"]] = None, next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: The list of backups of a server.
        :paramtype value: list[~azure.mgmt.mysqlflexibleservers.models.ServerBackupV2]
        :keyword next_link: The link used to get the next page of operations.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class ServerDetachVNetParameter(_serialization.Model):
    """Parameters to detach Vnet.

    :ivar public_network_access: Whether or not public network access is allowed for this server.
     Value is 'Disabled' when server has VNet integration. Known values are: "Enabled" and
     "Disabled".
    :vartype public_network_access: str or ~azure.mgmt.mysqlflexibleservers.models.EnableStatusEnum
    """

    _attribute_map = {
        "public_network_access": {"key": "publicNetworkAccess", "type": "str"},
    }

    def __init__(
        self, *, public_network_access: Optional[Union[str, "_models.EnableStatusEnum"]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword public_network_access: Whether or not public network access is allowed for this
         server. Value is 'Disabled' when server has VNet integration. Known values are: "Enabled" and
         "Disabled".
        :paramtype public_network_access: str or
         ~azure.mgmt.mysqlflexibleservers.models.EnableStatusEnum
        """
        super().__init__(**kwargs)
        self.public_network_access = public_network_access


class ServerEditionCapability(_serialization.Model):
    """Server edition capabilities.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: Server edition name.
    :vartype name: str
    :ivar supported_storage_editions: A list of supported storage editions.
    :vartype supported_storage_editions:
     list[~azure.mgmt.mysqlflexibleservers.models.StorageEditionCapability]
    :ivar supported_server_versions: A list of supported server versions.
    :vartype supported_server_versions:
     list[~azure.mgmt.mysqlflexibleservers.models.ServerVersionCapability]
    """

    _validation = {
        "name": {"readonly": True},
        "supported_storage_editions": {"readonly": True},
        "supported_server_versions": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "supported_storage_editions": {"key": "supportedStorageEditions", "type": "[StorageEditionCapability]"},
        "supported_server_versions": {"key": "supportedServerVersions", "type": "[ServerVersionCapability]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.name = None
        self.supported_storage_editions = None
        self.supported_server_versions = None


class ServerEditionCapabilityV2(_serialization.Model):
    """Server edition capabilities.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: Server edition name.
    :vartype name: str
    :ivar default_sku: Default Sku name.
    :vartype default_sku: str
    :ivar default_storage_size: Default storage size.
    :vartype default_storage_size: int
    :ivar supported_storage_editions: A list of supported storage editions.
    :vartype supported_storage_editions:
     list[~azure.mgmt.mysqlflexibleservers.models.StorageEditionCapability]
    :ivar supported_skus: A list of supported Skus.
    :vartype supported_skus: list[~azure.mgmt.mysqlflexibleservers.models.SkuCapabilityV2]
    """

    _validation = {
        "name": {"readonly": True},
        "default_sku": {"readonly": True},
        "default_storage_size": {"readonly": True},
        "supported_storage_editions": {"readonly": True},
        "supported_skus": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "default_sku": {"key": "defaultSku", "type": "str"},
        "default_storage_size": {"key": "defaultStorageSize", "type": "int"},
        "supported_storage_editions": {"key": "supportedStorageEditions", "type": "[StorageEditionCapability]"},
        "supported_skus": {"key": "supportedSkus", "type": "[SkuCapabilityV2]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.name = None
        self.default_sku = None
        self.default_storage_size = None
        self.supported_storage_editions = None
        self.supported_skus = None


class ServerForUpdate(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """Parameters allowed to update for a server.

    :ivar identity: The cmk identity for the server.
    :vartype identity: ~azure.mgmt.mysqlflexibleservers.models.MySQLServerIdentity
    :ivar sku: The SKU (pricing tier) of the server.
    :vartype sku: ~azure.mgmt.mysqlflexibleservers.models.MySQLServerSku
    :ivar tags: Application-specific metadata in the form of key-value pairs.
    :vartype tags: dict[str, str]
    :ivar administrator_login_password: The password of the administrator login.
    :vartype administrator_login_password: str
    :ivar version: Server version. Known values are: "5.7" and "8.0.21".
    :vartype version: str or ~azure.mgmt.mysqlflexibleservers.models.ServerVersion
    :ivar storage: Storage related properties of a server.
    :vartype storage: ~azure.mgmt.mysqlflexibleservers.models.Storage
    :ivar backup: Backup related properties of a server.
    :vartype backup: ~azure.mgmt.mysqlflexibleservers.models.Backup
    :ivar high_availability: High availability related properties of a server.
    :vartype high_availability: ~azure.mgmt.mysqlflexibleservers.models.HighAvailability
    :ivar maintenance_policy: Maintenance policy of a server.
    :vartype maintenance_policy: ~azure.mgmt.mysqlflexibleservers.models.MaintenancePolicy
    :ivar maintenance_window: Maintenance window of a server.
    :vartype maintenance_window: ~azure.mgmt.mysqlflexibleservers.models.MaintenanceWindow
    :ivar replication_role: The replication role of the server. Known values are: "None", "Source",
     and "Replica".
    :vartype replication_role: str or ~azure.mgmt.mysqlflexibleservers.models.ReplicationRole
    :ivar data_encryption: The Data Encryption for CMK.
    :vartype data_encryption: ~azure.mgmt.mysqlflexibleservers.models.DataEncryption
    :ivar network: Network related properties of a server.
    :vartype network: ~azure.mgmt.mysqlflexibleservers.models.Network
    """

    _attribute_map = {
        "identity": {"key": "identity", "type": "MySQLServerIdentity"},
        "sku": {"key": "sku", "type": "MySQLServerSku"},
        "tags": {"key": "tags", "type": "{str}"},
        "administrator_login_password": {"key": "properties.administratorLoginPassword", "type": "str"},
        "version": {"key": "properties.version", "type": "str"},
        "storage": {"key": "properties.storage", "type": "Storage"},
        "backup": {"key": "properties.backup", "type": "Backup"},
        "high_availability": {"key": "properties.highAvailability", "type": "HighAvailability"},
        "maintenance_policy": {"key": "properties.maintenancePolicy", "type": "MaintenancePolicy"},
        "maintenance_window": {"key": "properties.maintenanceWindow", "type": "MaintenanceWindow"},
        "replication_role": {"key": "properties.replicationRole", "type": "str"},
        "data_encryption": {"key": "properties.dataEncryption", "type": "DataEncryption"},
        "network": {"key": "properties.network", "type": "Network"},
    }

    def __init__(
        self,
        *,
        identity: Optional["_models.MySQLServerIdentity"] = None,
        sku: Optional["_models.MySQLServerSku"] = None,
        tags: Optional[Dict[str, str]] = None,
        administrator_login_password: Optional[str] = None,
        version: Optional[Union[str, "_models.ServerVersion"]] = None,
        storage: Optional["_models.Storage"] = None,
        backup: Optional["_models.Backup"] = None,
        high_availability: Optional["_models.HighAvailability"] = None,
        maintenance_policy: Optional["_models.MaintenancePolicy"] = None,
        maintenance_window: Optional["_models.MaintenanceWindow"] = None,
        replication_role: Optional[Union[str, "_models.ReplicationRole"]] = None,
        data_encryption: Optional["_models.DataEncryption"] = None,
        network: Optional["_models.Network"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword identity: The cmk identity for the server.
        :paramtype identity: ~azure.mgmt.mysqlflexibleservers.models.MySQLServerIdentity
        :keyword sku: The SKU (pricing tier) of the server.
        :paramtype sku: ~azure.mgmt.mysqlflexibleservers.models.MySQLServerSku
        :keyword tags: Application-specific metadata in the form of key-value pairs.
        :paramtype tags: dict[str, str]
        :keyword administrator_login_password: The password of the administrator login.
        :paramtype administrator_login_password: str
        :keyword version: Server version. Known values are: "5.7" and "8.0.21".
        :paramtype version: str or ~azure.mgmt.mysqlflexibleservers.models.ServerVersion
        :keyword storage: Storage related properties of a server.
        :paramtype storage: ~azure.mgmt.mysqlflexibleservers.models.Storage
        :keyword backup: Backup related properties of a server.
        :paramtype backup: ~azure.mgmt.mysqlflexibleservers.models.Backup
        :keyword high_availability: High availability related properties of a server.
        :paramtype high_availability: ~azure.mgmt.mysqlflexibleservers.models.HighAvailability
        :keyword maintenance_policy: Maintenance policy of a server.
        :paramtype maintenance_policy: ~azure.mgmt.mysqlflexibleservers.models.MaintenancePolicy
        :keyword maintenance_window: Maintenance window of a server.
        :paramtype maintenance_window: ~azure.mgmt.mysqlflexibleservers.models.MaintenanceWindow
        :keyword replication_role: The replication role of the server. Known values are: "None",
         "Source", and "Replica".
        :paramtype replication_role: str or ~azure.mgmt.mysqlflexibleservers.models.ReplicationRole
        :keyword data_encryption: The Data Encryption for CMK.
        :paramtype data_encryption: ~azure.mgmt.mysqlflexibleservers.models.DataEncryption
        :keyword network: Network related properties of a server.
        :paramtype network: ~azure.mgmt.mysqlflexibleservers.models.Network
        """
        super().__init__(**kwargs)
        self.identity = identity
        self.sku = sku
        self.tags = tags
        self.administrator_login_password = administrator_login_password
        self.version = version
        self.storage = storage
        self.backup = backup
        self.high_availability = high_availability
        self.maintenance_policy = maintenance_policy
        self.maintenance_window = maintenance_window
        self.replication_role = replication_role
        self.data_encryption = data_encryption
        self.network = network


class ServerGtidSetParameter(_serialization.Model):
    """Server Gtid set parameters: Replication with Global Transaction Identifiers.

    :ivar gtid_set: The Gtid set of server.
    :vartype gtid_set: str
    """

    _attribute_map = {
        "gtid_set": {"key": "gtidSet", "type": "str"},
    }

    def __init__(self, *, gtid_set: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword gtid_set: The Gtid set of server.
        :paramtype gtid_set: str
        """
        super().__init__(**kwargs)
        self.gtid_set = gtid_set


class ServerListResult(_serialization.Model):
    """A list of servers.

    :ivar value: The list of servers.
    :vartype value: list[~azure.mgmt.mysqlflexibleservers.models.Server]
    :ivar next_link: The link used to get the next page of operations.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[Server]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.Server"]] = None, next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: The list of servers.
        :paramtype value: list[~azure.mgmt.mysqlflexibleservers.models.Server]
        :keyword next_link: The link used to get the next page of operations.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class ServerRestartParameter(_serialization.Model):
    """Server restart parameters.

    :ivar restart_with_failover: Whether or not failover to standby server when restarting a server
     with high availability enabled. Known values are: "Enabled" and "Disabled".
    :vartype restart_with_failover: str or ~azure.mgmt.mysqlflexibleservers.models.EnableStatusEnum
    :ivar max_failover_seconds: The maximum allowed failover time in seconds.
    :vartype max_failover_seconds: int
    """

    _attribute_map = {
        "restart_with_failover": {"key": "restartWithFailover", "type": "str"},
        "max_failover_seconds": {"key": "maxFailoverSeconds", "type": "int"},
    }

    def __init__(
        self,
        *,
        restart_with_failover: Optional[Union[str, "_models.EnableStatusEnum"]] = None,
        max_failover_seconds: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword restart_with_failover: Whether or not failover to standby server when restarting a
         server with high availability enabled. Known values are: "Enabled" and "Disabled".
        :paramtype restart_with_failover: str or
         ~azure.mgmt.mysqlflexibleservers.models.EnableStatusEnum
        :keyword max_failover_seconds: The maximum allowed failover time in seconds.
        :paramtype max_failover_seconds: int
        """
        super().__init__(**kwargs)
        self.restart_with_failover = restart_with_failover
        self.max_failover_seconds = max_failover_seconds


class ServerVersionCapability(_serialization.Model):
    """Server version capabilities.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: server version.
    :vartype name: str
    :ivar supported_skus: A list of supported Skus.
    :vartype supported_skus: list[~azure.mgmt.mysqlflexibleservers.models.SkuCapability]
    """

    _validation = {
        "name": {"readonly": True},
        "supported_skus": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "supported_skus": {"key": "supportedSkus", "type": "[SkuCapability]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.name = None
        self.supported_skus = None


class ServerVersionCapabilityV2(_serialization.Model):
    """Server version capabilities.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: server version.
    :vartype name: str
    """

    _validation = {
        "name": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.name = None


class SkuCapability(_serialization.Model):
    """Sku capability.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: vCore name.
    :vartype name: str
    :ivar v_cores: supported vCores.
    :vartype v_cores: int
    :ivar supported_iops: supported IOPS.
    :vartype supported_iops: int
    :ivar supported_memory_per_v_core_mb: supported memory per vCore in MB.
    :vartype supported_memory_per_v_core_mb: int
    """

    _validation = {
        "name": {"readonly": True},
        "v_cores": {"readonly": True},
        "supported_iops": {"readonly": True},
        "supported_memory_per_v_core_mb": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "v_cores": {"key": "vCores", "type": "int"},
        "supported_iops": {"key": "supportedIops", "type": "int"},
        "supported_memory_per_v_core_mb": {"key": "supportedMemoryPerVCoreMB", "type": "int"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.name = None
        self.v_cores = None
        self.supported_iops = None
        self.supported_memory_per_v_core_mb = None


class SkuCapabilityV2(_serialization.Model):
    """Sku capability.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: vCore name.
    :vartype name: str
    :ivar v_cores: supported vCores.
    :vartype v_cores: int
    :ivar supported_iops: supported IOPS.
    :vartype supported_iops: int
    :ivar supported_memory_per_v_core_mb: supported memory per vCore in MB.
    :vartype supported_memory_per_v_core_mb: int
    :ivar supported_zones: Supported zones.
    :vartype supported_zones: list[str]
    :ivar supported_ha_mode: Supported high availability mode.
    :vartype supported_ha_mode: list[str]
    """

    _validation = {
        "name": {"readonly": True},
        "v_cores": {"readonly": True},
        "supported_iops": {"readonly": True},
        "supported_memory_per_v_core_mb": {"readonly": True},
        "supported_zones": {"readonly": True},
        "supported_ha_mode": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "v_cores": {"key": "vCores", "type": "int"},
        "supported_iops": {"key": "supportedIops", "type": "int"},
        "supported_memory_per_v_core_mb": {"key": "supportedMemoryPerVCoreMB", "type": "int"},
        "supported_zones": {"key": "supportedZones", "type": "[str]"},
        "supported_ha_mode": {"key": "supportedHAMode", "type": "[str]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.name = None
        self.v_cores = None
        self.supported_iops = None
        self.supported_memory_per_v_core_mb = None
        self.supported_zones = None
        self.supported_ha_mode = None


class Storage(_serialization.Model):
    """Storage Profile properties of a server.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar storage_size_gb: Max storage size allowed for a server.
    :vartype storage_size_gb: int
    :ivar iops: Storage IOPS for a server.
    :vartype iops: int
    :ivar auto_grow: Enable Storage Auto Grow or not. Known values are: "Enabled" and "Disabled".
    :vartype auto_grow: str or ~azure.mgmt.mysqlflexibleservers.models.EnableStatusEnum
    :ivar log_on_disk: Enable Log On Disk or not. Known values are: "Enabled" and "Disabled".
    :vartype log_on_disk: str or ~azure.mgmt.mysqlflexibleservers.models.EnableStatusEnum
    :ivar storage_sku: The sku name of the server storage.
    :vartype storage_sku: str
    :ivar auto_io_scaling: Enable IO Auto Scaling or not. Known values are: "Enabled" and
     "Disabled".
    :vartype auto_io_scaling: str or ~azure.mgmt.mysqlflexibleservers.models.EnableStatusEnum
    :ivar storage_redundancy: The redundant type of the server storage. The parameter is used for
     server creation. Known values are: "LocalRedundancy" and "ZoneRedundancy".
    :vartype storage_redundancy: str or
     ~azure.mgmt.mysqlflexibleservers.models.StorageRedundancyEnum
    """

    _validation = {
        "storage_sku": {"readonly": True},
    }

    _attribute_map = {
        "storage_size_gb": {"key": "storageSizeGB", "type": "int"},
        "iops": {"key": "iops", "type": "int"},
        "auto_grow": {"key": "autoGrow", "type": "str"},
        "log_on_disk": {"key": "logOnDisk", "type": "str"},
        "storage_sku": {"key": "storageSku", "type": "str"},
        "auto_io_scaling": {"key": "autoIoScaling", "type": "str"},
        "storage_redundancy": {"key": "storageRedundancy", "type": "str"},
    }

    def __init__(
        self,
        *,
        storage_size_gb: Optional[int] = None,
        iops: Optional[int] = None,
        auto_grow: Optional[Union[str, "_models.EnableStatusEnum"]] = None,
        log_on_disk: Optional[Union[str, "_models.EnableStatusEnum"]] = None,
        auto_io_scaling: Optional[Union[str, "_models.EnableStatusEnum"]] = None,
        storage_redundancy: Optional[Union[str, "_models.StorageRedundancyEnum"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword storage_size_gb: Max storage size allowed for a server.
        :paramtype storage_size_gb: int
        :keyword iops: Storage IOPS for a server.
        :paramtype iops: int
        :keyword auto_grow: Enable Storage Auto Grow or not. Known values are: "Enabled" and
         "Disabled".
        :paramtype auto_grow: str or ~azure.mgmt.mysqlflexibleservers.models.EnableStatusEnum
        :keyword log_on_disk: Enable Log On Disk or not. Known values are: "Enabled" and "Disabled".
        :paramtype log_on_disk: str or ~azure.mgmt.mysqlflexibleservers.models.EnableStatusEnum
        :keyword auto_io_scaling: Enable IO Auto Scaling or not. Known values are: "Enabled" and
         "Disabled".
        :paramtype auto_io_scaling: str or ~azure.mgmt.mysqlflexibleservers.models.EnableStatusEnum
        :keyword storage_redundancy: The redundant type of the server storage. The parameter is used
         for server creation. Known values are: "LocalRedundancy" and "ZoneRedundancy".
        :paramtype storage_redundancy: str or
         ~azure.mgmt.mysqlflexibleservers.models.StorageRedundancyEnum
        """
        super().__init__(**kwargs)
        self.storage_size_gb = storage_size_gb
        self.iops = iops
        self.auto_grow = auto_grow
        self.log_on_disk = log_on_disk
        self.storage_sku = None
        self.auto_io_scaling = auto_io_scaling
        self.storage_redundancy = storage_redundancy


class StorageEditionCapability(_serialization.Model):
    """storage edition capability.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: storage edition name.
    :vartype name: str
    :ivar min_storage_size: The minimal supported storage size.
    :vartype min_storage_size: int
    :ivar max_storage_size: The maximum supported storage size.
    :vartype max_storage_size: int
    :ivar min_backup_retention_days: Minimal backup retention days.
    :vartype min_backup_retention_days: int
    :ivar max_backup_retention_days: Maximum backup retention days.
    :vartype max_backup_retention_days: int
    :ivar min_backup_interval_hours: Minimal backup interval hours.
    :vartype min_backup_interval_hours: int
    :ivar max_backup_interval_hours: Maximum backup interval hours.
    :vartype max_backup_interval_hours: int
    """

    _validation = {
        "name": {"readonly": True},
        "min_storage_size": {"readonly": True},
        "max_storage_size": {"readonly": True},
        "min_backup_retention_days": {"readonly": True},
        "max_backup_retention_days": {"readonly": True},
        "min_backup_interval_hours": {"readonly": True},
        "max_backup_interval_hours": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "min_storage_size": {"key": "minStorageSize", "type": "int"},
        "max_storage_size": {"key": "maxStorageSize", "type": "int"},
        "min_backup_retention_days": {"key": "minBackupRetentionDays", "type": "int"},
        "max_backup_retention_days": {"key": "maxBackupRetentionDays", "type": "int"},
        "min_backup_interval_hours": {"key": "minBackupIntervalHours", "type": "int"},
        "max_backup_interval_hours": {"key": "maxBackupIntervalHours", "type": "int"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.name = None
        self.min_storage_size = None
        self.max_storage_size = None
        self.min_backup_retention_days = None
        self.max_backup_retention_days = None
        self.min_backup_interval_hours = None
        self.max_backup_interval_hours = None


class SystemData(_serialization.Model):
    """Metadata pertaining to creation and last modification of the resource.

    :ivar created_by: The identity that created the resource.
    :vartype created_by: str
    :ivar created_by_type: The type of identity that created the resource. Known values are:
     "User", "Application", "ManagedIdentity", and "Key".
    :vartype created_by_type: str or ~azure.mgmt.mysqlflexibleservers.models.CreatedByType
    :ivar created_at: The timestamp of resource creation (UTC).
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_by: The identity that last modified the resource.
    :vartype last_modified_by: str
    :ivar last_modified_by_type: The type of identity that last modified the resource. Known values
     are: "User", "Application", "ManagedIdentity", and "Key".
    :vartype last_modified_by_type: str or ~azure.mgmt.mysqlflexibleservers.models.CreatedByType
    :ivar last_modified_at: The timestamp of resource last modification (UTC).
    :vartype last_modified_at: ~datetime.datetime
    """

    _attribute_map = {
        "created_by": {"key": "createdBy", "type": "str"},
        "created_by_type": {"key": "createdByType", "type": "str"},
        "created_at": {"key": "createdAt", "type": "iso-8601"},
        "last_modified_by": {"key": "lastModifiedBy", "type": "str"},
        "last_modified_by_type": {"key": "lastModifiedByType", "type": "str"},
        "last_modified_at": {"key": "lastModifiedAt", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        created_by: Optional[str] = None,
        created_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        last_modified_at: Optional[datetime.datetime] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword created_by: The identity that created the resource.
        :paramtype created_by: str
        :keyword created_by_type: The type of identity that created the resource. Known values are:
         "User", "Application", "ManagedIdentity", and "Key".
        :paramtype created_by_type: str or ~azure.mgmt.mysqlflexibleservers.models.CreatedByType
        :keyword created_at: The timestamp of resource creation (UTC).
        :paramtype created_at: ~datetime.datetime
        :keyword last_modified_by: The identity that last modified the resource.
        :paramtype last_modified_by: str
        :keyword last_modified_by_type: The type of identity that last modified the resource. Known
         values are: "User", "Application", "ManagedIdentity", and "Key".
        :paramtype last_modified_by_type: str or ~azure.mgmt.mysqlflexibleservers.models.CreatedByType
        :keyword last_modified_at: The timestamp of resource last modification (UTC).
        :paramtype last_modified_at: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.created_by = created_by
        self.created_by_type = created_by_type
        self.created_at = created_at
        self.last_modified_by = last_modified_by
        self.last_modified_by_type = last_modified_by_type
        self.last_modified_at = last_modified_at


class UserAssignedIdentity(_serialization.Model):
    """Metadata of user assigned identity.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar principal_id: Principal Id of user assigned identity.
    :vartype principal_id: str
    :ivar client_id: Client Id of user assigned identity.
    :vartype client_id: str
    """

    _validation = {
        "principal_id": {"readonly": True},
        "client_id": {"readonly": True},
    }

    _attribute_map = {
        "principal_id": {"key": "principalId", "type": "str"},
        "client_id": {"key": "clientId", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.principal_id = None
        self.client_id = None


class ValidateBackupResponse(_serialization.Model):
    """Represents ValidateBackup API Response.

    :ivar number_of_containers: Estimated no of storage containers required for resource data to be
     backed up.
    :vartype number_of_containers: int
    """

    _attribute_map = {
        "number_of_containers": {"key": "properties.numberOfContainers", "type": "int"},
    }

    def __init__(self, *, number_of_containers: Optional[int] = None, **kwargs: Any) -> None:
        """
        :keyword number_of_containers: Estimated no of storage containers required for resource data to
         be backed up.
        :paramtype number_of_containers: int
        """
        super().__init__(**kwargs)
        self.number_of_containers = number_of_containers


class VirtualNetworkSubnetUsageParameter(_serialization.Model):
    """Virtual network subnet usage parameter.

    :ivar virtual_network_resource_id: Virtual network resource id.
    :vartype virtual_network_resource_id: str
    """

    _attribute_map = {
        "virtual_network_resource_id": {"key": "virtualNetworkResourceId", "type": "str"},
    }

    def __init__(self, *, virtual_network_resource_id: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword virtual_network_resource_id: Virtual network resource id.
        :paramtype virtual_network_resource_id: str
        """
        super().__init__(**kwargs)
        self.virtual_network_resource_id = virtual_network_resource_id


class VirtualNetworkSubnetUsageResult(_serialization.Model):
    """Virtual network subnet usage data.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar location: The location name.
    :vartype location: str
    :ivar subscription_id: The subscription id.
    :vartype subscription_id: str
    :ivar delegated_subnets_usage: A list of delegated subnet usage.
    :vartype delegated_subnets_usage:
     list[~azure.mgmt.mysqlflexibleservers.models.DelegatedSubnetUsage]
    """

    _validation = {
        "location": {"readonly": True},
        "subscription_id": {"readonly": True},
        "delegated_subnets_usage": {"readonly": True},
    }

    _attribute_map = {
        "location": {"key": "location", "type": "str"},
        "subscription_id": {"key": "subscriptionId", "type": "str"},
        "delegated_subnets_usage": {"key": "delegatedSubnetsUsage", "type": "[DelegatedSubnetUsage]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.location = None
        self.subscription_id = None
        self.delegated_subnets_usage = None
