/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.timeseries.transport;

import java.io.IOException;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.FailedNodeException;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.nodes.TransportNodesAction;
import org.opensearch.ad.caching.ADCacheProvider;
import org.opensearch.ad.caching.ADPriorityCache;
import org.opensearch.ad.ml.ADColdStart;
import org.opensearch.ad.ml.ADModelManager;
import org.opensearch.ad.task.ADTaskManager;
import org.opensearch.ad.transport.CronAction;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.forecast.caching.ForecastCacheProvider;
import org.opensearch.forecast.caching.ForecastPriorityCache;
import org.opensearch.forecast.ml.ForecastColdStart;
import org.opensearch.forecast.task.ForecastTaskManager;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.timeseries.NodeStateManager;
import org.opensearch.timeseries.transport.CronNodeRequest;
import org.opensearch.timeseries.transport.CronNodeResponse;
import org.opensearch.timeseries.transport.CronRequest;
import org.opensearch.timeseries.transport.CronResponse;
import org.opensearch.transport.TransportService;

public class CronTransportAction
extends TransportNodesAction<CronRequest, CronResponse, CronNodeRequest, CronNodeResponse> {
    private final Logger LOG = LogManager.getLogger(CronTransportAction.class);
    private NodeStateManager transportStateManager;
    private ADModelManager adModelManager;
    private ADCacheProvider adCacheProvider;
    private ForecastCacheProvider forecastCacheProvider;
    private ADColdStart adEntityColdStarter;
    private ForecastColdStart forecastColdStarter;
    private ADTaskManager adTaskManager;
    private ForecastTaskManager forecastTaskManager;

    @Inject
    public CronTransportAction(ThreadPool threadPool, ClusterService clusterService, TransportService transportService, ActionFilters actionFilters, NodeStateManager tarnsportStatemanager, ADModelManager adModelManager, ADCacheProvider adCacheProvider, ForecastCacheProvider forecastCacheProvider, ADColdStart adEntityColdStarter, ForecastColdStart forecastColdStarter, ADTaskManager adTaskManager, ForecastTaskManager forecastTaskManager) {
        super(CronAction.NAME, threadPool, clusterService, transportService, actionFilters, CronRequest::new, CronNodeRequest::new, "management", CronNodeResponse.class);
        this.transportStateManager = tarnsportStatemanager;
        this.adModelManager = adModelManager;
        this.adCacheProvider = adCacheProvider;
        this.forecastCacheProvider = forecastCacheProvider;
        this.adEntityColdStarter = adEntityColdStarter;
        this.forecastColdStarter = forecastColdStarter;
        this.adTaskManager = adTaskManager;
        this.forecastTaskManager = forecastTaskManager;
    }

    protected CronResponse newResponse(CronRequest request, List<CronNodeResponse> responses, List<FailedNodeException> failures) {
        return new CronResponse(this.clusterService.getClusterName(), responses, failures);
    }

    protected CronNodeRequest newNodeRequest(CronRequest request) {
        return new CronNodeRequest();
    }

    protected CronNodeResponse newNodeResponse(StreamInput in) throws IOException {
        return new CronNodeResponse(in);
    }

    protected CronNodeResponse nodeOperation(CronNodeRequest request) {
        this.LOG.info("Start running hourly cron.");
        this.adModelManager.maintenance((ActionListener<Void>)ActionListener.wrap(v -> this.LOG.debug("model maintenance done"), e -> this.LOG.error("Error maintaining ad model", (Throwable)e)));
        ((ADPriorityCache)this.adCacheProvider.get()).maintenance();
        this.adEntityColdStarter.maintenance();
        this.adTaskManager.cleanChildTasksAndResultsOfDeletedTask();
        this.adTaskManager.cleanResultOfDeletedConfig();
        this.adTaskManager.maintainRunningHistoricalTasks(this.transportService, 100);
        this.adTaskManager.maintainRunningRealtimeTasks();
        ((ForecastPriorityCache)this.forecastCacheProvider.get()).maintenance();
        this.forecastColdStarter.maintenance();
        this.forecastTaskManager.cleanChildTasksAndResultsOfDeletedTask();
        this.forecastTaskManager.cleanResultOfDeletedConfig();
        this.forecastTaskManager.maintainRunningRealtimeTasks();
        this.transportStateManager.maintenance();
        return new CronNodeResponse(this.clusterService.localNode());
    }
}

