/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.messages.types;

import io.cucumber.messages.types.FeatureChild;
import io.cucumber.messages.types.Location;
import io.cucumber.messages.types.Tag;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public final class Feature {
    private final Location location;
    private final List<Tag> tags;
    private final String language;
    private final String keyword;
    private final String name;
    private final String description;
    private final List<FeatureChild> children;

    public Feature(Location location, List<Tag> tags, String language, String keyword, String name, String description, List<FeatureChild> children) {
        this.location = Objects.requireNonNull(location, "Feature.location cannot be null");
        this.tags = Collections.unmodifiableList(new ArrayList(Objects.requireNonNull(tags, "Feature.tags cannot be null")));
        this.language = Objects.requireNonNull(language, "Feature.language cannot be null");
        this.keyword = Objects.requireNonNull(keyword, "Feature.keyword cannot be null");
        this.name = Objects.requireNonNull(name, "Feature.name cannot be null");
        this.description = Objects.requireNonNull(description, "Feature.description cannot be null");
        this.children = Collections.unmodifiableList(new ArrayList(Objects.requireNonNull(children, "Feature.children cannot be null")));
    }

    public Location getLocation() {
        return this.location;
    }

    public List<Tag> getTags() {
        return this.tags;
    }

    public String getLanguage() {
        return this.language;
    }

    public String getKeyword() {
        return this.keyword;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public List<FeatureChild> getChildren() {
        return this.children;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Feature that = (Feature)o;
        return this.location.equals(that.location) && this.tags.equals(that.tags) && this.language.equals(that.language) && this.keyword.equals(that.keyword) && this.name.equals(that.name) && this.description.equals(that.description) && this.children.equals(that.children);
    }

    public int hashCode() {
        return Objects.hash(this.location, this.tags, this.language, this.keyword, this.name, this.description, this.children);
    }

    public String toString() {
        return "Feature{location=" + this.location + ", tags=" + this.tags + ", language=" + this.language + ", keyword=" + this.keyword + ", name=" + this.name + ", description=" + this.description + ", children=" + this.children + '}';
    }
}

