/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.nodes;

import jadx.core.dex.attributes.AFlag;
import jadx.core.dex.attributes.AType;
import jadx.core.dex.attributes.AttrNode;
import jadx.core.dex.attributes.nodes.IgnoreEdgeAttr;
import jadx.core.dex.attributes.nodes.LoopInfo;
import jadx.core.dex.nodes.IBlock;
import jadx.core.dex.nodes.InsnNode;
import jadx.core.utils.BlockUtils;
import jadx.core.utils.EmptyBitSet;
import jadx.core.utils.InsnUtils;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class BlockNode
extends AttrNode
implements IBlock {
    private int id;
    private final int startOffset;
    private final List<InsnNode> instructions = new ArrayList<InsnNode>(2);
    private List<BlockNode> predecessors = new ArrayList<BlockNode>(1);
    private List<BlockNode> successors = new ArrayList<BlockNode>(1);
    private List<BlockNode> cleanSuccessors;
    private BitSet doms = EmptyBitSet.EMPTY;
    private BitSet domFrontier;
    private BlockNode idom;
    private List<BlockNode> dominatesOn = Collections.emptyList();

    public BlockNode(int id, int offset) {
        this.id = id;
        this.startOffset = offset;
    }

    public void setId(int id) {
        this.id = id;
    }

    public int getId() {
        return this.id;
    }

    public List<BlockNode> getPredecessors() {
        return this.predecessors;
    }

    public List<BlockNode> getSuccessors() {
        return this.successors;
    }

    public List<BlockNode> getCleanSuccessors() {
        return this.cleanSuccessors;
    }

    public void updateCleanSuccessors() {
        this.cleanSuccessors = BlockNode.cleanSuccessors(this);
    }

    public void lock() {
        this.cleanSuccessors = this.lockList(this.cleanSuccessors);
        this.successors = this.lockList(this.successors);
        this.predecessors = this.lockList(this.predecessors);
        this.dominatesOn = this.lockList(this.dominatesOn);
    }

    List<BlockNode> lockList(List<BlockNode> list) {
        if (list.isEmpty()) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(list);
    }

    private static List<BlockNode> cleanSuccessors(BlockNode block) {
        IgnoreEdgeAttr ignoreEdgeAttr;
        List<BlockNode> sucList = block.getSuccessors();
        if (sucList.isEmpty()) {
            return sucList;
        }
        LinkedList<BlockNode> toRemove = new LinkedList<BlockNode>();
        for (BlockNode b : sucList) {
            if (!BlockUtils.isBlockMustBeCleared(b)) continue;
            toRemove.add(b);
        }
        if (block.contains(AFlag.LOOP_END)) {
            List loops = block.getAll(AType.LOOP);
            for (LoopInfo loop : loops) {
                toRemove.add(loop.getStart());
            }
        }
        if ((ignoreEdgeAttr = block.get(AType.IGNORE_EDGE)) != null) {
            toRemove.addAll(ignoreEdgeAttr.getBlocks());
        }
        if (toRemove.isEmpty()) {
            return sucList;
        }
        ArrayList<BlockNode> result = new ArrayList<BlockNode>(sucList);
        result.removeAll(toRemove);
        return result;
    }

    @Override
    public List<InsnNode> getInstructions() {
        return this.instructions;
    }

    public int getStartOffset() {
        return this.startOffset;
    }

    public boolean isDominator(BlockNode block) {
        return this.doms.get(block.getId());
    }

    public BitSet getDoms() {
        return this.doms;
    }

    public void setDoms(BitSet doms) {
        this.doms = doms;
    }

    public BitSet getDomFrontier() {
        return this.domFrontier;
    }

    public void setDomFrontier(BitSet domFrontier) {
        this.domFrontier = domFrontier;
    }

    public BlockNode getIDom() {
        return this.idom;
    }

    public void setIDom(BlockNode idom) {
        this.idom = idom;
    }

    public List<BlockNode> getDominatesOn() {
        return this.dominatesOn;
    }

    public void addDominatesOn(BlockNode block) {
        if (this.dominatesOn.isEmpty()) {
            this.dominatesOn = new LinkedList<BlockNode>();
        }
        this.dominatesOn.add(block);
    }

    public boolean isSynthetic() {
        return this.contains(AFlag.SYNTHETIC);
    }

    public boolean isReturnBlock() {
        return this.contains(AFlag.RETURN);
    }

    public int hashCode() {
        return this.startOffset;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof BlockNode)) {
            return false;
        }
        BlockNode other = (BlockNode)obj;
        return this.id == other.id && this.startOffset == other.startOffset;
    }

    @Override
    public String baseString() {
        return Integer.toString(this.id);
    }

    public String toString() {
        return "B:" + this.id + ":" + InsnUtils.formatOffset(this.startOffset);
    }
}

