/*
 * Decompiled with CFR 0.152.
 */
package org.GNOME.Accessibility;

import java.lang.ref.WeakReference;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleSelection;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import org.GNOME.Accessibility.AtkUtil;

public class AtkSelection {
    WeakReference<AccessibleContext> _ac;
    WeakReference<AccessibleSelection> _acc_selection;

    public AtkSelection(AccessibleContext accessibleContext) {
        this._ac = new WeakReference<AccessibleContext>(accessibleContext);
        this._acc_selection = new WeakReference<AccessibleSelection>(accessibleContext.getAccessibleSelection());
    }

    public static AtkSelection createAtkSelection(AccessibleContext accessibleContext) {
        return AtkUtil.invokeInSwing(() -> new AtkSelection(accessibleContext), null);
    }

    public boolean add_selection(int n) {
        AccessibleSelection accessibleSelection = (AccessibleSelection)this._acc_selection.get();
        if (accessibleSelection == null) {
            return false;
        }
        return AtkUtil.invokeInSwing(() -> {
            accessibleSelection.addAccessibleSelection(n);
            return this.is_child_selected(n);
        }, false);
    }

    public boolean clear_selection() {
        AccessibleSelection accessibleSelection = (AccessibleSelection)this._acc_selection.get();
        if (accessibleSelection == null) {
            return false;
        }
        AtkUtil.invokeInSwing(() -> accessibleSelection.clearAccessibleSelection());
        return true;
    }

    public AccessibleContext ref_selection(int n) {
        AccessibleSelection accessibleSelection = (AccessibleSelection)this._acc_selection.get();
        if (accessibleSelection == null) {
            return null;
        }
        return AtkUtil.invokeInSwing(() -> {
            Accessible accessible = accessibleSelection.getAccessibleSelection(n);
            if (accessible == null) {
                return null;
            }
            return accessible.getAccessibleContext();
        }, null);
    }

    public int get_selection_count() {
        AccessibleContext accessibleContext = (AccessibleContext)this._ac.get();
        if (accessibleContext == null) {
            return 0;
        }
        AccessibleSelection accessibleSelection = (AccessibleSelection)this._acc_selection.get();
        if (accessibleSelection == null) {
            return 0;
        }
        return AtkUtil.invokeInSwing(() -> {
            int n = 0;
            for (int i = 0; i < accessibleContext.getAccessibleChildrenCount(); ++i) {
                if (!accessibleSelection.isAccessibleChildSelected(i)) continue;
                ++n;
            }
            return n;
        }, 0);
    }

    public boolean is_child_selected(int n) {
        AccessibleSelection accessibleSelection = (AccessibleSelection)this._acc_selection.get();
        if (accessibleSelection == null) {
            return false;
        }
        return AtkUtil.invokeInSwing(() -> accessibleSelection.isAccessibleChildSelected(n), false);
    }

    public boolean remove_selection(int n) {
        AccessibleSelection accessibleSelection = (AccessibleSelection)this._acc_selection.get();
        if (accessibleSelection == null) {
            return false;
        }
        return AtkUtil.invokeInSwing(() -> {
            accessibleSelection.removeAccessibleSelection(n);
            return !this.is_child_selected(n);
        }, false);
    }

    public boolean select_all_selection() {
        AccessibleContext accessibleContext = (AccessibleContext)this._ac.get();
        if (accessibleContext == null) {
            return false;
        }
        AccessibleSelection accessibleSelection = (AccessibleSelection)this._acc_selection.get();
        if (accessibleSelection == null) {
            return false;
        }
        AccessibleStateSet accessibleStateSet = accessibleContext.getAccessibleStateSet();
        return AtkUtil.invokeInSwing(() -> {
            if (accessibleStateSet.contains(AccessibleState.MULTISELECTABLE)) {
                accessibleSelection.selectAllAccessibleSelection();
                return true;
            }
            return false;
        }, false);
    }
}

