/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.dlic.auth.http.jwt;

import com.nimbusds.jwt.proc.BadJWTException;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.JwtParser;
import io.jsonwebtoken.JwtParserBuilder;
import io.jsonwebtoken.security.WeakKeyException;
import java.nio.file.Path;
import java.security.AccessController;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.OpenSearchSecurityException;
import org.opensearch.SpecialPermission;
import org.opensearch.common.logging.DeprecationLogger;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.security.auth.HTTPAuthenticator;
import org.opensearch.security.filter.SecurityRequest;
import org.opensearch.security.filter.SecurityResponse;
import org.opensearch.security.user.AuthCredentials;
import org.opensearch.security.util.KeyUtils;

public class HTTPJwtAuthenticator
implements HTTPAuthenticator {
    protected final Logger log = LogManager.getLogger(this.getClass());
    protected final DeprecationLogger deprecationLog = DeprecationLogger.getLogger(this.getClass());
    private static final Pattern BASIC = Pattern.compile("^\\s*Basic\\s.*", 2);
    private static final String BEARER = "bearer ";
    private final List<JwtParser> jwtParsers = new ArrayList<JwtParser>();
    private final String jwtHeaderName;
    private final boolean isDefaultAuthHeader;
    private final String jwtUrlParameter;
    private final String rolesKey;
    private final String subjectKey;
    private final List<String> requiredAudience;
    private final String requireIssuer;

    public HTTPJwtAuthenticator(Settings settings, Path configPath) {
        List signingKeys = settings.getAsList("signing_key");
        this.jwtUrlParameter = settings.get("jwt_url_parameter");
        this.jwtHeaderName = settings.get("jwt_header", "Authorization");
        this.isDefaultAuthHeader = "Authorization".equalsIgnoreCase(this.jwtHeaderName);
        this.rolesKey = settings.get("roles_key");
        this.subjectKey = settings.get("subject_key");
        this.requiredAudience = settings.getAsList("required_audience");
        this.requireIssuer = settings.get("required_issuer");
        if (!this.jwtHeaderName.equals("Authorization")) {
            this.deprecationLog.deprecate("jwt_header", "The 'jwt_header' setting will be removed in the next major version of OpenSearch.  Consult https://github.com/opensearch-project/security/issues/3886 for more details.", new Object[0]);
        }
        for (String key : signingKeys) {
            JwtParser jwtParser;
            JwtParserBuilder jwtParserBuilder = KeyUtils.createJwtParserBuilderFromSigningKey(key, this.log);
            if (jwtParserBuilder == null) {
                jwtParser = null;
            } else {
                SecurityManager sm;
                if (this.requireIssuer != null) {
                    jwtParserBuilder.requireIssuer(this.requireIssuer);
                }
                if ((sm = System.getSecurityManager()) != null) {
                    sm.checkPermission((Permission)new SpecialPermission());
                }
                jwtParser = AccessController.doPrivileged(() -> ((JwtParserBuilder)jwtParserBuilder).build());
            }
            this.jwtParsers.add(jwtParser);
        }
    }

    @Override
    public AuthCredentials extractCredentials(final SecurityRequest request, ThreadContext context) throws OpenSearchSecurityException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission((Permission)new SpecialPermission());
        }
        AuthCredentials creds = AccessController.doPrivileged(new PrivilegedAction<AuthCredentials>(){

            @Override
            public AuthCredentials run() {
                return HTTPJwtAuthenticator.this.extractCredentials0(request);
            }
        });
        return creds;
    }

    private AuthCredentials extractCredentials0(SecurityRequest request) {
        if (this.jwtParsers.isEmpty() || this.jwtParsers.get(0) == null) {
            this.log.error("Missing Signing Key. JWT authentication will not work");
            return null;
        }
        String jwtToken = request.header(this.jwtHeaderName);
        if (this.isDefaultAuthHeader && jwtToken != null && BASIC.matcher(jwtToken).matches()) {
            jwtToken = null;
        }
        if ((jwtToken == null || jwtToken.isEmpty()) && this.jwtUrlParameter != null) {
            jwtToken = request.params().get(this.jwtUrlParameter);
        } else {
            request.params().get(this.jwtUrlParameter);
        }
        if (jwtToken == null || jwtToken.length() == 0) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("No JWT token found in '{}' {} header", (Object)(this.jwtUrlParameter == null ? this.jwtHeaderName : this.jwtUrlParameter), (Object)(this.jwtUrlParameter == null ? "header" : "url parameter"));
            }
            return null;
        }
        int index = jwtToken.toLowerCase().indexOf(BEARER);
        if (index > -1) {
            jwtToken = jwtToken.substring(index + BEARER.length());
        } else if (this.log.isDebugEnabled()) {
            this.log.debug("No Bearer scheme found in header");
        }
        for (JwtParser jwtParser : this.jwtParsers) {
            try {
                String subject;
                Claims claims = (Claims)jwtParser.parseClaimsJws((CharSequence)jwtToken).getBody();
                if (!this.requiredAudience.isEmpty()) {
                    this.assertValidAudienceClaim(claims);
                }
                if ((subject = this.extractSubject(claims, request)) == null) {
                    this.log.error("No subject found in JWT token");
                    return null;
                }
                String[] roles = this.extractRoles(claims, request);
                AuthCredentials ac = new AuthCredentials(subject, roles).markComplete();
                for (Map.Entry claim : claims.entrySet()) {
                    ac.addAttribute("attr.jwt." + (String)claim.getKey(), String.valueOf(claim.getValue()));
                }
                return ac;
            }
            catch (WeakKeyException e) {
                this.log.error("Cannot authenticate user with JWT because of ", (Throwable)e);
                return null;
            }
            catch (Exception e) {
                if (!this.log.isDebugEnabled()) continue;
                this.log.debug("Invalid or expired JWT token.", (Throwable)e);
            }
        }
        this.log.error("Failed to parse JWT token using any of the available parsers");
        return null;
    }

    private void assertValidAudienceClaim(Claims claims) throws BadJWTException {
        if (this.requiredAudience.isEmpty()) {
            return;
        }
        if (Collections.disjoint(claims.getAudience(), this.requiredAudience)) {
            throw new BadJWTException("Claim of 'aud' doesn't contain any required audience.");
        }
    }

    @Override
    public Optional<SecurityResponse> reRequestAuthentication(SecurityRequest channel, AuthCredentials creds) {
        return Optional.of(new SecurityResponse(401, Map.of("WWW-Authenticate", "Bearer realm=\"OpenSearch Security\""), ""));
    }

    @Override
    public Set<String> getSensitiveUrlParams() {
        if (this.jwtUrlParameter != null) {
            return Set.of(this.jwtUrlParameter);
        }
        return Collections.emptySet();
    }

    @Override
    public String getType() {
        return "jwt";
    }

    protected String extractSubject(Claims claims, SecurityRequest request) {
        String subject = claims.getSubject();
        if (this.subjectKey != null) {
            Object subjectObject = claims.get(this.subjectKey, Object.class);
            if (subjectObject == null) {
                this.log.warn("Failed to get subject from JWT claims, check if subject_key '{}' is correct.", (Object)this.subjectKey);
                return null;
            }
            if (!(subjectObject instanceof String)) {
                this.log.warn("Expected type String for roles in the JWT for subject_key {}, but value was '{}' ({}). Will convert this value to String.", (Object)this.subjectKey, subjectObject, subjectObject.getClass());
            }
            subject = String.valueOf(subjectObject);
        }
        return subject;
    }

    protected String[] extractRoles(Claims claims, SecurityRequest request) {
        if (this.rolesKey == null) {
            return new String[0];
        }
        Object rolesObject = claims.get(this.rolesKey, Object.class);
        if (rolesObject == null) {
            this.log.warn("Failed to get roles from JWT claims with roles_key '{}'. Check if this key is correct and available in the JWT payload.", (Object)this.rolesKey);
            return new String[0];
        }
        String[] roles = String.valueOf(rolesObject).split(",");
        if (!(rolesObject instanceof String) && !(rolesObject instanceof Collection)) {
            this.log.warn("Expected type String or Collection for roles in the JWT for roles_key {}, but value was '{}' ({}). Will convert this value to String.", (Object)this.rolesKey, rolesObject, rolesObject.getClass());
        } else if (rolesObject instanceof Collection) {
            roles = ((Collection)rolesObject).toArray(new String[0]);
        }
        for (int i = 0; i < roles.length; ++i) {
            roles[i] = roles[i].trim();
        }
        return roles;
    }

    private static PublicKey getPublicKey(byte[] keyBytes, String algo) throws NoSuchAlgorithmException, InvalidKeySpecException {
        X509EncodedKeySpec spec = new X509EncodedKeySpec(keyBytes);
        KeyFactory kf = KeyFactory.getInstance(algo);
        return kf.generatePublic(spec);
    }
}

