/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.icon.mindmapmode;

import java.awt.event.ActionEvent;
import java.net.URL;
import javax.swing.Icon;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.ui.AMultipleNodeAction;
import org.freeplane.core.ui.menubuilders.generic.UserRoleConstraint;
import org.freeplane.core.ui.svgicons.FixedSizeUIIcon;
import org.freeplane.features.icon.IconController;
import org.freeplane.features.icon.IconDescription;
import org.freeplane.features.icon.MindIcon;
import org.freeplane.features.icon.NamedIcon;
import org.freeplane.features.icon.UIIcon;
import org.freeplane.features.icon.factory.IconFactory;
import org.freeplane.features.icon.factory.IconStoreFactory;
import org.freeplane.features.icon.mindmapmode.MIconController;
import org.freeplane.features.map.NodeModel;

public class IconAction
extends AMultipleNodeAction
implements IconDescription {
    private static final long serialVersionUID = 1L;
    public static final String ICON_ACTION_REMOVES_ICON_IF_EXISTS_PROPERTY = "iconActionRemovesIconIfExists";
    private static boolean removesIconsIfExists;
    private final MindIcon mindIcon;

    public IconAction(MindIcon mindIcon) {
        super("IconAction." + mindIcon.getName(), mindIcon.getTranslatedDescription(), null);
        this.mindIcon = mindIcon;
        this.setIcon((Icon)FixedSizeUIIcon.withHeigth((URL)mindIcon.getUrl(), (int)IconFactory.DEFAULT_UI_ICON_HEIGTH.toBaseUnitsRounded(), (boolean)mindIcon.hasStandardSize()));
        this.putValue("ShortDescription", this.getTranslatedDescription());
        this.addConstraint(UserRoleConstraint.EDITOR);
    }

    public void actionPerformed(ActionEvent e) {
        removesIconsIfExists = ResourceController.getResourceController().getBooleanProperty(ICON_ACTION_REMOVES_ICON_IF_EXISTS_PROPERTY);
        super.actionPerformed(e);
    }

    public void actionPerformed(ActionEvent e, NodeModel node) {
        MIconController iconController = (MIconController)IconController.getController();
        if (!removesIconsIfExists || !iconController.removeIcon(node, (NamedIcon)this.mindIcon)) {
            iconController.addIconByUserAction(node, this);
        }
    }

    public String getDescriptionTranslationKey() {
        return this.mindIcon.getDescriptionTranslationKey();
    }

    public String getTextKey() {
        return this.getDescriptionTranslationKey();
    }

    public String getTranslatedDescription() {
        return this.mindIcon.getTranslatedDescription();
    }

    public String getFile() {
        return this.mindIcon.getFile();
    }

    public Icon getIcon() {
        return IconFactory.getInstance().getIcon((UIIcon)this.getMindIcon());
    }

    public Icon getActionIcon() {
        return (Icon)this.getValue("SmallIcon");
    }

    public MindIcon getMindIcon() {
        return IconStoreFactory.ICON_STORE.getMindIcon(this.mindIcon.getName());
    }

    public String getShortcutKey() {
        return this.mindIcon.getShortcutKey();
    }
}

