/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.security.utils;

import com.sun.org.apache.xml.internal.security.exceptions.XMLSecurityException;
import com.sun.org.apache.xml.internal.security.utils.HelperNodeList;
import com.sun.org.apache.xml.internal.security.utils.JavaUtils;
import com.sun.org.apache.xml.internal.security.utils.XMLUtils;
import com.sun.org.slf4j.internal.Logger;
import com.sun.org.slf4j.internal.LoggerFactory;
import java.math.BigInteger;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public abstract class ElementProxy {
    protected static final Logger LOG = LoggerFactory.getLogger(ElementProxy.class);
    private Element wrappedElement;
    protected String baseURI;
    private Document wrappedDoc;
    private static Map<String, String> prefixMappings = new ConcurrentHashMap<String, String>();

    public ElementProxy() {
    }

    public ElementProxy(Document document) {
        if (document == null) {
            throw new RuntimeException("Document is null");
        }
        this.wrappedDoc = document;
        this.wrappedElement = this.createElementForFamilyLocal(this.getBaseNamespace(), this.getBaseLocalName());
    }

    public ElementProxy(Element element, String string) throws XMLSecurityException {
        if (element == null) {
            throw new XMLSecurityException("ElementProxy.nullElement");
        }
        LOG.debug("setElement(\"{}\", \"{}\")", element.getTagName(), string);
        this.setElement(element);
        this.baseURI = string;
        this.guaranteeThatElementInCorrectSpace();
    }

    public abstract String getBaseNamespace();

    public abstract String getBaseLocalName();

    protected Element createElementForFamilyLocal(String string, String string2) {
        Document document = this.getDocument();
        Element element = null;
        if (string == null) {
            element = document.createElementNS(null, string2);
        } else {
            String string3 = this.getBaseNamespace();
            String string4 = ElementProxy.getDefaultPrefix(string3);
            if (string4 == null || string4.length() == 0) {
                element = document.createElementNS(string, string2);
                element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", string);
            } else {
                element = document.createElementNS(string, string4 + ":" + string2);
                element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + string4, string);
            }
        }
        return element;
    }

    public static Element createElementForFamily(Document document, String string, String string2) {
        Element element = null;
        String string3 = ElementProxy.getDefaultPrefix(string);
        if (string == null) {
            element = document.createElementNS(null, string2);
        } else if (string3 == null || string3.length() == 0) {
            element = document.createElementNS(string, string2);
            element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", string);
        } else {
            element = document.createElementNS(string, string3 + ":" + string2);
            element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + string3, string);
        }
        return element;
    }

    public void setElement(Element element, String string) throws XMLSecurityException {
        if (element == null) {
            throw new XMLSecurityException("ElementProxy.nullElement");
        }
        LOG.debug("setElement({}, \"{}\")", element.getTagName(), string);
        this.setElement(element);
        this.baseURI = string;
    }

    public final Element getElement() {
        return this.wrappedElement;
    }

    public final NodeList getElementPlusReturns() {
        HelperNodeList helperNodeList = new HelperNodeList();
        helperNodeList.appendChild(this.createText("\n"));
        helperNodeList.appendChild(this.getElement());
        helperNodeList.appendChild(this.createText("\n"));
        return helperNodeList;
    }

    protected Text createText(String string) {
        return this.wrappedDoc.createTextNode(string);
    }

    public Document getDocument() {
        if (this.wrappedDoc == null) {
            this.wrappedDoc = XMLUtils.getOwnerDocument(this.wrappedElement);
        }
        return this.wrappedDoc;
    }

    public String getBaseURI() {
        return this.baseURI;
    }

    void guaranteeThatElementInCorrectSpace() throws XMLSecurityException {
        String string = this.getBaseLocalName();
        String string2 = this.getBaseNamespace();
        String string3 = this.getElement().getLocalName();
        String string4 = this.getElement().getNamespaceURI();
        if (!string2.equals(string4) && !string.equals(string3)) {
            Object[] objectArray = new Object[]{string4 + ":" + string3, string2 + ":" + string};
            throw new XMLSecurityException("xml.WrongElement", objectArray);
        }
    }

    public void addBigIntegerElement(BigInteger bigInteger, String string) {
        if (bigInteger != null) {
            Element element = XMLUtils.createElementInSignatureSpace(this.getDocument(), string);
            byte[] byArray = XMLUtils.getBytes(bigInteger, bigInteger.bitLength());
            String string2 = XMLUtils.encodeToString(byArray);
            Document document = element.getOwnerDocument();
            Text text = document.createTextNode(string2);
            element.appendChild(text);
            this.appendSelf(element);
            this.addReturnToSelf();
        }
    }

    protected void addReturnToSelf() {
        XMLUtils.addReturnToElement(this.getElement());
    }

    public void addBase64Element(byte[] byArray, String string) {
        if (byArray != null) {
            Element element = XMLUtils.createElementInSignatureSpace(this.getDocument(), string);
            Text text = this.getDocument().createTextNode(XMLUtils.encodeToString(byArray));
            element.appendChild(text);
            this.appendSelf(element);
            if (!XMLUtils.ignoreLineBreaks()) {
                this.appendSelf(this.createText("\n"));
            }
        }
    }

    public void addTextElement(String string, String string2) {
        Element element = XMLUtils.createElementInSignatureSpace(this.getDocument(), string2);
        Text text = this.createText(string);
        this.appendOther(element, text);
        this.appendSelf(element);
        this.addReturnToSelf();
    }

    public void addBase64Text(byte[] byArray) {
        if (byArray != null) {
            Text text = XMLUtils.ignoreLineBreaks() ? this.createText(XMLUtils.encodeToString(byArray)) : this.createText("\n" + XMLUtils.encodeToString(byArray) + "\n");
            this.appendSelf(text);
        }
    }

    protected void appendSelf(ElementProxy elementProxy) {
        this.getElement().appendChild(elementProxy.getElement());
    }

    protected void appendSelf(Node node) {
        this.getElement().appendChild(node);
    }

    protected void appendOther(Element element, Node node) {
        element.appendChild(node);
    }

    public void addText(String string) {
        if (string != null) {
            Text text = this.createText(string);
            this.appendSelf(text);
        }
    }

    public BigInteger getBigIntegerFromChildElement(String string, String string2) {
        Element element = XMLUtils.selectNode(this.getFirstChild(), string2, string, 0);
        if (element != null) {
            return new BigInteger(1, XMLUtils.decode(XMLUtils.getFullTextChildrenFromNode(element)));
        }
        return null;
    }

    public String getTextFromChildElement(String string, String string2) {
        return XMLUtils.selectNode(this.getFirstChild(), string2, string, 0).getTextContent();
    }

    public byte[] getBytesFromTextChild() throws XMLSecurityException {
        return XMLUtils.decode(this.getTextFromTextChild());
    }

    public String getTextFromTextChild() {
        return XMLUtils.getFullTextChildrenFromNode(this.getElement());
    }

    public int length(String string, String string2) {
        int n = 0;
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (!string2.equals(node.getLocalName()) || !string.equals(node.getNamespaceURI())) continue;
            ++n;
        }
        return n;
    }

    public void setXPathNamespaceContext(String string, String string2) throws XMLSecurityException {
        if (string == null || string.length() == 0) {
            throw new XMLSecurityException("defaultNamespaceCannotBeSetHere");
        }
        if ("xmlns".equals(string)) {
            throw new XMLSecurityException("defaultNamespaceCannotBeSetHere");
        }
        String string3 = string.startsWith("xmlns:") ? string : "xmlns:" + string;
        Attr attr = this.getElement().getAttributeNodeNS("http://www.w3.org/2000/xmlns/", string3);
        if (attr != null) {
            if (!attr.getNodeValue().equals(string2)) {
                Object[] objectArray = new Object[]{string3, this.getElement().getAttributeNS(null, string3)};
                throw new XMLSecurityException("namespacePrefixAlreadyUsedByOtherURI", objectArray);
            }
            return;
        }
        this.getElement().setAttributeNS("http://www.w3.org/2000/xmlns/", string3, string2);
    }

    public static void setDefaultPrefix(String string, String string2) throws XMLSecurityException {
        JavaUtils.checkRegisterPermission();
        ElementProxy.setNamespacePrefix(string, string2);
    }

    private static void setNamespacePrefix(String string, String string2) throws XMLSecurityException {
        String string3;
        if (prefixMappings.containsValue(string2) && !(string3 = prefixMappings.get(string)).equals(string2)) {
            Object[] objectArray = new Object[]{string2, string, string3};
            throw new XMLSecurityException("prefix.AlreadyAssigned", objectArray);
        }
        if ("http://www.w3.org/2000/09/xmldsig#".equals(string)) {
            XMLUtils.setDsPrefix(string2);
        } else if ("http://www.w3.org/2009/xmldsig11#".equals(string)) {
            XMLUtils.setDs11Prefix(string2);
        } else if ("http://www.w3.org/2001/04/xmlenc#".equals(string)) {
            XMLUtils.setXencPrefix(string2);
        }
        prefixMappings.put(string, string2);
    }

    public static void registerDefaultPrefixes() throws XMLSecurityException {
        ElementProxy.setNamespacePrefix("http://www.w3.org/2000/09/xmldsig#", "ds");
        ElementProxy.setNamespacePrefix("http://www.w3.org/2001/04/xmlenc#", "xenc");
        ElementProxy.setNamespacePrefix("http://www.w3.org/2009/xmlenc11#", "xenc11");
        ElementProxy.setNamespacePrefix("http://www.xmlsecurity.org/experimental#", "experimental");
        ElementProxy.setNamespacePrefix("http://www.w3.org/2002/04/xmldsig-filter2", "dsig-xpath-old");
        ElementProxy.setNamespacePrefix("http://www.w3.org/2002/06/xmldsig-filter2", "dsig-xpath");
        ElementProxy.setNamespacePrefix("http://www.w3.org/2001/10/xml-exc-c14n#", "ec");
        ElementProxy.setNamespacePrefix("http://www.nue.et-inf.uni-siegen.de/~geuer-pollmann/#xpathFilter", "xx");
        ElementProxy.setNamespacePrefix("http://www.w3.org/2009/xmldsig11#", "dsig11");
    }

    public static String getDefaultPrefix(String string) {
        return prefixMappings.get(string);
    }

    protected void setElement(Element element) {
        this.wrappedElement = element;
    }

    protected void setDocument(Document document) {
        this.wrappedDoc = document;
    }

    protected String getLocalAttribute(String string) {
        return this.getElement().getAttributeNS(null, string);
    }

    protected void setLocalAttribute(String string, String string2) {
        this.getElement().setAttributeNS(null, string, string2);
    }

    protected void setLocalIdAttribute(String string, String string2) {
        if (string2 != null) {
            Attr attr = this.getDocument().createAttributeNS(null, string);
            attr.setValue(string2);
            this.getElement().setAttributeNodeNS(attr);
            this.getElement().setIdAttributeNode(attr, true);
        } else {
            this.getElement().removeAttributeNS(null, string);
        }
    }

    protected Node getFirstChild() {
        return this.getElement().getFirstChild();
    }
}

