/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.filters;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.filters.FilterBase;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.http.Parameters;

public class FailedRequestFilter
extends FilterBase {
    private final Log log = LogFactory.getLog(FailedRequestFilter.class);

    @Override
    protected Log getLogger() {
        return this.log;
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        if (!this.isGoodRequest(servletRequest)) {
            int n;
            Parameters.FailReason failReason = (Parameters.FailReason)servletRequest.getAttribute("org.apache.catalina.parameter_parse_failed_reason");
            switch (failReason) {
                case IO_ERROR: {
                    n = 500;
                    break;
                }
                case POST_TOO_LARGE: {
                    n = 413;
                    break;
                }
                default: {
                    n = 400;
                }
            }
            ((HttpServletResponse)servletResponse).sendError(n);
            return;
        }
        filterChain.doFilter(servletRequest, servletResponse);
    }

    private boolean isGoodRequest(ServletRequest servletRequest) {
        servletRequest.getParameter("none");
        return servletRequest.getAttribute("org.apache.catalina.parameter_parse_failed") == null;
    }

    @Override
    protected boolean isConfigProblemFatal() {
        return true;
    }
}

