/*
 * Decompiled with CFR 0.152.
 */
package org.openide.explorer.view;

import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.util.Arrays;
import java.util.EventObject;
import java.util.Properties;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.netbeans.swing.etable.ETable;
import org.netbeans.swing.etable.ETableColumn;
import org.netbeans.swing.etable.TableColumnSelector;
import org.openide.awt.Mnemonics;
import org.openide.awt.MouseUtils;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.NodePopupFactory;
import org.openide.explorer.view.NodeTableModel;
import org.openide.explorer.view.PropertiesRowModel;
import org.openide.explorer.view.SheetCell;
import org.openide.explorer.view.TableViewDragSupport;
import org.openide.explorer.view.TableViewDropSupport;
import org.openide.explorer.view.Visualizer;
import org.openide.explorer.view.VisualizerNode;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.WeakListeners;

public class TableView
extends JScrollPane {
    private ETable table = new TableViewETable();
    private ExplorerManager manager;
    transient PopupAdapter popupListener;
    transient TableSelectionListener managerListener = null;
    transient PropertyChangeListener wlpc;
    transient VetoableChangeListener wlvc;
    private NodePopupFactory popupFactory;
    private transient boolean dragActive = true;
    private transient boolean dropActive = true;
    transient TableViewDragSupport dragSupport;
    transient TableViewDropSupport dropSupport;
    transient boolean dropTargetPopupAllowed = true;
    private transient int allowedDragActions = 0x40000003;
    private transient int allowedDropActions = 0x40000003;

    public TableView() {
        this(new NodeTableModel());
    }

    public TableView(NodeTableModel nodeTableModel) {
        this.table.setModel((TableModel)nodeTableModel);
        SheetCell.TableSheetCell tableSheetCell = new SheetCell.TableSheetCell(nodeTableModel, this.table);
        this.table.setDefaultRenderer(Node.Property.class, (TableCellRenderer)tableSheetCell);
        this.table.setDefaultEditor(Node.Property.class, (TableCellEditor)tableSheetCell);
        this.setViewportView((Component)this.table);
        this.setPopupAllowed(true);
        this.setRequestFocusEnabled(false);
        this.table.setRequestFocusEnabled(true);
        this.getActionMap().put("org.openide.actions.PopupAction", new PopupAction());
        this.popupFactory = new NodePopupFactory();
        Color color = UIManager.getColor("Table.background1");
        if (color == null) {
            color = UIManager.getColor("Table.background");
        }
        if (color != null) {
            this.getViewport().setBackground(color);
        }
        this.setDragSource(true);
        this.setDropTarget(true);
        TableColumnSelector tableColumnSelector = (TableColumnSelector)Lookup.getDefault().lookup(TableColumnSelector.class);
        if (tableColumnSelector != null) {
            this.table.setColumnSelector(tableColumnSelector);
        }
    }

    @Override
    public void requestFocus() {
        this.table.requestFocus();
    }

    @Override
    public boolean requestFocusInWindow() {
        return this.table.requestFocusInWindow();
    }

    public ETable getTable() {
        return this.table;
    }

    public boolean isPopupAllowed() {
        return this.popupListener != null;
    }

    public void setPopupAllowed(boolean bl) {
        if (this.popupListener == null && bl) {
            this.popupListener = new PopupAdapter();
            this.table.addMouseListener((MouseListener)((Object)this.popupListener));
            this.addMouseListener((MouseListener)((Object)this.popupListener));
            return;
        }
        if (this.popupListener != null && !bl) {
            this.table.removeMouseListener((MouseListener)((Object)this.popupListener));
            this.removeMouseListener((MouseListener)((Object)this.popupListener));
            this.popupListener = null;
            return;
        }
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.lookupExplorerManager();
    }

    public void readSettings(Properties properties, String string) {
        this.table.readSettings(properties, string);
    }

    public void writeSettings(Properties properties, String string) {
        this.table.writeSettings(properties, string);
    }

    public void setNodePopupFactory(NodePopupFactory nodePopupFactory) {
        this.popupFactory = nodePopupFactory;
    }

    public NodePopupFactory getNodePopupFactory() {
        return this.popupFactory;
    }

    private void lookupExplorerManager() {
        ExplorerManager explorerManager;
        if (this.managerListener == null) {
            this.managerListener = new TableSelectionListener();
        }
        if ((explorerManager = ExplorerManager.find(this)) != this.manager) {
            if (this.manager != null) {
                this.manager.removeVetoableChangeListener(this.wlvc);
                this.manager.removePropertyChangeListener(this.wlpc);
            }
            this.manager = explorerManager;
            this.wlvc = WeakListeners.vetoableChange((VetoableChangeListener)this.managerListener, (Object)this.manager);
            this.manager.addVetoableChangeListener(this.wlvc);
            this.wlpc = WeakListeners.propertyChange((PropertyChangeListener)this.managerListener, (Object)this.manager);
            this.manager.addPropertyChangeListener(this.wlpc);
            this.synchronizeRootContext();
            this.synchronizeSelectedNodes();
        }
        this.table.getSelectionModel().removeListSelectionListener(this.managerListener);
        this.table.getSelectionModel().addListSelectionListener(this.managerListener);
    }

    final void synchronizeRootContext() {
        NodeTableModel nodeTableModel = (NodeTableModel)this.table.getModel();
        nodeTableModel.setNodes(this.manager.getRootContext().getChildren().getNodes());
    }

    final void synchronizeSelectedNodes() {
        Node[] nodeArray = this.manager.getSelectedNodes();
        this.table.getSelectionModel().clearSelection();
        NodeTableModel nodeTableModel = (NodeTableModel)this.table.getModel();
        int n = nodeTableModel.getRowCount();
        int n2 = -1;
        for (int i = 0; i < n; ++i) {
            Node node = this.getNodeFromRow(i);
            for (int j = 0; j < nodeArray.length; ++j) {
                if (!node.equals((Object)nodeArray[j])) continue;
                this.table.getSelectionModel().addSelectionInterval(i, i);
                if (n2 != -1) continue;
                n2 = i;
            }
        }
        if (n2 >= 0) {
            Rectangle rectangle = this.table.getCellRect(n2, 0, true);
            if (!this.getViewport().getViewRect().contains(rectangle.getLocation())) {
                rectangle.height = Math.max(rectangle.height, this.getHeight() - 30);
                this.table.scrollRectToVisible(rectangle);
            }
        }
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        this.table.getSelectionModel().removeListSelectionListener(this.managerListener);
    }

    private void showPopup(int n, int n2, final JPopupMenu jPopupMenu) {
        if (jPopupMenu != null && jPopupMenu.getSubElements().length > 0) {
            PopupMenuListener popupMenuListener = new PopupMenuListener(){

                @Override
                public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
                }

                @Override
                public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
                    jPopupMenu.removePopupMenuListener(this);
                    TableView.this.table.requestFocus();
                }

                @Override
                public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
                }
            };
            jPopupMenu.addPopupMenuListener(popupMenuListener);
            jPopupMenu.show(this, n, n2);
        }
    }

    private JPopupMenu createPopup(Point point) {
        int n;
        int[] nArray = this.table.getSelectedRows();
        Node[] nodeArray = new Node[nArray.length];
        for (n = 0; n < nArray.length; ++n) {
            nodeArray[n] = this.getNodeFromRow(nArray[n]);
        }
        if (nodeArray.length == 0) {
            nodeArray = new Node[]{this.manager.getRootContext()};
        }
        point = SwingUtilities.convertPoint(this, point, (Component)this.table);
        n = this.table.columnAtPoint(point);
        int n2 = this.table.rowAtPoint(point);
        return this.popupFactory.createPopupMenu(n2, n, nodeArray, (Component)this.table);
    }

    Node getNodeFromRow(int n) {
        int n2 = this.table.convertRowIndexToModel(n);
        TableModel tableModel = this.table.getModel();
        if (tableModel instanceof NodeTableModel) {
            NodeTableModel nodeTableModel = (NodeTableModel)tableModel;
            return nodeTableModel.nodeForRow(n2);
        }
        return null;
    }

    private Point getPositionForPopup() {
        Rectangle rectangle;
        int n = this.table.getSelectionModel().getLeadSelectionIndex();
        if (n < 0) {
            return null;
        }
        int n2 = this.table.getColumnModel().getSelectionModel().getLeadSelectionIndex();
        if (n2 < 0) {
            n2 = 0;
        }
        if ((rectangle = this.table.getCellRect(n, n2, true)) == null) {
            return null;
        }
        Point point = new Point(rectangle.x + rectangle.width / 3, rectangle.y + rectangle.height / 2);
        point = SwingUtilities.convertPoint((Component)this.table, point, this);
        return point;
    }

    final void callSelectionChanged(Node[] nodeArray) {
        this.manager.removePropertyChangeListener(this.wlpc);
        this.manager.removeVetoableChangeListener(this.wlvc);
        try {
            this.manager.setSelectedNodes(nodeArray);
        }
        catch (PropertyVetoException propertyVetoException) {
            this.synchronizeSelectedNodes();
        }
        finally {
            this.manager.addPropertyChangeListener(this.wlpc);
            this.manager.addVetoableChangeListener(this.wlvc);
        }
    }

    private boolean isSelectionModeBroken(Node[] nodeArray) {
        if (nodeArray.length <= 1 || this.table.getSelectionModel().getSelectionMode() == 2) {
            return false;
        }
        return this.table.getSelectionModel().getSelectionMode() == 0;
    }

    public boolean isDragSource() {
        return this.dragActive;
    }

    public void setDragSource(boolean bl) {
        if (bl && this.dragSupport == null) {
            this.dragSupport = new TableViewDragSupport(this, (JTable)this.table);
        }
        this.dragActive = bl;
        if (this.dragSupport != null) {
            this.dragSupport.activate(this.dragActive);
        }
    }

    public boolean isDropTarget() {
        return this.dropActive;
    }

    public void setDropTarget(boolean bl) {
        if (this.dropActive && this.dropSupport == null) {
            this.dropSupport = new TableViewDropSupport(this, (JTable)this.table, this.dropTargetPopupAllowed);
        }
        this.dropActive = bl;
        if (this.dropSupport != null) {
            this.dropSupport.activate(this.dropActive);
        }
    }

    public int getAllowedDragActions() {
        return this.allowedDragActions;
    }

    public void setAllowedDragActions(int n) {
        this.allowedDragActions = n;
    }

    public int getAllowedDropActions() {
        return this.allowedDropActions;
    }

    public void setAllowedDropActions(int n) {
        this.allowedDropActions = n;
    }

    private static class TableViewETable
    extends ETable {
        protected TableColumn createColumn(int n) {
            return new TableViewETableColumn(n);
        }

        public Object transformValue(Object object) {
            if (object instanceof ETableColumn) {
                ETableColumn eTableColumn = (ETableColumn)object;
                return eTableColumn.getHeaderValue().toString();
            }
            if (object instanceof AbstractButton) {
                AbstractButton abstractButton = (AbstractButton)object;
                Mnemonics.setLocalizedText((AbstractButton)abstractButton, (String)abstractButton.getText());
                return abstractButton;
            }
            if (object instanceof VisualizerNode) {
                return Visualizer.findNode(object);
            }
            return PropertiesRowModel.getValueFromProperty(object);
        }

        public boolean editCellAt(int n, int n2, EventObject eventObject) {
            Object object = this.getValueAt(n, n2);
            if (object instanceof Node.Property) {
                Node.Property property = (Node.Property)object;
                if (!property.canWrite()) {
                    return false;
                }
                if (property.getValueType() == Boolean.class || property.getValueType() == Boolean.TYPE) {
                    PropertiesRowModel.toggleBooleanProperty((Node.Property<Boolean>)property);
                    Rectangle rectangle = this.getCellRect(n, n2, true);
                    this.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                    return false;
                }
            }
            return super.editCellAt(n, n2, eventObject);
        }

        private class TableViewETableColumn
        extends ETableColumn {
            private String tooltip;

            public TableViewETableColumn(int n) {
                super(n, (ETable)TableViewETable.this);
            }

            public boolean isSortingAllowed() {
                TableModel tableModel = TableViewETable.this.getModel();
                if (tableModel instanceof NodeTableModel) {
                    NodeTableModel nodeTableModel = (NodeTableModel)tableModel;
                    return nodeTableModel.isComparableColumn(this.getModelIndex());
                }
                return true;
            }

            final String getShortDescription(String string) {
                TableModel tableModel = TableViewETable.this.getModel();
                if (tableModel.getRowCount() <= 0) {
                    return null;
                }
                if (0 == this.getModelIndex()) {
                    return string;
                }
                if (tableModel instanceof NodeTableModel) {
                    NodeTableModel nodeTableModel = (NodeTableModel)tableModel;
                    Node.Property property = nodeTableModel.propertyForColumn(this.getModelIndex());
                    return property.getShortDescription();
                }
                return string;
            }

            protected TableCellRenderer createDefaultHeaderRenderer() {
                TableCellRenderer tableCellRenderer = super.createDefaultHeaderRenderer();
                TableViewHeaderRenderer tableViewHeaderRenderer = new TableViewHeaderRenderer(tableCellRenderer);
                return tableViewHeaderRenderer;
            }

            class TableViewHeaderRenderer
            implements TableCellRenderer {
                private TableCellRenderer orig;

                public TableViewHeaderRenderer(TableCellRenderer tableCellRenderer) {
                    this.orig = tableCellRenderer;
                }

                @Override
                public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                    Component component = this.orig.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                    if (TableViewETableColumn.this.tooltip == null) {
                        TableViewETableColumn.this.tooltip = TableViewETableColumn.this.getShortDescription(object.toString());
                    }
                    if (TableViewETableColumn.this.tooltip != null && component instanceof JComponent) {
                        JComponent jComponent = (JComponent)component;
                        jComponent.setToolTipText(TableViewETableColumn.this.tooltip);
                    }
                    return component;
                }
            }
        }
    }

    private class TableSelectionListener
    implements VetoableChangeListener,
    ListSelectionListener,
    PropertyChangeListener {
        private TableSelectionListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (TableView.this.manager == null) {
                return;
            }
            if (propertyChangeEvent.getPropertyName().equals("rootContext")) {
                TableView.this.synchronizeRootContext();
            }
            if (propertyChangeEvent.getPropertyName().equals("selectedNodes")) {
                TableView.this.synchronizeSelectedNodes();
            }
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            int[] nArray = TableView.this.table.getSelectedRows();
            Node[] nodeArray = new Node[nArray.length];
            for (int i = 0; i < nodeArray.length; ++i) {
                nodeArray[i] = TableView.this.getNodeFromRow(nArray[i]);
            }
            TableView.this.callSelectionChanged(nodeArray);
        }

        @Override
        public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
            Node[] nodeArray;
            if (propertyChangeEvent.getPropertyName().equals("selectedNodes") && TableView.this.isSelectionModeBroken(nodeArray = (Node[])propertyChangeEvent.getNewValue())) {
                throw new PropertyVetoException("selection mode  broken by " + Arrays.asList(nodeArray), propertyChangeEvent);
            }
        }
    }

    private class PopupAdapter
    extends MouseUtils.PopupMouseAdapter {
        PopupAdapter() {
        }

        protected void showPopup(MouseEvent mouseEvent) {
            int n = TableView.this.table.rowAtPoint(mouseEvent.getPoint());
            if (n != -1) {
                if (!TableView.this.table.getSelectionModel().isSelectedIndex(n)) {
                    TableView.this.table.getSelectionModel().clearSelection();
                    TableView.this.table.getSelectionModel().setSelectionInterval(n, n);
                }
            } else {
                TableView.this.table.getSelectionModel().clearSelection();
            }
            Point point = SwingUtilities.convertPoint(mouseEvent.getComponent(), mouseEvent.getPoint(), TableView.this);
            if (TableView.this.isPopupAllowed()) {
                JPopupMenu jPopupMenu = TableView.this.createPopup(point);
                TableView.this.showPopup(point.x, point.y, jPopupMenu);
                mouseEvent.consume();
            }
        }
    }

    private class PopupAction
    extends AbstractAction
    implements Runnable {
        private PopupAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SwingUtilities.invokeLater(this);
        }

        @Override
        public void run() {
            Point point = TableView.this.getPositionForPopup();
            if (point == null) {
                return;
            }
            if (TableView.this.isPopupAllowed()) {
                JPopupMenu jPopupMenu = TableView.this.createPopup(point);
                TableView.this.showPopup(point.x, point.y, jPopupMenu);
            }
        }
    }
}

