/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.model.deprecation;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.stream.Collectors;
import org.protege.editor.owl.model.deprecation.DeprecationProfile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeprecationProfileLoader {
    private static final Logger logger = LoggerFactory.getLogger(DeprecationProfileLoader.class);

    public List<DeprecationProfile> loadProfiles() throws IOException {
        Path deprecationConfDirectory = Paths.get("conf", "deprecation");
        logger.info("Loading deprecation profiles from {}", (Object)deprecationConfDirectory.toAbsolutePath());
        return Files.list(deprecationConfDirectory).filter(file -> Files.isRegularFile(file, new LinkOption[0])).map(Path::toFile).filter(file -> file.getName().endsWith(".yaml")).map(file -> {
            try {
                ObjectMapper objectMapper = new ObjectMapper(new YAMLFactory());
                return objectMapper.readValue((File)file, DeprecationProfile.class);
            }
            catch (IOException e) {
                logger.warn("Could not load deprecation profile at " + String.valueOf(file) + ".  Cause: {}", (Object)e.getMessage(), (Object)e);
                return null;
            }
        }).filter(profile -> profile != null).sorted((o1, o2) -> o1.getName().compareToIgnoreCase(o2.getName())).collect(Collectors.toList());
    }
}

